# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetEmailCustomizationsResult',
    'AwaitableGetEmailCustomizationsResult',
    'get_email_customizations',
    'get_email_customizations_output',
]

@pulumi.output_type
class GetEmailCustomizationsResult:
    """
    A collection of values returned by getEmailCustomizations.
    """
    def __init__(__self__, brand_id=None, email_customizations=None, id=None, template_name=None):
        if brand_id and not isinstance(brand_id, str):
            raise TypeError("Expected argument 'brand_id' to be a str")
        pulumi.set(__self__, "brand_id", brand_id)
        if email_customizations and not isinstance(email_customizations, list):
            raise TypeError("Expected argument 'email_customizations' to be a list")
        pulumi.set(__self__, "email_customizations", email_customizations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if template_name and not isinstance(template_name, str):
            raise TypeError("Expected argument 'template_name' to be a str")
        pulumi.set(__self__, "template_name", template_name)

    @property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> str:
        return pulumi.get(self, "brand_id")

    @property
    @pulumi.getter(name="emailCustomizations")
    def email_customizations(self) -> Sequence['outputs.GetEmailCustomizationsEmailCustomizationResult']:
        """
        List of `EmailCustomization` belonging to the named email template of the brand
        """
        return pulumi.get(self, "email_customizations")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> str:
        return pulumi.get(self, "template_name")


class AwaitableGetEmailCustomizationsResult(GetEmailCustomizationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEmailCustomizationsResult(
            brand_id=self.brand_id,
            email_customizations=self.email_customizations,
            id=self.id,
            template_name=self.template_name)


def get_email_customizations(brand_id: Optional[str] = None,
                             template_name: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEmailCustomizationsResult:
    """
    Use this data source to retrieve the [email
    customizations](https://developer.okta.com/docs/reference/api/brands/#list-email-customizations)
    of an email template belonging to a brand in an Okta organization.


    :param str brand_id: Brand ID
    :param str template_name: Name of an Email Template
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    __args__['templateName'] = template_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getEmailCustomizations:getEmailCustomizations', __args__, opts=opts, typ=GetEmailCustomizationsResult).value

    return AwaitableGetEmailCustomizationsResult(
        brand_id=__ret__.brand_id,
        email_customizations=__ret__.email_customizations,
        id=__ret__.id,
        template_name=__ret__.template_name)


@_utilities.lift_output_func(get_email_customizations)
def get_email_customizations_output(brand_id: Optional[pulumi.Input[str]] = None,
                                    template_name: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEmailCustomizationsResult]:
    """
    Use this data source to retrieve the [email
    customizations](https://developer.okta.com/docs/reference/api/brands/#list-email-customizations)
    of an email template belonging to a brand in an Okta organization.


    :param str brand_id: Brand ID
    :param str template_name: Name of an Email Template
    """
    ...
