# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MappingArgs', 'Mapping']

@pulumi.input_type
class MappingArgs:
    def __init__(__self__, *,
                 source_id: pulumi.Input[str],
                 target_id: pulumi.Input[str],
                 always_apply: Optional[pulumi.Input[bool]] = None,
                 delete_when_absent: Optional[pulumi.Input[bool]] = None,
                 mappings: Optional[pulumi.Input[Sequence[pulumi.Input['MappingMappingArgs']]]] = None):
        """
        The set of arguments for constructing a Mapping resource.
        :param pulumi.Input[str] source_id: Source id of the profile mapping.
        :param pulumi.Input[str] target_id: ID of the mapping target.
        :param pulumi.Input[bool] always_apply: Whether apply the changes to all users with this profile after updating or creating the these mappings.
        :param pulumi.Input[bool] delete_when_absent: Tells the provider whether to attempt to delete missing mappings under profile mapping.
        :param pulumi.Input[Sequence[pulumi.Input['MappingMappingArgs']]] mappings: Priority of the policy.
        """
        pulumi.set(__self__, "source_id", source_id)
        pulumi.set(__self__, "target_id", target_id)
        if always_apply is not None:
            pulumi.set(__self__, "always_apply", always_apply)
        if delete_when_absent is not None:
            pulumi.set(__self__, "delete_when_absent", delete_when_absent)
        if mappings is not None:
            pulumi.set(__self__, "mappings", mappings)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Input[str]:
        """
        Source id of the profile mapping.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[str]:
        """
        ID of the mapping target.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="alwaysApply")
    def always_apply(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether apply the changes to all users with this profile after updating or creating the these mappings.
        """
        return pulumi.get(self, "always_apply")

    @always_apply.setter
    def always_apply(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "always_apply", value)

    @property
    @pulumi.getter(name="deleteWhenAbsent")
    def delete_when_absent(self) -> Optional[pulumi.Input[bool]]:
        """
        Tells the provider whether to attempt to delete missing mappings under profile mapping.
        """
        return pulumi.get(self, "delete_when_absent")

    @delete_when_absent.setter
    def delete_when_absent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_when_absent", value)

    @property
    @pulumi.getter
    def mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MappingMappingArgs']]]]:
        """
        Priority of the policy.
        """
        return pulumi.get(self, "mappings")

    @mappings.setter
    def mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MappingMappingArgs']]]]):
        pulumi.set(self, "mappings", value)


@pulumi.input_type
class _MappingState:
    def __init__(__self__, *,
                 always_apply: Optional[pulumi.Input[bool]] = None,
                 delete_when_absent: Optional[pulumi.Input[bool]] = None,
                 mappings: Optional[pulumi.Input[Sequence[pulumi.Input['MappingMappingArgs']]]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 source_name: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 target_name: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Mapping resources.
        :param pulumi.Input[bool] always_apply: Whether apply the changes to all users with this profile after updating or creating the these mappings.
        :param pulumi.Input[bool] delete_when_absent: Tells the provider whether to attempt to delete missing mappings under profile mapping.
        :param pulumi.Input[Sequence[pulumi.Input['MappingMappingArgs']]] mappings: Priority of the policy.
        :param pulumi.Input[str] source_id: Source id of the profile mapping.
        :param pulumi.Input[str] source_name: Name of the mapping source.
        :param pulumi.Input[str] source_type: ID of the mapping source.
        :param pulumi.Input[str] target_id: ID of the mapping target.
        :param pulumi.Input[str] target_name: Name of the mapping target.
        :param pulumi.Input[str] target_type: ID of the mapping target.
        """
        if always_apply is not None:
            pulumi.set(__self__, "always_apply", always_apply)
        if delete_when_absent is not None:
            pulumi.set(__self__, "delete_when_absent", delete_when_absent)
        if mappings is not None:
            pulumi.set(__self__, "mappings", mappings)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="alwaysApply")
    def always_apply(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether apply the changes to all users with this profile after updating or creating the these mappings.
        """
        return pulumi.get(self, "always_apply")

    @always_apply.setter
    def always_apply(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "always_apply", value)

    @property
    @pulumi.getter(name="deleteWhenAbsent")
    def delete_when_absent(self) -> Optional[pulumi.Input[bool]]:
        """
        Tells the provider whether to attempt to delete missing mappings under profile mapping.
        """
        return pulumi.get(self, "delete_when_absent")

    @delete_when_absent.setter
    def delete_when_absent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_when_absent", value)

    @property
    @pulumi.getter
    def mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MappingMappingArgs']]]]:
        """
        Priority of the policy.
        """
        return pulumi.get(self, "mappings")

    @mappings.setter
    def mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MappingMappingArgs']]]]):
        pulumi.set(self, "mappings", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[str]]:
        """
        Source id of the profile mapping.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the mapping source.
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_name", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the mapping source.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the mapping target.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the mapping target.
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_name", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the mapping target.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_type", value)


class Mapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_apply: Optional[pulumi.Input[bool]] = None,
                 delete_when_absent: Optional[pulumi.Input[bool]] = None,
                 mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MappingMappingArgs']]]]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource allows you to manage a profile mapping by source and target IDs.

        > **NOTE:** If using this resource with OAuth2 scopes, this resource requires `okta.profileMappings.manage` scope.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        user = okta.user.get_user_profile_mapping_source()
        example = okta.profile.Mapping("example",
            delete_when_absent=True,
            mappings=[
                okta.profile.MappingMappingArgs(
                    expression="appuser.firstName",
                    id="firstName",
                ),
                okta.profile.MappingMappingArgs(
                    expression="appuser.lastName",
                    id="lastName",
                ),
                okta.profile.MappingMappingArgs(
                    expression="appuser.email",
                    id="email",
                ),
                okta.profile.MappingMappingArgs(
                    expression="appuser.email",
                    id="login",
                ),
            ],
            source_id="<source id>",
            target_id=user.id)
        ```

        ## Import

        There is no reason to import this resource. You can simply create the resource config and point it to a source ID. Mind here, once the source is deleted this resources will no longer exist.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] always_apply: Whether apply the changes to all users with this profile after updating or creating the these mappings.
        :param pulumi.Input[bool] delete_when_absent: Tells the provider whether to attempt to delete missing mappings under profile mapping.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MappingMappingArgs']]]] mappings: Priority of the policy.
        :param pulumi.Input[str] source_id: Source id of the profile mapping.
        :param pulumi.Input[str] target_id: ID of the mapping target.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to manage a profile mapping by source and target IDs.

        > **NOTE:** If using this resource with OAuth2 scopes, this resource requires `okta.profileMappings.manage` scope.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        user = okta.user.get_user_profile_mapping_source()
        example = okta.profile.Mapping("example",
            delete_when_absent=True,
            mappings=[
                okta.profile.MappingMappingArgs(
                    expression="appuser.firstName",
                    id="firstName",
                ),
                okta.profile.MappingMappingArgs(
                    expression="appuser.lastName",
                    id="lastName",
                ),
                okta.profile.MappingMappingArgs(
                    expression="appuser.email",
                    id="email",
                ),
                okta.profile.MappingMappingArgs(
                    expression="appuser.email",
                    id="login",
                ),
            ],
            source_id="<source id>",
            target_id=user.id)
        ```

        ## Import

        There is no reason to import this resource. You can simply create the resource config and point it to a source ID. Mind here, once the source is deleted this resources will no longer exist.

        :param str resource_name: The name of the resource.
        :param MappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_apply: Optional[pulumi.Input[bool]] = None,
                 delete_when_absent: Optional[pulumi.Input[bool]] = None,
                 mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MappingMappingArgs']]]]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MappingArgs.__new__(MappingArgs)

            __props__.__dict__["always_apply"] = always_apply
            __props__.__dict__["delete_when_absent"] = delete_when_absent
            __props__.__dict__["mappings"] = mappings
            if source_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_id'")
            __props__.__dict__["source_id"] = source_id
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["source_name"] = None
            __props__.__dict__["source_type"] = None
            __props__.__dict__["target_name"] = None
            __props__.__dict__["target_type"] = None
        super(Mapping, __self__).__init__(
            'okta:profile/mapping:Mapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            always_apply: Optional[pulumi.Input[bool]] = None,
            delete_when_absent: Optional[pulumi.Input[bool]] = None,
            mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MappingMappingArgs']]]]] = None,
            source_id: Optional[pulumi.Input[str]] = None,
            source_name: Optional[pulumi.Input[str]] = None,
            source_type: Optional[pulumi.Input[str]] = None,
            target_id: Optional[pulumi.Input[str]] = None,
            target_name: Optional[pulumi.Input[str]] = None,
            target_type: Optional[pulumi.Input[str]] = None) -> 'Mapping':
        """
        Get an existing Mapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] always_apply: Whether apply the changes to all users with this profile after updating or creating the these mappings.
        :param pulumi.Input[bool] delete_when_absent: Tells the provider whether to attempt to delete missing mappings under profile mapping.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MappingMappingArgs']]]] mappings: Priority of the policy.
        :param pulumi.Input[str] source_id: Source id of the profile mapping.
        :param pulumi.Input[str] source_name: Name of the mapping source.
        :param pulumi.Input[str] source_type: ID of the mapping source.
        :param pulumi.Input[str] target_id: ID of the mapping target.
        :param pulumi.Input[str] target_name: Name of the mapping target.
        :param pulumi.Input[str] target_type: ID of the mapping target.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MappingState.__new__(_MappingState)

        __props__.__dict__["always_apply"] = always_apply
        __props__.__dict__["delete_when_absent"] = delete_when_absent
        __props__.__dict__["mappings"] = mappings
        __props__.__dict__["source_id"] = source_id
        __props__.__dict__["source_name"] = source_name
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["target_name"] = target_name
        __props__.__dict__["target_type"] = target_type
        return Mapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alwaysApply")
    def always_apply(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether apply the changes to all users with this profile after updating or creating the these mappings.
        """
        return pulumi.get(self, "always_apply")

    @property
    @pulumi.getter(name="deleteWhenAbsent")
    def delete_when_absent(self) -> pulumi.Output[Optional[bool]]:
        """
        Tells the provider whether to attempt to delete missing mappings under profile mapping.
        """
        return pulumi.get(self, "delete_when_absent")

    @property
    @pulumi.getter
    def mappings(self) -> pulumi.Output[Optional[Sequence['outputs.MappingMapping']]]:
        """
        Priority of the policy.
        """
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Output[str]:
        """
        Source id of the profile mapping.
        """
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> pulumi.Output[str]:
        """
        Name of the mapping source.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[str]:
        """
        ID of the mapping source.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        ID of the mapping target.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> pulumi.Output[str]:
        """
        Name of the mapping target.
        """
        return pulumi.get(self, "target_name")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output[str]:
        """
        ID of the mapping target.
        """
        return pulumi.get(self, "target_type")

