from ama_xiv_combat_sim.example_rotations.specific_rotations import SpecificRotations


all_drk_rotations = SpecificRotations()

ALL_DRK_ROTATIONS = {
    "DRK": {
        90: {
            "stats": {
                "wd": 132,
                "main_stat": 3311,
                "det_stat": 2182,
                "crit_stat": 2596,
                "dh_stat": 940,
                "speed_stat": 400,
                "tenacity": 601,
                "job_class": "DRK",
            },
            "skills": (
                "Grade 8 Tincture",
                "Hard Slash",
                "Edge of Shadow",
                "Syphon Strike",
                "Delirium",
                "Souleater",
                "Living Shadow",
                "Hard Slash",
                "Salted Earth",
                "Edge of Shadow",
                "Bloodspiller",
                "Shadowbringer",
                "Edge of Shadow",
                "Bloodspiller",
                "Carve and Spit",
                "Plunge",
                "Bloodspiller",
                "Shadowbringer",
                "Edge of Shadow",
                "Syphon Strike",
                "Salt and Darkness",
                "Edge of Shadow",
                "Souleater",
                "Plunge",
                "Hard Slash",
                "Syphon Strike",
                "Edge of Shadow",
                "Souleater",
                "Bloodspiller",
            ),
            "start_version": "6.55",
            "end_version": "6.55",
        },
        100: {
            "stats": {
                "wd": 146,
                "main_stat": 4839,
                "det_stat": 2310,
                "crit_stat": 3174,
                "dh_stat": 1470,
                "speed_stat": 420,
                "tenacity": 868,
                "job_class": "DRK",
            },
            "skills": (
                "Unmend",
                "Grade 2 Gemdraught",
                "Hard Slash",
                "Edge of Shadow",
                "Living Shadow",
                "Syphon Strike",
                "Souleater",
                "Delirium",
                "Disesteem",
                "Salted Earth",
                "Edge of Shadow",
                "Scarlet Delirium",
                "Shadowbringer",
                "Edge of Shadow",
                "Comeuppance",
                "Carve and Spit",
                "Edge of Shadow",
                "Torcleaver",
                "Shadowbringer",
                "Edge of Shadow",
                "Bloodspiller",
                "Salt and Darkness",                
            ),
            "start_version": "7.05",            
        },
    },
}

for k, v in ALL_DRK_ROTATIONS.items():
    all_drk_rotations.add_rotation_data(k, v)
