import math

from ama_xiv_combat_sim.simulator.calcs.stat_fns import StatFns
from ama_xiv_combat_sim.simulator.testing.test_class import TestClass


# TODO: fdetdh test
class TestStatFns(TestClass):
    VERSION = "6.55"
    LEVEL = 90

    @TestClass.is_a_test
    def get_time_using_speed_stat_test(self):
        test_passed = True
        err_msg = ""

        gcd_inputs_and_expcted = {
            2500: ((1408, 1409, 1410), (2330, 2320, 2320)),
            3500: ((999, 1000, 1001), (3360, 3350, 3350)),
        }

        for gcd_time, inputs_and_outputs in gcd_inputs_and_expcted.items():
            speed_stat = inputs_and_outputs[0]
            expected = inputs_and_outputs[1]
            for i in range(0, len(speed_stat)):
                gcd_actual = StatFns.get_time_using_speed_stat(
                    gcd_time, speed_stat[i], version=self.VERSION, level=self.LEVEL
                )
                gcd_expected = expected[i]
                if gcd_actual != gcd_expected:
                    err_msg += (
                        "gcd_time expected: {}. Actual: {}. For {} gcd.\n".format(
                            gcd_expected, gcd_actual, gcd_time
                        )
                    )
                    test_passed = False

        return test_passed, err_msg

    @TestClass.is_a_test
    def get_crit_stats_test(self):
        test_passed = True
        err_msg = ""

        crit_stat_inputs_and_expected = {
            400: (0.05, 0.40),
            475: (0.057, 0.407),
            476: (0.058, 0.408),
            1150: (0.128, 0.478),
            1151: (0.129, 0.479),
            1152: (0.129, 0.479),
        }

        for crit_stat, expected in crit_stat_inputs_and_expected.items():
            # TODO: consider using math.isclose isntead for float comparison fiddliness.
            crit_rate_actual, crit_bonus_actual = StatFns.get_crit_stats(
                crit_stat, version=self.VERSION, level=self.LEVEL
            )
            if (crit_rate_actual, crit_bonus_actual) != expected:
                err_msg += "crit stat: {}. crit rate/bonus expected: {}/{}. Actual: {}/{}.\n".format(
                    crit_stat,
                    expected[0],
                    expected[1],
                    crit_rate_actual,
                    crit_bonus_actual,
                )
                test_passed = False

        return test_passed, err_msg

    @TestClass.is_a_test
    def fDetDH_test(self):
        test_passed = True
        err_msg = ""

        # (det_stat, dh_stat, fDetDh_expected)
        stat_inputs_and_expected = (
            (390, 400, 1000 + 0),
            (1706, 1360, 1096 + 70),
            (1707, 1369, 1097 + 71),
        )

        for det_stat, dh_stat, expected in stat_inputs_and_expected:
            fDetDH_actual = StatFns.fDetDH(
                det_stat, dh_stat, version=self.VERSION, level=self.LEVEL
            )
            if fDetDH_actual != expected:
                err_msg += "fDetDh expected: {}. Actual: {}.\n".format(
                    expected, fDetDH_actual
                )
                test_passed = False

        return test_passed, err_msg

    @TestClass.is_a_test
    def fDet_test(self):
        test_passed = True
        err_msg = ""

        det_stat_inputs_and_expected = {
            390: 1000,
            566: 1012,
            567: 1013,
            1706: 1096,
            1707: 1097,
            1708: 1097,
        }

        for det_stat, expected in det_stat_inputs_and_expected.items():
            fDet_actual = StatFns.fDet(det_stat, version=self.VERSION, level=self.LEVEL)
            if fDet_actual != expected:
                err_msg += "fDet expected: {}. Actual: {}.\n".format(
                    expected, fDet_actual
                )
                test_passed = False

        return test_passed, err_msg

    @TestClass.is_a_test
    def dh_rate_test(self):
        test_passed = True
        err_msg = ""

        dh_stat_inputs_and_expected = {
            400: 0,
            472: 0.020,
            473: 0.021,
            1360: 0.277,
            1361: 0.278,
            1362: 0.278,
        }

        for dh_stat, expected in dh_stat_inputs_and_expected.items():
            dh_rate_actual = StatFns.get_dh_rate(
                dh_stat, version=self.VERSION, level=self.LEVEL
            )
            if not math.isclose(dh_rate_actual, expected, abs_tol=1e-4):
                err_msg += "dh_rate expected: {}. Actual: {}.\n".format(
                    expected, dh_rate_actual
                )
                test_passed = False

        return test_passed, err_msg

    @TestClass.is_a_test
    def wd_test(self):
        test_passed = True
        err_msg = ""

        # (wd, job_mod, fWd_expected)
        wd_stat_inputs_and_expected = ((120, 100, 159), (126, 115, 170))

        for wd, job_mod, expected in wd_stat_inputs_and_expected:
            fWD_actual = StatFns.fWD(
                wd, job_mod, version=self.VERSION, level=self.LEVEL
            )
            if fWD_actual != expected:
                err_msg += "fWd expected: {}. Actual: {}.\n".format(
                    expected, fWD_actual
                )
                test_passed = False

        return test_passed, err_msg

    @TestClass.is_a_test
    def fAuto_test(self):
        test_passed = True
        err_msg = ""

        stat_inputs_and_expected = ((120, 3.44, 105, 183), (126, 2.6, 115, 147))

        for wd, weapon_delay, job_mod, expected in stat_inputs_and_expected:
            fAuto_actual = StatFns.fAuto(
                wd, weapon_delay, job_mod, version=self.VERSION, level=self.LEVEL
            )
            if fAuto_actual != expected:
                err_msg += "fAuto expected: {}. Actual: {}.\n".format(
                    expected, fAuto_actual
                )
                test_passed = False

        return test_passed, err_msg

    @TestClass.is_a_test
    def spd_test(self):
        test_passed = True
        err_msg = ""

        # (spd, fSpd_expected)
        spd_stat_inputs_and_expected = ((859, 1031), (1700, 1088))

        for spd, expected in spd_stat_inputs_and_expected:
            fSpd_actual_actual = StatFns.fSpd(
                spd, version=self.VERSION, level=self.LEVEL
            )
            if fSpd_actual_actual != expected:
                err_msg += "fSpd expected: {}. Actual: {}.\n".format(
                    expected, fSpd_actual_actual
                )
                test_passed = False

        return test_passed, err_msg

    @TestClass.is_a_test
    def fTnc_test(self):
        test_passed = True
        err_msg = ""

        tnc_inputs_and_expected = {751: 1018, 1100: 1036, 500: 1005}

        for tnc, expected in tnc_inputs_and_expected.items():
            fTnc_actual = StatFns.fTnc(tnc, version=self.VERSION, level=self.LEVEL)
            if fTnc_actual != expected:
                err_msg += "fTnc expected: {}. Actual: {}.\n".format(
                    expected, fTnc_actual
                )
                test_passed = False

        return test_passed, err_msg

    @TestClass.is_a_test
    def fAP_tank_test(self):
        test_passed = True
        err_msg = ""

        ap_inputs_and_expected = {390: 100, 699: 223, 1219: 431}

        for ap, expected in ap_inputs_and_expected.items():
            fAP_actual = StatFns.fAP(
                ap, is_tank=True, version=self.VERSION, level=self.LEVEL
            )
            if fAP_actual != expected:
                err_msg += "fAP expected: {}. Actual: {}.\n".format(
                    expected, fAP_actual
                )
                test_passed = False

        return test_passed, err_msg

    @TestClass.is_a_test
    def fAP_non_tank_test(self):
        test_passed = True
        err_msg = ""

        ap_inputs_and_expected = {390: 100, 699: 254, 1219: 514}

        for ap, expected in ap_inputs_and_expected.items():
            fAP_actual = StatFns.fAP(
                ap, is_tank=False, version=self.VERSION, level=self.LEVEL
            )
            if fAP_actual != expected:
                err_msg += "fAP expected: {}. Actual: {}.\n".format(
                    expected, fAP_actual
                )
                test_passed = False

        return test_passed, err_msg
