"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBClusterEndpoint = exports.DBClusterEndpointProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBClusterEndpointProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBClusterEndpoint; } });
/**
 * A ROS resource type:  `ALIYUN::POLARDB::DBClusterEndpoint`
 */
class DBClusterEndpoint extends ros.Resource {
    /**
     * Create a new `ALIYUN::POLARDB::DBClusterEndpoint`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBClusterEndpoint = new polardb_generated_1.RosDBClusterEndpoint(this, id, {
            autoAddNewNodes: props.autoAddNewNodes === undefined || props.autoAddNewNodes === null ? 'Disable' : props.autoAddNewNodes,
            dbClusterId: props.dbClusterId,
            endpointType: props.endpointType === undefined || props.endpointType === null ? 'Custom' : props.endpointType,
            readWriteMode: props.readWriteMode === undefined || props.readWriteMode === null ? 'ReadOnly' : props.readWriteMode,
            nodes: props.nodes,
            endpointConfig: props.endpointConfig,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBClusterEndpoint;
        this.attrAddresses = rosDBClusterEndpoint.attrAddresses;
        this.attrConnectionString = rosDBClusterEndpoint.attrConnectionString;
        this.attrDbEndpointId = rosDBClusterEndpoint.attrDbEndpointId;
    }
}
exports.DBClusterEndpoint = DBClusterEndpoint;
//# sourceMappingURL=data:application/json;base64,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