"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SamlIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration snowflake_saml_integration}
*/
class SamlIntegration extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration snowflake_saml_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SamlIntegrationConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_saml_integration',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.33.1',
                providerVersionConstraint: ' ~> 0.25'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._enabled = config.enabled;
        this._name = config.name;
        this._saml2EnableSpInitiated = config.saml2EnableSpInitiated;
        this._saml2ForceAuthn = config.saml2ForceAuthn;
        this._saml2Issuer = config.saml2Issuer;
        this._saml2PostLogoutRedirectUrl = config.saml2PostLogoutRedirectUrl;
        this._saml2Provider = config.saml2Provider;
        this._saml2RequestedNameidFormat = config.saml2RequestedNameidFormat;
        this._saml2SignRequest = config.saml2SignRequest;
        this._saml2SnowflakeAcsUrl = config.saml2SnowflakeAcsUrl;
        this._saml2SnowflakeIssuerUrl = config.saml2SnowflakeIssuerUrl;
        this._saml2SnowflakeX509Cert = config.saml2SnowflakeX509Cert;
        this._saml2SpInitiatedLoginPageLabel = config.saml2SpInitiatedLoginPageLabel;
        this._saml2SsoUrl = config.saml2SsoUrl;
        this._saml2X509Cert = config.saml2X509Cert;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // created_on - computed: true, optional: false, required: false
    get createdOn() {
        return this.getStringAttribute('created_on');
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    // saml2_digest_methods_used - computed: true, optional: false, required: false
    get saml2DigestMethodsUsed() {
        return this.getStringAttribute('saml2_digest_methods_used');
    }
    get saml2EnableSpInitiated() {
        return this.getBooleanAttribute('saml2_enable_sp_initiated');
    }
    set saml2EnableSpInitiated(value) {
        this._saml2EnableSpInitiated = value;
    }
    resetSaml2EnableSpInitiated() {
        this._saml2EnableSpInitiated = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2EnableSpInitiatedInput() {
        return this._saml2EnableSpInitiated;
    }
    get saml2ForceAuthn() {
        return this.getBooleanAttribute('saml2_force_authn');
    }
    set saml2ForceAuthn(value) {
        this._saml2ForceAuthn = value;
    }
    resetSaml2ForceAuthn() {
        this._saml2ForceAuthn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2ForceAuthnInput() {
        return this._saml2ForceAuthn;
    }
    get saml2Issuer() {
        return this.getStringAttribute('saml2_issuer');
    }
    set saml2Issuer(value) {
        this._saml2Issuer = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2IssuerInput() {
        return this._saml2Issuer;
    }
    get saml2PostLogoutRedirectUrl() {
        return this.getStringAttribute('saml2_post_logout_redirect_url');
    }
    set saml2PostLogoutRedirectUrl(value) {
        this._saml2PostLogoutRedirectUrl = value;
    }
    resetSaml2PostLogoutRedirectUrl() {
        this._saml2PostLogoutRedirectUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2PostLogoutRedirectUrlInput() {
        return this._saml2PostLogoutRedirectUrl;
    }
    get saml2Provider() {
        return this.getStringAttribute('saml2_provider');
    }
    set saml2Provider(value) {
        this._saml2Provider = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2ProviderInput() {
        return this._saml2Provider;
    }
    get saml2RequestedNameidFormat() {
        return this.getStringAttribute('saml2_requested_nameid_format');
    }
    set saml2RequestedNameidFormat(value) {
        this._saml2RequestedNameidFormat = value;
    }
    resetSaml2RequestedNameidFormat() {
        this._saml2RequestedNameidFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2RequestedNameidFormatInput() {
        return this._saml2RequestedNameidFormat;
    }
    get saml2SignRequest() {
        return this.getBooleanAttribute('saml2_sign_request');
    }
    set saml2SignRequest(value) {
        this._saml2SignRequest = value;
    }
    resetSaml2SignRequest() {
        this._saml2SignRequest = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SignRequestInput() {
        return this._saml2SignRequest;
    }
    // saml2_signature_methods_used - computed: true, optional: false, required: false
    get saml2SignatureMethodsUsed() {
        return this.getStringAttribute('saml2_signature_methods_used');
    }
    get saml2SnowflakeAcsUrl() {
        return this.getStringAttribute('saml2_snowflake_acs_url');
    }
    set saml2SnowflakeAcsUrl(value) {
        this._saml2SnowflakeAcsUrl = value;
    }
    resetSaml2SnowflakeAcsUrl() {
        this._saml2SnowflakeAcsUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeAcsUrlInput() {
        return this._saml2SnowflakeAcsUrl;
    }
    get saml2SnowflakeIssuerUrl() {
        return this.getStringAttribute('saml2_snowflake_issuer_url');
    }
    set saml2SnowflakeIssuerUrl(value) {
        this._saml2SnowflakeIssuerUrl = value;
    }
    resetSaml2SnowflakeIssuerUrl() {
        this._saml2SnowflakeIssuerUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeIssuerUrlInput() {
        return this._saml2SnowflakeIssuerUrl;
    }
    // saml2_snowflake_metadata - computed: true, optional: false, required: false
    get saml2SnowflakeMetadata() {
        return this.getStringAttribute('saml2_snowflake_metadata');
    }
    get saml2SnowflakeX509Cert() {
        return this.getStringAttribute('saml2_snowflake_x509_cert');
    }
    set saml2SnowflakeX509Cert(value) {
        this._saml2SnowflakeX509Cert = value;
    }
    resetSaml2SnowflakeX509Cert() {
        this._saml2SnowflakeX509Cert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeX509CertInput() {
        return this._saml2SnowflakeX509Cert;
    }
    get saml2SpInitiatedLoginPageLabel() {
        return this.getStringAttribute('saml2_sp_initiated_login_page_label');
    }
    set saml2SpInitiatedLoginPageLabel(value) {
        this._saml2SpInitiatedLoginPageLabel = value;
    }
    resetSaml2SpInitiatedLoginPageLabel() {
        this._saml2SpInitiatedLoginPageLabel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SpInitiatedLoginPageLabelInput() {
        return this._saml2SpInitiatedLoginPageLabel;
    }
    get saml2SsoUrl() {
        return this.getStringAttribute('saml2_sso_url');
    }
    set saml2SsoUrl(value) {
        this._saml2SsoUrl = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SsoUrlInput() {
        return this._saml2SsoUrl;
    }
    get saml2X509Cert() {
        return this.getStringAttribute('saml2_x509_cert');
    }
    set saml2X509Cert(value) {
        this._saml2X509Cert = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2X509CertInput() {
        return this._saml2X509Cert;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            enabled: cdktf.booleanToTerraform(this._enabled),
            name: cdktf.stringToTerraform(this._name),
            saml2_enable_sp_initiated: cdktf.booleanToTerraform(this._saml2EnableSpInitiated),
            saml2_force_authn: cdktf.booleanToTerraform(this._saml2ForceAuthn),
            saml2_issuer: cdktf.stringToTerraform(this._saml2Issuer),
            saml2_post_logout_redirect_url: cdktf.stringToTerraform(this._saml2PostLogoutRedirectUrl),
            saml2_provider: cdktf.stringToTerraform(this._saml2Provider),
            saml2_requested_nameid_format: cdktf.stringToTerraform(this._saml2RequestedNameidFormat),
            saml2_sign_request: cdktf.booleanToTerraform(this._saml2SignRequest),
            saml2_snowflake_acs_url: cdktf.stringToTerraform(this._saml2SnowflakeAcsUrl),
            saml2_snowflake_issuer_url: cdktf.stringToTerraform(this._saml2SnowflakeIssuerUrl),
            saml2_snowflake_x509_cert: cdktf.stringToTerraform(this._saml2SnowflakeX509Cert),
            saml2_sp_initiated_login_page_label: cdktf.stringToTerraform(this._saml2SpInitiatedLoginPageLabel),
            saml2_sso_url: cdktf.stringToTerraform(this._saml2SsoUrl),
            saml2_x509_cert: cdktf.stringToTerraform(this._saml2X509Cert),
        };
    }
}
exports.SamlIntegration = SamlIntegration;
_a = JSII_RTTI_SYMBOL_1;
SamlIntegration[_a] = { fqn: "@cdktf/provider-snowflake.SamlIntegration", version: "0.1.59" };
// =================
// STATIC PROPERTIES
// =================
SamlIntegration.tfResourceType = "snowflake_saml_integration";
//# sourceMappingURL=data:application/json;base64,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