import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ScimIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the name of the SCIM integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/scim_integration#name ScimIntegration#name}
    */
    readonly name: string;
    /**
    * Specifies an existing network policy active for your account. The network policy restricts the list of user IP addresses when exchanging an authorization code for an access or refresh token and when using a refresh token to obtain a new access token. If this parameter is not set, the network policy for the account (if any) is used instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/scim_integration#network_policy ScimIntegration#network_policy}
    */
    readonly networkPolicy?: string;
    /**
    * Specify the SCIM role in Snowflake that owns any users and roles that are imported from the identity provider into Snowflake using SCIM.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/scim_integration#provisioner_role ScimIntegration#provisioner_role}
    */
    readonly provisionerRole: string;
    /**
    * Specifies the client type for the scim integration
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/scim_integration#scim_client ScimIntegration#scim_client}
    */
    readonly scimClient: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/scim_integration snowflake_scim_integration}
*/
export declare class ScimIntegration extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_scim_integration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/scim_integration snowflake_scim_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ScimIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: ScimIntegrationConfig);
    get createdOn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkPolicy?;
    get networkPolicy(): string;
    set networkPolicy(value: string);
    resetNetworkPolicy(): void;
    get networkPolicyInput(): string | undefined;
    private _provisionerRole?;
    get provisionerRole(): string;
    set provisionerRole(value: string);
    get provisionerRoleInput(): string | undefined;
    private _scimClient?;
    get scimClient(): string;
    set scimClient(value: string);
    get scimClientInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=scim-integration.d.ts.map