# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetInstanceDeployKeysResult',
    'AwaitableGetInstanceDeployKeysResult',
    'get_instance_deploy_keys',
    'get_instance_deploy_keys_output',
]

@pulumi.output_type
class GetInstanceDeployKeysResult:
    """
    A collection of values returned by getInstanceDeployKeys.
    """
    def __init__(__self__, deploy_keys=None, id=None, public=None):
        if deploy_keys and not isinstance(deploy_keys, list):
            raise TypeError("Expected argument 'deploy_keys' to be a list")
        pulumi.set(__self__, "deploy_keys", deploy_keys)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if public and not isinstance(public, bool):
            raise TypeError("Expected argument 'public' to be a bool")
        pulumi.set(__self__, "public", public)

    @property
    @pulumi.getter(name="deployKeys")
    def deploy_keys(self) -> Sequence['outputs.GetInstanceDeployKeysDeployKeyResult']:
        """
        The list of all deploy keys across all projects of the GitLab instance.
        """
        return pulumi.get(self, "deploy_keys")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def public(self) -> Optional[bool]:
        """
        Only return deploy keys that are public.
        """
        return pulumi.get(self, "public")


class AwaitableGetInstanceDeployKeysResult(GetInstanceDeployKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceDeployKeysResult(
            deploy_keys=self.deploy_keys,
            id=self.id,
            public=self.public)


def get_instance_deploy_keys(public: Optional[bool] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceDeployKeysResult:
    """
    The `get_instance_deploy_keys` data source allows to retrieve a list of deploy keys for a GitLab instance.

    > This data source requires administration privileges.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/deploy_keys.html#list-all-deploy-keys)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_instance_deploy_keys(public=True)
    ```


    :param bool public: Only return deploy keys that are public.
    """
    __args__ = dict()
    __args__['public'] = public
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getInstanceDeployKeys:getInstanceDeployKeys', __args__, opts=opts, typ=GetInstanceDeployKeysResult).value

    return AwaitableGetInstanceDeployKeysResult(
        deploy_keys=__ret__.deploy_keys,
        id=__ret__.id,
        public=__ret__.public)


@_utilities.lift_output_func(get_instance_deploy_keys)
def get_instance_deploy_keys_output(public: Optional[pulumi.Input[Optional[bool]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceDeployKeysResult]:
    """
    The `get_instance_deploy_keys` data source allows to retrieve a list of deploy keys for a GitLab instance.

    > This data source requires administration privileges.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/deploy_keys.html#list-all-deploy-keys)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_instance_deploy_keys(public=True)
    ```


    :param bool public: Only return deploy keys that are public.
    """
    ...
