from Math.DiscreteDistribution cimport DiscreteDistribution
from Math.Vector cimport Vector


cdef class LdaModel(GaussianModel):

    def __init__(self, priorDistribution: DiscreteDistribution, w: dict, w0: dict):
        """
        A constructor which sets the priorDistribution, w and w0 according to given inputs.

        PARAMETERS
        ----------
        priorDistribution : DiscreteDistribution
            DiscreteDistribution input.
        w : dict
            Dict of String and Vectors.
        w0 : dict
            Dict of String and float.
        """
        self.priorDistribution = priorDistribution
        self.w = w
        self.w0 = w0

    cpdef double calculateMetric(self, Instance instance, str Ci):
        """
        The calculateMetric method takes an Instance and a String as inputs. It returns the dot product of given
        Instance and wi plus w0i.

        PARAMETERS
        ----------
        instance : Instance
            Instance input.
        Ci : str
            String input.

        RETURNS
        -------
        float
            The dot product of given Instance and wi plus w0i.
        """
        cdef Vector xi, wi
        cdef double w0i
        xi = instance.toVector()
        wi = self.w[Ci]
        w0i = self.w0[Ci]
        return wi.dotProduct(xi) + w0i
