
MusicBox
========

MusicBox: A MUSICA model for boxes and columns.

[![License](https://img.shields.io/github/license/NCAR/music-box.svg)](https://github.com/NCAR/music-box/blob/main/LICENSE)
[![CI Status](https://github.com/NCAR/music-box/actions/workflows/CI_Tests.yml/badge.svg)](https://github.com/NCAR/music-box/actions/workflows/CI_Tests.yml)
[![PyPI version](https://badge.fury.io/py/acom_music_box.svg)](https://pypi.org/p/acom_music_box)

Copyright (C) 2020 National Center for Atmospheric Research

# Installation

The project is configured to be installed using `pip` by the `pyproject.toml` file. 

To install the `music-box` package into a Python environment, run the following command from the root directory:

```
pip install .
```

The package is also available on PyPi and can be installed in any Python environment through:

```
pip install acom_music_box
```

# Tests

The tests directory contains 4 different tests that can be ran with [PyTest](https://docs.pytest.org/en/8.2.x/). PyTest can be installed by running:

```
pip install pytest
```

After PyTest is intalled, the tests can be ran through the following commands from the root directory:

```
cd tests
pytest
```

# Documentation

MusicBox documentation can be built using [Sphinx](https://www.sphinx-doc.org/en/master/). Sphinx can be installed by running:

```
pip install sphinx
```

After installing Sphinx, the documentation can be generated by running the following commands in the root directory:

```
cd doc/sphinx_files
make html
```

Then, open `music-box/doc/sphinx_files/build/html/index.html` in a browser.

The documentation includes more detailed instructions for configuring the model, along with developer resources.
