# Developing on Windows

## Git

To download the latest version of Plaso you'll need to install the
[git tools](http://git-scm.com/downloads).

Checkout the Plaso source from the git repo:

```bash
git clone https://github.com/log2timeline/plaso.git
```

**If you intend to submit code make sure to configure git to use convert to the
Unix-style end-of-line characters (linefeed) on submission and not have the
Windows-style end-of-line characters (carriage return + linefeed).**

We recommend to configure your editor of choice to use linefeed only and turn
off git's autocrlf:

```bash
git config --global core.autocrlf false
```

## Dependencies

Install the dependencies, using the
[prepackaged dependencies](Development-Dependencies.html#Windows).

Check if you have all the dependencies installed and have the right minimum
version:

```bash
C:\Python38\python.exe utils\check_dependencies.py
```

**Note that some dependencies are actively under development and can be
frequently updated, therefore we recommend checking the status of the
dependencies regularly.**

## Running the development code

To run the development code directly from source make sure Python can find the
Plaso source files by setting PYTHONPATH correspondingly.

```bash
set PYTHONPATH=C:\plaso-build\plaso
```

To run a tool, for example `pinfo`:

```bash
C:\Python39\python.exe C:\plaso-build\plaso\plaso\frontend\pinfo.py timeline.plaso
```

## Development tools

If you intend to do development on Plaso you'll also need to install some
development tools:

* PyLint
* Python Mock

### PyLint

At the moment Plaso development requires PyLint 2.6.x.

### Python Mock

Download the latest source package from: https://pypi.org/project/mock

To build the MSI file run the following commands from the build root directory:

```bash
tar xvf mock-1.0.1.tar.gz
cd mock-1.0.1\
C:\Python39\python.exe setup.py bdist_msi
cd ..
```

This will create a MSI in the dist sub directory e.g.:

```bash
dist\mock-1.0.1.win32.msi
```

Install the MSI.
