"""
    Criteo API

    Criteo publicly exposed API  # noqa: E501

    The version of the OpenAPI document: Preview
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from criteo_api_retailmedia_preview.api_client import ApiClient, Endpoint as _Endpoint
from criteo_api_retailmedia_preview.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from criteo_api_retailmedia_preview.model.brand_preview_list_response import BrandPreviewListResponse
from criteo_api_retailmedia_preview.model.category_cpc_rate_card_preview_list_response import CategoryCpcRateCardPreviewListResponse
from criteo_api_retailmedia_preview.model.creative202210_list_response import Creative202210ListResponse
from criteo_api_retailmedia_preview.model.creative202210_response import Creative202210Response
from criteo_api_retailmedia_preview.model.creative_create_model202207 import CreativeCreateModel202207
from criteo_api_retailmedia_preview.model.creative_update_model202207 import CreativeUpdateModel202207
from criteo_api_retailmedia_preview.model.external_post_campaign import ExternalPostCampaign
from criteo_api_retailmedia_preview.model.external_post_line_item import ExternalPostLineItem
from criteo_api_retailmedia_preview.model.external_put_campaign import ExternalPutCampaign
from criteo_api_retailmedia_preview.model.external_put_line_item import ExternalPutLineItem
from criteo_api_retailmedia_preview.model.json_api_data_request_of_delete_balance_campaign import JsonApiDataRequestOfDeleteBalanceCampaign
from criteo_api_retailmedia_preview.model.json_api_data_request_of_put_balance_campaign import JsonApiDataRequestOfPutBalanceCampaign
from criteo_api_retailmedia_preview.model.json_api_data_request_with_id_of_string_and_promoted_product import JsonApiDataRequestWithIdOfStringAndPromotedProduct
from criteo_api_retailmedia_preview.model.json_api_page_response_of_account import JsonApiPageResponseOfAccount
from criteo_api_retailmedia_preview.model.json_api_page_response_of_balance import JsonApiPageResponseOfBalance
from criteo_api_retailmedia_preview.model.json_api_page_response_of_brand import JsonApiPageResponseOfBrand
from criteo_api_retailmedia_preview.model.json_api_page_response_of_campaign import JsonApiPageResponseOfCampaign
from criteo_api_retailmedia_preview.model.json_api_page_response_of_line_item import JsonApiPageResponseOfLineItem
from criteo_api_retailmedia_preview.model.json_api_page_response_of_retailer import JsonApiPageResponseOfRetailer
from criteo_api_retailmedia_preview.model.json_api_page_response_of_string_and_promoted_product import JsonApiPageResponseOfStringAndPromotedProduct
from criteo_api_retailmedia_preview.model.json_api_request_of_catalog_request_preview import JsonApiRequestOfCatalogRequestPreview
from criteo_api_retailmedia_preview.model.json_api_single_response_of_campaign import JsonApiSingleResponseOfCampaign
from criteo_api_retailmedia_preview.model.json_api_single_response_of_catalog_status import JsonApiSingleResponseOfCatalogStatus
from criteo_api_retailmedia_preview.model.json_api_single_response_of_line_item import JsonApiSingleResponseOfLineItem
from criteo_api_retailmedia_preview.model.json_api_single_response_of_line_item_bid_multipliers import JsonApiSingleResponseOfLineItemBidMultipliers
from criteo_api_retailmedia_preview.model.line_item_bid_multipliers_request import LineItemBidMultipliersRequest
from criteo_api_retailmedia_preview.model.line_item_bid_multipliers_response import LineItemBidMultipliersResponse
from criteo_api_retailmedia_preview.model.page_of_balance_campaign import PageOfBalanceCampaign
from criteo_api_retailmedia_preview.model.placement_preview_list_response import PlacementPreviewListResponse
from criteo_api_retailmedia_preview.model.product_button_list_request import ProductButtonListRequest
from criteo_api_retailmedia_preview.model.product_button_list_response import ProductButtonListResponse
from criteo_api_retailmedia_preview.model.product_button_request import ProductButtonRequest
from criteo_api_retailmedia_preview.model.product_button_response import ProductButtonResponse
from criteo_api_retailmedia_preview.model.retail_media_externalv1_add_remove_keywords_model_request import RetailMediaExternalv1AddRemoveKeywordsModelRequest
from criteo_api_retailmedia_preview.model.retail_media_externalv1_keywords_model_response import RetailMediaExternalv1KeywordsModelResponse
from criteo_api_retailmedia_preview.model.retail_media_externalv1_proposal_status_model_response import RetailMediaExternalv1ProposalStatusModelResponse
from criteo_api_retailmedia_preview.model.retail_media_externalv1_resource_outcome import RetailMediaExternalv1ResourceOutcome
from criteo_api_retailmedia_preview.model.retail_media_externalv1_set_bids_model_request import RetailMediaExternalv1SetBidsModelRequest
from criteo_api_retailmedia_preview.model.retailer_cpc_rate_card_preview_response import RetailerCpcRateCardPreviewResponse
from criteo_api_retailmedia_preview.model.seller_preview_response import SellerPreviewResponse
from criteo_api_retailmedia_preview.model.sku_data_preview_list_response import SkuDataPreviewListResponse
from criteo_api_retailmedia_preview.model.sku_search_request_preview_request import SkuSearchRequestPreviewRequest


class CampaignApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.add_remove_keywords_endpoint = _Endpoint(
            settings={
                'response_type': (RetailMediaExternalv1ResourceOutcome,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{id}/keywords/add-remove',
                'operation_id': 'add_remove_keywords',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'retail_media_externalv1_add_remove_keywords_model_request',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'retail_media_externalv1_add_remove_keywords_model_request':
                        (RetailMediaExternalv1AddRemoveKeywordsModelRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'retail_media_externalv1_add_remove_keywords_model_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{line-item-id}/product-buttons/{product-button-id}',
                'operation_id': 'delete_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'product_button_id',
                ],
                'required': [
                    'line_item_id',
                    'product_button_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'product_button_id':
                        (str,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                    'product_button_id': 'product-button-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'product_button_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_api_v1_external_balance_campaigns_by_balance_id_endpoint = _Endpoint(
            settings={
                'response_type': (PageOfBalanceCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/balances/{balanceId}/campaigns',
                'operation_id': 'delete_api_v1_external_balance_campaigns_by_balance_id',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'balance_id',
                    'json_api_data_request_of_delete_balance_campaign',
                ],
                'required': [
                    'balance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'balance_id':
                        (str,),
                    'json_api_data_request_of_delete_balance_campaign':
                        (JsonApiDataRequestOfDeleteBalanceCampaign,),
                },
                'attribute_map': {
                    'balance_id': 'balanceId',
                },
                'location_map': {
                    'balance_id': 'path',
                    'json_api_data_request_of_delete_balance_campaign': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_api_v1_external_line_item_products_by_line_item_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfStringAndPromotedProduct,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{lineItemId}/products',
                'operation_id': 'delete_api_v1_external_line_item_products_by_line_item_id',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'json_api_data_request_with_id_of_string_and_promoted_product',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'json_api_data_request_with_id_of_string_and_promoted_product':
                        (JsonApiDataRequestWithIdOfStringAndPromotedProduct,),
                },
                'attribute_map': {
                    'line_item_id': 'lineItemId',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'json_api_data_request_with_id_of_string_and_promoted_product': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.fetch_keywords_endpoint = _Endpoint(
            settings={
                'response_type': (RetailMediaExternalv1KeywordsModelResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{id}/keywords',
                'operation_id': 'fetch_keywords',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_proposal_endpoint = _Endpoint(
            settings={
                'response_type': (RetailMediaExternalv1ProposalStatusModelResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/preferred-deal-line-items/{id}/proposal',
                'operation_id': 'fetch_proposal',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_aip_v1_external_retailer_retailer_cpc_rates_by_retailer_id_endpoint = _Endpoint(
            settings={
                'response_type': (RetailerCpcRateCardPreviewResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/retailers/{retailer-id}/retailer-cpc-rates',
                'operation_id': 'get_aip_v1_external_retailer_retailer_cpc_rates_by_retailer_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'retailer_id',
                ],
                'required': [
                    'retailer_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'retailer_id':
                        (str,),
                },
                'attribute_map': {
                    'retailer_id': 'retailer-id',
                },
                'location_map': {
                    'retailer_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api202210_external_account_by_account_id_creativescreative_id_endpoint = _Endpoint(
            settings={
                'response_type': (Creative202210Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{account-id}/creatives/{creative-id}',
                'operation_id': 'get_api202210_external_account_by_account_id_creativescreative_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'creative_id',
                ],
                'required': [
                    'account_id',
                    'creative_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'creative_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'creative_id': 'creative-id',
                },
                'location_map': {
                    'account_id': 'path',
                    'creative_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api202210_external_line_item_product_buttons_by_line_item_id_endpoint = _Endpoint(
            settings={
                'response_type': (ProductButtonListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{line-item-id}/product-buttons',
                'operation_id': 'get_api202210_external_line_item_product_buttons_by_line_item_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id_endpoint = _Endpoint(
            settings={
                'response_type': (ProductButtonResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{line-item-id}/product-buttons/{product-button-id}',
                'operation_id': 'get_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'product_button_id',
                ],
                'required': [
                    'line_item_id',
                    'product_button_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'product_button_id':
                        (str,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                    'product_button_id': 'product-button-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'product_button_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api202301_external_line_item_bid_multipliers_by_line_item_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfLineItemBidMultipliers,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{line-item-id}/bid-multipliers',
                'operation_id': 'get_api202301_external_line_item_bid_multipliers_by_line_item_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v0_external_catalog_output_by_catalog_id_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/catalogs/{catalogId}/output',
                'operation_id': 'get_api_v0_external_catalog_output_by_catalog_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'catalog_id',
                ],
                'required': [
                    'catalog_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'catalog_id':
                        (str,),
                },
                'attribute_map': {
                    'catalog_id': 'catalogId',
                },
                'location_map': {
                    'catalog_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/x-json-stream',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v0_external_catalog_status_by_catalog_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCatalogStatus,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/catalogs/{catalogId}/status',
                'operation_id': 'get_api_v0_external_catalog_status_by_catalog_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'catalog_id',
                ],
                'required': [
                    'catalog_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'catalog_id':
                        (str,),
                },
                'attribute_map': {
                    'catalog_id': 'catalogId',
                },
                'location_map': {
                    'catalog_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v1_external_account_balances_by_account_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfBalance,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{accountId}/balances',
                'operation_id': 'get_api_v1_external_account_balances_by_account_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'account_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v1_external_account_brands_by_account_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfBrand,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{accountId}/brands',
                'operation_id': 'get_api_v1_external_account_brands_by_account_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'account_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v1_external_account_campaigns_by_account_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{accountId}/campaigns',
                'operation_id': 'get_api_v1_external_account_campaigns_by_account_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'account_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v1_external_account_retailers_by_account_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfRetailer,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{accountId}/retailers',
                'operation_id': 'get_api_v1_external_account_retailers_by_account_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'account_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v1_external_accounts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfAccount,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts',
                'operation_id': 'get_api_v1_external_accounts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v1_external_balance_campaigns_by_balance_id_endpoint = _Endpoint(
            settings={
                'response_type': (PageOfBalanceCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/balances/{balanceId}/campaigns',
                'operation_id': 'get_api_v1_external_balance_campaigns_by_balance_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'balance_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'balance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'balance_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'balance_id': 'balanceId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'balance_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v1_external_campaign_by_campaign_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/campaigns/{campaignId}',
                'operation_id': 'get_api_v1_external_campaign_by_campaign_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (str,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignId',
                },
                'location_map': {
                    'campaign_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v1_external_campaign_line_items_by_campaign_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfLineItem,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/campaigns/{campaignId}/line-items',
                'operation_id': 'get_api_v1_external_campaign_line_items_by_campaign_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v1_external_line_item_by_line_item_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfLineItem,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{lineItemId}',
                'operation_id': 'get_api_v1_external_line_item_by_line_item_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                },
                'attribute_map': {
                    'line_item_id': 'lineItemId',
                },
                'location_map': {
                    'line_item_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v1_external_line_item_products_by_line_item_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfStringAndPromotedProduct,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{lineItemId}/products',
                'operation_id': 'get_api_v1_external_line_item_products_by_line_item_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'line_item_id': 'lineItemId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v1_external_retailer_brands_by_retailer_id_endpoint = _Endpoint(
            settings={
                'response_type': (BrandPreviewListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/retailers/{retailerId}/brands',
                'operation_id': 'get_api_v1_external_retailer_brands_by_retailer_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'retailer_id',
                    'sku_stock_type_filter',
                ],
                'required': [
                    'retailer_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'sku_stock_type_filter',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('sku_stock_type_filter',): {

                        "FIRST-PARTY": "first-party",
                        "THIRD-PARTY": "third-party",
                        "FIRST-AND-THIRD-PARTY": "first-and-third-party"
                    },
                },
                'openapi_types': {
                    'retailer_id':
                        (int,),
                    'sku_stock_type_filter':
                        (str,),
                },
                'attribute_map': {
                    'retailer_id': 'retailerId',
                    'sku_stock_type_filter': 'sku-stock-type-filter',
                },
                'location_map': {
                    'retailer_id': 'path',
                    'sku_stock_type_filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v1_external_retailer_by_retailer_id_seller_by_seller_endpoint = _Endpoint(
            settings={
                'response_type': (SellerPreviewResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/retailers/{retailerId}/sellers/{seller}',
                'operation_id': 'get_api_v1_external_retailer_by_retailer_id_seller_by_seller',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'retailer_id',
                    'seller',
                ],
                'required': [
                    'retailer_id',
                    'seller',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'retailer_id':
                        (int,),
                    'seller':
                        (str,),
                },
                'attribute_map': {
                    'retailer_id': 'retailerId',
                    'seller': 'seller',
                },
                'location_map': {
                    'retailer_id': 'path',
                    'seller': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v1_external_retailer_category_cpc_rates_by_retailer_id_endpoint = _Endpoint(
            settings={
                'response_type': (CategoryCpcRateCardPreviewListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/retailers/{retailer-id}/category-cpc-rates',
                'operation_id': 'get_api_v1_external_retailer_category_cpc_rates_by_retailer_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'retailer_id',
                ],
                'required': [
                    'retailer_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'retailer_id':
                        (str,),
                },
                'attribute_map': {
                    'retailer_id': 'retailer-id',
                },
                'location_map': {
                    'retailer_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_api_v1_external_retailer_placements_by_retailer_id_endpoint = _Endpoint(
            settings={
                'response_type': (PlacementPreviewListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/retailers/{retailer-id}/placements',
                'operation_id': 'get_api_v1_external_retailer_placements_by_retailer_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'retailer_id',
                ],
                'required': [
                    'retailer_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'retailer_id':
                        (str,),
                },
                'attribute_map': {
                    'retailer_id': 'retailer-id',
                },
                'location_map': {
                    'retailer_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.post_api202210_external_account_creatives_by_account_id_endpoint = _Endpoint(
            settings={
                'response_type': (Creative202210Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{account-id}/creatives',
                'operation_id': 'post_api202210_external_account_creatives_by_account_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'creative_create_model202207',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'creative_create_model202207':
                        (CreativeCreateModel202207,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                },
                'location_map': {
                    'account_id': 'path',
                    'creative_create_model202207': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.post_api202210_external_account_creatives_search_by_account_id_endpoint = _Endpoint(
            settings={
                'response_type': (Creative202210ListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{account-id}/creatives/search',
                'operation_id': 'post_api202210_external_account_creatives_search_by_account_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'creative_ids',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'creative_ids':
                        ([str],),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'creative_ids': 'creative-ids',
                },
                'location_map': {
                    'account_id': 'path',
                    'creative_ids': 'query',
                },
                'collection_format_map': {
                    'creative_ids': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.post_api202210_external_line_item_product_buttons_create_by_line_item_id_endpoint = _Endpoint(
            settings={
                'response_type': (ProductButtonListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{line-item-id}/product-buttons/create',
                'operation_id': 'post_api202210_external_line_item_product_buttons_create_by_line_item_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'product_button_list_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'product_button_list_request':
                        (ProductButtonListRequest,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'product_button_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.post_api_v0_external_account_catalogs_by_account_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCatalogStatus,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{accountId}/catalogs',
                'operation_id': 'post_api_v0_external_account_catalogs_by_account_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'json_api_request_of_catalog_request_preview',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'json_api_request_of_catalog_request_preview':
                        (JsonApiRequestOfCatalogRequestPreview,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                    'json_api_request_of_catalog_request_preview': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.post_api_v1_external_account_campaigns_by_account_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{accountId}/campaigns',
                'operation_id': 'post_api_v1_external_account_campaigns_by_account_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'external_post_campaign',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'external_post_campaign':
                        (ExternalPostCampaign,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                    'external_post_campaign': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.post_api_v1_external_campaign_line_items_by_campaign_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfLineItem,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/campaigns/{campaignId}/line-items',
                'operation_id': 'post_api_v1_external_campaign_line_items_by_campaign_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'external_post_line_item',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (str,),
                    'external_post_line_item':
                        (ExternalPostLineItem,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignId',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'external_post_line_item': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.post_api_v1_external_catalogs_sku_retrieval_endpoint = _Endpoint(
            settings={
                'response_type': (SkuDataPreviewListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/catalogs/sku-retrieval',
                'operation_id': 'post_api_v1_external_catalogs_sku_retrieval',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'page_index',
                    'page_size',
                    'request_body',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_index',
                    'page_size',
                    'request_body',
                ]
            },
            root_map={
                'validations': {
                    ('page_index',): {

                        'inclusive_maximum': 500,
                        'inclusive_minimum': 0,
                    },
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('request_body',): {

                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                    'request_body':
                        ([str],),
                },
                'attribute_map': {
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'page_index': 'query',
                    'page_size': 'query',
                    'request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.post_api_v1_external_catalogs_sku_search_endpoint = _Endpoint(
            settings={
                'response_type': (SkuDataPreviewListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/catalogs/sku-search',
                'operation_id': 'post_api_v1_external_catalogs_sku_search',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'page_index',
                    'page_size',
                    'sku_search_request_preview_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_index',
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('page_index',): {

                        'inclusive_maximum': 500,
                        'inclusive_minimum': 0,
                    },
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                    'sku_search_request_preview_request':
                        (SkuSearchRequestPreviewRequest,),
                },
                'attribute_map': {
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'page_index': 'query',
                    'page_size': 'query',
                    'sku_search_request_preview_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.put_api202210_external_account_by_account_id_creativescreative_id_endpoint = _Endpoint(
            settings={
                'response_type': (Creative202210Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{account-id}/creatives/{creative-id}',
                'operation_id': 'put_api202210_external_account_by_account_id_creativescreative_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'creative_id',
                    'creative_update_model202207',
                ],
                'required': [
                    'account_id',
                    'creative_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'creative_id':
                        (str,),
                    'creative_update_model202207':
                        (CreativeUpdateModel202207,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'creative_id': 'creative-id',
                },
                'location_map': {
                    'account_id': 'path',
                    'creative_id': 'path',
                    'creative_update_model202207': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.put_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id_endpoint = _Endpoint(
            settings={
                'response_type': (ProductButtonResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{line-item-id}/product-buttons/{product-button-id}',
                'operation_id': 'put_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'product_button_id',
                    'product_button_request',
                ],
                'required': [
                    'line_item_id',
                    'product_button_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'product_button_id':
                        (str,),
                    'product_button_request':
                        (ProductButtonRequest,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                    'product_button_id': 'product-button-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'product_button_id': 'path',
                    'product_button_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.put_api202301_external_line_item_bid_multipliers_by_line_item_id_endpoint = _Endpoint(
            settings={
                'response_type': (LineItemBidMultipliersResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{line-item-id}/bid-multipliers',
                'operation_id': 'put_api202301_external_line_item_bid_multipliers_by_line_item_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'line_item_bid_multipliers_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'line_item_bid_multipliers_request':
                        (LineItemBidMultipliersRequest,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'line_item_bid_multipliers_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.put_api_v1_external_balance_campaigns_by_balance_id_endpoint = _Endpoint(
            settings={
                'response_type': (PageOfBalanceCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/balances/{balanceId}/campaigns',
                'operation_id': 'put_api_v1_external_balance_campaigns_by_balance_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'balance_id',
                    'json_api_data_request_of_put_balance_campaign',
                ],
                'required': [
                    'balance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'balance_id':
                        (str,),
                    'json_api_data_request_of_put_balance_campaign':
                        (JsonApiDataRequestOfPutBalanceCampaign,),
                },
                'attribute_map': {
                    'balance_id': 'balanceId',
                },
                'location_map': {
                    'balance_id': 'path',
                    'json_api_data_request_of_put_balance_campaign': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.put_api_v1_external_campaign_by_campaign_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/campaigns/{campaignId}',
                'operation_id': 'put_api_v1_external_campaign_by_campaign_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'external_put_campaign',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (str,),
                    'external_put_campaign':
                        (ExternalPutCampaign,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignId',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'external_put_campaign': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.put_api_v1_external_line_item_by_line_item_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfLineItem,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{lineItemId}',
                'operation_id': 'put_api_v1_external_line_item_by_line_item_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'external_put_line_item',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'external_put_line_item':
                        (ExternalPutLineItem,),
                },
                'attribute_map': {
                    'line_item_id': 'lineItemId',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'external_put_line_item': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.put_api_v1_external_line_item_products_by_line_item_id_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfStringAndPromotedProduct,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{lineItemId}/products',
                'operation_id': 'put_api_v1_external_line_item_products_by_line_item_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'json_api_data_request_with_id_of_string_and_promoted_product',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'json_api_data_request_with_id_of_string_and_promoted_product':
                        (JsonApiDataRequestWithIdOfStringAndPromotedProduct,),
                },
                'attribute_map': {
                    'line_item_id': 'lineItemId',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'json_api_data_request_with_id_of_string_and_promoted_product': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.set_keyword_bids_endpoint = _Endpoint(
            settings={
                'response_type': (RetailMediaExternalv1ResourceOutcome,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{id}/keywords/set-bid',
                'operation_id': 'set_keyword_bids',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'retail_media_externalv1_set_bids_model_request',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'retail_media_externalv1_set_bids_model_request':
                        (RetailMediaExternalv1SetBidsModelRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'retail_media_externalv1_set_bids_model_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.submit_proposal_endpoint = _Endpoint(
            settings={
                'response_type': (RetailMediaExternalv1ProposalStatusModelResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/preferred-deal-line-items/{id}/proposal/submit',
                'operation_id': 'submit_proposal',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def add_remove_keywords(
        self,
        id,
        **kwargs
    ):
        """add_remove_keywords  # noqa: E501

        Add or Remove keywords from the associated line item in bulk  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_remove_keywords(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): Long external id of the associated line item

        Keyword Args:
            retail_media_externalv1_add_remove_keywords_model_request (RetailMediaExternalv1AddRemoveKeywordsModelRequest): Object containing keywords to be added or removed. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RetailMediaExternalv1ResourceOutcome
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.add_remove_keywords_endpoint.call_with_http_info(**kwargs)

    def delete_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id(
        self,
        line_item_id,
        product_button_id,
        **kwargs
    ):
        """delete_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id  # noqa: E501

        Delete a product button  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id(line_item_id, product_button_id, async_req=True)
        >>> result = thread.get()

        Args:
            line_item_id (str): Long external id of the associated line item
            product_button_id (str): Sequential id of the product button

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['line_item_id'] = \
            line_item_id
        kwargs['product_button_id'] = \
            product_button_id
        return self.delete_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id_endpoint.call_with_http_info(**kwargs)

    def delete_api_v1_external_balance_campaigns_by_balance_id(
        self,
        balance_id,
        **kwargs
    ):
        """delete_api_v1_external_balance_campaigns_by_balance_id  # noqa: E501

        Removes one or more campaigns on the specified balance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_api_v1_external_balance_campaigns_by_balance_id(balance_id, async_req=True)
        >>> result = thread.get()

        Args:
            balance_id (str): The balance to remove campaigns from

        Keyword Args:
            json_api_data_request_of_delete_balance_campaign (JsonApiDataRequestOfDeleteBalanceCampaign): The campaigns to append. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PageOfBalanceCampaign
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['balance_id'] = \
            balance_id
        return self.delete_api_v1_external_balance_campaigns_by_balance_id_endpoint.call_with_http_info(**kwargs)

    def delete_api_v1_external_line_item_products_by_line_item_id(
        self,
        line_item_id,
        **kwargs
    ):
        """delete_api_v1_external_line_item_products_by_line_item_id  # noqa: E501

        This endpoint removes one or more products from promotion on the specified line item.  The resulting state of the line item is returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_api_v1_external_line_item_products_by_line_item_id(line_item_id, async_req=True)
        >>> result = thread.get()

        Args:
            line_item_id (str): The line item to interact with

        Keyword Args:
            json_api_data_request_with_id_of_string_and_promoted_product (JsonApiDataRequestWithIdOfStringAndPromotedProduct): . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiPageResponseOfStringAndPromotedProduct
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['line_item_id'] = \
            line_item_id
        return self.delete_api_v1_external_line_item_products_by_line_item_id_endpoint.call_with_http_info(**kwargs)

    def fetch_keywords(
        self,
        id,
        **kwargs
    ):
        """fetch_keywords  # noqa: E501

        Fetch keywords associated with the specified line item  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_keywords(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): Long external id of the associated line item

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RetailMediaExternalv1KeywordsModelResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.fetch_keywords_endpoint.call_with_http_info(**kwargs)

    def fetch_proposal(
        self,
        id,
        **kwargs
    ):
        """fetch_proposal  # noqa: E501

        Fetch the status of a proposal to modify a Preferred Deal Line Item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_proposal(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): The external id of a line item.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RetailMediaExternalv1ProposalStatusModelResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.fetch_proposal_endpoint.call_with_http_info(**kwargs)

    def get_aip_v1_external_retailer_retailer_cpc_rates_by_retailer_id(
        self,
        retailer_id,
        **kwargs
    ):
        """get_aip_v1_external_retailer_retailer_cpc_rates_by_retailer_id  # noqa: E501

        Gets the minimum cpc bid for a retailer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_aip_v1_external_retailer_retailer_cpc_rates_by_retailer_id(retailer_id, async_req=True)
        >>> result = thread.get()

        Args:
            retailer_id (str): The retailer id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RetailerCpcRateCardPreviewResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['retailer_id'] = \
            retailer_id
        return self.get_aip_v1_external_retailer_retailer_cpc_rates_by_retailer_id_endpoint.call_with_http_info(**kwargs)

    def get_api202210_external_account_by_account_id_creativescreative_id(
        self,
        account_id,
        creative_id,
        **kwargs
    ):
        """get_api202210_external_account_by_account_id_creativescreative_id  # noqa: E501

        Get the specified creative  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api202210_external_account_by_account_id_creativescreative_id(account_id, creative_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): External account id to retrieve creatives for
            creative_id (str): Creative to get

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Creative202210Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        kwargs['creative_id'] = \
            creative_id
        return self.get_api202210_external_account_by_account_id_creativescreative_id_endpoint.call_with_http_info(**kwargs)

    def get_api202210_external_line_item_product_buttons_by_line_item_id(
        self,
        line_item_id,
        **kwargs
    ):
        """get_api202210_external_line_item_product_buttons_by_line_item_id  # noqa: E501

        Get all the product buttons associated with a line item  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api202210_external_line_item_product_buttons_by_line_item_id(line_item_id, async_req=True)
        >>> result = thread.get()

        Args:
            line_item_id (str): Long external id of the associated line item

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ProductButtonListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['line_item_id'] = \
            line_item_id
        return self.get_api202210_external_line_item_product_buttons_by_line_item_id_endpoint.call_with_http_info(**kwargs)

    def get_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id(
        self,
        line_item_id,
        product_button_id,
        **kwargs
    ):
        """get_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id  # noqa: E501

        Get a single product button  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id(line_item_id, product_button_id, async_req=True)
        >>> result = thread.get()

        Args:
            line_item_id (str): Long external id of the associated line item
            product_button_id (str): Sequential id of the product button

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ProductButtonResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['line_item_id'] = \
            line_item_id
        kwargs['product_button_id'] = \
            product_button_id
        return self.get_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id_endpoint.call_with_http_info(**kwargs)

    def get_api202301_external_line_item_bid_multipliers_by_line_item_id(
        self,
        line_item_id,
        **kwargs
    ):
        """get_api202301_external_line_item_bid_multipliers_by_line_item_id  # noqa: E501

        Get bid multipliers by line item  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api202301_external_line_item_bid_multipliers_by_line_item_id(line_item_id, async_req=True)
        >>> result = thread.get()

        Args:
            line_item_id (str): Long external id of the associated line item

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiSingleResponseOfLineItemBidMultipliers
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['line_item_id'] = \
            line_item_id
        return self.get_api202301_external_line_item_bid_multipliers_by_line_item_id_endpoint.call_with_http_info(**kwargs)

    def get_api_v0_external_catalog_output_by_catalog_id(
        self,
        catalog_id,
        **kwargs
    ):
        """get_api_v0_external_catalog_output_by_catalog_id  # noqa: E501

        Output the indicated catalog. Catalogs are only available for retrieval when their associated status request  is at a Success status.  Produces application/x-json-stream of CatalogProduct json objects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v0_external_catalog_output_by_catalog_id(catalog_id, async_req=True)
        >>> result = thread.get()

        Args:
            catalog_id (str): A catalog ID returned from an account catalog request.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['catalog_id'] = \
            catalog_id
        return self.get_api_v0_external_catalog_output_by_catalog_id_endpoint.call_with_http_info(**kwargs)

    def get_api_v0_external_catalog_status_by_catalog_id(
        self,
        catalog_id,
        **kwargs
    ):
        """get_api_v0_external_catalog_status_by_catalog_id  # noqa: E501

        Check the status of a catalog request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v0_external_catalog_status_by_catalog_id(catalog_id, async_req=True)
        >>> result = thread.get()

        Args:
            catalog_id (str): A catalog ID returned from an account catalog request.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiSingleResponseOfCatalogStatus
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['catalog_id'] = \
            catalog_id
        return self.get_api_v0_external_catalog_status_by_catalog_id_endpoint.call_with_http_info(**kwargs)

    def get_api_v1_external_account_balances_by_account_id(
        self,
        account_id,
        **kwargs
    ):
        """get_api_v1_external_account_balances_by_account_id  # noqa: E501

        Gets page of balance objects for the given account id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v1_external_account_balances_by_account_id(account_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): The account to get balances for

        Keyword Args:
            limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
            page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
            page_size (int): The maximum number of items you would like to receive in this request. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiPageResponseOfBalance
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        return self.get_api_v1_external_account_balances_by_account_id_endpoint.call_with_http_info(**kwargs)

    def get_api_v1_external_account_brands_by_account_id(
        self,
        account_id,
        **kwargs
    ):
        """get_api_v1_external_account_brands_by_account_id  # noqa: E501

        Gets page of retailer objects that are associated with the given account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v1_external_account_brands_by_account_id(account_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): The given account id

        Keyword Args:
            limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
            page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
            page_size (int): The maximum number of items you would like to receive in this request. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiPageResponseOfBrand
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        return self.get_api_v1_external_account_brands_by_account_id_endpoint.call_with_http_info(**kwargs)

    def get_api_v1_external_account_campaigns_by_account_id(
        self,
        account_id,
        **kwargs
    ):
        """get_api_v1_external_account_campaigns_by_account_id  # noqa: E501

        Gets page of campaign objects for the given account id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v1_external_account_campaigns_by_account_id(account_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): The given account id

        Keyword Args:
            limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
            page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
            page_size (int): The maximum number of items you would like to receive in this request. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiPageResponseOfCampaign
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        return self.get_api_v1_external_account_campaigns_by_account_id_endpoint.call_with_http_info(**kwargs)

    def get_api_v1_external_account_retailers_by_account_id(
        self,
        account_id,
        **kwargs
    ):
        """get_api_v1_external_account_retailers_by_account_id  # noqa: E501

        Gets page of retailer objects that are associated with the given account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v1_external_account_retailers_by_account_id(account_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): The given account id

        Keyword Args:
            limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
            page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
            page_size (int): The maximum number of items you would like to receive in this request. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiPageResponseOfRetailer
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        return self.get_api_v1_external_account_retailers_by_account_id_endpoint.call_with_http_info(**kwargs)

    def get_api_v1_external_accounts(
        self,
        **kwargs
    ):
        """get_api_v1_external_accounts  # noqa: E501

        Gets page of account objects that the current user can access  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v1_external_accounts(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
            page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
            page_size (int): The maximum number of items you would like to receive in this request. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiPageResponseOfAccount
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_api_v1_external_accounts_endpoint.call_with_http_info(**kwargs)

    def get_api_v1_external_balance_campaigns_by_balance_id(
        self,
        balance_id,
        **kwargs
    ):
        """get_api_v1_external_balance_campaigns_by_balance_id  # noqa: E501

        Gets page of campaigns for the given balanceId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v1_external_balance_campaigns_by_balance_id(balance_id, async_req=True)
        >>> result = thread.get()

        Args:
            balance_id (str): The balance to get campaigns from

        Keyword Args:
            limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
            page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
            page_size (int): The maximum number of items you would like to receive in this request. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PageOfBalanceCampaign
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['balance_id'] = \
            balance_id
        return self.get_api_v1_external_balance_campaigns_by_balance_id_endpoint.call_with_http_info(**kwargs)

    def get_api_v1_external_campaign_by_campaign_id(
        self,
        campaign_id,
        **kwargs
    ):
        """get_api_v1_external_campaign_by_campaign_id  # noqa: E501

        Gets the campaign for the given campaign id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v1_external_campaign_by_campaign_id(campaign_id, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (str): The given campaign id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiSingleResponseOfCampaign
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['campaign_id'] = \
            campaign_id
        return self.get_api_v1_external_campaign_by_campaign_id_endpoint.call_with_http_info(**kwargs)

    def get_api_v1_external_campaign_line_items_by_campaign_id(
        self,
        campaign_id,
        **kwargs
    ):
        """get_api_v1_external_campaign_line_items_by_campaign_id  # noqa: E501

        Gets page of line item objects for the given campaign id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v1_external_campaign_line_items_by_campaign_id(campaign_id, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (str): The given campaign id

        Keyword Args:
            limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
            page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
            page_size (int): The maximum number of items you would like to receive in this request. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiPageResponseOfLineItem
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['campaign_id'] = \
            campaign_id
        return self.get_api_v1_external_campaign_line_items_by_campaign_id_endpoint.call_with_http_info(**kwargs)

    def get_api_v1_external_line_item_by_line_item_id(
        self,
        line_item_id,
        **kwargs
    ):
        """get_api_v1_external_line_item_by_line_item_id  # noqa: E501

        Gets the line item for the given line item id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v1_external_line_item_by_line_item_id(line_item_id, async_req=True)
        >>> result = thread.get()

        Args:
            line_item_id (str): The given line item id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiSingleResponseOfLineItem
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['line_item_id'] = \
            line_item_id
        return self.get_api_v1_external_line_item_by_line_item_id_endpoint.call_with_http_info(**kwargs)

    def get_api_v1_external_line_item_products_by_line_item_id(
        self,
        line_item_id,
        **kwargs
    ):
        """get_api_v1_external_line_item_products_by_line_item_id  # noqa: E501

        This endpoint gets the promoted products on the specified line item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v1_external_line_item_products_by_line_item_id(line_item_id, async_req=True)
        >>> result = thread.get()

        Args:
            line_item_id (str): The line item to interact with

        Keyword Args:
            limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
            page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
            page_size (int): The maximum number of items you would like to receive in this request. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiPageResponseOfStringAndPromotedProduct
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['line_item_id'] = \
            line_item_id
        return self.get_api_v1_external_line_item_products_by_line_item_id_endpoint.call_with_http_info(**kwargs)

    def get_api_v1_external_retailer_brands_by_retailer_id(
        self,
        retailer_id,
        **kwargs
    ):
        """get_api_v1_external_retailer_brands_by_retailer_id  # noqa: E501

        Gets the brands for the given retailer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v1_external_retailer_brands_by_retailer_id(retailer_id, async_req=True)
        >>> result = thread.get()

        Args:
            retailer_id (int): The retailer id for which brands should be fetched.

        Keyword Args:
            sku_stock_type_filter (str): Filter to narrow down brands [first-party|third-party|first-and-third-party]. Defaults to first-and-third-party. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            BrandPreviewListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['retailer_id'] = \
            retailer_id
        return self.get_api_v1_external_retailer_brands_by_retailer_id_endpoint.call_with_http_info(**kwargs)

    def get_api_v1_external_retailer_by_retailer_id_seller_by_seller(
        self,
        retailer_id,
        seller,
        **kwargs
    ):
        """get_api_v1_external_retailer_by_retailer_id_seller_by_seller  # noqa: E501

        Endpoint to get market place seller id and name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v1_external_retailer_by_retailer_id_seller_by_seller(retailer_id, seller, async_req=True)
        >>> result = thread.get()

        Args:
            retailer_id (int): The retailer id for which seller should be fetched.
            seller (str): The seller id or seller name which should be validated.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SellerPreviewResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['retailer_id'] = \
            retailer_id
        kwargs['seller'] = \
            seller
        return self.get_api_v1_external_retailer_by_retailer_id_seller_by_seller_endpoint.call_with_http_info(**kwargs)

    def get_api_v1_external_retailer_category_cpc_rates_by_retailer_id(
        self,
        retailer_id,
        **kwargs
    ):
        """get_api_v1_external_retailer_category_cpc_rates_by_retailer_id  # noqa: E501

        Gets the minimum cpc bid for all categories for a retailer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v1_external_retailer_category_cpc_rates_by_retailer_id(retailer_id, async_req=True)
        >>> result = thread.get()

        Args:
            retailer_id (str): The retailer id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CategoryCpcRateCardPreviewListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['retailer_id'] = \
            retailer_id
        return self.get_api_v1_external_retailer_category_cpc_rates_by_retailer_id_endpoint.call_with_http_info(**kwargs)

    def get_api_v1_external_retailer_placements_by_retailer_id(
        self,
        retailer_id,
        **kwargs
    ):
        """get_api_v1_external_retailer_placements_by_retailer_id  # noqa: E501

        Gets all placement information for the given retailer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_v1_external_retailer_placements_by_retailer_id(retailer_id, async_req=True)
        >>> result = thread.get()

        Args:
            retailer_id (str): The retailer id for which placements should be fetched.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PlacementPreviewListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['retailer_id'] = \
            retailer_id
        return self.get_api_v1_external_retailer_placements_by_retailer_id_endpoint.call_with_http_info(**kwargs)

    def post_api202210_external_account_creatives_by_account_id(
        self,
        account_id,
        **kwargs
    ):
        """post_api202210_external_account_creatives_by_account_id  # noqa: E501

        Create a creative for an account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_api202210_external_account_creatives_by_account_id(account_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): External account id to create a creative for

        Keyword Args:
            creative_create_model202207 (CreativeCreateModel202207): The creative to create. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Creative202210Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        return self.post_api202210_external_account_creatives_by_account_id_endpoint.call_with_http_info(**kwargs)

    def post_api202210_external_account_creatives_search_by_account_id(
        self,
        account_id,
        **kwargs
    ):
        """post_api202210_external_account_creatives_search_by_account_id  # noqa: E501

        Get account creatives  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_api202210_external_account_creatives_search_by_account_id(account_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): External account id to retrieve creatives for

        Keyword Args:
            creative_ids ([str]): Creatives to filter by. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Creative202210ListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        return self.post_api202210_external_account_creatives_search_by_account_id_endpoint.call_with_http_info(**kwargs)

    def post_api202210_external_line_item_product_buttons_create_by_line_item_id(
        self,
        line_item_id,
        **kwargs
    ):
        """post_api202210_external_line_item_product_buttons_create_by_line_item_id  # noqa: E501

        Append new product buttons to a line item  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_api202210_external_line_item_product_buttons_create_by_line_item_id(line_item_id, async_req=True)
        >>> result = thread.get()

        Args:
            line_item_id (str): Long external id of the associated line item

        Keyword Args:
            product_button_list_request (ProductButtonListRequest): List of product buttons to append to the specified line item. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ProductButtonListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['line_item_id'] = \
            line_item_id
        return self.post_api202210_external_line_item_product_buttons_create_by_line_item_id_endpoint.call_with_http_info(**kwargs)

    def post_api_v0_external_account_catalogs_by_account_id(
        self,
        account_id,
        **kwargs
    ):
        """post_api_v0_external_account_catalogs_by_account_id  # noqa: E501

        Create a request for a Catalog available to the indicated account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_api_v0_external_account_catalogs_by_account_id(account_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): The account to request the catalog for.

        Keyword Args:
            json_api_request_of_catalog_request_preview (JsonApiRequestOfCatalogRequestPreview): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiSingleResponseOfCatalogStatus
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        return self.post_api_v0_external_account_catalogs_by_account_id_endpoint.call_with_http_info(**kwargs)

    def post_api_v1_external_account_campaigns_by_account_id(
        self,
        account_id,
        **kwargs
    ):
        """post_api_v1_external_account_campaigns_by_account_id  # noqa: E501

        Creates a new campaign with the specified settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_api_v1_external_account_campaigns_by_account_id(account_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): The given account id

        Keyword Args:
            external_post_campaign (ExternalPostCampaign): The campaign settings to create a campaign with. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiSingleResponseOfCampaign
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        return self.post_api_v1_external_account_campaigns_by_account_id_endpoint.call_with_http_info(**kwargs)

    def post_api_v1_external_campaign_line_items_by_campaign_id(
        self,
        campaign_id,
        **kwargs
    ):
        """post_api_v1_external_campaign_line_items_by_campaign_id  # noqa: E501

        Creates a new line item with the specified settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_api_v1_external_campaign_line_items_by_campaign_id(campaign_id, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (str): The given campaign id

        Keyword Args:
            external_post_line_item (ExternalPostLineItem): The line item settings to create a line item with. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiSingleResponseOfLineItem
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['campaign_id'] = \
            campaign_id
        return self.post_api_v1_external_campaign_line_items_by_campaign_id_endpoint.call_with_http_info(**kwargs)

    def post_api_v1_external_catalogs_sku_retrieval(
        self,
        **kwargs
    ):
        """post_api_v1_external_catalogs_sku_retrieval  # noqa: E501

        Endpoint to search skus by text, retailer and sellers/brands.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_api_v1_external_catalogs_sku_retrieval(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_index (int): The start position in the overall list of matches. Must be zero or greater.. [optional] if omitted the server will use the default value of 0
            page_size (int): The maximum number of results to return with each call. Must be greater than zero.. [optional] if omitted the server will use the default value of 100
            request_body ([str]): The list of SKU keys to retrieve sku information. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SkuDataPreviewListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.post_api_v1_external_catalogs_sku_retrieval_endpoint.call_with_http_info(**kwargs)

    def post_api_v1_external_catalogs_sku_search(
        self,
        **kwargs
    ):
        """post_api_v1_external_catalogs_sku_search  # noqa: E501

        Endpoint to search skus by text, retailer and sellers/brands.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_api_v1_external_catalogs_sku_search(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_index (int): The start position in the overall list of matches. Must be zero or greater.. [optional] if omitted the server will use the default value of 0
            page_size (int): The maximum number of results to return with each call. Must be greater than zero.. [optional] if omitted the server will use the default value of 100
            sku_search_request_preview_request (SkuSearchRequestPreviewRequest): . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SkuDataPreviewListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.post_api_v1_external_catalogs_sku_search_endpoint.call_with_http_info(**kwargs)

    def put_api202210_external_account_by_account_id_creativescreative_id(
        self,
        account_id,
        creative_id,
        **kwargs
    ):
        """put_api202210_external_account_by_account_id_creativescreative_id  # noqa: E501

        Update a creative  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_api202210_external_account_by_account_id_creativescreative_id(account_id, creative_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): External account id containing the creative
            creative_id (str): Creative to update

        Keyword Args:
            creative_update_model202207 (CreativeUpdateModel202207): The creative to create. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Creative202210Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        kwargs['creative_id'] = \
            creative_id
        return self.put_api202210_external_account_by_account_id_creativescreative_id_endpoint.call_with_http_info(**kwargs)

    def put_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id(
        self,
        line_item_id,
        product_button_id,
        **kwargs
    ):
        """put_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id  # noqa: E501

        Update a product button  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id(line_item_id, product_button_id, async_req=True)
        >>> result = thread.get()

        Args:
            line_item_id (str): Long external id of the associated line item
            product_button_id (str): Sequential id of the product button

        Keyword Args:
            product_button_request (ProductButtonRequest): Details of the updated product button. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ProductButtonResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['line_item_id'] = \
            line_item_id
        kwargs['product_button_id'] = \
            product_button_id
        return self.put_api202210_external_line_item_product_buttons_by_line_item_id_product_button_id_endpoint.call_with_http_info(**kwargs)

    def put_api202301_external_line_item_bid_multipliers_by_line_item_id(
        self,
        line_item_id,
        **kwargs
    ):
        """put_api202301_external_line_item_bid_multipliers_by_line_item_id  # noqa: E501

        Replace bid multipliers on a line item  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_api202301_external_line_item_bid_multipliers_by_line_item_id(line_item_id, async_req=True)
        >>> result = thread.get()

        Args:
            line_item_id (str): Long external id of the associated line item

        Keyword Args:
            line_item_bid_multipliers_request (LineItemBidMultipliersRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            LineItemBidMultipliersResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['line_item_id'] = \
            line_item_id
        return self.put_api202301_external_line_item_bid_multipliers_by_line_item_id_endpoint.call_with_http_info(**kwargs)

    def put_api_v1_external_balance_campaigns_by_balance_id(
        self,
        balance_id,
        **kwargs
    ):
        """put_api_v1_external_balance_campaigns_by_balance_id  # noqa: E501

        appends one or more campaigns to the specified balance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_api_v1_external_balance_campaigns_by_balance_id(balance_id, async_req=True)
        >>> result = thread.get()

        Args:
            balance_id (str): The balance to add campaigns from

        Keyword Args:
            json_api_data_request_of_put_balance_campaign (JsonApiDataRequestOfPutBalanceCampaign): The campaigns to append. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PageOfBalanceCampaign
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['balance_id'] = \
            balance_id
        return self.put_api_v1_external_balance_campaigns_by_balance_id_endpoint.call_with_http_info(**kwargs)

    def put_api_v1_external_campaign_by_campaign_id(
        self,
        campaign_id,
        **kwargs
    ):
        """put_api_v1_external_campaign_by_campaign_id  # noqa: E501

        Updates the campaign for the given campaign id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_api_v1_external_campaign_by_campaign_id(campaign_id, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (str): The given campaign id

        Keyword Args:
            external_put_campaign (ExternalPutCampaign): The campaign settings to update that campaign with. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiSingleResponseOfCampaign
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['campaign_id'] = \
            campaign_id
        return self.put_api_v1_external_campaign_by_campaign_id_endpoint.call_with_http_info(**kwargs)

    def put_api_v1_external_line_item_by_line_item_id(
        self,
        line_item_id,
        **kwargs
    ):
        """put_api_v1_external_line_item_by_line_item_id  # noqa: E501

        Updates the line item for the given line item id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_api_v1_external_line_item_by_line_item_id(line_item_id, async_req=True)
        >>> result = thread.get()

        Args:
            line_item_id (str): The given line item id

        Keyword Args:
            external_put_line_item (ExternalPutLineItem): The line item settings to create a line item with. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiSingleResponseOfLineItem
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['line_item_id'] = \
            line_item_id
        return self.put_api_v1_external_line_item_by_line_item_id_endpoint.call_with_http_info(**kwargs)

    def put_api_v1_external_line_item_products_by_line_item_id(
        self,
        line_item_id,
        **kwargs
    ):
        """put_api_v1_external_line_item_products_by_line_item_id  # noqa: E501

        This endpoint appends one or more products to promote on the specified line item.  The resulting state of the line item is returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_api_v1_external_line_item_products_by_line_item_id(line_item_id, async_req=True)
        >>> result = thread.get()

        Args:
            line_item_id (str): The line item to interact with

        Keyword Args:
            json_api_data_request_with_id_of_string_and_promoted_product (JsonApiDataRequestWithIdOfStringAndPromotedProduct): the products to append to this line item. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiPageResponseOfStringAndPromotedProduct
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['line_item_id'] = \
            line_item_id
        return self.put_api_v1_external_line_item_products_by_line_item_id_endpoint.call_with_http_info(**kwargs)

    def set_keyword_bids(
        self,
        id,
        **kwargs
    ):
        """set_keyword_bids  # noqa: E501

        Set bid overrides for associated keywords to the given line item in bulk  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_keyword_bids(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): Long external id of the associated line item

        Keyword Args:
            retail_media_externalv1_set_bids_model_request (RetailMediaExternalv1SetBidsModelRequest): Object containing a list of bid overrides for associated keywords. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RetailMediaExternalv1ResourceOutcome
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.set_keyword_bids_endpoint.call_with_http_info(**kwargs)

    def submit_proposal(
        self,
        id,
        **kwargs
    ):
        """submit_proposal  # noqa: E501

        Submit a proposal to modify a Preferred Deal Line Item for review.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_proposal(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): The external id of a line item.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RetailMediaExternalv1ProposalStatusModelResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.submit_proposal_endpoint.call_with_http_info(**kwargs)

