"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalExec = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const provider_null_1 = require("@cdktf/provider-null");
const cdktf_1 = require("cdktf");
var provider_null_2 = require("@cdktf/provider-null");
Object.defineProperty(exports, "Provider", { enumerable: true, get: function () { return provider_null_2.NullProvider; } });
/**
 * @stability stable
 */
class LocalExec extends provider_null_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, config) {
        super(scope, id, config);
        const workingDir = config.copyBeforeRun === true
            ? new cdktf_1.TerraformAsset(this, "workingDir", {
                path: config.cwd,
                type: cdktf_1.AssetType.DIRECTORY,
            }).path
            : config.cwd;
        this.cwd = workingDir;
        this.command = config.command;
        this.addOverride("provisioner", [
            {
                "local-exec": {
                    working_dir: workingDir,
                    command: cdktf_1.Lazy.stringValue({
                        // TODO: wrap command to capture stdout and stderr
                        produce: () => this.command,
                    }),
                },
            },
        ]);
    }
}
exports.LocalExec = LocalExec;
_a = JSII_RTTI_SYMBOL_1;
LocalExec[_a] = { fqn: "cdktf-local-exec.LocalExec", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,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