# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GlobalClientArgs', 'GlobalClient']

@pulumi.input_type
class GlobalClientArgs:
    def __init__(__self__, *,
                 addons: Optional[pulumi.Input['GlobalClientAddonsArgs']] = None,
                 allowed_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_type: Optional[pulumi.Input[str]] = None,
                 callbacks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 client_secret_rotation_trigger: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cross_origin_auth: Optional[pulumi.Input[bool]] = None,
                 cross_origin_loc: Optional[pulumi.Input[str]] = None,
                 custom_login_page: Optional[pulumi.Input[str]] = None,
                 custom_login_page_on: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 form_template: Optional[pulumi.Input[str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 initiate_login_uri: Optional[pulumi.Input[str]] = None,
                 is_first_party: Optional[pulumi.Input[bool]] = None,
                 is_token_endpoint_ip_header_trusted: Optional[pulumi.Input[bool]] = None,
                 jwt_configuration: Optional[pulumi.Input['GlobalClientJwtConfigurationArgs']] = None,
                 logo_uri: Optional[pulumi.Input[str]] = None,
                 mobile: Optional[pulumi.Input['GlobalClientMobileArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_social_login: Optional[pulumi.Input['GlobalClientNativeSocialLoginArgs']] = None,
                 oidc_conformant: Optional[pulumi.Input[bool]] = None,
                 organization_require_behavior: Optional[pulumi.Input[str]] = None,
                 organization_usage: Optional[pulumi.Input[str]] = None,
                 refresh_token: Optional[pulumi.Input['GlobalClientRefreshTokenArgs']] = None,
                 signing_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]] = None,
                 sso: Optional[pulumi.Input[bool]] = None,
                 sso_disabled: Optional[pulumi.Input[bool]] = None,
                 token_endpoint_auth_method: Optional[pulumi.Input[str]] = None,
                 web_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a GlobalClient resource.
        :param pulumi.Input['GlobalClientAddonsArgs'] addons: Addons enabled for this client and their associated configurations.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_clients: List of applications ID's that will be allowed to make delegation request. By default, all applications will be allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        :param pulumi.Input[str] app_type: Type of application the client represents. Possible values are: `native`, `spa`, `regular_web`, `non_interactive`, `sso_integration`. Specific SSO integrations types accepted as well are: `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] callbacks: URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_aliases: List of audiences/realms for SAML protocol. Used by the wsfed addon.
        :param pulumi.Input[str] client_id: The ID of the client.
        :param pulumi.Input[Mapping[str, Any]] client_metadata: Metadata associated with the client, in the form of an object with string values (max 255 chars). Maximum of 10 metadata properties allowed. Field names (max 255 chars) are alphanumeric and may only include the following special characters: `:,-+=_*?"/\\()<>@ [Tab] [Space]`.
        :param pulumi.Input[str] client_secret: Secret for the client. Keep this private. To access this attribute you need to add the `read:client_keys` scope to the
               Terraform client. Otherwise, the attribute will contain an empty string.
        :param pulumi.Input[Mapping[str, Any]] client_secret_rotation_trigger: Custom metadata for the rotation. For more info: [rotate-client-secret](https://auth0.com/docs/get-started/applications/rotate-client-secret).
        :param pulumi.Input[bool] cross_origin_auth: Whether this client can be used to make cross-origin authentication requests (true) or it is not allowed to make such requests (false).
        :param pulumi.Input[str] cross_origin_loc: URL of the location in your site where the cross-origin verification takes place for the cross-origin auth flow when performing authentication in your own domain instead of Auth0 Universal Login page.
        :param pulumi.Input[str] custom_login_page: The content (HTML, CSS, JS) of the custom login page.
        :param pulumi.Input[bool] custom_login_page_on: Indicates whether a custom login page is to be used.
        :param pulumi.Input[str] description: Description of the purpose of the client.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] encryption_key: Encryption used for WS-Fed responses with this client.
        :param pulumi.Input[str] form_template: HTML form template to be used for WS-Federation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: Types of grants that this client is authorized to use.
        :param pulumi.Input[str] initiate_login_uri: Initiate login URI, must be HTTPS.
        :param pulumi.Input[bool] is_first_party: Indicates whether this client is a first-party client.
        :param pulumi.Input[bool] is_token_endpoint_ip_header_trusted: Indicates whether the token endpoint IP header is trusted.
        :param pulumi.Input['GlobalClientJwtConfigurationArgs'] jwt_configuration: Configuration settings for the JWTs issued for this client.
        :param pulumi.Input[str] logo_uri: URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        :param pulumi.Input['GlobalClientMobileArgs'] mobile: Additional configuration for native mobile apps.
        :param pulumi.Input[str] name: Name of the client.
        :param pulumi.Input['GlobalClientNativeSocialLoginArgs'] native_social_login: Configuration settings to toggle native social login for mobile native applications. Once this is set it must stay set, with both resources set to `false` in order to change the `app_type`.
        :param pulumi.Input[bool] oidc_conformant: Indicates whether this client will conform to strict OIDC specifications.
        :param pulumi.Input[str] organization_require_behavior: Defines how to proceed during an authentication transaction when `organization_usage = "require"`. Can be `no_prompt` (default) or `pre_login_prompt`.
        :param pulumi.Input[str] organization_usage: Defines how to proceed during an authentication transaction with regards to an organization. Can be `deny` (default), `allow` or `require`.
        :param pulumi.Input['GlobalClientRefreshTokenArgs'] refresh_token: Configuration settings for the refresh tokens issued for this client.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]] signing_keys: List containing a map of the public cert of the signing key and the public cert of the signing key in PKCS7.
        :param pulumi.Input[bool] sso: Applies only to SSO clients and determines whether Auth0 will handle Single Sign-On (true) or whether the identity provider will (false).
        :param pulumi.Input[bool] sso_disabled: Indicates whether or not SSO is disabled.
        :param pulumi.Input[str] token_endpoint_auth_method: Defines the requested authentication method for the token endpoint. Options include `none` (public client without a client secret), `client_secret_post` (client uses HTTP POST parameters), `client_secret_basic` (client uses HTTP Basic).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] web_origins: URLs that represent valid web origins for use with web message response mode.
        """
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if allowed_clients is not None:
            pulumi.set(__self__, "allowed_clients", allowed_clients)
        if allowed_logout_urls is not None:
            pulumi.set(__self__, "allowed_logout_urls", allowed_logout_urls)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if app_type is not None:
            pulumi.set(__self__, "app_type", app_type)
        if callbacks is not None:
            pulumi.set(__self__, "callbacks", callbacks)
        if client_aliases is not None:
            pulumi.set(__self__, "client_aliases", client_aliases)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_metadata is not None:
            pulumi.set(__self__, "client_metadata", client_metadata)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if client_secret_rotation_trigger is not None:
            pulumi.set(__self__, "client_secret_rotation_trigger", client_secret_rotation_trigger)
        if cross_origin_auth is not None:
            pulumi.set(__self__, "cross_origin_auth", cross_origin_auth)
        if cross_origin_loc is not None:
            pulumi.set(__self__, "cross_origin_loc", cross_origin_loc)
        if custom_login_page is not None:
            pulumi.set(__self__, "custom_login_page", custom_login_page)
        if custom_login_page_on is not None:
            pulumi.set(__self__, "custom_login_page_on", custom_login_page_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if form_template is not None:
            pulumi.set(__self__, "form_template", form_template)
        if grant_types is not None:
            pulumi.set(__self__, "grant_types", grant_types)
        if initiate_login_uri is not None:
            pulumi.set(__self__, "initiate_login_uri", initiate_login_uri)
        if is_first_party is not None:
            pulumi.set(__self__, "is_first_party", is_first_party)
        if is_token_endpoint_ip_header_trusted is not None:
            pulumi.set(__self__, "is_token_endpoint_ip_header_trusted", is_token_endpoint_ip_header_trusted)
        if jwt_configuration is not None:
            pulumi.set(__self__, "jwt_configuration", jwt_configuration)
        if logo_uri is not None:
            pulumi.set(__self__, "logo_uri", logo_uri)
        if mobile is not None:
            pulumi.set(__self__, "mobile", mobile)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if native_social_login is not None:
            pulumi.set(__self__, "native_social_login", native_social_login)
        if oidc_conformant is not None:
            pulumi.set(__self__, "oidc_conformant", oidc_conformant)
        if organization_require_behavior is not None:
            pulumi.set(__self__, "organization_require_behavior", organization_require_behavior)
        if organization_usage is not None:
            pulumi.set(__self__, "organization_usage", organization_usage)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if signing_keys is not None:
            pulumi.set(__self__, "signing_keys", signing_keys)
        if sso is not None:
            pulumi.set(__self__, "sso", sso)
        if sso_disabled is not None:
            pulumi.set(__self__, "sso_disabled", sso_disabled)
        if token_endpoint_auth_method is not None:
            pulumi.set(__self__, "token_endpoint_auth_method", token_endpoint_auth_method)
        if web_origins is not None:
            pulumi.set(__self__, "web_origins", web_origins)

    @property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input['GlobalClientAddonsArgs']]:
        """
        Addons enabled for this client and their associated configurations.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input['GlobalClientAddonsArgs']]):
        pulumi.set(self, "addons", value)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of applications ID's that will be allowed to make delegation request. By default, all applications will be allowed.
        """
        return pulumi.get(self, "allowed_clients")

    @allowed_clients.setter
    def allowed_clients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_clients", value)

    @property
    @pulumi.getter(name="allowedLogoutUrls")
    def allowed_logout_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that Auth0 may redirect to after logout.
        """
        return pulumi.get(self, "allowed_logout_urls")

    @allowed_logout_urls.setter
    def allowed_logout_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_logout_urls", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="appType")
    def app_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of application the client represents. Possible values are: `native`, `spa`, `regular_web`, `non_interactive`, `sso_integration`. Specific SSO integrations types accepted as well are: `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        """
        return pulumi.get(self, "app_type")

    @app_type.setter
    def app_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_type", value)

    @property
    @pulumi.getter
    def callbacks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        """
        return pulumi.get(self, "callbacks")

    @callbacks.setter
    def callbacks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "callbacks", value)

    @property
    @pulumi.getter(name="clientAliases")
    def client_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of audiences/realms for SAML protocol. Used by the wsfed addon.
        """
        return pulumi.get(self, "client_aliases")

    @client_aliases.setter
    def client_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "client_aliases", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the client.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientMetadata")
    def client_metadata(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Metadata associated with the client, in the form of an object with string values (max 255 chars). Maximum of 10 metadata properties allowed. Field names (max 255 chars) are alphanumeric and may only include the following special characters: `:,-+=_*?"/\\()<>@ [Tab] [Space]`.
        """
        return pulumi.get(self, "client_metadata")

    @client_metadata.setter
    def client_metadata(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "client_metadata", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Secret for the client. Keep this private. To access this attribute you need to add the `read:client_keys` scope to the
        Terraform client. Otherwise, the attribute will contain an empty string.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="clientSecretRotationTrigger")
    def client_secret_rotation_trigger(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Custom metadata for the rotation. For more info: [rotate-client-secret](https://auth0.com/docs/get-started/applications/rotate-client-secret).
        """
        return pulumi.get(self, "client_secret_rotation_trigger")

    @client_secret_rotation_trigger.setter
    def client_secret_rotation_trigger(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "client_secret_rotation_trigger", value)

    @property
    @pulumi.getter(name="crossOriginAuth")
    def cross_origin_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this client can be used to make cross-origin authentication requests (true) or it is not allowed to make such requests (false).
        """
        return pulumi.get(self, "cross_origin_auth")

    @cross_origin_auth.setter
    def cross_origin_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cross_origin_auth", value)

    @property
    @pulumi.getter(name="crossOriginLoc")
    def cross_origin_loc(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the location in your site where the cross-origin verification takes place for the cross-origin auth flow when performing authentication in your own domain instead of Auth0 Universal Login page.
        """
        return pulumi.get(self, "cross_origin_loc")

    @cross_origin_loc.setter
    def cross_origin_loc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_origin_loc", value)

    @property
    @pulumi.getter(name="customLoginPage")
    def custom_login_page(self) -> Optional[pulumi.Input[str]]:
        """
        The content (HTML, CSS, JS) of the custom login page.
        """
        return pulumi.get(self, "custom_login_page")

    @custom_login_page.setter
    def custom_login_page(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_login_page", value)

    @property
    @pulumi.getter(name="customLoginPageOn")
    def custom_login_page_on(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether a custom login page is to be used.
        """
        return pulumi.get(self, "custom_login_page_on")

    @custom_login_page_on.setter
    def custom_login_page_on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_login_page_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the purpose of the client.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Encryption used for WS-Fed responses with this client.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="formTemplate")
    def form_template(self) -> Optional[pulumi.Input[str]]:
        """
        HTML form template to be used for WS-Federation.
        """
        return pulumi.get(self, "form_template")

    @form_template.setter
    def form_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "form_template", value)

    @property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Types of grants that this client is authorized to use.
        """
        return pulumi.get(self, "grant_types")

    @grant_types.setter
    def grant_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "grant_types", value)

    @property
    @pulumi.getter(name="initiateLoginUri")
    def initiate_login_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Initiate login URI, must be HTTPS.
        """
        return pulumi.get(self, "initiate_login_uri")

    @initiate_login_uri.setter
    def initiate_login_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initiate_login_uri", value)

    @property
    @pulumi.getter(name="isFirstParty")
    def is_first_party(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this client is a first-party client.
        """
        return pulumi.get(self, "is_first_party")

    @is_first_party.setter
    def is_first_party(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_first_party", value)

    @property
    @pulumi.getter(name="isTokenEndpointIpHeaderTrusted")
    def is_token_endpoint_ip_header_trusted(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the token endpoint IP header is trusted.
        """
        return pulumi.get(self, "is_token_endpoint_ip_header_trusted")

    @is_token_endpoint_ip_header_trusted.setter
    def is_token_endpoint_ip_header_trusted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_token_endpoint_ip_header_trusted", value)

    @property
    @pulumi.getter(name="jwtConfiguration")
    def jwt_configuration(self) -> Optional[pulumi.Input['GlobalClientJwtConfigurationArgs']]:
        """
        Configuration settings for the JWTs issued for this client.
        """
        return pulumi.get(self, "jwt_configuration")

    @jwt_configuration.setter
    def jwt_configuration(self, value: Optional[pulumi.Input['GlobalClientJwtConfigurationArgs']]):
        pulumi.set(self, "jwt_configuration", value)

    @property
    @pulumi.getter(name="logoUri")
    def logo_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        """
        return pulumi.get(self, "logo_uri")

    @logo_uri.setter
    def logo_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_uri", value)

    @property
    @pulumi.getter
    def mobile(self) -> Optional[pulumi.Input['GlobalClientMobileArgs']]:
        """
        Additional configuration for native mobile apps.
        """
        return pulumi.get(self, "mobile")

    @mobile.setter
    def mobile(self, value: Optional[pulumi.Input['GlobalClientMobileArgs']]):
        pulumi.set(self, "mobile", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the client.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nativeSocialLogin")
    def native_social_login(self) -> Optional[pulumi.Input['GlobalClientNativeSocialLoginArgs']]:
        """
        Configuration settings to toggle native social login for mobile native applications. Once this is set it must stay set, with both resources set to `false` in order to change the `app_type`.
        """
        return pulumi.get(self, "native_social_login")

    @native_social_login.setter
    def native_social_login(self, value: Optional[pulumi.Input['GlobalClientNativeSocialLoginArgs']]):
        pulumi.set(self, "native_social_login", value)

    @property
    @pulumi.getter(name="oidcConformant")
    def oidc_conformant(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this client will conform to strict OIDC specifications.
        """
        return pulumi.get(self, "oidc_conformant")

    @oidc_conformant.setter
    def oidc_conformant(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "oidc_conformant", value)

    @property
    @pulumi.getter(name="organizationRequireBehavior")
    def organization_require_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Defines how to proceed during an authentication transaction when `organization_usage = "require"`. Can be `no_prompt` (default) or `pre_login_prompt`.
        """
        return pulumi.get(self, "organization_require_behavior")

    @organization_require_behavior.setter
    def organization_require_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_require_behavior", value)

    @property
    @pulumi.getter(name="organizationUsage")
    def organization_usage(self) -> Optional[pulumi.Input[str]]:
        """
        Defines how to proceed during an authentication transaction with regards to an organization. Can be `deny` (default), `allow` or `require`.
        """
        return pulumi.get(self, "organization_usage")

    @organization_usage.setter
    def organization_usage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_usage", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input['GlobalClientRefreshTokenArgs']]:
        """
        Configuration settings for the refresh tokens issued for this client.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input['GlobalClientRefreshTokenArgs']]):
        pulumi.set(self, "refresh_token", value)

    @property
    @pulumi.getter(name="signingKeys")
    def signing_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]]:
        """
        List containing a map of the public cert of the signing key and the public cert of the signing key in PKCS7.
        """
        return pulumi.get(self, "signing_keys")

    @signing_keys.setter
    def signing_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]]):
        pulumi.set(self, "signing_keys", value)

    @property
    @pulumi.getter
    def sso(self) -> Optional[pulumi.Input[bool]]:
        """
        Applies only to SSO clients and determines whether Auth0 will handle Single Sign-On (true) or whether the identity provider will (false).
        """
        return pulumi.get(self, "sso")

    @sso.setter
    def sso(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sso", value)

    @property
    @pulumi.getter(name="ssoDisabled")
    def sso_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not SSO is disabled.
        """
        return pulumi.get(self, "sso_disabled")

    @sso_disabled.setter
    def sso_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sso_disabled", value)

    @property
    @pulumi.getter(name="tokenEndpointAuthMethod")
    def token_endpoint_auth_method(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the requested authentication method for the token endpoint. Options include `none` (public client without a client secret), `client_secret_post` (client uses HTTP POST parameters), `client_secret_basic` (client uses HTTP Basic).
        """
        return pulumi.get(self, "token_endpoint_auth_method")

    @token_endpoint_auth_method.setter
    def token_endpoint_auth_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_endpoint_auth_method", value)

    @property
    @pulumi.getter(name="webOrigins")
    def web_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that represent valid web origins for use with web message response mode.
        """
        return pulumi.get(self, "web_origins")

    @web_origins.setter
    def web_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "web_origins", value)


@pulumi.input_type
class _GlobalClientState:
    def __init__(__self__, *,
                 addons: Optional[pulumi.Input['GlobalClientAddonsArgs']] = None,
                 allowed_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_type: Optional[pulumi.Input[str]] = None,
                 callbacks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 client_secret_rotation_trigger: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cross_origin_auth: Optional[pulumi.Input[bool]] = None,
                 cross_origin_loc: Optional[pulumi.Input[str]] = None,
                 custom_login_page: Optional[pulumi.Input[str]] = None,
                 custom_login_page_on: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 form_template: Optional[pulumi.Input[str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 initiate_login_uri: Optional[pulumi.Input[str]] = None,
                 is_first_party: Optional[pulumi.Input[bool]] = None,
                 is_token_endpoint_ip_header_trusted: Optional[pulumi.Input[bool]] = None,
                 jwt_configuration: Optional[pulumi.Input['GlobalClientJwtConfigurationArgs']] = None,
                 logo_uri: Optional[pulumi.Input[str]] = None,
                 mobile: Optional[pulumi.Input['GlobalClientMobileArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_social_login: Optional[pulumi.Input['GlobalClientNativeSocialLoginArgs']] = None,
                 oidc_conformant: Optional[pulumi.Input[bool]] = None,
                 organization_require_behavior: Optional[pulumi.Input[str]] = None,
                 organization_usage: Optional[pulumi.Input[str]] = None,
                 refresh_token: Optional[pulumi.Input['GlobalClientRefreshTokenArgs']] = None,
                 signing_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]] = None,
                 sso: Optional[pulumi.Input[bool]] = None,
                 sso_disabled: Optional[pulumi.Input[bool]] = None,
                 token_endpoint_auth_method: Optional[pulumi.Input[str]] = None,
                 web_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering GlobalClient resources.
        :param pulumi.Input['GlobalClientAddonsArgs'] addons: Addons enabled for this client and their associated configurations.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_clients: List of applications ID's that will be allowed to make delegation request. By default, all applications will be allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        :param pulumi.Input[str] app_type: Type of application the client represents. Possible values are: `native`, `spa`, `regular_web`, `non_interactive`, `sso_integration`. Specific SSO integrations types accepted as well are: `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] callbacks: URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_aliases: List of audiences/realms for SAML protocol. Used by the wsfed addon.
        :param pulumi.Input[str] client_id: The ID of the client.
        :param pulumi.Input[Mapping[str, Any]] client_metadata: Metadata associated with the client, in the form of an object with string values (max 255 chars). Maximum of 10 metadata properties allowed. Field names (max 255 chars) are alphanumeric and may only include the following special characters: `:,-+=_*?"/\\()<>@ [Tab] [Space]`.
        :param pulumi.Input[str] client_secret: Secret for the client. Keep this private. To access this attribute you need to add the `read:client_keys` scope to the
               Terraform client. Otherwise, the attribute will contain an empty string.
        :param pulumi.Input[Mapping[str, Any]] client_secret_rotation_trigger: Custom metadata for the rotation. For more info: [rotate-client-secret](https://auth0.com/docs/get-started/applications/rotate-client-secret).
        :param pulumi.Input[bool] cross_origin_auth: Whether this client can be used to make cross-origin authentication requests (true) or it is not allowed to make such requests (false).
        :param pulumi.Input[str] cross_origin_loc: URL of the location in your site where the cross-origin verification takes place for the cross-origin auth flow when performing authentication in your own domain instead of Auth0 Universal Login page.
        :param pulumi.Input[str] custom_login_page: The content (HTML, CSS, JS) of the custom login page.
        :param pulumi.Input[bool] custom_login_page_on: Indicates whether a custom login page is to be used.
        :param pulumi.Input[str] description: Description of the purpose of the client.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] encryption_key: Encryption used for WS-Fed responses with this client.
        :param pulumi.Input[str] form_template: HTML form template to be used for WS-Federation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: Types of grants that this client is authorized to use.
        :param pulumi.Input[str] initiate_login_uri: Initiate login URI, must be HTTPS.
        :param pulumi.Input[bool] is_first_party: Indicates whether this client is a first-party client.
        :param pulumi.Input[bool] is_token_endpoint_ip_header_trusted: Indicates whether the token endpoint IP header is trusted.
        :param pulumi.Input['GlobalClientJwtConfigurationArgs'] jwt_configuration: Configuration settings for the JWTs issued for this client.
        :param pulumi.Input[str] logo_uri: URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        :param pulumi.Input['GlobalClientMobileArgs'] mobile: Additional configuration for native mobile apps.
        :param pulumi.Input[str] name: Name of the client.
        :param pulumi.Input['GlobalClientNativeSocialLoginArgs'] native_social_login: Configuration settings to toggle native social login for mobile native applications. Once this is set it must stay set, with both resources set to `false` in order to change the `app_type`.
        :param pulumi.Input[bool] oidc_conformant: Indicates whether this client will conform to strict OIDC specifications.
        :param pulumi.Input[str] organization_require_behavior: Defines how to proceed during an authentication transaction when `organization_usage = "require"`. Can be `no_prompt` (default) or `pre_login_prompt`.
        :param pulumi.Input[str] organization_usage: Defines how to proceed during an authentication transaction with regards to an organization. Can be `deny` (default), `allow` or `require`.
        :param pulumi.Input['GlobalClientRefreshTokenArgs'] refresh_token: Configuration settings for the refresh tokens issued for this client.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]] signing_keys: List containing a map of the public cert of the signing key and the public cert of the signing key in PKCS7.
        :param pulumi.Input[bool] sso: Applies only to SSO clients and determines whether Auth0 will handle Single Sign-On (true) or whether the identity provider will (false).
        :param pulumi.Input[bool] sso_disabled: Indicates whether or not SSO is disabled.
        :param pulumi.Input[str] token_endpoint_auth_method: Defines the requested authentication method for the token endpoint. Options include `none` (public client without a client secret), `client_secret_post` (client uses HTTP POST parameters), `client_secret_basic` (client uses HTTP Basic).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] web_origins: URLs that represent valid web origins for use with web message response mode.
        """
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if allowed_clients is not None:
            pulumi.set(__self__, "allowed_clients", allowed_clients)
        if allowed_logout_urls is not None:
            pulumi.set(__self__, "allowed_logout_urls", allowed_logout_urls)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if app_type is not None:
            pulumi.set(__self__, "app_type", app_type)
        if callbacks is not None:
            pulumi.set(__self__, "callbacks", callbacks)
        if client_aliases is not None:
            pulumi.set(__self__, "client_aliases", client_aliases)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_metadata is not None:
            pulumi.set(__self__, "client_metadata", client_metadata)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if client_secret_rotation_trigger is not None:
            pulumi.set(__self__, "client_secret_rotation_trigger", client_secret_rotation_trigger)
        if cross_origin_auth is not None:
            pulumi.set(__self__, "cross_origin_auth", cross_origin_auth)
        if cross_origin_loc is not None:
            pulumi.set(__self__, "cross_origin_loc", cross_origin_loc)
        if custom_login_page is not None:
            pulumi.set(__self__, "custom_login_page", custom_login_page)
        if custom_login_page_on is not None:
            pulumi.set(__self__, "custom_login_page_on", custom_login_page_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if form_template is not None:
            pulumi.set(__self__, "form_template", form_template)
        if grant_types is not None:
            pulumi.set(__self__, "grant_types", grant_types)
        if initiate_login_uri is not None:
            pulumi.set(__self__, "initiate_login_uri", initiate_login_uri)
        if is_first_party is not None:
            pulumi.set(__self__, "is_first_party", is_first_party)
        if is_token_endpoint_ip_header_trusted is not None:
            pulumi.set(__self__, "is_token_endpoint_ip_header_trusted", is_token_endpoint_ip_header_trusted)
        if jwt_configuration is not None:
            pulumi.set(__self__, "jwt_configuration", jwt_configuration)
        if logo_uri is not None:
            pulumi.set(__self__, "logo_uri", logo_uri)
        if mobile is not None:
            pulumi.set(__self__, "mobile", mobile)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if native_social_login is not None:
            pulumi.set(__self__, "native_social_login", native_social_login)
        if oidc_conformant is not None:
            pulumi.set(__self__, "oidc_conformant", oidc_conformant)
        if organization_require_behavior is not None:
            pulumi.set(__self__, "organization_require_behavior", organization_require_behavior)
        if organization_usage is not None:
            pulumi.set(__self__, "organization_usage", organization_usage)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if signing_keys is not None:
            pulumi.set(__self__, "signing_keys", signing_keys)
        if sso is not None:
            pulumi.set(__self__, "sso", sso)
        if sso_disabled is not None:
            pulumi.set(__self__, "sso_disabled", sso_disabled)
        if token_endpoint_auth_method is not None:
            pulumi.set(__self__, "token_endpoint_auth_method", token_endpoint_auth_method)
        if web_origins is not None:
            pulumi.set(__self__, "web_origins", web_origins)

    @property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input['GlobalClientAddonsArgs']]:
        """
        Addons enabled for this client and their associated configurations.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input['GlobalClientAddonsArgs']]):
        pulumi.set(self, "addons", value)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of applications ID's that will be allowed to make delegation request. By default, all applications will be allowed.
        """
        return pulumi.get(self, "allowed_clients")

    @allowed_clients.setter
    def allowed_clients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_clients", value)

    @property
    @pulumi.getter(name="allowedLogoutUrls")
    def allowed_logout_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that Auth0 may redirect to after logout.
        """
        return pulumi.get(self, "allowed_logout_urls")

    @allowed_logout_urls.setter
    def allowed_logout_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_logout_urls", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="appType")
    def app_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of application the client represents. Possible values are: `native`, `spa`, `regular_web`, `non_interactive`, `sso_integration`. Specific SSO integrations types accepted as well are: `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        """
        return pulumi.get(self, "app_type")

    @app_type.setter
    def app_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_type", value)

    @property
    @pulumi.getter
    def callbacks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        """
        return pulumi.get(self, "callbacks")

    @callbacks.setter
    def callbacks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "callbacks", value)

    @property
    @pulumi.getter(name="clientAliases")
    def client_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of audiences/realms for SAML protocol. Used by the wsfed addon.
        """
        return pulumi.get(self, "client_aliases")

    @client_aliases.setter
    def client_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "client_aliases", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the client.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientMetadata")
    def client_metadata(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Metadata associated with the client, in the form of an object with string values (max 255 chars). Maximum of 10 metadata properties allowed. Field names (max 255 chars) are alphanumeric and may only include the following special characters: `:,-+=_*?"/\\()<>@ [Tab] [Space]`.
        """
        return pulumi.get(self, "client_metadata")

    @client_metadata.setter
    def client_metadata(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "client_metadata", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Secret for the client. Keep this private. To access this attribute you need to add the `read:client_keys` scope to the
        Terraform client. Otherwise, the attribute will contain an empty string.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="clientSecretRotationTrigger")
    def client_secret_rotation_trigger(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Custom metadata for the rotation. For more info: [rotate-client-secret](https://auth0.com/docs/get-started/applications/rotate-client-secret).
        """
        return pulumi.get(self, "client_secret_rotation_trigger")

    @client_secret_rotation_trigger.setter
    def client_secret_rotation_trigger(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "client_secret_rotation_trigger", value)

    @property
    @pulumi.getter(name="crossOriginAuth")
    def cross_origin_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this client can be used to make cross-origin authentication requests (true) or it is not allowed to make such requests (false).
        """
        return pulumi.get(self, "cross_origin_auth")

    @cross_origin_auth.setter
    def cross_origin_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cross_origin_auth", value)

    @property
    @pulumi.getter(name="crossOriginLoc")
    def cross_origin_loc(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the location in your site where the cross-origin verification takes place for the cross-origin auth flow when performing authentication in your own domain instead of Auth0 Universal Login page.
        """
        return pulumi.get(self, "cross_origin_loc")

    @cross_origin_loc.setter
    def cross_origin_loc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_origin_loc", value)

    @property
    @pulumi.getter(name="customLoginPage")
    def custom_login_page(self) -> Optional[pulumi.Input[str]]:
        """
        The content (HTML, CSS, JS) of the custom login page.
        """
        return pulumi.get(self, "custom_login_page")

    @custom_login_page.setter
    def custom_login_page(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_login_page", value)

    @property
    @pulumi.getter(name="customLoginPageOn")
    def custom_login_page_on(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether a custom login page is to be used.
        """
        return pulumi.get(self, "custom_login_page_on")

    @custom_login_page_on.setter
    def custom_login_page_on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_login_page_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the purpose of the client.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Encryption used for WS-Fed responses with this client.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="formTemplate")
    def form_template(self) -> Optional[pulumi.Input[str]]:
        """
        HTML form template to be used for WS-Federation.
        """
        return pulumi.get(self, "form_template")

    @form_template.setter
    def form_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "form_template", value)

    @property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Types of grants that this client is authorized to use.
        """
        return pulumi.get(self, "grant_types")

    @grant_types.setter
    def grant_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "grant_types", value)

    @property
    @pulumi.getter(name="initiateLoginUri")
    def initiate_login_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Initiate login URI, must be HTTPS.
        """
        return pulumi.get(self, "initiate_login_uri")

    @initiate_login_uri.setter
    def initiate_login_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initiate_login_uri", value)

    @property
    @pulumi.getter(name="isFirstParty")
    def is_first_party(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this client is a first-party client.
        """
        return pulumi.get(self, "is_first_party")

    @is_first_party.setter
    def is_first_party(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_first_party", value)

    @property
    @pulumi.getter(name="isTokenEndpointIpHeaderTrusted")
    def is_token_endpoint_ip_header_trusted(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the token endpoint IP header is trusted.
        """
        return pulumi.get(self, "is_token_endpoint_ip_header_trusted")

    @is_token_endpoint_ip_header_trusted.setter
    def is_token_endpoint_ip_header_trusted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_token_endpoint_ip_header_trusted", value)

    @property
    @pulumi.getter(name="jwtConfiguration")
    def jwt_configuration(self) -> Optional[pulumi.Input['GlobalClientJwtConfigurationArgs']]:
        """
        Configuration settings for the JWTs issued for this client.
        """
        return pulumi.get(self, "jwt_configuration")

    @jwt_configuration.setter
    def jwt_configuration(self, value: Optional[pulumi.Input['GlobalClientJwtConfigurationArgs']]):
        pulumi.set(self, "jwt_configuration", value)

    @property
    @pulumi.getter(name="logoUri")
    def logo_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        """
        return pulumi.get(self, "logo_uri")

    @logo_uri.setter
    def logo_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_uri", value)

    @property
    @pulumi.getter
    def mobile(self) -> Optional[pulumi.Input['GlobalClientMobileArgs']]:
        """
        Additional configuration for native mobile apps.
        """
        return pulumi.get(self, "mobile")

    @mobile.setter
    def mobile(self, value: Optional[pulumi.Input['GlobalClientMobileArgs']]):
        pulumi.set(self, "mobile", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the client.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nativeSocialLogin")
    def native_social_login(self) -> Optional[pulumi.Input['GlobalClientNativeSocialLoginArgs']]:
        """
        Configuration settings to toggle native social login for mobile native applications. Once this is set it must stay set, with both resources set to `false` in order to change the `app_type`.
        """
        return pulumi.get(self, "native_social_login")

    @native_social_login.setter
    def native_social_login(self, value: Optional[pulumi.Input['GlobalClientNativeSocialLoginArgs']]):
        pulumi.set(self, "native_social_login", value)

    @property
    @pulumi.getter(name="oidcConformant")
    def oidc_conformant(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this client will conform to strict OIDC specifications.
        """
        return pulumi.get(self, "oidc_conformant")

    @oidc_conformant.setter
    def oidc_conformant(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "oidc_conformant", value)

    @property
    @pulumi.getter(name="organizationRequireBehavior")
    def organization_require_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Defines how to proceed during an authentication transaction when `organization_usage = "require"`. Can be `no_prompt` (default) or `pre_login_prompt`.
        """
        return pulumi.get(self, "organization_require_behavior")

    @organization_require_behavior.setter
    def organization_require_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_require_behavior", value)

    @property
    @pulumi.getter(name="organizationUsage")
    def organization_usage(self) -> Optional[pulumi.Input[str]]:
        """
        Defines how to proceed during an authentication transaction with regards to an organization. Can be `deny` (default), `allow` or `require`.
        """
        return pulumi.get(self, "organization_usage")

    @organization_usage.setter
    def organization_usage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_usage", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input['GlobalClientRefreshTokenArgs']]:
        """
        Configuration settings for the refresh tokens issued for this client.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input['GlobalClientRefreshTokenArgs']]):
        pulumi.set(self, "refresh_token", value)

    @property
    @pulumi.getter(name="signingKeys")
    def signing_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]]:
        """
        List containing a map of the public cert of the signing key and the public cert of the signing key in PKCS7.
        """
        return pulumi.get(self, "signing_keys")

    @signing_keys.setter
    def signing_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]]):
        pulumi.set(self, "signing_keys", value)

    @property
    @pulumi.getter
    def sso(self) -> Optional[pulumi.Input[bool]]:
        """
        Applies only to SSO clients and determines whether Auth0 will handle Single Sign-On (true) or whether the identity provider will (false).
        """
        return pulumi.get(self, "sso")

    @sso.setter
    def sso(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sso", value)

    @property
    @pulumi.getter(name="ssoDisabled")
    def sso_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not SSO is disabled.
        """
        return pulumi.get(self, "sso_disabled")

    @sso_disabled.setter
    def sso_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sso_disabled", value)

    @property
    @pulumi.getter(name="tokenEndpointAuthMethod")
    def token_endpoint_auth_method(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the requested authentication method for the token endpoint. Options include `none` (public client without a client secret), `client_secret_post` (client uses HTTP POST parameters), `client_secret_basic` (client uses HTTP Basic).
        """
        return pulumi.get(self, "token_endpoint_auth_method")

    @token_endpoint_auth_method.setter
    def token_endpoint_auth_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_endpoint_auth_method", value)

    @property
    @pulumi.getter(name="webOrigins")
    def web_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that represent valid web origins for use with web message response mode.
        """
        return pulumi.get(self, "web_origins")

    @web_origins.setter
    def web_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "web_origins", value)


class GlobalClient(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[pulumi.InputType['GlobalClientAddonsArgs']]] = None,
                 allowed_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_type: Optional[pulumi.Input[str]] = None,
                 callbacks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 client_secret_rotation_trigger: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cross_origin_auth: Optional[pulumi.Input[bool]] = None,
                 cross_origin_loc: Optional[pulumi.Input[str]] = None,
                 custom_login_page: Optional[pulumi.Input[str]] = None,
                 custom_login_page_on: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 form_template: Optional[pulumi.Input[str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 initiate_login_uri: Optional[pulumi.Input[str]] = None,
                 is_first_party: Optional[pulumi.Input[bool]] = None,
                 is_token_endpoint_ip_header_trusted: Optional[pulumi.Input[bool]] = None,
                 jwt_configuration: Optional[pulumi.Input[pulumi.InputType['GlobalClientJwtConfigurationArgs']]] = None,
                 logo_uri: Optional[pulumi.Input[str]] = None,
                 mobile: Optional[pulumi.Input[pulumi.InputType['GlobalClientMobileArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_social_login: Optional[pulumi.Input[pulumi.InputType['GlobalClientNativeSocialLoginArgs']]] = None,
                 oidc_conformant: Optional[pulumi.Input[bool]] = None,
                 organization_require_behavior: Optional[pulumi.Input[str]] = None,
                 organization_usage: Optional[pulumi.Input[str]] = None,
                 refresh_token: Optional[pulumi.Input[pulumi.InputType['GlobalClientRefreshTokenArgs']]] = None,
                 signing_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]] = None,
                 sso: Optional[pulumi.Input[bool]] = None,
                 sso_disabled: Optional[pulumi.Input[bool]] = None,
                 token_endpoint_auth_method: Optional[pulumi.Input[str]] = None,
                 web_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Use a tenant's global Auth0 Application client.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        global_ = auth0.GlobalClient("global",
            callbacks=["http://somehostname.com/a/callback"],
            custom_login_page=\"\"\"<html>
            <head><title>My Custom Login Page</title></head>
            <body>
                I should probably have a login form here
            </body>
        </html>

        \"\"\",
            custom_login_page_on=True)
        ```

        ## Import

        The auth0_global_client can be imported using the global client's ID. # You can find the ID of the global client by going to the [API Explorer](https://auth0.com/docs/api/management/v2#!/Clients/get_clients) and fetching the clients that have `"global"true`. # Example

        ```sh
         $ pulumi import auth0:index/globalClient:GlobalClient global XaiyAXXXYdXXXXnqjj8HXXXXXT5titww
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['GlobalClientAddonsArgs']] addons: Addons enabled for this client and their associated configurations.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_clients: List of applications ID's that will be allowed to make delegation request. By default, all applications will be allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        :param pulumi.Input[str] app_type: Type of application the client represents. Possible values are: `native`, `spa`, `regular_web`, `non_interactive`, `sso_integration`. Specific SSO integrations types accepted as well are: `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] callbacks: URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_aliases: List of audiences/realms for SAML protocol. Used by the wsfed addon.
        :param pulumi.Input[str] client_id: The ID of the client.
        :param pulumi.Input[Mapping[str, Any]] client_metadata: Metadata associated with the client, in the form of an object with string values (max 255 chars). Maximum of 10 metadata properties allowed. Field names (max 255 chars) are alphanumeric and may only include the following special characters: `:,-+=_*?"/\\()<>@ [Tab] [Space]`.
        :param pulumi.Input[str] client_secret: Secret for the client. Keep this private. To access this attribute you need to add the `read:client_keys` scope to the
               Terraform client. Otherwise, the attribute will contain an empty string.
        :param pulumi.Input[Mapping[str, Any]] client_secret_rotation_trigger: Custom metadata for the rotation. For more info: [rotate-client-secret](https://auth0.com/docs/get-started/applications/rotate-client-secret).
        :param pulumi.Input[bool] cross_origin_auth: Whether this client can be used to make cross-origin authentication requests (true) or it is not allowed to make such requests (false).
        :param pulumi.Input[str] cross_origin_loc: URL of the location in your site where the cross-origin verification takes place for the cross-origin auth flow when performing authentication in your own domain instead of Auth0 Universal Login page.
        :param pulumi.Input[str] custom_login_page: The content (HTML, CSS, JS) of the custom login page.
        :param pulumi.Input[bool] custom_login_page_on: Indicates whether a custom login page is to be used.
        :param pulumi.Input[str] description: Description of the purpose of the client.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] encryption_key: Encryption used for WS-Fed responses with this client.
        :param pulumi.Input[str] form_template: HTML form template to be used for WS-Federation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: Types of grants that this client is authorized to use.
        :param pulumi.Input[str] initiate_login_uri: Initiate login URI, must be HTTPS.
        :param pulumi.Input[bool] is_first_party: Indicates whether this client is a first-party client.
        :param pulumi.Input[bool] is_token_endpoint_ip_header_trusted: Indicates whether the token endpoint IP header is trusted.
        :param pulumi.Input[pulumi.InputType['GlobalClientJwtConfigurationArgs']] jwt_configuration: Configuration settings for the JWTs issued for this client.
        :param pulumi.Input[str] logo_uri: URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        :param pulumi.Input[pulumi.InputType['GlobalClientMobileArgs']] mobile: Additional configuration for native mobile apps.
        :param pulumi.Input[str] name: Name of the client.
        :param pulumi.Input[pulumi.InputType['GlobalClientNativeSocialLoginArgs']] native_social_login: Configuration settings to toggle native social login for mobile native applications. Once this is set it must stay set, with both resources set to `false` in order to change the `app_type`.
        :param pulumi.Input[bool] oidc_conformant: Indicates whether this client will conform to strict OIDC specifications.
        :param pulumi.Input[str] organization_require_behavior: Defines how to proceed during an authentication transaction when `organization_usage = "require"`. Can be `no_prompt` (default) or `pre_login_prompt`.
        :param pulumi.Input[str] organization_usage: Defines how to proceed during an authentication transaction with regards to an organization. Can be `deny` (default), `allow` or `require`.
        :param pulumi.Input[pulumi.InputType['GlobalClientRefreshTokenArgs']] refresh_token: Configuration settings for the refresh tokens issued for this client.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]] signing_keys: List containing a map of the public cert of the signing key and the public cert of the signing key in PKCS7.
        :param pulumi.Input[bool] sso: Applies only to SSO clients and determines whether Auth0 will handle Single Sign-On (true) or whether the identity provider will (false).
        :param pulumi.Input[bool] sso_disabled: Indicates whether or not SSO is disabled.
        :param pulumi.Input[str] token_endpoint_auth_method: Defines the requested authentication method for the token endpoint. Options include `none` (public client without a client secret), `client_secret_post` (client uses HTTP POST parameters), `client_secret_basic` (client uses HTTP Basic).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] web_origins: URLs that represent valid web origins for use with web message response mode.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GlobalClientArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use a tenant's global Auth0 Application client.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        global_ = auth0.GlobalClient("global",
            callbacks=["http://somehostname.com/a/callback"],
            custom_login_page=\"\"\"<html>
            <head><title>My Custom Login Page</title></head>
            <body>
                I should probably have a login form here
            </body>
        </html>

        \"\"\",
            custom_login_page_on=True)
        ```

        ## Import

        The auth0_global_client can be imported using the global client's ID. # You can find the ID of the global client by going to the [API Explorer](https://auth0.com/docs/api/management/v2#!/Clients/get_clients) and fetching the clients that have `"global"true`. # Example

        ```sh
         $ pulumi import auth0:index/globalClient:GlobalClient global XaiyAXXXYdXXXXnqjj8HXXXXXT5titww
        ```

        :param str resource_name: The name of the resource.
        :param GlobalClientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlobalClientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[pulumi.InputType['GlobalClientAddonsArgs']]] = None,
                 allowed_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_type: Optional[pulumi.Input[str]] = None,
                 callbacks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 client_secret_rotation_trigger: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cross_origin_auth: Optional[pulumi.Input[bool]] = None,
                 cross_origin_loc: Optional[pulumi.Input[str]] = None,
                 custom_login_page: Optional[pulumi.Input[str]] = None,
                 custom_login_page_on: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 form_template: Optional[pulumi.Input[str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 initiate_login_uri: Optional[pulumi.Input[str]] = None,
                 is_first_party: Optional[pulumi.Input[bool]] = None,
                 is_token_endpoint_ip_header_trusted: Optional[pulumi.Input[bool]] = None,
                 jwt_configuration: Optional[pulumi.Input[pulumi.InputType['GlobalClientJwtConfigurationArgs']]] = None,
                 logo_uri: Optional[pulumi.Input[str]] = None,
                 mobile: Optional[pulumi.Input[pulumi.InputType['GlobalClientMobileArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_social_login: Optional[pulumi.Input[pulumi.InputType['GlobalClientNativeSocialLoginArgs']]] = None,
                 oidc_conformant: Optional[pulumi.Input[bool]] = None,
                 organization_require_behavior: Optional[pulumi.Input[str]] = None,
                 organization_usage: Optional[pulumi.Input[str]] = None,
                 refresh_token: Optional[pulumi.Input[pulumi.InputType['GlobalClientRefreshTokenArgs']]] = None,
                 signing_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]] = None,
                 sso: Optional[pulumi.Input[bool]] = None,
                 sso_disabled: Optional[pulumi.Input[bool]] = None,
                 token_endpoint_auth_method: Optional[pulumi.Input[str]] = None,
                 web_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlobalClientArgs.__new__(GlobalClientArgs)

            __props__.__dict__["addons"] = addons
            __props__.__dict__["allowed_clients"] = allowed_clients
            __props__.__dict__["allowed_logout_urls"] = allowed_logout_urls
            __props__.__dict__["allowed_origins"] = allowed_origins
            __props__.__dict__["app_type"] = app_type
            __props__.__dict__["callbacks"] = callbacks
            __props__.__dict__["client_aliases"] = client_aliases
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_metadata"] = client_metadata
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["client_secret_rotation_trigger"] = client_secret_rotation_trigger
            __props__.__dict__["cross_origin_auth"] = cross_origin_auth
            __props__.__dict__["cross_origin_loc"] = cross_origin_loc
            __props__.__dict__["custom_login_page"] = custom_login_page
            __props__.__dict__["custom_login_page_on"] = custom_login_page_on
            __props__.__dict__["description"] = description
            __props__.__dict__["encryption_key"] = encryption_key
            __props__.__dict__["form_template"] = form_template
            __props__.__dict__["grant_types"] = grant_types
            __props__.__dict__["initiate_login_uri"] = initiate_login_uri
            __props__.__dict__["is_first_party"] = is_first_party
            __props__.__dict__["is_token_endpoint_ip_header_trusted"] = is_token_endpoint_ip_header_trusted
            __props__.__dict__["jwt_configuration"] = jwt_configuration
            __props__.__dict__["logo_uri"] = logo_uri
            __props__.__dict__["mobile"] = mobile
            __props__.__dict__["name"] = name
            __props__.__dict__["native_social_login"] = native_social_login
            __props__.__dict__["oidc_conformant"] = oidc_conformant
            __props__.__dict__["organization_require_behavior"] = organization_require_behavior
            __props__.__dict__["organization_usage"] = organization_usage
            __props__.__dict__["refresh_token"] = refresh_token
            __props__.__dict__["signing_keys"] = None if signing_keys is None else pulumi.Output.secret(signing_keys)
            __props__.__dict__["sso"] = sso
            __props__.__dict__["sso_disabled"] = sso_disabled
            __props__.__dict__["token_endpoint_auth_method"] = token_endpoint_auth_method
            __props__.__dict__["web_origins"] = web_origins
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret", "signingKeys"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(GlobalClient, __self__).__init__(
            'auth0:index/globalClient:GlobalClient',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addons: Optional[pulumi.Input[pulumi.InputType['GlobalClientAddonsArgs']]] = None,
            allowed_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            app_type: Optional[pulumi.Input[str]] = None,
            callbacks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            client_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            client_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            client_secret: Optional[pulumi.Input[str]] = None,
            client_secret_rotation_trigger: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            cross_origin_auth: Optional[pulumi.Input[bool]] = None,
            cross_origin_loc: Optional[pulumi.Input[str]] = None,
            custom_login_page: Optional[pulumi.Input[str]] = None,
            custom_login_page_on: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            encryption_key: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            form_template: Optional[pulumi.Input[str]] = None,
            grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            initiate_login_uri: Optional[pulumi.Input[str]] = None,
            is_first_party: Optional[pulumi.Input[bool]] = None,
            is_token_endpoint_ip_header_trusted: Optional[pulumi.Input[bool]] = None,
            jwt_configuration: Optional[pulumi.Input[pulumi.InputType['GlobalClientJwtConfigurationArgs']]] = None,
            logo_uri: Optional[pulumi.Input[str]] = None,
            mobile: Optional[pulumi.Input[pulumi.InputType['GlobalClientMobileArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            native_social_login: Optional[pulumi.Input[pulumi.InputType['GlobalClientNativeSocialLoginArgs']]] = None,
            oidc_conformant: Optional[pulumi.Input[bool]] = None,
            organization_require_behavior: Optional[pulumi.Input[str]] = None,
            organization_usage: Optional[pulumi.Input[str]] = None,
            refresh_token: Optional[pulumi.Input[pulumi.InputType['GlobalClientRefreshTokenArgs']]] = None,
            signing_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]] = None,
            sso: Optional[pulumi.Input[bool]] = None,
            sso_disabled: Optional[pulumi.Input[bool]] = None,
            token_endpoint_auth_method: Optional[pulumi.Input[str]] = None,
            web_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'GlobalClient':
        """
        Get an existing GlobalClient resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['GlobalClientAddonsArgs']] addons: Addons enabled for this client and their associated configurations.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_clients: List of applications ID's that will be allowed to make delegation request. By default, all applications will be allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        :param pulumi.Input[str] app_type: Type of application the client represents. Possible values are: `native`, `spa`, `regular_web`, `non_interactive`, `sso_integration`. Specific SSO integrations types accepted as well are: `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] callbacks: URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_aliases: List of audiences/realms for SAML protocol. Used by the wsfed addon.
        :param pulumi.Input[str] client_id: The ID of the client.
        :param pulumi.Input[Mapping[str, Any]] client_metadata: Metadata associated with the client, in the form of an object with string values (max 255 chars). Maximum of 10 metadata properties allowed. Field names (max 255 chars) are alphanumeric and may only include the following special characters: `:,-+=_*?"/\\()<>@ [Tab] [Space]`.
        :param pulumi.Input[str] client_secret: Secret for the client. Keep this private. To access this attribute you need to add the `read:client_keys` scope to the
               Terraform client. Otherwise, the attribute will contain an empty string.
        :param pulumi.Input[Mapping[str, Any]] client_secret_rotation_trigger: Custom metadata for the rotation. For more info: [rotate-client-secret](https://auth0.com/docs/get-started/applications/rotate-client-secret).
        :param pulumi.Input[bool] cross_origin_auth: Whether this client can be used to make cross-origin authentication requests (true) or it is not allowed to make such requests (false).
        :param pulumi.Input[str] cross_origin_loc: URL of the location in your site where the cross-origin verification takes place for the cross-origin auth flow when performing authentication in your own domain instead of Auth0 Universal Login page.
        :param pulumi.Input[str] custom_login_page: The content (HTML, CSS, JS) of the custom login page.
        :param pulumi.Input[bool] custom_login_page_on: Indicates whether a custom login page is to be used.
        :param pulumi.Input[str] description: Description of the purpose of the client.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] encryption_key: Encryption used for WS-Fed responses with this client.
        :param pulumi.Input[str] form_template: HTML form template to be used for WS-Federation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: Types of grants that this client is authorized to use.
        :param pulumi.Input[str] initiate_login_uri: Initiate login URI, must be HTTPS.
        :param pulumi.Input[bool] is_first_party: Indicates whether this client is a first-party client.
        :param pulumi.Input[bool] is_token_endpoint_ip_header_trusted: Indicates whether the token endpoint IP header is trusted.
        :param pulumi.Input[pulumi.InputType['GlobalClientJwtConfigurationArgs']] jwt_configuration: Configuration settings for the JWTs issued for this client.
        :param pulumi.Input[str] logo_uri: URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        :param pulumi.Input[pulumi.InputType['GlobalClientMobileArgs']] mobile: Additional configuration for native mobile apps.
        :param pulumi.Input[str] name: Name of the client.
        :param pulumi.Input[pulumi.InputType['GlobalClientNativeSocialLoginArgs']] native_social_login: Configuration settings to toggle native social login for mobile native applications. Once this is set it must stay set, with both resources set to `false` in order to change the `app_type`.
        :param pulumi.Input[bool] oidc_conformant: Indicates whether this client will conform to strict OIDC specifications.
        :param pulumi.Input[str] organization_require_behavior: Defines how to proceed during an authentication transaction when `organization_usage = "require"`. Can be `no_prompt` (default) or `pre_login_prompt`.
        :param pulumi.Input[str] organization_usage: Defines how to proceed during an authentication transaction with regards to an organization. Can be `deny` (default), `allow` or `require`.
        :param pulumi.Input[pulumi.InputType['GlobalClientRefreshTokenArgs']] refresh_token: Configuration settings for the refresh tokens issued for this client.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]] signing_keys: List containing a map of the public cert of the signing key and the public cert of the signing key in PKCS7.
        :param pulumi.Input[bool] sso: Applies only to SSO clients and determines whether Auth0 will handle Single Sign-On (true) or whether the identity provider will (false).
        :param pulumi.Input[bool] sso_disabled: Indicates whether or not SSO is disabled.
        :param pulumi.Input[str] token_endpoint_auth_method: Defines the requested authentication method for the token endpoint. Options include `none` (public client without a client secret), `client_secret_post` (client uses HTTP POST parameters), `client_secret_basic` (client uses HTTP Basic).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] web_origins: URLs that represent valid web origins for use with web message response mode.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlobalClientState.__new__(_GlobalClientState)

        __props__.__dict__["addons"] = addons
        __props__.__dict__["allowed_clients"] = allowed_clients
        __props__.__dict__["allowed_logout_urls"] = allowed_logout_urls
        __props__.__dict__["allowed_origins"] = allowed_origins
        __props__.__dict__["app_type"] = app_type
        __props__.__dict__["callbacks"] = callbacks
        __props__.__dict__["client_aliases"] = client_aliases
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_metadata"] = client_metadata
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["client_secret_rotation_trigger"] = client_secret_rotation_trigger
        __props__.__dict__["cross_origin_auth"] = cross_origin_auth
        __props__.__dict__["cross_origin_loc"] = cross_origin_loc
        __props__.__dict__["custom_login_page"] = custom_login_page
        __props__.__dict__["custom_login_page_on"] = custom_login_page_on
        __props__.__dict__["description"] = description
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["form_template"] = form_template
        __props__.__dict__["grant_types"] = grant_types
        __props__.__dict__["initiate_login_uri"] = initiate_login_uri
        __props__.__dict__["is_first_party"] = is_first_party
        __props__.__dict__["is_token_endpoint_ip_header_trusted"] = is_token_endpoint_ip_header_trusted
        __props__.__dict__["jwt_configuration"] = jwt_configuration
        __props__.__dict__["logo_uri"] = logo_uri
        __props__.__dict__["mobile"] = mobile
        __props__.__dict__["name"] = name
        __props__.__dict__["native_social_login"] = native_social_login
        __props__.__dict__["oidc_conformant"] = oidc_conformant
        __props__.__dict__["organization_require_behavior"] = organization_require_behavior
        __props__.__dict__["organization_usage"] = organization_usage
        __props__.__dict__["refresh_token"] = refresh_token
        __props__.__dict__["signing_keys"] = signing_keys
        __props__.__dict__["sso"] = sso
        __props__.__dict__["sso_disabled"] = sso_disabled
        __props__.__dict__["token_endpoint_auth_method"] = token_endpoint_auth_method
        __props__.__dict__["web_origins"] = web_origins
        return GlobalClient(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def addons(self) -> pulumi.Output['outputs.GlobalClientAddons']:
        """
        Addons enabled for this client and their associated configurations.
        """
        return pulumi.get(self, "addons")

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> pulumi.Output[Sequence[str]]:
        """
        List of applications ID's that will be allowed to make delegation request. By default, all applications will be allowed.
        """
        return pulumi.get(self, "allowed_clients")

    @property
    @pulumi.getter(name="allowedLogoutUrls")
    def allowed_logout_urls(self) -> pulumi.Output[Sequence[str]]:
        """
        URLs that Auth0 may redirect to after logout.
        """
        return pulumi.get(self, "allowed_logout_urls")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Output[Sequence[str]]:
        """
        URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="appType")
    def app_type(self) -> pulumi.Output[str]:
        """
        Type of application the client represents. Possible values are: `native`, `spa`, `regular_web`, `non_interactive`, `sso_integration`. Specific SSO integrations types accepted as well are: `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        """
        return pulumi.get(self, "app_type")

    @property
    @pulumi.getter
    def callbacks(self) -> pulumi.Output[Sequence[str]]:
        """
        URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        """
        return pulumi.get(self, "callbacks")

    @property
    @pulumi.getter(name="clientAliases")
    def client_aliases(self) -> pulumi.Output[Sequence[str]]:
        """
        List of audiences/realms for SAML protocol. Used by the wsfed addon.
        """
        return pulumi.get(self, "client_aliases")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        The ID of the client.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientMetadata")
    def client_metadata(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Metadata associated with the client, in the form of an object with string values (max 255 chars). Maximum of 10 metadata properties allowed. Field names (max 255 chars) are alphanumeric and may only include the following special characters: `:,-+=_*?"/\\()<>@ [Tab] [Space]`.
        """
        return pulumi.get(self, "client_metadata")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[str]:
        """
        Secret for the client. Keep this private. To access this attribute you need to add the `read:client_keys` scope to the
        Terraform client. Otherwise, the attribute will contain an empty string.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="clientSecretRotationTrigger")
    def client_secret_rotation_trigger(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Custom metadata for the rotation. For more info: [rotate-client-secret](https://auth0.com/docs/get-started/applications/rotate-client-secret).
        """
        return pulumi.get(self, "client_secret_rotation_trigger")

    @property
    @pulumi.getter(name="crossOriginAuth")
    def cross_origin_auth(self) -> pulumi.Output[bool]:
        """
        Whether this client can be used to make cross-origin authentication requests (true) or it is not allowed to make such requests (false).
        """
        return pulumi.get(self, "cross_origin_auth")

    @property
    @pulumi.getter(name="crossOriginLoc")
    def cross_origin_loc(self) -> pulumi.Output[str]:
        """
        URL of the location in your site where the cross-origin verification takes place for the cross-origin auth flow when performing authentication in your own domain instead of Auth0 Universal Login page.
        """
        return pulumi.get(self, "cross_origin_loc")

    @property
    @pulumi.getter(name="customLoginPage")
    def custom_login_page(self) -> pulumi.Output[str]:
        """
        The content (HTML, CSS, JS) of the custom login page.
        """
        return pulumi.get(self, "custom_login_page")

    @property
    @pulumi.getter(name="customLoginPageOn")
    def custom_login_page_on(self) -> pulumi.Output[bool]:
        """
        Indicates whether a custom login page is to be used.
        """
        return pulumi.get(self, "custom_login_page_on")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the purpose of the client.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Encryption used for WS-Fed responses with this client.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="formTemplate")
    def form_template(self) -> pulumi.Output[str]:
        """
        HTML form template to be used for WS-Federation.
        """
        return pulumi.get(self, "form_template")

    @property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> pulumi.Output[Sequence[str]]:
        """
        Types of grants that this client is authorized to use.
        """
        return pulumi.get(self, "grant_types")

    @property
    @pulumi.getter(name="initiateLoginUri")
    def initiate_login_uri(self) -> pulumi.Output[str]:
        """
        Initiate login URI, must be HTTPS.
        """
        return pulumi.get(self, "initiate_login_uri")

    @property
    @pulumi.getter(name="isFirstParty")
    def is_first_party(self) -> pulumi.Output[bool]:
        """
        Indicates whether this client is a first-party client.
        """
        return pulumi.get(self, "is_first_party")

    @property
    @pulumi.getter(name="isTokenEndpointIpHeaderTrusted")
    def is_token_endpoint_ip_header_trusted(self) -> pulumi.Output[bool]:
        """
        Indicates whether the token endpoint IP header is trusted.
        """
        return pulumi.get(self, "is_token_endpoint_ip_header_trusted")

    @property
    @pulumi.getter(name="jwtConfiguration")
    def jwt_configuration(self) -> pulumi.Output['outputs.GlobalClientJwtConfiguration']:
        """
        Configuration settings for the JWTs issued for this client.
        """
        return pulumi.get(self, "jwt_configuration")

    @property
    @pulumi.getter(name="logoUri")
    def logo_uri(self) -> pulumi.Output[str]:
        """
        URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        """
        return pulumi.get(self, "logo_uri")

    @property
    @pulumi.getter
    def mobile(self) -> pulumi.Output['outputs.GlobalClientMobile']:
        """
        Additional configuration for native mobile apps.
        """
        return pulumi.get(self, "mobile")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the client.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nativeSocialLogin")
    def native_social_login(self) -> pulumi.Output['outputs.GlobalClientNativeSocialLogin']:
        """
        Configuration settings to toggle native social login for mobile native applications. Once this is set it must stay set, with both resources set to `false` in order to change the `app_type`.
        """
        return pulumi.get(self, "native_social_login")

    @property
    @pulumi.getter(name="oidcConformant")
    def oidc_conformant(self) -> pulumi.Output[bool]:
        """
        Indicates whether this client will conform to strict OIDC specifications.
        """
        return pulumi.get(self, "oidc_conformant")

    @property
    @pulumi.getter(name="organizationRequireBehavior")
    def organization_require_behavior(self) -> pulumi.Output[str]:
        """
        Defines how to proceed during an authentication transaction when `organization_usage = "require"`. Can be `no_prompt` (default) or `pre_login_prompt`.
        """
        return pulumi.get(self, "organization_require_behavior")

    @property
    @pulumi.getter(name="organizationUsage")
    def organization_usage(self) -> pulumi.Output[str]:
        """
        Defines how to proceed during an authentication transaction with regards to an organization. Can be `deny` (default), `allow` or `require`.
        """
        return pulumi.get(self, "organization_usage")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> pulumi.Output['outputs.GlobalClientRefreshToken']:
        """
        Configuration settings for the refresh tokens issued for this client.
        """
        return pulumi.get(self, "refresh_token")

    @property
    @pulumi.getter(name="signingKeys")
    def signing_keys(self) -> pulumi.Output[Sequence[Mapping[str, Any]]]:
        """
        List containing a map of the public cert of the signing key and the public cert of the signing key in PKCS7.
        """
        return pulumi.get(self, "signing_keys")

    @property
    @pulumi.getter
    def sso(self) -> pulumi.Output[bool]:
        """
        Applies only to SSO clients and determines whether Auth0 will handle Single Sign-On (true) or whether the identity provider will (false).
        """
        return pulumi.get(self, "sso")

    @property
    @pulumi.getter(name="ssoDisabled")
    def sso_disabled(self) -> pulumi.Output[bool]:
        """
        Indicates whether or not SSO is disabled.
        """
        return pulumi.get(self, "sso_disabled")

    @property
    @pulumi.getter(name="tokenEndpointAuthMethod")
    def token_endpoint_auth_method(self) -> pulumi.Output[str]:
        """
        Defines the requested authentication method for the token endpoint. Options include `none` (public client without a client secret), `client_secret_post` (client uses HTTP POST parameters), `client_secret_basic` (client uses HTTP Basic).
        """
        return pulumi.get(self, "token_endpoint_auth_method")

    @property
    @pulumi.getter(name="webOrigins")
    def web_origins(self) -> pulumi.Output[Sequence[str]]:
        """
        URLs that represent valid web origins for use with web message response mode.
        """
        return pulumi.get(self, "web_origins")

