# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'ActionDependency',
    'ActionSecret',
    'ActionSupportedTriggers',
    'AttackProtectionBreachedPasswordDetection',
    'AttackProtectionBruteForceProtection',
    'AttackProtectionSuspiciousIpThrottling',
    'AttackProtectionSuspiciousIpThrottlingPreLogin',
    'AttackProtectionSuspiciousIpThrottlingPreUserRegistration',
    'BrandingColors',
    'BrandingFont',
    'BrandingThemeBorders',
    'BrandingThemeColors',
    'BrandingThemeFonts',
    'BrandingThemeFontsBodyText',
    'BrandingThemeFontsButtonsText',
    'BrandingThemeFontsInputLabels',
    'BrandingThemeFontsLinks',
    'BrandingThemeFontsSubtitle',
    'BrandingThemeFontsTitle',
    'BrandingThemePageBackground',
    'BrandingThemeWidget',
    'BrandingUniversalLogin',
    'ClientAddons',
    'ClientAddonsSamlp',
    'ClientJwtConfiguration',
    'ClientMobile',
    'ClientMobileAndroid',
    'ClientMobileIos',
    'ClientNativeSocialLogin',
    'ClientNativeSocialLoginApple',
    'ClientNativeSocialLoginFacebook',
    'ClientRefreshToken',
    'ConnectionOptions',
    'ConnectionOptionsGatewayAuthentication',
    'ConnectionOptionsIdpInitiated',
    'ConnectionOptionsMfa',
    'ConnectionOptionsPasswordComplexityOptions',
    'ConnectionOptionsPasswordDictionary',
    'ConnectionOptionsPasswordHistory',
    'ConnectionOptionsPasswordNoPersonalInfo',
    'ConnectionOptionsSigningKey',
    'ConnectionOptionsTotp',
    'ConnectionOptionsValidation',
    'ConnectionOptionsValidationUsername',
    'CustomDomainVerification',
    'EmailCredentials',
    'EmailSettings',
    'EmailSettingsHeaders',
    'EmailSettingsMessage',
    'GlobalClientAddons',
    'GlobalClientAddonsSamlp',
    'GlobalClientJwtConfiguration',
    'GlobalClientMobile',
    'GlobalClientMobileAndroid',
    'GlobalClientMobileIos',
    'GlobalClientNativeSocialLogin',
    'GlobalClientNativeSocialLoginApple',
    'GlobalClientNativeSocialLoginFacebook',
    'GlobalClientRefreshToken',
    'GuardianDuo',
    'GuardianPhone',
    'GuardianPhoneOptions',
    'GuardianPush',
    'GuardianPushAmazonSns',
    'GuardianPushCustomApp',
    'GuardianWebauthnPlatform',
    'GuardianWebauthnRoaming',
    'LogStreamSink',
    'OrganizationBranding',
    'ResourceServerScope',
    'RolePermission',
    'TenantChangePassword',
    'TenantErrorPage',
    'TenantFlags',
    'TenantGuardianMfaPage',
    'TenantSessionCookie',
    'TenantUniversalLogin',
    'TenantUniversalLoginColors',
    'TriggerBindingAction',
    'GetClientAddonResult',
    'GetClientAddonSamlpResult',
    'GetClientJwtConfigurationResult',
    'GetClientMobileResult',
    'GetClientMobileAndroidResult',
    'GetClientMobileIoResult',
    'GetClientNativeSocialLoginResult',
    'GetClientNativeSocialLoginAppleResult',
    'GetClientNativeSocialLoginFacebookResult',
    'GetClientRefreshTokenResult',
    'GetGlobalClientAddonResult',
    'GetGlobalClientAddonSamlpResult',
    'GetGlobalClientJwtConfigurationResult',
    'GetGlobalClientMobileResult',
    'GetGlobalClientMobileAndroidResult',
    'GetGlobalClientMobileIoResult',
    'GetGlobalClientNativeSocialLoginResult',
    'GetGlobalClientNativeSocialLoginAppleResult',
    'GetGlobalClientNativeSocialLoginFacebookResult',
    'GetGlobalClientRefreshTokenResult',
]

@pulumi.output_type
class ActionDependency(dict):
    def __init__(__self__, *,
                 name: str,
                 version: str):
        """
        :param str name: Dependency name, e.g. `lodash`.
        :param str version: Dependency version, e.g. `latest` or `4.17.21`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Dependency name, e.g. `lodash`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Dependency version, e.g. `latest` or `4.17.21`.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ActionSecret(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Secret name.
        :param str value: Secret value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Secret name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Secret value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ActionSupportedTriggers(dict):
    def __init__(__self__, *,
                 id: str,
                 version: str):
        """
        :param str id: The trigger ID.
        :param str version: The trigger version. This regulates which `runtime` versions are supported.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The trigger ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The trigger version. This regulates which `runtime` versions are supported.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class AttackProtectionBreachedPasswordDetection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminNotificationFrequencies":
            suggest = "admin_notification_frequencies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttackProtectionBreachedPasswordDetection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttackProtectionBreachedPasswordDetection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttackProtectionBreachedPasswordDetection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_notification_frequencies: Optional[Sequence[str]] = None,
                 enabled: Optional[bool] = None,
                 method: Optional[str] = None,
                 shields: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] admin_notification_frequencies: When "admin_notification" is enabled, determines how often email notifications are sent. Possible values: `immediately`, `daily`, `weekly`, `monthly`.
        :param bool enabled: Whether breached password detection is active.
        :param str method: The subscription level for breached password detection methods. Use "enhanced" to enable Credential Guard. Possible values: `standard`, `enhanced`.
        :param Sequence[str] shields: Action to take when a breached password is detected.
        """
        if admin_notification_frequencies is not None:
            pulumi.set(__self__, "admin_notification_frequencies", admin_notification_frequencies)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if shields is not None:
            pulumi.set(__self__, "shields", shields)

    @property
    @pulumi.getter(name="adminNotificationFrequencies")
    def admin_notification_frequencies(self) -> Optional[Sequence[str]]:
        """
        When "admin_notification" is enabled, determines how often email notifications are sent. Possible values: `immediately`, `daily`, `weekly`, `monthly`.
        """
        return pulumi.get(self, "admin_notification_frequencies")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether breached password detection is active.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        The subscription level for breached password detection methods. Use "enhanced" to enable Credential Guard. Possible values: `standard`, `enhanced`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def shields(self) -> Optional[Sequence[str]]:
        """
        Action to take when a breached password is detected.
        """
        return pulumi.get(self, "shields")


@pulumi.output_type
class AttackProtectionBruteForceProtection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAttempts":
            suggest = "max_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttackProtectionBruteForceProtection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttackProtectionBruteForceProtection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttackProtectionBruteForceProtection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowlists: Optional[Sequence[str]] = None,
                 enabled: Optional[bool] = None,
                 max_attempts: Optional[int] = None,
                 mode: Optional[str] = None,
                 shields: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] allowlists: List of trusted IP addresses that will not have attack protection enforced against them.
        :param bool enabled: Whether brute force attack protections are active.
        :param int max_attempts: Maximum number of unsuccessful attempts. Only available on public tenants.
        :param str mode: Determines whether the IP address is used when counting failed attempts. Possible values: `count_per_identifier_and_ip` or `count_per_identifier`.
        :param Sequence[str] shields: Action to take when a brute force protection threshold is violated. Possible values: `block`, `user_notification`
        """
        if allowlists is not None:
            pulumi.set(__self__, "allowlists", allowlists)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_attempts is not None:
            pulumi.set(__self__, "max_attempts", max_attempts)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if shields is not None:
            pulumi.set(__self__, "shields", shields)

    @property
    @pulumi.getter
    def allowlists(self) -> Optional[Sequence[str]]:
        """
        List of trusted IP addresses that will not have attack protection enforced against them.
        """
        return pulumi.get(self, "allowlists")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether brute force attack protections are active.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> Optional[int]:
        """
        Maximum number of unsuccessful attempts. Only available on public tenants.
        """
        return pulumi.get(self, "max_attempts")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Determines whether the IP address is used when counting failed attempts. Possible values: `count_per_identifier_and_ip` or `count_per_identifier`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def shields(self) -> Optional[Sequence[str]]:
        """
        Action to take when a brute force protection threshold is violated. Possible values: `block`, `user_notification`
        """
        return pulumi.get(self, "shields")


@pulumi.output_type
class AttackProtectionSuspiciousIpThrottling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preLogin":
            suggest = "pre_login"
        elif key == "preUserRegistration":
            suggest = "pre_user_registration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttackProtectionSuspiciousIpThrottling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttackProtectionSuspiciousIpThrottling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttackProtectionSuspiciousIpThrottling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowlists: Optional[Sequence[str]] = None,
                 enabled: Optional[bool] = None,
                 pre_login: Optional['outputs.AttackProtectionSuspiciousIpThrottlingPreLogin'] = None,
                 pre_user_registration: Optional['outputs.AttackProtectionSuspiciousIpThrottlingPreUserRegistration'] = None,
                 shields: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] allowlists: List of trusted IP addresses that will not have attack protection enforced against them.
        :param bool enabled: Whether suspicious IP throttling attack protections are active.
        :param 'AttackProtectionSuspiciousIpThrottlingPreLoginArgs' pre_login: Configuration options that apply before every login attempt. Only available on public tenants.
        :param 'AttackProtectionSuspiciousIpThrottlingPreUserRegistrationArgs' pre_user_registration: Configuration options that apply before every user registration attempt. Only available on public tenants.
        :param Sequence[str] shields: Action to take when a suspicious IP throttling threshold is violated. Possible values: `block`, `admin_notification`
        """
        if allowlists is not None:
            pulumi.set(__self__, "allowlists", allowlists)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if pre_login is not None:
            pulumi.set(__self__, "pre_login", pre_login)
        if pre_user_registration is not None:
            pulumi.set(__self__, "pre_user_registration", pre_user_registration)
        if shields is not None:
            pulumi.set(__self__, "shields", shields)

    @property
    @pulumi.getter
    def allowlists(self) -> Optional[Sequence[str]]:
        """
        List of trusted IP addresses that will not have attack protection enforced against them.
        """
        return pulumi.get(self, "allowlists")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether suspicious IP throttling attack protections are active.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="preLogin")
    def pre_login(self) -> Optional['outputs.AttackProtectionSuspiciousIpThrottlingPreLogin']:
        """
        Configuration options that apply before every login attempt. Only available on public tenants.
        """
        return pulumi.get(self, "pre_login")

    @property
    @pulumi.getter(name="preUserRegistration")
    def pre_user_registration(self) -> Optional['outputs.AttackProtectionSuspiciousIpThrottlingPreUserRegistration']:
        """
        Configuration options that apply before every user registration attempt. Only available on public tenants.
        """
        return pulumi.get(self, "pre_user_registration")

    @property
    @pulumi.getter
    def shields(self) -> Optional[Sequence[str]]:
        """
        Action to take when a suspicious IP throttling threshold is violated. Possible values: `block`, `admin_notification`
        """
        return pulumi.get(self, "shields")


@pulumi.output_type
class AttackProtectionSuspiciousIpThrottlingPreLogin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAttempts":
            suggest = "max_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttackProtectionSuspiciousIpThrottlingPreLogin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttackProtectionSuspiciousIpThrottlingPreLogin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttackProtectionSuspiciousIpThrottlingPreLogin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_attempts: Optional[int] = None,
                 rate: Optional[int] = None):
        if max_attempts is not None:
            pulumi.set(__self__, "max_attempts", max_attempts)
        if rate is not None:
            pulumi.set(__self__, "rate", rate)

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> Optional[int]:
        return pulumi.get(self, "max_attempts")

    @property
    @pulumi.getter
    def rate(self) -> Optional[int]:
        return pulumi.get(self, "rate")


@pulumi.output_type
class AttackProtectionSuspiciousIpThrottlingPreUserRegistration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAttempts":
            suggest = "max_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttackProtectionSuspiciousIpThrottlingPreUserRegistration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttackProtectionSuspiciousIpThrottlingPreUserRegistration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttackProtectionSuspiciousIpThrottlingPreUserRegistration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_attempts: Optional[int] = None,
                 rate: Optional[int] = None):
        if max_attempts is not None:
            pulumi.set(__self__, "max_attempts", max_attempts)
        if rate is not None:
            pulumi.set(__self__, "rate", rate)

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> Optional[int]:
        return pulumi.get(self, "max_attempts")

    @property
    @pulumi.getter
    def rate(self) -> Optional[int]:
        return pulumi.get(self, "rate")


@pulumi.output_type
class BrandingColors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pageBackground":
            suggest = "page_background"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BrandingColors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BrandingColors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BrandingColors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 page_background: Optional[str] = None,
                 primary: Optional[str] = None):
        """
        :param str page_background: Background color of login pages in hexadecimal.
        :param str primary: Primary button background color in hexadecimal.
        """
        if page_background is not None:
            pulumi.set(__self__, "page_background", page_background)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @property
    @pulumi.getter(name="pageBackground")
    def page_background(self) -> Optional[str]:
        """
        Background color of login pages in hexadecimal.
        """
        return pulumi.get(self, "page_background")

    @property
    @pulumi.getter
    def primary(self) -> Optional[str]:
        """
        Primary button background color in hexadecimal.
        """
        return pulumi.get(self, "primary")


@pulumi.output_type
class BrandingFont(dict):
    def __init__(__self__, *,
                 url: Optional[str] = None):
        """
        :param str url: URL for the custom font.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        URL for the custom font.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class BrandingThemeBorders(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buttonBorderRadius":
            suggest = "button_border_radius"
        elif key == "buttonBorderWeight":
            suggest = "button_border_weight"
        elif key == "buttonsStyle":
            suggest = "buttons_style"
        elif key == "inputBorderRadius":
            suggest = "input_border_radius"
        elif key == "inputBorderWeight":
            suggest = "input_border_weight"
        elif key == "inputsStyle":
            suggest = "inputs_style"
        elif key == "showWidgetShadow":
            suggest = "show_widget_shadow"
        elif key == "widgetBorderWeight":
            suggest = "widget_border_weight"
        elif key == "widgetCornerRadius":
            suggest = "widget_corner_radius"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BrandingThemeBorders. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BrandingThemeBorders.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BrandingThemeBorders.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 button_border_radius: float,
                 button_border_weight: float,
                 buttons_style: str,
                 input_border_radius: float,
                 input_border_weight: float,
                 inputs_style: str,
                 show_widget_shadow: bool,
                 widget_border_weight: float,
                 widget_corner_radius: float):
        """
        :param float button_border_radius: Button border radius. Value needs to be between `1` and `10`.
        :param float button_border_weight: Button border weight. Value needs to be between `0` and `10`.
        :param str buttons_style: Buttons style. Available options: `pill`, `rounded`, `sharp`.
        :param float input_border_radius: Input border radius. Value needs to be between `0` and `10`.
        :param float input_border_weight: Input border weight. Value needs to be between `0` and `3`.
        :param str inputs_style: Inputs style. Available options: `pill`, `rounded`, `sharp`.
        :param bool show_widget_shadow: Show widget shadow.
        :param float widget_border_weight: Widget border weight. Value needs to be between `0` and `10`.
        :param float widget_corner_radius: Widget corner radius. Value needs to be between `0` and `50`.
        """
        pulumi.set(__self__, "button_border_radius", button_border_radius)
        pulumi.set(__self__, "button_border_weight", button_border_weight)
        pulumi.set(__self__, "buttons_style", buttons_style)
        pulumi.set(__self__, "input_border_radius", input_border_radius)
        pulumi.set(__self__, "input_border_weight", input_border_weight)
        pulumi.set(__self__, "inputs_style", inputs_style)
        pulumi.set(__self__, "show_widget_shadow", show_widget_shadow)
        pulumi.set(__self__, "widget_border_weight", widget_border_weight)
        pulumi.set(__self__, "widget_corner_radius", widget_corner_radius)

    @property
    @pulumi.getter(name="buttonBorderRadius")
    def button_border_radius(self) -> float:
        """
        Button border radius. Value needs to be between `1` and `10`.
        """
        return pulumi.get(self, "button_border_radius")

    @property
    @pulumi.getter(name="buttonBorderWeight")
    def button_border_weight(self) -> float:
        """
        Button border weight. Value needs to be between `0` and `10`.
        """
        return pulumi.get(self, "button_border_weight")

    @property
    @pulumi.getter(name="buttonsStyle")
    def buttons_style(self) -> str:
        """
        Buttons style. Available options: `pill`, `rounded`, `sharp`.
        """
        return pulumi.get(self, "buttons_style")

    @property
    @pulumi.getter(name="inputBorderRadius")
    def input_border_radius(self) -> float:
        """
        Input border radius. Value needs to be between `0` and `10`.
        """
        return pulumi.get(self, "input_border_radius")

    @property
    @pulumi.getter(name="inputBorderWeight")
    def input_border_weight(self) -> float:
        """
        Input border weight. Value needs to be between `0` and `3`.
        """
        return pulumi.get(self, "input_border_weight")

    @property
    @pulumi.getter(name="inputsStyle")
    def inputs_style(self) -> str:
        """
        Inputs style. Available options: `pill`, `rounded`, `sharp`.
        """
        return pulumi.get(self, "inputs_style")

    @property
    @pulumi.getter(name="showWidgetShadow")
    def show_widget_shadow(self) -> bool:
        """
        Show widget shadow.
        """
        return pulumi.get(self, "show_widget_shadow")

    @property
    @pulumi.getter(name="widgetBorderWeight")
    def widget_border_weight(self) -> float:
        """
        Widget border weight. Value needs to be between `0` and `10`.
        """
        return pulumi.get(self, "widget_border_weight")

    @property
    @pulumi.getter(name="widgetCornerRadius")
    def widget_corner_radius(self) -> float:
        """
        Widget corner radius. Value needs to be between `0` and `50`.
        """
        return pulumi.get(self, "widget_corner_radius")


@pulumi.output_type
class BrandingThemeColors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyText":
            suggest = "body_text"
        elif key == "inputBackground":
            suggest = "input_background"
        elif key == "inputBorder":
            suggest = "input_border"
        elif key == "inputFilledText":
            suggest = "input_filled_text"
        elif key == "inputLabelsPlaceholders":
            suggest = "input_labels_placeholders"
        elif key == "linksFocusedComponents":
            suggest = "links_focused_components"
        elif key == "primaryButton":
            suggest = "primary_button"
        elif key == "primaryButtonLabel":
            suggest = "primary_button_label"
        elif key == "secondaryButtonBorder":
            suggest = "secondary_button_border"
        elif key == "secondaryButtonLabel":
            suggest = "secondary_button_label"
        elif key == "widgetBackground":
            suggest = "widget_background"
        elif key == "widgetBorder":
            suggest = "widget_border"
        elif key == "baseFocusColor":
            suggest = "base_focus_color"
        elif key == "baseHoverColor":
            suggest = "base_hover_color"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BrandingThemeColors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BrandingThemeColors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BrandingThemeColors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_text: str,
                 error: str,
                 header: str,
                 icons: str,
                 input_background: str,
                 input_border: str,
                 input_filled_text: str,
                 input_labels_placeholders: str,
                 links_focused_components: str,
                 primary_button: str,
                 primary_button_label: str,
                 secondary_button_border: str,
                 secondary_button_label: str,
                 success: str,
                 widget_background: str,
                 widget_border: str,
                 base_focus_color: Optional[str] = None,
                 base_hover_color: Optional[str] = None):
        """
        :param str body_text: Body text.
        :param str error: Error.
        :param str header: Header.
        :param str icons: Icons.
        :param str input_background: Input background.
        :param str input_border: Input border.
        :param str input_filled_text: Input filled text.
        :param str input_labels_placeholders: Input labels & placeholders.
        :param str links_focused_components: Links & focused components.
        :param str primary_button: Primary button.
        :param str primary_button_label: Primary button label.
        :param str secondary_button_border: Secondary button border.
        :param str secondary_button_label: Secondary button label.
        :param str success: Success.
        :param str widget_background: Widget background.
        :param str widget_border: Widget border.
        :param str base_focus_color: Base focus color.
        :param str base_hover_color: Base hover color.
        """
        pulumi.set(__self__, "body_text", body_text)
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "icons", icons)
        pulumi.set(__self__, "input_background", input_background)
        pulumi.set(__self__, "input_border", input_border)
        pulumi.set(__self__, "input_filled_text", input_filled_text)
        pulumi.set(__self__, "input_labels_placeholders", input_labels_placeholders)
        pulumi.set(__self__, "links_focused_components", links_focused_components)
        pulumi.set(__self__, "primary_button", primary_button)
        pulumi.set(__self__, "primary_button_label", primary_button_label)
        pulumi.set(__self__, "secondary_button_border", secondary_button_border)
        pulumi.set(__self__, "secondary_button_label", secondary_button_label)
        pulumi.set(__self__, "success", success)
        pulumi.set(__self__, "widget_background", widget_background)
        pulumi.set(__self__, "widget_border", widget_border)
        if base_focus_color is not None:
            pulumi.set(__self__, "base_focus_color", base_focus_color)
        if base_hover_color is not None:
            pulumi.set(__self__, "base_hover_color", base_hover_color)

    @property
    @pulumi.getter(name="bodyText")
    def body_text(self) -> str:
        """
        Body text.
        """
        return pulumi.get(self, "body_text")

    @property
    @pulumi.getter
    def error(self) -> str:
        """
        Error.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def header(self) -> str:
        """
        Header.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def icons(self) -> str:
        """
        Icons.
        """
        return pulumi.get(self, "icons")

    @property
    @pulumi.getter(name="inputBackground")
    def input_background(self) -> str:
        """
        Input background.
        """
        return pulumi.get(self, "input_background")

    @property
    @pulumi.getter(name="inputBorder")
    def input_border(self) -> str:
        """
        Input border.
        """
        return pulumi.get(self, "input_border")

    @property
    @pulumi.getter(name="inputFilledText")
    def input_filled_text(self) -> str:
        """
        Input filled text.
        """
        return pulumi.get(self, "input_filled_text")

    @property
    @pulumi.getter(name="inputLabelsPlaceholders")
    def input_labels_placeholders(self) -> str:
        """
        Input labels & placeholders.
        """
        return pulumi.get(self, "input_labels_placeholders")

    @property
    @pulumi.getter(name="linksFocusedComponents")
    def links_focused_components(self) -> str:
        """
        Links & focused components.
        """
        return pulumi.get(self, "links_focused_components")

    @property
    @pulumi.getter(name="primaryButton")
    def primary_button(self) -> str:
        """
        Primary button.
        """
        return pulumi.get(self, "primary_button")

    @property
    @pulumi.getter(name="primaryButtonLabel")
    def primary_button_label(self) -> str:
        """
        Primary button label.
        """
        return pulumi.get(self, "primary_button_label")

    @property
    @pulumi.getter(name="secondaryButtonBorder")
    def secondary_button_border(self) -> str:
        """
        Secondary button border.
        """
        return pulumi.get(self, "secondary_button_border")

    @property
    @pulumi.getter(name="secondaryButtonLabel")
    def secondary_button_label(self) -> str:
        """
        Secondary button label.
        """
        return pulumi.get(self, "secondary_button_label")

    @property
    @pulumi.getter
    def success(self) -> str:
        """
        Success.
        """
        return pulumi.get(self, "success")

    @property
    @pulumi.getter(name="widgetBackground")
    def widget_background(self) -> str:
        """
        Widget background.
        """
        return pulumi.get(self, "widget_background")

    @property
    @pulumi.getter(name="widgetBorder")
    def widget_border(self) -> str:
        """
        Widget border.
        """
        return pulumi.get(self, "widget_border")

    @property
    @pulumi.getter(name="baseFocusColor")
    def base_focus_color(self) -> Optional[str]:
        """
        Base focus color.
        """
        return pulumi.get(self, "base_focus_color")

    @property
    @pulumi.getter(name="baseHoverColor")
    def base_hover_color(self) -> Optional[str]:
        """
        Base hover color.
        """
        return pulumi.get(self, "base_hover_color")


@pulumi.output_type
class BrandingThemeFonts(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyText":
            suggest = "body_text"
        elif key == "buttonsText":
            suggest = "buttons_text"
        elif key == "fontUrl":
            suggest = "font_url"
        elif key == "inputLabels":
            suggest = "input_labels"
        elif key == "linksStyle":
            suggest = "links_style"
        elif key == "referenceTextSize":
            suggest = "reference_text_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BrandingThemeFonts. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BrandingThemeFonts.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BrandingThemeFonts.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_text: 'outputs.BrandingThemeFontsBodyText',
                 buttons_text: 'outputs.BrandingThemeFontsButtonsText',
                 font_url: str,
                 input_labels: 'outputs.BrandingThemeFontsInputLabels',
                 links: 'outputs.BrandingThemeFontsLinks',
                 links_style: str,
                 reference_text_size: float,
                 subtitle: 'outputs.BrandingThemeFontsSubtitle',
                 title: 'outputs.BrandingThemeFontsTitle'):
        """
        :param 'BrandingThemeFontsBodyTextArgs' body_text: Body text.
        :param 'BrandingThemeFontsButtonsTextArgs' buttons_text: Buttons text.
        :param str font_url: Font URL.
        :param 'BrandingThemeFontsInputLabelsArgs' input_labels: Input labels.
        :param 'BrandingThemeFontsLinksArgs' links: Links.
        :param str links_style: Links style.
        :param float reference_text_size: Reference text size. Value needs to be between `12` and `24`.
        :param 'BrandingThemeFontsSubtitleArgs' subtitle: Subtitle.
        :param 'BrandingThemeFontsTitleArgs' title: Title.
        """
        pulumi.set(__self__, "body_text", body_text)
        pulumi.set(__self__, "buttons_text", buttons_text)
        pulumi.set(__self__, "font_url", font_url)
        pulumi.set(__self__, "input_labels", input_labels)
        pulumi.set(__self__, "links", links)
        pulumi.set(__self__, "links_style", links_style)
        pulumi.set(__self__, "reference_text_size", reference_text_size)
        pulumi.set(__self__, "subtitle", subtitle)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="bodyText")
    def body_text(self) -> 'outputs.BrandingThemeFontsBodyText':
        """
        Body text.
        """
        return pulumi.get(self, "body_text")

    @property
    @pulumi.getter(name="buttonsText")
    def buttons_text(self) -> 'outputs.BrandingThemeFontsButtonsText':
        """
        Buttons text.
        """
        return pulumi.get(self, "buttons_text")

    @property
    @pulumi.getter(name="fontUrl")
    def font_url(self) -> str:
        """
        Font URL.
        """
        return pulumi.get(self, "font_url")

    @property
    @pulumi.getter(name="inputLabels")
    def input_labels(self) -> 'outputs.BrandingThemeFontsInputLabels':
        """
        Input labels.
        """
        return pulumi.get(self, "input_labels")

    @property
    @pulumi.getter
    def links(self) -> 'outputs.BrandingThemeFontsLinks':
        """
        Links.
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter(name="linksStyle")
    def links_style(self) -> str:
        """
        Links style.
        """
        return pulumi.get(self, "links_style")

    @property
    @pulumi.getter(name="referenceTextSize")
    def reference_text_size(self) -> float:
        """
        Reference text size. Value needs to be between `12` and `24`.
        """
        return pulumi.get(self, "reference_text_size")

    @property
    @pulumi.getter
    def subtitle(self) -> 'outputs.BrandingThemeFontsSubtitle':
        """
        Subtitle.
        """
        return pulumi.get(self, "subtitle")

    @property
    @pulumi.getter
    def title(self) -> 'outputs.BrandingThemeFontsTitle':
        """
        Title.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class BrandingThemeFontsBodyText(dict):
    def __init__(__self__, *,
                 bold: bool,
                 size: float):
        pulumi.set(__self__, "bold", bold)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def bold(self) -> bool:
        return pulumi.get(self, "bold")

    @property
    @pulumi.getter
    def size(self) -> float:
        return pulumi.get(self, "size")


@pulumi.output_type
class BrandingThemeFontsButtonsText(dict):
    def __init__(__self__, *,
                 bold: bool,
                 size: float):
        pulumi.set(__self__, "bold", bold)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def bold(self) -> bool:
        return pulumi.get(self, "bold")

    @property
    @pulumi.getter
    def size(self) -> float:
        return pulumi.get(self, "size")


@pulumi.output_type
class BrandingThemeFontsInputLabels(dict):
    def __init__(__self__, *,
                 bold: bool,
                 size: float):
        pulumi.set(__self__, "bold", bold)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def bold(self) -> bool:
        return pulumi.get(self, "bold")

    @property
    @pulumi.getter
    def size(self) -> float:
        return pulumi.get(self, "size")


@pulumi.output_type
class BrandingThemeFontsLinks(dict):
    def __init__(__self__, *,
                 bold: bool,
                 size: float):
        pulumi.set(__self__, "bold", bold)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def bold(self) -> bool:
        return pulumi.get(self, "bold")

    @property
    @pulumi.getter
    def size(self) -> float:
        return pulumi.get(self, "size")


@pulumi.output_type
class BrandingThemeFontsSubtitle(dict):
    def __init__(__self__, *,
                 bold: bool,
                 size: float):
        pulumi.set(__self__, "bold", bold)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def bold(self) -> bool:
        return pulumi.get(self, "bold")

    @property
    @pulumi.getter
    def size(self) -> float:
        return pulumi.get(self, "size")


@pulumi.output_type
class BrandingThemeFontsTitle(dict):
    def __init__(__self__, *,
                 bold: bool,
                 size: float):
        pulumi.set(__self__, "bold", bold)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def bold(self) -> bool:
        return pulumi.get(self, "bold")

    @property
    @pulumi.getter
    def size(self) -> float:
        return pulumi.get(self, "size")


@pulumi.output_type
class BrandingThemePageBackground(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backgroundColor":
            suggest = "background_color"
        elif key == "backgroundImageUrl":
            suggest = "background_image_url"
        elif key == "pageLayout":
            suggest = "page_layout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BrandingThemePageBackground. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BrandingThemePageBackground.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BrandingThemePageBackground.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 background_color: str,
                 background_image_url: str,
                 page_layout: str):
        """
        :param str background_color: Background color.
        :param str background_image_url: Background image url.
        :param str page_layout: Page layout. Available options: `center`, `left`, `right`.
        """
        pulumi.set(__self__, "background_color", background_color)
        pulumi.set(__self__, "background_image_url", background_image_url)
        pulumi.set(__self__, "page_layout", page_layout)

    @property
    @pulumi.getter(name="backgroundColor")
    def background_color(self) -> str:
        """
        Background color.
        """
        return pulumi.get(self, "background_color")

    @property
    @pulumi.getter(name="backgroundImageUrl")
    def background_image_url(self) -> str:
        """
        Background image url.
        """
        return pulumi.get(self, "background_image_url")

    @property
    @pulumi.getter(name="pageLayout")
    def page_layout(self) -> str:
        """
        Page layout. Available options: `center`, `left`, `right`.
        """
        return pulumi.get(self, "page_layout")


@pulumi.output_type
class BrandingThemeWidget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerTextAlignment":
            suggest = "header_text_alignment"
        elif key == "logoHeight":
            suggest = "logo_height"
        elif key == "logoPosition":
            suggest = "logo_position"
        elif key == "logoUrl":
            suggest = "logo_url"
        elif key == "socialButtonsLayout":
            suggest = "social_buttons_layout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BrandingThemeWidget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BrandingThemeWidget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BrandingThemeWidget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_text_alignment: str,
                 logo_height: float,
                 logo_position: str,
                 logo_url: str,
                 social_buttons_layout: str):
        """
        :param str header_text_alignment: Header text alignment. Available options: `center`, `left`, `right`.
        :param float logo_height: Logo height. Value needs to be between `1` and `100`.
        :param str logo_position: Logo position. Available options: `center`, `left`, `right`, `none`.
        :param str logo_url: Logo url.
        :param str social_buttons_layout: Social buttons layout.  Available options: `bottom`, `top`.
        """
        pulumi.set(__self__, "header_text_alignment", header_text_alignment)
        pulumi.set(__self__, "logo_height", logo_height)
        pulumi.set(__self__, "logo_position", logo_position)
        pulumi.set(__self__, "logo_url", logo_url)
        pulumi.set(__self__, "social_buttons_layout", social_buttons_layout)

    @property
    @pulumi.getter(name="headerTextAlignment")
    def header_text_alignment(self) -> str:
        """
        Header text alignment. Available options: `center`, `left`, `right`.
        """
        return pulumi.get(self, "header_text_alignment")

    @property
    @pulumi.getter(name="logoHeight")
    def logo_height(self) -> float:
        """
        Logo height. Value needs to be between `1` and `100`.
        """
        return pulumi.get(self, "logo_height")

    @property
    @pulumi.getter(name="logoPosition")
    def logo_position(self) -> str:
        """
        Logo position. Available options: `center`, `left`, `right`, `none`.
        """
        return pulumi.get(self, "logo_position")

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> str:
        """
        Logo url.
        """
        return pulumi.get(self, "logo_url")

    @property
    @pulumi.getter(name="socialButtonsLayout")
    def social_buttons_layout(self) -> str:
        """
        Social buttons layout.  Available options: `bottom`, `top`.
        """
        return pulumi.get(self, "social_buttons_layout")


@pulumi.output_type
class BrandingUniversalLogin(dict):
    def __init__(__self__, *,
                 body: Optional[str] = None):
        """
        :param str body: The body of login pages.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)

    @property
    @pulumi.getter
    def body(self) -> Optional[str]:
        """
        The body of login pages.
        """
        return pulumi.get(self, "body")


@pulumi.output_type
class ClientAddons(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureBlob":
            suggest = "azure_blob"
        elif key == "azureSb":
            suggest = "azure_sb"
        elif key == "salesforceApi":
            suggest = "salesforce_api"
        elif key == "salesforceSandboxApi":
            suggest = "salesforce_sandbox_api"
        elif key == "sapApi":
            suggest = "sap_api"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientAddons. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientAddons.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientAddons.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws: Optional[Mapping[str, Any]] = None,
                 azure_blob: Optional[Mapping[str, Any]] = None,
                 azure_sb: Optional[Mapping[str, Any]] = None,
                 box: Optional[Mapping[str, Any]] = None,
                 cloudbees: Optional[Mapping[str, Any]] = None,
                 concur: Optional[Mapping[str, Any]] = None,
                 dropbox: Optional[Mapping[str, Any]] = None,
                 echosign: Optional[Mapping[str, Any]] = None,
                 egnyte: Optional[Mapping[str, Any]] = None,
                 firebase: Optional[Mapping[str, Any]] = None,
                 layer: Optional[Mapping[str, Any]] = None,
                 mscrm: Optional[Mapping[str, Any]] = None,
                 newrelic: Optional[Mapping[str, Any]] = None,
                 office365: Optional[Mapping[str, Any]] = None,
                 rms: Optional[Mapping[str, Any]] = None,
                 salesforce: Optional[Mapping[str, Any]] = None,
                 salesforce_api: Optional[Mapping[str, Any]] = None,
                 salesforce_sandbox_api: Optional[Mapping[str, Any]] = None,
                 samlp: Optional['outputs.ClientAddonsSamlp'] = None,
                 sap_api: Optional[Mapping[str, Any]] = None,
                 sentry: Optional[Mapping[str, Any]] = None,
                 sharepoint: Optional[Mapping[str, Any]] = None,
                 slack: Optional[Mapping[str, Any]] = None,
                 springcm: Optional[Mapping[str, Any]] = None,
                 wams: Optional[Mapping[str, Any]] = None,
                 wsfed: Optional[Mapping[str, Any]] = None,
                 zendesk: Optional[Mapping[str, Any]] = None,
                 zoom: Optional[Mapping[str, Any]] = None):
        """
        :param 'ClientAddonsSamlpArgs' samlp: Configuration settings for a SAML add-on.
        :param Mapping[str, Any] wsfed: WS-Fed (WIF) addon indicator. Actual configuration is stored in callback and `client_aliases` properties on the client.
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure_blob is not None:
            pulumi.set(__self__, "azure_blob", azure_blob)
        if azure_sb is not None:
            pulumi.set(__self__, "azure_sb", azure_sb)
        if box is not None:
            pulumi.set(__self__, "box", box)
        if cloudbees is not None:
            pulumi.set(__self__, "cloudbees", cloudbees)
        if concur is not None:
            pulumi.set(__self__, "concur", concur)
        if dropbox is not None:
            pulumi.set(__self__, "dropbox", dropbox)
        if echosign is not None:
            pulumi.set(__self__, "echosign", echosign)
        if egnyte is not None:
            pulumi.set(__self__, "egnyte", egnyte)
        if firebase is not None:
            pulumi.set(__self__, "firebase", firebase)
        if layer is not None:
            pulumi.set(__self__, "layer", layer)
        if mscrm is not None:
            pulumi.set(__self__, "mscrm", mscrm)
        if newrelic is not None:
            pulumi.set(__self__, "newrelic", newrelic)
        if office365 is not None:
            pulumi.set(__self__, "office365", office365)
        if rms is not None:
            pulumi.set(__self__, "rms", rms)
        if salesforce is not None:
            pulumi.set(__self__, "salesforce", salesforce)
        if salesforce_api is not None:
            pulumi.set(__self__, "salesforce_api", salesforce_api)
        if salesforce_sandbox_api is not None:
            pulumi.set(__self__, "salesforce_sandbox_api", salesforce_sandbox_api)
        if samlp is not None:
            pulumi.set(__self__, "samlp", samlp)
        if sap_api is not None:
            pulumi.set(__self__, "sap_api", sap_api)
        if sentry is not None:
            pulumi.set(__self__, "sentry", sentry)
        if sharepoint is not None:
            pulumi.set(__self__, "sharepoint", sharepoint)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if springcm is not None:
            pulumi.set(__self__, "springcm", springcm)
        if wams is not None:
            pulumi.set(__self__, "wams", wams)
        if wsfed is not None:
            pulumi.set(__self__, "wsfed", wsfed)
        if zendesk is not None:
            pulumi.set(__self__, "zendesk", zendesk)
        if zoom is not None:
            pulumi.set(__self__, "zoom", zoom)

    @property
    @pulumi.getter
    def aws(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter(name="azureBlob")
    def azure_blob(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "azure_blob")

    @property
    @pulumi.getter(name="azureSb")
    def azure_sb(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "azure_sb")

    @property
    @pulumi.getter
    def box(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "box")

    @property
    @pulumi.getter
    def cloudbees(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "cloudbees")

    @property
    @pulumi.getter
    def concur(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "concur")

    @property
    @pulumi.getter
    def dropbox(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "dropbox")

    @property
    @pulumi.getter
    def echosign(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "echosign")

    @property
    @pulumi.getter
    def egnyte(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "egnyte")

    @property
    @pulumi.getter
    def firebase(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "firebase")

    @property
    @pulumi.getter
    def layer(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "layer")

    @property
    @pulumi.getter
    def mscrm(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "mscrm")

    @property
    @pulumi.getter
    def newrelic(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "newrelic")

    @property
    @pulumi.getter
    def office365(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "office365")

    @property
    @pulumi.getter
    def rms(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "rms")

    @property
    @pulumi.getter
    def salesforce(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="salesforceApi")
    def salesforce_api(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "salesforce_api")

    @property
    @pulumi.getter(name="salesforceSandboxApi")
    def salesforce_sandbox_api(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "salesforce_sandbox_api")

    @property
    @pulumi.getter
    def samlp(self) -> Optional['outputs.ClientAddonsSamlp']:
        """
        Configuration settings for a SAML add-on.
        """
        return pulumi.get(self, "samlp")

    @property
    @pulumi.getter(name="sapApi")
    def sap_api(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "sap_api")

    @property
    @pulumi.getter
    def sentry(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "sentry")

    @property
    @pulumi.getter
    def sharepoint(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "sharepoint")

    @property
    @pulumi.getter
    def slack(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "slack")

    @property
    @pulumi.getter
    def springcm(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "springcm")

    @property
    @pulumi.getter
    def wams(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "wams")

    @property
    @pulumi.getter
    def wsfed(self) -> Optional[Mapping[str, Any]]:
        """
        WS-Fed (WIF) addon indicator. Actual configuration is stored in callback and `client_aliases` properties on the client.
        """
        return pulumi.get(self, "wsfed")

    @property
    @pulumi.getter
    def zendesk(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "zendesk")

    @property
    @pulumi.getter
    def zoom(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "zoom")


@pulumi.output_type
class ClientAddonsSamlp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authnContextClassRef":
            suggest = "authn_context_class_ref"
        elif key == "createUpnClaim":
            suggest = "create_upn_claim"
        elif key == "digestAlgorithm":
            suggest = "digest_algorithm"
        elif key == "includeAttributeNameFormat":
            suggest = "include_attribute_name_format"
        elif key == "lifetimeInSeconds":
            suggest = "lifetime_in_seconds"
        elif key == "mapIdentities":
            suggest = "map_identities"
        elif key == "mapUnknownClaimsAsIs":
            suggest = "map_unknown_claims_as_is"
        elif key == "nameIdentifierFormat":
            suggest = "name_identifier_format"
        elif key == "nameIdentifierProbes":
            suggest = "name_identifier_probes"
        elif key == "passthroughClaimsWithNoMapping":
            suggest = "passthrough_claims_with_no_mapping"
        elif key == "signResponse":
            suggest = "sign_response"
        elif key == "signatureAlgorithm":
            suggest = "signature_algorithm"
        elif key == "signingCert":
            suggest = "signing_cert"
        elif key == "typedAttributes":
            suggest = "typed_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientAddonsSamlp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientAddonsSamlp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientAddonsSamlp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audience: Optional[str] = None,
                 authn_context_class_ref: Optional[str] = None,
                 binding: Optional[str] = None,
                 create_upn_claim: Optional[bool] = None,
                 destination: Optional[str] = None,
                 digest_algorithm: Optional[str] = None,
                 include_attribute_name_format: Optional[bool] = None,
                 issuer: Optional[str] = None,
                 lifetime_in_seconds: Optional[int] = None,
                 logout: Optional[Mapping[str, Any]] = None,
                 map_identities: Optional[bool] = None,
                 map_unknown_claims_as_is: Optional[bool] = None,
                 mappings: Optional[Mapping[str, Any]] = None,
                 name_identifier_format: Optional[str] = None,
                 name_identifier_probes: Optional[Sequence[str]] = None,
                 passthrough_claims_with_no_mapping: Optional[bool] = None,
                 recipient: Optional[str] = None,
                 sign_response: Optional[bool] = None,
                 signature_algorithm: Optional[str] = None,
                 signing_cert: Optional[str] = None,
                 typed_attributes: Optional[bool] = None):
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if authn_context_class_ref is not None:
            pulumi.set(__self__, "authn_context_class_ref", authn_context_class_ref)
        if binding is not None:
            pulumi.set(__self__, "binding", binding)
        if create_upn_claim is not None:
            pulumi.set(__self__, "create_upn_claim", create_upn_claim)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if digest_algorithm is not None:
            pulumi.set(__self__, "digest_algorithm", digest_algorithm)
        if include_attribute_name_format is not None:
            pulumi.set(__self__, "include_attribute_name_format", include_attribute_name_format)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if lifetime_in_seconds is not None:
            pulumi.set(__self__, "lifetime_in_seconds", lifetime_in_seconds)
        if logout is not None:
            pulumi.set(__self__, "logout", logout)
        if map_identities is not None:
            pulumi.set(__self__, "map_identities", map_identities)
        if map_unknown_claims_as_is is not None:
            pulumi.set(__self__, "map_unknown_claims_as_is", map_unknown_claims_as_is)
        if mappings is not None:
            pulumi.set(__self__, "mappings", mappings)
        if name_identifier_format is not None:
            pulumi.set(__self__, "name_identifier_format", name_identifier_format)
        if name_identifier_probes is not None:
            pulumi.set(__self__, "name_identifier_probes", name_identifier_probes)
        if passthrough_claims_with_no_mapping is not None:
            pulumi.set(__self__, "passthrough_claims_with_no_mapping", passthrough_claims_with_no_mapping)
        if recipient is not None:
            pulumi.set(__self__, "recipient", recipient)
        if sign_response is not None:
            pulumi.set(__self__, "sign_response", sign_response)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if signing_cert is not None:
            pulumi.set(__self__, "signing_cert", signing_cert)
        if typed_attributes is not None:
            pulumi.set(__self__, "typed_attributes", typed_attributes)

    @property
    @pulumi.getter
    def audience(self) -> Optional[str]:
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="authnContextClassRef")
    def authn_context_class_ref(self) -> Optional[str]:
        return pulumi.get(self, "authn_context_class_ref")

    @property
    @pulumi.getter
    def binding(self) -> Optional[str]:
        return pulumi.get(self, "binding")

    @property
    @pulumi.getter(name="createUpnClaim")
    def create_upn_claim(self) -> Optional[bool]:
        return pulumi.get(self, "create_upn_claim")

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="digestAlgorithm")
    def digest_algorithm(self) -> Optional[str]:
        return pulumi.get(self, "digest_algorithm")

    @property
    @pulumi.getter(name="includeAttributeNameFormat")
    def include_attribute_name_format(self) -> Optional[bool]:
        return pulumi.get(self, "include_attribute_name_format")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="lifetimeInSeconds")
    def lifetime_in_seconds(self) -> Optional[int]:
        return pulumi.get(self, "lifetime_in_seconds")

    @property
    @pulumi.getter
    def logout(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "logout")

    @property
    @pulumi.getter(name="mapIdentities")
    def map_identities(self) -> Optional[bool]:
        return pulumi.get(self, "map_identities")

    @property
    @pulumi.getter(name="mapUnknownClaimsAsIs")
    def map_unknown_claims_as_is(self) -> Optional[bool]:
        return pulumi.get(self, "map_unknown_claims_as_is")

    @property
    @pulumi.getter
    def mappings(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter(name="nameIdentifierFormat")
    def name_identifier_format(self) -> Optional[str]:
        return pulumi.get(self, "name_identifier_format")

    @property
    @pulumi.getter(name="nameIdentifierProbes")
    def name_identifier_probes(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "name_identifier_probes")

    @property
    @pulumi.getter(name="passthroughClaimsWithNoMapping")
    def passthrough_claims_with_no_mapping(self) -> Optional[bool]:
        return pulumi.get(self, "passthrough_claims_with_no_mapping")

    @property
    @pulumi.getter
    def recipient(self) -> Optional[str]:
        return pulumi.get(self, "recipient")

    @property
    @pulumi.getter(name="signResponse")
    def sign_response(self) -> Optional[bool]:
        return pulumi.get(self, "sign_response")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[str]:
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter(name="signingCert")
    def signing_cert(self) -> Optional[str]:
        return pulumi.get(self, "signing_cert")

    @property
    @pulumi.getter(name="typedAttributes")
    def typed_attributes(self) -> Optional[bool]:
        return pulumi.get(self, "typed_attributes")


@pulumi.output_type
class ClientJwtConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifetimeInSeconds":
            suggest = "lifetime_in_seconds"
        elif key == "secretEncoded":
            suggest = "secret_encoded"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientJwtConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientJwtConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientJwtConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alg: Optional[str] = None,
                 lifetime_in_seconds: Optional[int] = None,
                 scopes: Optional[Mapping[str, str]] = None,
                 secret_encoded: Optional[bool] = None):
        """
        :param str alg: Algorithm used to sign JWTs.
        :param int lifetime_in_seconds: Number of seconds during which the JWT will be valid.
        :param Mapping[str, str] scopes: Permissions (scopes) included in JWTs.
        :param bool secret_encoded: Indicates whether the client secret is Base64-encoded.
        """
        if alg is not None:
            pulumi.set(__self__, "alg", alg)
        if lifetime_in_seconds is not None:
            pulumi.set(__self__, "lifetime_in_seconds", lifetime_in_seconds)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if secret_encoded is not None:
            pulumi.set(__self__, "secret_encoded", secret_encoded)

    @property
    @pulumi.getter
    def alg(self) -> Optional[str]:
        """
        Algorithm used to sign JWTs.
        """
        return pulumi.get(self, "alg")

    @property
    @pulumi.getter(name="lifetimeInSeconds")
    def lifetime_in_seconds(self) -> Optional[int]:
        """
        Number of seconds during which the JWT will be valid.
        """
        return pulumi.get(self, "lifetime_in_seconds")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Mapping[str, str]]:
        """
        Permissions (scopes) included in JWTs.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="secretEncoded")
    def secret_encoded(self) -> Optional[bool]:
        """
        Indicates whether the client secret is Base64-encoded.
        """
        return pulumi.get(self, "secret_encoded")


@pulumi.output_type
class ClientMobile(dict):
    def __init__(__self__, *,
                 android: Optional['outputs.ClientMobileAndroid'] = None,
                 ios: Optional['outputs.ClientMobileIos'] = None):
        """
        :param 'ClientMobileAndroidArgs' android: Configuration settings for Android native apps.
        :param 'ClientMobileIosArgs' ios: Configuration settings for i0S native apps.
        """
        if android is not None:
            pulumi.set(__self__, "android", android)
        if ios is not None:
            pulumi.set(__self__, "ios", ios)

    @property
    @pulumi.getter
    def android(self) -> Optional['outputs.ClientMobileAndroid']:
        """
        Configuration settings for Android native apps.
        """
        return pulumi.get(self, "android")

    @property
    @pulumi.getter
    def ios(self) -> Optional['outputs.ClientMobileIos']:
        """
        Configuration settings for i0S native apps.
        """
        return pulumi.get(self, "ios")


@pulumi.output_type
class ClientMobileAndroid(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appPackageName":
            suggest = "app_package_name"
        elif key == "sha256CertFingerprints":
            suggest = "sha256_cert_fingerprints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientMobileAndroid. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientMobileAndroid.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientMobileAndroid.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_package_name: Optional[str] = None,
                 sha256_cert_fingerprints: Optional[Sequence[str]] = None):
        if app_package_name is not None:
            pulumi.set(__self__, "app_package_name", app_package_name)
        if sha256_cert_fingerprints is not None:
            pulumi.set(__self__, "sha256_cert_fingerprints", sha256_cert_fingerprints)

    @property
    @pulumi.getter(name="appPackageName")
    def app_package_name(self) -> Optional[str]:
        return pulumi.get(self, "app_package_name")

    @property
    @pulumi.getter(name="sha256CertFingerprints")
    def sha256_cert_fingerprints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "sha256_cert_fingerprints")


@pulumi.output_type
class ClientMobileIos(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appBundleIdentifier":
            suggest = "app_bundle_identifier"
        elif key == "teamId":
            suggest = "team_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientMobileIos. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientMobileIos.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientMobileIos.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_bundle_identifier: Optional[str] = None,
                 team_id: Optional[str] = None):
        if app_bundle_identifier is not None:
            pulumi.set(__self__, "app_bundle_identifier", app_bundle_identifier)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="appBundleIdentifier")
    def app_bundle_identifier(self) -> Optional[str]:
        return pulumi.get(self, "app_bundle_identifier")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[str]:
        return pulumi.get(self, "team_id")


@pulumi.output_type
class ClientNativeSocialLogin(dict):
    def __init__(__self__, *,
                 apple: Optional['outputs.ClientNativeSocialLoginApple'] = None,
                 facebook: Optional['outputs.ClientNativeSocialLoginFacebook'] = None):
        if apple is not None:
            pulumi.set(__self__, "apple", apple)
        if facebook is not None:
            pulumi.set(__self__, "facebook", facebook)

    @property
    @pulumi.getter
    def apple(self) -> Optional['outputs.ClientNativeSocialLoginApple']:
        return pulumi.get(self, "apple")

    @property
    @pulumi.getter
    def facebook(self) -> Optional['outputs.ClientNativeSocialLoginFacebook']:
        return pulumi.get(self, "facebook")


@pulumi.output_type
class ClientNativeSocialLoginApple(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClientNativeSocialLoginFacebook(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClientRefreshToken(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationType":
            suggest = "expiration_type"
        elif key == "rotationType":
            suggest = "rotation_type"
        elif key == "idleTokenLifetime":
            suggest = "idle_token_lifetime"
        elif key == "infiniteIdleTokenLifetime":
            suggest = "infinite_idle_token_lifetime"
        elif key == "infiniteTokenLifetime":
            suggest = "infinite_token_lifetime"
        elif key == "tokenLifetime":
            suggest = "token_lifetime"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientRefreshToken. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientRefreshToken.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientRefreshToken.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration_type: str,
                 rotation_type: str,
                 idle_token_lifetime: Optional[int] = None,
                 infinite_idle_token_lifetime: Optional[bool] = None,
                 infinite_token_lifetime: Optional[bool] = None,
                 leeway: Optional[int] = None,
                 token_lifetime: Optional[int] = None):
        """
        :param str expiration_type: Options include `expiring`, `non-expiring`. Whether a refresh token will expire based on an absolute lifetime, after which the token can no longer be used. If rotation is `rotating`, this must be set to `expiring`.
        :param str rotation_type: Options include `rotating`, `non-rotating`. When `rotating`, exchanging a refresh token will cause a new refresh token to be issued and the existing token will be invalidated. This allows for automatic detection of token reuse if the token is leaked.
        :param int idle_token_lifetime: The time in seconds after which inactive refresh tokens will expire.
        :param bool infinite_idle_token_lifetime: Whether inactive refresh tokens should remain valid indefinitely.
        :param bool infinite_token_lifetime: Whether refresh tokens should remain valid indefinitely. If false, `token_lifetime` should also be set.
        :param int leeway: The amount of time in seconds in which a refresh token may be reused without triggering reuse detection.
        :param int token_lifetime: The absolute lifetime of a refresh token in seconds.
        """
        pulumi.set(__self__, "expiration_type", expiration_type)
        pulumi.set(__self__, "rotation_type", rotation_type)
        if idle_token_lifetime is not None:
            pulumi.set(__self__, "idle_token_lifetime", idle_token_lifetime)
        if infinite_idle_token_lifetime is not None:
            pulumi.set(__self__, "infinite_idle_token_lifetime", infinite_idle_token_lifetime)
        if infinite_token_lifetime is not None:
            pulumi.set(__self__, "infinite_token_lifetime", infinite_token_lifetime)
        if leeway is not None:
            pulumi.set(__self__, "leeway", leeway)
        if token_lifetime is not None:
            pulumi.set(__self__, "token_lifetime", token_lifetime)

    @property
    @pulumi.getter(name="expirationType")
    def expiration_type(self) -> str:
        """
        Options include `expiring`, `non-expiring`. Whether a refresh token will expire based on an absolute lifetime, after which the token can no longer be used. If rotation is `rotating`, this must be set to `expiring`.
        """
        return pulumi.get(self, "expiration_type")

    @property
    @pulumi.getter(name="rotationType")
    def rotation_type(self) -> str:
        """
        Options include `rotating`, `non-rotating`. When `rotating`, exchanging a refresh token will cause a new refresh token to be issued and the existing token will be invalidated. This allows for automatic detection of token reuse if the token is leaked.
        """
        return pulumi.get(self, "rotation_type")

    @property
    @pulumi.getter(name="idleTokenLifetime")
    def idle_token_lifetime(self) -> Optional[int]:
        """
        The time in seconds after which inactive refresh tokens will expire.
        """
        return pulumi.get(self, "idle_token_lifetime")

    @property
    @pulumi.getter(name="infiniteIdleTokenLifetime")
    def infinite_idle_token_lifetime(self) -> Optional[bool]:
        """
        Whether inactive refresh tokens should remain valid indefinitely.
        """
        return pulumi.get(self, "infinite_idle_token_lifetime")

    @property
    @pulumi.getter(name="infiniteTokenLifetime")
    def infinite_token_lifetime(self) -> Optional[bool]:
        """
        Whether refresh tokens should remain valid indefinitely. If false, `token_lifetime` should also be set.
        """
        return pulumi.get(self, "infinite_token_lifetime")

    @property
    @pulumi.getter
    def leeway(self) -> Optional[int]:
        """
        The amount of time in seconds in which a refresh token may be reused without triggering reuse detection.
        """
        return pulumi.get(self, "leeway")

    @property
    @pulumi.getter(name="tokenLifetime")
    def token_lifetime(self) -> Optional[int]:
        """
        The absolute lifetime of a refresh token in seconds.
        """
        return pulumi.get(self, "token_lifetime")


@pulumi.output_type
class ConnectionOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adfsServer":
            suggest = "adfs_server"
        elif key == "allowedAudiences":
            suggest = "allowed_audiences"
        elif key == "apiEnableUsers":
            suggest = "api_enable_users"
        elif key == "appId":
            suggest = "app_id"
        elif key == "authParams":
            suggest = "auth_params"
        elif key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "bruteForceProtection":
            suggest = "brute_force_protection"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "communityBaseUrl":
            suggest = "community_base_url"
        elif key == "customScripts":
            suggest = "custom_scripts"
        elif key == "digestAlgorithm":
            suggest = "digest_algorithm"
        elif key == "disableCache":
            suggest = "disable_cache"
        elif key == "disableSignOut":
            suggest = "disable_sign_out"
        elif key == "disableSignup":
            suggest = "disable_signup"
        elif key == "discoveryUrl":
            suggest = "discovery_url"
        elif key == "domainAliases":
            suggest = "domain_aliases"
        elif key == "enabledDatabaseCustomization":
            suggest = "enabled_database_customization"
        elif key == "entityId":
            suggest = "entity_id"
        elif key == "fieldsMap":
            suggest = "fields_map"
        elif key == "forwardRequestInfo":
            suggest = "forward_request_info"
        elif key == "from":
            suggest = "from_"
        elif key == "gatewayAuthentication":
            suggest = "gateway_authentication"
        elif key == "gatewayUrl":
            suggest = "gateway_url"
        elif key == "iconUrl":
            suggest = "icon_url"
        elif key == "identityApi":
            suggest = "identity_api"
        elif key == "idpInitiated":
            suggest = "idp_initiated"
        elif key == "importMode":
            suggest = "import_mode"
        elif key == "jwksUri":
            suggest = "jwks_uri"
        elif key == "keyId":
            suggest = "key_id"
        elif key == "maxGroupsToRetrieve":
            suggest = "max_groups_to_retrieve"
        elif key == "messagingServiceSid":
            suggest = "messaging_service_sid"
        elif key == "metadataUrl":
            suggest = "metadata_url"
        elif key == "metadataXml":
            suggest = "metadata_xml"
        elif key == "nonPersistentAttrs":
            suggest = "non_persistent_attrs"
        elif key == "passwordComplexityOptions":
            suggest = "password_complexity_options"
        elif key == "passwordDictionary":
            suggest = "password_dictionary"
        elif key == "passwordHistories":
            suggest = "password_histories"
        elif key == "passwordNoPersonalInfo":
            suggest = "password_no_personal_info"
        elif key == "passwordPolicy":
            suggest = "password_policy"
        elif key == "pkceEnabled":
            suggest = "pkce_enabled"
        elif key == "protocolBinding":
            suggest = "protocol_binding"
        elif key == "requestTemplate":
            suggest = "request_template"
        elif key == "requiresUsername":
            suggest = "requires_username"
        elif key == "setUserRootAttributes":
            suggest = "set_user_root_attributes"
        elif key == "shouldTrustEmailVerifiedConnection":
            suggest = "should_trust_email_verified_connection"
        elif key == "signInEndpoint":
            suggest = "sign_in_endpoint"
        elif key == "signOutEndpoint":
            suggest = "sign_out_endpoint"
        elif key == "signSamlRequest":
            suggest = "sign_saml_request"
        elif key == "signatureAlgorithm":
            suggest = "signature_algorithm"
        elif key == "signingCert":
            suggest = "signing_cert"
        elif key == "signingKey":
            suggest = "signing_key"
        elif key == "strategyVersion":
            suggest = "strategy_version"
        elif key == "teamId":
            suggest = "team_id"
        elif key == "tenantDomain":
            suggest = "tenant_domain"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "twilioSid":
            suggest = "twilio_sid"
        elif key == "twilioToken":
            suggest = "twilio_token"
        elif key == "upstreamParams":
            suggest = "upstream_params"
        elif key == "useCertAuth":
            suggest = "use_cert_auth"
        elif key == "useKerberos":
            suggest = "use_kerberos"
        elif key == "useWsfed":
            suggest = "use_wsfed"
        elif key == "userIdAttribute":
            suggest = "user_id_attribute"
        elif key == "userinfoEndpoint":
            suggest = "userinfo_endpoint"
        elif key == "waadCommonEndpoint":
            suggest = "waad_common_endpoint"
        elif key == "waadProtocol":
            suggest = "waad_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adfs_server: Optional[str] = None,
                 allowed_audiences: Optional[Sequence[str]] = None,
                 api_enable_users: Optional[bool] = None,
                 app_id: Optional[str] = None,
                 auth_params: Optional[Mapping[str, str]] = None,
                 authorization_endpoint: Optional[str] = None,
                 brute_force_protection: Optional[bool] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 community_base_url: Optional[str] = None,
                 configuration: Optional[Mapping[str, Any]] = None,
                 custom_scripts: Optional[Mapping[str, str]] = None,
                 debug: Optional[bool] = None,
                 digest_algorithm: Optional[str] = None,
                 disable_cache: Optional[bool] = None,
                 disable_sign_out: Optional[bool] = None,
                 disable_signup: Optional[bool] = None,
                 discovery_url: Optional[str] = None,
                 domain: Optional[str] = None,
                 domain_aliases: Optional[Sequence[str]] = None,
                 enabled_database_customization: Optional[bool] = None,
                 entity_id: Optional[str] = None,
                 fields_map: Optional[str] = None,
                 forward_request_info: Optional[bool] = None,
                 from_: Optional[str] = None,
                 gateway_authentication: Optional['outputs.ConnectionOptionsGatewayAuthentication'] = None,
                 gateway_url: Optional[str] = None,
                 icon_url: Optional[str] = None,
                 identity_api: Optional[str] = None,
                 idp_initiated: Optional['outputs.ConnectionOptionsIdpInitiated'] = None,
                 import_mode: Optional[bool] = None,
                 ips: Optional[Sequence[str]] = None,
                 issuer: Optional[str] = None,
                 jwks_uri: Optional[str] = None,
                 key_id: Optional[str] = None,
                 max_groups_to_retrieve: Optional[str] = None,
                 messaging_service_sid: Optional[str] = None,
                 metadata_url: Optional[str] = None,
                 metadata_xml: Optional[str] = None,
                 mfa: Optional['outputs.ConnectionOptionsMfa'] = None,
                 name: Optional[str] = None,
                 non_persistent_attrs: Optional[Sequence[str]] = None,
                 password_complexity_options: Optional['outputs.ConnectionOptionsPasswordComplexityOptions'] = None,
                 password_dictionary: Optional['outputs.ConnectionOptionsPasswordDictionary'] = None,
                 password_histories: Optional[Sequence['outputs.ConnectionOptionsPasswordHistory']] = None,
                 password_no_personal_info: Optional['outputs.ConnectionOptionsPasswordNoPersonalInfo'] = None,
                 password_policy: Optional[str] = None,
                 pkce_enabled: Optional[bool] = None,
                 protocol_binding: Optional[str] = None,
                 provider: Optional[str] = None,
                 request_template: Optional[str] = None,
                 requires_username: Optional[bool] = None,
                 scopes: Optional[Sequence[str]] = None,
                 scripts: Optional[Mapping[str, str]] = None,
                 set_user_root_attributes: Optional[str] = None,
                 should_trust_email_verified_connection: Optional[str] = None,
                 sign_in_endpoint: Optional[str] = None,
                 sign_out_endpoint: Optional[str] = None,
                 sign_saml_request: Optional[bool] = None,
                 signature_algorithm: Optional[str] = None,
                 signing_cert: Optional[str] = None,
                 signing_key: Optional['outputs.ConnectionOptionsSigningKey'] = None,
                 strategy_version: Optional[int] = None,
                 subject: Optional[str] = None,
                 syntax: Optional[str] = None,
                 team_id: Optional[str] = None,
                 template: Optional[str] = None,
                 tenant_domain: Optional[str] = None,
                 token_endpoint: Optional[str] = None,
                 totp: Optional['outputs.ConnectionOptionsTotp'] = None,
                 twilio_sid: Optional[str] = None,
                 twilio_token: Optional[str] = None,
                 type: Optional[str] = None,
                 upstream_params: Optional[str] = None,
                 use_cert_auth: Optional[bool] = None,
                 use_kerberos: Optional[bool] = None,
                 use_wsfed: Optional[bool] = None,
                 user_id_attribute: Optional[str] = None,
                 userinfo_endpoint: Optional[str] = None,
                 validation: Optional['outputs.ConnectionOptionsValidation'] = None,
                 waad_common_endpoint: Optional[bool] = None,
                 waad_protocol: Optional[str] = None):
        """
        :param str adfs_server: ADFS Metadata source.
        :param Sequence[str] allowed_audiences: List of allowed audiences.
        :param bool api_enable_users: Enable API Access to users.
        :param str app_id: App ID.
        :param Mapping[str, str] auth_params: Query string parameters to be included as part of the generated passwordless email link.
        :param str authorization_endpoint: Authorization endpoint.
        :param bool brute_force_protection: Indicates whether to enable brute force protection, which will limit the number of signups and failed logins from a suspicious IP address.
        :param str client_id: The strategy's client ID.
        :param str client_secret: The strategy's client secret.
        :param str community_base_url: Salesforce community base URL.
        :param Mapping[str, Any] configuration: A case-sensitive map of key value pairs used as configuration variables for the `custom_script`.
        :param Mapping[str, str] custom_scripts: A map of scripts used to integrate with a custom database.
        :param bool debug: When enabled, additional debug information will be generated.
        :param str digest_algorithm: Sign Request Algorithm Digest.
        :param bool disable_cache: Indicates whether to disable the cache or not.
        :param bool disable_sign_out: When enabled, will disable sign out.
        :param bool disable_signup: Indicates whether to allow user sign-ups to your application.
        :param str discovery_url: OpenID discovery URL, e.g. `https://auth.example.com/.well-known/openid-configuration`.
        :param str domain: Domain name.
        :param Sequence[str] domain_aliases: List of the domains that can be authenticated using the identity provider. Only needed for Identifier First authentication flows.
        :param bool enabled_database_customization: Set to `true` to use a legacy user store.
        :param str entity_id: Custom Entity ID for the connection.
        :param str fields_map: If you're configuring a SAML enterprise connection for a non-standard PingFederate Server, you must update the attribute mappings.
        :param bool forward_request_info: Specifies whether or not request info should be forwarded to sms gateway.
        :param str from_: Address to use as the sender.
        :param 'ConnectionOptionsGatewayAuthenticationArgs' gateway_authentication: Defines the parameters used to generate the auth token for the custom gateway.
        :param str gateway_url: Defines a custom sms gateway to use instead of Twilio.
        :param str icon_url: Icon URL.
        :param str identity_api: Azure AD Identity API. Available options are: `microsoft-identity-platform-v2.0` or `azure-active-directory-v1.0`.
        :param 'ConnectionOptionsIdpInitiatedArgs' idp_initiated: Configuration options for IDP Initiated Authentication. This is an object with the properties: `client_id`, `client_protocol`, and `client_authorize_query`.
        :param bool import_mode: Indicates whether you have a legacy user store and want to gradually migrate those users to the Auth0 user store.
        :param Sequence[str] ips: A list of IPs.
        :param str issuer: Issuer URL, e.g. `https://auth.example.com`.
        :param str jwks_uri: JWKS URI.
        :param str key_id: Apple Key ID.
        :param str max_groups_to_retrieve: Maximum number of groups to retrieve.
        :param str messaging_service_sid: SID for Copilot. Used when SMS Source is Copilot.
        :param str metadata_url: The URL of the SAML metadata document.
        :param str metadata_xml: The XML content for the SAML metadata document.
        :param 'ConnectionOptionsMfaArgs' mfa: Configuration options for multifactor authentication.
        :param str name: The public name of the email or SMS Connection. In most cases this is the same name as the connection name.
        :param Sequence[str] non_persistent_attrs: If there are user fields that should not be stored in Auth0 databases due to privacy reasons, you can add them to the DenyList here.
        :param 'ConnectionOptionsPasswordComplexityOptionsArgs' password_complexity_options: Configuration settings for password complexity.
        :param 'ConnectionOptionsPasswordDictionaryArgs' password_dictionary: Configuration settings for the password dictionary check, which does not allow passwords that are part of the password dictionary.
        :param Sequence['ConnectionOptionsPasswordHistoryArgs'] password_histories: Configuration settings for the password history that is maintained for each user to prevent the reuse of passwords.
        :param 'ConnectionOptionsPasswordNoPersonalInfoArgs' password_no_personal_info: Configuration settings for the password personal info check, which does not allow passwords that contain any part of the user's personal data, including user's `name`, `username`, `nickname`, `user_metadata.name`, `user_metadata.first`, `user_metadata.last`, user's `email`, or first part of the user's `email`.
        :param str password_policy: Indicates level of password strength to enforce during authentication. A strong password policy will make it difficult, if not improbable, for someone to guess a password through either manual or automated means. Options include `none`, `low`, `fair`, `good`, `excellent`.
        :param bool pkce_enabled: Enables Proof Key for Code Exchange (PKCE) functionality for OAuth2 connections.
        :param str protocol_binding: The SAML Response Binding: how the SAML token is received by Auth0 from the IdP.
        :param str provider: Defines the custom `sms_gateway` provider.
        :param str request_template: Template that formats the SAML request.
        :param bool requires_username: Indicates whether the user is required to provide a username in addition to an email address.
        :param Sequence[str] scopes: Permissions to grant to the connection. Within the Auth0 dashboard these appear under the "Attributes" and "Extended Attributes" sections. Some examples: `basic_profile`, `ext_profile`, `ext_nested_groups`, etc.
        :param Mapping[str, str] scripts: A map of scripts used for an OAuth connection. Only accepts a `fetchUserProfile` script.
        :param str set_user_root_attributes: Determines whether the 'name', 'given*name', 'family*name', 'nickname', and 'picture' attributes can be independently updated when using an external IdP. Possible values are 'on*each*login' (default value, it configures the connection to automatically update the root attributes from the external IdP with each user login. When this setting is used, root attributes cannot be independently updated), 'on*first*login' (configures the connection to only set the root attributes on first login, allowing them to be independently updated thereafter).
        :param str should_trust_email_verified_connection: Choose how Auth0 sets the email_verified field in the user profile.
        :param str sign_in_endpoint: SAML single login URL for the connection.
        :param str sign_out_endpoint: SAML single logout URL for the connection.
        :param bool sign_saml_request: When enabled, the SAML authentication request will be signed.
        :param str signature_algorithm: Sign Request Algorithm.
        :param str signing_cert: X.509 signing certificate (encoded in PEM or CER) you retrieved from the IdP, Base64-encoded.
        :param 'ConnectionOptionsSigningKeyArgs' signing_key: The key used to sign requests in the connection. Uses the `key` and `cert` properties to provide the private key and certificate respectively.
        :param int strategy_version: Version 1 is deprecated, use version 2.
        :param str subject: Subject line of the email.
        :param str syntax: Syntax of the template body.
        :param str team_id: Apple Team ID.
        :param str template: Body of the template.
        :param str tenant_domain: Tenant domain name.
        :param str token_endpoint: Token endpoint.
        :param 'ConnectionOptionsTotpArgs' totp: Configuration options for one-time passwords.
        :param str twilio_sid: SID for your Twilio account.
        :param str twilio_token: AuthToken for your Twilio account.
        :param str type: Value can be `back_channel` or `front_channel`.
        :param str upstream_params: You can pass provider-specific parameters to an identity provider during authentication. The values can either be static per connection or dynamic per user.
        :param bool use_cert_auth: Indicates whether to use cert auth or not.
        :param bool use_kerberos: Indicates whether to use Kerberos or not.
        :param bool use_wsfed: Whether to use WS-Fed.
        :param str user_id_attribute: Attribute in the SAML token that will be mapped to the user_id property in Auth0.
        :param str userinfo_endpoint: User info endpoint.
        :param 'ConnectionOptionsValidationArgs' validation: Validation of the minimum and maximum values allowed for a user to have as username.
        :param bool waad_common_endpoint: Indicates whether to use the common endpoint rather than the default endpoint. Typically enabled if you're using this for a multi-tenant application in Azure AD.
        :param str waad_protocol: Protocol to use.
        """
        if adfs_server is not None:
            pulumi.set(__self__, "adfs_server", adfs_server)
        if allowed_audiences is not None:
            pulumi.set(__self__, "allowed_audiences", allowed_audiences)
        if api_enable_users is not None:
            pulumi.set(__self__, "api_enable_users", api_enable_users)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if auth_params is not None:
            pulumi.set(__self__, "auth_params", auth_params)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if brute_force_protection is not None:
            pulumi.set(__self__, "brute_force_protection", brute_force_protection)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if community_base_url is not None:
            pulumi.set(__self__, "community_base_url", community_base_url)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if custom_scripts is not None:
            pulumi.set(__self__, "custom_scripts", custom_scripts)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if digest_algorithm is not None:
            pulumi.set(__self__, "digest_algorithm", digest_algorithm)
        if disable_cache is not None:
            pulumi.set(__self__, "disable_cache", disable_cache)
        if disable_sign_out is not None:
            pulumi.set(__self__, "disable_sign_out", disable_sign_out)
        if disable_signup is not None:
            pulumi.set(__self__, "disable_signup", disable_signup)
        if discovery_url is not None:
            pulumi.set(__self__, "discovery_url", discovery_url)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_aliases is not None:
            pulumi.set(__self__, "domain_aliases", domain_aliases)
        if enabled_database_customization is not None:
            pulumi.set(__self__, "enabled_database_customization", enabled_database_customization)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if fields_map is not None:
            pulumi.set(__self__, "fields_map", fields_map)
        if forward_request_info is not None:
            pulumi.set(__self__, "forward_request_info", forward_request_info)
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if gateway_authentication is not None:
            pulumi.set(__self__, "gateway_authentication", gateway_authentication)
        if gateway_url is not None:
            pulumi.set(__self__, "gateway_url", gateway_url)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if identity_api is not None:
            pulumi.set(__self__, "identity_api", identity_api)
        if idp_initiated is not None:
            pulumi.set(__self__, "idp_initiated", idp_initiated)
        if import_mode is not None:
            pulumi.set(__self__, "import_mode", import_mode)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwks_uri is not None:
            pulumi.set(__self__, "jwks_uri", jwks_uri)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if max_groups_to_retrieve is not None:
            pulumi.set(__self__, "max_groups_to_retrieve", max_groups_to_retrieve)
        if messaging_service_sid is not None:
            pulumi.set(__self__, "messaging_service_sid", messaging_service_sid)
        if metadata_url is not None:
            pulumi.set(__self__, "metadata_url", metadata_url)
        if metadata_xml is not None:
            pulumi.set(__self__, "metadata_xml", metadata_xml)
        if mfa is not None:
            pulumi.set(__self__, "mfa", mfa)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if non_persistent_attrs is not None:
            pulumi.set(__self__, "non_persistent_attrs", non_persistent_attrs)
        if password_complexity_options is not None:
            pulumi.set(__self__, "password_complexity_options", password_complexity_options)
        if password_dictionary is not None:
            pulumi.set(__self__, "password_dictionary", password_dictionary)
        if password_histories is not None:
            pulumi.set(__self__, "password_histories", password_histories)
        if password_no_personal_info is not None:
            pulumi.set(__self__, "password_no_personal_info", password_no_personal_info)
        if password_policy is not None:
            pulumi.set(__self__, "password_policy", password_policy)
        if pkce_enabled is not None:
            pulumi.set(__self__, "pkce_enabled", pkce_enabled)
        if protocol_binding is not None:
            pulumi.set(__self__, "protocol_binding", protocol_binding)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)
        if request_template is not None:
            pulumi.set(__self__, "request_template", request_template)
        if requires_username is not None:
            pulumi.set(__self__, "requires_username", requires_username)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if scripts is not None:
            pulumi.set(__self__, "scripts", scripts)
        if set_user_root_attributes is not None:
            pulumi.set(__self__, "set_user_root_attributes", set_user_root_attributes)
        if should_trust_email_verified_connection is not None:
            pulumi.set(__self__, "should_trust_email_verified_connection", should_trust_email_verified_connection)
        if sign_in_endpoint is not None:
            pulumi.set(__self__, "sign_in_endpoint", sign_in_endpoint)
        if sign_out_endpoint is not None:
            pulumi.set(__self__, "sign_out_endpoint", sign_out_endpoint)
        if sign_saml_request is not None:
            pulumi.set(__self__, "sign_saml_request", sign_saml_request)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if signing_cert is not None:
            pulumi.set(__self__, "signing_cert", signing_cert)
        if signing_key is not None:
            pulumi.set(__self__, "signing_key", signing_key)
        if strategy_version is not None:
            pulumi.set(__self__, "strategy_version", strategy_version)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if syntax is not None:
            pulumi.set(__self__, "syntax", syntax)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if tenant_domain is not None:
            pulumi.set(__self__, "tenant_domain", tenant_domain)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if totp is not None:
            pulumi.set(__self__, "totp", totp)
        if twilio_sid is not None:
            pulumi.set(__self__, "twilio_sid", twilio_sid)
        if twilio_token is not None:
            pulumi.set(__self__, "twilio_token", twilio_token)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if upstream_params is not None:
            pulumi.set(__self__, "upstream_params", upstream_params)
        if use_cert_auth is not None:
            pulumi.set(__self__, "use_cert_auth", use_cert_auth)
        if use_kerberos is not None:
            pulumi.set(__self__, "use_kerberos", use_kerberos)
        if use_wsfed is not None:
            pulumi.set(__self__, "use_wsfed", use_wsfed)
        if user_id_attribute is not None:
            pulumi.set(__self__, "user_id_attribute", user_id_attribute)
        if userinfo_endpoint is not None:
            pulumi.set(__self__, "userinfo_endpoint", userinfo_endpoint)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)
        if waad_common_endpoint is not None:
            pulumi.set(__self__, "waad_common_endpoint", waad_common_endpoint)
        if waad_protocol is not None:
            pulumi.set(__self__, "waad_protocol", waad_protocol)

    @property
    @pulumi.getter(name="adfsServer")
    def adfs_server(self) -> Optional[str]:
        """
        ADFS Metadata source.
        """
        return pulumi.get(self, "adfs_server")

    @property
    @pulumi.getter(name="allowedAudiences")
    def allowed_audiences(self) -> Optional[Sequence[str]]:
        """
        List of allowed audiences.
        """
        return pulumi.get(self, "allowed_audiences")

    @property
    @pulumi.getter(name="apiEnableUsers")
    def api_enable_users(self) -> Optional[bool]:
        """
        Enable API Access to users.
        """
        return pulumi.get(self, "api_enable_users")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[str]:
        """
        App ID.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="authParams")
    def auth_params(self) -> Optional[Mapping[str, str]]:
        """
        Query string parameters to be included as part of the generated passwordless email link.
        """
        return pulumi.get(self, "auth_params")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        Authorization endpoint.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="bruteForceProtection")
    def brute_force_protection(self) -> Optional[bool]:
        """
        Indicates whether to enable brute force protection, which will limit the number of signups and failed logins from a suspicious IP address.
        """
        return pulumi.get(self, "brute_force_protection")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The strategy's client ID.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The strategy's client secret.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="communityBaseUrl")
    def community_base_url(self) -> Optional[str]:
        """
        Salesforce community base URL.
        """
        return pulumi.get(self, "community_base_url")

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Mapping[str, Any]]:
        """
        A case-sensitive map of key value pairs used as configuration variables for the `custom_script`.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="customScripts")
    def custom_scripts(self) -> Optional[Mapping[str, str]]:
        """
        A map of scripts used to integrate with a custom database.
        """
        return pulumi.get(self, "custom_scripts")

    @property
    @pulumi.getter
    def debug(self) -> Optional[bool]:
        """
        When enabled, additional debug information will be generated.
        """
        return pulumi.get(self, "debug")

    @property
    @pulumi.getter(name="digestAlgorithm")
    def digest_algorithm(self) -> Optional[str]:
        """
        Sign Request Algorithm Digest.
        """
        return pulumi.get(self, "digest_algorithm")

    @property
    @pulumi.getter(name="disableCache")
    def disable_cache(self) -> Optional[bool]:
        """
        Indicates whether to disable the cache or not.
        """
        return pulumi.get(self, "disable_cache")

    @property
    @pulumi.getter(name="disableSignOut")
    def disable_sign_out(self) -> Optional[bool]:
        """
        When enabled, will disable sign out.
        """
        return pulumi.get(self, "disable_sign_out")

    @property
    @pulumi.getter(name="disableSignup")
    def disable_signup(self) -> Optional[bool]:
        """
        Indicates whether to allow user sign-ups to your application.
        """
        return pulumi.get(self, "disable_signup")

    @property
    @pulumi.getter(name="discoveryUrl")
    def discovery_url(self) -> Optional[str]:
        """
        OpenID discovery URL, e.g. `https://auth.example.com/.well-known/openid-configuration`.
        """
        return pulumi.get(self, "discovery_url")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        Domain name.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainAliases")
    def domain_aliases(self) -> Optional[Sequence[str]]:
        """
        List of the domains that can be authenticated using the identity provider. Only needed for Identifier First authentication flows.
        """
        return pulumi.get(self, "domain_aliases")

    @property
    @pulumi.getter(name="enabledDatabaseCustomization")
    def enabled_database_customization(self) -> Optional[bool]:
        """
        Set to `true` to use a legacy user store.
        """
        return pulumi.get(self, "enabled_database_customization")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[str]:
        """
        Custom Entity ID for the connection.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter(name="fieldsMap")
    def fields_map(self) -> Optional[str]:
        """
        If you're configuring a SAML enterprise connection for a non-standard PingFederate Server, you must update the attribute mappings.
        """
        return pulumi.get(self, "fields_map")

    @property
    @pulumi.getter(name="forwardRequestInfo")
    def forward_request_info(self) -> Optional[bool]:
        """
        Specifies whether or not request info should be forwarded to sms gateway.
        """
        return pulumi.get(self, "forward_request_info")

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[str]:
        """
        Address to use as the sender.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter(name="gatewayAuthentication")
    def gateway_authentication(self) -> Optional['outputs.ConnectionOptionsGatewayAuthentication']:
        """
        Defines the parameters used to generate the auth token for the custom gateway.
        """
        return pulumi.get(self, "gateway_authentication")

    @property
    @pulumi.getter(name="gatewayUrl")
    def gateway_url(self) -> Optional[str]:
        """
        Defines a custom sms gateway to use instead of Twilio.
        """
        return pulumi.get(self, "gateway_url")

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[str]:
        """
        Icon URL.
        """
        return pulumi.get(self, "icon_url")

    @property
    @pulumi.getter(name="identityApi")
    def identity_api(self) -> Optional[str]:
        """
        Azure AD Identity API. Available options are: `microsoft-identity-platform-v2.0` or `azure-active-directory-v1.0`.
        """
        return pulumi.get(self, "identity_api")

    @property
    @pulumi.getter(name="idpInitiated")
    def idp_initiated(self) -> Optional['outputs.ConnectionOptionsIdpInitiated']:
        """
        Configuration options for IDP Initiated Authentication. This is an object with the properties: `client_id`, `client_protocol`, and `client_authorize_query`.
        """
        return pulumi.get(self, "idp_initiated")

    @property
    @pulumi.getter(name="importMode")
    def import_mode(self) -> Optional[bool]:
        """
        Indicates whether you have a legacy user store and want to gradually migrate those users to the Auth0 user store.
        """
        return pulumi.get(self, "import_mode")

    @property
    @pulumi.getter
    def ips(self) -> Optional[Sequence[str]]:
        """
        A list of IPs.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        """
        Issuer URL, e.g. `https://auth.example.com`.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwksUri")
    def jwks_uri(self) -> Optional[str]:
        """
        JWKS URI.
        """
        return pulumi.get(self, "jwks_uri")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[str]:
        """
        Apple Key ID.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="maxGroupsToRetrieve")
    def max_groups_to_retrieve(self) -> Optional[str]:
        """
        Maximum number of groups to retrieve.
        """
        return pulumi.get(self, "max_groups_to_retrieve")

    @property
    @pulumi.getter(name="messagingServiceSid")
    def messaging_service_sid(self) -> Optional[str]:
        """
        SID for Copilot. Used when SMS Source is Copilot.
        """
        return pulumi.get(self, "messaging_service_sid")

    @property
    @pulumi.getter(name="metadataUrl")
    def metadata_url(self) -> Optional[str]:
        """
        The URL of the SAML metadata document.
        """
        return pulumi.get(self, "metadata_url")

    @property
    @pulumi.getter(name="metadataXml")
    def metadata_xml(self) -> Optional[str]:
        """
        The XML content for the SAML metadata document.
        """
        return pulumi.get(self, "metadata_xml")

    @property
    @pulumi.getter
    def mfa(self) -> Optional['outputs.ConnectionOptionsMfa']:
        """
        Configuration options for multifactor authentication.
        """
        return pulumi.get(self, "mfa")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The public name of the email or SMS Connection. In most cases this is the same name as the connection name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nonPersistentAttrs")
    def non_persistent_attrs(self) -> Optional[Sequence[str]]:
        """
        If there are user fields that should not be stored in Auth0 databases due to privacy reasons, you can add them to the DenyList here.
        """
        return pulumi.get(self, "non_persistent_attrs")

    @property
    @pulumi.getter(name="passwordComplexityOptions")
    def password_complexity_options(self) -> Optional['outputs.ConnectionOptionsPasswordComplexityOptions']:
        """
        Configuration settings for password complexity.
        """
        return pulumi.get(self, "password_complexity_options")

    @property
    @pulumi.getter(name="passwordDictionary")
    def password_dictionary(self) -> Optional['outputs.ConnectionOptionsPasswordDictionary']:
        """
        Configuration settings for the password dictionary check, which does not allow passwords that are part of the password dictionary.
        """
        return pulumi.get(self, "password_dictionary")

    @property
    @pulumi.getter(name="passwordHistories")
    def password_histories(self) -> Optional[Sequence['outputs.ConnectionOptionsPasswordHistory']]:
        """
        Configuration settings for the password history that is maintained for each user to prevent the reuse of passwords.
        """
        return pulumi.get(self, "password_histories")

    @property
    @pulumi.getter(name="passwordNoPersonalInfo")
    def password_no_personal_info(self) -> Optional['outputs.ConnectionOptionsPasswordNoPersonalInfo']:
        """
        Configuration settings for the password personal info check, which does not allow passwords that contain any part of the user's personal data, including user's `name`, `username`, `nickname`, `user_metadata.name`, `user_metadata.first`, `user_metadata.last`, user's `email`, or first part of the user's `email`.
        """
        return pulumi.get(self, "password_no_personal_info")

    @property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> Optional[str]:
        """
        Indicates level of password strength to enforce during authentication. A strong password policy will make it difficult, if not improbable, for someone to guess a password through either manual or automated means. Options include `none`, `low`, `fair`, `good`, `excellent`.
        """
        return pulumi.get(self, "password_policy")

    @property
    @pulumi.getter(name="pkceEnabled")
    def pkce_enabled(self) -> Optional[bool]:
        """
        Enables Proof Key for Code Exchange (PKCE) functionality for OAuth2 connections.
        """
        return pulumi.get(self, "pkce_enabled")

    @property
    @pulumi.getter(name="protocolBinding")
    def protocol_binding(self) -> Optional[str]:
        """
        The SAML Response Binding: how the SAML token is received by Auth0 from the IdP.
        """
        return pulumi.get(self, "protocol_binding")

    @property
    @pulumi.getter
    def provider(self) -> Optional[str]:
        """
        Defines the custom `sms_gateway` provider.
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter(name="requestTemplate")
    def request_template(self) -> Optional[str]:
        """
        Template that formats the SAML request.
        """
        return pulumi.get(self, "request_template")

    @property
    @pulumi.getter(name="requiresUsername")
    def requires_username(self) -> Optional[bool]:
        """
        Indicates whether the user is required to provide a username in addition to an email address.
        """
        return pulumi.get(self, "requires_username")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        Permissions to grant to the connection. Within the Auth0 dashboard these appear under the "Attributes" and "Extended Attributes" sections. Some examples: `basic_profile`, `ext_profile`, `ext_nested_groups`, etc.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def scripts(self) -> Optional[Mapping[str, str]]:
        """
        A map of scripts used for an OAuth connection. Only accepts a `fetchUserProfile` script.
        """
        return pulumi.get(self, "scripts")

    @property
    @pulumi.getter(name="setUserRootAttributes")
    def set_user_root_attributes(self) -> Optional[str]:
        """
        Determines whether the 'name', 'given*name', 'family*name', 'nickname', and 'picture' attributes can be independently updated when using an external IdP. Possible values are 'on*each*login' (default value, it configures the connection to automatically update the root attributes from the external IdP with each user login. When this setting is used, root attributes cannot be independently updated), 'on*first*login' (configures the connection to only set the root attributes on first login, allowing them to be independently updated thereafter).
        """
        return pulumi.get(self, "set_user_root_attributes")

    @property
    @pulumi.getter(name="shouldTrustEmailVerifiedConnection")
    def should_trust_email_verified_connection(self) -> Optional[str]:
        """
        Choose how Auth0 sets the email_verified field in the user profile.
        """
        return pulumi.get(self, "should_trust_email_verified_connection")

    @property
    @pulumi.getter(name="signInEndpoint")
    def sign_in_endpoint(self) -> Optional[str]:
        """
        SAML single login URL for the connection.
        """
        return pulumi.get(self, "sign_in_endpoint")

    @property
    @pulumi.getter(name="signOutEndpoint")
    def sign_out_endpoint(self) -> Optional[str]:
        """
        SAML single logout URL for the connection.
        """
        return pulumi.get(self, "sign_out_endpoint")

    @property
    @pulumi.getter(name="signSamlRequest")
    def sign_saml_request(self) -> Optional[bool]:
        """
        When enabled, the SAML authentication request will be signed.
        """
        return pulumi.get(self, "sign_saml_request")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[str]:
        """
        Sign Request Algorithm.
        """
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter(name="signingCert")
    def signing_cert(self) -> Optional[str]:
        """
        X.509 signing certificate (encoded in PEM or CER) you retrieved from the IdP, Base64-encoded.
        """
        return pulumi.get(self, "signing_cert")

    @property
    @pulumi.getter(name="signingKey")
    def signing_key(self) -> Optional['outputs.ConnectionOptionsSigningKey']:
        """
        The key used to sign requests in the connection. Uses the `key` and `cert` properties to provide the private key and certificate respectively.
        """
        return pulumi.get(self, "signing_key")

    @property
    @pulumi.getter(name="strategyVersion")
    def strategy_version(self) -> Optional[int]:
        """
        Version 1 is deprecated, use version 2.
        """
        return pulumi.get(self, "strategy_version")

    @property
    @pulumi.getter
    def subject(self) -> Optional[str]:
        """
        Subject line of the email.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def syntax(self) -> Optional[str]:
        """
        Syntax of the template body.
        """
        return pulumi.get(self, "syntax")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[str]:
        """
        Apple Team ID.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter
    def template(self) -> Optional[str]:
        """
        Body of the template.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="tenantDomain")
    def tenant_domain(self) -> Optional[str]:
        """
        Tenant domain name.
        """
        return pulumi.get(self, "tenant_domain")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[str]:
        """
        Token endpoint.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter
    def totp(self) -> Optional['outputs.ConnectionOptionsTotp']:
        """
        Configuration options for one-time passwords.
        """
        return pulumi.get(self, "totp")

    @property
    @pulumi.getter(name="twilioSid")
    def twilio_sid(self) -> Optional[str]:
        """
        SID for your Twilio account.
        """
        return pulumi.get(self, "twilio_sid")

    @property
    @pulumi.getter(name="twilioToken")
    def twilio_token(self) -> Optional[str]:
        """
        AuthToken for your Twilio account.
        """
        return pulumi.get(self, "twilio_token")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Value can be `back_channel` or `front_channel`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="upstreamParams")
    def upstream_params(self) -> Optional[str]:
        """
        You can pass provider-specific parameters to an identity provider during authentication. The values can either be static per connection or dynamic per user.
        """
        return pulumi.get(self, "upstream_params")

    @property
    @pulumi.getter(name="useCertAuth")
    def use_cert_auth(self) -> Optional[bool]:
        """
        Indicates whether to use cert auth or not.
        """
        return pulumi.get(self, "use_cert_auth")

    @property
    @pulumi.getter(name="useKerberos")
    def use_kerberos(self) -> Optional[bool]:
        """
        Indicates whether to use Kerberos or not.
        """
        return pulumi.get(self, "use_kerberos")

    @property
    @pulumi.getter(name="useWsfed")
    def use_wsfed(self) -> Optional[bool]:
        """
        Whether to use WS-Fed.
        """
        return pulumi.get(self, "use_wsfed")

    @property
    @pulumi.getter(name="userIdAttribute")
    def user_id_attribute(self) -> Optional[str]:
        """
        Attribute in the SAML token that will be mapped to the user_id property in Auth0.
        """
        return pulumi.get(self, "user_id_attribute")

    @property
    @pulumi.getter(name="userinfoEndpoint")
    def userinfo_endpoint(self) -> Optional[str]:
        """
        User info endpoint.
        """
        return pulumi.get(self, "userinfo_endpoint")

    @property
    @pulumi.getter
    def validation(self) -> Optional['outputs.ConnectionOptionsValidation']:
        """
        Validation of the minimum and maximum values allowed for a user to have as username.
        """
        return pulumi.get(self, "validation")

    @property
    @pulumi.getter(name="waadCommonEndpoint")
    def waad_common_endpoint(self) -> Optional[bool]:
        """
        Indicates whether to use the common endpoint rather than the default endpoint. Typically enabled if you're using this for a multi-tenant application in Azure AD.
        """
        return pulumi.get(self, "waad_common_endpoint")

    @property
    @pulumi.getter(name="waadProtocol")
    def waad_protocol(self) -> Optional[str]:
        """
        Protocol to use.
        """
        return pulumi.get(self, "waad_protocol")


@pulumi.output_type
class ConnectionOptionsGatewayAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretBase64Encoded":
            suggest = "secret_base64_encoded"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionOptionsGatewayAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionOptionsGatewayAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionOptionsGatewayAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audience: Optional[str] = None,
                 method: Optional[str] = None,
                 secret: Optional[str] = None,
                 secret_base64_encoded: Optional[bool] = None,
                 subject: Optional[str] = None):
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if secret_base64_encoded is not None:
            pulumi.set(__self__, "secret_base64_encoded", secret_base64_encoded)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @property
    @pulumi.getter
    def audience(self) -> Optional[str]:
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def secret(self) -> Optional[str]:
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="secretBase64Encoded")
    def secret_base64_encoded(self) -> Optional[bool]:
        return pulumi.get(self, "secret_base64_encoded")

    @property
    @pulumi.getter
    def subject(self) -> Optional[str]:
        return pulumi.get(self, "subject")


@pulumi.output_type
class ConnectionOptionsIdpInitiated(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAuthorizeQuery":
            suggest = "client_authorize_query"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientProtocol":
            suggest = "client_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionOptionsIdpInitiated. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionOptionsIdpInitiated.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionOptionsIdpInitiated.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_authorize_query: Optional[str] = None,
                 client_id: Optional[str] = None,
                 client_protocol: Optional[str] = None):
        if client_authorize_query is not None:
            pulumi.set(__self__, "client_authorize_query", client_authorize_query)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_protocol is not None:
            pulumi.set(__self__, "client_protocol", client_protocol)

    @property
    @pulumi.getter(name="clientAuthorizeQuery")
    def client_authorize_query(self) -> Optional[str]:
        return pulumi.get(self, "client_authorize_query")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientProtocol")
    def client_protocol(self) -> Optional[str]:
        return pulumi.get(self, "client_protocol")


@pulumi.output_type
class ConnectionOptionsMfa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "returnEnrollSettings":
            suggest = "return_enroll_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionOptionsMfa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionOptionsMfa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionOptionsMfa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active: Optional[bool] = None,
                 return_enroll_settings: Optional[bool] = None):
        if active is not None:
            pulumi.set(__self__, "active", active)
        if return_enroll_settings is not None:
            pulumi.set(__self__, "return_enroll_settings", return_enroll_settings)

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="returnEnrollSettings")
    def return_enroll_settings(self) -> Optional[bool]:
        return pulumi.get(self, "return_enroll_settings")


@pulumi.output_type
class ConnectionOptionsPasswordComplexityOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minLength":
            suggest = "min_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionOptionsPasswordComplexityOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionOptionsPasswordComplexityOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionOptionsPasswordComplexityOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_length: Optional[int] = None):
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[int]:
        return pulumi.get(self, "min_length")


@pulumi.output_type
class ConnectionOptionsPasswordDictionary(dict):
    def __init__(__self__, *,
                 dictionaries: Optional[Sequence[str]] = None,
                 enable: Optional[bool] = None):
        if dictionaries is not None:
            pulumi.set(__self__, "dictionaries", dictionaries)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)

    @property
    @pulumi.getter
    def dictionaries(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "dictionaries")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        return pulumi.get(self, "enable")


@pulumi.output_type
class ConnectionOptionsPasswordHistory(dict):
    def __init__(__self__, *,
                 enable: Optional[bool] = None,
                 size: Optional[int] = None):
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        return pulumi.get(self, "size")


@pulumi.output_type
class ConnectionOptionsPasswordNoPersonalInfo(dict):
    def __init__(__self__, *,
                 enable: Optional[bool] = None):
        if enable is not None:
            pulumi.set(__self__, "enable", enable)

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        return pulumi.get(self, "enable")


@pulumi.output_type
class ConnectionOptionsSigningKey(dict):
    def __init__(__self__, *,
                 cert: str,
                 key: str):
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def cert(self) -> str:
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")


@pulumi.output_type
class ConnectionOptionsTotp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeStep":
            suggest = "time_step"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionOptionsTotp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionOptionsTotp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionOptionsTotp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 length: Optional[int] = None,
                 time_step: Optional[int] = None):
        if length is not None:
            pulumi.set(__self__, "length", length)
        if time_step is not None:
            pulumi.set(__self__, "time_step", time_step)

    @property
    @pulumi.getter
    def length(self) -> Optional[int]:
        return pulumi.get(self, "length")

    @property
    @pulumi.getter(name="timeStep")
    def time_step(self) -> Optional[int]:
        return pulumi.get(self, "time_step")


@pulumi.output_type
class ConnectionOptionsValidation(dict):
    def __init__(__self__, *,
                 username: Optional['outputs.ConnectionOptionsValidationUsername'] = None):
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def username(self) -> Optional['outputs.ConnectionOptionsValidationUsername']:
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionOptionsValidationUsername(dict):
    def __init__(__self__, *,
                 max: Optional[int] = None,
                 min: Optional[int] = None):
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[int]:
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[int]:
        return pulumi.get(self, "min")


@pulumi.output_type
class CustomDomainVerification(dict):
    def __init__(__self__, *,
                 methods: Optional[Sequence[Any]] = None):
        if methods is not None:
            pulumi.set(__self__, "methods", methods)

    @property
    @pulumi.getter
    def methods(self) -> Optional[Sequence[Any]]:
        return pulumi.get(self, "methods")


@pulumi.output_type
class EmailCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "apiKey":
            suggest = "api_key"
        elif key == "apiUser":
            suggest = "api_user"
        elif key == "secretAccessKey":
            suggest = "secret_access_key"
        elif key == "smtpHost":
            suggest = "smtp_host"
        elif key == "smtpPass":
            suggest = "smtp_pass"
        elif key == "smtpPort":
            suggest = "smtp_port"
        elif key == "smtpUser":
            suggest = "smtp_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: Optional[str] = None,
                 api_key: Optional[str] = None,
                 api_user: Optional[str] = None,
                 domain: Optional[str] = None,
                 region: Optional[str] = None,
                 secret_access_key: Optional[str] = None,
                 smtp_host: Optional[str] = None,
                 smtp_pass: Optional[str] = None,
                 smtp_port: Optional[int] = None,
                 smtp_user: Optional[str] = None):
        """
        :param str access_key_id: AWS Access Key ID. Used only for AWS.
        :param str api_key: API Key for your email service. Will always be encrypted in our database.
        :param str api_user: API User for your email service.
        :param str domain: Domain name.
        :param str region: Default region. Used only for AWS, Mailgun, and SparkPost.
        :param str secret_access_key: AWS Secret Key. Will always be encrypted in our database. Used only for AWS.
        :param str smtp_host: Hostname or IP address of your SMTP server. Used only for SMTP.
        :param str smtp_pass: SMTP password. Used only for SMTP.
        :param int smtp_port: Port used by your SMTP server. Please avoid using port 25 if possible because many providers have limitations on this port. Used only for SMTP.
        :param str smtp_user: SMTP username. Used only for SMTP.
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_user is not None:
            pulumi.set(__self__, "api_user", api_user)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if smtp_host is not None:
            pulumi.set(__self__, "smtp_host", smtp_host)
        if smtp_pass is not None:
            pulumi.set(__self__, "smtp_pass", smtp_pass)
        if smtp_port is not None:
            pulumi.set(__self__, "smtp_port", smtp_port)
        if smtp_user is not None:
            pulumi.set(__self__, "smtp_user", smtp_user)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[str]:
        """
        AWS Access Key ID. Used only for AWS.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key for your email service. Will always be encrypted in our database.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="apiUser")
    def api_user(self) -> Optional[str]:
        """
        API User for your email service.
        """
        return pulumi.get(self, "api_user")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        Domain name.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Default region. Used only for AWS, Mailgun, and SparkPost.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[str]:
        """
        AWS Secret Key. Will always be encrypted in our database. Used only for AWS.
        """
        return pulumi.get(self, "secret_access_key")

    @property
    @pulumi.getter(name="smtpHost")
    def smtp_host(self) -> Optional[str]:
        """
        Hostname or IP address of your SMTP server. Used only for SMTP.
        """
        return pulumi.get(self, "smtp_host")

    @property
    @pulumi.getter(name="smtpPass")
    def smtp_pass(self) -> Optional[str]:
        """
        SMTP password. Used only for SMTP.
        """
        return pulumi.get(self, "smtp_pass")

    @property
    @pulumi.getter(name="smtpPort")
    def smtp_port(self) -> Optional[int]:
        """
        Port used by your SMTP server. Please avoid using port 25 if possible because many providers have limitations on this port. Used only for SMTP.
        """
        return pulumi.get(self, "smtp_port")

    @property
    @pulumi.getter(name="smtpUser")
    def smtp_user(self) -> Optional[str]:
        """
        SMTP username. Used only for SMTP.
        """
        return pulumi.get(self, "smtp_user")


@pulumi.output_type
class EmailSettings(dict):
    def __init__(__self__, *,
                 headers: Optional['outputs.EmailSettingsHeaders'] = None,
                 message: Optional['outputs.EmailSettingsMessage'] = None):
        """
        :param 'EmailSettingsHeadersArgs' headers: Headers settings for the `smtp` email provider.
        :param 'EmailSettingsMessageArgs' message: Message settings for the `mandrill` or `ses` email provider.
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def headers(self) -> Optional['outputs.EmailSettingsHeaders']:
        """
        Headers settings for the `smtp` email provider.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def message(self) -> Optional['outputs.EmailSettingsMessage']:
        """
        Message settings for the `mandrill` or `ses` email provider.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class EmailSettingsHeaders(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "xMcViewContentLink":
            suggest = "x_mc_view_content_link"
        elif key == "xSesConfigurationSet":
            suggest = "x_ses_configuration_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailSettingsHeaders. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailSettingsHeaders.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailSettingsHeaders.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 x_mc_view_content_link: Optional[str] = None,
                 x_ses_configuration_set: Optional[str] = None):
        if x_mc_view_content_link is not None:
            pulumi.set(__self__, "x_mc_view_content_link", x_mc_view_content_link)
        if x_ses_configuration_set is not None:
            pulumi.set(__self__, "x_ses_configuration_set", x_ses_configuration_set)

    @property
    @pulumi.getter(name="xMcViewContentLink")
    def x_mc_view_content_link(self) -> Optional[str]:
        return pulumi.get(self, "x_mc_view_content_link")

    @property
    @pulumi.getter(name="xSesConfigurationSet")
    def x_ses_configuration_set(self) -> Optional[str]:
        return pulumi.get(self, "x_ses_configuration_set")


@pulumi.output_type
class EmailSettingsMessage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationSetName":
            suggest = "configuration_set_name"
        elif key == "viewContentLink":
            suggest = "view_content_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailSettingsMessage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailSettingsMessage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailSettingsMessage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_set_name: Optional[str] = None,
                 view_content_link: Optional[bool] = None):
        if configuration_set_name is not None:
            pulumi.set(__self__, "configuration_set_name", configuration_set_name)
        if view_content_link is not None:
            pulumi.set(__self__, "view_content_link", view_content_link)

    @property
    @pulumi.getter(name="configurationSetName")
    def configuration_set_name(self) -> Optional[str]:
        return pulumi.get(self, "configuration_set_name")

    @property
    @pulumi.getter(name="viewContentLink")
    def view_content_link(self) -> Optional[bool]:
        return pulumi.get(self, "view_content_link")


@pulumi.output_type
class GlobalClientAddons(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureBlob":
            suggest = "azure_blob"
        elif key == "azureSb":
            suggest = "azure_sb"
        elif key == "salesforceApi":
            suggest = "salesforce_api"
        elif key == "salesforceSandboxApi":
            suggest = "salesforce_sandbox_api"
        elif key == "sapApi":
            suggest = "sap_api"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalClientAddons. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalClientAddons.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalClientAddons.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws: Optional[Mapping[str, Any]] = None,
                 azure_blob: Optional[Mapping[str, Any]] = None,
                 azure_sb: Optional[Mapping[str, Any]] = None,
                 box: Optional[Mapping[str, Any]] = None,
                 cloudbees: Optional[Mapping[str, Any]] = None,
                 concur: Optional[Mapping[str, Any]] = None,
                 dropbox: Optional[Mapping[str, Any]] = None,
                 echosign: Optional[Mapping[str, Any]] = None,
                 egnyte: Optional[Mapping[str, Any]] = None,
                 firebase: Optional[Mapping[str, Any]] = None,
                 layer: Optional[Mapping[str, Any]] = None,
                 mscrm: Optional[Mapping[str, Any]] = None,
                 newrelic: Optional[Mapping[str, Any]] = None,
                 office365: Optional[Mapping[str, Any]] = None,
                 rms: Optional[Mapping[str, Any]] = None,
                 salesforce: Optional[Mapping[str, Any]] = None,
                 salesforce_api: Optional[Mapping[str, Any]] = None,
                 salesforce_sandbox_api: Optional[Mapping[str, Any]] = None,
                 samlp: Optional['outputs.GlobalClientAddonsSamlp'] = None,
                 sap_api: Optional[Mapping[str, Any]] = None,
                 sentry: Optional[Mapping[str, Any]] = None,
                 sharepoint: Optional[Mapping[str, Any]] = None,
                 slack: Optional[Mapping[str, Any]] = None,
                 springcm: Optional[Mapping[str, Any]] = None,
                 wams: Optional[Mapping[str, Any]] = None,
                 wsfed: Optional[Mapping[str, Any]] = None,
                 zendesk: Optional[Mapping[str, Any]] = None,
                 zoom: Optional[Mapping[str, Any]] = None):
        """
        :param 'GlobalClientAddonsSamlpArgs' samlp: Configuration settings for a SAML add-on.
        :param Mapping[str, Any] wsfed: WS-Fed (WIF) addon indicator. Actual configuration is stored in callback and `client_aliases` properties on the client.
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure_blob is not None:
            pulumi.set(__self__, "azure_blob", azure_blob)
        if azure_sb is not None:
            pulumi.set(__self__, "azure_sb", azure_sb)
        if box is not None:
            pulumi.set(__self__, "box", box)
        if cloudbees is not None:
            pulumi.set(__self__, "cloudbees", cloudbees)
        if concur is not None:
            pulumi.set(__self__, "concur", concur)
        if dropbox is not None:
            pulumi.set(__self__, "dropbox", dropbox)
        if echosign is not None:
            pulumi.set(__self__, "echosign", echosign)
        if egnyte is not None:
            pulumi.set(__self__, "egnyte", egnyte)
        if firebase is not None:
            pulumi.set(__self__, "firebase", firebase)
        if layer is not None:
            pulumi.set(__self__, "layer", layer)
        if mscrm is not None:
            pulumi.set(__self__, "mscrm", mscrm)
        if newrelic is not None:
            pulumi.set(__self__, "newrelic", newrelic)
        if office365 is not None:
            pulumi.set(__self__, "office365", office365)
        if rms is not None:
            pulumi.set(__self__, "rms", rms)
        if salesforce is not None:
            pulumi.set(__self__, "salesforce", salesforce)
        if salesforce_api is not None:
            pulumi.set(__self__, "salesforce_api", salesforce_api)
        if salesforce_sandbox_api is not None:
            pulumi.set(__self__, "salesforce_sandbox_api", salesforce_sandbox_api)
        if samlp is not None:
            pulumi.set(__self__, "samlp", samlp)
        if sap_api is not None:
            pulumi.set(__self__, "sap_api", sap_api)
        if sentry is not None:
            pulumi.set(__self__, "sentry", sentry)
        if sharepoint is not None:
            pulumi.set(__self__, "sharepoint", sharepoint)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if springcm is not None:
            pulumi.set(__self__, "springcm", springcm)
        if wams is not None:
            pulumi.set(__self__, "wams", wams)
        if wsfed is not None:
            pulumi.set(__self__, "wsfed", wsfed)
        if zendesk is not None:
            pulumi.set(__self__, "zendesk", zendesk)
        if zoom is not None:
            pulumi.set(__self__, "zoom", zoom)

    @property
    @pulumi.getter
    def aws(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter(name="azureBlob")
    def azure_blob(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "azure_blob")

    @property
    @pulumi.getter(name="azureSb")
    def azure_sb(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "azure_sb")

    @property
    @pulumi.getter
    def box(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "box")

    @property
    @pulumi.getter
    def cloudbees(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "cloudbees")

    @property
    @pulumi.getter
    def concur(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "concur")

    @property
    @pulumi.getter
    def dropbox(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "dropbox")

    @property
    @pulumi.getter
    def echosign(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "echosign")

    @property
    @pulumi.getter
    def egnyte(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "egnyte")

    @property
    @pulumi.getter
    def firebase(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "firebase")

    @property
    @pulumi.getter
    def layer(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "layer")

    @property
    @pulumi.getter
    def mscrm(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "mscrm")

    @property
    @pulumi.getter
    def newrelic(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "newrelic")

    @property
    @pulumi.getter
    def office365(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "office365")

    @property
    @pulumi.getter
    def rms(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "rms")

    @property
    @pulumi.getter
    def salesforce(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="salesforceApi")
    def salesforce_api(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "salesforce_api")

    @property
    @pulumi.getter(name="salesforceSandboxApi")
    def salesforce_sandbox_api(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "salesforce_sandbox_api")

    @property
    @pulumi.getter
    def samlp(self) -> Optional['outputs.GlobalClientAddonsSamlp']:
        """
        Configuration settings for a SAML add-on.
        """
        return pulumi.get(self, "samlp")

    @property
    @pulumi.getter(name="sapApi")
    def sap_api(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "sap_api")

    @property
    @pulumi.getter
    def sentry(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "sentry")

    @property
    @pulumi.getter
    def sharepoint(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "sharepoint")

    @property
    @pulumi.getter
    def slack(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "slack")

    @property
    @pulumi.getter
    def springcm(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "springcm")

    @property
    @pulumi.getter
    def wams(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "wams")

    @property
    @pulumi.getter
    def wsfed(self) -> Optional[Mapping[str, Any]]:
        """
        WS-Fed (WIF) addon indicator. Actual configuration is stored in callback and `client_aliases` properties on the client.
        """
        return pulumi.get(self, "wsfed")

    @property
    @pulumi.getter
    def zendesk(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "zendesk")

    @property
    @pulumi.getter
    def zoom(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "zoom")


@pulumi.output_type
class GlobalClientAddonsSamlp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authnContextClassRef":
            suggest = "authn_context_class_ref"
        elif key == "createUpnClaim":
            suggest = "create_upn_claim"
        elif key == "digestAlgorithm":
            suggest = "digest_algorithm"
        elif key == "includeAttributeNameFormat":
            suggest = "include_attribute_name_format"
        elif key == "lifetimeInSeconds":
            suggest = "lifetime_in_seconds"
        elif key == "mapIdentities":
            suggest = "map_identities"
        elif key == "mapUnknownClaimsAsIs":
            suggest = "map_unknown_claims_as_is"
        elif key == "nameIdentifierFormat":
            suggest = "name_identifier_format"
        elif key == "nameIdentifierProbes":
            suggest = "name_identifier_probes"
        elif key == "passthroughClaimsWithNoMapping":
            suggest = "passthrough_claims_with_no_mapping"
        elif key == "signResponse":
            suggest = "sign_response"
        elif key == "signatureAlgorithm":
            suggest = "signature_algorithm"
        elif key == "signingCert":
            suggest = "signing_cert"
        elif key == "typedAttributes":
            suggest = "typed_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalClientAddonsSamlp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalClientAddonsSamlp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalClientAddonsSamlp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audience: Optional[str] = None,
                 authn_context_class_ref: Optional[str] = None,
                 binding: Optional[str] = None,
                 create_upn_claim: Optional[bool] = None,
                 destination: Optional[str] = None,
                 digest_algorithm: Optional[str] = None,
                 include_attribute_name_format: Optional[bool] = None,
                 issuer: Optional[str] = None,
                 lifetime_in_seconds: Optional[int] = None,
                 logout: Optional[Mapping[str, Any]] = None,
                 map_identities: Optional[bool] = None,
                 map_unknown_claims_as_is: Optional[bool] = None,
                 mappings: Optional[Mapping[str, Any]] = None,
                 name_identifier_format: Optional[str] = None,
                 name_identifier_probes: Optional[Sequence[str]] = None,
                 passthrough_claims_with_no_mapping: Optional[bool] = None,
                 recipient: Optional[str] = None,
                 sign_response: Optional[bool] = None,
                 signature_algorithm: Optional[str] = None,
                 signing_cert: Optional[str] = None,
                 typed_attributes: Optional[bool] = None):
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if authn_context_class_ref is not None:
            pulumi.set(__self__, "authn_context_class_ref", authn_context_class_ref)
        if binding is not None:
            pulumi.set(__self__, "binding", binding)
        if create_upn_claim is not None:
            pulumi.set(__self__, "create_upn_claim", create_upn_claim)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if digest_algorithm is not None:
            pulumi.set(__self__, "digest_algorithm", digest_algorithm)
        if include_attribute_name_format is not None:
            pulumi.set(__self__, "include_attribute_name_format", include_attribute_name_format)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if lifetime_in_seconds is not None:
            pulumi.set(__self__, "lifetime_in_seconds", lifetime_in_seconds)
        if logout is not None:
            pulumi.set(__self__, "logout", logout)
        if map_identities is not None:
            pulumi.set(__self__, "map_identities", map_identities)
        if map_unknown_claims_as_is is not None:
            pulumi.set(__self__, "map_unknown_claims_as_is", map_unknown_claims_as_is)
        if mappings is not None:
            pulumi.set(__self__, "mappings", mappings)
        if name_identifier_format is not None:
            pulumi.set(__self__, "name_identifier_format", name_identifier_format)
        if name_identifier_probes is not None:
            pulumi.set(__self__, "name_identifier_probes", name_identifier_probes)
        if passthrough_claims_with_no_mapping is not None:
            pulumi.set(__self__, "passthrough_claims_with_no_mapping", passthrough_claims_with_no_mapping)
        if recipient is not None:
            pulumi.set(__self__, "recipient", recipient)
        if sign_response is not None:
            pulumi.set(__self__, "sign_response", sign_response)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if signing_cert is not None:
            pulumi.set(__self__, "signing_cert", signing_cert)
        if typed_attributes is not None:
            pulumi.set(__self__, "typed_attributes", typed_attributes)

    @property
    @pulumi.getter
    def audience(self) -> Optional[str]:
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="authnContextClassRef")
    def authn_context_class_ref(self) -> Optional[str]:
        return pulumi.get(self, "authn_context_class_ref")

    @property
    @pulumi.getter
    def binding(self) -> Optional[str]:
        return pulumi.get(self, "binding")

    @property
    @pulumi.getter(name="createUpnClaim")
    def create_upn_claim(self) -> Optional[bool]:
        return pulumi.get(self, "create_upn_claim")

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="digestAlgorithm")
    def digest_algorithm(self) -> Optional[str]:
        return pulumi.get(self, "digest_algorithm")

    @property
    @pulumi.getter(name="includeAttributeNameFormat")
    def include_attribute_name_format(self) -> Optional[bool]:
        return pulumi.get(self, "include_attribute_name_format")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="lifetimeInSeconds")
    def lifetime_in_seconds(self) -> Optional[int]:
        return pulumi.get(self, "lifetime_in_seconds")

    @property
    @pulumi.getter
    def logout(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "logout")

    @property
    @pulumi.getter(name="mapIdentities")
    def map_identities(self) -> Optional[bool]:
        return pulumi.get(self, "map_identities")

    @property
    @pulumi.getter(name="mapUnknownClaimsAsIs")
    def map_unknown_claims_as_is(self) -> Optional[bool]:
        return pulumi.get(self, "map_unknown_claims_as_is")

    @property
    @pulumi.getter
    def mappings(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter(name="nameIdentifierFormat")
    def name_identifier_format(self) -> Optional[str]:
        return pulumi.get(self, "name_identifier_format")

    @property
    @pulumi.getter(name="nameIdentifierProbes")
    def name_identifier_probes(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "name_identifier_probes")

    @property
    @pulumi.getter(name="passthroughClaimsWithNoMapping")
    def passthrough_claims_with_no_mapping(self) -> Optional[bool]:
        return pulumi.get(self, "passthrough_claims_with_no_mapping")

    @property
    @pulumi.getter
    def recipient(self) -> Optional[str]:
        return pulumi.get(self, "recipient")

    @property
    @pulumi.getter(name="signResponse")
    def sign_response(self) -> Optional[bool]:
        return pulumi.get(self, "sign_response")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[str]:
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter(name="signingCert")
    def signing_cert(self) -> Optional[str]:
        return pulumi.get(self, "signing_cert")

    @property
    @pulumi.getter(name="typedAttributes")
    def typed_attributes(self) -> Optional[bool]:
        return pulumi.get(self, "typed_attributes")


@pulumi.output_type
class GlobalClientJwtConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifetimeInSeconds":
            suggest = "lifetime_in_seconds"
        elif key == "secretEncoded":
            suggest = "secret_encoded"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalClientJwtConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalClientJwtConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalClientJwtConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alg: Optional[str] = None,
                 lifetime_in_seconds: Optional[int] = None,
                 scopes: Optional[Mapping[str, str]] = None,
                 secret_encoded: Optional[bool] = None):
        """
        :param str alg: Algorithm used to sign JWTs.
        :param int lifetime_in_seconds: Number of seconds during which the JWT will be valid.
        :param Mapping[str, str] scopes: Permissions (scopes) included in JWTs.
        :param bool secret_encoded: Indicates whether the client secret is Base64-encoded.
        """
        if alg is not None:
            pulumi.set(__self__, "alg", alg)
        if lifetime_in_seconds is not None:
            pulumi.set(__self__, "lifetime_in_seconds", lifetime_in_seconds)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if secret_encoded is not None:
            pulumi.set(__self__, "secret_encoded", secret_encoded)

    @property
    @pulumi.getter
    def alg(self) -> Optional[str]:
        """
        Algorithm used to sign JWTs.
        """
        return pulumi.get(self, "alg")

    @property
    @pulumi.getter(name="lifetimeInSeconds")
    def lifetime_in_seconds(self) -> Optional[int]:
        """
        Number of seconds during which the JWT will be valid.
        """
        return pulumi.get(self, "lifetime_in_seconds")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Mapping[str, str]]:
        """
        Permissions (scopes) included in JWTs.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="secretEncoded")
    def secret_encoded(self) -> Optional[bool]:
        """
        Indicates whether the client secret is Base64-encoded.
        """
        return pulumi.get(self, "secret_encoded")


@pulumi.output_type
class GlobalClientMobile(dict):
    def __init__(__self__, *,
                 android: Optional['outputs.GlobalClientMobileAndroid'] = None,
                 ios: Optional['outputs.GlobalClientMobileIos'] = None):
        """
        :param 'GlobalClientMobileAndroidArgs' android: Configuration settings for Android native apps.
        :param 'GlobalClientMobileIosArgs' ios: Configuration settings for i0S native apps.
        """
        if android is not None:
            pulumi.set(__self__, "android", android)
        if ios is not None:
            pulumi.set(__self__, "ios", ios)

    @property
    @pulumi.getter
    def android(self) -> Optional['outputs.GlobalClientMobileAndroid']:
        """
        Configuration settings for Android native apps.
        """
        return pulumi.get(self, "android")

    @property
    @pulumi.getter
    def ios(self) -> Optional['outputs.GlobalClientMobileIos']:
        """
        Configuration settings for i0S native apps.
        """
        return pulumi.get(self, "ios")


@pulumi.output_type
class GlobalClientMobileAndroid(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appPackageName":
            suggest = "app_package_name"
        elif key == "sha256CertFingerprints":
            suggest = "sha256_cert_fingerprints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalClientMobileAndroid. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalClientMobileAndroid.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalClientMobileAndroid.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_package_name: Optional[str] = None,
                 sha256_cert_fingerprints: Optional[Sequence[str]] = None):
        if app_package_name is not None:
            pulumi.set(__self__, "app_package_name", app_package_name)
        if sha256_cert_fingerprints is not None:
            pulumi.set(__self__, "sha256_cert_fingerprints", sha256_cert_fingerprints)

    @property
    @pulumi.getter(name="appPackageName")
    def app_package_name(self) -> Optional[str]:
        return pulumi.get(self, "app_package_name")

    @property
    @pulumi.getter(name="sha256CertFingerprints")
    def sha256_cert_fingerprints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "sha256_cert_fingerprints")


@pulumi.output_type
class GlobalClientMobileIos(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appBundleIdentifier":
            suggest = "app_bundle_identifier"
        elif key == "teamId":
            suggest = "team_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalClientMobileIos. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalClientMobileIos.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalClientMobileIos.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_bundle_identifier: Optional[str] = None,
                 team_id: Optional[str] = None):
        if app_bundle_identifier is not None:
            pulumi.set(__self__, "app_bundle_identifier", app_bundle_identifier)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="appBundleIdentifier")
    def app_bundle_identifier(self) -> Optional[str]:
        return pulumi.get(self, "app_bundle_identifier")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[str]:
        return pulumi.get(self, "team_id")


@pulumi.output_type
class GlobalClientNativeSocialLogin(dict):
    def __init__(__self__, *,
                 apple: Optional['outputs.GlobalClientNativeSocialLoginApple'] = None,
                 facebook: Optional['outputs.GlobalClientNativeSocialLoginFacebook'] = None):
        if apple is not None:
            pulumi.set(__self__, "apple", apple)
        if facebook is not None:
            pulumi.set(__self__, "facebook", facebook)

    @property
    @pulumi.getter
    def apple(self) -> Optional['outputs.GlobalClientNativeSocialLoginApple']:
        return pulumi.get(self, "apple")

    @property
    @pulumi.getter
    def facebook(self) -> Optional['outputs.GlobalClientNativeSocialLoginFacebook']:
        return pulumi.get(self, "facebook")


@pulumi.output_type
class GlobalClientNativeSocialLoginApple(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GlobalClientNativeSocialLoginFacebook(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GlobalClientRefreshToken(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationType":
            suggest = "expiration_type"
        elif key == "rotationType":
            suggest = "rotation_type"
        elif key == "idleTokenLifetime":
            suggest = "idle_token_lifetime"
        elif key == "infiniteIdleTokenLifetime":
            suggest = "infinite_idle_token_lifetime"
        elif key == "infiniteTokenLifetime":
            suggest = "infinite_token_lifetime"
        elif key == "tokenLifetime":
            suggest = "token_lifetime"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalClientRefreshToken. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalClientRefreshToken.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalClientRefreshToken.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration_type: str,
                 rotation_type: str,
                 idle_token_lifetime: Optional[int] = None,
                 infinite_idle_token_lifetime: Optional[bool] = None,
                 infinite_token_lifetime: Optional[bool] = None,
                 leeway: Optional[int] = None,
                 token_lifetime: Optional[int] = None):
        """
        :param str expiration_type: Options include `expiring`, `non-expiring`. Whether a refresh token will expire based on an absolute lifetime, after which the token can no longer be used. If rotation is `rotating`, this must be set to `expiring`.
        :param str rotation_type: Options include `rotating`, `non-rotating`. When `rotating`, exchanging a refresh token will cause a new refresh token to be issued and the existing token will be invalidated. This allows for automatic detection of token reuse if the token is leaked.
        :param int idle_token_lifetime: The time in seconds after which inactive refresh tokens will expire.
        :param bool infinite_idle_token_lifetime: Whether inactive refresh tokens should remain valid indefinitely.
        :param bool infinite_token_lifetime: Whether refresh tokens should remain valid indefinitely. If false, `token_lifetime` should also be set.
        :param int leeway: The amount of time in seconds in which a refresh token may be reused without triggering reuse detection.
        :param int token_lifetime: The absolute lifetime of a refresh token in seconds.
        """
        pulumi.set(__self__, "expiration_type", expiration_type)
        pulumi.set(__self__, "rotation_type", rotation_type)
        if idle_token_lifetime is not None:
            pulumi.set(__self__, "idle_token_lifetime", idle_token_lifetime)
        if infinite_idle_token_lifetime is not None:
            pulumi.set(__self__, "infinite_idle_token_lifetime", infinite_idle_token_lifetime)
        if infinite_token_lifetime is not None:
            pulumi.set(__self__, "infinite_token_lifetime", infinite_token_lifetime)
        if leeway is not None:
            pulumi.set(__self__, "leeway", leeway)
        if token_lifetime is not None:
            pulumi.set(__self__, "token_lifetime", token_lifetime)

    @property
    @pulumi.getter(name="expirationType")
    def expiration_type(self) -> str:
        """
        Options include `expiring`, `non-expiring`. Whether a refresh token will expire based on an absolute lifetime, after which the token can no longer be used. If rotation is `rotating`, this must be set to `expiring`.
        """
        return pulumi.get(self, "expiration_type")

    @property
    @pulumi.getter(name="rotationType")
    def rotation_type(self) -> str:
        """
        Options include `rotating`, `non-rotating`. When `rotating`, exchanging a refresh token will cause a new refresh token to be issued and the existing token will be invalidated. This allows for automatic detection of token reuse if the token is leaked.
        """
        return pulumi.get(self, "rotation_type")

    @property
    @pulumi.getter(name="idleTokenLifetime")
    def idle_token_lifetime(self) -> Optional[int]:
        """
        The time in seconds after which inactive refresh tokens will expire.
        """
        return pulumi.get(self, "idle_token_lifetime")

    @property
    @pulumi.getter(name="infiniteIdleTokenLifetime")
    def infinite_idle_token_lifetime(self) -> Optional[bool]:
        """
        Whether inactive refresh tokens should remain valid indefinitely.
        """
        return pulumi.get(self, "infinite_idle_token_lifetime")

    @property
    @pulumi.getter(name="infiniteTokenLifetime")
    def infinite_token_lifetime(self) -> Optional[bool]:
        """
        Whether refresh tokens should remain valid indefinitely. If false, `token_lifetime` should also be set.
        """
        return pulumi.get(self, "infinite_token_lifetime")

    @property
    @pulumi.getter
    def leeway(self) -> Optional[int]:
        """
        The amount of time in seconds in which a refresh token may be reused without triggering reuse detection.
        """
        return pulumi.get(self, "leeway")

    @property
    @pulumi.getter(name="tokenLifetime")
    def token_lifetime(self) -> Optional[int]:
        """
        The absolute lifetime of a refresh token in seconds.
        """
        return pulumi.get(self, "token_lifetime")


@pulumi.output_type
class GuardianDuo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "integrationKey":
            suggest = "integration_key"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardianDuo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardianDuo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardianDuo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 hostname: Optional[str] = None,
                 integration_key: Optional[str] = None,
                 secret_key: Optional[str] = None):
        """
        :param bool enabled: Indicates whether Duo MFA is enabled.
        :param str hostname: Duo API Hostname, see the Duo documentation for more details on Duo setup.
        :param str integration_key: Duo client ID, see the Duo documentation for more details on Duo setup.
        :param str secret_key: Duo client secret, see the Duo documentation for more details on Duo setup.
        """
        pulumi.set(__self__, "enabled", enabled)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if integration_key is not None:
            pulumi.set(__self__, "integration_key", integration_key)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether Duo MFA is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Duo API Hostname, see the Duo documentation for more details on Duo setup.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="integrationKey")
    def integration_key(self) -> Optional[str]:
        """
        Duo client ID, see the Duo documentation for more details on Duo setup.
        """
        return pulumi.get(self, "integration_key")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        Duo client secret, see the Duo documentation for more details on Duo setup.
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class GuardianPhone(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageTypes":
            suggest = "message_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardianPhone. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardianPhone.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardianPhone.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 message_types: Optional[Sequence[str]] = None,
                 options: Optional['outputs.GuardianPhoneOptions'] = None,
                 provider: Optional[str] = None):
        """
        :param bool enabled: Indicates whether Phone MFA is enabled.
        :param Sequence[str] message_types: Message types to use, array of `sms` and/or `voice`. Adding both to the array should enable the user to choose.
        :param 'GuardianPhoneOptionsArgs' options: Options for the various providers.
        :param str provider: Provider to use, one of `auth0`, `twilio` or `phone-message-hook`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if message_types is not None:
            pulumi.set(__self__, "message_types", message_types)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether Phone MFA is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="messageTypes")
    def message_types(self) -> Optional[Sequence[str]]:
        """
        Message types to use, array of `sms` and/or `voice`. Adding both to the array should enable the user to choose.
        """
        return pulumi.get(self, "message_types")

    @property
    @pulumi.getter
    def options(self) -> Optional['outputs.GuardianPhoneOptions']:
        """
        Options for the various providers.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def provider(self) -> Optional[str]:
        """
        Provider to use, one of `auth0`, `twilio` or `phone-message-hook`.
        """
        return pulumi.get(self, "provider")


@pulumi.output_type
class GuardianPhoneOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authToken":
            suggest = "auth_token"
        elif key == "enrollmentMessage":
            suggest = "enrollment_message"
        elif key == "from":
            suggest = "from_"
        elif key == "messagingServiceSid":
            suggest = "messaging_service_sid"
        elif key == "verificationMessage":
            suggest = "verification_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardianPhoneOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardianPhoneOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardianPhoneOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_token: Optional[str] = None,
                 enrollment_message: Optional[str] = None,
                 from_: Optional[str] = None,
                 messaging_service_sid: Optional[str] = None,
                 sid: Optional[str] = None,
                 verification_message: Optional[str] = None):
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if enrollment_message is not None:
            pulumi.set(__self__, "enrollment_message", enrollment_message)
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if messaging_service_sid is not None:
            pulumi.set(__self__, "messaging_service_sid", messaging_service_sid)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)
        if verification_message is not None:
            pulumi.set(__self__, "verification_message", verification_message)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[str]:
        return pulumi.get(self, "auth_token")

    @property
    @pulumi.getter(name="enrollmentMessage")
    def enrollment_message(self) -> Optional[str]:
        return pulumi.get(self, "enrollment_message")

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[str]:
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter(name="messagingServiceSid")
    def messaging_service_sid(self) -> Optional[str]:
        return pulumi.get(self, "messaging_service_sid")

    @property
    @pulumi.getter
    def sid(self) -> Optional[str]:
        return pulumi.get(self, "sid")

    @property
    @pulumi.getter(name="verificationMessage")
    def verification_message(self) -> Optional[str]:
        return pulumi.get(self, "verification_message")


@pulumi.output_type
class GuardianPush(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amazonSns":
            suggest = "amazon_sns"
        elif key == "customApp":
            suggest = "custom_app"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardianPush. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardianPush.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardianPush.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 amazon_sns: Optional['outputs.GuardianPushAmazonSns'] = None,
                 custom_app: Optional['outputs.GuardianPushCustomApp'] = None,
                 provider: Optional[str] = None):
        """
        :param bool enabled: Indicates whether Push MFA is enabled.
        :param 'GuardianPushAmazonSnsArgs' amazon_sns: Configuration for Amazon SNS.
        :param 'GuardianPushCustomAppArgs' custom_app: Configuration for the Guardian Custom App.
        :param str provider: Provider to use, one of `guardian`, `sns`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if amazon_sns is not None:
            pulumi.set(__self__, "amazon_sns", amazon_sns)
        if custom_app is not None:
            pulumi.set(__self__, "custom_app", custom_app)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether Push MFA is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="amazonSns")
    def amazon_sns(self) -> Optional['outputs.GuardianPushAmazonSns']:
        """
        Configuration for Amazon SNS.
        """
        return pulumi.get(self, "amazon_sns")

    @property
    @pulumi.getter(name="customApp")
    def custom_app(self) -> Optional['outputs.GuardianPushCustomApp']:
        """
        Configuration for the Guardian Custom App.
        """
        return pulumi.get(self, "custom_app")

    @property
    @pulumi.getter
    def provider(self) -> Optional[str]:
        """
        Provider to use, one of `guardian`, `sns`.
        """
        return pulumi.get(self, "provider")


@pulumi.output_type
class GuardianPushAmazonSns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsAccessKeyId":
            suggest = "aws_access_key_id"
        elif key == "awsRegion":
            suggest = "aws_region"
        elif key == "awsSecretAccessKey":
            suggest = "aws_secret_access_key"
        elif key == "snsApnsPlatformApplicationArn":
            suggest = "sns_apns_platform_application_arn"
        elif key == "snsGcmPlatformApplicationArn":
            suggest = "sns_gcm_platform_application_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardianPushAmazonSns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardianPushAmazonSns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardianPushAmazonSns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_access_key_id: str,
                 aws_region: str,
                 aws_secret_access_key: str,
                 sns_apns_platform_application_arn: str,
                 sns_gcm_platform_application_arn: str):
        pulumi.set(__self__, "aws_access_key_id", aws_access_key_id)
        pulumi.set(__self__, "aws_region", aws_region)
        pulumi.set(__self__, "aws_secret_access_key", aws_secret_access_key)
        pulumi.set(__self__, "sns_apns_platform_application_arn", sns_apns_platform_application_arn)
        pulumi.set(__self__, "sns_gcm_platform_application_arn", sns_gcm_platform_application_arn)

    @property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> str:
        return pulumi.get(self, "aws_access_key_id")

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> str:
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> str:
        return pulumi.get(self, "aws_secret_access_key")

    @property
    @pulumi.getter(name="snsApnsPlatformApplicationArn")
    def sns_apns_platform_application_arn(self) -> str:
        return pulumi.get(self, "sns_apns_platform_application_arn")

    @property
    @pulumi.getter(name="snsGcmPlatformApplicationArn")
    def sns_gcm_platform_application_arn(self) -> str:
        return pulumi.get(self, "sns_gcm_platform_application_arn")


@pulumi.output_type
class GuardianPushCustomApp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appName":
            suggest = "app_name"
        elif key == "appleAppLink":
            suggest = "apple_app_link"
        elif key == "googleAppLink":
            suggest = "google_app_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardianPushCustomApp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardianPushCustomApp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardianPushCustomApp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_name: Optional[str] = None,
                 apple_app_link: Optional[str] = None,
                 google_app_link: Optional[str] = None):
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if apple_app_link is not None:
            pulumi.set(__self__, "apple_app_link", apple_app_link)
        if google_app_link is not None:
            pulumi.set(__self__, "google_app_link", google_app_link)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[str]:
        return pulumi.get(self, "app_name")

    @property
    @pulumi.getter(name="appleAppLink")
    def apple_app_link(self) -> Optional[str]:
        return pulumi.get(self, "apple_app_link")

    @property
    @pulumi.getter(name="googleAppLink")
    def google_app_link(self) -> Optional[str]:
        return pulumi.get(self, "google_app_link")


@pulumi.output_type
class GuardianWebauthnPlatform(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "overrideRelyingParty":
            suggest = "override_relying_party"
        elif key == "relyingPartyIdentifier":
            suggest = "relying_party_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardianWebauthnPlatform. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardianWebauthnPlatform.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardianWebauthnPlatform.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 override_relying_party: Optional[bool] = None,
                 relying_party_identifier: Optional[str] = None):
        """
        :param bool enabled: Indicates whether WebAuthn with FIDO Device Biometrics MFA is enabled.
        :param bool override_relying_party: The Relying Party is the domain for which the WebAuthn keys will be issued, set to `true` if you are customizing the identifier.
        :param str relying_party_identifier: The Relying Party should be a suffix of the custom domain.
        """
        pulumi.set(__self__, "enabled", enabled)
        if override_relying_party is not None:
            pulumi.set(__self__, "override_relying_party", override_relying_party)
        if relying_party_identifier is not None:
            pulumi.set(__self__, "relying_party_identifier", relying_party_identifier)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether WebAuthn with FIDO Device Biometrics MFA is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="overrideRelyingParty")
    def override_relying_party(self) -> Optional[bool]:
        """
        The Relying Party is the domain for which the WebAuthn keys will be issued, set to `true` if you are customizing the identifier.
        """
        return pulumi.get(self, "override_relying_party")

    @property
    @pulumi.getter(name="relyingPartyIdentifier")
    def relying_party_identifier(self) -> Optional[str]:
        """
        The Relying Party should be a suffix of the custom domain.
        """
        return pulumi.get(self, "relying_party_identifier")


@pulumi.output_type
class GuardianWebauthnRoaming(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "overrideRelyingParty":
            suggest = "override_relying_party"
        elif key == "relyingPartyIdentifier":
            suggest = "relying_party_identifier"
        elif key == "userVerification":
            suggest = "user_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardianWebauthnRoaming. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardianWebauthnRoaming.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardianWebauthnRoaming.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 override_relying_party: Optional[bool] = None,
                 relying_party_identifier: Optional[str] = None,
                 user_verification: Optional[str] = None):
        """
        :param bool enabled: Indicates whether WebAuthn with FIDO Security Keys MFA is enabled.
        :param bool override_relying_party: The Relying Party is the domain for which the WebAuthn keys will be issued, set to `true` if you are customizing the identifier.
        :param str relying_party_identifier: The Relying Party should be a suffix of the custom domain.
        :param str user_verification: User verification, one of `discouraged`, `preferred` or `required`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if override_relying_party is not None:
            pulumi.set(__self__, "override_relying_party", override_relying_party)
        if relying_party_identifier is not None:
            pulumi.set(__self__, "relying_party_identifier", relying_party_identifier)
        if user_verification is not None:
            pulumi.set(__self__, "user_verification", user_verification)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether WebAuthn with FIDO Security Keys MFA is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="overrideRelyingParty")
    def override_relying_party(self) -> Optional[bool]:
        """
        The Relying Party is the domain for which the WebAuthn keys will be issued, set to `true` if you are customizing the identifier.
        """
        return pulumi.get(self, "override_relying_party")

    @property
    @pulumi.getter(name="relyingPartyIdentifier")
    def relying_party_identifier(self) -> Optional[str]:
        """
        The Relying Party should be a suffix of the custom domain.
        """
        return pulumi.get(self, "relying_party_identifier")

    @property
    @pulumi.getter(name="userVerification")
    def user_verification(self) -> Optional[str]:
        """
        User verification, one of `discouraged`, `preferred` or `required`.
        """
        return pulumi.get(self, "user_verification")


@pulumi.output_type
class LogStreamSink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsAccountId":
            suggest = "aws_account_id"
        elif key == "awsPartnerEventSource":
            suggest = "aws_partner_event_source"
        elif key == "awsRegion":
            suggest = "aws_region"
        elif key == "azurePartnerTopic":
            suggest = "azure_partner_topic"
        elif key == "azureRegion":
            suggest = "azure_region"
        elif key == "azureResourceGroup":
            suggest = "azure_resource_group"
        elif key == "azureSubscriptionId":
            suggest = "azure_subscription_id"
        elif key == "datadogApiKey":
            suggest = "datadog_api_key"
        elif key == "datadogRegion":
            suggest = "datadog_region"
        elif key == "httpAuthorization":
            suggest = "http_authorization"
        elif key == "httpContentFormat":
            suggest = "http_content_format"
        elif key == "httpContentType":
            suggest = "http_content_type"
        elif key == "httpCustomHeaders":
            suggest = "http_custom_headers"
        elif key == "httpEndpoint":
            suggest = "http_endpoint"
        elif key == "mixpanelProjectId":
            suggest = "mixpanel_project_id"
        elif key == "mixpanelRegion":
            suggest = "mixpanel_region"
        elif key == "mixpanelServiceAccountPassword":
            suggest = "mixpanel_service_account_password"
        elif key == "mixpanelServiceAccountUsername":
            suggest = "mixpanel_service_account_username"
        elif key == "splunkDomain":
            suggest = "splunk_domain"
        elif key == "splunkPort":
            suggest = "splunk_port"
        elif key == "splunkSecure":
            suggest = "splunk_secure"
        elif key == "splunkToken":
            suggest = "splunk_token"
        elif key == "sumoSourceAddress":
            suggest = "sumo_source_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogStreamSink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogStreamSink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogStreamSink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_account_id: Optional[str] = None,
                 aws_partner_event_source: Optional[str] = None,
                 aws_region: Optional[str] = None,
                 azure_partner_topic: Optional[str] = None,
                 azure_region: Optional[str] = None,
                 azure_resource_group: Optional[str] = None,
                 azure_subscription_id: Optional[str] = None,
                 datadog_api_key: Optional[str] = None,
                 datadog_region: Optional[str] = None,
                 http_authorization: Optional[str] = None,
                 http_content_format: Optional[str] = None,
                 http_content_type: Optional[str] = None,
                 http_custom_headers: Optional[Sequence[Mapping[str, str]]] = None,
                 http_endpoint: Optional[str] = None,
                 mixpanel_project_id: Optional[str] = None,
                 mixpanel_region: Optional[str] = None,
                 mixpanel_service_account_password: Optional[str] = None,
                 mixpanel_service_account_username: Optional[str] = None,
                 splunk_domain: Optional[str] = None,
                 splunk_port: Optional[str] = None,
                 splunk_secure: Optional[bool] = None,
                 splunk_token: Optional[str] = None,
                 sumo_source_address: Optional[str] = None):
        """
        :param str aws_account_id: The AWS Account ID.
        :param str aws_partner_event_source: Name of the Partner Event Source to be used with AWS. Generally generated by Auth0 and passed to AWS, so this should be an output attribute.
        :param str aws_region: The AWS Region, e.g. "us-east-2").
        :param str azure_partner_topic: Name of the Partner Topic to be used with Azure. Generally should not be specified.
        :param str azure_region: The Azure region code, e.g. "ne")
        :param str azure_resource_group: The Azure EventGrid resource group which allows you to manage all Azure assets within one subscription.
        :param str azure_subscription_id: The unique alphanumeric string that identifies your Azure subscription.
        :param str datadog_api_key: The Datadog API key.
        :param str datadog_region: The Datadog region. Options are ["us", "eu", "us3", "us5"].
        :param str http_authorization: Sent in the HTTP "Authorization" header with each request.
        :param str http_content_format: The format of data sent over HTTP. Options are "JSONLINES", "JSONARRAY" or "JSONOBJECT"
        :param str http_content_type: The "Content-Type" header to send over HTTP. Common value is "application/json".
        :param Sequence[Mapping[str, str]] http_custom_headers: Additional HTTP headers to be included as part of the HTTP request.
        :param str http_endpoint: The HTTP endpoint to send streaming logs.
        :param str mixpanel_project_id: The Mixpanel project ID, found on the Project Settings page.
        :param str mixpanel_region: The Mixpanel region. Options are ["us", "eu"]. EU is required for customers with EU data residency requirements.
        :param str mixpanel_service_account_password: The Mixpanel Service Account password.
        :param str mixpanel_service_account_username: The Mixpanel Service Account username. Services Accounts can be created in the Project Settings page.
        :param str splunk_domain: The Splunk domain name.
        :param str splunk_port: The Splunk port.
        :param bool splunk_secure: This toggle should be turned off when using self-signed certificates.
        :param str splunk_token: The Splunk access token.
        :param str sumo_source_address: Generated URL for your defined HTTP source in Sumo Logic for collecting streaming data from Auth0.
        """
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if aws_partner_event_source is not None:
            pulumi.set(__self__, "aws_partner_event_source", aws_partner_event_source)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if azure_partner_topic is not None:
            pulumi.set(__self__, "azure_partner_topic", azure_partner_topic)
        if azure_region is not None:
            pulumi.set(__self__, "azure_region", azure_region)
        if azure_resource_group is not None:
            pulumi.set(__self__, "azure_resource_group", azure_resource_group)
        if azure_subscription_id is not None:
            pulumi.set(__self__, "azure_subscription_id", azure_subscription_id)
        if datadog_api_key is not None:
            pulumi.set(__self__, "datadog_api_key", datadog_api_key)
        if datadog_region is not None:
            pulumi.set(__self__, "datadog_region", datadog_region)
        if http_authorization is not None:
            pulumi.set(__self__, "http_authorization", http_authorization)
        if http_content_format is not None:
            pulumi.set(__self__, "http_content_format", http_content_format)
        if http_content_type is not None:
            pulumi.set(__self__, "http_content_type", http_content_type)
        if http_custom_headers is not None:
            pulumi.set(__self__, "http_custom_headers", http_custom_headers)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if mixpanel_project_id is not None:
            pulumi.set(__self__, "mixpanel_project_id", mixpanel_project_id)
        if mixpanel_region is not None:
            pulumi.set(__self__, "mixpanel_region", mixpanel_region)
        if mixpanel_service_account_password is not None:
            pulumi.set(__self__, "mixpanel_service_account_password", mixpanel_service_account_password)
        if mixpanel_service_account_username is not None:
            pulumi.set(__self__, "mixpanel_service_account_username", mixpanel_service_account_username)
        if splunk_domain is not None:
            pulumi.set(__self__, "splunk_domain", splunk_domain)
        if splunk_port is not None:
            pulumi.set(__self__, "splunk_port", splunk_port)
        if splunk_secure is not None:
            pulumi.set(__self__, "splunk_secure", splunk_secure)
        if splunk_token is not None:
            pulumi.set(__self__, "splunk_token", splunk_token)
        if sumo_source_address is not None:
            pulumi.set(__self__, "sumo_source_address", sumo_source_address)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[str]:
        """
        The AWS Account ID.
        """
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="awsPartnerEventSource")
    def aws_partner_event_source(self) -> Optional[str]:
        """
        Name of the Partner Event Source to be used with AWS. Generally generated by Auth0 and passed to AWS, so this should be an output attribute.
        """
        return pulumi.get(self, "aws_partner_event_source")

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[str]:
        """
        The AWS Region, e.g. "us-east-2").
        """
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter(name="azurePartnerTopic")
    def azure_partner_topic(self) -> Optional[str]:
        """
        Name of the Partner Topic to be used with Azure. Generally should not be specified.
        """
        return pulumi.get(self, "azure_partner_topic")

    @property
    @pulumi.getter(name="azureRegion")
    def azure_region(self) -> Optional[str]:
        """
        The Azure region code, e.g. "ne")
        """
        return pulumi.get(self, "azure_region")

    @property
    @pulumi.getter(name="azureResourceGroup")
    def azure_resource_group(self) -> Optional[str]:
        """
        The Azure EventGrid resource group which allows you to manage all Azure assets within one subscription.
        """
        return pulumi.get(self, "azure_resource_group")

    @property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> Optional[str]:
        """
        The unique alphanumeric string that identifies your Azure subscription.
        """
        return pulumi.get(self, "azure_subscription_id")

    @property
    @pulumi.getter(name="datadogApiKey")
    def datadog_api_key(self) -> Optional[str]:
        """
        The Datadog API key.
        """
        return pulumi.get(self, "datadog_api_key")

    @property
    @pulumi.getter(name="datadogRegion")
    def datadog_region(self) -> Optional[str]:
        """
        The Datadog region. Options are ["us", "eu", "us3", "us5"].
        """
        return pulumi.get(self, "datadog_region")

    @property
    @pulumi.getter(name="httpAuthorization")
    def http_authorization(self) -> Optional[str]:
        """
        Sent in the HTTP "Authorization" header with each request.
        """
        return pulumi.get(self, "http_authorization")

    @property
    @pulumi.getter(name="httpContentFormat")
    def http_content_format(self) -> Optional[str]:
        """
        The format of data sent over HTTP. Options are "JSONLINES", "JSONARRAY" or "JSONOBJECT"
        """
        return pulumi.get(self, "http_content_format")

    @property
    @pulumi.getter(name="httpContentType")
    def http_content_type(self) -> Optional[str]:
        """
        The "Content-Type" header to send over HTTP. Common value is "application/json".
        """
        return pulumi.get(self, "http_content_type")

    @property
    @pulumi.getter(name="httpCustomHeaders")
    def http_custom_headers(self) -> Optional[Sequence[Mapping[str, str]]]:
        """
        Additional HTTP headers to be included as part of the HTTP request.
        """
        return pulumi.get(self, "http_custom_headers")

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[str]:
        """
        The HTTP endpoint to send streaming logs.
        """
        return pulumi.get(self, "http_endpoint")

    @property
    @pulumi.getter(name="mixpanelProjectId")
    def mixpanel_project_id(self) -> Optional[str]:
        """
        The Mixpanel project ID, found on the Project Settings page.
        """
        return pulumi.get(self, "mixpanel_project_id")

    @property
    @pulumi.getter(name="mixpanelRegion")
    def mixpanel_region(self) -> Optional[str]:
        """
        The Mixpanel region. Options are ["us", "eu"]. EU is required for customers with EU data residency requirements.
        """
        return pulumi.get(self, "mixpanel_region")

    @property
    @pulumi.getter(name="mixpanelServiceAccountPassword")
    def mixpanel_service_account_password(self) -> Optional[str]:
        """
        The Mixpanel Service Account password.
        """
        return pulumi.get(self, "mixpanel_service_account_password")

    @property
    @pulumi.getter(name="mixpanelServiceAccountUsername")
    def mixpanel_service_account_username(self) -> Optional[str]:
        """
        The Mixpanel Service Account username. Services Accounts can be created in the Project Settings page.
        """
        return pulumi.get(self, "mixpanel_service_account_username")

    @property
    @pulumi.getter(name="splunkDomain")
    def splunk_domain(self) -> Optional[str]:
        """
        The Splunk domain name.
        """
        return pulumi.get(self, "splunk_domain")

    @property
    @pulumi.getter(name="splunkPort")
    def splunk_port(self) -> Optional[str]:
        """
        The Splunk port.
        """
        return pulumi.get(self, "splunk_port")

    @property
    @pulumi.getter(name="splunkSecure")
    def splunk_secure(self) -> Optional[bool]:
        """
        This toggle should be turned off when using self-signed certificates.
        """
        return pulumi.get(self, "splunk_secure")

    @property
    @pulumi.getter(name="splunkToken")
    def splunk_token(self) -> Optional[str]:
        """
        The Splunk access token.
        """
        return pulumi.get(self, "splunk_token")

    @property
    @pulumi.getter(name="sumoSourceAddress")
    def sumo_source_address(self) -> Optional[str]:
        """
        Generated URL for your defined HTTP source in Sumo Logic for collecting streaming data from Auth0.
        """
        return pulumi.get(self, "sumo_source_address")


@pulumi.output_type
class OrganizationBranding(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logoUrl":
            suggest = "logo_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationBranding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationBranding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationBranding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 colors: Optional[Mapping[str, str]] = None,
                 logo_url: Optional[str] = None):
        """
        :param Mapping[str, str] colors: Color scheme used to customize the login pages.
        :param str logo_url: URL of logo to display on login page.
        """
        if colors is not None:
            pulumi.set(__self__, "colors", colors)
        if logo_url is not None:
            pulumi.set(__self__, "logo_url", logo_url)

    @property
    @pulumi.getter
    def colors(self) -> Optional[Mapping[str, str]]:
        """
        Color scheme used to customize the login pages.
        """
        return pulumi.get(self, "colors")

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> Optional[str]:
        """
        URL of logo to display on login page.
        """
        return pulumi.get(self, "logo_url")


@pulumi.output_type
class ResourceServerScope(dict):
    def __init__(__self__, *,
                 value: str,
                 description: Optional[str] = None):
        """
        :param str value: Name of the permission (scope). Examples include `read:appointments` or `delete:appointments`.
        :param str description: Description of the permission (scope).
        """
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Name of the permission (scope). Examples include `read:appointments` or `delete:appointments`.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the permission (scope).
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class RolePermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceServerIdentifier":
            suggest = "resource_server_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolePermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolePermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolePermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 resource_server_identifier: str):
        """
        :param str name: Name of the permission (scope).
        :param str resource_server_identifier: Unique identifier for the resource server.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_server_identifier", resource_server_identifier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the permission (scope).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceServerIdentifier")
    def resource_server_identifier(self) -> str:
        """
        Unique identifier for the resource server.
        """
        return pulumi.get(self, "resource_server_identifier")


@pulumi.output_type
class TenantChangePassword(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 html: str):
        """
        :param bool enabled: Indicates whether to use the custom change password page.
        :param str html: HTML format with supported Liquid syntax. Customized content of the change password page.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "html", html)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether to use the custom change password page.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def html(self) -> str:
        """
        HTML format with supported Liquid syntax. Customized content of the change password page.
        """
        return pulumi.get(self, "html")


@pulumi.output_type
class TenantErrorPage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "showLogLink":
            suggest = "show_log_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TenantErrorPage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TenantErrorPage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TenantErrorPage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 html: str,
                 show_log_link: bool,
                 url: str):
        """
        :param str html: HTML format with supported Liquid syntax. Customized content of the error page.
        :param bool show_log_link: Indicates whether to show the link to logs as part of the default error page.
        :param str url: URL to redirect to when an error occurs rather than showing the default error page.
        """
        pulumi.set(__self__, "html", html)
        pulumi.set(__self__, "show_log_link", show_log_link)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def html(self) -> str:
        """
        HTML format with supported Liquid syntax. Customized content of the error page.
        """
        return pulumi.get(self, "html")

    @property
    @pulumi.getter(name="showLogLink")
    def show_log_link(self) -> bool:
        """
        Indicates whether to show the link to logs as part of the default error page.
        """
        return pulumi.get(self, "show_log_link")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL to redirect to when an error occurs rather than showing the default error page.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class TenantFlags(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowLegacyDelegationGrantTypes":
            suggest = "allow_legacy_delegation_grant_types"
        elif key == "allowLegacyRoGrantTypes":
            suggest = "allow_legacy_ro_grant_types"
        elif key == "allowLegacyTokeninfoEndpoint":
            suggest = "allow_legacy_tokeninfo_endpoint"
        elif key == "dashboardInsightsView":
            suggest = "dashboard_insights_view"
        elif key == "dashboardLogStreamsNext":
            suggest = "dashboard_log_streams_next"
        elif key == "disableClickjackProtectionHeaders":
            suggest = "disable_clickjack_protection_headers"
        elif key == "disableFieldsMapFix":
            suggest = "disable_fields_map_fix"
        elif key == "disableManagementApiSmsObfuscation":
            suggest = "disable_management_api_sms_obfuscation"
        elif key == "enableAdfsWaadEmailVerification":
            suggest = "enable_adfs_waad_email_verification"
        elif key == "enableApisSection":
            suggest = "enable_apis_section"
        elif key == "enableClientConnections":
            suggest = "enable_client_connections"
        elif key == "enableCustomDomainInEmails":
            suggest = "enable_custom_domain_in_emails"
        elif key == "enableDynamicClientRegistration":
            suggest = "enable_dynamic_client_registration"
        elif key == "enableIdtokenApi2":
            suggest = "enable_idtoken_api2"
        elif key == "enableLegacyLogsSearchV2":
            suggest = "enable_legacy_logs_search_v2"
        elif key == "enableLegacyProfile":
            suggest = "enable_legacy_profile"
        elif key == "enablePipeline2":
            suggest = "enable_pipeline2"
        elif key == "enablePublicSignupUserExistsError":
            suggest = "enable_public_signup_user_exists_error"
        elif key == "noDiscloseEnterpriseConnections":
            suggest = "no_disclose_enterprise_connections"
        elif key == "revokeRefreshTokenGrant":
            suggest = "revoke_refresh_token_grant"
        elif key == "universalLogin":
            suggest = "universal_login"
        elif key == "useScopeDescriptionsForConsent":
            suggest = "use_scope_descriptions_for_consent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TenantFlags. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TenantFlags.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TenantFlags.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_legacy_delegation_grant_types: Optional[bool] = None,
                 allow_legacy_ro_grant_types: Optional[bool] = None,
                 allow_legacy_tokeninfo_endpoint: Optional[bool] = None,
                 dashboard_insights_view: Optional[bool] = None,
                 dashboard_log_streams_next: Optional[bool] = None,
                 disable_clickjack_protection_headers: Optional[bool] = None,
                 disable_fields_map_fix: Optional[bool] = None,
                 disable_management_api_sms_obfuscation: Optional[bool] = None,
                 enable_adfs_waad_email_verification: Optional[bool] = None,
                 enable_apis_section: Optional[bool] = None,
                 enable_client_connections: Optional[bool] = None,
                 enable_custom_domain_in_emails: Optional[bool] = None,
                 enable_dynamic_client_registration: Optional[bool] = None,
                 enable_idtoken_api2: Optional[bool] = None,
                 enable_legacy_logs_search_v2: Optional[bool] = None,
                 enable_legacy_profile: Optional[bool] = None,
                 enable_pipeline2: Optional[bool] = None,
                 enable_public_signup_user_exists_error: Optional[bool] = None,
                 no_disclose_enterprise_connections: Optional[bool] = None,
                 revoke_refresh_token_grant: Optional[bool] = None,
                 universal_login: Optional[bool] = None,
                 use_scope_descriptions_for_consent: Optional[bool] = None):
        """
        :param bool allow_legacy_delegation_grant_types: Whether the legacy delegation endpoint will be enabled for your account (true) or not available (false).
        :param bool allow_legacy_ro_grant_types: Whether the legacy `auth/ro` endpoint (used with resource owner password and passwordless features) will be enabled for your account (true) or not available (false).
        :param bool allow_legacy_tokeninfo_endpoint: If enabled, customers can use Tokeninfo Endpoint, otherwise they can not use it.
        :param bool dashboard_insights_view: Enables new insights activity page view.
        :param bool dashboard_log_streams_next: Enables beta access to log streaming changes.
        :param bool disable_clickjack_protection_headers: Indicates whether classic Universal Login prompts include additional security headers to prevent clickjacking.
        :param bool disable_fields_map_fix: Disables SAML fields map fix for bad mappings with repeated attributes.
        :param bool disable_management_api_sms_obfuscation: If true, SMS phone numbers will not be obfuscated in Management API GET calls.
        :param bool enable_adfs_waad_email_verification: If enabled, users will be presented with an email verification prompt during their first login when using Azure AD or ADFS connections.
        :param bool enable_apis_section: Indicates whether the APIs section is enabled for the tenant.
        :param bool enable_client_connections: Indicates whether all current connections should be enabled when a new client is created.
        :param bool enable_custom_domain_in_emails: Indicates whether the tenant allows custom domains in emails.
        :param bool enable_dynamic_client_registration: Indicates whether the tenant allows dynamic client registration.
        :param bool enable_idtoken_api2: Whether ID tokens can be used to authorize some types of requests to API v2 (true) or not (false).
        :param bool enable_legacy_logs_search_v2: Indicates whether to use the older v2 legacy logs search.
        :param bool enable_legacy_profile: Whether ID tokens and the userinfo endpoint includes a complete user profile (true) or only OpenID Connect claims (false).
        :param bool enable_pipeline2: Indicates whether advanced API Authorization scenarios are enabled.
        :param bool enable_public_signup_user_exists_error: Indicates whether the public sign up process shows a `user_exists` error if the user already exists.
        :param bool no_disclose_enterprise_connections: Do not Publish Enterprise Connections Information with IdP domains on the lock configuration file.
        :param bool revoke_refresh_token_grant: Delete underlying grant when a refresh token is revoked via the Authentication API.
        :param bool universal_login: Indicates whether the tenant uses Universal Login.
        :param bool use_scope_descriptions_for_consent: Indicates whether to use scope descriptions for consent.
        """
        if allow_legacy_delegation_grant_types is not None:
            pulumi.set(__self__, "allow_legacy_delegation_grant_types", allow_legacy_delegation_grant_types)
        if allow_legacy_ro_grant_types is not None:
            pulumi.set(__self__, "allow_legacy_ro_grant_types", allow_legacy_ro_grant_types)
        if allow_legacy_tokeninfo_endpoint is not None:
            pulumi.set(__self__, "allow_legacy_tokeninfo_endpoint", allow_legacy_tokeninfo_endpoint)
        if dashboard_insights_view is not None:
            pulumi.set(__self__, "dashboard_insights_view", dashboard_insights_view)
        if dashboard_log_streams_next is not None:
            pulumi.set(__self__, "dashboard_log_streams_next", dashboard_log_streams_next)
        if disable_clickjack_protection_headers is not None:
            pulumi.set(__self__, "disable_clickjack_protection_headers", disable_clickjack_protection_headers)
        if disable_fields_map_fix is not None:
            pulumi.set(__self__, "disable_fields_map_fix", disable_fields_map_fix)
        if disable_management_api_sms_obfuscation is not None:
            pulumi.set(__self__, "disable_management_api_sms_obfuscation", disable_management_api_sms_obfuscation)
        if enable_adfs_waad_email_verification is not None:
            pulumi.set(__self__, "enable_adfs_waad_email_verification", enable_adfs_waad_email_verification)
        if enable_apis_section is not None:
            pulumi.set(__self__, "enable_apis_section", enable_apis_section)
        if enable_client_connections is not None:
            pulumi.set(__self__, "enable_client_connections", enable_client_connections)
        if enable_custom_domain_in_emails is not None:
            pulumi.set(__self__, "enable_custom_domain_in_emails", enable_custom_domain_in_emails)
        if enable_dynamic_client_registration is not None:
            pulumi.set(__self__, "enable_dynamic_client_registration", enable_dynamic_client_registration)
        if enable_idtoken_api2 is not None:
            pulumi.set(__self__, "enable_idtoken_api2", enable_idtoken_api2)
        if enable_legacy_logs_search_v2 is not None:
            pulumi.set(__self__, "enable_legacy_logs_search_v2", enable_legacy_logs_search_v2)
        if enable_legacy_profile is not None:
            pulumi.set(__self__, "enable_legacy_profile", enable_legacy_profile)
        if enable_pipeline2 is not None:
            pulumi.set(__self__, "enable_pipeline2", enable_pipeline2)
        if enable_public_signup_user_exists_error is not None:
            pulumi.set(__self__, "enable_public_signup_user_exists_error", enable_public_signup_user_exists_error)
        if no_disclose_enterprise_connections is not None:
            pulumi.set(__self__, "no_disclose_enterprise_connections", no_disclose_enterprise_connections)
        if revoke_refresh_token_grant is not None:
            pulumi.set(__self__, "revoke_refresh_token_grant", revoke_refresh_token_grant)
        if universal_login is not None:
            pulumi.set(__self__, "universal_login", universal_login)
        if use_scope_descriptions_for_consent is not None:
            pulumi.set(__self__, "use_scope_descriptions_for_consent", use_scope_descriptions_for_consent)

    @property
    @pulumi.getter(name="allowLegacyDelegationGrantTypes")
    def allow_legacy_delegation_grant_types(self) -> Optional[bool]:
        """
        Whether the legacy delegation endpoint will be enabled for your account (true) or not available (false).
        """
        return pulumi.get(self, "allow_legacy_delegation_grant_types")

    @property
    @pulumi.getter(name="allowLegacyRoGrantTypes")
    def allow_legacy_ro_grant_types(self) -> Optional[bool]:
        """
        Whether the legacy `auth/ro` endpoint (used with resource owner password and passwordless features) will be enabled for your account (true) or not available (false).
        """
        return pulumi.get(self, "allow_legacy_ro_grant_types")

    @property
    @pulumi.getter(name="allowLegacyTokeninfoEndpoint")
    def allow_legacy_tokeninfo_endpoint(self) -> Optional[bool]:
        """
        If enabled, customers can use Tokeninfo Endpoint, otherwise they can not use it.
        """
        return pulumi.get(self, "allow_legacy_tokeninfo_endpoint")

    @property
    @pulumi.getter(name="dashboardInsightsView")
    def dashboard_insights_view(self) -> Optional[bool]:
        """
        Enables new insights activity page view.
        """
        return pulumi.get(self, "dashboard_insights_view")

    @property
    @pulumi.getter(name="dashboardLogStreamsNext")
    def dashboard_log_streams_next(self) -> Optional[bool]:
        """
        Enables beta access to log streaming changes.
        """
        return pulumi.get(self, "dashboard_log_streams_next")

    @property
    @pulumi.getter(name="disableClickjackProtectionHeaders")
    def disable_clickjack_protection_headers(self) -> Optional[bool]:
        """
        Indicates whether classic Universal Login prompts include additional security headers to prevent clickjacking.
        """
        return pulumi.get(self, "disable_clickjack_protection_headers")

    @property
    @pulumi.getter(name="disableFieldsMapFix")
    def disable_fields_map_fix(self) -> Optional[bool]:
        """
        Disables SAML fields map fix for bad mappings with repeated attributes.
        """
        return pulumi.get(self, "disable_fields_map_fix")

    @property
    @pulumi.getter(name="disableManagementApiSmsObfuscation")
    def disable_management_api_sms_obfuscation(self) -> Optional[bool]:
        """
        If true, SMS phone numbers will not be obfuscated in Management API GET calls.
        """
        return pulumi.get(self, "disable_management_api_sms_obfuscation")

    @property
    @pulumi.getter(name="enableAdfsWaadEmailVerification")
    def enable_adfs_waad_email_verification(self) -> Optional[bool]:
        """
        If enabled, users will be presented with an email verification prompt during their first login when using Azure AD or ADFS connections.
        """
        return pulumi.get(self, "enable_adfs_waad_email_verification")

    @property
    @pulumi.getter(name="enableApisSection")
    def enable_apis_section(self) -> Optional[bool]:
        """
        Indicates whether the APIs section is enabled for the tenant.
        """
        return pulumi.get(self, "enable_apis_section")

    @property
    @pulumi.getter(name="enableClientConnections")
    def enable_client_connections(self) -> Optional[bool]:
        """
        Indicates whether all current connections should be enabled when a new client is created.
        """
        return pulumi.get(self, "enable_client_connections")

    @property
    @pulumi.getter(name="enableCustomDomainInEmails")
    def enable_custom_domain_in_emails(self) -> Optional[bool]:
        """
        Indicates whether the tenant allows custom domains in emails.
        """
        return pulumi.get(self, "enable_custom_domain_in_emails")

    @property
    @pulumi.getter(name="enableDynamicClientRegistration")
    def enable_dynamic_client_registration(self) -> Optional[bool]:
        """
        Indicates whether the tenant allows dynamic client registration.
        """
        return pulumi.get(self, "enable_dynamic_client_registration")

    @property
    @pulumi.getter(name="enableIdtokenApi2")
    def enable_idtoken_api2(self) -> Optional[bool]:
        """
        Whether ID tokens can be used to authorize some types of requests to API v2 (true) or not (false).
        """
        return pulumi.get(self, "enable_idtoken_api2")

    @property
    @pulumi.getter(name="enableLegacyLogsSearchV2")
    def enable_legacy_logs_search_v2(self) -> Optional[bool]:
        """
        Indicates whether to use the older v2 legacy logs search.
        """
        return pulumi.get(self, "enable_legacy_logs_search_v2")

    @property
    @pulumi.getter(name="enableLegacyProfile")
    def enable_legacy_profile(self) -> Optional[bool]:
        """
        Whether ID tokens and the userinfo endpoint includes a complete user profile (true) or only OpenID Connect claims (false).
        """
        return pulumi.get(self, "enable_legacy_profile")

    @property
    @pulumi.getter(name="enablePipeline2")
    def enable_pipeline2(self) -> Optional[bool]:
        """
        Indicates whether advanced API Authorization scenarios are enabled.
        """
        return pulumi.get(self, "enable_pipeline2")

    @property
    @pulumi.getter(name="enablePublicSignupUserExistsError")
    def enable_public_signup_user_exists_error(self) -> Optional[bool]:
        """
        Indicates whether the public sign up process shows a `user_exists` error if the user already exists.
        """
        return pulumi.get(self, "enable_public_signup_user_exists_error")

    @property
    @pulumi.getter(name="noDiscloseEnterpriseConnections")
    def no_disclose_enterprise_connections(self) -> Optional[bool]:
        """
        Do not Publish Enterprise Connections Information with IdP domains on the lock configuration file.
        """
        return pulumi.get(self, "no_disclose_enterprise_connections")

    @property
    @pulumi.getter(name="revokeRefreshTokenGrant")
    def revoke_refresh_token_grant(self) -> Optional[bool]:
        """
        Delete underlying grant when a refresh token is revoked via the Authentication API.
        """
        return pulumi.get(self, "revoke_refresh_token_grant")

    @property
    @pulumi.getter(name="universalLogin")
    def universal_login(self) -> Optional[bool]:
        """
        Indicates whether the tenant uses Universal Login.
        """
        return pulumi.get(self, "universal_login")

    @property
    @pulumi.getter(name="useScopeDescriptionsForConsent")
    def use_scope_descriptions_for_consent(self) -> Optional[bool]:
        """
        Indicates whether to use scope descriptions for consent.
        """
        return pulumi.get(self, "use_scope_descriptions_for_consent")


@pulumi.output_type
class TenantGuardianMfaPage(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 html: str):
        """
        :param bool enabled: Indicates whether to use the custom Guardian page.
        :param str html: HTML format with supported Liquid syntax. Customized content of the Guardian page.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "html", html)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether to use the custom Guardian page.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def html(self) -> str:
        """
        HTML format with supported Liquid syntax. Customized content of the Guardian page.
        """
        return pulumi.get(self, "html")


@pulumi.output_type
class TenantSessionCookie(dict):
    def __init__(__self__, *,
                 mode: Optional[str] = None):
        """
        :param str mode: Behavior of tenant session cookie. Accepts either "persistent" or "non-persistent".
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Behavior of tenant session cookie. Accepts either "persistent" or "non-persistent".
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class TenantUniversalLogin(dict):
    def __init__(__self__, *,
                 colors: Optional['outputs.TenantUniversalLoginColors'] = None):
        """
        :param 'TenantUniversalLoginColorsArgs' colors: Configuration settings for Universal Login colors.
        """
        if colors is not None:
            pulumi.set(__self__, "colors", colors)

    @property
    @pulumi.getter
    def colors(self) -> Optional['outputs.TenantUniversalLoginColors']:
        """
        Configuration settings for Universal Login colors.
        """
        return pulumi.get(self, "colors")


@pulumi.output_type
class TenantUniversalLoginColors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pageBackground":
            suggest = "page_background"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TenantUniversalLoginColors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TenantUniversalLoginColors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TenantUniversalLoginColors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 page_background: Optional[str] = None,
                 primary: Optional[str] = None):
        if page_background is not None:
            pulumi.set(__self__, "page_background", page_background)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @property
    @pulumi.getter(name="pageBackground")
    def page_background(self) -> Optional[str]:
        return pulumi.get(self, "page_background")

    @property
    @pulumi.getter
    def primary(self) -> Optional[str]:
        return pulumi.get(self, "primary")


@pulumi.output_type
class TriggerBindingAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBindingAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBindingAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBindingAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 id: str):
        """
        :param str display_name: The name of an action.
        :param str id: Action ID.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The name of an action.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Action ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetClientAddonResult(dict):
    def __init__(__self__, *,
                 aws: Mapping[str, Any],
                 azure_blob: Mapping[str, Any],
                 azure_sb: Mapping[str, Any],
                 box: Mapping[str, Any],
                 cloudbees: Mapping[str, Any],
                 concur: Mapping[str, Any],
                 dropbox: Mapping[str, Any],
                 echosign: Mapping[str, Any],
                 egnyte: Mapping[str, Any],
                 firebase: Mapping[str, Any],
                 layer: Mapping[str, Any],
                 mscrm: Mapping[str, Any],
                 newrelic: Mapping[str, Any],
                 office365: Mapping[str, Any],
                 rms: Mapping[str, Any],
                 salesforce: Mapping[str, Any],
                 salesforce_api: Mapping[str, Any],
                 salesforce_sandbox_api: Mapping[str, Any],
                 samlps: Sequence['outputs.GetClientAddonSamlpResult'],
                 sap_api: Mapping[str, Any],
                 sentry: Mapping[str, Any],
                 sharepoint: Mapping[str, Any],
                 slack: Mapping[str, Any],
                 springcm: Mapping[str, Any],
                 wams: Mapping[str, Any],
                 wsfed: Mapping[str, Any],
                 zendesk: Mapping[str, Any],
                 zoom: Mapping[str, Any]):
        pulumi.set(__self__, "aws", aws)
        pulumi.set(__self__, "azure_blob", azure_blob)
        pulumi.set(__self__, "azure_sb", azure_sb)
        pulumi.set(__self__, "box", box)
        pulumi.set(__self__, "cloudbees", cloudbees)
        pulumi.set(__self__, "concur", concur)
        pulumi.set(__self__, "dropbox", dropbox)
        pulumi.set(__self__, "echosign", echosign)
        pulumi.set(__self__, "egnyte", egnyte)
        pulumi.set(__self__, "firebase", firebase)
        pulumi.set(__self__, "layer", layer)
        pulumi.set(__self__, "mscrm", mscrm)
        pulumi.set(__self__, "newrelic", newrelic)
        pulumi.set(__self__, "office365", office365)
        pulumi.set(__self__, "rms", rms)
        pulumi.set(__self__, "salesforce", salesforce)
        pulumi.set(__self__, "salesforce_api", salesforce_api)
        pulumi.set(__self__, "salesforce_sandbox_api", salesforce_sandbox_api)
        pulumi.set(__self__, "samlps", samlps)
        pulumi.set(__self__, "sap_api", sap_api)
        pulumi.set(__self__, "sentry", sentry)
        pulumi.set(__self__, "sharepoint", sharepoint)
        pulumi.set(__self__, "slack", slack)
        pulumi.set(__self__, "springcm", springcm)
        pulumi.set(__self__, "wams", wams)
        pulumi.set(__self__, "wsfed", wsfed)
        pulumi.set(__self__, "zendesk", zendesk)
        pulumi.set(__self__, "zoom", zoom)

    @property
    @pulumi.getter
    def aws(self) -> Mapping[str, Any]:
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter(name="azureBlob")
    def azure_blob(self) -> Mapping[str, Any]:
        return pulumi.get(self, "azure_blob")

    @property
    @pulumi.getter(name="azureSb")
    def azure_sb(self) -> Mapping[str, Any]:
        return pulumi.get(self, "azure_sb")

    @property
    @pulumi.getter
    def box(self) -> Mapping[str, Any]:
        return pulumi.get(self, "box")

    @property
    @pulumi.getter
    def cloudbees(self) -> Mapping[str, Any]:
        return pulumi.get(self, "cloudbees")

    @property
    @pulumi.getter
    def concur(self) -> Mapping[str, Any]:
        return pulumi.get(self, "concur")

    @property
    @pulumi.getter
    def dropbox(self) -> Mapping[str, Any]:
        return pulumi.get(self, "dropbox")

    @property
    @pulumi.getter
    def echosign(self) -> Mapping[str, Any]:
        return pulumi.get(self, "echosign")

    @property
    @pulumi.getter
    def egnyte(self) -> Mapping[str, Any]:
        return pulumi.get(self, "egnyte")

    @property
    @pulumi.getter
    def firebase(self) -> Mapping[str, Any]:
        return pulumi.get(self, "firebase")

    @property
    @pulumi.getter
    def layer(self) -> Mapping[str, Any]:
        return pulumi.get(self, "layer")

    @property
    @pulumi.getter
    def mscrm(self) -> Mapping[str, Any]:
        return pulumi.get(self, "mscrm")

    @property
    @pulumi.getter
    def newrelic(self) -> Mapping[str, Any]:
        return pulumi.get(self, "newrelic")

    @property
    @pulumi.getter
    def office365(self) -> Mapping[str, Any]:
        return pulumi.get(self, "office365")

    @property
    @pulumi.getter
    def rms(self) -> Mapping[str, Any]:
        return pulumi.get(self, "rms")

    @property
    @pulumi.getter
    def salesforce(self) -> Mapping[str, Any]:
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="salesforceApi")
    def salesforce_api(self) -> Mapping[str, Any]:
        return pulumi.get(self, "salesforce_api")

    @property
    @pulumi.getter(name="salesforceSandboxApi")
    def salesforce_sandbox_api(self) -> Mapping[str, Any]:
        return pulumi.get(self, "salesforce_sandbox_api")

    @property
    @pulumi.getter
    def samlps(self) -> Sequence['outputs.GetClientAddonSamlpResult']:
        return pulumi.get(self, "samlps")

    @property
    @pulumi.getter(name="sapApi")
    def sap_api(self) -> Mapping[str, Any]:
        return pulumi.get(self, "sap_api")

    @property
    @pulumi.getter
    def sentry(self) -> Mapping[str, Any]:
        return pulumi.get(self, "sentry")

    @property
    @pulumi.getter
    def sharepoint(self) -> Mapping[str, Any]:
        return pulumi.get(self, "sharepoint")

    @property
    @pulumi.getter
    def slack(self) -> Mapping[str, Any]:
        return pulumi.get(self, "slack")

    @property
    @pulumi.getter
    def springcm(self) -> Mapping[str, Any]:
        return pulumi.get(self, "springcm")

    @property
    @pulumi.getter
    def wams(self) -> Mapping[str, Any]:
        return pulumi.get(self, "wams")

    @property
    @pulumi.getter
    def wsfed(self) -> Mapping[str, Any]:
        return pulumi.get(self, "wsfed")

    @property
    @pulumi.getter
    def zendesk(self) -> Mapping[str, Any]:
        return pulumi.get(self, "zendesk")

    @property
    @pulumi.getter
    def zoom(self) -> Mapping[str, Any]:
        return pulumi.get(self, "zoom")


@pulumi.output_type
class GetClientAddonSamlpResult(dict):
    def __init__(__self__, *,
                 audience: str,
                 authn_context_class_ref: str,
                 binding: str,
                 create_upn_claim: bool,
                 destination: str,
                 digest_algorithm: str,
                 include_attribute_name_format: bool,
                 issuer: str,
                 lifetime_in_seconds: int,
                 logout: Mapping[str, Any],
                 map_identities: bool,
                 map_unknown_claims_as_is: bool,
                 mappings: Mapping[str, Any],
                 name_identifier_format: str,
                 name_identifier_probes: Sequence[str],
                 passthrough_claims_with_no_mapping: bool,
                 recipient: str,
                 sign_response: bool,
                 signature_algorithm: str,
                 signing_cert: str,
                 typed_attributes: bool):
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "authn_context_class_ref", authn_context_class_ref)
        pulumi.set(__self__, "binding", binding)
        pulumi.set(__self__, "create_upn_claim", create_upn_claim)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "digest_algorithm", digest_algorithm)
        pulumi.set(__self__, "include_attribute_name_format", include_attribute_name_format)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "lifetime_in_seconds", lifetime_in_seconds)
        pulumi.set(__self__, "logout", logout)
        pulumi.set(__self__, "map_identities", map_identities)
        pulumi.set(__self__, "map_unknown_claims_as_is", map_unknown_claims_as_is)
        pulumi.set(__self__, "mappings", mappings)
        pulumi.set(__self__, "name_identifier_format", name_identifier_format)
        pulumi.set(__self__, "name_identifier_probes", name_identifier_probes)
        pulumi.set(__self__, "passthrough_claims_with_no_mapping", passthrough_claims_with_no_mapping)
        pulumi.set(__self__, "recipient", recipient)
        pulumi.set(__self__, "sign_response", sign_response)
        pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        pulumi.set(__self__, "signing_cert", signing_cert)
        pulumi.set(__self__, "typed_attributes", typed_attributes)

    @property
    @pulumi.getter
    def audience(self) -> str:
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="authnContextClassRef")
    def authn_context_class_ref(self) -> str:
        return pulumi.get(self, "authn_context_class_ref")

    @property
    @pulumi.getter
    def binding(self) -> str:
        return pulumi.get(self, "binding")

    @property
    @pulumi.getter(name="createUpnClaim")
    def create_upn_claim(self) -> bool:
        return pulumi.get(self, "create_upn_claim")

    @property
    @pulumi.getter
    def destination(self) -> str:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="digestAlgorithm")
    def digest_algorithm(self) -> str:
        return pulumi.get(self, "digest_algorithm")

    @property
    @pulumi.getter(name="includeAttributeNameFormat")
    def include_attribute_name_format(self) -> bool:
        return pulumi.get(self, "include_attribute_name_format")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="lifetimeInSeconds")
    def lifetime_in_seconds(self) -> int:
        return pulumi.get(self, "lifetime_in_seconds")

    @property
    @pulumi.getter
    def logout(self) -> Mapping[str, Any]:
        return pulumi.get(self, "logout")

    @property
    @pulumi.getter(name="mapIdentities")
    def map_identities(self) -> bool:
        return pulumi.get(self, "map_identities")

    @property
    @pulumi.getter(name="mapUnknownClaimsAsIs")
    def map_unknown_claims_as_is(self) -> bool:
        return pulumi.get(self, "map_unknown_claims_as_is")

    @property
    @pulumi.getter
    def mappings(self) -> Mapping[str, Any]:
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter(name="nameIdentifierFormat")
    def name_identifier_format(self) -> str:
        return pulumi.get(self, "name_identifier_format")

    @property
    @pulumi.getter(name="nameIdentifierProbes")
    def name_identifier_probes(self) -> Sequence[str]:
        return pulumi.get(self, "name_identifier_probes")

    @property
    @pulumi.getter(name="passthroughClaimsWithNoMapping")
    def passthrough_claims_with_no_mapping(self) -> bool:
        return pulumi.get(self, "passthrough_claims_with_no_mapping")

    @property
    @pulumi.getter
    def recipient(self) -> str:
        return pulumi.get(self, "recipient")

    @property
    @pulumi.getter(name="signResponse")
    def sign_response(self) -> bool:
        return pulumi.get(self, "sign_response")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> str:
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter(name="signingCert")
    def signing_cert(self) -> str:
        return pulumi.get(self, "signing_cert")

    @property
    @pulumi.getter(name="typedAttributes")
    def typed_attributes(self) -> bool:
        return pulumi.get(self, "typed_attributes")


@pulumi.output_type
class GetClientJwtConfigurationResult(dict):
    def __init__(__self__, *,
                 alg: str,
                 lifetime_in_seconds: int,
                 scopes: Mapping[str, str],
                 secret_encoded: bool):
        pulumi.set(__self__, "alg", alg)
        pulumi.set(__self__, "lifetime_in_seconds", lifetime_in_seconds)
        pulumi.set(__self__, "scopes", scopes)
        pulumi.set(__self__, "secret_encoded", secret_encoded)

    @property
    @pulumi.getter
    def alg(self) -> str:
        return pulumi.get(self, "alg")

    @property
    @pulumi.getter(name="lifetimeInSeconds")
    def lifetime_in_seconds(self) -> int:
        return pulumi.get(self, "lifetime_in_seconds")

    @property
    @pulumi.getter
    def scopes(self) -> Mapping[str, str]:
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="secretEncoded")
    def secret_encoded(self) -> bool:
        return pulumi.get(self, "secret_encoded")


@pulumi.output_type
class GetClientMobileResult(dict):
    def __init__(__self__, *,
                 androids: Sequence['outputs.GetClientMobileAndroidResult'],
                 ios: Sequence['outputs.GetClientMobileIoResult']):
        pulumi.set(__self__, "androids", androids)
        pulumi.set(__self__, "ios", ios)

    @property
    @pulumi.getter
    def androids(self) -> Sequence['outputs.GetClientMobileAndroidResult']:
        return pulumi.get(self, "androids")

    @property
    @pulumi.getter
    def ios(self) -> Sequence['outputs.GetClientMobileIoResult']:
        return pulumi.get(self, "ios")


@pulumi.output_type
class GetClientMobileAndroidResult(dict):
    def __init__(__self__, *,
                 app_package_name: str,
                 sha256_cert_fingerprints: Sequence[str]):
        pulumi.set(__self__, "app_package_name", app_package_name)
        pulumi.set(__self__, "sha256_cert_fingerprints", sha256_cert_fingerprints)

    @property
    @pulumi.getter(name="appPackageName")
    def app_package_name(self) -> str:
        return pulumi.get(self, "app_package_name")

    @property
    @pulumi.getter(name="sha256CertFingerprints")
    def sha256_cert_fingerprints(self) -> Sequence[str]:
        return pulumi.get(self, "sha256_cert_fingerprints")


@pulumi.output_type
class GetClientMobileIoResult(dict):
    def __init__(__self__, *,
                 app_bundle_identifier: str,
                 team_id: str):
        pulumi.set(__self__, "app_bundle_identifier", app_bundle_identifier)
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="appBundleIdentifier")
    def app_bundle_identifier(self) -> str:
        return pulumi.get(self, "app_bundle_identifier")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        return pulumi.get(self, "team_id")


@pulumi.output_type
class GetClientNativeSocialLoginResult(dict):
    def __init__(__self__, *,
                 apples: Sequence['outputs.GetClientNativeSocialLoginAppleResult'],
                 facebooks: Sequence['outputs.GetClientNativeSocialLoginFacebookResult']):
        pulumi.set(__self__, "apples", apples)
        pulumi.set(__self__, "facebooks", facebooks)

    @property
    @pulumi.getter
    def apples(self) -> Sequence['outputs.GetClientNativeSocialLoginAppleResult']:
        return pulumi.get(self, "apples")

    @property
    @pulumi.getter
    def facebooks(self) -> Sequence['outputs.GetClientNativeSocialLoginFacebookResult']:
        return pulumi.get(self, "facebooks")


@pulumi.output_type
class GetClientNativeSocialLoginAppleResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetClientNativeSocialLoginFacebookResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetClientRefreshTokenResult(dict):
    def __init__(__self__, *,
                 expiration_type: str,
                 idle_token_lifetime: int,
                 infinite_idle_token_lifetime: bool,
                 infinite_token_lifetime: bool,
                 leeway: int,
                 rotation_type: str,
                 token_lifetime: int):
        pulumi.set(__self__, "expiration_type", expiration_type)
        pulumi.set(__self__, "idle_token_lifetime", idle_token_lifetime)
        pulumi.set(__self__, "infinite_idle_token_lifetime", infinite_idle_token_lifetime)
        pulumi.set(__self__, "infinite_token_lifetime", infinite_token_lifetime)
        pulumi.set(__self__, "leeway", leeway)
        pulumi.set(__self__, "rotation_type", rotation_type)
        pulumi.set(__self__, "token_lifetime", token_lifetime)

    @property
    @pulumi.getter(name="expirationType")
    def expiration_type(self) -> str:
        return pulumi.get(self, "expiration_type")

    @property
    @pulumi.getter(name="idleTokenLifetime")
    def idle_token_lifetime(self) -> int:
        return pulumi.get(self, "idle_token_lifetime")

    @property
    @pulumi.getter(name="infiniteIdleTokenLifetime")
    def infinite_idle_token_lifetime(self) -> bool:
        return pulumi.get(self, "infinite_idle_token_lifetime")

    @property
    @pulumi.getter(name="infiniteTokenLifetime")
    def infinite_token_lifetime(self) -> bool:
        return pulumi.get(self, "infinite_token_lifetime")

    @property
    @pulumi.getter
    def leeway(self) -> int:
        return pulumi.get(self, "leeway")

    @property
    @pulumi.getter(name="rotationType")
    def rotation_type(self) -> str:
        return pulumi.get(self, "rotation_type")

    @property
    @pulumi.getter(name="tokenLifetime")
    def token_lifetime(self) -> int:
        return pulumi.get(self, "token_lifetime")


@pulumi.output_type
class GetGlobalClientAddonResult(dict):
    def __init__(__self__, *,
                 aws: Mapping[str, Any],
                 azure_blob: Mapping[str, Any],
                 azure_sb: Mapping[str, Any],
                 box: Mapping[str, Any],
                 cloudbees: Mapping[str, Any],
                 concur: Mapping[str, Any],
                 dropbox: Mapping[str, Any],
                 echosign: Mapping[str, Any],
                 egnyte: Mapping[str, Any],
                 firebase: Mapping[str, Any],
                 layer: Mapping[str, Any],
                 mscrm: Mapping[str, Any],
                 newrelic: Mapping[str, Any],
                 office365: Mapping[str, Any],
                 rms: Mapping[str, Any],
                 salesforce: Mapping[str, Any],
                 salesforce_api: Mapping[str, Any],
                 salesforce_sandbox_api: Mapping[str, Any],
                 samlps: Sequence['outputs.GetGlobalClientAddonSamlpResult'],
                 sap_api: Mapping[str, Any],
                 sentry: Mapping[str, Any],
                 sharepoint: Mapping[str, Any],
                 slack: Mapping[str, Any],
                 springcm: Mapping[str, Any],
                 wams: Mapping[str, Any],
                 wsfed: Mapping[str, Any],
                 zendesk: Mapping[str, Any],
                 zoom: Mapping[str, Any]):
        pulumi.set(__self__, "aws", aws)
        pulumi.set(__self__, "azure_blob", azure_blob)
        pulumi.set(__self__, "azure_sb", azure_sb)
        pulumi.set(__self__, "box", box)
        pulumi.set(__self__, "cloudbees", cloudbees)
        pulumi.set(__self__, "concur", concur)
        pulumi.set(__self__, "dropbox", dropbox)
        pulumi.set(__self__, "echosign", echosign)
        pulumi.set(__self__, "egnyte", egnyte)
        pulumi.set(__self__, "firebase", firebase)
        pulumi.set(__self__, "layer", layer)
        pulumi.set(__self__, "mscrm", mscrm)
        pulumi.set(__self__, "newrelic", newrelic)
        pulumi.set(__self__, "office365", office365)
        pulumi.set(__self__, "rms", rms)
        pulumi.set(__self__, "salesforce", salesforce)
        pulumi.set(__self__, "salesforce_api", salesforce_api)
        pulumi.set(__self__, "salesforce_sandbox_api", salesforce_sandbox_api)
        pulumi.set(__self__, "samlps", samlps)
        pulumi.set(__self__, "sap_api", sap_api)
        pulumi.set(__self__, "sentry", sentry)
        pulumi.set(__self__, "sharepoint", sharepoint)
        pulumi.set(__self__, "slack", slack)
        pulumi.set(__self__, "springcm", springcm)
        pulumi.set(__self__, "wams", wams)
        pulumi.set(__self__, "wsfed", wsfed)
        pulumi.set(__self__, "zendesk", zendesk)
        pulumi.set(__self__, "zoom", zoom)

    @property
    @pulumi.getter
    def aws(self) -> Mapping[str, Any]:
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter(name="azureBlob")
    def azure_blob(self) -> Mapping[str, Any]:
        return pulumi.get(self, "azure_blob")

    @property
    @pulumi.getter(name="azureSb")
    def azure_sb(self) -> Mapping[str, Any]:
        return pulumi.get(self, "azure_sb")

    @property
    @pulumi.getter
    def box(self) -> Mapping[str, Any]:
        return pulumi.get(self, "box")

    @property
    @pulumi.getter
    def cloudbees(self) -> Mapping[str, Any]:
        return pulumi.get(self, "cloudbees")

    @property
    @pulumi.getter
    def concur(self) -> Mapping[str, Any]:
        return pulumi.get(self, "concur")

    @property
    @pulumi.getter
    def dropbox(self) -> Mapping[str, Any]:
        return pulumi.get(self, "dropbox")

    @property
    @pulumi.getter
    def echosign(self) -> Mapping[str, Any]:
        return pulumi.get(self, "echosign")

    @property
    @pulumi.getter
    def egnyte(self) -> Mapping[str, Any]:
        return pulumi.get(self, "egnyte")

    @property
    @pulumi.getter
    def firebase(self) -> Mapping[str, Any]:
        return pulumi.get(self, "firebase")

    @property
    @pulumi.getter
    def layer(self) -> Mapping[str, Any]:
        return pulumi.get(self, "layer")

    @property
    @pulumi.getter
    def mscrm(self) -> Mapping[str, Any]:
        return pulumi.get(self, "mscrm")

    @property
    @pulumi.getter
    def newrelic(self) -> Mapping[str, Any]:
        return pulumi.get(self, "newrelic")

    @property
    @pulumi.getter
    def office365(self) -> Mapping[str, Any]:
        return pulumi.get(self, "office365")

    @property
    @pulumi.getter
    def rms(self) -> Mapping[str, Any]:
        return pulumi.get(self, "rms")

    @property
    @pulumi.getter
    def salesforce(self) -> Mapping[str, Any]:
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="salesforceApi")
    def salesforce_api(self) -> Mapping[str, Any]:
        return pulumi.get(self, "salesforce_api")

    @property
    @pulumi.getter(name="salesforceSandboxApi")
    def salesforce_sandbox_api(self) -> Mapping[str, Any]:
        return pulumi.get(self, "salesforce_sandbox_api")

    @property
    @pulumi.getter
    def samlps(self) -> Sequence['outputs.GetGlobalClientAddonSamlpResult']:
        return pulumi.get(self, "samlps")

    @property
    @pulumi.getter(name="sapApi")
    def sap_api(self) -> Mapping[str, Any]:
        return pulumi.get(self, "sap_api")

    @property
    @pulumi.getter
    def sentry(self) -> Mapping[str, Any]:
        return pulumi.get(self, "sentry")

    @property
    @pulumi.getter
    def sharepoint(self) -> Mapping[str, Any]:
        return pulumi.get(self, "sharepoint")

    @property
    @pulumi.getter
    def slack(self) -> Mapping[str, Any]:
        return pulumi.get(self, "slack")

    @property
    @pulumi.getter
    def springcm(self) -> Mapping[str, Any]:
        return pulumi.get(self, "springcm")

    @property
    @pulumi.getter
    def wams(self) -> Mapping[str, Any]:
        return pulumi.get(self, "wams")

    @property
    @pulumi.getter
    def wsfed(self) -> Mapping[str, Any]:
        return pulumi.get(self, "wsfed")

    @property
    @pulumi.getter
    def zendesk(self) -> Mapping[str, Any]:
        return pulumi.get(self, "zendesk")

    @property
    @pulumi.getter
    def zoom(self) -> Mapping[str, Any]:
        return pulumi.get(self, "zoom")


@pulumi.output_type
class GetGlobalClientAddonSamlpResult(dict):
    def __init__(__self__, *,
                 audience: str,
                 authn_context_class_ref: str,
                 binding: str,
                 create_upn_claim: bool,
                 destination: str,
                 digest_algorithm: str,
                 include_attribute_name_format: bool,
                 issuer: str,
                 lifetime_in_seconds: int,
                 logout: Mapping[str, Any],
                 map_identities: bool,
                 map_unknown_claims_as_is: bool,
                 mappings: Mapping[str, Any],
                 name_identifier_format: str,
                 name_identifier_probes: Sequence[str],
                 passthrough_claims_with_no_mapping: bool,
                 recipient: str,
                 sign_response: bool,
                 signature_algorithm: str,
                 signing_cert: str,
                 typed_attributes: bool):
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "authn_context_class_ref", authn_context_class_ref)
        pulumi.set(__self__, "binding", binding)
        pulumi.set(__self__, "create_upn_claim", create_upn_claim)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "digest_algorithm", digest_algorithm)
        pulumi.set(__self__, "include_attribute_name_format", include_attribute_name_format)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "lifetime_in_seconds", lifetime_in_seconds)
        pulumi.set(__self__, "logout", logout)
        pulumi.set(__self__, "map_identities", map_identities)
        pulumi.set(__self__, "map_unknown_claims_as_is", map_unknown_claims_as_is)
        pulumi.set(__self__, "mappings", mappings)
        pulumi.set(__self__, "name_identifier_format", name_identifier_format)
        pulumi.set(__self__, "name_identifier_probes", name_identifier_probes)
        pulumi.set(__self__, "passthrough_claims_with_no_mapping", passthrough_claims_with_no_mapping)
        pulumi.set(__self__, "recipient", recipient)
        pulumi.set(__self__, "sign_response", sign_response)
        pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        pulumi.set(__self__, "signing_cert", signing_cert)
        pulumi.set(__self__, "typed_attributes", typed_attributes)

    @property
    @pulumi.getter
    def audience(self) -> str:
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="authnContextClassRef")
    def authn_context_class_ref(self) -> str:
        return pulumi.get(self, "authn_context_class_ref")

    @property
    @pulumi.getter
    def binding(self) -> str:
        return pulumi.get(self, "binding")

    @property
    @pulumi.getter(name="createUpnClaim")
    def create_upn_claim(self) -> bool:
        return pulumi.get(self, "create_upn_claim")

    @property
    @pulumi.getter
    def destination(self) -> str:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="digestAlgorithm")
    def digest_algorithm(self) -> str:
        return pulumi.get(self, "digest_algorithm")

    @property
    @pulumi.getter(name="includeAttributeNameFormat")
    def include_attribute_name_format(self) -> bool:
        return pulumi.get(self, "include_attribute_name_format")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="lifetimeInSeconds")
    def lifetime_in_seconds(self) -> int:
        return pulumi.get(self, "lifetime_in_seconds")

    @property
    @pulumi.getter
    def logout(self) -> Mapping[str, Any]:
        return pulumi.get(self, "logout")

    @property
    @pulumi.getter(name="mapIdentities")
    def map_identities(self) -> bool:
        return pulumi.get(self, "map_identities")

    @property
    @pulumi.getter(name="mapUnknownClaimsAsIs")
    def map_unknown_claims_as_is(self) -> bool:
        return pulumi.get(self, "map_unknown_claims_as_is")

    @property
    @pulumi.getter
    def mappings(self) -> Mapping[str, Any]:
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter(name="nameIdentifierFormat")
    def name_identifier_format(self) -> str:
        return pulumi.get(self, "name_identifier_format")

    @property
    @pulumi.getter(name="nameIdentifierProbes")
    def name_identifier_probes(self) -> Sequence[str]:
        return pulumi.get(self, "name_identifier_probes")

    @property
    @pulumi.getter(name="passthroughClaimsWithNoMapping")
    def passthrough_claims_with_no_mapping(self) -> bool:
        return pulumi.get(self, "passthrough_claims_with_no_mapping")

    @property
    @pulumi.getter
    def recipient(self) -> str:
        return pulumi.get(self, "recipient")

    @property
    @pulumi.getter(name="signResponse")
    def sign_response(self) -> bool:
        return pulumi.get(self, "sign_response")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> str:
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter(name="signingCert")
    def signing_cert(self) -> str:
        return pulumi.get(self, "signing_cert")

    @property
    @pulumi.getter(name="typedAttributes")
    def typed_attributes(self) -> bool:
        return pulumi.get(self, "typed_attributes")


@pulumi.output_type
class GetGlobalClientJwtConfigurationResult(dict):
    def __init__(__self__, *,
                 alg: str,
                 lifetime_in_seconds: int,
                 scopes: Mapping[str, str],
                 secret_encoded: bool):
        pulumi.set(__self__, "alg", alg)
        pulumi.set(__self__, "lifetime_in_seconds", lifetime_in_seconds)
        pulumi.set(__self__, "scopes", scopes)
        pulumi.set(__self__, "secret_encoded", secret_encoded)

    @property
    @pulumi.getter
    def alg(self) -> str:
        return pulumi.get(self, "alg")

    @property
    @pulumi.getter(name="lifetimeInSeconds")
    def lifetime_in_seconds(self) -> int:
        return pulumi.get(self, "lifetime_in_seconds")

    @property
    @pulumi.getter
    def scopes(self) -> Mapping[str, str]:
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="secretEncoded")
    def secret_encoded(self) -> bool:
        return pulumi.get(self, "secret_encoded")


@pulumi.output_type
class GetGlobalClientMobileResult(dict):
    def __init__(__self__, *,
                 androids: Sequence['outputs.GetGlobalClientMobileAndroidResult'],
                 ios: Sequence['outputs.GetGlobalClientMobileIoResult']):
        pulumi.set(__self__, "androids", androids)
        pulumi.set(__self__, "ios", ios)

    @property
    @pulumi.getter
    def androids(self) -> Sequence['outputs.GetGlobalClientMobileAndroidResult']:
        return pulumi.get(self, "androids")

    @property
    @pulumi.getter
    def ios(self) -> Sequence['outputs.GetGlobalClientMobileIoResult']:
        return pulumi.get(self, "ios")


@pulumi.output_type
class GetGlobalClientMobileAndroidResult(dict):
    def __init__(__self__, *,
                 app_package_name: str,
                 sha256_cert_fingerprints: Sequence[str]):
        pulumi.set(__self__, "app_package_name", app_package_name)
        pulumi.set(__self__, "sha256_cert_fingerprints", sha256_cert_fingerprints)

    @property
    @pulumi.getter(name="appPackageName")
    def app_package_name(self) -> str:
        return pulumi.get(self, "app_package_name")

    @property
    @pulumi.getter(name="sha256CertFingerprints")
    def sha256_cert_fingerprints(self) -> Sequence[str]:
        return pulumi.get(self, "sha256_cert_fingerprints")


@pulumi.output_type
class GetGlobalClientMobileIoResult(dict):
    def __init__(__self__, *,
                 app_bundle_identifier: str,
                 team_id: str):
        pulumi.set(__self__, "app_bundle_identifier", app_bundle_identifier)
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="appBundleIdentifier")
    def app_bundle_identifier(self) -> str:
        return pulumi.get(self, "app_bundle_identifier")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        return pulumi.get(self, "team_id")


@pulumi.output_type
class GetGlobalClientNativeSocialLoginResult(dict):
    def __init__(__self__, *,
                 apples: Sequence['outputs.GetGlobalClientNativeSocialLoginAppleResult'],
                 facebooks: Sequence['outputs.GetGlobalClientNativeSocialLoginFacebookResult']):
        pulumi.set(__self__, "apples", apples)
        pulumi.set(__self__, "facebooks", facebooks)

    @property
    @pulumi.getter
    def apples(self) -> Sequence['outputs.GetGlobalClientNativeSocialLoginAppleResult']:
        return pulumi.get(self, "apples")

    @property
    @pulumi.getter
    def facebooks(self) -> Sequence['outputs.GetGlobalClientNativeSocialLoginFacebookResult']:
        return pulumi.get(self, "facebooks")


@pulumi.output_type
class GetGlobalClientNativeSocialLoginAppleResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetGlobalClientNativeSocialLoginFacebookResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetGlobalClientRefreshTokenResult(dict):
    def __init__(__self__, *,
                 expiration_type: str,
                 idle_token_lifetime: int,
                 infinite_idle_token_lifetime: bool,
                 infinite_token_lifetime: bool,
                 leeway: int,
                 rotation_type: str,
                 token_lifetime: int):
        pulumi.set(__self__, "expiration_type", expiration_type)
        pulumi.set(__self__, "idle_token_lifetime", idle_token_lifetime)
        pulumi.set(__self__, "infinite_idle_token_lifetime", infinite_idle_token_lifetime)
        pulumi.set(__self__, "infinite_token_lifetime", infinite_token_lifetime)
        pulumi.set(__self__, "leeway", leeway)
        pulumi.set(__self__, "rotation_type", rotation_type)
        pulumi.set(__self__, "token_lifetime", token_lifetime)

    @property
    @pulumi.getter(name="expirationType")
    def expiration_type(self) -> str:
        return pulumi.get(self, "expiration_type")

    @property
    @pulumi.getter(name="idleTokenLifetime")
    def idle_token_lifetime(self) -> int:
        return pulumi.get(self, "idle_token_lifetime")

    @property
    @pulumi.getter(name="infiniteIdleTokenLifetime")
    def infinite_idle_token_lifetime(self) -> bool:
        return pulumi.get(self, "infinite_idle_token_lifetime")

    @property
    @pulumi.getter(name="infiniteTokenLifetime")
    def infinite_token_lifetime(self) -> bool:
        return pulumi.get(self, "infinite_token_lifetime")

    @property
    @pulumi.getter
    def leeway(self) -> int:
        return pulumi.get(self, "leeway")

    @property
    @pulumi.getter(name="rotationType")
    def rotation_type(self) -> str:
        return pulumi.get(self, "rotation_type")

    @property
    @pulumi.getter(name="tokenLifetime")
    def token_lifetime(self) -> int:
        return pulumi.get(self, "token_lifetime")


