
# Firebase Authentication UI in Python Using Tkinter

This package will help you to add modern authentication UI in your desktop based Python apps by **writing just 1 line**. Just add this repository in the root folder of your project and 
write couple of lines to use Firebase authentication system in your python apps. [Screenshots of the UI.](#screenshots-of-the-ui)

***Please read the full documentation to implement it in your project. It is very simple!***

[![Contributors](https://img.shields.io/badge/Total_Lines_of_Code_🐍-1121-yellow?style=for-the-badge)](https://github.com/PriomDeb/Firebase-Authentication-in-Python-Using-Tkinter/graphs/contributors)
[![Contributors](https://img.shields.io/github/contributors/PriomDeb/Firebase-Authentication-in-Python-Using-Tkinter?style=for-the-badge)](https://github.com/PriomDeb/Firebase-Authentication-in-Python-Using-Tkinter/graphs/contributors)
[![Members](https://img.shields.io/github/forks/PriomDeb/Firebase-Authentication-in-Python-Using-Tkinter?style=for-the-badge)](https://github.com/PriomDeb/Firebase-Authentication-in-Python-Using-Tkinter/network/members)
[![Stars](https://img.shields.io/github/stars/PriomDeb/Firebase-Authentication-in-Python-Using-Tkinter?style=for-the-badge)](https://github.com/PriomDeb/Firebase-Authentication-in-Python-Using-Tkinter/stargazers)


[![MIT License](https://img.shields.io/badge/License-MIT-green.svg)](https://choosealicense.com/licenses/mit/)
[!["FirebaseandPython"](https://img.shields.io/badge/Firebase-Python-yellow)](https://github.com/PriomDeb/Firebase-Authentication-in-Python-Using-Tkinter)
[!["Tkinter"](https://img.shields.io/badge/Tkinter-Python%20Framework-orange)](https://docs.python.org/3/library/tkinter.html)
[!["EZTranslation"](https://img.shields.io/badge/See%20a%20desktop%20app%20that%20uses-this%20authentication%20module-brightgreen)](https://www.priomdeb.com/ez-translation)
[!["PriomDeb"](https://img.shields.io/badge/PriomDeb-web-yellow)](http://priomdeb.com)

<br/>


# Documentation

## 🐍 Just 1 line of python code to implement authentication and modern UI in Python
Install this package, get your Firebase configuration file and just write 1 line code. [**A complete example is given at the end of this documentation.**](#an-example-of-complete-implementation-of-the-package-in-your-project)

Simplest Firebase Authentication and Modern UI in Python using Tkinter! <img width="50" height="50" src="https://i.gifer.com/origin/87/87863c1f95e7173189a1a1a1e714373a_w200.gif">

<br/>


### First install the package
```bash
pip install firebase-auth-ui
```

### Then import the package
```python
from firebase_auth_ui import draw_ui
```

### Now get your Firebase config values from your Firebase console and write 1 line python code
```python
# Set your Firebase config values
firebase_config = {
    "you will find it in your firebase console": "I have also added documentation about it"
    }


# Run the authentication method
# Here my_app will be a function which contain your codes, basically you will replace the my_app
# with your main calling function which run/call your app
draw_ui.run_authentication(firebase_config, my_app)


# draw_ui.run_authentication() takes to arguments 
# firebase_config_values and call_app

```

### Create a Firebase Project and Get Firebase Config Values
- Go to https://console.firebase.google.com/
- Click "Add project"
- Give your project name (Any name you want) and click Continue
- Keep Google Analytics as same as it (Default is Enabled) given and click Continue
- Select "Default Account for Firebase" and click Create project
- Wait for a couple of seconds to get your project ready and when it is ready click Continue
- A dashboard of **Project Overview** will be opened and you will see iOS+, Android and Web
- Click on the **Web** which icon is </>
- Give an app name and don't select "Also set up **Firebase Hosting** for this app. Learn more" then click Register app
- Now you will see **Add Firebase SDK**
- Look throgh the SDK codes that is generated by Firebase
- You will see a const variable **firebaseConfig** which is your configuration values to use Firebase Authentication
- Copy the entire **firebaseConfig** values
- ```const firebaseConfig = {
  apiKey: "XXxxXxX00XXxxx-xxxxX0XXXx0XxxxxxXXXXxxx",
  authDomain: "xxx-xx-xxxxx.xxxxxxxxxxx.com",
  projectId: "xxx-xx-xxxxx",
  storageBucket: "xxx-xx-xxxxx.xxxxxxxx.com",
  messagingSenderId: "xxxxxxxxxxxx",
  appId: "x:xxxxxxxxxxxx:web:xxxxxxxxxxxxxxxxxxxxxx",
  measurementId: "G-XXXXXXXXXX"}
- Click Continue to console
- Open your python script and create a dictionary variable **firebase_config** and paste the values like the ***given format***
- ```python 
  firebase_config={"apiKey": "XXxxXxX00XXxxx-xxxxX0XXXx0XxxxxxXXXXxxx",
  "authDomain": "xxx-xx-xxxxx.xxxxxxxxxxx.com",
  "projectId": "xxx-xx-xxxxx",
  "storageBucket": "xxx-xx-xxxxx.xxxxxxxx.com",
  "messagingSenderId": "xxxxxxxxxxxx",
  "appId": "x:xxxxxxxxxxxx:web:xxxxxxxxxxxxxxxxxxxxxx",
  "measurementId": "G-XXXXXXXXXX",
  "databaseURL": ""
  }
  # Copy this format exactly and DON"T FORGET TO KEEP "databaseURL":"", an empty string
  # Keep databaseURL value an empty string
  
  # See I have put the keys inside ""
  # You need to put all the keys inside "" as python only accepts this format in its dictionary data types
  ```
- ***Don't forget to add "databaseURL":"" like this***, keep the value of **"databaseURL"** = empty string
- Go to your Firebase Project Overview/Dashboard and last one thing need to configure to use Firebase Authentication
- Click **Build** from left side menu
- Click **Authentication**
- Click Get Started
- From **Sign-in method** select **Email/Password** and **Enable** it
- Click **Save** 

That's all from Firebase console.

<br/>






<br/>
<br/>

## An example of complete implementation of the package in your project
```python
from firebase_auth_ui import draw_ui


# Your main app calling function
# For example, here my_app() is the final function which will be called to run the entire app
def my_app():
    print(f"User Authentication Successful. The app is opening!")


# Set Firebase config
firebase_config={"apiKey": "XXxxXxX00XXxxx-xxxxX0XXXx0XxxxxxXXXXxxx",
"authDomain": "xxx-xx-xxxxx.xxxxxxxxxxx.com",
"projectId": "xxx-xx-xxxxx",
"storageBucket": "xxx-xx-xxxxx.xxxxxxxx.com",
"messagingSenderId": "xxxxxxxxxxxx",
"appId": "x:xxxxxxxxxxxx:web:xxxxxxxxxxxxxxxxxxxxxx",
"measurementId": "G-XXXXXXXXXX"}



draw_ui.run_authentication(firebase_config, my_app)


```
# bada bim bada boom! <img width="100" height="50" src="https://c.tenor.com/19NP4W6Ny2MAAAAC/im-going-crazy-minions.gif">

<br/>


**That's how you add sign in and sign out modern UI using Firebase in Python in the simplest way!**

<br/>

# Languages and Tools

<p align="left"> <a href="https://www.figma.com/" target="_blank" rel="noreferrer"> <img src="https://www.vectorlogo.zone/logos/figma/figma-icon.svg" alt="figma" width="40" height="40"/> </a>            <a href="https://firebase.google.com/" target="_blank" rel="noreferrer"> <img src="https://www.vectorlogo.zone/logos/firebase/firebase-icon.svg" alt="firebase" width="40" height="40"/> </a>           <a href="https://git-scm.com/" target="_blank" rel="noreferrer"> <img src="https://www.vectorlogo.zone/logos/git-scm/git-scm-icon.svg" alt="git" width="40" height="40"/> </a>           <a href="https://www.python.org" target="_blank" rel="noreferrer"> <img src="https://raw.githubusercontent.com/devicons/devicon/master/icons/python/python-original.svg" alt="python" width="40" height="40"/> </a> <a href="https://www.jetbrains.com/pycharm/"> <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/1/1d/PyCharm_Icon.svg/2048px-PyCharm_Icon.svg.png" alt="pycharm" width="40" height="40"> </a>        </p> 

<br/>

# Contact 
[![Mail](https://img.shields.io/badge/Direct_Email-yellow)](mailto:priom@priomdeb.com)

priom@priomdeb.com 

diskaouapps@gmail.com 

http://priomdeb.com


# 🌵 Stay peace and keep coding!
<p align="center"> <a href="https://github.com/PriomDeb"> <img src="https://c.tenor.com/UIOAoI_h-XsAAAAd/sleep-tom-and-jerry.gif"> </a> </p>

# Screenshots of the UI
<p>

<img src="https://i.ibb.co/Wx0fZ7S/login-UI-min.jpg" alt="login-UI-min" border="0" width="400">
<img src="https://i.ibb.co/gMrB9Mw/reset-Password-min.jpg" alt="reset-Password-min" border="0" width="400">
<img src="https://i.ibb.co/0nBz1SF/sign-Up-UI-min.jpg" alt="sign-Up-UI-min" border="0" width="400">
<img src="https://i.ibb.co/x86SL7Q/terms-min.jpg" alt="terms-min" border="0" width="400">
<img src="https://i.ibb.co/DLWsBSr/verify-Email-min.jpg" alt="verify-Email-min" border="0" width="400">
<img src="https://i.ibb.co/xhQDfjT/internet-Connection-min.jpg" alt="internet-Connection-min" border="0" width="400">
</p>
