# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class AuthReportInterval(TeaModel):
    def __init__(
        self,
        time_unit: str = None,
        value: int = None,
    ):
        self.time_unit = time_unit
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_unit is not None:
            result['TimeUnit'] = self.time_unit
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeUnit') is not None:
            self.time_unit = m.get('TimeUnit')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CommonConfigIdpDingtalk(TeaModel):
    def __init__(
        self,
        event_callback_base: str = None,
        event_label: str = None,
        home_page: str = None,
        login_redirect: str = None,
    ):
        self.event_callback_base = event_callback_base
        self.event_label = event_label
        self.home_page = home_page
        self.login_redirect = login_redirect

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_callback_base is not None:
            result['EventCallbackBase'] = self.event_callback_base
        if self.event_label is not None:
            result['EventLabel'] = self.event_label
        if self.home_page is not None:
            result['HomePage'] = self.home_page
        if self.login_redirect is not None:
            result['LoginRedirect'] = self.login_redirect
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventCallbackBase') is not None:
            self.event_callback_base = m.get('EventCallbackBase')
        if m.get('EventLabel') is not None:
            self.event_label = m.get('EventLabel')
        if m.get('HomePage') is not None:
            self.home_page = m.get('HomePage')
        if m.get('LoginRedirect') is not None:
            self.login_redirect = m.get('LoginRedirect')
        return self


class CommonConfigIdpFeishu(TeaModel):
    def __init__(
        self,
        event_callback_base: str = None,
        event_label: str = None,
        home_page: str = None,
        login_redirect: str = None,
    ):
        self.event_callback_base = event_callback_base
        self.event_label = event_label
        self.home_page = home_page
        self.login_redirect = login_redirect

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_callback_base is not None:
            result['EventCallbackBase'] = self.event_callback_base
        if self.event_label is not None:
            result['EventLabel'] = self.event_label
        if self.home_page is not None:
            result['HomePage'] = self.home_page
        if self.login_redirect is not None:
            result['LoginRedirect'] = self.login_redirect
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventCallbackBase') is not None:
            self.event_callback_base = m.get('EventCallbackBase')
        if m.get('EventLabel') is not None:
            self.event_label = m.get('EventLabel')
        if m.get('HomePage') is not None:
            self.home_page = m.get('HomePage')
        if m.get('LoginRedirect') is not None:
            self.login_redirect = m.get('LoginRedirect')
        return self


class CommonConfigIdpIdaas2(TeaModel):
    def __init__(
        self,
        event_callback_base: str = None,
        event_label: str = None,
    ):
        self.event_callback_base = event_callback_base
        self.event_label = event_label

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_callback_base is not None:
            result['EventCallbackBase'] = self.event_callback_base
        if self.event_label is not None:
            result['EventLabel'] = self.event_label
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventCallbackBase') is not None:
            self.event_callback_base = m.get('EventCallbackBase')
        if m.get('EventLabel') is not None:
            self.event_label = m.get('EventLabel')
        return self


class CommonConfigIdpSaml(TeaModel):
    def __init__(
        self,
        acs: str = None,
        metadata: str = None,
    ):
        self.acs = acs
        self.metadata = metadata

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acs is not None:
            result['Acs'] = self.acs
        if self.metadata is not None:
            result['Metadata'] = self.metadata
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acs') is not None:
            self.acs = m.get('Acs')
        if m.get('Metadata') is not None:
            self.metadata = m.get('Metadata')
        return self


class CommonConfigIdp(TeaModel):
    def __init__(
        self,
        ap_oidc_callback_url: str = None,
        dingtalk: CommonConfigIdpDingtalk = None,
        feishu: CommonConfigIdpFeishu = None,
        idaas_2: CommonConfigIdpIdaas2 = None,
        saml: CommonConfigIdpSaml = None,
    ):
        self.ap_oidc_callback_url = ap_oidc_callback_url
        self.dingtalk = dingtalk
        self.feishu = feishu
        self.idaas_2 = idaas_2
        self.saml = saml

    def validate(self):
        if self.dingtalk:
            self.dingtalk.validate()
        if self.feishu:
            self.feishu.validate()
        if self.idaas_2:
            self.idaas_2.validate()
        if self.saml:
            self.saml.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ap_oidc_callback_url is not None:
            result['ApOidcCallbackUrl'] = self.ap_oidc_callback_url
        if self.dingtalk is not None:
            result['Dingtalk'] = self.dingtalk.to_map()
        if self.feishu is not None:
            result['Feishu'] = self.feishu.to_map()
        if self.idaas_2 is not None:
            result['Idaas2'] = self.idaas_2.to_map()
        if self.saml is not None:
            result['Saml'] = self.saml.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApOidcCallbackUrl') is not None:
            self.ap_oidc_callback_url = m.get('ApOidcCallbackUrl')
        if m.get('Dingtalk') is not None:
            temp_model = CommonConfigIdpDingtalk()
            self.dingtalk = temp_model.from_map(m['Dingtalk'])
        if m.get('Feishu') is not None:
            temp_model = CommonConfigIdpFeishu()
            self.feishu = temp_model.from_map(m['Feishu'])
        if m.get('Idaas2') is not None:
            temp_model = CommonConfigIdpIdaas2()
            self.idaas_2 = temp_model.from_map(m['Idaas2'])
        if m.get('Saml') is not None:
            temp_model = CommonConfigIdpSaml()
            self.saml = temp_model.from_map(m['Saml'])
        return self


class CommonConfig(TeaModel):
    def __init__(
        self,
        idp: CommonConfigIdp = None,
    ):
        self.idp = idp

    def validate(self):
        if self.idp:
            self.idp.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idp is not None:
            result['Idp'] = self.idp.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Idp') is not None:
            temp_model = CommonConfigIdp()
            self.idp = temp_model.from_map(m['Idp'])
        return self


class DisposalContent(TeaModel):
    def __init__(
        self,
        alert_content: str = None,
        alert_content_en: str = None,
        alert_interval_seconds: int = None,
        alert_title: str = None,
        alert_title_en: str = None,
        nac_demotion_policy_ids: List[str] = None,
        notice_content: str = None,
        notice_content_en: str = None,
        notify_actions: List[str] = None,
        prohibit_actions: List[str] = None,
        prohibit_software_ids: List[str] = None,
    ):
        self.alert_content = alert_content
        self.alert_content_en = alert_content_en
        self.alert_interval_seconds = alert_interval_seconds
        self.alert_title = alert_title
        self.alert_title_en = alert_title_en
        self.nac_demotion_policy_ids = nac_demotion_policy_ids
        self.notice_content = notice_content
        self.notice_content_en = notice_content_en
        # This parameter is required.
        self.notify_actions = notify_actions
        self.prohibit_actions = prohibit_actions
        self.prohibit_software_ids = prohibit_software_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_content is not None:
            result['AlertContent'] = self.alert_content
        if self.alert_content_en is not None:
            result['AlertContentEn'] = self.alert_content_en
        if self.alert_interval_seconds is not None:
            result['AlertIntervalSeconds'] = self.alert_interval_seconds
        if self.alert_title is not None:
            result['AlertTitle'] = self.alert_title
        if self.alert_title_en is not None:
            result['AlertTitleEn'] = self.alert_title_en
        if self.nac_demotion_policy_ids is not None:
            result['NacDemotionPolicyIds'] = self.nac_demotion_policy_ids
        if self.notice_content is not None:
            result['NoticeContent'] = self.notice_content
        if self.notice_content_en is not None:
            result['NoticeContentEn'] = self.notice_content_en
        if self.notify_actions is not None:
            result['NotifyActions'] = self.notify_actions
        if self.prohibit_actions is not None:
            result['ProhibitActions'] = self.prohibit_actions
        if self.prohibit_software_ids is not None:
            result['ProhibitSoftwareIds'] = self.prohibit_software_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertContent') is not None:
            self.alert_content = m.get('AlertContent')
        if m.get('AlertContentEn') is not None:
            self.alert_content_en = m.get('AlertContentEn')
        if m.get('AlertIntervalSeconds') is not None:
            self.alert_interval_seconds = m.get('AlertIntervalSeconds')
        if m.get('AlertTitle') is not None:
            self.alert_title = m.get('AlertTitle')
        if m.get('AlertTitleEn') is not None:
            self.alert_title_en = m.get('AlertTitleEn')
        if m.get('NacDemotionPolicyIds') is not None:
            self.nac_demotion_policy_ids = m.get('NacDemotionPolicyIds')
        if m.get('NoticeContent') is not None:
            self.notice_content = m.get('NoticeContent')
        if m.get('NoticeContentEn') is not None:
            self.notice_content_en = m.get('NoticeContentEn')
        if m.get('NotifyActions') is not None:
            self.notify_actions = m.get('NotifyActions')
        if m.get('ProhibitActions') is not None:
            self.prohibit_actions = m.get('ProhibitActions')
        if m.get('ProhibitSoftwareIds') is not None:
            self.prohibit_software_ids = m.get('ProhibitSoftwareIds')
        return self


class IdpAttrMapConfigItem(TeaModel):
    def __init__(
        self,
        source: str = None,
        target: str = None,
        target_type: str = None,
    ):
        self.source = source
        self.target = target
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source is not None:
            result['Source'] = self.source
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class IdpAttrMapConfig(TeaModel):
    def __init__(
        self,
        map_items: List[IdpAttrMapConfigItem] = None,
    ):
        self.map_items = map_items

    def validate(self):
        if self.map_items:
            for k in self.map_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MapItems'] = []
        if self.map_items is not None:
            for k in self.map_items:
                result['MapItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.map_items = []
        if m.get('MapItems') is not None:
            for k in m.get('MapItems'):
                temp_model = IdpAttrMapConfigItem()
                self.map_items.append(temp_model.from_map(k))
        return self


class IdpConnectConfig(TeaModel):
    def __init__(
        self,
        connector_id: str = None,
        use_connector: bool = None,
    ):
        self.connector_id = connector_id
        self.use_connector = use_connector

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connector_id is not None:
            result['ConnectorId'] = self.connector_id
        if self.use_connector is not None:
            result['UseConnector'] = self.use_connector
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectorId') is not None:
            self.connector_id = m.get('ConnectorId')
        if m.get('UseConnector') is not None:
            self.use_connector = m.get('UseConnector')
        return self


class IdpDingtalkSubConfig(TeaModel):
    def __init__(
        self,
        app_key: str = None,
        app_secret: str = None,
        corp_id: str = None,
        event_aes_key: str = None,
        event_label: str = None,
        event_verify_token: str = None,
        exclusive: bool = None,
        redirect_uri: str = None,
    ):
        self.app_key = app_key
        self.app_secret = app_secret
        self.corp_id = corp_id
        self.event_aes_key = event_aes_key
        self.event_label = event_label
        self.event_verify_token = event_verify_token
        self.exclusive = exclusive
        self.redirect_uri = redirect_uri

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_key is not None:
            result['AppKey'] = self.app_key
        if self.app_secret is not None:
            result['AppSecret'] = self.app_secret
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.event_aes_key is not None:
            result['EventAesKey'] = self.event_aes_key
        if self.event_label is not None:
            result['EventLabel'] = self.event_label
        if self.event_verify_token is not None:
            result['EventVerifyToken'] = self.event_verify_token
        if self.exclusive is not None:
            result['Exclusive'] = self.exclusive
        if self.redirect_uri is not None:
            result['RedirectUri'] = self.redirect_uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppKey') is not None:
            self.app_key = m.get('AppKey')
        if m.get('AppSecret') is not None:
            self.app_secret = m.get('AppSecret')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('EventAesKey') is not None:
            self.event_aes_key = m.get('EventAesKey')
        if m.get('EventLabel') is not None:
            self.event_label = m.get('EventLabel')
        if m.get('EventVerifyToken') is not None:
            self.event_verify_token = m.get('EventVerifyToken')
        if m.get('Exclusive') is not None:
            self.exclusive = m.get('Exclusive')
        if m.get('RedirectUri') is not None:
            self.redirect_uri = m.get('RedirectUri')
        return self


class IdpFeishuSubConfig(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_secret: str = None,
        corp_id: str = None,
        event_aes_key: str = None,
        event_label: str = None,
        event_verify_token: str = None,
        redirect_uri: str = None,
    ):
        self.app_id = app_id
        self.app_secret = app_secret
        self.corp_id = corp_id
        self.event_aes_key = event_aes_key
        self.event_label = event_label
        self.event_verify_token = event_verify_token
        self.redirect_uri = redirect_uri

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_secret is not None:
            result['AppSecret'] = self.app_secret
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.event_aes_key is not None:
            result['EventAesKey'] = self.event_aes_key
        if self.event_label is not None:
            result['EventLabel'] = self.event_label
        if self.event_verify_token is not None:
            result['EventVerifyToken'] = self.event_verify_token
        if self.redirect_uri is not None:
            result['RedirectUri'] = self.redirect_uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppSecret') is not None:
            self.app_secret = m.get('AppSecret')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('EventAesKey') is not None:
            self.event_aes_key = m.get('EventAesKey')
        if m.get('EventLabel') is not None:
            self.event_label = m.get('EventLabel')
        if m.get('EventVerifyToken') is not None:
            self.event_verify_token = m.get('EventVerifyToken')
        if m.get('RedirectUri') is not None:
            self.redirect_uri = m.get('RedirectUri')
        return self


class IdpIdaas2SubConfig(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        client_id: str = None,
        client_secret: str = None,
        event_aes_key: str = None,
        event_label: str = None,
        instance_id: str = None,
        public_key_endpoint: str = None,
        region: str = None,
        saml_metadata: str = None,
    ):
        self.application_id = application_id
        self.client_id = client_id
        self.client_secret = client_secret
        self.event_aes_key = event_aes_key
        self.event_label = event_label
        self.instance_id = instance_id
        self.public_key_endpoint = public_key_endpoint
        self.region = region
        self.saml_metadata = saml_metadata

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_secret is not None:
            result['ClientSecret'] = self.client_secret
        if self.event_aes_key is not None:
            result['EventAesKey'] = self.event_aes_key
        if self.event_label is not None:
            result['EventLabel'] = self.event_label
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.public_key_endpoint is not None:
            result['PublicKeyEndpoint'] = self.public_key_endpoint
        if self.region is not None:
            result['Region'] = self.region
        if self.saml_metadata is not None:
            result['SamlMetadata'] = self.saml_metadata
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientSecret') is not None:
            self.client_secret = m.get('ClientSecret')
        if m.get('EventAesKey') is not None:
            self.event_aes_key = m.get('EventAesKey')
        if m.get('EventLabel') is not None:
            self.event_label = m.get('EventLabel')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PublicKeyEndpoint') is not None:
            self.public_key_endpoint = m.get('PublicKeyEndpoint')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SamlMetadata') is not None:
            self.saml_metadata = m.get('SamlMetadata')
        return self


class IdpLdapSubConfig(TeaModel):
    def __init__(
        self,
        base_dn: str = None,
        group_base_dn: str = None,
        group_filter: str = None,
        group_membership_attr: str = None,
        group_name_attr: str = None,
        login_name_attr: str = None,
        server_addr: str = None,
        server_port: str = None,
        server_type: str = None,
        use_ssl: bool = None,
        user_dn: str = None,
        user_filter: str = None,
        user_password: str = None,
    ):
        self.base_dn = base_dn
        self.group_base_dn = group_base_dn
        self.group_filter = group_filter
        self.group_membership_attr = group_membership_attr
        self.group_name_attr = group_name_attr
        self.login_name_attr = login_name_attr
        self.server_addr = server_addr
        self.server_port = server_port
        self.server_type = server_type
        self.use_ssl = use_ssl
        self.user_dn = user_dn
        self.user_filter = user_filter
        self.user_password = user_password

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.base_dn is not None:
            result['BaseDn'] = self.base_dn
        if self.group_base_dn is not None:
            result['GroupBaseDn'] = self.group_base_dn
        if self.group_filter is not None:
            result['GroupFilter'] = self.group_filter
        if self.group_membership_attr is not None:
            result['GroupMembershipAttr'] = self.group_membership_attr
        if self.group_name_attr is not None:
            result['GroupNameAttr'] = self.group_name_attr
        if self.login_name_attr is not None:
            result['LoginNameAttr'] = self.login_name_attr
        if self.server_addr is not None:
            result['ServerAddr'] = self.server_addr
        if self.server_port is not None:
            result['ServerPort'] = self.server_port
        if self.server_type is not None:
            result['ServerType'] = self.server_type
        if self.use_ssl is not None:
            result['UseSsl'] = self.use_ssl
        if self.user_dn is not None:
            result['UserDn'] = self.user_dn
        if self.user_filter is not None:
            result['UserFilter'] = self.user_filter
        if self.user_password is not None:
            result['UserPassword'] = self.user_password
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaseDn') is not None:
            self.base_dn = m.get('BaseDn')
        if m.get('GroupBaseDn') is not None:
            self.group_base_dn = m.get('GroupBaseDn')
        if m.get('GroupFilter') is not None:
            self.group_filter = m.get('GroupFilter')
        if m.get('GroupMembershipAttr') is not None:
            self.group_membership_attr = m.get('GroupMembershipAttr')
        if m.get('GroupNameAttr') is not None:
            self.group_name_attr = m.get('GroupNameAttr')
        if m.get('LoginNameAttr') is not None:
            self.login_name_attr = m.get('LoginNameAttr')
        if m.get('ServerAddr') is not None:
            self.server_addr = m.get('ServerAddr')
        if m.get('ServerPort') is not None:
            self.server_port = m.get('ServerPort')
        if m.get('ServerType') is not None:
            self.server_type = m.get('ServerType')
        if m.get('UseSsl') is not None:
            self.use_ssl = m.get('UseSsl')
        if m.get('UserDn') is not None:
            self.user_dn = m.get('UserDn')
        if m.get('UserFilter') is not None:
            self.user_filter = m.get('UserFilter')
        if m.get('UserPassword') is not None:
            self.user_password = m.get('UserPassword')
        return self


class IdpLoginConfig(TeaModel):
    def __init__(
        self,
        mobile_login_type: str = None,
        mobile_mfa_types: str = None,
        pc_login_type: str = None,
        pc_mfa_types: str = None,
        totp_corp_verify_aes_key: str = None,
        totp_corp_verify_token: str = None,
        totp_corp_verify_url: str = None,
    ):
        self.mobile_login_type = mobile_login_type
        self.mobile_mfa_types = mobile_mfa_types
        self.pc_login_type = pc_login_type
        self.pc_mfa_types = pc_mfa_types
        self.totp_corp_verify_aes_key = totp_corp_verify_aes_key
        self.totp_corp_verify_token = totp_corp_verify_token
        self.totp_corp_verify_url = totp_corp_verify_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mobile_login_type is not None:
            result['MobileLoginType'] = self.mobile_login_type
        if self.mobile_mfa_types is not None:
            result['MobileMfaTypes'] = self.mobile_mfa_types
        if self.pc_login_type is not None:
            result['PcLoginType'] = self.pc_login_type
        if self.pc_mfa_types is not None:
            result['PcMfaTypes'] = self.pc_mfa_types
        if self.totp_corp_verify_aes_key is not None:
            result['TotpCorpVerifyAesKey'] = self.totp_corp_verify_aes_key
        if self.totp_corp_verify_token is not None:
            result['TotpCorpVerifyToken'] = self.totp_corp_verify_token
        if self.totp_corp_verify_url is not None:
            result['TotpCorpVerifyUrl'] = self.totp_corp_verify_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MobileLoginType') is not None:
            self.mobile_login_type = m.get('MobileLoginType')
        if m.get('MobileMfaTypes') is not None:
            self.mobile_mfa_types = m.get('MobileMfaTypes')
        if m.get('PcLoginType') is not None:
            self.pc_login_type = m.get('PcLoginType')
        if m.get('PcMfaTypes') is not None:
            self.pc_mfa_types = m.get('PcMfaTypes')
        if m.get('TotpCorpVerifyAesKey') is not None:
            self.totp_corp_verify_aes_key = m.get('TotpCorpVerifyAesKey')
        if m.get('TotpCorpVerifyToken') is not None:
            self.totp_corp_verify_token = m.get('TotpCorpVerifyToken')
        if m.get('TotpCorpVerifyUrl') is not None:
            self.totp_corp_verify_url = m.get('TotpCorpVerifyUrl')
        return self


class IdpSyncConfigIdpDepartmentInfos(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
    ):
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class IdpSyncConfig(TeaModel):
    def __init__(
        self,
        auto_sync_enabled: bool = None,
        idp_department_infos: List[IdpSyncConfigIdpDepartmentInfos] = None,
        schedule_sync_interval_second: int = None,
        user_sync_enabled: bool = None,
    ):
        self.auto_sync_enabled = auto_sync_enabled
        self.idp_department_infos = idp_department_infos
        self.schedule_sync_interval_second = schedule_sync_interval_second
        self.user_sync_enabled = user_sync_enabled

    def validate(self):
        if self.idp_department_infos:
            for k in self.idp_department_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_sync_enabled is not None:
            result['AutoSyncEnabled'] = self.auto_sync_enabled
        result['IdpDepartmentInfos'] = []
        if self.idp_department_infos is not None:
            for k in self.idp_department_infos:
                result['IdpDepartmentInfos'].append(k.to_map() if k else None)
        if self.schedule_sync_interval_second is not None:
            result['ScheduleSyncIntervalSecond'] = self.schedule_sync_interval_second
        if self.user_sync_enabled is not None:
            result['UserSyncEnabled'] = self.user_sync_enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoSyncEnabled') is not None:
            self.auto_sync_enabled = m.get('AutoSyncEnabled')
        self.idp_department_infos = []
        if m.get('IdpDepartmentInfos') is not None:
            for k in m.get('IdpDepartmentInfos'):
                temp_model = IdpSyncConfigIdpDepartmentInfos()
                self.idp_department_infos.append(temp_model.from_map(k))
        if m.get('ScheduleSyncIntervalSecond') is not None:
            self.schedule_sync_interval_second = m.get('ScheduleSyncIntervalSecond')
        if m.get('UserSyncEnabled') is not None:
            self.user_sync_enabled = m.get('UserSyncEnabled')
        return self


class IdpWeixin2SubConfig(TeaModel):
    def __init__(
        self,
        agent_id: str = None,
        app_schema: str = None,
        app_secret: str = None,
        corp_id: str = None,
        event_aes_key: str = None,
        event_label: str = None,
        event_verify_token: str = None,
        redirect_uri: str = None,
    ):
        self.agent_id = agent_id
        self.app_schema = app_schema
        self.app_secret = app_secret
        self.corp_id = corp_id
        self.event_aes_key = event_aes_key
        self.event_label = event_label
        self.event_verify_token = event_verify_token
        self.redirect_uri = redirect_uri

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.app_schema is not None:
            result['AppSchema'] = self.app_schema
        if self.app_secret is not None:
            result['AppSecret'] = self.app_secret
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.event_aes_key is not None:
            result['EventAesKey'] = self.event_aes_key
        if self.event_label is not None:
            result['EventLabel'] = self.event_label
        if self.event_verify_token is not None:
            result['EventVerifyToken'] = self.event_verify_token
        if self.redirect_uri is not None:
            result['RedirectUri'] = self.redirect_uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AppSchema') is not None:
            self.app_schema = m.get('AppSchema')
        if m.get('AppSecret') is not None:
            self.app_secret = m.get('AppSecret')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('EventAesKey') is not None:
            self.event_aes_key = m.get('EventAesKey')
        if m.get('EventLabel') is not None:
            self.event_label = m.get('EventLabel')
        if m.get('EventVerifyToken') is not None:
            self.event_verify_token = m.get('EventVerifyToken')
        if m.get('RedirectUri') is not None:
            self.redirect_uri = m.get('RedirectUri')
        return self


class OpenStructIdpWuyingSubConfig(TeaModel):
    def __init__(
        self,
        aliuids: List[str] = None,
    ):
        self.aliuids = aliuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliuids is not None:
            result['Aliuids'] = self.aliuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Aliuids') is not None:
            self.aliuids = m.get('Aliuids')
        return self


class IdpConfig(TeaModel):
    def __init__(
        self,
        attr_map_config: IdpAttrMapConfig = None,
        connect_config: IdpConnectConfig = None,
        description: str = None,
        dingtalk_config: IdpDingtalkSubConfig = None,
        enabled: bool = None,
        feishu_config: IdpFeishuSubConfig = None,
        idaas_config: IdpIdaas2SubConfig = None,
        idp_config_id: str = None,
        last_sync_time_unix: int = None,
        ldap_config: IdpLdapSubConfig = None,
        login_config: IdpLoginConfig = None,
        name: str = None,
        sync_config: IdpSyncConfig = None,
        sync_status: str = None,
        type: str = None,
        weixin_config: IdpWeixin2SubConfig = None,
        wuying_config: OpenStructIdpWuyingSubConfig = None,
    ):
        self.attr_map_config = attr_map_config
        self.connect_config = connect_config
        self.description = description
        self.dingtalk_config = dingtalk_config
        self.enabled = enabled
        self.feishu_config = feishu_config
        self.idaas_config = idaas_config
        self.idp_config_id = idp_config_id
        self.last_sync_time_unix = last_sync_time_unix
        self.ldap_config = ldap_config
        self.login_config = login_config
        self.name = name
        self.sync_config = sync_config
        self.sync_status = sync_status
        self.type = type
        self.weixin_config = weixin_config
        self.wuying_config = wuying_config

    def validate(self):
        if self.attr_map_config:
            self.attr_map_config.validate()
        if self.connect_config:
            self.connect_config.validate()
        if self.dingtalk_config:
            self.dingtalk_config.validate()
        if self.feishu_config:
            self.feishu_config.validate()
        if self.idaas_config:
            self.idaas_config.validate()
        if self.ldap_config:
            self.ldap_config.validate()
        if self.login_config:
            self.login_config.validate()
        if self.sync_config:
            self.sync_config.validate()
        if self.weixin_config:
            self.weixin_config.validate()
        if self.wuying_config:
            self.wuying_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attr_map_config is not None:
            result['AttrMapConfig'] = self.attr_map_config.to_map()
        if self.connect_config is not None:
            result['ConnectConfig'] = self.connect_config.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.dingtalk_config is not None:
            result['DingtalkConfig'] = self.dingtalk_config.to_map()
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.feishu_config is not None:
            result['FeishuConfig'] = self.feishu_config.to_map()
        if self.idaas_config is not None:
            result['IdaasConfig'] = self.idaas_config.to_map()
        if self.idp_config_id is not None:
            result['IdpConfigId'] = self.idp_config_id
        if self.last_sync_time_unix is not None:
            result['LastSyncTimeUnix'] = self.last_sync_time_unix
        if self.ldap_config is not None:
            result['LdapConfig'] = self.ldap_config.to_map()
        if self.login_config is not None:
            result['LoginConfig'] = self.login_config.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.sync_config is not None:
            result['SyncConfig'] = self.sync_config.to_map()
        if self.sync_status is not None:
            result['SyncStatus'] = self.sync_status
        if self.type is not None:
            result['Type'] = self.type
        if self.weixin_config is not None:
            result['WeixinConfig'] = self.weixin_config.to_map()
        if self.wuying_config is not None:
            result['WuyingConfig'] = self.wuying_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttrMapConfig') is not None:
            temp_model = IdpAttrMapConfig()
            self.attr_map_config = temp_model.from_map(m['AttrMapConfig'])
        if m.get('ConnectConfig') is not None:
            temp_model = IdpConnectConfig()
            self.connect_config = temp_model.from_map(m['ConnectConfig'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DingtalkConfig') is not None:
            temp_model = IdpDingtalkSubConfig()
            self.dingtalk_config = temp_model.from_map(m['DingtalkConfig'])
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('FeishuConfig') is not None:
            temp_model = IdpFeishuSubConfig()
            self.feishu_config = temp_model.from_map(m['FeishuConfig'])
        if m.get('IdaasConfig') is not None:
            temp_model = IdpIdaas2SubConfig()
            self.idaas_config = temp_model.from_map(m['IdaasConfig'])
        if m.get('IdpConfigId') is not None:
            self.idp_config_id = m.get('IdpConfigId')
        if m.get('LastSyncTimeUnix') is not None:
            self.last_sync_time_unix = m.get('LastSyncTimeUnix')
        if m.get('LdapConfig') is not None:
            temp_model = IdpLdapSubConfig()
            self.ldap_config = temp_model.from_map(m['LdapConfig'])
        if m.get('LoginConfig') is not None:
            temp_model = IdpLoginConfig()
            self.login_config = temp_model.from_map(m['LoginConfig'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SyncConfig') is not None:
            temp_model = IdpSyncConfig()
            self.sync_config = temp_model.from_map(m['SyncConfig'])
        if m.get('SyncStatus') is not None:
            self.sync_status = m.get('SyncStatus')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('WeixinConfig') is not None:
            temp_model = IdpWeixin2SubConfig()
            self.weixin_config = temp_model.from_map(m['WeixinConfig'])
        if m.get('WuyingConfig') is not None:
            temp_model = OpenStructIdpWuyingSubConfig()
            self.wuying_config = temp_model.from_map(m['WuyingConfig'])
        return self


class IdpCustomField(TeaModel):
    def __init__(
        self,
        description: str = None,
        key: str = None,
        name: str = None,
        type: str = None,
        value: str = None,
    ):
        self.description = description
        self.key = key
        self.name = name
        self.type = type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.key is not None:
            result['Key'] = self.key
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class IdpLoginOrderItem(TeaModel):
    def __init__(
        self,
        class_: str = None,
        config_id: str = None,
        desc: str = None,
        enabled: bool = None,
        name: str = None,
        type: str = None,
    ):
        self.class_ = class_
        self.config_id = config_id
        self.desc = desc
        self.enabled = enabled
        self.name = name
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_ is not None:
            result['Class'] = self.class_
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Class') is not None:
            self.class_ = m.get('Class')
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class OpenStructIdpSyncRecord(TeaModel):
    def __init__(
        self,
        action: str = None,
        idp_raw_json: str = None,
        idp_resource_id: str = None,
        name: str = None,
        record_type: str = None,
        sase_raw_json: str = None,
        sase_resource_id: str = None,
        success: bool = None,
        sync_record_id: str = None,
        sync_task_id: str = None,
        time_unix: str = None,
    ):
        self.action = action
        self.idp_raw_json = idp_raw_json
        self.idp_resource_id = idp_resource_id
        self.name = name
        self.record_type = record_type
        self.sase_raw_json = sase_raw_json
        self.sase_resource_id = sase_resource_id
        self.success = success
        self.sync_record_id = sync_record_id
        self.sync_task_id = sync_task_id
        self.time_unix = time_unix

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.idp_raw_json is not None:
            result['IdpRawJson'] = self.idp_raw_json
        if self.idp_resource_id is not None:
            result['IdpResourceId'] = self.idp_resource_id
        if self.name is not None:
            result['Name'] = self.name
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        if self.sase_raw_json is not None:
            result['SaseRawJson'] = self.sase_raw_json
        if self.sase_resource_id is not None:
            result['SaseResourceId'] = self.sase_resource_id
        if self.success is not None:
            result['Success'] = self.success
        if self.sync_record_id is not None:
            result['SyncRecordId'] = self.sync_record_id
        if self.sync_task_id is not None:
            result['SyncTaskId'] = self.sync_task_id
        if self.time_unix is not None:
            result['TimeUnix'] = self.time_unix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('IdpRawJson') is not None:
            self.idp_raw_json = m.get('IdpRawJson')
        if m.get('IdpResourceId') is not None:
            self.idp_resource_id = m.get('IdpResourceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        if m.get('SaseRawJson') is not None:
            self.sase_raw_json = m.get('SaseRawJson')
        if m.get('SaseResourceId') is not None:
            self.sase_resource_id = m.get('SaseResourceId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SyncRecordId') is not None:
            self.sync_record_id = m.get('SyncRecordId')
        if m.get('SyncTaskId') is not None:
            self.sync_task_id = m.get('SyncTaskId')
        if m.get('TimeUnix') is not None:
            self.time_unix = m.get('TimeUnix')
        return self


class OpenStructIdpSyncTask(TeaModel):
    def __init__(
        self,
        department_failed: int = None,
        department_total: int = None,
        end_time_unix: int = None,
        fail_type: str = None,
        idp_config_id: bytes = None,
        start_time_unix: int = None,
        status: str = None,
        sync_task_id: str = None,
        update_time_unix: int = None,
        user_failed: int = None,
        user_total: int = None,
    ):
        self.department_failed = department_failed
        self.department_total = department_total
        self.end_time_unix = end_time_unix
        self.fail_type = fail_type
        self.idp_config_id = idp_config_id
        self.start_time_unix = start_time_unix
        self.status = status
        self.sync_task_id = sync_task_id
        self.update_time_unix = update_time_unix
        self.user_failed = user_failed
        self.user_total = user_total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_failed is not None:
            result['DepartmentFailed'] = self.department_failed
        if self.department_total is not None:
            result['DepartmentTotal'] = self.department_total
        if self.end_time_unix is not None:
            result['EndTimeUnix'] = self.end_time_unix
        if self.fail_type is not None:
            result['FailType'] = self.fail_type
        if self.idp_config_id is not None:
            result['IdpConfigId'] = self.idp_config_id
        if self.start_time_unix is not None:
            result['StartTimeUnix'] = self.start_time_unix
        if self.status is not None:
            result['Status'] = self.status
        if self.sync_task_id is not None:
            result['SyncTaskId'] = self.sync_task_id
        if self.update_time_unix is not None:
            result['UpdateTimeUnix'] = self.update_time_unix
        if self.user_failed is not None:
            result['UserFailed'] = self.user_failed
        if self.user_total is not None:
            result['UserTotal'] = self.user_total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentFailed') is not None:
            self.department_failed = m.get('DepartmentFailed')
        if m.get('DepartmentTotal') is not None:
            self.department_total = m.get('DepartmentTotal')
        if m.get('EndTimeUnix') is not None:
            self.end_time_unix = m.get('EndTimeUnix')
        if m.get('FailType') is not None:
            self.fail_type = m.get('FailType')
        if m.get('IdpConfigId') is not None:
            self.idp_config_id = m.get('IdpConfigId')
        if m.get('StartTimeUnix') is not None:
            self.start_time_unix = m.get('StartTimeUnix')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SyncTaskId') is not None:
            self.sync_task_id = m.get('SyncTaskId')
        if m.get('UpdateTimeUnix') is not None:
            self.update_time_unix = m.get('UpdateTimeUnix')
        if m.get('UserFailed') is not None:
            self.user_failed = m.get('UserFailed')
        if m.get('UserTotal') is not None:
            self.user_total = m.get('UserTotal')
        return self


class OpenStructSaseDepartment(TeaModel):
    def __init__(
        self,
        department_id: str = None,
        full_dn: str = None,
        name: str = None,
        parent_department_id: str = None,
    ):
        self.department_id = department_id
        self.full_dn = full_dn
        self.name = name
        self.parent_department_id = parent_department_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.full_dn is not None:
            result['FullDn'] = self.full_dn
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_department_id is not None:
            result['ParentDepartmentId'] = self.parent_department_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('FullDn') is not None:
            self.full_dn = m.get('FullDn')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentDepartmentId') is not None:
            self.parent_department_id = m.get('ParentDepartmentId')
        return self


class OpenStructSaseUser(TeaModel):
    def __init__(
        self,
        create_time_unix: int = None,
        custom_fields: List[IdpCustomField] = None,
        departments: List[OpenStructSaseDepartment] = None,
        email: str = None,
        idp_config_id: str = None,
        leave_time_unix: int = None,
        login_time_unix: int = None,
        sase_user_id: str = None,
        sase_user_status: str = None,
        sync_time_unix: int = None,
        telephone: str = None,
        title: str = None,
        update_time_unix: int = None,
        username: str = None,
        work_status: str = None,
    ):
        self.create_time_unix = create_time_unix
        self.custom_fields = custom_fields
        self.departments = departments
        self.email = email
        self.idp_config_id = idp_config_id
        self.leave_time_unix = leave_time_unix
        self.login_time_unix = login_time_unix
        self.sase_user_id = sase_user_id
        self.sase_user_status = sase_user_status
        self.sync_time_unix = sync_time_unix
        self.telephone = telephone
        self.title = title
        self.update_time_unix = update_time_unix
        self.username = username
        self.work_status = work_status

    def validate(self):
        if self.custom_fields:
            for k in self.custom_fields:
                if k:
                    k.validate()
        if self.departments:
            for k in self.departments:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time_unix is not None:
            result['CreateTimeUnix'] = self.create_time_unix
        result['CustomFields'] = []
        if self.custom_fields is not None:
            for k in self.custom_fields:
                result['CustomFields'].append(k.to_map() if k else None)
        result['Departments'] = []
        if self.departments is not None:
            for k in self.departments:
                result['Departments'].append(k.to_map() if k else None)
        if self.email is not None:
            result['Email'] = self.email
        if self.idp_config_id is not None:
            result['IdpConfigId'] = self.idp_config_id
        if self.leave_time_unix is not None:
            result['LeaveTimeUnix'] = self.leave_time_unix
        if self.login_time_unix is not None:
            result['LoginTimeUnix'] = self.login_time_unix
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.sase_user_status is not None:
            result['SaseUserStatus'] = self.sase_user_status
        if self.sync_time_unix is not None:
            result['SyncTimeUnix'] = self.sync_time_unix
        if self.telephone is not None:
            result['Telephone'] = self.telephone
        if self.title is not None:
            result['Title'] = self.title
        if self.update_time_unix is not None:
            result['UpdateTimeUnix'] = self.update_time_unix
        if self.username is not None:
            result['Username'] = self.username
        if self.work_status is not None:
            result['WorkStatus'] = self.work_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimeUnix') is not None:
            self.create_time_unix = m.get('CreateTimeUnix')
        self.custom_fields = []
        if m.get('CustomFields') is not None:
            for k in m.get('CustomFields'):
                temp_model = IdpCustomField()
                self.custom_fields.append(temp_model.from_map(k))
        self.departments = []
        if m.get('Departments') is not None:
            for k in m.get('Departments'):
                temp_model = OpenStructSaseDepartment()
                self.departments.append(temp_model.from_map(k))
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('IdpConfigId') is not None:
            self.idp_config_id = m.get('IdpConfigId')
        if m.get('LeaveTimeUnix') is not None:
            self.leave_time_unix = m.get('LeaveTimeUnix')
        if m.get('LoginTimeUnix') is not None:
            self.login_time_unix = m.get('LoginTimeUnix')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('SaseUserStatus') is not None:
            self.sase_user_status = m.get('SaseUserStatus')
        if m.get('SyncTimeUnix') is not None:
            self.sync_time_unix = m.get('SyncTimeUnix')
        if m.get('Telephone') is not None:
            self.telephone = m.get('Telephone')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UpdateTimeUnix') is not None:
            self.update_time_unix = m.get('UpdateTimeUnix')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        if m.get('WorkStatus') is not None:
            self.work_status = m.get('WorkStatus')
        return self


class OpenStructSaseUserSimpleDepartments(TeaModel):
    def __init__(
        self,
        department_id: str = None,
        name: str = None,
    ):
        self.department_id = department_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class OpenStructSaseUserSimple(TeaModel):
    def __init__(
        self,
        departments: List[OpenStructSaseUserSimpleDepartments] = None,
        email: str = None,
        idp_config_id: str = None,
        sase_user_id: str = None,
        telephone: str = None,
        username: str = None,
    ):
        self.departments = departments
        self.email = email
        self.idp_config_id = idp_config_id
        self.sase_user_id = sase_user_id
        self.telephone = telephone
        self.username = username

    def validate(self):
        if self.departments:
            for k in self.departments:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Departments'] = []
        if self.departments is not None:
            for k in self.departments:
                result['Departments'].append(k.to_map() if k else None)
        if self.email is not None:
            result['Email'] = self.email
        if self.idp_config_id is not None:
            result['IdpConfigId'] = self.idp_config_id
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.telephone is not None:
            result['Telephone'] = self.telephone
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.departments = []
        if m.get('Departments') is not None:
            for k in m.get('Departments'):
                temp_model = OpenStructSaseUserSimpleDepartments()
                self.departments.append(temp_model.from_map(k))
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('IdpConfigId') is not None:
            self.idp_config_id = m.get('IdpConfigId')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Telephone') is not None:
            self.telephone = m.get('Telephone')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class PAL7ConfigBypassConfigUrlBypassRules(TeaModel):
    def __init__(
        self,
        froms: List[str] = None,
        paths: List[str] = None,
    ):
        self.froms = froms
        self.paths = paths

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.froms is not None:
            result['Froms'] = self.froms
        if self.paths is not None:
            result['Paths'] = self.paths
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Froms') is not None:
            self.froms = m.get('Froms')
        if m.get('Paths') is not None:
            self.paths = m.get('Paths')
        return self


class PAL7ConfigBypassConfig(TeaModel):
    def __init__(
        self,
        app_bypass_froms: List[str] = None,
        mode: str = None,
        url_bypass_rules: List[PAL7ConfigBypassConfigUrlBypassRules] = None,
    ):
        self.app_bypass_froms = app_bypass_froms
        self.mode = mode
        self.url_bypass_rules = url_bypass_rules

    def validate(self):
        if self.url_bypass_rules:
            for k in self.url_bypass_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_bypass_froms is not None:
            result['AppBypassFroms'] = self.app_bypass_froms
        if self.mode is not None:
            result['Mode'] = self.mode
        result['UrlBypassRules'] = []
        if self.url_bypass_rules is not None:
            for k in self.url_bypass_rules:
                result['UrlBypassRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppBypassFroms') is not None:
            self.app_bypass_froms = m.get('AppBypassFroms')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        self.url_bypass_rules = []
        if m.get('UrlBypassRules') is not None:
            for k in m.get('UrlBypassRules'):
                temp_model = PAL7ConfigBypassConfigUrlBypassRules()
                self.url_bypass_rules.append(temp_model.from_map(k))
        return self


class PAL7ConfigDnsConfig(TeaModel):
    def __init__(
        self,
        dns_servers: List[str] = None,
    ):
        self.dns_servers = dns_servers

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dns_servers is not None:
            result['DnsServers'] = self.dns_servers
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnsServers') is not None:
            self.dns_servers = m.get('DnsServers')
        return self


class PAL7ConfigReplaceRule(TeaModel):
    def __init__(
        self,
        from_: str = None,
        to: str = None,
    ):
        self.from_ = from_
        self.to = to

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.to is not None:
            result['To'] = self.to
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('To') is not None:
            self.to = m.get('To')
        return self


class PAL7ConfigJsHookConfig(TeaModel):
    def __init__(
        self,
        mode: str = None,
        replace_rules: List[PAL7ConfigReplaceRule] = None,
    ):
        self.mode = mode
        self.replace_rules = replace_rules

    def validate(self):
        if self.replace_rules:
            for k in self.replace_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mode is not None:
            result['Mode'] = self.mode
        result['ReplaceRules'] = []
        if self.replace_rules is not None:
            for k in self.replace_rules:
                result['ReplaceRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        self.replace_rules = []
        if m.get('ReplaceRules') is not None:
            for k in m.get('ReplaceRules'):
                temp_model = PAL7ConfigReplaceRule()
                self.replace_rules.append(temp_model.from_map(k))
        return self


class PAL7ConfigRewriteOp(TeaModel):
    def __init__(
        self,
        key: str = None,
        old_value: str = None,
        op: str = None,
        value: str = None,
        value_variable: str = None,
    ):
        self.key = key
        self.old_value = old_value
        self.op = op
        self.value = value
        self.value_variable = value_variable

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.old_value is not None:
            result['OldValue'] = self.old_value
        if self.op is not None:
            result['Op'] = self.op
        if self.value is not None:
            result['Value'] = self.value
        if self.value_variable is not None:
            result['ValueVariable'] = self.value_variable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('OldValue') is not None:
            self.old_value = m.get('OldValue')
        if m.get('Op') is not None:
            self.op = m.get('Op')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('ValueVariable') is not None:
            self.value_variable = m.get('ValueVariable')
        return self


class PAL7ConfigRequestHeaderRewriteConfig(TeaModel):
    def __init__(
        self,
        ops: List[PAL7ConfigRewriteOp] = None,
    ):
        self.ops = ops

    def validate(self):
        if self.ops:
            for k in self.ops:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Ops'] = []
        if self.ops is not None:
            for k in self.ops:
                result['Ops'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ops = []
        if m.get('Ops') is not None:
            for k in m.get('Ops'):
                temp_model = PAL7ConfigRewriteOp()
                self.ops.append(temp_model.from_map(k))
        return self


class PAL7ConfigRequestQueryRewriteConfig(TeaModel):
    def __init__(
        self,
        ops: List[PAL7ConfigRewriteOp] = None,
    ):
        self.ops = ops

    def validate(self):
        if self.ops:
            for k in self.ops:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Ops'] = []
        if self.ops is not None:
            for k in self.ops:
                result['Ops'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ops = []
        if m.get('Ops') is not None:
            for k in m.get('Ops'):
                temp_model = PAL7ConfigRewriteOp()
                self.ops.append(temp_model.from_map(k))
        return self


class PAL7ConfigResponseHeaderRewriteConfig(TeaModel):
    def __init__(
        self,
        ops: List[PAL7ConfigRewriteOp] = None,
    ):
        self.ops = ops

    def validate(self):
        if self.ops:
            for k in self.ops:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Ops'] = []
        if self.ops is not None:
            for k in self.ops:
                result['Ops'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ops = []
        if m.get('Ops') is not None:
            for k in m.get('Ops'):
                temp_model = PAL7ConfigRewriteOp()
                self.ops.append(temp_model.from_map(k))
        return self


class PAL7ConfigResponseRewriteConfig(TeaModel):
    def __init__(
        self,
        mode: str = None,
        replace_rules: List[PAL7ConfigReplaceRule] = None,
    ):
        self.mode = mode
        self.replace_rules = replace_rules

    def validate(self):
        if self.replace_rules:
            for k in self.replace_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mode is not None:
            result['Mode'] = self.mode
        result['ReplaceRules'] = []
        if self.replace_rules is not None:
            for k in self.replace_rules:
                result['ReplaceRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        self.replace_rules = []
        if m.get('ReplaceRules') is not None:
            for k in m.get('ReplaceRules'):
                temp_model = PAL7ConfigReplaceRule()
                self.replace_rules.append(temp_model.from_map(k))
        return self


class PAL7Config(TeaModel):
    def __init__(
        self,
        bypass_config: PAL7ConfigBypassConfig = None,
        cert_id: str = None,
        dns_config: PAL7ConfigDnsConfig = None,
        js_hook_config: PAL7ConfigJsHookConfig = None,
        proxy_domain_types: bytes = None,
        request_header_rewrite_config: PAL7ConfigRequestHeaderRewriteConfig = None,
        request_query_rewrite_config: PAL7ConfigRequestQueryRewriteConfig = None,
        response_header_rewrite_config: PAL7ConfigResponseHeaderRewriteConfig = None,
        response_rewrite_config: PAL7ConfigResponseRewriteConfig = None,
    ):
        self.bypass_config = bypass_config
        self.cert_id = cert_id
        self.dns_config = dns_config
        self.js_hook_config = js_hook_config
        self.proxy_domain_types = proxy_domain_types
        self.request_header_rewrite_config = request_header_rewrite_config
        self.request_query_rewrite_config = request_query_rewrite_config
        self.response_header_rewrite_config = response_header_rewrite_config
        self.response_rewrite_config = response_rewrite_config

    def validate(self):
        if self.bypass_config:
            self.bypass_config.validate()
        if self.dns_config:
            self.dns_config.validate()
        if self.js_hook_config:
            self.js_hook_config.validate()
        if self.request_header_rewrite_config:
            self.request_header_rewrite_config.validate()
        if self.request_query_rewrite_config:
            self.request_query_rewrite_config.validate()
        if self.response_header_rewrite_config:
            self.response_header_rewrite_config.validate()
        if self.response_rewrite_config:
            self.response_rewrite_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bypass_config is not None:
            result['BypassConfig'] = self.bypass_config.to_map()
        if self.cert_id is not None:
            result['CertId'] = self.cert_id
        if self.dns_config is not None:
            result['DnsConfig'] = self.dns_config.to_map()
        if self.js_hook_config is not None:
            result['JsHookConfig'] = self.js_hook_config.to_map()
        if self.proxy_domain_types is not None:
            result['ProxyDomainTypes'] = self.proxy_domain_types
        if self.request_header_rewrite_config is not None:
            result['RequestHeaderRewriteConfig'] = self.request_header_rewrite_config.to_map()
        if self.request_query_rewrite_config is not None:
            result['RequestQueryRewriteConfig'] = self.request_query_rewrite_config.to_map()
        if self.response_header_rewrite_config is not None:
            result['ResponseHeaderRewriteConfig'] = self.response_header_rewrite_config.to_map()
        if self.response_rewrite_config is not None:
            result['ResponseRewriteConfig'] = self.response_rewrite_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BypassConfig') is not None:
            temp_model = PAL7ConfigBypassConfig()
            self.bypass_config = temp_model.from_map(m['BypassConfig'])
        if m.get('CertId') is not None:
            self.cert_id = m.get('CertId')
        if m.get('DnsConfig') is not None:
            temp_model = PAL7ConfigDnsConfig()
            self.dns_config = temp_model.from_map(m['DnsConfig'])
        if m.get('JsHookConfig') is not None:
            temp_model = PAL7ConfigJsHookConfig()
            self.js_hook_config = temp_model.from_map(m['JsHookConfig'])
        if m.get('ProxyDomainTypes') is not None:
            self.proxy_domain_types = m.get('ProxyDomainTypes')
        if m.get('RequestHeaderRewriteConfig') is not None:
            temp_model = PAL7ConfigRequestHeaderRewriteConfig()
            self.request_header_rewrite_config = temp_model.from_map(m['RequestHeaderRewriteConfig'])
        if m.get('RequestQueryRewriteConfig') is not None:
            temp_model = PAL7ConfigRequestQueryRewriteConfig()
            self.request_query_rewrite_config = temp_model.from_map(m['RequestQueryRewriteConfig'])
        if m.get('ResponseHeaderRewriteConfig') is not None:
            temp_model = PAL7ConfigResponseHeaderRewriteConfig()
            self.response_header_rewrite_config = temp_model.from_map(m['ResponseHeaderRewriteConfig'])
        if m.get('ResponseRewriteConfig') is not None:
            temp_model = PAL7ConfigResponseRewriteConfig()
            self.response_rewrite_config = temp_model.from_map(m['ResponseRewriteConfig'])
        return self


class ProcessItem(TeaModel):
    def __init__(
        self,
        bundle_id: str = None,
        dev_type: str = None,
        directory: str = None,
        process: str = None,
    ):
        self.bundle_id = bundle_id
        self.dev_type = dev_type
        self.directory = directory
        self.process = process

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.dev_type is not None:
            result['DevType'] = self.dev_type
        if self.directory is not None:
            result['Directory'] = self.directory
        if self.process is not None:
            result['Process'] = self.process
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('DevType') is not None:
            self.dev_type = m.get('DevType')
        if m.get('Directory') is not None:
            self.directory = m.get('Directory')
        if m.get('Process') is not None:
            self.process = m.get('Process')
        return self


class ProcessGroup(TeaModel):
    def __init__(
        self,
        description: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        name: str = None,
        process_group_id: str = None,
        processes: List[ProcessItem] = None,
    ):
        self.description = description
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.name = name
        self.process_group_id = process_group_id
        self.processes = processes

    def validate(self):
        if self.processes:
            for k in self.processes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.name is not None:
            result['Name'] = self.name
        if self.process_group_id is not None:
            result['ProcessGroupId'] = self.process_group_id
        result['Processes'] = []
        if self.processes is not None:
            for k in self.processes:
                result['Processes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProcessGroupId') is not None:
            self.process_group_id = m.get('ProcessGroupId')
        self.processes = []
        if m.get('Processes') is not None:
            for k in m.get('Processes'):
                temp_model = ProcessItem()
                self.processes.append(temp_model.from_map(k))
        return self


class RecoveryContent(TeaModel):
    def __init__(
        self,
        auth_report_interval: AuthReportInterval = None,
        recovery_actions: List[str] = None,
    ):
        self.auth_report_interval = auth_report_interval
        # This parameter is required.
        self.recovery_actions = recovery_actions

    def validate(self):
        if self.auth_report_interval:
            self.auth_report_interval.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_report_interval is not None:
            result['AuthReportInterval'] = self.auth_report_interval.to_map()
        if self.recovery_actions is not None:
            result['RecoveryActions'] = self.recovery_actions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthReportInterval') is not None:
            temp_model = AuthReportInterval()
            self.auth_report_interval = temp_model.from_map(m['AuthReportInterval'])
        if m.get('RecoveryActions') is not None:
            self.recovery_actions = m.get('RecoveryActions')
        return self


class RiskSceneConfig(TeaModel):
    def __init__(
        self,
        detect_channel: List[str] = None,
        office_channel: List[str] = None,
    ):
        self.detect_channel = detect_channel
        self.office_channel = office_channel

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.detect_channel is not None:
            result['DetectChannel'] = self.detect_channel
        if self.office_channel is not None:
            result['OfficeChannel'] = self.office_channel
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DetectChannel') is not None:
            self.detect_channel = m.get('DetectChannel')
        if m.get('OfficeChannel') is not None:
            self.office_channel = m.get('OfficeChannel')
        return self


class Rule(TeaModel):
    def __init__(
        self,
        combinator: str = None,
        id: str = None,
        name: str = None,
        operator: str = None,
        rule_sub_type: str = None,
        rule_type: str = None,
        rules: List['Rule'] = None,
        values: List[str] = None,
    ):
        self.combinator = combinator
        self.id = id
        self.name = name
        self.operator = operator
        self.rule_sub_type = rule_sub_type
        self.rule_type = rule_type
        self.rules = rules
        self.values = values

    def validate(self):
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.combinator is not None:
            result['Combinator'] = self.combinator
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.rule_sub_type is not None:
            result['RuleSubType'] = self.rule_sub_type
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Combinator') is not None:
            self.combinator = m.get('Combinator')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('RuleSubType') is not None:
            self.rule_sub_type = m.get('RuleSubType')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = Rule()
                self.rules.append(temp_model.from_map(k))
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class UserCertificate(TeaModel):
    def __init__(
        self,
        cert_id: str = None,
        certificate: str = None,
        description: str = None,
        dns_names: List[str] = None,
        exp_time_unix: int = None,
        gmt_create_unix: int = None,
        gmt_modified_unix: int = None,
        name: str = None,
        private_key: str = None,
    ):
        self.cert_id = cert_id
        self.certificate = certificate
        self.description = description
        self.dns_names = dns_names
        self.exp_time_unix = exp_time_unix
        self.gmt_create_unix = gmt_create_unix
        self.gmt_modified_unix = gmt_modified_unix
        self.name = name
        self.private_key = private_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_id is not None:
            result['CertId'] = self.cert_id
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.description is not None:
            result['Description'] = self.description
        if self.dns_names is not None:
            result['DnsNames'] = self.dns_names
        if self.exp_time_unix is not None:
            result['ExpTimeUnix'] = self.exp_time_unix
        if self.gmt_create_unix is not None:
            result['GmtCreateUnix'] = self.gmt_create_unix
        if self.gmt_modified_unix is not None:
            result['GmtModifiedUnix'] = self.gmt_modified_unix
        if self.name is not None:
            result['Name'] = self.name
        if self.private_key is not None:
            result['PrivateKey'] = self.private_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CertId') is not None:
            self.cert_id = m.get('CertId')
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DnsNames') is not None:
            self.dns_names = m.get('DnsNames')
        if m.get('ExpTimeUnix') is not None:
            self.exp_time_unix = m.get('ExpTimeUnix')
        if m.get('GmtCreateUnix') is not None:
            self.gmt_create_unix = m.get('GmtCreateUnix')
        if m.get('GmtModifiedUnix') is not None:
            self.gmt_modified_unix = m.get('GmtModifiedUnix')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PrivateKey') is not None:
            self.private_key = m.get('PrivateKey')
        return self


class AttachApplication2ConnectorRequest(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        connector_id: str = None,
    ):
        # This parameter is required.
        self.application_ids = application_ids
        # ConnectorID。
        # 
        # This parameter is required.
        self.connector_id = connector_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.connector_id is not None:
            result['ConnectorId'] = self.connector_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('ConnectorId') is not None:
            self.connector_id = m.get('ConnectorId')
        return self


class AttachApplication2ConnectorShrinkRequest(TeaModel):
    def __init__(
        self,
        application_ids_shrink: str = None,
        connector_id: str = None,
    ):
        # This parameter is required.
        self.application_ids_shrink = application_ids_shrink
        # ConnectorID。
        # 
        # This parameter is required.
        self.connector_id = connector_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids_shrink is not None:
            result['ApplicationIds'] = self.application_ids_shrink
        if self.connector_id is not None:
            result['ConnectorId'] = self.connector_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids_shrink = m.get('ApplicationIds')
        if m.get('ConnectorId') is not None:
            self.connector_id = m.get('ConnectorId')
        return self


class AttachApplication2ConnectorResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachApplication2ConnectorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachApplication2ConnectorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachApplication2ConnectorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachPolicy2ApprovalProcessRequest(TeaModel):
    def __init__(
        self,
        policy_id: str = None,
        policy_type: str = None,
        process_id: str = None,
    ):
        self.policy_id = policy_id
        # This parameter is required.
        self.policy_type = policy_type
        # This parameter is required.
        self.process_id = process_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        return self


class AttachPolicy2ApprovalProcessResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachPolicy2ApprovalProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachPolicy2ApprovalProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachPolicy2ApprovalProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateApprovalProcessRequestMatchSchemas(TeaModel):
    def __init__(
        self,
        app_uninstall_schema_id: str = None,
        device_registration_schema_id: str = None,
        dlp_send_schema_id: str = None,
        domain_blacklist_schema_id: str = None,
        domain_whitelist_schema_id: str = None,
        endpoint_hardening_schema_id: str = None,
        peripheral_block_schema_id: str = None,
        software_block_schema_id: str = None,
        software_hardening_schema_id: str = None,
    ):
        self.app_uninstall_schema_id = app_uninstall_schema_id
        self.device_registration_schema_id = device_registration_schema_id
        self.dlp_send_schema_id = dlp_send_schema_id
        self.domain_blacklist_schema_id = domain_blacklist_schema_id
        self.domain_whitelist_schema_id = domain_whitelist_schema_id
        self.endpoint_hardening_schema_id = endpoint_hardening_schema_id
        self.peripheral_block_schema_id = peripheral_block_schema_id
        self.software_block_schema_id = software_block_schema_id
        self.software_hardening_schema_id = software_hardening_schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_uninstall_schema_id is not None:
            result['AppUninstallSchemaId'] = self.app_uninstall_schema_id
        if self.device_registration_schema_id is not None:
            result['DeviceRegistrationSchemaId'] = self.device_registration_schema_id
        if self.dlp_send_schema_id is not None:
            result['DlpSendSchemaId'] = self.dlp_send_schema_id
        if self.domain_blacklist_schema_id is not None:
            result['DomainBlacklistSchemaId'] = self.domain_blacklist_schema_id
        if self.domain_whitelist_schema_id is not None:
            result['DomainWhitelistSchemaId'] = self.domain_whitelist_schema_id
        if self.endpoint_hardening_schema_id is not None:
            result['EndpointHardeningSchemaId'] = self.endpoint_hardening_schema_id
        if self.peripheral_block_schema_id is not None:
            result['PeripheralBlockSchemaId'] = self.peripheral_block_schema_id
        if self.software_block_schema_id is not None:
            result['SoftwareBlockSchemaId'] = self.software_block_schema_id
        if self.software_hardening_schema_id is not None:
            result['SoftwareHardeningSchemaId'] = self.software_hardening_schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppUninstallSchemaId') is not None:
            self.app_uninstall_schema_id = m.get('AppUninstallSchemaId')
        if m.get('DeviceRegistrationSchemaId') is not None:
            self.device_registration_schema_id = m.get('DeviceRegistrationSchemaId')
        if m.get('DlpSendSchemaId') is not None:
            self.dlp_send_schema_id = m.get('DlpSendSchemaId')
        if m.get('DomainBlacklistSchemaId') is not None:
            self.domain_blacklist_schema_id = m.get('DomainBlacklistSchemaId')
        if m.get('DomainWhitelistSchemaId') is not None:
            self.domain_whitelist_schema_id = m.get('DomainWhitelistSchemaId')
        if m.get('EndpointHardeningSchemaId') is not None:
            self.endpoint_hardening_schema_id = m.get('EndpointHardeningSchemaId')
        if m.get('PeripheralBlockSchemaId') is not None:
            self.peripheral_block_schema_id = m.get('PeripheralBlockSchemaId')
        if m.get('SoftwareBlockSchemaId') is not None:
            self.software_block_schema_id = m.get('SoftwareBlockSchemaId')
        if m.get('SoftwareHardeningSchemaId') is not None:
            self.software_hardening_schema_id = m.get('SoftwareHardeningSchemaId')
        return self


class CreateApprovalProcessRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        match_schemas: CreateApprovalProcessRequestMatchSchemas = None,
        process_name: str = None,
        process_nodes: List[List[str]] = None,
    ):
        self.description = description
        self.match_schemas = match_schemas
        # This parameter is required.
        self.process_name = process_name
        # This parameter is required.
        self.process_nodes = process_nodes

    def validate(self):
        if self.match_schemas:
            self.match_schemas.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.match_schemas is not None:
            result['MatchSchemas'] = self.match_schemas.to_map()
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.process_nodes is not None:
            result['ProcessNodes'] = self.process_nodes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MatchSchemas') is not None:
            temp_model = CreateApprovalProcessRequestMatchSchemas()
            self.match_schemas = temp_model.from_map(m['MatchSchemas'])
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('ProcessNodes') is not None:
            self.process_nodes = m.get('ProcessNodes')
        return self


class CreateApprovalProcessShrinkRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        match_schemas_shrink: str = None,
        process_name: str = None,
        process_nodes: List[List[str]] = None,
    ):
        self.description = description
        self.match_schemas_shrink = match_schemas_shrink
        # This parameter is required.
        self.process_name = process_name
        # This parameter is required.
        self.process_nodes = process_nodes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.match_schemas_shrink is not None:
            result['MatchSchemas'] = self.match_schemas_shrink
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.process_nodes is not None:
            result['ProcessNodes'] = self.process_nodes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MatchSchemas') is not None:
            self.match_schemas_shrink = m.get('MatchSchemas')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('ProcessNodes') is not None:
            self.process_nodes = m.get('ProcessNodes')
        return self


class CreateApprovalProcessResponseBodyProcessAppUninstallPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class CreateApprovalProcessResponseBodyProcessDeviceRegistrationPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class CreateApprovalProcessResponseBodyProcessDlpSendPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class CreateApprovalProcessResponseBodyProcessDomainBlacklistPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class CreateApprovalProcessResponseBodyProcessDomainWhitelistPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class CreateApprovalProcessResponseBodyProcessEndpointHardeningPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class CreateApprovalProcessResponseBodyProcessPeripheralBlockPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class CreateApprovalProcessResponseBodyProcessProcessNodes(TeaModel):
    def __init__(
        self,
        sase_user_id: str = None,
        username: str = None,
    ):
        self.sase_user_id = sase_user_id
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class CreateApprovalProcessResponseBodyProcessSoftwareBlockPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class CreateApprovalProcessResponseBodyProcessSoftwareHardeningPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class CreateApprovalProcessResponseBodyProcess(TeaModel):
    def __init__(
        self,
        app_uninstall_policies: CreateApprovalProcessResponseBodyProcessAppUninstallPolicies = None,
        create_time: str = None,
        description: str = None,
        device_registration_policies: CreateApprovalProcessResponseBodyProcessDeviceRegistrationPolicies = None,
        dlp_send_policies: CreateApprovalProcessResponseBodyProcessDlpSendPolicies = None,
        domain_blacklist_policies: CreateApprovalProcessResponseBodyProcessDomainBlacklistPolicies = None,
        domain_whitelist_policies: CreateApprovalProcessResponseBodyProcessDomainWhitelistPolicies = None,
        endpoint_hardening_policies: CreateApprovalProcessResponseBodyProcessEndpointHardeningPolicies = None,
        peripheral_block_policies: CreateApprovalProcessResponseBodyProcessPeripheralBlockPolicies = None,
        process_id: str = None,
        process_name: str = None,
        process_nodes: List[List[CreateApprovalProcessResponseBodyProcessProcessNodes]] = None,
        software_block_policies: CreateApprovalProcessResponseBodyProcessSoftwareBlockPolicies = None,
        software_hardening_policies: CreateApprovalProcessResponseBodyProcessSoftwareHardeningPolicies = None,
    ):
        self.app_uninstall_policies = app_uninstall_policies
        self.create_time = create_time
        self.description = description
        self.device_registration_policies = device_registration_policies
        self.dlp_send_policies = dlp_send_policies
        self.domain_blacklist_policies = domain_blacklist_policies
        self.domain_whitelist_policies = domain_whitelist_policies
        self.endpoint_hardening_policies = endpoint_hardening_policies
        self.peripheral_block_policies = peripheral_block_policies
        self.process_id = process_id
        self.process_name = process_name
        self.process_nodes = process_nodes
        self.software_block_policies = software_block_policies
        self.software_hardening_policies = software_hardening_policies

    def validate(self):
        if self.app_uninstall_policies:
            self.app_uninstall_policies.validate()
        if self.device_registration_policies:
            self.device_registration_policies.validate()
        if self.dlp_send_policies:
            self.dlp_send_policies.validate()
        if self.domain_blacklist_policies:
            self.domain_blacklist_policies.validate()
        if self.domain_whitelist_policies:
            self.domain_whitelist_policies.validate()
        if self.endpoint_hardening_policies:
            self.endpoint_hardening_policies.validate()
        if self.peripheral_block_policies:
            self.peripheral_block_policies.validate()
        if self.process_nodes:
            for k in self.process_nodes:
                for k1 in k:
                    if k1:
                        k1.validate()
        if self.software_block_policies:
            self.software_block_policies.validate()
        if self.software_hardening_policies:
            self.software_hardening_policies.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_uninstall_policies is not None:
            result['AppUninstallPolicies'] = self.app_uninstall_policies.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.device_registration_policies is not None:
            result['DeviceRegistrationPolicies'] = self.device_registration_policies.to_map()
        if self.dlp_send_policies is not None:
            result['DlpSendPolicies'] = self.dlp_send_policies.to_map()
        if self.domain_blacklist_policies is not None:
            result['DomainBlacklistPolicies'] = self.domain_blacklist_policies.to_map()
        if self.domain_whitelist_policies is not None:
            result['DomainWhitelistPolicies'] = self.domain_whitelist_policies.to_map()
        if self.endpoint_hardening_policies is not None:
            result['EndpointHardeningPolicies'] = self.endpoint_hardening_policies.to_map()
        if self.peripheral_block_policies is not None:
            result['PeripheralBlockPolicies'] = self.peripheral_block_policies.to_map()
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        result['ProcessNodes'] = []
        if self.process_nodes is not None:
            for k in self.process_nodes:
                l1 = []
                for k1 in k:
                    l1.append(k1.to_map() if k1 else None)
                result['ProcessNodes'].append(l1)
        if self.software_block_policies is not None:
            result['SoftwareBlockPolicies'] = self.software_block_policies.to_map()
        if self.software_hardening_policies is not None:
            result['SoftwareHardeningPolicies'] = self.software_hardening_policies.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppUninstallPolicies') is not None:
            temp_model = CreateApprovalProcessResponseBodyProcessAppUninstallPolicies()
            self.app_uninstall_policies = temp_model.from_map(m['AppUninstallPolicies'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceRegistrationPolicies') is not None:
            temp_model = CreateApprovalProcessResponseBodyProcessDeviceRegistrationPolicies()
            self.device_registration_policies = temp_model.from_map(m['DeviceRegistrationPolicies'])
        if m.get('DlpSendPolicies') is not None:
            temp_model = CreateApprovalProcessResponseBodyProcessDlpSendPolicies()
            self.dlp_send_policies = temp_model.from_map(m['DlpSendPolicies'])
        if m.get('DomainBlacklistPolicies') is not None:
            temp_model = CreateApprovalProcessResponseBodyProcessDomainBlacklistPolicies()
            self.domain_blacklist_policies = temp_model.from_map(m['DomainBlacklistPolicies'])
        if m.get('DomainWhitelistPolicies') is not None:
            temp_model = CreateApprovalProcessResponseBodyProcessDomainWhitelistPolicies()
            self.domain_whitelist_policies = temp_model.from_map(m['DomainWhitelistPolicies'])
        if m.get('EndpointHardeningPolicies') is not None:
            temp_model = CreateApprovalProcessResponseBodyProcessEndpointHardeningPolicies()
            self.endpoint_hardening_policies = temp_model.from_map(m['EndpointHardeningPolicies'])
        if m.get('PeripheralBlockPolicies') is not None:
            temp_model = CreateApprovalProcessResponseBodyProcessPeripheralBlockPolicies()
            self.peripheral_block_policies = temp_model.from_map(m['PeripheralBlockPolicies'])
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        self.process_nodes = []
        if m.get('ProcessNodes') is not None:
            for k in m.get('ProcessNodes'):
                l1 = []
                for k1 in k:
                    temp_model = CreateApprovalProcessResponseBodyProcessProcessNodes()
                    l1.append(temp_model.from_map(k1))
                self.process_nodes.append(l1)
        if m.get('SoftwareBlockPolicies') is not None:
            temp_model = CreateApprovalProcessResponseBodyProcessSoftwareBlockPolicies()
            self.software_block_policies = temp_model.from_map(m['SoftwareBlockPolicies'])
        if m.get('SoftwareHardeningPolicies') is not None:
            temp_model = CreateApprovalProcessResponseBodyProcessSoftwareHardeningPolicies()
            self.software_hardening_policies = temp_model.from_map(m['SoftwareHardeningPolicies'])
        return self


class CreateApprovalProcessResponseBody(TeaModel):
    def __init__(
        self,
        process: CreateApprovalProcessResponseBodyProcess = None,
        request_id: str = None,
    ):
        self.process = process
        self.request_id = request_id

    def validate(self):
        if self.process:
            self.process.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.process is not None:
            result['Process'] = self.process.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Process') is not None:
            temp_model = CreateApprovalProcessResponseBodyProcess()
            self.process = temp_model.from_map(m['Process'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateApprovalProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateApprovalProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateApprovalProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClientUserRequest(TeaModel):
    def __init__(
        self,
        department_id: str = None,
        description: str = None,
        email: str = None,
        idp_config_id: str = None,
        mobile_number: str = None,
        password: str = None,
        username: str = None,
    ):
        self.department_id = department_id
        self.description = description
        # This parameter is required.
        self.email = email
        # This parameter is required.
        self.idp_config_id = idp_config_id
        self.mobile_number = mobile_number
        self.password = password
        # This parameter is required.
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.description is not None:
            result['Description'] = self.description
        if self.email is not None:
            result['Email'] = self.email
        if self.idp_config_id is not None:
            result['IdpConfigId'] = self.idp_config_id
        if self.mobile_number is not None:
            result['MobileNumber'] = self.mobile_number
        if self.password is not None:
            result['Password'] = self.password
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('IdpConfigId') is not None:
            self.idp_config_id = m.get('IdpConfigId')
        if m.get('MobileNumber') is not None:
            self.mobile_number = m.get('MobileNumber')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class CreateClientUserResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateClientUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateClientUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateClientUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDynamicRouteRequest(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        application_type: str = None,
        description: str = None,
        dynamic_route_type: str = None,
        name: str = None,
        next_hop: str = None,
        priority: int = None,
        region_ids: List[str] = None,
        status: str = None,
        tag_ids: List[str] = None,
    ):
        self.application_ids = application_ids
        # This parameter is required.
        self.application_type = application_type
        self.description = description
        # This parameter is required.
        self.dynamic_route_type = dynamic_route_type
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.next_hop = next_hop
        # This parameter is required.
        self.priority = priority
        # This parameter is required.
        self.region_ids = region_ids
        # This parameter is required.
        self.status = status
        self.tag_ids = tag_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.application_type is not None:
            result['ApplicationType'] = self.application_type
        if self.description is not None:
            result['Description'] = self.description
        if self.dynamic_route_type is not None:
            result['DynamicRouteType'] = self.dynamic_route_type
        if self.name is not None:
            result['Name'] = self.name
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.region_ids is not None:
            result['RegionIds'] = self.region_ids
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_ids is not None:
            result['TagIds'] = self.tag_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('ApplicationType') is not None:
            self.application_type = m.get('ApplicationType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DynamicRouteType') is not None:
            self.dynamic_route_type = m.get('DynamicRouteType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RegionIds') is not None:
            self.region_ids = m.get('RegionIds')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagIds') is not None:
            self.tag_ids = m.get('TagIds')
        return self


class CreateDynamicRouteResponseBody(TeaModel):
    def __init__(
        self,
        dynamic_route_id: str = None,
        request_id: str = None,
    ):
        self.dynamic_route_id = dynamic_route_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_route_id is not None:
            result['DynamicRouteId'] = self.dynamic_route_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DynamicRouteId') is not None:
            self.dynamic_route_id = m.get('DynamicRouteId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDynamicRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDynamicRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDynamicRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEnterpriseAcceleratePolicyRequest(TeaModel):
    def __init__(
        self,
        acceleration_type: str = None,
        description: str = None,
        name: str = None,
        priority: str = None,
        show_in_client: int = None,
        upstream_host: str = None,
        upstream_port: int = None,
        upstream_type: str = None,
        user_attribute_group: str = None,
    ):
        self.acceleration_type = acceleration_type
        self.description = description
        self.name = name
        self.priority = priority
        self.show_in_client = show_in_client
        # This parameter is required.
        self.upstream_host = upstream_host
        # This parameter is required.
        self.upstream_port = upstream_port
        # This parameter is required.
        self.upstream_type = upstream_type
        # This parameter is required.
        self.user_attribute_group = user_attribute_group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acceleration_type is not None:
            result['AccelerationType'] = self.acceleration_type
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.show_in_client is not None:
            result['ShowInClient'] = self.show_in_client
        if self.upstream_host is not None:
            result['UpstreamHost'] = self.upstream_host
        if self.upstream_port is not None:
            result['UpstreamPort'] = self.upstream_port
        if self.upstream_type is not None:
            result['UpstreamType'] = self.upstream_type
        if self.user_attribute_group is not None:
            result['UserAttributeGroup'] = self.user_attribute_group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccelerationType') is not None:
            self.acceleration_type = m.get('AccelerationType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ShowInClient') is not None:
            self.show_in_client = m.get('ShowInClient')
        if m.get('UpstreamHost') is not None:
            self.upstream_host = m.get('UpstreamHost')
        if m.get('UpstreamPort') is not None:
            self.upstream_port = m.get('UpstreamPort')
        if m.get('UpstreamType') is not None:
            self.upstream_type = m.get('UpstreamType')
        if m.get('UserAttributeGroup') is not None:
            self.user_attribute_group = m.get('UserAttributeGroup')
        return self


class CreateEnterpriseAcceleratePolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEnterpriseAcceleratePolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEnterpriseAcceleratePolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEnterpriseAcceleratePolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEnterpriseAccelerateTargetRequest(TeaModel):
    def __init__(
        self,
        eap_id: str = None,
        target: List[str] = None,
    ):
        # This parameter is required.
        self.eap_id = eap_id
        # This parameter is required.
        self.target = target

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.eap_id is not None:
            result['EapId'] = self.eap_id
        if self.target is not None:
            result['Target'] = self.target
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EapId') is not None:
            self.eap_id = m.get('EapId')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        return self


class CreateEnterpriseAccelerateTargetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEnterpriseAccelerateTargetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEnterpriseAccelerateTargetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEnterpriseAccelerateTargetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIdpDepartmentRequest(TeaModel):
    def __init__(
        self,
        department_name: str = None,
        idp_config_id: str = None,
    ):
        # This parameter is required.
        self.department_name = department_name
        # This parameter is required.
        self.idp_config_id = idp_config_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_name is not None:
            result['DepartmentName'] = self.department_name
        if self.idp_config_id is not None:
            result['IdpConfigId'] = self.idp_config_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentName') is not None:
            self.department_name = m.get('DepartmentName')
        if m.get('IdpConfigId') is not None:
            self.idp_config_id = m.get('IdpConfigId')
        return self


class CreateIdpDepartmentResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateIdpDepartmentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateIdpDepartmentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateIdpDepartmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePrivateAccessApplicationRequestPortRanges(TeaModel):
    def __init__(
        self,
        begin: int = None,
        end: int = None,
    ):
        # The start port. The start port must be less than or equal to the end port.
        # 
        # This parameter is required.
        self.begin = begin
        # The end port. The end port must be greater than or equal to the start port.
        # 
        # This parameter is required.
        self.end = end

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin is not None:
            result['Begin'] = self.begin
        if self.end is not None:
            result['End'] = self.end
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Begin') is not None:
            self.begin = m.get('Begin')
        if m.get('End') is not None:
            self.end = m.get('End')
        return self


class CreatePrivateAccessApplicationRequest(TeaModel):
    def __init__(
        self,
        addresses: List[str] = None,
        browser_access_status: str = None,
        description: str = None,
        l_7config: PAL7Config = None,
        l_7proxy_domain_automatic_prefix: str = None,
        l_7proxy_domain_custom: str = None,
        name: str = None,
        port_ranges: List[CreatePrivateAccessApplicationRequestPortRanges] = None,
        protocol: str = None,
        status: str = None,
        tag_ids: List[str] = None,
    ):
        # The addresses of the office applications. You can enter up to 1,000 addresses of office applications.
        # 
        # This parameter is required.
        self.addresses = addresses
        # Specifies whether to allow access from a browser. Default value: **Disabled**. Valid values:
        # 
        # *   **Enabled**\
        # *   **Disabled**\
        self.browser_access_status = browser_access_status
        # The description of the office application. The value must be 1 to 128 characters in length and can contain letters, digits, periods (.), underscores (_), hyphens (-), and spaces.
        self.description = description
        # The browser access mode parameter. The parameter specifies the configurations of Layer 7 applications.
        self.l_7config = l_7config
        # The browser access mode parameter. The parameter specifies the prefix of the domain name that the proxy gateway uses. The prefix must be 3 to 20 characters in length, and can contain lowercase letters, digits, and hyphens (-).
        self.l_7proxy_domain_automatic_prefix = l_7proxy_domain_automatic_prefix
        # The browser access mode parameter. The parameter specifies the custom domain name of the proxy gateway. Enter a valid domain name.
        self.l_7proxy_domain_custom = l_7proxy_domain_custom
        # The name of the office application. The value must be 1 to 128 characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-).
        # 
        # This parameter is required.
        self.name = name
        # The port ranges of the office applications. You can enter up to 65,535 port ranges. Multiple port ranges cannot be duplicated or overlapped.
        # 
        # This parameter is required.
        self.port_ranges = port_ranges
        # The protocol that is used by the office application. Valid values:
        # 
        # *   **All**\
        # *   **TCP**\
        # *   **UDP**\
        # 
        # This parameter is required.
        self.protocol = protocol
        # The status of the office application. Valid values:
        # 
        # *   **Enabled**\
        # *   **Disabled**\
        # 
        # This parameter is required.
        self.status = status
        # The IDs of the tags for the office applications. You can add up to six custom tags to an office application.
        self.tag_ids = tag_ids

    def validate(self):
        if self.l_7config:
            self.l_7config.validate()
        if self.port_ranges:
            for k in self.port_ranges:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addresses is not None:
            result['Addresses'] = self.addresses
        if self.browser_access_status is not None:
            result['BrowserAccessStatus'] = self.browser_access_status
        if self.description is not None:
            result['Description'] = self.description
        if self.l_7config is not None:
            result['L7Config'] = self.l_7config.to_map()
        if self.l_7proxy_domain_automatic_prefix is not None:
            result['L7ProxyDomainAutomaticPrefix'] = self.l_7proxy_domain_automatic_prefix
        if self.l_7proxy_domain_custom is not None:
            result['L7ProxyDomainCustom'] = self.l_7proxy_domain_custom
        if self.name is not None:
            result['Name'] = self.name
        result['PortRanges'] = []
        if self.port_ranges is not None:
            for k in self.port_ranges:
                result['PortRanges'].append(k.to_map() if k else None)
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_ids is not None:
            result['TagIds'] = self.tag_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addresses') is not None:
            self.addresses = m.get('Addresses')
        if m.get('BrowserAccessStatus') is not None:
            self.browser_access_status = m.get('BrowserAccessStatus')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('L7Config') is not None:
            temp_model = PAL7Config()
            self.l_7config = temp_model.from_map(m['L7Config'])
        if m.get('L7ProxyDomainAutomaticPrefix') is not None:
            self.l_7proxy_domain_automatic_prefix = m.get('L7ProxyDomainAutomaticPrefix')
        if m.get('L7ProxyDomainCustom') is not None:
            self.l_7proxy_domain_custom = m.get('L7ProxyDomainCustom')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.port_ranges = []
        if m.get('PortRanges') is not None:
            for k in m.get('PortRanges'):
                temp_model = CreatePrivateAccessApplicationRequestPortRanges()
                self.port_ranges.append(temp_model.from_map(k))
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagIds') is not None:
            self.tag_ids = m.get('TagIds')
        return self


class CreatePrivateAccessApplicationShrinkRequestPortRanges(TeaModel):
    def __init__(
        self,
        begin: int = None,
        end: int = None,
    ):
        # The start port. The start port must be less than or equal to the end port.
        # 
        # This parameter is required.
        self.begin = begin
        # The end port. The end port must be greater than or equal to the start port.
        # 
        # This parameter is required.
        self.end = end

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin is not None:
            result['Begin'] = self.begin
        if self.end is not None:
            result['End'] = self.end
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Begin') is not None:
            self.begin = m.get('Begin')
        if m.get('End') is not None:
            self.end = m.get('End')
        return self


class CreatePrivateAccessApplicationShrinkRequest(TeaModel):
    def __init__(
        self,
        addresses: List[str] = None,
        browser_access_status: str = None,
        description: str = None,
        l_7config_shrink: str = None,
        l_7proxy_domain_automatic_prefix: str = None,
        l_7proxy_domain_custom: str = None,
        name: str = None,
        port_ranges: List[CreatePrivateAccessApplicationShrinkRequestPortRanges] = None,
        protocol: str = None,
        status: str = None,
        tag_ids: List[str] = None,
    ):
        # The addresses of the office applications. You can enter up to 1,000 addresses of office applications.
        # 
        # This parameter is required.
        self.addresses = addresses
        # Specifies whether to allow access from a browser. Default value: **Disabled**. Valid values:
        # 
        # *   **Enabled**\
        # *   **Disabled**\
        self.browser_access_status = browser_access_status
        # The description of the office application. The value must be 1 to 128 characters in length and can contain letters, digits, periods (.), underscores (_), hyphens (-), and spaces.
        self.description = description
        # The browser access mode parameter. The parameter specifies the configurations of Layer 7 applications.
        self.l_7config_shrink = l_7config_shrink
        # The browser access mode parameter. The parameter specifies the prefix of the domain name that the proxy gateway uses. The prefix must be 3 to 20 characters in length, and can contain lowercase letters, digits, and hyphens (-).
        self.l_7proxy_domain_automatic_prefix = l_7proxy_domain_automatic_prefix
        # The browser access mode parameter. The parameter specifies the custom domain name of the proxy gateway. Enter a valid domain name.
        self.l_7proxy_domain_custom = l_7proxy_domain_custom
        # The name of the office application. The value must be 1 to 128 characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-).
        # 
        # This parameter is required.
        self.name = name
        # The port ranges of the office applications. You can enter up to 65,535 port ranges. Multiple port ranges cannot be duplicated or overlapped.
        # 
        # This parameter is required.
        self.port_ranges = port_ranges
        # The protocol that is used by the office application. Valid values:
        # 
        # *   **All**\
        # *   **TCP**\
        # *   **UDP**\
        # 
        # This parameter is required.
        self.protocol = protocol
        # The status of the office application. Valid values:
        # 
        # *   **Enabled**\
        # *   **Disabled**\
        # 
        # This parameter is required.
        self.status = status
        # The IDs of the tags for the office applications. You can add up to six custom tags to an office application.
        self.tag_ids = tag_ids

    def validate(self):
        if self.port_ranges:
            for k in self.port_ranges:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addresses is not None:
            result['Addresses'] = self.addresses
        if self.browser_access_status is not None:
            result['BrowserAccessStatus'] = self.browser_access_status
        if self.description is not None:
            result['Description'] = self.description
        if self.l_7config_shrink is not None:
            result['L7Config'] = self.l_7config_shrink
        if self.l_7proxy_domain_automatic_prefix is not None:
            result['L7ProxyDomainAutomaticPrefix'] = self.l_7proxy_domain_automatic_prefix
        if self.l_7proxy_domain_custom is not None:
            result['L7ProxyDomainCustom'] = self.l_7proxy_domain_custom
        if self.name is not None:
            result['Name'] = self.name
        result['PortRanges'] = []
        if self.port_ranges is not None:
            for k in self.port_ranges:
                result['PortRanges'].append(k.to_map() if k else None)
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_ids is not None:
            result['TagIds'] = self.tag_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addresses') is not None:
            self.addresses = m.get('Addresses')
        if m.get('BrowserAccessStatus') is not None:
            self.browser_access_status = m.get('BrowserAccessStatus')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('L7Config') is not None:
            self.l_7config_shrink = m.get('L7Config')
        if m.get('L7ProxyDomainAutomaticPrefix') is not None:
            self.l_7proxy_domain_automatic_prefix = m.get('L7ProxyDomainAutomaticPrefix')
        if m.get('L7ProxyDomainCustom') is not None:
            self.l_7proxy_domain_custom = m.get('L7ProxyDomainCustom')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.port_ranges = []
        if m.get('PortRanges') is not None:
            for k in m.get('PortRanges'):
                temp_model = CreatePrivateAccessApplicationShrinkRequestPortRanges()
                self.port_ranges.append(temp_model.from_map(k))
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagIds') is not None:
            self.tag_ids = m.get('TagIds')
        return self


class CreatePrivateAccessApplicationResponseBody(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        request_id: str = None,
    ):
        # The ID of the office application.
        self.application_id = application_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePrivateAccessApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePrivateAccessApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePrivateAccessApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePrivateAccessPolicyRequestCustomUserAttributes(TeaModel):
    def __init__(
        self,
        idp_id: int = None,
        relation: str = None,
        user_group_type: str = None,
        value: str = None,
    ):
        # The ID of the identity source for the custom user group. Required when the custom user group type is **department**.
        self.idp_id = idp_id
        # Relation of the custom user group. Values:
        # - **Equal**: Equal.
        # - **Unequal**: Not equal.
        self.relation = relation
        # Type of the custom user group. Values:
        # - **username**: Username.
        # - **department**: Department.
        # - **email**: Email.
        # - **telephone**: Telephone.
        self.user_group_type = user_group_type
        # Value of the custom user group attribute.
        # - When the user group type is **username**, it represents the value of the username. The length is 1 to 128 characters, supporting Chinese and uppercase and lowercase English letters, and can include numbers, periods (.), underscores (_), hyphens (-), asterisks (*), at (@) symbols, and spaces.
        # - When the user group type is **department**, it represents the value of the department. For example: OU=Department1,OU=SASE DingTalk.
        # - When the user group type is **email**, it represents the value of the email. For example: username@example.com.
        # - When the user group type is **telephone**, it represents the value of the telephone. For example: 13900001234.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idp_id is not None:
            result['IdpId'] = self.idp_id
        if self.relation is not None:
            result['Relation'] = self.relation
        if self.user_group_type is not None:
            result['UserGroupType'] = self.user_group_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdpId') is not None:
            self.idp_id = m.get('IdpId')
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        if m.get('UserGroupType') is not None:
            self.user_group_type = m.get('UserGroupType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreatePrivateAccessPolicyRequest(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        application_type: str = None,
        custom_user_attributes: List[CreatePrivateAccessPolicyRequestCustomUserAttributes] = None,
        description: str = None,
        device_attribute_action: str = None,
        device_attribute_id: str = None,
        name: str = None,
        policy_action: str = None,
        priority: int = None,
        status: str = None,
        tag_ids: List[str] = None,
        trigger_template_id: str = None,
        trusted_process_group_ids: List[str] = None,
        trusted_process_status: str = None,
        trusted_software_ids: List[str] = None,
        user_group_ids: List[str] = None,
        user_group_mode: str = None,
    ):
        # Set of application IDs for the private access policy. Up to 100 application IDs can be entered. Required when **ApplicationType** is **Application**. Mutually exclusive with **TagIds**.
        self.application_ids = application_ids
        # Application type of the private access policy. Values:
        # - **Application**: Application.
        # - **Tag**: Tag.
        # 
        # This parameter is required.
        self.application_type = application_type
        # Set of custom user groups for the private access policy. Required when the user group type is **Custom**. Mutually exclusive with the user group ID set. Up to 10 custom user groups can be entered.
        self.custom_user_attributes = custom_user_attributes
        # Description of the private access policy. The length is 1 to 128 characters, supporting Chinese and uppercase and lowercase English letters, and can include numbers, periods (.), underscores (_), hyphens (-), and spaces.
        self.description = description
        # The execution policy for not meeting the security baseline. Values:
        # 
        # - **Block**: Block.
        # - **Observe**: Observe.
        self.device_attribute_action = device_attribute_action
        # The ID of the security baseline policy.
        self.device_attribute_id = device_attribute_id
        # Name of the private access policy. The length is 1 to 128 characters, supporting Chinese and uppercase and lowercase English letters, and can include numbers, periods (.), underscores (_), and hyphens (-).
        # 
        # This parameter is required.
        self.name = name
        # Action of the private access policy. Values:
        # - **Block**: Block.
        # - **Allow**: Allow.
        # 
        # This parameter is required.
        self.policy_action = policy_action
        # The priority of the private access policy. The number 1 indicates the highest priority. Range: 1~1000, with the maximum value being the total number of private access policies.
        # 
        # This parameter is required.
        self.priority = priority
        # The status of the private access policy. Values:
        # - **Enabled**: Enabled.
        # - **Disabled**: Disabled.
        # 
        # This parameter is required.
        self.status = status
        # Set of tag IDs for the private access policy. Up to 100 tag IDs can be entered. Required when **ApplicationType** is **Tag**. Mutually exclusive with **ApplicationIds**.
        self.tag_ids = tag_ids
        # The trigger template ID.
        self.trigger_template_id = trigger_template_id
        # The ID of the trusted process group.
        self.trusted_process_group_ids = trusted_process_group_ids
        # The switch status of the trusted process. Values:
        # - **Enabled**: Enabled.
        # - **Disabled**: Disabled.
        self.trusted_process_status = trusted_process_status
        # The ID of the trusted software.
        self.trusted_software_ids = trusted_software_ids
        # Set of user group IDs for the private access policy. Required when the user group type is **Normal**. Mutually exclusive with the custom user group set. Up to 2000 user group IDs can be entered.
        self.user_group_ids = user_group_ids
        # User group type of the private access policy. Values:
        # - **Normal**: Normal user group.
        # - **Custom**: Custom user group.
        # 
        # This parameter is required.
        self.user_group_mode = user_group_mode

    def validate(self):
        if self.custom_user_attributes:
            for k in self.custom_user_attributes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.application_type is not None:
            result['ApplicationType'] = self.application_type
        result['CustomUserAttributes'] = []
        if self.custom_user_attributes is not None:
            for k in self.custom_user_attributes:
                result['CustomUserAttributes'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.device_attribute_action is not None:
            result['DeviceAttributeAction'] = self.device_attribute_action
        if self.device_attribute_id is not None:
            result['DeviceAttributeId'] = self.device_attribute_id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_action is not None:
            result['PolicyAction'] = self.policy_action
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_ids is not None:
            result['TagIds'] = self.tag_ids
        if self.trigger_template_id is not None:
            result['TriggerTemplateId'] = self.trigger_template_id
        if self.trusted_process_group_ids is not None:
            result['TrustedProcessGroupIds'] = self.trusted_process_group_ids
        if self.trusted_process_status is not None:
            result['TrustedProcessStatus'] = self.trusted_process_status
        if self.trusted_software_ids is not None:
            result['TrustedSoftwareIds'] = self.trusted_software_ids
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        if self.user_group_mode is not None:
            result['UserGroupMode'] = self.user_group_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('ApplicationType') is not None:
            self.application_type = m.get('ApplicationType')
        self.custom_user_attributes = []
        if m.get('CustomUserAttributes') is not None:
            for k in m.get('CustomUserAttributes'):
                temp_model = CreatePrivateAccessPolicyRequestCustomUserAttributes()
                self.custom_user_attributes.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceAttributeAction') is not None:
            self.device_attribute_action = m.get('DeviceAttributeAction')
        if m.get('DeviceAttributeId') is not None:
            self.device_attribute_id = m.get('DeviceAttributeId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyAction') is not None:
            self.policy_action = m.get('PolicyAction')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagIds') is not None:
            self.tag_ids = m.get('TagIds')
        if m.get('TriggerTemplateId') is not None:
            self.trigger_template_id = m.get('TriggerTemplateId')
        if m.get('TrustedProcessGroupIds') is not None:
            self.trusted_process_group_ids = m.get('TrustedProcessGroupIds')
        if m.get('TrustedProcessStatus') is not None:
            self.trusted_process_status = m.get('TrustedProcessStatus')
        if m.get('TrustedSoftwareIds') is not None:
            self.trusted_software_ids = m.get('TrustedSoftwareIds')
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        if m.get('UserGroupMode') is not None:
            self.user_group_mode = m.get('UserGroupMode')
        return self


class CreatePrivateAccessPolicyResponseBody(TeaModel):
    def __init__(
        self,
        policy_id: str = None,
        request_id: str = None,
    ):
        # The ID of the private access policy.
        self.policy_id = policy_id
        # The ID of the current request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePrivateAccessPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePrivateAccessPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePrivateAccessPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePrivateAccessTagRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
    ):
        self.description = description
        # This parameter is required.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreatePrivateAccessTagResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        tag_id: str = None,
    ):
        self.request_id = request_id
        self.tag_id = tag_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        return self


class CreatePrivateAccessTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePrivateAccessTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePrivateAccessTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRegistrationPolicyRequestCompanyLimitCount(TeaModel):
    def __init__(
        self,
        all: int = None,
        mobile: int = None,
        pc: int = None,
    ):
        self.all = all
        self.mobile = mobile
        self.pc = pc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all is not None:
            result['All'] = self.all
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.pc is not None:
            result['PC'] = self.pc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('All') is not None:
            self.all = m.get('All')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('PC') is not None:
            self.pc = m.get('PC')
        return self


class CreateRegistrationPolicyRequestPersonalLimitCount(TeaModel):
    def __init__(
        self,
        all: int = None,
        mobile: int = None,
        pc: int = None,
    ):
        self.all = all
        self.mobile = mobile
        self.pc = pc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all is not None:
            result['All'] = self.all
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.pc is not None:
            result['PC'] = self.pc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('All') is not None:
            self.all = m.get('All')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('PC') is not None:
            self.pc = m.get('PC')
        return self


class CreateRegistrationPolicyRequest(TeaModel):
    def __init__(
        self,
        company_limit_count: CreateRegistrationPolicyRequestCompanyLimitCount = None,
        company_limit_type: str = None,
        description: str = None,
        match_mode: str = None,
        name: str = None,
        personal_limit_count: CreateRegistrationPolicyRequestPersonalLimitCount = None,
        personal_limit_type: str = None,
        priority: int = None,
        status: str = None,
        user_group_ids: List[str] = None,
        whitelist: List[str] = None,
    ):
        self.company_limit_count = company_limit_count
        # This parameter is required.
        self.company_limit_type = company_limit_type
        self.description = description
        # This parameter is required.
        self.match_mode = match_mode
        # This parameter is required.
        self.name = name
        self.personal_limit_count = personal_limit_count
        # This parameter is required.
        self.personal_limit_type = personal_limit_type
        self.priority = priority
        # This parameter is required.
        self.status = status
        self.user_group_ids = user_group_ids
        self.whitelist = whitelist

    def validate(self):
        if self.company_limit_count:
            self.company_limit_count.validate()
        if self.personal_limit_count:
            self.personal_limit_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.company_limit_count is not None:
            result['CompanyLimitCount'] = self.company_limit_count.to_map()
        if self.company_limit_type is not None:
            result['CompanyLimitType'] = self.company_limit_type
        if self.description is not None:
            result['Description'] = self.description
        if self.match_mode is not None:
            result['MatchMode'] = self.match_mode
        if self.name is not None:
            result['Name'] = self.name
        if self.personal_limit_count is not None:
            result['PersonalLimitCount'] = self.personal_limit_count.to_map()
        if self.personal_limit_type is not None:
            result['PersonalLimitType'] = self.personal_limit_type
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.status is not None:
            result['Status'] = self.status
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        if self.whitelist is not None:
            result['Whitelist'] = self.whitelist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompanyLimitCount') is not None:
            temp_model = CreateRegistrationPolicyRequestCompanyLimitCount()
            self.company_limit_count = temp_model.from_map(m['CompanyLimitCount'])
        if m.get('CompanyLimitType') is not None:
            self.company_limit_type = m.get('CompanyLimitType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MatchMode') is not None:
            self.match_mode = m.get('MatchMode')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PersonalLimitCount') is not None:
            temp_model = CreateRegistrationPolicyRequestPersonalLimitCount()
            self.personal_limit_count = temp_model.from_map(m['PersonalLimitCount'])
        if m.get('PersonalLimitType') is not None:
            self.personal_limit_type = m.get('PersonalLimitType')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        if m.get('Whitelist') is not None:
            self.whitelist = m.get('Whitelist')
        return self


class CreateRegistrationPolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        company_limit_count_shrink: str = None,
        company_limit_type: str = None,
        description: str = None,
        match_mode: str = None,
        name: str = None,
        personal_limit_count_shrink: str = None,
        personal_limit_type: str = None,
        priority: int = None,
        status: str = None,
        user_group_ids: List[str] = None,
        whitelist: List[str] = None,
    ):
        self.company_limit_count_shrink = company_limit_count_shrink
        # This parameter is required.
        self.company_limit_type = company_limit_type
        self.description = description
        # This parameter is required.
        self.match_mode = match_mode
        # This parameter is required.
        self.name = name
        self.personal_limit_count_shrink = personal_limit_count_shrink
        # This parameter is required.
        self.personal_limit_type = personal_limit_type
        self.priority = priority
        # This parameter is required.
        self.status = status
        self.user_group_ids = user_group_ids
        self.whitelist = whitelist

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.company_limit_count_shrink is not None:
            result['CompanyLimitCount'] = self.company_limit_count_shrink
        if self.company_limit_type is not None:
            result['CompanyLimitType'] = self.company_limit_type
        if self.description is not None:
            result['Description'] = self.description
        if self.match_mode is not None:
            result['MatchMode'] = self.match_mode
        if self.name is not None:
            result['Name'] = self.name
        if self.personal_limit_count_shrink is not None:
            result['PersonalLimitCount'] = self.personal_limit_count_shrink
        if self.personal_limit_type is not None:
            result['PersonalLimitType'] = self.personal_limit_type
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.status is not None:
            result['Status'] = self.status
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        if self.whitelist is not None:
            result['Whitelist'] = self.whitelist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompanyLimitCount') is not None:
            self.company_limit_count_shrink = m.get('CompanyLimitCount')
        if m.get('CompanyLimitType') is not None:
            self.company_limit_type = m.get('CompanyLimitType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MatchMode') is not None:
            self.match_mode = m.get('MatchMode')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PersonalLimitCount') is not None:
            self.personal_limit_count_shrink = m.get('PersonalLimitCount')
        if m.get('PersonalLimitType') is not None:
            self.personal_limit_type = m.get('PersonalLimitType')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        if m.get('Whitelist') is not None:
            self.whitelist = m.get('Whitelist')
        return self


class CreateRegistrationPolicyResponseBodyPolicyLimitDetailLimitCount(TeaModel):
    def __init__(
        self,
        all: int = None,
        mobile: int = None,
        pc: int = None,
    ):
        self.all = all
        self.mobile = mobile
        self.pc = pc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all is not None:
            result['All'] = self.all
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.pc is not None:
            result['PC'] = self.pc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('All') is not None:
            self.all = m.get('All')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('PC') is not None:
            self.pc = m.get('PC')
        return self


class CreateRegistrationPolicyResponseBodyPolicyLimitDetail(TeaModel):
    def __init__(
        self,
        device_belong: str = None,
        limit_count: CreateRegistrationPolicyResponseBodyPolicyLimitDetailLimitCount = None,
        limit_type: str = None,
    ):
        self.device_belong = device_belong
        self.limit_count = limit_count
        self.limit_type = limit_type

    def validate(self):
        if self.limit_count:
            self.limit_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_belong is not None:
            result['DeviceBelong'] = self.device_belong
        if self.limit_count is not None:
            result['LimitCount'] = self.limit_count.to_map()
        if self.limit_type is not None:
            result['LimitType'] = self.limit_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceBelong') is not None:
            self.device_belong = m.get('DeviceBelong')
        if m.get('LimitCount') is not None:
            temp_model = CreateRegistrationPolicyResponseBodyPolicyLimitDetailLimitCount()
            self.limit_count = temp_model.from_map(m['LimitCount'])
        if m.get('LimitType') is not None:
            self.limit_type = m.get('LimitType')
        return self


class CreateRegistrationPolicyResponseBodyPolicy(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        limit_detail: List[CreateRegistrationPolicyResponseBodyPolicyLimitDetail] = None,
        match_mode: str = None,
        name: str = None,
        policy_id: str = None,
        priority: str = None,
        status: str = None,
        user_group_ids: List[str] = None,
        whitelist: List[str] = None,
    ):
        self.create_time = create_time
        self.description = description
        self.limit_detail = limit_detail
        self.match_mode = match_mode
        self.name = name
        self.policy_id = policy_id
        self.priority = priority
        self.status = status
        self.user_group_ids = user_group_ids
        self.whitelist = whitelist

    def validate(self):
        if self.limit_detail:
            for k in self.limit_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        result['LimitDetail'] = []
        if self.limit_detail is not None:
            for k in self.limit_detail:
                result['LimitDetail'].append(k.to_map() if k else None)
        if self.match_mode is not None:
            result['MatchMode'] = self.match_mode
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.status is not None:
            result['Status'] = self.status
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        if self.whitelist is not None:
            result['Whitelist'] = self.whitelist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.limit_detail = []
        if m.get('LimitDetail') is not None:
            for k in m.get('LimitDetail'):
                temp_model = CreateRegistrationPolicyResponseBodyPolicyLimitDetail()
                self.limit_detail.append(temp_model.from_map(k))
        if m.get('MatchMode') is not None:
            self.match_mode = m.get('MatchMode')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        if m.get('Whitelist') is not None:
            self.whitelist = m.get('Whitelist')
        return self


class CreateRegistrationPolicyResponseBody(TeaModel):
    def __init__(
        self,
        policy: CreateRegistrationPolicyResponseBodyPolicy = None,
        request_id: str = None,
    ):
        self.policy = policy
        self.request_id = request_id

    def validate(self):
        if self.policy:
            self.policy.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy is not None:
            result['Policy'] = self.policy.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Policy') is not None:
            temp_model = CreateRegistrationPolicyResponseBodyPolicy()
            self.policy = temp_model.from_map(m['Policy'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRegistrationPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRegistrationPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRegistrationPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUserGroupRequestAttributes(TeaModel):
    def __init__(
        self,
        idp_id: int = None,
        relation: str = None,
        user_group_type: str = None,
        value: str = None,
    ):
        self.idp_id = idp_id
        # This parameter is required.
        self.relation = relation
        # This parameter is required.
        self.user_group_type = user_group_type
        # This parameter is required.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idp_id is not None:
            result['IdpId'] = self.idp_id
        if self.relation is not None:
            result['Relation'] = self.relation
        if self.user_group_type is not None:
            result['UserGroupType'] = self.user_group_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdpId') is not None:
            self.idp_id = m.get('IdpId')
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        if m.get('UserGroupType') is not None:
            self.user_group_type = m.get('UserGroupType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateUserGroupRequest(TeaModel):
    def __init__(
        self,
        attributes: List[CreateUserGroupRequestAttributes] = None,
        description: str = None,
        name: str = None,
    ):
        # This parameter is required.
        self.attributes = attributes
        self.description = description
        # This parameter is required.
        self.name = name

    def validate(self):
        if self.attributes:
            for k in self.attributes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attributes'] = []
        if self.attributes is not None:
            for k in self.attributes:
                result['Attributes'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attributes = []
        if m.get('Attributes') is not None:
            for k in m.get('Attributes'):
                temp_model = CreateUserGroupRequestAttributes()
                self.attributes.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateUserGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_group_id: str = None,
    ):
        self.request_id = request_id
        self.user_group_id = user_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class CreateUserGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUserGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUserGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWmBaseImageRequestImageControlLogoVisibleControlMargin(TeaModel):
    def __init__(
        self,
        bottom: float = None,
        left: float = None,
        right: float = None,
        top: float = None,
    ):
        self.bottom = bottom
        self.left = left
        self.right = right
        self.top = top

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bottom is not None:
            result['Bottom'] = self.bottom
        if self.left is not None:
            result['Left'] = self.left
        if self.right is not None:
            result['Right'] = self.right
        if self.top is not None:
            result['Top'] = self.top
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bottom') is not None:
            self.bottom = m.get('Bottom')
        if m.get('Left') is not None:
            self.left = m.get('Left')
        if m.get('Right') is not None:
            self.right = m.get('Right')
        if m.get('Top') is not None:
            self.top = m.get('Top')
        return self


class CreateWmBaseImageRequestImageControlLogoVisibleControl(TeaModel):
    def __init__(
        self,
        angle: int = None,
        enhance: bool = None,
        logo_base_64: str = None,
        margin: CreateWmBaseImageRequestImageControlLogoVisibleControlMargin = None,
        mode: str = None,
        opacity: int = None,
        pos_ax: float = None,
        pos_ay: float = None,
        pos_x: int = None,
        pos_y: int = None,
        space_x: int = None,
        space_y: int = None,
        visible: bool = None,
    ):
        self.angle = angle
        self.enhance = enhance
        self.logo_base_64 = logo_base_64
        self.margin = margin
        self.mode = mode
        self.opacity = opacity
        self.pos_ax = pos_ax
        self.pos_ay = pos_ay
        self.pos_x = pos_x
        self.pos_y = pos_y
        self.space_x = space_x
        self.space_y = space_y
        self.visible = visible

    def validate(self):
        if self.margin:
            self.margin.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.angle is not None:
            result['Angle'] = self.angle
        if self.enhance is not None:
            result['Enhance'] = self.enhance
        if self.logo_base_64 is not None:
            result['LogoBase64'] = self.logo_base_64
        if self.margin is not None:
            result['Margin'] = self.margin.to_map()
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.opacity is not None:
            result['Opacity'] = self.opacity
        if self.pos_ax is not None:
            result['PosAx'] = self.pos_ax
        if self.pos_ay is not None:
            result['PosAy'] = self.pos_ay
        if self.pos_x is not None:
            result['PosX'] = self.pos_x
        if self.pos_y is not None:
            result['PosY'] = self.pos_y
        if self.space_x is not None:
            result['SpaceX'] = self.space_x
        if self.space_y is not None:
            result['SpaceY'] = self.space_y
        if self.visible is not None:
            result['Visible'] = self.visible
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Angle') is not None:
            self.angle = m.get('Angle')
        if m.get('Enhance') is not None:
            self.enhance = m.get('Enhance')
        if m.get('LogoBase64') is not None:
            self.logo_base_64 = m.get('LogoBase64')
        if m.get('Margin') is not None:
            temp_model = CreateWmBaseImageRequestImageControlLogoVisibleControlMargin()
            self.margin = temp_model.from_map(m['Margin'])
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Opacity') is not None:
            self.opacity = m.get('Opacity')
        if m.get('PosAx') is not None:
            self.pos_ax = m.get('PosAx')
        if m.get('PosAy') is not None:
            self.pos_ay = m.get('PosAy')
        if m.get('PosX') is not None:
            self.pos_x = m.get('PosX')
        if m.get('PosY') is not None:
            self.pos_y = m.get('PosY')
        if m.get('SpaceX') is not None:
            self.space_x = m.get('SpaceX')
        if m.get('SpaceY') is not None:
            self.space_y = m.get('SpaceY')
        if m.get('Visible') is not None:
            self.visible = m.get('Visible')
        return self


class CreateWmBaseImageRequestImageControlTextVisibleControlMargin(TeaModel):
    def __init__(
        self,
        bottom: float = None,
        left: float = None,
        right: float = None,
        top: float = None,
    ):
        self.bottom = bottom
        self.left = left
        self.right = right
        self.top = top

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bottom is not None:
            result['Bottom'] = self.bottom
        if self.left is not None:
            result['Left'] = self.left
        if self.right is not None:
            result['Right'] = self.right
        if self.top is not None:
            result['Top'] = self.top
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bottom') is not None:
            self.bottom = m.get('Bottom')
        if m.get('Left') is not None:
            self.left = m.get('Left')
        if m.get('Right') is not None:
            self.right = m.get('Right')
        if m.get('Top') is not None:
            self.top = m.get('Top')
        return self


class CreateWmBaseImageRequestImageControlTextVisibleControl(TeaModel):
    def __init__(
        self,
        angle: int = None,
        font_color: str = None,
        font_size: int = None,
        margin: CreateWmBaseImageRequestImageControlTextVisibleControlMargin = None,
        mode: str = None,
        opacity: int = None,
        pos_ax: float = None,
        pos_ay: float = None,
        pos_x: int = None,
        pos_y: int = None,
        space_x: int = None,
        space_y: int = None,
        visible: bool = None,
        visible_text: str = None,
    ):
        self.angle = angle
        self.font_color = font_color
        self.font_size = font_size
        self.margin = margin
        self.mode = mode
        self.opacity = opacity
        self.pos_ax = pos_ax
        self.pos_ay = pos_ay
        self.pos_x = pos_x
        self.pos_y = pos_y
        self.space_x = space_x
        self.space_y = space_y
        self.visible = visible
        self.visible_text = visible_text

    def validate(self):
        if self.margin:
            self.margin.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.angle is not None:
            result['Angle'] = self.angle
        if self.font_color is not None:
            result['FontColor'] = self.font_color
        if self.font_size is not None:
            result['FontSize'] = self.font_size
        if self.margin is not None:
            result['Margin'] = self.margin.to_map()
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.opacity is not None:
            result['Opacity'] = self.opacity
        if self.pos_ax is not None:
            result['PosAx'] = self.pos_ax
        if self.pos_ay is not None:
            result['PosAy'] = self.pos_ay
        if self.pos_x is not None:
            result['PosX'] = self.pos_x
        if self.pos_y is not None:
            result['PosY'] = self.pos_y
        if self.space_x is not None:
            result['SpaceX'] = self.space_x
        if self.space_y is not None:
            result['SpaceY'] = self.space_y
        if self.visible is not None:
            result['Visible'] = self.visible
        if self.visible_text is not None:
            result['VisibleText'] = self.visible_text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Angle') is not None:
            self.angle = m.get('Angle')
        if m.get('FontColor') is not None:
            self.font_color = m.get('FontColor')
        if m.get('FontSize') is not None:
            self.font_size = m.get('FontSize')
        if m.get('Margin') is not None:
            temp_model = CreateWmBaseImageRequestImageControlTextVisibleControlMargin()
            self.margin = temp_model.from_map(m['Margin'])
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Opacity') is not None:
            self.opacity = m.get('Opacity')
        if m.get('PosAx') is not None:
            self.pos_ax = m.get('PosAx')
        if m.get('PosAy') is not None:
            self.pos_ay = m.get('PosAy')
        if m.get('PosX') is not None:
            self.pos_x = m.get('PosX')
        if m.get('PosY') is not None:
            self.pos_y = m.get('PosY')
        if m.get('SpaceX') is not None:
            self.space_x = m.get('SpaceX')
        if m.get('SpaceY') is not None:
            self.space_y = m.get('SpaceY')
        if m.get('Visible') is not None:
            self.visible = m.get('Visible')
        if m.get('VisibleText') is not None:
            self.visible_text = m.get('VisibleText')
        return self


class CreateWmBaseImageRequestImageControl(TeaModel):
    def __init__(
        self,
        logo_visible_control: CreateWmBaseImageRequestImageControlLogoVisibleControl = None,
        text_visible_control: CreateWmBaseImageRequestImageControlTextVisibleControl = None,
    ):
        self.logo_visible_control = logo_visible_control
        self.text_visible_control = text_visible_control

    def validate(self):
        if self.logo_visible_control:
            self.logo_visible_control.validate()
        if self.text_visible_control:
            self.text_visible_control.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logo_visible_control is not None:
            result['LogoVisibleControl'] = self.logo_visible_control.to_map()
        if self.text_visible_control is not None:
            result['TextVisibleControl'] = self.text_visible_control.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogoVisibleControl') is not None:
            temp_model = CreateWmBaseImageRequestImageControlLogoVisibleControl()
            self.logo_visible_control = temp_model.from_map(m['LogoVisibleControl'])
        if m.get('TextVisibleControl') is not None:
            temp_model = CreateWmBaseImageRequestImageControlTextVisibleControl()
            self.text_visible_control = temp_model.from_map(m['TextVisibleControl'])
        return self


class CreateWmBaseImageRequest(TeaModel):
    def __init__(
        self,
        height: int = None,
        image_control: CreateWmBaseImageRequestImageControl = None,
        opacity: int = None,
        scale: int = None,
        width: int = None,
        wm_info_bytes_b64: str = None,
        wm_info_size: int = None,
        wm_info_uint: str = None,
        wm_type: str = None,
        comment: str = None,
    ):
        # This parameter is required.
        self.height = height
        self.image_control = image_control
        # This parameter is required.
        self.opacity = opacity
        # This parameter is required.
        self.scale = scale
        # This parameter is required.
        self.width = width
        self.wm_info_bytes_b64 = wm_info_bytes_b64
        self.wm_info_size = wm_info_size
        self.wm_info_uint = wm_info_uint
        # This parameter is required.
        self.wm_type = wm_type
        self.comment = comment

    def validate(self):
        if self.image_control:
            self.image_control.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.height is not None:
            result['Height'] = self.height
        if self.image_control is not None:
            result['ImageControl'] = self.image_control.to_map()
        if self.opacity is not None:
            result['Opacity'] = self.opacity
        if self.scale is not None:
            result['Scale'] = self.scale
        if self.width is not None:
            result['Width'] = self.width
        if self.wm_info_bytes_b64 is not None:
            result['WmInfoBytesB64'] = self.wm_info_bytes_b64
        if self.wm_info_size is not None:
            result['WmInfoSize'] = self.wm_info_size
        if self.wm_info_uint is not None:
            result['WmInfoUint'] = self.wm_info_uint
        if self.wm_type is not None:
            result['WmType'] = self.wm_type
        if self.comment is not None:
            result['comment'] = self.comment
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ImageControl') is not None:
            temp_model = CreateWmBaseImageRequestImageControl()
            self.image_control = temp_model.from_map(m['ImageControl'])
        if m.get('Opacity') is not None:
            self.opacity = m.get('Opacity')
        if m.get('Scale') is not None:
            self.scale = m.get('Scale')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('WmInfoBytesB64') is not None:
            self.wm_info_bytes_b64 = m.get('WmInfoBytesB64')
        if m.get('WmInfoSize') is not None:
            self.wm_info_size = m.get('WmInfoSize')
        if m.get('WmInfoUint') is not None:
            self.wm_info_uint = m.get('WmInfoUint')
        if m.get('WmType') is not None:
            self.wm_type = m.get('WmType')
        if m.get('comment') is not None:
            self.comment = m.get('comment')
        return self


class CreateWmBaseImageShrinkRequest(TeaModel):
    def __init__(
        self,
        height: int = None,
        image_control_shrink: str = None,
        opacity: int = None,
        scale: int = None,
        width: int = None,
        wm_info_bytes_b64: str = None,
        wm_info_size: int = None,
        wm_info_uint: str = None,
        wm_type: str = None,
        comment: str = None,
    ):
        # This parameter is required.
        self.height = height
        self.image_control_shrink = image_control_shrink
        # This parameter is required.
        self.opacity = opacity
        # This parameter is required.
        self.scale = scale
        # This parameter is required.
        self.width = width
        self.wm_info_bytes_b64 = wm_info_bytes_b64
        self.wm_info_size = wm_info_size
        self.wm_info_uint = wm_info_uint
        # This parameter is required.
        self.wm_type = wm_type
        self.comment = comment

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.height is not None:
            result['Height'] = self.height
        if self.image_control_shrink is not None:
            result['ImageControl'] = self.image_control_shrink
        if self.opacity is not None:
            result['Opacity'] = self.opacity
        if self.scale is not None:
            result['Scale'] = self.scale
        if self.width is not None:
            result['Width'] = self.width
        if self.wm_info_bytes_b64 is not None:
            result['WmInfoBytesB64'] = self.wm_info_bytes_b64
        if self.wm_info_size is not None:
            result['WmInfoSize'] = self.wm_info_size
        if self.wm_info_uint is not None:
            result['WmInfoUint'] = self.wm_info_uint
        if self.wm_type is not None:
            result['WmType'] = self.wm_type
        if self.comment is not None:
            result['comment'] = self.comment
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ImageControl') is not None:
            self.image_control_shrink = m.get('ImageControl')
        if m.get('Opacity') is not None:
            self.opacity = m.get('Opacity')
        if m.get('Scale') is not None:
            self.scale = m.get('Scale')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('WmInfoBytesB64') is not None:
            self.wm_info_bytes_b64 = m.get('WmInfoBytesB64')
        if m.get('WmInfoSize') is not None:
            self.wm_info_size = m.get('WmInfoSize')
        if m.get('WmInfoUint') is not None:
            self.wm_info_uint = m.get('WmInfoUint')
        if m.get('WmType') is not None:
            self.wm_type = m.get('WmType')
        if m.get('comment') is not None:
            self.comment = m.get('comment')
        return self


class CreateWmBaseImageResponseBodyData(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        image_url: str = None,
        image_url_exp: int = None,
    ):
        self.image_id = image_id
        self.image_url = image_url
        self.image_url_exp = image_url_exp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.image_url_exp is not None:
            result['ImageUrlExp'] = self.image_url_exp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('ImageUrlExp') is not None:
            self.image_url_exp = m.get('ImageUrlExp')
        return self


class CreateWmBaseImageResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateWmBaseImageResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateWmBaseImageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateWmBaseImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWmBaseImageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWmBaseImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWmEmbedTaskRequestCsvControl(TeaModel):
    def __init__(
        self,
        embed_bits_number_in_each_time: int = None,
        embed_column: int = None,
        embed_density: str = None,
        embed_precision: int = None,
        embed_time_position: str = None,
        method: str = None,
        time_format: str = None,
    ):
        self.embed_bits_number_in_each_time = embed_bits_number_in_each_time
        self.embed_column = embed_column
        self.embed_density = embed_density
        self.embed_precision = embed_precision
        self.embed_time_position = embed_time_position
        self.method = method
        self.time_format = time_format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.embed_bits_number_in_each_time is not None:
            result['EmbedBitsNumberInEachTime'] = self.embed_bits_number_in_each_time
        if self.embed_column is not None:
            result['EmbedColumn'] = self.embed_column
        if self.embed_density is not None:
            result['EmbedDensity'] = self.embed_density
        if self.embed_precision is not None:
            result['EmbedPrecision'] = self.embed_precision
        if self.embed_time_position is not None:
            result['EmbedTimePosition'] = self.embed_time_position
        if self.method is not None:
            result['Method'] = self.method
        if self.time_format is not None:
            result['TimeFormat'] = self.time_format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EmbedBitsNumberInEachTime') is not None:
            self.embed_bits_number_in_each_time = m.get('EmbedBitsNumberInEachTime')
        if m.get('EmbedColumn') is not None:
            self.embed_column = m.get('EmbedColumn')
        if m.get('EmbedDensity') is not None:
            self.embed_density = m.get('EmbedDensity')
        if m.get('EmbedPrecision') is not None:
            self.embed_precision = m.get('EmbedPrecision')
        if m.get('EmbedTimePosition') is not None:
            self.embed_time_position = m.get('EmbedTimePosition')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('TimeFormat') is not None:
            self.time_format = m.get('TimeFormat')
        return self


class CreateWmEmbedTaskRequestDocumentControlBackgroundControlBgInvisibleControl(TeaModel):
    def __init__(
        self,
        opacity: int = None,
    ):
        self.opacity = opacity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.opacity is not None:
            result['Opacity'] = self.opacity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Opacity') is not None:
            self.opacity = m.get('Opacity')
        return self


class CreateWmEmbedTaskRequestDocumentControlBackgroundControlBgVisibleControl(TeaModel):
    def __init__(
        self,
        angle: int = None,
        font_color: str = None,
        font_size: int = None,
        horizontal_number: int = None,
        mode: str = None,
        opacity: int = None,
        pos_x: str = None,
        pos_y: str = None,
        vertical_number: int = None,
        visible_text: str = None,
    ):
        self.angle = angle
        self.font_color = font_color
        self.font_size = font_size
        self.horizontal_number = horizontal_number
        self.mode = mode
        self.opacity = opacity
        self.pos_x = pos_x
        self.pos_y = pos_y
        self.vertical_number = vertical_number
        self.visible_text = visible_text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.angle is not None:
            result['Angle'] = self.angle
        if self.font_color is not None:
            result['FontColor'] = self.font_color
        if self.font_size is not None:
            result['FontSize'] = self.font_size
        if self.horizontal_number is not None:
            result['HorizontalNumber'] = self.horizontal_number
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.opacity is not None:
            result['Opacity'] = self.opacity
        if self.pos_x is not None:
            result['PosX'] = self.pos_x
        if self.pos_y is not None:
            result['PosY'] = self.pos_y
        if self.vertical_number is not None:
            result['VerticalNumber'] = self.vertical_number
        if self.visible_text is not None:
            result['VisibleText'] = self.visible_text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Angle') is not None:
            self.angle = m.get('Angle')
        if m.get('FontColor') is not None:
            self.font_color = m.get('FontColor')
        if m.get('FontSize') is not None:
            self.font_size = m.get('FontSize')
        if m.get('HorizontalNumber') is not None:
            self.horizontal_number = m.get('HorizontalNumber')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Opacity') is not None:
            self.opacity = m.get('Opacity')
        if m.get('PosX') is not None:
            self.pos_x = m.get('PosX')
        if m.get('PosY') is not None:
            self.pos_y = m.get('PosY')
        if m.get('VerticalNumber') is not None:
            self.vertical_number = m.get('VerticalNumber')
        if m.get('VisibleText') is not None:
            self.visible_text = m.get('VisibleText')
        return self


class CreateWmEmbedTaskRequestDocumentControlBackgroundControl(TeaModel):
    def __init__(
        self,
        bg_add_invisible: bool = None,
        bg_add_visible: bool = None,
        bg_invisible_control: CreateWmEmbedTaskRequestDocumentControlBackgroundControlBgInvisibleControl = None,
        bg_visible_control: CreateWmEmbedTaskRequestDocumentControlBackgroundControlBgVisibleControl = None,
    ):
        self.bg_add_invisible = bg_add_invisible
        self.bg_add_visible = bg_add_visible
        self.bg_invisible_control = bg_invisible_control
        self.bg_visible_control = bg_visible_control

    def validate(self):
        if self.bg_invisible_control:
            self.bg_invisible_control.validate()
        if self.bg_visible_control:
            self.bg_visible_control.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bg_add_invisible is not None:
            result['BgAddInvisible'] = self.bg_add_invisible
        if self.bg_add_visible is not None:
            result['BgAddVisible'] = self.bg_add_visible
        if self.bg_invisible_control is not None:
            result['BgInvisibleControl'] = self.bg_invisible_control.to_map()
        if self.bg_visible_control is not None:
            result['BgVisibleControl'] = self.bg_visible_control.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BgAddInvisible') is not None:
            self.bg_add_invisible = m.get('BgAddInvisible')
        if m.get('BgAddVisible') is not None:
            self.bg_add_visible = m.get('BgAddVisible')
        if m.get('BgInvisibleControl') is not None:
            temp_model = CreateWmEmbedTaskRequestDocumentControlBackgroundControlBgInvisibleControl()
            self.bg_invisible_control = temp_model.from_map(m['BgInvisibleControl'])
        if m.get('BgVisibleControl') is not None:
            temp_model = CreateWmEmbedTaskRequestDocumentControlBackgroundControlBgVisibleControl()
            self.bg_visible_control = temp_model.from_map(m['BgVisibleControl'])
        return self


class CreateWmEmbedTaskRequestDocumentControl(TeaModel):
    def __init__(
        self,
        background_control: CreateWmEmbedTaskRequestDocumentControlBackgroundControl = None,
        invisible_anti_all_copy: bool = None,
        invisible_anti_text_copy: bool = None,
    ):
        self.background_control = background_control
        self.invisible_anti_all_copy = invisible_anti_all_copy
        self.invisible_anti_text_copy = invisible_anti_text_copy

    def validate(self):
        if self.background_control:
            self.background_control.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.background_control is not None:
            result['BackgroundControl'] = self.background_control.to_map()
        if self.invisible_anti_all_copy is not None:
            result['InvisibleAntiAllCopy'] = self.invisible_anti_all_copy
        if self.invisible_anti_text_copy is not None:
            result['InvisibleAntiTextCopy'] = self.invisible_anti_text_copy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackgroundControl') is not None:
            temp_model = CreateWmEmbedTaskRequestDocumentControlBackgroundControl()
            self.background_control = temp_model.from_map(m['BackgroundControl'])
        if m.get('InvisibleAntiAllCopy') is not None:
            self.invisible_anti_all_copy = m.get('InvisibleAntiAllCopy')
        if m.get('InvisibleAntiTextCopy') is not None:
            self.invisible_anti_text_copy = m.get('InvisibleAntiTextCopy')
        return self


class CreateWmEmbedTaskRequest(TeaModel):
    def __init__(
        self,
        csv_control: CreateWmEmbedTaskRequestCsvControl = None,
        document_control: CreateWmEmbedTaskRequestDocumentControl = None,
        file_url: str = None,
        filename: str = None,
        image_embed_jpeg_quality: int = None,
        image_embed_level: int = None,
        video_bitrate: str = None,
        video_is_long: bool = None,
        wm_info_bytes_b64: str = None,
        wm_info_size: int = None,
        wm_info_uint: str = None,
        wm_type: str = None,
    ):
        self.csv_control = csv_control
        self.document_control = document_control
        # This parameter is required.
        self.file_url = file_url
        # This parameter is required.
        self.filename = filename
        self.image_embed_jpeg_quality = image_embed_jpeg_quality
        self.image_embed_level = image_embed_level
        self.video_bitrate = video_bitrate
        self.video_is_long = video_is_long
        self.wm_info_bytes_b64 = wm_info_bytes_b64
        self.wm_info_size = wm_info_size
        self.wm_info_uint = wm_info_uint
        # This parameter is required.
        self.wm_type = wm_type

    def validate(self):
        if self.csv_control:
            self.csv_control.validate()
        if self.document_control:
            self.document_control.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.csv_control is not None:
            result['CsvControl'] = self.csv_control.to_map()
        if self.document_control is not None:
            result['DocumentControl'] = self.document_control.to_map()
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.filename is not None:
            result['Filename'] = self.filename
        if self.image_embed_jpeg_quality is not None:
            result['ImageEmbedJpegQuality'] = self.image_embed_jpeg_quality
        if self.image_embed_level is not None:
            result['ImageEmbedLevel'] = self.image_embed_level
        if self.video_bitrate is not None:
            result['VideoBitrate'] = self.video_bitrate
        if self.video_is_long is not None:
            result['VideoIsLong'] = self.video_is_long
        if self.wm_info_bytes_b64 is not None:
            result['WmInfoBytesB64'] = self.wm_info_bytes_b64
        if self.wm_info_size is not None:
            result['WmInfoSize'] = self.wm_info_size
        if self.wm_info_uint is not None:
            result['WmInfoUint'] = self.wm_info_uint
        if self.wm_type is not None:
            result['WmType'] = self.wm_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CsvControl') is not None:
            temp_model = CreateWmEmbedTaskRequestCsvControl()
            self.csv_control = temp_model.from_map(m['CsvControl'])
        if m.get('DocumentControl') is not None:
            temp_model = CreateWmEmbedTaskRequestDocumentControl()
            self.document_control = temp_model.from_map(m['DocumentControl'])
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('Filename') is not None:
            self.filename = m.get('Filename')
        if m.get('ImageEmbedJpegQuality') is not None:
            self.image_embed_jpeg_quality = m.get('ImageEmbedJpegQuality')
        if m.get('ImageEmbedLevel') is not None:
            self.image_embed_level = m.get('ImageEmbedLevel')
        if m.get('VideoBitrate') is not None:
            self.video_bitrate = m.get('VideoBitrate')
        if m.get('VideoIsLong') is not None:
            self.video_is_long = m.get('VideoIsLong')
        if m.get('WmInfoBytesB64') is not None:
            self.wm_info_bytes_b64 = m.get('WmInfoBytesB64')
        if m.get('WmInfoSize') is not None:
            self.wm_info_size = m.get('WmInfoSize')
        if m.get('WmInfoUint') is not None:
            self.wm_info_uint = m.get('WmInfoUint')
        if m.get('WmType') is not None:
            self.wm_type = m.get('WmType')
        return self


class CreateWmEmbedTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        csv_control_shrink: str = None,
        document_control_shrink: str = None,
        file_url: str = None,
        filename: str = None,
        image_embed_jpeg_quality: int = None,
        image_embed_level: int = None,
        video_bitrate: str = None,
        video_is_long: bool = None,
        wm_info_bytes_b64: str = None,
        wm_info_size: int = None,
        wm_info_uint: str = None,
        wm_type: str = None,
    ):
        self.csv_control_shrink = csv_control_shrink
        self.document_control_shrink = document_control_shrink
        # This parameter is required.
        self.file_url = file_url
        # This parameter is required.
        self.filename = filename
        self.image_embed_jpeg_quality = image_embed_jpeg_quality
        self.image_embed_level = image_embed_level
        self.video_bitrate = video_bitrate
        self.video_is_long = video_is_long
        self.wm_info_bytes_b64 = wm_info_bytes_b64
        self.wm_info_size = wm_info_size
        self.wm_info_uint = wm_info_uint
        # This parameter is required.
        self.wm_type = wm_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.csv_control_shrink is not None:
            result['CsvControl'] = self.csv_control_shrink
        if self.document_control_shrink is not None:
            result['DocumentControl'] = self.document_control_shrink
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.filename is not None:
            result['Filename'] = self.filename
        if self.image_embed_jpeg_quality is not None:
            result['ImageEmbedJpegQuality'] = self.image_embed_jpeg_quality
        if self.image_embed_level is not None:
            result['ImageEmbedLevel'] = self.image_embed_level
        if self.video_bitrate is not None:
            result['VideoBitrate'] = self.video_bitrate
        if self.video_is_long is not None:
            result['VideoIsLong'] = self.video_is_long
        if self.wm_info_bytes_b64 is not None:
            result['WmInfoBytesB64'] = self.wm_info_bytes_b64
        if self.wm_info_size is not None:
            result['WmInfoSize'] = self.wm_info_size
        if self.wm_info_uint is not None:
            result['WmInfoUint'] = self.wm_info_uint
        if self.wm_type is not None:
            result['WmType'] = self.wm_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CsvControl') is not None:
            self.csv_control_shrink = m.get('CsvControl')
        if m.get('DocumentControl') is not None:
            self.document_control_shrink = m.get('DocumentControl')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('Filename') is not None:
            self.filename = m.get('Filename')
        if m.get('ImageEmbedJpegQuality') is not None:
            self.image_embed_jpeg_quality = m.get('ImageEmbedJpegQuality')
        if m.get('ImageEmbedLevel') is not None:
            self.image_embed_level = m.get('ImageEmbedLevel')
        if m.get('VideoBitrate') is not None:
            self.video_bitrate = m.get('VideoBitrate')
        if m.get('VideoIsLong') is not None:
            self.video_is_long = m.get('VideoIsLong')
        if m.get('WmInfoBytesB64') is not None:
            self.wm_info_bytes_b64 = m.get('WmInfoBytesB64')
        if m.get('WmInfoSize') is not None:
            self.wm_info_size = m.get('WmInfoSize')
        if m.get('WmInfoUint') is not None:
            self.wm_info_uint = m.get('WmInfoUint')
        if m.get('WmType') is not None:
            self.wm_type = m.get('WmType')
        return self


class CreateWmEmbedTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateWmEmbedTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateWmEmbedTaskResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateWmEmbedTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateWmEmbedTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWmEmbedTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWmEmbedTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWmExtractTaskRequestCsvControl(TeaModel):
    def __init__(
        self,
        embed_bits_number_in_each_time: int = None,
        embed_column: int = None,
        embed_precision: int = None,
        embed_time_position: str = None,
        method: str = None,
        time_format: str = None,
    ):
        # The timestamp watermark parameter that specifies how much information a single timestamp holds. You must keep the value of this parameter consistent for watermark embedding and watermark extraction. Otherwise, the extraction fails.
        self.embed_bits_number_in_each_time = embed_bits_number_in_each_time
        # The lossy embedding control parameter that specifies columns to be modified You must keep the value of this parameter consistent for watermark embedding and watermark extraction. Otherwise, the extraction fails.
        self.embed_column = embed_column
        # The lossy embedding control parameter that specifies the modification precision. You must keep the value of this parameter consistent for watermark embedding and watermark extraction. Otherwise, the extraction fails.
        self.embed_precision = embed_precision
        # The timestamp watermark parameter that specifies the embedding position of the timestamp watermarks. You must keep the value of this parameter consistent for watermark embedding and watermark extraction. Otherwise, the extraction fails.
        self.embed_time_position = embed_time_position
        # The CSV watermark embedding method. You must keep the value of this parameter consistent for watermark embedding and watermark extraction. Otherwise, the extraction fails.
        self.method = method
        # The timestamp watermark parameter that specifies the timestamp format. You must keep the value of this parameter consistent for watermark embedding and watermark extraction. Otherwise, the extraction fails.
        self.time_format = time_format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.embed_bits_number_in_each_time is not None:
            result['EmbedBitsNumberInEachTime'] = self.embed_bits_number_in_each_time
        if self.embed_column is not None:
            result['EmbedColumn'] = self.embed_column
        if self.embed_precision is not None:
            result['EmbedPrecision'] = self.embed_precision
        if self.embed_time_position is not None:
            result['EmbedTimePosition'] = self.embed_time_position
        if self.method is not None:
            result['Method'] = self.method
        if self.time_format is not None:
            result['TimeFormat'] = self.time_format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EmbedBitsNumberInEachTime') is not None:
            self.embed_bits_number_in_each_time = m.get('EmbedBitsNumberInEachTime')
        if m.get('EmbedColumn') is not None:
            self.embed_column = m.get('EmbedColumn')
        if m.get('EmbedPrecision') is not None:
            self.embed_precision = m.get('EmbedPrecision')
        if m.get('EmbedTimePosition') is not None:
            self.embed_time_position = m.get('EmbedTimePosition')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('TimeFormat') is not None:
            self.time_format = m.get('TimeFormat')
        return self


class CreateWmExtractTaskRequestImageExtractParamsOpenApi(TeaModel):
    def __init__(
        self,
        src_logo_base_64: str = None,
    ):
        self.src_logo_base_64 = src_logo_base_64

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.src_logo_base_64 is not None:
            result['SrcLogoBase64'] = self.src_logo_base_64
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SrcLogoBase64') is not None:
            self.src_logo_base_64 = m.get('SrcLogoBase64')
        return self


class CreateWmExtractTaskRequest(TeaModel):
    def __init__(
        self,
        csv_control: CreateWmExtractTaskRequestCsvControl = None,
        document_is_capture: bool = None,
        file_url: str = None,
        filename: str = None,
        image_extract_params_open_api: CreateWmExtractTaskRequestImageExtractParamsOpenApi = None,
        is_client_embed: bool = None,
        video_is_long: bool = None,
        video_speed: str = None,
        wm_info_size: int = None,
        wm_type: str = None,
    ):
        # The CSV watermark control parameter. You must keep the value of this parameter consistent for watermark embedding and watermark extraction. Otherwise, the extraction fails.
        self.csv_control = csv_control
        # The document watermark parameter that specifies whether the file to be extracted is a screenshot of a document with a background watermark added. The system determines whether to use the extraction logic for document background watermarks based on whether the file to be extracted is an image file. By default, you do not need to configure this parameter. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.document_is_capture = document_is_capture
        # The URL used to download the file to be extracted. The URL must be accessible over the Internet.
        # 
        # This parameter is required.
        self.file_url = file_url
        # The name of the file to be extracted. The system needs to check the file type based on the file name extension.
        # 
        # This parameter is required.
        self.filename = filename
        self.image_extract_params_open_api = image_extract_params_open_api
        self.is_client_embed = is_client_embed
        # The watermark parameter for videos that specifies whether to use the long video watermark SDK. Default value: false. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.video_is_long = video_is_long
        # The watermark parameter for long videos that specifies the video speed factor. The value can be a floating-point number or a string. Default value: 1. This parameter indicates the speed at which a watermark is added or the time-stretching rate for videos after a watermark is added.
        self.video_speed = video_speed
        # The watermark information size. Default value: 32. You must keep the value of this parameter consistent for watermark embedding and watermark extraction. For example, if a 40-bit watermark is used for watermark embedding, you must set this parameter to 40 for watermark extraction.
        self.wm_info_size = wm_info_size
        # The watermark type. Valid values:
        # 
        # *   **PureWebappInvisible**: web page watermark
        # *   **PureAppInvisible**: app watermark
        # *   **PureScreenInvisible**: screen watermark
        # *   **PureDocument**: document watermark
        # *   **PureImage**: image watermark
        # *   **PureAudio**: audio watermark
        # *   **PureVideo**: video watermark
        # *   **AigcWebappInvisible**: artificial intelligence generated content (AIGC)-based webpage watermark
        # *   **AigcAppInvisible**: AIGC-based app watermark
        # *   **AigcScreenInvisible**: AIGC-based screen watermark
        # *   **AigcDocument**: AIGC-based document watermark
        # *   **AigcImage**: AIGC-based image watermark
        # *   **AigcAudio**: AIGC-based audio watermark
        # *   **AigcVideo**: AIGC-based video watermark
        # 
        # This parameter is required.
        self.wm_type = wm_type

    def validate(self):
        if self.csv_control:
            self.csv_control.validate()
        if self.image_extract_params_open_api:
            self.image_extract_params_open_api.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.csv_control is not None:
            result['CsvControl'] = self.csv_control.to_map()
        if self.document_is_capture is not None:
            result['DocumentIsCapture'] = self.document_is_capture
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.filename is not None:
            result['Filename'] = self.filename
        if self.image_extract_params_open_api is not None:
            result['ImageExtractParamsOpenApi'] = self.image_extract_params_open_api.to_map()
        if self.is_client_embed is not None:
            result['IsClientEmbed'] = self.is_client_embed
        if self.video_is_long is not None:
            result['VideoIsLong'] = self.video_is_long
        if self.video_speed is not None:
            result['VideoSpeed'] = self.video_speed
        if self.wm_info_size is not None:
            result['WmInfoSize'] = self.wm_info_size
        if self.wm_type is not None:
            result['WmType'] = self.wm_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CsvControl') is not None:
            temp_model = CreateWmExtractTaskRequestCsvControl()
            self.csv_control = temp_model.from_map(m['CsvControl'])
        if m.get('DocumentIsCapture') is not None:
            self.document_is_capture = m.get('DocumentIsCapture')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('Filename') is not None:
            self.filename = m.get('Filename')
        if m.get('ImageExtractParamsOpenApi') is not None:
            temp_model = CreateWmExtractTaskRequestImageExtractParamsOpenApi()
            self.image_extract_params_open_api = temp_model.from_map(m['ImageExtractParamsOpenApi'])
        if m.get('IsClientEmbed') is not None:
            self.is_client_embed = m.get('IsClientEmbed')
        if m.get('VideoIsLong') is not None:
            self.video_is_long = m.get('VideoIsLong')
        if m.get('VideoSpeed') is not None:
            self.video_speed = m.get('VideoSpeed')
        if m.get('WmInfoSize') is not None:
            self.wm_info_size = m.get('WmInfoSize')
        if m.get('WmType') is not None:
            self.wm_type = m.get('WmType')
        return self


class CreateWmExtractTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        csv_control_shrink: str = None,
        document_is_capture: bool = None,
        file_url: str = None,
        filename: str = None,
        image_extract_params_open_api_shrink: str = None,
        is_client_embed: bool = None,
        video_is_long: bool = None,
        video_speed: str = None,
        wm_info_size: int = None,
        wm_type: str = None,
    ):
        # The CSV watermark control parameter. You must keep the value of this parameter consistent for watermark embedding and watermark extraction. Otherwise, the extraction fails.
        self.csv_control_shrink = csv_control_shrink
        # The document watermark parameter that specifies whether the file to be extracted is a screenshot of a document with a background watermark added. The system determines whether to use the extraction logic for document background watermarks based on whether the file to be extracted is an image file. By default, you do not need to configure this parameter. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.document_is_capture = document_is_capture
        # The URL used to download the file to be extracted. The URL must be accessible over the Internet.
        # 
        # This parameter is required.
        self.file_url = file_url
        # The name of the file to be extracted. The system needs to check the file type based on the file name extension.
        # 
        # This parameter is required.
        self.filename = filename
        self.image_extract_params_open_api_shrink = image_extract_params_open_api_shrink
        self.is_client_embed = is_client_embed
        # The watermark parameter for videos that specifies whether to use the long video watermark SDK. Default value: false. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.video_is_long = video_is_long
        # The watermark parameter for long videos that specifies the video speed factor. The value can be a floating-point number or a string. Default value: 1. This parameter indicates the speed at which a watermark is added or the time-stretching rate for videos after a watermark is added.
        self.video_speed = video_speed
        # The watermark information size. Default value: 32. You must keep the value of this parameter consistent for watermark embedding and watermark extraction. For example, if a 40-bit watermark is used for watermark embedding, you must set this parameter to 40 for watermark extraction.
        self.wm_info_size = wm_info_size
        # The watermark type. Valid values:
        # 
        # *   **PureWebappInvisible**: web page watermark
        # *   **PureAppInvisible**: app watermark
        # *   **PureScreenInvisible**: screen watermark
        # *   **PureDocument**: document watermark
        # *   **PureImage**: image watermark
        # *   **PureAudio**: audio watermark
        # *   **PureVideo**: video watermark
        # *   **AigcWebappInvisible**: artificial intelligence generated content (AIGC)-based webpage watermark
        # *   **AigcAppInvisible**: AIGC-based app watermark
        # *   **AigcScreenInvisible**: AIGC-based screen watermark
        # *   **AigcDocument**: AIGC-based document watermark
        # *   **AigcImage**: AIGC-based image watermark
        # *   **AigcAudio**: AIGC-based audio watermark
        # *   **AigcVideo**: AIGC-based video watermark
        # 
        # This parameter is required.
        self.wm_type = wm_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.csv_control_shrink is not None:
            result['CsvControl'] = self.csv_control_shrink
        if self.document_is_capture is not None:
            result['DocumentIsCapture'] = self.document_is_capture
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.filename is not None:
            result['Filename'] = self.filename
        if self.image_extract_params_open_api_shrink is not None:
            result['ImageExtractParamsOpenApi'] = self.image_extract_params_open_api_shrink
        if self.is_client_embed is not None:
            result['IsClientEmbed'] = self.is_client_embed
        if self.video_is_long is not None:
            result['VideoIsLong'] = self.video_is_long
        if self.video_speed is not None:
            result['VideoSpeed'] = self.video_speed
        if self.wm_info_size is not None:
            result['WmInfoSize'] = self.wm_info_size
        if self.wm_type is not None:
            result['WmType'] = self.wm_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CsvControl') is not None:
            self.csv_control_shrink = m.get('CsvControl')
        if m.get('DocumentIsCapture') is not None:
            self.document_is_capture = m.get('DocumentIsCapture')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('Filename') is not None:
            self.filename = m.get('Filename')
        if m.get('ImageExtractParamsOpenApi') is not None:
            self.image_extract_params_open_api_shrink = m.get('ImageExtractParamsOpenApi')
        if m.get('IsClientEmbed') is not None:
            self.is_client_embed = m.get('IsClientEmbed')
        if m.get('VideoIsLong') is not None:
            self.video_is_long = m.get('VideoIsLong')
        if m.get('VideoSpeed') is not None:
            self.video_speed = m.get('VideoSpeed')
        if m.get('WmInfoSize') is not None:
            self.wm_info_size = m.get('WmInfoSize')
        if m.get('WmType') is not None:
            self.wm_type = m.get('WmType')
        return self


class CreateWmExtractTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        # The task ID. You can use task IDs to query task results.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateWmExtractTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateWmExtractTaskResponseBodyData = None,
        request_id: str = None,
    ):
        # The information about the watermark extraction task.
        self.data = data
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateWmExtractTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateWmExtractTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWmExtractTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWmExtractTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWmInfoMappingRequest(TeaModel):
    def __init__(
        self,
        wm_info_bytes_b64: str = None,
        wm_info_size: int = None,
        wm_type: str = None,
    ):
        # This parameter is required.
        self.wm_info_bytes_b64 = wm_info_bytes_b64
        self.wm_info_size = wm_info_size
        # This parameter is required.
        self.wm_type = wm_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.wm_info_bytes_b64 is not None:
            result['WmInfoBytesB64'] = self.wm_info_bytes_b64
        if self.wm_info_size is not None:
            result['WmInfoSize'] = self.wm_info_size
        if self.wm_type is not None:
            result['WmType'] = self.wm_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WmInfoBytesB64') is not None:
            self.wm_info_bytes_b64 = m.get('WmInfoBytesB64')
        if m.get('WmInfoSize') is not None:
            self.wm_info_size = m.get('WmInfoSize')
        if m.get('WmType') is not None:
            self.wm_type = m.get('WmType')
        return self


class CreateWmInfoMappingResponseBodyData(TeaModel):
    def __init__(
        self,
        wm_info_uint: int = None,
    ):
        self.wm_info_uint = wm_info_uint

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.wm_info_uint is not None:
            result['WmInfoUint'] = self.wm_info_uint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WmInfoUint') is not None:
            self.wm_info_uint = m.get('WmInfoUint')
        return self


class CreateWmInfoMappingResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateWmInfoMappingResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateWmInfoMappingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateWmInfoMappingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWmInfoMappingResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWmInfoMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteApprovalProcessesRequest(TeaModel):
    def __init__(
        self,
        process_ids: List[str] = None,
    ):
        # This parameter is required.
        self.process_ids = process_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.process_ids is not None:
            result['ProcessIds'] = self.process_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProcessIds') is not None:
            self.process_ids = m.get('ProcessIds')
        return self


class DeleteApprovalProcessesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteApprovalProcessesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteApprovalProcessesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteApprovalProcessesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClientUserRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
    ):
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteClientUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteClientUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteClientUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteClientUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDynamicRouteRequest(TeaModel):
    def __init__(
        self,
        dynamic_route_id: str = None,
    ):
        # This parameter is required.
        self.dynamic_route_id = dynamic_route_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_route_id is not None:
            result['DynamicRouteId'] = self.dynamic_route_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DynamicRouteId') is not None:
            self.dynamic_route_id = m.get('DynamicRouteId')
        return self


class DeleteDynamicRouteResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDynamicRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDynamicRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDynamicRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEnterpriseAcceleratePolicyRequest(TeaModel):
    def __init__(
        self,
        eap_id: str = None,
    ):
        # This parameter is required.
        self.eap_id = eap_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.eap_id is not None:
            result['EapId'] = self.eap_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EapId') is not None:
            self.eap_id = m.get('EapId')
        return self


class DeleteEnterpriseAcceleratePolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEnterpriseAcceleratePolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEnterpriseAcceleratePolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEnterpriseAcceleratePolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEnterpriseAccelerateTargetRequest(TeaModel):
    def __init__(
        self,
        eap_id: str = None,
        target: List[str] = None,
    ):
        # This parameter is required.
        self.eap_id = eap_id
        # This parameter is required.
        self.target = target

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.eap_id is not None:
            result['EapId'] = self.eap_id
        if self.target is not None:
            result['Target'] = self.target
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EapId') is not None:
            self.eap_id = m.get('EapId')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        return self


class DeleteEnterpriseAccelerateTargetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEnterpriseAccelerateTargetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEnterpriseAccelerateTargetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEnterpriseAccelerateTargetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIdpDepartmentRequest(TeaModel):
    def __init__(
        self,
        department_id: str = None,
        idp_config_id: str = None,
    ):
        # This parameter is required.
        self.department_id = department_id
        # This parameter is required.
        self.idp_config_id = idp_config_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.idp_config_id is not None:
            result['IdpConfigId'] = self.idp_config_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('IdpConfigId') is not None:
            self.idp_config_id = m.get('IdpConfigId')
        return self


class DeleteIdpDepartmentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIdpDepartmentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteIdpDepartmentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteIdpDepartmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOtpConfigRequest(TeaModel):
    def __init__(
        self,
        username: str = None,
    ):
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class DeleteOtpConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteOtpConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteOtpConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOtpConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePrivateAccessApplicationRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
    ):
        # This parameter is required.
        self.application_id = application_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class DeletePrivateAccessApplicationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePrivateAccessApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePrivateAccessApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePrivateAccessApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePrivateAccessPolicyRequest(TeaModel):
    def __init__(
        self,
        policy_id: str = None,
    ):
        # This parameter is required.
        self.policy_id = policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        return self


class DeletePrivateAccessPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePrivateAccessPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePrivateAccessPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePrivateAccessPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePrivateAccessTagRequest(TeaModel):
    def __init__(
        self,
        tag_id: str = None,
    ):
        # This parameter is required.
        self.tag_id = tag_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        return self


class DeletePrivateAccessTagResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePrivateAccessTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePrivateAccessTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePrivateAccessTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRegistrationPoliciesRequest(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
    ):
        # This parameter is required.
        self.policy_ids = policy_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        return self


class DeleteRegistrationPoliciesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRegistrationPoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRegistrationPoliciesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRegistrationPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUserDevicesRequest(TeaModel):
    def __init__(
        self,
        device_tags: List[str] = None,
    ):
        self.device_tags = device_tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_tags is not None:
            result['DeviceTags'] = self.device_tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceTags') is not None:
            self.device_tags = m.get('DeviceTags')
        return self


class DeleteUserDevicesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUserDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteUserDevicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUserDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUserGroupRequest(TeaModel):
    def __init__(
        self,
        user_group_id: str = None,
    ):
        # This parameter is required.
        self.user_group_id = user_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class DeleteUserGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUserGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteUserGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUserGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetachApplication2ConnectorRequest(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        connector_id: str = None,
    ):
        # This parameter is required.
        self.application_ids = application_ids
        # ConnectorID。
        # 
        # This parameter is required.
        self.connector_id = connector_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.connector_id is not None:
            result['ConnectorId'] = self.connector_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('ConnectorId') is not None:
            self.connector_id = m.get('ConnectorId')
        return self


class DetachApplication2ConnectorShrinkRequest(TeaModel):
    def __init__(
        self,
        application_ids_shrink: str = None,
        connector_id: str = None,
    ):
        # This parameter is required.
        self.application_ids_shrink = application_ids_shrink
        # ConnectorID。
        # 
        # This parameter is required.
        self.connector_id = connector_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids_shrink is not None:
            result['ApplicationIds'] = self.application_ids_shrink
        if self.connector_id is not None:
            result['ConnectorId'] = self.connector_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids_shrink = m.get('ApplicationIds')
        if m.get('ConnectorId') is not None:
            self.connector_id = m.get('ConnectorId')
        return self


class DetachApplication2ConnectorResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DetachApplication2ConnectorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DetachApplication2ConnectorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DetachApplication2ConnectorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetachPolicy2ApprovalProcessRequest(TeaModel):
    def __init__(
        self,
        policy_id: str = None,
        policy_type: str = None,
        process_id: str = None,
    ):
        # This parameter is required.
        self.policy_id = policy_id
        # This parameter is required.
        self.policy_type = policy_type
        # This parameter is required.
        self.process_id = process_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        return self


class DetachPolicy2ApprovalProcessResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DetachPolicy2ApprovalProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DetachPolicy2ApprovalProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DetachPolicy2ApprovalProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableEnterpriseAcceleratePolicyRequest(TeaModel):
    def __init__(
        self,
        eap_id: str = None,
    ):
        # This parameter is required.
        self.eap_id = eap_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.eap_id is not None:
            result['EapId'] = self.eap_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EapId') is not None:
            self.eap_id = m.get('EapId')
        return self


class DisableEnterpriseAcceleratePolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableEnterpriseAcceleratePolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableEnterpriseAcceleratePolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableEnterpriseAcceleratePolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableEnterpriseAcceleratePolicyRequest(TeaModel):
    def __init__(
        self,
        eap_id: str = None,
    ):
        # This parameter is required.
        self.eap_id = eap_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.eap_id is not None:
            result['EapId'] = self.eap_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EapId') is not None:
            self.eap_id = m.get('EapId')
        return self


class EnableEnterpriseAcceleratePolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableEnterpriseAcceleratePolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableEnterpriseAcceleratePolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableEnterpriseAcceleratePolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportUserDevicesRequest(TeaModel):
    def __init__(
        self,
        app_statuses: List[str] = None,
        department: str = None,
        device_belong: str = None,
        device_statuses: List[str] = None,
        device_tags: List[str] = None,
        device_types: List[str] = None,
        dlp_statuses: List[str] = None,
        hostname: str = None,
        ia_statuses: List[str] = None,
        mac: str = None,
        nac_statuses: List[str] = None,
        pa_statuses: List[str] = None,
        sase_user_id: str = None,
        sharing_status: bool = None,
        username: str = None,
    ):
        self.app_statuses = app_statuses
        self.department = department
        self.device_belong = device_belong
        self.device_statuses = device_statuses
        self.device_tags = device_tags
        self.device_types = device_types
        self.dlp_statuses = dlp_statuses
        self.hostname = hostname
        self.ia_statuses = ia_statuses
        self.mac = mac
        self.nac_statuses = nac_statuses
        self.pa_statuses = pa_statuses
        self.sase_user_id = sase_user_id
        self.sharing_status = sharing_status
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_statuses is not None:
            result['AppStatuses'] = self.app_statuses
        if self.department is not None:
            result['Department'] = self.department
        if self.device_belong is not None:
            result['DeviceBelong'] = self.device_belong
        if self.device_statuses is not None:
            result['DeviceStatuses'] = self.device_statuses
        if self.device_tags is not None:
            result['DeviceTags'] = self.device_tags
        if self.device_types is not None:
            result['DeviceTypes'] = self.device_types
        if self.dlp_statuses is not None:
            result['DlpStatuses'] = self.dlp_statuses
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.ia_statuses is not None:
            result['IaStatuses'] = self.ia_statuses
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.nac_statuses is not None:
            result['NacStatuses'] = self.nac_statuses
        if self.pa_statuses is not None:
            result['PaStatuses'] = self.pa_statuses
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.sharing_status is not None:
            result['SharingStatus'] = self.sharing_status
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppStatuses') is not None:
            self.app_statuses = m.get('AppStatuses')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('DeviceBelong') is not None:
            self.device_belong = m.get('DeviceBelong')
        if m.get('DeviceStatuses') is not None:
            self.device_statuses = m.get('DeviceStatuses')
        if m.get('DeviceTags') is not None:
            self.device_tags = m.get('DeviceTags')
        if m.get('DeviceTypes') is not None:
            self.device_types = m.get('DeviceTypes')
        if m.get('DlpStatuses') is not None:
            self.dlp_statuses = m.get('DlpStatuses')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('IaStatuses') is not None:
            self.ia_statuses = m.get('IaStatuses')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('NacStatuses') is not None:
            self.nac_statuses = m.get('NacStatuses')
        if m.get('PaStatuses') is not None:
            self.pa_statuses = m.get('PaStatuses')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('SharingStatus') is not None:
            self.sharing_status = m.get('SharingStatus')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ExportUserDevicesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        signed_url: str = None,
    ):
        self.request_id = request_id
        self.signed_url = signed_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.signed_url is not None:
            result['SignedUrl'] = self.signed_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SignedUrl') is not None:
            self.signed_url = m.get('SignedUrl')
        return self


class ExportUserDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ExportUserDevicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExportUserDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetActiveIdpConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        description: str = None,
        id: str = None,
        name: str = None,
        type: str = None,
    ):
        self.description = description
        self.id = id
        self.name = name
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetActiveIdpConfigResponseBody(TeaModel):
    def __init__(
        self,
        data: GetActiveIdpConfigResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetActiveIdpConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetActiveIdpConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetActiveIdpConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetActiveIdpConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetApprovalRequest(TeaModel):
    def __init__(
        self,
        approval_id: str = None,
    ):
        # This parameter is required.
        self.approval_id = approval_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approval_id is not None:
            result['ApprovalId'] = self.approval_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApprovalId') is not None:
            self.approval_id = m.get('ApprovalId')
        return self


class GetApprovalResponseBodyApprovalApprovalProgressesOperators(TeaModel):
    def __init__(
        self,
        sase_user_id: str = None,
        username: str = None,
    ):
        self.sase_user_id = sase_user_id
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class GetApprovalResponseBodyApprovalApprovalProgresses(TeaModel):
    def __init__(
        self,
        action: str = None,
        comment: str = None,
        executor: str = None,
        operators: List[GetApprovalResponseBodyApprovalApprovalProgressesOperators] = None,
        status: str = None,
        timestamp: int = None,
    ):
        self.action = action
        self.comment = comment
        self.executor = executor
        self.operators = operators
        self.status = status
        self.timestamp = timestamp

    def validate(self):
        if self.operators:
            for k in self.operators:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.executor is not None:
            result['Executor'] = self.executor
        result['Operators'] = []
        if self.operators is not None:
            for k in self.operators:
                result['Operators'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Executor') is not None:
            self.executor = m.get('Executor')
        self.operators = []
        if m.get('Operators') is not None:
            for k in m.get('Operators'):
                temp_model = GetApprovalResponseBodyApprovalApprovalProgressesOperators()
                self.operators.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetApprovalResponseBodyApproval(TeaModel):
    def __init__(
        self,
        approval_detail: str = None,
        approval_id: str = None,
        approval_progresses: List[GetApprovalResponseBodyApprovalApprovalProgresses] = None,
        create_time: str = None,
        creator_department: str = None,
        creator_dev_tag: str = None,
        creator_user_id: str = None,
        creator_username: str = None,
        end_timestamp: int = None,
        policy_type: str = None,
        process_id: str = None,
        process_name: str = None,
        reason: str = None,
        schema_content: str = None,
        schema_id: str = None,
        schema_name: str = None,
        status: str = None,
    ):
        self.approval_detail = approval_detail
        self.approval_id = approval_id
        self.approval_progresses = approval_progresses
        self.create_time = create_time
        self.creator_department = creator_department
        self.creator_dev_tag = creator_dev_tag
        self.creator_user_id = creator_user_id
        self.creator_username = creator_username
        self.end_timestamp = end_timestamp
        self.policy_type = policy_type
        self.process_id = process_id
        self.process_name = process_name
        self.reason = reason
        self.schema_content = schema_content
        self.schema_id = schema_id
        self.schema_name = schema_name
        self.status = status

    def validate(self):
        if self.approval_progresses:
            for k in self.approval_progresses:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approval_detail is not None:
            result['ApprovalDetail'] = self.approval_detail
        if self.approval_id is not None:
            result['ApprovalId'] = self.approval_id
        result['ApprovalProgresses'] = []
        if self.approval_progresses is not None:
            for k in self.approval_progresses:
                result['ApprovalProgresses'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_department is not None:
            result['CreatorDepartment'] = self.creator_department
        if self.creator_dev_tag is not None:
            result['CreatorDevTag'] = self.creator_dev_tag
        if self.creator_user_id is not None:
            result['CreatorUserId'] = self.creator_user_id
        if self.creator_username is not None:
            result['CreatorUsername'] = self.creator_username
        if self.end_timestamp is not None:
            result['EndTimestamp'] = self.end_timestamp
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.schema_content is not None:
            result['SchemaContent'] = self.schema_content
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        if self.schema_name is not None:
            result['SchemaName'] = self.schema_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApprovalDetail') is not None:
            self.approval_detail = m.get('ApprovalDetail')
        if m.get('ApprovalId') is not None:
            self.approval_id = m.get('ApprovalId')
        self.approval_progresses = []
        if m.get('ApprovalProgresses') is not None:
            for k in m.get('ApprovalProgresses'):
                temp_model = GetApprovalResponseBodyApprovalApprovalProgresses()
                self.approval_progresses.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorDepartment') is not None:
            self.creator_department = m.get('CreatorDepartment')
        if m.get('CreatorDevTag') is not None:
            self.creator_dev_tag = m.get('CreatorDevTag')
        if m.get('CreatorUserId') is not None:
            self.creator_user_id = m.get('CreatorUserId')
        if m.get('CreatorUsername') is not None:
            self.creator_username = m.get('CreatorUsername')
        if m.get('EndTimestamp') is not None:
            self.end_timestamp = m.get('EndTimestamp')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('SchemaContent') is not None:
            self.schema_content = m.get('SchemaContent')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        if m.get('SchemaName') is not None:
            self.schema_name = m.get('SchemaName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetApprovalResponseBody(TeaModel):
    def __init__(
        self,
        approval: List[GetApprovalResponseBodyApproval] = None,
        request_id: str = None,
    ):
        self.approval = approval
        self.request_id = request_id

    def validate(self):
        if self.approval:
            for k in self.approval:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Approval'] = []
        if self.approval is not None:
            for k in self.approval:
                result['Approval'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.approval = []
        if m.get('Approval') is not None:
            for k in m.get('Approval'):
                temp_model = GetApprovalResponseBodyApproval()
                self.approval.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetApprovalResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetApprovalResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetApprovalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetApprovalProcessRequest(TeaModel):
    def __init__(
        self,
        process_id: str = None,
    ):
        # This parameter is required.
        self.process_id = process_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        return self


class GetApprovalProcessResponseBodyProcessAppUninstallPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class GetApprovalProcessResponseBodyProcessAppUninstallPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[GetApprovalProcessResponseBodyProcessAppUninstallPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = GetApprovalProcessResponseBodyProcessAppUninstallPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class GetApprovalProcessResponseBodyProcessDeviceRegistrationPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class GetApprovalProcessResponseBodyProcessDeviceRegistrationPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[GetApprovalProcessResponseBodyProcessDeviceRegistrationPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = GetApprovalProcessResponseBodyProcessDeviceRegistrationPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class GetApprovalProcessResponseBodyProcessDlpSendPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class GetApprovalProcessResponseBodyProcessDlpSendPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[GetApprovalProcessResponseBodyProcessDlpSendPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = GetApprovalProcessResponseBodyProcessDlpSendPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class GetApprovalProcessResponseBodyProcessDomainBlacklistPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class GetApprovalProcessResponseBodyProcessDomainBlacklistPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[GetApprovalProcessResponseBodyProcessDomainBlacklistPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = GetApprovalProcessResponseBodyProcessDomainBlacklistPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class GetApprovalProcessResponseBodyProcessDomainWhitelistPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class GetApprovalProcessResponseBodyProcessDomainWhitelistPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[GetApprovalProcessResponseBodyProcessDomainWhitelistPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = GetApprovalProcessResponseBodyProcessDomainWhitelistPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class GetApprovalProcessResponseBodyProcessEndpointHardeningPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class GetApprovalProcessResponseBodyProcessEndpointHardeningPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[GetApprovalProcessResponseBodyProcessEndpointHardeningPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = GetApprovalProcessResponseBodyProcessEndpointHardeningPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class GetApprovalProcessResponseBodyProcessPeripheralBlockPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class GetApprovalProcessResponseBodyProcessPeripheralBlockPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[GetApprovalProcessResponseBodyProcessPeripheralBlockPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = GetApprovalProcessResponseBodyProcessPeripheralBlockPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class GetApprovalProcessResponseBodyProcessProcessNodes(TeaModel):
    def __init__(
        self,
        sase_user_id: str = None,
        username: str = None,
    ):
        self.sase_user_id = sase_user_id
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class GetApprovalProcessResponseBodyProcessSoftwareBlockPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class GetApprovalProcessResponseBodyProcessSoftwareBlockPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[GetApprovalProcessResponseBodyProcessSoftwareBlockPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = GetApprovalProcessResponseBodyProcessSoftwareBlockPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class GetApprovalProcessResponseBodyProcessSoftwareHardeningPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class GetApprovalProcessResponseBodyProcessSoftwareHardeningPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[GetApprovalProcessResponseBodyProcessSoftwareHardeningPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = GetApprovalProcessResponseBodyProcessSoftwareHardeningPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class GetApprovalProcessResponseBodyProcess(TeaModel):
    def __init__(
        self,
        app_uninstall_policies: GetApprovalProcessResponseBodyProcessAppUninstallPolicies = None,
        approval_type: int = None,
        create_time: str = None,
        description: str = None,
        device_registration_policies: GetApprovalProcessResponseBodyProcessDeviceRegistrationPolicies = None,
        dlp_send_policies: GetApprovalProcessResponseBodyProcessDlpSendPolicies = None,
        domain_blacklist_policies: GetApprovalProcessResponseBodyProcessDomainBlacklistPolicies = None,
        domain_whitelist_policies: GetApprovalProcessResponseBodyProcessDomainWhitelistPolicies = None,
        endpoint_hardening_policies: GetApprovalProcessResponseBodyProcessEndpointHardeningPolicies = None,
        event_label: str = None,
        external_config: str = None,
        peripheral_block_policies: GetApprovalProcessResponseBodyProcessPeripheralBlockPolicies = None,
        process_id: str = None,
        process_name: str = None,
        process_nodes: List[List[GetApprovalProcessResponseBodyProcessProcessNodes]] = None,
        software_block_policies: GetApprovalProcessResponseBodyProcessSoftwareBlockPolicies = None,
        software_hardening_policies: GetApprovalProcessResponseBodyProcessSoftwareHardeningPolicies = None,
    ):
        self.app_uninstall_policies = app_uninstall_policies
        self.approval_type = approval_type
        self.create_time = create_time
        self.description = description
        self.device_registration_policies = device_registration_policies
        self.dlp_send_policies = dlp_send_policies
        self.domain_blacklist_policies = domain_blacklist_policies
        self.domain_whitelist_policies = domain_whitelist_policies
        self.endpoint_hardening_policies = endpoint_hardening_policies
        self.event_label = event_label
        self.external_config = external_config
        self.peripheral_block_policies = peripheral_block_policies
        self.process_id = process_id
        self.process_name = process_name
        self.process_nodes = process_nodes
        self.software_block_policies = software_block_policies
        self.software_hardening_policies = software_hardening_policies

    def validate(self):
        if self.app_uninstall_policies:
            self.app_uninstall_policies.validate()
        if self.device_registration_policies:
            self.device_registration_policies.validate()
        if self.dlp_send_policies:
            self.dlp_send_policies.validate()
        if self.domain_blacklist_policies:
            self.domain_blacklist_policies.validate()
        if self.domain_whitelist_policies:
            self.domain_whitelist_policies.validate()
        if self.endpoint_hardening_policies:
            self.endpoint_hardening_policies.validate()
        if self.peripheral_block_policies:
            self.peripheral_block_policies.validate()
        if self.process_nodes:
            for k in self.process_nodes:
                for k1 in k:
                    if k1:
                        k1.validate()
        if self.software_block_policies:
            self.software_block_policies.validate()
        if self.software_hardening_policies:
            self.software_hardening_policies.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_uninstall_policies is not None:
            result['AppUninstallPolicies'] = self.app_uninstall_policies.to_map()
        if self.approval_type is not None:
            result['ApprovalType'] = self.approval_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.device_registration_policies is not None:
            result['DeviceRegistrationPolicies'] = self.device_registration_policies.to_map()
        if self.dlp_send_policies is not None:
            result['DlpSendPolicies'] = self.dlp_send_policies.to_map()
        if self.domain_blacklist_policies is not None:
            result['DomainBlacklistPolicies'] = self.domain_blacklist_policies.to_map()
        if self.domain_whitelist_policies is not None:
            result['DomainWhitelistPolicies'] = self.domain_whitelist_policies.to_map()
        if self.endpoint_hardening_policies is not None:
            result['EndpointHardeningPolicies'] = self.endpoint_hardening_policies.to_map()
        if self.event_label is not None:
            result['EventLabel'] = self.event_label
        if self.external_config is not None:
            result['ExternalConfig'] = self.external_config
        if self.peripheral_block_policies is not None:
            result['PeripheralBlockPolicies'] = self.peripheral_block_policies.to_map()
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        result['ProcessNodes'] = []
        if self.process_nodes is not None:
            for k in self.process_nodes:
                l1 = []
                for k1 in k:
                    l1.append(k1.to_map() if k1 else None)
                result['ProcessNodes'].append(l1)
        if self.software_block_policies is not None:
            result['SoftwareBlockPolicies'] = self.software_block_policies.to_map()
        if self.software_hardening_policies is not None:
            result['SoftwareHardeningPolicies'] = self.software_hardening_policies.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppUninstallPolicies') is not None:
            temp_model = GetApprovalProcessResponseBodyProcessAppUninstallPolicies()
            self.app_uninstall_policies = temp_model.from_map(m['AppUninstallPolicies'])
        if m.get('ApprovalType') is not None:
            self.approval_type = m.get('ApprovalType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceRegistrationPolicies') is not None:
            temp_model = GetApprovalProcessResponseBodyProcessDeviceRegistrationPolicies()
            self.device_registration_policies = temp_model.from_map(m['DeviceRegistrationPolicies'])
        if m.get('DlpSendPolicies') is not None:
            temp_model = GetApprovalProcessResponseBodyProcessDlpSendPolicies()
            self.dlp_send_policies = temp_model.from_map(m['DlpSendPolicies'])
        if m.get('DomainBlacklistPolicies') is not None:
            temp_model = GetApprovalProcessResponseBodyProcessDomainBlacklistPolicies()
            self.domain_blacklist_policies = temp_model.from_map(m['DomainBlacklistPolicies'])
        if m.get('DomainWhitelistPolicies') is not None:
            temp_model = GetApprovalProcessResponseBodyProcessDomainWhitelistPolicies()
            self.domain_whitelist_policies = temp_model.from_map(m['DomainWhitelistPolicies'])
        if m.get('EndpointHardeningPolicies') is not None:
            temp_model = GetApprovalProcessResponseBodyProcessEndpointHardeningPolicies()
            self.endpoint_hardening_policies = temp_model.from_map(m['EndpointHardeningPolicies'])
        if m.get('EventLabel') is not None:
            self.event_label = m.get('EventLabel')
        if m.get('ExternalConfig') is not None:
            self.external_config = m.get('ExternalConfig')
        if m.get('PeripheralBlockPolicies') is not None:
            temp_model = GetApprovalProcessResponseBodyProcessPeripheralBlockPolicies()
            self.peripheral_block_policies = temp_model.from_map(m['PeripheralBlockPolicies'])
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        self.process_nodes = []
        if m.get('ProcessNodes') is not None:
            for k in m.get('ProcessNodes'):
                l1 = []
                for k1 in k:
                    temp_model = GetApprovalProcessResponseBodyProcessProcessNodes()
                    l1.append(temp_model.from_map(k1))
                self.process_nodes.append(l1)
        if m.get('SoftwareBlockPolicies') is not None:
            temp_model = GetApprovalProcessResponseBodyProcessSoftwareBlockPolicies()
            self.software_block_policies = temp_model.from_map(m['SoftwareBlockPolicies'])
        if m.get('SoftwareHardeningPolicies') is not None:
            temp_model = GetApprovalProcessResponseBodyProcessSoftwareHardeningPolicies()
            self.software_hardening_policies = temp_model.from_map(m['SoftwareHardeningPolicies'])
        return self


class GetApprovalProcessResponseBody(TeaModel):
    def __init__(
        self,
        process: GetApprovalProcessResponseBodyProcess = None,
        request_id: str = None,
    ):
        self.process = process
        self.request_id = request_id

    def validate(self):
        if self.process:
            self.process.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.process is not None:
            result['Process'] = self.process.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Process') is not None:
            temp_model = GetApprovalProcessResponseBodyProcess()
            self.process = temp_model.from_map(m['Process'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetApprovalProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetApprovalProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetApprovalProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetApprovalSchemaRequest(TeaModel):
    def __init__(
        self,
        schema_id: str = None,
    ):
        # This parameter is required.
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class GetApprovalSchemaResponseBodySchema(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        is_default: bool = None,
        policy_type: str = None,
        schema_content: str = None,
        schema_id: str = None,
        schema_name: str = None,
        schema_version: int = None,
    ):
        self.create_time = create_time
        self.description = description
        self.is_default = is_default
        self.policy_type = policy_type
        self.schema_content = schema_content
        self.schema_id = schema_id
        self.schema_name = schema_name
        self.schema_version = schema_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.schema_content is not None:
            result['SchemaContent'] = self.schema_content
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        if self.schema_name is not None:
            result['SchemaName'] = self.schema_name
        if self.schema_version is not None:
            result['SchemaVersion'] = self.schema_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('SchemaContent') is not None:
            self.schema_content = m.get('SchemaContent')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        if m.get('SchemaName') is not None:
            self.schema_name = m.get('SchemaName')
        if m.get('SchemaVersion') is not None:
            self.schema_version = m.get('SchemaVersion')
        return self


class GetApprovalSchemaResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        schema: GetApprovalSchemaResponseBodySchema = None,
    ):
        self.request_id = request_id
        self.schema = schema

    def validate(self):
        if self.schema:
            self.schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schema is not None:
            result['Schema'] = self.schema.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Schema') is not None:
            temp_model = GetApprovalSchemaResponseBodySchema()
            self.schema = temp_model.from_map(m['Schema'])
        return self


class GetApprovalSchemaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetApprovalSchemaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetApprovalSchemaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBootAndAntiUninstallPolicyResponseBodyStrategyBlockContentBlockTextEn(TeaModel):
    def __init__(
        self,
        content: str = None,
        main_button_text: str = None,
        minor_button_text: str = None,
        title: str = None,
    ):
        self.content = content
        self.main_button_text = main_button_text
        self.minor_button_text = minor_button_text
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.main_button_text is not None:
            result['MainButtonText'] = self.main_button_text
        if self.minor_button_text is not None:
            result['MinorButtonText'] = self.minor_button_text
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('MainButtonText') is not None:
            self.main_button_text = m.get('MainButtonText')
        if m.get('MinorButtonText') is not None:
            self.minor_button_text = m.get('MinorButtonText')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetBootAndAntiUninstallPolicyResponseBodyStrategyBlockContentBlockTextZh(TeaModel):
    def __init__(
        self,
        content: str = None,
        main_button_text: str = None,
        minor_button_text: str = None,
        title: str = None,
    ):
        self.content = content
        self.main_button_text = main_button_text
        self.minor_button_text = minor_button_text
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.main_button_text is not None:
            result['MainButtonText'] = self.main_button_text
        if self.minor_button_text is not None:
            result['MinorButtonText'] = self.minor_button_text
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('MainButtonText') is not None:
            self.main_button_text = m.get('MainButtonText')
        if m.get('MinorButtonText') is not None:
            self.minor_button_text = m.get('MinorButtonText')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetBootAndAntiUninstallPolicyResponseBodyStrategyBlockContent(TeaModel):
    def __init__(
        self,
        block_text_en: GetBootAndAntiUninstallPolicyResponseBodyStrategyBlockContentBlockTextEn = None,
        block_text_zh: GetBootAndAntiUninstallPolicyResponseBodyStrategyBlockContentBlockTextZh = None,
    ):
        self.block_text_en = block_text_en
        self.block_text_zh = block_text_zh

    def validate(self):
        if self.block_text_en:
            self.block_text_en.validate()
        if self.block_text_zh:
            self.block_text_zh.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_text_en is not None:
            result['BlockTextEn'] = self.block_text_en.to_map()
        if self.block_text_zh is not None:
            result['BlockTextZh'] = self.block_text_zh.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockTextEn') is not None:
            temp_model = GetBootAndAntiUninstallPolicyResponseBodyStrategyBlockContentBlockTextEn()
            self.block_text_en = temp_model.from_map(m['BlockTextEn'])
        if m.get('BlockTextZh') is not None:
            temp_model = GetBootAndAntiUninstallPolicyResponseBodyStrategyBlockContentBlockTextZh()
            self.block_text_zh = temp_model.from_map(m['BlockTextZh'])
        return self


class GetBootAndAntiUninstallPolicyResponseBodyStrategy(TeaModel):
    def __init__(
        self,
        allow_report: bool = None,
        block_content: GetBootAndAntiUninstallPolicyResponseBodyStrategyBlockContent = None,
        create_time: str = None,
        is_anti_uninstall: bool = None,
        is_boot: bool = None,
        policy_id: str = None,
        report_process_id: str = None,
        update_time: str = None,
        user_group_ids: List[str] = None,
        whitelist_users: List[str] = None,
    ):
        self.allow_report = allow_report
        self.block_content = block_content
        self.create_time = create_time
        self.is_anti_uninstall = is_anti_uninstall
        self.is_boot = is_boot
        self.policy_id = policy_id
        self.report_process_id = report_process_id
        self.update_time = update_time
        self.user_group_ids = user_group_ids
        self.whitelist_users = whitelist_users

    def validate(self):
        if self.block_content:
            self.block_content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_report is not None:
            result['AllowReport'] = self.allow_report
        if self.block_content is not None:
            result['BlockContent'] = self.block_content.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.is_anti_uninstall is not None:
            result['IsAntiUninstall'] = self.is_anti_uninstall
        if self.is_boot is not None:
            result['IsBoot'] = self.is_boot
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.report_process_id is not None:
            result['ReportProcessId'] = self.report_process_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        if self.whitelist_users is not None:
            result['WhitelistUsers'] = self.whitelist_users
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowReport') is not None:
            self.allow_report = m.get('AllowReport')
        if m.get('BlockContent') is not None:
            temp_model = GetBootAndAntiUninstallPolicyResponseBodyStrategyBlockContent()
            self.block_content = temp_model.from_map(m['BlockContent'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IsAntiUninstall') is not None:
            self.is_anti_uninstall = m.get('IsAntiUninstall')
        if m.get('IsBoot') is not None:
            self.is_boot = m.get('IsBoot')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('ReportProcessId') is not None:
            self.report_process_id = m.get('ReportProcessId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        if m.get('WhitelistUsers') is not None:
            self.whitelist_users = m.get('WhitelistUsers')
        return self


class GetBootAndAntiUninstallPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        strategy: GetBootAndAntiUninstallPolicyResponseBodyStrategy = None,
    ):
        self.request_id = request_id
        self.strategy = strategy

    def validate(self):
        if self.strategy:
            self.strategy.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.strategy is not None:
            result['Strategy'] = self.strategy.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Strategy') is not None:
            temp_model = GetBootAndAntiUninstallPolicyResponseBodyStrategy()
            self.strategy = temp_model.from_map(m['Strategy'])
        return self


class GetBootAndAntiUninstallPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetBootAndAntiUninstallPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetBootAndAntiUninstallPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetClientUserRequest(TeaModel):
    def __init__(
        self,
        idp_config_id: str = None,
        username: str = None,
    ):
        # This parameter is required.
        self.idp_config_id = idp_config_id
        # This parameter is required.
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idp_config_id is not None:
            result['IdpConfigId'] = self.idp_config_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdpConfigId') is not None:
            self.idp_config_id = m.get('IdpConfigId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class GetClientUserResponseBodyDataDepartment(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
    ):
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetClientUserResponseBodyData(TeaModel):
    def __init__(
        self,
        department: GetClientUserResponseBodyDataDepartment = None,
        department_id: str = None,
        description: str = None,
        email: str = None,
        id: str = None,
        idp_config_id: str = None,
        mobile_number: str = None,
        status: str = None,
        user_id: str = None,
        username: str = None,
    ):
        self.department = department
        self.department_id = department_id
        self.description = description
        self.email = email
        self.id = id
        self.idp_config_id = idp_config_id
        self.mobile_number = mobile_number
        self.status = status
        self.user_id = user_id
        self.username = username

    def validate(self):
        if self.department:
            self.department.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department is not None:
            result['Department'] = self.department.to_map()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.description is not None:
            result['Description'] = self.description
        if self.email is not None:
            result['Email'] = self.email
        if self.id is not None:
            result['Id'] = self.id
        if self.idp_config_id is not None:
            result['IdpConfigId'] = self.idp_config_id
        if self.mobile_number is not None:
            result['MobileNumber'] = self.mobile_number
        if self.status is not None:
            result['Status'] = self.status
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Department') is not None:
            temp_model = GetClientUserResponseBodyDataDepartment()
            self.department = temp_model.from_map(m['Department'])
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IdpConfigId') is not None:
            self.idp_config_id = m.get('IdpConfigId')
        if m.get('MobileNumber') is not None:
            self.mobile_number = m.get('MobileNumber')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class GetClientUserResponseBody(TeaModel):
    def __init__(
        self,
        data: GetClientUserResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetClientUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetClientUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetClientUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetClientUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDynamicRouteRequest(TeaModel):
    def __init__(
        self,
        dynamic_route_id: str = None,
    ):
        # This parameter is required.
        self.dynamic_route_id = dynamic_route_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_route_id is not None:
            result['DynamicRouteId'] = self.dynamic_route_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DynamicRouteId') is not None:
            self.dynamic_route_id = m.get('DynamicRouteId')
        return self


class GetDynamicRouteResponseBodyDynamicRoute(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        application_type: str = None,
        create_time: str = None,
        description: str = None,
        dynamic_route_id: str = None,
        dynamic_route_type: str = None,
        name: str = None,
        next_hop: str = None,
        priority: int = None,
        region_ids: List[str] = None,
        status: str = None,
        tag_ids: List[str] = None,
    ):
        self.application_ids = application_ids
        self.application_type = application_type
        self.create_time = create_time
        self.description = description
        self.dynamic_route_id = dynamic_route_id
        self.dynamic_route_type = dynamic_route_type
        self.name = name
        self.next_hop = next_hop
        self.priority = priority
        self.region_ids = region_ids
        self.status = status
        self.tag_ids = tag_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.application_type is not None:
            result['ApplicationType'] = self.application_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.dynamic_route_id is not None:
            result['DynamicRouteId'] = self.dynamic_route_id
        if self.dynamic_route_type is not None:
            result['DynamicRouteType'] = self.dynamic_route_type
        if self.name is not None:
            result['Name'] = self.name
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.region_ids is not None:
            result['RegionIds'] = self.region_ids
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_ids is not None:
            result['TagIds'] = self.tag_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('ApplicationType') is not None:
            self.application_type = m.get('ApplicationType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DynamicRouteId') is not None:
            self.dynamic_route_id = m.get('DynamicRouteId')
        if m.get('DynamicRouteType') is not None:
            self.dynamic_route_type = m.get('DynamicRouteType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RegionIds') is not None:
            self.region_ids = m.get('RegionIds')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagIds') is not None:
            self.tag_ids = m.get('TagIds')
        return self


class GetDynamicRouteResponseBody(TeaModel):
    def __init__(
        self,
        dynamic_route: GetDynamicRouteResponseBodyDynamicRoute = None,
        request_id: str = None,
    ):
        self.dynamic_route = dynamic_route
        self.request_id = request_id

    def validate(self):
        if self.dynamic_route:
            self.dynamic_route.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_route is not None:
            result['DynamicRoute'] = self.dynamic_route.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DynamicRoute') is not None:
            temp_model = GetDynamicRouteResponseBodyDynamicRoute()
            self.dynamic_route = temp_model.from_map(m['DynamicRoute'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDynamicRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDynamicRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDynamicRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetIdpConfigRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
    ):
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetIdpConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        access_key: str = None,
        access_key_secret: str = None,
        description: str = None,
        get_group_url: str = None,
        id: str = None,
        idp_metadata: str = None,
        mfa_config_type: str = None,
        mobile_login_type: str = None,
        mobile_mfa_config_type: str = None,
        multi_idp_info: str = None,
        name: str = None,
        pc_login_type: str = None,
        status: str = None,
        type: str = None,
        update_time: str = None,
        verify_aes_key: str = None,
        verify_token: str = None,
        verify_url: str = None,
    ):
        # AccessKey ID
        self.access_key = access_key
        # AccessKey Secret
        self.access_key_secret = access_key_secret
        self.description = description
        self.get_group_url = get_group_url
        self.id = id
        self.idp_metadata = idp_metadata
        self.mfa_config_type = mfa_config_type
        self.mobile_login_type = mobile_login_type
        self.mobile_mfa_config_type = mobile_mfa_config_type
        self.multi_idp_info = multi_idp_info
        self.name = name
        self.pc_login_type = pc_login_type
        self.status = status
        self.type = type
        self.update_time = update_time
        self.verify_aes_key = verify_aes_key
        self.verify_token = verify_token
        self.verify_url = verify_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key is not None:
            result['AccessKey'] = self.access_key
        if self.access_key_secret is not None:
            result['AccessKeySecret'] = self.access_key_secret
        if self.description is not None:
            result['Description'] = self.description
        if self.get_group_url is not None:
            result['GetGroupUrl'] = self.get_group_url
        if self.id is not None:
            result['Id'] = self.id
        if self.idp_metadata is not None:
            result['IdpMetadata'] = self.idp_metadata
        if self.mfa_config_type is not None:
            result['MfaConfigType'] = self.mfa_config_type
        if self.mobile_login_type is not None:
            result['MobileLoginType'] = self.mobile_login_type
        if self.mobile_mfa_config_type is not None:
            result['MobileMfaConfigType'] = self.mobile_mfa_config_type
        if self.multi_idp_info is not None:
            result['MultiIdpInfo'] = self.multi_idp_info
        if self.name is not None:
            result['Name'] = self.name
        if self.pc_login_type is not None:
            result['PcLoginType'] = self.pc_login_type
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.verify_aes_key is not None:
            result['VerifyAesKey'] = self.verify_aes_key
        if self.verify_token is not None:
            result['VerifyToken'] = self.verify_token
        if self.verify_url is not None:
            result['VerifyUrl'] = self.verify_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessKey') is not None:
            self.access_key = m.get('AccessKey')
        if m.get('AccessKeySecret') is not None:
            self.access_key_secret = m.get('AccessKeySecret')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GetGroupUrl') is not None:
            self.get_group_url = m.get('GetGroupUrl')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IdpMetadata') is not None:
            self.idp_metadata = m.get('IdpMetadata')
        if m.get('MfaConfigType') is not None:
            self.mfa_config_type = m.get('MfaConfigType')
        if m.get('MobileLoginType') is not None:
            self.mobile_login_type = m.get('MobileLoginType')
        if m.get('MobileMfaConfigType') is not None:
            self.mobile_mfa_config_type = m.get('MobileMfaConfigType')
        if m.get('MultiIdpInfo') is not None:
            self.multi_idp_info = m.get('MultiIdpInfo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PcLoginType') is not None:
            self.pc_login_type = m.get('PcLoginType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('VerifyAesKey') is not None:
            self.verify_aes_key = m.get('VerifyAesKey')
        if m.get('VerifyToken') is not None:
            self.verify_token = m.get('VerifyToken')
        if m.get('VerifyUrl') is not None:
            self.verify_url = m.get('VerifyUrl')
        return self


class GetIdpConfigResponseBody(TeaModel):
    def __init__(
        self,
        data: GetIdpConfigResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetIdpConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetIdpConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetIdpConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetIdpConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPrivateAccessApplicationRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
    ):
        # The ID of the office application. You can obtain the value by calling the following operations:
        # 
        # *   [ListPrivateAccessApplications](~~ListPrivateAccessApplications~~): queries office applications.
        # *   [CreatePrivateAccessApplication](~~CreatePrivateAccessApplication~~): creates an office application.
        # 
        # This parameter is required.
        self.application_id = application_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class GetPrivateAccessApplicationResponseBodyApplicationPortRanges(TeaModel):
    def __init__(
        self,
        begin: int = None,
        end: int = None,
    ):
        # The start port.
        self.begin = begin
        # The end port.
        self.end = end

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin is not None:
            result['Begin'] = self.begin
        if self.end is not None:
            result['End'] = self.end
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Begin') is not None:
            self.begin = m.get('Begin')
        if m.get('End') is not None:
            self.end = m.get('End')
        return self


class GetPrivateAccessApplicationResponseBodyApplication(TeaModel):
    def __init__(
        self,
        addresses: List[str] = None,
        application_id: str = None,
        auto_generated: int = None,
        browser_access_status: str = None,
        connector_ids: List[str] = None,
        create_time: str = None,
        description: str = None,
        l_7config: PAL7Config = None,
        l_7proxy_domain_automatic: str = None,
        l_7proxy_domain_custom: str = None,
        name: str = None,
        policy_ids: List[str] = None,
        port_ranges: List[GetPrivateAccessApplicationResponseBodyApplicationPortRanges] = None,
        protocol: str = None,
        status: str = None,
        tag_ids: List[str] = None,
    ):
        # The addresses of the office applications.
        self.addresses = addresses
        # The ID of the office application.
        self.application_id = application_id
        self.auto_generated = auto_generated
        # The browser access mode. Valid values:
        # 
        # *   **Enabled**\
        # *   **Disabled**\
        self.browser_access_status = browser_access_status
        # The IDs of connectors.
        self.connector_ids = connector_ids
        # The creation time of the office application.
        self.create_time = create_time
        # The description of the office application.
        self.description = description
        # The browser access mode parameter. The parameter indicates the configurations of Layer 7 applications.
        self.l_7config = l_7config
        # The browser access mode parameter. The parameter indicates the domain name that the proxy gateway uses.
        self.l_7proxy_domain_automatic = l_7proxy_domain_automatic
        # The browser access mode parameter. The parameter indicates the custom domain name of the proxy gateway.
        self.l_7proxy_domain_custom = l_7proxy_domain_custom
        # The name of the office application.
        self.name = name
        # The IDs of the private access policies.
        self.policy_ids = policy_ids
        # The port ranges of the office applications. Multiple port ranges cannot be duplicated or overlapped.
        self.port_ranges = port_ranges
        # The protocol that is used by the office application. Valid values:
        # 
        # *   **All**\
        # *   **TCP**\
        # *   **UDP**\
        self.protocol = protocol
        # The status of the office application. Valid values:
        # 
        # *   **Enabled**\
        # *   **Disabled**\
        self.status = status
        # The IDs of the tags for the office applications.
        self.tag_ids = tag_ids

    def validate(self):
        if self.l_7config:
            self.l_7config.validate()
        if self.port_ranges:
            for k in self.port_ranges:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addresses is not None:
            result['Addresses'] = self.addresses
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.auto_generated is not None:
            result['AutoGenerated'] = self.auto_generated
        if self.browser_access_status is not None:
            result['BrowserAccessStatus'] = self.browser_access_status
        if self.connector_ids is not None:
            result['ConnectorIds'] = self.connector_ids
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.l_7config is not None:
            result['L7Config'] = self.l_7config.to_map()
        if self.l_7proxy_domain_automatic is not None:
            result['L7ProxyDomainAutomatic'] = self.l_7proxy_domain_automatic
        if self.l_7proxy_domain_custom is not None:
            result['L7ProxyDomainCustom'] = self.l_7proxy_domain_custom
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        result['PortRanges'] = []
        if self.port_ranges is not None:
            for k in self.port_ranges:
                result['PortRanges'].append(k.to_map() if k else None)
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_ids is not None:
            result['TagIds'] = self.tag_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addresses') is not None:
            self.addresses = m.get('Addresses')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('AutoGenerated') is not None:
            self.auto_generated = m.get('AutoGenerated')
        if m.get('BrowserAccessStatus') is not None:
            self.browser_access_status = m.get('BrowserAccessStatus')
        if m.get('ConnectorIds') is not None:
            self.connector_ids = m.get('ConnectorIds')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('L7Config') is not None:
            temp_model = PAL7Config()
            self.l_7config = temp_model.from_map(m['L7Config'])
        if m.get('L7ProxyDomainAutomatic') is not None:
            self.l_7proxy_domain_automatic = m.get('L7ProxyDomainAutomatic')
        if m.get('L7ProxyDomainCustom') is not None:
            self.l_7proxy_domain_custom = m.get('L7ProxyDomainCustom')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        self.port_ranges = []
        if m.get('PortRanges') is not None:
            for k in m.get('PortRanges'):
                temp_model = GetPrivateAccessApplicationResponseBodyApplicationPortRanges()
                self.port_ranges.append(temp_model.from_map(k))
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagIds') is not None:
            self.tag_ids = m.get('TagIds')
        return self


class GetPrivateAccessApplicationResponseBody(TeaModel):
    def __init__(
        self,
        application: GetPrivateAccessApplicationResponseBodyApplication = None,
        request_id: str = None,
    ):
        # The office application.
        self.application = application
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.application:
            self.application.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application is not None:
            result['Application'] = self.application.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Application') is not None:
            temp_model = GetPrivateAccessApplicationResponseBodyApplication()
            self.application = temp_model.from_map(m['Application'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPrivateAccessApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPrivateAccessApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPrivateAccessApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPrivateAccessPolicyRequest(TeaModel):
    def __init__(
        self,
        policy_id: str = None,
    ):
        # Intranet access policy ID. The value can be obtained from:
        # - [ListPrivateAccessPolices](~~ListPrivateAccessPolices~~): Query multiple intranet access policies in bulk.
        # - [CreatePrivateAccessPolicy](~~CreatePrivateAccessPolicy~~): Create an intranet access policy.
        # 
        # This parameter is required.
        self.policy_id = policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        return self


class GetPrivateAccessPolicyResponseBodyPolicyCustomUserAttributes(TeaModel):
    def __init__(
        self,
        idp_id: int = None,
        relation: str = None,
        user_group_type: str = None,
        value: str = None,
    ):
        # The identity provider ID for the custom user group. This field is required when the custom user group type is **department**.
        self.idp_id = idp_id
        # Custom user group relationship. Values: - **Equal**: Equal to. - **Unequal**: Not equal to.
        self.relation = relation
        # Type of the custom user group. Values:
        # - **username**: Username.
        # - **department**: Department.
        # - **email**: Email.
        # - **telephone**: Telephone.
        self.user_group_type = user_group_type
        # The value of the custom user group attribute.
        # - When the user group type is **username**, it represents the value of the username. The length should be 1 to 128 characters, supporting Chinese and case-sensitive English letters, and can include numbers, periods (.), underscores (_), and hyphens (-).
        # - When the user group type is **department**, it represents the value of the department. For example: OU=Department1,OU=SASE DingTalk.
        # - When the user group type is **email**, it represents the value of the email. For example: username@example.com.
        # - When the user group type is **telephone**, it represents the value of the phone number. For example: 13900001234.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idp_id is not None:
            result['IdpId'] = self.idp_id
        if self.relation is not None:
            result['Relation'] = self.relation
        if self.user_group_type is not None:
            result['UserGroupType'] = self.user_group_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdpId') is not None:
            self.idp_id = m.get('IdpId')
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        if m.get('UserGroupType') is not None:
            self.user_group_type = m.get('UserGroupType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetPrivateAccessPolicyResponseBodyPolicy(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        application_type: str = None,
        create_time: str = None,
        custom_user_attributes: List[GetPrivateAccessPolicyResponseBodyPolicyCustomUserAttributes] = None,
        description: str = None,
        device_attribute_action: str = None,
        device_attribute_id: str = None,
        name: str = None,
        policy_action: str = None,
        policy_id: str = None,
        priority: int = None,
        status: str = None,
        tag_ids: List[str] = None,
        trigger_template_id: str = None,
        trusted_process_group_ids: List[str] = None,
        trusted_process_status: str = None,
        trusted_software_ids: List[str] = None,
        user_group_ids: List[str] = None,
        user_group_mode: str = None,
    ):
        # A collection of application IDs for the private access policy. This field has a value when the application type is Application.
        self.application_ids = application_ids
        # The application type of the private access policy. Possible values:
        # - **Application**: Application.
        # - **Tag**: Tag.
        self.application_type = application_type
        # Intranet access policy creation time.
        self.create_time = create_time
        # Collection of custom user group attributes. Multiple custom user group attributes are combined with an OR relationship and take effect as a set.
        self.custom_user_attributes = custom_user_attributes
        # Intranet access policy description.
        self.description = description
        # The action to take if the security baseline is not met. Possible values:
        # 
        # - **Block**: Block.
        # - **Observe**: Observe.
        self.device_attribute_action = device_attribute_action
        # The ID of the security baseline policy.
        self.device_attribute_id = device_attribute_id
        # Intranet access policy name.
        self.name = name
        # Intranet access policy action. Values:
        # - **Block**: Block.
        # - **Allow**: Allow.
        self.policy_action = policy_action
        # Intranet access policy ID.
        self.policy_id = policy_id
        # Intranet access policy priority. A value of 1 indicates the highest priority.
        self.priority = priority
        # Intranet access policy status. Values:
        # - **Enabled**: Enabled.
        # - **Disabled**: Disabled.
        self.status = status
        # A collection of tag IDs for the private access policy. This field has a value when the application type is Tag.
        self.tag_ids = tag_ids
        # The trigger template ID.
        self.trigger_template_id = trigger_template_id
        # A list of trusted process group IDs.
        self.trusted_process_group_ids = trusted_process_group_ids
        # The status of the trusted process switch. Possible values:
        # - **Enabled**: Enabled.
        # - **Disabled**: Disabled.
        self.trusted_process_status = trusted_process_status
        # A list of trusted software IDs.
        self.trusted_software_ids = trusted_software_ids
        # Collection of user group IDs for the intranet access policy. This field is populated when the user group type is Normal.
        self.user_group_ids = user_group_ids
        # User group type for the intranet access policy. Values:
        # - **Normal**: Normal user group.
        # - **Custom**: Custom user group.
        self.user_group_mode = user_group_mode

    def validate(self):
        if self.custom_user_attributes:
            for k in self.custom_user_attributes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.application_type is not None:
            result['ApplicationType'] = self.application_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['CustomUserAttributes'] = []
        if self.custom_user_attributes is not None:
            for k in self.custom_user_attributes:
                result['CustomUserAttributes'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.device_attribute_action is not None:
            result['DeviceAttributeAction'] = self.device_attribute_action
        if self.device_attribute_id is not None:
            result['DeviceAttributeId'] = self.device_attribute_id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_action is not None:
            result['PolicyAction'] = self.policy_action
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_ids is not None:
            result['TagIds'] = self.tag_ids
        if self.trigger_template_id is not None:
            result['TriggerTemplateId'] = self.trigger_template_id
        if self.trusted_process_group_ids is not None:
            result['TrustedProcessGroupIds'] = self.trusted_process_group_ids
        if self.trusted_process_status is not None:
            result['TrustedProcessStatus'] = self.trusted_process_status
        if self.trusted_software_ids is not None:
            result['TrustedSoftwareIds'] = self.trusted_software_ids
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        if self.user_group_mode is not None:
            result['UserGroupMode'] = self.user_group_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('ApplicationType') is not None:
            self.application_type = m.get('ApplicationType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.custom_user_attributes = []
        if m.get('CustomUserAttributes') is not None:
            for k in m.get('CustomUserAttributes'):
                temp_model = GetPrivateAccessPolicyResponseBodyPolicyCustomUserAttributes()
                self.custom_user_attributes.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceAttributeAction') is not None:
            self.device_attribute_action = m.get('DeviceAttributeAction')
        if m.get('DeviceAttributeId') is not None:
            self.device_attribute_id = m.get('DeviceAttributeId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyAction') is not None:
            self.policy_action = m.get('PolicyAction')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagIds') is not None:
            self.tag_ids = m.get('TagIds')
        if m.get('TriggerTemplateId') is not None:
            self.trigger_template_id = m.get('TriggerTemplateId')
        if m.get('TrustedProcessGroupIds') is not None:
            self.trusted_process_group_ids = m.get('TrustedProcessGroupIds')
        if m.get('TrustedProcessStatus') is not None:
            self.trusted_process_status = m.get('TrustedProcessStatus')
        if m.get('TrustedSoftwareIds') is not None:
            self.trusted_software_ids = m.get('TrustedSoftwareIds')
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        if m.get('UserGroupMode') is not None:
            self.user_group_mode = m.get('UserGroupMode')
        return self


class GetPrivateAccessPolicyResponseBody(TeaModel):
    def __init__(
        self,
        policy: GetPrivateAccessPolicyResponseBodyPolicy = None,
        request_id: str = None,
    ):
        # Intranet access policy.
        self.policy = policy
        # The ID of the current request.
        self.request_id = request_id

    def validate(self):
        if self.policy:
            self.policy.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy is not None:
            result['Policy'] = self.policy.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Policy') is not None:
            temp_model = GetPrivateAccessPolicyResponseBodyPolicy()
            self.policy = temp_model.from_map(m['Policy'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPrivateAccessPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPrivateAccessPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPrivateAccessPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRegistrationPolicyRequest(TeaModel):
    def __init__(
        self,
        policy_id: str = None,
    ):
        # This parameter is required.
        self.policy_id = policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        return self


class GetRegistrationPolicyResponseBodyLimitDetailLimitCount(TeaModel):
    def __init__(
        self,
        all: int = None,
        mobile: int = None,
        pc: int = None,
    ):
        self.all = all
        self.mobile = mobile
        self.pc = pc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all is not None:
            result['All'] = self.all
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.pc is not None:
            result['PC'] = self.pc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('All') is not None:
            self.all = m.get('All')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('PC') is not None:
            self.pc = m.get('PC')
        return self


class GetRegistrationPolicyResponseBodyLimitDetail(TeaModel):
    def __init__(
        self,
        device_belong: str = None,
        limit_count: GetRegistrationPolicyResponseBodyLimitDetailLimitCount = None,
        limit_type: str = None,
    ):
        self.device_belong = device_belong
        self.limit_count = limit_count
        self.limit_type = limit_type

    def validate(self):
        if self.limit_count:
            self.limit_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_belong is not None:
            result['DeviceBelong'] = self.device_belong
        if self.limit_count is not None:
            result['LimitCount'] = self.limit_count.to_map()
        if self.limit_type is not None:
            result['LimitType'] = self.limit_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceBelong') is not None:
            self.device_belong = m.get('DeviceBelong')
        if m.get('LimitCount') is not None:
            temp_model = GetRegistrationPolicyResponseBodyLimitDetailLimitCount()
            self.limit_count = temp_model.from_map(m['LimitCount'])
        if m.get('LimitType') is not None:
            self.limit_type = m.get('LimitType')
        return self


class GetRegistrationPolicyResponseBody(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        limit_detail: List[GetRegistrationPolicyResponseBodyLimitDetail] = None,
        match_mode: str = None,
        name: str = None,
        policy_id: str = None,
        priority: int = None,
        request_id: str = None,
        status: str = None,
        user_group_ids: List[str] = None,
        whitelist: List[str] = None,
    ):
        self.create_time = create_time
        self.description = description
        self.limit_detail = limit_detail
        self.match_mode = match_mode
        self.name = name
        self.policy_id = policy_id
        self.priority = priority
        self.request_id = request_id
        self.status = status
        self.user_group_ids = user_group_ids
        self.whitelist = whitelist

    def validate(self):
        if self.limit_detail:
            for k in self.limit_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        result['LimitDetail'] = []
        if self.limit_detail is not None:
            for k in self.limit_detail:
                result['LimitDetail'].append(k.to_map() if k else None)
        if self.match_mode is not None:
            result['MatchMode'] = self.match_mode
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        if self.whitelist is not None:
            result['Whitelist'] = self.whitelist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.limit_detail = []
        if m.get('LimitDetail') is not None:
            for k in m.get('LimitDetail'):
                temp_model = GetRegistrationPolicyResponseBodyLimitDetail()
                self.limit_detail.append(temp_model.from_map(k))
        if m.get('MatchMode') is not None:
            self.match_mode = m.get('MatchMode')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        if m.get('Whitelist') is not None:
            self.whitelist = m.get('Whitelist')
        return self


class GetRegistrationPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRegistrationPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRegistrationPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserDeviceRequest(TeaModel):
    def __init__(
        self,
        device_tag: str = None,
    ):
        # This parameter is required.
        self.device_tag = device_tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_tag is not None:
            result['DeviceTag'] = self.device_tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceTag') is not None:
            self.device_tag = m.get('DeviceTag')
        return self


class GetUserDeviceResponseBodyDeviceHistoryUsers(TeaModel):
    def __init__(
        self,
        sase_user_id: str = None,
        username: str = None,
    ):
        self.sase_user_id = sase_user_id
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class GetUserDeviceResponseBodyDeviceNetInterfaceInfo(TeaModel):
    def __init__(
        self,
        mac: str = None,
        name: str = None,
    ):
        self.mac = mac
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetUserDeviceResponseBodyDevice(TeaModel):
    def __init__(
        self,
        app_status: str = None,
        app_version: str = None,
        cpu: str = None,
        create_time: str = None,
        department: str = None,
        device_belong: str = None,
        device_model: str = None,
        device_status: str = None,
        device_tag: str = None,
        device_type: str = None,
        device_version: str = None,
        disk: str = None,
        dlp_status: str = None,
        edr_status: str = None,
        history_users: List[GetUserDeviceResponseBodyDeviceHistoryUsers] = None,
        hostname: str = None,
        ia_status: str = None,
        inner_ip: str = None,
        mac: str = None,
        match_device_group_ids: List[str] = None,
        memory: str = None,
        nac_status: str = None,
        net_interface_info: List[GetUserDeviceResponseBodyDeviceNetInterfaceInfo] = None,
        pa_status: str = None,
        sase_user_id: str = None,
        sharing_status: bool = None,
        sn_base_board: str = None,
        sn_bios: str = None,
        sn_disk_drive: str = None,
        sn_processor: str = None,
        sn_system: str = None,
        src_ip: str = None,
        update_time: str = None,
        username: str = None,
        workshop: str = None,
    ):
        self.app_status = app_status
        self.app_version = app_version
        self.cpu = cpu
        self.create_time = create_time
        self.department = department
        self.device_belong = device_belong
        self.device_model = device_model
        self.device_status = device_status
        self.device_tag = device_tag
        self.device_type = device_type
        self.device_version = device_version
        self.disk = disk
        self.dlp_status = dlp_status
        self.edr_status = edr_status
        self.history_users = history_users
        self.hostname = hostname
        self.ia_status = ia_status
        self.inner_ip = inner_ip
        self.mac = mac
        self.match_device_group_ids = match_device_group_ids
        self.memory = memory
        self.nac_status = nac_status
        self.net_interface_info = net_interface_info
        self.pa_status = pa_status
        self.sase_user_id = sase_user_id
        self.sharing_status = sharing_status
        self.sn_base_board = sn_base_board
        self.sn_bios = sn_bios
        self.sn_disk_drive = sn_disk_drive
        self.sn_processor = sn_processor
        self.sn_system = sn_system
        self.src_ip = src_ip
        self.update_time = update_time
        self.username = username
        self.workshop = workshop

    def validate(self):
        if self.history_users:
            for k in self.history_users:
                if k:
                    k.validate()
        if self.net_interface_info:
            for k in self.net_interface_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_status is not None:
            result['AppStatus'] = self.app_status
        if self.app_version is not None:
            result['AppVersion'] = self.app_version
        if self.cpu is not None:
            result['CPU'] = self.cpu
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.department is not None:
            result['Department'] = self.department
        if self.device_belong is not None:
            result['DeviceBelong'] = self.device_belong
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_tag is not None:
            result['DeviceTag'] = self.device_tag
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.device_version is not None:
            result['DeviceVersion'] = self.device_version
        if self.disk is not None:
            result['Disk'] = self.disk
        if self.dlp_status is not None:
            result['DlpStatus'] = self.dlp_status
        if self.edr_status is not None:
            result['EdrStatus'] = self.edr_status
        result['HistoryUsers'] = []
        if self.history_users is not None:
            for k in self.history_users:
                result['HistoryUsers'].append(k.to_map() if k else None)
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.ia_status is not None:
            result['IaStatus'] = self.ia_status
        if self.inner_ip is not None:
            result['InnerIP'] = self.inner_ip
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.match_device_group_ids is not None:
            result['MatchDeviceGroupIds'] = self.match_device_group_ids
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.nac_status is not None:
            result['NacStatus'] = self.nac_status
        result['NetInterfaceInfo'] = []
        if self.net_interface_info is not None:
            for k in self.net_interface_info:
                result['NetInterfaceInfo'].append(k.to_map() if k else None)
        if self.pa_status is not None:
            result['PaStatus'] = self.pa_status
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.sharing_status is not None:
            result['SharingStatus'] = self.sharing_status
        if self.sn_base_board is not None:
            result['SnBaseBoard'] = self.sn_base_board
        if self.sn_bios is not None:
            result['SnBios'] = self.sn_bios
        if self.sn_disk_drive is not None:
            result['SnDiskDrive'] = self.sn_disk_drive
        if self.sn_processor is not None:
            result['SnProcessor'] = self.sn_processor
        if self.sn_system is not None:
            result['SnSystem'] = self.sn_system
        if self.src_ip is not None:
            result['SrcIP'] = self.src_ip
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.username is not None:
            result['Username'] = self.username
        if self.workshop is not None:
            result['Workshop'] = self.workshop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppStatus') is not None:
            self.app_status = m.get('AppStatus')
        if m.get('AppVersion') is not None:
            self.app_version = m.get('AppVersion')
        if m.get('CPU') is not None:
            self.cpu = m.get('CPU')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('DeviceBelong') is not None:
            self.device_belong = m.get('DeviceBelong')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceTag') is not None:
            self.device_tag = m.get('DeviceTag')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('DeviceVersion') is not None:
            self.device_version = m.get('DeviceVersion')
        if m.get('Disk') is not None:
            self.disk = m.get('Disk')
        if m.get('DlpStatus') is not None:
            self.dlp_status = m.get('DlpStatus')
        if m.get('EdrStatus') is not None:
            self.edr_status = m.get('EdrStatus')
        self.history_users = []
        if m.get('HistoryUsers') is not None:
            for k in m.get('HistoryUsers'):
                temp_model = GetUserDeviceResponseBodyDeviceHistoryUsers()
                self.history_users.append(temp_model.from_map(k))
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('IaStatus') is not None:
            self.ia_status = m.get('IaStatus')
        if m.get('InnerIP') is not None:
            self.inner_ip = m.get('InnerIP')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('MatchDeviceGroupIds') is not None:
            self.match_device_group_ids = m.get('MatchDeviceGroupIds')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('NacStatus') is not None:
            self.nac_status = m.get('NacStatus')
        self.net_interface_info = []
        if m.get('NetInterfaceInfo') is not None:
            for k in m.get('NetInterfaceInfo'):
                temp_model = GetUserDeviceResponseBodyDeviceNetInterfaceInfo()
                self.net_interface_info.append(temp_model.from_map(k))
        if m.get('PaStatus') is not None:
            self.pa_status = m.get('PaStatus')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('SharingStatus') is not None:
            self.sharing_status = m.get('SharingStatus')
        if m.get('SnBaseBoard') is not None:
            self.sn_base_board = m.get('SnBaseBoard')
        if m.get('SnBios') is not None:
            self.sn_bios = m.get('SnBios')
        if m.get('SnDiskDrive') is not None:
            self.sn_disk_drive = m.get('SnDiskDrive')
        if m.get('SnProcessor') is not None:
            self.sn_processor = m.get('SnProcessor')
        if m.get('SnSystem') is not None:
            self.sn_system = m.get('SnSystem')
        if m.get('SrcIP') is not None:
            self.src_ip = m.get('SrcIP')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        if m.get('Workshop') is not None:
            self.workshop = m.get('Workshop')
        return self


class GetUserDeviceResponseBody(TeaModel):
    def __init__(
        self,
        device: GetUserDeviceResponseBodyDevice = None,
        request_id: str = None,
    ):
        self.device = device
        self.request_id = request_id

    def validate(self):
        if self.device:
            self.device.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device is not None:
            result['Device'] = self.device.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Device') is not None:
            temp_model = GetUserDeviceResponseBodyDevice()
            self.device = temp_model.from_map(m['Device'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetUserDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetUserDeviceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetUserDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserGroupRequest(TeaModel):
    def __init__(
        self,
        user_group_id: str = None,
    ):
        # This parameter is required.
        self.user_group_id = user_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class GetUserGroupResponseBodyUserGroupAttributes(TeaModel):
    def __init__(
        self,
        idp_id: int = None,
        relation: str = None,
        user_group_type: str = None,
        value: str = None,
    ):
        self.idp_id = idp_id
        self.relation = relation
        self.user_group_type = user_group_type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idp_id is not None:
            result['IdpId'] = self.idp_id
        if self.relation is not None:
            result['Relation'] = self.relation
        if self.user_group_type is not None:
            result['UserGroupType'] = self.user_group_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdpId') is not None:
            self.idp_id = m.get('IdpId')
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        if m.get('UserGroupType') is not None:
            self.user_group_type = m.get('UserGroupType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetUserGroupResponseBodyUserGroup(TeaModel):
    def __init__(
        self,
        attributes: List[GetUserGroupResponseBodyUserGroupAttributes] = None,
        create_time: str = None,
        description: str = None,
        name: str = None,
        user_group_id: str = None,
    ):
        self.attributes = attributes
        self.create_time = create_time
        self.description = description
        self.name = name
        self.user_group_id = user_group_id

    def validate(self):
        if self.attributes:
            for k in self.attributes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attributes'] = []
        if self.attributes is not None:
            for k in self.attributes:
                result['Attributes'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attributes = []
        if m.get('Attributes') is not None:
            for k in m.get('Attributes'):
                temp_model = GetUserGroupResponseBodyUserGroupAttributes()
                self.attributes.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class GetUserGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_group: GetUserGroupResponseBodyUserGroup = None,
    ):
        self.request_id = request_id
        self.user_group = user_group

    def validate(self):
        if self.user_group:
            self.user_group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_group is not None:
            result['UserGroup'] = self.user_group.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserGroup') is not None:
            temp_model = GetUserGroupResponseBodyUserGroup()
            self.user_group = temp_model.from_map(m['UserGroup'])
        return self


class GetUserGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetUserGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetUserGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWmEmbedTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        # This parameter is required.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetWmEmbedTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        file_url_exp: str = None,
        filename: str = None,
        out_file_hash_md_5: str = None,
        out_file_size: int = None,
        task_id: str = None,
        task_status: str = None,
    ):
        self.file_url = file_url
        self.file_url_exp = file_url_exp
        self.filename = filename
        self.out_file_hash_md_5 = out_file_hash_md_5
        self.out_file_size = out_file_size
        self.task_id = task_id
        self.task_status = task_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.file_url_exp is not None:
            result['FileUrlExp'] = self.file_url_exp
        if self.filename is not None:
            result['Filename'] = self.filename
        if self.out_file_hash_md_5 is not None:
            result['OutFileHashMd5'] = self.out_file_hash_md_5
        if self.out_file_size is not None:
            result['OutFileSize'] = self.out_file_size
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FileUrlExp') is not None:
            self.file_url_exp = m.get('FileUrlExp')
        if m.get('Filename') is not None:
            self.filename = m.get('Filename')
        if m.get('OutFileHashMd5') is not None:
            self.out_file_hash_md_5 = m.get('OutFileHashMd5')
        if m.get('OutFileSize') is not None:
            self.out_file_size = m.get('OutFileSize')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class GetWmEmbedTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: GetWmEmbedTaskResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetWmEmbedTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetWmEmbedTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWmEmbedTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWmEmbedTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWmExtractTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        # This parameter is required.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetWmExtractTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        filename: str = None,
        status: str = None,
        task_id: str = None,
        wm_info_bytes_b64: str = None,
        wm_info_size: int = None,
        wm_info_uint: int = None,
        wm_type: str = None,
    ):
        self.create_time = create_time
        self.filename = filename
        self.status = status
        self.task_id = task_id
        self.wm_info_bytes_b64 = wm_info_bytes_b64
        self.wm_info_size = wm_info_size
        self.wm_info_uint = wm_info_uint
        self.wm_type = wm_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.filename is not None:
            result['Filename'] = self.filename
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.wm_info_bytes_b64 is not None:
            result['WmInfoBytesB64'] = self.wm_info_bytes_b64
        if self.wm_info_size is not None:
            result['WmInfoSize'] = self.wm_info_size
        if self.wm_info_uint is not None:
            result['WmInfoUint'] = self.wm_info_uint
        if self.wm_type is not None:
            result['WmType'] = self.wm_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Filename') is not None:
            self.filename = m.get('Filename')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WmInfoBytesB64') is not None:
            self.wm_info_bytes_b64 = m.get('WmInfoBytesB64')
        if m.get('WmInfoSize') is not None:
            self.wm_info_size = m.get('WmInfoSize')
        if m.get('WmInfoUint') is not None:
            self.wm_info_uint = m.get('WmInfoUint')
        if m.get('WmType') is not None:
            self.wm_type = m.get('WmType')
        return self


class GetWmExtractTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: GetWmExtractTaskResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetWmExtractTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetWmExtractTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWmExtractTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWmExtractTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportEnterpriseAccelerateTargetsRequest(TeaModel):
    def __init__(
        self,
        eap_id: str = None,
        file_url: str = None,
    ):
        # This parameter is required.
        self.eap_id = eap_id
        # This parameter is required.
        self.file_url = file_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.eap_id is not None:
            result['EapId'] = self.eap_id
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EapId') is not None:
            self.eap_id = m.get('EapId')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        return self


class ImportEnterpriseAccelerateTargetsResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ImportEnterpriseAccelerateTargetsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ImportEnterpriseAccelerateTargetsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ImportEnterpriseAccelerateTargetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApplicationsForPrivateAccessPolicyRequest(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
    ):
        # This parameter is required.
        self.policy_ids = policy_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        return self


class ListApplicationsForPrivateAccessPolicyResponseBodyPolicesApplicationsPortRanges(TeaModel):
    def __init__(
        self,
        begin: int = None,
        end: int = None,
    ):
        self.begin = begin
        self.end = end

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin is not None:
            result['Begin'] = self.begin
        if self.end is not None:
            result['End'] = self.end
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Begin') is not None:
            self.begin = m.get('Begin')
        if m.get('End') is not None:
            self.end = m.get('End')
        return self


class ListApplicationsForPrivateAccessPolicyResponseBodyPolicesApplications(TeaModel):
    def __init__(
        self,
        addresses: List[str] = None,
        application_id: str = None,
        create_time: str = None,
        description: str = None,
        name: str = None,
        port_ranges: List[ListApplicationsForPrivateAccessPolicyResponseBodyPolicesApplicationsPortRanges] = None,
        protocol: str = None,
        status: str = None,
    ):
        self.addresses = addresses
        self.application_id = application_id
        self.create_time = create_time
        self.description = description
        self.name = name
        self.port_ranges = port_ranges
        self.protocol = protocol
        self.status = status

    def validate(self):
        if self.port_ranges:
            for k in self.port_ranges:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addresses is not None:
            result['Addresses'] = self.addresses
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        result['PortRanges'] = []
        if self.port_ranges is not None:
            for k in self.port_ranges:
                result['PortRanges'].append(k.to_map() if k else None)
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addresses') is not None:
            self.addresses = m.get('Addresses')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.port_ranges = []
        if m.get('PortRanges') is not None:
            for k in m.get('PortRanges'):
                temp_model = ListApplicationsForPrivateAccessPolicyResponseBodyPolicesApplicationsPortRanges()
                self.port_ranges.append(temp_model.from_map(k))
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListApplicationsForPrivateAccessPolicyResponseBodyPolices(TeaModel):
    def __init__(
        self,
        applications: List[ListApplicationsForPrivateAccessPolicyResponseBodyPolicesApplications] = None,
        policy_id: str = None,
    ):
        self.applications = applications
        self.policy_id = policy_id

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = ListApplicationsForPrivateAccessPolicyResponseBodyPolicesApplications()
                self.applications.append(temp_model.from_map(k))
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        return self


class ListApplicationsForPrivateAccessPolicyResponseBody(TeaModel):
    def __init__(
        self,
        polices: List[ListApplicationsForPrivateAccessPolicyResponseBodyPolices] = None,
        request_id: str = None,
    ):
        self.polices = polices
        self.request_id = request_id

    def validate(self):
        if self.polices:
            for k in self.polices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Polices'] = []
        if self.polices is not None:
            for k in self.polices:
                result['Polices'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.polices = []
        if m.get('Polices') is not None:
            for k in m.get('Polices'):
                temp_model = ListApplicationsForPrivateAccessPolicyResponseBodyPolices()
                self.polices.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListApplicationsForPrivateAccessPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListApplicationsForPrivateAccessPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListApplicationsForPrivateAccessPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApplicationsForPrivateAccessTagRequest(TeaModel):
    def __init__(
        self,
        tag_ids: List[str] = None,
    ):
        # This parameter is required.
        self.tag_ids = tag_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_ids is not None:
            result['TagIds'] = self.tag_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagIds') is not None:
            self.tag_ids = m.get('TagIds')
        return self


class ListApplicationsForPrivateAccessTagResponseBodyTagsApplicationsPortRanges(TeaModel):
    def __init__(
        self,
        begin: int = None,
        end: int = None,
    ):
        self.begin = begin
        self.end = end

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin is not None:
            result['Begin'] = self.begin
        if self.end is not None:
            result['End'] = self.end
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Begin') is not None:
            self.begin = m.get('Begin')
        if m.get('End') is not None:
            self.end = m.get('End')
        return self


class ListApplicationsForPrivateAccessTagResponseBodyTagsApplications(TeaModel):
    def __init__(
        self,
        addresses: List[str] = None,
        application_id: str = None,
        create_time: str = None,
        description: str = None,
        name: str = None,
        port_ranges: List[ListApplicationsForPrivateAccessTagResponseBodyTagsApplicationsPortRanges] = None,
        protocol: str = None,
        status: str = None,
    ):
        self.addresses = addresses
        self.application_id = application_id
        # 内网访问应用创建时间。
        self.create_time = create_time
        self.description = description
        self.name = name
        self.port_ranges = port_ranges
        self.protocol = protocol
        self.status = status

    def validate(self):
        if self.port_ranges:
            for k in self.port_ranges:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addresses is not None:
            result['Addresses'] = self.addresses
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        result['PortRanges'] = []
        if self.port_ranges is not None:
            for k in self.port_ranges:
                result['PortRanges'].append(k.to_map() if k else None)
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addresses') is not None:
            self.addresses = m.get('Addresses')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.port_ranges = []
        if m.get('PortRanges') is not None:
            for k in m.get('PortRanges'):
                temp_model = ListApplicationsForPrivateAccessTagResponseBodyTagsApplicationsPortRanges()
                self.port_ranges.append(temp_model.from_map(k))
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListApplicationsForPrivateAccessTagResponseBodyTags(TeaModel):
    def __init__(
        self,
        applications: List[ListApplicationsForPrivateAccessTagResponseBodyTagsApplications] = None,
        tag_id: str = None,
    ):
        self.applications = applications
        self.tag_id = tag_id

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = ListApplicationsForPrivateAccessTagResponseBodyTagsApplications()
                self.applications.append(temp_model.from_map(k))
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        return self


class ListApplicationsForPrivateAccessTagResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        tags: List[ListApplicationsForPrivateAccessTagResponseBodyTags] = None,
    ):
        self.request_id = request_id
        self.tags = tags

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = ListApplicationsForPrivateAccessTagResponseBodyTags()
                self.tags.append(temp_model.from_map(k))
        return self


class ListApplicationsForPrivateAccessTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListApplicationsForPrivateAccessTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListApplicationsForPrivateAccessTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApprovalProcessesRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        policy_id: str = None,
        policy_type: str = None,
        process_ids: List[str] = None,
        process_name: str = None,
        sase_user_id: str = None,
        username: str = None,
    ):
        # This parameter is required.
        self.current_page = current_page
        # This parameter is required.
        self.page_size = page_size
        self.policy_id = policy_id
        self.policy_type = policy_type
        self.process_ids = process_ids
        self.process_name = process_name
        self.sase_user_id = sase_user_id
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.process_ids is not None:
            result['ProcessIds'] = self.process_ids
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('ProcessIds') is not None:
            self.process_ids = m.get('ProcessIds')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListApprovalProcessesResponseBodyProcessesAppUninstallPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class ListApprovalProcessesResponseBodyProcessesDeviceRegistrationPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class ListApprovalProcessesResponseBodyProcessesDlpSendPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class ListApprovalProcessesResponseBodyProcessesDomainBlacklistPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class ListApprovalProcessesResponseBodyProcessesDomainWhitelistPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class ListApprovalProcessesResponseBodyProcessesEndpointHardeningPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class ListApprovalProcessesResponseBodyProcessesPeripheralBlockPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class ListApprovalProcessesResponseBodyProcessesProcessNodes(TeaModel):
    def __init__(
        self,
        sase_user_id: str = None,
        username: str = None,
    ):
        self.sase_user_id = sase_user_id
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListApprovalProcessesResponseBodyProcessesSoftwareBlockPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class ListApprovalProcessesResponseBodyProcessesSoftwareHardeningPolicies(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class ListApprovalProcessesResponseBodyProcesses(TeaModel):
    def __init__(
        self,
        app_uninstall_policies: ListApprovalProcessesResponseBodyProcessesAppUninstallPolicies = None,
        approval_type: int = None,
        create_time: str = None,
        description: str = None,
        device_registration_policies: ListApprovalProcessesResponseBodyProcessesDeviceRegistrationPolicies = None,
        dlp_send_policies: ListApprovalProcessesResponseBodyProcessesDlpSendPolicies = None,
        domain_blacklist_policies: ListApprovalProcessesResponseBodyProcessesDomainBlacklistPolicies = None,
        domain_whitelist_policies: ListApprovalProcessesResponseBodyProcessesDomainWhitelistPolicies = None,
        endpoint_hardening_policies: ListApprovalProcessesResponseBodyProcessesEndpointHardeningPolicies = None,
        peripheral_block_policies: ListApprovalProcessesResponseBodyProcessesPeripheralBlockPolicies = None,
        process_id: str = None,
        process_name: str = None,
        process_nodes: List[List[ListApprovalProcessesResponseBodyProcessesProcessNodes]] = None,
        software_block_policies: ListApprovalProcessesResponseBodyProcessesSoftwareBlockPolicies = None,
        software_hardening_policies: ListApprovalProcessesResponseBodyProcessesSoftwareHardeningPolicies = None,
    ):
        self.app_uninstall_policies = app_uninstall_policies
        self.approval_type = approval_type
        self.create_time = create_time
        self.description = description
        self.device_registration_policies = device_registration_policies
        self.dlp_send_policies = dlp_send_policies
        self.domain_blacklist_policies = domain_blacklist_policies
        self.domain_whitelist_policies = domain_whitelist_policies
        self.endpoint_hardening_policies = endpoint_hardening_policies
        self.peripheral_block_policies = peripheral_block_policies
        self.process_id = process_id
        self.process_name = process_name
        self.process_nodes = process_nodes
        self.software_block_policies = software_block_policies
        self.software_hardening_policies = software_hardening_policies

    def validate(self):
        if self.app_uninstall_policies:
            self.app_uninstall_policies.validate()
        if self.device_registration_policies:
            self.device_registration_policies.validate()
        if self.dlp_send_policies:
            self.dlp_send_policies.validate()
        if self.domain_blacklist_policies:
            self.domain_blacklist_policies.validate()
        if self.domain_whitelist_policies:
            self.domain_whitelist_policies.validate()
        if self.endpoint_hardening_policies:
            self.endpoint_hardening_policies.validate()
        if self.peripheral_block_policies:
            self.peripheral_block_policies.validate()
        if self.process_nodes:
            for k in self.process_nodes:
                for k1 in k:
                    if k1:
                        k1.validate()
        if self.software_block_policies:
            self.software_block_policies.validate()
        if self.software_hardening_policies:
            self.software_hardening_policies.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_uninstall_policies is not None:
            result['AppUninstallPolicies'] = self.app_uninstall_policies.to_map()
        if self.approval_type is not None:
            result['ApprovalType'] = self.approval_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.device_registration_policies is not None:
            result['DeviceRegistrationPolicies'] = self.device_registration_policies.to_map()
        if self.dlp_send_policies is not None:
            result['DlpSendPolicies'] = self.dlp_send_policies.to_map()
        if self.domain_blacklist_policies is not None:
            result['DomainBlacklistPolicies'] = self.domain_blacklist_policies.to_map()
        if self.domain_whitelist_policies is not None:
            result['DomainWhitelistPolicies'] = self.domain_whitelist_policies.to_map()
        if self.endpoint_hardening_policies is not None:
            result['EndpointHardeningPolicies'] = self.endpoint_hardening_policies.to_map()
        if self.peripheral_block_policies is not None:
            result['PeripheralBlockPolicies'] = self.peripheral_block_policies.to_map()
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        result['ProcessNodes'] = []
        if self.process_nodes is not None:
            for k in self.process_nodes:
                l1 = []
                for k1 in k:
                    l1.append(k1.to_map() if k1 else None)
                result['ProcessNodes'].append(l1)
        if self.software_block_policies is not None:
            result['SoftwareBlockPolicies'] = self.software_block_policies.to_map()
        if self.software_hardening_policies is not None:
            result['SoftwareHardeningPolicies'] = self.software_hardening_policies.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppUninstallPolicies') is not None:
            temp_model = ListApprovalProcessesResponseBodyProcessesAppUninstallPolicies()
            self.app_uninstall_policies = temp_model.from_map(m['AppUninstallPolicies'])
        if m.get('ApprovalType') is not None:
            self.approval_type = m.get('ApprovalType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceRegistrationPolicies') is not None:
            temp_model = ListApprovalProcessesResponseBodyProcessesDeviceRegistrationPolicies()
            self.device_registration_policies = temp_model.from_map(m['DeviceRegistrationPolicies'])
        if m.get('DlpSendPolicies') is not None:
            temp_model = ListApprovalProcessesResponseBodyProcessesDlpSendPolicies()
            self.dlp_send_policies = temp_model.from_map(m['DlpSendPolicies'])
        if m.get('DomainBlacklistPolicies') is not None:
            temp_model = ListApprovalProcessesResponseBodyProcessesDomainBlacklistPolicies()
            self.domain_blacklist_policies = temp_model.from_map(m['DomainBlacklistPolicies'])
        if m.get('DomainWhitelistPolicies') is not None:
            temp_model = ListApprovalProcessesResponseBodyProcessesDomainWhitelistPolicies()
            self.domain_whitelist_policies = temp_model.from_map(m['DomainWhitelistPolicies'])
        if m.get('EndpointHardeningPolicies') is not None:
            temp_model = ListApprovalProcessesResponseBodyProcessesEndpointHardeningPolicies()
            self.endpoint_hardening_policies = temp_model.from_map(m['EndpointHardeningPolicies'])
        if m.get('PeripheralBlockPolicies') is not None:
            temp_model = ListApprovalProcessesResponseBodyProcessesPeripheralBlockPolicies()
            self.peripheral_block_policies = temp_model.from_map(m['PeripheralBlockPolicies'])
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        self.process_nodes = []
        if m.get('ProcessNodes') is not None:
            for k in m.get('ProcessNodes'):
                l1 = []
                for k1 in k:
                    temp_model = ListApprovalProcessesResponseBodyProcessesProcessNodes()
                    l1.append(temp_model.from_map(k1))
                self.process_nodes.append(l1)
        if m.get('SoftwareBlockPolicies') is not None:
            temp_model = ListApprovalProcessesResponseBodyProcessesSoftwareBlockPolicies()
            self.software_block_policies = temp_model.from_map(m['SoftwareBlockPolicies'])
        if m.get('SoftwareHardeningPolicies') is not None:
            temp_model = ListApprovalProcessesResponseBodyProcessesSoftwareHardeningPolicies()
            self.software_hardening_policies = temp_model.from_map(m['SoftwareHardeningPolicies'])
        return self


class ListApprovalProcessesResponseBody(TeaModel):
    def __init__(
        self,
        processes: List[ListApprovalProcessesResponseBodyProcesses] = None,
        request_id: str = None,
        total_num: str = None,
    ):
        self.processes = processes
        self.request_id = request_id
        self.total_num = total_num

    def validate(self):
        if self.processes:
            for k in self.processes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Processes'] = []
        if self.processes is not None:
            for k in self.processes:
                result['Processes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.processes = []
        if m.get('Processes') is not None:
            for k in m.get('Processes'):
                temp_model = ListApprovalProcessesResponseBodyProcesses()
                self.processes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListApprovalProcessesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListApprovalProcessesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListApprovalProcessesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApprovalProcessesForApprovalSchemasRequest(TeaModel):
    def __init__(
        self,
        schema_ids: List[str] = None,
    ):
        # This parameter is required.
        self.schema_ids = schema_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schema_ids is not None:
            result['SchemaIds'] = self.schema_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SchemaIds') is not None:
            self.schema_ids = m.get('SchemaIds')
        return self


class ListApprovalProcessesForApprovalSchemasResponseBodySchemasProcesses(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        process_id: str = None,
        process_name: str = None,
    ):
        self.create_time = create_time
        self.description = description
        self.process_id = process_id
        self.process_name = process_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        return self


class ListApprovalProcessesForApprovalSchemasResponseBodySchemas(TeaModel):
    def __init__(
        self,
        processes: List[ListApprovalProcessesForApprovalSchemasResponseBodySchemasProcesses] = None,
        schema_id: str = None,
    ):
        self.processes = processes
        self.schema_id = schema_id

    def validate(self):
        if self.processes:
            for k in self.processes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Processes'] = []
        if self.processes is not None:
            for k in self.processes:
                result['Processes'].append(k.to_map() if k else None)
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.processes = []
        if m.get('Processes') is not None:
            for k in m.get('Processes'):
                temp_model = ListApprovalProcessesForApprovalSchemasResponseBodySchemasProcesses()
                self.processes.append(temp_model.from_map(k))
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class ListApprovalProcessesForApprovalSchemasResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        schemas: List[ListApprovalProcessesForApprovalSchemasResponseBodySchemas] = None,
    ):
        self.request_id = request_id
        self.schemas = schemas

    def validate(self):
        if self.schemas:
            for k in self.schemas:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Schemas'] = []
        if self.schemas is not None:
            for k in self.schemas:
                result['Schemas'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.schemas = []
        if m.get('Schemas') is not None:
            for k in m.get('Schemas'):
                temp_model = ListApprovalProcessesForApprovalSchemasResponseBodySchemas()
                self.schemas.append(temp_model.from_map(k))
        return self


class ListApprovalProcessesForApprovalSchemasResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListApprovalProcessesForApprovalSchemasResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListApprovalProcessesForApprovalSchemasResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApprovalSchemasRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        policy_type: str = None,
        schema_ids: List[str] = None,
        schema_name: str = None,
    ):
        # This parameter is required.
        self.current_page = current_page
        # This parameter is required.
        self.page_size = page_size
        self.policy_type = policy_type
        self.schema_ids = schema_ids
        self.schema_name = schema_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.schema_ids is not None:
            result['SchemaIds'] = self.schema_ids
        if self.schema_name is not None:
            result['SchemaName'] = self.schema_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('SchemaIds') is not None:
            self.schema_ids = m.get('SchemaIds')
        if m.get('SchemaName') is not None:
            self.schema_name = m.get('SchemaName')
        return self


class ListApprovalSchemasResponseBodySchemas(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        is_default: bool = None,
        policy_type: str = None,
        schema_content: str = None,
        schema_id: str = None,
        schema_name: str = None,
        schema_version: int = None,
    ):
        self.create_time = create_time
        self.description = description
        self.is_default = is_default
        self.policy_type = policy_type
        self.schema_content = schema_content
        self.schema_id = schema_id
        self.schema_name = schema_name
        self.schema_version = schema_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.schema_content is not None:
            result['SchemaContent'] = self.schema_content
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        if self.schema_name is not None:
            result['SchemaName'] = self.schema_name
        if self.schema_version is not None:
            result['SchemaVersion'] = self.schema_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('SchemaContent') is not None:
            self.schema_content = m.get('SchemaContent')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        if m.get('SchemaName') is not None:
            self.schema_name = m.get('SchemaName')
        if m.get('SchemaVersion') is not None:
            self.schema_version = m.get('SchemaVersion')
        return self


class ListApprovalSchemasResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        schemas: List[ListApprovalSchemasResponseBodySchemas] = None,
        total_num: str = None,
    ):
        self.request_id = request_id
        self.schemas = schemas
        self.total_num = total_num

    def validate(self):
        if self.schemas:
            for k in self.schemas:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Schemas'] = []
        if self.schemas is not None:
            for k in self.schemas:
                result['Schemas'].append(k.to_map() if k else None)
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.schemas = []
        if m.get('Schemas') is not None:
            for k in m.get('Schemas'):
                temp_model = ListApprovalSchemasResponseBodySchemas()
                self.schemas.append(temp_model.from_map(k))
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListApprovalSchemasResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListApprovalSchemasResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListApprovalSchemasResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApprovalSchemasForApprovalProcessesRequest(TeaModel):
    def __init__(
        self,
        process_ids: List[str] = None,
    ):
        # This parameter is required.
        self.process_ids = process_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.process_ids is not None:
            result['ProcessIds'] = self.process_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProcessIds') is not None:
            self.process_ids = m.get('ProcessIds')
        return self


class ListApprovalSchemasForApprovalProcessesResponseBodyProcessesSchemas(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        is_default: bool = None,
        policy_type: str = None,
        schema_content: str = None,
        schema_id: str = None,
        schema_name: str = None,
        schema_version: int = None,
    ):
        self.create_time = create_time
        self.description = description
        self.is_default = is_default
        self.policy_type = policy_type
        self.schema_content = schema_content
        self.schema_id = schema_id
        self.schema_name = schema_name
        self.schema_version = schema_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.schema_content is not None:
            result['SchemaContent'] = self.schema_content
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        if self.schema_name is not None:
            result['SchemaName'] = self.schema_name
        if self.schema_version is not None:
            result['SchemaVersion'] = self.schema_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('SchemaContent') is not None:
            self.schema_content = m.get('SchemaContent')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        if m.get('SchemaName') is not None:
            self.schema_name = m.get('SchemaName')
        if m.get('SchemaVersion') is not None:
            self.schema_version = m.get('SchemaVersion')
        return self


class ListApprovalSchemasForApprovalProcessesResponseBodyProcesses(TeaModel):
    def __init__(
        self,
        process_id: str = None,
        schemas: List[ListApprovalSchemasForApprovalProcessesResponseBodyProcessesSchemas] = None,
    ):
        self.process_id = process_id
        self.schemas = schemas

    def validate(self):
        if self.schemas:
            for k in self.schemas:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        result['Schemas'] = []
        if self.schemas is not None:
            for k in self.schemas:
                result['Schemas'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        self.schemas = []
        if m.get('Schemas') is not None:
            for k in m.get('Schemas'):
                temp_model = ListApprovalSchemasForApprovalProcessesResponseBodyProcessesSchemas()
                self.schemas.append(temp_model.from_map(k))
        return self


class ListApprovalSchemasForApprovalProcessesResponseBody(TeaModel):
    def __init__(
        self,
        processes: List[ListApprovalSchemasForApprovalProcessesResponseBodyProcesses] = None,
        request_id: str = None,
    ):
        self.processes = processes
        self.request_id = request_id

    def validate(self):
        if self.processes:
            for k in self.processes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Processes'] = []
        if self.processes is not None:
            for k in self.processes:
                result['Processes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.processes = []
        if m.get('Processes') is not None:
            for k in m.get('Processes'):
                temp_model = ListApprovalSchemasForApprovalProcessesResponseBodyProcesses()
                self.processes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListApprovalSchemasForApprovalProcessesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListApprovalSchemasForApprovalProcessesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListApprovalSchemasForApprovalProcessesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApprovalsRequest(TeaModel):
    def __init__(
        self,
        approval_ids: List[str] = None,
        create_end_time: int = None,
        create_start_time: int = None,
        creator_department: str = None,
        creator_dev_tag: str = None,
        creator_user_id: str = None,
        creator_username: str = None,
        current_page: int = None,
        operator_user_id: str = None,
        operator_username: str = None,
        page_size: int = None,
        policy_type: str = None,
        process_id: str = None,
        process_name: str = None,
        schema_id: str = None,
        schema_name: str = None,
        statuses: List[str] = None,
    ):
        self.approval_ids = approval_ids
        self.create_end_time = create_end_time
        self.create_start_time = create_start_time
        self.creator_department = creator_department
        self.creator_dev_tag = creator_dev_tag
        self.creator_user_id = creator_user_id
        self.creator_username = creator_username
        # This parameter is required.
        self.current_page = current_page
        self.operator_user_id = operator_user_id
        self.operator_username = operator_username
        # This parameter is required.
        self.page_size = page_size
        self.policy_type = policy_type
        self.process_id = process_id
        self.process_name = process_name
        self.schema_id = schema_id
        self.schema_name = schema_name
        self.statuses = statuses

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approval_ids is not None:
            result['ApprovalIds'] = self.approval_ids
        if self.create_end_time is not None:
            result['CreateEndTime'] = self.create_end_time
        if self.create_start_time is not None:
            result['CreateStartTime'] = self.create_start_time
        if self.creator_department is not None:
            result['CreatorDepartment'] = self.creator_department
        if self.creator_dev_tag is not None:
            result['CreatorDevTag'] = self.creator_dev_tag
        if self.creator_user_id is not None:
            result['CreatorUserId'] = self.creator_user_id
        if self.creator_username is not None:
            result['CreatorUsername'] = self.creator_username
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.operator_user_id is not None:
            result['OperatorUserId'] = self.operator_user_id
        if self.operator_username is not None:
            result['OperatorUsername'] = self.operator_username
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        if self.schema_name is not None:
            result['SchemaName'] = self.schema_name
        if self.statuses is not None:
            result['Statuses'] = self.statuses
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApprovalIds') is not None:
            self.approval_ids = m.get('ApprovalIds')
        if m.get('CreateEndTime') is not None:
            self.create_end_time = m.get('CreateEndTime')
        if m.get('CreateStartTime') is not None:
            self.create_start_time = m.get('CreateStartTime')
        if m.get('CreatorDepartment') is not None:
            self.creator_department = m.get('CreatorDepartment')
        if m.get('CreatorDevTag') is not None:
            self.creator_dev_tag = m.get('CreatorDevTag')
        if m.get('CreatorUserId') is not None:
            self.creator_user_id = m.get('CreatorUserId')
        if m.get('CreatorUsername') is not None:
            self.creator_username = m.get('CreatorUsername')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('OperatorUserId') is not None:
            self.operator_user_id = m.get('OperatorUserId')
        if m.get('OperatorUsername') is not None:
            self.operator_username = m.get('OperatorUsername')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        if m.get('SchemaName') is not None:
            self.schema_name = m.get('SchemaName')
        if m.get('Statuses') is not None:
            self.statuses = m.get('Statuses')
        return self


class ListApprovalsResponseBodyApprovalsApprovalProgressesOperators(TeaModel):
    def __init__(
        self,
        sase_user_id: str = None,
        username: str = None,
    ):
        self.sase_user_id = sase_user_id
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListApprovalsResponseBodyApprovalsApprovalProgresses(TeaModel):
    def __init__(
        self,
        action: str = None,
        comment: str = None,
        executor: str = None,
        operators: List[ListApprovalsResponseBodyApprovalsApprovalProgressesOperators] = None,
        status: str = None,
        timestamp: int = None,
    ):
        self.action = action
        self.comment = comment
        self.executor = executor
        self.operators = operators
        self.status = status
        self.timestamp = timestamp

    def validate(self):
        if self.operators:
            for k in self.operators:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.executor is not None:
            result['Executor'] = self.executor
        result['Operators'] = []
        if self.operators is not None:
            for k in self.operators:
                result['Operators'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Executor') is not None:
            self.executor = m.get('Executor')
        self.operators = []
        if m.get('Operators') is not None:
            for k in m.get('Operators'):
                temp_model = ListApprovalsResponseBodyApprovalsApprovalProgressesOperators()
                self.operators.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class ListApprovalsResponseBodyApprovals(TeaModel):
    def __init__(
        self,
        approval_detail: str = None,
        approval_id: str = None,
        approval_progresses: List[ListApprovalsResponseBodyApprovalsApprovalProgresses] = None,
        approval_type: int = None,
        create_time: str = None,
        creator_department: str = None,
        creator_dev_tag: str = None,
        creator_user_id: str = None,
        creator_username: str = None,
        end_timestamp: int = None,
        policy_type: str = None,
        process_id: str = None,
        process_name: str = None,
        reason: str = None,
        schema_content: str = None,
        schema_id: str = None,
        schema_name: str = None,
        status: str = None,
    ):
        self.approval_detail = approval_detail
        self.approval_id = approval_id
        self.approval_progresses = approval_progresses
        self.approval_type = approval_type
        self.create_time = create_time
        self.creator_department = creator_department
        self.creator_dev_tag = creator_dev_tag
        self.creator_user_id = creator_user_id
        self.creator_username = creator_username
        self.end_timestamp = end_timestamp
        self.policy_type = policy_type
        self.process_id = process_id
        self.process_name = process_name
        self.reason = reason
        self.schema_content = schema_content
        self.schema_id = schema_id
        self.schema_name = schema_name
        self.status = status

    def validate(self):
        if self.approval_progresses:
            for k in self.approval_progresses:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approval_detail is not None:
            result['ApprovalDetail'] = self.approval_detail
        if self.approval_id is not None:
            result['ApprovalId'] = self.approval_id
        result['ApprovalProgresses'] = []
        if self.approval_progresses is not None:
            for k in self.approval_progresses:
                result['ApprovalProgresses'].append(k.to_map() if k else None)
        if self.approval_type is not None:
            result['ApprovalType'] = self.approval_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_department is not None:
            result['CreatorDepartment'] = self.creator_department
        if self.creator_dev_tag is not None:
            result['CreatorDevTag'] = self.creator_dev_tag
        if self.creator_user_id is not None:
            result['CreatorUserId'] = self.creator_user_id
        if self.creator_username is not None:
            result['CreatorUsername'] = self.creator_username
        if self.end_timestamp is not None:
            result['EndTimestamp'] = self.end_timestamp
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.schema_content is not None:
            result['SchemaContent'] = self.schema_content
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        if self.schema_name is not None:
            result['SchemaName'] = self.schema_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApprovalDetail') is not None:
            self.approval_detail = m.get('ApprovalDetail')
        if m.get('ApprovalId') is not None:
            self.approval_id = m.get('ApprovalId')
        self.approval_progresses = []
        if m.get('ApprovalProgresses') is not None:
            for k in m.get('ApprovalProgresses'):
                temp_model = ListApprovalsResponseBodyApprovalsApprovalProgresses()
                self.approval_progresses.append(temp_model.from_map(k))
        if m.get('ApprovalType') is not None:
            self.approval_type = m.get('ApprovalType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorDepartment') is not None:
            self.creator_department = m.get('CreatorDepartment')
        if m.get('CreatorDevTag') is not None:
            self.creator_dev_tag = m.get('CreatorDevTag')
        if m.get('CreatorUserId') is not None:
            self.creator_user_id = m.get('CreatorUserId')
        if m.get('CreatorUsername') is not None:
            self.creator_username = m.get('CreatorUsername')
        if m.get('EndTimestamp') is not None:
            self.end_timestamp = m.get('EndTimestamp')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('SchemaContent') is not None:
            self.schema_content = m.get('SchemaContent')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        if m.get('SchemaName') is not None:
            self.schema_name = m.get('SchemaName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListApprovalsResponseBody(TeaModel):
    def __init__(
        self,
        approvals: List[ListApprovalsResponseBodyApprovals] = None,
        request_id: str = None,
        total_num: str = None,
    ):
        self.approvals = approvals
        self.request_id = request_id
        self.total_num = total_num

    def validate(self):
        if self.approvals:
            for k in self.approvals:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Approvals'] = []
        if self.approvals is not None:
            for k in self.approvals:
                result['Approvals'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.approvals = []
        if m.get('Approvals') is not None:
            for k in m.get('Approvals'):
                temp_model = ListApprovalsResponseBodyApprovals()
                self.approvals.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListApprovalsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListApprovalsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListApprovalsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClientUsersRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        department_id: str = None,
        email: str = None,
        idp_config_id: str = None,
        mobile_number: str = None,
        page_size: int = None,
        status: str = None,
        username: str = None,
    ):
        self.current_page = current_page
        self.department_id = department_id
        self.email = email
        # This parameter is required.
        self.idp_config_id = idp_config_id
        self.mobile_number = mobile_number
        self.page_size = page_size
        self.status = status
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.email is not None:
            result['Email'] = self.email
        if self.idp_config_id is not None:
            result['IdpConfigId'] = self.idp_config_id
        if self.mobile_number is not None:
            result['MobileNumber'] = self.mobile_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('IdpConfigId') is not None:
            self.idp_config_id = m.get('IdpConfigId')
        if m.get('MobileNumber') is not None:
            self.mobile_number = m.get('MobileNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListClientUsersResponseBodyDataDataListDepartment(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
    ):
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ListClientUsersResponseBodyDataDataList(TeaModel):
    def __init__(
        self,
        department: ListClientUsersResponseBodyDataDataListDepartment = None,
        department_id: str = None,
        description: str = None,
        email: str = None,
        id: str = None,
        idp_config_id: str = None,
        mobile_number: str = None,
        status: str = None,
        user_id: str = None,
        username: str = None,
    ):
        self.department = department
        self.department_id = department_id
        self.description = description
        self.email = email
        self.id = id
        self.idp_config_id = idp_config_id
        self.mobile_number = mobile_number
        self.status = status
        self.user_id = user_id
        self.username = username

    def validate(self):
        if self.department:
            self.department.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department is not None:
            result['Department'] = self.department.to_map()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.description is not None:
            result['Description'] = self.description
        if self.email is not None:
            result['Email'] = self.email
        if self.id is not None:
            result['Id'] = self.id
        if self.idp_config_id is not None:
            result['IdpConfigId'] = self.idp_config_id
        if self.mobile_number is not None:
            result['MobileNumber'] = self.mobile_number
        if self.status is not None:
            result['Status'] = self.status
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Department') is not None:
            temp_model = ListClientUsersResponseBodyDataDataListDepartment()
            self.department = temp_model.from_map(m['Department'])
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IdpConfigId') is not None:
            self.idp_config_id = m.get('IdpConfigId')
        if m.get('MobileNumber') is not None:
            self.mobile_number = m.get('MobileNumber')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListClientUsersResponseBodyData(TeaModel):
    def __init__(
        self,
        data_list: List[ListClientUsersResponseBodyDataDataList] = None,
        total_num: int = None,
    ):
        self.data_list = data_list
        self.total_num = total_num

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = ListClientUsersResponseBodyDataDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListClientUsersResponseBody(TeaModel):
    def __init__(
        self,
        data: ListClientUsersResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ListClientUsersResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListClientUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListClientUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListClientUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConnectorsRequest(TeaModel):
    def __init__(
        self,
        connector_ids: List[str] = None,
        current_page: int = None,
        name: str = None,
        page_size: int = None,
        status: str = None,
        switch_status: str = None,
    ):
        self.connector_ids = connector_ids
        # This parameter is required.
        self.current_page = current_page
        self.name = name
        # This parameter is required.
        self.page_size = page_size
        self.status = status
        self.switch_status = switch_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connector_ids is not None:
            result['ConnectorIds'] = self.connector_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        if self.switch_status is not None:
            result['SwitchStatus'] = self.switch_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectorIds') is not None:
            self.connector_ids = m.get('ConnectorIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SwitchStatus') is not None:
            self.switch_status = m.get('SwitchStatus')
        return self


class ListConnectorsResponseBodyConnectorsApplications(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        application_name: str = None,
    ):
        self.application_id = application_id
        self.application_name = application_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        return self


class ListConnectorsResponseBodyConnectorsConnectorClients(TeaModel):
    def __init__(
        self,
        connection_status: str = None,
        dev_tag: str = None,
        hostname: str = None,
        public_ip: str = None,
    ):
        self.connection_status = connection_status
        self.dev_tag = dev_tag
        self.hostname = hostname
        self.public_ip = public_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_status is not None:
            result['ConnectionStatus'] = self.connection_status
        if self.dev_tag is not None:
            result['DevTag'] = self.dev_tag
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionStatus') is not None:
            self.connection_status = m.get('ConnectionStatus')
        if m.get('DevTag') is not None:
            self.dev_tag = m.get('DevTag')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        return self


class ListConnectorsResponseBodyConnectorsUpgradeTime(TeaModel):
    def __init__(
        self,
        end: str = None,
        start: str = None,
    ):
        self.end = end
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class ListConnectorsResponseBodyConnectors(TeaModel):
    def __init__(
        self,
        applications: List[ListConnectorsResponseBodyConnectorsApplications] = None,
        connector_clients: List[ListConnectorsResponseBodyConnectorsConnectorClients] = None,
        connector_id: str = None,
        create_time: str = None,
        name: str = None,
        region_id: str = None,
        status: str = None,
        switch_status: str = None,
        upgrade_time: ListConnectorsResponseBodyConnectorsUpgradeTime = None,
    ):
        self.applications = applications
        self.connector_clients = connector_clients
        # ConnectorID。
        self.connector_id = connector_id
        self.create_time = create_time
        self.name = name
        self.region_id = region_id
        self.status = status
        self.switch_status = switch_status
        self.upgrade_time = upgrade_time

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()
        if self.connector_clients:
            for k in self.connector_clients:
                if k:
                    k.validate()
        if self.upgrade_time:
            self.upgrade_time.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        result['ConnectorClients'] = []
        if self.connector_clients is not None:
            for k in self.connector_clients:
                result['ConnectorClients'].append(k.to_map() if k else None)
        if self.connector_id is not None:
            result['ConnectorId'] = self.connector_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.switch_status is not None:
            result['SwitchStatus'] = self.switch_status
        if self.upgrade_time is not None:
            result['UpgradeTime'] = self.upgrade_time.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = ListConnectorsResponseBodyConnectorsApplications()
                self.applications.append(temp_model.from_map(k))
        self.connector_clients = []
        if m.get('ConnectorClients') is not None:
            for k in m.get('ConnectorClients'):
                temp_model = ListConnectorsResponseBodyConnectorsConnectorClients()
                self.connector_clients.append(temp_model.from_map(k))
        if m.get('ConnectorId') is not None:
            self.connector_id = m.get('ConnectorId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SwitchStatus') is not None:
            self.switch_status = m.get('SwitchStatus')
        if m.get('UpgradeTime') is not None:
            temp_model = ListConnectorsResponseBodyConnectorsUpgradeTime()
            self.upgrade_time = temp_model.from_map(m['UpgradeTime'])
        return self


class ListConnectorsResponseBody(TeaModel):
    def __init__(
        self,
        connectors: List[ListConnectorsResponseBodyConnectors] = None,
        request_id: str = None,
        total_num: int = None,
    ):
        self.connectors = connectors
        self.request_id = request_id
        self.total_num = total_num

    def validate(self):
        if self.connectors:
            for k in self.connectors:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Connectors'] = []
        if self.connectors is not None:
            for k in self.connectors:
                result['Connectors'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.connectors = []
        if m.get('Connectors') is not None:
            for k in m.get('Connectors'):
                temp_model = ListConnectorsResponseBodyConnectors()
                self.connectors.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListConnectorsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListConnectorsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListConnectorsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDynamicDisposalProcessesRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dev_tag: str = None,
        disposal_action: str = None,
        disposal_process_id: str = None,
        end_time: int = None,
        page_size: int = None,
        recovery_type: str = None,
        start_time: int = None,
        status: str = None,
        user_name: str = None,
    ):
        # The page number to display in the paginated query. Range: 1~10000.
        # 
        # This parameter is required.
        self.current_page = current_page
        # Terminal device ID.
        self.dev_tag = dev_tag
        # Disposal action.
        # - **ztna_connect**: Prohibit connection to the zero-trust intranet.
        # - **nac_connect**: Prohibit connection to the office network access.
        # - **none**: No disposal action.
        self.disposal_action = disposal_action
        # Disposal process ID.
        self.disposal_process_id = disposal_process_id
        # The end time for querying dynamic disposal processes. Format: Unix timestamp (in seconds).
        self.end_time = end_time
        # The number of items per page in the paginated query. Range: 1~1000.
        # 
        # This parameter is required.
        self.page_size = page_size
        # Recovery type.
        # - **auto**: Automatic recovery.
        # - **console**: Console recovery.
        # - **auth**: Recovery by authentication and reporting.
        self.recovery_type = recovery_type
        # The start time for querying dynamic disposal processes. Format: Unix timestamp (in seconds).
        self.start_time = start_time
        # Disposal status. Values:
        # - **disposal**: In the disposal state.
        # - **finished**: Already automatically recovered.
        # - **recovery**: Recovered by authentication and reporting or console recovery.
        self.status = status
        # Username.
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dev_tag is not None:
            result['DevTag'] = self.dev_tag
        if self.disposal_action is not None:
            result['DisposalAction'] = self.disposal_action
        if self.disposal_process_id is not None:
            result['DisposalProcessId'] = self.disposal_process_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.recovery_type is not None:
            result['RecoveryType'] = self.recovery_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DevTag') is not None:
            self.dev_tag = m.get('DevTag')
        if m.get('DisposalAction') is not None:
            self.disposal_action = m.get('DisposalAction')
        if m.get('DisposalProcessId') is not None:
            self.disposal_process_id = m.get('DisposalProcessId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RecoveryType') is not None:
            self.recovery_type = m.get('RecoveryType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class ListDynamicDisposalProcessesResponseBodyDisposalProcessesDeviceBasicInfo(TeaModel):
    def __init__(
        self,
        cpu: str = None,
        dev_tag: str = None,
        dev_type: str = None,
        disk: str = None,
        hostname: str = None,
        mac: str = None,
        memory: str = None,
        os_version: str = None,
    ):
        # CPU model.
        self.cpu = cpu
        # Device ID.
        self.dev_tag = dev_tag
        # Device operating system type. Values:
        # - **Windows**：Windows system.
        # - **macOS**：macOS system.
        # - **Linux**：Linux system.
        # - **Android**：Android system.
        # - **iOS**：iOS system.
        # - **Windows_Wuying**：Wuying cloud desktop system.
        self.dev_type = dev_type
        # Device disk model.
        self.disk = disk
        # Device name.
        self.hostname = hostname
        # Device MAC address.
        self.mac = mac
        # Device memory capacity. Unit: GB.
        self.memory = memory
        # Operating system version
        self.os_version = os_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.dev_tag is not None:
            result['DevTag'] = self.dev_tag
        if self.dev_type is not None:
            result['DevType'] = self.dev_type
        if self.disk is not None:
            result['Disk'] = self.disk
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('DevTag') is not None:
            self.dev_tag = m.get('DevTag')
        if m.get('DevType') is not None:
            self.dev_type = m.get('DevType')
        if m.get('Disk') is not None:
            self.disk = m.get('Disk')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        return self


class ListDynamicDisposalProcessesResponseBodyDisposalProcessesDeviceStatusInfo(TeaModel):
    def __init__(
        self,
        app_version: str = None,
        department: str = None,
        dlp_status: str = None,
        internet_ip: str = None,
        la_status: str = None,
        login_status: str = None,
        nac_status: str = None,
        private_ip: str = None,
        sase_user_id: str = None,
        username: str = None,
        workshop: str = None,
        ztna_status: str = None,
    ):
        # Client version.
        self.app_version = app_version
        # Department to which the user belongs.
        self.department = department
        # Office data protection status. Values:
        # - **Enabled**: Enabled.
        # - **Disabled**: Disabled.
        # - **Unprovisioned**: Not configured.
        # - **Unauthorized**: Unauthorized.
        self.dlp_status = dlp_status
        # Public IP address.
        self.internet_ip = internet_ip
        # Internet behavior management enablement status.
        self.la_status = la_status
        # Login status.
        self.login_status = login_status
        # Network access control status. Values:
        # - **Enabled**: Enabled.
        # - **Disabled**: Disabled.
        # - **Unprovisioned**: Not configured.
        self.nac_status = nac_status
        # Private IP address.
        self.private_ip = private_ip
        # Unique ID of the SASE user.
        self.sase_user_id = sase_user_id
        # Username.
        self.username = username
        # Identified office area name.
        self.workshop = workshop
        # ZTNA enablement status.
        self.ztna_status = ztna_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_version is not None:
            result['AppVersion'] = self.app_version
        if self.department is not None:
            result['Department'] = self.department
        if self.dlp_status is not None:
            result['DlpStatus'] = self.dlp_status
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.la_status is not None:
            result['LaStatus'] = self.la_status
        if self.login_status is not None:
            result['LoginStatus'] = self.login_status
        if self.nac_status is not None:
            result['NacStatus'] = self.nac_status
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.username is not None:
            result['Username'] = self.username
        if self.workshop is not None:
            result['Workshop'] = self.workshop
        if self.ztna_status is not None:
            result['ZtnaStatus'] = self.ztna_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppVersion') is not None:
            self.app_version = m.get('AppVersion')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('DlpStatus') is not None:
            self.dlp_status = m.get('DlpStatus')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('LaStatus') is not None:
            self.la_status = m.get('LaStatus')
        if m.get('LoginStatus') is not None:
            self.login_status = m.get('LoginStatus')
        if m.get('NacStatus') is not None:
            self.nac_status = m.get('NacStatus')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        if m.get('Workshop') is not None:
            self.workshop = m.get('Workshop')
        if m.get('ZtnaStatus') is not None:
            self.ztna_status = m.get('ZtnaStatus')
        return self


class ListDynamicDisposalProcessesResponseBodyDisposalProcesses(TeaModel):
    def __init__(
        self,
        department: str = None,
        dev_tag: str = None,
        device_basic_info: ListDynamicDisposalProcessesResponseBodyDisposalProcessesDeviceBasicInfo = None,
        device_status_info: ListDynamicDisposalProcessesResponseBodyDisposalProcessesDeviceStatusInfo = None,
        disposal_actions: List[str] = None,
        disposal_process_id: str = None,
        disposal_time: str = None,
        dynamic_policy_id: str = None,
        dynamic_policy_name: str = None,
        hostname: str = None,
        recovery_type: str = None,
        rule_content: Any = None,
        sase_user_id: str = None,
        status: str = None,
        user_name: str = None,
    ):
        # User\\"s department.
        self.department = department
        # Device ID.
        self.dev_tag = dev_tag
        # Basic device information.
        self.device_basic_info = device_basic_info
        # 设备状态信息。
        self.device_status_info = device_status_info
        # List of disposal actions.
        self.disposal_actions = disposal_actions
        # Disposal process ID.
        self.disposal_process_id = disposal_process_id
        # Disposal time, in seconds since the epoch.
        self.disposal_time = disposal_time
        # Dynamic policy ID.
        self.dynamic_policy_id = dynamic_policy_id
        # Dynamic policy name.
        self.dynamic_policy_name = dynamic_policy_name
        # Terminal device name. Length: 1~128 characters, supporting Chinese and uppercase/lowercase English letters, and can include numbers, half-width periods (.), commas (,), semicolons (;), hyphens (-), underscores (_), slashes (/), at (@) symbols, and spaces. Entering an underscore (_) alone will additionally query all terminal devices with 4-byte UTF-8 characters in their names.
        self.hostname = hostname
        # Recovery type.
        # - **auto**：Automatic recovery.
        # - **console**：Console recovery.
        # - **auth**：Certification and reporting recovery.
        self.recovery_type = recovery_type
        # Rule content.
        self.rule_content = rule_content
        # SASE用户ID。
        self.sase_user_id = sase_user_id
        # Disposal status. Values:
        # - **disposal**: In the disposal state.
        # - **finished**: Already automatically recovered.
        # - **recovery**: Recovered by authentication and reporting or console recovery.
        self.status = status
        # Username.
        self.user_name = user_name

    def validate(self):
        if self.device_basic_info:
            self.device_basic_info.validate()
        if self.device_status_info:
            self.device_status_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department is not None:
            result['Department'] = self.department
        if self.dev_tag is not None:
            result['DevTag'] = self.dev_tag
        if self.device_basic_info is not None:
            result['DeviceBasicInfo'] = self.device_basic_info.to_map()
        if self.device_status_info is not None:
            result['DeviceStatusInfo'] = self.device_status_info.to_map()
        if self.disposal_actions is not None:
            result['DisposalActions'] = self.disposal_actions
        if self.disposal_process_id is not None:
            result['DisposalProcessId'] = self.disposal_process_id
        if self.disposal_time is not None:
            result['DisposalTime'] = self.disposal_time
        if self.dynamic_policy_id is not None:
            result['DynamicPolicyId'] = self.dynamic_policy_id
        if self.dynamic_policy_name is not None:
            result['DynamicPolicyName'] = self.dynamic_policy_name
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.recovery_type is not None:
            result['RecoveryType'] = self.recovery_type
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.status is not None:
            result['Status'] = self.status
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('DevTag') is not None:
            self.dev_tag = m.get('DevTag')
        if m.get('DeviceBasicInfo') is not None:
            temp_model = ListDynamicDisposalProcessesResponseBodyDisposalProcessesDeviceBasicInfo()
            self.device_basic_info = temp_model.from_map(m['DeviceBasicInfo'])
        if m.get('DeviceStatusInfo') is not None:
            temp_model = ListDynamicDisposalProcessesResponseBodyDisposalProcessesDeviceStatusInfo()
            self.device_status_info = temp_model.from_map(m['DeviceStatusInfo'])
        if m.get('DisposalActions') is not None:
            self.disposal_actions = m.get('DisposalActions')
        if m.get('DisposalProcessId') is not None:
            self.disposal_process_id = m.get('DisposalProcessId')
        if m.get('DisposalTime') is not None:
            self.disposal_time = m.get('DisposalTime')
        if m.get('DynamicPolicyId') is not None:
            self.dynamic_policy_id = m.get('DynamicPolicyId')
        if m.get('DynamicPolicyName') is not None:
            self.dynamic_policy_name = m.get('DynamicPolicyName')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('RecoveryType') is not None:
            self.recovery_type = m.get('RecoveryType')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class ListDynamicDisposalProcessesResponseBody(TeaModel):
    def __init__(
        self,
        disposal_processes: List[ListDynamicDisposalProcessesResponseBodyDisposalProcesses] = None,
        request_id: str = None,
        total_num: int = None,
    ):
        # List of disposal processes.
        self.disposal_processes = disposal_processes
        # Request ID.
        self.request_id = request_id
        # Total number of dynamic disposal processes.
        self.total_num = total_num

    def validate(self):
        if self.disposal_processes:
            for k in self.disposal_processes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DisposalProcesses'] = []
        if self.disposal_processes is not None:
            for k in self.disposal_processes:
                result['DisposalProcesses'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.disposal_processes = []
        if m.get('DisposalProcesses') is not None:
            for k in m.get('DisposalProcesses'):
                temp_model = ListDynamicDisposalProcessesResponseBodyDisposalProcesses()
                self.disposal_processes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListDynamicDisposalProcessesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListDynamicDisposalProcessesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDynamicDisposalProcessesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDynamicRouteRegionsResponseBody(TeaModel):
    def __init__(
        self,
        regions: List[str] = None,
        request_id: str = None,
        total_num: int = None,
    ):
        self.regions = regions
        self.request_id = request_id
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.regions is not None:
            result['Regions'] = self.regions
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Regions') is not None:
            self.regions = m.get('Regions')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListDynamicRouteRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListDynamicRouteRegionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDynamicRouteRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDynamicRoutesRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        current_page: int = None,
        dynamic_route_ids: List[str] = None,
        name: str = None,
        next_hop: str = None,
        page_size: int = None,
        region_ids: List[str] = None,
        status: str = None,
        tag_id: str = None,
    ):
        self.application_id = application_id
        # This parameter is required.
        self.current_page = current_page
        self.dynamic_route_ids = dynamic_route_ids
        self.name = name
        self.next_hop = next_hop
        # This parameter is required.
        self.page_size = page_size
        self.region_ids = region_ids
        self.status = status
        self.tag_id = tag_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dynamic_route_ids is not None:
            result['DynamicRouteIds'] = self.dynamic_route_ids
        if self.name is not None:
            result['Name'] = self.name
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_ids is not None:
            result['RegionIds'] = self.region_ids
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DynamicRouteIds') is not None:
            self.dynamic_route_ids = m.get('DynamicRouteIds')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionIds') is not None:
            self.region_ids = m.get('RegionIds')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        return self


class ListDynamicRoutesResponseBodyDynamicRoutes(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        application_type: str = None,
        create_time: str = None,
        description: str = None,
        dynamic_route_id: str = None,
        dynamic_route_type: str = None,
        name: str = None,
        next_hop: str = None,
        priority: int = None,
        region_ids: List[str] = None,
        status: str = None,
        tag_ids: List[str] = None,
    ):
        self.application_ids = application_ids
        self.application_type = application_type
        self.create_time = create_time
        self.description = description
        self.dynamic_route_id = dynamic_route_id
        self.dynamic_route_type = dynamic_route_type
        self.name = name
        self.next_hop = next_hop
        self.priority = priority
        self.region_ids = region_ids
        self.status = status
        self.tag_ids = tag_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.application_type is not None:
            result['ApplicationType'] = self.application_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.dynamic_route_id is not None:
            result['DynamicRouteId'] = self.dynamic_route_id
        if self.dynamic_route_type is not None:
            result['DynamicRouteType'] = self.dynamic_route_type
        if self.name is not None:
            result['Name'] = self.name
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.region_ids is not None:
            result['RegionIds'] = self.region_ids
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_ids is not None:
            result['TagIds'] = self.tag_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('ApplicationType') is not None:
            self.application_type = m.get('ApplicationType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DynamicRouteId') is not None:
            self.dynamic_route_id = m.get('DynamicRouteId')
        if m.get('DynamicRouteType') is not None:
            self.dynamic_route_type = m.get('DynamicRouteType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RegionIds') is not None:
            self.region_ids = m.get('RegionIds')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagIds') is not None:
            self.tag_ids = m.get('TagIds')
        return self


class ListDynamicRoutesResponseBody(TeaModel):
    def __init__(
        self,
        dynamic_routes: List[ListDynamicRoutesResponseBodyDynamicRoutes] = None,
        request_id: str = None,
        total_num: int = None,
    ):
        self.dynamic_routes = dynamic_routes
        self.request_id = request_id
        self.total_num = total_num

    def validate(self):
        if self.dynamic_routes:
            for k in self.dynamic_routes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DynamicRoutes'] = []
        if self.dynamic_routes is not None:
            for k in self.dynamic_routes:
                result['DynamicRoutes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dynamic_routes = []
        if m.get('DynamicRoutes') is not None:
            for k in m.get('DynamicRoutes'):
                temp_model = ListDynamicRoutesResponseBodyDynamicRoutes()
                self.dynamic_routes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListDynamicRoutesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListDynamicRoutesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDynamicRoutesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEnterpriseAccelerateLogsRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        department: str = None,
        dst_addr: str = None,
        end_time: int = None,
        page_size: int = None,
        search_mode: str = None,
        start_time: int = None,
        username: str = None,
    ):
        self.current_page = current_page
        self.department = department
        self.dst_addr = dst_addr
        # This parameter is required.
        self.end_time = end_time
        self.page_size = page_size
        self.search_mode = search_mode
        # This parameter is required.
        self.start_time = start_time
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department is not None:
            result['Department'] = self.department
        if self.dst_addr is not None:
            result['DstAddr'] = self.dst_addr
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_mode is not None:
            result['SearchMode'] = self.search_mode
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('DstAddr') is not None:
            self.dst_addr = m.get('DstAddr')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchMode') is not None:
            self.search_mode = m.get('SearchMode')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListEnterpriseAccelerateLogsResponseBodyLogs(TeaModel):
    def __init__(
        self,
        department: str = None,
        device_type: str = None,
        dst_addr: str = None,
        in_bytes: str = None,
        out_bytes: str = None,
        policy_name: str = None,
        proxy_addr: str = None,
        unix_time: str = None,
        username: str = None,
    ):
        self.department = department
        self.device_type = device_type
        self.dst_addr = dst_addr
        self.in_bytes = in_bytes
        self.out_bytes = out_bytes
        self.policy_name = policy_name
        self.proxy_addr = proxy_addr
        self.unix_time = unix_time
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department is not None:
            result['Department'] = self.department
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.dst_addr is not None:
            result['DstAddr'] = self.dst_addr
        if self.in_bytes is not None:
            result['InBytes'] = self.in_bytes
        if self.out_bytes is not None:
            result['OutBytes'] = self.out_bytes
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.proxy_addr is not None:
            result['ProxyAddr'] = self.proxy_addr
        if self.unix_time is not None:
            result['UnixTime'] = self.unix_time
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('DstAddr') is not None:
            self.dst_addr = m.get('DstAddr')
        if m.get('InBytes') is not None:
            self.in_bytes = m.get('InBytes')
        if m.get('OutBytes') is not None:
            self.out_bytes = m.get('OutBytes')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('ProxyAddr') is not None:
            self.proxy_addr = m.get('ProxyAddr')
        if m.get('UnixTime') is not None:
            self.unix_time = m.get('UnixTime')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListEnterpriseAccelerateLogsResponseBody(TeaModel):
    def __init__(
        self,
        logs: List[ListEnterpriseAccelerateLogsResponseBodyLogs] = None,
        request_id: str = None,
        total_number: int = None,
    ):
        self.logs = logs
        self.request_id = request_id
        self.total_number = total_number

    def validate(self):
        if self.logs:
            for k in self.logs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Logs'] = []
        if self.logs is not None:
            for k in self.logs:
                result['Logs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_number is not None:
            result['TotalNumber'] = self.total_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.logs = []
        if m.get('Logs') is not None:
            for k in m.get('Logs'):
                temp_model = ListEnterpriseAccelerateLogsResponseBodyLogs()
                self.logs.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNumber') is not None:
            self.total_number = m.get('TotalNumber')
        return self


class ListEnterpriseAccelerateLogsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEnterpriseAccelerateLogsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEnterpriseAccelerateLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEnterpriseAcceleratePoliciesRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        name: str = None,
        page_size: int = None,
    ):
        # This parameter is required.
        self.current_page = current_page
        self.name = name
        # This parameter is required.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListEnterpriseAcceleratePoliciesResponseBodyPolicies(TeaModel):
    def __init__(
        self,
        acceleration_type: str = None,
        description: str = None,
        eap_id: str = None,
        enabled: int = None,
        name: str = None,
        on_tls: int = None,
        priority: int = None,
        show_in_client: int = None,
        upstream_host: str = None,
        upstream_port: int = None,
        upstream_type: str = None,
        user_attribute_group: str = None,
    ):
        self.acceleration_type = acceleration_type
        self.description = description
        self.eap_id = eap_id
        self.enabled = enabled
        self.name = name
        self.on_tls = on_tls
        self.priority = priority
        self.show_in_client = show_in_client
        self.upstream_host = upstream_host
        self.upstream_port = upstream_port
        self.upstream_type = upstream_type
        self.user_attribute_group = user_attribute_group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acceleration_type is not None:
            result['AccelerationType'] = self.acceleration_type
        if self.description is not None:
            result['Description'] = self.description
        if self.eap_id is not None:
            result['EapId'] = self.eap_id
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.name is not None:
            result['Name'] = self.name
        if self.on_tls is not None:
            result['OnTls'] = self.on_tls
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.show_in_client is not None:
            result['ShowInClient'] = self.show_in_client
        if self.upstream_host is not None:
            result['UpstreamHost'] = self.upstream_host
        if self.upstream_port is not None:
            result['UpstreamPort'] = self.upstream_port
        if self.upstream_type is not None:
            result['UpstreamType'] = self.upstream_type
        if self.user_attribute_group is not None:
            result['UserAttributeGroup'] = self.user_attribute_group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccelerationType') is not None:
            self.acceleration_type = m.get('AccelerationType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EapId') is not None:
            self.eap_id = m.get('EapId')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OnTls') is not None:
            self.on_tls = m.get('OnTls')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ShowInClient') is not None:
            self.show_in_client = m.get('ShowInClient')
        if m.get('UpstreamHost') is not None:
            self.upstream_host = m.get('UpstreamHost')
        if m.get('UpstreamPort') is not None:
            self.upstream_port = m.get('UpstreamPort')
        if m.get('UpstreamType') is not None:
            self.upstream_type = m.get('UpstreamType')
        if m.get('UserAttributeGroup') is not None:
            self.user_attribute_group = m.get('UserAttributeGroup')
        return self


class ListEnterpriseAcceleratePoliciesResponseBody(TeaModel):
    def __init__(
        self,
        policies: List[ListEnterpriseAcceleratePoliciesResponseBodyPolicies] = None,
        request_id: str = None,
        total: int = None,
    ):
        self.policies = policies
        self.request_id = request_id
        self.total = total

    def validate(self):
        if self.policies:
            for k in self.policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Policies'] = []
        if self.policies is not None:
            for k in self.policies:
                result['Policies'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.policies = []
        if m.get('Policies') is not None:
            for k in m.get('Policies'):
                temp_model = ListEnterpriseAcceleratePoliciesResponseBodyPolicies()
                self.policies.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListEnterpriseAcceleratePoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEnterpriseAcceleratePoliciesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEnterpriseAcceleratePoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEnterpriseAccelerateTargetsRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        eap_id: str = None,
        page_size: int = None,
        target: str = None,
    ):
        # This parameter is required.
        self.current_page = current_page
        # This parameter is required.
        self.eap_id = eap_id
        # This parameter is required.
        self.page_size = page_size
        self.target = target

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.eap_id is not None:
            result['EapId'] = self.eap_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.target is not None:
            result['Target'] = self.target
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('EapId') is not None:
            self.eap_id = m.get('EapId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        return self


class ListEnterpriseAccelerateTargetsResponseBody(TeaModel):
    def __init__(
        self,
        eap_id: str = None,
        request_id: str = None,
        targets: List[str] = None,
        total: int = None,
    ):
        self.eap_id = eap_id
        self.request_id = request_id
        self.targets = targets
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.eap_id is not None:
            result['EapId'] = self.eap_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.targets is not None:
            result['Targets'] = self.targets
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EapId') is not None:
            self.eap_id = m.get('EapId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Targets') is not None:
            self.targets = m.get('Targets')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListEnterpriseAccelerateTargetsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEnterpriseAccelerateTargetsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEnterpriseAccelerateTargetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListExcessiveDeviceRegistrationApplicationsRequest(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        current_page: int = None,
        department: str = None,
        device_tag: str = None,
        hostname: str = None,
        mac: str = None,
        page_size: int = None,
        sase_user_id: str = None,
        statuses: List[str] = None,
        username: str = None,
    ):
        self.application_ids = application_ids
        # This parameter is required.
        self.current_page = current_page
        self.department = department
        self.device_tag = device_tag
        self.hostname = hostname
        self.mac = mac
        # This parameter is required.
        self.page_size = page_size
        self.sase_user_id = sase_user_id
        self.statuses = statuses
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department is not None:
            result['Department'] = self.department
        if self.device_tag is not None:
            result['DeviceTag'] = self.device_tag
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.statuses is not None:
            result['Statuses'] = self.statuses
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('DeviceTag') is not None:
            self.device_tag = m.get('DeviceTag')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Statuses') is not None:
            self.statuses = m.get('Statuses')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListExcessiveDeviceRegistrationApplicationsResponseBodyApplications(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        create_time: str = None,
        department: str = None,
        description: str = None,
        device_tag: str = None,
        device_type: str = None,
        hostname: str = None,
        is_used: bool = None,
        mac: str = None,
        sase_user_id: str = None,
        status: str = None,
        username: str = None,
    ):
        self.application_id = application_id
        self.create_time = create_time
        self.department = department
        self.description = description
        self.device_tag = device_tag
        self.device_type = device_type
        self.hostname = hostname
        self.is_used = is_used
        self.mac = mac
        self.sase_user_id = sase_user_id
        self.status = status
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.department is not None:
            result['Department'] = self.department
        if self.description is not None:
            result['Description'] = self.description
        if self.device_tag is not None:
            result['DeviceTag'] = self.device_tag
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.is_used is not None:
            result['IsUsed'] = self.is_used
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.status is not None:
            result['Status'] = self.status
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceTag') is not None:
            self.device_tag = m.get('DeviceTag')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('IsUsed') is not None:
            self.is_used = m.get('IsUsed')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListExcessiveDeviceRegistrationApplicationsResponseBody(TeaModel):
    def __init__(
        self,
        applications: List[ListExcessiveDeviceRegistrationApplicationsResponseBodyApplications] = None,
        request_id: str = None,
        total_num: int = None,
    ):
        self.applications = applications
        self.request_id = request_id
        self.total_num = total_num

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = ListExcessiveDeviceRegistrationApplicationsResponseBodyApplications()
                self.applications.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListExcessiveDeviceRegistrationApplicationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListExcessiveDeviceRegistrationApplicationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListExcessiveDeviceRegistrationApplicationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIdpConfigsRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        include: str = None,
        page_size: int = None,
    ):
        self.current_page = current_page
        self.include = include
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.include is not None:
            result['Include'] = self.include
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Include') is not None:
            self.include = m.get('Include')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListIdpConfigsResponseBodyDataDataList(TeaModel):
    def __init__(
        self,
        description: str = None,
        id: str = None,
        mfa: str = None,
        mobile_login_type: str = None,
        mobile_mfa_config_type: str = None,
        multi_idp_info: str = None,
        name: str = None,
        pc_login_type: str = None,
        status: str = None,
        type: str = None,
        update_time: str = None,
    ):
        self.description = description
        self.id = id
        self.mfa = mfa
        self.mobile_login_type = mobile_login_type
        self.mobile_mfa_config_type = mobile_mfa_config_type
        self.multi_idp_info = multi_idp_info
        self.name = name
        self.pc_login_type = pc_login_type
        self.status = status
        self.type = type
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.id is not None:
            result['Id'] = self.id
        if self.mfa is not None:
            result['Mfa'] = self.mfa
        if self.mobile_login_type is not None:
            result['MobileLoginType'] = self.mobile_login_type
        if self.mobile_mfa_config_type is not None:
            result['MobileMfaConfigType'] = self.mobile_mfa_config_type
        if self.multi_idp_info is not None:
            result['MultiIdpInfo'] = self.multi_idp_info
        if self.name is not None:
            result['Name'] = self.name
        if self.pc_login_type is not None:
            result['PcLoginType'] = self.pc_login_type
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Mfa') is not None:
            self.mfa = m.get('Mfa')
        if m.get('MobileLoginType') is not None:
            self.mobile_login_type = m.get('MobileLoginType')
        if m.get('MobileMfaConfigType') is not None:
            self.mobile_mfa_config_type = m.get('MobileMfaConfigType')
        if m.get('MultiIdpInfo') is not None:
            self.multi_idp_info = m.get('MultiIdpInfo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PcLoginType') is not None:
            self.pc_login_type = m.get('PcLoginType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListIdpConfigsResponseBodyData(TeaModel):
    def __init__(
        self,
        data_list: List[ListIdpConfigsResponseBodyDataDataList] = None,
        total_num: int = None,
    ):
        self.data_list = data_list
        self.total_num = total_num

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = ListIdpConfigsResponseBodyDataDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListIdpConfigsResponseBody(TeaModel):
    def __init__(
        self,
        data: ListIdpConfigsResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ListIdpConfigsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListIdpConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListIdpConfigsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListIdpConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIdpDepartmentsRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        idp_config_id: str = None,
        page_size: int = None,
    ):
        self.current_page = current_page
        # This parameter is required.
        self.idp_config_id = idp_config_id
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.idp_config_id is not None:
            result['IdpConfigId'] = self.idp_config_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('IdpConfigId') is not None:
            self.idp_config_id = m.get('IdpConfigId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListIdpDepartmentsResponseBodyDataDataList(TeaModel):
    def __init__(
        self,
        id: str = None,
        idp_config_id: str = None,
        name: str = None,
    ):
        self.id = id
        self.idp_config_id = idp_config_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.idp_config_id is not None:
            result['IdpConfigId'] = self.idp_config_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IdpConfigId') is not None:
            self.idp_config_id = m.get('IdpConfigId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ListIdpDepartmentsResponseBodyData(TeaModel):
    def __init__(
        self,
        data_list: List[ListIdpDepartmentsResponseBodyDataDataList] = None,
        total_num: int = None,
    ):
        self.data_list = data_list
        self.total_num = total_num

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = ListIdpDepartmentsResponseBodyDataDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListIdpDepartmentsResponseBody(TeaModel):
    def __init__(
        self,
        data: ListIdpDepartmentsResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ListIdpDepartmentsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListIdpDepartmentsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListIdpDepartmentsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListIdpDepartmentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNacUserCertRequest(TeaModel):
    def __init__(
        self,
        current_page: str = None,
        department: str = None,
        device_type: str = None,
        end_time: int = None,
        page_size: str = None,
        start_time: int = None,
        status: str = None,
        username: str = None,
    ):
        self.current_page = current_page
        self.department = department
        self.device_type = device_type
        self.end_time = end_time
        self.page_size = page_size
        self.start_time = start_time
        self.status = status
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department is not None:
            result['Department'] = self.department
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListNacUserCertResponseBodyDataList(TeaModel):
    def __init__(
        self,
        aliuid: str = None,
        department: str = None,
        dev_tag: str = None,
        device_type: str = None,
        expired_time: str = None,
        hostname: str = None,
        mac: str = None,
        status: str = None,
        user_id: str = None,
        username: str = None,
    ):
        self.aliuid = aliuid
        self.department = department
        self.dev_tag = dev_tag
        self.device_type = device_type
        self.expired_time = expired_time
        self.hostname = hostname
        self.mac = mac
        self.status = status
        self.user_id = user_id
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliuid is not None:
            result['Aliuid'] = self.aliuid
        if self.department is not None:
            result['Department'] = self.department
        if self.dev_tag is not None:
            result['DevTag'] = self.dev_tag
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.status is not None:
            result['Status'] = self.status
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Aliuid') is not None:
            self.aliuid = m.get('Aliuid')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('DevTag') is not None:
            self.dev_tag = m.get('DevTag')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListNacUserCertResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data_list: List[ListNacUserCertResponseBodyDataList] = None,
        message: str = None,
        request_id: str = None,
        total_num: int = None,
    ):
        self.code = code
        self.data_list = data_list
        self.message = message
        self.request_id = request_id
        self.total_num = total_num

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = ListNacUserCertResponseBodyDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListNacUserCertResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListNacUserCertResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListNacUserCertResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPolicesForPrivateAccessApplicationRequest(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
    ):
        # This parameter is required.
        self.application_ids = application_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        return self


class ListPolicesForPrivateAccessApplicationResponseBodyApplicationsPoliciesCustomUserAttributes(TeaModel):
    def __init__(
        self,
        idp_id: int = None,
        relation: str = None,
        user_group_type: str = None,
        value: str = None,
    ):
        self.idp_id = idp_id
        self.relation = relation
        self.user_group_type = user_group_type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idp_id is not None:
            result['IdpId'] = self.idp_id
        if self.relation is not None:
            result['Relation'] = self.relation
        if self.user_group_type is not None:
            result['UserGroupType'] = self.user_group_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdpId') is not None:
            self.idp_id = m.get('IdpId')
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        if m.get('UserGroupType') is not None:
            self.user_group_type = m.get('UserGroupType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListPolicesForPrivateAccessApplicationResponseBodyApplicationsPolicies(TeaModel):
    def __init__(
        self,
        application_type: str = None,
        create_time: str = None,
        custom_user_attributes: List[ListPolicesForPrivateAccessApplicationResponseBodyApplicationsPoliciesCustomUserAttributes] = None,
        description: str = None,
        name: str = None,
        policy_action: str = None,
        policy_id: str = None,
        priority: int = None,
        status: str = None,
        user_group_type: str = None,
    ):
        self.application_type = application_type
        self.create_time = create_time
        self.custom_user_attributes = custom_user_attributes
        self.description = description
        self.name = name
        self.policy_action = policy_action
        self.policy_id = policy_id
        self.priority = priority
        self.status = status
        self.user_group_type = user_group_type

    def validate(self):
        if self.custom_user_attributes:
            for k in self.custom_user_attributes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_type is not None:
            result['ApplicationType'] = self.application_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['CustomUserAttributes'] = []
        if self.custom_user_attributes is not None:
            for k in self.custom_user_attributes:
                result['CustomUserAttributes'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_action is not None:
            result['PolicyAction'] = self.policy_action
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.status is not None:
            result['Status'] = self.status
        if self.user_group_type is not None:
            result['UserGroupType'] = self.user_group_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationType') is not None:
            self.application_type = m.get('ApplicationType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.custom_user_attributes = []
        if m.get('CustomUserAttributes') is not None:
            for k in m.get('CustomUserAttributes'):
                temp_model = ListPolicesForPrivateAccessApplicationResponseBodyApplicationsPoliciesCustomUserAttributes()
                self.custom_user_attributes.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyAction') is not None:
            self.policy_action = m.get('PolicyAction')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserGroupType') is not None:
            self.user_group_type = m.get('UserGroupType')
        return self


class ListPolicesForPrivateAccessApplicationResponseBodyApplications(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        policies: List[ListPolicesForPrivateAccessApplicationResponseBodyApplicationsPolicies] = None,
    ):
        self.application_id = application_id
        self.policies = policies

    def validate(self):
        if self.policies:
            for k in self.policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        result['Policies'] = []
        if self.policies is not None:
            for k in self.policies:
                result['Policies'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        self.policies = []
        if m.get('Policies') is not None:
            for k in m.get('Policies'):
                temp_model = ListPolicesForPrivateAccessApplicationResponseBodyApplicationsPolicies()
                self.policies.append(temp_model.from_map(k))
        return self


class ListPolicesForPrivateAccessApplicationResponseBody(TeaModel):
    def __init__(
        self,
        applications: List[ListPolicesForPrivateAccessApplicationResponseBodyApplications] = None,
        request_id: str = None,
    ):
        self.applications = applications
        self.request_id = request_id

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = ListPolicesForPrivateAccessApplicationResponseBodyApplications()
                self.applications.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPolicesForPrivateAccessApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPolicesForPrivateAccessApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPolicesForPrivateAccessApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPolicesForPrivateAccessTagRequest(TeaModel):
    def __init__(
        self,
        tag_ids: List[str] = None,
    ):
        # This parameter is required.
        self.tag_ids = tag_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_ids is not None:
            result['TagIds'] = self.tag_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagIds') is not None:
            self.tag_ids = m.get('TagIds')
        return self


class ListPolicesForPrivateAccessTagResponseBodyTagsPolicesCustomUserAttributes(TeaModel):
    def __init__(
        self,
        idp_id: int = None,
        relation: str = None,
        user_group_type: str = None,
        value: str = None,
    ):
        # 用户组的身份源ID。当自定义用户组类型为**department**时，存在该值。
        self.idp_id = idp_id
        # 用户组的关系。取值：
        # - **Equal**：等于。
        # - **Unequal**：不等于。
        self.relation = relation
        # 用户组的类型。取值：
        # - **username**：用户名。
        # - **department**：部门。
        # - **email**：邮箱。
        # - **telephone**：手机。
        self.user_group_type = user_group_type
        # 用户组属性的值。
        # - 当用户组类型为**username**时，表示用户名的值。长度为1~128个字符，支持中文和大小写英文字母，可包含数字、半角句号（.）、下划线（_）和短划线（-）。
        # - 当用户组类型为**department**时，表示部门的值。如：OU=部门1,OU=SASE钉钉。
        # - 当用户组类型为**email**时，表示邮箱的值。如：username@example.com。
        # - 当用户组类型为**telephone**时，表示手机的值。如：13900001234。
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idp_id is not None:
            result['IdpId'] = self.idp_id
        if self.relation is not None:
            result['Relation'] = self.relation
        if self.user_group_type is not None:
            result['UserGroupType'] = self.user_group_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdpId') is not None:
            self.idp_id = m.get('IdpId')
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        if m.get('UserGroupType') is not None:
            self.user_group_type = m.get('UserGroupType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListPolicesForPrivateAccessTagResponseBodyTagsPolices(TeaModel):
    def __init__(
        self,
        application_type: str = None,
        create_time: str = None,
        custom_user_attributes: List[ListPolicesForPrivateAccessTagResponseBodyTagsPolicesCustomUserAttributes] = None,
        description: str = None,
        name: str = None,
        policy_action: str = None,
        policy_id: str = None,
        priority: int = None,
        status: str = None,
        user_group_type: str = None,
    ):
        self.application_type = application_type
        # 内网访问策略创建时间。
        self.create_time = create_time
        # 自定义用户组属性集合。多个自定义用户组属性之间是或的关系，按照合集生效。
        self.custom_user_attributes = custom_user_attributes
        self.description = description
        self.name = name
        self.policy_action = policy_action
        self.policy_id = policy_id
        self.priority = priority
        self.status = status
        self.user_group_type = user_group_type

    def validate(self):
        if self.custom_user_attributes:
            for k in self.custom_user_attributes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_type is not None:
            result['ApplicationType'] = self.application_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['CustomUserAttributes'] = []
        if self.custom_user_attributes is not None:
            for k in self.custom_user_attributes:
                result['CustomUserAttributes'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_action is not None:
            result['PolicyAction'] = self.policy_action
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.status is not None:
            result['Status'] = self.status
        if self.user_group_type is not None:
            result['UserGroupType'] = self.user_group_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationType') is not None:
            self.application_type = m.get('ApplicationType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.custom_user_attributes = []
        if m.get('CustomUserAttributes') is not None:
            for k in m.get('CustomUserAttributes'):
                temp_model = ListPolicesForPrivateAccessTagResponseBodyTagsPolicesCustomUserAttributes()
                self.custom_user_attributes.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyAction') is not None:
            self.policy_action = m.get('PolicyAction')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserGroupType') is not None:
            self.user_group_type = m.get('UserGroupType')
        return self


class ListPolicesForPrivateAccessTagResponseBodyTags(TeaModel):
    def __init__(
        self,
        polices: List[ListPolicesForPrivateAccessTagResponseBodyTagsPolices] = None,
        tag_id: str = None,
    ):
        self.polices = polices
        self.tag_id = tag_id

    def validate(self):
        if self.polices:
            for k in self.polices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Polices'] = []
        if self.polices is not None:
            for k in self.polices:
                result['Polices'].append(k.to_map() if k else None)
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.polices = []
        if m.get('Polices') is not None:
            for k in m.get('Polices'):
                temp_model = ListPolicesForPrivateAccessTagResponseBodyTagsPolices()
                self.polices.append(temp_model.from_map(k))
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        return self


class ListPolicesForPrivateAccessTagResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        tags: List[ListPolicesForPrivateAccessTagResponseBodyTags] = None,
    ):
        self.request_id = request_id
        self.tags = tags

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = ListPolicesForPrivateAccessTagResponseBodyTags()
                self.tags.append(temp_model.from_map(k))
        return self


class ListPolicesForPrivateAccessTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPolicesForPrivateAccessTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPolicesForPrivateAccessTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPolicesForUserGroupRequest(TeaModel):
    def __init__(
        self,
        user_group_ids: List[str] = None,
    ):
        # This parameter is required.
        self.user_group_ids = user_group_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        return self


class ListPolicesForUserGroupResponseBodyUserGroupsPolices(TeaModel):
    def __init__(
        self,
        name: str = None,
        policy_id: str = None,
        policy_type: str = None,
    ):
        self.name = name
        self.policy_id = policy_id
        self.policy_type = policy_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        return self


class ListPolicesForUserGroupResponseBodyUserGroups(TeaModel):
    def __init__(
        self,
        polices: List[ListPolicesForUserGroupResponseBodyUserGroupsPolices] = None,
        user_group_id: str = None,
    ):
        self.polices = polices
        self.user_group_id = user_group_id

    def validate(self):
        if self.polices:
            for k in self.polices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Polices'] = []
        if self.polices is not None:
            for k in self.polices:
                result['Polices'].append(k.to_map() if k else None)
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.polices = []
        if m.get('Polices') is not None:
            for k in m.get('Polices'):
                temp_model = ListPolicesForUserGroupResponseBodyUserGroupsPolices()
                self.polices.append(temp_model.from_map(k))
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class ListPolicesForUserGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_groups: List[ListPolicesForUserGroupResponseBodyUserGroups] = None,
    ):
        self.request_id = request_id
        self.user_groups = user_groups

    def validate(self):
        if self.user_groups:
            for k in self.user_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['UserGroups'] = []
        if self.user_groups is not None:
            for k in self.user_groups:
                result['UserGroups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.user_groups = []
        if m.get('UserGroups') is not None:
            for k in m.get('UserGroups'):
                temp_model = ListPolicesForUserGroupResponseBodyUserGroups()
                self.user_groups.append(temp_model.from_map(k))
        return self


class ListPolicesForUserGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPolicesForUserGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPolicesForUserGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPopTrafficStatisticsRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        region: str = None,
        start_time: str = None,
    ):
        self.end_time = end_time
        self.region = region
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.region is not None:
            result['Region'] = self.region
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListPopTrafficStatisticsResponseBodyTrafficDataDatapoints(TeaModel):
    def __init__(
        self,
        average: float = None,
        date_time: str = None,
    ):
        self.average = average
        self.date_time = date_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average is not None:
            result['Average'] = self.average
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Average') is not None:
            self.average = m.get('Average')
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        return self


class ListPopTrafficStatisticsResponseBodyTrafficData(TeaModel):
    def __init__(
        self,
        datapoints: List[ListPopTrafficStatisticsResponseBodyTrafficDataDatapoints] = None,
        metric_name: str = None,
    ):
        self.datapoints = datapoints
        self.metric_name = metric_name

    def validate(self):
        if self.datapoints:
            for k in self.datapoints:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Datapoints'] = []
        if self.datapoints is not None:
            for k in self.datapoints:
                result['Datapoints'].append(k.to_map() if k else None)
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.datapoints = []
        if m.get('Datapoints') is not None:
            for k in m.get('Datapoints'):
                temp_model = ListPopTrafficStatisticsResponseBodyTrafficDataDatapoints()
                self.datapoints.append(temp_model.from_map(k))
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        return self


class ListPopTrafficStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        traffic_data: List[ListPopTrafficStatisticsResponseBodyTrafficData] = None,
    ):
        # Id of the request
        self.request_id = request_id
        self.traffic_data = traffic_data

    def validate(self):
        if self.traffic_data:
            for k in self.traffic_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TrafficData'] = []
        if self.traffic_data is not None:
            for k in self.traffic_data:
                result['TrafficData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.traffic_data = []
        if m.get('TrafficData') is not None:
            for k in m.get('TrafficData'):
                temp_model = ListPopTrafficStatisticsResponseBodyTrafficData()
                self.traffic_data.append(temp_model.from_map(k))
        return self


class ListPopTrafficStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPopTrafficStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPopTrafficStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPrivateAccessApplicationsRequest(TeaModel):
    def __init__(
        self,
        access_modes: str = None,
        address: str = None,
        application_ids: List[str] = None,
        connector_id: str = None,
        current_page: int = None,
        name: str = None,
        page_size: int = None,
        policy_id: str = None,
        status: str = None,
        tag_id: str = None,
    ):
        self.access_modes = access_modes
        self.address = address
        self.application_ids = application_ids
        self.connector_id = connector_id
        # This parameter is required.
        self.current_page = current_page
        self.name = name
        # This parameter is required.
        self.page_size = page_size
        self.policy_id = policy_id
        self.status = status
        self.tag_id = tag_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_modes is not None:
            result['AccessModes'] = self.access_modes
        if self.address is not None:
            result['Address'] = self.address
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.connector_id is not None:
            result['ConnectorId'] = self.connector_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessModes') is not None:
            self.access_modes = m.get('AccessModes')
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('ConnectorId') is not None:
            self.connector_id = m.get('ConnectorId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        return self


class ListPrivateAccessApplicationsResponseBodyApplicationsPortRanges(TeaModel):
    def __init__(
        self,
        begin: int = None,
        end: int = None,
    ):
        self.begin = begin
        self.end = end

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin is not None:
            result['Begin'] = self.begin
        if self.end is not None:
            result['End'] = self.end
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Begin') is not None:
            self.begin = m.get('Begin')
        if m.get('End') is not None:
            self.end = m.get('End')
        return self


class ListPrivateAccessApplicationsResponseBodyApplications(TeaModel):
    def __init__(
        self,
        addresses: List[str] = None,
        application_id: str = None,
        auto_generated: int = None,
        browser_access_status: str = None,
        connector_ids: List[str] = None,
        create_time: str = None,
        description: str = None,
        l_7proxy_domain_automatic: str = None,
        l_7proxy_domain_custom: str = None,
        name: str = None,
        policy_ids: List[str] = None,
        port_ranges: List[ListPrivateAccessApplicationsResponseBodyApplicationsPortRanges] = None,
        protocol: str = None,
        status: str = None,
        tag_ids: List[str] = None,
    ):
        self.addresses = addresses
        self.application_id = application_id
        self.auto_generated = auto_generated
        self.browser_access_status = browser_access_status
        self.connector_ids = connector_ids
        self.create_time = create_time
        self.description = description
        self.l_7proxy_domain_automatic = l_7proxy_domain_automatic
        self.l_7proxy_domain_custom = l_7proxy_domain_custom
        self.name = name
        self.policy_ids = policy_ids
        self.port_ranges = port_ranges
        self.protocol = protocol
        self.status = status
        self.tag_ids = tag_ids

    def validate(self):
        if self.port_ranges:
            for k in self.port_ranges:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addresses is not None:
            result['Addresses'] = self.addresses
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.auto_generated is not None:
            result['AutoGenerated'] = self.auto_generated
        if self.browser_access_status is not None:
            result['BrowserAccessStatus'] = self.browser_access_status
        if self.connector_ids is not None:
            result['ConnectorIds'] = self.connector_ids
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.l_7proxy_domain_automatic is not None:
            result['L7ProxyDomainAutomatic'] = self.l_7proxy_domain_automatic
        if self.l_7proxy_domain_custom is not None:
            result['L7ProxyDomainCustom'] = self.l_7proxy_domain_custom
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        result['PortRanges'] = []
        if self.port_ranges is not None:
            for k in self.port_ranges:
                result['PortRanges'].append(k.to_map() if k else None)
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_ids is not None:
            result['TagIds'] = self.tag_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addresses') is not None:
            self.addresses = m.get('Addresses')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('AutoGenerated') is not None:
            self.auto_generated = m.get('AutoGenerated')
        if m.get('BrowserAccessStatus') is not None:
            self.browser_access_status = m.get('BrowserAccessStatus')
        if m.get('ConnectorIds') is not None:
            self.connector_ids = m.get('ConnectorIds')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('L7ProxyDomainAutomatic') is not None:
            self.l_7proxy_domain_automatic = m.get('L7ProxyDomainAutomatic')
        if m.get('L7ProxyDomainCustom') is not None:
            self.l_7proxy_domain_custom = m.get('L7ProxyDomainCustom')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        self.port_ranges = []
        if m.get('PortRanges') is not None:
            for k in m.get('PortRanges'):
                temp_model = ListPrivateAccessApplicationsResponseBodyApplicationsPortRanges()
                self.port_ranges.append(temp_model.from_map(k))
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagIds') is not None:
            self.tag_ids = m.get('TagIds')
        return self


class ListPrivateAccessApplicationsResponseBody(TeaModel):
    def __init__(
        self,
        applications: List[ListPrivateAccessApplicationsResponseBodyApplications] = None,
        request_id: str = None,
        total_num: int = None,
    ):
        self.applications = applications
        self.request_id = request_id
        self.total_num = total_num

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = ListPrivateAccessApplicationsResponseBodyApplications()
                self.applications.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListPrivateAccessApplicationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPrivateAccessApplicationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPrivateAccessApplicationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPrivateAccessApplicationsForDynamicRouteRequest(TeaModel):
    def __init__(
        self,
        dynamic_route_ids: List[str] = None,
    ):
        # This parameter is required.
        self.dynamic_route_ids = dynamic_route_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_route_ids is not None:
            result['DynamicRouteIds'] = self.dynamic_route_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DynamicRouteIds') is not None:
            self.dynamic_route_ids = m.get('DynamicRouteIds')
        return self


class ListPrivateAccessApplicationsForDynamicRouteResponseBodyDynamicRoutesApplicationsPortRanges(TeaModel):
    def __init__(
        self,
        begin: int = None,
        end: int = None,
    ):
        self.begin = begin
        self.end = end

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin is not None:
            result['Begin'] = self.begin
        if self.end is not None:
            result['End'] = self.end
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Begin') is not None:
            self.begin = m.get('Begin')
        if m.get('End') is not None:
            self.end = m.get('End')
        return self


class ListPrivateAccessApplicationsForDynamicRouteResponseBodyDynamicRoutesApplications(TeaModel):
    def __init__(
        self,
        addresses: List[str] = None,
        application_id: str = None,
        create_time: str = None,
        description: str = None,
        name: str = None,
        port_ranges: List[ListPrivateAccessApplicationsForDynamicRouteResponseBodyDynamicRoutesApplicationsPortRanges] = None,
        protocol: str = None,
        status: str = None,
    ):
        self.addresses = addresses
        self.application_id = application_id
        self.create_time = create_time
        self.description = description
        self.name = name
        self.port_ranges = port_ranges
        self.protocol = protocol
        self.status = status

    def validate(self):
        if self.port_ranges:
            for k in self.port_ranges:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addresses is not None:
            result['Addresses'] = self.addresses
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        result['PortRanges'] = []
        if self.port_ranges is not None:
            for k in self.port_ranges:
                result['PortRanges'].append(k.to_map() if k else None)
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addresses') is not None:
            self.addresses = m.get('Addresses')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.port_ranges = []
        if m.get('PortRanges') is not None:
            for k in m.get('PortRanges'):
                temp_model = ListPrivateAccessApplicationsForDynamicRouteResponseBodyDynamicRoutesApplicationsPortRanges()
                self.port_ranges.append(temp_model.from_map(k))
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListPrivateAccessApplicationsForDynamicRouteResponseBodyDynamicRoutes(TeaModel):
    def __init__(
        self,
        applications: List[ListPrivateAccessApplicationsForDynamicRouteResponseBodyDynamicRoutesApplications] = None,
        dynamic_route_id: str = None,
    ):
        self.applications = applications
        self.dynamic_route_id = dynamic_route_id

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        if self.dynamic_route_id is not None:
            result['DynamicRouteId'] = self.dynamic_route_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = ListPrivateAccessApplicationsForDynamicRouteResponseBodyDynamicRoutesApplications()
                self.applications.append(temp_model.from_map(k))
        if m.get('DynamicRouteId') is not None:
            self.dynamic_route_id = m.get('DynamicRouteId')
        return self


class ListPrivateAccessApplicationsForDynamicRouteResponseBody(TeaModel):
    def __init__(
        self,
        dynamic_routes: List[ListPrivateAccessApplicationsForDynamicRouteResponseBodyDynamicRoutes] = None,
        request_id: str = None,
    ):
        self.dynamic_routes = dynamic_routes
        self.request_id = request_id

    def validate(self):
        if self.dynamic_routes:
            for k in self.dynamic_routes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DynamicRoutes'] = []
        if self.dynamic_routes is not None:
            for k in self.dynamic_routes:
                result['DynamicRoutes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dynamic_routes = []
        if m.get('DynamicRoutes') is not None:
            for k in m.get('DynamicRoutes'):
                temp_model = ListPrivateAccessApplicationsForDynamicRouteResponseBodyDynamicRoutes()
                self.dynamic_routes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPrivateAccessApplicationsForDynamicRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPrivateAccessApplicationsForDynamicRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPrivateAccessApplicationsForDynamicRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPrivateAccessPolicesRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        application_name: str = None,
        current_page: int = None,
        name: str = None,
        page_size: int = None,
        policy_action: str = None,
        policy_ids: List[str] = None,
        status: str = None,
        tag_id: str = None,
        tag_name: str = None,
        user_group_id: str = None,
    ):
        # The ID of the office application. Either the ID or tag of the office application is used for queries. You can obtain the value by calling the following operations:
        # 
        # *   [ListPrivateAccessApplications](~~ListPrivateAccessApplications~~): queries office applications.
        # *   [CreatePrivateAccessApplication](~~CreatePrivateAccessApplication~~): creates an office application.
        self.application_id = application_id
        # The name of the office application.
        self.application_name = application_name
        # The page number. Valid values: 1 to 10000.
        # 
        # This parameter is required.
        self.current_page = current_page
        # The name of the private access policy. The value must be 1 to 128 characters in length and can contain letters, digits, hyphens (-), underscores (_), and periods (.).
        self.name = name
        # The number of entries per page. Valid values: 1 to 1000.
        # 
        # This parameter is required.
        self.page_size = page_size
        # The action in the private access policy. Valid values:
        # 
        # *   **Block**\
        # *   **Allow**\
        self.policy_action = policy_action
        # The IDs of the private access policies. You can enter up to 100 IDs.
        self.policy_ids = policy_ids
        # The status of the private access policy. Valid values:
        # 
        # *   **Enabled**\
        # *   **Disabled**\
        self.status = status
        # The ID of the tag for the office application. Either the ID or tag of the office application is used for queries. You can obtain the value by calling the following operations:
        # 
        # *   [ListPrivateAccessTags](~~ListPrivateAccessTags~~): queries tags for office applications.
        # *   [CreatePrivateAccessTag](~~CreatePrivateAccessTag~~): creates a tag for office applications.
        self.tag_id = tag_id
        # The name of the tag.
        self.tag_name = tag_name
        # The ID of the user group. You can obtain the value by calling the following operations:
        # 
        # *   [ListUserGroups](~~ListUserGroups~~): queries user groups.
        # *   [CreateUserGroup](~~CreateUserGroup~~): creates a user group.
        self.user_group_id = user_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.policy_action is not None:
            result['PolicyAction'] = self.policy_action
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PolicyAction') is not None:
            self.policy_action = m.get('PolicyAction')
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class ListPrivateAccessPolicesResponseBodyPolicesCustomUserAttributes(TeaModel):
    def __init__(
        self,
        idp_id: int = None,
        relation: str = None,
        user_group_type: str = None,
        value: str = None,
    ):
        # The ID of the identity provider (IdP) for the user group. If the value of UserGroupType is **department**, this parameter is returned.
        self.idp_id = idp_id
        # The logical operator for the user group. Valid values:
        # 
        # *   **Equal**\
        # *   **Unequal**\
        self.relation = relation
        # The type of the user group, which is the key of the attribute. Valid values:
        # 
        # *   **username**\
        # *   **department**\
        # *   **email**\
        # *   **telephone**\
        self.user_group_type = user_group_type
        # The value of the attribute.
        # 
        # *   If the value of UserGroupType is **username**, the value of this parameter is a username. The value must be 1 to 128 characters in length and can contain letters, digits, hyphens (-), underscores (_), and periods (.).
        # *   If the value of UserGroupType is **department**, the value of this parameter is a department. Examples: OU=Department 1, OU=SASE DingTalk.
        # *   If the value of UserGroupType is **email**, the value of this parameter is an email address. Example: username@example.com.
        # *   If the value of UserGroupType is **telephone**, the value of this parameter is a mobile phone number. Example: 13900001234.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idp_id is not None:
            result['IdpId'] = self.idp_id
        if self.relation is not None:
            result['Relation'] = self.relation
        if self.user_group_type is not None:
            result['UserGroupType'] = self.user_group_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdpId') is not None:
            self.idp_id = m.get('IdpId')
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        if m.get('UserGroupType') is not None:
            self.user_group_type = m.get('UserGroupType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListPrivateAccessPolicesResponseBodyPolices(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        application_type: str = None,
        create_time: str = None,
        custom_user_attributes: List[ListPrivateAccessPolicesResponseBodyPolicesCustomUserAttributes] = None,
        description: str = None,
        device_attribute_action: str = None,
        device_attribute_id: str = None,
        name: str = None,
        policy_action: str = None,
        policy_id: str = None,
        priority: int = None,
        status: str = None,
        tag_ids: List[str] = None,
        trigger_template_id: str = None,
        trusted_process_group_ids: List[str] = None,
        trusted_process_status: str = None,
        trusted_software_ids: List[str] = None,
        user_group_ids: List[str] = None,
        user_group_mode: str = None,
    ):
        # The IDs of the applications that are specified in the private access policy. If the value of ApplicationType is **Application**, this parameter is returned.
        self.application_ids = application_ids
        # The application type of the private access policy. Valid values:
        # 
        # *   **Application**\
        # *   **Tag**\
        self.application_type = application_type
        # The creation time of the private access policy.
        self.create_time = create_time
        # The attributes of the custom user group. The attributes of the custom user group are evaluated by using a logical OR. If an attribute is matched, the policy takes effect.
        self.custom_user_attributes = custom_user_attributes
        # The description of the private access policy.
        self.description = description
        # The action that is performed when the security baseline is not met. Valid values:
        # 
        # *   **Block**\
        # *   **Observe**\
        self.device_attribute_action = device_attribute_action
        # The ID of the security baseline.
        self.device_attribute_id = device_attribute_id
        # The name of the private access policy.
        self.name = name
        # The action in the private access policy. Valid values:
        # 
        # *   **Block**\
        # *   **Allow**\
        self.policy_action = policy_action
        # The ID of the private access policy.
        self.policy_id = policy_id
        # The priority of the private access policy. The value 1 indicates the highest priority.
        self.priority = priority
        # The status of the private access policy. Valid values:
        # 
        # *   **Enabled**\
        # *   **Disabled**\
        self.status = status
        # The IDs of the tags that are specified in the private access policy. If the value of ApplicationType is **Tag**, this parameter is returned.
        self.tag_ids = tag_ids
        # The ID of the trigger template.
        self.trigger_template_id = trigger_template_id
        # List of trusted process group IDs.
        self.trusted_process_group_ids = trusted_process_group_ids
        # Trusted process switch status. Values: 
        # - **Enabled**: On.
        # - **Disabled**: Off.
        self.trusted_process_status = trusted_process_status
        # List of trusted software IDs.
        self.trusted_software_ids = trusted_software_ids
        # The IDs of user groups in the private access policy. If the value of UserGroupMode is **Normal**, this parameter is returned.
        self.user_group_ids = user_group_ids
        # The type of the user group in the private access policy. Valid values:
        # 
        # *   **Normal**: regular user group.
        # *   **Custom**: custom user group.
        self.user_group_mode = user_group_mode

    def validate(self):
        if self.custom_user_attributes:
            for k in self.custom_user_attributes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.application_type is not None:
            result['ApplicationType'] = self.application_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['CustomUserAttributes'] = []
        if self.custom_user_attributes is not None:
            for k in self.custom_user_attributes:
                result['CustomUserAttributes'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.device_attribute_action is not None:
            result['DeviceAttributeAction'] = self.device_attribute_action
        if self.device_attribute_id is not None:
            result['DeviceAttributeId'] = self.device_attribute_id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_action is not None:
            result['PolicyAction'] = self.policy_action
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_ids is not None:
            result['TagIds'] = self.tag_ids
        if self.trigger_template_id is not None:
            result['TriggerTemplateId'] = self.trigger_template_id
        if self.trusted_process_group_ids is not None:
            result['TrustedProcessGroupIds'] = self.trusted_process_group_ids
        if self.trusted_process_status is not None:
            result['TrustedProcessStatus'] = self.trusted_process_status
        if self.trusted_software_ids is not None:
            result['TrustedSoftwareIds'] = self.trusted_software_ids
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        if self.user_group_mode is not None:
            result['UserGroupMode'] = self.user_group_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('ApplicationType') is not None:
            self.application_type = m.get('ApplicationType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.custom_user_attributes = []
        if m.get('CustomUserAttributes') is not None:
            for k in m.get('CustomUserAttributes'):
                temp_model = ListPrivateAccessPolicesResponseBodyPolicesCustomUserAttributes()
                self.custom_user_attributes.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceAttributeAction') is not None:
            self.device_attribute_action = m.get('DeviceAttributeAction')
        if m.get('DeviceAttributeId') is not None:
            self.device_attribute_id = m.get('DeviceAttributeId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyAction') is not None:
            self.policy_action = m.get('PolicyAction')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagIds') is not None:
            self.tag_ids = m.get('TagIds')
        if m.get('TriggerTemplateId') is not None:
            self.trigger_template_id = m.get('TriggerTemplateId')
        if m.get('TrustedProcessGroupIds') is not None:
            self.trusted_process_group_ids = m.get('TrustedProcessGroupIds')
        if m.get('TrustedProcessStatus') is not None:
            self.trusted_process_status = m.get('TrustedProcessStatus')
        if m.get('TrustedSoftwareIds') is not None:
            self.trusted_software_ids = m.get('TrustedSoftwareIds')
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        if m.get('UserGroupMode') is not None:
            self.user_group_mode = m.get('UserGroupMode')
        return self


class ListPrivateAccessPolicesResponseBody(TeaModel):
    def __init__(
        self,
        polices: List[ListPrivateAccessPolicesResponseBodyPolices] = None,
        request_id: str = None,
        total_num: int = None,
    ):
        # The private access policies.
        self.polices = polices
        # The request ID.
        self.request_id = request_id
        # The total number of private access policies.
        self.total_num = total_num

    def validate(self):
        if self.polices:
            for k in self.polices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Polices'] = []
        if self.polices is not None:
            for k in self.polices:
                result['Polices'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.polices = []
        if m.get('Polices') is not None:
            for k in m.get('Polices'):
                temp_model = ListPrivateAccessPolicesResponseBodyPolices()
                self.polices.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListPrivateAccessPolicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPrivateAccessPolicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPrivateAccessPolicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPrivateAccessTagsRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        current_page: int = None,
        name: str = None,
        page_size: int = None,
        policy_id: str = None,
        simple_mode: bool = None,
        tag_ids: List[str] = None,
    ):
        # The ID of the internal access application. You can obtain the application ID by calling the following operations:
        # 
        # *   [ListPrivateAccessApplications](~~ListPrivateAccessApplications~~): queries all internal access applications.
        # *   [CreatePrivateAccessApplication](~~CreatePrivateAccessApplication~~): creates an internal access application.
        self.application_id = application_id
        # The page number. Valid values: 1 to 10000.
        # 
        # This parameter is required.
        self.current_page = current_page
        # The name of the internal access tag. The name must be 1 to 128 characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-).
        self.name = name
        # The number of entries per page. Valid values: 1 to 1000.
        # 
        # This parameter is required.
        self.page_size = page_size
        # The ID of the internal access policy. You can obtain the policy ID by calling the following operations:
        # 
        # *   [ListPrivateAccessPolices](~~ListPrivateAccessPolices~~): queries all internal access policies.
        # *   [CreatePrivateAccessPolicy](~~CreatePrivateAccessPolicy~~): creates an internal access policy.
        self.policy_id = policy_id
        # Specifies whether to enable the simple query mode. A value of true specifies that policy IDs are not queried.
        self.simple_mode = simple_mode
        # The IDs of internal access tags. You can specify up to 100 tag IDs.
        self.tag_ids = tag_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.simple_mode is not None:
            result['SimpleMode'] = self.simple_mode
        if self.tag_ids is not None:
            result['TagIds'] = self.tag_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('SimpleMode') is not None:
            self.simple_mode = m.get('SimpleMode')
        if m.get('TagIds') is not None:
            self.tag_ids = m.get('TagIds')
        return self


class ListPrivateAccessTagsResponseBodyTags(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        create_time: str = None,
        description: str = None,
        name: str = None,
        policy_ids: List[str] = None,
        tag_id: str = None,
        tag_type: str = None,
    ):
        # The IDs of the internal access applications.
        self.application_ids = application_ids
        # The time when the internal access tag was created.
        self.create_time = create_time
        # The description of the internal access tag.
        self.description = description
        # The name of the internal access tag.
        self.name = name
        # The IDs of the internal access policies.
        self.policy_ids = policy_ids
        # The ID of the internal access tag.
        self.tag_id = tag_id
        # The type of the internal access tag. Valid values:
        # 
        # *   **Default**\
        # *   **Custom**\
        self.tag_type = tag_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        if self.tag_type is not None:
            result['TagType'] = self.tag_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        if m.get('TagType') is not None:
            self.tag_type = m.get('TagType')
        return self


class ListPrivateAccessTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        tags: List[ListPrivateAccessTagsResponseBodyTags] = None,
        total_num: int = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The internal access tags.
        self.tags = tags
        # The total number of internal access tags.
        self.total_num = total_num

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = ListPrivateAccessTagsResponseBodyTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListPrivateAccessTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPrivateAccessTagsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPrivateAccessTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPrivateAccessTagsForDynamicRouteRequest(TeaModel):
    def __init__(
        self,
        dynamic_route_ids: List[str] = None,
    ):
        # This parameter is required.
        self.dynamic_route_ids = dynamic_route_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_route_ids is not None:
            result['DynamicRouteIds'] = self.dynamic_route_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DynamicRouteIds') is not None:
            self.dynamic_route_ids = m.get('DynamicRouteIds')
        return self


class ListPrivateAccessTagsForDynamicRouteResponseBodyDynamicRoutesTags(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        name: str = None,
        tag_id: str = None,
        tag_type: str = None,
    ):
        self.create_time = create_time
        self.description = description
        self.name = name
        self.tag_id = tag_id
        self.tag_type = tag_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        if self.tag_type is not None:
            result['TagType'] = self.tag_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        if m.get('TagType') is not None:
            self.tag_type = m.get('TagType')
        return self


class ListPrivateAccessTagsForDynamicRouteResponseBodyDynamicRoutes(TeaModel):
    def __init__(
        self,
        dynamic_route_id: str = None,
        tags: List[ListPrivateAccessTagsForDynamicRouteResponseBodyDynamicRoutesTags] = None,
    ):
        self.dynamic_route_id = dynamic_route_id
        self.tags = tags

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_route_id is not None:
            result['DynamicRouteId'] = self.dynamic_route_id
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DynamicRouteId') is not None:
            self.dynamic_route_id = m.get('DynamicRouteId')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = ListPrivateAccessTagsForDynamicRouteResponseBodyDynamicRoutesTags()
                self.tags.append(temp_model.from_map(k))
        return self


class ListPrivateAccessTagsForDynamicRouteResponseBody(TeaModel):
    def __init__(
        self,
        dynamic_routes: List[ListPrivateAccessTagsForDynamicRouteResponseBodyDynamicRoutes] = None,
        request_id: str = None,
    ):
        self.dynamic_routes = dynamic_routes
        self.request_id = request_id

    def validate(self):
        if self.dynamic_routes:
            for k in self.dynamic_routes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DynamicRoutes'] = []
        if self.dynamic_routes is not None:
            for k in self.dynamic_routes:
                result['DynamicRoutes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dynamic_routes = []
        if m.get('DynamicRoutes') is not None:
            for k in m.get('DynamicRoutes'):
                temp_model = ListPrivateAccessTagsForDynamicRouteResponseBodyDynamicRoutes()
                self.dynamic_routes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPrivateAccessTagsForDynamicRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPrivateAccessTagsForDynamicRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPrivateAccessTagsForDynamicRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRegistrationPoliciesRequest(TeaModel):
    def __init__(
        self,
        company_limit_type: str = None,
        current_page: int = None,
        match_mode: str = None,
        name: str = None,
        page_size: int = None,
        personal_limit_type: str = None,
        policy_ids: List[str] = None,
        status: str = None,
        user_group_id: str = None,
    ):
        self.company_limit_type = company_limit_type
        # This parameter is required.
        self.current_page = current_page
        self.match_mode = match_mode
        self.name = name
        # This parameter is required.
        self.page_size = page_size
        self.personal_limit_type = personal_limit_type
        self.policy_ids = policy_ids
        self.status = status
        self.user_group_id = user_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.company_limit_type is not None:
            result['CompanyLimitType'] = self.company_limit_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.match_mode is not None:
            result['MatchMode'] = self.match_mode
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.personal_limit_type is not None:
            result['PersonalLimitType'] = self.personal_limit_type
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.status is not None:
            result['Status'] = self.status
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompanyLimitType') is not None:
            self.company_limit_type = m.get('CompanyLimitType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('MatchMode') is not None:
            self.match_mode = m.get('MatchMode')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PersonalLimitType') is not None:
            self.personal_limit_type = m.get('PersonalLimitType')
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class ListRegistrationPoliciesResponseBodyPoliciesLimitDetailLimitCount(TeaModel):
    def __init__(
        self,
        all: int = None,
        mobile: int = None,
        pc: int = None,
    ):
        self.all = all
        self.mobile = mobile
        self.pc = pc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all is not None:
            result['All'] = self.all
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.pc is not None:
            result['PC'] = self.pc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('All') is not None:
            self.all = m.get('All')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('PC') is not None:
            self.pc = m.get('PC')
        return self


class ListRegistrationPoliciesResponseBodyPoliciesLimitDetail(TeaModel):
    def __init__(
        self,
        device_belong: str = None,
        limit_count: ListRegistrationPoliciesResponseBodyPoliciesLimitDetailLimitCount = None,
        limit_type: str = None,
    ):
        self.device_belong = device_belong
        self.limit_count = limit_count
        self.limit_type = limit_type

    def validate(self):
        if self.limit_count:
            self.limit_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_belong is not None:
            result['DeviceBelong'] = self.device_belong
        if self.limit_count is not None:
            result['LimitCount'] = self.limit_count.to_map()
        if self.limit_type is not None:
            result['LimitType'] = self.limit_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceBelong') is not None:
            self.device_belong = m.get('DeviceBelong')
        if m.get('LimitCount') is not None:
            temp_model = ListRegistrationPoliciesResponseBodyPoliciesLimitDetailLimitCount()
            self.limit_count = temp_model.from_map(m['LimitCount'])
        if m.get('LimitType') is not None:
            self.limit_type = m.get('LimitType')
        return self


class ListRegistrationPoliciesResponseBodyPolicies(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        limit_detail: List[ListRegistrationPoliciesResponseBodyPoliciesLimitDetail] = None,
        match_mode: str = None,
        name: str = None,
        policy_id: str = None,
        priority: int = None,
        status: str = None,
        user_group_ids: List[str] = None,
        whitelist: List[str] = None,
    ):
        self.create_time = create_time
        self.description = description
        self.limit_detail = limit_detail
        self.match_mode = match_mode
        self.name = name
        self.policy_id = policy_id
        self.priority = priority
        self.status = status
        self.user_group_ids = user_group_ids
        self.whitelist = whitelist

    def validate(self):
        if self.limit_detail:
            for k in self.limit_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        result['LimitDetail'] = []
        if self.limit_detail is not None:
            for k in self.limit_detail:
                result['LimitDetail'].append(k.to_map() if k else None)
        if self.match_mode is not None:
            result['MatchMode'] = self.match_mode
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.status is not None:
            result['Status'] = self.status
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        if self.whitelist is not None:
            result['Whitelist'] = self.whitelist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.limit_detail = []
        if m.get('LimitDetail') is not None:
            for k in m.get('LimitDetail'):
                temp_model = ListRegistrationPoliciesResponseBodyPoliciesLimitDetail()
                self.limit_detail.append(temp_model.from_map(k))
        if m.get('MatchMode') is not None:
            self.match_mode = m.get('MatchMode')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        if m.get('Whitelist') is not None:
            self.whitelist = m.get('Whitelist')
        return self


class ListRegistrationPoliciesResponseBody(TeaModel):
    def __init__(
        self,
        policies: List[ListRegistrationPoliciesResponseBodyPolicies] = None,
        request_id: str = None,
        total_num: str = None,
    ):
        self.policies = policies
        self.request_id = request_id
        self.total_num = total_num

    def validate(self):
        if self.policies:
            for k in self.policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Policies'] = []
        if self.policies is not None:
            for k in self.policies:
                result['Policies'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.policies = []
        if m.get('Policies') is not None:
            for k in m.get('Policies'):
                temp_model = ListRegistrationPoliciesResponseBodyPolicies()
                self.policies.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListRegistrationPoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListRegistrationPoliciesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListRegistrationPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRegistrationPoliciesForUserGroupRequest(TeaModel):
    def __init__(
        self,
        user_group_ids: List[str] = None,
    ):
        # This parameter is required.
        self.user_group_ids = user_group_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        return self


class ListRegistrationPoliciesForUserGroupResponseBodyUserGroupsPoliciesLimitDetailLimitCount(TeaModel):
    def __init__(
        self,
        all: str = None,
        mobile: str = None,
        pc: str = None,
    ):
        self.all = all
        self.mobile = mobile
        self.pc = pc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all is not None:
            result['All'] = self.all
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.pc is not None:
            result['PC'] = self.pc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('All') is not None:
            self.all = m.get('All')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('PC') is not None:
            self.pc = m.get('PC')
        return self


class ListRegistrationPoliciesForUserGroupResponseBodyUserGroupsPoliciesLimitDetail(TeaModel):
    def __init__(
        self,
        device_belong: str = None,
        limit_count: ListRegistrationPoliciesForUserGroupResponseBodyUserGroupsPoliciesLimitDetailLimitCount = None,
        limit_type: str = None,
    ):
        self.device_belong = device_belong
        self.limit_count = limit_count
        self.limit_type = limit_type

    def validate(self):
        if self.limit_count:
            self.limit_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_belong is not None:
            result['DeviceBelong'] = self.device_belong
        if self.limit_count is not None:
            result['LimitCount'] = self.limit_count.to_map()
        if self.limit_type is not None:
            result['LimitType'] = self.limit_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceBelong') is not None:
            self.device_belong = m.get('DeviceBelong')
        if m.get('LimitCount') is not None:
            temp_model = ListRegistrationPoliciesForUserGroupResponseBodyUserGroupsPoliciesLimitDetailLimitCount()
            self.limit_count = temp_model.from_map(m['LimitCount'])
        if m.get('LimitType') is not None:
            self.limit_type = m.get('LimitType')
        return self


class ListRegistrationPoliciesForUserGroupResponseBodyUserGroupsPolicies(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        limit_detail: List[ListRegistrationPoliciesForUserGroupResponseBodyUserGroupsPoliciesLimitDetail] = None,
        match_mode: str = None,
        name: str = None,
        policy_id: str = None,
        priority: int = None,
        status: str = None,
        whitelist: List[str] = None,
    ):
        self.create_time = create_time
        self.description = description
        self.limit_detail = limit_detail
        self.match_mode = match_mode
        self.name = name
        self.policy_id = policy_id
        self.priority = priority
        self.status = status
        self.whitelist = whitelist

    def validate(self):
        if self.limit_detail:
            for k in self.limit_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        result['LimitDetail'] = []
        if self.limit_detail is not None:
            for k in self.limit_detail:
                result['LimitDetail'].append(k.to_map() if k else None)
        if self.match_mode is not None:
            result['MatchMode'] = self.match_mode
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.status is not None:
            result['Status'] = self.status
        if self.whitelist is not None:
            result['Whitelist'] = self.whitelist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.limit_detail = []
        if m.get('LimitDetail') is not None:
            for k in m.get('LimitDetail'):
                temp_model = ListRegistrationPoliciesForUserGroupResponseBodyUserGroupsPoliciesLimitDetail()
                self.limit_detail.append(temp_model.from_map(k))
        if m.get('MatchMode') is not None:
            self.match_mode = m.get('MatchMode')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Whitelist') is not None:
            self.whitelist = m.get('Whitelist')
        return self


class ListRegistrationPoliciesForUserGroupResponseBodyUserGroups(TeaModel):
    def __init__(
        self,
        policies: List[ListRegistrationPoliciesForUserGroupResponseBodyUserGroupsPolicies] = None,
        user_group_id: str = None,
    ):
        self.policies = policies
        self.user_group_id = user_group_id

    def validate(self):
        if self.policies:
            for k in self.policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Policies'] = []
        if self.policies is not None:
            for k in self.policies:
                result['Policies'].append(k.to_map() if k else None)
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.policies = []
        if m.get('Policies') is not None:
            for k in m.get('Policies'):
                temp_model = ListRegistrationPoliciesForUserGroupResponseBodyUserGroupsPolicies()
                self.policies.append(temp_model.from_map(k))
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class ListRegistrationPoliciesForUserGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_groups: List[ListRegistrationPoliciesForUserGroupResponseBodyUserGroups] = None,
    ):
        self.request_id = request_id
        self.user_groups = user_groups

    def validate(self):
        if self.user_groups:
            for k in self.user_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['UserGroups'] = []
        if self.user_groups is not None:
            for k in self.user_groups:
                result['UserGroups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.user_groups = []
        if m.get('UserGroups') is not None:
            for k in m.get('UserGroups'):
                temp_model = ListRegistrationPoliciesForUserGroupResponseBodyUserGroups()
                self.user_groups.append(temp_model.from_map(k))
        return self


class ListRegistrationPoliciesForUserGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListRegistrationPoliciesForUserGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListRegistrationPoliciesForUserGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSoftwareForUserDeviceRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        device_tag: str = None,
        page_size: int = None,
    ):
        # This parameter is required.
        self.current_page = current_page
        # This parameter is required.
        self.device_tag = device_tag
        # This parameter is required.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.device_tag is not None:
            result['DeviceTag'] = self.device_tag
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DeviceTag') is not None:
            self.device_tag = m.get('DeviceTag')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListSoftwareForUserDeviceResponseBodySoftware(TeaModel):
    def __init__(
        self,
        inc: str = None,
        install_time: str = None,
        name: str = None,
        versions: List[str] = None,
    ):
        self.inc = inc
        self.install_time = install_time
        self.name = name
        self.versions = versions

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inc is not None:
            result['Inc'] = self.inc
        if self.install_time is not None:
            result['InstallTime'] = self.install_time
        if self.name is not None:
            result['Name'] = self.name
        if self.versions is not None:
            result['Versions'] = self.versions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Inc') is not None:
            self.inc = m.get('Inc')
        if m.get('InstallTime') is not None:
            self.install_time = m.get('InstallTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Versions') is not None:
            self.versions = m.get('Versions')
        return self


class ListSoftwareForUserDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        software: List[ListSoftwareForUserDeviceResponseBodySoftware] = None,
        total_num: int = None,
    ):
        self.request_id = request_id
        self.software = software
        self.total_num = total_num

    def validate(self):
        if self.software:
            for k in self.software:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Software'] = []
        if self.software is not None:
            for k in self.software:
                result['Software'].append(k.to_map() if k else None)
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.software = []
        if m.get('Software') is not None:
            for k in m.get('Software'):
                temp_model = ListSoftwareForUserDeviceResponseBodySoftware()
                self.software.append(temp_model.from_map(k))
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListSoftwareForUserDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListSoftwareForUserDeviceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListSoftwareForUserDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTagsForPrivateAccessApplicationRequest(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
    ):
        # This parameter is required.
        self.application_ids = application_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        return self


class ListTagsForPrivateAccessApplicationResponseBodyApplicationsTags(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        name: str = None,
        tag_id: str = None,
        tag_type: str = None,
    ):
        self.create_time = create_time
        self.description = description
        self.name = name
        self.tag_id = tag_id
        self.tag_type = tag_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        if self.tag_type is not None:
            result['TagType'] = self.tag_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        if m.get('TagType') is not None:
            self.tag_type = m.get('TagType')
        return self


class ListTagsForPrivateAccessApplicationResponseBodyApplications(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        tags: List[ListTagsForPrivateAccessApplicationResponseBodyApplicationsTags] = None,
    ):
        self.application_id = application_id
        self.tags = tags

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = ListTagsForPrivateAccessApplicationResponseBodyApplicationsTags()
                self.tags.append(temp_model.from_map(k))
        return self


class ListTagsForPrivateAccessApplicationResponseBody(TeaModel):
    def __init__(
        self,
        applications: List[ListTagsForPrivateAccessApplicationResponseBodyApplications] = None,
        request_id: str = None,
    ):
        self.applications = applications
        self.request_id = request_id

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = ListTagsForPrivateAccessApplicationResponseBodyApplications()
                self.applications.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListTagsForPrivateAccessApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListTagsForPrivateAccessApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTagsForPrivateAccessApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTagsForPrivateAccessPolicyRequest(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
    ):
        # This parameter is required.
        self.policy_ids = policy_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        return self


class ListTagsForPrivateAccessPolicyResponseBodyPolicesTags(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        name: str = None,
        tag_id: str = None,
        tag_type: str = None,
    ):
        # 内网访问标签创建时间。
        self.create_time = create_time
        self.description = description
        self.name = name
        self.tag_id = tag_id
        self.tag_type = tag_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        if self.tag_type is not None:
            result['TagType'] = self.tag_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        if m.get('TagType') is not None:
            self.tag_type = m.get('TagType')
        return self


class ListTagsForPrivateAccessPolicyResponseBodyPolices(TeaModel):
    def __init__(
        self,
        policy_id: str = None,
        tags: List[ListTagsForPrivateAccessPolicyResponseBodyPolicesTags] = None,
    ):
        self.policy_id = policy_id
        self.tags = tags

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = ListTagsForPrivateAccessPolicyResponseBodyPolicesTags()
                self.tags.append(temp_model.from_map(k))
        return self


class ListTagsForPrivateAccessPolicyResponseBody(TeaModel):
    def __init__(
        self,
        polices: List[ListTagsForPrivateAccessPolicyResponseBodyPolices] = None,
        request_id: str = None,
    ):
        self.polices = polices
        self.request_id = request_id

    def validate(self):
        if self.polices:
            for k in self.polices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Polices'] = []
        if self.polices is not None:
            for k in self.polices:
                result['Polices'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.polices = []
        if m.get('Polices') is not None:
            for k in m.get('Polices'):
                temp_model = ListTagsForPrivateAccessPolicyResponseBodyPolices()
                self.polices.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListTagsForPrivateAccessPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListTagsForPrivateAccessPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTagsForPrivateAccessPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUninstallApplicationsRequest(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        current_page: int = None,
        department: str = None,
        hostname: str = None,
        mac: str = None,
        page_size: int = None,
        statuses: List[str] = None,
        username: str = None,
    ):
        self.application_ids = application_ids
        # This parameter is required.
        self.current_page = current_page
        self.department = department
        self.hostname = hostname
        self.mac = mac
        # This parameter is required.
        self.page_size = page_size
        self.statuses = statuses
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department is not None:
            result['Department'] = self.department
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.statuses is not None:
            result['Statuses'] = self.statuses
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Statuses') is not None:
            self.statuses = m.get('Statuses')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListUninstallApplicationsResponseBodyApplications(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        create_time: str = None,
        department: str = None,
        dev_tag: str = None,
        dev_type: str = None,
        hostname: str = None,
        idp_name: str = None,
        is_uninstall: bool = None,
        mac: str = None,
        reason: str = None,
        sase_user_id: str = None,
        status: str = None,
        username: str = None,
    ):
        self.application_id = application_id
        self.create_time = create_time
        self.department = department
        self.dev_tag = dev_tag
        self.dev_type = dev_type
        self.hostname = hostname
        self.idp_name = idp_name
        self.is_uninstall = is_uninstall
        self.mac = mac
        self.reason = reason
        self.sase_user_id = sase_user_id
        self.status = status
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.department is not None:
            result['Department'] = self.department
        if self.dev_tag is not None:
            result['DevTag'] = self.dev_tag
        if self.dev_type is not None:
            result['DevType'] = self.dev_type
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.idp_name is not None:
            result['IdpName'] = self.idp_name
        if self.is_uninstall is not None:
            result['IsUninstall'] = self.is_uninstall
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.status is not None:
            result['Status'] = self.status
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('DevTag') is not None:
            self.dev_tag = m.get('DevTag')
        if m.get('DevType') is not None:
            self.dev_type = m.get('DevType')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('IdpName') is not None:
            self.idp_name = m.get('IdpName')
        if m.get('IsUninstall') is not None:
            self.is_uninstall = m.get('IsUninstall')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListUninstallApplicationsResponseBody(TeaModel):
    def __init__(
        self,
        applications: List[ListUninstallApplicationsResponseBodyApplications] = None,
        request_id: str = None,
        total_num: int = None,
    ):
        self.applications = applications
        self.request_id = request_id
        self.total_num = total_num

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = ListUninstallApplicationsResponseBodyApplications()
                self.applications.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListUninstallApplicationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListUninstallApplicationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListUninstallApplicationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUserApplicationsRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        name: str = None,
        page_size: int = None,
        sase_user_id: str = None,
    ):
        # This parameter is required.
        self.current_page = current_page
        self.name = name
        # This parameter is required.
        self.page_size = page_size
        # This parameter is required.
        self.sase_user_id = sase_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        return self


class ListUserApplicationsResponseBodyApplicationsPortRanges(TeaModel):
    def __init__(
        self,
        begin: str = None,
        end: str = None,
    ):
        self.begin = begin
        self.end = end

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin is not None:
            result['Begin'] = self.begin
        if self.end is not None:
            result['End'] = self.end
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Begin') is not None:
            self.begin = m.get('Begin')
        if m.get('End') is not None:
            self.end = m.get('End')
        return self


class ListUserApplicationsResponseBodyApplications(TeaModel):
    def __init__(
        self,
        action: str = None,
        addresses: List[str] = None,
        application_id: str = None,
        name: str = None,
        port_ranges: List[ListUserApplicationsResponseBodyApplicationsPortRanges] = None,
        protocol: str = None,
    ):
        self.action = action
        self.addresses = addresses
        self.application_id = application_id
        self.name = name
        self.port_ranges = port_ranges
        self.protocol = protocol

    def validate(self):
        if self.port_ranges:
            for k in self.port_ranges:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.addresses is not None:
            result['Addresses'] = self.addresses
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.name is not None:
            result['Name'] = self.name
        result['PortRanges'] = []
        if self.port_ranges is not None:
            for k in self.port_ranges:
                result['PortRanges'].append(k.to_map() if k else None)
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Addresses') is not None:
            self.addresses = m.get('Addresses')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.port_ranges = []
        if m.get('PortRanges') is not None:
            for k in m.get('PortRanges'):
                temp_model = ListUserApplicationsResponseBodyApplicationsPortRanges()
                self.port_ranges.append(temp_model.from_map(k))
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class ListUserApplicationsResponseBody(TeaModel):
    def __init__(
        self,
        applications: List[ListUserApplicationsResponseBodyApplications] = None,
        request_id: str = None,
        total_num: int = None,
    ):
        self.applications = applications
        # Id of the request
        self.request_id = request_id
        self.total_num = total_num

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = ListUserApplicationsResponseBodyApplications()
                self.applications.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListUserApplicationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListUserApplicationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListUserApplicationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUserDevicesRequest(TeaModel):
    def __init__(
        self,
        app_statuses: List[str] = None,
        app_versions: List[str] = None,
        current_page: int = None,
        department: str = None,
        device_belong: str = None,
        device_group_id: str = None,
        device_statuses: List[str] = None,
        device_tags: List[str] = None,
        device_types: List[str] = None,
        dlp_statuses: List[str] = None,
        hostname: str = None,
        ia_statuses: List[str] = None,
        inner_ip: str = None,
        mac: str = None,
        nac_statuses: List[str] = None,
        pa_statuses: List[str] = None,
        page_size: int = None,
        sase_user_id: str = None,
        sharing_status: bool = None,
        sn_system: str = None,
        sort_by: str = None,
        username: str = None,
        workshop: str = None,
    ):
        self.app_statuses = app_statuses
        self.app_versions = app_versions
        # This parameter is required.
        self.current_page = current_page
        self.department = department
        self.device_belong = device_belong
        self.device_group_id = device_group_id
        self.device_statuses = device_statuses
        self.device_tags = device_tags
        self.device_types = device_types
        self.dlp_statuses = dlp_statuses
        self.hostname = hostname
        self.ia_statuses = ia_statuses
        self.inner_ip = inner_ip
        self.mac = mac
        self.nac_statuses = nac_statuses
        self.pa_statuses = pa_statuses
        # This parameter is required.
        self.page_size = page_size
        self.sase_user_id = sase_user_id
        self.sharing_status = sharing_status
        self.sn_system = sn_system
        self.sort_by = sort_by
        self.username = username
        self.workshop = workshop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_statuses is not None:
            result['AppStatuses'] = self.app_statuses
        if self.app_versions is not None:
            result['AppVersions'] = self.app_versions
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department is not None:
            result['Department'] = self.department
        if self.device_belong is not None:
            result['DeviceBelong'] = self.device_belong
        if self.device_group_id is not None:
            result['DeviceGroupId'] = self.device_group_id
        if self.device_statuses is not None:
            result['DeviceStatuses'] = self.device_statuses
        if self.device_tags is not None:
            result['DeviceTags'] = self.device_tags
        if self.device_types is not None:
            result['DeviceTypes'] = self.device_types
        if self.dlp_statuses is not None:
            result['DlpStatuses'] = self.dlp_statuses
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.ia_statuses is not None:
            result['IaStatuses'] = self.ia_statuses
        if self.inner_ip is not None:
            result['InnerIp'] = self.inner_ip
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.nac_statuses is not None:
            result['NacStatuses'] = self.nac_statuses
        if self.pa_statuses is not None:
            result['PaStatuses'] = self.pa_statuses
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.sharing_status is not None:
            result['SharingStatus'] = self.sharing_status
        if self.sn_system is not None:
            result['SnSystem'] = self.sn_system
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.username is not None:
            result['Username'] = self.username
        if self.workshop is not None:
            result['Workshop'] = self.workshop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppStatuses') is not None:
            self.app_statuses = m.get('AppStatuses')
        if m.get('AppVersions') is not None:
            self.app_versions = m.get('AppVersions')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('DeviceBelong') is not None:
            self.device_belong = m.get('DeviceBelong')
        if m.get('DeviceGroupId') is not None:
            self.device_group_id = m.get('DeviceGroupId')
        if m.get('DeviceStatuses') is not None:
            self.device_statuses = m.get('DeviceStatuses')
        if m.get('DeviceTags') is not None:
            self.device_tags = m.get('DeviceTags')
        if m.get('DeviceTypes') is not None:
            self.device_types = m.get('DeviceTypes')
        if m.get('DlpStatuses') is not None:
            self.dlp_statuses = m.get('DlpStatuses')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('IaStatuses') is not None:
            self.ia_statuses = m.get('IaStatuses')
        if m.get('InnerIp') is not None:
            self.inner_ip = m.get('InnerIp')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('NacStatuses') is not None:
            self.nac_statuses = m.get('NacStatuses')
        if m.get('PaStatuses') is not None:
            self.pa_statuses = m.get('PaStatuses')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('SharingStatus') is not None:
            self.sharing_status = m.get('SharingStatus')
        if m.get('SnSystem') is not None:
            self.sn_system = m.get('SnSystem')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        if m.get('Workshop') is not None:
            self.workshop = m.get('Workshop')
        return self


class ListUserDevicesResponseBodyDevicesNetInterfaceInfo(TeaModel):
    def __init__(
        self,
        mac: str = None,
        name: str = None,
    ):
        self.mac = mac
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ListUserDevicesResponseBodyDevices(TeaModel):
    def __init__(
        self,
        app_status: str = None,
        app_version: str = None,
        cpu: str = None,
        create_time: str = None,
        department: str = None,
        device_belong: str = None,
        device_model: str = None,
        device_status: str = None,
        device_tag: str = None,
        device_type: str = None,
        device_version: str = None,
        disk: str = None,
        dlp_status: str = None,
        edr_status: str = None,
        hostname: str = None,
        ia_status: str = None,
        inner_ip: str = None,
        mac: str = None,
        match_device_group_ids: List[str] = None,
        memory: str = None,
        nac_status: str = None,
        net_interface_info: List[ListUserDevicesResponseBodyDevicesNetInterfaceInfo] = None,
        pa_status: str = None,
        sase_user_id: str = None,
        sharing_status: bool = None,
        sn_base_board: str = None,
        sn_bios: str = None,
        sn_disk_drive: str = None,
        sn_processor: str = None,
        sn_system: str = None,
        src_ip: str = None,
        update_time: str = None,
        username: str = None,
        workshop: str = None,
    ):
        self.app_status = app_status
        self.app_version = app_version
        self.cpu = cpu
        self.create_time = create_time
        self.department = department
        self.device_belong = device_belong
        self.device_model = device_model
        self.device_status = device_status
        self.device_tag = device_tag
        self.device_type = device_type
        self.device_version = device_version
        self.disk = disk
        self.dlp_status = dlp_status
        self.edr_status = edr_status
        self.hostname = hostname
        self.ia_status = ia_status
        self.inner_ip = inner_ip
        self.mac = mac
        self.match_device_group_ids = match_device_group_ids
        self.memory = memory
        self.nac_status = nac_status
        self.net_interface_info = net_interface_info
        self.pa_status = pa_status
        self.sase_user_id = sase_user_id
        self.sharing_status = sharing_status
        self.sn_base_board = sn_base_board
        self.sn_bios = sn_bios
        self.sn_disk_drive = sn_disk_drive
        self.sn_processor = sn_processor
        self.sn_system = sn_system
        self.src_ip = src_ip
        self.update_time = update_time
        self.username = username
        self.workshop = workshop

    def validate(self):
        if self.net_interface_info:
            for k in self.net_interface_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_status is not None:
            result['AppStatus'] = self.app_status
        if self.app_version is not None:
            result['AppVersion'] = self.app_version
        if self.cpu is not None:
            result['CPU'] = self.cpu
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.department is not None:
            result['Department'] = self.department
        if self.device_belong is not None:
            result['DeviceBelong'] = self.device_belong
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_tag is not None:
            result['DeviceTag'] = self.device_tag
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.device_version is not None:
            result['DeviceVersion'] = self.device_version
        if self.disk is not None:
            result['Disk'] = self.disk
        if self.dlp_status is not None:
            result['DlpStatus'] = self.dlp_status
        if self.edr_status is not None:
            result['EdrStatus'] = self.edr_status
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.ia_status is not None:
            result['IaStatus'] = self.ia_status
        if self.inner_ip is not None:
            result['InnerIP'] = self.inner_ip
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.match_device_group_ids is not None:
            result['MatchDeviceGroupIds'] = self.match_device_group_ids
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.nac_status is not None:
            result['NacStatus'] = self.nac_status
        result['NetInterfaceInfo'] = []
        if self.net_interface_info is not None:
            for k in self.net_interface_info:
                result['NetInterfaceInfo'].append(k.to_map() if k else None)
        if self.pa_status is not None:
            result['PaStatus'] = self.pa_status
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.sharing_status is not None:
            result['SharingStatus'] = self.sharing_status
        if self.sn_base_board is not None:
            result['SnBaseBoard'] = self.sn_base_board
        if self.sn_bios is not None:
            result['SnBios'] = self.sn_bios
        if self.sn_disk_drive is not None:
            result['SnDiskDrive'] = self.sn_disk_drive
        if self.sn_processor is not None:
            result['SnProcessor'] = self.sn_processor
        if self.sn_system is not None:
            result['SnSystem'] = self.sn_system
        if self.src_ip is not None:
            result['SrcIP'] = self.src_ip
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.username is not None:
            result['Username'] = self.username
        if self.workshop is not None:
            result['Workshop'] = self.workshop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppStatus') is not None:
            self.app_status = m.get('AppStatus')
        if m.get('AppVersion') is not None:
            self.app_version = m.get('AppVersion')
        if m.get('CPU') is not None:
            self.cpu = m.get('CPU')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('DeviceBelong') is not None:
            self.device_belong = m.get('DeviceBelong')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceTag') is not None:
            self.device_tag = m.get('DeviceTag')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('DeviceVersion') is not None:
            self.device_version = m.get('DeviceVersion')
        if m.get('Disk') is not None:
            self.disk = m.get('Disk')
        if m.get('DlpStatus') is not None:
            self.dlp_status = m.get('DlpStatus')
        if m.get('EdrStatus') is not None:
            self.edr_status = m.get('EdrStatus')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('IaStatus') is not None:
            self.ia_status = m.get('IaStatus')
        if m.get('InnerIP') is not None:
            self.inner_ip = m.get('InnerIP')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('MatchDeviceGroupIds') is not None:
            self.match_device_group_ids = m.get('MatchDeviceGroupIds')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('NacStatus') is not None:
            self.nac_status = m.get('NacStatus')
        self.net_interface_info = []
        if m.get('NetInterfaceInfo') is not None:
            for k in m.get('NetInterfaceInfo'):
                temp_model = ListUserDevicesResponseBodyDevicesNetInterfaceInfo()
                self.net_interface_info.append(temp_model.from_map(k))
        if m.get('PaStatus') is not None:
            self.pa_status = m.get('PaStatus')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('SharingStatus') is not None:
            self.sharing_status = m.get('SharingStatus')
        if m.get('SnBaseBoard') is not None:
            self.sn_base_board = m.get('SnBaseBoard')
        if m.get('SnBios') is not None:
            self.sn_bios = m.get('SnBios')
        if m.get('SnDiskDrive') is not None:
            self.sn_disk_drive = m.get('SnDiskDrive')
        if m.get('SnProcessor') is not None:
            self.sn_processor = m.get('SnProcessor')
        if m.get('SnSystem') is not None:
            self.sn_system = m.get('SnSystem')
        if m.get('SrcIP') is not None:
            self.src_ip = m.get('SrcIP')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        if m.get('Workshop') is not None:
            self.workshop = m.get('Workshop')
        return self


class ListUserDevicesResponseBody(TeaModel):
    def __init__(
        self,
        devices: List[ListUserDevicesResponseBodyDevices] = None,
        request_id: str = None,
        total_num: int = None,
    ):
        self.devices = devices
        self.request_id = request_id
        self.total_num = total_num

    def validate(self):
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = ListUserDevicesResponseBodyDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListUserDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListUserDevicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListUserDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUserGroupsRequest(TeaModel):
    def __init__(
        self,
        attribute_value: str = None,
        current_page: int = None,
        name: str = None,
        papolicy_id: str = None,
        page_size: int = None,
        user_group_ids: List[str] = None,
    ):
        self.attribute_value = attribute_value
        # This parameter is required.
        self.current_page = current_page
        # 用户组名称。长度为1~128个字符，支持中文和大小写英文字母，可包含数字、半角句号（.）、下划线（_）和短划线（-）。
        self.name = name
        self.papolicy_id = papolicy_id
        # This parameter is required.
        self.page_size = page_size
        self.user_group_ids = user_group_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_value is not None:
            result['AttributeValue'] = self.attribute_value
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.name is not None:
            result['Name'] = self.name
        if self.papolicy_id is not None:
            result['PAPolicyId'] = self.papolicy_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttributeValue') is not None:
            self.attribute_value = m.get('AttributeValue')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PAPolicyId') is not None:
            self.papolicy_id = m.get('PAPolicyId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        return self


class ListUserGroupsResponseBodyUserGroupsAttributes(TeaModel):
    def __init__(
        self,
        idp_id: int = None,
        relation: str = None,
        user_group_type: str = None,
        value: str = None,
    ):
        self.idp_id = idp_id
        self.relation = relation
        self.user_group_type = user_group_type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idp_id is not None:
            result['IdpId'] = self.idp_id
        if self.relation is not None:
            result['Relation'] = self.relation
        if self.user_group_type is not None:
            result['UserGroupType'] = self.user_group_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdpId') is not None:
            self.idp_id = m.get('IdpId')
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        if m.get('UserGroupType') is not None:
            self.user_group_type = m.get('UserGroupType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListUserGroupsResponseBodyUserGroups(TeaModel):
    def __init__(
        self,
        attributes: List[ListUserGroupsResponseBodyUserGroupsAttributes] = None,
        create_time: str = None,
        description: str = None,
        name: str = None,
        user_group_id: str = None,
    ):
        self.attributes = attributes
        self.create_time = create_time
        self.description = description
        self.name = name
        self.user_group_id = user_group_id

    def validate(self):
        if self.attributes:
            for k in self.attributes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attributes'] = []
        if self.attributes is not None:
            for k in self.attributes:
                result['Attributes'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attributes = []
        if m.get('Attributes') is not None:
            for k in m.get('Attributes'):
                temp_model = ListUserGroupsResponseBodyUserGroupsAttributes()
                self.attributes.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class ListUserGroupsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total_num: int = None,
        user_groups: List[ListUserGroupsResponseBodyUserGroups] = None,
    ):
        self.request_id = request_id
        self.total_num = total_num
        self.user_groups = user_groups

    def validate(self):
        if self.user_groups:
            for k in self.user_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        result['UserGroups'] = []
        if self.user_groups is not None:
            for k in self.user_groups:
                result['UserGroups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        self.user_groups = []
        if m.get('UserGroups') is not None:
            for k in m.get('UserGroups'):
                temp_model = ListUserGroupsResponseBodyUserGroups()
                self.user_groups.append(temp_model.from_map(k))
        return self


class ListUserGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListUserGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListUserGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUserGroupsForPrivateAccessPolicyRequest(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
    ):
        # This parameter is required.
        self.policy_ids = policy_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        return self


class ListUserGroupsForPrivateAccessPolicyResponseBodyPolicesUserGroupsAttributes(TeaModel):
    def __init__(
        self,
        idp_id: int = None,
        relation: str = None,
        user_group_type: str = None,
        value: str = None,
    ):
        self.idp_id = idp_id
        self.relation = relation
        self.user_group_type = user_group_type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idp_id is not None:
            result['IdpId'] = self.idp_id
        if self.relation is not None:
            result['Relation'] = self.relation
        if self.user_group_type is not None:
            result['UserGroupType'] = self.user_group_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdpId') is not None:
            self.idp_id = m.get('IdpId')
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        if m.get('UserGroupType') is not None:
            self.user_group_type = m.get('UserGroupType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListUserGroupsForPrivateAccessPolicyResponseBodyPolicesUserGroups(TeaModel):
    def __init__(
        self,
        attributes: List[ListUserGroupsForPrivateAccessPolicyResponseBodyPolicesUserGroupsAttributes] = None,
        create_time: str = None,
        description: str = None,
        name: str = None,
        user_group_id: str = None,
    ):
        self.attributes = attributes
        # 用户组创建时间。
        self.create_time = create_time
        self.description = description
        self.name = name
        self.user_group_id = user_group_id

    def validate(self):
        if self.attributes:
            for k in self.attributes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attributes'] = []
        if self.attributes is not None:
            for k in self.attributes:
                result['Attributes'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attributes = []
        if m.get('Attributes') is not None:
            for k in m.get('Attributes'):
                temp_model = ListUserGroupsForPrivateAccessPolicyResponseBodyPolicesUserGroupsAttributes()
                self.attributes.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class ListUserGroupsForPrivateAccessPolicyResponseBodyPolices(TeaModel):
    def __init__(
        self,
        policy_id: str = None,
        user_groups: List[ListUserGroupsForPrivateAccessPolicyResponseBodyPolicesUserGroups] = None,
    ):
        self.policy_id = policy_id
        self.user_groups = user_groups

    def validate(self):
        if self.user_groups:
            for k in self.user_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        result['UserGroups'] = []
        if self.user_groups is not None:
            for k in self.user_groups:
                result['UserGroups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        self.user_groups = []
        if m.get('UserGroups') is not None:
            for k in m.get('UserGroups'):
                temp_model = ListUserGroupsForPrivateAccessPolicyResponseBodyPolicesUserGroups()
                self.user_groups.append(temp_model.from_map(k))
        return self


class ListUserGroupsForPrivateAccessPolicyResponseBody(TeaModel):
    def __init__(
        self,
        polices: List[ListUserGroupsForPrivateAccessPolicyResponseBodyPolices] = None,
        request_id: str = None,
    ):
        self.polices = polices
        self.request_id = request_id

    def validate(self):
        if self.polices:
            for k in self.polices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Polices'] = []
        if self.polices is not None:
            for k in self.polices:
                result['Polices'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.polices = []
        if m.get('Polices') is not None:
            for k in m.get('Polices'):
                temp_model = ListUserGroupsForPrivateAccessPolicyResponseBodyPolices()
                self.polices.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListUserGroupsForPrivateAccessPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListUserGroupsForPrivateAccessPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListUserGroupsForPrivateAccessPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUserGroupsForRegistrationPolicyRequest(TeaModel):
    def __init__(
        self,
        policy_ids: List[str] = None,
    ):
        # This parameter is required.
        self.policy_ids = policy_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        return self


class ListUserGroupsForRegistrationPolicyResponseBodyPoliciesUserGroupsAttributes(TeaModel):
    def __init__(
        self,
        idp_id: int = None,
        relation: str = None,
        user_group_type: str = None,
        value: str = None,
    ):
        self.idp_id = idp_id
        self.relation = relation
        self.user_group_type = user_group_type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idp_id is not None:
            result['IdpId'] = self.idp_id
        if self.relation is not None:
            result['Relation'] = self.relation
        if self.user_group_type is not None:
            result['UserGroupType'] = self.user_group_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdpId') is not None:
            self.idp_id = m.get('IdpId')
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        if m.get('UserGroupType') is not None:
            self.user_group_type = m.get('UserGroupType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListUserGroupsForRegistrationPolicyResponseBodyPoliciesUserGroups(TeaModel):
    def __init__(
        self,
        attributes: List[ListUserGroupsForRegistrationPolicyResponseBodyPoliciesUserGroupsAttributes] = None,
        create_time: str = None,
        description: str = None,
        name: str = None,
        user_group_id: str = None,
    ):
        self.attributes = attributes
        self.create_time = create_time
        self.description = description
        self.name = name
        self.user_group_id = user_group_id

    def validate(self):
        if self.attributes:
            for k in self.attributes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attributes'] = []
        if self.attributes is not None:
            for k in self.attributes:
                result['Attributes'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attributes = []
        if m.get('Attributes') is not None:
            for k in m.get('Attributes'):
                temp_model = ListUserGroupsForRegistrationPolicyResponseBodyPoliciesUserGroupsAttributes()
                self.attributes.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class ListUserGroupsForRegistrationPolicyResponseBodyPolicies(TeaModel):
    def __init__(
        self,
        policy_id: str = None,
        user_groups: List[ListUserGroupsForRegistrationPolicyResponseBodyPoliciesUserGroups] = None,
    ):
        self.policy_id = policy_id
        self.user_groups = user_groups

    def validate(self):
        if self.user_groups:
            for k in self.user_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        result['UserGroups'] = []
        if self.user_groups is not None:
            for k in self.user_groups:
                result['UserGroups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        self.user_groups = []
        if m.get('UserGroups') is not None:
            for k in m.get('UserGroups'):
                temp_model = ListUserGroupsForRegistrationPolicyResponseBodyPoliciesUserGroups()
                self.user_groups.append(temp_model.from_map(k))
        return self


class ListUserGroupsForRegistrationPolicyResponseBody(TeaModel):
    def __init__(
        self,
        policies: List[ListUserGroupsForRegistrationPolicyResponseBodyPolicies] = None,
        request_id: str = None,
    ):
        self.policies = policies
        self.request_id = request_id

    def validate(self):
        if self.policies:
            for k in self.policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Policies'] = []
        if self.policies is not None:
            for k in self.policies:
                result['Policies'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.policies = []
        if m.get('Policies') is not None:
            for k in m.get('Policies'):
                temp_model = ListUserGroupsForRegistrationPolicyResponseBodyPolicies()
                self.policies.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListUserGroupsForRegistrationPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListUserGroupsForRegistrationPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListUserGroupsForRegistrationPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUserPrivateAccessPoliciesRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        name: str = None,
        page_size: int = None,
        sase_user_id: str = None,
    ):
        # Current page number.
        # 
        # This parameter is required.
        self.current_page = current_page
        # Intranet access policy name. Length should be between 1 to 128 characters, supporting Chinese and case-sensitive English letters, and can include numbers, periods (.), underscores (_), and hyphens (-).
        self.name = name
        # Number of items per page for pagination. Range: 1~100.
        # 
        # This parameter is required.
        self.page_size = page_size
        # User ID.
        # 
        # This parameter is required.
        self.sase_user_id = sase_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        return self


class ListUserPrivateAccessPoliciesResponseBodyPolicesCustomUserAttributes(TeaModel):
    def __init__(
        self,
        idp_id: int = None,
        relation: str = None,
        user_group_type: str = None,
        value: str = None,
    ):
        # The identity provider ID of the user group. This value exists when the custom user group type is **department**.
        self.idp_id = idp_id
        # Relation of the user group. Values:
        # - **Equal**: Equal.
        # - **Unequal**: Not equal.
        self.relation = relation
        # Type of the user group. Values:
        # - **username**: Username.
        # - **department**: Department.
        # - **email**: Email.
        # - **telephone**: Telephone.
        self.user_group_type = user_group_type
        # The value of the user group attribute.
        # - When the user group type is **username**, it represents the value of the username. The length is 1 to 128 characters, supporting Chinese and case-sensitive English letters, and can include numbers, periods (.), underscores (_), and hyphens (-).
        # - When the user group type is **department**, it represents the value of the department. For example: OU=Department1,OU=SASE DingTalk.
        # - When the user group type is **email**, it represents the value of the email. For example: username@example.com.
        # - When the user group type is **telephone**, it represents the value of the phone number. For example: 13900001234.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idp_id is not None:
            result['IdpId'] = self.idp_id
        if self.relation is not None:
            result['Relation'] = self.relation
        if self.user_group_type is not None:
            result['UserGroupType'] = self.user_group_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdpId') is not None:
            self.idp_id = m.get('IdpId')
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        if m.get('UserGroupType') is not None:
            self.user_group_type = m.get('UserGroupType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListUserPrivateAccessPoliciesResponseBodyPolices(TeaModel):
    def __init__(
        self,
        custom_user_attributes: List[ListUserPrivateAccessPoliciesResponseBodyPolicesCustomUserAttributes] = None,
        device_attribute_name: str = None,
        matched_user_group: str = None,
        name: str = None,
        policy_action: str = None,
        policy_id: str = None,
        priority: int = None,
        trusted_process_group_ids: List[str] = None,
        trusted_software_ids: List[str] = None,
        user_group_mode: str = None,
    ):
        # Set of custom user group attributes. Multiple custom user group attributes are in an OR relationship, effective as a union.
        self.custom_user_attributes = custom_user_attributes
        # Associated security baseline.
        self.device_attribute_name = device_attribute_name
        # Associated user group.
        self.matched_user_group = matched_user_group
        # Intranet access policy name.
        self.name = name
        # Action of the intranet access policy. Values:
        # - **Block**: Block.
        # - **Allow**: Allow.
        self.policy_action = policy_action
        # Intranet access policy ID.
        self.policy_id = policy_id
        # Priority of the intranet access policy. The number 1 indicates the highest priority.
        self.priority = priority
        # List of trusted process group IDs.
        self.trusted_process_group_ids = trusted_process_group_ids
        # List of trusted software IDs.
        self.trusted_software_ids = trusted_software_ids
        # Type of the user group for the intranet access policy. Values:
        # - **Normal**: Normal user group.
        # - **Custom**: Custom user group.
        self.user_group_mode = user_group_mode

    def validate(self):
        if self.custom_user_attributes:
            for k in self.custom_user_attributes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomUserAttributes'] = []
        if self.custom_user_attributes is not None:
            for k in self.custom_user_attributes:
                result['CustomUserAttributes'].append(k.to_map() if k else None)
        if self.device_attribute_name is not None:
            result['DeviceAttributeName'] = self.device_attribute_name
        if self.matched_user_group is not None:
            result['MatchedUserGroup'] = self.matched_user_group
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_action is not None:
            result['PolicyAction'] = self.policy_action
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.trusted_process_group_ids is not None:
            result['TrustedProcessGroupIds'] = self.trusted_process_group_ids
        if self.trusted_software_ids is not None:
            result['TrustedSoftwareIds'] = self.trusted_software_ids
        if self.user_group_mode is not None:
            result['UserGroupMode'] = self.user_group_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.custom_user_attributes = []
        if m.get('CustomUserAttributes') is not None:
            for k in m.get('CustomUserAttributes'):
                temp_model = ListUserPrivateAccessPoliciesResponseBodyPolicesCustomUserAttributes()
                self.custom_user_attributes.append(temp_model.from_map(k))
        if m.get('DeviceAttributeName') is not None:
            self.device_attribute_name = m.get('DeviceAttributeName')
        if m.get('MatchedUserGroup') is not None:
            self.matched_user_group = m.get('MatchedUserGroup')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyAction') is not None:
            self.policy_action = m.get('PolicyAction')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('TrustedProcessGroupIds') is not None:
            self.trusted_process_group_ids = m.get('TrustedProcessGroupIds')
        if m.get('TrustedSoftwareIds') is not None:
            self.trusted_software_ids = m.get('TrustedSoftwareIds')
        if m.get('UserGroupMode') is not None:
            self.user_group_mode = m.get('UserGroupMode')
        return self


class ListUserPrivateAccessPoliciesResponseBody(TeaModel):
    def __init__(
        self,
        polices: List[ListUserPrivateAccessPoliciesResponseBodyPolices] = None,
        request_id: str = None,
        total_num: int = None,
    ):
        # List of authorized policies.
        self.polices = polices
        # ID of the request.
        self.request_id = request_id
        # Total number of authorized policies.
        self.total_num = total_num

    def validate(self):
        if self.polices:
            for k in self.polices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Polices'] = []
        if self.polices is not None:
            for k in self.polices:
                result['Polices'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.polices = []
        if m.get('Polices') is not None:
            for k in m.get('Polices'):
                temp_model = ListUserPrivateAccessPoliciesResponseBodyPolices()
                self.polices.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class ListUserPrivateAccessPoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListUserPrivateAccessPoliciesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListUserPrivateAccessPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUsersRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        department: str = None,
        fuzzy_username: str = None,
        page_size: int = None,
        precise_username: str = None,
        sase_user_ids: List[str] = None,
        status: str = None,
    ):
        # This parameter is required.
        self.current_page = current_page
        self.department = department
        self.fuzzy_username = fuzzy_username
        # This parameter is required.
        self.page_size = page_size
        self.precise_username = precise_username
        self.sase_user_ids = sase_user_ids
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department is not None:
            result['Department'] = self.department
        if self.fuzzy_username is not None:
            result['FuzzyUsername'] = self.fuzzy_username
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.precise_username is not None:
            result['PreciseUsername'] = self.precise_username
        if self.sase_user_ids is not None:
            result['SaseUserIds'] = self.sase_user_ids
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('FuzzyUsername') is not None:
            self.fuzzy_username = m.get('FuzzyUsername')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PreciseUsername') is not None:
            self.precise_username = m.get('PreciseUsername')
        if m.get('SaseUserIds') is not None:
            self.sase_user_ids = m.get('SaseUserIds')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListUsersResponseBodyUsers(TeaModel):
    def __init__(
        self,
        department: str = None,
        email: str = None,
        idp_name: str = None,
        phone: str = None,
        sase_user_id: str = None,
        status: str = None,
        username: str = None,
    ):
        self.department = department
        self.email = email
        self.idp_name = idp_name
        self.phone = phone
        self.sase_user_id = sase_user_id
        self.status = status
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department is not None:
            result['Department'] = self.department
        if self.email is not None:
            result['Email'] = self.email
        if self.idp_name is not None:
            result['IdpName'] = self.idp_name
        if self.phone is not None:
            result['Phone'] = self.phone
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.status is not None:
            result['Status'] = self.status
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('IdpName') is not None:
            self.idp_name = m.get('IdpName')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListUsersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total_num: str = None,
        users: List[ListUsersResponseBodyUsers] = None,
    ):
        self.request_id = request_id
        self.total_num = total_num
        self.users = users

    def validate(self):
        if self.users:
            for k in self.users:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        result['Users'] = []
        if self.users is not None:
            for k in self.users:
                result['Users'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        self.users = []
        if m.get('Users') is not None:
            for k in m.get('Users'):
                temp_model = ListUsersResponseBodyUsers()
                self.users.append(temp_model.from_map(k))
        return self


class ListUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class LookupWmInfoMappingRequest(TeaModel):
    def __init__(
        self,
        wm_info_size: int = None,
        wm_info_uint: str = None,
        wm_type: str = None,
    ):
        self.wm_info_size = wm_info_size
        # This parameter is required.
        self.wm_info_uint = wm_info_uint
        # This parameter is required.
        self.wm_type = wm_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.wm_info_size is not None:
            result['WmInfoSize'] = self.wm_info_size
        if self.wm_info_uint is not None:
            result['WmInfoUint'] = self.wm_info_uint
        if self.wm_type is not None:
            result['WmType'] = self.wm_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WmInfoSize') is not None:
            self.wm_info_size = m.get('WmInfoSize')
        if m.get('WmInfoUint') is not None:
            self.wm_info_uint = m.get('WmInfoUint')
        if m.get('WmType') is not None:
            self.wm_type = m.get('WmType')
        return self


class LookupWmInfoMappingResponseBodyData(TeaModel):
    def __init__(
        self,
        wm_info_bytes_b64: str = None,
    ):
        self.wm_info_bytes_b64 = wm_info_bytes_b64

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.wm_info_bytes_b64 is not None:
            result['WmInfoBytesB64'] = self.wm_info_bytes_b64
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WmInfoBytesB64') is not None:
            self.wm_info_bytes_b64 = m.get('WmInfoBytesB64')
        return self


class LookupWmInfoMappingResponseBody(TeaModel):
    def __init__(
        self,
        data: LookupWmInfoMappingResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = LookupWmInfoMappingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class LookupWmInfoMappingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: LookupWmInfoMappingResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = LookupWmInfoMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyEnterpriseAcceleratePolicyRequest(TeaModel):
    def __init__(
        self,
        acceleration_type: str = None,
        description: str = None,
        eap_id: str = None,
        name: str = None,
        on_tls: int = None,
        priority: int = None,
        show_in_client: int = None,
        upstream_host: str = None,
        upstream_port: int = None,
        upstream_type: str = None,
        user_attribute_group: str = None,
    ):
        self.acceleration_type = acceleration_type
        self.description = description
        self.eap_id = eap_id
        self.name = name
        self.on_tls = on_tls
        self.priority = priority
        self.show_in_client = show_in_client
        # This parameter is required.
        self.upstream_host = upstream_host
        # This parameter is required.
        self.upstream_port = upstream_port
        # This parameter is required.
        self.upstream_type = upstream_type
        # This parameter is required.
        self.user_attribute_group = user_attribute_group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acceleration_type is not None:
            result['AccelerationType'] = self.acceleration_type
        if self.description is not None:
            result['Description'] = self.description
        if self.eap_id is not None:
            result['EapId'] = self.eap_id
        if self.name is not None:
            result['Name'] = self.name
        if self.on_tls is not None:
            result['OnTls'] = self.on_tls
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.show_in_client is not None:
            result['ShowInClient'] = self.show_in_client
        if self.upstream_host is not None:
            result['UpstreamHost'] = self.upstream_host
        if self.upstream_port is not None:
            result['UpstreamPort'] = self.upstream_port
        if self.upstream_type is not None:
            result['UpstreamType'] = self.upstream_type
        if self.user_attribute_group is not None:
            result['UserAttributeGroup'] = self.user_attribute_group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccelerationType') is not None:
            self.acceleration_type = m.get('AccelerationType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EapId') is not None:
            self.eap_id = m.get('EapId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OnTls') is not None:
            self.on_tls = m.get('OnTls')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ShowInClient') is not None:
            self.show_in_client = m.get('ShowInClient')
        if m.get('UpstreamHost') is not None:
            self.upstream_host = m.get('UpstreamHost')
        if m.get('UpstreamPort') is not None:
            self.upstream_port = m.get('UpstreamPort')
        if m.get('UpstreamType') is not None:
            self.upstream_type = m.get('UpstreamType')
        if m.get('UserAttributeGroup') is not None:
            self.user_attribute_group = m.get('UserAttributeGroup')
        return self


class ModifyEnterpriseAcceleratePolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyEnterpriseAcceleratePolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ModifyEnterpriseAcceleratePolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ModifyEnterpriseAcceleratePolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RevokeUserSessionRequest(TeaModel):
    def __init__(
        self,
        external_ids: str = None,
        idp_id: str = None,
    ):
        # This parameter is required.
        self.external_ids = external_ids
        # This parameter is required.
        self.idp_id = idp_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_ids is not None:
            result['ExternalIds'] = self.external_ids
        if self.idp_id is not None:
            result['IdpId'] = self.idp_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalIds') is not None:
            self.external_ids = m.get('ExternalIds')
        if m.get('IdpId') is not None:
            self.idp_id = m.get('IdpId')
        return self


class RevokeUserSessionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RevokeUserSessionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RevokeUserSessionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RevokeUserSessionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsAppUninstallSchemaConfigFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsAppUninstallSchemaConfig(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessRequestMatchSchemaConfigsAppUninstallSchemaConfigFieldMap] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsAppUninstallSchemaConfigFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsDeviceRegistrationSchemaConfigFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsDeviceRegistrationSchemaConfig(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessRequestMatchSchemaConfigsDeviceRegistrationSchemaConfigFieldMap] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsDeviceRegistrationSchemaConfigFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsDlpSendSchemaConfigFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsDlpSendSchemaConfig(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessRequestMatchSchemaConfigsDlpSendSchemaConfigFieldMap] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsDlpSendSchemaConfigFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsDomainBlacklistSchemaConfigFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsDomainBlacklistSchemaConfig(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessRequestMatchSchemaConfigsDomainBlacklistSchemaConfigFieldMap] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsDomainBlacklistSchemaConfigFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsDomainWhitelistSchemaConfigFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsDomainWhitelistSchemaConfig(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessRequestMatchSchemaConfigsDomainWhitelistSchemaConfigFieldMap] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsDomainWhitelistSchemaConfigFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsEndpointHardeningSchemaConfigFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsEndpointHardeningSchemaConfig(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessRequestMatchSchemaConfigsEndpointHardeningSchemaConfigFieldMap] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsEndpointHardeningSchemaConfigFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsPeripheralBlockSchemaConfigFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsPeripheralBlockSchemaConfig(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessRequestMatchSchemaConfigsPeripheralBlockSchemaConfigFieldMap] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsPeripheralBlockSchemaConfigFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsSoftwareBlockSchemaConfigFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsSoftwareBlockSchemaConfig(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessRequestMatchSchemaConfigsSoftwareBlockSchemaConfigFieldMap] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsSoftwareBlockSchemaConfigFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsSoftwareHardeningSchemaConfigFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigsSoftwareHardeningSchemaConfig(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessRequestMatchSchemaConfigsSoftwareHardeningSchemaConfigFieldMap] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsSoftwareHardeningSchemaConfigFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessRequestMatchSchemaConfigs(TeaModel):
    def __init__(
        self,
        app_uninstall_schema_config: UpdateApprovalProcessRequestMatchSchemaConfigsAppUninstallSchemaConfig = None,
        device_registration_schema_config: UpdateApprovalProcessRequestMatchSchemaConfigsDeviceRegistrationSchemaConfig = None,
        dlp_send_schema_config: UpdateApprovalProcessRequestMatchSchemaConfigsDlpSendSchemaConfig = None,
        domain_blacklist_schema_config: UpdateApprovalProcessRequestMatchSchemaConfigsDomainBlacklistSchemaConfig = None,
        domain_whitelist_schema_config: UpdateApprovalProcessRequestMatchSchemaConfigsDomainWhitelistSchemaConfig = None,
        endpoint_hardening_schema_config: UpdateApprovalProcessRequestMatchSchemaConfigsEndpointHardeningSchemaConfig = None,
        peripheral_block_schema_config: UpdateApprovalProcessRequestMatchSchemaConfigsPeripheralBlockSchemaConfig = None,
        software_block_schema_config: UpdateApprovalProcessRequestMatchSchemaConfigsSoftwareBlockSchemaConfig = None,
        software_hardening_schema_config: UpdateApprovalProcessRequestMatchSchemaConfigsSoftwareHardeningSchemaConfig = None,
    ):
        self.app_uninstall_schema_config = app_uninstall_schema_config
        self.device_registration_schema_config = device_registration_schema_config
        self.dlp_send_schema_config = dlp_send_schema_config
        self.domain_blacklist_schema_config = domain_blacklist_schema_config
        self.domain_whitelist_schema_config = domain_whitelist_schema_config
        self.endpoint_hardening_schema_config = endpoint_hardening_schema_config
        self.peripheral_block_schema_config = peripheral_block_schema_config
        self.software_block_schema_config = software_block_schema_config
        self.software_hardening_schema_config = software_hardening_schema_config

    def validate(self):
        if self.app_uninstall_schema_config:
            self.app_uninstall_schema_config.validate()
        if self.device_registration_schema_config:
            self.device_registration_schema_config.validate()
        if self.dlp_send_schema_config:
            self.dlp_send_schema_config.validate()
        if self.domain_blacklist_schema_config:
            self.domain_blacklist_schema_config.validate()
        if self.domain_whitelist_schema_config:
            self.domain_whitelist_schema_config.validate()
        if self.endpoint_hardening_schema_config:
            self.endpoint_hardening_schema_config.validate()
        if self.peripheral_block_schema_config:
            self.peripheral_block_schema_config.validate()
        if self.software_block_schema_config:
            self.software_block_schema_config.validate()
        if self.software_hardening_schema_config:
            self.software_hardening_schema_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_uninstall_schema_config is not None:
            result['AppUninstallSchemaConfig'] = self.app_uninstall_schema_config.to_map()
        if self.device_registration_schema_config is not None:
            result['DeviceRegistrationSchemaConfig'] = self.device_registration_schema_config.to_map()
        if self.dlp_send_schema_config is not None:
            result['DlpSendSchemaConfig'] = self.dlp_send_schema_config.to_map()
        if self.domain_blacklist_schema_config is not None:
            result['DomainBlacklistSchemaConfig'] = self.domain_blacklist_schema_config.to_map()
        if self.domain_whitelist_schema_config is not None:
            result['DomainWhitelistSchemaConfig'] = self.domain_whitelist_schema_config.to_map()
        if self.endpoint_hardening_schema_config is not None:
            result['EndpointHardeningSchemaConfig'] = self.endpoint_hardening_schema_config.to_map()
        if self.peripheral_block_schema_config is not None:
            result['PeripheralBlockSchemaConfig'] = self.peripheral_block_schema_config.to_map()
        if self.software_block_schema_config is not None:
            result['SoftwareBlockSchemaConfig'] = self.software_block_schema_config.to_map()
        if self.software_hardening_schema_config is not None:
            result['SoftwareHardeningSchemaConfig'] = self.software_hardening_schema_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppUninstallSchemaConfig') is not None:
            temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsAppUninstallSchemaConfig()
            self.app_uninstall_schema_config = temp_model.from_map(m['AppUninstallSchemaConfig'])
        if m.get('DeviceRegistrationSchemaConfig') is not None:
            temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsDeviceRegistrationSchemaConfig()
            self.device_registration_schema_config = temp_model.from_map(m['DeviceRegistrationSchemaConfig'])
        if m.get('DlpSendSchemaConfig') is not None:
            temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsDlpSendSchemaConfig()
            self.dlp_send_schema_config = temp_model.from_map(m['DlpSendSchemaConfig'])
        if m.get('DomainBlacklistSchemaConfig') is not None:
            temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsDomainBlacklistSchemaConfig()
            self.domain_blacklist_schema_config = temp_model.from_map(m['DomainBlacklistSchemaConfig'])
        if m.get('DomainWhitelistSchemaConfig') is not None:
            temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsDomainWhitelistSchemaConfig()
            self.domain_whitelist_schema_config = temp_model.from_map(m['DomainWhitelistSchemaConfig'])
        if m.get('EndpointHardeningSchemaConfig') is not None:
            temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsEndpointHardeningSchemaConfig()
            self.endpoint_hardening_schema_config = temp_model.from_map(m['EndpointHardeningSchemaConfig'])
        if m.get('PeripheralBlockSchemaConfig') is not None:
            temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsPeripheralBlockSchemaConfig()
            self.peripheral_block_schema_config = temp_model.from_map(m['PeripheralBlockSchemaConfig'])
        if m.get('SoftwareBlockSchemaConfig') is not None:
            temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsSoftwareBlockSchemaConfig()
            self.software_block_schema_config = temp_model.from_map(m['SoftwareBlockSchemaConfig'])
        if m.get('SoftwareHardeningSchemaConfig') is not None:
            temp_model = UpdateApprovalProcessRequestMatchSchemaConfigsSoftwareHardeningSchemaConfig()
            self.software_hardening_schema_config = temp_model.from_map(m['SoftwareHardeningSchemaConfig'])
        return self


class UpdateApprovalProcessRequestMatchSchemas(TeaModel):
    def __init__(
        self,
        app_uninstall_schema_id: str = None,
        device_registration_schema_id: str = None,
        dlp_send_schema_id: str = None,
        domain_blacklist_schema_id: str = None,
        domain_whitelist_schema_id: str = None,
        endpoint_hardening_schema_id: str = None,
        peripheral_block_schema_id: str = None,
        software_block_schema_id: str = None,
        software_hardening_schema_id: str = None,
    ):
        self.app_uninstall_schema_id = app_uninstall_schema_id
        self.device_registration_schema_id = device_registration_schema_id
        self.dlp_send_schema_id = dlp_send_schema_id
        self.domain_blacklist_schema_id = domain_blacklist_schema_id
        self.domain_whitelist_schema_id = domain_whitelist_schema_id
        self.endpoint_hardening_schema_id = endpoint_hardening_schema_id
        self.peripheral_block_schema_id = peripheral_block_schema_id
        self.software_block_schema_id = software_block_schema_id
        self.software_hardening_schema_id = software_hardening_schema_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_uninstall_schema_id is not None:
            result['AppUninstallSchemaId'] = self.app_uninstall_schema_id
        if self.device_registration_schema_id is not None:
            result['DeviceRegistrationSchemaId'] = self.device_registration_schema_id
        if self.dlp_send_schema_id is not None:
            result['DlpSendSchemaId'] = self.dlp_send_schema_id
        if self.domain_blacklist_schema_id is not None:
            result['DomainBlacklistSchemaId'] = self.domain_blacklist_schema_id
        if self.domain_whitelist_schema_id is not None:
            result['DomainWhitelistSchemaId'] = self.domain_whitelist_schema_id
        if self.endpoint_hardening_schema_id is not None:
            result['EndpointHardeningSchemaId'] = self.endpoint_hardening_schema_id
        if self.peripheral_block_schema_id is not None:
            result['PeripheralBlockSchemaId'] = self.peripheral_block_schema_id
        if self.software_block_schema_id is not None:
            result['SoftwareBlockSchemaId'] = self.software_block_schema_id
        if self.software_hardening_schema_id is not None:
            result['SoftwareHardeningSchemaId'] = self.software_hardening_schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppUninstallSchemaId') is not None:
            self.app_uninstall_schema_id = m.get('AppUninstallSchemaId')
        if m.get('DeviceRegistrationSchemaId') is not None:
            self.device_registration_schema_id = m.get('DeviceRegistrationSchemaId')
        if m.get('DlpSendSchemaId') is not None:
            self.dlp_send_schema_id = m.get('DlpSendSchemaId')
        if m.get('DomainBlacklistSchemaId') is not None:
            self.domain_blacklist_schema_id = m.get('DomainBlacklistSchemaId')
        if m.get('DomainWhitelistSchemaId') is not None:
            self.domain_whitelist_schema_id = m.get('DomainWhitelistSchemaId')
        if m.get('EndpointHardeningSchemaId') is not None:
            self.endpoint_hardening_schema_id = m.get('EndpointHardeningSchemaId')
        if m.get('PeripheralBlockSchemaId') is not None:
            self.peripheral_block_schema_id = m.get('PeripheralBlockSchemaId')
        if m.get('SoftwareBlockSchemaId') is not None:
            self.software_block_schema_id = m.get('SoftwareBlockSchemaId')
        if m.get('SoftwareHardeningSchemaId') is not None:
            self.software_hardening_schema_id = m.get('SoftwareHardeningSchemaId')
        return self


class UpdateApprovalProcessRequest(TeaModel):
    def __init__(
        self,
        approval_type: int = None,
        description: str = None,
        event_label: str = None,
        external_config: str = None,
        match_schema_configs: UpdateApprovalProcessRequestMatchSchemaConfigs = None,
        match_schemas: UpdateApprovalProcessRequestMatchSchemas = None,
        process_id: str = None,
        process_name: str = None,
        process_nodes: List[List[str]] = None,
    ):
        self.approval_type = approval_type
        self.description = description
        self.event_label = event_label
        self.external_config = external_config
        self.match_schema_configs = match_schema_configs
        self.match_schemas = match_schemas
        # This parameter is required.
        self.process_id = process_id
        self.process_name = process_name
        self.process_nodes = process_nodes

    def validate(self):
        if self.match_schema_configs:
            self.match_schema_configs.validate()
        if self.match_schemas:
            self.match_schemas.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approval_type is not None:
            result['ApprovalType'] = self.approval_type
        if self.description is not None:
            result['Description'] = self.description
        if self.event_label is not None:
            result['EventLabel'] = self.event_label
        if self.external_config is not None:
            result['ExternalConfig'] = self.external_config
        if self.match_schema_configs is not None:
            result['MatchSchemaConfigs'] = self.match_schema_configs.to_map()
        if self.match_schemas is not None:
            result['MatchSchemas'] = self.match_schemas.to_map()
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.process_nodes is not None:
            result['ProcessNodes'] = self.process_nodes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApprovalType') is not None:
            self.approval_type = m.get('ApprovalType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EventLabel') is not None:
            self.event_label = m.get('EventLabel')
        if m.get('ExternalConfig') is not None:
            self.external_config = m.get('ExternalConfig')
        if m.get('MatchSchemaConfigs') is not None:
            temp_model = UpdateApprovalProcessRequestMatchSchemaConfigs()
            self.match_schema_configs = temp_model.from_map(m['MatchSchemaConfigs'])
        if m.get('MatchSchemas') is not None:
            temp_model = UpdateApprovalProcessRequestMatchSchemas()
            self.match_schemas = temp_model.from_map(m['MatchSchemas'])
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('ProcessNodes') is not None:
            self.process_nodes = m.get('ProcessNodes')
        return self


class UpdateApprovalProcessShrinkRequest(TeaModel):
    def __init__(
        self,
        approval_type: int = None,
        description: str = None,
        event_label: str = None,
        external_config: str = None,
        match_schema_configs_shrink: str = None,
        match_schemas_shrink: str = None,
        process_id: str = None,
        process_name: str = None,
        process_nodes: List[List[str]] = None,
    ):
        self.approval_type = approval_type
        self.description = description
        self.event_label = event_label
        self.external_config = external_config
        self.match_schema_configs_shrink = match_schema_configs_shrink
        self.match_schemas_shrink = match_schemas_shrink
        # This parameter is required.
        self.process_id = process_id
        self.process_name = process_name
        self.process_nodes = process_nodes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approval_type is not None:
            result['ApprovalType'] = self.approval_type
        if self.description is not None:
            result['Description'] = self.description
        if self.event_label is not None:
            result['EventLabel'] = self.event_label
        if self.external_config is not None:
            result['ExternalConfig'] = self.external_config
        if self.match_schema_configs_shrink is not None:
            result['MatchSchemaConfigs'] = self.match_schema_configs_shrink
        if self.match_schemas_shrink is not None:
            result['MatchSchemas'] = self.match_schemas_shrink
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.process_nodes is not None:
            result['ProcessNodes'] = self.process_nodes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApprovalType') is not None:
            self.approval_type = m.get('ApprovalType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EventLabel') is not None:
            self.event_label = m.get('EventLabel')
        if m.get('ExternalConfig') is not None:
            self.external_config = m.get('ExternalConfig')
        if m.get('MatchSchemaConfigs') is not None:
            self.match_schema_configs_shrink = m.get('MatchSchemaConfigs')
        if m.get('MatchSchemas') is not None:
            self.match_schemas_shrink = m.get('MatchSchemas')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('ProcessNodes') is not None:
            self.process_nodes = m.get('ProcessNodes')
        return self


class UpdateApprovalProcessResponseBodyProcessAppUninstallPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        display_field_value: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.display_field_value = display_field_value
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.display_field_value is not None:
            result['DisplayFieldValue'] = self.display_field_value
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('DisplayFieldValue') is not None:
            self.display_field_value = m.get('DisplayFieldValue')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessResponseBodyProcessAppUninstallPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessResponseBodyProcessAppUninstallPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessResponseBodyProcessAppUninstallPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessResponseBodyProcessDeviceRegistrationPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        display_field_value: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.display_field_value = display_field_value
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.display_field_value is not None:
            result['DisplayFieldValue'] = self.display_field_value
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('DisplayFieldValue') is not None:
            self.display_field_value = m.get('DisplayFieldValue')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessResponseBodyProcessDeviceRegistrationPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessResponseBodyProcessDeviceRegistrationPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessResponseBodyProcessDeviceRegistrationPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessResponseBodyProcessDlpSendPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        display_field_value: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.display_field_value = display_field_value
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.display_field_value is not None:
            result['DisplayFieldValue'] = self.display_field_value
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('DisplayFieldValue') is not None:
            self.display_field_value = m.get('DisplayFieldValue')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessResponseBodyProcessDlpSendPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessResponseBodyProcessDlpSendPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessResponseBodyProcessDlpSendPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessResponseBodyProcessDomainBlacklistPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        display_field_value: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.display_field_value = display_field_value
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.display_field_value is not None:
            result['DisplayFieldValue'] = self.display_field_value
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('DisplayFieldValue') is not None:
            self.display_field_value = m.get('DisplayFieldValue')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessResponseBodyProcessDomainBlacklistPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessResponseBodyProcessDomainBlacklistPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessResponseBodyProcessDomainBlacklistPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessResponseBodyProcessDomainWhitelistPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        display_field_value: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.display_field_value = display_field_value
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.display_field_value is not None:
            result['DisplayFieldValue'] = self.display_field_value
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('DisplayFieldValue') is not None:
            self.display_field_value = m.get('DisplayFieldValue')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessResponseBodyProcessDomainWhitelistPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessResponseBodyProcessDomainWhitelistPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessResponseBodyProcessDomainWhitelistPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessResponseBodyProcessEndpointHardeningPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        display_field_value: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.display_field_value = display_field_value
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.display_field_value is not None:
            result['DisplayFieldValue'] = self.display_field_value
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('DisplayFieldValue') is not None:
            self.display_field_value = m.get('DisplayFieldValue')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessResponseBodyProcessEndpointHardeningPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessResponseBodyProcessEndpointHardeningPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessResponseBodyProcessEndpointHardeningPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessResponseBodyProcessPeripheraBlockPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        display_field_value: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.display_field_value = display_field_value
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.display_field_value is not None:
            result['DisplayFieldValue'] = self.display_field_value
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('DisplayFieldValue') is not None:
            self.display_field_value = m.get('DisplayFieldValue')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessResponseBodyProcessPeripheraBlockPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessResponseBodyProcessPeripheraBlockPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessResponseBodyProcessPeripheraBlockPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessResponseBodyProcessProcessNodes(TeaModel):
    def __init__(
        self,
        sase_user_id: str = None,
        username: str = None,
    ):
        self.sase_user_id = sase_user_id
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class UpdateApprovalProcessResponseBodyProcessSoftwareBlockPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        display_field_value: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.display_field_value = display_field_value
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.display_field_value is not None:
            result['DisplayFieldValue'] = self.display_field_value
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('DisplayFieldValue') is not None:
            self.display_field_value = m.get('DisplayFieldValue')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessResponseBodyProcessSoftwareBlockPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessResponseBodyProcessSoftwareBlockPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessResponseBodyProcessSoftwareBlockPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessResponseBodyProcessSoftwareHardeningPoliciesFieldMap(TeaModel):
    def __init__(
        self,
        display_field: str = None,
        display_field_value: str = None,
        system_field: str = None,
    ):
        self.display_field = display_field
        self.display_field_value = display_field_value
        self.system_field = system_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_field is not None:
            result['DisplayField'] = self.display_field
        if self.display_field_value is not None:
            result['DisplayFieldValue'] = self.display_field_value
        if self.system_field is not None:
            result['SystemField'] = self.system_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayField') is not None:
            self.display_field = m.get('DisplayField')
        if m.get('DisplayFieldValue') is not None:
            self.display_field_value = m.get('DisplayFieldValue')
        if m.get('SystemField') is not None:
            self.system_field = m.get('SystemField')
        return self


class UpdateApprovalProcessResponseBodyProcessSoftwareHardeningPolicies(TeaModel):
    def __init__(
        self,
        external_process_id: str = None,
        field_map: List[UpdateApprovalProcessResponseBodyProcessSoftwareHardeningPoliciesFieldMap] = None,
        policy_ids: List[str] = None,
        schema_id: str = None,
    ):
        self.external_process_id = external_process_id
        self.field_map = field_map
        self.policy_ids = policy_ids
        self.schema_id = schema_id

    def validate(self):
        if self.field_map:
            for k in self.field_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_process_id is not None:
            result['ExternalProcessId'] = self.external_process_id
        result['FieldMap'] = []
        if self.field_map is not None:
            for k in self.field_map:
                result['FieldMap'].append(k.to_map() if k else None)
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalProcessId') is not None:
            self.external_process_id = m.get('ExternalProcessId')
        self.field_map = []
        if m.get('FieldMap') is not None:
            for k in m.get('FieldMap'):
                temp_model = UpdateApprovalProcessResponseBodyProcessSoftwareHardeningPoliciesFieldMap()
                self.field_map.append(temp_model.from_map(k))
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        return self


class UpdateApprovalProcessResponseBodyProcess(TeaModel):
    def __init__(
        self,
        app_uninstall_policies: UpdateApprovalProcessResponseBodyProcessAppUninstallPolicies = None,
        approval_type: int = None,
        create_time: str = None,
        description: str = None,
        device_registration_policies: UpdateApprovalProcessResponseBodyProcessDeviceRegistrationPolicies = None,
        dlp_send_policies: UpdateApprovalProcessResponseBodyProcessDlpSendPolicies = None,
        domain_blacklist_policies: UpdateApprovalProcessResponseBodyProcessDomainBlacklistPolicies = None,
        domain_whitelist_policies: UpdateApprovalProcessResponseBodyProcessDomainWhitelistPolicies = None,
        endpoint_hardening_policies: UpdateApprovalProcessResponseBodyProcessEndpointHardeningPolicies = None,
        event_label: str = None,
        external_config: str = None,
        periphera_block_policies: UpdateApprovalProcessResponseBodyProcessPeripheraBlockPolicies = None,
        process_id: str = None,
        process_name: str = None,
        process_nodes: List[List[UpdateApprovalProcessResponseBodyProcessProcessNodes]] = None,
        software_block_policies: UpdateApprovalProcessResponseBodyProcessSoftwareBlockPolicies = None,
        software_hardening_policies: UpdateApprovalProcessResponseBodyProcessSoftwareHardeningPolicies = None,
    ):
        self.app_uninstall_policies = app_uninstall_policies
        self.approval_type = approval_type
        self.create_time = create_time
        self.description = description
        self.device_registration_policies = device_registration_policies
        self.dlp_send_policies = dlp_send_policies
        self.domain_blacklist_policies = domain_blacklist_policies
        self.domain_whitelist_policies = domain_whitelist_policies
        self.endpoint_hardening_policies = endpoint_hardening_policies
        self.event_label = event_label
        self.external_config = external_config
        self.periphera_block_policies = periphera_block_policies
        self.process_id = process_id
        self.process_name = process_name
        self.process_nodes = process_nodes
        self.software_block_policies = software_block_policies
        self.software_hardening_policies = software_hardening_policies

    def validate(self):
        if self.app_uninstall_policies:
            self.app_uninstall_policies.validate()
        if self.device_registration_policies:
            self.device_registration_policies.validate()
        if self.dlp_send_policies:
            self.dlp_send_policies.validate()
        if self.domain_blacklist_policies:
            self.domain_blacklist_policies.validate()
        if self.domain_whitelist_policies:
            self.domain_whitelist_policies.validate()
        if self.endpoint_hardening_policies:
            self.endpoint_hardening_policies.validate()
        if self.periphera_block_policies:
            self.periphera_block_policies.validate()
        if self.process_nodes:
            for k in self.process_nodes:
                for k1 in k:
                    if k1:
                        k1.validate()
        if self.software_block_policies:
            self.software_block_policies.validate()
        if self.software_hardening_policies:
            self.software_hardening_policies.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_uninstall_policies is not None:
            result['AppUninstallPolicies'] = self.app_uninstall_policies.to_map()
        if self.approval_type is not None:
            result['ApprovalType'] = self.approval_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.device_registration_policies is not None:
            result['DeviceRegistrationPolicies'] = self.device_registration_policies.to_map()
        if self.dlp_send_policies is not None:
            result['DlpSendPolicies'] = self.dlp_send_policies.to_map()
        if self.domain_blacklist_policies is not None:
            result['DomainBlacklistPolicies'] = self.domain_blacklist_policies.to_map()
        if self.domain_whitelist_policies is not None:
            result['DomainWhitelistPolicies'] = self.domain_whitelist_policies.to_map()
        if self.endpoint_hardening_policies is not None:
            result['EndpointHardeningPolicies'] = self.endpoint_hardening_policies.to_map()
        if self.event_label is not None:
            result['EventLabel'] = self.event_label
        if self.external_config is not None:
            result['ExternalConfig'] = self.external_config
        if self.periphera_block_policies is not None:
            result['PeripheraBlockPolicies'] = self.periphera_block_policies.to_map()
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        result['ProcessNodes'] = []
        if self.process_nodes is not None:
            for k in self.process_nodes:
                l1 = []
                for k1 in k:
                    l1.append(k1.to_map() if k1 else None)
                result['ProcessNodes'].append(l1)
        if self.software_block_policies is not None:
            result['SoftwareBlockPolicies'] = self.software_block_policies.to_map()
        if self.software_hardening_policies is not None:
            result['SoftwareHardeningPolicies'] = self.software_hardening_policies.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppUninstallPolicies') is not None:
            temp_model = UpdateApprovalProcessResponseBodyProcessAppUninstallPolicies()
            self.app_uninstall_policies = temp_model.from_map(m['AppUninstallPolicies'])
        if m.get('ApprovalType') is not None:
            self.approval_type = m.get('ApprovalType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceRegistrationPolicies') is not None:
            temp_model = UpdateApprovalProcessResponseBodyProcessDeviceRegistrationPolicies()
            self.device_registration_policies = temp_model.from_map(m['DeviceRegistrationPolicies'])
        if m.get('DlpSendPolicies') is not None:
            temp_model = UpdateApprovalProcessResponseBodyProcessDlpSendPolicies()
            self.dlp_send_policies = temp_model.from_map(m['DlpSendPolicies'])
        if m.get('DomainBlacklistPolicies') is not None:
            temp_model = UpdateApprovalProcessResponseBodyProcessDomainBlacklistPolicies()
            self.domain_blacklist_policies = temp_model.from_map(m['DomainBlacklistPolicies'])
        if m.get('DomainWhitelistPolicies') is not None:
            temp_model = UpdateApprovalProcessResponseBodyProcessDomainWhitelistPolicies()
            self.domain_whitelist_policies = temp_model.from_map(m['DomainWhitelistPolicies'])
        if m.get('EndpointHardeningPolicies') is not None:
            temp_model = UpdateApprovalProcessResponseBodyProcessEndpointHardeningPolicies()
            self.endpoint_hardening_policies = temp_model.from_map(m['EndpointHardeningPolicies'])
        if m.get('EventLabel') is not None:
            self.event_label = m.get('EventLabel')
        if m.get('ExternalConfig') is not None:
            self.external_config = m.get('ExternalConfig')
        if m.get('PeripheraBlockPolicies') is not None:
            temp_model = UpdateApprovalProcessResponseBodyProcessPeripheraBlockPolicies()
            self.periphera_block_policies = temp_model.from_map(m['PeripheraBlockPolicies'])
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        self.process_nodes = []
        if m.get('ProcessNodes') is not None:
            for k in m.get('ProcessNodes'):
                l1 = []
                for k1 in k:
                    temp_model = UpdateApprovalProcessResponseBodyProcessProcessNodes()
                    l1.append(temp_model.from_map(k1))
                self.process_nodes.append(l1)
        if m.get('SoftwareBlockPolicies') is not None:
            temp_model = UpdateApprovalProcessResponseBodyProcessSoftwareBlockPolicies()
            self.software_block_policies = temp_model.from_map(m['SoftwareBlockPolicies'])
        if m.get('SoftwareHardeningPolicies') is not None:
            temp_model = UpdateApprovalProcessResponseBodyProcessSoftwareHardeningPolicies()
            self.software_hardening_policies = temp_model.from_map(m['SoftwareHardeningPolicies'])
        return self


class UpdateApprovalProcessResponseBody(TeaModel):
    def __init__(
        self,
        process: UpdateApprovalProcessResponseBodyProcess = None,
        request_id: str = None,
    ):
        self.process = process
        self.request_id = request_id

    def validate(self):
        if self.process:
            self.process.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.process is not None:
            result['Process'] = self.process.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Process') is not None:
            temp_model = UpdateApprovalProcessResponseBodyProcess()
            self.process = temp_model.from_map(m['Process'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateApprovalProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateApprovalProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateApprovalProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateApprovalStatusRequest(TeaModel):
    def __init__(
        self,
        approval_id: str = None,
        status: str = None,
    ):
        # This parameter is required.
        self.approval_id = approval_id
        # This parameter is required.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approval_id is not None:
            result['ApprovalId'] = self.approval_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApprovalId') is not None:
            self.approval_id = m.get('ApprovalId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class UpdateApprovalStatusResponseBodyApprovalApprovalProgressesOperators(TeaModel):
    def __init__(
        self,
        sase_user_id: str = None,
        username: str = None,
    ):
        self.sase_user_id = sase_user_id
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class UpdateApprovalStatusResponseBodyApprovalApprovalProgresses(TeaModel):
    def __init__(
        self,
        action: str = None,
        comment: str = None,
        executor: str = None,
        operators: List[UpdateApprovalStatusResponseBodyApprovalApprovalProgressesOperators] = None,
        status: str = None,
        timestamp: int = None,
    ):
        self.action = action
        self.comment = comment
        self.executor = executor
        self.operators = operators
        self.status = status
        self.timestamp = timestamp

    def validate(self):
        if self.operators:
            for k in self.operators:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.executor is not None:
            result['Executor'] = self.executor
        result['Operators'] = []
        if self.operators is not None:
            for k in self.operators:
                result['Operators'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Executor') is not None:
            self.executor = m.get('Executor')
        self.operators = []
        if m.get('Operators') is not None:
            for k in m.get('Operators'):
                temp_model = UpdateApprovalStatusResponseBodyApprovalApprovalProgressesOperators()
                self.operators.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class UpdateApprovalStatusResponseBodyApproval(TeaModel):
    def __init__(
        self,
        approval_detail: str = None,
        approval_id: str = None,
        approval_progresses: List[UpdateApprovalStatusResponseBodyApprovalApprovalProgresses] = None,
        create_time: str = None,
        creator_dev_tag: str = None,
        creator_user_id: str = None,
        end_timestamp: int = None,
        policy_type: str = None,
        process_id: str = None,
        process_name: str = None,
        reason: str = None,
        schema_content: str = None,
        schema_id: str = None,
        schema_name: str = None,
        status: str = None,
    ):
        self.approval_detail = approval_detail
        self.approval_id = approval_id
        self.approval_progresses = approval_progresses
        self.create_time = create_time
        self.creator_dev_tag = creator_dev_tag
        self.creator_user_id = creator_user_id
        self.end_timestamp = end_timestamp
        self.policy_type = policy_type
        self.process_id = process_id
        self.process_name = process_name
        self.reason = reason
        self.schema_content = schema_content
        self.schema_id = schema_id
        self.schema_name = schema_name
        self.status = status

    def validate(self):
        if self.approval_progresses:
            for k in self.approval_progresses:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approval_detail is not None:
            result['ApprovalDetail'] = self.approval_detail
        if self.approval_id is not None:
            result['ApprovalId'] = self.approval_id
        result['ApprovalProgresses'] = []
        if self.approval_progresses is not None:
            for k in self.approval_progresses:
                result['ApprovalProgresses'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_dev_tag is not None:
            result['CreatorDevTag'] = self.creator_dev_tag
        if self.creator_user_id is not None:
            result['CreatorUserId'] = self.creator_user_id
        if self.end_timestamp is not None:
            result['EndTimestamp'] = self.end_timestamp
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.schema_content is not None:
            result['SchemaContent'] = self.schema_content
        if self.schema_id is not None:
            result['SchemaId'] = self.schema_id
        if self.schema_name is not None:
            result['SchemaName'] = self.schema_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApprovalDetail') is not None:
            self.approval_detail = m.get('ApprovalDetail')
        if m.get('ApprovalId') is not None:
            self.approval_id = m.get('ApprovalId')
        self.approval_progresses = []
        if m.get('ApprovalProgresses') is not None:
            for k in m.get('ApprovalProgresses'):
                temp_model = UpdateApprovalStatusResponseBodyApprovalApprovalProgresses()
                self.approval_progresses.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorDevTag') is not None:
            self.creator_dev_tag = m.get('CreatorDevTag')
        if m.get('CreatorUserId') is not None:
            self.creator_user_id = m.get('CreatorUserId')
        if m.get('EndTimestamp') is not None:
            self.end_timestamp = m.get('EndTimestamp')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('SchemaContent') is not None:
            self.schema_content = m.get('SchemaContent')
        if m.get('SchemaId') is not None:
            self.schema_id = m.get('SchemaId')
        if m.get('SchemaName') is not None:
            self.schema_name = m.get('SchemaName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class UpdateApprovalStatusResponseBody(TeaModel):
    def __init__(
        self,
        approval: List[UpdateApprovalStatusResponseBodyApproval] = None,
        request_id: str = None,
    ):
        self.approval = approval
        self.request_id = request_id

    def validate(self):
        if self.approval:
            for k in self.approval:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Approval'] = []
        if self.approval is not None:
            for k in self.approval:
                result['Approval'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.approval = []
        if m.get('Approval') is not None:
            for k in m.get('Approval'):
                temp_model = UpdateApprovalStatusResponseBodyApproval()
                self.approval.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateApprovalStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateApprovalStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateApprovalStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateBootAndAntiUninstallPolicyRequestBlockContentBlockTextEn(TeaModel):
    def __init__(
        self,
        content: str = None,
        main_button_text: str = None,
        minor_button_text: str = None,
        title: str = None,
    ):
        self.content = content
        self.main_button_text = main_button_text
        self.minor_button_text = minor_button_text
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.main_button_text is not None:
            result['MainButtonText'] = self.main_button_text
        if self.minor_button_text is not None:
            result['MinorButtonText'] = self.minor_button_text
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('MainButtonText') is not None:
            self.main_button_text = m.get('MainButtonText')
        if m.get('MinorButtonText') is not None:
            self.minor_button_text = m.get('MinorButtonText')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class UpdateBootAndAntiUninstallPolicyRequestBlockContentBlockTextZh(TeaModel):
    def __init__(
        self,
        content: str = None,
        main_button_text: str = None,
        minor_button_text: str = None,
        title: str = None,
    ):
        self.content = content
        self.main_button_text = main_button_text
        self.minor_button_text = minor_button_text
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.main_button_text is not None:
            result['MainButtonText'] = self.main_button_text
        if self.minor_button_text is not None:
            result['MinorButtonText'] = self.minor_button_text
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('MainButtonText') is not None:
            self.main_button_text = m.get('MainButtonText')
        if m.get('MinorButtonText') is not None:
            self.minor_button_text = m.get('MinorButtonText')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class UpdateBootAndAntiUninstallPolicyRequestBlockContent(TeaModel):
    def __init__(
        self,
        block_text_en: UpdateBootAndAntiUninstallPolicyRequestBlockContentBlockTextEn = None,
        block_text_zh: UpdateBootAndAntiUninstallPolicyRequestBlockContentBlockTextZh = None,
    ):
        self.block_text_en = block_text_en
        self.block_text_zh = block_text_zh

    def validate(self):
        if self.block_text_en:
            self.block_text_en.validate()
        if self.block_text_zh:
            self.block_text_zh.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_text_en is not None:
            result['BlockTextEn'] = self.block_text_en.to_map()
        if self.block_text_zh is not None:
            result['BlockTextZh'] = self.block_text_zh.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockTextEn') is not None:
            temp_model = UpdateBootAndAntiUninstallPolicyRequestBlockContentBlockTextEn()
            self.block_text_en = temp_model.from_map(m['BlockTextEn'])
        if m.get('BlockTextZh') is not None:
            temp_model = UpdateBootAndAntiUninstallPolicyRequestBlockContentBlockTextZh()
            self.block_text_zh = temp_model.from_map(m['BlockTextZh'])
        return self


class UpdateBootAndAntiUninstallPolicyRequest(TeaModel):
    def __init__(
        self,
        allow_report: bool = None,
        block_content: UpdateBootAndAntiUninstallPolicyRequestBlockContent = None,
        is_anti_uninstall: bool = None,
        is_boot: bool = None,
        user_group_ids: List[str] = None,
        whitelist_users: List[str] = None,
    ):
        self.allow_report = allow_report
        self.block_content = block_content
        self.is_anti_uninstall = is_anti_uninstall
        self.is_boot = is_boot
        self.user_group_ids = user_group_ids
        self.whitelist_users = whitelist_users

    def validate(self):
        if self.block_content:
            self.block_content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_report is not None:
            result['AllowReport'] = self.allow_report
        if self.block_content is not None:
            result['BlockContent'] = self.block_content.to_map()
        if self.is_anti_uninstall is not None:
            result['IsAntiUninstall'] = self.is_anti_uninstall
        if self.is_boot is not None:
            result['IsBoot'] = self.is_boot
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        if self.whitelist_users is not None:
            result['WhitelistUsers'] = self.whitelist_users
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowReport') is not None:
            self.allow_report = m.get('AllowReport')
        if m.get('BlockContent') is not None:
            temp_model = UpdateBootAndAntiUninstallPolicyRequestBlockContent()
            self.block_content = temp_model.from_map(m['BlockContent'])
        if m.get('IsAntiUninstall') is not None:
            self.is_anti_uninstall = m.get('IsAntiUninstall')
        if m.get('IsBoot') is not None:
            self.is_boot = m.get('IsBoot')
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        if m.get('WhitelistUsers') is not None:
            self.whitelist_users = m.get('WhitelistUsers')
        return self


class UpdateBootAndAntiUninstallPolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        allow_report: bool = None,
        block_content_shrink: str = None,
        is_anti_uninstall: bool = None,
        is_boot: bool = None,
        user_group_ids: List[str] = None,
        whitelist_users: List[str] = None,
    ):
        self.allow_report = allow_report
        self.block_content_shrink = block_content_shrink
        self.is_anti_uninstall = is_anti_uninstall
        self.is_boot = is_boot
        self.user_group_ids = user_group_ids
        self.whitelist_users = whitelist_users

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_report is not None:
            result['AllowReport'] = self.allow_report
        if self.block_content_shrink is not None:
            result['BlockContent'] = self.block_content_shrink
        if self.is_anti_uninstall is not None:
            result['IsAntiUninstall'] = self.is_anti_uninstall
        if self.is_boot is not None:
            result['IsBoot'] = self.is_boot
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        if self.whitelist_users is not None:
            result['WhitelistUsers'] = self.whitelist_users
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowReport') is not None:
            self.allow_report = m.get('AllowReport')
        if m.get('BlockContent') is not None:
            self.block_content_shrink = m.get('BlockContent')
        if m.get('IsAntiUninstall') is not None:
            self.is_anti_uninstall = m.get('IsAntiUninstall')
        if m.get('IsBoot') is not None:
            self.is_boot = m.get('IsBoot')
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        if m.get('WhitelistUsers') is not None:
            self.whitelist_users = m.get('WhitelistUsers')
        return self


class UpdateBootAndAntiUninstallPolicyResponseBodyStrategyBlockContentBlockTextEn(TeaModel):
    def __init__(
        self,
        content: str = None,
        main_button_text: str = None,
        minor_button_text: str = None,
        title: str = None,
    ):
        self.content = content
        self.main_button_text = main_button_text
        self.minor_button_text = minor_button_text
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.main_button_text is not None:
            result['MainButtonText'] = self.main_button_text
        if self.minor_button_text is not None:
            result['MinorButtonText'] = self.minor_button_text
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('MainButtonText') is not None:
            self.main_button_text = m.get('MainButtonText')
        if m.get('MinorButtonText') is not None:
            self.minor_button_text = m.get('MinorButtonText')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class UpdateBootAndAntiUninstallPolicyResponseBodyStrategyBlockContentBlockTextZh(TeaModel):
    def __init__(
        self,
        content: str = None,
        main_button_text: str = None,
        minor_button_text: str = None,
        title: str = None,
    ):
        self.content = content
        self.main_button_text = main_button_text
        self.minor_button_text = minor_button_text
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.main_button_text is not None:
            result['MainButtonText'] = self.main_button_text
        if self.minor_button_text is not None:
            result['MinorButtonText'] = self.minor_button_text
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('MainButtonText') is not None:
            self.main_button_text = m.get('MainButtonText')
        if m.get('MinorButtonText') is not None:
            self.minor_button_text = m.get('MinorButtonText')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class UpdateBootAndAntiUninstallPolicyResponseBodyStrategyBlockContent(TeaModel):
    def __init__(
        self,
        block_text_en: UpdateBootAndAntiUninstallPolicyResponseBodyStrategyBlockContentBlockTextEn = None,
        block_text_zh: UpdateBootAndAntiUninstallPolicyResponseBodyStrategyBlockContentBlockTextZh = None,
    ):
        self.block_text_en = block_text_en
        self.block_text_zh = block_text_zh

    def validate(self):
        if self.block_text_en:
            self.block_text_en.validate()
        if self.block_text_zh:
            self.block_text_zh.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_text_en is not None:
            result['BlockTextEn'] = self.block_text_en.to_map()
        if self.block_text_zh is not None:
            result['BlockTextZh'] = self.block_text_zh.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockTextEn') is not None:
            temp_model = UpdateBootAndAntiUninstallPolicyResponseBodyStrategyBlockContentBlockTextEn()
            self.block_text_en = temp_model.from_map(m['BlockTextEn'])
        if m.get('BlockTextZh') is not None:
            temp_model = UpdateBootAndAntiUninstallPolicyResponseBodyStrategyBlockContentBlockTextZh()
            self.block_text_zh = temp_model.from_map(m['BlockTextZh'])
        return self


class UpdateBootAndAntiUninstallPolicyResponseBodyStrategy(TeaModel):
    def __init__(
        self,
        allow_report: bool = None,
        block_content: UpdateBootAndAntiUninstallPolicyResponseBodyStrategyBlockContent = None,
        create_time: str = None,
        is_anti_uninstall: bool = None,
        is_boot: bool = None,
        policy_id: str = None,
        report_process_id: str = None,
        update_time: str = None,
        user_group_ids: List[str] = None,
        whitelist_users: List[str] = None,
    ):
        self.allow_report = allow_report
        self.block_content = block_content
        self.create_time = create_time
        self.is_anti_uninstall = is_anti_uninstall
        self.is_boot = is_boot
        self.policy_id = policy_id
        self.report_process_id = report_process_id
        self.update_time = update_time
        self.user_group_ids = user_group_ids
        self.whitelist_users = whitelist_users

    def validate(self):
        if self.block_content:
            self.block_content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_report is not None:
            result['AllowReport'] = self.allow_report
        if self.block_content is not None:
            result['BlockContent'] = self.block_content.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.is_anti_uninstall is not None:
            result['IsAntiUninstall'] = self.is_anti_uninstall
        if self.is_boot is not None:
            result['IsBoot'] = self.is_boot
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.report_process_id is not None:
            result['ReportProcessId'] = self.report_process_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        if self.whitelist_users is not None:
            result['WhitelistUsers'] = self.whitelist_users
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowReport') is not None:
            self.allow_report = m.get('AllowReport')
        if m.get('BlockContent') is not None:
            temp_model = UpdateBootAndAntiUninstallPolicyResponseBodyStrategyBlockContent()
            self.block_content = temp_model.from_map(m['BlockContent'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IsAntiUninstall') is not None:
            self.is_anti_uninstall = m.get('IsAntiUninstall')
        if m.get('IsBoot') is not None:
            self.is_boot = m.get('IsBoot')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('ReportProcessId') is not None:
            self.report_process_id = m.get('ReportProcessId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        if m.get('WhitelistUsers') is not None:
            self.whitelist_users = m.get('WhitelistUsers')
        return self


class UpdateBootAndAntiUninstallPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        strategy: UpdateBootAndAntiUninstallPolicyResponseBodyStrategy = None,
    ):
        self.request_id = request_id
        self.strategy = strategy

    def validate(self):
        if self.strategy:
            self.strategy.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.strategy is not None:
            result['Strategy'] = self.strategy.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Strategy') is not None:
            temp_model = UpdateBootAndAntiUninstallPolicyResponseBodyStrategy()
            self.strategy = temp_model.from_map(m['Strategy'])
        return self


class UpdateBootAndAntiUninstallPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateBootAndAntiUninstallPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateBootAndAntiUninstallPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateClientUserRequest(TeaModel):
    def __init__(
        self,
        department_id: str = None,
        description: str = None,
        email: str = None,
        id: str = None,
        mobile_number: str = None,
    ):
        self.department_id = department_id
        self.description = description
        self.email = email
        # This parameter is required.
        self.id = id
        self.mobile_number = mobile_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.description is not None:
            result['Description'] = self.description
        if self.email is not None:
            result['Email'] = self.email
        if self.id is not None:
            result['Id'] = self.id
        if self.mobile_number is not None:
            result['MobileNumber'] = self.mobile_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MobileNumber') is not None:
            self.mobile_number = m.get('MobileNumber')
        return self


class UpdateClientUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateClientUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateClientUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateClientUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateClientUserPasswordRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        password: str = None,
        username: str = None,
    ):
        self.id = id
        self.password = password
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.password is not None:
            result['Password'] = self.password
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class UpdateClientUserPasswordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateClientUserPasswordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateClientUserPasswordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateClientUserPasswordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateClientUserStatusRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        status: str = None,
    ):
        # This parameter is required.
        self.id = id
        # This parameter is required.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class UpdateClientUserStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateClientUserStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateClientUserStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateClientUserStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateDynamicRouteRequest(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        application_type: str = None,
        description: str = None,
        dynamic_route_id: str = None,
        dynamic_route_type: str = None,
        modify_type: str = None,
        name: str = None,
        next_hop: str = None,
        priority: int = None,
        region_ids: List[str] = None,
        status: str = None,
        tag_ids: List[str] = None,
    ):
        self.application_ids = application_ids
        self.application_type = application_type
        self.description = description
        # This parameter is required.
        self.dynamic_route_id = dynamic_route_id
        self.dynamic_route_type = dynamic_route_type
        self.modify_type = modify_type
        self.name = name
        self.next_hop = next_hop
        self.priority = priority
        self.region_ids = region_ids
        self.status = status
        self.tag_ids = tag_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.application_type is not None:
            result['ApplicationType'] = self.application_type
        if self.description is not None:
            result['Description'] = self.description
        if self.dynamic_route_id is not None:
            result['DynamicRouteId'] = self.dynamic_route_id
        if self.dynamic_route_type is not None:
            result['DynamicRouteType'] = self.dynamic_route_type
        if self.modify_type is not None:
            result['ModifyType'] = self.modify_type
        if self.name is not None:
            result['Name'] = self.name
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.region_ids is not None:
            result['RegionIds'] = self.region_ids
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_ids is not None:
            result['TagIds'] = self.tag_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('ApplicationType') is not None:
            self.application_type = m.get('ApplicationType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DynamicRouteId') is not None:
            self.dynamic_route_id = m.get('DynamicRouteId')
        if m.get('DynamicRouteType') is not None:
            self.dynamic_route_type = m.get('DynamicRouteType')
        if m.get('ModifyType') is not None:
            self.modify_type = m.get('ModifyType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RegionIds') is not None:
            self.region_ids = m.get('RegionIds')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagIds') is not None:
            self.tag_ids = m.get('TagIds')
        return self


class UpdateDynamicRouteResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateDynamicRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateDynamicRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateDynamicRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateExcessiveDeviceRegistrationApplicationsStatusRequest(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        status: str = None,
    ):
        # This parameter is required.
        self.application_ids = application_ids
        # This parameter is required.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class UpdateExcessiveDeviceRegistrationApplicationsStatusResponseBodyApplications(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        create_time: str = None,
        department: str = None,
        description: str = None,
        device_tag: str = None,
        device_type: str = None,
        hostname: str = None,
        is_used: bool = None,
        mac: str = None,
        sase_user_id: str = None,
        status: str = None,
        username: str = None,
    ):
        self.application_id = application_id
        self.create_time = create_time
        self.department = department
        self.description = description
        self.device_tag = device_tag
        self.device_type = device_type
        self.hostname = hostname
        self.is_used = is_used
        self.mac = mac
        self.sase_user_id = sase_user_id
        self.status = status
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.department is not None:
            result['Department'] = self.department
        if self.description is not None:
            result['Description'] = self.description
        if self.device_tag is not None:
            result['DeviceTag'] = self.device_tag
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.is_used is not None:
            result['IsUsed'] = self.is_used
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.sase_user_id is not None:
            result['SaseUserId'] = self.sase_user_id
        if self.status is not None:
            result['Status'] = self.status
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceTag') is not None:
            self.device_tag = m.get('DeviceTag')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('IsUsed') is not None:
            self.is_used = m.get('IsUsed')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('SaseUserId') is not None:
            self.sase_user_id = m.get('SaseUserId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class UpdateExcessiveDeviceRegistrationApplicationsStatusResponseBody(TeaModel):
    def __init__(
        self,
        applications: List[UpdateExcessiveDeviceRegistrationApplicationsStatusResponseBodyApplications] = None,
        request_id: str = None,
    ):
        self.applications = applications
        self.request_id = request_id

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = UpdateExcessiveDeviceRegistrationApplicationsStatusResponseBodyApplications()
                self.applications.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateExcessiveDeviceRegistrationApplicationsStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateExcessiveDeviceRegistrationApplicationsStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateExcessiveDeviceRegistrationApplicationsStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateIdpDepartmentRequest(TeaModel):
    def __init__(
        self,
        department_id: str = None,
        department_name: str = None,
        idp_config_id: str = None,
    ):
        # This parameter is required.
        self.department_id = department_id
        # This parameter is required.
        self.department_name = department_name
        # This parameter is required.
        self.idp_config_id = idp_config_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.department_name is not None:
            result['DepartmentName'] = self.department_name
        if self.idp_config_id is not None:
            result['IdpConfigId'] = self.idp_config_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('DepartmentName') is not None:
            self.department_name = m.get('DepartmentName')
        if m.get('IdpConfigId') is not None:
            self.idp_config_id = m.get('IdpConfigId')
        return self


class UpdateIdpDepartmentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateIdpDepartmentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateIdpDepartmentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateIdpDepartmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateNacUserCertStatusRequestIdList(TeaModel):
    def __init__(
        self,
        dev_tag: str = None,
        user_id: str = None,
    ):
        self.dev_tag = dev_tag
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dev_tag is not None:
            result['DevTag'] = self.dev_tag
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DevTag') is not None:
            self.dev_tag = m.get('DevTag')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class UpdateNacUserCertStatusRequest(TeaModel):
    def __init__(
        self,
        id_list: List[UpdateNacUserCertStatusRequestIdList] = None,
        status: str = None,
    ):
        self.id_list = id_list
        self.status = status

    def validate(self):
        if self.id_list:
            for k in self.id_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IdList'] = []
        if self.id_list is not None:
            for k in self.id_list:
                result['IdList'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.id_list = []
        if m.get('IdList') is not None:
            for k in m.get('IdList'):
                temp_model = UpdateNacUserCertStatusRequestIdList()
                self.id_list.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class UpdateNacUs