# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['synapse',
 'synapse._scripts',
 'synapse.api',
 'synapse.app',
 'synapse.appservice',
 'synapse.config',
 'synapse.crypto',
 'synapse.events',
 'synapse.federation',
 'synapse.federation.sender',
 'synapse.federation.transport',
 'synapse.federation.transport.server',
 'synapse.groups',
 'synapse.handlers',
 'synapse.handlers.ui_auth',
 'synapse.http',
 'synapse.http.federation',
 'synapse.logging',
 'synapse.metrics',
 'synapse.module_api',
 'synapse.push',
 'synapse.replication',
 'synapse.replication.http',
 'synapse.replication.slave',
 'synapse.replication.slave.storage',
 'synapse.replication.tcp',
 'synapse.replication.tcp.streams',
 'synapse.rest',
 'synapse.rest.admin',
 'synapse.rest.client',
 'synapse.rest.consent',
 'synapse.rest.key',
 'synapse.rest.key.v2',
 'synapse.rest.media',
 'synapse.rest.media.v1',
 'synapse.rest.synapse',
 'synapse.rest.synapse.client',
 'synapse.rest.synapse.client.oidc',
 'synapse.rest.synapse.client.saml2',
 'synapse.server_notices',
 'synapse.spam_checker_api',
 'synapse.state',
 'synapse.storage',
 'synapse.storage.databases',
 'synapse.storage.databases.main',
 'synapse.storage.databases.state',
 'synapse.storage.engines',
 'synapse.storage.schema',
 'synapse.storage.schema.main.delta.20',
 'synapse.storage.schema.main.delta.25',
 'synapse.storage.schema.main.delta.27',
 'synapse.storage.schema.main.delta.30',
 'synapse.storage.schema.main.delta.31',
 'synapse.storage.schema.main.delta.33',
 'synapse.storage.schema.main.delta.34',
 'synapse.storage.schema.main.delta.37',
 'synapse.storage.schema.main.delta.42',
 'synapse.storage.schema.main.delta.48',
 'synapse.storage.schema.main.delta.50',
 'synapse.storage.schema.main.delta.56',
 'synapse.storage.schema.main.delta.57',
 'synapse.storage.schema.main.delta.58',
 'synapse.storage.schema.main.delta.59',
 'synapse.storage.schema.main.delta.61',
 'synapse.storage.schema.main.delta.68',
 'synapse.storage.schema.main.delta.69',
 'synapse.storage.schema.state.delta.47',
 'synapse.storage.util',
 'synapse.streams',
 'synapse.util',
 'synapse.util.caches']

package_data = \
{'': ['*'],
 'synapse': ['res/*',
             'res/templates/*',
             'static/*',
             'static/client/login/*',
             'static/client/login/js/*',
             'static/client/register/*',
             'static/client/register/js/*'],
 'synapse.storage.schema': ['common/*',
                            'common/delta/25/*',
                            'common/delta/35/*',
                            'common/delta/58/*',
                            'common/full_schemas/54/*',
                            'main/delta/12/*',
                            'main/delta/13/*',
                            'main/delta/14/*',
                            'main/delta/15/*',
                            'main/delta/16/*',
                            'main/delta/17/*',
                            'main/delta/18/*',
                            'main/delta/19/*',
                            'main/delta/21/*',
                            'main/delta/22/*',
                            'main/delta/24/*',
                            'main/delta/26/*',
                            'main/delta/28/*',
                            'main/delta/29/*',
                            'main/delta/32/*',
                            'main/delta/35/*',
                            'main/delta/36/*',
                            'main/delta/38/*',
                            'main/delta/39/*',
                            'main/delta/40/*',
                            'main/delta/41/*',
                            'main/delta/43/*',
                            'main/delta/44/*',
                            'main/delta/45/*',
                            'main/delta/46/*',
                            'main/delta/47/*',
                            'main/delta/49/*',
                            'main/delta/51/*',
                            'main/delta/52/*',
                            'main/delta/53/*',
                            'main/delta/54/*',
                            'main/delta/55/*',
                            'main/delta/60/*',
                            'main/delta/62/*',
                            'main/delta/63/*',
                            'main/delta/64/*',
                            'main/delta/65/*',
                            'main/delta/67/*',
                            'main/full_schemas/16/*',
                            'main/full_schemas/54/*',
                            'state/delta/23/*',
                            'state/delta/30/*',
                            'state/delta/32/*',
                            'state/delta/35/*',
                            'state/delta/56/*',
                            'state/delta/61/*',
                            'state/full_schemas/54/*']}

install_requires = \
['Jinja2>=3.0',
 'Pillow>=5.4.0',
 'PyNaCl>=1.2.1',
 'PyYAML>=3.11',
 'Twisted[tls]>=18.9.0',
 'attrs>=19.2.0,!=21.1.0',
 'bcrypt>=3.1.0',
 'bleach>=1.4.3',
 'canonicaljson>=1.4.0',
 'cryptography>=3.4.7',
 'frozendict>=1,!=2.1.2',
 'ijson>=3.1.4',
 'jsonschema>=3.0.0',
 'matrix-common>=1.1.0,<1.2.0',
 'msgpack>=0.5.2',
 'netaddr>=0.7.18',
 'packaging>=16.1',
 'phonenumbers>=8.2.0',
 'prometheus-client>=0.4.0',
 'pyOpenSSL>=16.0.0',
 'pyasn1-modules>=0.0.7',
 'pyasn1>=0.1.9',
 'pymacaroons>=0.13.0',
 'service-identity>=18.1.0',
 'signedjson>=1.1.0',
 'sortedcontainers>=1.4.4',
 'treq>=15.1',
 'typing-extensions>=3.10.0',
 'unpaddedbase64>=2.1.0']

extras_require = \
{':python_version < "3.8"': ['importlib_metadata>=1.4'],
 'all': ['matrix-synapse-ldap3>=0.1',
         'pysaml2>=4.5.0',
         'authlib>=0.14.0',
         'lxml>=4.2.0',
         'sentry-sdk>=0.7.2',
         'opentracing>=2.2.0',
         'jaeger-client>=4.0.0',
         'pyjwt>=1.6.4',
         'txredisapi>=1.4.7',
         'hiredis'],
 'all:platform_python_implementation != "PyPy"': ['psycopg2>=2.8'],
 'all:platform_python_implementation == "PyPy"': ['psycopg2cffi>=2.8',
                                                  'psycopg2cffi-compat==1.1'],
 'cache_memory': ['Pympler'],
 'jwt': ['pyjwt>=1.6.4'],
 'matrix-synapse-ldap3': ['matrix-synapse-ldap3>=0.1'],
 'oidc': ['authlib>=0.14.0'],
 'opentracing': ['opentracing>=2.2.0', 'jaeger-client>=4.0.0'],
 'postgres:platform_python_implementation != "PyPy"': ['psycopg2>=2.8'],
 'postgres:platform_python_implementation == "PyPy"': ['psycopg2cffi>=2.8',
                                                       'psycopg2cffi-compat==1.1'],
 'redis': ['txredisapi>=1.4.7', 'hiredis'],
 'saml2': ['pysaml2>=4.5.0'],
 'sentry': ['sentry-sdk>=0.7.2'],
 'systemd': ['systemd-python>=231'],
 'test': ['parameterized>=0.7.4', 'idna>=2.5'],
 'url_preview': ['lxml>=4.2.0']}

entry_points = \
{'console_scripts': ['export_signing_key = '
                     'synapse._scripts.export_signing_key:main',
                     'generate_config = synapse._scripts.generate_config:main',
                     'generate_log_config = '
                     'synapse._scripts.generate_log_config:main',
                     'generate_signing_key = '
                     'synapse._scripts.generate_signing_key:main',
                     'hash_password = synapse._scripts.hash_password:main',
                     'register_new_matrix_user = '
                     'synapse._scripts.register_new_matrix_user:main',
                     'synapse_homeserver = synapse.app.homeserver:main',
                     'synapse_port_db = synapse._scripts.synapse_port_db:main',
                     'synapse_review_recent_signups = '
                     'synapse._scripts.review_recent_signups:main',
                     'synapse_worker = synapse.app.generic_worker:main',
                     'synctl = synapse._scripts.synctl:main',
                     'update_synapse_database = '
                     'synapse._scripts.update_synapse_database:main']}

setup_kwargs = {
    'name': 'matrix-synapse',
    'version': '1.58.1',
    'description': 'Homeserver for the Matrix decentralised comms protocol',
    'long_description': '=========================================================================\nSynapse |support| |development| |documentation| |license| |pypi| |python|\n=========================================================================\n\n.. contents::\n\nIntroduction\n============\n\nMatrix is an ambitious new ecosystem for open federated Instant Messaging and\nVoIP.  The basics you need to know to get up and running are:\n\n- Everything in Matrix happens in a room.  Rooms are distributed and do not\n  exist on any single server.  Rooms can be located using convenience aliases\n  like ``#matrix:matrix.org`` or ``#test:localhost:8448``.\n\n- Matrix user IDs look like ``@matthew:matrix.org`` (although in the future\n  you will normally refer to yourself and others using a third party identifier\n  (3PID): email address, phone number, etc rather than manipulating Matrix user IDs)\n\nThe overall architecture is::\n\n      client <----> homeserver <=====================> homeserver <----> client\n             https://somewhere.org/_matrix      https://elsewhere.net/_matrix\n\n``#matrix:matrix.org`` is the official support room for Matrix, and can be\naccessed by any client from https://matrix.org/docs/projects/try-matrix-now.html or\nvia IRC bridge at irc://irc.libera.chat/matrix.\n\nSynapse is currently in rapid development, but as of version 0.5 we believe it\nis sufficiently stable to be run as an internet-facing service for real usage!\n\nAbout Matrix\n============\n\nMatrix specifies a set of pragmatic RESTful HTTP JSON APIs as an open standard,\nwhich handle:\n\n- Creating and managing fully distributed chat rooms with no\n  single points of control or failure\n- Eventually-consistent cryptographically secure synchronisation of room\n  state across a global open network of federated servers and services\n- Sending and receiving extensible messages in a room with (optional)\n  end-to-end encryption\n- Inviting, joining, leaving, kicking, banning room members\n- Managing user accounts (registration, login, logout)\n- Using 3rd Party IDs (3PIDs) such as email addresses, phone numbers,\n  Facebook accounts to authenticate, identify and discover users on Matrix.\n- Placing 1:1 VoIP and Video calls\n\nThese APIs are intended to be implemented on a wide range of servers, services\nand clients, letting developers build messaging and VoIP functionality on top\nof the entirely open Matrix ecosystem rather than using closed or proprietary\nsolutions. The hope is for Matrix to act as the building blocks for a new\ngeneration of fully open and interoperable messaging and VoIP apps for the\ninternet.\n\nSynapse is a Matrix "homeserver" implementation developed by the matrix.org core \nteam, written in Python 3/Twisted.\n\nIn Matrix, every user runs one or more Matrix clients, which connect through to\na Matrix homeserver. The homeserver stores all their personal chat history and\nuser account information - much as a mail client connects through to an\nIMAP/SMTP server. Just like email, you can either run your own Matrix\nhomeserver and control and own your own communications and history or use one\nhosted by someone else (e.g. matrix.org) - there is no single point of control\nor mandatory service provider in Matrix, unlike WhatsApp, Facebook, Hangouts,\netc.\n\nWe\'d like to invite you to join #matrix:matrix.org (via\nhttps://matrix.org/docs/projects/try-matrix-now.html), run a homeserver, take a look\nat the `Matrix spec <https://matrix.org/docs/spec>`_, and experiment with the\n`APIs <https://matrix.org/docs/api>`_ and `Client SDKs\n<https://matrix.org/docs/projects/try-matrix-now.html#client-sdks>`_.\n\nThanks for using Matrix!\n\nSupport\n=======\n\nFor support installing or managing Synapse, please join |room|_ (from a matrix.org\naccount if necessary) and ask questions there. We do not use GitHub issues for\nsupport requests, only for bug reports and feature requests.\n\nSynapse\'s documentation is `nicely rendered on GitHub Pages <https://matrix-org.github.io/synapse>`_,\nwith its source available in |docs|_.\n\n.. |room| replace:: ``#synapse:matrix.org``\n.. _room: https://matrix.to/#/#synapse:matrix.org\n\n.. |docs| replace:: ``docs``\n.. _docs: docs\n\nSynapse Installation\n====================\n\n.. _federation:\n\n* For details on how to install synapse, see\n  `Installation Instructions <https://matrix-org.github.io/synapse/latest/setup/installation.html>`_.\n* For specific details on how to configure Synapse for federation see `docs/federate.md <docs/federate.md>`_\n\n\nConnecting to Synapse from a client\n===================================\n\nThe easiest way to try out your new Synapse installation is by connecting to it\nfrom a web client.\n\nUnless you are running a test instance of Synapse on your local machine, in\ngeneral, you will need to enable TLS support before you can successfully\nconnect from a client: see\n`TLS certificates <https://matrix-org.github.io/synapse/latest/setup/installation.html#tls-certificates>`_.\n\nAn easy way to get started is to login or register via Element at\nhttps://app.element.io/#/login or https://app.element.io/#/register respectively.\nYou will need to change the server you are logging into from ``matrix.org``\nand instead specify a Homeserver URL of ``https://<server_name>:8448``\n(or just ``https://<server_name>`` if you are using a reverse proxy).\nIf you prefer to use another client, refer to our\n`client breakdown <https://matrix.org/docs/projects/clients-matrix>`_.\n\nIf all goes well you should at least be able to log in, create a room, and\nstart sending messages.\n\n.. _`client-user-reg`:\n\nRegistering a new user from a client\n------------------------------------\n\nBy default, registration of new users via Matrix clients is disabled. To enable\nit, specify ``enable_registration: true`` in ``homeserver.yaml``. (It is then\nrecommended to also set up CAPTCHA - see `<docs/CAPTCHA_SETUP.md>`_.)\n\nOnce ``enable_registration`` is set to ``true``, it is possible to register a\nuser via a Matrix client.\n\nYour new user name will be formed partly from the ``server_name``, and partly\nfrom a localpart you specify when you create the account. Your name will take\nthe form of::\n\n    @localpart:my.domain.name\n\n(pronounced "at localpart on my dot domain dot name").\n\nAs when logging in, you will need to specify a "Custom server".  Specify your\ndesired ``localpart`` in the \'User name\' box.\n\nSecurity note\n=============\n\nMatrix serves raw, user-supplied data in some APIs -- specifically the `content\nrepository endpoints`_.\n\n.. _content repository endpoints: https://matrix.org/docs/spec/client_server/latest.html#get-matrix-media-r0-download-servername-mediaid\n\nWhilst we make a reasonable effort to mitigate against XSS attacks (for\ninstance, by using `CSP`_), a Matrix homeserver should not be hosted on a\ndomain hosting other web applications. This especially applies to sharing\nthe domain with Matrix web clients and other sensitive applications like\nwebmail. See\nhttps://developer.github.com/changes/2014-04-25-user-content-security for more\ninformation.\n\n.. _CSP: https://github.com/matrix-org/synapse/pull/1021\n\nIdeally, the homeserver should not simply be on a different subdomain, but on\na completely different `registered domain`_ (also known as top-level site or\neTLD+1). This is because `some attacks`_ are still possible as long as the two\napplications share the same registered domain.\n\n.. _registered domain: https://tools.ietf.org/html/draft-ietf-httpbis-rfc6265bis-03#section-2.3\n\n.. _some attacks: https://en.wikipedia.org/wiki/Session_fixation#Attacks_using_cross-subdomain_cookie\n\nTo illustrate this with an example, if your Element Web or other sensitive web\napplication is hosted on ``A.example1.com``, you should ideally host Synapse on\n``example2.com``. Some amount of protection is offered by hosting on\n``B.example1.com`` instead, so this is also acceptable in some scenarios.\nHowever, you should *not* host your Synapse on ``A.example1.com``.\n\nNote that all of the above refers exclusively to the domain used in Synapse\'s\n``public_baseurl`` setting. In particular, it has no bearing on the domain\nmentioned in MXIDs hosted on that server.\n\nFollowing this advice ensures that even if an XSS is found in Synapse, the\nimpact to other applications will be minimal.\n\n\nUpgrading an existing Synapse\n=============================\n\nThe instructions for upgrading synapse are in `the upgrade notes`_.\nPlease check these instructions as upgrading may require extra steps for some\nversions of synapse.\n\n.. _the upgrade notes: https://matrix-org.github.io/synapse/develop/upgrade.html\n\n.. _reverse-proxy:\n\nUsing a reverse proxy with Synapse\n==================================\n\nIt is recommended to put a reverse proxy such as\n`nginx <https://nginx.org/en/docs/http/ngx_http_proxy_module.html>`_,\n`Apache <https://httpd.apache.org/docs/current/mod/mod_proxy_http.html>`_,\n`Caddy <https://caddyserver.com/docs/quick-starts/reverse-proxy>`_,\n`HAProxy <https://www.haproxy.org/>`_ or\n`relayd <https://man.openbsd.org/relayd.8>`_ in front of Synapse. One advantage of\ndoing so is that it means that you can expose the default https port (443) to\nMatrix clients without needing to run Synapse with root privileges.\n\nFor information on configuring one, see `<docs/reverse_proxy.md>`_.\n\nIdentity Servers\n================\n\nIdentity servers have the job of mapping email addresses and other 3rd Party\nIDs (3PIDs) to Matrix user IDs, as well as verifying the ownership of 3PIDs\nbefore creating that mapping.\n\n**They are not where accounts or credentials are stored - these live on home\nservers. Identity Servers are just for mapping 3rd party IDs to matrix IDs.**\n\nThis process is very security-sensitive, as there is obvious risk of spam if it\nis too easy to sign up for Matrix accounts or harvest 3PID data. In the longer\nterm, we hope to create a decentralised system to manage it (`matrix-doc #712\n<https://github.com/matrix-org/matrix-doc/issues/712>`_), but in the meantime,\nthe role of managing trusted identity in the Matrix ecosystem is farmed out to\na cluster of known trusted ecosystem partners, who run \'Matrix Identity\nServers\' such as `Sydent <https://github.com/matrix-org/sydent>`_, whose role\nis purely to authenticate and track 3PID logins and publish end-user public\nkeys.\n\nYou can host your own copy of Sydent, but this will prevent you reaching other\nusers in the Matrix ecosystem via their email address, and prevent them finding\nyou. We therefore recommend that you use one of the centralised identity servers\nat ``https://matrix.org`` or ``https://vector.im`` for now.\n\nTo reiterate: the Identity server will only be used if you choose to associate\nan email address with your account, or send an invite to another user via their\nemail address.\n\n\nPassword reset\n==============\n\nUsers can reset their password through their client. Alternatively, a server admin\ncan reset a users password using the `admin API <docs/admin_api/user_admin_api.md#reset-password>`_\nor by directly editing the database as shown below.\n\nFirst calculate the hash of the new password::\n\n    $ ~/synapse/env/bin/hash_password\n    Password:\n    Confirm password:\n    $2a$12$xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\n\nThen update the ``users`` table in the database::\n\n    UPDATE users SET password_hash=\'$2a$12$xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\'\n        WHERE name=\'@test:test.com\';\n\n\nSynapse Development\n===================\n\nThe best place to get started is our\n`guide for contributors <https://matrix-org.github.io/synapse/latest/development/contributing_guide.html>`_.\nThis is part of our larger `documentation <https://matrix-org.github.io/synapse/latest>`_, which includes\ninformation for synapse developers as well as synapse administrators.\n\nDevelopers might be particularly interested in:\n\n* `Synapse\'s database schema <https://matrix-org.github.io/synapse/latest/development/database_schema.html>`_,\n* `notes on Synapse\'s implementation details <https://matrix-org.github.io/synapse/latest/development/internal_documentation/index.html>`_, and\n* `how we use git <https://matrix-org.github.io/synapse/latest/development/git.html>`_.\n\nAlongside all that, join our developer community on Matrix:\n`#synapse-dev:matrix.org <https://matrix.to/#/#synapse-dev:matrix.org>`_, featuring real humans!\n\n\nQuick start\n-----------\n\nBefore setting up a development environment for synapse, make sure you have the\nsystem dependencies (such as the python header files) installed - see\n`Platform-specific prerequisites <https://matrix-org.github.io/synapse/latest/setup/installation.html#platform-specific-prerequisites>`_.\n\nTo check out a synapse for development, clone the git repo into a working\ndirectory of your choice::\n\n    git clone https://github.com/matrix-org/synapse.git\n    cd synapse\n\nSynapse has a number of external dependencies. We maintain a fixed development\nenvironment using [poetry](https://python-poetry.org/). First, install poetry. We recommend\n\n    pip install --user pipx\n    pipx install poetry\n\nas described `here <https://python-poetry.org/docs/#installing-with-pipx>`_.\n(See `poetry\'s installation docs <https://python-poetry.org/docs/#installation>`\nfor other installation methods.) Then ask poetry to create a virtual environment\nfrom the project and install Synapse\'s dependencies::\n\n    poetry install --extras "all test"\n\nThis will run a process of downloading and installing all the needed\ndependencies into a virtual env.\n\nWe recommend using the demo which starts 3 federated instances running on ports `8080` - `8082`\n\n    poetry run ./demo/start.sh\n\n(to stop, you can use `poetry run ./demo/stop.sh`)\n\nSee the `demo documentation <https://matrix-org.github.io/synapse/develop/development/demo.html>`_\nfor more information.\n\nIf you just want to start a single instance of the app and run it directly::\n\n    # Create the homeserver.yaml config once\n    poetry run synapse_homeserver \\\n      --server-name my.domain.name \\\n      --config-path homeserver.yaml \\\n      --generate-config \\\n      --report-stats=[yes|no]\n\n    # Start the app\n    poetry run synapse_homeserver --config-path homeserver.yaml\n\n\nRunning the unit tests\n----------------------\n\nAfter getting up and running, you may wish to run Synapse\'s unit tests to\ncheck that everything is installed correctly::\n\n    poetry run trial tests\n\nThis should end with a \'PASSED\' result (note that exact numbers will\ndiffer)::\n\n    Ran 1337 tests in 716.064s\n\n    PASSED (skips=15, successes=1322)\n\nFor more tips on running the unit tests, like running a specific test or\nto see the logging output, see the `CONTRIBUTING doc <CONTRIBUTING.md#run-the-unit-tests>`_.\n\n\nRunning the Integration Tests\n-----------------------------\n\nSynapse is accompanied by `SyTest <https://github.com/matrix-org/sytest>`_,\na Matrix homeserver integration testing suite, which uses HTTP requests to\naccess the API as a Matrix client would. It is able to run Synapse directly from\nthe source tree, so installation of the server is not required.\n\nTesting with SyTest is recommended for verifying that changes related to the\nClient-Server API are functioning correctly. See the `SyTest installation\ninstructions <https://github.com/matrix-org/sytest#installing>`_ for details.\n\n\nPlatform dependencies\n=====================\n\nSynapse uses a number of platform dependencies such as Python and PostgreSQL,\nand aims to follow supported upstream versions. See the\n`<docs/deprecation_policy.md>`_ document for more details.\n\n\nTroubleshooting\n===============\n\nNeed help? Join our community support room on Matrix:\n`#synapse:matrix.org <https://matrix.to/#/#synapse:matrix.org>`_\n\nRunning out of File Handles\n---------------------------\n\nIf synapse runs out of file handles, it typically fails badly - live-locking\nat 100% CPU, and/or failing to accept new TCP connections (blocking the\nconnecting client).  Matrix currently can legitimately use a lot of file handles,\nthanks to busy rooms like #matrix:matrix.org containing hundreds of participating\nservers.  The first time a server talks in a room it will try to connect\nsimultaneously to all participating servers, which could exhaust the available\nfile descriptors between DNS queries & HTTPS sockets, especially if DNS is slow\nto respond. (We need to improve the routing algorithm used to be better than\nfull mesh, but as of March 2019 this hasn\'t happened yet).\n\nIf you hit this failure mode, we recommend increasing the maximum number of\nopen file handles to be at least 4096 (assuming a default of 1024 or 256).\nThis is typically done by editing ``/etc/security/limits.conf``\n\nSeparately, Synapse may leak file handles if inbound HTTP requests get stuck\nduring processing - e.g. blocked behind a lock or talking to a remote server etc.\nThis is best diagnosed by matching up the \'Received request\' and \'Processed request\'\nlog lines and looking for any \'Processed request\' lines which take more than\na few seconds to execute. Please let us know at #synapse:matrix.org if\nyou see this failure mode so we can help debug it, however.\n\nHelp!! Synapse is slow and eats all my RAM/CPU!\n-----------------------------------------------\n\nFirst, ensure you are running the latest version of Synapse, using Python 3\nwith a PostgreSQL database.\n\nSynapse\'s architecture is quite RAM hungry currently - we deliberately\ncache a lot of recent room data and metadata in RAM in order to speed up\ncommon requests. We\'ll improve this in the future, but for now the easiest\nway to either reduce the RAM usage (at the risk of slowing things down)\nis to set the almost-undocumented ``SYNAPSE_CACHE_FACTOR`` environment\nvariable. The default is 0.5, which can be decreased to reduce RAM usage\nin memory constrained enviroments, or increased if performance starts to\ndegrade.\n\nHowever, degraded performance due to a low cache factor, common on\nmachines with slow disks, often leads to explosions in memory use due\nbacklogged requests. In this case, reducing the cache factor will make\nthings worse. Instead, try increasing it drastically. 2.0 is a good\nstarting value.\n\nUsing `libjemalloc <http://jemalloc.net/>`_ can also yield a significant\nimprovement in overall memory use, and especially in terms of giving back\nRAM to the OS. To use it, the library must simply be put in the\nLD_PRELOAD environment variable when launching Synapse. On Debian, this\ncan be done by installing the ``libjemalloc1`` package and adding this\nline to ``/etc/default/matrix-synapse``::\n\n    LD_PRELOAD=/usr/lib/x86_64-linux-gnu/libjemalloc.so.1\n\nThis can make a significant difference on Python 2.7 - it\'s unclear how\nmuch of an improvement it provides on Python 3.x.\n\nIf you\'re encountering high CPU use by the Synapse process itself, you\nmay be affected by a bug with presence tracking that leads to a\nmassive excess of outgoing federation requests (see `discussion\n<https://github.com/matrix-org/synapse/issues/3971>`_). If metrics\nindicate that your server is also issuing far more outgoing federation\nrequests than can be accounted for by your users\' activity, this is a\nlikely cause. The misbehavior can be worked around by setting\nthe following in the Synapse config file:\n\n.. code-block:: yaml\n\n   presence:\n       enabled: false\n\nPeople can\'t accept room invitations from me\n--------------------------------------------\n\nThe typical failure mode here is that you send an invitation to someone\nto join a room or direct chat, but when they go to accept it, they get an\nerror (typically along the lines of "Invalid signature"). They might see\nsomething like the following in their logs::\n\n    2019-09-11 19:32:04,271 - synapse.federation.transport.server - 288 - WARNING - GET-11752 - authenticate_request failed: 401: Invalid signature for server <server> with key ed25519:a_EqML: Unable to verify signature for <server>\n\nThis is normally caused by a misconfiguration in your reverse-proxy. See\n`<docs/reverse_proxy.md>`_ and double-check that your settings are correct.\n\n.. |support| image:: https://img.shields.io/matrix/synapse:matrix.org?label=support&logo=matrix\n  :alt: (get support on #synapse:matrix.org)\n  :target: https://matrix.to/#/#synapse:matrix.org\n\n.. |development| image:: https://img.shields.io/matrix/synapse-dev:matrix.org?label=development&logo=matrix\n  :alt: (discuss development on #synapse-dev:matrix.org)\n  :target: https://matrix.to/#/#synapse-dev:matrix.org\n\n.. |documentation| image:: https://img.shields.io/badge/documentation-%E2%9C%93-success\n  :alt: (Rendered documentation on GitHub Pages)\n  :target: https://matrix-org.github.io/synapse/latest/\n\n.. |license| image:: https://img.shields.io/github/license/matrix-org/synapse\n  :alt: (check license in LICENSE file)\n  :target: LICENSE\n\n.. |pypi| image:: https://img.shields.io/pypi/v/matrix-synapse\n  :alt: (latest version released on PyPi)\n  :target: https://pypi.org/project/matrix-synapse\n\n.. |python| image:: https://img.shields.io/pypi/pyversions/matrix-synapse\n  :alt: (supported python versions)\n  :target: https://pypi.org/project/matrix-synapse\n',
    'author': 'Matrix.org Team and Contributors',
    'author_email': 'packages@matrix.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/matrix-org/synapse',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
