#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream>

#include "PairwiseAlign.h"

#define NUM_REF_SEQ   348

static const char *_ref_seq[NUM_REF_SEQ] = {
       "GLY", "GLN", "ASP", "GLU", "GLU", "ARG", "ASP", "VAL", "GLY", "ASP", "ASP", "PRO", "PHE",
       "VAL", "ARG", "ARG", "ALA", "GLY", "ALA", "PHE", "LEU", "GLY", "ILE", "GLU", "ALA", "GLY",
       "THR", "ILE", "THR", "ILE", "GLU", "LEU", "SER", "ASN", "LEU", "ILE", "ASP", "PHE", "TYR",
       "ILE", "ARG", "ASN", "GLY", "ILE", "LEU", "GLU", "MET", "GLU", "ASN", "GLU", "GLN", "ALA",
       "VAL", "TYR", "PRO", "VAL", "ASN", "LEU", "ARG", "GLY", "VAL", "PHE", "ASP", "LEU", "ASN",
       "ILE", "LEU", "GLN", "GLU", "MET", "TYR", "ARG", "GLN", "TYR", "LEU", "ILE", "GLN", "SER",
       "PHE", "ALA", "ALA", "LYS", "SER", "ARG", "THR", "GLU", "LYS", "GLU", "ARG", "LEU", "PHE",
       "ASN", "ASN", "LEU", "ALA", "HIS", "LEU", "GLY", "ASN", "ILE", "LEU", "GLY", "LEU", "THR",
       "SER", "ALA", "GLU", "VAL", "ASN", "ALA", "ILE", "HIS", "SER", "ASN", "ILE", "GLY", "SER",
       "VAL", "ILE", "TYR", "LYS", "THR", "TYR", "ALA", "SER", "GLN", "ALA", "LEU", "THR", "ASN",
       "ASN", "ARG", "LEU", "GLU", "GLU", "LYS", "ASP", "ILE", "GLU", "PHE", "LEU", "ARG", "ASN",
       "ILE", "GLN", "ASN", "MET", "LEU", "SER", "MET", "ASP", "GLU", "ALA", "THR", "CYS", "ARG",
       "THR", "LEU", "LEU", "GLN", "GLU", "THR", "LYS", "GLU", "ALA", "ARG", "ALA", "GLY", "PHE",
       "LEU", "PHE", "ASP", "LYS", "ILE", "PHE", "SER", "ARG", "THR", "PHE", "GLY", "MET", "ALA",
       "GLU", "ALA", "VAL", "ALA", "GLU", "PHE", "ARG", "ARG", "VAL", "CYS", "ARG", "GLU", "LEU",
       "ASP", "VAL", "ASP", "PRO", "VAL", "ARG", "ASP", "LEU", "LYS", "LEU", "THR", "GLU", "ASP",
       "ARG", "ARG", "VAL", "ARG", "ALA", "PHE", "ARG", "ALA", "GLU", "ILE", "GLU", "HIS", "ALA",
       "ILE", "GLU", "ASN", "GLY", "LEU", "ILE", "THR", "PRO", "GLU", "ASN", "GLN", "SER", "LEU",
       "LEU", "LYS", "GLU", "SER", "GLN", "GLU", "GLU", "LEU", "GLY", "ILE", "SER", "ALA", "GLU",
       "LYS", "ALA", "ARG", "GLN", "VAL", "LEU", "LEU", "ASP", "CYS", "ILE", "GLN", "ASP", "ARG",
       "CYS", "GLU", "ALA", "LEU", "ILE", "VAL", "GLN", "ALA", "ALA", "ALA", "SER", "LEU", "ARG",
       "GLN", "ARG", "ARG", "GLN", "GLU", "GLY", "ALA", "ALA", "ARG", "ASP", "LEU", "SER", "ARG",
       "ALA", "LEU", "ARG", "PHE", "GLY", "LYS", "LEU", "LEU", "PRO", "PHE", "GLN", "VAL", "GLN",
       "THR", "PRO", "THR", "VAL", "THR", "GLY", "ALA", "GLU", "ARG", "GLN", "GLU", "LEU", "TYR",
       "LEU", "VAL", "TYR", "GLN", "ALA", "TYR", "ALA", "LEU", "GLY", "THR", "ALA", "ARG", "SER",
       "ASN", "ALA", "GLU", "ASN", "ASP", "GLN", "VAL", "LYS", "GLU", "ASP", "LEU", "ALA", "LEU",
       "LEU", "ARG", "GLU", "MET", "LEU", "GLY", "ILE", "GLN", "ALA", "ALA"
};

#define NUM_COORD_SEQ  270

static const char *_coord_seq[NUM_COORD_SEQ] = { 
       "SER", "ASN", "LEU", "ILE", "ASP", "PHE", "TYR", "ILE", "ARG", "ASN",
       "GLY", "ILE", "LEU", "GLU", "MET", "GLU", "ASN", "GLU", "GLN", "ALA",
       "VAL", "TYR", "PRO", "VAL", "ALA", "ALA", "ALA", "ALA", "ALA", "ALA",
       "ALA", "ALA", "ALA", "ALA", "LEU", "GLN", "GLU", "MET", "TYR", "ARG",
       "GLN", "TYR", "LEU", "ILE", "GLN", "SER", "PHE", "ALA", "ALA", "ALA",
       "SER", "ALA", "ALA", "ALA", "LYS", "GLU", "ARG", "LEU", "PHE", "ASN",
       "ASN", "LEU", "ALA", "HIS", "LEU", "GLY", "ALA", "ALA", "ALA", "ALA",
       "VAL", "ASN", "ALA", "ILE", "HIS", "SER", "ASN", "ILE", "GLY", "SER",
       "VAL", "ILE", "TYR", "LYS", "THR", "TYR", "ALA", "SER", "GLN", "ALA",
       "LEU", "THR", "ASN", "ASN", "ARG", "LEU", "GLU", "GLU", "LYS", "ASP",
       "ILE", "GLU", "PHE", "LEU", "ARG", "ASN", "ILE", "GLN", "ASN", "MET",
       "LEU", "SER", "MET", "ASP", "GLU", "ALA", "THR", "CYS", "ARG", "THR",
       "LEU", "LEU", "GLN", "GLU", "THR", "LYS", "GLU", "ALA", "ARG", "ALA",
       "GLY", "PHE", "LEU", "PHE", "ASP", "LYS", "ILE", "PHE", "MET", "ALA",
       "GLU", "ALA", "VAL", "ALA", "GLU", "PHE", "ARG", "ARG", "VAL", "CYS",
       "ARG", "GLU", "LEU", "ASP", "VAL", "GLU", "ASP", "ARG", "ARG", "VAL",
       "ARG", "ALA", "PHE", "ARG", "ALA", "GLU", "ILE", "GLU", "HIS", "ALA",
       "ALA", "ALA", "ALA", "SER", "LEU", "LEU", "LYS", "GLU", "SER", "GLN",
       "GLU", "GLU", "LEU", "GLY", "ILE", "SER", "ALA", "GLU", "LYS", "ALA",
       "ARG", "GLN", "VAL", "LEU", "LEU", "ASP", "CYS", "ILE", "GLN", "ASP",
       "ARG", "CYS", "GLU", "ALA", "LEU", "ILE", "VAL", "GLN", "ALA", "ALA",
       "ALA", "SER", "LEU", "ALA", "ALA", "ALA", "ALA", "GLN", "GLU", "GLY",
       "ALA", "ALA", "ARG", "ASP", "LEU", "SER", "ARG", "ALA", "LEU", "ALA",
       "GLN", "GLU", "LEU", "TYR", "LEU", "VAL", "TYR", "GLN", "ALA", "TYR",
       "ALA", "LEU", "GLY", "THR", "ALA", "ARG", "SER", "ASN", "ALA", "GLU",
       "ASN", "ASP", "GLN", "VAL", "LYS", "GLU", "ASP", "LEU", "ALA", "LEU",
       "LEU", "ARG", "GLU", "MET", "LEU", "GLY", "ILE", "GLN", "ALA", "ALA"
};

#define NUM_LINK  269

static const char *_linkage_dist[NUM_LINK][7] = {
       { "A", "SER", "903", "A", "ASN", "904", "1.330"},
       { "A", "ASN", "904", "A", "LEU", "905", "1.343"},
       { "A", "LEU", "905", "A", "ILE", "906", "1.324"},
       { "A", "ILE", "906", "A", "ASP", "907", "1.328"},
       { "A", "ASP", "907", "A", "PHE", "908", "1.322"},
       { "A", "PHE", "908", "A", "TYR", "909", "1.330"},
       { "A", "TYR", "909", "A", "ILE", "910", "1.321"},
       { "A", "ILE", "910", "A", "ARG", "911", "1.327"},
       { "A", "ARG", "911", "A", "ASN", "912", "1.336"},
       { "A", "ASN", "912", "A", "GLY", "913", "1.324"},
       { "A", "GLY", "913", "A", "ILE", "914", "1.336"},
       { "A", "ILE", "914", "A", "LEU", "915", "1.331"},
       { "A", "LEU", "915", "A", "GLU", "916", "1.321"},
       { "A", "GLU", "916", "A", "MET", "917", "1.313"},
       { "A", "MET", "917", "A", "GLU", "918", "1.325"},
       { "A", "GLU", "918", "A", "ASN", "919", "1.325"},
       { "A", "ASN", "919", "A", "GLU", "920", "1.318"},
       { "A", "GLU", "920", "A", "GLN", "921", "1.321"},
       { "A", "GLN", "921", "A", "ALA", "922", "1.320"},
       { "A", "ALA", "922", "A", "VAL", "923", "1.328"},
       { "A", "VAL", "923", "A", "TYR", "924", "1.311"},
       { "A", "TYR", "924", "A", "PRO", "925", "1.346"},
       { "A", "PRO", "925", "A", "VAL", "926", "1.310"},
       { "A", "VAL", "926", "A", "ALA", "927", "1.326"},
       { "A", "ALA", "927", "A", "ALA", "928", "1.319"},
       { "A", "ALA", "928", "A", "ALA", "929", "1.326"},
       { "A", "ALA", "929", "A", "ALA", "930", "1.330"},
       { "A", "ALA", "930", "A", "ALA", "931", "1.336"},
       { "A", "ALA", "931", "A", "ALA", "932", "1.331"},
       { "A", "ALA", "932", "A", "ALA", "933", "1.335"},
       { "A", "ALA", "933", "A", "ALA", "934", "13.072"},
       { "A", "ALA", "934", "A", "ALA", "935", "1.343"},
       { "A", "ALA", "935", "A", "ALA", "936", "1.324"},
       { "A", "ALA", "936", "A", "LEU", "937", "1.317"},
       { "A", "LEU", "937", "A", "GLN", "938", "1.325"},
       { "A", "GLN", "938", "A", "GLU", "939", "1.325"},
       { "A", "GLU", "939", "A", "MET", "940", "1.328"},
       { "A", "MET", "940", "A", "TYR", "941", "1.328"},
       { "A", "TYR", "941", "A", "ARG", "942", "1.319"},
       { "A", "ARG", "942", "A", "GLN", "943", "1.328"},
       { "A", "GLN", "943", "A", "TYR", "944", "1.323"},
       { "A", "TYR", "944", "A", "LEU", "945", "1.321"},
       { "A", "LEU", "945", "A", "ILE", "946", "1.334"},
       { "A", "ILE", "946", "A", "GLN", "947", "1.335"},
       { "A", "GLN", "947", "A", "SER", "948", "1.334"},
       { "A", "SER", "948", "A", "PHE", "949", "1.327"},
       { "A", "PHE", "949", "A", "ALA", "950", "1.329"},
       { "A", "ALA", "950", "A", "ALA", "951", "1.342"},
       { "A", "ALA", "951", "A", "ALA", "952", "1.333"},
       { "A", "ALA", "952", "A", "SER", "953", "1.337"},
       { "A", "SER", "953", "A", "ALA", "954", "1.335"},
       { "A", "ALA", "954", "A", "ALA", "955", "1.344"},
       { "A", "ALA", "955", "A", "ALA", "956", "1.329"},
       { "A", "ALA", "956", "A", "LYS", "957", "1.324"},
       { "A", "LYS", "957", "A", "GLU", "958", "1.326"},
       { "A", "GLU", "958", "A", "ARG", "959", "1.328"},
       { "A", "ARG", "959", "A", "LEU", "960", "1.330"},
       { "A", "LEU", "960", "A", "PHE", "961", "1.327"},
       { "A", "PHE", "961", "A", "ASN", "962", "1.333"},
       { "A", "ASN", "962", "A", "ASN", "963", "1.321"},
       { "A", "ASN", "963", "A", "LEU", "964", "1.331"},
       { "A", "LEU", "964", "A", "ALA", "965", "1.324"},
       { "A", "ALA", "965", "A", "HIS", "966", "1.335"},
       { "A", "HIS", "966", "A", "LEU", "967", "1.324"},
       { "A", "LEU", "967", "A", "GLY", "968", "1.329"},
       { "A", "GLY", "968", "A", "ALA", "969", "1.332"},
       { "A", "ALA", "969", "A", "ALA", "970", "1.330"},
       { "A", "ALA", "970", "A", "ALA", "971", "1.331"},
       { "A", "ALA", "971", "A", "ALA", "972", "1.328"},
       { "A", "ALA", "972", "A", "VAL", "978", "13.012"},
       { "A", "VAL", "978", "A", "ASN", "979", "1.330"},
       { "A", "ASN", "979", "A", "ALA", "980", "1.328"},
       { "A", "ALA", "980", "A", "ILE", "981", "1.322"},
       { "A", "ILE", "981", "A", "HIS", "982", "1.329"},
       { "A", "HIS", "982", "A", "SER", "983", "1.322"},
       { "A", "SER", "983", "A", "ASN", "984", "1.326"},
       { "A", "ASN", "984", "A", "ILE", "985", "1.323"},
       { "A", "ILE", "985", "A", "GLY", "986", "1.331"},
       { "A", "GLY", "986", "A", "SER", "987", "1.328"},
       { "A", "SER", "987", "A", "VAL", "988", "1.332"},
       { "A", "VAL", "988", "A", "ILE", "989", "1.329"},
       { "A", "ILE", "989", "A", "TYR", "990", "1.333"},
       { "A", "TYR", "990", "A", "LYS", "991", "1.332"},
       { "A", "LYS", "991", "A", "THR", "992", "1.327"},
       { "A", "THR", "992", "A", "TYR", "993", "1.334"},
       { "A", "TYR", "993", "A", "ALA", "994", "1.327"},
       { "A", "ALA", "994", "A", "SER", "995", "1.332"},
       { "A", "SER", "995", "A", "GLN", "996", "1.329"},
       { "A", "GLN", "996", "A", "ALA", "997", "1.331"},
       { "A", "ALA", "997", "A", "LEU", "998", "1.321"},
       { "A", "LEU", "998", "A", "THR", "999", "1.330"},
       { "A", "THR", "999", "A", "ASN", "1000", "1.342"},
       { "A", "ASN", "1000", "A", "ASN", "1001", "1.344"},
       { "A", "ASN", "1001", "A", "ARG", "1002", "1.340"},
       { "A", "ARG", "1002", "A", "LEU", "1003", "1.317"},
       { "A", "LEU", "1003", "A", "GLU", "1004", "1.321"},
       { "A", "GLU", "1004", "A", "GLU", "1005", "1.328"},
       { "A", "GLU", "1005", "A", "LYS", "1006", "1.351"},
       { "A", "LYS", "1006", "A", "ASP", "1007", "1.333"},
       { "A", "ASP", "1007", "A", "ILE", "1008", "1.321"},
       { "A", "ILE", "1008", "A", "GLU", "1009", "1.319"},
       { "A", "GLU", "1009", "A", "PHE", "1010", "1.335"},
       { "A", "PHE", "1010", "A", "LEU", "1011", "1.331"},
       { "A", "LEU", "1011", "A", "ARG", "1012", "1.328"},
       { "A", "ARG", "1012", "A", "ASN", "1013", "1.325"},
       { "A", "ASN", "1013", "A", "ILE", "1014", "1.324"},
       { "A", "ILE", "1014", "A", "GLN", "1015", "1.325"},
       { "A", "GLN", "1015", "A", "ASN", "1016", "1.335"},
       { "A", "ASN", "1016", "A", "MET", "1017", "1.321"},
       { "A", "MET", "1017", "A", "LEU", "1018", "1.329"},
       { "A", "LEU", "1018", "A", "SER", "1019", "1.328"},
       { "A", "SER", "1019", "A", "MET", "1020", "1.340"},
       { "A", "MET", "1020", "A", "ASP", "1021", "1.331"},
       { "A", "ASP", "1021", "A", "GLU", "1022", "1.325"},
       { "A", "GLU", "1022", "A", "ALA", "1023", "1.334"},
       { "A", "ALA", "1023", "A", "THR", "1024", "1.328"},
       { "A", "THR", "1024", "A", "CYS", "1025", "1.326"},
       { "A", "CYS", "1025", "A", "ARG", "1026", "1.330"},
       { "A", "ARG", "1026", "A", "THR", "1027", "1.320"},
       { "A", "THR", "1027", "A", "LEU", "1028", "1.328"},
       { "A", "LEU", "1028", "A", "LEU", "1029", "1.326"},
       { "A", "LEU", "1029", "A", "GLN", "1030", "1.328"},
       { "A", "GLN", "1030", "A", "GLU", "1031", "1.324"},
       { "A", "GLU", "1031", "A", "THR", "1032", "1.330"},
       { "A", "THR", "1032", "A", "LYS", "1033", "1.325"},
       { "A", "LYS", "1033", "A", "GLU", "1034", "1.323"},
       { "A", "GLU", "1034", "A", "ALA", "1035", "1.329"},
       { "A", "ALA", "1035", "A", "ARG", "1036", "1.329"},
       { "A", "ARG", "1036", "A", "ALA", "1037", "1.323"},
       { "A", "ALA", "1037", "A", "GLY", "1038", "1.325"},
       { "A", "GLY", "1038", "A", "PHE", "1039", "1.323"},
       { "A", "PHE", "1039", "A", "LEU", "1040", "1.333"},
       { "A", "LEU", "1040", "A", "PHE", "1041", "1.330"},
       { "A", "PHE", "1041", "A", "ASP", "1042", "1.329"},
       { "A", "ASP", "1042", "A", "LYS", "1043", "1.335"},
       { "A", "LYS", "1043", "A", "ILE", "1044", "1.333"},
       { "A", "ILE", "1044", "A", "PHE", "1045", "1.336"},
       { "A", "PHE", "1045", "A", "MET", "1051", "6.342"},
       { "A", "MET", "1051", "A", "ALA", "1052", "1.329"},
       { "A", "ALA", "1052", "A", "GLU", "1053", "1.336"},
       { "A", "GLU", "1053", "A", "ALA", "1054", "1.332"},
       { "A", "ALA", "1054", "A", "VAL", "1055", "1.327"},
       { "A", "VAL", "1055", "A", "ALA", "1056", "1.327"},
       { "A", "ALA", "1056", "A", "GLU", "1057", "1.332"},
       { "A", "GLU", "1057", "A", "PHE", "1058", "1.330"},
       { "A", "PHE", "1058", "A", "ARG", "1059", "1.327"},
       { "A", "ARG", "1059", "A", "ARG", "1060", "1.319"},
       { "A", "ARG", "1060", "A", "VAL", "1061", "1.323"},
       { "A", "VAL", "1061", "A", "CYS", "1062", "1.326"},
       { "A", "CYS", "1062", "A", "ARG", "1063", "1.315"},
       { "A", "ARG", "1063", "A", "GLU", "1064", "1.327"},
       { "A", "GLU", "1064", "A", "LEU", "1065", "1.331"},
       { "A", "LEU", "1065", "A", "ASP", "1066", "1.336"},
       { "A", "ASP", "1066", "A", "VAL", "1067", "1.331"},
       { "A", "VAL", "1067", "A", "GLU", "1077", "22.896"},
       { "A", "GLU", "1077", "A", "ASP", "1078", "1.330"},
       { "A", "ASP", "1078", "A", "ARG", "1079", "1.328"},
       { "A", "ARG", "1079", "A", "ARG", "1080", "1.340"},
       { "A", "ARG", "1080", "A", "VAL", "1081", "1.334"},
       { "A", "VAL", "1081", "A", "ARG", "1082", "1.324"},
       { "A", "ARG", "1082", "A", "ALA", "1083", "1.320"},
       { "A", "ALA", "1083", "A", "PHE", "1084", "1.330"},
       { "A", "PHE", "1084", "A", "ARG", "1085", "1.323"},
       { "A", "ARG", "1085", "A", "ALA", "1086", "1.320"},
       { "A", "ALA", "1086", "A", "GLU", "1087", "1.320"},
       { "A", "GLU", "1087", "A", "ILE", "1088", "1.330"},
       { "A", "ILE", "1088", "A", "GLU", "1089", "1.332"},
       { "A", "GLU", "1089", "A", "HIS", "1090", "1.325"},
       { "A", "HIS", "1090", "A", "ALA", "1091", "1.331"},
       { "A", "ALA", "1091", "A", "ALA", "1092", "1.334"},
       { "A", "ALA", "1092", "A", "ALA", "1093", "1.327"},
       { "A", "ALA", "1093", "A", "ALA", "1094", "1.333"},
       { "A", "ALA", "1094", "A", "SER", "1103", "10.637"},
       { "A", "SER", "1103", "A", "LEU", "1104", "1.330"},
       { "A", "LEU", "1104", "A", "LEU", "1105", "1.333"},
       { "A", "LEU", "1105", "A", "LYS", "1106", "1.334"},
       { "A", "LYS", "1106", "A", "GLU", "1107", "1.331"},
       { "A", "GLU", "1107", "A", "SER", "1108", "1.332"},
       { "A", "SER", "1108", "A", "GLN", "1109", "1.347"},
       { "A", "GLN", "1109", "A", "GLU", "1110", "1.328"},
       { "A", "GLU", "1110", "A", "GLU", "1111", "1.330"},
       { "A", "GLU", "1111", "A", "LEU", "1112", "1.329"},
       { "A", "LEU", "1112", "A", "GLY", "1113", "1.324"},
       { "A", "GLY", "1113", "A", "ILE", "1114", "1.341"},
       { "A", "ILE", "1114", "A", "SER", "1115", "1.325"},
       { "A", "SER", "1115", "A", "ALA", "1116", "1.333"},
       { "A", "ALA", "1116", "A", "GLU", "1117", "1.327"},
       { "A", "GLU", "1117", "A", "LYS", "1118", "1.329"},
       { "A", "LYS", "1118", "A", "ALA", "1119", "1.329"},
       { "A", "ALA", "1119", "A", "ARG", "1120", "1.330"},
       { "A", "ARG", "1120", "A", "GLN", "1121", "1.332"},
       { "A", "GLN", "1121", "A", "VAL", "1122", "1.328"},
       { "A", "VAL", "1122", "A", "LEU", "1123", "1.331"},
       { "A", "LEU", "1123", "A", "LEU", "1124", "1.338"},
       { "A", "LEU", "1124", "A", "ASP", "1125", "1.322"},
       { "A", "ASP", "1125", "A", "CYS", "1126", "1.339"},
       { "A", "CYS", "1126", "A", "ILE", "1127", "1.324"},
       { "A", "ILE", "1127", "A", "GLN", "1128", "1.328"},
       { "A", "GLN", "1128", "A", "ASP", "1129", "1.334"},
       { "A", "ASP", "1129", "A", "ARG", "1130", "1.326"},
       { "A", "ARG", "1130", "A", "CYS", "1131", "1.337"},
       { "A", "CYS", "1131", "A", "GLU", "1132", "1.331"},
       { "A", "GLU", "1132", "A", "ALA", "1133", "1.337"},
       { "A", "ALA", "1133", "A", "LEU", "1134", "1.335"},
       { "A", "LEU", "1134", "A", "ILE", "1135", "1.328"},
       { "A", "ILE", "1135", "A", "VAL", "1136", "1.336"},
       { "A", "VAL", "1136", "A", "GLN", "1137", "1.328"},
       { "A", "GLN", "1137", "A", "ALA", "1138", "1.331"},
       { "A", "ALA", "1138", "A", "ALA", "1139", "1.330"},
       { "A", "ALA", "1139", "A", "ALA", "1140", "1.335"},
       { "A", "ALA", "1140", "A", "SER", "1141", "1.335"},
       { "A", "SER", "1141", "A", "LEU", "1142", "1.318"},
       { "A", "LEU", "1142", "A", "ALA", "1143", "1.333"},
       { "A", "ALA", "1143", "A", "ALA", "1144", "1.343"},
       { "A", "ALA", "1144", "A", "ALA", "1145", "1.334"},
       { "A", "ALA", "1145", "A", "ALA", "1146", "1.338"},
       { "A", "ALA", "1146", "A", "GLN", "1147", "1.333"},
       { "A", "GLN", "1147", "A", "GLU", "1148", "1.329"},
       { "A", "GLU", "1148", "A", "GLY", "1149", "1.332"},
       { "A", "GLY", "1149", "A", "ALA", "1150", "1.330"},
       { "A", "ALA", "1150", "A", "ALA", "1151", "1.329"},
       { "A", "ALA", "1151", "A", "ARG", "1152", "1.327"},
       { "A", "ARG", "1152", "A", "ASP", "1153", "1.331"},
       { "A", "ASP", "1153", "A", "LEU", "1154", "1.333"},
       { "A", "LEU", "1154", "A", "SER", "1155", "1.335"},
       { "A", "SER", "1155", "A", "ARG", "1156", "1.334"},
       { "A", "ARG", "1156", "A", "ALA", "1157", "1.331"},
       { "A", "ALA", "1157", "A", "LEU", "1158", "1.329"},
       { "A", "LEU", "1158", "A", "ALA", "1159", "1.332"},
       { "A", "ALA", "1159", "A", "GLN", "1179", "25.260"},
       { "A", "GLN", "1179", "A", "GLU", "1180", "1.335"},
       { "A", "GLU", "1180", "A", "LEU", "1181", "1.328"},
       { "A", "LEU", "1181", "A", "TYR", "1182", "1.328"},
       { "A", "TYR", "1182", "A", "LEU", "1183", "1.332"},
       { "A", "LEU", "1183", "A", "VAL", "1184", "1.334"},
       { "A", "VAL", "1184", "A", "TYR", "1185", "1.332"},
       { "A", "TYR", "1185", "A", "GLN", "1186", "1.324"},
       { "A", "GLN", "1186", "A", "ALA", "1187", "1.334"},
       { "A", "ALA", "1187", "A", "TYR", "1188", "1.325"},
       { "A", "TYR", "1188", "A", "ALA", "1189", "1.329"},
       { "A", "ALA", "1189", "A", "LEU", "1190", "1.326"},
       { "A", "LEU", "1190", "A", "GLY", "1191", "1.333"},
       { "A", "GLY", "1191", "A", "THR", "1192", "1.325"},
       { "A", "THR", "1192", "A", "ALA", "1193", "1.328"},
       { "A", "ALA", "1193", "A", "ARG", "1194", "1.329"},
       { "A", "ARG", "1194", "A", "SER", "1195", "1.337"},
       { "A", "SER", "1195", "A", "ASN", "1196", "1.333"},
       { "A", "ASN", "1196", "A", "ALA", "1197", "1.335"},
       { "A", "ALA", "1197", "A", "GLU", "1198", "1.328"},
       { "A", "GLU", "1198", "A", "ASN", "1199", "1.335"},
       { "A", "ASN", "1199", "A", "ASP", "1200", "1.330"},
       { "A", "ASP", "1200", "A", "GLN", "1201", "1.332"},
       { "A", "GLN", "1201", "A", "VAL", "1202", "1.330"},
       { "A", "VAL", "1202", "A", "LYS", "1203", "1.327"},
       { "A", "LYS", "1203", "A", "GLU", "1204", "1.333"},
       { "A", "GLU", "1204", "A", "ASP", "1205", "1.325"},
       { "A", "ASP", "1205", "A", "LEU", "1206", "1.329"},
       { "A", "LEU", "1206", "A", "ALA", "1207", "1.332"},
       { "A", "ALA", "1207", "A", "LEU", "1208", "1.321"},
       { "A", "LEU", "1208", "A", "LEU", "1209", "1.324"},
       { "A", "LEU", "1209", "A", "ARG", "1210", "1.330"},
       { "A", "ARG", "1210", "A", "GLU", "1211", "1.328"},
       { "A", "GLU", "1211", "A", "MET", "1212", "1.331"},
       { "A", "MET", "1212", "A", "LEU", "1213", "1.321"},
       { "A", "LEU", "1213", "A", "GLY", "1214", "1.330"},
       { "A", "GLY", "1214", "A", "ILE", "1215", "1.328"},
       { "A", "ILE", "1215", "A", "GLN", "1216", "1.333"},
       { "A", "GLN", "1216", "A", "ALA", "1217", "1.335"},
       { "A", "ALA", "1217", "A", "ALA", "1218", "1.334"}
};

using namespace RCSB;

int main(int argc, char *argv[])
{
  std::vector<std::string> sRef;
  std::vector<std::string> sTest;

  sRef.clear();
  for (int i = 0; i < NUM_REF_SEQ; ++i) {
       sRef.push_back(_ref_seq[i]);
  }

  sTest.clear();
  for (int i = 0; i < NUM_COORD_SEQ; ++i) {
       sTest.push_back(_coord_seq[i]);
  }

  std::vector<int> linkage;
  linkage.clear();
  for (int i = 0; i < NUM_LINK; ++i) {
       if (atof(_linkage_dist[i][6]) < 1.75)
            linkage.push_back(1);
       else linkage.push_back(0);
  }
  linkage.push_back(0);

  std::vector<std::pair<std::string, std::string> > align;

  PairwiseAlign pA=PairwiseAlign();
  pA.setReferenceSequence(sRef,"REFA");
  pA.addTestSequence(sTest,"SEQA");
  pA.doAlign();
  pA.wrAlignmentFull(std::cout);

  PairwiseAlign pB=PairwiseAlign();
  pB.setReferenceSequence(sRef,"REFA");
  pB.addTestSequenceWithLink(sTest,"SEQB", linkage);
  pB.doAlign();
  pB.wrAlignmentFull(std::cout);

  return 0;
}

