"""Functions for scoring predicted ARC grids against ground truth output grids"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/06_score.ipynb.

# %% auto 0
__all__ = ['score']

# %% ../nbs/06_score.ipynb 3
import numpy as np
from .task import ArcGrid, ArcPair

# %% ../nbs/06_score.ipynb 10
def score(
    truth: ArcGrid,         # True ARC grid
    pred: ArcGrid | None    # Predicted ARC grid
) -> float:
    "Score a predicted grid against the true grid"
    if pred is None: return 0.0
    if pred == truth: return 1.0
    
    # Calculate shape penalty
    rows_ratio = min(truth.shape[0], pred.shape[0]) / max(truth.shape[0], pred.shape[0])
    cols_ratio = min(truth.shape[1], pred.shape[1]) / max(truth.shape[1], pred.shape[1])
    shape_penalty = rows_ratio * cols_ratio

    # Get overlapping region dimensions
    overlap_rows = min(truth.shape[0], pred.shape[0])
    overlap_cols = min(truth.shape[1], pred.shape[1])

    # Calculate color accuracy in overlapping region
    true_overlap = truth.data[:overlap_rows, :overlap_cols]
    pred_overlap = pred.data[:overlap_rows, :overlap_cols]
    color_accuracy = np.mean(true_overlap == pred_overlap)

    return float(shape_penalty * color_accuracy)
