"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const _1 = require("./");
class IntegTesting {
    constructor() {
        const app = new aws_cdk_lib_1.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new aws_cdk_lib_1.Stack(app, 'my-stack-dev', { env });
        const kaniko = new _1.Kaniko(stack, 'KanikoDemo', {
            context: 'git://github.com/pahud/vscode.git',
            contextSubPath: './.devcontainer',
            fargateSpot: true,
        });
        // build it once
        kaniko.buildImage('once');
        // schedule the build every day 0:00AM
        kaniko.buildImage('everyday', aws_cdk_lib_1.aws_events.Schedule.cron({
            minute: '0',
            hour: '0',
        }));
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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