"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Kaniko = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk_fargate_run_task_1 = require("cdk-fargate-run-task");
const constructs_1 = require("constructs");
/**
 * @stability stable
 */
class Kaniko extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        this.fargateSpot = (_b = props.fargateSpot) !== null && _b !== void 0 ? _b : false;
        this.vpc = getOrCreateVpc(this);
        this.cluster = new aws_cdk_lib_1.aws_ecs.Cluster(this, 'Cluster', {
            vpc: this.vpc,
            enableFargateCapacityProviders: true,
        });
        this.destinationRepository = (_c = props.destinationRepository) !== null && _c !== void 0 ? _c : this._createDestinationRepository();
        const executorImage = aws_cdk_lib_1.aws_ecs.ContainerImage.fromAsset(path.join(__dirname, '../docker.d'));
        this.task = new aws_cdk_lib_1.aws_ecs.FargateTaskDefinition(this, 'BuildImageTask', {
            cpu: 512,
            memoryLimitMiB: 1024,
        });
        this.task.addContainer('kaniko', {
            image: executorImage,
            command: [
                '--context', props.context,
                '--context-sub-path',
                (_d = props.contextSubPath) !== null && _d !== void 0 ? _d : './',
                '--dockerfile',
                (_e = props.dockerfile) !== null && _e !== void 0 ? _e : 'Dockerfile',
                '--destination', this.destinationRepository.repositoryUri,
                '--force',
            ],
            logging: new aws_cdk_lib_1.aws_ecs.AwsLogDriver({ streamPrefix: 'kaniko' }),
        });
        this.destinationRepository.grantPullPush(this.task.taskRole);
        new cdk.CfnOutput(this, 'Repository', {
            value: this.destinationRepository.repositoryName,
        });
    }
    _createDestinationRepository() {
        return new aws_cdk_lib_1.aws_ecr.Repository(this, 'Repo', {
            removalPolicy: cdk.RemovalPolicy.DESTROY,
        });
    }
    /**
     * Build the image with kaniko.
     *
     * @param schedule The schedule to repeatedly build the image.
     * @stability stable
     */
    buildImage(id, schedule) {
        // run it just once
        const newRunTask = new cdk_fargate_run_task_1.RunTask(this, `BuildImage${id}`, {
            task: this.task,
            cluster: this.cluster,
            schedule,
            capacityProviderStrategy: this.fargateSpot ? [
                {
                    capacityProvider: 'FARGATE_SPOT',
                    weight: 1,
                },
            ] : undefined,
        });
        // if vpc is a new resource in this stack, run task job will add dependency on vpc created.
        if (this.node.tryFindChild('Vpc').node.children.find(c => c.cfnResourceType === 'AWS::EC2::VPC')) {
            newRunTask.node.addDependency(this.vpc);
        }
        ;
    }
}
exports.Kaniko = Kaniko;
_a = JSII_RTTI_SYMBOL_1;
Kaniko[_a] = { fqn: "cdk-kaniko.Kaniko", version: "2.0.2" };
function getOrCreateVpc(scope) {
    // use an existing vpc or create a new one
    return scope.node.tryGetContext('use_default_vpc') === '1'
        || process.env.CDK_USE_DEFAULT_VPC === '1' ? aws_cdk_lib_1.aws_ec2.Vpc.fromLookup(scope, 'Vpc', { isDefault: true }) :
        scope.node.tryGetContext('use_vpc_id') ?
            aws_cdk_lib_1.aws_ec2.Vpc.fromLookup(scope, 'Vpc', { vpcId: scope.node.tryGetContext('use_vpc_id') }) :
            new aws_cdk_lib_1.aws_ec2.Vpc(scope, 'Vpc', { maxAzs: 3, natGateways: 1 });
}
//# sourceMappingURL=data:application/json;base64,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