import pathlib
from functools import lru_cache

from abuse_whois import settings
from abuse_whois.utils import glob_rules, load_yaml

from .rule import WhoisRule

DEFAULT_RULE_DIRECTORY: pathlib.Path = pathlib.Path(__file__).parent / "./rules"


@lru_cache(maxsize=1)
def load_rules() -> list[WhoisRule]:
    paths = glob_rules(
        DEFAULT_RULE_DIRECTORY,
        additional_directories=settings.ADDITIONAL_WHOIS_RULE_DIRECTORIES,
    )
    return [WhoisRule.parse_obj(load_yaml(path)) for path in paths]
