# Auto generated from crdch_model.yaml by pythongen.py version: 0.9.0
# Generation date: 2021-12-16T13:08:03
# Schema: CRDC-H
#
# id: https://example.org/crdch
# description:
# license: https://creativecommons.org/publicdomain/zero/1.0/

import dataclasses
import sys
import re
from jsonasobj2 import JsonObj, as_dict
from typing import Optional, List, Union, Dict, ClassVar, Any
from dataclasses import dataclass
from linkml_runtime.linkml_model.meta import EnumDefinition, PermissibleValue, PvFormulaOptions

from linkml_runtime.utils.slot import Slot
from linkml_runtime.utils.metamodelcore import empty_list, empty_dict, bnode
from linkml_runtime.utils.yamlutils import YAMLRoot, extended_str, extended_float, extended_int
from linkml_runtime.utils.dataclass_extensions_376 import dataclasses_init_fn_with_kwargs
from linkml_runtime.utils.formatutils import camelcase, underscore, sfx
from linkml_runtime.utils.enumerations import EnumDefinitionImpl
from rdflib import Namespace, URIRef
from linkml_runtime.utils.curienamespace import CurieNamespace
from linkml_runtime.linkml_model.types import Boolean, Datetime, Decimal, Integer, String, Uriorcurie
from linkml_runtime.utils.metamodelcore import Bool, Decimal, URIorCURIE, XSDDateTime

metamodel_version = "1.7.0"

# Overwrite dataclasses _init_fn to add **kwargs in __init__
dataclasses._init_fn = dataclasses_init_fn_with_kwargs

# Namespaces
GDC = CurieNamespace('GDC', 'http://example.org/gdc/')
HTAN = CurieNamespace('HTAN', 'http://example.org/htan/')
ICDC = CurieNamespace('ICDC', 'http://example.org/icdc/')
NCIT = CurieNamespace('NCIT', 'http://purl.obolibrary.org/obo/NCIT_')
PDC = CurieNamespace('PDC', 'http://example.org/pdc/')
CRDCH = CurieNamespace('crdch', 'https://example.org/crdch/')
LINKML = CurieNamespace('linkml', 'https://w3id.org/linkml/')
XSD = CurieNamespace('xsd', 'http://www.w3.org/2001/XMLSchema#')
DEFAULT_ = CRDCH


# Types
class CrdchString(String):
    """ A sequence of Unicode characters.  There are no limits on the number of characters in the string. """
    type_class_uri = XSD.string
    type_class_curie = "xsd:string"
    type_name = "crdch_string"
    type_model_uri = CRDCH.CrdchString


class CrdchInteger(Integer):
    """ An integer number.  This data type is based on the decimal type, but the fractional component is not allowed.  There are no restrictions on the size of the integer. """
    type_class_uri = XSD.integer
    type_class_curie = "xsd:integer"
    type_name = "crdch_integer"
    type_model_uri = CRDCH.CrdchInteger


class CrdchDecimal(Decimal):
    """ A rational number that has a decimal representation.  This data type does not restrict the size or precision of the number. """
    type_class_uri = XSD.decimal
    type_class_curie = "xsd:decimal"
    type_name = "crdch_decimal"
    type_model_uri = CRDCH.CrdchDecimal


class CrdchBoolean(Boolean):
    """ Value representing either “true” or “false”.  Permissible values (case-sensitive) = “true”, “false”, “1”, “0”. """
    type_class_uri = XSD.boolean
    type_class_curie = "xsd:boolean"
    type_name = "crdch_boolean"
    type_model_uri = CRDCH.CrdchBoolean


class CrdchDateTime(Datetime):
    """ A date and time string specified using a specialized concatenation of the date and time data types, in the general format YYYY-MM-DDThh:mm:ss+zz:zz. """
    type_class_uri = XSD.dateTime
    type_class_curie = "xsd:dateTime"
    type_name = "crdch_dateTime"
    type_model_uri = CRDCH.CrdchDateTime


class CrdchCurie(Uriorcurie):
    """ A compact URI (CURIE), which is a bipartite identifier of the form prefix:reference, in which the prefix is a convenient abbreviation of a URI.  It is expressed in the format “prefix:reference”. When a mapping of prefix to base URI is provided (external to this data type), a CURIE may be mapped to a URI. """
    type_class_uri = XSD.anyURI
    type_class_curie = "xsd:anyURI"
    type_name = "crdch_curie"
    type_model_uri = CRDCH.CrdchCurie


class CrdchCode(String):
    type_class_uri = XSD.string
    type_class_curie = "xsd:string"
    type_name = "crdch_code"
    type_model_uri = CRDCH.CrdchCode


# Class references



class Entity(YAMLRoot):
    """
    Any resource that has its own identifier
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Entity
    class_class_curie: ClassVar[str] = "crdch:Entity"
    class_name: ClassVar[str] = "Entity"
    class_model_uri: ClassVar[URIRef] = CRDCH.Entity


@dataclass
class AlcoholExposureObservation(Entity):
    """
    A structured object that describes a single data item about an individual's exposure to alcohol, as generated
    through a point-in-time observation, measurement, or interpretation.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.AlcoholExposureObservation
    class_class_curie: ClassVar[str] = "crdch:AlcoholExposureObservation"
    class_name: ClassVar[str] = "AlcoholExposureObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.AlcoholExposureObservation

    observation_type: Union[dict, "CodeableConcept"] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, "CodeableConcept"]] = None
    method_type: Optional[Union[dict, "CodeableConcept"]] = None
    focus: Optional[Union[dict, "Entity"]] = None
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None
    value_integer: Optional[Union[int, CrdchInteger]] = None
    value_codeable_concept: Optional[Union[dict, "CodeableConcept"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.value_integer is not None and not isinstance(self.value_integer, CrdchInteger):
            self.value_integer = CrdchInteger(self.value_integer)

        if self.value_codeable_concept is not None and not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        super().__post_init__(**kwargs)


@dataclass
class BodySite(Entity):
    """
    A site in the body of an organism, typically described in terms of an anatomical concept and optional qualifiers
    (e.g. left/right, upper/lower). But body sites as defined here may include non-canonical sites, such as an
    implanted medical device.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.BodySite
    class_class_curie: ClassVar[str] = "crdch:BodySite"
    class_name: ClassVar[str] = "BodySite"
    class_model_uri: ClassVar[URIRef] = CRDCH.BodySite

    site: Union[dict, "CodeableConcept"] = None
    qualifier: Optional[Union[Union[dict, "CodeableConcept"], List[Union[dict, "CodeableConcept"]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.site):
            self.MissingRequiredField("site")
        if not isinstance(self.site, CodeableConcept):
            self.site = CodeableConcept(**as_dict(self.site))

        if not isinstance(self.qualifier, list):
            self.qualifier = [self.qualifier] if self.qualifier is not None else []
        self.qualifier = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.qualifier]

        super().__post_init__(**kwargs)


@dataclass
class BiologicProduct(Entity):
    """
    A living organism, or a metabolically active biological system such as a cell culture, tissue culture, or organoid
    that is maintained or propagated in vitro.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.BiologicProduct
    class_class_curie: ClassVar[str] = "crdch:BiologicProduct"
    class_name: ClassVar[str] = "BiologicProduct"
    class_model_uri: ClassVar[URIRef] = CRDCH.BiologicProduct

    id: Optional[Union[str, CrdchString]] = None
    identifier: Optional[Union[Union[dict, "Identifier"], List[Union[dict, "Identifier"]]]] = empty_list()
    description: Optional[Union[str, CrdchString]] = None
    product_type: Optional[Union[dict, "CodeableConcept"]] = None
    passage_number: Optional[Union[Union[int, CrdchInteger], List[Union[int, CrdchInteger]]]] = empty_list()
    growth_rate: Optional[Union[Union[str, CrdchString], List[Union[str, CrdchString]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.description is not None and not isinstance(self.description, CrdchString):
            self.description = CrdchString(self.description)

        if self.product_type is not None and not isinstance(self.product_type, CodeableConcept):
            self.product_type = CodeableConcept(**as_dict(self.product_type))

        if not isinstance(self.passage_number, list):
            self.passage_number = [self.passage_number] if self.passage_number is not None else []
        self.passage_number = [v if isinstance(v, CrdchInteger) else CrdchInteger(v) for v in self.passage_number]

        if not isinstance(self.growth_rate, list):
            self.growth_rate = [self.growth_rate] if self.growth_rate is not None else []
        self.growth_rate = [v if isinstance(v, CrdchString) else CrdchString(v) for v in self.growth_rate]

        super().__post_init__(**kwargs)


@dataclass
class CancerGradeObservation(Entity):
    """
    A data structure with key (observation_type) and value (value_codeable_concept) attributes that represents a
    single cancer grade observation
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.CancerGradeObservation
    class_class_curie: ClassVar[str] = "crdch:CancerGradeObservation"
    class_name: ClassVar[str] = "CancerGradeObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.CancerGradeObservation

    observation_type: Union[dict, "CodeableConcept"] = None
    value_codeable_concept: Union[dict, "CodeableConcept"] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, "CodeableConcept"]] = None
    method_type: Optional[Union[dict, "CodeableConcept"]] = None
    focus: Optional[Union[dict, "Entity"]] = None
    subject: Optional[Union[dict, "Subject"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_codeable_concept):
            self.MissingRequiredField("value_codeable_concept")
        if not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        super().__post_init__(**kwargs)


@dataclass
class CancerGradeObservationSet(Entity):
    """
    A structured object to hold related data items about the grade of cancer (e.g. overall, primary gleason, secondary
    gleason, etc.).
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.CancerGradeObservationSet
    class_class_curie: ClassVar[str] = "crdch:CancerGradeObservationSet"
    class_name: ClassVar[str] = "CancerGradeObservationSet"
    class_model_uri: ClassVar[URIRef] = CRDCH.CancerGradeObservationSet

    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, "CodeableConcept"]] = None
    focus: Optional[Union[Union[dict, "Entity"], List[Union[dict, "Entity"]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    method_type: Optional[Union[Union[dict, "CodeableConcept"], List[Union[dict, "CodeableConcept"]]]] = empty_list()
    performed_by: Optional[Union[dict, "Organization"]] = None
    observations: Optional[Union[Union[dict, CancerGradeObservation], List[Union[dict, CancerGradeObservation]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        self._normalize_inlined_as_list(slot_name="observations", slot_type=CancerGradeObservation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class CancerStageObservation(Entity):
    """
    A data structure with key (observation_type) and value (value_codeable_concept) attributes that represents a
    single cancer staging observation, such as the Clinical Metastasis (M) component of a clinical TNM staging.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.CancerStageObservation
    class_class_curie: ClassVar[str] = "crdch:CancerStageObservation"
    class_name: ClassVar[str] = "CancerStageObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.CancerStageObservation

    observation_type: Union[dict, "CodeableConcept"] = None
    value_codeable_concept: Union[dict, "CodeableConcept"] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, "CodeableConcept"]] = None
    method_type: Optional[Union[dict, "CodeableConcept"]] = None
    focus: Optional[Union[dict, "Entity"]] = None
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_codeable_concept):
            self.MissingRequiredField("value_codeable_concept")
        if not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class CancerStageObservationSet(Entity):
    """
    A structured object to hold related data items about the staging of cancer (e.g. overall, T, N, and M components
    of a Cancer Staging observation).
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.CancerStageObservationSet
    class_class_curie: ClassVar[str] = "crdch:CancerStageObservationSet"
    class_name: ClassVar[str] = "CancerStageObservationSet"
    class_model_uri: ClassVar[URIRef] = CRDCH.CancerStageObservationSet

    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, "CodeableConcept"]] = None
    focus: Optional[Union[Union[dict, "Entity"], List[Union[dict, "Entity"]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    method_type: Optional[Union[Union[dict, "CodeableConcept"], List[Union[dict, "CodeableConcept"]]]] = empty_list()
    performed_by: Optional[Union[dict, "Organization"]] = None
    observations: Optional[Union[Union[dict, CancerStageObservation], List[Union[dict, CancerStageObservation]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        self._normalize_inlined_as_list(slot_name="observations", slot_type=CancerStageObservation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class CodeableConcept(Entity):
    """
    A representation of a concept that may be defined by or mapped to one or more codes in code systems
    (terminologies, ontologies, dictionaries, code sets, etc) - but may also be defined by the provision of text.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.CodeableConcept
    class_class_curie: ClassVar[str] = "crdch:CodeableConcept"
    class_name: ClassVar[str] = "CodeableConcept"
    class_model_uri: ClassVar[URIRef] = CRDCH.CodeableConcept

    coding: Optional[Union[Union[dict, "Coding"], List[Union[dict, "Coding"]]]] = empty_list()
    text: Optional[Union[str, CrdchString]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        self._normalize_inlined_as_list(slot_name="coding", slot_type=Coding, key_name="code", keyed=False)

        if self.text is not None and not isinstance(self.text, CrdchString):
            self.text = CrdchString(self.text)

        super().__post_init__(**kwargs)


@dataclass
class Coding(Entity):
    """
    A structured representation of a coded/enumerated data value, that includes additional metadata about the code and
    code system.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Coding
    class_class_curie: ClassVar[str] = "crdch:Coding"
    class_name: ClassVar[str] = "Coding"
    class_model_uri: ClassVar[URIRef] = CRDCH.Coding

    code: Union[str, CrdchString] = None
    system: Union[str, CrdchString] = None
    label: Optional[Union[str, CrdchString]] = None
    system_version: Optional[Union[str, CrdchString]] = None
    value_set: Optional[Union[str, CrdchString]] = None
    value_set_version: Optional[Union[str, CrdchString]] = None
    tag: Optional[Union[Union[str, CrdchString], List[Union[str, CrdchString]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.code):
            self.MissingRequiredField("code")
        if not isinstance(self.code, CrdchString):
            self.code = CrdchString(self.code)

        if self._is_empty(self.system):
            self.MissingRequiredField("system")
        if not isinstance(self.system, CrdchString):
            self.system = CrdchString(self.system)

        if self.label is not None and not isinstance(self.label, CrdchString):
            self.label = CrdchString(self.label)

        if self.system_version is not None and not isinstance(self.system_version, CrdchString):
            self.system_version = CrdchString(self.system_version)

        if self.value_set is not None and not isinstance(self.value_set, CrdchString):
            self.value_set = CrdchString(self.value_set)

        if self.value_set_version is not None and not isinstance(self.value_set_version, CrdchString):
            self.value_set_version = CrdchString(self.value_set_version)

        if not isinstance(self.tag, list):
            self.tag = [self.tag] if self.tag is not None else []
        self.tag = [v if isinstance(v, CrdchString) else CrdchString(v) for v in self.tag]

        super().__post_init__(**kwargs)


@dataclass
class Diagnosis(Entity):
    """
    A collection of characteristics that describe an abnormal condition of the body as assessed at a point in time.
    May be used to capture information about neoplastic and non-neoplastic conditions.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Diagnosis
    class_class_curie: ClassVar[str] = "crdch:Diagnosis"
    class_name: ClassVar[str] = "Diagnosis"
    class_model_uri: ClassVar[URIRef] = CRDCH.Diagnosis

    id: Optional[Union[str, CrdchString]] = None
    identifier: Optional[Union[Union[dict, "Identifier"], List[Union[dict, "Identifier"]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    age_at_diagnosis: Optional[Union[dict, "Quantity"]] = None
    diagnosis_date: Optional[Union[dict, "TimePoint"]] = None
    condition: Optional[Union[dict, CodeableConcept]] = None
    primary_site: Optional[Union[Union[dict, BodySite], List[Union[dict, BodySite]]]] = empty_list()
    metastatic_site: Optional[Union[Union[dict, BodySite], List[Union[dict, BodySite]]]] = empty_list()
    stage: Optional[Union[Union[dict, CancerStageObservationSet], List[Union[dict, CancerStageObservationSet]]]] = empty_list()
    grade: Optional[Union[Union[dict, CancerGradeObservationSet], List[Union[dict, CancerGradeObservationSet]]]] = empty_list()
    morphology: Optional[Union[dict, CodeableConcept]] = None
    disease_status: Optional[Union[dict, CodeableConcept]] = None
    prior_diagnosis: Optional[Union[dict, "Diagnosis"]] = None
    method_of_diagnosis: Optional[Union[dict, CodeableConcept]] = None
    related_specimen: Optional[Union[Union[dict, "Specimen"], List[Union[dict, "Specimen"]]]] = empty_list()
    primary_tumor_dimensional_measures: Optional[Union[dict, "DimensionalObservationSet"]] = None
    supporting_observation: Optional[Union[Union[dict, "Observation"], List[Union[dict, "Observation"]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.age_at_diagnosis is not None and not isinstance(self.age_at_diagnosis, Quantity):
            self.age_at_diagnosis = Quantity(**as_dict(self.age_at_diagnosis))

        if self.diagnosis_date is not None and not isinstance(self.diagnosis_date, TimePoint):
            self.diagnosis_date = TimePoint(**as_dict(self.diagnosis_date))

        if self.condition is not None and not isinstance(self.condition, CodeableConcept):
            self.condition = CodeableConcept(**as_dict(self.condition))

        self._normalize_inlined_as_list(slot_name="primary_site", slot_type=BodySite, key_name="site", keyed=False)

        self._normalize_inlined_as_list(slot_name="metastatic_site", slot_type=BodySite, key_name="site", keyed=False)

        if not isinstance(self.stage, list):
            self.stage = [self.stage] if self.stage is not None else []
        self.stage = [v if isinstance(v, CancerStageObservationSet) else CancerStageObservationSet(**as_dict(v)) for v in self.stage]

        if not isinstance(self.grade, list):
            self.grade = [self.grade] if self.grade is not None else []
        self.grade = [v if isinstance(v, CancerGradeObservationSet) else CancerGradeObservationSet(**as_dict(v)) for v in self.grade]

        if self.morphology is not None and not isinstance(self.morphology, CodeableConcept):
            self.morphology = CodeableConcept(**as_dict(self.morphology))

        if self.disease_status is not None and not isinstance(self.disease_status, CodeableConcept):
            self.disease_status = CodeableConcept(**as_dict(self.disease_status))

        if self.prior_diagnosis is not None and not isinstance(self.prior_diagnosis, Diagnosis):
            self.prior_diagnosis = Diagnosis(**as_dict(self.prior_diagnosis))

        if self.method_of_diagnosis is not None and not isinstance(self.method_of_diagnosis, CodeableConcept):
            self.method_of_diagnosis = CodeableConcept(**as_dict(self.method_of_diagnosis))

        if not isinstance(self.related_specimen, list):
            self.related_specimen = [self.related_specimen] if self.related_specimen is not None else []
        self.related_specimen = [v if isinstance(v, Specimen) else Specimen(**as_dict(v)) for v in self.related_specimen]

        if self.primary_tumor_dimensional_measures is not None and not isinstance(self.primary_tumor_dimensional_measures, DimensionalObservationSet):
            self.primary_tumor_dimensional_measures = DimensionalObservationSet(**as_dict(self.primary_tumor_dimensional_measures))

        self._normalize_inlined_as_list(slot_name="supporting_observation", slot_type=Observation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class DimensionalObservation(Entity):
    """
    A structured object that describes a single data item about the physical dimensions of an entity (e.g. length
    width, area), as generated through a point-in-time observation or measurement.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.DimensionalObservation
    class_class_curie: ClassVar[str] = "crdch:DimensionalObservation"
    class_name: ClassVar[str] = "DimensionalObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.DimensionalObservation

    observation_type: Union[dict, CodeableConcept] = None
    value_quantity: Union[dict, "Quantity"] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    focus: Optional[Union[Union[dict, "Entity"], List[Union[dict, "Entity"]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_quantity):
            self.MissingRequiredField("value_quantity")
        if not isinstance(self.value_quantity, Quantity):
            self.value_quantity = Quantity(**as_dict(self.value_quantity))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class DimensionalObservationSet(Entity):
    """
    A set of one or more discrete observations about the physical dimensions of an object (e.g. length, width, area).
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.DimensionalObservationSet
    class_class_curie: ClassVar[str] = "crdch:DimensionalObservationSet"
    class_name: ClassVar[str] = "DimensionalObservationSet"
    class_model_uri: ClassVar[URIRef] = CRDCH.DimensionalObservationSet

    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    focus: Optional[Union[Union[dict, "Entity"], List[Union[dict, "Entity"]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    performed_by: Optional[Union[dict, "Organization"]] = None
    observations: Optional[Union[Union[dict, DimensionalObservation], List[Union[dict, DimensionalObservation]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        self._normalize_inlined_as_list(slot_name="observations", slot_type=DimensionalObservation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class Document(Entity):
    """
    A collection of information intented to be understood together as a whole, and codified in human-readable form.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Document
    class_class_curie: ClassVar[str] = "crdch:Document"
    class_name: ClassVar[str] = "Document"
    class_model_uri: ClassVar[URIRef] = CRDCH.Document

    id: Optional[Union[str, CrdchString]] = None
    identifier: Optional[Union[Union[dict, "Identifier"], List[Union[dict, "Identifier"]]]] = empty_list()
    document_type: Optional[Union[dict, CodeableConcept]] = None
    description: Optional[Union[str, CrdchString]] = None
    focus: Optional[Union[dict, "Entity"]] = None
    url: Optional[Union[Union[str, CrdchString], List[Union[str, CrdchString]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.document_type is not None and not isinstance(self.document_type, CodeableConcept):
            self.document_type = CodeableConcept(**as_dict(self.document_type))

        if self.description is not None and not isinstance(self.description, CrdchString):
            self.description = CrdchString(self.description)

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if not isinstance(self.url, list):
            self.url = [self.url] if self.url is not None else []
        self.url = [v if isinstance(v, CrdchString) else CrdchString(v) for v in self.url]

        super().__post_init__(**kwargs)


@dataclass
class EnvironmentalExposureObservation(Entity):
    """
    A structured object that describes a single data item about an individual's exposure to an environmental factor,
    as generated through a point-in-time observation, measurement, or interpretation.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.EnvironmentalExposureObservation
    class_class_curie: ClassVar[str] = "crdch:EnvironmentalExposureObservation"
    class_name: ClassVar[str] = "EnvironmentalExposureObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.EnvironmentalExposureObservation

    observation_type: Union[dict, CodeableConcept] = None
    value_codeable_concept: Union[dict, CodeableConcept] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[dict, CodeableConcept]] = None
    focus: Optional[Union[dict, Entity]] = None
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_codeable_concept):
            self.MissingRequiredField("value_codeable_concept")
        if not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class ExecutionConditionObservation(Entity):
    """
    A structured object that describes how long certain parts on an activity took to complete, as determined through a
    point-in-time observation or measurement.

    Information describing the environmental conditions in which an activity, or a specific part of an activity, was
    performed.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.ExecutionConditionObservation
    class_class_curie: ClassVar[str] = "crdch:ExecutionConditionObservation"
    class_name: ClassVar[str] = "ExecutionConditionObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.ExecutionConditionObservation

    observation_type: Union[dict, CodeableConcept] = None
    value_codeable_concept: Union[dict, CodeableConcept] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[dict, CodeableConcept]] = None
    focus: Optional[Union[dict, Entity]] = None
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_codeable_concept):
            self.MissingRequiredField("value_codeable_concept")
        if not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class ExecutionTimeObservation(Entity):
    """
    A structured object that describes how long certain parts on an activity took to complete, as determined through a
    point-in-time observation or measurement.

    Information describing the environmental conditions in which an activity, or a specific part of an activity, was
    performed.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.ExecutionTimeObservation
    class_class_curie: ClassVar[str] = "crdch:ExecutionTimeObservation"
    class_name: ClassVar[str] = "ExecutionTimeObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.ExecutionTimeObservation

    observation_type: Union[dict, CodeableConcept] = None
    value_quantity: Union[dict, "Quantity"] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[dict, CodeableConcept]] = None
    focus: Optional[Union[dict, Entity]] = None
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_quantity):
            self.MissingRequiredField("value_quantity")
        if not isinstance(self.value_quantity, Quantity):
            self.value_quantity = Quantity(**as_dict(self.value_quantity))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class Exposure(Entity):
    """
    Contact between an agent and a target. A state of contact or close proximity to a medicinal product, chemical,
    pathogen, radioisotope or other substance.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Exposure
    class_class_curie: ClassVar[str] = "crdch:Exposure"
    class_name: ClassVar[str] = "Exposure"
    class_model_uri: ClassVar[URIRef] = CRDCH.Exposure

    id: Union[str, CrdchString] = None
    identifier: Optional[Union[Union[dict, "Identifier"], List[Union[dict, "Identifier"]]]] = empty_list()
    tobacco_exposure: Optional[Union[Union[dict, "TobaccoExposureObservation"], List[Union[dict, "TobaccoExposureObservation"]]]] = empty_list()
    alcohol_exposure: Optional[Union[Union[dict, AlcoholExposureObservation], List[Union[dict, AlcoholExposureObservation]]]] = empty_list()
    environmental_exposure: Optional[Union[Union[dict, EnvironmentalExposureObservation], List[Union[dict, EnvironmentalExposureObservation]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.id):
            self.MissingRequiredField("id")
        if not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        self._normalize_inlined_as_list(slot_name="tobacco_exposure", slot_type=TobaccoExposureObservation, key_name="observation_type", keyed=False)

        self._normalize_inlined_as_list(slot_name="alcohol_exposure", slot_type=AlcoholExposureObservation, key_name="observation_type", keyed=False)

        self._normalize_inlined_as_list(slot_name="environmental_exposure", slot_type=EnvironmentalExposureObservation, key_name="observation_type", keyed=False)

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        super().__post_init__(**kwargs)


@dataclass
class HistologicalCompositionObservation(Entity):
    """
    An observation about characteristics of a specimen at a microscopic level - typically related to its cellular or
    tissue composition. (e.g. how many cells in the specimen are of a given type, or exhibit a particular cellular
    phenotype).
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.HistologicalCompositionObservation
    class_class_curie: ClassVar[str] = "crdch:HistologicalCompositionObservation"
    class_name: ClassVar[str] = "HistologicalCompositionObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.HistologicalCompositionObservation

    observation_type: Union[dict, CodeableConcept] = None
    value_quantity: Union[dict, "Quantity"] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    focus: Optional[Union[Union[dict, Entity], List[Union[dict, Entity]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_quantity):
            self.MissingRequiredField("value_quantity")
        if not isinstance(self.value_quantity, Quantity):
            self.value_quantity = Quantity(**as_dict(self.value_quantity))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class HistologicalCompositionObservationSet(Entity):
    """
    A set of one or more discrete observations that quantify the relative or absolute composition of a specimen at
    cellular level - e.g. how many cells in the specimen are of a given type, or exhibit a particular cellular
    phenotype.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.HistologicalCompositionObservationSet
    class_class_curie: ClassVar[str] = "crdch:HistologicalCompositionObservationSet"
    class_name: ClassVar[str] = "HistologicalCompositionObservationSet"
    class_model_uri: ClassVar[URIRef] = CRDCH.HistologicalCompositionObservationSet

    id: Union[str, CrdchString] = None
    category: Union[dict, CodeableConcept] = None
    focus: Optional[Union[Union[dict, Entity], List[Union[dict, Entity]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    performed_by: Optional[Union[dict, "Organization"]] = None
    observations: Optional[Union[Union[dict, HistologicalCompositionObservation], List[Union[dict, HistologicalCompositionObservation]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.id):
            self.MissingRequiredField("id")
        if not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self._is_empty(self.category):
            self.MissingRequiredField("category")
        if not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        self._normalize_inlined_as_list(slot_name="observations", slot_type=HistologicalCompositionObservation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class Identifier(Entity):
    """
    An Identifier is associated with a unique object or entity within a given system.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Identifier
    class_class_curie: ClassVar[str] = "crdch:Identifier"
    class_name: ClassVar[str] = "Identifier"
    class_model_uri: ClassVar[URIRef] = CRDCH.Identifier

    value: Union[str, CrdchString] = None
    system: Optional[Union[str, CrdchString]] = None
    type: Optional[Union[dict, CodeableConcept]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.value):
            self.MissingRequiredField("value")
        if not isinstance(self.value, CrdchString):
            self.value = CrdchString(self.value)

        if self.system is not None and not isinstance(self.system, CrdchString):
            self.system = CrdchString(self.system)

        if self.type is not None and not isinstance(self.type, CodeableConcept):
            self.type = CodeableConcept(**as_dict(self.type))

        super().__post_init__(**kwargs)


@dataclass
class Observation(Entity):
    """
    A structured object that describes a single data item about an entity, as generated through a point-in-time
    observation, measurement, or interpretation.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Observation
    class_class_curie: ClassVar[str] = "crdch:Observation"
    class_name: ClassVar[str] = "Observation"
    class_model_uri: ClassVar[URIRef] = CRDCH.Observation

    observation_type: Union[dict, CodeableConcept] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    focus: Optional[Union[Union[dict, Entity], List[Union[dict, Entity]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None
    value_entity: Optional[Union[dict, Entity]] = None
    value_string: Optional[Union[str, CrdchString]] = None
    value_integer: Optional[Union[Decimal, CrdchDecimal]] = None
    value_decimal: Optional[Union[Decimal, CrdchDecimal]] = None
    value_boolean: Optional[Union[bool, CrdchBoolean]] = None
    value_date_time: Optional[Union[str, CrdchDateTime]] = None
    value_quantity: Optional[Union[dict, "Quantity"]] = None
    value_codeable_concept: Optional[Union[dict, CodeableConcept]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.value_entity is not None and not isinstance(self.value_entity, Entity):
            self.value_entity = Entity()

        if self.value_string is not None and not isinstance(self.value_string, CrdchString):
            self.value_string = CrdchString(self.value_string)

        if self.value_integer is not None and not isinstance(self.value_integer, CrdchDecimal):
            self.value_integer = CrdchDecimal(self.value_integer)

        if self.value_decimal is not None and not isinstance(self.value_decimal, CrdchDecimal):
            self.value_decimal = CrdchDecimal(self.value_decimal)

        if self.value_boolean is not None and not isinstance(self.value_boolean, CrdchBoolean):
            self.value_boolean = CrdchBoolean(self.value_boolean)

        if self.value_date_time is not None and not isinstance(self.value_date_time, CrdchDateTime):
            self.value_date_time = CrdchDateTime(self.value_date_time)

        if self.value_quantity is not None and not isinstance(self.value_quantity, Quantity):
            self.value_quantity = Quantity(**as_dict(self.value_quantity))

        if self.value_codeable_concept is not None and not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        super().__post_init__(**kwargs)


@dataclass
class ObservationSet(Entity):
    """
    A structured object to hold related data items about an entity, as generated through a point-in-time observation,
    measurement, or interpretation.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.ObservationSet
    class_class_curie: ClassVar[str] = "crdch:ObservationSet"
    class_name: ClassVar[str] = "ObservationSet"
    class_model_uri: ClassVar[URIRef] = CRDCH.ObservationSet

    id: Union[str, CrdchString] = None
    category: Union[dict, CodeableConcept] = None
    focus: Optional[Union[Union[dict, Entity], List[Union[dict, Entity]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    performed_by: Optional[Union[dict, "Organization"]] = None
    observations: Optional[Union[Union[dict, Observation], List[Union[dict, Observation]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.id):
            self.MissingRequiredField("id")
        if not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self._is_empty(self.category):
            self.MissingRequiredField("category")
        if not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        self._normalize_inlined_as_list(slot_name="observations", slot_type=Observation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class Organization(Entity):
    """
    A grouping of people or organizations with a common purpose such as a data coordinating center, an university, or
    an institute within a university
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Organization
    class_class_curie: ClassVar[str] = "crdch:Organization"
    class_name: ClassVar[str] = "Organization"
    class_model_uri: ClassVar[URIRef] = CRDCH.Organization

    id: Union[str, CrdchString] = None
    identifier: Optional[Union[Union[dict, Identifier], List[Union[dict, Identifier]]]] = empty_list()
    name: Optional[Union[str, CrdchString]] = None
    alias: Optional[Union[str, CrdchString]] = None
    organization_type: Optional[Union[str, CrdchString]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.id):
            self.MissingRequiredField("id")
        if not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.name is not None and not isinstance(self.name, CrdchString):
            self.name = CrdchString(self.name)

        if self.alias is not None and not isinstance(self.alias, CrdchString):
            self.alias = CrdchString(self.alias)

        if self.organization_type is not None and not isinstance(self.organization_type, CrdchString):
            self.organization_type = CrdchString(self.organization_type)

        super().__post_init__(**kwargs)


@dataclass
class Quantity(Entity):
    """
    A structured object to represent an amount of something (e.g., weight, mass, length, duration of time) - including
    a value and unit.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Quantity
    class_class_curie: ClassVar[str] = "crdch:Quantity"
    class_name: ClassVar[str] = "Quantity"
    class_model_uri: ClassVar[URIRef] = CRDCH.Quantity

    value_decimal: Optional[Union[Decimal, CrdchDecimal]] = None
    value_codeable_concept: Optional[Union[dict, CodeableConcept]] = None
    unit: Optional[Union[dict, CodeableConcept]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.value_decimal is not None and not isinstance(self.value_decimal, CrdchDecimal):
            self.value_decimal = CrdchDecimal(self.value_decimal)

        if self.value_codeable_concept is not None and not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        if self.unit is not None and not isinstance(self.unit, CodeableConcept):
            self.unit = CodeableConcept(**as_dict(self.unit))

        super().__post_init__(**kwargs)


@dataclass
class ResearchProject(Entity):
    """
    A process where a researcher or organization plans and then executes a series of steps intended to increase the
    field of healthcare-related knowledge.
    This includes studies of safety, efficacy, comparative effectiveness and other information about medications,
    devices, therapies and other interventional
    and investigative techniques. A ResearchProject involves the gathering of information about human or animal
    subjects.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.ResearchProject
    class_class_curie: ClassVar[str] = "crdch:ResearchProject"
    class_name: ClassVar[str] = "ResearchProject"
    class_model_uri: ClassVar[URIRef] = CRDCH.ResearchProject

    research_project_type: Union[dict, CodeableConcept] = None
    id: Optional[Union[str, CrdchString]] = None
    identifier: Optional[Union[Union[dict, Identifier], List[Union[dict, Identifier]]]] = empty_list()
    name: Optional[Union[str, CrdchString]] = None
    name_shortened: Optional[Union[str, CrdchString]] = None
    description: Optional[Union[str, CrdchString]] = None
    description_shortened: Optional[Union[str, CrdchString]] = None
    sponsor: Optional[Union[Union[str, CrdchString], List[Union[str, CrdchString]]]] = empty_list()
    date_started: Optional[Union[dict, "TimePoint"]] = None
    date_ended: Optional[Union[dict, "TimePoint"]] = None
    primary_anatomic_site: Optional[Union[Union[dict, BodySite], List[Union[dict, BodySite]]]] = empty_list()
    url: Optional[Union[Union[str, CrdchString], List[Union[str, CrdchString]]]] = empty_list()
    part_of: Optional[Union[Union[dict, "ResearchProject"], List[Union[dict, "ResearchProject"]]]] = empty_list()
    associated_timepoint: Optional[Union[Union[dict, "TimePoint"], List[Union[dict, "TimePoint"]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.research_project_type):
            self.MissingRequiredField("research_project_type")
        if not isinstance(self.research_project_type, CodeableConcept):
            self.research_project_type = CodeableConcept(**as_dict(self.research_project_type))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.name is not None and not isinstance(self.name, CrdchString):
            self.name = CrdchString(self.name)

        if self.name_shortened is not None and not isinstance(self.name_shortened, CrdchString):
            self.name_shortened = CrdchString(self.name_shortened)

        if self.description is not None and not isinstance(self.description, CrdchString):
            self.description = CrdchString(self.description)

        if self.description_shortened is not None and not isinstance(self.description_shortened, CrdchString):
            self.description_shortened = CrdchString(self.description_shortened)

        if not isinstance(self.sponsor, list):
            self.sponsor = [self.sponsor] if self.sponsor is not None else []
        self.sponsor = [v if isinstance(v, CrdchString) else CrdchString(v) for v in self.sponsor]

        if self.date_started is not None and not isinstance(self.date_started, TimePoint):
            self.date_started = TimePoint(**as_dict(self.date_started))

        if self.date_ended is not None and not isinstance(self.date_ended, TimePoint):
            self.date_ended = TimePoint(**as_dict(self.date_ended))

        self._normalize_inlined_as_list(slot_name="primary_anatomic_site", slot_type=BodySite, key_name="site", keyed=False)

        if not isinstance(self.url, list):
            self.url = [self.url] if self.url is not None else []
        self.url = [v if isinstance(v, CrdchString) else CrdchString(v) for v in self.url]

        self._normalize_inlined_as_list(slot_name="part_of", slot_type=ResearchProject, key_name="research_project_type", keyed=False)

        if not isinstance(self.associated_timepoint, list):
            self.associated_timepoint = [self.associated_timepoint] if self.associated_timepoint is not None else []
        self.associated_timepoint = [v if isinstance(v, TimePoint) else TimePoint(**as_dict(v)) for v in self.associated_timepoint]

        super().__post_init__(**kwargs)


@dataclass
class ResearchSubject(Entity):
    """
    A research subject is the entity of interest in a research study, typically a human being or an animal, but can
    also be a device, group of humans or animals,
    or a tissue sample. Human research subjects are usually not traceable to a particular person to protect the
    subject’s privacy.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.ResearchSubject
    class_class_curie: ClassVar[str] = "crdch:ResearchSubject"
    class_name: ClassVar[str] = "ResearchSubject"
    class_model_uri: ClassVar[URIRef] = CRDCH.ResearchSubject

    id: Union[str, CrdchString] = None
    associated_subject: Union[dict, "Subject"] = None
    identifier: Optional[Union[Union[dict, Identifier], List[Union[dict, Identifier]]]] = empty_list()
    description: Optional[Union[str, CrdchString]] = None
    member_of_research_project: Optional[Union[dict, ResearchProject]] = None
    age_at_enrollment: Optional[Union[dict, Quantity]] = None
    primary_diagnosis_condition: Optional[Union[dict, CodeableConcept]] = None
    primary_diagnosis_site: Optional[Union[dict, BodySite]] = None
    primary_diagnosis: Optional[Union[Union[dict, Diagnosis], List[Union[dict, Diagnosis]]]] = empty_list()
    comorbid_diagnosis: Optional[Union[Union[dict, Diagnosis], List[Union[dict, Diagnosis]]]] = empty_list()
    index_timepoint: Optional[Union[dict, CodeableConcept]] = None
    originating_site: Optional[Union[dict, Organization]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.id):
            self.MissingRequiredField("id")
        if not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self._is_empty(self.associated_subject):
            self.MissingRequiredField("associated_subject")
        if not isinstance(self.associated_subject, Subject):
            self.associated_subject = Subject(**as_dict(self.associated_subject))

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.description is not None and not isinstance(self.description, CrdchString):
            self.description = CrdchString(self.description)

        if self.member_of_research_project is not None and not isinstance(self.member_of_research_project, ResearchProject):
            self.member_of_research_project = ResearchProject(**as_dict(self.member_of_research_project))

        if self.age_at_enrollment is not None and not isinstance(self.age_at_enrollment, Quantity):
            self.age_at_enrollment = Quantity(**as_dict(self.age_at_enrollment))

        if self.primary_diagnosis_condition is not None and not isinstance(self.primary_diagnosis_condition, CodeableConcept):
            self.primary_diagnosis_condition = CodeableConcept(**as_dict(self.primary_diagnosis_condition))

        if self.primary_diagnosis_site is not None and not isinstance(self.primary_diagnosis_site, BodySite):
            self.primary_diagnosis_site = BodySite(**as_dict(self.primary_diagnosis_site))

        if not isinstance(self.primary_diagnosis, list):
            self.primary_diagnosis = [self.primary_diagnosis] if self.primary_diagnosis is not None else []
        self.primary_diagnosis = [v if isinstance(v, Diagnosis) else Diagnosis(**as_dict(v)) for v in self.primary_diagnosis]

        if not isinstance(self.comorbid_diagnosis, list):
            self.comorbid_diagnosis = [self.comorbid_diagnosis] if self.comorbid_diagnosis is not None else []
        self.comorbid_diagnosis = [v if isinstance(v, Diagnosis) else Diagnosis(**as_dict(v)) for v in self.comorbid_diagnosis]

        if self.index_timepoint is not None and not isinstance(self.index_timepoint, CodeableConcept):
            self.index_timepoint = CodeableConcept(**as_dict(self.index_timepoint))

        if self.originating_site is not None and not isinstance(self.originating_site, Organization):
            self.originating_site = Organization(**as_dict(self.originating_site))

        super().__post_init__(**kwargs)


@dataclass
class Specimen(Entity):
    """
    Any material taken as a sample from a biological entity (living or dead), or from a physical object or the
    environment. Specimens are usually collected as an example of their kind, often for use in some investigation.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Specimen
    class_class_curie: ClassVar[str] = "crdch:Specimen"
    class_name: ClassVar[str] = "Specimen"
    class_model_uri: ClassVar[URIRef] = CRDCH.Specimen

    id: Optional[Union[str, CrdchString]] = None
    identifier: Optional[Union[Union[dict, Identifier], List[Union[dict, Identifier]]]] = empty_list()
    description: Optional[Union[str, CrdchString]] = None
    specimen_type: Optional[Union[dict, CodeableConcept]] = None
    analyte_type: Optional[Union[dict, CodeableConcept]] = None
    associated_project: Optional[Union[dict, ResearchProject]] = None
    data_provider: Optional[Union[dict, Organization]] = None
    source_material_type: Optional[Union[dict, CodeableConcept]] = None
    parent_specimen: Optional[Union[Union[dict, "Specimen"], List[Union[dict, "Specimen"]]]] = empty_list()
    source_subject: Optional[Union[dict, "Subject"]] = None
    tumor_status_at_collection: Optional[Union[dict, CodeableConcept]] = None
    creation_activity: Optional[Union[dict, "SpecimenCreationActivity"]] = None
    processing_activity: Optional[Union[Union[dict, "SpecimenProcessingActivity"], List[Union[dict, "SpecimenProcessingActivity"]]]] = empty_list()
    storage_activity: Optional[Union[Union[dict, "SpecimenStorageActivity"], List[Union[dict, "SpecimenStorageActivity"]]]] = empty_list()
    transport_activity: Optional[Union[Union[dict, "SpecimenTransportActivity"], List[Union[dict, "SpecimenTransportActivity"]]]] = empty_list()
    contained_in: Optional[Union[dict, "SpecimenContainer"]] = None
    dimensional_measures: Optional[Union[dict, DimensionalObservationSet]] = None
    quantity_measure: Optional[Union[Union[dict, "SpecimenQuantityObservation"], List[Union[dict, "SpecimenQuantityObservation"]]]] = empty_list()
    quality_measure: Optional[Union[Union[dict, "SpecimenQualityObservation"], List[Union[dict, "SpecimenQualityObservation"]]]] = empty_list()
    cellular_composition_type: Optional[Union[dict, CodeableConcept]] = None
    histological_composition_measures: Optional[Union[Union[dict, HistologicalCompositionObservationSet], List[Union[dict, HistologicalCompositionObservationSet]]]] = empty_list()
    general_tissue_pathology: Optional[Union[dict, CodeableConcept]] = None
    specific_tissue_pathology: Optional[Union[dict, CodeableConcept]] = None
    preinvasive_tissue_morphology: Optional[Union[dict, CodeableConcept]] = None
    morphology_pathologically_confirmed: Optional[Union[bool, CrdchBoolean]] = None
    morphology_assessor_role: Optional[Union[dict, CodeableConcept]] = None
    morphology_assessment_method: Optional[Union[dict, CodeableConcept]] = None
    degree_of_dysplasia: Optional[Union[dict, CodeableConcept]] = None
    dysplasia_fraction: Optional[Union[str, CrdchString]] = None
    related_document: Optional[Union[Union[dict, Document], List[Union[dict, Document]]]] = empty_list()
    section_location: Optional[Union[dict, CodeableConcept]] = None
    derived_product: Optional[Union[Union[dict, BiologicProduct], List[Union[dict, BiologicProduct]]]] = empty_list()
    distance_from_paired_specimen: Optional[Union[dict, Quantity]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.description is not None and not isinstance(self.description, CrdchString):
            self.description = CrdchString(self.description)

        if self.specimen_type is not None and not isinstance(self.specimen_type, CodeableConcept):
            self.specimen_type = CodeableConcept(**as_dict(self.specimen_type))

        if self.analyte_type is not None and not isinstance(self.analyte_type, CodeableConcept):
            self.analyte_type = CodeableConcept(**as_dict(self.analyte_type))

        if self.associated_project is not None and not isinstance(self.associated_project, ResearchProject):
            self.associated_project = ResearchProject(**as_dict(self.associated_project))

        if self.data_provider is not None and not isinstance(self.data_provider, Organization):
            self.data_provider = Organization(**as_dict(self.data_provider))

        if self.source_material_type is not None and not isinstance(self.source_material_type, CodeableConcept):
            self.source_material_type = CodeableConcept(**as_dict(self.source_material_type))

        if not isinstance(self.parent_specimen, list):
            self.parent_specimen = [self.parent_specimen] if self.parent_specimen is not None else []
        self.parent_specimen = [v if isinstance(v, Specimen) else Specimen(**as_dict(v)) for v in self.parent_specimen]

        if self.source_subject is not None and not isinstance(self.source_subject, Subject):
            self.source_subject = Subject(**as_dict(self.source_subject))

        if self.tumor_status_at_collection is not None and not isinstance(self.tumor_status_at_collection, CodeableConcept):
            self.tumor_status_at_collection = CodeableConcept(**as_dict(self.tumor_status_at_collection))

        if self.creation_activity is not None and not isinstance(self.creation_activity, SpecimenCreationActivity):
            self.creation_activity = SpecimenCreationActivity(**as_dict(self.creation_activity))

        if not isinstance(self.processing_activity, list):
            self.processing_activity = [self.processing_activity] if self.processing_activity is not None else []
        self.processing_activity = [v if isinstance(v, SpecimenProcessingActivity) else SpecimenProcessingActivity(**as_dict(v)) for v in self.processing_activity]

        if not isinstance(self.storage_activity, list):
            self.storage_activity = [self.storage_activity] if self.storage_activity is not None else []
        self.storage_activity = [v if isinstance(v, SpecimenStorageActivity) else SpecimenStorageActivity(**as_dict(v)) for v in self.storage_activity]

        if not isinstance(self.transport_activity, list):
            self.transport_activity = [self.transport_activity] if self.transport_activity is not None else []
        self.transport_activity = [v if isinstance(v, SpecimenTransportActivity) else SpecimenTransportActivity(**as_dict(v)) for v in self.transport_activity]

        if self.contained_in is not None and not isinstance(self.contained_in, SpecimenContainer):
            self.contained_in = SpecimenContainer(**as_dict(self.contained_in))

        if self.dimensional_measures is not None and not isinstance(self.dimensional_measures, DimensionalObservationSet):
            self.dimensional_measures = DimensionalObservationSet(**as_dict(self.dimensional_measures))

        self._normalize_inlined_as_list(slot_name="quantity_measure", slot_type=SpecimenQuantityObservation, key_name="observation_type", keyed=False)

        self._normalize_inlined_as_list(slot_name="quality_measure", slot_type=SpecimenQualityObservation, key_name="observation_type", keyed=False)

        if self.cellular_composition_type is not None and not isinstance(self.cellular_composition_type, CodeableConcept):
            self.cellular_composition_type = CodeableConcept(**as_dict(self.cellular_composition_type))

        self._normalize_inlined_as_list(slot_name="histological_composition_measures", slot_type=HistologicalCompositionObservationSet, key_name="id", keyed=False)

        if self.general_tissue_pathology is not None and not isinstance(self.general_tissue_pathology, CodeableConcept):
            self.general_tissue_pathology = CodeableConcept(**as_dict(self.general_tissue_pathology))

        if self.specific_tissue_pathology is not None and not isinstance(self.specific_tissue_pathology, CodeableConcept):
            self.specific_tissue_pathology = CodeableConcept(**as_dict(self.specific_tissue_pathology))

        if self.preinvasive_tissue_morphology is not None and not isinstance(self.preinvasive_tissue_morphology, CodeableConcept):
            self.preinvasive_tissue_morphology = CodeableConcept(**as_dict(self.preinvasive_tissue_morphology))

        if self.morphology_pathologically_confirmed is not None and not isinstance(self.morphology_pathologically_confirmed, CrdchBoolean):
            self.morphology_pathologically_confirmed = CrdchBoolean(self.morphology_pathologically_confirmed)

        if self.morphology_assessor_role is not None and not isinstance(self.morphology_assessor_role, CodeableConcept):
            self.morphology_assessor_role = CodeableConcept(**as_dict(self.morphology_assessor_role))

        if self.morphology_assessment_method is not None and not isinstance(self.morphology_assessment_method, CodeableConcept):
            self.morphology_assessment_method = CodeableConcept(**as_dict(self.morphology_assessment_method))

        if self.degree_of_dysplasia is not None and not isinstance(self.degree_of_dysplasia, CodeableConcept):
            self.degree_of_dysplasia = CodeableConcept(**as_dict(self.degree_of_dysplasia))

        if self.dysplasia_fraction is not None and not isinstance(self.dysplasia_fraction, CrdchString):
            self.dysplasia_fraction = CrdchString(self.dysplasia_fraction)

        if not isinstance(self.related_document, list):
            self.related_document = [self.related_document] if self.related_document is not None else []
        self.related_document = [v if isinstance(v, Document) else Document(**as_dict(v)) for v in self.related_document]

        if self.section_location is not None and not isinstance(self.section_location, CodeableConcept):
            self.section_location = CodeableConcept(**as_dict(self.section_location))

        if not isinstance(self.derived_product, list):
            self.derived_product = [self.derived_product] if self.derived_product is not None else []
        self.derived_product = [v if isinstance(v, BiologicProduct) else BiologicProduct(**as_dict(v)) for v in self.derived_product]

        if self.distance_from_paired_specimen is not None and not isinstance(self.distance_from_paired_specimen, Quantity):
            self.distance_from_paired_specimen = Quantity(**as_dict(self.distance_from_paired_specimen))

        super().__post_init__(**kwargs)


@dataclass
class SpecimenContainer(Entity):
    """
    A vessel in which a specimen is held or to which it is attached - for storage or as a substrate for growth (e.g. a
    cell culture dish) or analysis (e.g. a microscope slide or 96-well plate)
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.SpecimenContainer
    class_class_curie: ClassVar[str] = "crdch:SpecimenContainer"
    class_name: ClassVar[str] = "SpecimenContainer"
    class_model_uri: ClassVar[URIRef] = CRDCH.SpecimenContainer

    id: Optional[Union[str, CrdchString]] = None
    identifier: Optional[Union[Union[dict, Identifier], List[Union[dict, Identifier]]]] = empty_list()
    container_type: Optional[Union[dict, CodeableConcept]] = None
    container_number: Optional[Union[str, CrdchString]] = None
    additive: Optional[Union[Union[dict, "Substance"], List[Union[dict, "Substance"]]]] = empty_list()
    parent_container: Optional[Union[dict, "SpecimenContainer"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.container_type is not None and not isinstance(self.container_type, CodeableConcept):
            self.container_type = CodeableConcept(**as_dict(self.container_type))

        if self.container_number is not None and not isinstance(self.container_number, CrdchString):
            self.container_number = CrdchString(self.container_number)

        if not isinstance(self.additive, list):
            self.additive = [self.additive] if self.additive is not None else []
        self.additive = [v if isinstance(v, Substance) else Substance(**as_dict(v)) for v in self.additive]

        if self.parent_container is not None and not isinstance(self.parent_container, SpecimenContainer):
            self.parent_container = SpecimenContainer(**as_dict(self.parent_container))

        super().__post_init__(**kwargs)


@dataclass
class SpecimenCreationActivity(Entity):
    """
    The process of creating a specimen. This may occur through observing and/or collecting material from an biological
    source or natural setting, or through derivation from an existing specimen (e.g. via portioning or aliquoting).
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.SpecimenCreationActivity
    class_class_curie: ClassVar[str] = "crdch:SpecimenCreationActivity"
    class_name: ClassVar[str] = "SpecimenCreationActivity"
    class_model_uri: ClassVar[URIRef] = CRDCH.SpecimenCreationActivity

    activity_type: Optional[Union[dict, CodeableConcept]] = None
    date_started: Optional[Union[dict, "TimePoint"]] = None
    date_ended: Optional[Union[dict, "TimePoint"]] = None
    performed_by: Optional[Union[dict, Organization]] = None
    collection_method_type: Optional[Union[dict, CodeableConcept]] = None
    derivation_method_type: Optional[Union[dict, CodeableConcept]] = None
    additive: Optional[Union[Union[dict, "Substance"], List[Union[dict, "Substance"]]]] = empty_list()
    collection_site: Optional[Union[dict, BodySite]] = None
    quantity_collected: Optional[Union[dict, Quantity]] = None
    execution_time_observation: Optional[Union[Union[dict, ExecutionTimeObservation], List[Union[dict, ExecutionTimeObservation]]]] = empty_list()
    execution_condition_observation: Optional[Union[Union[dict, ExecutionConditionObservation], List[Union[dict, ExecutionConditionObservation]]]] = empty_list()
    specimen_order: Optional[Union[int, CrdchInteger]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.activity_type is not None and not isinstance(self.activity_type, CodeableConcept):
            self.activity_type = CodeableConcept(**as_dict(self.activity_type))

        if self.date_started is not None and not isinstance(self.date_started, TimePoint):
            self.date_started = TimePoint(**as_dict(self.date_started))

        if self.date_ended is not None and not isinstance(self.date_ended, TimePoint):
            self.date_ended = TimePoint(**as_dict(self.date_ended))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.collection_method_type is not None and not isinstance(self.collection_method_type, CodeableConcept):
            self.collection_method_type = CodeableConcept(**as_dict(self.collection_method_type))

        if self.derivation_method_type is not None and not isinstance(self.derivation_method_type, CodeableConcept):
            self.derivation_method_type = CodeableConcept(**as_dict(self.derivation_method_type))

        if not isinstance(self.additive, list):
            self.additive = [self.additive] if self.additive is not None else []
        self.additive = [v if isinstance(v, Substance) else Substance(**as_dict(v)) for v in self.additive]

        if self.collection_site is not None and not isinstance(self.collection_site, BodySite):
            self.collection_site = BodySite(**as_dict(self.collection_site))

        if self.quantity_collected is not None and not isinstance(self.quantity_collected, Quantity):
            self.quantity_collected = Quantity(**as_dict(self.quantity_collected))

        self._normalize_inlined_as_list(slot_name="execution_time_observation", slot_type=ExecutionTimeObservation, key_name="observation_type", keyed=False)

        self._normalize_inlined_as_list(slot_name="execution_condition_observation", slot_type=ExecutionConditionObservation, key_name="observation_type", keyed=False)

        if self.specimen_order is not None and not isinstance(self.specimen_order, CrdchInteger):
            self.specimen_order = CrdchInteger(self.specimen_order)

        super().__post_init__(**kwargs)


@dataclass
class SpecimenQualityObservation(Entity):
    """
    A structured object that describes a characteristic of a specimen indicative of its quality or suitability for
    use, as generated through a point-in-time observation or measurement.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.SpecimenQualityObservation
    class_class_curie: ClassVar[str] = "crdch:SpecimenQualityObservation"
    class_name: ClassVar[str] = "SpecimenQualityObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.SpecimenQualityObservation

    observation_type: Union[dict, CodeableConcept] = None
    value_quantity: Union[dict, Quantity] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    focus: Optional[Union[Union[dict, Entity], List[Union[dict, Entity]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, Organization]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_quantity):
            self.MissingRequiredField("value_quantity")
        if not isinstance(self.value_quantity, Quantity):
            self.value_quantity = Quantity(**as_dict(self.value_quantity))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class SpecimenQuantityObservation(Entity):
    """
    A structured object that describes a single data item about the quantity of an entity, as generated through a
    point-in-time observation or measurement.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.SpecimenQuantityObservation
    class_class_curie: ClassVar[str] = "crdch:SpecimenQuantityObservation"
    class_name: ClassVar[str] = "SpecimenQuantityObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.SpecimenQuantityObservation

    observation_type: Union[dict, CodeableConcept] = None
    value_quantity: Union[dict, Quantity] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    focus: Optional[Union[Union[dict, Entity], List[Union[dict, Entity]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, Organization]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_quantity):
            self.MissingRequiredField("value_quantity")
        if not isinstance(self.value_quantity, Quantity):
            self.value_quantity = Quantity(**as_dict(self.value_quantity))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class SpecimenProcessingActivity(Entity):
    """
    An activity that modifies the physical structure, composition, or state of a specimen. Unlike SpecimenCreation,
    SpecimenProcessing activities do not result in the generation of new entities - they take a single specimen as
    input, and output that same specimen.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.SpecimenProcessingActivity
    class_class_curie: ClassVar[str] = "crdch:SpecimenProcessingActivity"
    class_name: ClassVar[str] = "SpecimenProcessingActivity"
    class_model_uri: ClassVar[URIRef] = CRDCH.SpecimenProcessingActivity

    activity_type: Optional[Union[dict, CodeableConcept]] = None
    date_started: Optional[Union[dict, "TimePoint"]] = None
    date_ended: Optional[Union[dict, "TimePoint"]] = None
    duration: Optional[Union[Union[dict, Quantity], List[Union[dict, Quantity]]]] = empty_list()
    performed_by: Optional[Union[dict, Organization]] = None
    method_type: Optional[Union[dict, CodeableConcept]] = None
    additive: Optional[Union[Union[dict, "Substance"], List[Union[dict, "Substance"]]]] = empty_list()
    execution_time_observation: Optional[Union[Union[dict, ExecutionTimeObservation], List[Union[dict, ExecutionTimeObservation]]]] = empty_list()
    execution_condition_observation: Optional[Union[Union[dict, ExecutionConditionObservation], List[Union[dict, ExecutionConditionObservation]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.activity_type is not None and not isinstance(self.activity_type, CodeableConcept):
            self.activity_type = CodeableConcept(**as_dict(self.activity_type))

        if self.date_started is not None and not isinstance(self.date_started, TimePoint):
            self.date_started = TimePoint(**as_dict(self.date_started))

        if self.date_ended is not None and not isinstance(self.date_ended, TimePoint):
            self.date_ended = TimePoint(**as_dict(self.date_ended))

        if not isinstance(self.duration, list):
            self.duration = [self.duration] if self.duration is not None else []
        self.duration = [v if isinstance(v, Quantity) else Quantity(**as_dict(v)) for v in self.duration]

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if not isinstance(self.additive, list):
            self.additive = [self.additive] if self.additive is not None else []
        self.additive = [v if isinstance(v, Substance) else Substance(**as_dict(v)) for v in self.additive]

        self._normalize_inlined_as_list(slot_name="execution_time_observation", slot_type=ExecutionTimeObservation, key_name="observation_type", keyed=False)

        self._normalize_inlined_as_list(slot_name="execution_condition_observation", slot_type=ExecutionConditionObservation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class SpecimenStorageActivity(Entity):
    """
    An activity in which a specimen is stored or maintained in a particular location, container, or state. Unlike
    'processing' activities, storage does not alter the
    intrinsic physical nature of a specimen.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.SpecimenStorageActivity
    class_class_curie: ClassVar[str] = "crdch:SpecimenStorageActivity"
    class_name: ClassVar[str] = "SpecimenStorageActivity"
    class_model_uri: ClassVar[URIRef] = CRDCH.SpecimenStorageActivity

    date_started: Optional[Union[dict, "TimePoint"]] = None
    date_ended: Optional[Union[dict, "TimePoint"]] = None
    duration: Optional[Union[dict, Quantity]] = None
    performed_by: Optional[Union[dict, Organization]] = None
    method_type: Optional[Union[dict, CodeableConcept]] = None
    container: Optional[Union[Union[dict, SpecimenContainer], List[Union[dict, SpecimenContainer]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.date_started is not None and not isinstance(self.date_started, TimePoint):
            self.date_started = TimePoint(**as_dict(self.date_started))

        if self.date_ended is not None and not isinstance(self.date_ended, TimePoint):
            self.date_ended = TimePoint(**as_dict(self.date_ended))

        if self.duration is not None and not isinstance(self.duration, Quantity):
            self.duration = Quantity(**as_dict(self.duration))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if not isinstance(self.container, list):
            self.container = [self.container] if self.container is not None else []
        self.container = [v if isinstance(v, SpecimenContainer) else SpecimenContainer(**as_dict(v)) for v in self.container]

        super().__post_init__(**kwargs)


@dataclass
class SpecimenTransportActivity(Entity):
    """
    An activity through which a specimen is transported between locations or organizations.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.SpecimenTransportActivity
    class_class_curie: ClassVar[str] = "crdch:SpecimenTransportActivity"
    class_name: ClassVar[str] = "SpecimenTransportActivity"
    class_model_uri: ClassVar[URIRef] = CRDCH.SpecimenTransportActivity

    date_started: Optional[Union[dict, "TimePoint"]] = None
    date_ended: Optional[Union[dict, "TimePoint"]] = None
    duration: Optional[Union[Union[str, CrdchString], List[Union[str, CrdchString]]]] = empty_list()
    performed_by: Optional[Union[dict, Organization]] = None
    transport_origin: Optional[Union[dict, Organization]] = None
    transport_destination: Optional[Union[dict, Organization]] = None
    execution_condition_observation: Optional[Union[Union[dict, ExecutionConditionObservation], List[Union[dict, ExecutionConditionObservation]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.date_started is not None and not isinstance(self.date_started, TimePoint):
            self.date_started = TimePoint(**as_dict(self.date_started))

        if self.date_ended is not None and not isinstance(self.date_ended, TimePoint):
            self.date_ended = TimePoint(**as_dict(self.date_ended))

        if not isinstance(self.duration, list):
            self.duration = [self.duration] if self.duration is not None else []
        self.duration = [v if isinstance(v, CrdchString) else CrdchString(v) for v in self.duration]

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.transport_origin is not None and not isinstance(self.transport_origin, Organization):
            self.transport_origin = Organization(**as_dict(self.transport_origin))

        if self.transport_destination is not None and not isinstance(self.transport_destination, Organization):
            self.transport_destination = Organization(**as_dict(self.transport_destination))

        self._normalize_inlined_as_list(slot_name="execution_condition_observation", slot_type=ExecutionConditionObservation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class Subject(Entity):
    """
    Demographics and other administrative information about an individual or animal receiving care or other
    health-related services.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Subject
    class_class_curie: ClassVar[str] = "crdch:Subject"
    class_name: ClassVar[str] = "Subject"
    class_model_uri: ClassVar[URIRef] = CRDCH.Subject

    id: Union[str, CrdchString] = None
    identifier: Optional[Union[Union[dict, Identifier], List[Union[dict, Identifier]]]] = empty_list()
    species: Optional[Union[dict, CodeableConcept]] = None
    breed: Optional[Union[dict, CodeableConcept]] = None
    sex: Optional[Union[dict, CodeableConcept]] = None
    ethnicity: Optional[Union[dict, CodeableConcept]] = None
    race: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    year_of_birth: Optional[Union[int, CrdchInteger]] = None
    vital_status: Optional[Union[dict, CodeableConcept]] = None
    age_at_death: Optional[Union[dict, Quantity]] = None
    year_of_death: Optional[Union[int, CrdchInteger]] = None
    cause_of_death: Optional[Union[dict, CodeableConcept]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.id):
            self.MissingRequiredField("id")
        if not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.species is not None and not isinstance(self.species, CodeableConcept):
            self.species = CodeableConcept(**as_dict(self.species))

        if self.breed is not None and not isinstance(self.breed, CodeableConcept):
            self.breed = CodeableConcept(**as_dict(self.breed))

        if self.sex is not None and not isinstance(self.sex, CodeableConcept):
            self.sex = CodeableConcept(**as_dict(self.sex))

        if self.ethnicity is not None and not isinstance(self.ethnicity, CodeableConcept):
            self.ethnicity = CodeableConcept(**as_dict(self.ethnicity))

        if not isinstance(self.race, list):
            self.race = [self.race] if self.race is not None else []
        self.race = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.race]

        if self.year_of_birth is not None and not isinstance(self.year_of_birth, CrdchInteger):
            self.year_of_birth = CrdchInteger(self.year_of_birth)

        if self.vital_status is not None and not isinstance(self.vital_status, CodeableConcept):
            self.vital_status = CodeableConcept(**as_dict(self.vital_status))

        if self.age_at_death is not None and not isinstance(self.age_at_death, Quantity):
            self.age_at_death = Quantity(**as_dict(self.age_at_death))

        if self.year_of_death is not None and not isinstance(self.year_of_death, CrdchInteger):
            self.year_of_death = CrdchInteger(self.year_of_death)

        if self.cause_of_death is not None and not isinstance(self.cause_of_death, CodeableConcept):
            self.cause_of_death = CodeableConcept(**as_dict(self.cause_of_death))

        super().__post_init__(**kwargs)


@dataclass
class Substance(Entity):
    """
    A type of material substance, or instance thereof, as used in a particular application. May include information
    about the role the substance played in a particular application.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Substance
    class_class_curie: ClassVar[str] = "crdch:Substance"
    class_name: ClassVar[str] = "Substance"
    class_model_uri: ClassVar[URIRef] = CRDCH.Substance

    substance_type: Optional[Union[dict, CodeableConcept]] = None
    role: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    substance_quantity: Optional[Union[dict, Quantity]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.substance_type is not None and not isinstance(self.substance_type, CodeableConcept):
            self.substance_type = CodeableConcept(**as_dict(self.substance_type))

        if not isinstance(self.role, list):
            self.role = [self.role] if self.role is not None else []
        self.role = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.role]

        if self.substance_quantity is not None and not isinstance(self.substance_quantity, Quantity):
            self.substance_quantity = Quantity(**as_dict(self.substance_quantity))

        super().__post_init__(**kwargs)


@dataclass
class TimePoint(Entity):
    """
    A structured representation of a single point in time that allows direct/explicit declaration as a dateTime,
    specification in terms of offset from a defined index, or description of an event type as a proxy for the time
    point when it occurred.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.TimePoint
    class_class_curie: ClassVar[str] = "crdch:TimePoint"
    class_name: ClassVar[str] = "TimePoint"
    class_model_uri: ClassVar[URIRef] = CRDCH.TimePoint

    id: Optional[Union[str, CrdchString]] = None
    date_time: Optional[Union[str, CrdchDateTime]] = None
    index_time_point: Optional[Union[dict, "TimePoint"]] = None
    offset_from_index: Optional[Union[dict, Quantity]] = None
    event_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.date_time is not None and not isinstance(self.date_time, CrdchDateTime):
            self.date_time = CrdchDateTime(self.date_time)

        if self.index_time_point is not None and not isinstance(self.index_time_point, TimePoint):
            self.index_time_point = TimePoint(**as_dict(self.index_time_point))

        if self.offset_from_index is not None and not isinstance(self.offset_from_index, Quantity):
            self.offset_from_index = Quantity(**as_dict(self.offset_from_index))

        if not isinstance(self.event_type, list):
            self.event_type = [self.event_type] if self.event_type is not None else []
        self.event_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.event_type]

        super().__post_init__(**kwargs)


@dataclass
class TimePeriod(Entity):
    """
    A period of time between a start and end time point.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.TimePeriod
    class_class_curie: ClassVar[str] = "crdch:TimePeriod"
    class_name: ClassVar[str] = "TimePeriod"
    class_model_uri: ClassVar[URIRef] = CRDCH.TimePeriod

    period_start_start: Optional[Union[dict, TimePoint]] = None
    period_end_end: Optional[Union[dict, TimePoint]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.period_start_start is not None and not isinstance(self.period_start_start, TimePoint):
            self.period_start_start = TimePoint(**as_dict(self.period_start_start))

        if self.period_end_end is not None and not isinstance(self.period_end_end, TimePoint):
            self.period_end_end = TimePoint(**as_dict(self.period_end_end))

        super().__post_init__(**kwargs)


@dataclass
class TobaccoExposureObservation(Entity):
    """
    A structured object that describes a single data item about an individual's exposure to tobacco, as generated
    through a point-in-time observation, measurement, or interpretation.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.TobaccoExposureObservation
    class_class_curie: ClassVar[str] = "crdch:TobaccoExposureObservation"
    class_name: ClassVar[str] = "TobaccoExposureObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.TobaccoExposureObservation

    observation_type: Union[dict, CodeableConcept] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[dict, CodeableConcept]] = None
    focus: Optional[Union[dict, Entity]] = None
    subject: Optional[Union[dict, Subject]] = None
    performed_by: Optional[Union[dict, Organization]] = None
    value_integer: Optional[Union[int, CrdchInteger]] = None
    value_codeable_concept: Optional[Union[dict, CodeableConcept]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.value_integer is not None and not isinstance(self.value_integer, CrdchInteger):
            self.value_integer = CrdchInteger(self.value_integer)

        if self.value_codeable_concept is not None and not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        super().__post_init__(**kwargs)


@dataclass
class Treatment(Entity):
    """
    Represent medication administration or other treatment types.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Treatment
    class_class_curie: ClassVar[str] = "crdch:Treatment"
    class_name: ClassVar[str] = "Treatment"
    class_model_uri: ClassVar[URIRef] = CRDCH.Treatment

    id: Optional[Union[str, CrdchString]] = None
    identifier: Optional[Union[Union[dict, Identifier], List[Union[dict, Identifier]]]] = empty_list()
    treatment_for_diagnosis: Optional[Union[Union[dict, Diagnosis], List[Union[dict, Diagnosis]]]] = empty_list()
    concurrent_treatment: Optional[Union[Union[dict, "Treatment"], List[Union[dict, "Treatment"]]]] = empty_list()
    treatment_type: Optional[Union[dict, CodeableConcept]] = None
    subject: Optional[Union[dict, Subject]] = None
    date_started: Optional[Union[dict, TimePoint]] = None
    date_ended: Optional[Union[dict, TimePoint]] = None
    treatment_end_reason: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    regimen: Optional[Union[dict, CodeableConcept]] = None
    therapeutic_agent: Optional[Union[dict, Substance]] = None
    number_of_cycles: Optional[Union[int, CrdchInteger]] = None
    treatment_frequency: Optional[Union[dict, CodeableConcept]] = None
    treatment_anatomic_site: Optional[Union[dict, BodySite]] = None
    treatment_intent: Optional[Union[dict, CodeableConcept]] = None
    treatment_effect: Optional[Union[dict, CodeableConcept]] = None
    treatment_outcome: Optional[Union[dict, CodeableConcept]] = None
    treatment_dose: Optional[Union[dict, Quantity]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if not isinstance(self.treatment_for_diagnosis, list):
            self.treatment_for_diagnosis = [self.treatment_for_diagnosis] if self.treatment_for_diagnosis is not None else []
        self.treatment_for_diagnosis = [v if isinstance(v, Diagnosis) else Diagnosis(**as_dict(v)) for v in self.treatment_for_diagnosis]

        if not isinstance(self.concurrent_treatment, list):
            self.concurrent_treatment = [self.concurrent_treatment] if self.concurrent_treatment is not None else []
        self.concurrent_treatment = [v if isinstance(v, Treatment) else Treatment(**as_dict(v)) for v in self.concurrent_treatment]

        if self.treatment_type is not None and not isinstance(self.treatment_type, CodeableConcept):
            self.treatment_type = CodeableConcept(**as_dict(self.treatment_type))

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.date_started is not None and not isinstance(self.date_started, TimePoint):
            self.date_started = TimePoint(**as_dict(self.date_started))

        if self.date_ended is not None and not isinstance(self.date_ended, TimePoint):
            self.date_ended = TimePoint(**as_dict(self.date_ended))

        if not isinstance(self.treatment_end_reason, list):
            self.treatment_end_reason = [self.treatment_end_reason] if self.treatment_end_reason is not None else []
        self.treatment_end_reason = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.treatment_end_reason]

        if self.regimen is not None and not isinstance(self.regimen, CodeableConcept):
            self.regimen = CodeableConcept(**as_dict(self.regimen))

        if self.therapeutic_agent is not None and not isinstance(self.therapeutic_agent, Substance):
            self.therapeutic_agent = Substance(**as_dict(self.therapeutic_agent))

        if self.number_of_cycles is not None and not isinstance(self.number_of_cycles, CrdchInteger):
            self.number_of_cycles = CrdchInteger(self.number_of_cycles)

        if self.treatment_frequency is not None and not isinstance(self.treatment_frequency, CodeableConcept):
            self.treatment_frequency = CodeableConcept(**as_dict(self.treatment_frequency))

        if self.treatment_anatomic_site is not None and not isinstance(self.treatment_anatomic_site, BodySite):
            self.treatment_anatomic_site = BodySite(**as_dict(self.treatment_anatomic_site))

        if self.treatment_intent is not None and not isinstance(self.treatment_intent, CodeableConcept):
            self.treatment_intent = CodeableConcept(**as_dict(self.treatment_intent))

        if self.treatment_effect is not None and not isinstance(self.treatment_effect, CodeableConcept):
            self.treatment_effect = CodeableConcept(**as_dict(self.treatment_effect))

        if self.treatment_outcome is not None and not isinstance(self.treatment_outcome, CodeableConcept):
            self.treatment_outcome = CodeableConcept(**as_dict(self.treatment_outcome))

        if self.treatment_dose is not None and not isinstance(self.treatment_dose, Quantity):
            self.treatment_dose = Quantity(**as_dict(self.treatment_dose))

        super().__post_init__(**kwargs)


# Enumerations
class EnumCRDCHAlcoholExposureObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H AlcoholExposureObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHAlcoholExposureObservationCategory",
        description="Autogenerated Enumeration for CRDC-H AlcoholExposureObservation category",
        code_set=None,
        code_set_version="2021-12-16T18:03:46.901555+00:00",
    )

class EnumCRDCHAlcoholExposureObservationObservationType(EnumDefinitionImpl):
    """
    Types of observations about a Subject's exposure to alcohol.
    """
    alcohol_days_per_week = PermissibleValue(text="alcohol_days_per_week",
                                                                 description="Numeric value used to describe the average number of days each week that a person consumes an alcoholic beverage.")
    alcohol_drinks_per_day = PermissibleValue(text="alcohol_drinks_per_day",
                                                                   description="Numeric value used to describe the average number of alcoholic beverages a person consumes per day.")
    alcohol_history = PermissibleValue(text="alcohol_history",
                                                     description="A response to a question that asks whether the participant has consumed at least 12 drinks of any kind of alcoholic beverage in their lifetime.")
    alcohol_intensity = PermissibleValue(text="alcohol_intensity",
                                                         description="Category to describe the patient's current level of alcohol use as self-reported by the patient.")

    _defn = EnumDefinition(
        name="EnumCRDCHAlcoholExposureObservationObservationType",
        description="Types of observations about a Subject's exposure to alcohol.",
    )

class EnumCRDCHAlcoholExposureObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H AlcoholExposureObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHAlcoholExposureObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H AlcoholExposureObservation method_type",
        code_set=None,
        code_set_version="2021-12-16T18:03:47.431359+00:00",
    )

class EnumCRDCHAlcoholExposureObservationValueCodeableConcept(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H AlcoholExposureObservation value_codeable_concept
    """
    Drinker = PermissibleValue(text="Drinker")
    Unknown = PermissibleValue(text="Unknown")
    No = PermissibleValue(text="No",
                           description="No")
    Yes = PermissibleValue(text="Yes",
                             description="Yes")

    _defn = EnumDefinition(
        name="EnumCRDCHAlcoholExposureObservationValueCodeableConcept",
        description="Autogenerated Enumeration for CRDC-H AlcoholExposureObservation value_codeable_concept",
        code_set=None,
        code_set_version="2021-12-16T18:03:47.581332+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Non-Drinker",
                PermissibleValue(text="Non-Drinker") )
        setattr(cls, "Lifelong Non-Drinker",
                PermissibleValue(text="Lifelong Non-Drinker") )
        setattr(cls, "Heavy Drinker",
                PermissibleValue(text="Heavy Drinker") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "Occasional Drinker",
                PermissibleValue(text="Occasional Drinker",
                                 description="Occasional Drinker") )

class EnumCRDCHBodySiteSite(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H BodySite site
    """
    Nasopharynx = PermissibleValue(text="Nasopharynx",
                                             description="Nasopharynx")
    Retina = PermissibleValue(text="Retina",
                                   description="Retina")
    Mantle = PermissibleValue(text="Mantle")
    Breast = PermissibleValue(text="Breast",
                                   description="Breast")
    Sinus = PermissibleValue(text="Sinus",
                                 description="Sinus")
    Clavicle = PermissibleValue(text="Clavicle",
                                       description="Clavicle")
    Kidney = PermissibleValue(text="Kidney",
                                   description="Kidney")
    Brain = PermissibleValue(text="Brain",
                                 description="Brain")
    Tonsil = PermissibleValue(text="Tonsil",
                                   description="Tonsil")
    Axilla = PermissibleValue(text="Axilla",
                                   description="Axilla")
    Arm = PermissibleValue(text="Arm",
                             description="Arm")
    Anus = PermissibleValue(text="Anus",
                               description="Anus")
    Bronchiole = PermissibleValue(text="Bronchiole",
                                           description="Bronchiole")
    Groin = PermissibleValue(text="Groin",
                                 description="Inguinal Region")
    Hilar = PermissibleValue(text="Hilar")
    Pouch = PermissibleValue(text="Pouch",
                                 description="Pouch")
    Neck = PermissibleValue(text="Neck",
                               description="Neck")
    Shoulder = PermissibleValue(text="Shoulder",
                                       description="Shoulder Joint")
    Gum = PermissibleValue(text="Gum",
                             description="Gingiva")
    Ankle = PermissibleValue(text="Ankle",
                                 description="Ankle")
    Lip = PermissibleValue(text="Lip",
                             description="Lip")
    Wrist = PermissibleValue(text="Wrist",
                                 description="Wrist")
    Ischium = PermissibleValue(text="Ischium",
                                     description="Ischium")
    Skull = PermissibleValue(text="Skull",
                                 description="Skull")
    Pericardium = PermissibleValue(text="Pericardium",
                                             description="Pericardium")
    Ovary = PermissibleValue(text="Ovary",
                                 description="Ovary")
    Vertebra = PermissibleValue(text="Vertebra",
                                       description="Vertebra")
    Bone = PermissibleValue(text="Bone",
                               description="Bone")
    Ileum = PermissibleValue(text="Ileum",
                                 description="Ileum")
    Hypopharynx = PermissibleValue(text="Hypopharynx",
                                             description="Hypopharynx")
    Palate = PermissibleValue(text="Palate",
                                   description="Palate")
    Back = PermissibleValue(text="Back",
                               description="Back")
    Thumb = PermissibleValue(text="Thumb",
                                 description="Hand Digit 1")
    Heart = PermissibleValue(text="Heart",
                                 description="Heart")
    Vein = PermissibleValue(text="Vein",
                               description="Vein")
    Rib = PermissibleValue(text="Rib",
                             description="Rib")
    Placenta = PermissibleValue(text="Placenta",
                                       description="Placenta")
    Fluid = PermissibleValue(text="Fluid",
                                 description="Body Fluid or Substance")
    Stomach = PermissibleValue(text="Stomach",
                                     description="Stomach")
    Peritoneum = PermissibleValue(text="Peritoneum",
                                           description="Peritoneum")
    Ear = PermissibleValue(text="Ear",
                             description="Ear")
    Sacrum = PermissibleValue(text="Sacrum",
                                   description="Sacrum")
    Vagina = PermissibleValue(text="Vagina",
                                   description="Vagina")
    Finger = PermissibleValue(text="Finger",
                                   description="Fingers (Phalanges)")
    Foreskin = PermissibleValue(text="Foreskin",
                                       description="Male Prepuce")
    Adenoid = PermissibleValue(text="Adenoid",
                                     description="Tonsillar Tissue")
    Joint = PermissibleValue(text="Joint",
                                 description="Joint")
    Ascites = PermissibleValue(text="Ascites")
    Parametrium = PermissibleValue(text="Parametrium")
    Blood = PermissibleValue(text="Blood",
                                 description="Blood")
    Antrum = PermissibleValue(text="Antrum",
                                   description="Antrum Pylori")
    Aorta = PermissibleValue(text="Aorta",
                                 description="Aorta")
    Thorax = PermissibleValue(text="Thorax",
                                   description="Thorax")
    Scapula = PermissibleValue(text="Scapula",
                                     description="Scapula")
    Tongue = PermissibleValue(text="Tongue",
                                   description="Tongue")
    Hand = PermissibleValue(text="Hand",
                               description="Hand")
    Capillary = PermissibleValue(text="Capillary",
                                         description="Capillary")
    Humerus = PermissibleValue(text="Humerus",
                                     description="Humerus")
    Buttock = PermissibleValue(text="Buttock",
                                     description="Buttock")
    Larynx = PermissibleValue(text="Larynx",
                                   description="Larynx")
    Carina = PermissibleValue(text="Carina",
                                   description="Carina")
    Leptomeninges = PermissibleValue(text="Leptomeninges",
                                                 description="Leptomeninges")
    Conjunctiva = PermissibleValue(text="Conjunctiva",
                                             description="Conjunctiva")
    Penis = PermissibleValue(text="Penis",
                                 description="Penis")
    Forehead = PermissibleValue(text="Forehead",
                                       description="Forehead")
    Anorectum = PermissibleValue(text="Anorectum",
                                         description="Anorectum")
    Laryngopharynx = PermissibleValue(text="Laryngopharynx",
                                                   description="Hypopharynx (Laryngopharynx)")
    Parathyroid = PermissibleValue(text="Parathyroid",
                                             description="Parathyroid Gland")
    Thymus = PermissibleValue(text="Thymus",
                                   description="Thymus")
    Chest = PermissibleValue(text="Chest",
                                 description="Chest")
    Calf = PermissibleValue(text="Calf",
                               description="Calf")
    Nails = PermissibleValue(text="Nails",
                                 description="Nail")
    Gallbladder = PermissibleValue(text="Gallbladder",
                                             description="Gallbladder")
    Hepatic = PermissibleValue(text="Hepatic",
                                     description="Hepatic")
    Cartilage = PermissibleValue(text="Cartilage",
                                         description="Cartilage")
    Pancreas = PermissibleValue(text="Pancreas",
                                       description="Pancreas")
    Elbow = PermissibleValue(text="Elbow",
                                 description="Elbow Joint")
    Ligament = PermissibleValue(text="Ligament",
                                       description="Ligament")
    Mesentery = PermissibleValue(text="Mesentery",
                                         description="Mesentery")
    Maxilla = PermissibleValue(text="Maxilla",
                                     description="Maxilla")
    Venous = PermissibleValue(text="Venous",
                                   description="Venous")
    Cerebrum = PermissibleValue(text="Cerebrum",
                                       description="Cerebral Hemisphere")
    Prostate = PermissibleValue(text="Prostate",
                                       description="Prostate")
    Clitoris = PermissibleValue(text="Clitoris",
                                       description="Clitoris")
    Ureter = PermissibleValue(text="Ureter",
                                   description="Ureter")
    Hippocampus = PermissibleValue(text="Hippocampus",
                                             description="Hippocampus")
    Eye = PermissibleValue(text="Eye",
                             description="Eye")
    Forearm = PermissibleValue(text="Forearm",
                                     description="Forearm")
    Testis = PermissibleValue(text="Testis",
                                   description="Testis")
    Femur = PermissibleValue(text="Femur",
                                 description="Femur")
    Liver = PermissibleValue(text="Liver",
                                 description="Liver")
    Scalp = PermissibleValue(text="Scalp",
                                 description="Scalp")
    Pelvis = PermissibleValue(text="Pelvis",
                                   description="Pelvis")
    Spleen = PermissibleValue(text="Spleen",
                                   description="Spleen")
    Rectum = PermissibleValue(text="Rectum",
                                   description="Rectum")
    Thyroid = PermissibleValue(text="Thyroid",
                                     description="Thyroid Gland")
    Lung = PermissibleValue(text="Lung",
                               description="Lung")
    Oropharynx = PermissibleValue(text="Oropharynx",
                                           description="Oropharynx")
    Epitrochlear = PermissibleValue(text="Epitrochlear")
    Uterus = PermissibleValue(text="Uterus",
                                   description="Uterus")
    Scrotum = PermissibleValue(text="Scrotum",
                                     description="Scrotum")
    Urethra = PermissibleValue(text="Urethra",
                                     description="Urethra")
    Uvula = PermissibleValue(text="Uvula",
                                 description="Uvula")
    Acetabulum = PermissibleValue(text="Acetabulum",
                                           description="Acetabulum")
    Trunk = PermissibleValue(text="Trunk",
                                 description="Trunk")
    Ganglia = PermissibleValue(text="Ganglia",
                                     description="Ganglion")
    Bowel = PermissibleValue(text="Bowel",
                                 description="Bowel")
    Nerve = PermissibleValue(text="Nerve",
                                 description="nerve")
    Tibia = PermissibleValue(text="Tibia",
                                 description="Tibia")
    Artery = PermissibleValue(text="Artery",
                                   description="Artery")
    Epididymis = PermissibleValue(text="Epididymis",
                                           description="Epididymis")
    Cecum = PermissibleValue(text="Cecum",
                                 description="Cecum")
    Muscle = PermissibleValue(text="Muscle",
                                   description="Muscle")
    Other = PermissibleValue(text="Other",
                                 description="Other")
    Pylorus = PermissibleValue(text="Pylorus",
                                     description="Pylorus")
    Colon = PermissibleValue(text="Colon",
                                 description="Colon")
    Skin = PermissibleValue(text="Skin",
                               description="Skin")
    Vulva = PermissibleValue(text="Vulva",
                                 description="Vulva")
    Cerebellum = PermissibleValue(text="Cerebellum",
                                           description="Cerebellum")
    Spine = PermissibleValue(text="Spine")
    Leg = PermissibleValue(text="Leg",
                             description="Leg")
    Cervix = PermissibleValue(text="Cervix",
                                   description="Cervix")
    Foot = PermissibleValue(text="Foot",
                               description="Foot")
    Brow = PermissibleValue(text="Brow",
                               description="Eyebrow")
    Hip = PermissibleValue(text="Hip",
                             description="Hip")
    Bronchus = PermissibleValue(text="Bronchus",
                                       description="Bronchus")
    Jejunum = PermissibleValue(text="Jejunum",
                                     description="Jejunum")
    Jaw = PermissibleValue(text="Jaw",
                             description="Jaw")
    Tendon = PermissibleValue(text="Tendon",
                                   description="Tendon")
    Mandible = PermissibleValue(text="Mandible",
                                       description="Mandible")
    Pineal = PermissibleValue(text="Pineal",
                                   description="Pineal")
    Omentum = PermissibleValue(text="Omentum",
                                     description="Omentum")
    Patella = PermissibleValue(text="Patella",
                                     description="Patella")
    Adipose = PermissibleValue(text="Adipose",
                                     description="Adipose Tissue")
    Duodenum = PermissibleValue(text="Duodenum",
                                       description="Duodenum")
    Mitochondria = PermissibleValue(text="Mitochondria",
                                               description="Mitochondrion")
    Mediastinum = PermissibleValue(text="Mediastinum",
                                             description="Mediastinum")
    Ilium = PermissibleValue(text="Ilium",
                                 description="Ilium")
    Knee = PermissibleValue(text="Knee",
                               description="Knee Joint")
    Diaphragm = PermissibleValue(text="Diaphragm",
                                         description="Diaphragm")
    Esophagus = PermissibleValue(text="Esophagus",
                                         description="Esophagus")
    Appendix = PermissibleValue(text="Appendix",
                                       description="Appendix")
    Sternum = PermissibleValue(text="Sternum",
                                     description="Sternum")
    Thigh = PermissibleValue(text="Thigh",
                                 description="Thigh")
    Pleura = PermissibleValue(text="Pleura",
                                   description="Pleura")
    Cardia = PermissibleValue(text="Cardia",
                                   description="Gastric Cardia")
    Dermal = PermissibleValue(text="Dermal",
                                   description="Dermal")
    Throat = PermissibleValue(text="Throat",
                                   description="Throat")
    Fibroblasts = PermissibleValue(text="Fibroblasts",
                                             description="Fibroblast")
    Fibula = PermissibleValue(text="Fibula",
                                   description="Fibula")
    Chin = PermissibleValue(text="Chin",
                               description="Mentum")
    Bladder = PermissibleValue(text="Bladder",
                                     description="Bladder")
    Retroperitoneum = PermissibleValue(text="Retroperitoneum",
                                                     description="Retroperitoneum")
    Pharynx = PermissibleValue(text="Pharynx",
                                     description="Pharynx")
    Mesothelium = PermissibleValue(text="Mesothelium",
                                             description="Mesothelium")
    Synovium = PermissibleValue(text="Synovium",
                                       description="Synovial Membrane")
    Adrenal = PermissibleValue(text="Adrenal",
                                     description="Adrenal Gland")
    Abdomen = PermissibleValue(text="Abdomen",
                                     description="Abdominal Cavity")
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    Effusion = PermissibleValue(text="Effusion",
                                       description="Effusion")
    Meninges = PermissibleValue(text="Meninges",
                                       description="Meninges")
    Trachea = PermissibleValue(text="Trachea",
                                     description="Trachea")
    Eyelid = PermissibleValue(text="Eyelid")
    Urachus = PermissibleValue(text="Urachus")
    Choroid = PermissibleValue(text="Choroid")
    Endometrium = PermissibleValue(text="Endometrium")
    Prepuce = PermissibleValue(text="Prepuce")
    Vallecula = PermissibleValue(text="Vallecula")
    Myometrium = PermissibleValue(text="Myometrium")
    Endocervix = PermissibleValue(text="Endocervix")
    Nipple = PermissibleValue(text="Nipple")
    Exocervix = PermissibleValue(text="Exocervix")
    Colorectal = PermissibleValue(text="Colorectal")
    Subglottis = PermissibleValue(text="Subglottis",
                                           description="Subglottis")
    Glottis = PermissibleValue(text="Glottis",
                                     description="Glottis")
    Supraglottis = PermissibleValue(text="Supraglottis",
                                               description="Supraglottis")

    _defn = EnumDefinition(
        name="EnumCRDCHBodySiteSite",
        description="Autogenerated Enumeration for CRDC-H BodySite site",
        code_set=None,
        code_set_version="2021-12-16T18:03:47.749381+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Brain Stem",
                PermissibleValue(text="Brain Stem",
                                 description="Brain Stem") )
        setattr(cls, "Lymph Node(s) Pelvic",
                PermissibleValue(text="Lymph Node(s) Pelvic",
                                 description="Pelvic Lymph Node") )
        setattr(cls, "Ocular Orbits",
                PermissibleValue(text="Ocular Orbits",
                                 description="Orbit") )
        setattr(cls, "Abdomen, total",
                PermissibleValue(text="Abdomen, total") )
        setattr(cls, "Femoral Vein",
                PermissibleValue(text="Femoral Vein",
                                 description="Femoral Vein") )
        setattr(cls, "Bone, non-spine",
                PermissibleValue(text="Bone, non-spine") )
        setattr(cls, "Head - Face Or Neck, Nos",
                PermissibleValue(text="Head - Face Or Neck, Nos") )
        setattr(cls, "Fundus of Stomach",
                PermissibleValue(text="Fundus of Stomach") )
        setattr(cls, "Amniotic Fluid",
                PermissibleValue(text="Amniotic Fluid",
                                 description="Amniotic Fluid") )
        setattr(cls, "Nasal Soft Tissue",
                PermissibleValue(text="Nasal Soft Tissue",
                                 description="Nasal Soft Tissue") )
        setattr(cls, "Lymph Node(s) Paraaortic",
                PermissibleValue(text="Lymph Node(s) Paraaortic") )
        setattr(cls, "Lymph Node",
                PermissibleValue(text="Lymph Node",
                                 description="Lymph node") )
        setattr(cls, "Lymph Node(s) Cervical",
                PermissibleValue(text="Lymph Node(s) Cervical",
                                 description="Cervical Lymph Node") )
        setattr(cls, "Lymph Node(s) Regional",
                PermissibleValue(text="Lymph Node(s) Regional") )
        setattr(cls, "Buccal Mucosa",
                PermissibleValue(text="Buccal Mucosa",
                                 description="Buccal Mucosa") )
        setattr(cls, "Skin, upper extremity, local",
                PermissibleValue(text="Skin, upper extremity, local") )
        setattr(cls, "Hepatic Duct",
                PermissibleValue(text="Hepatic Duct",
                                 description="Hepatic Duct") )
        setattr(cls, "Nasal Cavity",
                PermissibleValue(text="Nasal Cavity",
                                 description="Nasal Cavity") )
        setattr(cls, "Index Finger",
                PermissibleValue(text="Index Finger") )
        setattr(cls, "Fallopian Tube",
                PermissibleValue(text="Fallopian Tube",
                                 description="Fallopian tube") )
        setattr(cls, "Splenic Flexure",
                PermissibleValue(text="Splenic Flexure",
                                 description="Splenic Flexure") )
        setattr(cls, "Peritoneal Cavity",
                PermissibleValue(text="Peritoneal Cavity",
                                 description="Peritoneal Cavity") )
        setattr(cls, "Blood Vessel",
                PermissibleValue(text="Blood Vessel") )
        setattr(cls, "Lymph Node(s) Scalene",
                PermissibleValue(text="Lymph Node(s) Scalene") )
        setattr(cls, "Floor of Mouth",
                PermissibleValue(text="Floor of Mouth",
                                 description="Floor of Mouth") )
        setattr(cls, "Distant Site",
                PermissibleValue(text="Distant Site") )
        setattr(cls, "Broad Ligament",
                PermissibleValue(text="Broad Ligament",
                                 description="Broad Ligament") )
        setattr(cls, "Parotid Gland",
                PermissibleValue(text="Parotid Gland",
                                 description="Parotid Gland") )
        setattr(cls, "Spinal Cord",
                PermissibleValue(text="Spinal Cord",
                                 description="Spinal Cord") )
        setattr(cls, "Soft Tissue",
                PermissibleValue(text="Soft Tissue",
                                 description="Soft tissue") )
        setattr(cls, "Primary tumor site",
                PermissibleValue(text="Primary tumor site") )
        setattr(cls, "Buccal Cavity",
                PermissibleValue(text="Buccal Cavity",
                                 description="Buccal Cavity") )
        setattr(cls, "Aqueous Fluid",
                PermissibleValue(text="Aqueous Fluid",
                                 description="Aqueous Fluid") )
        setattr(cls, "Periorbital Soft Tissue",
                PermissibleValue(text="Periorbital Soft Tissue",
                                 description="Periorbital Soft Tissue") )
        setattr(cls, "Lymph Node(s) Hilar",
                PermissibleValue(text="Lymph Node(s) Hilar",
                                 description="Hilar Lymph Node") )
        setattr(cls, "Cerebral Cortex",
                PermissibleValue(text="Cerebral Cortex",
                                 description="Cerebral Cortex") )
        setattr(cls, "Lymph Node(s) Internal Mammary",
                PermissibleValue(text="Lymph Node(s) Internal Mammary",
                                 description="Internal Mammary Lymph Node") )
        setattr(cls, "Regional Site",
                PermissibleValue(text="Regional Site") )
        setattr(cls, "Esophagogastric Junction",
                PermissibleValue(text="Esophagogastric Junction") )
        setattr(cls, "Small Bowel - Mucosa Only",
                PermissibleValue(text="Small Bowel - Mucosa Only",
                                 description="Small Bowel Mucosa") )
        setattr(cls, "White Blood Cells",
                PermissibleValue(text="White Blood Cells",
                                 description="Leukocyte") )
        setattr(cls, "Lymph Node(s) Iliac-External",
                PermissibleValue(text="Lymph Node(s) Iliac-External") )
        setattr(cls, "Autonomic Nervous System",
                PermissibleValue(text="Autonomic Nervous System",
                                 description="Autonomic Nervous System") )
        setattr(cls, "Skin, lower extremity, local",
                PermissibleValue(text="Skin, lower extremity, local") )
        setattr(cls, "Sinus(es), Maxillary",
                PermissibleValue(text="Sinus(es), Maxillary",
                                 description="Maxillary Sinus") )
        setattr(cls, "Vas Deferens",
                PermissibleValue(text="Vas Deferens",
                                 description="Vas Deferens") )
        setattr(cls, "Skin, trunk, local",
                PermissibleValue(text="Skin, trunk, local") )
        setattr(cls, "Skin, total",
                PermissibleValue(text="Skin, total") )
        setattr(cls, "Ear, Pinna (External)",
                PermissibleValue(text="Ear, Pinna (External)",
                                 description="External Ear") )
        setattr(cls, "Epidural Space",
                PermissibleValue(text="Epidural Space",
                                 description="Epidural Spinal Canal Space") )
        setattr(cls, "Lymph Node(s) Mediastinal",
                PermissibleValue(text="Lymph Node(s) Mediastinal") )
        setattr(cls, "Carotid Body",
                PermissibleValue(text="Carotid Body",
                                 description="Carotid Body") )
        setattr(cls, "Antecubital Fossa",
                PermissibleValue(text="Antecubital Fossa",
                                 description="Antecubital Fossa") )
        setattr(cls, "Lymph Node(s) Axilla",
                PermissibleValue(text="Lymph Node(s) Axilla",
                                 description="Axillary Lymph Node") )
        setattr(cls, "Mediastinal Soft Tissue",
                PermissibleValue(text="Mediastinal Soft Tissue",
                                 description="Mediastinal Soft Tissue") )
        setattr(cls, "Lymph Node(s) Supraclavicular",
                PermissibleValue(text="Lymph Node(s) Supraclavicular",
                                 description="Supraclavicular Lymph Node") )
        setattr(cls, "Ring Finger",
                PermissibleValue(text="Ring Finger") )
        setattr(cls, "Bile Duct",
                PermissibleValue(text="Bile Duct",
                                 description="Bile Duct") )
        setattr(cls, "Frontal Lobe",
                PermissibleValue(text="Frontal Lobe",
                                 description="Frontal Lobe") )
        setattr(cls, "Frontal Cortex",
                PermissibleValue(text="Frontal Cortex",
                                 description="Frontal Lobe") )
        setattr(cls, "Head and Neck",
                PermissibleValue(text="Head and Neck") )
        setattr(cls, "Ampulla of Vater",
                PermissibleValue(text="Ampulla of Vater",
                                 description="Ampulla of Vater") )
        setattr(cls, "Connective Tissue",
                PermissibleValue(text="Connective Tissue",
                                 description="Connective Tissue") )
        setattr(cls, "Thoracic Spine",
                PermissibleValue(text="Thoracic Spine",
                                 description="Thoracic Spine") )
        setattr(cls, "Oral Cavity",
                PermissibleValue(text="Oral Cavity",
                                 description="Oral Cavity") )
        setattr(cls, "Middle Finger",
                PermissibleValue(text="Middle Finger") )
        setattr(cls, "Body, total",
                PermissibleValue(text="Body, total") )
        setattr(cls, "Chest Wall",
                PermissibleValue(text="Chest Wall",
                                 description="Chest Wall") )
        setattr(cls, "Central Nervous System",
                PermissibleValue(text="Central Nervous System",
                                 description="Central Nervous System") )
        setattr(cls, "Lymph Node(s) Retroperitoneal",
                PermissibleValue(text="Lymph Node(s) Retroperitoneal",
                                 description="Retroperitoneal Lymph Node") )
        setattr(cls, "Tonsil (Pharyngeal)",
                PermissibleValue(text="Tonsil (Pharyngeal)",
                                 description="Pharynx Tonsil") )
        setattr(cls, "Gastrointestinal, Intestine",
                PermissibleValue(text="Gastrointestinal, Intestine") )
        setattr(cls, "Anal Sphincter",
                PermissibleValue(text="Anal Sphincter",
                                 description="Anal Sphincter") )
        setattr(cls, "Occipital Cortex",
                PermissibleValue(text="Occipital Cortex",
                                 description="Occipital Lobe") )
        setattr(cls, "Lymph Node(s) Mammary",
                PermissibleValue(text="Lymph Node(s) Mammary",
                                 description="Mammary Lymph Node") )
        setattr(cls, "Ileocecal Valve",
                PermissibleValue(text="Ileocecal Valve",
                                 description="Ileocecal Valve") )
        setattr(cls, "Skeletal Muscle",
                PermissibleValue(text="Skeletal Muscle",
                                 description="Skeletal Muscle Tissue") )
        setattr(cls, "Paraspinal Ganglion",
                PermissibleValue(text="Paraspinal Ganglion",
                                 description="Spinal Ganglion") )
        setattr(cls, "Ear Canal",
                PermissibleValue(text="Ear Canal",
                                 description="Ear Canal") )
        setattr(cls, "Round Ligament",
                PermissibleValue(text="Round Ligament",
                                 description="Round Ligament") )
        setattr(cls, "Lymph Node(s) Inguinal",
                PermissibleValue(text="Lymph Node(s) Inguinal",
                                 description="Inguinal Lymph Node") )
        setattr(cls, "Auditory Canal",
                PermissibleValue(text="Auditory Canal",
                                 description="Auditory Canal") )
        setattr(cls, "Cervical Spine",
                PermissibleValue(text="Cervical Spine",
                                 description="Cervical Spine") )
        setattr(cls, "Stomach - Mucosa Only",
                PermissibleValue(text="Stomach - Mucosa Only",
                                 description="Stomach Mucosa") )
        setattr(cls, "Popliteal Fossa",
                PermissibleValue(text="Popliteal Fossa") )
        setattr(cls, "Colon - Mucosa Only",
                PermissibleValue(text="Colon - Mucosa Only",
                                 description="Colon Mucosa") )
        setattr(cls, "Esophagus - Mucosa Only",
                PermissibleValue(text="Esophagus - Mucosa Only",
                                 description="Esophagus Mucosa") )
        setattr(cls, "Retro-Orbital Region",
                PermissibleValue(text="Retro-Orbital Region",
                                 description="Retro-Orbital Region") )
        setattr(cls, "Trachea / Major Bronchi",
                PermissibleValue(text="Trachea / Major Bronchi",
                                 description="Trachea / Major Bronchi") )
        setattr(cls, "Prostate, Seminal Vesicles and Lymph Nodes",
                PermissibleValue(text="Prostate, Seminal Vesicles and Lymph Nodes") )
        setattr(cls, "Cerebrospinal Fluid",
                PermissibleValue(text="Cerebrospinal Fluid",
                                 description="Cerebrospinal Fluid") )
        setattr(cls, "Aortic Body",
                PermissibleValue(text="Aortic Body",
                                 description="Aortic Body") )
        setattr(cls, "Lymph Node(s) Femoral",
                PermissibleValue(text="Lymph Node(s) Femoral",
                                 description="Femoral Lymph Node") )
        setattr(cls, "Hard Palate",
                PermissibleValue(text="Hard Palate",
                                 description="Hard Palate") )
        setattr(cls, "Oral Cavity - Mucosa Only",
                PermissibleValue(text="Oral Cavity - Mucosa Only",
                                 description="Oral Cavity Mucosa") )
        setattr(cls, "Common Duct",
                PermissibleValue(text="Common Duct",
                                 description="Common Bile Duct") )
        setattr(cls, "Umbilical Cord",
                PermissibleValue(text="Umbilical Cord",
                                 description="Umbilical Cord") )
        setattr(cls, "Abdominal Wall",
                PermissibleValue(text="Abdominal Wall",
                                 description="Abdominal Wall") )
        setattr(cls, "Islet Cells",
                PermissibleValue(text="Islet Cells",
                                 description="Islet Cell") )
        setattr(cls, "Genitourinary, NOS",
                PermissibleValue(text="Genitourinary, NOS") )
        setattr(cls, "Salivary Gland",
                PermissibleValue(text="Salivary Gland",
                                 description="Salivary Gland") )
        setattr(cls, "Lymph Node(s) Occipital",
                PermissibleValue(text="Lymph Node(s) Occipital",
                                 description="Occipital Lymph Node") )
        setattr(cls, "Lymph Node(s) Parotid",
                PermissibleValue(text="Lymph Node(s) Parotid",
                                 description="Parotid Gland Lymph Node") )
        setattr(cls, "Lymph Node(s) Splenic",
                PermissibleValue(text="Lymph Node(s) Splenic",
                                 description="Splenic Lymph Node") )
        setattr(cls, "Rectosigmoid Junction",
                PermissibleValue(text="Rectosigmoid Junction",
                                 description="Rectosigmoid Region") )
        setattr(cls, "Lymph Node(s) Submandibular",
                PermissibleValue(text="Lymph Node(s) Submandibular",
                                 description="Submandibular Lymph Node") )
        setattr(cls, "Cell-Line",
                PermissibleValue(text="Cell-Line",
                                 description="Cell Line") )
        setattr(cls, "Ascending Colon",
                PermissibleValue(text="Ascending Colon",
                                 description="Ascending Colon") )
        setattr(cls, "Seminal Vesicle",
                PermissibleValue(text="Seminal Vesicle",
                                 description="Seminal Vesicle") )
        setattr(cls, "Temporal Cortex",
                PermissibleValue(text="Temporal Cortex",
                                 description="Temporal Lobe") )
        setattr(cls, "Pituitary Gland",
                PermissibleValue(text="Pituitary Gland",
                                 description="Pituitary Gland") )
        setattr(cls, "Bone Marrow",
                PermissibleValue(text="Bone Marrow",
                                 description="Bone Marrow") )
        setattr(cls, "Lymph Node(s) Iliac-Common",
                PermissibleValue(text="Lymph Node(s) Iliac-Common") )
        setattr(cls, "Endocrine Gland",
                PermissibleValue(text="Endocrine Gland",
                                 description="Endocrine Gland") )
        setattr(cls, "Subcutaneous Tissue",
                PermissibleValue(text="Subcutaneous Tissue",
                                 description="Subcutis") )
        setattr(cls, "Descending Colon",
                PermissibleValue(text="Descending Colon",
                                 description="Descending Colon") )
        setattr(cls, "Sciatic Nerve",
                PermissibleValue(text="Sciatic Nerve",
                                 description="Sciatic Nerve") )
        setattr(cls, "Spinal Column",
                PermissibleValue(text="Spinal Column",
                                 description="Vertebral Column") )
        setattr(cls, "Urinary Tract",
                PermissibleValue(text="Urinary Tract",
                                 description="Urinary System") )
        setattr(cls, "Lymph Node(s) Mesenteric",
                PermissibleValue(text="Lymph Node(s) Mesenteric",
                                 description="Mesenteric Lymph Node") )
        setattr(cls, "Alveolar Ridge",
                PermissibleValue(text="Alveolar Ridge",
                                 description="Alveolar Ridge") )
        setattr(cls, "Prostate Bed",
                PermissibleValue(text="Prostate Bed") )
        setattr(cls, "Pineal Gland",
                PermissibleValue(text="Pineal Gland",
                                 description="Pineal Gland") )
        setattr(cls, "Lacrimal Gland",
                PermissibleValue(text="Lacrimal Gland",
                                 description="Lacrimal Gland") )
        setattr(cls, "Lymph Node(s) Distant",
                PermissibleValue(text="Lymph Node(s) Distant") )
        setattr(cls, "Transverse Colon",
                PermissibleValue(text="Transverse Colon",
                                 description="Transverse Colon") )
        setattr(cls, "Femoral Artery",
                PermissibleValue(text="Femoral Artery",
                                 description="Femoral Artery") )
        setattr(cls, "Nerve(s) Cranial",
                PermissibleValue(text="Nerve(s) Cranial",
                                 description="Cranial Nerve") )
        setattr(cls, "Carotid Artery",
                PermissibleValue(text="Carotid Artery",
                                 description="Carotid Artery") )
        setattr(cls, "Hepatic Vein",
                PermissibleValue(text="Hepatic Vein",
                                 description="Hepatic Vein") )
        setattr(cls, "Small Bowel",
                PermissibleValue(text="Small Bowel",
                                 description="Small Intestine") )
        setattr(cls, "Ascending Colon Hepatic Flexure",
                PermissibleValue(text="Ascending Colon Hepatic Flexure",
                                 description="Ascending Colon Hepatic Flexure") )
        setattr(cls, "Primary Tumor Field",
                PermissibleValue(text="Primary Tumor Field") )
        setattr(cls, "Gastrointestinal Tract",
                PermissibleValue(text="Gastrointestinal Tract",
                                 description="Gastrointestinal Tract") )
        setattr(cls, "Small Finger",
                PermissibleValue(text="Small Finger") )
        setattr(cls, "Gastroesophageal Junction",
                PermissibleValue(text="Gastroesophageal Junction",
                                 description="Gastroesophageal Junction") )
        setattr(cls, "Large Bowel",
                PermissibleValue(text="Large Bowel",
                                 description="Large Intestine") )
        setattr(cls, "Lymph Node(s) Epitrochlear",
                PermissibleValue(text="Lymph Node(s) Epitrochlear",
                                 description="Epitrochlear Lymph Node") )
        setattr(cls, "Sigmoid Colon",
                PermissibleValue(text="Sigmoid Colon",
                                 description="Sigmoid Colon") )
        setattr(cls, "Lymph Node(s) Subclavicular",
                PermissibleValue(text="Lymph Node(s) Subclavicular",
                                 description="Infraclavicular Lymph Node") )
        setattr(cls, "Lymph Node(s) Popliteal",
                PermissibleValue(text="Lymph Node(s) Popliteal",
                                 description="Popliteal Lymph Node") )
        setattr(cls, "Lumbar Spine",
                PermissibleValue(text="Lumbar Spine",
                                 description="Lumbar Spine") )
        setattr(cls, "Not Allowed To Collect",
                PermissibleValue(text="Not Allowed To Collect") )
        setattr(cls, "Esophageal; Proximal",
                PermissibleValue(text="Esophageal; Proximal",
                                 description="Proximal Esophageal") )
        setattr(cls, "Lymph Nodes(s) Mediastinal",
                PermissibleValue(text="Lymph Nodes(s) Mediastinal") )
        setattr(cls, "Esophageal; Distal",
                PermissibleValue(text="Esophageal; Distal",
                                 description="Distal Esophageal") )
        setattr(cls, "Ampulla Of Vater",
                PermissibleValue(text="Ampulla Of Vater") )
        setattr(cls, "Fundus Of Stomach",
                PermissibleValue(text="Fundus Of Stomach") )
        setattr(cls, "Esophageal; Mid",
                PermissibleValue(text="Esophageal; Mid",
                                 description="Middle Esophageal") )
        setattr(cls, "Floor Of Mouth",
                PermissibleValue(text="Floor Of Mouth") )
        setattr(cls, "Hepatic Flexure",
                PermissibleValue(text="Hepatic Flexure",
                                 description="Hepatic Flexure") )
        setattr(cls, "Head & Neck",
                PermissibleValue(text="Head & Neck") )
        setattr(cls, "Other endocrine glands and related structures",
                PermissibleValue(text="Other endocrine glands and related structures",
                                 description="Other endocrine glands and related structures") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported",
                                 description="Not Reported") )
        setattr(cls, "Parotid gland",
                PermissibleValue(text="Parotid gland",
                                 description="Parotid Gland") )
        setattr(cls, "Peripheral nerves and autonomic nervous system",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system",
                                 description="Peripheral Nerve and Autonomic Nervous System") )
        setattr(cls, "Eye and adnexa",
                PermissibleValue(text="Eye and adnexa",
                                 description="Adnexa And Eye") )
        setattr(cls, "Corpus uteri",
                PermissibleValue(text="Corpus uteri",
                                 description="Corpus Uteri") )
        setattr(cls, "Other and unspecified male genital organs",
                PermissibleValue(text="Other and unspecified male genital organs",
                                 description="Other and unspecified male genital organs") )
        setattr(cls, "Base of tongue",
                PermissibleValue(text="Base of tongue",
                                 description="Base of the Tongue") )
        setattr(cls, "Retroperitoneum and peritoneum",
                PermissibleValue(text="Retroperitoneum and peritoneum",
                                 description="Retroperitoneum and Peritoneum") )
        setattr(cls, "Uterus, NOS",
                PermissibleValue(text="Uterus, NOS",
                                 description="Not Otherwise Specified Uterus") )
        setattr(cls, "Lymph nodes",
                PermissibleValue(text="Lymph nodes",
                                 description="Lymph Node") )
        setattr(cls, "Other and ill-defined sites within respiratory system and intrathoracic organs",
                PermissibleValue(text="Other and ill-defined sites within respiratory system and intrathoracic organs",
                                 description="Other and ill-defined sites within respiratory system and intrathoracic organs") )
        setattr(cls, "Other and unspecified parts of tongue",
                PermissibleValue(text="Other and unspecified parts of tongue",
                                 description="Other and unspecified parts of tongue") )
        setattr(cls, "Small intestine",
                PermissibleValue(text="Small intestine",
                                 description="Small Intestine") )
        setattr(cls, "Other and ill-defined sites",
                PermissibleValue(text="Other and ill-defined sites",
                                 description="Other and ill-defined sites") )
        setattr(cls, "Floor of mouth",
                PermissibleValue(text="Floor of mouth") )
        setattr(cls, "Liver and intrahepatic bile ducts",
                PermissibleValue(text="Liver and intrahepatic bile ducts",
                                 description="Liver and Intrahepatic Bile Duct") )
        setattr(cls, "Other and ill-defined sites in lip, oral cavity and pharynx",
                PermissibleValue(text="Other and ill-defined sites in lip, oral cavity and pharynx",
                                 description="Other and ill-defined sites in lip, oral cavity and pharynx") )
        setattr(cls, "Rectosigmoid junction",
                PermissibleValue(text="Rectosigmoid junction",
                                 description="Rectosigmoid Region") )
        setattr(cls, "Other and ill-defined digestive organs",
                PermissibleValue(text="Other and ill-defined digestive organs",
                                 description="Other and ill-defined digestive organs") )
        setattr(cls, "Other and unspecified parts of biliary tract",
                PermissibleValue(text="Other and unspecified parts of biliary tract",
                                 description="Other and unspecified parts of biliary tract") )
        setattr(cls, "Bronchus and lung",
                PermissibleValue(text="Bronchus and lung",
                                 description="Bronchus and Lung") )
        setattr(cls, "Cervix uteri",
                PermissibleValue(text="Cervix uteri",
                                 description="Cervix Uteri") )
        setattr(cls, "Thyroid gland",
                PermissibleValue(text="Thyroid gland",
                                 description="Thyroid Gland") )
        setattr(cls, "Other and unspecified parts of mouth",
                PermissibleValue(text="Other and unspecified parts of mouth",
                                 description="Other and unspecified parts of mouth") )
        setattr(cls, "Spinal cord, cranial nerves, and other parts of central nervous system",
                PermissibleValue(text="Spinal cord, cranial nerves, and other parts of central nervous system",
                                 description="Spinal Cord Cranial Nerve and Other Central Nervous System") )
        setattr(cls, "Other and unspecified major salivary glands",
                PermissibleValue(text="Other and unspecified major salivary glands",
                                 description="Other and unspecified major salivary glands") )
        setattr(cls, "Pyriform sinus",
                PermissibleValue(text="Pyriform sinus",
                                 description="Pyriform Sinus") )
        setattr(cls, "Hematopoietic and reticuloendothelial systems",
                PermissibleValue(text="Hematopoietic and reticuloendothelial systems",
                                 description="Hematopoietic and Reticuloendothelial System") )
        setattr(cls, "Other and unspecified female genital organs",
                PermissibleValue(text="Other and unspecified female genital organs",
                                 description="Other and unspecified female genital organs") )
        setattr(cls, "Adrenal gland",
                PermissibleValue(text="Adrenal gland",
                                 description="Adrenal Gland") )
        setattr(cls, "Anus and anal canal",
                PermissibleValue(text="Anus and anal canal",
                                 description="Anus and Anal Canal") )
        setattr(cls, "Connective, subcutaneous and other soft tissues",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues",
                                 description="Connective, Subcutaneous and Other Soft Tissue") )
        setattr(cls, "Prostate gland",
                PermissibleValue(text="Prostate gland",
                                 description="Prostate Gland") )
        setattr(cls, "Renal pelvis",
                PermissibleValue(text="Renal pelvis",
                                 description="Renal Pelvis") )
        setattr(cls, "Bones, joints and articular cartilage of other and unspecified sites",
                PermissibleValue(text="Bones, joints and articular cartilage of other and unspecified sites",
                                 description="Bone, Joint ,Articular Cartilage of Other and Unspecified Anatomic Site") )
        setattr(cls, "Bones, joints and articular cartilage of limbs",
                PermissibleValue(text="Bones, joints and articular cartilage of limbs",
                                 description="Bone, Joint, Articular Cartilage of Limb") )
        setattr(cls, "Heart, mediastinum, and pleura",
                PermissibleValue(text="Heart, mediastinum, and pleura",
                                 description="Heart, Mediastinum and Pleura") )
        setattr(cls, "Accessory sinuses",
                PermissibleValue(text="Accessory sinuses",
                                 description="Paranasal Sinus") )
        setattr(cls, "Nasal cavity and middle ear",
                PermissibleValue(text="Nasal cavity and middle ear",
                                 description="Nasal Cavity and Middle Ear") )
        setattr(cls, "Other and unspecified urinary organs",
                PermissibleValue(text="Other and unspecified urinary organs",
                                 description="Other and unspecified urinary organs") )
        setattr(cls, "Lymph nodes of inguinal region or leg",
                PermissibleValue(text="Lymph nodes of inguinal region or leg") )
        setattr(cls, "Overlapping lesion of skin",
                PermissibleValue(text="Overlapping lesion of skin") )
        setattr(cls, "Fundus uteri",
                PermissibleValue(text="Fundus uteri") )
        setattr(cls, "Hard palate",
                PermissibleValue(text="Hard palate") )
        setattr(cls, "Ill-defined sites within respiratory system",
                PermissibleValue(text="Ill-defined sites within respiratory system") )
        setattr(cls, "Axillary tail of breast",
                PermissibleValue(text="Axillary tail of breast") )
        setattr(cls, "Overlapping lesion of respiratory system and intrathoracic organs",
                PermissibleValue(text="Overlapping lesion of respiratory system and intrathoracic organs") )
        setattr(cls, "Middle third of esophagus",
                PermissibleValue(text="Middle third of esophagus") )
        setattr(cls, "Bladder, NOS",
                PermissibleValue(text="Bladder, NOS") )
        setattr(cls, "Lower-outer quadrant of breast",
                PermissibleValue(text="Lower-outer quadrant of breast") )
        setattr(cls, "Craniopharyngeal duct",
                PermissibleValue(text="Craniopharyngeal duct") )
        setattr(cls, "Rectum, NOS",
                PermissibleValue(text="Rectum, NOS") )
        setattr(cls, "Overlapping lesion of larynx",
                PermissibleValue(text="Overlapping lesion of larynx") )
        setattr(cls, "Kidney, NOS",
                PermissibleValue(text="Kidney, NOS") )
        setattr(cls, "Paraurethral gland",
                PermissibleValue(text="Paraurethral gland") )
        setattr(cls, "Head, face or neck, NOS",
                PermissibleValue(text="Head, face or neck, NOS") )
        setattr(cls, "Other specified parts of pancreas",
                PermissibleValue(text="Other specified parts of pancreas") )
        setattr(cls, "Unknown primary site",
                PermissibleValue(text="Unknown primary site") )
        setattr(cls, "Tonsillar fossa",
                PermissibleValue(text="Tonsillar fossa") )
        setattr(cls, "Maxillary sinus",
                PermissibleValue(text="Maxillary sinus") )
        setattr(cls, "Waldeyer ring",
                PermissibleValue(text="Waldeyer ring") )
        setattr(cls, "Upper lobe, lung",
                PermissibleValue(text="Upper lobe, lung") )
        setattr(cls, "Labium majus",
                PermissibleValue(text="Labium majus") )
        setattr(cls, "Skin of lip, NOS",
                PermissibleValue(text="Skin of lip, NOS") )
        setattr(cls, "Upper-inner quadrant of breast",
                PermissibleValue(text="Upper-inner quadrant of breast") )
        setattr(cls, "Ciliary body",
                PermissibleValue(text="Ciliary body") )
        setattr(cls, "Head of pancreas",
                PermissibleValue(text="Head of pancreas") )
        setattr(cls, "Floor of mouth, NOS",
                PermissibleValue(text="Floor of mouth, NOS") )
        setattr(cls, "Transverse colon",
                PermissibleValue(text="Transverse colon") )
        setattr(cls, "Branchial cleft",
                PermissibleValue(text="Branchial cleft") )
        setattr(cls, "Pelvic bones, sacrum, coccyx and associated joints",
                PermissibleValue(text="Pelvic bones, sacrum, coccyx and associated joints") )
        setattr(cls, "Lacrimal gland",
                PermissibleValue(text="Lacrimal gland") )
        setattr(cls, "Nasopharynx, NOS",
                PermissibleValue(text="Nasopharynx, NOS") )
        setattr(cls, "Overlapping lesion of bones, joints and articular cartilage",
                PermissibleValue(text="Overlapping lesion of bones, joints and articular cartilage") )
        setattr(cls, "Retromolar area",
                PermissibleValue(text="Retromolar area") )
        setattr(cls, "Lung, NOS",
                PermissibleValue(text="Lung, NOS") )
        setattr(cls, "Skin of lower limb and hip",
                PermissibleValue(text="Skin of lower limb and hip") )
        setattr(cls, "Lymph nodes of axilla or arm",
                PermissibleValue(text="Lymph nodes of axilla or arm") )
        setattr(cls, "Upper respiratory tract, NOS",
                PermissibleValue(text="Upper respiratory tract, NOS") )
        setattr(cls, "Overlapping lesion of bones, joints and articular cartilage of limbs",
                PermissibleValue(text="Overlapping lesion of bones, joints and articular cartilage of limbs") )
        setattr(cls, "Spinal cord",
                PermissibleValue(text="Spinal cord") )
        setattr(cls, "Endocrine gland, NOS",
                PermissibleValue(text="Endocrine gland, NOS") )
        setattr(cls, "Penis, NOS",
                PermissibleValue(text="Penis, NOS") )
        setattr(cls, "Long bones of upper limb, scapula and associated joints",
                PermissibleValue(text="Long bones of upper limb, scapula and associated joints") )
        setattr(cls, "Overlapping lesion of breast",
                PermissibleValue(text="Overlapping lesion of breast") )
        setattr(cls, "Pleura, NOS",
                PermissibleValue(text="Pleura, NOS") )
        setattr(cls, "Skin of other and unspecified parts of face",
                PermissibleValue(text="Skin of other and unspecified parts of face") )
        setattr(cls, "Splenic flexure of colon",
                PermissibleValue(text="Splenic flexure of colon") )
        setattr(cls, "Cheek mucosa",
                PermissibleValue(text="Cheek mucosa") )
        setattr(cls, "Bone, NOS",
                PermissibleValue(text="Bone, NOS") )
        setattr(cls, "Cerebellum, NOS",
                PermissibleValue(text="Cerebellum, NOS") )
        setattr(cls, "Overlapping lesion of cervix uteri",
                PermissibleValue(text="Overlapping lesion of cervix uteri") )
        setattr(cls, "Sphenoid sinus",
                PermissibleValue(text="Sphenoid sinus") )
        setattr(cls, "Olfactory nerve",
                PermissibleValue(text="Olfactory nerve") )
        setattr(cls, "Connective, subcutaneous and other soft tissues, NOS",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues, NOS") )
        setattr(cls, "Overlapping lesion of major salivary glands",
                PermissibleValue(text="Overlapping lesion of major salivary glands") )
        setattr(cls, "Connective, subcutaneous and other soft tissues of head, face, and neck",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues of head, face, and neck") )
        setattr(cls, "Mouth, NOS",
                PermissibleValue(text="Mouth, NOS") )
        setattr(cls, "Overlapping lesion of small intestine",
                PermissibleValue(text="Overlapping lesion of small intestine") )
        setattr(cls, "Overlapping lesion of connective, subcutaneous and other soft tissues",
                PermissibleValue(text="Overlapping lesion of connective, subcutaneous and other soft tissues") )
        setattr(cls, "Ureteric orifice",
                PermissibleValue(text="Ureteric orifice") )
        setattr(cls, "Intrathoracic lymph nodes",
                PermissibleValue(text="Intrathoracic lymph nodes") )
        setattr(cls, "Biliary tract, NOS",
                PermissibleValue(text="Biliary tract, NOS") )
        setattr(cls, "Postcricoid region",
                PermissibleValue(text="Postcricoid region") )
        setattr(cls, "Connective, subcutaneous and other soft tissues of thorax",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues of thorax") )
        setattr(cls, "Lymph nodes of multiple regions",
                PermissibleValue(text="Lymph nodes of multiple regions") )
        setattr(cls, "Parietal lobe",
                PermissibleValue(text="Parietal lobe") )
        setattr(cls, "Anterior wall of bladder",
                PermissibleValue(text="Anterior wall of bladder") )
        setattr(cls, "Overlapping lesion of lip, oral cavity and pharynx",
                PermissibleValue(text="Overlapping lesion of lip, oral cavity and pharynx") )
        setattr(cls, "Other specified parts of female genital organs",
                PermissibleValue(text="Other specified parts of female genital organs") )
        setattr(cls, "Lower lobe, lung",
                PermissibleValue(text="Lower lobe, lung") )
        setattr(cls, "Mucosa of lower lip",
                PermissibleValue(text="Mucosa of lower lip") )
        setattr(cls, "Accessory sinus, NOS",
                PermissibleValue(text="Accessory sinus, NOS") )
        setattr(cls, "Ventral surface of tongue, NOS",
                PermissibleValue(text="Ventral surface of tongue, NOS") )
        setattr(cls, "Soft palate, NOS",
                PermissibleValue(text="Soft palate, NOS") )
        setattr(cls, "Tonsil, NOS",
                PermissibleValue(text="Tonsil, NOS") )
        setattr(cls, "Peripheral nerves and autonomic nervous system of head, face, and neck",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system of head, face, and neck") )
        setattr(cls, "Upper limb, NOS",
                PermissibleValue(text="Upper limb, NOS") )
        setattr(cls, "Small intestine, NOS",
                PermissibleValue(text="Small intestine, NOS") )
        setattr(cls, "Overlapping lesion of accessory sinuses",
                PermissibleValue(text="Overlapping lesion of accessory sinuses") )
        setattr(cls, "Palate, NOS",
                PermissibleValue(text="Palate, NOS") )
        setattr(cls, "Cervical esophagus",
                PermissibleValue(text="Cervical esophagus") )
        setattr(cls, "Body of stomach",
                PermissibleValue(text="Body of stomach") )
        setattr(cls, "Overlapping lesion of rectum, anus and anal canal",
                PermissibleValue(text="Overlapping lesion of rectum, anus and anal canal") )
        setattr(cls, "Cornea, NOS",
                PermissibleValue(text="Cornea, NOS") )
        setattr(cls, "Tongue, NOS",
                PermissibleValue(text="Tongue, NOS") )
        setattr(cls, "Pelvic lymph nodes",
                PermissibleValue(text="Pelvic lymph nodes") )
        setattr(cls, "Greater curvature of stomach, NOS",
                PermissibleValue(text="Greater curvature of stomach, NOS") )
        setattr(cls, "Cortex of adrenal gland",
                PermissibleValue(text="Cortex of adrenal gland") )
        setattr(cls, "Reticuloendothelial system, NOS",
                PermissibleValue(text="Reticuloendothelial system, NOS") )
        setattr(cls, "Hepatic flexure of colon",
                PermissibleValue(text="Hepatic flexure of colon") )
        setattr(cls, "Peripheral nerves and autonomic nervous system of pelvis",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system of pelvis") )
        setattr(cls, "Pancreatic neck",
                PermissibleValue(text="Pancreatic neck") )
        setattr(cls, "Lateral wall of bladder",
                PermissibleValue(text="Lateral wall of bladder") )
        setattr(cls, "Vertebral column",
                PermissibleValue(text="Vertebral column") )
        setattr(cls, "Anterior 2/3 of tongue, NOS",
                PermissibleValue(text="Anterior 2/3 of tongue, NOS") )
        setattr(cls, "Peripheral nerves and autonomic nervous system of lower limb and hip",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system of lower limb and hip") )
        setattr(cls, "Cauda equina",
                PermissibleValue(text="Cauda equina") )
        setattr(cls, "Middle lobe, lung",
                PermissibleValue(text="Middle lobe, lung") )
        setattr(cls, "Overlapping lesion of endocrine glands and related structures",
                PermissibleValue(text="Overlapping lesion of endocrine glands and related structures") )
        setattr(cls, "Upper third of esophagus",
                PermissibleValue(text="Upper third of esophagus") )
        setattr(cls, "Other specified parts of male genital organs",
                PermissibleValue(text="Other specified parts of male genital organs") )
        setattr(cls, "Glans penis",
                PermissibleValue(text="Glans penis") )
        setattr(cls, "Body of pancreas",
                PermissibleValue(text="Body of pancreas") )
        setattr(cls, "Bone marrow",
                PermissibleValue(text="Bone marrow") )
        setattr(cls, "Abdomen, NOS",
                PermissibleValue(text="Abdomen, NOS") )
        setattr(cls, "Esophagus, NOS",
                PermissibleValue(text="Esophagus, NOS") )
        setattr(cls, "Upper gum",
                PermissibleValue(text="Upper gum") )
        setattr(cls, "Peripheral nerves and autonomic nervous system of trunk, NOS",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system of trunk, NOS") )
        setattr(cls, "Breast, NOS",
                PermissibleValue(text="Breast, NOS") )
        setattr(cls, "Overlapping lesion of floor of mouth",
                PermissibleValue(text="Overlapping lesion of floor of mouth") )
        setattr(cls, "Anterior surface of epiglottis",
                PermissibleValue(text="Anterior surface of epiglottis") )
        setattr(cls, "Peripheral nerves and autonomic nervous system of upper limb and shoulder",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system of upper limb and shoulder") )
        setattr(cls, "Posterior wall of bladder",
                PermissibleValue(text="Posterior wall of bladder") )
        setattr(cls, "Cloacogenic zone",
                PermissibleValue(text="Cloacogenic zone") )
        setattr(cls, "Overlapping lesion of corpus uteri",
                PermissibleValue(text="Overlapping lesion of corpus uteri") )
        setattr(cls, "Other ill-defined sites",
                PermissibleValue(text="Other ill-defined sites") )
        setattr(cls, "Bladder neck",
                PermissibleValue(text="Bladder neck") )
        setattr(cls, "Posterior mediastinum",
                PermissibleValue(text="Posterior mediastinum") )
        setattr(cls, "External upper lip",
                PermissibleValue(text="External upper lip") )
        setattr(cls, "Pancreas, NOS",
                PermissibleValue(text="Pancreas, NOS") )
        setattr(cls, "Overlapping lesion of female genital organs",
                PermissibleValue(text="Overlapping lesion of female genital organs") )
        setattr(cls, "Overlapping lesion of pancreas",
                PermissibleValue(text="Overlapping lesion of pancreas") )
        setattr(cls, "Mucosa of lip, NOS",
                PermissibleValue(text="Mucosa of lip, NOS") )
        setattr(cls, "Optic nerve",
                PermissibleValue(text="Optic nerve") )
        setattr(cls, "Overlapping lesion of tonsil",
                PermissibleValue(text="Overlapping lesion of tonsil") )
        setattr(cls, "Carotid body",
                PermissibleValue(text="Carotid body") )
        setattr(cls, "Body of penis",
                PermissibleValue(text="Body of penis") )
        setattr(cls, "Skin of upper limb and shoulder",
                PermissibleValue(text="Skin of upper limb and shoulder") )
        setattr(cls, "Tail of pancreas",
                PermissibleValue(text="Tail of pancreas") )
        setattr(cls, "Oropharynx, NOS",
                PermissibleValue(text="Oropharynx, NOS") )
        setattr(cls, "Male genital organs, NOS",
                PermissibleValue(text="Male genital organs, NOS") )
        setattr(cls, "Anterior mediastinum",
                PermissibleValue(text="Anterior mediastinum") )
        setattr(cls, "Submandibular gland",
                PermissibleValue(text="Submandibular gland") )
        setattr(cls, "Ethmoid sinus",
                PermissibleValue(text="Ethmoid sinus") )
        setattr(cls, "Anterior floor of mouth",
                PermissibleValue(text="Anterior floor of mouth") )
        setattr(cls, "Thoracic esophagus",
                PermissibleValue(text="Thoracic esophagus") )
        setattr(cls, "Anal canal",
                PermissibleValue(text="Anal canal") )
        setattr(cls, "External ear",
                PermissibleValue(text="External ear") )
        setattr(cls, "Mediastinum, NOS",
                PermissibleValue(text="Mediastinum, NOS") )
        setattr(cls, "Fundus of stomach",
                PermissibleValue(text="Fundus of stomach") )
        setattr(cls, "Trigone of bladder",
                PermissibleValue(text="Trigone of bladder") )
        setattr(cls, "Hematopoietic system, NOS",
                PermissibleValue(text="Hematopoietic system, NOS") )
        setattr(cls, "Connective, subcutaneous and other soft tissues of trunk, NOS",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues of trunk, NOS") )
        setattr(cls, "Peripheral nerves and autonomic nervous system of thorax",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system of thorax") )
        setattr(cls, "Hypopharynx, NOS",
                PermissibleValue(text="Hypopharynx, NOS") )
        setattr(cls, "Posterior wall of nasopharynx",
                PermissibleValue(text="Posterior wall of nasopharynx") )
        setattr(cls, "Brain stem",
                PermissibleValue(text="Brain stem") )
        setattr(cls, "Main bronchus",
                PermissibleValue(text="Main bronchus") )
        setattr(cls, "Border of tongue",
                PermissibleValue(text="Border of tongue") )
        setattr(cls, "Lower third of esophagus",
                PermissibleValue(text="Lower third of esophagus") )
        setattr(cls, "Overlapping lesion of brain",
                PermissibleValue(text="Overlapping lesion of brain") )
        setattr(cls, "Lateral floor of mouth",
                PermissibleValue(text="Lateral floor of mouth") )
        setattr(cls, "Thorax, NOS",
                PermissibleValue(text="Thorax, NOS") )
        setattr(cls, "Lip, NOS",
                PermissibleValue(text="Lip, NOS") )
        setattr(cls, "Pelvis, NOS",
                PermissibleValue(text="Pelvis, NOS") )
        setattr(cls, "Sublingual gland",
                PermissibleValue(text="Sublingual gland") )
        setattr(cls, "Overlapping lesion of hypopharynx",
                PermissibleValue(text="Overlapping lesion of hypopharynx") )
        setattr(cls, "Brain, NOS",
                PermissibleValue(text="Brain, NOS") )
        setattr(cls, "Nervous system, NOS",
                PermissibleValue(text="Nervous system, NOS") )
        setattr(cls, "Islets of Langerhans",
                PermissibleValue(text="Islets of Langerhans") )
        setattr(cls, "Extrahepatic bile duct",
                PermissibleValue(text="Extrahepatic bile duct") )
        setattr(cls, "Dome of bladder",
                PermissibleValue(text="Dome of bladder") )
        setattr(cls, "Bone of limb, NOS",
                PermissibleValue(text="Bone of limb, NOS") )
        setattr(cls, "Overlapping lesion of lip",
                PermissibleValue(text="Overlapping lesion of lip") )
        setattr(cls, "Pancreatic duct",
                PermissibleValue(text="Pancreatic duct") )
        setattr(cls, "Intestinal tract, NOS",
                PermissibleValue(text="Intestinal tract, NOS") )
        setattr(cls, "Overlapping lesion of bladder",
                PermissibleValue(text="Overlapping lesion of bladder") )
        setattr(cls, "Overlapping lesion of peripheral nerves and autonomic nervous system",
                PermissibleValue(text="Overlapping lesion of peripheral nerves and autonomic nervous system") )
        setattr(cls, "Uterine adnexa",
                PermissibleValue(text="Uterine adnexa") )
        setattr(cls, "Larynx, NOS",
                PermissibleValue(text="Larynx, NOS") )
        setattr(cls, "Cerebral meninges",
                PermissibleValue(text="Cerebral meninges") )
        setattr(cls, "Lower-inner quadrant of breast",
                PermissibleValue(text="Lower-inner quadrant of breast") )
        setattr(cls, "Meninges, NOS",
                PermissibleValue(text="Meninges, NOS") )
        setattr(cls, "Descended testis",
                PermissibleValue(text="Descended testis") )
        setattr(cls, "Upper-outer quadrant of breast",
                PermissibleValue(text="Upper-outer quadrant of breast") )
        setattr(cls, "Overlapping lesions of oropharynx",
                PermissibleValue(text="Overlapping lesions of oropharynx") )
        setattr(cls, "Gastrointestinal tract, NOS",
                PermissibleValue(text="Gastrointestinal tract, NOS") )
        setattr(cls, "Lateral wall of oropharynx",
                PermissibleValue(text="Lateral wall of oropharynx") )
        setattr(cls, "Intrahepatic bile duct",
                PermissibleValue(text="Intrahepatic bile duct") )
        setattr(cls, "Intra-abdominal lymph nodes",
                PermissibleValue(text="Intra-abdominal lymph nodes") )
        setattr(cls, "Gum, NOS",
                PermissibleValue(text="Gum, NOS") )
        setattr(cls, "Overlapping lesion of brain and central nervous system",
                PermissibleValue(text="Overlapping lesion of brain and central nervous system") )
        setattr(cls, "Overlapping lesion of biliary tract",
                PermissibleValue(text="Overlapping lesion of biliary tract") )
        setattr(cls, "Specified parts of peritoneum",
                PermissibleValue(text="Specified parts of peritoneum") )
        setattr(cls, "Fallopian tube",
                PermissibleValue(text="Fallopian tube") )
        setattr(cls, "Ascending colon",
                PermissibleValue(text="Ascending colon") )
        setattr(cls, "Cardia, NOS",
                PermissibleValue(text="Cardia, NOS") )
        setattr(cls, "Overlapping lesion of eye and adnexa",
                PermissibleValue(text="Overlapping lesion of eye and adnexa") )
        setattr(cls, "Connective, subcutaneous and other soft tissues of pelvis",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues of pelvis") )
        setattr(cls, "Central portion of breast",
                PermissibleValue(text="Central portion of breast") )
        setattr(cls, "Abdominal esophagus",
                PermissibleValue(text="Abdominal esophagus") )
        setattr(cls, "Overlapping lesion of urinary organs",
                PermissibleValue(text="Overlapping lesion of urinary organs") )
        setattr(cls, "Commissure of lip",
                PermissibleValue(text="Commissure of lip") )
        setattr(cls, "Spinal meninges",
                PermissibleValue(text="Spinal meninges") )
        setattr(cls, "Short bones of upper limb and associated joints",
                PermissibleValue(text="Short bones of upper limb and associated joints") )
        setattr(cls, "Female genital tract, NOS",
                PermissibleValue(text="Female genital tract, NOS") )
        setattr(cls, "Urinary system, NOS",
                PermissibleValue(text="Urinary system, NOS") )
        setattr(cls, "Bones of skull and face and associated joints",
                PermissibleValue(text="Bones of skull and face and associated joints") )
        setattr(cls, "Peritoneum, NOS",
                PermissibleValue(text="Peritoneum, NOS") )
        setattr(cls, "Aortic body and other paraganglia",
                PermissibleValue(text="Aortic body and other paraganglia") )
        setattr(cls, "Round ligament",
                PermissibleValue(text="Round ligament") )
        setattr(cls, "Lower gum",
                PermissibleValue(text="Lower gum") )
        setattr(cls, "Overlapping lesion of male genital organs",
                PermissibleValue(text="Overlapping lesion of male genital organs") )
        setattr(cls, "Cranial nerve, NOS",
                PermissibleValue(text="Cranial nerve, NOS") )
        setattr(cls, "Major salivary gland, NOS",
                PermissibleValue(text="Major salivary gland, NOS") )
        setattr(cls, "Autonomic nervous system, NOS",
                PermissibleValue(text="Autonomic nervous system, NOS") )
        setattr(cls, "Pituitary gland",
                PermissibleValue(text="Pituitary gland") )
        setattr(cls, "Superior wall of nasopharynx",
                PermissibleValue(text="Superior wall of nasopharynx") )
        setattr(cls, "Posterior wall of oropharynx",
                PermissibleValue(text="Posterior wall of oropharynx") )
        setattr(cls, "Overlapping lesion of nasopharynx",
                PermissibleValue(text="Overlapping lesion of nasopharynx") )
        setattr(cls, "External lip, NOS",
                PermissibleValue(text="External lip, NOS") )
        setattr(cls, "Short bones of lower limb and associated joints",
                PermissibleValue(text="Short bones of lower limb and associated joints") )
        setattr(cls, "Anterior wall of nasopharynx",
                PermissibleValue(text="Anterior wall of nasopharynx") )
        setattr(cls, "Sigmoid colon",
                PermissibleValue(text="Sigmoid colon") )
        setattr(cls, "Descending colon",
                PermissibleValue(text="Descending colon") )
        setattr(cls, "Anus, NOS",
                PermissibleValue(text="Anus, NOS") )
        setattr(cls, "Rib, sternum, clavicle and associated joints",
                PermissibleValue(text="Rib, sternum, clavicle and associated joints") )
        setattr(cls, "Lingual tonsil",
                PermissibleValue(text="Lingual tonsil") )
        setattr(cls, "Adrenal gland, NOS",
                PermissibleValue(text="Adrenal gland, NOS") )
        setattr(cls, "Temporal lobe",
                PermissibleValue(text="Temporal lobe") )
        setattr(cls, "Spermatic cord",
                PermissibleValue(text="Spermatic cord") )
        setattr(cls, "Vagina, NOS",
                PermissibleValue(text="Vagina, NOS") )
        setattr(cls, "Stomach, NOS",
                PermissibleValue(text="Stomach, NOS") )
        setattr(cls, "Overlapping lesion of retroperitoneum and peritoneum",
                PermissibleValue(text="Overlapping lesion of retroperitoneum and peritoneum") )
        setattr(cls, "Acoustic nerve",
                PermissibleValue(text="Acoustic nerve") )
        setattr(cls, "Hypopharyngeal aspect of aryepiglottic fold",
                PermissibleValue(text="Hypopharyngeal aspect of aryepiglottic fold") )
        setattr(cls, "Parathyroid gland",
                PermissibleValue(text="Parathyroid gland") )
        setattr(cls, "Connective, subcutaneous and other soft tissues of abdomen",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues of abdomen") )
        setattr(cls, "Base of tongue, NOS",
                PermissibleValue(text="Base of tongue, NOS") )
        setattr(cls, "Overlapping lesion of penis",
                PermissibleValue(text="Overlapping lesion of penis") )
        setattr(cls, "Gastric antrum",
                PermissibleValue(text="Gastric antrum") )
        setattr(cls, "Lateral wall of nasopharynx",
                PermissibleValue(text="Lateral wall of nasopharynx") )
        setattr(cls, "Posterior wall of hypopharynx",
                PermissibleValue(text="Posterior wall of hypopharynx") )
        setattr(cls, "Broad ligament",
                PermissibleValue(text="Broad ligament") )
        setattr(cls, "Lower limb, NOS",
                PermissibleValue(text="Lower limb, NOS") )
        setattr(cls, "Skin of scalp and neck",
                PermissibleValue(text="Skin of scalp and neck") )
        setattr(cls, "Overlapping lesion of palate",
                PermissibleValue(text="Overlapping lesion of palate") )
        setattr(cls, "Laryngeal cartilage",
                PermissibleValue(text="Laryngeal cartilage") )
        setattr(cls, "Frontal lobe",
                PermissibleValue(text="Frontal lobe") )
        setattr(cls, "Pharynx, NOS",
                PermissibleValue(text="Pharynx, NOS") )
        setattr(cls, "Scrotum, NOS",
                PermissibleValue(text="Scrotum, NOS") )
        setattr(cls, "Lymph node, NOS",
                PermissibleValue(text="Lymph node, NOS") )
        setattr(cls, "Nasal cavity",
                PermissibleValue(text="Nasal cavity") )
        setattr(cls, "Connective, subcutaneous and other soft tissues of upper limb and shoulder",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues of upper limb and shoulder") )
        setattr(cls, "Overlapping lesion of lung",
                PermissibleValue(text="Overlapping lesion of lung") )
        setattr(cls, "Middle ear",
                PermissibleValue(text="Middle ear") )
        setattr(cls, "Ventricle, NOS",
                PermissibleValue(text="Ventricle, NOS") )
        setattr(cls, "Connective, subcutaneous and other soft tissues of lower limb and hip",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues of lower limb and hip") )
        setattr(cls, "Skin of trunk",
                PermissibleValue(text="Skin of trunk") )
        setattr(cls, "Overlapping lesion of stomach",
                PermissibleValue(text="Overlapping lesion of stomach") )
        setattr(cls, "Undescended testis",
                PermissibleValue(text="Undescended testis") )
        setattr(cls, "Skin, NOS",
                PermissibleValue(text="Skin, NOS") )
        setattr(cls, "Vulva, NOS",
                PermissibleValue(text="Vulva, NOS") )
        setattr(cls, "Dorsal surface of tongue, NOS",
                PermissibleValue(text="Dorsal surface of tongue, NOS") )
        setattr(cls, "Overlapping lesion of other and unspecified parts of mouth",
                PermissibleValue(text="Overlapping lesion of other and unspecified parts of mouth") )
        setattr(cls, "External lower lip",
                PermissibleValue(text="External lower lip") )
        setattr(cls, "Occipital lobe",
                PermissibleValue(text="Occipital lobe") )
        setattr(cls, "Overlapping lesion of digestive system",
                PermissibleValue(text="Overlapping lesion of digestive system") )
        setattr(cls, "Overlapping lesion of tongue",
                PermissibleValue(text="Overlapping lesion of tongue") )
        setattr(cls, "Frontal sinus",
                PermissibleValue(text="Frontal sinus") )
        setattr(cls, "Colon, NOS",
                PermissibleValue(text="Colon, NOS") )
        setattr(cls, "Lymph nodes of head, face and neck",
                PermissibleValue(text="Lymph nodes of head, face and neck") )
        setattr(cls, "Orbit, NOS",
                PermissibleValue(text="Orbit, NOS") )
        setattr(cls, "Lesser curvature of stomach, NOS",
                PermissibleValue(text="Lesser curvature of stomach, NOS") )
        setattr(cls, "Mucosa of upper lip",
                PermissibleValue(text="Mucosa of upper lip") )
        setattr(cls, "Long bones of lower limb and associated joints",
                PermissibleValue(text="Long bones of lower limb and associated joints") )
        setattr(cls, "Eye, NOS",
                PermissibleValue(text="Eye, NOS") )
        setattr(cls, "Meckel diverticulum",
                PermissibleValue(text="Meckel diverticulum") )
        setattr(cls, "Pineal gland",
                PermissibleValue(text="Pineal gland") )
        setattr(cls, "Overlapping lesion of heart, mediastinum and pleura",
                PermissibleValue(text="Overlapping lesion of heart, mediastinum and pleura") )
        setattr(cls, "Labium minus",
                PermissibleValue(text="Labium minus") )
        setattr(cls, "Overlapping lesion of vulva",
                PermissibleValue(text="Overlapping lesion of vulva") )
        setattr(cls, "Isthmus uteri",
                PermissibleValue(text="Isthmus uteri") )
        setattr(cls, "Overlapping lesion of colon",
                PermissibleValue(text="Overlapping lesion of colon") )
        setattr(cls, "Testis, NOS",
                PermissibleValue(text="Testis, NOS") )
        setattr(cls, "Medulla of adrenal gland",
                PermissibleValue(text="Medulla of adrenal gland") )
        setattr(cls, "Tonsillar pillar",
                PermissibleValue(text="Tonsillar pillar") )
        setattr(cls, "Peripheral nerves and autonomic nervous system of abdomen",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system of abdomen") )
        setattr(cls, "Overlapping lesion of ill-defined sites",
                PermissibleValue(text="Overlapping lesion of ill-defined sites") )
        setattr(cls, "Vestibule of mouth",
                PermissibleValue(text="Vestibule of mouth") )
        setattr(cls, "Overlapping lesion of esophagus",
                PermissibleValue(text="Overlapping lesion of esophagus") )
        setattr(cls, "Nervous System",
                PermissibleValue(text="Nervous System") )
        setattr(cls, "Not Applicable",
                PermissibleValue(text="Not Applicable") )
        setattr(cls, "Adrenal Gland",
                PermissibleValue(text="Adrenal Gland") )
        setattr(cls, "Lymph Nodes",
                PermissibleValue(text="Lymph Nodes") )
        setattr(cls, "Paranasal Sinuses",
                PermissibleValue(text="Paranasal Sinuses") )
        setattr(cls, "Sublingual Gland",
                PermissibleValue(text="Sublingual Gland") )
        setattr(cls, "Submandibular Gland",
                PermissibleValue(text="Submandibular Gland") )

class EnumCRDCHBodySiteQualifier(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H BodySite qualifier
    """
    Left = PermissibleValue(text="Left",
                               description="Left")
    Bilateral = PermissibleValue(text="Bilateral",
                                         description="Bilateral")
    Unknown = PermissibleValue(text="Unknown")
    Right = PermissibleValue(text="Right",
                                 description="Right")

    _defn = EnumDefinition(
        name="EnumCRDCHBodySiteQualifier",
        description="Autogenerated Enumeration for CRDC-H BodySite qualifier",
        code_set=None,
        code_set_version="2021-12-16T18:03:50.851596+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )

class EnumCRDCHBiologicProductProductType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H BiologicProduct product_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHBiologicProductProductType",
        description="Autogenerated Enumeration for CRDC-H BiologicProduct product_type",
        code_set=None,
        code_set_version="2021-12-16T18:03:50.998844+00:00",
    )

class EnumCRDCHCancerGradeObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerGradeObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerGradeObservationCategory",
        description="Autogenerated Enumeration for CRDC-H CancerGradeObservation category",
        code_set=None,
        code_set_version="2021-12-16T18:03:51.135762+00:00",
    )

class EnumCRDCHCancerGradeObservationObservationType(EnumDefinitionImpl):

    enneking_msts_grade = PermissibleValue(text="enneking_msts_grade",
                                                             description="The text term used to describe the surgical grade of the musculoskeletal sarcoma, using the Enneking staging system approved by the Musculoskeletal Tumor Society (MSTS).")
    esophageal_columnar_dysplasia_degree = PermissibleValue(text="esophageal_columnar_dysplasia_degree",
                                                                                               description="Text term to describe the amount of dysplasia found within the benign esophageal columnar mucosa.")
    inpc_grade = PermissibleValue(text="inpc_grade",
                                           description="Text term used to describe the classification of neuroblastic differentiation within neuroblastoma tumors, as defined by the International Neuroblastoma Pathology Classification (INPC).")
    gleason_grade_group = PermissibleValue(text="gleason_grade_group",
                                                             description="The text term used to describe the overall grouping of grades defined by the Gleason grading classification, which is used to determine the aggressiveness of prostate cancer. Note that this grade describes the entire prostatectomy specimen and is not specific to the sample used for sequencing.")
    primary_gleason_grade = PermissibleValue(text="primary_gleason_grade",
                                                                 description="The text term used to describe the primary Gleason score, which describes the pattern of cells making up the largest area of the tumor. The primary and secondary Gleason pattern grades are combined to determine the patient's Gleason grade group, which is used to determine the aggressiveness of prostate cancer. Note that this grade describes the entire prostatectomy specimen and is not specific to the sample used for sequencing.")
    secondary_gleason_grade = PermissibleValue(text="secondary_gleason_grade",
                                                                     description="The text term used to describe the secondary Gleason score, which describes the pattern of cells making up the second largest area of the tumor. The primary and secondary Gleason pattern grades are combined to determine the patient's Gleason grade group, which is used to determine the aggressiveness of prostate cancer. Note that this grade describes the entire prostatectomy specimen and is not specific to the sample used for sequencing.")
    tumor_grade = PermissibleValue(text="tumor_grade",
                                             description="Text value to express the degree of abnormality of cancer cells, a measure of differentiation and aggressiveness.")

    _defn = EnumDefinition(
        name="EnumCRDCHCancerGradeObservationObservationType",
    )

class EnumCRDCHCancerGradeObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerGradeObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerGradeObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H CancerGradeObservation method_type",
        code_set=None,
        code_set_version="2021-12-16T18:03:51.400069+00:00",
    )

class EnumCRDCHCancerGradeObservationValueCodeableConcept(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerGradeObservation value_codeable_concept
    """
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    Differentiating = PermissibleValue(text="Differentiating",
                                                     description="Differentiating Neuroblastoma")
    Undifferentiated = PermissibleValue(text="Undifferentiated",
                                                       description="Undifferentiated Neuroblastoma")
    G4 = PermissibleValue(text="G4",
                           description="Undifferentiated Histology")
    G1 = PermissibleValue(text="G1",
                           description="Well Differentiated")
    GX = PermissibleValue(text="GX",
                           description="Grade Cannot be Assessed")
    GB = PermissibleValue(text="GB",
                           description="Borderline Histologic Grade")
    G3 = PermissibleValue(text="G3",
                           description="Poorly Differentiated")
    G2 = PermissibleValue(text="G2",
                           description="Moderately Differentiated")

    _defn = EnumDefinition(
        name="EnumCRDCHCancerGradeObservationValueCodeableConcept",
        description="Autogenerated Enumeration for CRDC-H CancerGradeObservation value_codeable_concept",
        code_set=None,
        code_set_version="2021-12-16T18:03:51.528534+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Group 2",
                PermissibleValue(text="Group 2") )
        setattr(cls, "Group 4",
                PermissibleValue(text="Group 4") )
        setattr(cls, "Group 1",
                PermissibleValue(text="Group 1") )
        setattr(cls, "Group 5",
                PermissibleValue(text="Group 5") )
        setattr(cls, "Group 3",
                PermissibleValue(text="Group 3") )
        setattr(cls, "Poorly Differentiated",
                PermissibleValue(text="Poorly Differentiated",
                                 description="Poorly Differentiated Neuroblastoma") )
        setattr(cls, "not reported",
                PermissibleValue(text="not reported") )
        setattr(cls, "Low Grade",
                PermissibleValue(text="Low Grade",
                                 description="Low Grade") )
        setattr(cls, "High Grade",
                PermissibleValue(text="High Grade",
                                 description="High Grade") )
        setattr(cls, "High Grade Dysplasia",
                PermissibleValue(text="High Grade Dysplasia") )
        setattr(cls, "Negative/ No Dysplasia",
                PermissibleValue(text="Negative/ No Dysplasia") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported",
                                 description="Not Reported") )
        setattr(cls, "Indefinite for Dysplasia",
                PermissibleValue(text="Indefinite for Dysplasia") )
        setattr(cls, "Low Grade Dysplasia",
                PermissibleValue(text="Low Grade Dysplasia") )
        setattr(cls, "Pattern 2",
                PermissibleValue(text="Pattern 2") )
        setattr(cls, "Pattern 3",
                PermissibleValue(text="Pattern 3") )
        setattr(cls, "Pattern 1",
                PermissibleValue(text="Pattern 1") )
        setattr(cls, "Pattern 5",
                PermissibleValue(text="Pattern 5") )
        setattr(cls, "Pattern 4",
                PermissibleValue(text="Pattern 4") )
        setattr(cls, "High Grade (G2)",
                PermissibleValue(text="High Grade (G2)",
                                 description="Enneking High Surgical Grade") )
        setattr(cls, "Low Grade (G1)",
                PermissibleValue(text="Low Grade (G1)",
                                 description="Enneking Low Surgical Grade") )
        setattr(cls, "Intermediate Grade",
                PermissibleValue(text="Intermediate Grade",
                                 description="Intermediate Grade") )

class EnumCRDCHCancerGradeObservationSetCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerGradeObservationSet category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerGradeObservationSetCategory",
        description="Autogenerated Enumeration for CRDC-H CancerGradeObservationSet category",
        code_set=None,
        code_set_version="2021-12-16T18:03:51.780008+00:00",
    )

class EnumCRDCHCancerGradeObservationSetMethodType(EnumDefinitionImpl):
    """
    A morphologic classification system of malignant tumors, usually relating to disease progression and clinical
    outcome. It is based upon the presence or absence of several morphologic parameters, including tumor cell
    necrosis, cytologic atypia, nuclear pleomorphism and mitotic figures, the architectural infiltrating patterns, and
    the degree of tumor cell differentiation. Malignant tumors usually are graded I-III
    """
    Gleason = PermissibleValue(text="Gleason",
                                     description="A grading system for prostatic carcinoma based on the microscopic glandular architectural patterns of the malignant epithelial cells. Nuclear atypia is not evaluated. It defines five patterns or grades which reflect decreasing differentiation.")
    INPC = PermissibleValue(text="INPC")

    _defn = EnumDefinition(
        name="EnumCRDCHCancerGradeObservationSetMethodType",
        description="A morphologic classification system of malignant tumors, usually relating to disease progression and clinical outcome. It is based upon the presence or absence of several morphologic parameters, including tumor cell necrosis, cytologic atypia, nuclear pleomorphism and mitotic figures, the architectural infiltrating patterns, and the degree of tumor cell differentiation. Malignant tumors usually are graded I-III",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Unspecified grading system",
                PermissibleValue(text="Unspecified grading system") )

class EnumCRDCHCancerStageObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerStageObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerStageObservationCategory",
        description="Autogenerated Enumeration for CRDC-H CancerStageObservation category",
        code_set=None,
        code_set_version="2021-12-16T18:03:52.072037+00:00",
    )

class EnumCRDCHCancerStageObservationObservationType(EnumDefinitionImpl):
    """
    Types of observations or components of a cancer staging assessment.
    """
    Overall = PermissibleValue(text="Overall",
                                     description="The overall stage of the disease")

    _defn = EnumDefinition(
        name="EnumCRDCHCancerStageObservationObservationType",
        description="Types of observations or components of a cancer staging assessment.",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Tumor (T)",
                PermissibleValue(text="Tumor (T)",
                                 description="T classifies the size or direct extent of the primary tumor") )
        setattr(cls, "Node (N)",
                PermissibleValue(text="Node (N)",
                                 description="N classifies the degree of spread to regional lymph nodes") )
        setattr(cls, "Metastasis (M)",
                PermissibleValue(text="Metastasis (M)",
                                 description="M classifies the presence of distant metastasis") )
        setattr(cls, "Clinical Overall",
                PermissibleValue(text="Clinical Overall",
                                 description="The overall stage of the disease; clinical stage is determined from evidence acquired before treatment (including clinical examination, imaging, endoscopy, biopsy, surgical exploration)") )
        setattr(cls, "Clinical Tumor (T)",
                PermissibleValue(text="Clinical Tumor (T)",
                                 description="T classifies the size or direct extent of the primary tumor; clinical stage is determined from evidence acquired before treatment (including clinical examination, imaging, endoscopy, biopsy, surgical exploration)") )
        setattr(cls, "Clinical Node (N)",
                PermissibleValue(text="Clinical Node (N)",
                                 description="N classifies the degree of spread to regional lymph nodes; clinical stage is determined from evidence acquired before treatment (including clinical examination, imaging, endoscopy, biopsy, surgical exploration)") )
        setattr(cls, "Clinical Metastasis (M)",
                PermissibleValue(text="Clinical Metastasis (M)",
                                 description="M classifies the presence of distant metastasis; clinical stage is determined from evidence acquired before treatment (including clinical examination, imaging, endoscopy, biopsy, surgical exploration)") )
        setattr(cls, "Pathological Overall",
                PermissibleValue(text="Pathological Overall",
                                 description="The overall stage of the disease; stage given by histopathologic examination of a surgical specimen") )
        setattr(cls, "Pathological Tumor (T)",
                PermissibleValue(text="Pathological Tumor (T)",
                                 description="T classifies the size or direct extent of the primary tumor; stage given by histopathologic examination of a surgical specimen") )
        setattr(cls, "Pathological Node (N)",
                PermissibleValue(text="Pathological Node (N)",
                                 description="N classifies the degree of spread to regional lymph nodes; stage given by histopathologic examination of a surgical specimen") )
        setattr(cls, "Pathological Metastasis (M)",
                PermissibleValue(text="Pathological Metastasis (M)",
                                 description="M classifies the presence of distant metastasis; stage given by histopathologic examination of a surgical specimen") )
        setattr(cls, "Ann Arbor Substage Modifier",
                PermissibleValue(text="Ann Arbor Substage Modifier",
                                 description="The substage classification modifiers amend each stage based on distinct features.") )

class EnumCRDCHCancerStageObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerStageObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerStageObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H CancerStageObservation method_type",
        code_set=None,
        code_set_version="2021-12-16T18:03:52.365338+00:00",
    )

class EnumCRDCHCancerStageObservationValueCodeableConcept(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerStageObservation value_codeable_concept
    """
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    Yes = PermissibleValue(text="Yes",
                             description="Yes")
    No = PermissibleValue(text="No",
                           description="No")
    M1a = PermissibleValue(text="M1a",
                             description="M1a Stage Finding")
    M1 = PermissibleValue(text="M1",
                           description="M1 Stage Finding")
    M1c = PermissibleValue(text="M1c",
                             description="M1c Stage Finding")
    MX = PermissibleValue(text="MX",
                           description="MX Stage Finding")
    M0 = PermissibleValue(text="M0",
                           description="M0 Stage Finding")
    M1b = PermissibleValue(text="M1b",
                             description="M1b Stage Finding")
    TX = PermissibleValue(text="TX",
                           description="TX Stage Finding")
    T3d = PermissibleValue(text="T3d",
                             description="T3d Stage Finding")
    T1a1 = PermissibleValue(text="T1a1",
                               description="Stage T1a1 Finding")
    Ta = PermissibleValue(text="Ta",
                           description="Ta Stage Finding")
    T2a1 = PermissibleValue(text="T2a1",
                               description="Stage T2a1 Finding")
    T1b = PermissibleValue(text="T1b",
                             description="T1b Stage Finding")
    T1c = PermissibleValue(text="T1c",
                             description="T1c Stage Finding")
    T1b2 = PermissibleValue(text="T1b2",
                               description="T1b2 Stage Finding")
    T2d = PermissibleValue(text="T2d",
                             description="T2d Stage Finding")
    T2c = PermissibleValue(text="T2c",
                             description="T2c Stage Finding")
    T2a = PermissibleValue(text="T2a",
                             description="T2a Stage Finding")
    T1b1 = PermissibleValue(text="T1b1",
                               description="T1b1 Stage Finding")
    T3 = PermissibleValue(text="T3",
                           description="T3 Stage Finding")
    T1 = PermissibleValue(text="T1",
                           description="T1 Stage Finding")
    T4a = PermissibleValue(text="T4a",
                             description="T4a Stage Finding")
    T2a2 = PermissibleValue(text="T2a2",
                               description="Stage T2a2 Finding")
    T0 = PermissibleValue(text="T0",
                           description="T0 Stage Finding")
    Tis = PermissibleValue(text="Tis",
                             description="Tis Stage Finding")
    T1mi = PermissibleValue(text="T1mi",
                               description="T1mi Stage Finding")
    T3a = PermissibleValue(text="T3a",
                             description="T3a Stage Finding")
    T4e = PermissibleValue(text="T4e",
                             description="T4e Stage Finding")
    T3b = PermissibleValue(text="T3b",
                             description="T3b Stage Finding")
    T1a2 = PermissibleValue(text="T1a2",
                               description="Stage T1a2 Finding")
    T4d = PermissibleValue(text="T4d",
                             description="T4d Stage Finding")
    T4c = PermissibleValue(text="T4c",
                             description="T4c Stage Finding")
    T2b = PermissibleValue(text="T2b",
                             description="T2b Stage Finding")
    T1a = PermissibleValue(text="T1a",
                             description="T1a Stage Finding")
    T4 = PermissibleValue(text="T4",
                           description="T4 Stage Finding")
    T4b = PermissibleValue(text="T4b",
                             description="T4b Stage Finding")
    T3c = PermissibleValue(text="T3c",
                             description="T3c Stage Finding")
    T2 = PermissibleValue(text="T2",
                           description="T2 Stage Finding")
    M1d = PermissibleValue(text="M1d")
    M2 = PermissibleValue(text="M2",
                           description="M2 Stage Finding")
    N1bIII = PermissibleValue(text="N1bIII",
                                   description="N1bIII Stage Finding")
    N2c = PermissibleValue(text="N2c",
                             description="N2c Stage Finding")
    N0 = PermissibleValue(text="N0",
                           description="N0 Stage Finding")
    N4 = PermissibleValue(text="N4",
                           description="N4 Stage Finding")
    N1bIV = PermissibleValue(text="N1bIV",
                                 description="N1bIV Stage Finding")
    N1b = PermissibleValue(text="N1b",
                             description="N1b Stage Finding")
    N2b = PermissibleValue(text="N2b",
                             description="N2b Stage Finding")
    N3a = PermissibleValue(text="N3a",
                             description="N3a Stage Finding")
    N1bII = PermissibleValue(text="N1bII",
                                 description="N1bII Stage Finding")
    N1 = PermissibleValue(text="N1",
                           description="N1 Stage Finding")
    N3 = PermissibleValue(text="N3",
                           description="N3 Stage Finding")
    N2a = PermissibleValue(text="N2a",
                             description="N2a Stage Finding")
    N1c = PermissibleValue(text="N1c",
                             description="N1c Stage Finding")
    N3c = PermissibleValue(text="N3c",
                             description="N3c Stage Finding")
    N3b = PermissibleValue(text="N3b",
                             description="N3b Stage Finding")
    N1bI = PermissibleValue(text="N1bI",
                               description="N1bI Stage Finding")
    N1mi = PermissibleValue(text="N1mi",
                               description="N1mi Stage Finding")
    N1a = PermissibleValue(text="N1a",
                             description="N1a Stage Finding")
    N2 = PermissibleValue(text="N2",
                           description="N2 Stage Finding")
    NX = PermissibleValue(text="NX",
                           description="NX Stage Finding")
    II = PermissibleValue(text="II",
                           description="II")
    III = PermissibleValue(text="III",
                             description="III")
    I = PermissibleValue(text="I",
                         description="I")
    Ms = PermissibleValue(text="Ms",
                           description="INRG Stage MS")
    L2 = PermissibleValue(text="L2",
                           description="INRG Stage L2")
    L1 = PermissibleValue(text="L1",
                           description="INRG Stage L1")
    M = PermissibleValue(text="M",
                         description="INRG Stage M")

    _defn = EnumDefinition(
        name="EnumCRDCHCancerStageObservationValueCodeableConcept",
        description="Autogenerated Enumeration for CRDC-H CancerStageObservation value_codeable_concept",
        code_set=None,
        code_set_version="2021-12-16T18:03:52.512125+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "No Metastasis (M0)",
                PermissibleValue(text="No Metastasis (M0)") )
        setattr(cls, "Regional or Distant Metastasis (M1)",
                PermissibleValue(text="Regional or Distant Metastasis (M1)") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported",
                                 description="Not Reported") )
        setattr(cls, "Stage IA",
                PermissibleValue(text="Stage IA",
                                 description="Stage IA") )
        setattr(cls, "Stage III",
                PermissibleValue(text="Stage III",
                                 description="SIOP/COG/NWTSG Stage III") )
        setattr(cls, "Stage IIA",
                PermissibleValue(text="Stage IIA",
                                 description="Stage IIA") )
        setattr(cls, "Stage IIB",
                PermissibleValue(text="Stage IIB",
                                 description="Stage IIB") )
        setattr(cls, "Stage IB",
                PermissibleValue(text="Stage IB",
                                 description="Stage IB") )
        setattr(cls, "Not Allowed To Collect",
                PermissibleValue(text="Not Allowed To Collect") )
        setattr(cls, "Stage 1",
                PermissibleValue(text="Stage 1",
                                 description="INSS Stage 1") )
        setattr(cls, "Stage 4S",
                PermissibleValue(text="Stage 4S",
                                 description="INSS Stage 4S") )
        setattr(cls, "Stage 3",
                PermissibleValue(text="Stage 3",
                                 description="INSS Stage 3") )
        setattr(cls, "Stage 2B",
                PermissibleValue(text="Stage 2B",
                                 description="INSS Stage 2B") )
        setattr(cls, "Stage 4",
                PermissibleValue(text="Stage 4",
                                 description="INSS Stage 4") )
        setattr(cls, "Stage 2A",
                PermissibleValue(text="Stage 2A",
                                 description="INSS Stage 2A") )
        setattr(cls, "Intermediate Prognosis",
                PermissibleValue(text="Intermediate Prognosis") )
        setattr(cls, "Poor Prognosis",
                PermissibleValue(text="Poor Prognosis") )
        setattr(cls, "Good Prognosis",
                PermissibleValue(text="Good Prognosis") )
        setattr(cls, "Stage IIIC",
                PermissibleValue(text="Stage IIIC",
                                 description="Stage IIIC") )
        setattr(cls, "Stage IIIA",
                PermissibleValue(text="Stage IIIA",
                                 description="Stage IIIA") )
        setattr(cls, "Stage IIA2",
                PermissibleValue(text="Stage IIA2",
                                 description="Stage IIA2") )
        setattr(cls, "Stage IV",
                PermissibleValue(text="Stage IV",
                                 description="SIOP/COG/NWTSG Stage IV") )
        setattr(cls, "Stage IIIC1",
                PermissibleValue(text="Stage IIIC1",
                                 description="FIGO Stage IIIC1") )
        setattr(cls, "Stage IIIC2",
                PermissibleValue(text="Stage IIIC2",
                                 description="FIGO Stage IIIC2") )
        setattr(cls, "Stage IIA1",
                PermissibleValue(text="Stage IIA1",
                                 description="Stage IIA1") )
        setattr(cls, "Stage IIIB",
                PermissibleValue(text="Stage IIIB",
                                 description="Stage IIIB") )
        setattr(cls, "Stage IVA",
                PermissibleValue(text="Stage IVA",
                                 description="Stage IVA") )
        setattr(cls, "Stage 0",
                PermissibleValue(text="Stage 0",
                                 description="Stage 0") )
        setattr(cls, "Stage I",
                PermissibleValue(text="Stage I",
                                 description="SIOP/COG/NWTSG Stage I") )
        setattr(cls, "Stage IVB",
                PermissibleValue(text="Stage IVB",
                                 description="Stage IVB") )
        setattr(cls, "Stage IA1",
                PermissibleValue(text="Stage IA1",
                                 description="Stage IA1") )
        setattr(cls, "Stage IA2",
                PermissibleValue(text="Stage IA2",
                                 description="Stage IA2") )
        setattr(cls, "Stage IB1",
                PermissibleValue(text="Stage IB1",
                                 description="Stage IB1") )
        setattr(cls, "Stage IB2",
                PermissibleValue(text="Stage IB2",
                                 description="Stage IB2") )
        setattr(cls, "Stage II",
                PermissibleValue(text="Stage II",
                                 description="SIOP/COG/NWTSG Stage II") )
        setattr(cls, "Stage IC",
                PermissibleValue(text="Stage IC",
                                 description="Stage IC") )
        setattr(cls, "2",
                PermissibleValue(text="2",
                                 description="Unfavorable site, <= 5 cm, no regional node involvement") )
        setattr(cls, "1",
                PermissibleValue(text="1",
                                 description="Favorable Site") )
        setattr(cls, "3",
                PermissibleValue(text="3",
                                 description="Unfavorable site, >5cm, and/or regional node involvement") )
        setattr(cls, "4",
                PermissibleValue(text="4",
                                 description="Metastatic disease") )
        setattr(cls, "cM0 (i+)",
                PermissibleValue(text="cM0 (i+)",
                                 description="cM0 (i+) Stage Finding") )
        setattr(cls, "Tis (Paget's)",
                PermissibleValue(text="Tis (Paget's)",
                                 description="Tis Stage Finding Paget Disease of the Breast without Invasive Carcinoma") )
        setattr(cls, "Tis (DCIS)",
                PermissibleValue(text="Tis (DCIS)",
                                 description="Tis Stage Finding Ductal Breast Carcinoma In Situ") )
        setattr(cls, "Tis (LCIS)",
                PermissibleValue(text="Tis (LCIS)",
                                 description="Tis Stage Finding Lobular Breast Carcinoma In Situ") )
        setattr(cls, "Stage Tis",
                PermissibleValue(text="Stage Tis",
                                 description="Tis Stage Finding") )
        setattr(cls, "Stage X",
                PermissibleValue(text="Stage X",
                                 description="Stage X") )
        setattr(cls, "Stage IVC",
                PermissibleValue(text="Stage IVC",
                                 description="Stage IVC") )
        setattr(cls, "Stage 0a",
                PermissibleValue(text="Stage 0a",
                                 description="Stage 0a") )
        setattr(cls, "Stage IIC1",
                PermissibleValue(text="Stage IIC1") )
        setattr(cls, "Stage IS",
                PermissibleValue(text="Stage IS",
                                 description="Stage Is") )
        setattr(cls, "Stage 0is",
                PermissibleValue(text="Stage 0is",
                                 description="Stage 0is") )
        setattr(cls, "Stage IIC",
                PermissibleValue(text="Stage IIC",
                                 description="Stage IIC") )
        setattr(cls, "N0 (mol+)",
                PermissibleValue(text="N0 (mol+)",
                                 description="N0 (mol+) Stage Finding") )
        setattr(cls, "N0 (mol-)",
                PermissibleValue(text="N0 (mol-)",
                                 description="N0 (mol-) Stage Finding") )
        setattr(cls, "N0 (i+)",
                PermissibleValue(text="N0 (i+)",
                                 description="N0 (i+) Stage Finding") )
        setattr(cls, "N0 (i-)",
                PermissibleValue(text="N0 (i-)",
                                 description="N0 (i-) Stage Finding") )
        setattr(cls, "Stage IIID",
                PermissibleValue(text="Stage IIID") )
        setattr(cls, "Stage IIb",
                PermissibleValue(text="Stage IIb") )
        setattr(cls, "Stage IIa",
                PermissibleValue(text="Stage IIa") )
        setattr(cls, "Stage IVb",
                PermissibleValue(text="Stage IVb") )
        setattr(cls, "Stage IVa",
                PermissibleValue(text="Stage IVa") )
        setattr(cls, "Intracompartmental (T1)",
                PermissibleValue(text="Intracompartmental (T1)",
                                 description="Intracompartmental Tumor") )
        setattr(cls, "Extracompartmental (T2)",
                PermissibleValue(text="Extracompartmental (T2)",
                                 description="Extracompartmental Tumor") )
        setattr(cls, "Stage IA3",
                PermissibleValue(text="Stage IA3",
                                 description="Stage IA3") )
        setattr(cls, "Stage IB Cervix",
                PermissibleValue(text="Stage IB Cervix",
                                 description="Stage IB Cervix") )
        setattr(cls, "Stage IIA Cervix",
                PermissibleValue(text="Stage IIA Cervix",
                                 description="Stage IIA Cervix") )
        setattr(cls, "Stage II Cervix",
                PermissibleValue(text="Stage II Cervix",
                                 description="Stage II Cervix") )
        setattr(cls, "Stage IIIAii",
                PermissibleValue(text="Stage IIIAii") )
        setattr(cls, "Stage IIIAi",
                PermissibleValue(text="Stage IIIAi") )
        setattr(cls, "Stage IC3",
                PermissibleValue(text="Stage IC3") )
        setattr(cls, "Stage IC2",
                PermissibleValue(text="Stage IC2") )
        setattr(cls, "Stage IIIA2",
                PermissibleValue(text="Stage IIIA2") )
        setattr(cls, "Stage IIIA1",
                PermissibleValue(text="Stage IIIA1") )
        setattr(cls, "Stage IC1",
                PermissibleValue(text="Stage IC1") )
        setattr(cls, "3rd",
                PermissibleValue(text="3rd",
                                 description="Third Edition (published 1988)") )
        setattr(cls, "7th",
                PermissibleValue(text="7th",
                                 description="Seventh Edition") )
        setattr(cls, "1st",
                PermissibleValue(text="1st",
                                 description="First Edition") )
        setattr(cls, "4th",
                PermissibleValue(text="4th",
                                 description="Fourth Edition (published 1992)") )
        setattr(cls, "2nd",
                PermissibleValue(text="2nd",
                                 description="Second Edition (published 1983)") )
        setattr(cls, "5th",
                PermissibleValue(text="5th",
                                 description="Fifth Edition (published 1997)") )
        setattr(cls, "8th",
                PermissibleValue(text="8th",
                                 description="Eighth Edition") )
        setattr(cls, "6th",
                PermissibleValue(text="6th",
                                 description="Sixth Edition (published 2002)") )

class EnumCRDCHCancerStageObservationSetCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerStageObservationSet category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerStageObservationSetCategory",
        description="Autogenerated Enumeration for CRDC-H CancerStageObservationSet category",
        code_set=None,
        code_set_version="2021-12-16T18:03:53.169837+00:00",
    )

class EnumCRDCHCancerStageObservationSetMethodType(EnumDefinitionImpl):
    """
    Classification systems used for defining the point in the natural history of a malignant disease a patient is when
    a diagnosis is made
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerStageObservationSetMethodType",
        description="Classification systems used for defining the point in the natural history of a malignant disease a patient is when a diagnosis is made",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "AJCC staging system 1st edition",
                PermissibleValue(text="AJCC staging system 1st edition",
                                 description="The 1st edition of the criteria developed by the American Joint Committee on Cancer (AJCC) used for the classification and staging of neoplastic diseases.") )
        setattr(cls, "AJCC staging system 2nd edition",
                PermissibleValue(text="AJCC staging system 2nd edition",
                                 description="The 2nd edition of the criteria developed by the American Joint Committee on Cancer (AJCC) used for the classification and staging of neoplastic diseases.") )
        setattr(cls, "AJCC staging system 3rd edition",
                PermissibleValue(text="AJCC staging system 3rd edition",
                                 description="The 3rd edition of the criteria developed by the American Joint Committee on Cancer (AJCC) used for the classification and staging of neoplastic diseases.") )
        setattr(cls, "AJCC staging system 4th edition",
                PermissibleValue(text="AJCC staging system 4th edition",
                                 description="The 4th edition of the criteria developed by the American Joint Committee on Cancer (AJCC) used for the classification and staging of neoplastic diseases.") )
        setattr(cls, "AJCC staging system 5th edition",
                PermissibleValue(text="AJCC staging system 5th edition",
                                 description="The 5th edition of the criteria developed by the American Joint Committee on Cancer (AJCC) used for the classification and staging of neoplastic diseases.") )
        setattr(cls, "AJCC staging system 6th edition",
                PermissibleValue(text="AJCC staging system 6th edition",
                                 description="The 6th edition of the criteria developed by the American Joint Committee on Cancer (AJCC) used for the classification and staging of neoplastic diseases.") )
        setattr(cls, "AJCC staging system 7th edition",
                PermissibleValue(text="AJCC staging system 7th edition",
                                 description="The 7th edition of the criteria developed by the American Joint Committee on Cancer (AJCC) in 2010, used for the classification and staging of neoplastic diseases.") )
        setattr(cls, "AJCC staging system 8th edition",
                PermissibleValue(text="AJCC staging system 8th edition",
                                 description="The 8th edition of the criteria developed by the American Joint Committee on Cancer (AJCC), implemented in 2018, used for the classification and staging of neoplastic diseases") )
        setattr(cls, "Ann Arbor staging system",
                PermissibleValue(text="Ann Arbor staging system",
                                 description="The Ann Arbor Staging guidelines used in the staging of lymphomas") )
        setattr(cls, "COG Liver staging system",
                PermissibleValue(text="COG Liver staging system",
                                 description="A staging system developed by Children's Oncology Group (COG) that categorizes liver tumors based on the size and extent of the tumor.") )
        setattr(cls, "COG Renal staging system",
                PermissibleValue(text="COG Renal staging system",
                                 description="A staging system developed by Children's Oncology Group (COG) that categorizes renal tumors, often Wilms tumor, based on the size and extent of the tumor.") )
        setattr(cls, "Enneking MSTS staging system",
                PermissibleValue(text="Enneking MSTS staging system",
                                 description="A staging system for malignant mesenchymal tumors that takes into account the surgical grade, local extent, and presence or absence of metastasis.") )
        setattr(cls, "FIGO staging system",
                PermissibleValue(text="FIGO staging system",
                                 description="A set of staging terms for carcinoma developed by the International Federation of Gynecology and Obstetrics (FIGO).") )
        setattr(cls, "IGCCCG staging system",
                PermissibleValue(text="IGCCCG staging system") )
        setattr(cls, "INRG staging system",
                PermissibleValue(text="INRG staging system",
                                 description="A clinical staging system for neuroblastoma based on preoperative imaging and determined prior to any treatment, including surgery. It includes two stages of localized disease (L1 and L2) and two stages of metastatic disease (M and MS).") )
        setattr(cls, "INSS staging system",
                PermissibleValue(text="INSS staging system",
                                 description="A surgicopathological staging system for neuroblastoma, based on the Evans staging system.") )
        setattr(cls, "IRS staging system",
                PermissibleValue(text="IRS staging system",
                                 description="A system developed by the Intergroup Rhabdomyosarcoma Studies (IRS) group for staging rhabdomyosarcomas based on a modified TNM staging system.") )
        setattr(cls, "ISS staging system",
                PermissibleValue(text="ISS staging system",
                                 description="A plasma cell myeloma stage defined according to the international staging system.") )
        setattr(cls, "Masaoka staging system",
                PermissibleValue(text="Masaoka staging system",
                                 description="A thymoma stage defined according to the Masaoka-Koga staging criteria.") )
        setattr(cls, "Unspecified staging system",
                PermissibleValue(text="Unspecified staging system",
                                 description="For use when a data contributor has a cancer staging value, but no clearly specified staging system under which that value falls.") )

class EnumCRDCHDiagnosisCondition(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Diagnosis condition
    """
    M6A = PermissibleValue(text="M6A")
    Enchondroma = PermissibleValue(text="Enchondroma")
    Myoma = PermissibleValue(text="Myoma")
    Glomangiomyoma = PermissibleValue(text="Glomangiomyoma")
    Neurinomatosis = PermissibleValue(text="Neurinomatosis")
    Gliofibroma = PermissibleValue(text="Gliofibroma")
    Chloroma = PermissibleValue(text="Chloroma")
    Neurocytoma = PermissibleValue(text="Neurocytoma")
    Spongioneuroblastoma = PermissibleValue(text="Spongioneuroblastoma")
    Angiomyolipoma = PermissibleValue(text="Angiomyolipoma")
    Pituicytoma = PermissibleValue(text="Pituicytoma")
    Ependymoblastoma = PermissibleValue(text="Ependymoblastoma")
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    Angiomyosarcoma = PermissibleValue(text="Angiomyosarcoma")
    Cholangioma = PermissibleValue(text="Cholangioma")
    Rhabdosarcoma = PermissibleValue(text="Rhabdosarcoma")
    Hepatocholangiocarcinoma = PermissibleValue(text="Hepatocholangiocarcinoma")
    Pineocytoma = PermissibleValue(text="Pineocytoma")
    Ganglioneuroma = PermissibleValue(text="Ganglioneuroma")
    Dentinoma = PermissibleValue(text="Dentinoma")
    Luteinoma = PermissibleValue(text="Luteinoma")
    Gynandroblastoma = PermissibleValue(text="Gynandroblastoma")
    Myxoliposarcoma = PermissibleValue(text="Myxoliposarcoma")
    Oncocytoma = PermissibleValue(text="Oncocytoma")
    MGUS = PermissibleValue(text="MGUS")
    Chorioadenoma = PermissibleValue(text="Chorioadenoma")
    RARS = PermissibleValue(text="RARS")
    Angiomyofibroblastoma = PermissibleValue(text="Angiomyofibroblastoma")
    Neurilemosarcoma = PermissibleValue(text="Neurilemosarcoma")
    Teratocarcinoma = PermissibleValue(text="Teratocarcinoma")
    Malignancy = PermissibleValue(text="Malignancy")
    Esthesioneurocytoma = PermissibleValue(text="Esthesioneurocytoma")
    Gliosarcoma = PermissibleValue(text="Gliosarcoma")
    Neuroastrocytoma = PermissibleValue(text="Neuroastrocytoma")
    Adenoameloblastoma = PermissibleValue(text="Adenoameloblastoma")
    Adenoacanthoma = PermissibleValue(text="Adenoacanthoma")
    Angioendothelioma = PermissibleValue(text="Angioendothelioma")
    Reticulohistiocytoma = PermissibleValue(text="Reticulohistiocytoma")
    Neurinoma = PermissibleValue(text="Neurinoma")
    Elastofibroma = PermissibleValue(text="Elastofibroma")
    Reninoma = PermissibleValue(text="Reninoma")
    Porocarcinoma = PermissibleValue(text="Porocarcinoma")
    Melanoameloblastoma = PermissibleValue(text="Melanoameloblastoma")
    Trichilemmocarcinoma = PermissibleValue(text="Trichilemmocarcinoma")
    Fibromyxoma = PermissibleValue(text="Fibromyxoma")
    Chorionepithelioma = PermissibleValue(text="Chorionepithelioma")
    Ecchondroma = PermissibleValue(text="Ecchondroma")
    Lymphoepithelioma = PermissibleValue(text="Lymphoepithelioma")
    Chromaffinoma = PermissibleValue(text="Chromaffinoma")
    Subependymoma = PermissibleValue(text="Subependymoma")
    Odontoameloblastoma = PermissibleValue(text="Odontoameloblastoma")
    Haemangiosarcoma = PermissibleValue(text="Haemangiosarcoma")
    Glomangiosarcoma = PermissibleValue(text="Glomangiosarcoma")
    Chorioepithelioma = PermissibleValue(text="Chorioepithelioma")
    Pheochromoblastoma = PermissibleValue(text="Pheochromoblastoma")
    Erythroleukemia = PermissibleValue(text="Erythroleukemia")
    GANT = PermissibleValue(text="GANT")
    Osteochondrosarcoma = PermissibleValue(text="Osteochondrosarcoma")
    CPNET = PermissibleValue(text="CPNET")
    Nesidioblastoma = PermissibleValue(text="Nesidioblastoma")
    Hidradenocarcinoma = PermissibleValue(text="Hidradenocarcinoma")
    Angiosarcoma = PermissibleValue(text="Angiosarcoma")
    RAEB = PermissibleValue(text="RAEB")
    Myofibroma = PermissibleValue(text="Myofibroma")
    Immunocytoma = PermissibleValue(text="Immunocytoma")
    M6B = PermissibleValue(text="M6B")
    Oligoastrocytoma = PermissibleValue(text="Oligoastrocytoma",
                                                       description="Oligoastrocytoma")
    Esthesioneuroepithelioma = PermissibleValue(text="Esthesioneuroepithelioma")
    Haemangioblastoma = PermissibleValue(text="Haemangioblastoma")
    Neurolipocytoma = PermissibleValue(text="Neurolipocytoma")
    Neurosarcoma = PermissibleValue(text="Neurosarcoma")
    SETTLE = PermissibleValue(text="SETTLE")
    Angiokeratoma = PermissibleValue(text="Angiokeratoma")
    Astroglioma = PermissibleValue(text="Astroglioma")
    Adenosarcoma = PermissibleValue(text="Adenosarcoma",
                                               description="Adenosarcoma")
    Neurothekeoma = PermissibleValue(text="Neurothekeoma")
    Spermatocytoma = PermissibleValue(text="Spermatocytoma")
    Adenolymphoma = PermissibleValue(text="Adenolymphoma")
    Hidrocystoma = PermissibleValue(text="Hidrocystoma")
    Sympathicoblastoma = PermissibleValue(text="Sympathicoblastoma")
    MANEC = PermissibleValue(text="MANEC")
    Lymphangiosarcoma = PermissibleValue(text="Lymphangiosarcoma")
    Lymphoblastoma = PermissibleValue(text="Lymphoblastoma")
    Sialoblastoma = PermissibleValue(text="Sialoblastoma")
    Angiomyxoma = PermissibleValue(text="Angiomyxoma")
    Leiomyofibroma = PermissibleValue(text="Leiomyofibroma")
    Hepatoblastoma = PermissibleValue(text="Hepatoblastoma")
    Oligodendroblastoma = PermissibleValue(text="Oligodendroblastoma")
    Prolactinoma = PermissibleValue(text="Prolactinoma")
    Hibernoma = PermissibleValue(text="Hibernoma")
    Polyembryoma = PermissibleValue(text="Polyembryoma")
    Adenomyoma = PermissibleValue(text="Adenomyoma")
    Chemodectoma = PermissibleValue(text="Chemodectoma")
    Xanthofibroma = PermissibleValue(text="Xanthofibroma")
    Myofibroblastoma = PermissibleValue(text="Myofibroblastoma")
    Trichodiscoma = PermissibleValue(text="Trichodiscoma")
    Lymphangioleiomyomatosis = PermissibleValue(text="Lymphangioleiomyomatosis")
    Leiomyoblastoma = PermissibleValue(text="Leiomyoblastoma")
    Adenomyoepithelioma = PermissibleValue(text="Adenomyoepithelioma")
    Ectomesenchymoma = PermissibleValue(text="Ectomesenchymoma")
    Osteofibrosarcoma = PermissibleValue(text="Osteofibrosarcoma")
    Lipoadenoma = PermissibleValue(text="Lipoadenoma")
    Pineoblastoma = PermissibleValue(text="Pineoblastoma")
    Fibromyxolipoma = PermissibleValue(text="Fibromyxolipoma")
    Medullomyoblastoma = PermissibleValue(text="Medullomyoblastoma")
    Myelolipoma = PermissibleValue(text="Myelolipoma")
    Pancreatoblastoma = PermissibleValue(text="Pancreatoblastoma",
                                                         description="Pancreatoblastoma")
    Apudoma = PermissibleValue(text="Apudoma")
    Adenolipoma = PermissibleValue(text="Adenolipoma")
    Cancer = PermissibleValue(text="Cancer")
    Lipoblastoma = PermissibleValue(text="Lipoblastoma")
    Fibrofolliculoma = PermissibleValue(text="Fibrofolliculoma")
    Ecchondrosis = PermissibleValue(text="Ecchondrosis")
    Glioneuroma = PermissibleValue(text="Glioneuroma")
    Lipoblastomatosis = PermissibleValue(text="Lipoblastomatosis")
    Germinoma = PermissibleValue(text="Germinoma")
    Trichilemmoma = PermissibleValue(text="Trichilemmoma")
    Lipoleiomyoma = PermissibleValue(text="Lipoleiomyoma")
    Trichofolliculoma = PermissibleValue(text="Trichofolliculoma")
    Angioleiomyoma = PermissibleValue(text="Angioleiomyoma")
    Glioblastoma = PermissibleValue(text="Glioblastoma")
    Retinocytoma = PermissibleValue(text="Retinocytoma")
    Ganglioneuromatosis = PermissibleValue(text="Ganglioneuromatosis")
    Myelomatosis = PermissibleValue(text="Myelomatosis")
    Dysgerminoma = PermissibleValue(text="Dysgerminoma",
                                               description="Ovarian Dysgerminoma")
    Glomangioma = PermissibleValue(text="Glomangioma")
    Fibromyoma = PermissibleValue(text="Fibromyoma")
    Astroblastoma = PermissibleValue(text="Astroblastoma")
    Esthesioneuroblastoma = PermissibleValue(text="Esthesioneuroblastoma")
    CASTLE = PermissibleValue(text="CASTLE")
    Myoepithelioma = PermissibleValue(text="Myoepithelioma")
    Myxolipoma = PermissibleValue(text="Myxolipoma")
    Fibrochondrosarcoma = PermissibleValue(text="Fibrochondrosarcoma")
    Trichoepithelioma = PermissibleValue(text="Trichoepithelioma")
    Myofibromatosis = PermissibleValue(text="Myofibromatosis")
    Gangliocytoma = PermissibleValue(text="Gangliocytoma")
    Carcinomatosis = PermissibleValue(text="Carcinomatosis")
    Gemistocytoma = PermissibleValue(text="Gemistocytoma")
    Syringofibroadenoma = PermissibleValue(text="Syringofibroadenoma")
    Neurofibrosarcoma = PermissibleValue(text="Neurofibrosarcoma")
    Preleukemia = PermissibleValue(text="Preleukemia")
    Angioblastoma = PermissibleValue(text="Angioblastoma")
    Parachordoma = PermissibleValue(text="Parachordoma")
    Fibromyxosarcoma = PermissibleValue(text="Fibromyxosarcoma")
    Hemolymphangioma = PermissibleValue(text="Hemolymphangioma")
    Cholangiocarcinoma = PermissibleValue(text="Cholangiocarcinoma",
                                                           description="Cholangiocarcinoma")
    Microglioma = PermissibleValue(text="Microglioma")
    Ganglioneuroblastoma = PermissibleValue(text="Ganglioneuroblastoma")
    Myosarcoma = PermissibleValue(text="Myosarcoma")
    Lymphangiomyomatosis = PermissibleValue(text="Lymphangiomyomatosis")
    Neuronevus = PermissibleValue(text="Neuronevus")
    Orchioblastoma = PermissibleValue(text="Orchioblastoma")
    Osteofibroma = PermissibleValue(text="Osteofibroma")
    Pneumoblastoma = PermissibleValue(text="Pneumoblastoma")
    Fibroliposarcoma = PermissibleValue(text="Fibroliposarcoma")
    Angioendotheliomatosis = PermissibleValue(text="Angioendotheliomatosis")
    Medullocytoma = PermissibleValue(text="Medullocytoma")
    Hepatocarcinoma = PermissibleValue(text="Hepatocarcinoma")
    Angiomyoma = PermissibleValue(text="Angiomyoma")
    Fibrolipoma = PermissibleValue(text="Fibrolipoma")
    Pinealoma = PermissibleValue(text="Pinealoma")
    PPNET = PermissibleValue(text="PPNET")
    Craniopharyngioma = PermissibleValue(text="Craniopharyngioma")
    Chorioangioma = PermissibleValue(text="Chorioangioma")
    Gonadoblastoma = PermissibleValue(text="Gonadoblastoma")
    Osteochondroma = PermissibleValue(text="Osteochondroma")
    Hypernephroma = PermissibleValue(text="Hypernephroma")
    Carcinofibroma = PermissibleValue(text="Carcinofibroma")
    Masculinovoblastoma = PermissibleValue(text="Masculinovoblastoma")
    Lymphangiomyoma = PermissibleValue(text="Lymphangiomyoma")
    Gonocytoma = PermissibleValue(text="Gonocytoma")
    Myxosarcoma = PermissibleValue(text="Myxosarcoma")

    _defn = EnumDefinition(
        name="EnumCRDCHDiagnosisCondition",
        description="Autogenerated Enumeration for CRDC-H Diagnosis condition",
        code_set=None,
        code_set_version="2021-12-16T18:03:53.462956+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Myeloid neoplasms with PDGFRB rearrangement",
                PermissibleValue(text="Myeloid neoplasms with PDGFRB rearrangement") )
        setattr(cls, "PEComa, malignant",
                PermissibleValue(text="PEComa, malignant") )
        setattr(cls, "Acute erythroid leukaemia",
                PermissibleValue(text="Acute erythroid leukaemia") )
        setattr(cls, "Transitional papilloma",
                PermissibleValue(text="Transitional papilloma") )
        setattr(cls, "Pre-B ALL",
                PermissibleValue(text="Pre-B ALL") )
        setattr(cls, "Acute panmyelosis with myelofibrosis",
                PermissibleValue(text="Acute panmyelosis with myelofibrosis") )
        setattr(cls, "Mixed mesenchymal sarcoma",
                PermissibleValue(text="Mixed mesenchymal sarcoma") )
        setattr(cls, "Stromal tumor with minor sex cord elements",
                PermissibleValue(text="Stromal tumor with minor sex cord elements") )
        setattr(cls, "Adrenal cortical adenoma, glomerulosa cell",
                PermissibleValue(text="Adrenal cortical adenoma, glomerulosa cell") )
        setattr(cls, "Non-invasive encapsulated follicular variant of papillary thyroid carcinoma (non-invasive EFVPTC)",
                PermissibleValue(text="Non-invasive encapsulated follicular variant of papillary thyroid carcinoma (non-invasive EFVPTC)") )
        setattr(cls, "Epithelioid mesothelioma, malignant",
                PermissibleValue(text="Epithelioid mesothelioma, malignant") )
        setattr(cls, "Sertoli cell carcinoma",
                PermissibleValue(text="Sertoli cell carcinoma") )
        setattr(cls, "Odontogenic tumor, NOS",
                PermissibleValue(text="Odontogenic tumor, NOS") )
        setattr(cls, "Intraductal papilloma",
                PermissibleValue(text="Intraductal papilloma") )
        setattr(cls, "Nonencapsulated sclerosing adenocarcinoma",
                PermissibleValue(text="Nonencapsulated sclerosing adenocarcinoma") )
        setattr(cls, "Precursor B-cell lymphoblastic leukemia",
                PermissibleValue(text="Precursor B-cell lymphoblastic leukemia") )
        setattr(cls, "Stromal sarcoma, NOS",
                PermissibleValue(text="Stromal sarcoma, NOS") )
        setattr(cls, "Papillary cystadenoma lymphomatosum",
                PermissibleValue(text="Papillary cystadenoma lymphomatosum") )
        setattr(cls, "SALT lymphoma",
                PermissibleValue(text="SALT lymphoma") )
        setattr(cls, "Fibroxanthoma, malignant",
                PermissibleValue(text="Fibroxanthoma, malignant") )
        setattr(cls, "Endometrioid adenoma, borderline malignancy",
                PermissibleValue(text="Endometrioid adenoma, borderline malignancy") )
        setattr(cls, "Hand-Schuller-Christian disease",
                PermissibleValue(text="Hand-Schuller-Christian disease") )
        setattr(cls, "Ancient schwannoma",
                PermissibleValue(text="Ancient schwannoma") )
        setattr(cls, "Primary serous papillary carcinoma of peritoneum",
                PermissibleValue(text="Primary serous papillary carcinoma of peritoneum") )
        setattr(cls, "Compound odontoma",
                PermissibleValue(text="Compound odontoma") )
        setattr(cls, "Endocervical adenocarcinoma usual type",
                PermissibleValue(text="Endocervical adenocarcinoma usual type") )
        setattr(cls, "DCIS, NOS",
                PermissibleValue(text="DCIS, NOS") )
        setattr(cls, "Sclerosing sweat duct carcinoma",
                PermissibleValue(text="Sclerosing sweat duct carcinoma") )
        setattr(cls, "Complex odontoma",
                PermissibleValue(text="Complex odontoma") )
        setattr(cls, "Tubular androblastoma, NOS",
                PermissibleValue(text="Tubular androblastoma, NOS") )
        setattr(cls, "Ceruminous carcinoma",
                PermissibleValue(text="Ceruminous carcinoma") )
        setattr(cls, "Folliculome lipidique",
                PermissibleValue(text="Folliculome lipidique") )
        setattr(cls, "Perineurioma, malignant",
                PermissibleValue(text="Perineurioma, malignant") )
        setattr(cls, "Transitional cell carcinoma, spindle cell",
                PermissibleValue(text="Transitional cell carcinoma, spindle cell") )
        setattr(cls, "Embryonal teratoma",
                PermissibleValue(text="Embryonal teratoma") )
        setattr(cls, "Acute non-lymphocytic leukemia",
                PermissibleValue(text="Acute non-lymphocytic leukemia") )
        setattr(cls, "Lymphomatoid papulosis",
                PermissibleValue(text="Lymphomatoid papulosis") )
        setattr(cls, "Giant pigmented nevus, NOS",
                PermissibleValue(text="Giant pigmented nevus, NOS") )
        setattr(cls, "Fibrous histiocytoma of tendon sheath",
                PermissibleValue(text="Fibrous histiocytoma of tendon sheath") )
        setattr(cls, "Lipoma-like liposarcoma",
                PermissibleValue(text="Lipoma-like liposarcoma") )
        setattr(cls, "Diktyoma, benign",
                PermissibleValue(text="Diktyoma, benign") )
        setattr(cls, "Intraductal micropapillary carcinoma",
                PermissibleValue(text="Intraductal micropapillary carcinoma") )
        setattr(cls, "Large cell calcifying Sertoli cell tumor",
                PermissibleValue(text="Large cell calcifying Sertoli cell tumor") )
        setattr(cls, "Odontogenic myxoma",
                PermissibleValue(text="Odontogenic myxoma") )
        setattr(cls, "Hemangiopericytoma, NOS",
                PermissibleValue(text="Hemangiopericytoma, NOS") )
        setattr(cls, "Langerhans cell histiocytosis, multifocal",
                PermissibleValue(text="Langerhans cell histiocytosis, multifocal") )
        setattr(cls, "Primary cutaneous CD30+ large T-cell lymphoma",
                PermissibleValue(text="Primary cutaneous CD30+ large T-cell lymphoma") )
        setattr(cls, "Thymoma, malignant, NOS",
                PermissibleValue(text="Thymoma, malignant, NOS") )
        setattr(cls, "Solitary myeloma",
                PermissibleValue(text="Solitary myeloma") )
        setattr(cls, "Rhabdomyosarcoma with ganglionic differentiation",
                PermissibleValue(text="Rhabdomyosarcoma with ganglionic differentiation") )
        setattr(cls, "Fibrous papule of nose",
                PermissibleValue(text="Fibrous papule of nose") )
        setattr(cls, "Malignant lymphoma, centroblastic, diffuse",
                PermissibleValue(text="Malignant lymphoma, centroblastic, diffuse") )
        setattr(cls, "VAIN III",
                PermissibleValue(text="VAIN III") )
        setattr(cls, "Sarcoma, NOS",
                PermissibleValue(text="Sarcoma, NOS") )
        setattr(cls, "Congenital peribronchial myofibroblastic tumor",
                PermissibleValue(text="Congenital peribronchial myofibroblastic tumor") )
        setattr(cls, "Conventional central osteosarcoma",
                PermissibleValue(text="Conventional central osteosarcoma") )
        setattr(cls, "Plasmacytoma, NOS",
                PermissibleValue(text="Plasmacytoma, NOS") )
        setattr(cls, "NK-cell large granular lymphocytic leukemia",
                PermissibleValue(text="NK-cell large granular lymphocytic leukemia") )
        setattr(cls, "Water-clear cell carcinoma",
                PermissibleValue(text="Water-clear cell carcinoma") )
        setattr(cls, "Malignant lymphoma, mixed cell type, follicular",
                PermissibleValue(text="Malignant lymphoma, mixed cell type, follicular") )
        setattr(cls, "Papillary squamous cell carcinoma",
                PermissibleValue(text="Papillary squamous cell carcinoma") )
        setattr(cls, "Tumor embolus",
                PermissibleValue(text="Tumor embolus") )
        setattr(cls, "Anaplastic astrocytoma, IDH-wildtype",
                PermissibleValue(text="Anaplastic astrocytoma, IDH-wildtype") )
        setattr(cls, "Teratoid medulloepithelioma, benign",
                PermissibleValue(text="Teratoid medulloepithelioma, benign") )
        setattr(cls, "Fascial fibrosarcoma",
                PermissibleValue(text="Fascial fibrosarcoma") )
        setattr(cls, "Chondroid chordoma",
                PermissibleValue(text="Chondroid chordoma") )
        setattr(cls, "Intramuscular hemangioma",
                PermissibleValue(text="Intramuscular hemangioma") )
        setattr(cls, "Giant cell sarcoma",
                PermissibleValue(text="Giant cell sarcoma") )
        setattr(cls, "Hepatoma, malignant",
                PermissibleValue(text="Hepatoma, malignant") )
        setattr(cls, "Langerhans cell histiocytosis, poly-ostotic",
                PermissibleValue(text="Langerhans cell histiocytosis, poly-ostotic") )
        setattr(cls, "Atypical proliferative mucinous tumor",
                PermissibleValue(text="Atypical proliferative mucinous tumor") )
        setattr(cls, "Noninvasive pancreatobiliary papillary neoplasm with high grade intraepithelial neoplasia",
                PermissibleValue(text="Noninvasive pancreatobiliary papillary neoplasm with high grade intraepithelial neoplasia") )
        setattr(cls, "Chronic myelomonocytic leukemia, NOS",
                PermissibleValue(text="Chronic myelomonocytic leukemia, NOS") )
        setattr(cls, "Sclerosing stromal tumor",
                PermissibleValue(text="Sclerosing stromal tumor") )
        setattr(cls, "VIN III",
                PermissibleValue(text="VIN III") )
        setattr(cls, "Ependymoma, anaplastic",
                PermissibleValue(text="Ependymoma, anaplastic") )
        setattr(cls, "Glycogen-rich carcinoma",
                PermissibleValue(text="Glycogen-rich carcinoma") )
        setattr(cls, "Renal carcinoma, collecting duct type",
                PermissibleValue(text="Renal carcinoma, collecting duct type") )
        setattr(cls, "Diffuse astrocytoma, low grade",
                PermissibleValue(text="Diffuse astrocytoma, low grade") )
        setattr(cls, "Squamous cell carcinoma, acantholytic",
                PermissibleValue(text="Squamous cell carcinoma, acantholytic") )
        setattr(cls, "Sarcomatoid mesothelioma",
                PermissibleValue(text="Sarcomatoid mesothelioma",
                                 description="Sarcomatoid Mesothelioma") )
        setattr(cls, "Intraductal papillary-mucinous neoplasm with moderate dysplasia",
                PermissibleValue(text="Intraductal papillary-mucinous neoplasm with moderate dysplasia") )
        setattr(cls, "Malignant lymphoma, large B-cell, diffuse, immunoblastic, NOS",
                PermissibleValue(text="Malignant lymphoma, large B-cell, diffuse, immunoblastic, NOS") )
        setattr(cls, "Papillary adenoma, NOS",
                PermissibleValue(text="Papillary adenoma, NOS") )
        setattr(cls, "Sebaceous adenoma",
                PermissibleValue(text="Sebaceous adenoma") )
        setattr(cls, "Invasive mole, NOS",
                PermissibleValue(text="Invasive mole, NOS") )
        setattr(cls, "Oligodendroglioma, anaplastic",
                PermissibleValue(text="Oligodendroglioma, anaplastic") )
        setattr(cls, "Transitional cell papilloma, inverted, NOS",
                PermissibleValue(text="Transitional cell papilloma, inverted, NOS") )
        setattr(cls, "Hypereosinophilic syndrome",
                PermissibleValue(text="Hypereosinophilic syndrome") )
        setattr(cls, "Condylomatous carcinoma",
                PermissibleValue(text="Condylomatous carcinoma") )
        setattr(cls, "Malignant peripheral nerve sheath tumor",
                PermissibleValue(text="Malignant peripheral nerve sheath tumor") )
        setattr(cls, "Acute myeloid leukemia, AML1(CBF-alpha)/ETO",
                PermissibleValue(text="Acute myeloid leukemia, AML1(CBF-alpha)/ETO") )
        setattr(cls, "Neurilemoma, malignant",
                PermissibleValue(text="Neurilemoma, malignant") )
        setattr(cls, "Malignant mastocytoma",
                PermissibleValue(text="Malignant mastocytoma") )
        setattr(cls, "Periosteal chondroma",
                PermissibleValue(text="Periosteal chondroma") )
        setattr(cls, "Hodgkin paragranuloma, nodular",
                PermissibleValue(text="Hodgkin paragranuloma, nodular") )
        setattr(cls, "Thymoma, type B2, malignant",
                PermissibleValue(text="Thymoma, type B2, malignant") )
        setattr(cls, "Small cell carcinoma, fusiform cell",
                PermissibleValue(text="Small cell carcinoma, fusiform cell") )
        setattr(cls, "Somatostatin cell tumor, malignant",
                PermissibleValue(text="Somatostatin cell tumor, malignant") )
        setattr(cls, "Choroid plexus papilloma, anaplastic",
                PermissibleValue(text="Choroid plexus papilloma, anaplastic") )
        setattr(cls, "Clear cell cystic tumor of borderline malignancy",
                PermissibleValue(text="Clear cell cystic tumor of borderline malignancy") )
        setattr(cls, "Malignant lymphoma, diffuse, NOS",
                PermissibleValue(text="Malignant lymphoma, diffuse, NOS") )
        setattr(cls, "Esophageal squamous intraepithelial neoplasia (dysplasia), high grade",
                PermissibleValue(text="Esophageal squamous intraepithelial neoplasia (dysplasia), high grade") )
        setattr(cls, "Mixed liposarcoma",
                PermissibleValue(text="Mixed liposarcoma") )
        setattr(cls, "Mixed endocrine and exocrine adenocarcinoma",
                PermissibleValue(text="Mixed endocrine and exocrine adenocarcinoma") )
        setattr(cls, "Mixed adenocarcinoma and epidermoid carcinoma",
                PermissibleValue(text="Mixed adenocarcinoma and epidermoid carcinoma") )
        setattr(cls, "NK/T-cell lymphoma, nasal and nasal-type",
                PermissibleValue(text="NK/T-cell lymphoma, nasal and nasal-type") )
        setattr(cls, "Well differentiated liposarcoma of superficial soft tissue",
                PermissibleValue(text="Well differentiated liposarcoma of superficial soft tissue") )
        setattr(cls, "Aleukemic myelogenous leukemia",
                PermissibleValue(text="Aleukemic myelogenous leukemia") )
        setattr(cls, "Scirrhous carcinoma",
                PermissibleValue(text="Scirrhous carcinoma") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "Hodgkin disease, nodular sclerosis, mixed cellularity",
                PermissibleValue(text="Hodgkin disease, nodular sclerosis, mixed cellularity") )
        setattr(cls, "Papillary serous tumor of low malignant potential",
                PermissibleValue(text="Papillary serous tumor of low malignant potential") )
        setattr(cls, "Acinar cell cystadenocarcinoma",
                PermissibleValue(text="Acinar cell cystadenocarcinoma",
                                 description="Pancreatic Acinar Cell Cystadenocarcinoma") )
        setattr(cls, "Refractory anemia with ringed sideroblasts",
                PermissibleValue(text="Refractory anemia with ringed sideroblasts") )
        setattr(cls, "Struma ovarii, NOS",
                PermissibleValue(text="Struma ovarii, NOS") )
        setattr(cls, "Aggressive osteoblastoma",
                PermissibleValue(text="Aggressive osteoblastoma") )
        setattr(cls, "Thymoma, mixed type, NOS",
                PermissibleValue(text="Thymoma, mixed type, NOS") )
        setattr(cls, "Eosinophil adenoma",
                PermissibleValue(text="Eosinophil adenoma") )
        setattr(cls, "Nodular hidradenoma, malignant",
                PermissibleValue(text="Nodular hidradenoma, malignant") )
        setattr(cls, "Hurthle cell carcinoma",
                PermissibleValue(text="Hurthle cell carcinoma") )
        setattr(cls, "Chronic myelocytic leukemia, NOS",
                PermissibleValue(text="Chronic myelocytic leukemia, NOS") )
        setattr(cls, "Hilar cell tumor",
                PermissibleValue(text="Hilar cell tumor") )
        setattr(cls, "Lymphosarcoma, NOS",
                PermissibleValue(text="Lymphosarcoma, NOS") )
        setattr(cls, "Adamantinoma of long bones",
                PermissibleValue(text="Adamantinoma of long bones") )
        setattr(cls, "Grawitz tumor",
                PermissibleValue(text="Grawitz tumor") )
        setattr(cls, "Juvenile hemangioma",
                PermissibleValue(text="Juvenile hemangioma") )
        setattr(cls, "Serous cystadenoma, NOS",
                PermissibleValue(text="Serous cystadenoma, NOS") )
        setattr(cls, "Familial polyposis coli",
                PermissibleValue(text="Familial polyposis coli") )
        setattr(cls, "Intraductal papillary neoplasm with low grade intraepithelial neoplasia",
                PermissibleValue(text="Intraductal papillary neoplasm with low grade intraepithelial neoplasia") )
        setattr(cls, "Mixed acinar-endocrine carcinoma",
                PermissibleValue(text="Mixed acinar-endocrine carcinoma") )
        setattr(cls, "Multiple adenomatous polyps",
                PermissibleValue(text="Multiple adenomatous polyps") )
        setattr(cls, "Combined/mixed carcinoid and adenocarcinoma",
                PermissibleValue(text="Combined/mixed carcinoid and adenocarcinoma") )
        setattr(cls, "Clear cell ependymoma",
                PermissibleValue(text="Clear cell ependymoma") )
        setattr(cls, "Essential thrombocythemia",
                PermissibleValue(text="Essential thrombocythemia") )
        setattr(cls, "Clear cell (glycogen-rich) urothelial carcinoma",
                PermissibleValue(text="Clear cell (glycogen-rich) urothelial carcinoma") )
        setattr(cls, "Desmoplastic melanoma, malignant",
                PermissibleValue(text="Desmoplastic melanoma, malignant") )
        setattr(cls, "Papillary pseudomucinous cystadenoma, borderline malignancy",
                PermissibleValue(text="Papillary pseudomucinous cystadenoma, borderline malignancy") )
        setattr(cls, "Chronic idiopathic myelofibrosis",
                PermissibleValue(text="Chronic idiopathic myelofibrosis") )
        setattr(cls, "Hemangioendothelial sarcoma",
                PermissibleValue(text="Hemangioendothelial sarcoma") )
        setattr(cls, "Basaloid carcinoma",
                PermissibleValue(text="Basaloid carcinoma") )
        setattr(cls, "Malignant giant cell tumor of soft parts",
                PermissibleValue(text="Malignant giant cell tumor of soft parts") )
        setattr(cls, "Pagetoid reticulosis",
                PermissibleValue(text="Pagetoid reticulosis") )
        setattr(cls, "Hepatocellular carcinoma, pleomorphic type",
                PermissibleValue(text="Hepatocellular carcinoma, pleomorphic type") )
        setattr(cls, "Hairy cell leukemia variant",
                PermissibleValue(text="Hairy cell leukemia variant") )
        setattr(cls, "Ductal carcinoma in situ, papillary",
                PermissibleValue(text="Ductal carcinoma in situ, papillary") )
        setattr(cls, "Mucinous cystic neoplasm with intermediate-grade intraepithelial neoplasia",
                PermissibleValue(text="Mucinous cystic neoplasm with intermediate-grade intraepithelial neoplasia") )
        setattr(cls, "Myelosclerosis with myeloid metaplasia",
                PermissibleValue(text="Myelosclerosis with myeloid metaplasia") )
        setattr(cls, "Follicular thyroid carcinoma (FTC), encapsulated angioinvasive",
                PermissibleValue(text="Follicular thyroid carcinoma (FTC), encapsulated angioinvasive") )
        setattr(cls, "Psammomatous schwannoma",
                PermissibleValue(text="Psammomatous schwannoma") )
        setattr(cls, "Malignant lymphoma, centrocytic",
                PermissibleValue(text="Malignant lymphoma, centrocytic") )
        setattr(cls, "Soft tissue sarcoma",
                PermissibleValue(text="Soft tissue sarcoma") )
        setattr(cls, "Krukenberg tumor",
                PermissibleValue(text="Krukenberg tumor") )
        setattr(cls, "Neuroendocrine carcinoma, poorly differentiated",
                PermissibleValue(text="Neuroendocrine carcinoma, poorly differentiated") )
        setattr(cls, "Genital rhabdomyoma",
                PermissibleValue(text="Genital rhabdomyoma") )
        setattr(cls, "G cell tumor, NOS",
                PermissibleValue(text="G cell tumor, NOS") )
        setattr(cls, "Histiocytosis X, NOS",
                PermissibleValue(text="Histiocytosis X, NOS") )
        setattr(cls, "Brenner tumor, proliferating",
                PermissibleValue(text="Brenner tumor, proliferating") )
        setattr(cls, "Myelodysplastic/myeloproliferative neoplasm, unclassifiable",
                PermissibleValue(text="Myelodysplastic/myeloproliferative neoplasm, unclassifiable") )
        setattr(cls, "Waldenstrom macroglobulinemia",
                PermissibleValue(text="Waldenstrom macroglobulinemia") )
        setattr(cls, "Precursor cell lymphoblastic lymphoma, NOS",
                PermissibleValue(text="Precursor cell lymphoblastic lymphoma, NOS") )
        setattr(cls, "Medulloblastoma, classic",
                PermissibleValue(text="Medulloblastoma, classic") )
        setattr(cls, "Well differentiated papillary mesothelioma, benign",
                PermissibleValue(text="Well differentiated papillary mesothelioma, benign") )
        setattr(cls, "Arrhenoblastoma, NOS",
                PermissibleValue(text="Arrhenoblastoma, NOS") )
        setattr(cls, "Phyllodes tumor, benign",
                PermissibleValue(text="Phyllodes tumor, benign") )
        setattr(cls, "Malignant lymphoma, large B-cell, NOS",
                PermissibleValue(text="Malignant lymphoma, large B-cell, NOS") )
        setattr(cls, "Hemangioma, NOS",
                PermissibleValue(text="Hemangioma, NOS") )
        setattr(cls, "Serous surface papillary tumor of borderline malignancy",
                PermissibleValue(text="Serous surface papillary tumor of borderline malignancy") )
        setattr(cls, "Granulosa cell tumor, malignant",
                PermissibleValue(text="Granulosa cell tumor, malignant") )
        setattr(cls, "Gangliocytic paraganglioma",
                PermissibleValue(text="Gangliocytic paraganglioma") )
        setattr(cls, "Malignant schwannoma, NOS",
                PermissibleValue(text="Malignant schwannoma, NOS") )
        setattr(cls, "Osteochondromatosis, NOS",
                PermissibleValue(text="Osteochondromatosis, NOS") )
        setattr(cls, "Urothelial carcinoma with squamous differentiation",
                PermissibleValue(text="Urothelial carcinoma with squamous differentiation") )
        setattr(cls, "Large cell (Ki-1+) lymphoma",
                PermissibleValue(text="Large cell (Ki-1+) lymphoma") )
        setattr(cls, "Acute myelocytic leukemia",
                PermissibleValue(text="Acute myelocytic leukemia") )
        setattr(cls, "Mixed phenotype acute leukemia with t(9;22)(q34;q11.2); BCR-ABL1",
                PermissibleValue(text="Mixed phenotype acute leukemia with t(9;22)(q34;q11.2); BCR-ABL1") )
        setattr(cls, "Ductal papilloma",
                PermissibleValue(text="Ductal papilloma") )
        setattr(cls, "Classical Hodgkin lymphoma, nodular sclerosis, grade 1",
                PermissibleValue(text="Classical Hodgkin lymphoma, nodular sclerosis, grade 1") )
        setattr(cls, "Malignant lymphoma, lymphocytic, diffuse, NOS",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, diffuse, NOS") )
        setattr(cls, "Bile duct adenoma",
                PermissibleValue(text="Bile duct adenoma") )
        setattr(cls, "Juvenile chronic myelomonocytic leukemia",
                PermissibleValue(text="Juvenile chronic myelomonocytic leukemia") )
        setattr(cls, "Sertoli cell adenoma",
                PermissibleValue(text="Sertoli cell adenoma") )
        setattr(cls, "Serous cystadenocarcinofibroma",
                PermissibleValue(text="Serous cystadenocarcinofibroma") )
        setattr(cls, "Thymoma, cortical, malignant",
                PermissibleValue(text="Thymoma, cortical, malignant") )
        setattr(cls, "Papillary serous cystadenoma, borderline malignancy",
                PermissibleValue(text="Papillary serous cystadenoma, borderline malignancy") )
        setattr(cls, "Papillary mucinous cystadenocarcinoma",
                PermissibleValue(text="Papillary mucinous cystadenocarcinoma") )
        setattr(cls, "Cellular leiomyoma",
                PermissibleValue(text="Cellular leiomyoma") )
        setattr(cls, "Malignant serous adenofibroma",
                PermissibleValue(text="Malignant serous adenofibroma") )
        setattr(cls, "Balloon cell melanoma",
                PermissibleValue(text="Balloon cell melanoma") )
        setattr(cls, "Therapy-related myelodysplastic syndrome, NOS",
                PermissibleValue(text="Therapy-related myelodysplastic syndrome, NOS") )
        setattr(cls, "Fibrous mesothelioma, benign",
                PermissibleValue(text="Fibrous mesothelioma, benign") )
        setattr(cls, "Cribriform carcinoma in situ",
                PermissibleValue(text="Cribriform carcinoma in situ") )
        setattr(cls, "Malignant lymphoma, large cell, cleaved, diffuse",
                PermissibleValue(text="Malignant lymphoma, large cell, cleaved, diffuse") )
        setattr(cls, "Solid and cystic tumor",
                PermissibleValue(text="Solid and cystic tumor") )
        setattr(cls, "Cylindroma of skin",
                PermissibleValue(text="Cylindroma of skin") )
        setattr(cls, "Chondromatous giant cell tumor",
                PermissibleValue(text="Chondromatous giant cell tumor") )
        setattr(cls, "Embryonal rhabdomyosarcoma, NOS",
                PermissibleValue(text="Embryonal rhabdomyosarcoma, NOS") )
        setattr(cls, "Noninfiltrating intraductal papillary adenocarcinoma",
                PermissibleValue(text="Noninfiltrating intraductal papillary adenocarcinoma") )
        setattr(cls, "Liver cell adenoma",
                PermissibleValue(text="Liver cell adenoma") )
        setattr(cls, "Follicular adenocarcinoma, moderately differentiated",
                PermissibleValue(text="Follicular adenocarcinoma, moderately differentiated") )
        setattr(cls, "Seminoma with high mitotic index",
                PermissibleValue(text="Seminoma with high mitotic index") )
        setattr(cls, "Therapy related myeloid neoplasm",
                PermissibleValue(text="Therapy related myeloid neoplasm") )
        setattr(cls, "Subacute lymphatic leukemia",
                PermissibleValue(text="Subacute lymphatic leukemia") )
        setattr(cls, "Neuroendocrine tumor, well differentiated",
                PermissibleValue(text="Neuroendocrine tumor, well differentiated") )
        setattr(cls, "Non-invasive mammary carcinoma",
                PermissibleValue(text="Non-invasive mammary carcinoma") )
        setattr(cls, "MPNST with mesenchymal differentiation",
                PermissibleValue(text="MPNST with mesenchymal differentiation") )
        setattr(cls, "Acute myeloid leukemia with t(6;9)(p23;q34); DEK-NUP214",
                PermissibleValue(text="Acute myeloid leukemia with t(6;9)(p23;q34); DEK-NUP214") )
        setattr(cls, "Jadassohn blue nevus",
                PermissibleValue(text="Jadassohn blue nevus") )
        setattr(cls, "Intraductal papillary adenocarcinoma with invasion",
                PermissibleValue(text="Intraductal papillary adenocarcinoma with invasion") )
        setattr(cls, "Atypical proliferating clear cell tumor",
                PermissibleValue(text="Atypical proliferating clear cell tumor") )
        setattr(cls, "Nerve sheath myxoma",
                PermissibleValue(text="Nerve sheath myxoma") )
        setattr(cls, "Transitional papilloma, inverted, benign",
                PermissibleValue(text="Transitional papilloma, inverted, benign") )
        setattr(cls, "Chronic myelomonocytic leukemia, Type 1",
                PermissibleValue(text="Chronic myelomonocytic leukemia, Type 1") )
        setattr(cls, "Malignant melanoma in junctional nevus",
                PermissibleValue(text="Malignant melanoma in junctional nevus") )
        setattr(cls, "Hodgkin paragranuloma, NOS",
                PermissibleValue(text="Hodgkin paragranuloma, NOS") )
        setattr(cls, "Mesothelial papilloma",
                PermissibleValue(text="Mesothelial papilloma") )
        setattr(cls, "Pleuropulmonary blastoma",
                PermissibleValue(text="Pleuropulmonary blastoma") )
        setattr(cls, "Skin-associated lymphoid tissue lymphoma",
                PermissibleValue(text="Skin-associated lymphoid tissue lymphoma") )
        setattr(cls, "Papillotubular adenoma",
                PermissibleValue(text="Papillotubular adenoma") )
        setattr(cls, "Lymphangioendothelioma, malignant",
                PermissibleValue(text="Lymphangioendothelioma, malignant") )
        setattr(cls, "Ependymoma, RELA fusion-positive",
                PermissibleValue(text="Ependymoma, RELA fusion-positive") )
        setattr(cls, "Myxoma, NOS",
                PermissibleValue(text="Myxoma, NOS") )
        setattr(cls, "Fibrosarcomatous dermatofibrosarcoma protuberans",
                PermissibleValue(text="Fibrosarcomatous dermatofibrosarcoma protuberans") )
        setattr(cls, "Signet ring cell adenocarcinoma",
                PermissibleValue(text="Signet ring cell adenocarcinoma") )
        setattr(cls, "Monocytoid B-cell lymphoma",
                PermissibleValue(text="Monocytoid B-cell lymphoma") )
        setattr(cls, "Pleomorphic lobular carcinoma",
                PermissibleValue(text="Pleomorphic lobular carcinoma") )
        setattr(cls, "Malignant serous cystadenofibroma",
                PermissibleValue(text="Malignant serous cystadenofibroma") )
        setattr(cls, "Ameloblastic fibro-odontoma",
                PermissibleValue(text="Ameloblastic fibro-odontoma") )
        setattr(cls, "Myeloid and lymphoid neoplasms with PDGFRA rearrangement",
                PermissibleValue(text="Myeloid and lymphoid neoplasms with PDGFRA rearrangement") )
        setattr(cls, "Acute myeloid leukemia, PML/RAR-alpha",
                PermissibleValue(text="Acute myeloid leukemia, PML/RAR-alpha") )
        setattr(cls, "Neurofibromatosis, NOS",
                PermissibleValue(text="Neurofibromatosis, NOS") )
        setattr(cls, "Cementifying fibroma",
                PermissibleValue(text="Cementifying fibroma") )
        setattr(cls, "Monoclonal gammopathy, NOS",
                PermissibleValue(text="Monoclonal gammopathy, NOS") )
        setattr(cls, "Pituitary adenoma, NOS",
                PermissibleValue(text="Pituitary adenoma, NOS") )
        setattr(cls, "Indeterminate dendritic cell tumor",
                PermissibleValue(text="Indeterminate dendritic cell tumor") )
        setattr(cls, "Papillary carcinoma of thyroid",
                PermissibleValue(text="Papillary carcinoma of thyroid") )
        setattr(cls, "Fibroepithelioma of Pinkus type",
                PermissibleValue(text="Fibroepithelioma of Pinkus type") )
        setattr(cls, "Pancreatic endocrine tumor, NOS",
                PermissibleValue(text="Pancreatic endocrine tumor, NOS") )
        setattr(cls, "Lymphatic leukemic, NOS",
                PermissibleValue(text="Lymphatic leukemic, NOS") )
        setattr(cls, "T/NK-cell lymphoma",
                PermissibleValue(text="T/NK-cell lymphoma") )
        setattr(cls, "MiT family translocation renal cell carcinoma",
                PermissibleValue(text="MiT family translocation renal cell carcinoma",
                                 description="MiT Family Translocation-Associated Renal Cell Carcinoma") )
        setattr(cls, "Fibroma, NOS",
                PermissibleValue(text="Fibroma, NOS") )
        setattr(cls, "Spongioblastoma multiforme",
                PermissibleValue(text="Spongioblastoma multiforme") )
        setattr(cls, "Liposarcoma, well differentiated",
                PermissibleValue(text="Liposarcoma, well differentiated") )
        setattr(cls, "Large cell carcinoma with rhabdoid phenotype",
                PermissibleValue(text="Large cell carcinoma with rhabdoid phenotype") )
        setattr(cls, "Fibroblastic reticular cell tumor",
                PermissibleValue(text="Fibroblastic reticular cell tumor") )
        setattr(cls, "Acute promyelocytic leukaemia, PML-RAR-alpha",
                PermissibleValue(text="Acute promyelocytic leukaemia, PML-RAR-alpha") )
        setattr(cls, "Clear cell cystadenocarcinofibroma",
                PermissibleValue(text="Clear cell cystadenocarcinofibroma") )
        setattr(cls, "Large granular lymphocytosis, NOS",
                PermissibleValue(text="Large granular lymphocytosis, NOS") )
        setattr(cls, "Renal cell carcinoma, spindle cell",
                PermissibleValue(text="Renal cell carcinoma, spindle cell") )
        setattr(cls, "T-zone lymphoma",
                PermissibleValue(text="T-zone lymphoma") )
        setattr(cls, "Hemangioma simplex",
                PermissibleValue(text="Hemangioma simplex") )
        setattr(cls, "Spindle cell carcinoma, NOS",
                PermissibleValue(text="Spindle cell carcinoma, NOS") )
        setattr(cls, "Invasive mammary carcinoma",
                PermissibleValue(text="Invasive mammary carcinoma") )
        setattr(cls, "Matrical carcinoma",
                PermissibleValue(text="Matrical carcinoma") )
        setattr(cls, "Black adenoma",
                PermissibleValue(text="Black adenoma") )
        setattr(cls, "Malignant lymphoma, small lymphocytic, NOS",
                PermissibleValue(text="Malignant lymphoma, small lymphocytic, NOS") )
        setattr(cls, "Malignant mucinous cystadenofibroma",
                PermissibleValue(text="Malignant mucinous cystadenofibroma") )
        setattr(cls, "Differentiated penile intraepithelial neoplasia",
                PermissibleValue(text="Differentiated penile intraepithelial neoplasia") )
        setattr(cls, "Mycosis fungoides",
                PermissibleValue(text="Mycosis fungoides") )
        setattr(cls, "Juvenile histiocytoma",
                PermissibleValue(text="Juvenile histiocytoma") )
        setattr(cls, "Transitional cell carcinoma in situ",
                PermissibleValue(text="Transitional cell carcinoma in situ") )
        setattr(cls, "Epithelioid leiomyosarcoma",
                PermissibleValue(text="Epithelioid leiomyosarcoma") )
        setattr(cls, "Prolymphocytic leukemia, B-cell type",
                PermissibleValue(text="Prolymphocytic leukemia, B-cell type") )
        setattr(cls, "Balloon cell nevus",
                PermissibleValue(text="Balloon cell nevus") )
        setattr(cls, "Papillary and follicular adenocarcinoma",
                PermissibleValue(text="Papillary and follicular adenocarcinoma") )
        setattr(cls, "Malignant tumor, clear cell type",
                PermissibleValue(text="Malignant tumor, clear cell type") )
        setattr(cls, "Plexiform neurofibroma",
                PermissibleValue(text="Plexiform neurofibroma") )
        setattr(cls, "Monocytic leukemia, NOS",
                PermissibleValue(text="Monocytic leukemia, NOS") )
        setattr(cls, "Unclassified tumor, benign",
                PermissibleValue(text="Unclassified tumor, benign") )
        setattr(cls, "Mammary carcinoma, in situ",
                PermissibleValue(text="Mammary carcinoma, in situ") )
        setattr(cls, "Microfollicular adenoma, NOS",
                PermissibleValue(text="Microfollicular adenoma, NOS") )
        setattr(cls, "Adenosquamous carcinoma",
                PermissibleValue(text="Adenosquamous carcinoma") )
        setattr(cls, "Adenocarcinoma in situ in tubular adenoma",
                PermissibleValue(text="Adenocarcinoma in situ in tubular adenoma") )
        setattr(cls, "Hairy nevus",
                PermissibleValue(text="Hairy nevus") )
        setattr(cls, "Traditional serrated adenoma",
                PermissibleValue(text="Traditional serrated adenoma") )
        setattr(cls, "Hydroa vacciniforme-like lymphoma",
                PermissibleValue(text="Hydroa vacciniforme-like lymphoma") )
        setattr(cls, "Craniopharyngioma, papillary",
                PermissibleValue(text="Craniopharyngioma, papillary") )
        setattr(cls, "Mucinous cystadenofibroma, NOS",
                PermissibleValue(text="Mucinous cystadenofibroma, NOS") )
        setattr(cls, "Cystosarcoma phyllodes, benign",
                PermissibleValue(text="Cystosarcoma phyllodes, benign") )
        setattr(cls, "Chordoid meningioma",
                PermissibleValue(text="Chordoid meningioma") )
        setattr(cls, "Common ALL",
                PermissibleValue(text="Common ALL") )
        setattr(cls, "Mesothelioma, biphasic, malignant",
                PermissibleValue(text="Mesothelioma, biphasic, malignant") )
        setattr(cls, "Brooke tumor",
                PermissibleValue(text="Brooke tumor") )
        setattr(cls, "Glandular papilloma",
                PermissibleValue(text="Glandular papilloma") )
        setattr(cls, "Hilus cell tumor",
                PermissibleValue(text="Hilus cell tumor") )
        setattr(cls, "Acinar carcinoma",
                PermissibleValue(text="Acinar carcinoma") )
        setattr(cls, "Bronchiolo-alveolar carcinoma, indeterminate type",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma, indeterminate type") )
        setattr(cls, "Metatypical carcinoma",
                PermissibleValue(text="Metatypical carcinoma") )
        setattr(cls, "Adenocarcinoma in multiple adenomatous polyps",
                PermissibleValue(text="Adenocarcinoma in multiple adenomatous polyps") )
        setattr(cls, "Osteoblastoma, malignant",
                PermissibleValue(text="Osteoblastoma, malignant") )
        setattr(cls, "Hodgkin disease, nodular sclerosis, NOS",
                PermissibleValue(text="Hodgkin disease, nodular sclerosis, NOS") )
        setattr(cls, "Merkel cell tumor",
                PermissibleValue(text="Merkel cell tumor") )
        setattr(cls, "c-ALL",
                PermissibleValue(text="c-ALL") )
        setattr(cls, "Lymphoepithelioma-like carcinoma",
                PermissibleValue(text="Lymphoepithelioma-like carcinoma") )
        setattr(cls, "Meningeal melanoma",
                PermissibleValue(text="Meningeal melanoma") )
        setattr(cls, "Adenocarcinoma, diffuse type",
                PermissibleValue(text="Adenocarcinoma, diffuse type") )
        setattr(cls, "Intraductal papillary mucinous neoplasm (IPMN) with an associated invasive carcinoma",
                PermissibleValue(text="Intraductal papillary mucinous neoplasm (IPMN) with an associated invasive carcinoma") )
        setattr(cls, "Sertoli-Leydig cell tumor of intermediate differentiation",
                PermissibleValue(text="Sertoli-Leydig cell tumor of intermediate differentiation") )
        setattr(cls, "Degenerated schwannoma",
                PermissibleValue(text="Degenerated schwannoma") )
        setattr(cls, "Unclassified tumor, borderline malignancy",
                PermissibleValue(text="Unclassified tumor, borderline malignancy") )
        setattr(cls, "Malignant lymphoma, immunoblastic, NOS",
                PermissibleValue(text="Malignant lymphoma, immunoblastic, NOS") )
        setattr(cls, "Infantile fibrosarcoma",
                PermissibleValue(text="Infantile fibrosarcoma") )
        setattr(cls, "Tumor cells, NOS",
                PermissibleValue(text="Tumor cells, NOS") )
        setattr(cls, "Endometrioid adenofibroma, malignant",
                PermissibleValue(text="Endometrioid adenofibroma, malignant") )
        setattr(cls, "Cutaneous mastocytosis",
                PermissibleValue(text="Cutaneous mastocytosis") )
        setattr(cls, "Follicular lymphoma, grade 1",
                PermissibleValue(text="Follicular lymphoma, grade 1") )
        setattr(cls, "Undifferentiated sarcoma",
                PermissibleValue(text="Undifferentiated sarcoma") )
        setattr(cls, "Hepatosplenic T-cell lymphoma",
                PermissibleValue(text="Hepatosplenic T-cell lymphoma") )
        setattr(cls, "Squamous cell carcinoma, HPV-negative",
                PermissibleValue(text="Squamous cell carcinoma, HPV-negative") )
        setattr(cls, "Endometrioid cystadenoma, NOS",
                PermissibleValue(text="Endometrioid cystadenoma, NOS") )
        setattr(cls, "Villous adenoma, NOS",
                PermissibleValue(text="Villous adenoma, NOS") )
        setattr(cls, "Leydig cell tumor, NOS",
                PermissibleValue(text="Leydig cell tumor, NOS") )
        setattr(cls, "Hepatocellular adenoma",
                PermissibleValue(text="Hepatocellular adenoma") )
        setattr(cls, "Acute lymphoblastic leukemia, mature B-cell type",
                PermissibleValue(text="Acute lymphoblastic leukemia, mature B-cell type") )
        setattr(cls, "Systemic mastocytosis with associated hematological clonal non-mast cell disorder",
                PermissibleValue(text="Systemic mastocytosis with associated hematological clonal non-mast cell disorder") )
        setattr(cls, "Tubulo-papillary adenoma",
                PermissibleValue(text="Tubulo-papillary adenoma") )
        setattr(cls, "Endodermal sinus tumor",
                PermissibleValue(text="Endodermal sinus tumor") )
        setattr(cls, "Gastrointestinal autonomic nerve tumor",
                PermissibleValue(text="Gastrointestinal autonomic nerve tumor") )
        setattr(cls, "Malignant lymphoma, histiocytic, nodular",
                PermissibleValue(text="Malignant lymphoma, histiocytic, nodular") )
        setattr(cls, "Malignant tumor, fusiform cell type",
                PermissibleValue(text="Malignant tumor, fusiform cell type") )
        setattr(cls, "Cementoma, NOS",
                PermissibleValue(text="Cementoma, NOS") )
        setattr(cls, "Mucinous cystadenocarcinoma, non-invasive",
                PermissibleValue(text="Mucinous cystadenocarcinoma, non-invasive") )
        setattr(cls, "Malignant lymphoma, undifferentiated cell, non-Burkitt",
                PermissibleValue(text="Malignant lymphoma, undifferentiated cell, non-Burkitt") )
        setattr(cls, "Mixed type rhabdomyosarcoma",
                PermissibleValue(text="Mixed type rhabdomyosarcoma") )
        setattr(cls, "Gastrointestinal stromal tumor, NOS",
                PermissibleValue(text="Gastrointestinal stromal tumor, NOS") )
        setattr(cls, "Malignant lymphoma, lymphocytic, poorly differentiated, diffuse",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, poorly differentiated, diffuse") )
        setattr(cls, "Mesonephroma, NOS",
                PermissibleValue(text="Mesonephroma, NOS") )
        setattr(cls, "Duct adenoma, NOS",
                PermissibleValue(text="Duct adenoma, NOS") )
        setattr(cls, "Langerhans cell histiocytosis, disseminated",
                PermissibleValue(text="Langerhans cell histiocytosis, disseminated") )
        setattr(cls, "Osteosarcoma in Paget disease of bone",
                PermissibleValue(text="Osteosarcoma in Paget disease of bone") )
        setattr(cls, "Ovarian stromal tumor",
                PermissibleValue(text="Ovarian stromal tumor") )
        setattr(cls, "Pick tubular adenoma",
                PermissibleValue(text="Pick tubular adenoma") )
        setattr(cls, "Lobular carcinoma in situ, NOS",
                PermissibleValue(text="Lobular carcinoma in situ, NOS") )
        setattr(cls, "Malignant lymphoma, lymphocytic, well differentiated, diffuse",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, well differentiated, diffuse") )
        setattr(cls, "Mesenchymal tumor, malignant",
                PermissibleValue(text="Mesenchymal tumor, malignant") )
        setattr(cls, "Villoglandular adenoma",
                PermissibleValue(text="Villoglandular adenoma") )
        setattr(cls, "Thecoma, malignant",
                PermissibleValue(text="Thecoma, malignant") )
        setattr(cls, "Papilloma, NOS",
                PermissibleValue(text="Papilloma, NOS") )
        setattr(cls, "Glucagonoma, malignant",
                PermissibleValue(text="Glucagonoma, malignant") )
        setattr(cls, "Tumor cells, uncertain whether benign or malignant",
                PermissibleValue(text="Tumor cells, uncertain whether benign or malignant") )
        setattr(cls, "Myxoid liposarcoma",
                PermissibleValue(text="Myxoid liposarcoma") )
        setattr(cls, "Papillary pseudomucinous cystadenoma, NOS",
                PermissibleValue(text="Papillary pseudomucinous cystadenoma, NOS") )
        setattr(cls, "Low-grade intramedullary osteosarcoma",
                PermissibleValue(text="Low-grade intramedullary osteosarcoma") )
        setattr(cls, "Glioblastoma multiforme",
                PermissibleValue(text="Glioblastoma multiforme") )
        setattr(cls, "Mucoid carcinoma",
                PermissibleValue(text="Mucoid carcinoma") )
        setattr(cls, "Malignant lymphoma, small cell diffuse",
                PermissibleValue(text="Malignant lymphoma, small cell diffuse") )
        setattr(cls, "Primary cutaneous neuroendocrine carcinoma",
                PermissibleValue(text="Primary cutaneous neuroendocrine carcinoma") )
        setattr(cls, "Mucinous carcinoma, intestinal type",
                PermissibleValue(text="Mucinous carcinoma, intestinal type") )
        setattr(cls, "Choroid plexus papilloma, malignant",
                PermissibleValue(text="Choroid plexus papilloma, malignant") )
        setattr(cls, "Odontogenic tumor, malignant",
                PermissibleValue(text="Odontogenic tumor, malignant") )
        setattr(cls, "Mucosal-associated lymphoid tissue lymphoma",
                PermissibleValue(text="Mucosal-associated lymphoid tissue lymphoma") )
        setattr(cls, "Pinkus tumor",
                PermissibleValue(text="Pinkus tumor") )
        setattr(cls, "Blast cell leukemia",
                PermissibleValue(text="Blast cell leukemia") )
        setattr(cls, "Lepidic adenocarcinoma",
                PermissibleValue(text="Lepidic adenocarcinoma") )
        setattr(cls, "Mucinous cystic neoplasm with an associated invasive carcinoma",
                PermissibleValue(text="Mucinous cystic neoplasm with an associated invasive carcinoma",
                                 description="Bile Duct Cystadenocarcinoma") )
        setattr(cls, "Pseudomucinous cystadenoma, borderline malignancy",
                PermissibleValue(text="Pseudomucinous cystadenoma, borderline malignancy") )
        setattr(cls, "Lipoma, NOS",
                PermissibleValue(text="Lipoma, NOS") )
        setattr(cls, "Noninvasive pancreatobiliary papillary neoplasm with high grade dysplasia",
                PermissibleValue(text="Noninvasive pancreatobiliary papillary neoplasm with high grade dysplasia") )
        setattr(cls, "Unclassified tumor, malignant, uncertain whether primary or metastatic",
                PermissibleValue(text="Unclassified tumor, malignant, uncertain whether primary or metastatic") )
        setattr(cls, "Psammomatous meningioma",
                PermissibleValue(text="Psammomatous meningioma") )
        setattr(cls, "Sweat gland carcinoma",
                PermissibleValue(text="Sweat gland carcinoma") )
        setattr(cls, "Malignant myelosclerosis",
                PermissibleValue(text="Malignant myelosclerosis") )
        setattr(cls, "Canalicular adenoma",
                PermissibleValue(text="Canalicular adenoma") )
        setattr(cls, "T-cell rich large B-cell lymphoma",
                PermissibleValue(text="T-cell rich large B-cell lymphoma") )
        setattr(cls, "Teratoma, benign",
                PermissibleValue(text="Teratoma, benign") )
        setattr(cls, "Therapy-related myelodysplastic syndrome, epipodophyllotoxin-related",
                PermissibleValue(text="Therapy-related myelodysplastic syndrome, epipodophyllotoxin-related") )
        setattr(cls, "Subacute lymphoid leukemia",
                PermissibleValue(text="Subacute lymphoid leukemia") )
        setattr(cls, "Struma ovarii, malignant",
                PermissibleValue(text="Struma ovarii, malignant") )
        setattr(cls, "Sessile serrated polyp",
                PermissibleValue(text="Sessile serrated polyp") )
        setattr(cls, "Ameloblastic carcinoma",
                PermissibleValue(text="Ameloblastic carcinoma") )
        setattr(cls, "Osteosarcoma, NOS",
                PermissibleValue(text="Osteosarcoma, NOS") )
        setattr(cls, "Malignant lymphoma, large cell, NOS",
                PermissibleValue(text="Malignant lymphoma, large cell, NOS") )
        setattr(cls, "Combined small cell carcinoma",
                PermissibleValue(text="Combined small cell carcinoma") )
        setattr(cls, "Adenocarcinoma in situ, mucinous",
                PermissibleValue(text="Adenocarcinoma in situ, mucinous",
                                 description="Mucinous Lung Adenocarcinoma In Situ") )
        setattr(cls, "Lymphomatoid granulomatosis",
                PermissibleValue(text="Lymphomatoid granulomatosis") )
        setattr(cls, "Oncocytic adenoma",
                PermissibleValue(text="Oncocytic adenoma") )
        setattr(cls, "Adult teratoma, NOS",
                PermissibleValue(text="Adult teratoma, NOS") )
        setattr(cls, "RAEB-T",
                PermissibleValue(text="RAEB-T") )
        setattr(cls, "Enterochromaffin-like cell tumor, malignant",
                PermissibleValue(text="Enterochromaffin-like cell tumor, malignant") )
        setattr(cls, "Paget disease of breast",
                PermissibleValue(text="Paget disease of breast") )
        setattr(cls, "Spindle cell melanoma, type B",
                PermissibleValue(text="Spindle cell melanoma, type B") )
        setattr(cls, "Acute myeloid leukemia, MLL",
                PermissibleValue(text="Acute myeloid leukemia, MLL") )
        setattr(cls, "Mucinous cystic tumor with moderate dysplasia",
                PermissibleValue(text="Mucinous cystic tumor with moderate dysplasia") )
        setattr(cls, "Carcinoid, NOS",
                PermissibleValue(text="Carcinoid, NOS") )
        setattr(cls, "Small cell carcinoma, hypercalcemic type",
                PermissibleValue(text="Small cell carcinoma, hypercalcemic type",
                                 description="Ovarian Small Cell Carcinoma, Hypercalcemic Type") )
        setattr(cls, "Hepatoblastoma, epithelioid",
                PermissibleValue(text="Hepatoblastoma, epithelioid") )
        setattr(cls, "Adenocarcinoma, pancreatobiliary type",
                PermissibleValue(text="Adenocarcinoma, pancreatobiliary type") )
        setattr(cls, "Intraepidermal nevus",
                PermissibleValue(text="Intraepidermal nevus") )
        setattr(cls, "Mesenchymoma, NOS",
                PermissibleValue(text="Mesenchymoma, NOS") )
        setattr(cls, "Extra-abdominal desmoid",
                PermissibleValue(text="Extra-abdominal desmoid") )
        setattr(cls, "Mucinous cystic tumor with an associated invasive carcinoma",
                PermissibleValue(text="Mucinous cystic tumor with an associated invasive carcinoma") )
        setattr(cls, "Gastrinoma, malignant",
                PermissibleValue(text="Gastrinoma, malignant") )
        setattr(cls, "Lentigo maligna",
                PermissibleValue(text="Lentigo maligna") )
        setattr(cls, "AML M6",
                PermissibleValue(text="AML M6") )
        setattr(cls, "Serous adenofibroma of borderline malignancy",
                PermissibleValue(text="Serous adenofibroma of borderline malignancy") )
        setattr(cls, "Tubular carcinoid",
                PermissibleValue(text="Tubular carcinoid") )
        setattr(cls, "Duct adenocarcinoma, NOS",
                PermissibleValue(text="Duct adenocarcinoma, NOS") )
        setattr(cls, "Glomoid sarcoma",
                PermissibleValue(text="Glomoid sarcoma") )
        setattr(cls, "Hurthle cell tumor",
                PermissibleValue(text="Hurthle cell tumor") )
        setattr(cls, "Marginal zone B-cell lymphoma, NOS",
                PermissibleValue(text="Marginal zone B-cell lymphoma, NOS") )
        setattr(cls, "Solid carcinoma with mucin formation",
                PermissibleValue(text="Solid carcinoma with mucin formation") )
        setattr(cls, "Juvenile angiofibroma",
                PermissibleValue(text="Juvenile angiofibroma") )
        setattr(cls, "Intraductal tubulopapillary neoplasm",
                PermissibleValue(text="Intraductal tubulopapillary neoplasm") )
        setattr(cls, "Fibroxanthoma, NOS",
                PermissibleValue(text="Fibroxanthoma, NOS") )
        setattr(cls, "Dedifferentiated chondrosarcoma",
                PermissibleValue(text="Dedifferentiated chondrosarcoma") )
        setattr(cls, "Transitional pineal tumor",
                PermissibleValue(text="Transitional pineal tumor") )
        setattr(cls, "Vipoma, NOS",
                PermissibleValue(text="Vipoma, NOS") )
        setattr(cls, "Transitional cell carcinoma, sarcomatoid",
                PermissibleValue(text="Transitional cell carcinoma, sarcomatoid") )
        setattr(cls, "Intraductal papillary neoplasm with associated invasive carcinoma",
                PermissibleValue(text="Intraductal papillary neoplasm with associated invasive carcinoma") )
        setattr(cls, "Kaposi sarcoma",
                PermissibleValue(text="Kaposi sarcoma") )
        setattr(cls, "Granular cell tumor, NOS",
                PermissibleValue(text="Granular cell tumor, NOS") )
        setattr(cls, "Adenocarcinoma, intestinal type",
                PermissibleValue(text="Adenocarcinoma, intestinal type",
                                 description="Intestinal-Type Adenocarcinoma") )
        setattr(cls, "Carcinoma in adenomatous polyp",
                PermissibleValue(text="Carcinoma in adenomatous polyp") )
        setattr(cls, "Malignant lymphoma, convoluted cell",
                PermissibleValue(text="Malignant lymphoma, convoluted cell") )
        setattr(cls, "Intimal sarcoma",
                PermissibleValue(text="Intimal sarcoma") )
        setattr(cls, "Langerhans cell sarcoma",
                PermissibleValue(text="Langerhans cell sarcoma") )
        setattr(cls, "Tanycytic ependymoma",
                PermissibleValue(text="Tanycytic ependymoma") )
        setattr(cls, "Schneiderian papilloma, inverted",
                PermissibleValue(text="Schneiderian papilloma, inverted") )
        setattr(cls, "Well differentiated thymic carcinoma",
                PermissibleValue(text="Well differentiated thymic carcinoma") )
        setattr(cls, "Malignant teratoma, trophoblastic",
                PermissibleValue(text="Malignant teratoma, trophoblastic") )
        setattr(cls, "Parafollicular cell carcinoma",
                PermissibleValue(text="Parafollicular cell carcinoma") )
        setattr(cls, "Mixed basal-squamous cell carcinoma",
                PermissibleValue(text="Mixed basal-squamous cell carcinoma") )
        setattr(cls, "Hidradenoma, NOS",
                PermissibleValue(text="Hidradenoma, NOS") )
        setattr(cls, "Pigmented spindle cell nevus of Reed",
                PermissibleValue(text="Pigmented spindle cell nevus of Reed") )
        setattr(cls, "Acute lymphoblastic leukemia, precursor cell type",
                PermissibleValue(text="Acute lymphoblastic leukemia, precursor cell type") )
        setattr(cls, "Encapsulated follicular variant of papillary thyroid carcinoma, NOS (EFVPTC, NOS)",
                PermissibleValue(text="Encapsulated follicular variant of papillary thyroid carcinoma, NOS (EFVPTC, NOS)") )
        setattr(cls, "Sezary disease",
                PermissibleValue(text="Sezary disease") )
        setattr(cls, "Serous cystadenofibroma, NOS",
                PermissibleValue(text="Serous cystadenofibroma, NOS") )
        setattr(cls, "Primary intraosseous carcinoma",
                PermissibleValue(text="Primary intraosseous carcinoma") )
        setattr(cls, "Neuroendocrine carcinoma, NOS",
                PermissibleValue(text="Neuroendocrine carcinoma, NOS") )
        setattr(cls, "Retinoblastoma, diffuse",
                PermissibleValue(text="Retinoblastoma, diffuse") )
        setattr(cls, "Gastrointestinal pacemaker cell tumor",
                PermissibleValue(text="Gastrointestinal pacemaker cell tumor") )
        setattr(cls, "Adenocarcinoma in situ in tubulovillous adenoma",
                PermissibleValue(text="Adenocarcinoma in situ in tubulovillous adenoma") )
        setattr(cls, "Epithelioid hemangioendothelioma, NOS",
                PermissibleValue(text="Epithelioid hemangioendothelioma, NOS") )
        setattr(cls, "Embryonal carcinoma, polyembryonal type",
                PermissibleValue(text="Embryonal carcinoma, polyembryonal type") )
        setattr(cls, "Arrhenoblastoma, malignant",
                PermissibleValue(text="Arrhenoblastoma, malignant") )
        setattr(cls, "Spindle cell nevus, NOS",
                PermissibleValue(text="Spindle cell nevus, NOS") )
        setattr(cls, "Histiocytic sarcoma",
                PermissibleValue(text="Histiocytic sarcoma") )
        setattr(cls, "Malignant teratoma, anaplastic",
                PermissibleValue(text="Malignant teratoma, anaplastic") )
        setattr(cls, "Thymoma, lymphocyte-rich, malignant",
                PermissibleValue(text="Thymoma, lymphocyte-rich, malignant") )
        setattr(cls, "Intraductal papillary neoplasm with intermediate grade neoplasia",
                PermissibleValue(text="Intraductal papillary neoplasm with intermediate grade neoplasia") )
        setattr(cls, "Atypical polypoid adenomyoma",
                PermissibleValue(text="Atypical polypoid adenomyoma") )
        setattr(cls, "Mixed ductal-endocrine carcinoma",
                PermissibleValue(text="Mixed ductal-endocrine carcinoma") )
        setattr(cls, "Insular carcinoma",
                PermissibleValue(text="Insular carcinoma") )
        setattr(cls, "Arrhenoblastoma, benign",
                PermissibleValue(text="Arrhenoblastoma, benign") )
        setattr(cls, "Papillary carcinoma, follicular variant",
                PermissibleValue(text="Papillary carcinoma, follicular variant") )
        setattr(cls, "Astrocytoma, anaplastic",
                PermissibleValue(text="Astrocytoma, anaplastic") )
        setattr(cls, "Thymoma, type B1, NOS",
                PermissibleValue(text="Thymoma, type B1, NOS") )
        setattr(cls, "Solitary fibrous tumor/hemangiopericytoma Grade 1 (CNS)",
                PermissibleValue(text="Solitary fibrous tumor/hemangiopericytoma Grade 1 (CNS)") )
        setattr(cls, "Eosinophil carcinoma",
                PermissibleValue(text="Eosinophil carcinoma") )
        setattr(cls, "Sessile serrated adenoma",
                PermissibleValue(text="Sessile serrated adenoma") )
        setattr(cls, "Micropapillary serous carcinoma",
                PermissibleValue(text="Micropapillary serous carcinoma") )
        setattr(cls, "Acute myeloid leukemia with inv(3)(q21q26.2) or t(3;3)(q21;q26.2); RPN1-EVI1",
                PermissibleValue(text="Acute myeloid leukemia with inv(3)(q21q26.2) or t(3;3)(q21;q26.2); RPN1-EVI1") )
        setattr(cls, "Mixed pineocytoma-pineoblastoma",
                PermissibleValue(text="Mixed pineocytoma-pineoblastoma") )
        setattr(cls, "Acoustic neuroma",
                PermissibleValue(text="Acoustic neuroma") )
        setattr(cls, "Endometrioid carcinoma with squamous differentiation",
                PermissibleValue(text="Endometrioid carcinoma with squamous differentiation",
                                 description="Endometrial Squamous Cell Carcinoma") )
        setattr(cls, "Granular cell tumor of the sellar region",
                PermissibleValue(text="Granular cell tumor of the sellar region") )
        setattr(cls, "Intraductal papillary neoplasm with high grade intraepithelial neoplasia",
                PermissibleValue(text="Intraductal papillary neoplasm with high grade intraepithelial neoplasia") )
        setattr(cls, "Embryonal carcinoma, NOS",
                PermissibleValue(text="Embryonal carcinoma, NOS") )
        setattr(cls, "Hodgkin lymphoma, nodular sclerosis, NOS",
                PermissibleValue(text="Hodgkin lymphoma, nodular sclerosis, NOS") )
        setattr(cls, "Complete hydatidiform mole",
                PermissibleValue(text="Complete hydatidiform mole") )
        setattr(cls, "Intraductal tubular-papillary neoplasm, high grade",
                PermissibleValue(text="Intraductal tubular-papillary neoplasm, high grade") )
        setattr(cls, "Anaplastic oligoastrocytoma",
                PermissibleValue(text="Anaplastic oligoastrocytoma") )
        setattr(cls, "Neoplasm, uncertain whether benign or malignant",
                PermissibleValue(text="Neoplasm, uncertain whether benign or malignant") )
        setattr(cls, "Symplastic leiomyoma",
                PermissibleValue(text="Symplastic leiomyoma") )
        setattr(cls, "Hemangioendothelioma, benign",
                PermissibleValue(text="Hemangioendothelioma, benign") )
        setattr(cls, "Small cell carcinoma, intermediate cell",
                PermissibleValue(text="Small cell carcinoma, intermediate cell") )
        setattr(cls, "Serous adenocarcinofibroma",
                PermissibleValue(text="Serous adenocarcinofibroma") )
        setattr(cls, "Juxtacortical chondrosarcoma",
                PermissibleValue(text="Juxtacortical chondrosarcoma") )
        setattr(cls, "Adenomyoepithelioma with carcinoma",
                PermissibleValue(text="Adenomyoepithelioma with carcinoma") )
        setattr(cls, "Malignant multilocular cystic nephroma",
                PermissibleValue(text="Malignant multilocular cystic nephroma") )
        setattr(cls, "Acute myeloid leukemia with t(8;21)(q22;q22); RUNX1-RUNX1T1",
                PermissibleValue(text="Acute myeloid leukemia with t(8;21)(q22;q22); RUNX1-RUNX1T1") )
        setattr(cls, "Sebaceous epithelioma",
                PermissibleValue(text="Sebaceous epithelioma") )
        setattr(cls, "Meningioma, anaplastic",
                PermissibleValue(text="Meningioma, anaplastic") )
        setattr(cls, "Sex cord-gonadal stromal tumor, NOS",
                PermissibleValue(text="Sex cord-gonadal stromal tumor, NOS") )
        setattr(cls, "Chronic granulocytic leukemia, t(9;22)(q34;q11)",
                PermissibleValue(text="Chronic granulocytic leukemia, t(9;22)(q34;q11)") )
        setattr(cls, "Glycogenic rhabdomyoma",
                PermissibleValue(text="Glycogenic rhabdomyoma") )
        setattr(cls, "Therapy-related myelodysplastic syndrome, alkylating agent related",
                PermissibleValue(text="Therapy-related myelodysplastic syndrome, alkylating agent related") )
        setattr(cls, "Goblet cell carcinoid",
                PermissibleValue(text="Goblet cell carcinoid") )
        setattr(cls, "Non-invasive FTP",
                PermissibleValue(text="Non-invasive FTP") )
        setattr(cls, "Papillary squamous cell carcinoma, non-invasive",
                PermissibleValue(text="Papillary squamous cell carcinoma, non-invasive") )
        setattr(cls, "Basal cell epithelioma",
                PermissibleValue(text="Basal cell epithelioma") )
        setattr(cls, "Thymoma, type A, NOS",
                PermissibleValue(text="Thymoma, type A, NOS") )
        setattr(cls, "Choroid plexus papilloma, NOS",
                PermissibleValue(text="Choroid plexus papilloma, NOS") )
        setattr(cls, "Multicentric basal cell carcinoma",
                PermissibleValue(text="Multicentric basal cell carcinoma") )
        setattr(cls, "Acute myeloid leukemia, NOS",
                PermissibleValue(text="Acute myeloid leukemia, NOS") )
        setattr(cls, "Adenomatoid tumor, NOS",
                PermissibleValue(text="Adenomatoid tumor, NOS") )
        setattr(cls, "FAB M6",
                PermissibleValue(text="FAB M6") )
        setattr(cls, "Thymoma, predominantly cortical, NOS",
                PermissibleValue(text="Thymoma, predominantly cortical, NOS") )
        setattr(cls, "Mixed adenomatous and hyperplastic polyp",
                PermissibleValue(text="Mixed adenomatous and hyperplastic polyp") )
        setattr(cls, "Hemangiopericytic meningioma",
                PermissibleValue(text="Hemangiopericytic meningioma") )
        setattr(cls, "Intraepidermal carcinoma, NOS",
                PermissibleValue(text="Intraepidermal carcinoma, NOS") )
        setattr(cls, "Germ cell tumor, NOS",
                PermissibleValue(text="Germ cell tumor, NOS") )
        setattr(cls, "Florid osseous dysplasia",
                PermissibleValue(text="Florid osseous dysplasia") )
        setattr(cls, "Embryonal adenoma",
                PermissibleValue(text="Embryonal adenoma") )
        setattr(cls, "Eccrine adenocarcinoma",
                PermissibleValue(text="Eccrine adenocarcinoma") )
        setattr(cls, "Abdominal fibromatosis",
                PermissibleValue(text="Abdominal fibromatosis") )
        setattr(cls, "Chondrosarcoma grade 2/3",
                PermissibleValue(text="Chondrosarcoma grade 2/3") )
        setattr(cls, "Atypical lipoma",
                PermissibleValue(text="Atypical lipoma") )
        setattr(cls, "Small cell sarcoma",
                PermissibleValue(text="Small cell sarcoma") )
        setattr(cls, "Metaplastic carcinoma, NOS",
                PermissibleValue(text="Metaplastic carcinoma, NOS") )
        setattr(cls, "Paget disease and intraductal carcinoma of breast",
                PermissibleValue(text="Paget disease and intraductal carcinoma of breast") )
        setattr(cls, "Malignant lymphoma, large cell, diffuse, NOS",
                PermissibleValue(text="Malignant lymphoma, large cell, diffuse, NOS") )
        setattr(cls, "Transitional cell carcinoma",
                PermissibleValue(text="Transitional cell carcinoma",
                                 description="Ovarian Transitional Cell Carcinoma") )
        setattr(cls, "Tubular carcinoma",
                PermissibleValue(text="Tubular carcinoma") )
        setattr(cls, "Sweat gland tumor, benign",
                PermissibleValue(text="Sweat gland tumor, benign") )
        setattr(cls, "Carcinoid tumor, NOS",
                PermissibleValue(text="Carcinoid tumor, NOS") )
        setattr(cls, "Intraductal papillomatosis, NOS",
                PermissibleValue(text="Intraductal papillomatosis, NOS") )
        setattr(cls, "Infiltrating basal cell carcinoma, sclerosing",
                PermissibleValue(text="Infiltrating basal cell carcinoma, sclerosing") )
        setattr(cls, "Large B-cell lymphoma arising in HHV8-associated multicentric Castleman disease",
                PermissibleValue(text="Large B-cell lymphoma arising in HHV8-associated multicentric Castleman disease") )
        setattr(cls, "Desmoplastic medulloblastoma",
                PermissibleValue(text="Desmoplastic medulloblastoma") )
        setattr(cls, "Prostatic intraepithelial neoplasia, grade III",
                PermissibleValue(text="Prostatic intraepithelial neoplasia, grade III") )
        setattr(cls, "Askin tumor",
                PermissibleValue(text="Askin tumor") )
        setattr(cls, "Odontoma, NOS",
                PermissibleValue(text="Odontoma, NOS") )
        setattr(cls, "Gastrinoma, NOS",
                PermissibleValue(text="Gastrinoma, NOS") )
        setattr(cls, "Superficial spreading adenocarcinoma",
                PermissibleValue(text="Superficial spreading adenocarcinoma") )
        setattr(cls, "Malignant lymphoma, Hodgkin",
                PermissibleValue(text="Malignant lymphoma, Hodgkin") )
        setattr(cls, "Primary amyloidosis",
                PermissibleValue(text="Primary amyloidosis") )
        setattr(cls, "B-ALL",
                PermissibleValue(text="B-ALL") )
        setattr(cls, "Pilomatrixoma, malignant",
                PermissibleValue(text="Pilomatrixoma, malignant") )
        setattr(cls, "Acute myeloid leukemia with mutated NPM1",
                PermissibleValue(text="Acute myeloid leukemia with mutated NPM1") )
        setattr(cls, "Desmoplastic melanoma, amelanotic",
                PermissibleValue(text="Desmoplastic melanoma, amelanotic") )
        setattr(cls, "Proliferative dermal lesion in congenital nevus",
                PermissibleValue(text="Proliferative dermal lesion in congenital nevus") )
        setattr(cls, "Sarcoma botryoides",
                PermissibleValue(text="Sarcoma botryoides") )
        setattr(cls, "Non-invasive low grade serous carcinoma",
                PermissibleValue(text="Non-invasive low grade serous carcinoma") )
        setattr(cls, "Merkel cell carcinoma",
                PermissibleValue(text="Merkel cell carcinoma") )
        setattr(cls, "Low grade cribriform cystadenocarcinoma (LGCCC)",
                PermissibleValue(text="Low grade cribriform cystadenocarcinoma (LGCCC)") )
        setattr(cls, "Di Guglielmo disease",
                PermissibleValue(text="Di Guglielmo disease") )
        setattr(cls, "Desmoplastic nodular medulloblastoma",
                PermissibleValue(text="Desmoplastic nodular medulloblastoma") )
        setattr(cls, "Retinoblastoma, undifferentiated",
                PermissibleValue(text="Retinoblastoma, undifferentiated") )
        setattr(cls, "Cribriform carcinoma, NOS",
                PermissibleValue(text="Cribriform carcinoma, NOS") )
        setattr(cls, "Islet cell adenoma",
                PermissibleValue(text="Islet cell adenoma") )
        setattr(cls, "Malignant lymphoma, large B-cell, diffuse, NOS",
                PermissibleValue(text="Malignant lymphoma, large B-cell, diffuse, NOS") )
        setattr(cls, "Basal cell tumor",
                PermissibleValue(text="Basal cell tumor") )
        setattr(cls, "Somatostatinoma, NOS",
                PermissibleValue(text="Somatostatinoma, NOS") )
        setattr(cls, "Anaplastic large cell lymphoma, NOS",
                PermissibleValue(text="Anaplastic large cell lymphoma, NOS") )
        setattr(cls, "Undifferentiated high-grade pleomorphic sarcoma",
                PermissibleValue(text="Undifferentiated high-grade pleomorphic sarcoma") )
        setattr(cls, "Odontogenic fibrosarcoma",
                PermissibleValue(text="Odontogenic fibrosarcoma") )
        setattr(cls, "Papillary cystic tumor",
                PermissibleValue(text="Papillary cystic tumor") )
        setattr(cls, "Mixed medullary-papillary carcinoma",
                PermissibleValue(text="Mixed medullary-papillary carcinoma") )
        setattr(cls, "Mixed medullary-follicular carcinoma",
                PermissibleValue(text="Mixed medullary-follicular carcinoma") )
        setattr(cls, "Small cell carcinoma pulmonary type",
                PermissibleValue(text="Small cell carcinoma pulmonary type") )
        setattr(cls, "Basophil adenoma",
                PermissibleValue(text="Basophil adenoma") )
        setattr(cls, "Ductal carcinoma in situ, NOS",
                PermissibleValue(text="Ductal carcinoma in situ, NOS") )
        setattr(cls, "Ganglioglioma, NOS",
                PermissibleValue(text="Ganglioglioma, NOS") )
        setattr(cls, "Hodgkin disease, nodular sclerosis, syncytial variant",
                PermissibleValue(text="Hodgkin disease, nodular sclerosis, syncytial variant") )
        setattr(cls, "Acute lymphocytic leukemia",
                PermissibleValue(text="Acute lymphocytic leukemia") )
        setattr(cls, "Pseudomyxoma peritonei",
                PermissibleValue(text="Pseudomyxoma peritonei") )
        setattr(cls, "Squamotransitional cell carcinoma",
                PermissibleValue(text="Squamotransitional cell carcinoma") )
        setattr(cls, "Extranodal NK/T-cell lymphoma, nasal type",
                PermissibleValue(text="Extranodal NK/T-cell lymphoma, nasal type") )
        setattr(cls, "Adrenal cortical tumor, NOS",
                PermissibleValue(text="Adrenal cortical tumor, NOS") )
        setattr(cls, "FAB M2, t(8;21)(q22;q22)",
                PermissibleValue(text="FAB M2, t(8;21)(q22;q22)") )
        setattr(cls, "Pancreatic peptide and pancreatic peptide-like peptide within terminal tyrosine amide producing tumor",
                PermissibleValue(text="Pancreatic peptide and pancreatic peptide-like peptide within terminal tyrosine amide producing tumor") )
        setattr(cls, "Basal cell carcinoma, desmoplastic type",
                PermissibleValue(text="Basal cell carcinoma, desmoplastic type") )
        setattr(cls, "Undifferentiated pleomorphic sarcoma",
                PermissibleValue(text="Undifferentiated pleomorphic sarcoma") )
        setattr(cls, "Osteogenic sarcoma, NOS",
                PermissibleValue(text="Osteogenic sarcoma, NOS") )
        setattr(cls, "MPNST with rhabdomyoblastic differentiation",
                PermissibleValue(text="MPNST with rhabdomyoblastic differentiation") )
        setattr(cls, "Malignant reticulosis, NOS",
                PermissibleValue(text="Malignant reticulosis, NOS") )
        setattr(cls, "Chronic granulocytic leukemia, BCR/ABL",
                PermissibleValue(text="Chronic granulocytic leukemia, BCR/ABL") )
        setattr(cls, "Rodent ulcer",
                PermissibleValue(text="Rodent ulcer") )
        setattr(cls, "Glioblastoma with sarcomatous component",
                PermissibleValue(text="Glioblastoma with sarcomatous component") )
        setattr(cls, "Nodal marginal zone lymphoma",
                PermissibleValue(text="Nodal marginal zone lymphoma") )
        setattr(cls, "Calcifying odontogenic cyst",
                PermissibleValue(text="Calcifying odontogenic cyst") )
        setattr(cls, "Endotheliomatous meningioma",
                PermissibleValue(text="Endotheliomatous meningioma") )
        setattr(cls, "Carcinoma in pleomorphic adenoma",
                PermissibleValue(text="Carcinoma in pleomorphic adenoma") )
        setattr(cls, "Thymic large B-cell lymphoma",
                PermissibleValue(text="Thymic large B-cell lymphoma") )
        setattr(cls, "Lymphoplasmacyte-rich meningioma",
                PermissibleValue(text="Lymphoplasmacyte-rich meningioma") )
        setattr(cls, "Acute lymphatic leukemia",
                PermissibleValue(text="Acute lymphatic leukemia") )
        setattr(cls, "Squamous intraepithelial neoplasia, grade I",
                PermissibleValue(text="Squamous intraepithelial neoplasia, grade I") )
        setattr(cls, "Diffuse midline glioma, H3 K27M-mutant",
                PermissibleValue(text="Diffuse midline glioma, H3 K27M-mutant") )
        setattr(cls, "Intracystic papillary tumor with high grade intraepithelial neoplasia",
                PermissibleValue(text="Intracystic papillary tumor with high grade intraepithelial neoplasia") )
        setattr(cls, "Infiltrating and papillary adenocarcinoma",
                PermissibleValue(text="Infiltrating and papillary adenocarcinoma") )
        setattr(cls, "Desmoplastic small round cell tumor",
                PermissibleValue(text="Desmoplastic small round cell tumor") )
        setattr(cls, "Refractory thrombocytopenia",
                PermissibleValue(text="Refractory thrombocytopenia") )
        setattr(cls, "Strumal carcinoid",
                PermissibleValue(text="Strumal carcinoid") )
        setattr(cls, "Alpha cell tumor, NOS",
                PermissibleValue(text="Alpha cell tumor, NOS") )
        setattr(cls, "Melanotic neuroectodermal tumor",
                PermissibleValue(text="Melanotic neuroectodermal tumor") )
        setattr(cls, "Pseudomyxoma peritonei with unknown primary site",
                PermissibleValue(text="Pseudomyxoma peritonei with unknown primary site") )
        setattr(cls, "Hypernephroid tumor",
                PermissibleValue(text="Hypernephroid tumor") )
        setattr(cls, "Cutaneous lymphoma, NOS",
                PermissibleValue(text="Cutaneous lymphoma, NOS") )
        setattr(cls, "Junctional nevus, NOS",
                PermissibleValue(text="Junctional nevus, NOS") )
        setattr(cls, "Squamous intraepithelial neoplasia, high grade",
                PermissibleValue(text="Squamous intraepithelial neoplasia, high grade") )
        setattr(cls, "Leptomeningeal sarcoma",
                PermissibleValue(text="Leptomeningeal sarcoma") )
        setattr(cls, "Deep histiocytoma",
                PermissibleValue(text="Deep histiocytoma") )
        setattr(cls, "Arteriovenous hemangioma",
                PermissibleValue(text="Arteriovenous hemangioma") )
        setattr(cls, "Polycythemia rubra vera",
                PermissibleValue(text="Polycythemia rubra vera") )
        setattr(cls, "Infantile myofibromatosis",
                PermissibleValue(text="Infantile myofibromatosis") )
        setattr(cls, "Epithelioid MPNST",
                PermissibleValue(text="Epithelioid MPNST") )
        setattr(cls, "Pre-T ALL",
                PermissibleValue(text="Pre-T ALL") )
        setattr(cls, "Encapsulated papillary carcinoma with invasion",
                PermissibleValue(text="Encapsulated papillary carcinoma with invasion") )
        setattr(cls, "Carcinoid tumor, argentaffin, NOS",
                PermissibleValue(text="Carcinoid tumor, argentaffin, NOS") )
        setattr(cls, "Endovascular papillary angioendothelioma",
                PermissibleValue(text="Endovascular papillary angioendothelioma") )
        setattr(cls, "Pituitary carcinoma, NOS",
                PermissibleValue(text="Pituitary carcinoma, NOS") )
        setattr(cls, "Renomedullary fibroma",
                PermissibleValue(text="Renomedullary fibroma") )
        setattr(cls, "Juxtaglomerular tumor",
                PermissibleValue(text="Juxtaglomerular tumor") )
        setattr(cls, "Serous tubal intraepithelial carcinoma",
                PermissibleValue(text="Serous tubal intraepithelial carcinoma") )
        setattr(cls, "Malignant lymphoma, centroblasticcentrocytic, follicular",
                PermissibleValue(text="Malignant lymphoma, centroblasticcentrocytic, follicular") )
        setattr(cls, "Follicular lymphoma, grade 2",
                PermissibleValue(text="Follicular lymphoma, grade 2") )
        setattr(cls, "Eccrine poroma, malignant",
                PermissibleValue(text="Eccrine poroma, malignant") )
        setattr(cls, "Meningothelial meningioma",
                PermissibleValue(text="Meningothelial meningioma") )
        setattr(cls, "Endometrial stromal sarcoma, low grade",
                PermissibleValue(text="Endometrial stromal sarcoma, low grade") )
        setattr(cls, "Myelofibrosis as a result of myeloproliferative disease",
                PermissibleValue(text="Myelofibrosis as a result of myeloproliferative disease") )
        setattr(cls, "Medullary carcinoma, NOS",
                PermissibleValue(text="Medullary carcinoma, NOS") )
        setattr(cls, "Adenocystic carcinoma",
                PermissibleValue(text="Adenocystic carcinoma") )
        setattr(cls, "Intraductal papillary-mucinous tumor with moderate dysplasia",
                PermissibleValue(text="Intraductal papillary-mucinous tumor with moderate dysplasia") )
        setattr(cls, "Agnogenic myeloid metaplasia",
                PermissibleValue(text="Agnogenic myeloid metaplasia") )
        setattr(cls, "Mucinous adenocarcinofibroma",
                PermissibleValue(text="Mucinous adenocarcinofibroma") )
        setattr(cls, "T-cell large granular lymphocytic leukemia",
                PermissibleValue(text="T-cell large granular lymphocytic leukemia") )
        setattr(cls, "Neurofibroma, NOS",
                PermissibleValue(text="Neurofibroma, NOS") )
        setattr(cls, "Refractory anemia with excess blasts in transformation",
                PermissibleValue(text="Refractory anemia with excess blasts in transformation") )
        setattr(cls, "Trichilemmal carcinoma",
                PermissibleValue(text="Trichilemmal carcinoma") )
        setattr(cls, "Glandular intraepithelial neoplasia, high grade",
                PermissibleValue(text="Glandular intraepithelial neoplasia, high grade") )
        setattr(cls, "Neuroectodermal tumor, NOS",
                PermissibleValue(text="Neuroectodermal tumor, NOS") )
        setattr(cls, "Collecting duct carcinoma",
                PermissibleValue(text="Collecting duct carcinoma",
                                 description="Carcinoma of the Collecting Ducts of Bellini") )
        setattr(cls, "Wilms tumor",
                PermissibleValue(text="Wilms tumor") )
        setattr(cls, "Acidophil adenocarcinoma",
                PermissibleValue(text="Acidophil adenocarcinoma") )
        setattr(cls, "Malignant lymphoma, large cell, noncleaved, diffuse",
                PermissibleValue(text="Malignant lymphoma, large cell, noncleaved, diffuse") )
        setattr(cls, "Thymoma, benign",
                PermissibleValue(text="Thymoma, benign") )
        setattr(cls, "Juvenile nevus",
                PermissibleValue(text="Juvenile nevus") )
        setattr(cls, "Low grade appendiceal mucinous neoplasm",
                PermissibleValue(text="Low grade appendiceal mucinous neoplasm") )
        setattr(cls, "Columnar cell papilloma",
                PermissibleValue(text="Columnar cell papilloma") )
        setattr(cls, "Papillary neoplasm, pancreatobiliary-type, with high grade intraepithelial neoplasia",
                PermissibleValue(text="Papillary neoplasm, pancreatobiliary-type, with high grade intraepithelial neoplasia") )
        setattr(cls, "Fibroblastic osteosarcoma",
                PermissibleValue(text="Fibroblastic osteosarcoma") )
        setattr(cls, "Lennert lymphoma",
                PermissibleValue(text="Lennert lymphoma") )
        setattr(cls, "Megakaryocytic leukemia",
                PermissibleValue(text="Megakaryocytic leukemia") )
        setattr(cls, "Reticulum cell sarcoma, NOS",
                PermissibleValue(text="Reticulum cell sarcoma, NOS") )
        setattr(cls, "Ameloblastic sarcoma",
                PermissibleValue(text="Ameloblastic sarcoma") )
        setattr(cls, "Hepatocellular carcinoma, NOS",
                PermissibleValue(text="Hepatocellular carcinoma, NOS") )
        setattr(cls, "Infiltrating duct and lobular carcinoma",
                PermissibleValue(text="Infiltrating duct and lobular carcinoma") )
        setattr(cls, "Solitary fibrous tumor",
                PermissibleValue(text="Solitary fibrous tumor") )
        setattr(cls, "Pro-T ALL",
                PermissibleValue(text="Pro-T ALL") )
        setattr(cls, "Mixed phenotype acute leukemia with t(v;11q23); MLL rearranged",
                PermissibleValue(text="Mixed phenotype acute leukemia with t(v;11q23); MLL rearranged") )
        setattr(cls, "Pulmonary adenomatosis",
                PermissibleValue(text="Pulmonary adenomatosis") )
        setattr(cls, "ECL cell carcinoid, NOS",
                PermissibleValue(text="ECL cell carcinoid, NOS") )
        setattr(cls, "Adenomatoid odontogenic tumor",
                PermissibleValue(text="Adenomatoid odontogenic tumor") )
        setattr(cls, "Anaplastic large cell lymphoma, ALK negative",
                PermissibleValue(text="Anaplastic large cell lymphoma, ALK negative") )
        setattr(cls, "Malignant teratoma, intermediate",
                PermissibleValue(text="Malignant teratoma, intermediate") )
        setattr(cls, "Serous cystadenofibroma of borderline malignancy",
                PermissibleValue(text="Serous cystadenofibroma of borderline malignancy") )
        setattr(cls, "Mixed cell adenoma",
                PermissibleValue(text="Mixed cell adenoma") )
        setattr(cls, "Osteoma, NOS",
                PermissibleValue(text="Osteoma, NOS") )
        setattr(cls, "Bronchiolo-alveolar adenocarcinoma, NOS",
                PermissibleValue(text="Bronchiolo-alveolar adenocarcinoma, NOS") )
        setattr(cls, "Nephroma, NOS",
                PermissibleValue(text="Nephroma, NOS") )
        setattr(cls, "Carcinoma, metastatic, NOS",
                PermissibleValue(text="Carcinoma, metastatic, NOS") )
        setattr(cls, "Chronic monocytic leukemia",
                PermissibleValue(text="Chronic monocytic leukemia") )
        setattr(cls, "Malignant lymphoma, lymphoplasmacytic",
                PermissibleValue(text="Malignant lymphoma, lymphoplasmacytic") )
        setattr(cls, "Synovioma, benign",
                PermissibleValue(text="Synovioma, benign") )
        setattr(cls, "Myxoid chondrosarcoma",
                PermissibleValue(text="Myxoid chondrosarcoma") )
        setattr(cls, "Intraductal papillary tumor with high grade dysplasia",
                PermissibleValue(text="Intraductal papillary tumor with high grade dysplasia") )
        setattr(cls, "Oxyphilic adenoma",
                PermissibleValue(text="Oxyphilic adenoma") )
        setattr(cls, "Mixed carcinoid-adenocarcinoma",
                PermissibleValue(text="Mixed carcinoid-adenocarcinoma") )
        setattr(cls, "Cystic hygroma",
                PermissibleValue(text="Cystic hygroma") )
        setattr(cls, "Heavy chain disease, NOS",
                PermissibleValue(text="Heavy chain disease, NOS") )
        setattr(cls, "Phyllodes tumor, borderline",
                PermissibleValue(text="Phyllodes tumor, borderline") )
        setattr(cls, "Papillary cystadenocarcinoma, NOS",
                PermissibleValue(text="Papillary cystadenocarcinoma, NOS") )
        setattr(cls, "Malignant lymphoma, lymphoplasmacytoid",
                PermissibleValue(text="Malignant lymphoma, lymphoplasmacytoid") )
        setattr(cls, "Malignant lymphoma, centroblastic, follicular",
                PermissibleValue(text="Malignant lymphoma, centroblastic, follicular") )
        setattr(cls, "Mucinous cystic neoplasm with high-grade dysplasia",
                PermissibleValue(text="Mucinous cystic neoplasm with high-grade dysplasia") )
        setattr(cls, "Circumscribed arachnoidal cerebellar sarcoma",
                PermissibleValue(text="Circumscribed arachnoidal cerebellar sarcoma") )
        setattr(cls, "Papillary urothelial carcinoma",
                PermissibleValue(text="Papillary urothelial carcinoma") )
        setattr(cls, "Polymorphous low grade adenocarcinoma",
                PermissibleValue(text="Polymorphous low grade adenocarcinoma") )
        setattr(cls, "Periosteal osteosarcoma",
                PermissibleValue(text="Periosteal osteosarcoma") )
        setattr(cls, "Hodgkin disease, lymphocytic-histiocytic predominance",
                PermissibleValue(text="Hodgkin disease, lymphocytic-histiocytic predominance") )
        setattr(cls, "Hepatoma, NOS",
                PermissibleValue(text="Hepatoma, NOS") )
        setattr(cls, "Pigmented dermatofibrosarcoma protuberans",
                PermissibleValue(text="Pigmented dermatofibrosarcoma protuberans") )
        setattr(cls, "Calcifying epithelioma of Malherbe",
                PermissibleValue(text="Calcifying epithelioma of Malherbe") )
        setattr(cls, "Adenocarcinoma of anal glands",
                PermissibleValue(text="Adenocarcinoma of anal glands") )
        setattr(cls, "T-cell lymphoma, NOS",
                PermissibleValue(text="T-cell lymphoma, NOS") )
        setattr(cls, "Gastrointestinal stromal sarcoma",
                PermissibleValue(text="Gastrointestinal stromal sarcoma") )
        setattr(cls, "Eccrine dermal cylindroma",
                PermissibleValue(text="Eccrine dermal cylindroma") )
        setattr(cls, "RAEB II",
                PermissibleValue(text="RAEB II") )
        setattr(cls, "Halo nevus",
                PermissibleValue(text="Halo nevus") )
        setattr(cls, "Beta cell adenoma",
                PermissibleValue(text="Beta cell adenoma") )
        setattr(cls, "Dermoid cyst, NOS",
                PermissibleValue(text="Dermoid cyst, NOS") )
        setattr(cls, "Angiocentric immunoproliferative lesion",
                PermissibleValue(text="Angiocentric immunoproliferative lesion") )
        setattr(cls, "Fetal fat cell lipoma",
                PermissibleValue(text="Fetal fat cell lipoma") )
        setattr(cls, "Oncocytic Schneiderian papilloma",
                PermissibleValue(text="Oncocytic Schneiderian papilloma") )
        setattr(cls, "Cystic lymphangioma",
                PermissibleValue(text="Cystic lymphangioma") )
        setattr(cls, "Chromaffin tumor",
                PermissibleValue(text="Chromaffin tumor") )
        setattr(cls, "Intracystic papillary neoplasm with intermediate grade intraepithelial neoplasia",
                PermissibleValue(text="Intracystic papillary neoplasm with intermediate grade intraepithelial neoplasia") )
        setattr(cls, "Carcinoma, undifferentiated, NOS",
                PermissibleValue(text="Carcinoma, undifferentiated, NOS") )
        setattr(cls, "Glandular intraepithelial neoplasia, grade II",
                PermissibleValue(text="Glandular intraepithelial neoplasia, grade II") )
        setattr(cls, "Cavernous lymphangioma",
                PermissibleValue(text="Cavernous lymphangioma") )
        setattr(cls, "Adenocarcinoid tumor",
                PermissibleValue(text="Adenocarcinoid tumor") )
        setattr(cls, "Mixed acinar-endocrine-ductal carcinoma",
                PermissibleValue(text="Mixed acinar-endocrine-ductal carcinoma") )
        setattr(cls, "Hairy cell leukemia",
                PermissibleValue(text="Hairy cell leukemia") )
        setattr(cls, "Polar spongioblastoma",
                PermissibleValue(text="Polar spongioblastoma") )
        setattr(cls, "Clear cell adenocarcinoma, NOS",
                PermissibleValue(text="Clear cell adenocarcinoma, NOS") )
        setattr(cls, "Large cell carcinoma, NOS",
                PermissibleValue(text="Large cell carcinoma, NOS") )
        setattr(cls, "Adult cystic teratoma",
                PermissibleValue(text="Adult cystic teratoma") )
        setattr(cls, "Intracystic carcinoma, NOS",
                PermissibleValue(text="Intracystic carcinoma, NOS") )
        setattr(cls, "Enterochromaffin cell carcinoid",
                PermissibleValue(text="Enterochromaffin cell carcinoid") )
        setattr(cls, "Olfactory neuroblastoma",
                PermissibleValue(text="Olfactory neuroblastoma") )
        setattr(cls, "Comedocarcinoma, noninfiltrating",
                PermissibleValue(text="Comedocarcinoma, noninfiltrating") )
        setattr(cls, "Adnexal tumor, benign",
                PermissibleValue(text="Adnexal tumor, benign") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma with t(5;14)(q31;q32); IL3-IGH",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma with t(5;14)(q31;q32); IL3-IGH") )
        setattr(cls, "Bronchiolo-alveolar carcinoma, NOS",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma, NOS") )
        setattr(cls, "Gastrointestinal stromal tumor, uncertain malignant potential",
                PermissibleValue(text="Gastrointestinal stromal tumor, uncertain malignant potential") )
        setattr(cls, "Mesothelioma, benign",
                PermissibleValue(text="Mesothelioma, benign") )
        setattr(cls, "FAB M3 (includes all variants)",
                PermissibleValue(text="FAB M3 (includes all variants)") )
        setattr(cls, "Extra-adrenal paraganglioma, malignant",
                PermissibleValue(text="Extra-adrenal paraganglioma, malignant") )
        setattr(cls, "Fibrous histiocytoma, NOS",
                PermissibleValue(text="Fibrous histiocytoma, NOS") )
        setattr(cls, "Retinoblastoma, NOS",
                PermissibleValue(text="Retinoblastoma, NOS") )
        setattr(cls, "Infiltrating duct and tubular carcinoma",
                PermissibleValue(text="Infiltrating duct and tubular carcinoma") )
        setattr(cls, "Malignant mastocytosis",
                PermissibleValue(text="Malignant mastocytosis") )
        setattr(cls, "Papillary microcarcinoma",
                PermissibleValue(text="Papillary microcarcinoma") )
        setattr(cls, "Anaplastic medulloblastoma",
                PermissibleValue(text="Anaplastic medulloblastoma") )
        setattr(cls, "Giant osteoid osteoma",
                PermissibleValue(text="Giant osteoid osteoma") )
        setattr(cls, "Teratoma, malignant, NOS",
                PermissibleValue(text="Teratoma, malignant, NOS") )
        setattr(cls, "Undifferentiated uterine sarcoma",
                PermissibleValue(text="Undifferentiated uterine sarcoma") )
        setattr(cls, "Primary diffuse large B-cell lymphoma of the CNS",
                PermissibleValue(text="Primary diffuse large B-cell lymphoma of the CNS") )
        setattr(cls, "Neoplasm, malignant",
                PermissibleValue(text="Neoplasm, malignant") )
        setattr(cls, "Myelodysplastic syndrome, unclassifiable",
                PermissibleValue(text="Myelodysplastic syndrome, unclassifiable") )
        setattr(cls, "Malignant rhabdoid tumor",
                PermissibleValue(text="Malignant rhabdoid tumor") )
        setattr(cls, "Systemic tissue mast cell disease",
                PermissibleValue(text="Systemic tissue mast cell disease") )
        setattr(cls, "Transitional carcinoma",
                PermissibleValue(text="Transitional carcinoma") )
        setattr(cls, "Interdigitating cell sarcoma",
                PermissibleValue(text="Interdigitating cell sarcoma") )
        setattr(cls, "Paraganglioma, benign",
                PermissibleValue(text="Paraganglioma, benign") )
        setattr(cls, "Mucinous cystic tumor with high-grade dysplasia",
                PermissibleValue(text="Mucinous cystic tumor with high-grade dysplasia") )
        setattr(cls, "Desmoplastic fibroma",
                PermissibleValue(text="Desmoplastic fibroma") )
        setattr(cls, "Fibrillary astrocytoma",
                PermissibleValue(text="Fibrillary astrocytoma") )
        setattr(cls, "Infiltrating duct and mucinous carcinoma",
                PermissibleValue(text="Infiltrating duct and mucinous carcinoma") )
        setattr(cls, "Anaplastic large cell lymphoma, T cell and Null cell type",
                PermissibleValue(text="Anaplastic large cell lymphoma, T cell and Null cell type") )
        setattr(cls, "Mixed hepatocellular and bile duct carcinoma",
                PermissibleValue(text="Mixed hepatocellular and bile duct carcinoma") )
        setattr(cls, "Serous microcystic adenoma",
                PermissibleValue(text="Serous microcystic adenoma") )
        setattr(cls, "Spitz nevus",
                PermissibleValue(text="Spitz nevus") )
        setattr(cls, "Sex cord-gonadal stromal tumor, mixed forms",
                PermissibleValue(text="Sex cord-gonadal stromal tumor, mixed forms") )
        setattr(cls, "Medullary osteosarcoma",
                PermissibleValue(text="Medullary osteosarcoma") )
        setattr(cls, "Acute granulocytic leukemia",
                PermissibleValue(text="Acute granulocytic leukemia") )
        setattr(cls, "Embryonal carcinoma, infantile",
                PermissibleValue(text="Embryonal carcinoma, infantile") )
        setattr(cls, "Glomus jugulare tumor, NOS",
                PermissibleValue(text="Glomus jugulare tumor, NOS") )
        setattr(cls, "Central odontogenic fibroma",
                PermissibleValue(text="Central odontogenic fibroma") )
        setattr(cls, "Malignant lymphoma, small cell, NOS",
                PermissibleValue(text="Malignant lymphoma, small cell, NOS") )
        setattr(cls, "Mucoid cell adenocarcinoma",
                PermissibleValue(text="Mucoid cell adenocarcinoma") )
        setattr(cls, "Follicular lymphoma, grade 3A",
                PermissibleValue(text="Follicular lymphoma, grade 3A") )
        setattr(cls, "Adenoma of nipple",
                PermissibleValue(text="Adenoma of nipple") )
        setattr(cls, "Precursor cell lymphoblastic leukemia, NOS",
                PermissibleValue(text="Precursor cell lymphoblastic leukemia, NOS") )
        setattr(cls, "Chronic leukemia, NOS",
                PermissibleValue(text="Chronic leukemia, NOS") )
        setattr(cls, "Invasive lobular carcinoma, solid type",
                PermissibleValue(text="Invasive lobular carcinoma, solid type") )
        setattr(cls, "Serrated adenocarcinoma",
                PermissibleValue(text="Serrated adenocarcinoma") )
        setattr(cls, "Carcinoma showing thymus-like element",
                PermissibleValue(text="Carcinoma showing thymus-like element") )
        setattr(cls, "Ductal carcinoma in situ, comedo type",
                PermissibleValue(text="Ductal carcinoma in situ, comedo type") )
        setattr(cls, "Adult T-cell lymphoma/leukemia",
                PermissibleValue(text="Adult T-cell lymphoma/leukemia") )
        setattr(cls, "Interstitial cell tumor, malignant",
                PermissibleValue(text="Interstitial cell tumor, malignant") )
        setattr(cls, "Classical Hodgkin lymphoma, lymphocyte depletion, reticular",
                PermissibleValue(text="Classical Hodgkin lymphoma, lymphocyte depletion, reticular") )
        setattr(cls, "Thymoma, spindle cell, malignant",
                PermissibleValue(text="Thymoma, spindle cell, malignant") )
        setattr(cls, "Urothelial carcinoma in situ",
                PermissibleValue(text="Urothelial carcinoma in situ") )
        setattr(cls, "Apocrine adenoma",
                PermissibleValue(text="Apocrine adenoma") )
        setattr(cls, "Diffuse meningiomatosis",
                PermissibleValue(text="Diffuse meningiomatosis") )
        setattr(cls, "Odontogenic ghost cell tumor",
                PermissibleValue(text="Odontogenic ghost cell tumor") )
        setattr(cls, "Tubulopapillary adenocarcinoma",
                PermissibleValue(text="Tubulopapillary adenocarcinoma") )
        setattr(cls, "Mucin-secreting carcinoma",
                PermissibleValue(text="Mucin-secreting carcinoma") )
        setattr(cls, "Primitive polar spongioblastoma",
                PermissibleValue(text="Primitive polar spongioblastoma") )
        setattr(cls, "Burkitt lymphoma, NOS (Includes all variants)",
                PermissibleValue(text="Burkitt lymphoma, NOS (Includes all variants)") )
        setattr(cls, "Recklinghausen disease",
                PermissibleValue(text="Recklinghausen disease") )
        setattr(cls, "Follicular carcinoma, encapsulated",
                PermissibleValue(text="Follicular carcinoma, encapsulated") )
        setattr(cls, "Immunoproliferative disease, NOS",
                PermissibleValue(text="Immunoproliferative disease, NOS") )
        setattr(cls, "Ewing tumor",
                PermissibleValue(text="Ewing tumor") )
        setattr(cls, "Superficial spreading melanoma",
                PermissibleValue(text="Superficial spreading melanoma",
                                 description="Superficial Spreading Melanoma") )
        setattr(cls, "Epithelioid glioblastoma",
                PermissibleValue(text="Epithelioid glioblastoma") )
        setattr(cls, "Papillary urothelial carcinoma, non-invasive",
                PermissibleValue(text="Papillary urothelial carcinoma, non-invasive") )
        setattr(cls, "Follicular carcinoma, NOS",
                PermissibleValue(text="Follicular carcinoma, NOS") )
        setattr(cls, "Biliary intraepithelial neoplasia, high grade",
                PermissibleValue(text="Biliary intraepithelial neoplasia, high grade") )
        setattr(cls, "Follicular carcinoma, oxyphilic cell",
                PermissibleValue(text="Follicular carcinoma, oxyphilic cell") )
        setattr(cls, "Malignant lymphoma, small noncleaved, Burkitt type",
                PermissibleValue(text="Malignant lymphoma, small noncleaved, Burkitt type") )
        setattr(cls, "Dermoid, NOS",
                PermissibleValue(text="Dermoid, NOS") )
        setattr(cls, "Stromal tumor, benign",
                PermissibleValue(text="Stromal tumor, benign") )
        setattr(cls, "Clear cell adenocarcinoma, mesonephroid",
                PermissibleValue(text="Clear cell adenocarcinoma, mesonephroid") )
        setattr(cls, "Spindle cell sarcoma",
                PermissibleValue(text="Spindle cell sarcoma") )
        setattr(cls, "Malignant fibrous histiocytoma (MFH) of bone",
                PermissibleValue(text="Malignant fibrous histiocytoma (MFH) of bone") )
        setattr(cls, "Infiltrating lobular carcinoma and ductal carcinoma in situ",
                PermissibleValue(text="Infiltrating lobular carcinoma and ductal carcinoma in situ") )
        setattr(cls, "Gliomatosis cerebri",
                PermissibleValue(text="Gliomatosis cerebri") )
        setattr(cls, "Urothelial carcinoma with trophoblastic differentiation",
                PermissibleValue(text="Urothelial carcinoma with trophoblastic differentiation") )
        setattr(cls, "Myelofibrosis with myeloid metaplasia",
                PermissibleValue(text="Myelofibrosis with myeloid metaplasia") )
        setattr(cls, "Verrucous carcinoma, NOS",
                PermissibleValue(text="Verrucous carcinoma, NOS") )
        setattr(cls, "Embryonal tumor with rhabdoid features",
                PermissibleValue(text="Embryonal tumor with rhabdoid features") )
        setattr(cls, "Acute myelomonocytic leukemia",
                PermissibleValue(text="Acute myelomonocytic leukemia") )
        setattr(cls, "Spermatocytic seminoma",
                PermissibleValue(text="Spermatocytic seminoma") )
        setattr(cls, "Meningeal melanomatosis",
                PermissibleValue(text="Meningeal melanomatosis") )
        setattr(cls, "Odontogenic myxofibroma",
                PermissibleValue(text="Odontogenic myxofibroma") )
        setattr(cls, "Parosteal osteosarcoma",
                PermissibleValue(text="Parosteal osteosarcoma") )
        setattr(cls, "Epithelioid leiomyoma",
                PermissibleValue(text="Epithelioid leiomyoma") )
        setattr(cls, "Cystadenofibroma, NOS",
                PermissibleValue(text="Cystadenofibroma, NOS") )
        setattr(cls, "Malignant lymphoma, centroblasticcentrocytic, NOS",
                PermissibleValue(text="Malignant lymphoma, centroblasticcentrocytic, NOS") )
        setattr(cls, "Trabecular carcinoma",
                PermissibleValue(text="Trabecular carcinoma") )
        setattr(cls, "Intracystic papillary tumor with high grade dysplasia",
                PermissibleValue(text="Intracystic papillary tumor with high grade dysplasia") )
        setattr(cls, "Acidophil adenoma",
                PermissibleValue(text="Acidophil adenoma") )
        setattr(cls, "Sweat gland adenoma",
                PermissibleValue(text="Sweat gland adenoma") )
        setattr(cls, "Squamous cell papilloma, NOS",
                PermissibleValue(text="Squamous cell papilloma, NOS") )
        setattr(cls, "B-cell lymphoma, unclassifiable, with features intermediate between diffuse large B-cell lymphoma and Burkitt lymphoma",
                PermissibleValue(text="B-cell lymphoma, unclassifiable, with features intermediate between diffuse large B-cell lymphoma and Burkitt lymphoma") )
        setattr(cls, "Intradermal nevus",
                PermissibleValue(text="Intradermal nevus") )
        setattr(cls, "Proliferative polycythemia",
                PermissibleValue(text="Proliferative polycythemia") )
        setattr(cls, "Serous cystoma",
                PermissibleValue(text="Serous cystoma") )
        setattr(cls, "Meningioma, malignant",
                PermissibleValue(text="Meningioma, malignant") )
        setattr(cls, "Malignant lymphoma, noncleaved cell, follicular, NOS",
                PermissibleValue(text="Malignant lymphoma, noncleaved cell, follicular, NOS") )
        setattr(cls, "Granulosa cell-theca cell tumor",
                PermissibleValue(text="Granulosa cell-theca cell tumor") )
        setattr(cls, "Chronic lymphoid leukemia",
                PermissibleValue(text="Chronic lymphoid leukemia") )
        setattr(cls, "Apocrine adenocarcinoma",
                PermissibleValue(text="Apocrine adenocarcinoma") )
        setattr(cls, "Medulloblastoma with extensive nodularity",
                PermissibleValue(text="Medulloblastoma with extensive nodularity") )
        setattr(cls, "Diffuse astrocytoma, IDH-wildtype",
                PermissibleValue(text="Diffuse astrocytoma, IDH-wildtype") )
        setattr(cls, "Androblastoma, NOS",
                PermissibleValue(text="Androblastoma, NOS") )
        setattr(cls, "Adenoid cystic carcinoma",
                PermissibleValue(text="Adenoid cystic carcinoma") )
        setattr(cls, "Ameloblastoma, malignant",
                PermissibleValue(text="Ameloblastoma, malignant") )
        setattr(cls, "Granulosa cell tumor, juvenile",
                PermissibleValue(text="Granulosa cell tumor, juvenile") )
        setattr(cls, "Oncocytic carcinoma",
                PermissibleValue(text="Oncocytic carcinoma",
                                 description="Oxyphilic Adenocarcinoma") )
        setattr(cls, "Meningeal sarcoma",
                PermissibleValue(text="Meningeal sarcoma") )
        setattr(cls, "Subacute lymphocytic leukemia",
                PermissibleValue(text="Subacute lymphocytic leukemia") )
        setattr(cls, "Combined hepatocellular carcinoma and cholangiocarcinoma",
                PermissibleValue(text="Combined hepatocellular carcinoma and cholangiocarcinoma") )
        setattr(cls, "B-cell lymphoma, unclassifiable, with features intermediate between diffuse large B-cell lymphoma and classical Hodgkin lymphoma",
                PermissibleValue(text="B-cell lymphoma, unclassifiable, with features intermediate between diffuse large B-cell lymphoma and classical Hodgkin lymphoma") )
        setattr(cls, "Juvenile myelomonocytic leukemia",
                PermissibleValue(text="Juvenile myelomonocytic leukemia") )
        setattr(cls, "Hemangioendothelioma, NOS",
                PermissibleValue(text="Hemangioendothelioma, NOS") )
        setattr(cls, "Metaplastic carcinoma with osseous differentiation",
                PermissibleValue(text="Metaplastic carcinoma with osseous differentiation") )
        setattr(cls, "Sertoli cell tumor, NOS",
                PermissibleValue(text="Sertoli cell tumor, NOS") )
        setattr(cls, "Common precursor B ALL",
                PermissibleValue(text="Common precursor B ALL") )
        setattr(cls, "Infantile hemangioma",
                PermissibleValue(text="Infantile hemangioma") )
        setattr(cls, "Acute monoblastic and monocytic leukemia",
                PermissibleValue(text="Acute monoblastic and monocytic leukemia") )
        setattr(cls, "Malignant lymphoma, small cleaved cell, follicular",
                PermissibleValue(text="Malignant lymphoma, small cleaved cell, follicular") )
        setattr(cls, "Central primitive neuroectodermal tumor, NOS",
                PermissibleValue(text="Central primitive neuroectodermal tumor, NOS") )
        setattr(cls, "Monoblastic leukemia, NOS",
                PermissibleValue(text="Monoblastic leukemia, NOS") )
        setattr(cls, "Syncytial meningioma",
                PermissibleValue(text="Syncytial meningioma") )
        setattr(cls, "Ependymoma, NOS",
                PermissibleValue(text="Ependymoma, NOS") )
        setattr(cls, "Granulosa cell tumor, sarcomatoid",
                PermissibleValue(text="Granulosa cell tumor, sarcomatoid") )
        setattr(cls, "High-grade neuroendocrine carcinoma",
                PermissibleValue(text="High-grade neuroendocrine carcinoma") )
        setattr(cls, "Non-invasive follicular thyroid neoplasm with papillary-like nuclear features (NIFTP)",
                PermissibleValue(text="Non-invasive follicular thyroid neoplasm with papillary-like nuclear features (NIFTP)") )
        setattr(cls, "Thecoma, luteinized",
                PermissibleValue(text="Thecoma, luteinized") )
        setattr(cls, "Stem cell leukemia",
                PermissibleValue(text="Stem cell leukemia") )
        setattr(cls, "Cystosarcoma phyllodes, malignant",
                PermissibleValue(text="Cystosarcoma phyllodes, malignant") )
        setattr(cls, "Thymoma, lymphocytic, malignant",
                PermissibleValue(text="Thymoma, lymphocytic, malignant") )
        setattr(cls, "Phosphaturic mesenchymal tumor, malignant",
                PermissibleValue(text="Phosphaturic mesenchymal tumor, malignant") )
        setattr(cls, "Plexiform leiomyoma",
                PermissibleValue(text="Plexiform leiomyoma") )
        setattr(cls, "Cartilaginous exostosis",
                PermissibleValue(text="Cartilaginous exostosis") )
        setattr(cls, "Thymoma, spindle cell, NOS",
                PermissibleValue(text="Thymoma, spindle cell, NOS") )
        setattr(cls, "Myxofibroma, NOS",
                PermissibleValue(text="Myxofibroma, NOS") )
        setattr(cls, "Gastrointestinal stromal tumor, benign",
                PermissibleValue(text="Gastrointestinal stromal tumor, benign") )
        setattr(cls, "Intravascular bronchial alveolar tumor",
                PermissibleValue(text="Intravascular bronchial alveolar tumor") )
        setattr(cls, "Metaplastic carcinoma with chondroid differentiation",
                PermissibleValue(text="Metaplastic carcinoma with chondroid differentiation") )
        setattr(cls, "Composite Hodgkin and non-Hodgkin lymphoma",
                PermissibleValue(text="Composite Hodgkin and non-Hodgkin lymphoma") )
        setattr(cls, "Teratoid medulloepithelioma",
                PermissibleValue(text="Teratoid medulloepithelioma") )
        setattr(cls, "Rhabdomyosarcoma, NOS",
                PermissibleValue(text="Rhabdomyosarcoma, NOS") )
        setattr(cls, "Giant cell tumor of soft parts, NOS",
                PermissibleValue(text="Giant cell tumor of soft parts, NOS") )
        setattr(cls, "Mucinous carcinoid",
                PermissibleValue(text="Mucinous carcinoid") )
        setattr(cls, "Atypical adenoma",
                PermissibleValue(text="Atypical adenoma") )
        setattr(cls, "Spindle epithelial tumor with thymus-like element",
                PermissibleValue(text="Spindle epithelial tumor with thymus-like element") )
        setattr(cls, "Intermediate and giant congenital nevus",
                PermissibleValue(text="Intermediate and giant congenital nevus") )
        setattr(cls, "Papillary glioneuronal tumor",
                PermissibleValue(text="Papillary glioneuronal tumor") )
        setattr(cls, "Extranodal marginal zone lymphoma of mucosa-associated lymphoid tissue",
                PermissibleValue(text="Extranodal marginal zone lymphoma of mucosa-associated lymphoid tissue") )
        setattr(cls, "Systemic light chain disease",
                PermissibleValue(text="Systemic light chain disease") )
        setattr(cls, "Infiltrating papillary adenocarcinoma",
                PermissibleValue(text="Infiltrating papillary adenocarcinoma") )
        setattr(cls, "Adenomatous polyp, NOS",
                PermissibleValue(text="Adenomatous polyp, NOS") )
        setattr(cls, "Epithelial ependymoma",
                PermissibleValue(text="Epithelial ependymoma") )
        setattr(cls, "Pleomorphic rhabdomyosarcoma, adult type",
                PermissibleValue(text="Pleomorphic rhabdomyosarcoma, adult type") )
        setattr(cls, "Renal cell carcinoma, chromophobe type",
                PermissibleValue(text="Renal cell carcinoma, chromophobe type") )
        setattr(cls, "Acinar cell adenoma",
                PermissibleValue(text="Acinar cell adenoma") )
        setattr(cls, "Myoepithelial adenoma",
                PermissibleValue(text="Myoepithelial adenoma") )
        setattr(cls, "Carcinoma with osteoclast-like giant cells",
                PermissibleValue(text="Carcinoma with osteoclast-like giant cells") )
        setattr(cls, "Adenocarcinoma admixed with neuroendocrine carcinoma",
                PermissibleValue(text="Adenocarcinoma admixed with neuroendocrine carcinoma") )
        setattr(cls, "Adenocarcinoma with osseous metaplasia",
                PermissibleValue(text="Adenocarcinoma with osseous metaplasia") )
        setattr(cls, "Adult granulosa cell tumor",
                PermissibleValue(text="Adult granulosa cell tumor") )
        setattr(cls, "Hodgkin disease, NOS",
                PermissibleValue(text="Hodgkin disease, NOS") )
        setattr(cls, "Primary cutaneous gamma-delta T-cell lymphoma",
                PermissibleValue(text="Primary cutaneous gamma-delta T-cell lymphoma") )
        setattr(cls, "Atypical fibrous histiocytoma",
                PermissibleValue(text="Atypical fibrous histiocytoma") )
        setattr(cls, "Neuroblastoma, NOS",
                PermissibleValue(text="Neuroblastoma, NOS") )
        setattr(cls, "Minimally invasive adenocarcinoma, non-mucinous",
                PermissibleValue(text="Minimally invasive adenocarcinoma, non-mucinous") )
        setattr(cls, "Bizarre leiomyoma",
                PermissibleValue(text="Bizarre leiomyoma") )
        setattr(cls, "Diffuse intraductal papillomatosis",
                PermissibleValue(text="Diffuse intraductal papillomatosis") )
        setattr(cls, "Biliary papillomatosis",
                PermissibleValue(text="Biliary papillomatosis") )
        setattr(cls, "Proliferating trichilemmal tumor",
                PermissibleValue(text="Proliferating trichilemmal tumor") )
        setattr(cls, "NUT carcinoma",
                PermissibleValue(text="NUT carcinoma",
                                 description="NUT Carcinoma") )
        setattr(cls, "Lobular carcinoma, NOS",
                PermissibleValue(text="Lobular carcinoma, NOS") )
        setattr(cls, "Vaginal intraepithelial neoplasia, grade III",
                PermissibleValue(text="Vaginal intraepithelial neoplasia, grade III") )
        setattr(cls, "Androblastoma, benign",
                PermissibleValue(text="Androblastoma, benign") )
        setattr(cls, "Bile duct cystadenoma",
                PermissibleValue(text="Bile duct cystadenoma") )
        setattr(cls, "Pancreatic endocrine tumor, benign",
                PermissibleValue(text="Pancreatic endocrine tumor, benign") )
        setattr(cls, "Acute myeloblastic leukemia",
                PermissibleValue(text="Acute myeloblastic leukemia") )
        setattr(cls, "Noninvasive pancreatobiliary papillary neoplasm with low grade intraepithelial neoplasia",
                PermissibleValue(text="Noninvasive pancreatobiliary papillary neoplasm with low grade intraepithelial neoplasia") )
        setattr(cls, "Follicular adenocarcinoma, NOS",
                PermissibleValue(text="Follicular adenocarcinoma, NOS") )
        setattr(cls, "Perineurioma, NOS",
                PermissibleValue(text="Perineurioma, NOS") )
        setattr(cls, "Keratotoc papilloma",
                PermissibleValue(text="Keratotoc papilloma") )
        setattr(cls, "Granular cell tumor, malignant",
                PermissibleValue(text="Granular cell tumor, malignant") )
        setattr(cls, "GIST, NOS",
                PermissibleValue(text="GIST, NOS") )
        setattr(cls, "Alveolar soft part sarcoma",
                PermissibleValue(text="Alveolar soft part sarcoma") )
        setattr(cls, "Oat cell carcinoma",
                PermissibleValue(text="Oat cell carcinoma") )
        setattr(cls, "Fibroepithelioma, NOS",
                PermissibleValue(text="Fibroepithelioma, NOS") )
        setattr(cls, "Plexiform hemangioma",
                PermissibleValue(text="Plexiform hemangioma") )
        setattr(cls, "Skin appendage adenoma",
                PermissibleValue(text="Skin appendage adenoma") )
        setattr(cls, "Carcinoma simplex",
                PermissibleValue(text="Carcinoma simplex") )
        setattr(cls, "Carcinoma with other types mesenchymal differentiation",
                PermissibleValue(text="Carcinoma with other types mesenchymal differentiation") )
        setattr(cls, "Essential hemorrhagic thrombocythaemia",
                PermissibleValue(text="Essential hemorrhagic thrombocythaemia") )
        setattr(cls, "Medulloepithelioma, NOS",
                PermissibleValue(text="Medulloepithelioma, NOS") )
        setattr(cls, "Malignant lymphoma, large B-cell, diffuse, centroblastic, NOS",
                PermissibleValue(text="Malignant lymphoma, large B-cell, diffuse, centroblastic, NOS") )
        setattr(cls, "Neuroendocrine tumor, grade 2",
                PermissibleValue(text="Neuroendocrine tumor, grade 2") )
        setattr(cls, "Papillary mucinous cystadenoma, NOS",
                PermissibleValue(text="Papillary mucinous cystadenoma, NOS") )
        setattr(cls, "Pheochromocytoma, malignant",
                PermissibleValue(text="Pheochromocytoma, malignant") )
        setattr(cls, "Mullerian mixed tumor",
                PermissibleValue(text="Mullerian mixed tumor") )
        setattr(cls, "EBV positive diffuse large B-cell lymphoma of the elderly",
                PermissibleValue(text="EBV positive diffuse large B-cell lymphoma of the elderly") )
        setattr(cls, "Verrucous epidermoid carcinoma",
                PermissibleValue(text="Verrucous epidermoid carcinoma") )
        setattr(cls, "Desmoplastic infantile ganglioglioma",
                PermissibleValue(text="Desmoplastic infantile ganglioglioma") )
        setattr(cls, "Intracortical osteosarcoma",
                PermissibleValue(text="Intracortical osteosarcoma") )
        setattr(cls, "Lymphosarcoma cell leukemia",
                PermissibleValue(text="Lymphosarcoma cell leukemia") )
        setattr(cls, "Mucinous adenocarcinoma",
                PermissibleValue(text="Mucinous adenocarcinoma") )
        setattr(cls, "Theca cell-granulosa cell tumor",
                PermissibleValue(text="Theca cell-granulosa cell tumor") )
        setattr(cls, "Glomus tumor, NOS",
                PermissibleValue(text="Glomus tumor, NOS") )
        setattr(cls, "Intravascular leiomyomatosis",
                PermissibleValue(text="Intravascular leiomyomatosis") )
        setattr(cls, "Endometrial stromal sarcoma, NOS",
                PermissibleValue(text="Endometrial stromal sarcoma, NOS") )
        setattr(cls, "Ameloblastic fibrodentinoma",
                PermissibleValue(text="Ameloblastic fibrodentinoma") )
        setattr(cls, "Mucinous cystoma",
                PermissibleValue(text="Mucinous cystoma") )
        setattr(cls, "Chronic myelogenous leukemia, BCR-ABL positive",
                PermissibleValue(text="Chronic myelogenous leukemia, BCR-ABL positive") )
        setattr(cls, "Malignant lymphoma, undifferentiated, Burkitt type",
                PermissibleValue(text="Malignant lymphoma, undifferentiated, Burkitt type") )
        setattr(cls, "Thecoma, NOS",
                PermissibleValue(text="Thecoma, NOS") )
        setattr(cls, "Pilomatrixoma, NOS",
                PermissibleValue(text="Pilomatrixoma, NOS") )
        setattr(cls, "Noninfiltrating intracystic carcinoma",
                PermissibleValue(text="Noninfiltrating intracystic carcinoma") )
        setattr(cls, "Cellular ependymoma",
                PermissibleValue(text="Cellular ependymoma") )
        setattr(cls, "Epithelioid malignant peripheral nerve sheath tumor",
                PermissibleValue(text="Epithelioid malignant peripheral nerve sheath tumor") )
        setattr(cls, "Mixed tumor, malignant, NOS",
                PermissibleValue(text="Mixed tumor, malignant, NOS") )
        setattr(cls, "Gastrointestinal stromal tumor, malignant",
                PermissibleValue(text="Gastrointestinal stromal tumor, malignant") )
        setattr(cls, "Malignant lymphoma, large cell, noncleaved, follicular",
                PermissibleValue(text="Malignant lymphoma, large cell, noncleaved, follicular") )
        setattr(cls, "Infiltrating duct and cribriform carcinoma",
                PermissibleValue(text="Infiltrating duct and cribriform carcinoma") )
        setattr(cls, "Langerhans cell histiocytosis, mono-ostotic",
                PermissibleValue(text="Langerhans cell histiocytosis, mono-ostotic") )
        setattr(cls, "Intravascular B-cell lymphoma",
                PermissibleValue(text="Intravascular B-cell lymphoma") )
        setattr(cls, "Angioimmunoblastic lymphadenopathy",
                PermissibleValue(text="Angioimmunoblastic lymphadenopathy") )
        setattr(cls, "Steroid cell tumor, malignant",
                PermissibleValue(text="Steroid cell tumor, malignant") )
        setattr(cls, "Alveolar rhabdomyosarcoma",
                PermissibleValue(text="Alveolar rhabdomyosarcoma") )
        setattr(cls, "Giant cell glioblastoma",
                PermissibleValue(text="Giant cell glioblastoma") )
        setattr(cls, "Epithelioma, malignant",
                PermissibleValue(text="Epithelioma, malignant") )
        setattr(cls, "Sertoli-Leydig cell tumor, NOS",
                PermissibleValue(text="Sertoli-Leydig cell tumor, NOS") )
        setattr(cls, "Intratubular germ cell neoplasia",
                PermissibleValue(text="Intratubular germ cell neoplasia") )
        setattr(cls, "Pleomorphic rhabdomyosarcoma, NOS",
                PermissibleValue(text="Pleomorphic rhabdomyosarcoma, NOS") )
        setattr(cls, "Intracystic papillary neoplasm with low grade intraepithelial neoplasia",
                PermissibleValue(text="Intracystic papillary neoplasm with low grade intraepithelial neoplasia") )
        setattr(cls, "Mucinous tubular and spindle cell carcinoma",
                PermissibleValue(text="Mucinous tubular and spindle cell carcinoma") )
        setattr(cls, "Invasive carcinoma of no special type",
                PermissibleValue(text="Invasive carcinoma of no special type") )
        setattr(cls, "Pindborg tumor",
                PermissibleValue(text="Pindborg tumor") )
        setattr(cls, "Lipoid cell tumor of ovary",
                PermissibleValue(text="Lipoid cell tumor of ovary") )
        setattr(cls, "Angiofibroma, NOS",
                PermissibleValue(text="Angiofibroma, NOS") )
        setattr(cls, "Hepatocellular carcinoma, scirrhous",
                PermissibleValue(text="Hepatocellular carcinoma, scirrhous") )
        setattr(cls, "Squamous cell carcinoma, large cell, nonkeratinizing, NOS",
                PermissibleValue(text="Squamous cell carcinoma, large cell, nonkeratinizing, NOS") )
        setattr(cls, "Pilomyxoid astrocytoma",
                PermissibleValue(text="Pilomyxoid astrocytoma") )
        setattr(cls, "Subependymal glioma",
                PermissibleValue(text="Subependymal glioma") )
        setattr(cls, "Atypical carcinoid tumor",
                PermissibleValue(text="Atypical carcinoid tumor") )
        setattr(cls, "Aggressive digital papillary adenoma",
                PermissibleValue(text="Aggressive digital papillary adenoma") )
        setattr(cls, "Adenocarcinoma in a polyp, NOS",
                PermissibleValue(text="Adenocarcinoma in a polyp, NOS") )
        setattr(cls, "Intraductal papillary tumor with high grade intraepithelial neoplasia",
                PermissibleValue(text="Intraductal papillary tumor with high grade intraepithelial neoplasia") )
        setattr(cls, "Mixed acinar-ductal carcinoma",
                PermissibleValue(text="Mixed acinar-ductal carcinoma",
                                 description="Mixed Acinar-Ductal Carcinoma of the Pancreas") )
        setattr(cls, "Lymphoepithelioid lymphoma",
                PermissibleValue(text="Lymphoepithelioid lymphoma") )
        setattr(cls, "Blastoma, NOS",
                PermissibleValue(text="Blastoma, NOS") )
        setattr(cls, "Ameloblastic fibrodentinosarcoma",
                PermissibleValue(text="Ameloblastic fibrodentinosarcoma") )
        setattr(cls, "Adenocarcinoma of rete ovarii",
                PermissibleValue(text="Adenocarcinoma of rete ovarii") )
        setattr(cls, "Acute mixed lineage leukemia",
                PermissibleValue(text="Acute mixed lineage leukemia") )
        setattr(cls, "Intraductal carcinoma, noninfiltrating, NOS",
                PermissibleValue(text="Intraductal carcinoma, noninfiltrating, NOS") )
        setattr(cls, "Granulosa cell carcinoma",
                PermissibleValue(text="Granulosa cell carcinoma") )
        setattr(cls, "Squamous intraepithelial neoplasia, low grade",
                PermissibleValue(text="Squamous intraepithelial neoplasia, low grade") )
        setattr(cls, "Intramuscular lipoma",
                PermissibleValue(text="Intramuscular lipoma") )
        setattr(cls, "Noninvasive pancreatobiliary papillary neoplasm with low grade dysplasia",
                PermissibleValue(text="Noninvasive pancreatobiliary papillary neoplasm with low grade dysplasia") )
        setattr(cls, "Serous surface papilloma",
                PermissibleValue(text="Serous surface papilloma") )
        setattr(cls, "Polyvesicular vitelline tumor",
                PermissibleValue(text="Polyvesicular vitelline tumor") )
        setattr(cls, "Protoplasmic astrocytoma",
                PermissibleValue(text="Protoplasmic astrocytoma") )
        setattr(cls, "Combined small cell-adenocarcinoma",
                PermissibleValue(text="Combined small cell-adenocarcinoma") )
        setattr(cls, "Cutaneous histiocytoma, NOS",
                PermissibleValue(text="Cutaneous histiocytoma, NOS") )
        setattr(cls, "Parasympathetic paraganglioma",
                PermissibleValue(text="Parasympathetic paraganglioma") )
        setattr(cls, "Malignant lymphoma, small lymphocytic, diffuse",
                PermissibleValue(text="Malignant lymphoma, small lymphocytic, diffuse") )
        setattr(cls, "Serous adenocarcinoma, NOS",
                PermissibleValue(text="Serous adenocarcinoma, NOS") )
        setattr(cls, "Supratentorial PNET",
                PermissibleValue(text="Supratentorial PNET") )
        setattr(cls, "Mucinous cystadenoma, NOS",
                PermissibleValue(text="Mucinous cystadenoma, NOS") )
        setattr(cls, "Mucocarcinoid tumor",
                PermissibleValue(text="Mucocarcinoid tumor") )
        setattr(cls, "Acute basophilic leukaemia",
                PermissibleValue(text="Acute basophilic leukaemia") )
        setattr(cls, "Spindle cell lipoma",
                PermissibleValue(text="Spindle cell lipoma") )
        setattr(cls, "Retinoblastoma, spontaneously regressed",
                PermissibleValue(text="Retinoblastoma, spontaneously regressed") )
        setattr(cls, "Lipid-rich carcinoma",
                PermissibleValue(text="Lipid-rich carcinoma") )
        setattr(cls, "Blastic NK cell lymphoma",
                PermissibleValue(text="Blastic NK cell lymphoma") )
        setattr(cls, "Hereditary leiomyomatosis & RCC-associated renal cell carcinoma",
                PermissibleValue(text="Hereditary leiomyomatosis & RCC-associated renal cell carcinoma") )
        setattr(cls, "Hemangiopericytoma, malignant",
                PermissibleValue(text="Hemangiopericytoma, malignant") )
        setattr(cls, "Mast cell sarcoma",
                PermissibleValue(text="Mast cell sarcoma") )
        setattr(cls, "Giant cell tumor of bone, NOS",
                PermissibleValue(text="Giant cell tumor of bone, NOS") )
        setattr(cls, "Sertoli-Leydig cell tumor, poorly differentiated",
                PermissibleValue(text="Sertoli-Leydig cell tumor, poorly differentiated") )
        setattr(cls, "Dermoid cyst with malignant transformation",
                PermissibleValue(text="Dermoid cyst with malignant transformation") )
        setattr(cls, "Midline carcinoma of children and young adults with NUT rearrangement",
                PermissibleValue(text="Midline carcinoma of children and young adults with NUT rearrangement") )
        setattr(cls, "Mucin-secreting adenocarcinoma",
                PermissibleValue(text="Mucin-secreting adenocarcinoma") )
        setattr(cls, "Lentigo maligna melanoma",
                PermissibleValue(text="Lentigo maligna melanoma",
                                 description="Lentigo Maligna Melanoma") )
        setattr(cls, "Sertoli-Leydig cell tumor, intermediate differentiation, with heterologous elements",
                PermissibleValue(text="Sertoli-Leydig cell tumor, intermediate differentiation, with heterologous elements") )
        setattr(cls, "Cystoma, NOS",
                PermissibleValue(text="Cystoma, NOS") )
        setattr(cls, "Malignant lymphoma, mixed small cleaved and large cell, follicular",
                PermissibleValue(text="Malignant lymphoma, mixed small cleaved and large cell, follicular") )
        setattr(cls, "Liposarcoma, differentiated",
                PermissibleValue(text="Liposarcoma, differentiated") )
        setattr(cls, "Lobular adenocarcinoma",
                PermissibleValue(text="Lobular adenocarcinoma") )
        setattr(cls, "FAB M1",
                PermissibleValue(text="FAB M1") )
        setattr(cls, "Papillary squamous cell carcinoma in situ",
                PermissibleValue(text="Papillary squamous cell carcinoma in situ") )
        setattr(cls, "Infiltrating angiolipoma",
                PermissibleValue(text="Infiltrating angiolipoma") )
        setattr(cls, "Fetal lipomatosis",
                PermissibleValue(text="Fetal lipomatosis") )
        setattr(cls, "Clear cell tumor, NOS",
                PermissibleValue(text="Clear cell tumor, NOS") )
        setattr(cls, "FAB M2, AML1(CBF-alpha)/ETO",
                PermissibleValue(text="FAB M2, AML1(CBF-alpha)/ETO") )
        setattr(cls, "Lobular carcinoma, noninfiltrating",
                PermissibleValue(text="Lobular carcinoma, noninfiltrating") )
        setattr(cls, "Intraductal carcinoma and lobular carcinoma in situ",
                PermissibleValue(text="Intraductal carcinoma and lobular carcinoma in situ") )
        setattr(cls, "Hepatocellular carcinoma, sarcomatoid",
                PermissibleValue(text="Hepatocellular carcinoma, sarcomatoid") )
        setattr(cls, "Flat intraepithelial glandular neoplasia, high grade",
                PermissibleValue(text="Flat intraepithelial glandular neoplasia, high grade") )
        setattr(cls, "Mucoid adenocarcinoma",
                PermissibleValue(text="Mucoid adenocarcinoma") )
        setattr(cls, "Apocrine cystadenoma",
                PermissibleValue(text="Apocrine cystadenoma") )
        setattr(cls, "CIN III with severe dysplasia",
                PermissibleValue(text="CIN III with severe dysplasia") )
        setattr(cls, "Mature T-cell lymphoma, NOS",
                PermissibleValue(text="Mature T-cell lymphoma, NOS") )
        setattr(cls, "Peripheral neuroectodermal tumor",
                PermissibleValue(text="Peripheral neuroectodermal tumor") )
        setattr(cls, "DIN 3",
                PermissibleValue(text="DIN 3") )
        setattr(cls, "Metaplastic carcinoma with other types mesenchymal differentiation",
                PermissibleValue(text="Metaplastic carcinoma with other types mesenchymal differentiation") )
        setattr(cls, "Mixed pineal tumor",
                PermissibleValue(text="Mixed pineal tumor") )
        setattr(cls, "Solid pseudopapillary tumor",
                PermissibleValue(text="Solid pseudopapillary tumor") )
        setattr(cls, "Bronchial adenoma, NOS",
                PermissibleValue(text="Bronchial adenoma, NOS") )
        setattr(cls, "Intraductal papillary-mucinous adenoma",
                PermissibleValue(text="Intraductal papillary-mucinous adenoma") )
        setattr(cls, "Bednar tumor",
                PermissibleValue(text="Bednar tumor") )
        setattr(cls, "Perineural MPNST",
                PermissibleValue(text="Perineural MPNST") )
        setattr(cls, "Monomorphic adenoma",
                PermissibleValue(text="Monomorphic adenoma") )
        setattr(cls, "Lipid-rich Sertoli cell tumor",
                PermissibleValue(text="Lipid-rich Sertoli cell tumor") )
        setattr(cls, "Endometrioid carcinoma, NOS",
                PermissibleValue(text="Endometrioid carcinoma, NOS",
                                 description="Endometrial Carcinoma") )
        setattr(cls, "Reserve cell carcinoma",
                PermissibleValue(text="Reserve cell carcinoma") )
        setattr(cls, "Pleomorphic adenoma",
                PermissibleValue(text="Pleomorphic adenoma") )
        setattr(cls, "Splenic B-cell lymphoma/leukemia, unclassifiable",
                PermissibleValue(text="Splenic B-cell lymphoma/leukemia, unclassifiable") )
        setattr(cls, "Angiotropic lymphoma",
                PermissibleValue(text="Angiotropic lymphoma") )
        setattr(cls, "Gonadal stromal tumor, NOS",
                PermissibleValue(text="Gonadal stromal tumor, NOS") )
        setattr(cls, "Sclerosing liposarcoma",
                PermissibleValue(text="Sclerosing liposarcoma") )
        setattr(cls, "Mast cell tumor, NOS",
                PermissibleValue(text="Mast cell tumor, NOS") )
        setattr(cls, "Islet cell tumor, NOS",
                PermissibleValue(text="Islet cell tumor, NOS") )
        setattr(cls, "High-grade serous carcinoma",
                PermissibleValue(text="High-grade serous carcinoma") )
        setattr(cls, "Cellular schwannoma",
                PermissibleValue(text="Cellular schwannoma") )
        setattr(cls, "Adrenal medullary paraganglioma",
                PermissibleValue(text="Adrenal medullary paraganglioma") )
        setattr(cls, "Desmoplastic mesothelioma",
                PermissibleValue(text="Desmoplastic mesothelioma",
                                 description="Desmoplastic Mesothelioma") )
        setattr(cls, "Neuroendocrine carcinoma, moderately differentiated",
                PermissibleValue(text="Neuroendocrine carcinoma, moderately differentiated") )
        setattr(cls, "Adenocarcinoma in tubular adenoma",
                PermissibleValue(text="Adenocarcinoma in tubular adenoma") )
        setattr(cls, "Lymphosarcoma, diffuse",
                PermissibleValue(text="Lymphosarcoma, diffuse") )
        setattr(cls, "Choroid plexus carcinoma",
                PermissibleValue(text="Choroid plexus carcinoma") )
        setattr(cls, "Clear cell sarcoma, of tendons and aponeuroses",
                PermissibleValue(text="Clear cell sarcoma, of tendons and aponeuroses") )
        setattr(cls, "Hodgkin lymphoma, lymphocyte depletion, reticular",
                PermissibleValue(text="Hodgkin lymphoma, lymphocyte depletion, reticular") )
        setattr(cls, "Giant cell tumor of bone, malignant",
                PermissibleValue(text="Giant cell tumor of bone, malignant") )
        setattr(cls, "Mixed pancreatic endocrine and exocrine tumor, malignant",
                PermissibleValue(text="Mixed pancreatic endocrine and exocrine tumor, malignant") )
        setattr(cls, "Intraosseous well differentiated osteosarcoma",
                PermissibleValue(text="Intraosseous well differentiated osteosarcoma") )
        setattr(cls, "Malignant melanoma, regressing",
                PermissibleValue(text="Malignant melanoma, regressing") )
        setattr(cls, "Round cell osteosarcoma",
                PermissibleValue(text="Round cell osteosarcoma") )
        setattr(cls, "Precursor cell lymphoblastic leukemia, not phenotyped",
                PermissibleValue(text="Precursor cell lymphoblastic leukemia, not phenotyped") )
        setattr(cls, "Intraepidermal squamous cell carcinoma, Bowen type",
                PermissibleValue(text="Intraepidermal squamous cell carcinoma, Bowen type") )
        setattr(cls, "Hepatoid yolk sac tumor",
                PermissibleValue(text="Hepatoid yolk sac tumor") )
        setattr(cls, "Nonlipid reticuloendotheliosis",
                PermissibleValue(text="Nonlipid reticuloendotheliosis") )
        setattr(cls, "Malignant lymphoma, lymphocytic, intermediate differentiation, nodular",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, intermediate differentiation, nodular") )
        setattr(cls, "Tumor, secondary",
                PermissibleValue(text="Tumor, secondary") )
        setattr(cls, "Pilomatrix carcinoma",
                PermissibleValue(text="Pilomatrix carcinoma") )
        setattr(cls, "Periapical cemental dysplasia",
                PermissibleValue(text="Periapical cemental dysplasia") )
        setattr(cls, "Islet cell adenomatosis",
                PermissibleValue(text="Islet cell adenomatosis") )
        setattr(cls, "Clear cell sarcoma of kidney",
                PermissibleValue(text="Clear cell sarcoma of kidney") )
        setattr(cls, "Sarcomatoid carcinoma",
                PermissibleValue(text="Sarcomatoid carcinoma") )
        setattr(cls, "Alveolar adenoma",
                PermissibleValue(text="Alveolar adenoma") )
        setattr(cls, "Chondroblastoma, NOS",
                PermissibleValue(text="Chondroblastoma, NOS") )
        setattr(cls, "Infiltrating lipoma",
                PermissibleValue(text="Infiltrating lipoma") )
        setattr(cls, "Mucinous cystadenoma, borderline malignancy",
                PermissibleValue(text="Mucinous cystadenoma, borderline malignancy") )
        setattr(cls, "Intraductal tubular-papillary neoplasm, low grade",
                PermissibleValue(text="Intraductal tubular-papillary neoplasm, low grade") )
        setattr(cls, "Medulloblastoma, group 3",
                PermissibleValue(text="Medulloblastoma, group 3") )
        setattr(cls, "Intraductal carcinoma, solid type",
                PermissibleValue(text="Intraductal carcinoma, solid type") )
        setattr(cls, "FAB M5 (includes all variants)",
                PermissibleValue(text="FAB M5 (includes all variants)") )
        setattr(cls, "Adult rhabdomyoma",
                PermissibleValue(text="Adult rhabdomyoma") )
        setattr(cls, "Malignant mucinous adenofibroma",
                PermissibleValue(text="Malignant mucinous adenofibroma") )
        setattr(cls, "Eccrine poroma",
                PermissibleValue(text="Eccrine poroma") )
        setattr(cls, "Fibroameloblastic odontoma",
                PermissibleValue(text="Fibroameloblastic odontoma") )
        setattr(cls, "Immature teratoma, NOS",
                PermissibleValue(text="Immature teratoma, NOS") )
        setattr(cls, "Follicular lymphoma, small cleaved cell",
                PermissibleValue(text="Follicular lymphoma, small cleaved cell") )
        setattr(cls, "Interstitial cell tumor, NOS",
                PermissibleValue(text="Interstitial cell tumor, NOS") )
        setattr(cls, "Eccrine papillary adenocarcinoma",
                PermissibleValue(text="Eccrine papillary adenocarcinoma") )
        setattr(cls, "Lymphoepithelial carcinoma",
                PermissibleValue(text="Lymphoepithelial carcinoma",
                                 description="Nasopharyngeal Type Undifferentiated Carcinoma") )
        setattr(cls, "Invasive lobular carcinoma",
                PermissibleValue(text="Invasive lobular carcinoma") )
        setattr(cls, "Carcinoma with osseous differentiation",
                PermissibleValue(text="Carcinoma with osseous differentiation") )
        setattr(cls, "Intraepidermal epithelioma of Jadassohn",
                PermissibleValue(text="Intraepidermal epithelioma of Jadassohn") )
        setattr(cls, "Neuroepithelioma, NOS",
                PermissibleValue(text="Neuroepithelioma, NOS") )
        setattr(cls, "Immunoproliferative small intestinal disease",
                PermissibleValue(text="Immunoproliferative small intestinal disease") )
        setattr(cls, "Carotid body paraganglioma",
                PermissibleValue(text="Carotid body paraganglioma") )
        setattr(cls, "Combined small cell-squamous cell carcinoma",
                PermissibleValue(text="Combined small cell-squamous cell carcinoma") )
        setattr(cls, "EC cell carcinoid",
                PermissibleValue(text="EC cell carcinoid") )
        setattr(cls, "PIN III",
                PermissibleValue(text="PIN III") )
        setattr(cls, "Cystic astrocytoma",
                PermissibleValue(text="Cystic astrocytoma") )
        setattr(cls, "Neuroendocrine carcinoma, low grade",
                PermissibleValue(text="Neuroendocrine carcinoma, low grade") )
        setattr(cls, "Squamous cell carcinoma, sarcomatoid",
                PermissibleValue(text="Squamous cell carcinoma, sarcomatoid") )
        setattr(cls, "Carcinosarcoma, embryonal",
                PermissibleValue(text="Carcinosarcoma, embryonal") )
        setattr(cls, "Placental site trophoblastic tumor",
                PermissibleValue(text="Placental site trophoblastic tumor") )
        setattr(cls, "Mixed small cell carcinoma",
                PermissibleValue(text="Mixed small cell carcinoma") )
        setattr(cls, "Squamous cell carcinoma, metastatic, NOS",
                PermissibleValue(text="Squamous cell carcinoma, metastatic, NOS") )
        setattr(cls, "Phyllodes tumor, NOS",
                PermissibleValue(text="Phyllodes tumor, NOS") )
        setattr(cls, "Polymorphic post transplant lymphoproliferative disorder",
                PermissibleValue(text="Polymorphic post transplant lymphoproliferative disorder") )
        setattr(cls, "ALK positive large B-cell lymphoma",
                PermissibleValue(text="ALK positive large B-cell lymphoma") )
        setattr(cls, "Rathke pouch tumor",
                PermissibleValue(text="Rathke pouch tumor") )
        setattr(cls, "Medullary carcinoma with amyloid stroma",
                PermissibleValue(text="Medullary carcinoma with amyloid stroma") )
        setattr(cls, "Esophageal squamous intraepithelial neoplasia (dysplasia), low grade",
                PermissibleValue(text="Esophageal squamous intraepithelial neoplasia (dysplasia), low grade") )
        setattr(cls, "Differentiated-type vulvar intraepithelial neoplasia",
                PermissibleValue(text="Differentiated-type vulvar intraepithelial neoplasia") )
        setattr(cls, "Metaplastic carcinoma of no special type",
                PermissibleValue(text="Metaplastic carcinoma of no special type") )
        setattr(cls, "Splenic marginal zone lymphoma, NOS",
                PermissibleValue(text="Splenic marginal zone lymphoma, NOS") )
        setattr(cls, "Mucinous carcinoma",
                PermissibleValue(text="Mucinous carcinoma") )
        setattr(cls, "Ossifying fibromyxoid tumor",
                PermissibleValue(text="Ossifying fibromyxoid tumor") )
        setattr(cls, "Renal cell adenocarcinoma",
                PermissibleValue(text="Renal cell adenocarcinoma") )
        setattr(cls, "Mesothelioma, malignant",
                PermissibleValue(text="Mesothelioma, malignant") )
        setattr(cls, "Clear cell adenofibroma of borderline malignancy",
                PermissibleValue(text="Clear cell adenofibroma of borderline malignancy") )
        setattr(cls, "Acute myeloid leukemia with maturation",
                PermissibleValue(text="Acute myeloid leukemia with maturation") )
        setattr(cls, "Fetal adenocarcinoma",
                PermissibleValue(text="Fetal adenocarcinoma") )
        setattr(cls, "Solitary mastocytoma of skin",
                PermissibleValue(text="Solitary mastocytoma of skin") )
        setattr(cls, "Metastatic signet ring cell carcinoma",
                PermissibleValue(text="Metastatic signet ring cell carcinoma") )
        setattr(cls, "Papillary cystadenoma, borderline malignancy",
                PermissibleValue(text="Papillary cystadenoma, borderline malignancy") )
        setattr(cls, "Mucoepidermoid tumor",
                PermissibleValue(text="Mucoepidermoid tumor") )
        setattr(cls, "Adrenal cortical adenoma, clear cell",
                PermissibleValue(text="Adrenal cortical adenoma, clear cell") )
        setattr(cls, "Leiomyomatosis, NOS",
                PermissibleValue(text="Leiomyomatosis, NOS") )
        setattr(cls, "Mast cell leukaemia",
                PermissibleValue(text="Mast cell leukaemia") )
        setattr(cls, "Smooth muscle tumor of uncertain malignant potential",
                PermissibleValue(text="Smooth muscle tumor of uncertain malignant potential") )
        setattr(cls, "Papillary carcinoma, NOS",
                PermissibleValue(text="Papillary carcinoma, NOS") )
        setattr(cls, "Verrucous papilloma",
                PermissibleValue(text="Verrucous papilloma") )
        setattr(cls, "Glioma, malignant",
                PermissibleValue(text="Glioma, malignant") )
        setattr(cls, "Classical Hodgkin lymphoma, lymphocyte depletion, diffuse fibrosis",
                PermissibleValue(text="Classical Hodgkin lymphoma, lymphocyte depletion, diffuse fibrosis") )
        setattr(cls, "Junction nevus",
                PermissibleValue(text="Junction nevus") )
        setattr(cls, "Micropapillary carcinoma, NOS",
                PermissibleValue(text="Micropapillary carcinoma, NOS") )
        setattr(cls, "Acute myeloid leukemia with mutated CEBPA",
                PermissibleValue(text="Acute myeloid leukemia with mutated CEBPA") )
        setattr(cls, "Microcystic urothelial carcinoma",
                PermissibleValue(text="Microcystic urothelial carcinoma") )
        setattr(cls, "Carcinoma showing thymus-like differentiation",
                PermissibleValue(text="Carcinoma showing thymus-like differentiation") )
        setattr(cls, "Brown fat tumor",
                PermissibleValue(text="Brown fat tumor") )
        setattr(cls, "Clear cell odontogenic carcinoma",
                PermissibleValue(text="Clear cell odontogenic carcinoma") )
        setattr(cls, "Embryonal hepatoma",
                PermissibleValue(text="Embryonal hepatoma") )
        setattr(cls, "Endometrial sarcoma, NOS",
                PermissibleValue(text="Endometrial sarcoma, NOS") )
        setattr(cls, "Yolk sac tumor",
                PermissibleValue(text="Yolk sac tumor") )
        setattr(cls, "Undifferentiated spindle cell sarcoma",
                PermissibleValue(text="Undifferentiated spindle cell sarcoma") )
        setattr(cls, "Tubulolobular carcinoma",
                PermissibleValue(text="Tubulolobular carcinoma") )
        setattr(cls, "Odontogenic sarcoma",
                PermissibleValue(text="Odontogenic sarcoma") )
        setattr(cls, "Diffuse large B-cell lymphoma associated with chronic inflammation",
                PermissibleValue(text="Diffuse large B-cell lymphoma associated with chronic inflammation") )
        setattr(cls, "Spongioblastoma polare",
                PermissibleValue(text="Spongioblastoma polare") )
        setattr(cls, "Intraglandular papillary neoplasm with low grade intraepithelial neoplasia",
                PermissibleValue(text="Intraglandular papillary neoplasm with low grade intraepithelial neoplasia") )
        setattr(cls, "Enterochromaffin-like cell carcinoid, NOS",
                PermissibleValue(text="Enterochromaffin-like cell carcinoid, NOS") )
        setattr(cls, "Esophageal glandular dysplasia (intraepithelial neoplasia), low grade",
                PermissibleValue(text="Esophageal glandular dysplasia (intraepithelial neoplasia), low grade") )
        setattr(cls, "Lymphocytic leukemia, NOS",
                PermissibleValue(text="Lymphocytic leukemia, NOS") )
        setattr(cls, "Mesonephric adenoma",
                PermissibleValue(text="Mesonephric adenoma") )
        setattr(cls, "Neuroendocrine carcinoma, well-differentiated",
                PermissibleValue(text="Neuroendocrine carcinoma, well-differentiated") )
        setattr(cls, "Giant cell sarcoma of bone",
                PermissibleValue(text="Giant cell sarcoma of bone") )
        setattr(cls, "Chondromatosis, NOS",
                PermissibleValue(text="Chondromatosis, NOS") )
        setattr(cls, "Basosquamous carcinoma",
                PermissibleValue(text="Basosquamous carcinoma") )
        setattr(cls, "Tenosynovial giant cell tumor",
                PermissibleValue(text="Tenosynovial giant cell tumor") )
        setattr(cls, "Adrenal cortical adenoma, mixed cell",
                PermissibleValue(text="Adrenal cortical adenoma, mixed cell") )
        setattr(cls, "Serous borderline tumor-micropapillary variant",
                PermissibleValue(text="Serous borderline tumor-micropapillary variant") )
        setattr(cls, "Myelocytic leukemia, NOS",
                PermissibleValue(text="Myelocytic leukemia, NOS") )
        setattr(cls, "Secretory meningioma",
                PermissibleValue(text="Secretory meningioma") )
        setattr(cls, "Leiomyosarcoma, NOS",
                PermissibleValue(text="Leiomyosarcoma, NOS") )
        setattr(cls, "Mucinous cystic tumor with intermediate dysplasia",
                PermissibleValue(text="Mucinous cystic tumor with intermediate dysplasia") )
        setattr(cls, "Von Recklinghausen disease",
                PermissibleValue(text="Von Recklinghausen disease") )
        setattr(cls, "Mucous carcinoma",
                PermissibleValue(text="Mucous carcinoma") )
        setattr(cls, "Villous papilloma",
                PermissibleValue(text="Villous papilloma") )
        setattr(cls, "Intraductal papillary-mucinous neoplasm with low grade dysplasia",
                PermissibleValue(text="Intraductal papillary-mucinous neoplasm with low grade dysplasia") )
        setattr(cls, "Endometrioid cystadenoma, borderline malignancy",
                PermissibleValue(text="Endometrioid cystadenoma, borderline malignancy") )
        setattr(cls, "Mixed embryonal rhabdomyosarcoma and alveolar rhabdomyosarcoma",
                PermissibleValue(text="Mixed embryonal rhabdomyosarcoma and alveolar rhabdomyosarcoma") )
        setattr(cls, "Cystic teratoma, NOS",
                PermissibleValue(text="Cystic teratoma, NOS") )
        setattr(cls, "Squamous cell carcinoma, clear cell type",
                PermissibleValue(text="Squamous cell carcinoma, clear cell type") )
        setattr(cls, "Verrucous squamous cell carcinoma",
                PermissibleValue(text="Verrucous squamous cell carcinoma") )
        setattr(cls, "Ameloblastic fibro-odontosarcoma",
                PermissibleValue(text="Ameloblastic fibro-odontosarcoma") )
        setattr(cls, "Ossifying fibroma",
                PermissibleValue(text="Ossifying fibroma") )
        setattr(cls, "Hodgkin lymphoma, lymphocyte depletion, NOS",
                PermissibleValue(text="Hodgkin lymphoma, lymphocyte depletion, NOS") )
        setattr(cls, "Invasive lobular carcinoma, tubulolobular variant",
                PermissibleValue(text="Invasive lobular carcinoma, tubulolobular variant") )
        setattr(cls, "Retinal anlage tumor",
                PermissibleValue(text="Retinal anlage tumor") )
        setattr(cls, "Chronic lymphatic leukemia",
                PermissibleValue(text="Chronic lymphatic leukemia") )
        setattr(cls, "Chronic myeloid leukemia, NOS",
                PermissibleValue(text="Chronic myeloid leukemia, NOS") )
        setattr(cls, "Myeloid leukemia associated with Down Syndrome",
                PermissibleValue(text="Myeloid leukemia associated with Down Syndrome") )
        setattr(cls, "Sebaceous adenocarcinoma",
                PermissibleValue(text="Sebaceous adenocarcinoma",
                                 description="Head and Neck Sebaceous Carcinoma") )
        setattr(cls, "Adenocarcinoma in adenomatous polyposis coli",
                PermissibleValue(text="Adenocarcinoma in adenomatous polyposis coli") )
        setattr(cls, "Mucinous cystic neoplasm with low-grade intraepithelial neoplasia",
                PermissibleValue(text="Mucinous cystic neoplasm with low-grade intraepithelial neoplasia") )
        setattr(cls, "Synovial sarcoma, spindle cell",
                PermissibleValue(text="Synovial sarcoma, spindle cell") )
        setattr(cls, "Syringocystadenoma papilliferum",
                PermissibleValue(text="Syringocystadenoma papilliferum") )
        setattr(cls, "Adenoma, NOS",
                PermissibleValue(text="Adenoma, NOS") )
        setattr(cls, "Subacute myeloid leukemia",
                PermissibleValue(text="Subacute myeloid leukemia") )
        setattr(cls, "Rosette-forming glioneuronal tumor",
                PermissibleValue(text="Rosette-forming glioneuronal tumor") )
        setattr(cls, "Mucinous adenofibroma, NOS",
                PermissibleValue(text="Mucinous adenofibroma, NOS") )
        setattr(cls, "Infiltrating ductular carcinoma",
                PermissibleValue(text="Infiltrating ductular carcinoma") )
        setattr(cls, "Lipomatous medulloblastoma",
                PermissibleValue(text="Lipomatous medulloblastoma") )
        setattr(cls, "Acute leukemia, Burkitt type",
                PermissibleValue(text="Acute leukemia, Burkitt type") )
        setattr(cls, "Chondroma, NOS",
                PermissibleValue(text="Chondroma, NOS") )
        setattr(cls, "Malignant lymphoma, noncleaved, diffuse, NOS",
                PermissibleValue(text="Malignant lymphoma, noncleaved, diffuse, NOS") )
        setattr(cls, "Acinar adenocarcinoma, sarcomatoid",
                PermissibleValue(text="Acinar adenocarcinoma, sarcomatoid") )
        setattr(cls, "Serotonin producing carcinoid",
                PermissibleValue(text="Serotonin producing carcinoid") )
        setattr(cls, "Fibrosarcoma, NOS",
                PermissibleValue(text="Fibrosarcoma, NOS") )
        setattr(cls, "Acinar adenoma",
                PermissibleValue(text="Acinar adenoma") )
        setattr(cls, "Neoplasm, NOS",
                PermissibleValue(text="Neoplasm, NOS") )
        setattr(cls, "Spindle epithelial tumor with thymus-like differentiation",
                PermissibleValue(text="Spindle epithelial tumor with thymus-like differentiation") )
        setattr(cls, "Hurthle cell adenocarcinoma",
                PermissibleValue(text="Hurthle cell adenocarcinoma") )
        setattr(cls, "Giant cell carcinoma",
                PermissibleValue(text="Giant cell carcinoma") )
        setattr(cls, "Racemose hemangioma",
                PermissibleValue(text="Racemose hemangioma") )
        setattr(cls, "Spindle cell hemangioendothelioma",
                PermissibleValue(text="Spindle cell hemangioendothelioma") )
        setattr(cls, "LCIS, NOS",
                PermissibleValue(text="LCIS, NOS") )
        setattr(cls, "Therapy-related acute myeloid leukemia, alkylating agent related",
                PermissibleValue(text="Therapy-related acute myeloid leukemia, alkylating agent related") )
        setattr(cls, "Intraepithelial squamous cell carcinoma",
                PermissibleValue(text="Intraepithelial squamous cell carcinoma") )
        setattr(cls, "Anaplastic pleomorphic xanthroastrocytoma",
                PermissibleValue(text="Anaplastic pleomorphic xanthroastrocytoma") )
        setattr(cls, "Cystic tumor of atrio-ventricular node",
                PermissibleValue(text="Cystic tumor of atrio-ventricular node") )
        setattr(cls, "Endometrial stromal sarcoma, high grade",
                PermissibleValue(text="Endometrial stromal sarcoma, high grade") )
        setattr(cls, "Intraductal papillary mucinous neoplasm with high grade dysplasia",
                PermissibleValue(text="Intraductal papillary mucinous neoplasm with high grade dysplasia") )
        setattr(cls, "Hairy cell leukaemia variant",
                PermissibleValue(text="Hairy cell leukaemia variant") )
        setattr(cls, "Malignant melanoma, NOS",
                PermissibleValue(text="Malignant melanoma, NOS") )
        setattr(cls, "Basal cell adenocarcinoma",
                PermissibleValue(text="Basal cell adenocarcinoma",
                                 description="Salivary Gland Basal Cell Adenocarcinoma") )
        setattr(cls, "Malignant lymphoma, mixed small and large cell, diffuse",
                PermissibleValue(text="Malignant lymphoma, mixed small and large cell, diffuse") )
        setattr(cls, "Hepatocellular carcinoma, spindle cell variant",
                PermissibleValue(text="Hepatocellular carcinoma, spindle cell variant") )
        setattr(cls, "BALT lymphoma",
                PermissibleValue(text="BALT lymphoma") )
        setattr(cls, "Hepatoid adenocarcinoma",
                PermissibleValue(text="Hepatoid adenocarcinoma",
                                 description="Hepatoid Adenocarcinoma") )
        setattr(cls, "Pigmented nevus, NOS",
                PermissibleValue(text="Pigmented nevus, NOS") )
        setattr(cls, "Calcifying epithelial odontogenic tumor",
                PermissibleValue(text="Calcifying epithelial odontogenic tumor") )
        setattr(cls, "Acute erythremic myelosis",
                PermissibleValue(text="Acute erythremic myelosis") )
        setattr(cls, "Pacinian tumor",
                PermissibleValue(text="Pacinian tumor") )
        setattr(cls, "Papillary renal cell carcinoma",
                PermissibleValue(text="Papillary renal cell carcinoma") )
        setattr(cls, "Polycythemia vera",
                PermissibleValue(text="Polycythemia vera") )
        setattr(cls, "Fibromatosis-like metaplastic carcinoma",
                PermissibleValue(text="Fibromatosis-like metaplastic carcinoma") )
        setattr(cls, "Myofibroblastic tumor, peribronchial",
                PermissibleValue(text="Myofibroblastic tumor, peribronchial") )
        setattr(cls, "Small cell carcinoma, NOS",
                PermissibleValue(text="Small cell carcinoma, NOS") )
        setattr(cls, "Diffuse leptomeningeal glioneuronal tumor",
                PermissibleValue(text="Diffuse leptomeningeal glioneuronal tumor") )
        setattr(cls, "Adrenal cortical tumor, malignant",
                PermissibleValue(text="Adrenal cortical tumor, malignant") )
        setattr(cls, "Squamous cell carcinoma, NOS",
                PermissibleValue(text="Squamous cell carcinoma, NOS") )
        setattr(cls, "Rhabdoid tumor, NOS",
                PermissibleValue(text="Rhabdoid tumor, NOS") )
        setattr(cls, "Acquired tufted hemangioma",
                PermissibleValue(text="Acquired tufted hemangioma") )
        setattr(cls, "Embryonal adenocarcinoma",
                PermissibleValue(text="Embryonal adenocarcinoma") )
        setattr(cls, "Chondroblastic osteosarcoma",
                PermissibleValue(text="Chondroblastic osteosarcoma") )
        setattr(cls, "Acute myeloid leukaemia, t(8;21)(q22;q22)",
                PermissibleValue(text="Acute myeloid leukaemia, t(8;21)(q22;q22)") )
        setattr(cls, "Glioma, NOS",
                PermissibleValue(text="Glioma, NOS") )
        setattr(cls, "Glucagon-like peptide-producing tumor",
                PermissibleValue(text="Glucagon-like peptide-producing tumor") )
        setattr(cls, "Transitional meningioma",
                PermissibleValue(text="Transitional meningioma") )
        setattr(cls, "Therapy-related acute myeloid leukemia, epipodophyllotoxin-related",
                PermissibleValue(text="Therapy-related acute myeloid leukemia, epipodophyllotoxin-related") )
        setattr(cls, "Vascular leiomyoma",
                PermissibleValue(text="Vascular leiomyoma") )
        setattr(cls, "Papillary and follicular carcinoma",
                PermissibleValue(text="Papillary and follicular carcinoma") )
        setattr(cls, "Infiltrating lobular carcinoma, NOS",
                PermissibleValue(text="Infiltrating lobular carcinoma, NOS") )
        setattr(cls, "Small congenital nevus",
                PermissibleValue(text="Small congenital nevus") )
        setattr(cls, "Enteroglucagonoma, NOS",
                PermissibleValue(text="Enteroglucagonoma, NOS") )
        setattr(cls, "Dedifferentiated chordoma",
                PermissibleValue(text="Dedifferentiated chordoma") )
        setattr(cls, "Adenocarcinoma with apocrine metaplasia",
                PermissibleValue(text="Adenocarcinoma with apocrine metaplasia") )
        setattr(cls, "Immunoblastic sarcoma",
                PermissibleValue(text="Immunoblastic sarcoma") )
        setattr(cls, "Ghost cell odontogenic carcinoma",
                PermissibleValue(text="Ghost cell odontogenic carcinoma") )
        setattr(cls, "Anaplastic large cell lymphoma, ALK positive",
                PermissibleValue(text="Anaplastic large cell lymphoma, ALK positive") )
        setattr(cls, "Classical Hodgkin lymphoma, nodular sclerosis, cellular phase",
                PermissibleValue(text="Classical Hodgkin lymphoma, nodular sclerosis, cellular phase") )
        setattr(cls, "Mesonephric adenocarcinoma",
                PermissibleValue(text="Mesonephric adenocarcinoma") )
        setattr(cls, "Leiomyoma, NOS",
                PermissibleValue(text="Leiomyoma, NOS") )
        setattr(cls, "Malignant lymphoma, centroblasticcentrocytic, diffuse",
                PermissibleValue(text="Malignant lymphoma, centroblasticcentrocytic, diffuse") )
        setattr(cls, "Adrenal cortical adenocarcinoma",
                PermissibleValue(text="Adrenal cortical adenocarcinoma") )
        setattr(cls, "Esophageal intraepithelial neoplasia, high grade",
                PermissibleValue(text="Esophageal intraepithelial neoplasia, high grade") )
        setattr(cls, "Mesonephric tumor, NOS",
                PermissibleValue(text="Mesonephric tumor, NOS") )
        setattr(cls, "Signet ring cell carcinoma",
                PermissibleValue(text="Signet ring cell carcinoma") )
        setattr(cls, "Adnexal carcinoma",
                PermissibleValue(text="Adnexal carcinoma") )
        setattr(cls, "Acute myeloid leukemia, CBF-beta/MYH11",
                PermissibleValue(text="Acute myeloid leukemia, CBF-beta/MYH11") )
        setattr(cls, "Cementoblastoma, benign",
                PermissibleValue(text="Cementoblastoma, benign") )
        setattr(cls, "Wolffian duct tumor",
                PermissibleValue(text="Wolffian duct tumor") )
        setattr(cls, "Acute bilineal leukemia",
                PermissibleValue(text="Acute bilineal leukemia") )
        setattr(cls, "Tibial adamantinoma",
                PermissibleValue(text="Tibial adamantinoma") )
        setattr(cls, "Skin appendage tumor, benign",
                PermissibleValue(text="Skin appendage tumor, benign") )
        setattr(cls, "Granulosa cell tumor, NOS",
                PermissibleValue(text="Granulosa cell tumor, NOS") )
        setattr(cls, "Central osteosarcoma",
                PermissibleValue(text="Central osteosarcoma") )
        setattr(cls, "Mesothelioma, biphasic, NOS",
                PermissibleValue(text="Mesothelioma, biphasic, NOS") )
        setattr(cls, "Peripheral odontogenic fibroma",
                PermissibleValue(text="Peripheral odontogenic fibroma") )
        setattr(cls, "Carcinoma, diffuse type",
                PermissibleValue(text="Carcinoma, diffuse type") )
        setattr(cls, "Primary cutaneous CD8-positive aggressive epidermotropic cytotoxic T-cell lymphoma",
                PermissibleValue(text="Primary cutaneous CD8-positive aggressive epidermotropic cytotoxic T-cell lymphoma") )
        setattr(cls, "Glandular intraepithelial neoplasia, grade III",
                PermissibleValue(text="Glandular intraepithelial neoplasia, grade III") )
        setattr(cls, "Squamous odontogenic tumor",
                PermissibleValue(text="Squamous odontogenic tumor") )
        setattr(cls, "Papillary meningioma",
                PermissibleValue(text="Papillary meningioma") )
        setattr(cls, "Epidermoid carcinoma, NOS",
                PermissibleValue(text="Epidermoid carcinoma, NOS") )
        setattr(cls, "Leukemic reticuloendotheliosis",
                PermissibleValue(text="Leukemic reticuloendotheliosis") )
        setattr(cls, "Glandular intraepithelial neoplasia, grade I",
                PermissibleValue(text="Glandular intraepithelial neoplasia, grade I") )
        setattr(cls, "Chronic lymphocytic leukemia, B-cell type (includes all variants of BCLL)",
                PermissibleValue(text="Chronic lymphocytic leukemia, B-cell type (includes all variants of BCLL)") )
        setattr(cls, "Aggressive NK-cell leukaemia",
                PermissibleValue(text="Aggressive NK-cell leukaemia") )
        setattr(cls, "Solid teratoma",
                PermissibleValue(text="Solid teratoma") )
        setattr(cls, "Cystadenocarcinoma, NOS",
                PermissibleValue(text="Cystadenocarcinoma, NOS") )
        setattr(cls, "Infiltrating basal cell carcinoma, non-sclerosing",
                PermissibleValue(text="Infiltrating basal cell carcinoma, non-sclerosing") )
        setattr(cls, "Minimally invasive adenocarcinoma, NOS",
                PermissibleValue(text="Minimally invasive adenocarcinoma, NOS") )
        setattr(cls, "Intestinal-type adenocarcinoma",
                PermissibleValue(text="Intestinal-type adenocarcinoma") )
        setattr(cls, "Pseudomucinous cystadenocarcinoma, NOS",
                PermissibleValue(text="Pseudomucinous cystadenocarcinoma, NOS") )
        setattr(cls, "Subacute myelogenous leukemia",
                PermissibleValue(text="Subacute myelogenous leukemia") )
        setattr(cls, "Chordoid glioma of third ventricle",
                PermissibleValue(text="Chordoid glioma of third ventricle") )
        setattr(cls, "Salivary duct carcinoma",
                PermissibleValue(text="Salivary duct carcinoma",
                                 description="Salivary Duct Carcinoma") )
        setattr(cls, "Mixed mesenchymal tumor",
                PermissibleValue(text="Mixed mesenchymal tumor") )
        setattr(cls, "Bronchiolo-alveolar carcinoma; type II pneumocyte",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma; type II pneumocyte") )
        setattr(cls, "Acute biphenotypic leukemia",
                PermissibleValue(text="Acute biphenotypic leukemia") )
        setattr(cls, "Mixed acidophil-basophil adenoma",
                PermissibleValue(text="Mixed acidophil-basophil adenoma") )
        setattr(cls, "Capillary hemangioma",
                PermissibleValue(text="Capillary hemangioma") )
        setattr(cls, "Brenner tumor, malignant",
                PermissibleValue(text="Brenner tumor, malignant") )
        setattr(cls, "Chordoid glioma",
                PermissibleValue(text="Chordoid glioma") )
        setattr(cls, "Mixed teratoma and seminoma",
                PermissibleValue(text="Mixed teratoma and seminoma") )
        setattr(cls, "Embryonal tumor with multilayered rosettes C19MC-altered",
                PermissibleValue(text="Embryonal tumor with multilayered rosettes C19MC-altered") )
        setattr(cls, "Melanotic progonoma",
                PermissibleValue(text="Melanotic progonoma") )
        setattr(cls, "Thymoma, type B3, malignant",
                PermissibleValue(text="Thymoma, type B3, malignant") )
        setattr(cls, "Juxtacortical osteosarcoma",
                PermissibleValue(text="Juxtacortical osteosarcoma") )
        setattr(cls, "Reticulosarcoma, diffuse",
                PermissibleValue(text="Reticulosarcoma, diffuse") )
        setattr(cls, "Astrocytoma, low grade",
                PermissibleValue(text="Astrocytoma, low grade") )
        setattr(cls, "B-cell lymphocytic leukemia/small lymphocytic lymphoma",
                PermissibleValue(text="B-cell lymphocytic leukemia/small lymphocytic lymphoma") )
        setattr(cls, "Extraventricular neurocytoma",
                PermissibleValue(text="Extraventricular neurocytoma") )
        setattr(cls, "Glassy cell carcinoma",
                PermissibleValue(text="Glassy cell carcinoma") )
        setattr(cls, "ACTH-producing tumor",
                PermissibleValue(text="ACTH-producing tumor") )
        setattr(cls, "Malignant midline reticulosis",
                PermissibleValue(text="Malignant midline reticulosis") )
        setattr(cls, "Germ cell tumors with associated hematological malignancy",
                PermissibleValue(text="Germ cell tumors with associated hematological malignancy") )
        setattr(cls, "Choriocarcinoma combined with embryonal carcinoma",
                PermissibleValue(text="Choriocarcinoma combined with embryonal carcinoma") )
        setattr(cls, "Rhabdoid meningioma",
                PermissibleValue(text="Rhabdoid meningioma") )
        setattr(cls, "Mixed squamous cell and glandular papilloma",
                PermissibleValue(text="Mixed squamous cell and glandular papilloma") )
        setattr(cls, "Ganglioglioma, anaplastic",
                PermissibleValue(text="Ganglioglioma, anaplastic") )
        setattr(cls, "Bile duct carcinoma",
                PermissibleValue(text="Bile duct carcinoma") )
        setattr(cls, "Adenocarcinoma combined with other types of carcinoma",
                PermissibleValue(text="Adenocarcinoma combined with other types of carcinoma") )
        setattr(cls, "Biphenotypic sinonasal sarcoma",
                PermissibleValue(text="Biphenotypic sinonasal sarcoma",
                                 description="Biphenotypic Sinonasal Sarcoma") )
        setattr(cls, "Adrenal medullary paraganglioma, malignant",
                PermissibleValue(text="Adrenal medullary paraganglioma, malignant") )
        setattr(cls, "Cutaneous T-cell lymphoma, NOS",
                PermissibleValue(text="Cutaneous T-cell lymphoma, NOS") )
        setattr(cls, "Adrenal cortical adenoma, pigmented",
                PermissibleValue(text="Adrenal cortical adenoma, pigmented") )
        setattr(cls, "PP/PYY producing tumor",
                PermissibleValue(text="PP/PYY producing tumor") )
        setattr(cls, "Malignant lymphoma, large cell, immunoblastic",
                PermissibleValue(text="Malignant lymphoma, large cell, immunoblastic") )
        setattr(cls, "Mucinous tumor, NOS, of low malignant potential",
                PermissibleValue(text="Mucinous tumor, NOS, of low malignant potential") )
        setattr(cls, "Burkitt tumor",
                PermissibleValue(text="Burkitt tumor") )
        setattr(cls, "Dedifferentiated liposarcoma",
                PermissibleValue(text="Dedifferentiated liposarcoma",
                                 description="Dedifferentiated Liposarcoma") )
        setattr(cls, "Infiltrating duct and lobular carcinoma in situ",
                PermissibleValue(text="Infiltrating duct and lobular carcinoma in situ") )
        setattr(cls, "Ossifying fibromyxoid tumor, malignant",
                PermissibleValue(text="Ossifying fibromyxoid tumor, malignant") )
        setattr(cls, "Esophageal glandular dysplasia (intraepithelial neoplasia), high grade",
                PermissibleValue(text="Esophageal glandular dysplasia (intraepithelial neoplasia), high grade") )
        setattr(cls, "Flat adenoma",
                PermissibleValue(text="Flat adenoma") )
        setattr(cls, "Splenic lymphoma with villous lymphocytes",
                PermissibleValue(text="Splenic lymphoma with villous lymphocytes") )
        setattr(cls, "Mixed invasive mucinous and non-mucinous adenocarcinoma",
                PermissibleValue(text="Mixed invasive mucinous and non-mucinous adenocarcinoma") )
        setattr(cls, "Renomedullary interstitial cell tumor",
                PermissibleValue(text="Renomedullary interstitial cell tumor") )
        setattr(cls, "Malignant lymphoma, mixed cell type, diffuse",
                PermissibleValue(text="Malignant lymphoma, mixed cell type, diffuse") )
        setattr(cls, "Anaplastic large B-cell lymphoma",
                PermissibleValue(text="Anaplastic large B-cell lymphoma") )
        setattr(cls, "Chromophobe cell renal carcinoma",
                PermissibleValue(text="Chromophobe cell renal carcinoma") )
        setattr(cls, "Multiple neurofibromatosis",
                PermissibleValue(text="Multiple neurofibromatosis") )
        setattr(cls, "Epithelioid mesothelioma, benign",
                PermissibleValue(text="Epithelioid mesothelioma, benign") )
        setattr(cls, "Aleukemic lymphatic leukemia",
                PermissibleValue(text="Aleukemic lymphatic leukemia") )
        setattr(cls, "Adenocarcinoma of anal ducts",
                PermissibleValue(text="Adenocarcinoma of anal ducts") )
        setattr(cls, "Enteropathy type intestinal T-cell lymphoma",
                PermissibleValue(text="Enteropathy type intestinal T-cell lymphoma") )
        setattr(cls, "Retinoblastoma, differentiated",
                PermissibleValue(text="Retinoblastoma, differentiated") )
        setattr(cls, "Squamous cell carcinoma, adenoid",
                PermissibleValue(text="Squamous cell carcinoma, adenoid") )
        setattr(cls, "Cystic mesothelioma, NOS",
                PermissibleValue(text="Cystic mesothelioma, NOS") )
        setattr(cls, "Fascial fibroma",
                PermissibleValue(text="Fascial fibroma") )
        setattr(cls, "Perifollicular fibroma",
                PermissibleValue(text="Perifollicular fibroma") )
        setattr(cls, "Kaposiform hemangioendothelioma",
                PermissibleValue(text="Kaposiform hemangioendothelioma") )
        setattr(cls, "Basophil carcinoma",
                PermissibleValue(text="Basophil carcinoma") )
        setattr(cls, "Malignant lymphoma, non-Hodgkin, NOS",
                PermissibleValue(text="Malignant lymphoma, non-Hodgkin, NOS") )
        setattr(cls, "Pancreatobiliary-type carcinoma",
                PermissibleValue(text="Pancreatobiliary-type carcinoma") )
        setattr(cls, "Pheochromocytoma, NOS",
                PermissibleValue(text="Pheochromocytoma, NOS") )
        setattr(cls, "Epithelioma adenoides cysticum",
                PermissibleValue(text="Epithelioma adenoides cysticum") )
        setattr(cls, "Somatostatin cell tumor, NOS",
                PermissibleValue(text="Somatostatin cell tumor, NOS") )
        setattr(cls, "Plexiform fibromyxoma",
                PermissibleValue(text="Plexiform fibromyxoma") )
        setattr(cls, "Hepatocellular carcinoma, fibrolamellar",
                PermissibleValue(text="Hepatocellular carcinoma, fibrolamellar") )
        setattr(cls, "Atypical teratoid/rhabdoid tumor",
                PermissibleValue(text="Atypical teratoid/rhabdoid tumor") )
        setattr(cls, "Serrated adenoma",
                PermissibleValue(text="Serrated adenoma") )
        setattr(cls, "Germ cell tumor, nonseminomatous",
                PermissibleValue(text="Germ cell tumor, nonseminomatous") )
        setattr(cls, "Immunoglobulin deposition disease",
                PermissibleValue(text="Immunoglobulin deposition disease") )
        setattr(cls, "Malignant teratoma, undifferentiated",
                PermissibleValue(text="Malignant teratoma, undifferentiated") )
        setattr(cls, "Oligodendroglioma, NOS",
                PermissibleValue(text="Oligodendroglioma, NOS") )
        setattr(cls, "Small cell osteosarcoma",
                PermissibleValue(text="Small cell osteosarcoma") )
        setattr(cls, "Cloacogenic carcinoma",
                PermissibleValue(text="Cloacogenic carcinoma") )
        setattr(cls, "Bronchio-alveolar carcinoma, mucinous",
                PermissibleValue(text="Bronchio-alveolar carcinoma, mucinous") )
        setattr(cls, "Precursor T-cell lymphoblastic lymphoma",
                PermissibleValue(text="Precursor T-cell lymphoblastic lymphoma") )
        setattr(cls, "Alpha heavy chain disease",
                PermissibleValue(text="Alpha heavy chain disease") )
        setattr(cls, "Squamous cell carcinoma, HPV-positive",
                PermissibleValue(text="Squamous cell carcinoma, HPV-positive") )
        setattr(cls, "FAB Ll",
                PermissibleValue(text="FAB Ll") )
        setattr(cls, "Pro-B ALL",
                PermissibleValue(text="Pro-B ALL") )
        setattr(cls, "Schneiderian carcinoma",
                PermissibleValue(text="Schneiderian carcinoma") )
        setattr(cls, "Peripheral T-cell lymphoma, large cell",
                PermissibleValue(text="Peripheral T-cell lymphoma, large cell") )
        setattr(cls, "Primary effusion lymphoma",
                PermissibleValue(text="Primary effusion lymphoma") )
        setattr(cls, "Lipid cell tumor of ovary",
                PermissibleValue(text="Lipid cell tumor of ovary") )
        setattr(cls, "Thymoma, lymphocyte-rich, NOS",
                PermissibleValue(text="Thymoma, lymphocyte-rich, NOS") )
        setattr(cls, "Olfactory neurocytoma",
                PermissibleValue(text="Olfactory neurocytoma") )
        setattr(cls, "Mucoepidermoid carcinoma",
                PermissibleValue(text="Mucoepidermoid carcinoma",
                                 description="Mucoepidermoid Carcinoma") )
        setattr(cls, "Malignant cystic nephroma",
                PermissibleValue(text="Malignant cystic nephroma") )
        setattr(cls, "Epithelial tumor, malignant",
                PermissibleValue(text="Epithelial tumor, malignant") )
        setattr(cls, "Medulloblastoma, NOS",
                PermissibleValue(text="Medulloblastoma, NOS") )
        setattr(cls, "Solid pseudopapillary carcinoma",
                PermissibleValue(text="Solid pseudopapillary carcinoma") )
        setattr(cls, "Cystic partially differentiated nephroblastoma",
                PermissibleValue(text="Cystic partially differentiated nephroblastoma") )
        setattr(cls, "Acute myeloid leukemia without prior myelodysplastic syndrome",
                PermissibleValue(text="Acute myeloid leukemia without prior myelodysplastic syndrome") )
        setattr(cls, "Mixed adenocarcinoma and squamous cell carcinoma",
                PermissibleValue(text="Mixed adenocarcinoma and squamous cell carcinoma") )
        setattr(cls, "Primary cutaneous CD30+ T-cell lymphoproliferative disorder",
                PermissibleValue(text="Primary cutaneous CD30+ T-cell lymphoproliferative disorder") )
        setattr(cls, "Epidermoid carcinoma, spindle cell",
                PermissibleValue(text="Epidermoid carcinoma, spindle cell") )
        setattr(cls, "Transitional papilloma, inverted, NOS",
                PermissibleValue(text="Transitional papilloma, inverted, NOS") )
        setattr(cls, "Papillary carcinoma in situ",
                PermissibleValue(text="Papillary carcinoma in situ") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma with t(12;21)(p13;q22); TEL-AML1 (ETV6-RUNX1)",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma with t(12;21)(p13;q22); TEL-AML1 (ETV6-RUNX1)") )
        setattr(cls, "Bronchiolo-alveolar carcinoma, Clara cell",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma, Clara cell") )
        setattr(cls, "Central neuroblastoma",
                PermissibleValue(text="Central neuroblastoma") )
        setattr(cls, "Odontogenic carcinosarcoma",
                PermissibleValue(text="Odontogenic carcinosarcoma") )
        setattr(cls, "Endometrioid adenofibroma, borderline malignancy",
                PermissibleValue(text="Endometrioid adenofibroma, borderline malignancy") )
        setattr(cls, "Meningeal melanocytoma",
                PermissibleValue(text="Meningeal melanocytoma") )
        setattr(cls, "Eosinophilic leukemia",
                PermissibleValue(text="Eosinophilic leukemia") )
        setattr(cls, "Medullary carcinoma with lymphoid stroma",
                PermissibleValue(text="Medullary carcinoma with lymphoid stroma") )
        setattr(cls, "Serous surface papillary carcinoma",
                PermissibleValue(text="Serous surface papillary carcinoma") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma with hyperdiploidy",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma with hyperdiploidy") )
        setattr(cls, "Thymoma, epithelial, NOS",
                PermissibleValue(text="Thymoma, epithelial, NOS") )
        setattr(cls, "Low-grade central osteosarcoma",
                PermissibleValue(text="Low-grade central osteosarcoma") )
        setattr(cls, "Neoplasm, malignant, uncertain whether primary or metastatic",
                PermissibleValue(text="Neoplasm, malignant, uncertain whether primary or metastatic") )
        setattr(cls, "Glioblastoma, IDH wildtype",
                PermissibleValue(text="Glioblastoma, IDH wildtype") )
        setattr(cls, "Myeloid sarcoma",
                PermissibleValue(text="Myeloid sarcoma") )
        setattr(cls, "Acute megakaryoblastic leukaemia",
                PermissibleValue(text="Acute megakaryoblastic leukaemia") )
        setattr(cls, "Cystic hypersecretory carcinoma",
                PermissibleValue(text="Cystic hypersecretory carcinoma") )
        setattr(cls, "Sclerosing hemangioma",
                PermissibleValue(text="Sclerosing hemangioma") )
        setattr(cls, "Chromaffin paraganglioma",
                PermissibleValue(text="Chromaffin paraganglioma") )
        setattr(cls, "Intratubular malignant germ cells",
                PermissibleValue(text="Intratubular malignant germ cells") )
        setattr(cls, "Acute myeloid leukemia, minimal differentiation",
                PermissibleValue(text="Acute myeloid leukemia, minimal differentiation") )
        setattr(cls, "Plasmacytic lymphoma",
                PermissibleValue(text="Plasmacytic lymphoma") )
        setattr(cls, "Clear cell adenocarcinofibroma",
                PermissibleValue(text="Clear cell adenocarcinofibroma") )
        setattr(cls, "Prolymphocytic leukemia, NOS",
                PermissibleValue(text="Prolymphocytic leukemia, NOS") )
        setattr(cls, "Post transplant lymphoproliferative disorder, NOS",
                PermissibleValue(text="Post transplant lymphoproliferative disorder, NOS") )
        setattr(cls, "Carcinoma with chondroid differentiation",
                PermissibleValue(text="Carcinoma with chondroid differentiation") )
        setattr(cls, "Odontogenic tumor, benign",
                PermissibleValue(text="Odontogenic tumor, benign") )
        setattr(cls, "Invasive fibroma",
                PermissibleValue(text="Invasive fibroma") )
        setattr(cls, "Argentaffinoma, NOS",
                PermissibleValue(text="Argentaffinoma, NOS") )
        setattr(cls, "Bronchiolar adenocarcinoma",
                PermissibleValue(text="Bronchiolar adenocarcinoma") )
        setattr(cls, "Langerhans cell granulomatosis, unifocal",
                PermissibleValue(text="Langerhans cell granulomatosis, unifocal") )
        setattr(cls, "Granulocytic leukemia, NOS",
                PermissibleValue(text="Granulocytic leukemia, NOS") )
        setattr(cls, "Refractory anemia with ring sideroblasts associated with marked thrombocytosis",
                PermissibleValue(text="Refractory anemia with ring sideroblasts associated with marked thrombocytosis") )
        setattr(cls, "Subependymal astrocytoma, NOS",
                PermissibleValue(text="Subependymal astrocytoma, NOS") )
        setattr(cls, "Medulloepithelioma, benign",
                PermissibleValue(text="Medulloepithelioma, benign") )
        setattr(cls, "Serous tumor, NOS, of low malignant potential",
                PermissibleValue(text="Serous tumor, NOS, of low malignant potential") )
        setattr(cls, "Endolymphatic stromal myosis",
                PermissibleValue(text="Endolymphatic stromal myosis") )
        setattr(cls, "Papillary serous cystadenoma, NOS",
                PermissibleValue(text="Papillary serous cystadenoma, NOS") )
        setattr(cls, "Medulloblastoma, SHH-activated and TP53-mutant",
                PermissibleValue(text="Medulloblastoma, SHH-activated and TP53-mutant") )
        setattr(cls, "Adenocarcinoma with cartilaginous metaplasia",
                PermissibleValue(text="Adenocarcinoma with cartilaginous metaplasia") )
        setattr(cls, "Refractory neutropenia",
                PermissibleValue(text="Refractory neutropenia") )
        setattr(cls, "Undifferentiated epithelioid sarcoma",
                PermissibleValue(text="Undifferentiated epithelioid sarcoma") )
        setattr(cls, "Acute erythremia",
                PermissibleValue(text="Acute erythremia") )
        setattr(cls, "Basal cell carcinoma, micronodular",
                PermissibleValue(text="Basal cell carcinoma, micronodular") )
        setattr(cls, "Water-clear cell adenoma",
                PermissibleValue(text="Water-clear cell adenoma") )
        setattr(cls, "Pericanalicular fibroadenoma",
                PermissibleValue(text="Pericanalicular fibroadenoma") )
        setattr(cls, "Malignant myoepithelioma",
                PermissibleValue(text="Malignant myoepithelioma") )
        setattr(cls, "Adenocarcinoma in polypoid adenoma",
                PermissibleValue(text="Adenocarcinoma in polypoid adenoma") )
        setattr(cls, "Tumor cells, malignant",
                PermissibleValue(text="Tumor cells, malignant") )
        setattr(cls, "Linitis plastica",
                PermissibleValue(text="Linitis plastica") )
        setattr(cls, "Ductal carcinoma in situ, solid type",
                PermissibleValue(text="Ductal carcinoma in situ, solid type") )
        setattr(cls, "PNET, NOS",
                PermissibleValue(text="PNET, NOS") )
        setattr(cls, "Anaplastic large cell lymphoma, CD30+",
                PermissibleValue(text="Anaplastic large cell lymphoma, CD30+") )
        setattr(cls, "Myloproliferative neoplasm, unclassifiable",
                PermissibleValue(text="Myloproliferative neoplasm, unclassifiable") )
        setattr(cls, "Polymorphic reticulosis",
                PermissibleValue(text="Polymorphic reticulosis") )
        setattr(cls, "Venous hemangioma",
                PermissibleValue(text="Venous hemangioma") )
        setattr(cls, "Adrenal cortical tumor, benign",
                PermissibleValue(text="Adrenal cortical tumor, benign") )
        setattr(cls, "Acinic cell adenoma",
                PermissibleValue(text="Acinic cell adenoma") )
        setattr(cls, "Hemangioendothelioma, malignant",
                PermissibleValue(text="Hemangioendothelioma, malignant") )
        setattr(cls, "Water-clear cell adenocarcinoma",
                PermissibleValue(text="Water-clear cell adenocarcinoma") )
        setattr(cls, "Tubulocystic renal cell carcinoma",
                PermissibleValue(text="Tubulocystic renal cell carcinoma",
                                 description="Tubulocystic Renal Cell Carcinoma") )
        setattr(cls, "Extracutaneous mastocytoma",
                PermissibleValue(text="Extracutaneous mastocytoma") )
        setattr(cls, "Digital papillary adenocarcinoma",
                PermissibleValue(text="Digital papillary adenocarcinoma") )
        setattr(cls, "Hyalinizing trabecular adenoma",
                PermissibleValue(text="Hyalinizing trabecular adenoma") )
        setattr(cls, "Ductal carcinoma in situ, cribriform type",
                PermissibleValue(text="Ductal carcinoma in situ, cribriform type") )
        setattr(cls, "Giant cell tumor of tendon sheath, malignant",
                PermissibleValue(text="Giant cell tumor of tendon sheath, malignant") )
        setattr(cls, "Chondrosarcoma, NOS",
                PermissibleValue(text="Chondrosarcoma, NOS") )
        setattr(cls, "Stromal tumor, NOS",
                PermissibleValue(text="Stromal tumor, NOS") )
        setattr(cls, "Plasmacytoma, extramedullary",
                PermissibleValue(text="Plasmacytoma, extramedullary") )
        setattr(cls, "Cystadenoma, NOS",
                PermissibleValue(text="Cystadenoma, NOS") )
        setattr(cls, "Diffuse astrocytoma, IDH-mutant",
                PermissibleValue(text="Diffuse astrocytoma, IDH-mutant") )
        setattr(cls, "Pleomorphic leiomyoma",
                PermissibleValue(text="Pleomorphic leiomyoma") )
        setattr(cls, "Serous carcinoma, NOS",
                PermissibleValue(text="Serous carcinoma, NOS") )
        setattr(cls, "Vulvar intraepithelial neoplasia, grade III",
                PermissibleValue(text="Vulvar intraepithelial neoplasia, grade III") )
        setattr(cls, "Diffuse cutaneous mastocytosis",
                PermissibleValue(text="Diffuse cutaneous mastocytosis") )
        setattr(cls, "Bronchiolar carcinoma",
                PermissibleValue(text="Bronchiolar carcinoma") )
        setattr(cls, "Embryonal sarcoma",
                PermissibleValue(text="Embryonal sarcoma") )
        setattr(cls, "Intracystic papillary neoplasm with high grade intraepithelial neoplasia",
                PermissibleValue(text="Intracystic papillary neoplasm with high grade intraepithelial neoplasia") )
        setattr(cls, "Extra-adrenal paraganglioma, NOS",
                PermissibleValue(text="Extra-adrenal paraganglioma, NOS") )
        setattr(cls, "Clear cell cystadenofibroma of borderline malignancy",
                PermissibleValue(text="Clear cell cystadenofibroma of borderline malignancy") )
        setattr(cls, "Enteroglucagonoma, malignant",
                PermissibleValue(text="Enteroglucagonoma, malignant") )
        setattr(cls, "Skin appendage carcinoma",
                PermissibleValue(text="Skin appendage carcinoma") )
        setattr(cls, "Endometrial stromal nodule",
                PermissibleValue(text="Endometrial stromal nodule") )
        setattr(cls, "Peripheral T-cell lymphoma, pleomorphic medium and large cell",
                PermissibleValue(text="Peripheral T-cell lymphoma, pleomorphic medium and large cell") )
        setattr(cls, "Tubular adenocarcinoma",
                PermissibleValue(text="Tubular adenocarcinoma") )
        setattr(cls, "Pilocytic astrocytoma",
                PermissibleValue(text="Pilocytic astrocytoma") )
        setattr(cls, "Myeloproliferative neoplasm, NOS",
                PermissibleValue(text="Myeloproliferative neoplasm, NOS") )
        setattr(cls, "Malignant lymphoma, lymphocytic, poorly differentiated, nodular",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, poorly differentiated, nodular") )
        setattr(cls, "Giant fibroadenoma",
                PermissibleValue(text="Giant fibroadenoma") )
        setattr(cls, "Fetal adenoma",
                PermissibleValue(text="Fetal adenoma") )
        setattr(cls, "Hydatid mole",
                PermissibleValue(text="Hydatid mole") )
        setattr(cls, "Mesoblastic nephroma",
                PermissibleValue(text="Mesoblastic nephroma") )
        setattr(cls, "Periosteal chondrosarcoma",
                PermissibleValue(text="Periosteal chondrosarcoma") )
        setattr(cls, "Mixed germ cell sex cord-stromal tumor, unclassified",
                PermissibleValue(text="Mixed germ cell sex cord-stromal tumor, unclassified") )
        setattr(cls, "Angioblastic meningioma",
                PermissibleValue(text="Angioblastic meningioma") )
        setattr(cls, "MPNST, NOS",
                PermissibleValue(text="MPNST, NOS") )
        setattr(cls, "Paraganglioma, malignant",
                PermissibleValue(text="Paraganglioma, malignant") )
        setattr(cls, "Epithelioid hemangioendothelioma, malignant",
                PermissibleValue(text="Epithelioid hemangioendothelioma, malignant") )
        setattr(cls, "Seminoma, NOS",
                PermissibleValue(text="Seminoma, NOS") )
        setattr(cls, "Microcystic adnexal carcinoma",
                PermissibleValue(text="Microcystic adnexal carcinoma") )
        setattr(cls, "Composite carcinoid",
                PermissibleValue(text="Composite carcinoid") )
        setattr(cls, "Teratoblastoma, malignant",
                PermissibleValue(text="Teratoblastoma, malignant") )
        setattr(cls, "Pleomorphic liposarcoma",
                PermissibleValue(text="Pleomorphic liposarcoma") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma, NOS",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma, NOS") )
        setattr(cls, "Mantle zone lymphoma",
                PermissibleValue(text="Mantle zone lymphoma") )
        setattr(cls, "Infiltrating duct mixed with other types of carcinoma",
                PermissibleValue(text="Infiltrating duct mixed with other types of carcinoma") )
        setattr(cls, "Clear cell chondrosarcoma",
                PermissibleValue(text="Clear cell chondrosarcoma") )
        setattr(cls, "Ewing sarcoma",
                PermissibleValue(text="Ewing sarcoma") )
        setattr(cls, "Micropapillary adenocarcinoma",
                PermissibleValue(text="Micropapillary adenocarcinoma") )
        setattr(cls, "G cell tumor, malignant",
                PermissibleValue(text="G cell tumor, malignant") )
        setattr(cls, "Bile duct cystadenocarcinoma",
                PermissibleValue(text="Bile duct cystadenocarcinoma") )
        setattr(cls, "Glioblastoma, IDH-mutant",
                PermissibleValue(text="Glioblastoma, IDH-mutant") )
        setattr(cls, "Acute myeloid leukemia, inv(16)(p13;q22)",
                PermissibleValue(text="Acute myeloid leukemia, inv(16)(p13;q22)") )
        setattr(cls, "Scirrhous adenocarcinoma",
                PermissibleValue(text="Scirrhous adenocarcinoma") )
        setattr(cls, "Secretory carcinoma of breast",
                PermissibleValue(text="Secretory carcinoma of breast") )
        setattr(cls, "Acute monocytic leukemia",
                PermissibleValue(text="Acute monocytic leukemia") )
        setattr(cls, "Myeloid leukemia, NOS",
                PermissibleValue(text="Myeloid leukemia, NOS") )
        setattr(cls, "Precancerous melanosis, NOS",
                PermissibleValue(text="Precancerous melanosis, NOS") )
        setattr(cls, "Subcutaneous panniculitis-like T-cell lymphoma",
                PermissibleValue(text="Subcutaneous panniculitis-like T-cell lymphoma") )
        setattr(cls, "Theca cell tumor",
                PermissibleValue(text="Theca cell tumor") )
        setattr(cls, "Involuting nevus",
                PermissibleValue(text="Involuting nevus") )
        setattr(cls, "Solid papillary carcinoma in situ",
                PermissibleValue(text="Solid papillary carcinoma in situ") )
        setattr(cls, "Mucin-producing adenocarcinoma",
                PermissibleValue(text="Mucin-producing adenocarcinoma") )
        setattr(cls, "Follicular adenoma",
                PermissibleValue(text="Follicular adenoma") )
        setattr(cls, "Acute myelogenous leukemia",
                PermissibleValue(text="Acute myelogenous leukemia") )
        setattr(cls, "Idiopathic hemorrhagic thrombocythaemia",
                PermissibleValue(text="Idiopathic hemorrhagic thrombocythaemia") )
        setattr(cls, "Anal intraepithelial neoplasia, low grade",
                PermissibleValue(text="Anal intraepithelial neoplasia, low grade") )
        setattr(cls, "Acute myeloid leukemia, M6 type",
                PermissibleValue(text="Acute myeloid leukemia, M6 type") )
        setattr(cls, "Localized fibrous tumor",
                PermissibleValue(text="Localized fibrous tumor") )
        setattr(cls, "Kupffer cell sarcoma",
                PermissibleValue(text="Kupffer cell sarcoma") )
        setattr(cls, "Macrofollicular adenoma",
                PermissibleValue(text="Macrofollicular adenoma") )
        setattr(cls, "Malignant melanoma in giant pigmented nevus",
                PermissibleValue(text="Malignant melanoma in giant pigmented nevus") )
        setattr(cls, "Chromophobe adenocarcinoma",
                PermissibleValue(text="Chromophobe adenocarcinoma") )
        setattr(cls, "Mucinous cystic tumor with low grade dysplasia",
                PermissibleValue(text="Mucinous cystic tumor with low grade dysplasia") )
        setattr(cls, "Hodgkin lymphoma, nodular sclerosis, grade 2",
                PermissibleValue(text="Hodgkin lymphoma, nodular sclerosis, grade 2") )
        setattr(cls, "Endometrioid cystadenofibroma, NOS",
                PermissibleValue(text="Endometrioid cystadenofibroma, NOS") )
        setattr(cls, "Inflammatory myofibroblastic tumor",
                PermissibleValue(text="Inflammatory myofibroblastic tumor",
                                 description="Inflammatory Myofibroblastic Tumor") )
        setattr(cls, "Ectopic hamartomatous thymoma",
                PermissibleValue(text="Ectopic hamartomatous thymoma") )
        setattr(cls, "Invasive mucinous adenocarcinoma",
                PermissibleValue(text="Invasive mucinous adenocarcinoma") )
        setattr(cls, "Invasive micropapillary carcinoma",
                PermissibleValue(text="Invasive micropapillary carcinoma") )
        setattr(cls, "Medulloblastoma, group 4",
                PermissibleValue(text="Medulloblastoma, group 4") )
        setattr(cls, "Acinar cell carcinoma",
                PermissibleValue(text="Acinar cell carcinoma",
                                 description="Acinar Cell Carcinoma") )
        setattr(cls, "Anaplastic oligodendroglioma, IDH-mutant and 1p/19q-codeleted",
                PermissibleValue(text="Anaplastic oligodendroglioma, IDH-mutant and 1p/19q-codeleted") )
        setattr(cls, "Luteoma, NOS",
                PermissibleValue(text="Luteoma, NOS") )
        setattr(cls, "Adenocarcinoma with neuroendocrine differentiation",
                PermissibleValue(text="Adenocarcinoma with neuroendocrine differentiation") )
        setattr(cls, "Precursor B-cell lymphoblastic lymphoma",
                PermissibleValue(text="Precursor B-cell lymphoblastic lymphoma") )
        setattr(cls, "Langerhans cell histiocytosis, unifocal",
                PermissibleValue(text="Langerhans cell histiocytosis, unifocal") )
        setattr(cls, "MPNST with glandular differentiation",
                PermissibleValue(text="MPNST with glandular differentiation") )
        setattr(cls, "Renal medullary carcinoma",
                PermissibleValue(text="Renal medullary carcinoma",
                                 description="Kidney Medullary Carcinoma") )
        setattr(cls, "Round cell carcinoma",
                PermissibleValue(text="Round cell carcinoma") )
        setattr(cls, "Fibroepithelial basal cell carcinoma, Pinkus type",
                PermissibleValue(text="Fibroepithelial basal cell carcinoma, Pinkus type") )
        setattr(cls, "Granular cell myoblastoma, NOS",
                PermissibleValue(text="Granular cell myoblastoma, NOS") )
        setattr(cls, "Hygroma, NOS",
                PermissibleValue(text="Hygroma, NOS") )
        setattr(cls, "Gelatinous carcinoma",
                PermissibleValue(text="Gelatinous carcinoma") )
        setattr(cls, "Adenocarcinoma, endocervical type",
                PermissibleValue(text="Adenocarcinoma, endocervical type") )
        setattr(cls, "Cortical T ALL",
                PermissibleValue(text="Cortical T ALL") )
        setattr(cls, "Neuroma, NOS",
                PermissibleValue(text="Neuroma, NOS") )
        setattr(cls, "Sertoli-Leydig cell tumor, retiform, with heterologous elements",
                PermissibleValue(text="Sertoli-Leydig cell tumor, retiform, with heterologous elements") )
        setattr(cls, "Multifocal superficial basal cell carcinoma",
                PermissibleValue(text="Multifocal superficial basal cell carcinoma") )
        setattr(cls, "Glomus tumor, malignant",
                PermissibleValue(text="Glomus tumor, malignant") )
        setattr(cls, "Terminal duct adenocarcinoma",
                PermissibleValue(text="Terminal duct adenocarcinoma") )
        setattr(cls, "Urothelial papilloma, NOS",
                PermissibleValue(text="Urothelial papilloma, NOS") )
        setattr(cls, "Peripheral primitive neuroectodermal tumor, NOS",
                PermissibleValue(text="Peripheral primitive neuroectodermal tumor, NOS") )
        setattr(cls, "Squamous cell carcinoma, microinvasive",
                PermissibleValue(text="Squamous cell carcinoma, microinvasive") )
        setattr(cls, "Systemic EBV positive T-cell lymphoproliferative disease of childhood",
                PermissibleValue(text="Systemic EBV positive T-cell lymphoproliferative disease of childhood") )
        setattr(cls, "Pancreatic endocrine tumor, malignant",
                PermissibleValue(text="Pancreatic endocrine tumor, malignant") )
        setattr(cls, "Endocrine adenomatosis",
                PermissibleValue(text="Endocrine adenomatosis") )
        setattr(cls, "Blue nevus, NOS",
                PermissibleValue(text="Blue nevus, NOS") )
        setattr(cls, "Bellini duct carcinoma",
                PermissibleValue(text="Bellini duct carcinoma") )
        setattr(cls, "Carcinosarcoma, NOS",
                PermissibleValue(text="Carcinosarcoma, NOS") )
        setattr(cls, "Malignant lymphoma, small cleaved cell, NOS",
                PermissibleValue(text="Malignant lymphoma, small cleaved cell, NOS") )
        setattr(cls, "Sweat gland adenocarcinoma",
                PermissibleValue(text="Sweat gland adenocarcinoma") )
        setattr(cls, "Plasma cell tumor",
                PermissibleValue(text="Plasma cell tumor") )
        setattr(cls, "Follicular carcinoma, minimally invasive",
                PermissibleValue(text="Follicular carcinoma, minimally invasive") )
        setattr(cls, "Islet cell carcinoma",
                PermissibleValue(text="Islet cell carcinoma") )
        setattr(cls, "Chronic myeloproliferative disease, NOS",
                PermissibleValue(text="Chronic myeloproliferative disease, NOS") )
        setattr(cls, "Refractory anemia with sideroblasts",
                PermissibleValue(text="Refractory anemia with sideroblasts") )
        setattr(cls, "Intraductal papillary neoplasm with high grade dysplasia",
                PermissibleValue(text="Intraductal papillary neoplasm with high grade dysplasia") )
        setattr(cls, "Aortic body tumor",
                PermissibleValue(text="Aortic body tumor") )
        setattr(cls, "Sertoli-Leydig cell tumor, retiform",
                PermissibleValue(text="Sertoli-Leydig cell tumor, retiform") )
        setattr(cls, "Gastrin cell tumor",
                PermissibleValue(text="Gastrin cell tumor") )
        setattr(cls, "Eccrine spiradenoma",
                PermissibleValue(text="Eccrine spiradenoma") )
        setattr(cls, "Meningiomatosis, NOS",
                PermissibleValue(text="Meningiomatosis, NOS") )
        setattr(cls, "Thymoma, predominantly cortical, malignant",
                PermissibleValue(text="Thymoma, predominantly cortical, malignant") )
        setattr(cls, "Epithelioid mesothelioma, NOS",
                PermissibleValue(text="Epithelioid mesothelioma, NOS") )
        setattr(cls, "Fibroadenoma, NOS",
                PermissibleValue(text="Fibroadenoma, NOS") )
        setattr(cls, "Endometrioid adenofibroma, NOS",
                PermissibleValue(text="Endometrioid adenofibroma, NOS") )
        setattr(cls, "Periapical cemento-osseous dysplasia",
                PermissibleValue(text="Periapical cemento-osseous dysplasia") )
        setattr(cls, "Nevus, NOS",
                PermissibleValue(text="Nevus, NOS") )
        setattr(cls, "Chronic granulocytic leukemia, NOS",
                PermissibleValue(text="Chronic granulocytic leukemia, NOS") )
        setattr(cls, "Serous endometrial intraepithelial carcinoma",
                PermissibleValue(text="Serous endometrial intraepithelial carcinoma",
                                 description="Serous Endometrial Intraepithelial Carcinoma") )
        setattr(cls, "Malignant lymphoma, lymphocytic, NOS",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, NOS") )
        setattr(cls, "Cemento-ossifying fibroma",
                PermissibleValue(text="Cemento-ossifying fibroma") )
        setattr(cls, "Schmincke tumor",
                PermissibleValue(text="Schmincke tumor") )
        setattr(cls, "Hodgkin sarcoma",
                PermissibleValue(text="Hodgkin sarcoma") )
        setattr(cls, "Perivascular epithelioid cell tumor, malignant",
                PermissibleValue(text="Perivascular epithelioid cell tumor, malignant") )
        setattr(cls, "Classical Hodgkin lymphoma, mixed cellularity, NOS",
                PermissibleValue(text="Classical Hodgkin lymphoma, mixed cellularity, NOS") )
        setattr(cls, "Squamous cell carcinoma, pseudoglandular",
                PermissibleValue(text="Squamous cell carcinoma, pseudoglandular") )
        setattr(cls, "Hodgkin disease, nodular sclerosis, lymphocyte depletion",
                PermissibleValue(text="Hodgkin disease, nodular sclerosis, lymphocyte depletion") )
        setattr(cls, "Adenocarcinoma with spindle cell metaplasia",
                PermissibleValue(text="Adenocarcinoma with spindle cell metaplasia") )
        setattr(cls, "Metastasizing leiomyoma",
                PermissibleValue(text="Metastasizing leiomyoma") )
        setattr(cls, "Ossifying renal tumor",
                PermissibleValue(text="Ossifying renal tumor") )
        setattr(cls, "Infiltrating duct adenocarcinoma",
                PermissibleValue(text="Infiltrating duct adenocarcinoma") )
        setattr(cls, "Papillary adenofibroma",
                PermissibleValue(text="Papillary adenofibroma") )
        setattr(cls, "Bronchial adenoma, carcinoid",
                PermissibleValue(text="Bronchial adenoma, carcinoid") )
        setattr(cls, "Mixed embryonal carcinoma and teratoma",
                PermissibleValue(text="Mixed embryonal carcinoma and teratoma") )
        setattr(cls, "Chondroblastoma, malignant",
                PermissibleValue(text="Chondroblastoma, malignant") )
        setattr(cls, "Melanotic medulloblastoma",
                PermissibleValue(text="Melanotic medulloblastoma") )
        setattr(cls, "Mediastinal (thymic) large B-cell lymphoma",
                PermissibleValue(text="Mediastinal (thymic) large B-cell lymphoma") )
        setattr(cls, "Mucinous carcinoma, gastric type",
                PermissibleValue(text="Mucinous carcinoma, gastric type") )
        setattr(cls, "Fibrous mesothelioma, malignant",
                PermissibleValue(text="Fibrous mesothelioma, malignant") )
        setattr(cls, "Bronchiolo-alveolar carcinoma, goblet cell type",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma, goblet cell type") )
        setattr(cls, "Mucinous cystadenocarcinofibroma",
                PermissibleValue(text="Mucinous cystadenocarcinofibroma") )
        setattr(cls, "Synovial sarcoma, NOS",
                PermissibleValue(text="Synovial sarcoma, NOS") )
        setattr(cls, "Hepatoblastoma, mixed epithelial-mesenchymal",
                PermissibleValue(text="Hepatoblastoma, mixed epithelial-mesenchymal") )
        setattr(cls, "Aggressive fibromatosis",
                PermissibleValue(text="Aggressive fibromatosis") )
        setattr(cls, "Glandular intraepithelial neoplasia, low grade",
                PermissibleValue(text="Glandular intraepithelial neoplasia, low grade") )
        setattr(cls, "MALT lymphoma",
                PermissibleValue(text="MALT lymphoma") )
        setattr(cls, "Intraductal papilloma with ductal carcinoma in situ",
                PermissibleValue(text="Intraductal papilloma with ductal carcinoma in situ") )
        setattr(cls, "Myxoid leiomyosarcoma",
                PermissibleValue(text="Myxoid leiomyosarcoma") )
        setattr(cls, "Subareolar duct papillomatosis",
                PermissibleValue(text="Subareolar duct papillomatosis") )
        setattr(cls, "Liver cell carcinoma",
                PermissibleValue(text="Liver cell carcinoma") )
        setattr(cls, "Piloid astrocytoma",
                PermissibleValue(text="Piloid astrocytoma") )
        setattr(cls, "Chondroid lipoma",
                PermissibleValue(text="Chondroid lipoma") )
        setattr(cls, "Atypical hyperplasia/Endometrioid intraepithelial neoplasm",
                PermissibleValue(text="Atypical hyperplasia/Endometrioid intraepithelial neoplasm") )
        setattr(cls, "Mantle cell lymphoma (Includes all variants blastic, pleomorphic, small cell)",
                PermissibleValue(text="Mantle cell lymphoma (Includes all variants blastic, pleomorphic, small cell)") )
        setattr(cls, "Thymoma, medullary, malignant",
                PermissibleValue(text="Thymoma, medullary, malignant") )
        setattr(cls, "T-cell large granular lymphocytosis",
                PermissibleValue(text="T-cell large granular lymphocytosis") )
        setattr(cls, "Follicular carcinoma, trabecular",
                PermissibleValue(text="Follicular carcinoma, trabecular") )
        setattr(cls, "Melanotic schwannoma",
                PermissibleValue(text="Melanotic schwannoma") )
        setattr(cls, "Pilar tumor",
                PermissibleValue(text="Pilar tumor") )
        setattr(cls, "Cylindrical cell carcinoma",
                PermissibleValue(text="Cylindrical cell carcinoma") )
        setattr(cls, "Craniopharyngioma, adamantinomatous",
                PermissibleValue(text="Craniopharyngioma, adamantinomatous") )
        setattr(cls, "Dermatofibroma, NOS",
                PermissibleValue(text="Dermatofibroma, NOS") )
        setattr(cls, "Chief cell adenoma",
                PermissibleValue(text="Chief cell adenoma") )
        setattr(cls, "Microcystic adenoma",
                PermissibleValue(text="Microcystic adenoma") )
        setattr(cls, "Granular cell carcinoma",
                PermissibleValue(text="Granular cell carcinoma") )
        setattr(cls, "Chronic myelomonocytic leukemia in transformation",
                PermissibleValue(text="Chronic myelomonocytic leukemia in transformation") )
        setattr(cls, "Carcinoid tumor, argentaffin, malignant",
                PermissibleValue(text="Carcinoid tumor, argentaffin, malignant") )
        setattr(cls, "Intraductal papilloma with lobular carcinoma in situ",
                PermissibleValue(text="Intraductal papilloma with lobular carcinoma in situ") )
        setattr(cls, "Jugular paraganglioma",
                PermissibleValue(text="Jugular paraganglioma") )
        setattr(cls, "Multiple hemorrhagic sarcoma",
                PermissibleValue(text="Multiple hemorrhagic sarcoma") )
        setattr(cls, "Papillary transitional cell carcinoma",
                PermissibleValue(text="Papillary transitional cell carcinoma") )
        setattr(cls, "Pigmented schwannoma",
                PermissibleValue(text="Pigmented schwannoma") )
        setattr(cls, "Mucin-producing carcinoma",
                PermissibleValue(text="Mucin-producing carcinoma") )
        setattr(cls, "Epidermoid carcinoma in situ with questionable stromal invasion",
                PermissibleValue(text="Epidermoid carcinoma in situ with questionable stromal invasion") )
        setattr(cls, "Tumor, benign",
                PermissibleValue(text="Tumor, benign") )
        setattr(cls, "Mixed germ cell tumor",
                PermissibleValue(text="Mixed germ cell tumor") )
        setattr(cls, "Acute myloid leukemia, 11q23 abnormalities",
                PermissibleValue(text="Acute myloid leukemia, 11q23 abnormalities") )
        setattr(cls, "Adult T-cell lymphoma",
                PermissibleValue(text="Adult T-cell lymphoma") )
        setattr(cls, "Myelodysplastic syndrome with 5q deletion (5q-) syndrome",
                PermissibleValue(text="Myelodysplastic syndrome with 5q deletion (5q-) syndrome") )
        setattr(cls, "Triton tumor, malignant",
                PermissibleValue(text="Triton tumor, malignant") )
        setattr(cls, "Papillary mucinous cystadenoma, borderline malignancy",
                PermissibleValue(text="Papillary mucinous cystadenoma, borderline malignancy") )
        setattr(cls, "Mixed glioma",
                PermissibleValue(text="Mixed glioma") )
        setattr(cls, "Epithelioid and spindle cell nevus",
                PermissibleValue(text="Epithelioid and spindle cell nevus") )
        setattr(cls, "Papillary transitional cell neoplasm of low malignant potential",
                PermissibleValue(text="Papillary transitional cell neoplasm of low malignant potential") )
        setattr(cls, "Epidermoid carcinoma, keratinizing",
                PermissibleValue(text="Epidermoid carcinoma, keratinizing") )
        setattr(cls, "Endocrine tumor, functioning, NOS",
                PermissibleValue(text="Endocrine tumor, functioning, NOS") )
        setattr(cls, "Atypical proliferative endometrioid tumor",
                PermissibleValue(text="Atypical proliferative endometrioid tumor") )
        setattr(cls, "Cystosarcoma phyllodes, NOS",
                PermissibleValue(text="Cystosarcoma phyllodes, NOS") )
        setattr(cls, "Colloid adenoma",
                PermissibleValue(text="Colloid adenoma") )
        setattr(cls, "Fibroblastic liposarcoma",
                PermissibleValue(text="Fibroblastic liposarcoma") )
        setattr(cls, "Cerebellar sarcoma, NOS",
                PermissibleValue(text="Cerebellar sarcoma, NOS") )
        setattr(cls, "Spindled mesothelioma",
                PermissibleValue(text="Spindled mesothelioma") )
        setattr(cls, "Melanocytic nevus",
                PermissibleValue(text="Melanocytic nevus") )
        setattr(cls, "Vipoma, malignant",
                PermissibleValue(text="Vipoma, malignant") )
        setattr(cls, "Adenofibroma, NOS",
                PermissibleValue(text="Adenofibroma, NOS") )
        setattr(cls, "Mucinous cystic neoplasm with high-grade intraepithelial neoplasia",
                PermissibleValue(text="Mucinous cystic neoplasm with high-grade intraepithelial neoplasia") )
        setattr(cls, "Angiocentric T-cell lymphoma",
                PermissibleValue(text="Angiocentric T-cell lymphoma") )
        setattr(cls, "Gamma heavy chain disease",
                PermissibleValue(text="Gamma heavy chain disease") )
        setattr(cls, "Gemistocytic astrocytoma",
                PermissibleValue(text="Gemistocytic astrocytoma") )
        setattr(cls, "Mesenchymoma, benign",
                PermissibleValue(text="Mesenchymoma, benign") )
        setattr(cls, "Plexiform schwannoma",
                PermissibleValue(text="Plexiform schwannoma") )
        setattr(cls, "Minimally invasive adenocarcinoma, mucinous",
                PermissibleValue(text="Minimally invasive adenocarcinoma, mucinous",
                                 description="Mucinous Bronchioloalveolar Carcinoma") )
        setattr(cls, "Bronchiolo-alveolar carcinoma, type II pneumocyte and goblet cell type",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma, type II pneumocyte and goblet cell type") )
        setattr(cls, "Papillary adenocarcinoma, NOS",
                PermissibleValue(text="Papillary adenocarcinoma, NOS") )
        setattr(cls, "Splenic diffuse red pulp small B-cell lymphoma",
                PermissibleValue(text="Splenic diffuse red pulp small B-cell lymphoma") )
        setattr(cls, "Acquired cystic disease-associated renal cell carcinoma (RCC)",
                PermissibleValue(text="Acquired cystic disease-associated renal cell carcinoma (RCC)") )
        setattr(cls, "Thymoma, type C",
                PermissibleValue(text="Thymoma, type C") )
        setattr(cls, "Anaplastic astrocytoma, IDH-mutant",
                PermissibleValue(text="Anaplastic astrocytoma, IDH-mutant") )
        setattr(cls, "Primary cutaneous anaplastic large cell lymphoma",
                PermissibleValue(text="Primary cutaneous anaplastic large cell lymphoma") )
        setattr(cls, "Non-small cell carcinoma",
                PermissibleValue(text="Non-small cell carcinoma") )
        setattr(cls, "Malignant histiocytosis",
                PermissibleValue(text="Malignant histiocytosis") )
        setattr(cls, "Neurotropic melanoma, malignant",
                PermissibleValue(text="Neurotropic melanoma, malignant") )
        setattr(cls, "Papillary carcinoma, oxyphilic cell",
                PermissibleValue(text="Papillary carcinoma, oxyphilic cell") )
        setattr(cls, "Epithelioid sarcoma",
                PermissibleValue(text="Epithelioid sarcoma") )
        setattr(cls, "Papillary serous adenocarcinoma",
                PermissibleValue(text="Papillary serous adenocarcinoma") )
        setattr(cls, "Superficial well differentiated liposarcoma",
                PermissibleValue(text="Superficial well differentiated liposarcoma") )
        setattr(cls, "Syringoma, NOS",
                PermissibleValue(text="Syringoma, NOS") )
        setattr(cls, "Thymoma, organoid, NOS",
                PermissibleValue(text="Thymoma, organoid, NOS") )
        setattr(cls, "Follicular adenocarcinoma, well differentiated",
                PermissibleValue(text="Follicular adenocarcinoma, well differentiated") )
        setattr(cls, "Neoplasm, benign",
                PermissibleValue(text="Neoplasm, benign") )
        setattr(cls, "Myofibroblastic sarcoma",
                PermissibleValue(text="Myofibroblastic sarcoma") )
        setattr(cls, "Squamous papilloma",
                PermissibleValue(text="Squamous papilloma") )
        setattr(cls, "Hodgkin lymphoma, lymphocyte-rich",
                PermissibleValue(text="Hodgkin lymphoma, lymphocyte-rich") )
        setattr(cls, "Epithelioid cell melanoma",
                PermissibleValue(text="Epithelioid cell melanoma") )
        setattr(cls, "Urothelial carcinoma with divergent differentiation",
                PermissibleValue(text="Urothelial carcinoma with divergent differentiation") )
        setattr(cls, "Chordoma, NOS",
                PermissibleValue(text="Chordoma, NOS") )
        setattr(cls, "Acute progressive histiocytosis X",
                PermissibleValue(text="Acute progressive histiocytosis X") )
        setattr(cls, "Follicular fibroma",
                PermissibleValue(text="Follicular fibroma") )
        setattr(cls, "Papillary cystadenoma, NOS",
                PermissibleValue(text="Papillary cystadenoma, NOS") )
        setattr(cls, "Papillary carcinoma, encapsulated",
                PermissibleValue(text="Papillary carcinoma, encapsulated") )
        setattr(cls, "Idiopathic thrombocythemia",
                PermissibleValue(text="Idiopathic thrombocythemia") )
        setattr(cls, "Transitional cell papilloma, inverted, benign",
                PermissibleValue(text="Transitional cell papilloma, inverted, benign") )
        setattr(cls, "Hodgkin lymphoma, mixed cellularity, NOS",
                PermissibleValue(text="Hodgkin lymphoma, mixed cellularity, NOS") )
        setattr(cls, "Congenital fibrosarcoma",
                PermissibleValue(text="Congenital fibrosarcoma") )
        setattr(cls, "Burkitt cell leukemia",
                PermissibleValue(text="Burkitt cell leukemia") )
        setattr(cls, "Sezary syndrome",
                PermissibleValue(text="Sezary syndrome") )
        setattr(cls, "Endometrioid cystadenofibroma, borderline malignancy",
                PermissibleValue(text="Endometrioid cystadenofibroma, borderline malignancy") )
        setattr(cls, "Primary cutaneous CD4-positive small/medium T-cell lymphoma",
                PermissibleValue(text="Primary cutaneous CD4-positive small/medium T-cell lymphoma") )
        setattr(cls, "Sinonasal papilloma, fungiform",
                PermissibleValue(text="Sinonasal papilloma, fungiform") )
        setattr(cls, "Epithelioma, NOS",
                PermissibleValue(text="Epithelioma, NOS") )
        setattr(cls, "Myoepithelial tumor",
                PermissibleValue(text="Myoepithelial tumor") )
        setattr(cls, "Intraosseous low grade osteosarcoma",
                PermissibleValue(text="Intraosseous low grade osteosarcoma") )
        setattr(cls, "Epithelial tumor, benign",
                PermissibleValue(text="Epithelial tumor, benign") )
        setattr(cls, "True histiocytic lymphoma",
                PermissibleValue(text="True histiocytic lymphoma") )
        setattr(cls, "Schwannoma, NOS",
                PermissibleValue(text="Schwannoma, NOS") )
        setattr(cls, "Intracanalicular fibroadenoma",
                PermissibleValue(text="Intracanalicular fibroadenoma") )
        setattr(cls, "Malignant tumor, spindle cell type",
                PermissibleValue(text="Malignant tumor, spindle cell type") )
        setattr(cls, "Solid papillary carcinoma with invasion",
                PermissibleValue(text="Solid papillary carcinoma with invasion") )
        setattr(cls, "Malignant lymphoma, follicle center, NOS",
                PermissibleValue(text="Malignant lymphoma, follicle center, NOS") )
        setattr(cls, "Interstitial cell tumor, benign",
                PermissibleValue(text="Interstitial cell tumor, benign") )
        setattr(cls, "Lymphangioma, NOS",
                PermissibleValue(text="Lymphangioma, NOS") )
        setattr(cls, "Epidermoid carcinoma in situ, NOS",
                PermissibleValue(text="Epidermoid carcinoma in situ, NOS") )
        setattr(cls, "Chondroid syringoma",
                PermissibleValue(text="Chondroid syringoma") )
        setattr(cls, "Solitary plasmacytoma",
                PermissibleValue(text="Solitary plasmacytoma") )
        setattr(cls, "Non-invasive EFVPTC",
                PermissibleValue(text="Non-invasive EFVPTC") )
        setattr(cls, "Enteropathy associated T-cell lymphoma",
                PermissibleValue(text="Enteropathy associated T-cell lymphoma") )
        setattr(cls, "Adenocarcinoma in situ in villous adenoma",
                PermissibleValue(text="Adenocarcinoma in situ in villous adenoma") )
        setattr(cls, "Histiocytoma, NOS",
                PermissibleValue(text="Histiocytoma, NOS") )
        setattr(cls, "Pancreatic endocrine tumor, nonfunctioning",
                PermissibleValue(text="Pancreatic endocrine tumor, nonfunctioning") )
        setattr(cls, "Lepidic predominant adenocarcinoma",
                PermissibleValue(text="Lepidic predominant adenocarcinoma",
                                 description="Lepidic Predominant Adenocarcinoma") )
        setattr(cls, "Choriocarcinoma, NOS",
                PermissibleValue(text="Choriocarcinoma, NOS") )
        setattr(cls, "Inflammatory adenocarcinoma",
                PermissibleValue(text="Inflammatory adenocarcinoma") )
        setattr(cls, "Hodgkin lymphoma, nodular sclerosis, cellular phase",
                PermissibleValue(text="Hodgkin lymphoma, nodular sclerosis, cellular phase") )
        setattr(cls, "Endometrial stromatosis",
                PermissibleValue(text="Endometrial stromatosis") )
        setattr(cls, "Synovial sarcoma, epithelioid cell",
                PermissibleValue(text="Synovial sarcoma, epithelioid cell") )
        setattr(cls, "Intraductal papillary mucinous neoplasm with an associated invasive carcinoma",
                PermissibleValue(text="Intraductal papillary mucinous neoplasm with an associated invasive carcinoma") )
        setattr(cls, "Aleukemic lymphocytic leukemia",
                PermissibleValue(text="Aleukemic lymphocytic leukemia") )
        setattr(cls, "Papilloma of bladder",
                PermissibleValue(text="Papilloma of bladder") )
        setattr(cls, "Myxoid fibroma",
                PermissibleValue(text="Myxoid fibroma") )
        setattr(cls, "Cellular blue nevus",
                PermissibleValue(text="Cellular blue nevus") )
        setattr(cls, "Mature teratoma",
                PermissibleValue(text="Mature teratoma") )
        setattr(cls, "Intracystic papilloma",
                PermissibleValue(text="Intracystic papilloma") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma with t(9;22)(q34;q11.2); BCR-ABL1",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma with t(9;22)(q34;q11.2); BCR-ABL1") )
        setattr(cls, "Myelodysplastic syndrome, NOS",
                PermissibleValue(text="Myelodysplastic syndrome, NOS") )
        setattr(cls, "Colloid adenocarcinoma",
                PermissibleValue(text="Colloid adenocarcinoma",
                                 description="Lung Mucinous Adenocarcinoma") )
        setattr(cls, "Fibrous mesothelioma, NOS",
                PermissibleValue(text="Fibrous mesothelioma, NOS") )
        setattr(cls, "Medullary adenocarcinoma",
                PermissibleValue(text="Medullary adenocarcinoma") )
        setattr(cls, "Ductal carcinoma, NOS",
                PermissibleValue(text="Ductal carcinoma, NOS") )
        setattr(cls, "Papillary epidermoid carcinoma",
                PermissibleValue(text="Papillary epidermoid carcinoma") )
        setattr(cls, "Acute lymphoblastic leukemia-lymphoma, NOS",
                PermissibleValue(text="Acute lymphoblastic leukemia-lymphoma, NOS") )
        setattr(cls, "Acute myeloid leukemia with prior myelodysplastic syndrome",
                PermissibleValue(text="Acute myeloid leukemia with prior myelodysplastic syndrome") )
        setattr(cls, "Dysplastic nevus",
                PermissibleValue(text="Dysplastic nevus") )
        setattr(cls, "Squamous cell carcinoma, small cell, nonkeratinizing",
                PermissibleValue(text="Squamous cell carcinoma, small cell, nonkeratinizing") )
        setattr(cls, "Atypical medullary carcinoma",
                PermissibleValue(text="Atypical medullary carcinoma") )
        setattr(cls, "Eccrine papillary adenoma",
                PermissibleValue(text="Eccrine papillary adenoma") )
        setattr(cls, "Mixed phenotype acute leukemia, B/myeloid, NOS",
                PermissibleValue(text="Mixed phenotype acute leukemia, B/myeloid, NOS") )
        setattr(cls, "Malignant eccrine spiradenoma",
                PermissibleValue(text="Malignant eccrine spiradenoma") )
        setattr(cls, "Refractory cytopenia with multilineage dysplasia",
                PermissibleValue(text="Refractory cytopenia with multilineage dysplasia") )
        setattr(cls, "Solid adenocarcinoma with mucin formation",
                PermissibleValue(text="Solid adenocarcinoma with mucin formation") )
        setattr(cls, "Juvenile melanoma",
                PermissibleValue(text="Juvenile melanoma") )
        setattr(cls, "Alpha cell tumor, malignant",
                PermissibleValue(text="Alpha cell tumor, malignant") )
        setattr(cls, "Spindle cell rhabdomyosarcoma",
                PermissibleValue(text="Spindle cell rhabdomyosarcoma") )
        setattr(cls, "Stromal endometriosis",
                PermissibleValue(text="Stromal endometriosis") )
        setattr(cls, "Malignant lymphoma, lymphocytic, nodular, NOS",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, nodular, NOS") )
        setattr(cls, "Medulloblastoma, WNT-activated",
                PermissibleValue(text="Medulloblastoma, WNT-activated") )
        setattr(cls, "Acute promyelocytic leukaemia, t(15;17)(q22;q11-12)",
                PermissibleValue(text="Acute promyelocytic leukaemia, t(15;17)(q22;q11-12)") )
        setattr(cls, "Malignant lymphoma, mixed lymphocytic-histiocytic, diffuse",
                PermissibleValue(text="Malignant lymphoma, mixed lymphocytic-histiocytic, diffuse") )
        setattr(cls, "Chronic erythremia",
                PermissibleValue(text="Chronic erythremia") )
        setattr(cls, "Malignant melanoma in congenital melanocytic nevus",
                PermissibleValue(text="Malignant melanoma in congenital melanocytic nevus") )
        setattr(cls, "Lipid-rich urothelial carcinoma",
                PermissibleValue(text="Lipid-rich urothelial carcinoma") )
        setattr(cls, "Retroperitoneal fibromatosis",
                PermissibleValue(text="Retroperitoneal fibromatosis") )
        setattr(cls, "Klatskin tumor",
                PermissibleValue(text="Klatskin tumor") )
        setattr(cls, "Atypical proliferating serous tumor",
                PermissibleValue(text="Atypical proliferating serous tumor") )
        setattr(cls, "Squamous intraepithelial neoplasia, grade III",
                PermissibleValue(text="Squamous intraepithelial neoplasia, grade III") )
        setattr(cls, "Hutchinson melanotic freckle, NOS",
                PermissibleValue(text="Hutchinson melanotic freckle, NOS") )
        setattr(cls, "Combined carcinoid and adenocarcinoma",
                PermissibleValue(text="Combined carcinoid and adenocarcinoma") )
        setattr(cls, "Follicular lymphoma, grade 3",
                PermissibleValue(text="Follicular lymphoma, grade 3") )
        setattr(cls, "Sex cord tumor, NOS",
                PermissibleValue(text="Sex cord tumor, NOS") )
        setattr(cls, "Sclerosing rhabdomyosarcoma",
                PermissibleValue(text="Sclerosing rhabdomyosarcoma") )
        setattr(cls, "Multiple endocrine adenomas",
                PermissibleValue(text="Multiple endocrine adenomas") )
        setattr(cls, "Papillary tumor of the pineal region",
                PermissibleValue(text="Papillary tumor of the pineal region") )
        setattr(cls, "Intracystic papillary adenoma",
                PermissibleValue(text="Intracystic papillary adenoma") )
        setattr(cls, "High grade surface osteosarcoma",
                PermissibleValue(text="High grade surface osteosarcoma") )
        setattr(cls, "Adenocarcinoma in tubolovillous adenoma",
                PermissibleValue(text="Adenocarcinoma in tubolovillous adenoma") )
        setattr(cls, "Basal cell carcinoma, morpheic",
                PermissibleValue(text="Basal cell carcinoma, morpheic") )
        setattr(cls, "Medulloblastoma, non-WNT/non-SHH",
                PermissibleValue(text="Medulloblastoma, non-WNT/non-SHH") )
        setattr(cls, "Periosteal fibrosarcoma",
                PermissibleValue(text="Periosteal fibrosarcoma") )
        setattr(cls, "Sex cord tumor with annular tubules",
                PermissibleValue(text="Sex cord tumor with annular tubules") )
        setattr(cls, "Primary myelofibrosis",
                PermissibleValue(text="Primary myelofibrosis") )
        setattr(cls, "Epithelioid cell sarcoma",
                PermissibleValue(text="Epithelioid cell sarcoma") )
        setattr(cls, "Angiocentric glioma",
                PermissibleValue(text="Angiocentric glioma") )
        setattr(cls, "Malignant lymphoma, large cleaved cell, NOS",
                PermissibleValue(text="Malignant lymphoma, large cleaved cell, NOS") )
        setattr(cls, "Papillary syringadenoma",
                PermissibleValue(text="Papillary syringadenoma") )
        setattr(cls, "Mucinous adenofibroma of borderline malignancy",
                PermissibleValue(text="Mucinous adenofibroma of borderline malignancy") )
        setattr(cls, "Basophil adenocarcinoma",
                PermissibleValue(text="Basophil adenocarcinoma") )
        setattr(cls, "Aleukemic myeloid leukemia",
                PermissibleValue(text="Aleukemic myeloid leukemia") )
        setattr(cls, "Poorly cohesive carcinoma",
                PermissibleValue(text="Poorly cohesive carcinoma") )
        setattr(cls, "Acute myeloid leukemia with t(9;11)(p22;q23); MLLT3-MLL",
                PermissibleValue(text="Acute myeloid leukemia with t(9;11)(p22;q23); MLLT3-MLL") )
        setattr(cls, "Reticulum cell sarcoma, diffuse",
                PermissibleValue(text="Reticulum cell sarcoma, diffuse") )
        setattr(cls, "Intracystic papillary adenocarcinoma",
                PermissibleValue(text="Intracystic papillary adenocarcinoma") )
        setattr(cls, "Malignant lymphoma, large cleaved cell, follicular",
                PermissibleValue(text="Malignant lymphoma, large cleaved cell, follicular") )
        setattr(cls, "Melanocytoma, NOS",
                PermissibleValue(text="Melanocytoma, NOS") )
        setattr(cls, "Plasmablastic lymphoma",
                PermissibleValue(text="Plasmablastic lymphoma") )
        setattr(cls, "Invasive carcinoma, NST",
                PermissibleValue(text="Invasive carcinoma, NST") )
        setattr(cls, "Serous cystadenocarcinoma, NOS",
                PermissibleValue(text="Serous cystadenocarcinoma, NOS") )
        setattr(cls, "Dermal and epidermal nevus",
                PermissibleValue(text="Dermal and epidermal nevus") )
        setattr(cls, "Gigantiform cementoma",
                PermissibleValue(text="Gigantiform cementoma") )
        setattr(cls, "Transitional cell carcinoma, micropapillary",
                PermissibleValue(text="Transitional cell carcinoma, micropapillary") )
        setattr(cls, "Solitary fibrous tumor/hemangiopericytoma Grade 2 (CNS)",
                PermissibleValue(text="Solitary fibrous tumor/hemangiopericytoma Grade 2 (CNS)") )
        setattr(cls, "Squamous cell carcinoma, keratinizing, NOS",
                PermissibleValue(text="Squamous cell carcinoma, keratinizing, NOS") )
        setattr(cls, "Malignant lymphoma, lymphoblastic, NOS",
                PermissibleValue(text="Malignant lymphoma, lymphoblastic, NOS") )
        setattr(cls, "Adult T-cell leukemia/lymphoma (HTLV-1 positive) (includes all variants)",
                PermissibleValue(text="Adult T-cell leukemia/lymphoma (HTLV-1 positive) (includes all variants)") )
        setattr(cls, "Pigmented adenoma",
                PermissibleValue(text="Pigmented adenoma") )
        setattr(cls, "Malignant chondroid syringoma",
                PermissibleValue(text="Malignant chondroid syringoma") )
        setattr(cls, "Thymoma, type B1, malignant",
                PermissibleValue(text="Thymoma, type B1, malignant") )
        setattr(cls, "Intraductal papillary-mucinous carcinoma, invasive",
                PermissibleValue(text="Intraductal papillary-mucinous carcinoma, invasive") )
        setattr(cls, "Malignant lymphoma, large cell, cleaved and noncleaved",
                PermissibleValue(text="Malignant lymphoma, large cell, cleaved and noncleaved") )
        setattr(cls, "Pleomorphic lipoma",
                PermissibleValue(text="Pleomorphic lipoma") )
        setattr(cls, "Diffuse large B-cell lymphoma, NOS",
                PermissibleValue(text="Diffuse large B-cell lymphoma, NOS") )
        setattr(cls, "Carcinoma in situ in adenomatous polyp",
                PermissibleValue(text="Carcinoma in situ in adenomatous polyp") )
        setattr(cls, "Adenocarcinoma, cribriform comedo-type",
                PermissibleValue(text="Adenocarcinoma, cribriform comedo-type") )
        setattr(cls, "Peripheral T-cell lymphoma, pleomorphic small cell",
                PermissibleValue(text="Peripheral T-cell lymphoma, pleomorphic small cell") )
        setattr(cls, "Acinar cell tumor",
                PermissibleValue(text="Acinar cell tumor") )
        setattr(cls, "Clear cell adenoma",
                PermissibleValue(text="Clear cell adenoma") )
        setattr(cls, "Adenocarcinoma in adenomatous polyp",
                PermissibleValue(text="Adenocarcinoma in adenomatous polyp") )
        setattr(cls, "Adenocarcinoma, NOS",
                PermissibleValue(text="Adenocarcinoma, NOS") )
        setattr(cls, "Chronic myeloproliferative disorder",
                PermissibleValue(text="Chronic myeloproliferative disorder") )
        setattr(cls, "Monstrocellular sarcoma",
                PermissibleValue(text="Monstrocellular sarcoma") )
        setattr(cls, "Leukemia, NOS",
                PermissibleValue(text="Leukemia, NOS") )
        setattr(cls, "Thymoma, type B2, NOS",
                PermissibleValue(text="Thymoma, type B2, NOS") )
        setattr(cls, "NUT midline carcinoma",
                PermissibleValue(text="NUT midline carcinoma") )
        setattr(cls, "Carcinoma, NOS",
                PermissibleValue(text="Carcinoma, NOS") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma with t(v;11q23); MLL rearranged",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma with t(v;11q23); MLL rearranged") )
        setattr(cls, "Calcifying nested epithelial stromal tumor",
                PermissibleValue(text="Calcifying nested epithelial stromal tumor") )
        setattr(cls, "Teratoma, NOS",
                PermissibleValue(text="Teratoma, NOS") )
        setattr(cls, "Neuroendocrine tumor, grade 1",
                PermissibleValue(text="Neuroendocrine tumor, grade 1") )
        setattr(cls, "Polygonal cell carcinoma",
                PermissibleValue(text="Polygonal cell carcinoma") )
        setattr(cls, "Malignant tenosynovial giant cell tumor",
                PermissibleValue(text="Malignant tenosynovial giant cell tumor") )
        setattr(cls, "Tumor, NOS",
                PermissibleValue(text="Tumor, NOS") )
        setattr(cls, "Sympathetic paraganglioma",
                PermissibleValue(text="Sympathetic paraganglioma") )
        setattr(cls, "Basal cell carcinoma, fibroepithelial",
                PermissibleValue(text="Basal cell carcinoma, fibroepithelial") )
        setattr(cls, "Malignant lymphoma, lymphocytic, intermediate differentiation, diffuse",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, intermediate differentiation, diffuse") )
        setattr(cls, "Classical Hodgkin lymphoma, lymphocyte-rich",
                PermissibleValue(text="Classical Hodgkin lymphoma, lymphocyte-rich") )
        setattr(cls, "Osteoblastic sarcoma",
                PermissibleValue(text="Osteoblastic sarcoma") )
        setattr(cls, "Squamous cell carcinoma with horn formation",
                PermissibleValue(text="Squamous cell carcinoma with horn formation") )
        setattr(cls, "Histiocytic medullary reticulosis",
                PermissibleValue(text="Histiocytic medullary reticulosis") )
        setattr(cls, "Primitive neuroectodermal tumor, NOS",
                PermissibleValue(text="Primitive neuroectodermal tumor, NOS") )
        setattr(cls, "Classical Hodgkin lymphoma, lymphocyte depletion, NOS",
                PermissibleValue(text="Classical Hodgkin lymphoma, lymphocyte depletion, NOS") )
        setattr(cls, "Histiocytoid hemangioma",
                PermissibleValue(text="Histiocytoid hemangioma") )
        setattr(cls, "Mesonephroma, malignant",
                PermissibleValue(text="Mesonephroma, malignant") )
        setattr(cls, "Multiple meningiomas",
                PermissibleValue(text="Multiple meningiomas") )
        setattr(cls, "Mucinous cystadenofibroma of borderline malignancy",
                PermissibleValue(text="Mucinous cystadenofibroma of borderline malignancy") )
        setattr(cls, "Mu heavy chain disease",
                PermissibleValue(text="Mu heavy chain disease") )
        setattr(cls, "Chorioadenoma destruens",
                PermissibleValue(text="Chorioadenoma destruens") )
        setattr(cls, "Malignant lymphoma, nodular, NOS",
                PermissibleValue(text="Malignant lymphoma, nodular, NOS") )
        setattr(cls, "Duct cell carcinoma",
                PermissibleValue(text="Duct cell carcinoma") )
        setattr(cls, "Papillary carcinoma, tall cell",
                PermissibleValue(text="Papillary carcinoma, tall cell") )
        setattr(cls, "Thymoma, epithelial, malignant",
                PermissibleValue(text="Thymoma, epithelial, malignant") )
        setattr(cls, "Intraductal and lobular carcinoma",
                PermissibleValue(text="Intraductal and lobular carcinoma") )
        setattr(cls, "Urticaria pigmentosa",
                PermissibleValue(text="Urticaria pigmentosa") )
        setattr(cls, "Hodgkin granuloma",
                PermissibleValue(text="Hodgkin granuloma") )
        setattr(cls, "Thymic carcinoma, NOS",
                PermissibleValue(text="Thymic carcinoma, NOS") )
        setattr(cls, "T lymphoblastic leukemia/lymphoma",
                PermissibleValue(text="T lymphoblastic leukemia/lymphoma") )
        setattr(cls, "Basal cell carcinoma, nodular",
                PermissibleValue(text="Basal cell carcinoma, nodular") )
        setattr(cls, "Carcinoid tumor, NOS, of appendix",
                PermissibleValue(text="Carcinoid tumor, NOS, of appendix") )
        setattr(cls, "Squamous cell papilloma, inverted",
                PermissibleValue(text="Squamous cell papilloma, inverted") )
        setattr(cls, "Myoepithelial carcinoma",
                PermissibleValue(text="Myoepithelial carcinoma",
                                 description="Malignant Myoepithelioma") )
        setattr(cls, "Adenocarcinoma, metastatic, NOS",
                PermissibleValue(text="Adenocarcinoma, metastatic, NOS") )
        setattr(cls, "Adenocarcinoma, cylindroid",
                PermissibleValue(text="Adenocarcinoma, cylindroid") )
        setattr(cls, "Osteocartilaginous exostosis",
                PermissibleValue(text="Osteocartilaginous exostosis") )
        setattr(cls, "Endometrioid adenoma, NOS",
                PermissibleValue(text="Endometrioid adenoma, NOS") )
        setattr(cls, "Bronchial-associated lymphoid tissue lymphoma",
                PermissibleValue(text="Bronchial-associated lymphoid tissue lymphoma") )
        setattr(cls, "Sertoli-Leydig cell tumor, sarcomatoid",
                PermissibleValue(text="Sertoli-Leydig cell tumor, sarcomatoid") )
        setattr(cls, "Follicular adenoma, oxyphilic cell",
                PermissibleValue(text="Follicular adenoma, oxyphilic cell") )
        setattr(cls, "Spindle cell angioendothelioma",
                PermissibleValue(text="Spindle cell angioendothelioma") )
        setattr(cls, "Carotid body tumor",
                PermissibleValue(text="Carotid body tumor") )
        setattr(cls, "Abdominal desmoid",
                PermissibleValue(text="Abdominal desmoid") )
        setattr(cls, "Mucinous cystic neoplasm with intermediate-grade dysplasia",
                PermissibleValue(text="Mucinous cystic neoplasm with intermediate-grade dysplasia") )
        setattr(cls, "Invasive hydatidiform mole",
                PermissibleValue(text="Invasive hydatidiform mole") )
        setattr(cls, "Blue nevus, malignant",
                PermissibleValue(text="Blue nevus, malignant") )
        setattr(cls, "Sclerosing hepatic carcinoma",
                PermissibleValue(text="Sclerosing hepatic carcinoma") )
        setattr(cls, "Clear cell sarcoma, NOS",
                PermissibleValue(text="Clear cell sarcoma, NOS") )
        setattr(cls, "Hepatoma, benign",
                PermissibleValue(text="Hepatoma, benign") )
        setattr(cls, "Adrenal cortical carcinoma",
                PermissibleValue(text="Adrenal cortical carcinoma") )
        setattr(cls, "Teratoma with malignant transformation",
                PermissibleValue(text="Teratoma with malignant transformation") )
        setattr(cls, "AIN III",
                PermissibleValue(text="AIN III") )
        setattr(cls, "Mixed tumor, salivary gland type, malignant",
                PermissibleValue(text="Mixed tumor, salivary gland type, malignant") )
        setattr(cls, "Proliferating trichilemmal cyst",
                PermissibleValue(text="Proliferating trichilemmal cyst") )
        setattr(cls, "Meningeal sarcomatosis",
                PermissibleValue(text="Meningeal sarcomatosis") )
        setattr(cls, "Sertoli-Leydig cell tumor, well differentiated",
                PermissibleValue(text="Sertoli-Leydig cell tumor, well differentiated") )
        setattr(cls, "Squamous cell carcinoma in situ, NOS",
                PermissibleValue(text="Squamous cell carcinoma in situ, NOS") )
        setattr(cls, "Unclassified tumor, uncertain whether benign or malignant",
                PermissibleValue(text="Unclassified tumor, uncertain whether benign or malignant") )
        setattr(cls, "L-cell tumor",
                PermissibleValue(text="L-cell tumor") )
        setattr(cls, "Giant cell tumor of tendon sheath",
                PermissibleValue(text="Giant cell tumor of tendon sheath") )
        setattr(cls, "Adenocarcinoma in situ in adenomatous polyp",
                PermissibleValue(text="Adenocarcinoma in situ in adenomatous polyp") )
        setattr(cls, "Papillary transitional cell carcinoma, non-invasive",
                PermissibleValue(text="Papillary transitional cell carcinoma, non-invasive") )
        setattr(cls, "Cin III, NOS",
                PermissibleValue(text="Cin III, NOS") )
        setattr(cls, "Langerhans cell histiocytosis, generalized",
                PermissibleValue(text="Langerhans cell histiocytosis, generalized") )
        setattr(cls, "Plasma cell myeloma",
                PermissibleValue(text="Plasma cell myeloma") )
        setattr(cls, "ECL cell carcinoid, malignant",
                PermissibleValue(text="ECL cell carcinoid, malignant") )
        setattr(cls, "Eosinophil adenocarcinoma",
                PermissibleValue(text="Eosinophil adenocarcinoma") )
        setattr(cls, "Malignant lymphoma, NOS",
                PermissibleValue(text="Malignant lymphoma, NOS") )
        setattr(cls, "Ductal intraepithelial neoplasia 3",
                PermissibleValue(text="Ductal intraepithelial neoplasia 3") )
        setattr(cls, "Enteric adenocarcinoma",
                PermissibleValue(text="Enteric adenocarcinoma",
                                 description="Lung Enteric Adenocarcinoma") )
        setattr(cls, "Squamous intraepithelial neoplasia, grade II",
                PermissibleValue(text="Squamous intraepithelial neoplasia, grade II") )
        setattr(cls, "Marginal zone lymphoma, NOS",
                PermissibleValue(text="Marginal zone lymphoma, NOS",
                                 description="Marginal Zone Lymphoma Not Otherwise Specified") )
        setattr(cls, "Mixed meningioma",
                PermissibleValue(text="Mixed meningioma") )
        setattr(cls, "Carcinoid tumor of uncertain malignant potential",
                PermissibleValue(text="Carcinoid tumor of uncertain malignant potential") )
        setattr(cls, "Myxopapillary ependymoma",
                PermissibleValue(text="Myxopapillary ependymoma") )
        setattr(cls, "Acral lentiginous melanoma, malignant",
                PermissibleValue(text="Acral lentiginous melanoma, malignant") )
        setattr(cls, "Choriocarcinoma combined with teratorna",
                PermissibleValue(text="Choriocarcinoma combined with teratorna") )
        setattr(cls, "PTLD, NOS",
                PermissibleValue(text="PTLD, NOS") )
        setattr(cls, "Intraductal papillary adenocarcinoma, NOS",
                PermissibleValue(text="Intraductal papillary adenocarcinoma, NOS") )
        setattr(cls, "Fibrous meningioma",
                PermissibleValue(text="Fibrous meningioma") )
        setattr(cls, "Aorticopulmonary paraganglioma",
                PermissibleValue(text="Aorticopulmonary paraganglioma") )
        setattr(cls, "Dermal nevus",
                PermissibleValue(text="Dermal nevus") )
        setattr(cls, "Acinic cell tumor",
                PermissibleValue(text="Acinic cell tumor") )
        setattr(cls, "Embryonal tumor with multilayered rosettes, NOS",
                PermissibleValue(text="Embryonal tumor with multilayered rosettes, NOS") )
        setattr(cls, "Mediterranean lymphoma",
                PermissibleValue(text="Mediterranean lymphoma") )
        setattr(cls, "Malignant peripheral nerve sheath tumor with rhabdomyoblastic differentiation",
                PermissibleValue(text="Malignant peripheral nerve sheath tumor with rhabdomyoblastic differentiation") )
        setattr(cls, "Acute myeloid leukemia with abnormal marrow eosinophils (includes all variants)",
                PermissibleValue(text="Acute myeloid leukemia with abnormal marrow eosinophils (includes all variants)") )
        setattr(cls, "Somatostatinoma, malignant",
                PermissibleValue(text="Somatostatinoma, malignant") )
        setattr(cls, "Alveolar adenocarcinoma",
                PermissibleValue(text="Alveolar adenocarcinoma") )
        setattr(cls, "Syringomatous carcinoma",
                PermissibleValue(text="Syringomatous carcinoma") )
        setattr(cls, "Synovial sarcoma, biphasic",
                PermissibleValue(text="Synovial sarcoma, biphasic") )
        setattr(cls, "Basal cell adenoma",
                PermissibleValue(text="Basal cell adenoma") )
        setattr(cls, "Renal cell carcinoma, unclassified",
                PermissibleValue(text="Renal cell carcinoma, unclassified",
                                 description="Unclassified Renal Cell Carcinoma") )
        setattr(cls, "Nephrogenic adenofibroma",
                PermissibleValue(text="Nephrogenic adenofibroma") )
        setattr(cls, "Undifferentiated leukaemia",
                PermissibleValue(text="Undifferentiated leukaemia") )
        setattr(cls, "Syringadenoma, NOS",
                PermissibleValue(text="Syringadenoma, NOS") )
        setattr(cls, "Aggressive systemic mastocytosis",
                PermissibleValue(text="Aggressive systemic mastocytosis") )
        setattr(cls, "Cavernous hemangioma",
                PermissibleValue(text="Cavernous hemangioma") )
        setattr(cls, "Mucosal lentiginous melanoma",
                PermissibleValue(text="Mucosal lentiginous melanoma") )
        setattr(cls, "Malignant lymphoma, small cell, noncleaved, diffuse",
                PermissibleValue(text="Malignant lymphoma, small cell, noncleaved, diffuse") )
        setattr(cls, "Clear cell cystadenofibroma",
                PermissibleValue(text="Clear cell cystadenofibroma") )
        setattr(cls, "Pancreatic microadenoma",
                PermissibleValue(text="Pancreatic microadenoma") )
        setattr(cls, "Franklin disease",
                PermissibleValue(text="Franklin disease") )
        setattr(cls, "DCIS, papillary",
                PermissibleValue(text="DCIS, papillary") )
        setattr(cls, "Atypical follicular adenoma",
                PermissibleValue(text="Atypical follicular adenoma") )
        setattr(cls, "Low grade adenosquamous carcinoma",
                PermissibleValue(text="Low grade adenosquamous carcinoma") )
        setattr(cls, "C cell carcinoma",
                PermissibleValue(text="C cell carcinoma") )
        setattr(cls, "Chronic eosinophilic leukemia, NOS",
                PermissibleValue(text="Chronic eosinophilic leukemia, NOS") )
        setattr(cls, "Hydatidiform mole, NOS",
                PermissibleValue(text="Hydatidiform mole, NOS") )
        setattr(cls, "Chronic neutrophilic leukemia",
                PermissibleValue(text="Chronic neutrophilic leukemia") )
        setattr(cls, "Acute lymphoblastic leukemia, NOS",
                PermissibleValue(text="Acute lymphoblastic leukemia, NOS") )
        setattr(cls, "Lobular and ductal carcinoma",
                PermissibleValue(text="Lobular and ductal carcinoma") )
        setattr(cls, "Traditional sessile serrated adenoma",
                PermissibleValue(text="Traditional sessile serrated adenoma") )
        setattr(cls, "Choriocarcinoma combined with other germ cell elements",
                PermissibleValue(text="Choriocarcinoma combined with other germ cell elements") )
        setattr(cls, "Benign fibrous histiocytoma",
                PermissibleValue(text="Benign fibrous histiocytoma") )
        setattr(cls, "Hepatocellular carcinoma, clear cell type",
                PermissibleValue(text="Hepatocellular carcinoma, clear cell type") )
        setattr(cls, "Pre-pre-B ALL",
                PermissibleValue(text="Pre-pre-B ALL") )
        setattr(cls, "Carcinoma, intestinal type",
                PermissibleValue(text="Carcinoma, intestinal type") )
        setattr(cls, "Bronchio-alveolar carcinoma, mixed mucinous and non-mucinous",
                PermissibleValue(text="Bronchio-alveolar carcinoma, mixed mucinous and non-mucinous") )
        setattr(cls, "Hurthle cell adenoma",
                PermissibleValue(text="Hurthle cell adenoma") )
        setattr(cls, "RAEB I",
                PermissibleValue(text="RAEB I") )
        setattr(cls, "Ameloblastoma, NOS",
                PermissibleValue(text="Ameloblastoma, NOS") )
        setattr(cls, "Invasive encapsulated follicular variant of papillary thyroid carcinoma (invasive EFVPTC)",
                PermissibleValue(text="Invasive encapsulated follicular variant of papillary thyroid carcinoma (invasive EFVPTC)") )
        setattr(cls, "Eccrine cystadenoma",
                PermissibleValue(text="Eccrine cystadenoma") )
        setattr(cls, "Extraosseous plasmacytoma",
                PermissibleValue(text="Extraosseous plasmacytoma") )
        setattr(cls, "Granulocytic sarcoma",
                PermissibleValue(text="Granulocytic sarcoma") )
        setattr(cls, "Mixed cell adenocarcinoma",
                PermissibleValue(text="Mixed cell adenocarcinoma") )
        setattr(cls, "Insulinoma, NOS",
                PermissibleValue(text="Insulinoma, NOS") )
        setattr(cls, "Adenocarcinoma with cartilaginous and osseous metaplasia",
                PermissibleValue(text="Adenocarcinoma with cartilaginous and osseous metaplasia") )
        setattr(cls, "Intraepithelial carcinoma, NOS",
                PermissibleValue(text="Intraepithelial carcinoma, NOS") )
        setattr(cls, "Prolymphocytic leukemia, T-cell type",
                PermissibleValue(text="Prolymphocytic leukemia, T-cell type") )
        setattr(cls, "Pulmonary myxoid sarcoma with EWSR1-CREB1 translocation",
                PermissibleValue(text="Pulmonary myxoid sarcoma with EWSR1-CREB1 translocation") )
        setattr(cls, "Thymoma, organoid, malignant",
                PermissibleValue(text="Thymoma, organoid, malignant") )
        setattr(cls, "Sweat gland tumor, NOS",
                PermissibleValue(text="Sweat gland tumor, NOS") )
        setattr(cls, "Papillary pseudomucinous cystadenocarcinoma",
                PermissibleValue(text="Papillary pseudomucinous cystadenocarcinoma") )
        setattr(cls, "Adenoid basal carcinoma",
                PermissibleValue(text="Adenoid basal carcinoma") )
        setattr(cls, "Teratoma, differentiated",
                PermissibleValue(text="Teratoma, differentiated") )
        setattr(cls, "Paraganglioma, NOS",
                PermissibleValue(text="Paraganglioma, NOS") )
        setattr(cls, "Squamous cell carcinoma, nonkeratinizing, NOS",
                PermissibleValue(text="Squamous cell carcinoma, nonkeratinizing, NOS") )
        setattr(cls, "Periosteal sarcoma, NOS",
                PermissibleValue(text="Periosteal sarcoma, NOS") )
        setattr(cls, "Hodgkin lymphoma, nodular lymphocyte predominance",
                PermissibleValue(text="Hodgkin lymphoma, nodular lymphocyte predominance") )
        setattr(cls, "Serous cystadenoma, borderline malignancy",
                PermissibleValue(text="Serous cystadenoma, borderline malignancy") )
        setattr(cls, "Glucagonoma, NOS",
                PermissibleValue(text="Glucagonoma, NOS") )
        setattr(cls, "Soft tissue perineurioma",
                PermissibleValue(text="Soft tissue perineurioma") )
        setattr(cls, "Mesenchymal chondrosarcoma",
                PermissibleValue(text="Mesenchymal chondrosarcoma") )
        setattr(cls, "Hodgkin disease, lymphocyte predominance, NOS",
                PermissibleValue(text="Hodgkin disease, lymphocyte predominance, NOS") )
        setattr(cls, "Olfactory neurogenic tumor",
                PermissibleValue(text="Olfactory neurogenic tumor") )
        setattr(cls, "Villous adenocarcinoma",
                PermissibleValue(text="Villous adenocarcinoma") )
        setattr(cls, "Bronchiolo-alveolar carcinoma, non-mucinous",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma, non-mucinous") )
        setattr(cls, "Atypical fibroxanthoma",
                PermissibleValue(text="Atypical fibroxanthoma") )
        setattr(cls, "Multiple myeloma",
                PermissibleValue(text="Multiple myeloma") )
        setattr(cls, "Biliary intraepithelial neoplasia, low grade",
                PermissibleValue(text="Biliary intraepithelial neoplasia, low grade") )
        setattr(cls, "Odontogenic carcinoma",
                PermissibleValue(text="Odontogenic carcinoma") )
        setattr(cls, "Amelanotic melanoma",
                PermissibleValue(text="Amelanotic melanoma") )
        setattr(cls, "Sclerosing epithelioid fibrosarcoma",
                PermissibleValue(text="Sclerosing epithelioid fibrosarcoma") )
        setattr(cls, "Myelodysplastic syndrome with isolated del (5q)",
                PermissibleValue(text="Myelodysplastic syndrome with isolated del (5q)") )
        setattr(cls, "Monoclonal gammopathy of undetermined significance",
                PermissibleValue(text="Monoclonal gammopathy of undetermined significance") )
        setattr(cls, "Subacute granulocytic leukemia",
                PermissibleValue(text="Subacute granulocytic leukemia") )
        setattr(cls, "Cerebellar liponeurocytoma",
                PermissibleValue(text="Cerebellar liponeurocytoma") )
        setattr(cls, "Testicular stromal tumor",
                PermissibleValue(text="Testicular stromal tumor") )
        setattr(cls, "Mesothelioma, NOS",
                PermissibleValue(text="Mesothelioma, NOS") )
        setattr(cls, "Pleomorphic cell sarcoma",
                PermissibleValue(text="Pleomorphic cell sarcoma") )
        setattr(cls, "Oxyphilic adenocarcinoma",
                PermissibleValue(text="Oxyphilic adenocarcinoma") )
        setattr(cls, "Malignant lymphoma, small B lymphocytic, NOS",
                PermissibleValue(text="Malignant lymphoma, small B lymphocytic, NOS") )
        setattr(cls, "Histiocyte-rich large B-cell lymphoma",
                PermissibleValue(text="Histiocyte-rich large B-cell lymphoma") )
        setattr(cls, "Nonpigmented nevus",
                PermissibleValue(text="Nonpigmented nevus") )
        setattr(cls, "Pulmonary blastoma",
                PermissibleValue(text="Pulmonary blastoma") )
        setattr(cls, "Granular cell adenocarcinoma",
                PermissibleValue(text="Granular cell adenocarcinoma") )
        setattr(cls, "Pseudosarcomatous carcinoma",
                PermissibleValue(text="Pseudosarcomatous carcinoma") )
        setattr(cls, "Lymphoid leukemia, NOS",
                PermissibleValue(text="Lymphoid leukemia, NOS") )
        setattr(cls, "Insulinoma, malignant",
                PermissibleValue(text="Insulinoma, malignant") )
        setattr(cls, "Granulosa cell tumor, adult type",
                PermissibleValue(text="Granulosa cell tumor, adult type",
                                 description="Adult Type Ovarian Granulosa Cell Tumor") )
        setattr(cls, "Subependymal giant cell astrocytoma",
                PermissibleValue(text="Subependymal giant cell astrocytoma") )
        setattr(cls, "Meningioma, NOS",
                PermissibleValue(text="Meningioma, NOS") )
        setattr(cls, "Achromic nevus",
                PermissibleValue(text="Achromic nevus") )
        setattr(cls, "Argentaffinoma, malignant",
                PermissibleValue(text="Argentaffinoma, malignant") )
        setattr(cls, "Intraductal papillary neoplasm, NOS",
                PermissibleValue(text="Intraductal papillary neoplasm, NOS") )
        setattr(cls, "Alveolar carcinoma",
                PermissibleValue(text="Alveolar carcinoma") )
        setattr(cls, "Cylindrical cell papilloma",
                PermissibleValue(text="Cylindrical cell papilloma") )
        setattr(cls, "Papillotubular adenocarcinoma",
                PermissibleValue(text="Papillotubular adenocarcinoma") )
        setattr(cls, "Neoplasm, metastatic",
                PermissibleValue(text="Neoplasm, metastatic") )
        setattr(cls, "Melanoma, NOS",
                PermissibleValue(text="Melanoma, NOS",
                                 description="Not Otherwise Specified Melanoma") )
        setattr(cls, "Diktyoma, malignant",
                PermissibleValue(text="Diktyoma, malignant") )
        setattr(cls, "Pseudomucinous cystadenoma, NOS",
                PermissibleValue(text="Pseudomucinous cystadenoma, NOS") )
        setattr(cls, "Splenic marginal zone B-cell lymphoma",
                PermissibleValue(text="Splenic marginal zone B-cell lymphoma") )
        setattr(cls, "T-gamma lymphoproliferative disease",
                PermissibleValue(text="T-gamma lymphoproliferative disease") )
        setattr(cls, "Hepatoid carcinoma",
                PermissibleValue(text="Hepatoid carcinoma") )
        setattr(cls, "Neoplasm, secondary",
                PermissibleValue(text="Neoplasm, secondary") )
        setattr(cls, "Low-grade fibromyxoid sarcoma",
                PermissibleValue(text="Low-grade fibromyxoid sarcoma") )
        setattr(cls, "Telangiectatic osteosarcoma",
                PermissibleValue(text="Telangiectatic osteosarcoma") )
        setattr(cls, "Aortic body paraganglioma",
                PermissibleValue(text="Aortic body paraganglioma") )
        setattr(cls, "Malignant lymphoma, follicular, NOS",
                PermissibleValue(text="Malignant lymphoma, follicular, NOS") )
        setattr(cls, "Intravascular large B-cell lymphoma",
                PermissibleValue(text="Intravascular large B-cell lymphoma") )
        setattr(cls, "FAB L2",
                PermissibleValue(text="FAB L2") )
        setattr(cls, "Comedocarcinoma, NOS",
                PermissibleValue(text="Comedocarcinoma, NOS") )
        setattr(cls, "Ceruminous adenoma",
                PermissibleValue(text="Ceruminous adenoma") )
        setattr(cls, "Clear cell hidradenoma",
                PermissibleValue(text="Clear cell hidradenoma") )
        setattr(cls, "Papillary carcinoma, diffuse sclerosing",
                PermissibleValue(text="Papillary carcinoma, diffuse sclerosing") )
        setattr(cls, "Pseudomucinous adenocarcinoma",
                PermissibleValue(text="Pseudomucinous adenocarcinoma") )
        setattr(cls, "Mixed adenoneuroendocrine carcinoma",
                PermissibleValue(text="Mixed adenoneuroendocrine carcinoma",
                                 description="Digestive System Mixed Adenoneuroendocrine Carcinoma") )
        setattr(cls, "Islet cell adenocarcinoma",
                PermissibleValue(text="Islet cell adenocarcinoma") )
        setattr(cls, "Plasmacytic leukemia",
                PermissibleValue(text="Plasmacytic leukemia") )
        setattr(cls, "Melanotic psammomatous MPNST",
                PermissibleValue(text="Melanotic psammomatous MPNST") )
        setattr(cls, "Neurilemoma, NOS",
                PermissibleValue(text="Neurilemoma, NOS") )
        setattr(cls, "Islet cell tumor, benign",
                PermissibleValue(text="Islet cell tumor, benign") )
        setattr(cls, "Jugulotympanic paraganglioma",
                PermissibleValue(text="Jugulotympanic paraganglioma") )
        setattr(cls, "Clear cell carcinoma",
                PermissibleValue(text="Clear cell carcinoma") )
        setattr(cls, "Bronchial adenoma, cylindroid",
                PermissibleValue(text="Bronchial adenoma, cylindroid") )
        setattr(cls, "Erythremic myelosis, NOS",
                PermissibleValue(text="Erythremic myelosis, NOS") )
        setattr(cls, "Papillomatosis, glandular",
                PermissibleValue(text="Papillomatosis, glandular") )
        setattr(cls, "Mixed islet cell and exocrine adenocarcinoma",
                PermissibleValue(text="Mixed islet cell and exocrine adenocarcinoma") )
        setattr(cls, "Hodgkin disease, lymphocyte predominance, diffuse",
                PermissibleValue(text="Hodgkin disease, lymphocyte predominance, diffuse") )
        setattr(cls, "Steroid cell tumor, NOS",
                PermissibleValue(text="Steroid cell tumor, NOS") )
        setattr(cls, "Acute leukemia, NOS",
                PermissibleValue(text="Acute leukemia, NOS") )
        setattr(cls, "Intracystic papillary neoplasm with associated invasive carcinoma",
                PermissibleValue(text="Intracystic papillary neoplasm with associated invasive carcinoma") )
        setattr(cls, "Cylindroma, NOS",
                PermissibleValue(text="Cylindroma, NOS") )
        setattr(cls, "Tumor, malignant, NOS",
                PermissibleValue(text="Tumor, malignant, NOS") )
        setattr(cls, "Non-Hodgkin lymphoma, NOS",
                PermissibleValue(text="Non-Hodgkin lymphoma, NOS") )
        setattr(cls, "Angiomatoid fibrous histiocytoma",
                PermissibleValue(text="Angiomatoid fibrous histiocytoma") )
        setattr(cls, "Squamous papillomatosis",
                PermissibleValue(text="Squamous papillomatosis") )
        setattr(cls, "GIST, benign",
                PermissibleValue(text="GIST, benign") )
        setattr(cls, "Adenocarcinoma in villous adenoma",
                PermissibleValue(text="Adenocarcinoma in villous adenoma") )
        setattr(cls, "Large cell neuroendocrine carcinoma",
                PermissibleValue(text="Large cell neuroendocrine carcinoma") )
        setattr(cls, "Acute myeloid leukemia with myelodysplasia-related changes",
                PermissibleValue(text="Acute myeloid leukemia with myelodysplasia-related changes") )
        setattr(cls, "Paget disease and infiltrating duct carcinoma of breast",
                PermissibleValue(text="Paget disease and infiltrating duct carcinoma of breast") )
        setattr(cls, "Aggressive angiomyxoma",
                PermissibleValue(text="Aggressive angiomyxoma") )
        setattr(cls, "Hemangiopericytoma, benign",
                PermissibleValue(text="Hemangiopericytoma, benign") )
        setattr(cls, "Mixed subependymoma-ependymoma",
                PermissibleValue(text="Mixed subependymoma-ependymoma") )
        setattr(cls, "Follicular carcinoma, moderately differentiated",
                PermissibleValue(text="Follicular carcinoma, moderately differentiated") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma with hypodiploidy (Hypodiploid ALL)",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma with hypodiploidy (Hypodiploid ALL)") )
        setattr(cls, "Malignant lymphoma, histiocytic, diffuse",
                PermissibleValue(text="Malignant lymphoma, histiocytic, diffuse") )
        setattr(cls, "Fetal rhabdomyoma",
                PermissibleValue(text="Fetal rhabdomyoma") )
        setattr(cls, "Malignant lymphoma, centroblastic, NOS",
                PermissibleValue(text="Malignant lymphoma, centroblastic, NOS") )
        setattr(cls, "Osteoblastoma, NOS",
                PermissibleValue(text="Osteoblastoma, NOS") )
        setattr(cls, "Burkitt-like lymphoma",
                PermissibleValue(text="Burkitt-like lymphoma") )
        setattr(cls, "Tubulovillous adenoma, NOS",
                PermissibleValue(text="Tubulovillous adenoma, NOS") )
        setattr(cls, "Spiradenoma, NOS",
                PermissibleValue(text="Spiradenoma, NOS") )
        setattr(cls, "Malignant schwannoma with rhabdomyoblastic differentiation",
                PermissibleValue(text="Malignant schwannoma with rhabdomyoblastic differentiation") )
        setattr(cls, "Intraductal papillary-mucinous carcinoma, non-invasive",
                PermissibleValue(text="Intraductal papillary-mucinous carcinoma, non-invasive") )
        setattr(cls, "Alveolar cell carcinoma",
                PermissibleValue(text="Alveolar cell carcinoma") )
        setattr(cls, "Liposarcoma, NOS",
                PermissibleValue(text="Liposarcoma, NOS") )
        setattr(cls, "Adult T-cell leukemia",
                PermissibleValue(text="Adult T-cell leukemia") )
        setattr(cls, "Papillary urothelial neoplasm of low malignant potential",
                PermissibleValue(text="Papillary urothelial neoplasm of low malignant potential") )
        setattr(cls, "Pineal parenchymal tumor of intermediate differentiation",
                PermissibleValue(text="Pineal parenchymal tumor of intermediate differentiation") )
        setattr(cls, "Infiltrating duct and colloid carcinoma",
                PermissibleValue(text="Infiltrating duct and colloid carcinoma") )
        setattr(cls, "Multicystic mesothelioma, benign",
                PermissibleValue(text="Multicystic mesothelioma, benign") )
        setattr(cls, "Transitional cell papilloma, NOS",
                PermissibleValue(text="Transitional cell papilloma, NOS") )
        setattr(cls, "Adrenal cortical adenoma, NOS",
                PermissibleValue(text="Adrenal cortical adenoma, NOS") )
        setattr(cls, "Oncocytic adenocarcinoma",
                PermissibleValue(text="Oncocytic adenocarcinoma") )
        setattr(cls, "Bronchiolo-alveolar carcinoma, Clara cell and goblet cell type",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma, Clara cell and goblet cell type") )
        setattr(cls, "Mucinous cystadenocarcinoma, NOS",
                PermissibleValue(text="Mucinous cystadenocarcinoma, NOS") )
        setattr(cls, "Chromophobe adenoma",
                PermissibleValue(text="Chromophobe adenoma") )
        setattr(cls, "Hodgkin lymphoma, NOS",
                PermissibleValue(text="Hodgkin lymphoma, NOS") )
        setattr(cls, "Mixed tumor, salivary gland type, NOS",
                PermissibleValue(text="Mixed tumor, salivary gland type, NOS") )
        setattr(cls, "Mesodermal mixed tumor",
                PermissibleValue(text="Mesodermal mixed tumor") )
        setattr(cls, "Cellular fibroma",
                PermissibleValue(text="Cellular fibroma") )
        setattr(cls, "Thymoma, atypical, malignant",
                PermissibleValue(text="Thymoma, atypical, malignant") )
        setattr(cls, "Codman tumor",
                PermissibleValue(text="Codman tumor") )
        setattr(cls, "Adenocarcinoma in situ in polypoid adenoma",
                PermissibleValue(text="Adenocarcinoma in situ in polypoid adenoma") )
        setattr(cls, "Indolent systemic mastocytosis",
                PermissibleValue(text="Indolent systemic mastocytosis") )
        setattr(cls, "Struma ovarii and carcinoid",
                PermissibleValue(text="Struma ovarii and carcinoid") )
        setattr(cls, "Paget disease, mammary",
                PermissibleValue(text="Paget disease, mammary") )
        setattr(cls, "Myxoinflammatory fibroblastic sarcoma (MIFS)",
                PermissibleValue(text="Myxoinflammatory fibroblastic sarcoma (MIFS)") )
        setattr(cls, "Gelatinous adenocarcinoma",
                PermissibleValue(text="Gelatinous adenocarcinoma") )
        setattr(cls, "Refractory anemia without sideroblasts",
                PermissibleValue(text="Refractory anemia without sideroblasts") )
        setattr(cls, "Plasma cell leukemia",
                PermissibleValue(text="Plasma cell leukemia") )
        setattr(cls, "Epidermoid carcinoma, small cell, nonkeratinizing",
                PermissibleValue(text="Epidermoid carcinoma, small cell, nonkeratinizing") )
        setattr(cls, "Acute myeloid leukemia, t(15:17)(g22;q11-12)",
                PermissibleValue(text="Acute myeloid leukemia, t(15:17)(g22;q11-12)") )
        setattr(cls, "Giant cell fibroblastoma",
                PermissibleValue(text="Giant cell fibroblastoma") )
        setattr(cls, "Seromucinous carcinoma",
                PermissibleValue(text="Seromucinous carcinoma",
                                 description="Ovarian Seromucinous Carcinoma") )
        setattr(cls, "Carcinoma with apocrine metaplasia",
                PermissibleValue(text="Carcinoma with apocrine metaplasia") )
        setattr(cls, "Dysplastic gangliocytoma of cerebellum (Lhermitte-Duclos)",
                PermissibleValue(text="Dysplastic gangliocytoma of cerebellum (Lhermitte-Duclos)") )
        setattr(cls, "Epithelioid hemangioma",
                PermissibleValue(text="Epithelioid hemangioma") )
        setattr(cls, "Atypical choroid plexus papilloma",
                PermissibleValue(text="Atypical choroid plexus papilloma") )
        setattr(cls, "Pigmented basal cell carcinoma",
                PermissibleValue(text="Pigmented basal cell carcinoma") )
        setattr(cls, "Follicular adenocarcinoma, trabecular",
                PermissibleValue(text="Follicular adenocarcinoma, trabecular") )
        setattr(cls, "Follicular lymphoma, NOS",
                PermissibleValue(text="Follicular lymphoma, NOS") )
        setattr(cls, "Peripheral T-cell lymphoma, AILD (Angioimmunoblastic Lymphadenopathy with Dysproteinemia)",
                PermissibleValue(text="Peripheral T-cell lymphoma, AILD (Angioimmunoblastic Lymphadenopathy with Dysproteinemia)") )
        setattr(cls, "Renal cell carcinoma, sarcomatoid",
                PermissibleValue(text="Renal cell carcinoma, sarcomatoid") )
        setattr(cls, "Juvenile carcinoma of breast",
                PermissibleValue(text="Juvenile carcinoma of breast") )
        setattr(cls, "Infiltrating duct carcinoma, NOS",
                PermissibleValue(text="Infiltrating duct carcinoma, NOS") )
        setattr(cls, "Acinar adenocarcinoma",
                PermissibleValue(text="Acinar adenocarcinoma") )
        setattr(cls, "Basal cell carcinoma, NOS",
                PermissibleValue(text="Basal cell carcinoma, NOS") )
        setattr(cls, "Thymoma, type B3, NOS",
                PermissibleValue(text="Thymoma, type B3, NOS") )
        setattr(cls, "Central neurocytoma",
                PermissibleValue(text="Central neurocytoma") )
        setattr(cls, "Cervical intraepithelial neoplasia, grade III",
                PermissibleValue(text="Cervical intraepithelial neoplasia, grade III") )
        setattr(cls, "Pleomorphic carcinoma",
                PermissibleValue(text="Pleomorphic carcinoma") )
        setattr(cls, "Acute myelofibrosis",
                PermissibleValue(text="Acute myelofibrosis") )
        setattr(cls, "Hodgkin lymphoma, nodular sclerosis, grade 1",
                PermissibleValue(text="Hodgkin lymphoma, nodular sclerosis, grade 1") )
        setattr(cls, "Nested urothelial carcinoma",
                PermissibleValue(text="Nested urothelial carcinoma") )
        setattr(cls, "Transient abnormal myelopoiesis",
                PermissibleValue(text="Transient abnormal myelopoiesis") )
        setattr(cls, "Synovioma, NOS",
                PermissibleValue(text="Synovioma, NOS") )
        setattr(cls, "Lymphoproliferative disease, NOS",
                PermissibleValue(text="Lymphoproliferative disease, NOS") )
        setattr(cls, "Chronic myelomonocytic leukemia, Type II",
                PermissibleValue(text="Chronic myelomonocytic leukemia, Type II") )
        setattr(cls, "Atypical proliferative papillary serous tumor",
                PermissibleValue(text="Atypical proliferative papillary serous tumor") )
        setattr(cls, "Squamous cell carcinoma in situ with questionable stromal invasion",
                PermissibleValue(text="Squamous cell carcinoma in situ with questionable stromal invasion") )
        setattr(cls, "Mucinous adenoma",
                PermissibleValue(text="Mucinous adenoma") )
        setattr(cls, "Ceruminous adenocarcinoma",
                PermissibleValue(text="Ceruminous adenocarcinoma") )
        setattr(cls, "Thymoma, cortical, NOS",
                PermissibleValue(text="Thymoma, cortical, NOS") )
        setattr(cls, "Acute promyelocytic leukemia, NOS",
                PermissibleValue(text="Acute promyelocytic leukemia, NOS") )
        setattr(cls, "Malignant tumor, giant cell type",
                PermissibleValue(text="Malignant tumor, giant cell type") )
        setattr(cls, "Malignant lymphoma, non-cleaved cell, NOS",
                PermissibleValue(text="Malignant lymphoma, non-cleaved cell, NOS") )
        setattr(cls, "Astrocytoma, NOS",
                PermissibleValue(text="Astrocytoma, NOS") )
        setattr(cls, "Dermatofibrosarcoma, NOS",
                PermissibleValue(text="Dermatofibrosarcoma, NOS") )
        setattr(cls, "Malignant hydatidiform mole",
                PermissibleValue(text="Malignant hydatidiform mole") )
        setattr(cls, "Aleukemic granulocytic leukemia",
                PermissibleValue(text="Aleukemic granulocytic leukemia") )
        setattr(cls, "Clear cell odontogenic tumor",
                PermissibleValue(text="Clear cell odontogenic tumor") )
        setattr(cls, "Mullerian adenosarcoma",
                PermissibleValue(text="Mullerian adenosarcoma") )
        setattr(cls, "Intraductal papillary-mucinous tumor with low grade dysplasia",
                PermissibleValue(text="Intraductal papillary-mucinous tumor with low grade dysplasia") )
        setattr(cls, "Colloid carcinoma",
                PermissibleValue(text="Colloid carcinoma") )
        setattr(cls, "Thymoma, mixed type, malignant",
                PermissibleValue(text="Thymoma, mixed type, malignant") )
        setattr(cls, "Nonencapsulated sclerosing carcinoma",
                PermissibleValue(text="Nonencapsulated sclerosing carcinoma") )
        setattr(cls, "Sertoli-Leydig cell tumor, poorly differentiated, with heterologous elements",
                PermissibleValue(text="Sertoli-Leydig cell tumor, poorly differentiated, with heterologous elements") )
        setattr(cls, "Round cell sarcoma",
                PermissibleValue(text="Round cell sarcoma") )
        setattr(cls, "Carcinoid, NOS, of appendix",
                PermissibleValue(text="Carcinoid, NOS, of appendix") )
        setattr(cls, "Hodgkin disease, nodular sclerosis, lymphocyte predominance",
                PermissibleValue(text="Hodgkin disease, nodular sclerosis, lymphocyte predominance") )
        setattr(cls, "Intraductal papillary carcinoma",
                PermissibleValue(text="Intraductal papillary carcinoma") )
        setattr(cls, "Papillary adenocarcinoma, follicular variant",
                PermissibleValue(text="Papillary adenocarcinoma, follicular variant") )
        setattr(cls, "Mixed acidophil-basophil carcinoma",
                PermissibleValue(text="Mixed acidophil-basophil carcinoma") )
        setattr(cls, "Carcinoma in situ in a polyp, NOS",
                PermissibleValue(text="Carcinoma in situ in a polyp, NOS") )
        setattr(cls, "Sinonasal papilloma, exophytic",
                PermissibleValue(text="Sinonasal papilloma, exophytic") )
        setattr(cls, "Nonchromaffin paraganglioma, malignant",
                PermissibleValue(text="Nonchromaffin paraganglioma, malignant") )
        setattr(cls, "Beta cell tumor, malignant",
                PermissibleValue(text="Beta cell tumor, malignant") )
        setattr(cls, "Microcystic meningioma",
                PermissibleValue(text="Microcystic meningioma") )
        setattr(cls, "Plasmacytoma of bone",
                PermissibleValue(text="Plasmacytoma of bone") )
        setattr(cls, "Malignant mast cell tumor",
                PermissibleValue(text="Malignant mast cell tumor") )
        setattr(cls, "Ameloblastic fibrosarcoma",
                PermissibleValue(text="Ameloblastic fibrosarcoma") )
        setattr(cls, "Tumor, metastatic",
                PermissibleValue(text="Tumor, metastatic") )
        setattr(cls, "Endometrioid adenocarcinoma, villoglandular",
                PermissibleValue(text="Endometrioid adenocarcinoma, villoglandular") )
        setattr(cls, "Giant cell and spindle cell carcinoma",
                PermissibleValue(text="Giant cell and spindle cell carcinoma") )
        setattr(cls, "Mesonephroma, benign",
                PermissibleValue(text="Mesonephroma, benign") )
        setattr(cls, "Refractory anemia with excess blasts",
                PermissibleValue(text="Refractory anemia with excess blasts") )
        setattr(cls, "Thymoma, type A, malignant",
                PermissibleValue(text="Thymoma, type A, malignant") )
        setattr(cls, "Acute myeloid leukemia (megakaryoblastic) with t(1;22)(p13;q13); RBM15-MKL1",
                PermissibleValue(text="Acute myeloid leukemia (megakaryoblastic) with t(1;22)(p13;q13); RBM15-MKL1") )
        setattr(cls, "Bile duct adenocarcinoma",
                PermissibleValue(text="Bile duct adenocarcinoma") )
        setattr(cls, "Mixed tumor, NOS",
                PermissibleValue(text="Mixed tumor, NOS") )
        setattr(cls, "Myeloma, NOS",
                PermissibleValue(text="Myeloma, NOS") )
        setattr(cls, "Papillary hidradenoma",
                PermissibleValue(text="Papillary hidradenoma") )
        setattr(cls, "Malignant lymphoma, histiocytic, NOS",
                PermissibleValue(text="Malignant lymphoma, histiocytic, NOS") )
        setattr(cls, "Epithelial-myoepithelial carcinoma",
                PermissibleValue(text="Epithelial-myoepithelial carcinoma",
                                 description="Epithelial-Myoepithelial Carcinoma") )
        setattr(cls, "Queyrat erythroplasia",
                PermissibleValue(text="Queyrat erythroplasia") )
        setattr(cls, "Pancreatobiliary neoplasm, non-invasive",
                PermissibleValue(text="Pancreatobiliary neoplasm, non-invasive") )
        setattr(cls, "Acute lymphoblastic leukemia, L2 type, NOS",
                PermissibleValue(text="Acute lymphoblastic leukemia, L2 type, NOS") )
        setattr(cls, "Hodgkin lymphoma, lymphocyte predominance, nodular",
                PermissibleValue(text="Hodgkin lymphoma, lymphocyte predominance, nodular") )
        setattr(cls, "Malignant fibrous histiocytoma",
                PermissibleValue(text="Malignant fibrous histiocytoma") )
        setattr(cls, "Undifferentiated round cell sarcoma",
                PermissibleValue(text="Undifferentiated round cell sarcoma") )
        setattr(cls, "Malignant lymphoma, mixed lymphocytic-histiocytic, nodular",
                PermissibleValue(text="Malignant lymphoma, mixed lymphocytic-histiocytic, nodular") )
        setattr(cls, "Botryoid sarcoma",
                PermissibleValue(text="Botryoid sarcoma") )
        setattr(cls, "Letterer-Siwe disease",
                PermissibleValue(text="Letterer-Siwe disease") )
        setattr(cls, "Lymphoproliferative disorder, NOS",
                PermissibleValue(text="Lymphoproliferative disorder, NOS") )
        setattr(cls, "Seminoma, anaplastic",
                PermissibleValue(text="Seminoma, anaplastic") )
        setattr(cls, "Encapsulated papillary carcinoma",
                PermissibleValue(text="Encapsulated papillary carcinoma") )
        setattr(cls, "Transitional cell papilloma, benign",
                PermissibleValue(text="Transitional cell papilloma, benign") )
        setattr(cls, "Urothelial carcinoma, NOS",
                PermissibleValue(text="Urothelial carcinoma, NOS") )
        setattr(cls, "Metanephric adenoma",
                PermissibleValue(text="Metanephric adenoma") )
        setattr(cls, "Congenital generalized fibromatosis",
                PermissibleValue(text="Congenital generalized fibromatosis") )
        setattr(cls, "Primary cutaneous follicle centre lymphoma",
                PermissibleValue(text="Primary cutaneous follicle centre lymphoma") )
        setattr(cls, "Trabecular adenoma",
                PermissibleValue(text="Trabecular adenoma") )
        setattr(cls, "Chronic lymphoproliferative disorder of NK cells",
                PermissibleValue(text="Chronic lymphoproliferative disorder of NK cells") )
        setattr(cls, "Soft tissue tumor, benign",
                PermissibleValue(text="Soft tissue tumor, benign") )
        setattr(cls, "Melanocytoma, eyeball",
                PermissibleValue(text="Melanocytoma, eyeball") )
        setattr(cls, "Ductal carcinoma, cribriform type",
                PermissibleValue(text="Ductal carcinoma, cribriform type") )
        setattr(cls, "Dabska tumor",
                PermissibleValue(text="Dabska tumor") )
        setattr(cls, "FAB M4",
                PermissibleValue(text="FAB M4") )
        setattr(cls, "Classical Hodgkin lymphoma, nodular sclerosis, NOS",
                PermissibleValue(text="Classical Hodgkin lymphoma, nodular sclerosis, NOS") )
        setattr(cls, "Myelomonocytic leukemia, NOS",
                PermissibleValue(text="Myelomonocytic leukemia, NOS") )
        setattr(cls, "Dendritic cell sarcoma, NOS",
                PermissibleValue(text="Dendritic cell sarcoma, NOS") )
        setattr(cls, "Carcinoma in a polyp, NOS",
                PermissibleValue(text="Carcinoma in a polyp, NOS") )
        setattr(cls, "Lymphangioendothelioma, NOS",
                PermissibleValue(text="Lymphangioendothelioma, NOS") )
        setattr(cls, "Parietal cell adenocarcinoma",
                PermissibleValue(text="Parietal cell adenocarcinoma") )
        setattr(cls, "Intraductal adenocarcinoma, noninfiltrating, NOS",
                PermissibleValue(text="Intraductal adenocarcinoma, noninfiltrating, NOS") )
        setattr(cls, "Malignant melanoma in Hutchinson melanotic freckle",
                PermissibleValue(text="Malignant melanoma in Hutchinson melanotic freckle") )
        setattr(cls, "Dermoid cyst with secondary tumor",
                PermissibleValue(text="Dermoid cyst with secondary tumor") )
        setattr(cls, "Peripheral T-cell lymphoma, NOS",
                PermissibleValue(text="Peripheral T-cell lymphoma, NOS") )
        setattr(cls, "T-cell rich/histiocyte-rich large B-cell lymphoma",
                PermissibleValue(text="T-cell rich/histiocyte-rich large B-cell lymphoma") )
        setattr(cls, "Nonchromaffin paraganglioma, NOS",
                PermissibleValue(text="Nonchromaffin paraganglioma, NOS") )
        setattr(cls, "Chondromyxoid fibroma",
                PermissibleValue(text="Chondromyxoid fibroma") )
        setattr(cls, "Diffuse astrocytoma",
                PermissibleValue(text="Diffuse astrocytoma") )
        setattr(cls, "Adenocarcinoma in situ in a polyp, NOS",
                PermissibleValue(text="Adenocarcinoma in situ in a polyp, NOS") )
        setattr(cls, "Stromal myosis, NOS",
                PermissibleValue(text="Stromal myosis, NOS") )
        setattr(cls, "Thymoma, type AB, malignant",
                PermissibleValue(text="Thymoma, type AB, malignant") )
        setattr(cls, "Pulmonary artery intimal sarcoma",
                PermissibleValue(text="Pulmonary artery intimal sarcoma") )
        setattr(cls, "Diffuse melanocytosis",
                PermissibleValue(text="Diffuse melanocytosis") )
        setattr(cls, "Serous papillary cystic tumor of borderline malignancy",
                PermissibleValue(text="Serous papillary cystic tumor of borderline malignancy") )
        setattr(cls, "Hodgkin lymphoma, lymphocyte depletion, diffuse fibrosis",
                PermissibleValue(text="Hodgkin lymphoma, lymphocyte depletion, diffuse fibrosis") )
        setattr(cls, "Bowen disease",
                PermissibleValue(text="Bowen disease") )
        setattr(cls, "Cystic mesothelioma, benign",
                PermissibleValue(text="Cystic mesothelioma, benign") )
        setattr(cls, "Chromophobe carcinoma",
                PermissibleValue(text="Chromophobe carcinoma") )
        setattr(cls, "Therapy-related acute myeloid leukemia, NOS",
                PermissibleValue(text="Therapy-related acute myeloid leukemia, NOS") )
        setattr(cls, "Wolffian duct carcinoma",
                PermissibleValue(text="Wolffian duct carcinoma") )
        setattr(cls, "Anal intraepithelial neoplasia, grade III",
                PermissibleValue(text="Anal intraepithelial neoplasia, grade III") )
        setattr(cls, "Langerhans cell granulomatosis",
                PermissibleValue(text="Langerhans cell granulomatosis") )
        setattr(cls, "Epidermoid carcinoma, large cell, nonkeratinizing",
                PermissibleValue(text="Epidermoid carcinoma, large cell, nonkeratinizing") )
        setattr(cls, "Paget disease, extramammary",
                PermissibleValue(text="Paget disease, extramammary") )
        setattr(cls, "Nephroblastoma, NOS",
                PermissibleValue(text="Nephroblastoma, NOS") )
        setattr(cls, "Thymic carcinoma with adenoid cystic carcinoma-like features",
                PermissibleValue(text="Thymic carcinoma with adenoid cystic carcinoma-like features") )
        setattr(cls, "Fibroblastic meningioma",
                PermissibleValue(text="Fibroblastic meningioma") )
        setattr(cls, "Tumorlet, NOS",
                PermissibleValue(text="Tumorlet, NOS") )
        setattr(cls, "Carcinoma with productive fibrosis",
                PermissibleValue(text="Carcinoma with productive fibrosis") )
        setattr(cls, "Thymoma, medullary, NOS",
                PermissibleValue(text="Thymoma, medullary, NOS") )
        setattr(cls, "Intraductal carcinoma, NOS",
                PermissibleValue(text="Intraductal carcinoma, NOS") )
        setattr(cls, "FAB M2, NOS",
                PermissibleValue(text="FAB M2, NOS") )
        setattr(cls, "Duct carcinoma, NOS",
                PermissibleValue(text="Duct carcinoma, NOS") )
        setattr(cls, "Acute myeloid leukemia, t(16;16)(p 13;q 11)",
                PermissibleValue(text="Acute myeloid leukemia, t(16;16)(p 13;q 11)") )
        setattr(cls, "Dermatofibroma lenticulare",
                PermissibleValue(text="Dermatofibroma lenticulare") )
        setattr(cls, "Adrenal cortical adenoma, compact cell",
                PermissibleValue(text="Adrenal cortical adenoma, compact cell") )
        setattr(cls, "Primary cutaneous DLBCL, leg type",
                PermissibleValue(text="Primary cutaneous DLBCL, leg type") )
        setattr(cls, "Intraneural perineurioma",
                PermissibleValue(text="Intraneural perineurioma") )
        setattr(cls, "Malignant lymphoma, large cell, noncleaved, NOS",
                PermissibleValue(text="Malignant lymphoma, large cell, noncleaved, NOS") )
        setattr(cls, "Subacute monocytic leukemia",
                PermissibleValue(text="Subacute monocytic leukemia") )
        setattr(cls, "Eccrine acrospiroma",
                PermissibleValue(text="Eccrine acrospiroma") )
        setattr(cls, "Leydig cell tumor, malignant",
                PermissibleValue(text="Leydig cell tumor, malignant") )
        setattr(cls, "Astrocytic glioma",
                PermissibleValue(text="Astrocytic glioma") )
        setattr(cls, "Atypical leiomyoma",
                PermissibleValue(text="Atypical leiomyoma") )
        setattr(cls, "Warthin tumor",
                PermissibleValue(text="Warthin tumor") )
        setattr(cls, "Meningothelial sarcoma",
                PermissibleValue(text="Meningothelial sarcoma") )
        setattr(cls, "Acute myelosclerosis, NOS",
                PermissibleValue(text="Acute myelosclerosis, NOS") )
        setattr(cls, "Fetal lipoma, NOS",
                PermissibleValue(text="Fetal lipoma, NOS") )
        setattr(cls, "Mucinous cystic tumor of borderline malignancy",
                PermissibleValue(text="Mucinous cystic tumor of borderline malignancy") )
        setattr(cls, "Adenomatosis, NOS",
                PermissibleValue(text="Adenomatosis, NOS") )
        setattr(cls, "Chronic myelogenous leukemia, Philadelphia chromosome (Ph 1) positive",
                PermissibleValue(text="Chronic myelogenous leukemia, Philadelphia chromosome (Ph 1) positive") )
        setattr(cls, "Langerhans cell histiocytosis, NOS",
                PermissibleValue(text="Langerhans cell histiocytosis, NOS") )
        setattr(cls, "Wolffian duct adenoma",
                PermissibleValue(text="Wolffian duct adenoma") )
        setattr(cls, "Thymoma, NOS",
                PermissibleValue(text="Thymoma, NOS") )
        setattr(cls, "Mucoid cell adenoma",
                PermissibleValue(text="Mucoid cell adenoma") )
        setattr(cls, "FAB M4Eo",
                PermissibleValue(text="FAB M4Eo") )
        setattr(cls, "Squamous cell carcinoma, large cell, keratinizing",
                PermissibleValue(text="Squamous cell carcinoma, large cell, keratinizing") )
        setattr(cls, "Papillomatosis, NOS",
                PermissibleValue(text="Papillomatosis, NOS") )
        setattr(cls, "Epithelioma, benign",
                PermissibleValue(text="Epithelioma, benign") )
        setattr(cls, "Trabecular adenocarcinoma",
                PermissibleValue(text="Trabecular adenocarcinoma") )
        setattr(cls, "Schneiderian papilloma, NOS",
                PermissibleValue(text="Schneiderian papilloma, NOS") )
        setattr(cls, "Ameloblastic fibroma",
                PermissibleValue(text="Ameloblastic fibroma") )
        setattr(cls, "Adenocarcinoma in situ, NOS",
                PermissibleValue(text="Adenocarcinoma in situ, NOS") )
        setattr(cls, "Leydig cell tumor, benign",
                PermissibleValue(text="Leydig cell tumor, benign") )
        setattr(cls, "Refractory anemia",
                PermissibleValue(text="Refractory anemia") )
        setattr(cls, "Brenner tumor, NOS",
                PermissibleValue(text="Brenner tumor, NOS") )
        setattr(cls, "Lymphoblastic leukemia, NOS",
                PermissibleValue(text="Lymphoblastic leukemia, NOS") )
        setattr(cls, "Spongioblastoma, NOS",
                PermissibleValue(text="Spongioblastoma, NOS") )
        setattr(cls, "Eosinophilic granuloma",
                PermissibleValue(text="Eosinophilic granuloma") )
        setattr(cls, "Spindle cell oncocytoma",
                PermissibleValue(text="Spindle cell oncocytoma") )
        setattr(cls, "Periosteal fibroma",
                PermissibleValue(text="Periosteal fibroma") )
        setattr(cls, "Rhabdoid sarcoma",
                PermissibleValue(text="Rhabdoid sarcoma") )
        setattr(cls, "Large cell medulloblastoma",
                PermissibleValue(text="Large cell medulloblastoma") )
        setattr(cls, "Aleukemic lymphoid leukemia",
                PermissibleValue(text="Aleukemic lymphoid leukemia") )
        setattr(cls, "Cyst-associated renal cell carcinoma",
                PermissibleValue(text="Cyst-associated renal cell carcinoma") )
        setattr(cls, "Malignant lymphomatous polyposis",
                PermissibleValue(text="Malignant lymphomatous polyposis") )
        setattr(cls, "Pilomatricoma, malignant",
                PermissibleValue(text="Pilomatricoma, malignant") )
        setattr(cls, "Medulloblastoma, SHH-activated and TP53-wildtype",
                PermissibleValue(text="Medulloblastoma, SHH-activated and TP53-wildtype") )
        setattr(cls, "Intracystic papillary tumor with high grade entraepithelial neoplasia",
                PermissibleValue(text="Intracystic papillary tumor with high grade entraepithelial neoplasia") )
        setattr(cls, "Chronic lymphocytic leukemia",
                PermissibleValue(text="Chronic lymphocytic leukemia") )
        setattr(cls, "Fibrous astrocytoma",
                PermissibleValue(text="Fibrous astrocytoma") )
        setattr(cls, "Follicular dendritic cell sarcoma",
                PermissibleValue(text="Follicular dendritic cell sarcoma") )
        setattr(cls, "Carcinoma, anaplastic, NOS",
                PermissibleValue(text="Carcinoma, anaplastic, NOS") )
        setattr(cls, "Magnocellular nevus",
                PermissibleValue(text="Magnocellular nevus") )
        setattr(cls, "Non-lymphocytic leukemia, NOS",
                PermissibleValue(text="Non-lymphocytic leukemia, NOS") )
        setattr(cls, "Malignant lymphoma, large cell, cleaved, NOS",
                PermissibleValue(text="Malignant lymphoma, large cell, cleaved, NOS") )
        setattr(cls, "Flat intraepithelial neoplasia, high grade",
                PermissibleValue(text="Flat intraepithelial neoplasia, high grade") )
        setattr(cls, "Thymoma, type AB, NOS",
                PermissibleValue(text="Thymoma, type AB, NOS") )
        setattr(cls, "Thymoma, lymphocytic, NOS",
                PermissibleValue(text="Thymoma, lymphocytic, NOS") )
        setattr(cls, "Neurogenic sarcoma",
                PermissibleValue(text="Neurogenic sarcoma") )
        setattr(cls, "Aleukemic monocytic leukemia",
                PermissibleValue(text="Aleukemic monocytic leukemia") )
        setattr(cls, "GIST, malignant",
                PermissibleValue(text="GIST, malignant") )
        setattr(cls, "Low-grade serous carcinoma",
                PermissibleValue(text="Low-grade serous carcinoma") )
        setattr(cls, "Polypoid adenoma",
                PermissibleValue(text="Polypoid adenoma") )
        setattr(cls, "Regressing nevus",
                PermissibleValue(text="Regressing nevus") )
        setattr(cls, "Sebaceous carcinoma",
                PermissibleValue(text="Sebaceous carcinoma") )
        setattr(cls, "Melanoma in situ",
                PermissibleValue(text="Melanoma in situ") )
        setattr(cls, "Melanotic neurofibroma",
                PermissibleValue(text="Melanotic neurofibroma") )
        setattr(cls, "Tubular androblastoma with lipid storage",
                PermissibleValue(text="Tubular androblastoma with lipid storage") )
        setattr(cls, "Squamous cell carcinoma, spindle cell",
                PermissibleValue(text="Squamous cell carcinoma, spindle cell") )
        setattr(cls, "Sarcomatosis, NOS",
                PermissibleValue(text="Sarcomatosis, NOS") )
        setattr(cls, "Adamantinoma, NOS",
                PermissibleValue(text="Adamantinoma, NOS") )
        setattr(cls, "Compound nevus",
                PermissibleValue(text="Compound nevus") )
        setattr(cls, "Clear cell adenofibroma",
                PermissibleValue(text="Clear cell adenofibroma") )
        setattr(cls, "Round cell liposarcoma",
                PermissibleValue(text="Round cell liposarcoma") )
        setattr(cls, "Sertoli cell tumor with lipid storage",
                PermissibleValue(text="Sertoli cell tumor with lipid storage") )
        setattr(cls, "Nodular hidradenoma",
                PermissibleValue(text="Nodular hidradenoma") )
        setattr(cls, "Carcinoma with neuroendocrine differentiation",
                PermissibleValue(text="Carcinoma with neuroendocrine differentiation") )
        setattr(cls, "Malignant tumor, small cell type",
                PermissibleValue(text="Malignant tumor, small cell type") )
        setattr(cls, "Pleomorphic lobular carcinoma in situ",
                PermissibleValue(text="Pleomorphic lobular carcinoma in situ") )
        setattr(cls, "Villoglandular carcinoma",
                PermissibleValue(text="Villoglandular carcinoma") )
        setattr(cls, "Acinic cell adenocarcinoma",
                PermissibleValue(text="Acinic cell adenocarcinoma") )
        setattr(cls, "Verrucous keratotic hemangioma",
                PermissibleValue(text="Verrucous keratotic hemangioma") )
        setattr(cls, "Spindle cell melanoma, NOS",
                PermissibleValue(text="Spindle cell melanoma, NOS") )
        setattr(cls, "Angioma, NOS",
                PermissibleValue(text="Angioma, NOS") )
        setattr(cls, "Unclassified tumor, malignant",
                PermissibleValue(text="Unclassified tumor, malignant") )
        setattr(cls, "Phyllodes tumor, malignant",
                PermissibleValue(text="Phyllodes tumor, malignant") )
        setattr(cls, "Gastrin cell tumor, malignant",
                PermissibleValue(text="Gastrin cell tumor, malignant") )
        setattr(cls, "Intraductal papillary-mucinous tumor with intermediate dysplasia",
                PermissibleValue(text="Intraductal papillary-mucinous tumor with intermediate dysplasia") )
        setattr(cls, "Solid carcinoma, NOS",
                PermissibleValue(text="Solid carcinoma, NOS") )
        setattr(cls, "Squamous carcinoma",
                PermissibleValue(text="Squamous carcinoma") )
        setattr(cls, "Systemic mastocytosis with AHNMD",
                PermissibleValue(text="Systemic mastocytosis with AHNMD") )
        setattr(cls, "Synovioma, malignant",
                PermissibleValue(text="Synovioma, malignant") )
        setattr(cls, "Rhabdomyoma, NOS",
                PermissibleValue(text="Rhabdomyoma, NOS") )
        setattr(cls, "Epithelioid cell nevus",
                PermissibleValue(text="Epithelioid cell nevus") )
        setattr(cls, "Embryonal rhabdomyosarcoma, pleomorphic",
                PermissibleValue(text="Embryonal rhabdomyosarcoma, pleomorphic") )
        setattr(cls, "Mixed phenotype acute leukemia, T/myeloid, NOS",
                PermissibleValue(text="Mixed phenotype acute leukemia, T/myeloid, NOS") )
        setattr(cls, "Sweat gland tumor, malignant",
                PermissibleValue(text="Sweat gland tumor, malignant") )
        setattr(cls, "Parietal cell carcinoma",
                PermissibleValue(text="Parietal cell carcinoma") )
        setattr(cls, "Lymphangioendothelial sarcoma",
                PermissibleValue(text="Lymphangioendothelial sarcoma") )
        setattr(cls, "Inflammatory liposarcoma",
                PermissibleValue(text="Inflammatory liposarcoma") )
        setattr(cls, "Myofibroblastic tumor, NOS",
                PermissibleValue(text="Myofibroblastic tumor, NOS") )
        setattr(cls, "Endometrioid cystadenofibroma, malignant",
                PermissibleValue(text="Endometrioid cystadenofibroma, malignant") )
        setattr(cls, "Hemangioblastic meningioma",
                PermissibleValue(text="Hemangioblastic meningioma") )
        setattr(cls, "Adenomatous polyposis coli",
                PermissibleValue(text="Adenomatous polyposis coli") )
        setattr(cls, "Adenocarcinoma with squamous metaplasia",
                PermissibleValue(text="Adenocarcinoma with squamous metaplasia") )
        setattr(cls, "Renal cell carcinoma, NOS",
                PermissibleValue(text="Renal cell carcinoma, NOS") )
        setattr(cls, "Malignant lymphoma, undifferentiated cell type, NOS",
                PermissibleValue(text="Malignant lymphoma, undifferentiated cell type, NOS") )
        setattr(cls, "Malignant lymphoma, cleaved cell, NOS",
                PermissibleValue(text="Malignant lymphoma, cleaved cell, NOS") )
        setattr(cls, "Papillary serous cystadenocarcinoma",
                PermissibleValue(text="Papillary serous cystadenocarcinoma") )
        setattr(cls, "FAB M7",
                PermissibleValue(text="FAB M7") )
        setattr(cls, "Adenocarcinoma with mixed subtypes",
                PermissibleValue(text="Adenocarcinoma with mixed subtypes") )
        setattr(cls, "Myeloid and lymphoid neoplasms with FGFR1 abnormalities",
                PermissibleValue(text="Myeloid and lymphoid neoplasms with FGFR1 abnormalities") )
        setattr(cls, "Malignant lymphoma, noncleaved, NOS",
                PermissibleValue(text="Malignant lymphoma, noncleaved, NOS") )
        setattr(cls, "Subacute leukemia, NOS",
                PermissibleValue(text="Subacute leukemia, NOS") )
        setattr(cls, "Angiomatous meningioma",
                PermissibleValue(text="Angiomatous meningioma") )
        setattr(cls, "Preleukemic syndrome",
                PermissibleValue(text="Preleukemic syndrome") )
        setattr(cls, "Giant cell angiofibroma",
                PermissibleValue(text="Giant cell angiofibroma") )
        setattr(cls, "Dysembryoplastic neuroepithelial tumor",
                PermissibleValue(text="Dysembryoplastic neuroepithelial tumor") )
        setattr(cls, "Interdigitating dendritic cell sarcoma",
                PermissibleValue(text="Interdigitating dendritic cell sarcoma") )
        setattr(cls, "Mucous adenocarcinoma",
                PermissibleValue(text="Mucous adenocarcinoma") )
        setattr(cls, "Melanotic MPNST",
                PermissibleValue(text="Melanotic MPNST") )
        setattr(cls, "Biliary intraepithelial neoplasia, grade 3",
                PermissibleValue(text="Biliary intraepithelial neoplasia, grade 3") )
        setattr(cls, "Angioimmunoblastic T-cell lymphoma",
                PermissibleValue(text="Angioimmunoblastic T-cell lymphoma") )
        setattr(cls, "Lymphoma, NOS",
                PermissibleValue(text="Lymphoma, NOS") )
        setattr(cls, "Juvenile astrocytoma",
                PermissibleValue(text="Juvenile astrocytoma") )
        setattr(cls, "Atypical meningioma",
                PermissibleValue(text="Atypical meningioma") )
        setattr(cls, "Acute myeloid leukemia without maturation",
                PermissibleValue(text="Acute myeloid leukemia without maturation") )
        setattr(cls, "Urachal carcinoma",
                PermissibleValue(text="Urachal carcinoma") )
        setattr(cls, "Chronic myelogenous leukemia, t(9;22)(q34;q11)",
                PermissibleValue(text="Chronic myelogenous leukemia, t(9;22)(q34;q11)") )
        setattr(cls, "Metaplastic meningioma",
                PermissibleValue(text="Metaplastic meningioma") )
        setattr(cls, "Papillocystic adenocarcinoma",
                PermissibleValue(text="Papillocystic adenocarcinoma") )
        setattr(cls, "Oligodendroglioma, IDH-mutant and 1p/19q-codeleted",
                PermissibleValue(text="Oligodendroglioma, IDH-mutant and 1p/19q-codeleted") )
        setattr(cls, "Malignant lymphoma, small cleaved cell, diffuse",
                PermissibleValue(text="Malignant lymphoma, small cleaved cell, diffuse") )
        setattr(cls, "Secondary carcinoma",
                PermissibleValue(text="Secondary carcinoma") )
        setattr(cls, "Papillary syringocystadenoma",
                PermissibleValue(text="Papillary syringocystadenoma") )
        setattr(cls, "Myeloproliferative disease, NOS",
                PermissibleValue(text="Myeloproliferative disease, NOS") )
        setattr(cls, "Malignant perivascular epithelial cell tumor",
                PermissibleValue(text="Malignant perivascular epithelial cell tumor") )
        setattr(cls, "Brenner tumor, borderline malignancy",
                PermissibleValue(text="Brenner tumor, borderline malignancy") )
        setattr(cls, "Synovial sarcoma, monophasic fibrous",
                PermissibleValue(text="Synovial sarcoma, monophasic fibrous") )
        setattr(cls, "Lactating adenoma",
                PermissibleValue(text="Lactating adenoma") )
        setattr(cls, "Papillary carcinoma, columnar cell",
                PermissibleValue(text="Papillary carcinoma, columnar cell") )
        setattr(cls, "Atypical chronic myeloid leukemia, Philadelphia chromosome (Ph1) negative",
                PermissibleValue(text="Atypical chronic myeloid leukemia, Philadelphia chromosome (Ph1) negative") )
        setattr(cls, "Small cell neuroendocrine carcinoma",
                PermissibleValue(text="Small cell neuroendocrine carcinoma",
                                 description="Colorectal Small Cell Neuroendocrine Carcinoma") )
        setattr(cls, "FAB L3",
                PermissibleValue(text="FAB L3") )
        setattr(cls, "Turban tumor",
                PermissibleValue(text="Turban tumor") )
        setattr(cls, "Chronic granulocytic leukemia, Philadelphia chromosome (Ph1) positive",
                PermissibleValue(text="Chronic granulocytic leukemia, Philadelphia chromosome (Ph1) positive") )
        setattr(cls, "Odontogenic fibroma, NOS",
                PermissibleValue(text="Odontogenic fibroma, NOS") )
        setattr(cls, "Tubular adenoma, NOS",
                PermissibleValue(text="Tubular adenoma, NOS") )
        setattr(cls, "Infiltrating lobular mixed with other types of carcinoma",
                PermissibleValue(text="Infiltrating lobular mixed with other types of carcinoma") )
        setattr(cls, "Noninfiltrating intraductal papillary carcinoma",
                PermissibleValue(text="Noninfiltrating intraductal papillary carcinoma") )
        setattr(cls, "Subepidermal nodular fibrosis",
                PermissibleValue(text="Subepidermal nodular fibrosis") )
        setattr(cls, "Thymoma, atypical, NOS",
                PermissibleValue(text="Thymoma, atypical, NOS") )
        setattr(cls, "DCIS, comedo type",
                PermissibleValue(text="DCIS, comedo type") )
        setattr(cls, "Serous adenofibroma, NOS",
                PermissibleValue(text="Serous adenofibroma, NOS") )
        setattr(cls, "FAB MO",
                PermissibleValue(text="FAB MO") )
        setattr(cls, "Papillary mucinous tumor of low malignant potential",
                PermissibleValue(text="Papillary mucinous tumor of low malignant potential") )
        setattr(cls, "Mesenchymoma, malignant",
                PermissibleValue(text="Mesenchymoma, malignant") )
        setattr(cls, "Adrenal rest tumor",
                PermissibleValue(text="Adrenal rest tumor") )
        setattr(cls, "Endometrioid cystadenocarcinoma",
                PermissibleValue(text="Endometrioid cystadenocarcinoma") )
        setattr(cls, "Sinonasal papilloma, NOS",
                PermissibleValue(text="Sinonasal papilloma, NOS") )
        setattr(cls, "Mucinous cystic neoplasm with low-grade dysplasia",
                PermissibleValue(text="Mucinous cystic neoplasm with low-grade dysplasia") )
        setattr(cls, "Follicular dendritic cell tumor",
                PermissibleValue(text="Follicular dendritic cell tumor") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma with t(1;19)(q23;p13.3); E2A-PBX1 (TCF3-PBX1)",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma with t(1;19)(q23;p13.3); E2A-PBX1 (TCF3-PBX1)") )
        setattr(cls, "Cribriform comedo-type carcinoma",
                PermissibleValue(text="Cribriform comedo-type carcinoma") )
        setattr(cls, "Capillary lymphangioma",
                PermissibleValue(text="Capillary lymphangioma") )
        setattr(cls, "Desmoid, NOS",
                PermissibleValue(text="Desmoid, NOS") )
        setattr(cls, "Nodular melanoma",
                PermissibleValue(text="Nodular melanoma",
                                 description="Nodular Melanoma") )
        setattr(cls, "Endometrioid adenocarcinoma, ciliated cell variant",
                PermissibleValue(text="Endometrioid adenocarcinoma, ciliated cell variant") )
        setattr(cls, "Acute monoblastic leukemia",
                PermissibleValue(text="Acute monoblastic leukemia") )
        setattr(cls, "Olfactory neuroepithelioma",
                PermissibleValue(text="Olfactory neuroepithelioma") )
        setattr(cls, "Angioimmunoblastic lymphoma",
                PermissibleValue(text="Angioimmunoblastic lymphoma") )
        setattr(cls, "Cervical intraepithelial neoplasia, low grade",
                PermissibleValue(text="Cervical intraepithelial neoplasia, low grade") )
        setattr(cls, "Mesenteric fibromatosis",
                PermissibleValue(text="Mesenteric fibromatosis") )
        setattr(cls, "Plexiform neuroma",
                PermissibleValue(text="Plexiform neuroma") )
        setattr(cls, "Reticulosarcoma, NOS",
                PermissibleValue(text="Reticulosarcoma, NOS") )
        setattr(cls, "Mastocytoma, NOS",
                PermissibleValue(text="Mastocytoma, NOS") )
        setattr(cls, "Melanoma, malignant, of soft parts",
                PermissibleValue(text="Melanoma, malignant, of soft parts") )
        setattr(cls, "Refractory cytopenia of childhood",
                PermissibleValue(text="Refractory cytopenia of childhood") )
        setattr(cls, "Malignant melanoma in precancerous melanosis",
                PermissibleValue(text="Malignant melanoma in precancerous melanosis") )
        setattr(cls, "Hidradenoma papilliferum",
                PermissibleValue(text="Hidradenoma papilliferum") )
        setattr(cls, "Infiltrating basal cell carcinoma, NOS",
                PermissibleValue(text="Infiltrating basal cell carcinoma, NOS") )
        setattr(cls, "Endometrioid adenocarcinoma, secretory variant",
                PermissibleValue(text="Endometrioid adenocarcinoma, secretory variant") )
        setattr(cls, "B cell lymphoma, NOS",
                PermissibleValue(text="B cell lymphoma, NOS") )
        setattr(cls, "Immature teratoma, malignant",
                PermissibleValue(text="Immature teratoma, malignant") )
        setattr(cls, "Tumorlet, benign",
                PermissibleValue(text="Tumorlet, benign") )
        setattr(cls, "Soft tissue tumor, malignant",
                PermissibleValue(text="Soft tissue tumor, malignant") )
        setattr(cls, "Adamantinoma, malignant",
                PermissibleValue(text="Adamantinoma, malignant") )
        setattr(cls, "Inflammatory carcinoma",
                PermissibleValue(text="Inflammatory carcinoma") )
        setattr(cls, "Precursor T-cell lymphoblastic leukemia",
                PermissibleValue(text="Precursor T-cell lymphoblastic leukemia") )
        setattr(cls, "Testicular adenoma",
                PermissibleValue(text="Testicular adenoma") )
        setattr(cls, "Basaloid squamous cell carcinoma",
                PermissibleValue(text="Basaloid squamous cell carcinoma",
                                 description="Basaloid Squamous Cell Carcinoma") )
        setattr(cls, "Solitary fibrous tumor, malignant",
                PermissibleValue(text="Solitary fibrous tumor, malignant") )
        setattr(cls, "Carcinoma in situ, NOS",
                PermissibleValue(text="Carcinoma in situ, NOS") )
        setattr(cls, "Invasive lobular carcinoma, alveolar type",
                PermissibleValue(text="Invasive lobular carcinoma, alveolar type") )
        setattr(cls, "Warty carcinoma",
                PermissibleValue(text="Warty carcinoma") )
        setattr(cls, "Acidophil carcinoma",
                PermissibleValue(text="Acidophil carcinoma") )
        setattr(cls, "Low-grade myofibroblastic sarcoma",
                PermissibleValue(text="Low-grade myofibroblastic sarcoma") )
        setattr(cls, "Sex cord-gonadal stromal tumor, incompletely differentiated",
                PermissibleValue(text="Sex cord-gonadal stromal tumor, incompletely differentiated") )
        setattr(cls, "Fibro-osteoma",
                PermissibleValue(text="Fibro-osteoma") )
        setattr(cls, "Dermatofibrosarcoma protuberans, NOS",
                PermissibleValue(text="Dermatofibrosarcoma protuberans, NOS") )
        setattr(cls, "Ameloblastic odontosarcoma",
                PermissibleValue(text="Ameloblastic odontosarcoma") )
        setattr(cls, "Androblastoma, malignant",
                PermissibleValue(text="Androblastoma, malignant") )
        setattr(cls, "Acute myeloid leukemia with multilineage dysplasia",
                PermissibleValue(text="Acute myeloid leukemia with multilineage dysplasia") )
        setattr(cls, "Acute myelomonocytic leukemia with abnormal eosinophils",
                PermissibleValue(text="Acute myelomonocytic leukemia with abnormal eosinophils") )
        setattr(cls, "Intraductal carcinoma, clinging",
                PermissibleValue(text="Intraductal carcinoma, clinging") )
        setattr(cls, "Malignant lymphoma, lymphocytic, well differentiated, nodular",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, well differentiated, nodular") )
        setattr(cls, "Partial hydatidiform mole",
                PermissibleValue(text="Partial hydatidiform mole") )
        setattr(cls, "Blastic plasmacytoid dendritic cell neoplasm",
                PermissibleValue(text="Blastic plasmacytoid dendritic cell neoplasm") )
        setattr(cls, "Follicular carcinoma, well differentiated",
                PermissibleValue(text="Follicular carcinoma, well differentiated") )
        setattr(cls, "Malignant lymphoma, plasmacytoid",
                PermissibleValue(text="Malignant lymphoma, plasmacytoid") )
        setattr(cls, "Acute panmyelosis, NOS",
                PermissibleValue(text="Acute panmyelosis, NOS") )
        setattr(cls, "Spindle cell melanoma, type A",
                PermissibleValue(text="Spindle cell melanoma, type A") )
        setattr(cls, "Clear cell meningioma",
                PermissibleValue(text="Clear cell meningioma") )
        setattr(cls, "Solitary fibrous tumor/hemangiopericytoma Grade 3 (CNS)",
                PermissibleValue(text="Solitary fibrous tumor/hemangiopericytoma Grade 3 (CNS)") )
        setattr(cls, "Mature T ALL",
                PermissibleValue(text="Mature T ALL") )
        setattr(cls, "Trophoblastic tumor, epithelioid",
                PermissibleValue(text="Trophoblastic tumor, epithelioid") )
        setattr(cls, "Adenocarcinoma in situ, non-mucinous",
                PermissibleValue(text="Adenocarcinoma in situ, non-mucinous") )
        setattr(cls, "Classical Hodgkin lymphoma, nodular sclerosis, grade 2",
                PermissibleValue(text="Classical Hodgkin lymphoma, nodular sclerosis, grade 2") )
        setattr(cls, "Duct carcinoma, desmoplastic type",
                PermissibleValue(text="Duct carcinoma, desmoplastic type") )
        setattr(cls, "Periductal stromal tumor, low grade",
                PermissibleValue(text="Periductal stromal tumor, low grade") )
        setattr(cls, "Myelogenous leukemia, NOS",
                PermissibleValue(text="Myelogenous leukemia, NOS") )
        setattr(cls, "Atypical chronic myeloid leukemia, BCR/ABL negative",
                PermissibleValue(text="Atypical chronic myeloid leukemia, BCR/ABL negative") )
        setattr(cls, "Fibroid uterus",
                PermissibleValue(text="Fibroid uterus") )
        setattr(cls, "Pleomorphic xanthoastrocytoma",
                PermissibleValue(text="Pleomorphic xanthoastrocytoma") )
        setattr(cls, "Endometrioid tumor of low malignant potential",
                PermissibleValue(text="Endometrioid tumor of low malignant potential") )
        setattr(cls, "Follicular lymphoma, grade 3B",
                PermissibleValue(text="Follicular lymphoma, grade 3B") )
        setattr(cls, "Acute lymphoid leukemia",
                PermissibleValue(text="Acute lymphoid leukemia") )
        setattr(cls, "Pilomatricoma, NOS",
                PermissibleValue(text="Pilomatricoma, NOS") )
        setattr(cls, "Juxtacortical chondroma",
                PermissibleValue(text="Juxtacortical chondroma") )
        setattr(cls, "Intestinal T-cell lymphoma",
                PermissibleValue(text="Intestinal T-cell lymphoma") )
        setattr(cls, "Combined large cell neuroendocrine carcinoma",
                PermissibleValue(text="Combined large cell neuroendocrine carcinoma") )
        setattr(cls, "Squamous cell epithelioma",
                PermissibleValue(text="Squamous cell epithelioma") )
        setattr(cls, "Angiolipoma, NOS",
                PermissibleValue(text="Angiolipoma, NOS") )
        setattr(cls, "Mucinous adenocarcinoma, endocervical type",
                PermissibleValue(text="Mucinous adenocarcinoma, endocervical type") )
        setattr(cls, "Osteoid osteoma, NOS",
                PermissibleValue(text="Osteoid osteoma, NOS") )
        setattr(cls, "Clear cell cystadenoma",
                PermissibleValue(text="Clear cell cystadenoma") )
        setattr(cls, "Hepatosplenic gamma-delta cell lymphoma",
                PermissibleValue(text="Hepatosplenic gamma-delta cell lymphoma") )
        setattr(cls, "CNS Embryonal tumor with rhabdoid features",
                PermissibleValue(text="CNS Embryonal tumor with rhabdoid features") )
        setattr(cls, "Malignant lymphoma, mixed cell type, nodular",
                PermissibleValue(text="Malignant lymphoma, mixed cell type, nodular") )
        setattr(cls, "Granular cell myoblastoma, malignant",
                PermissibleValue(text="Granular cell myoblastoma, malignant") )
        setattr(cls, "Cellular angiofibroma",
                PermissibleValue(text="Cellular angiofibroma") )
        setattr(cls, "Aleukemic leukemia, NOS",
                PermissibleValue(text="Aleukemic leukemia, NOS") )
        setattr(cls, "Typical carcinoid",
                PermissibleValue(text="Typical carcinoid") )
        setattr(cls, "Malignant lymphoma, large cell, follicular, NOS",
                PermissibleValue(text="Malignant lymphoma, large cell, follicular, NOS") )
        setattr(cls, "Combined small cell-large carcinoma",
                PermissibleValue(text="Combined small cell-large carcinoma") )
        setattr(cls, "Desmoplastic infantile astrocytoma",
                PermissibleValue(text="Desmoplastic infantile astrocytoma") )
        setattr(cls, "Malignant lymphoma, follicle center, follicular",
                PermissibleValue(text="Malignant lymphoma, follicle center, follicular") )
        setattr(cls, "Plexiform fibrohistiocytic tumor",
                PermissibleValue(text="Plexiform fibrohistiocytic tumor") )
        setattr(cls, "Endometrioid adenocarcinoma, NOS",
                PermissibleValue(text="Endometrioid adenocarcinoma, NOS") )
        setattr(cls, "Juvenile fibroadenoma",
                PermissibleValue(text="Juvenile fibroadenoma") )
        setattr(cls, "Mixed epithelioid and spindle cell melanoma",
                PermissibleValue(text="Mixed epithelioid and spindle cell melanoma") )
        setattr(cls, "Smooth muscle tumor, NOS",
                PermissibleValue(text="Smooth muscle tumor, NOS") )
        setattr(cls, "Megakaryocytic myelosclerosis",
                PermissibleValue(text="Megakaryocytic myelosclerosis") )
        setattr(cls, "Benign cystic nephroma",
                PermissibleValue(text="Benign cystic nephroma") )
        setattr(cls, "Tumor cells, benign",
                PermissibleValue(text="Tumor cells, benign") )
        setattr(cls, "Ductal carcinoma in situ, micropapillary",
                PermissibleValue(text="Ductal carcinoma in situ, micropapillary") )
        setattr(cls, "Solid and papillary epithelial neoplasm",
                PermissibleValue(text="Solid and papillary epithelial neoplasm") )
        setattr(cls, "Papillary ependymoma",
                PermissibleValue(text="Papillary ependymoma") )
        setattr(cls, "Nonencapsulated sclerosing tumor",
                PermissibleValue(text="Nonencapsulated sclerosing tumor") )

class EnumCRDCHDiagnosisMorphology(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Diagnosis morphology
    """
    Unknown = PermissibleValue(text="Unknown")

    _defn = EnumDefinition(
        name="EnumCRDCHDiagnosisMorphology",
        description="Autogenerated Enumeration for CRDC-H Diagnosis morphology",
        code_set=None,
        code_set_version="2021-12-16T18:04:16.147503+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "8930/0",
                PermissibleValue(text="8930/0") )
        setattr(cls, "9282/0",
                PermissibleValue(text="9282/0") )
        setattr(cls, "9542/3",
                PermissibleValue(text="9542/3") )
        setattr(cls, "8575/3",
                PermissibleValue(text="8575/3") )
        setattr(cls, "9653/3",
                PermissibleValue(text="9653/3") )
        setattr(cls, "9432/1",
                PermissibleValue(text="9432/1") )
        setattr(cls, "9726/3",
                PermissibleValue(text="9726/3") )
        setattr(cls, "8120/2",
                PermissibleValue(text="8120/2") )
        setattr(cls, "8633/1",
                PermissibleValue(text="8633/1") )
        setattr(cls, "8831/0",
                PermissibleValue(text="8831/0") )
        setattr(cls, "8250/3",
                PermissibleValue(text="8250/3") )
        setattr(cls, "9510/0",
                PermissibleValue(text="9510/0") )
        setattr(cls, "9751/1",
                PermissibleValue(text="9751/1") )
        setattr(cls, "9808/3",
                PermissibleValue(text="9808/3") )
        setattr(cls, "8503/0",
                PermissibleValue(text="8503/0") )
        setattr(cls, "9705/3",
                PermissibleValue(text="9705/3") )
        setattr(cls, "9560/1",
                PermissibleValue(text="9560/1") )
        setattr(cls, "9700/3",
                PermissibleValue(text="9700/3") )
        setattr(cls, "8241/3",
                PermissibleValue(text="8241/3") )
        setattr(cls, "9910/3",
                PermissibleValue(text="9910/3") )
        setattr(cls, "8271/0",
                PermissibleValue(text="8271/0") )
        setattr(cls, "9535/0",
                PermissibleValue(text="9535/0") )
        setattr(cls, "9412/1",
                PermissibleValue(text="9412/1") )
        setattr(cls, "8890/0",
                PermissibleValue(text="8890/0") )
        setattr(cls, "8840/3",
                PermissibleValue(text="8840/3") )
        setattr(cls, "8380/3",
                PermissibleValue(text="8380/3") )
        setattr(cls, "8841/1",
                PermissibleValue(text="8841/1") )
        setattr(cls, "8070/3",
                PermissibleValue(text="8070/3") )
        setattr(cls, "9823/3",
                PermissibleValue(text="9823/3") )
        setattr(cls, "8211/0",
                PermissibleValue(text="8211/0") )
        setattr(cls, "8242/3",
                PermissibleValue(text="8242/3") )
        setattr(cls, "8003/3",
                PermissibleValue(text="8003/3") )
        setattr(cls, "8098/3",
                PermissibleValue(text="8098/3") )
        setattr(cls, "9015/1",
                PermissibleValue(text="9015/1") )
        setattr(cls, "8550/0",
                PermissibleValue(text="8550/0") )
        setattr(cls, "9260/3",
                PermissibleValue(text="9260/3") )
        setattr(cls, "9062/3",
                PermissibleValue(text="9062/3") )
        setattr(cls, "9740/3",
                PermissibleValue(text="9740/3") )
        setattr(cls, "8010/3",
                PermissibleValue(text="8010/3") )
        setattr(cls, "9523/3",
                PermissibleValue(text="9523/3") )
        setattr(cls, "9688/3",
                PermissibleValue(text="9688/3") )
        setattr(cls, "9478/3",
                PermissibleValue(text="9478/3") )
        setattr(cls, "8163/3",
                PermissibleValue(text="8163/3") )
        setattr(cls, "8593/1",
                PermissibleValue(text="8593/1") )
        setattr(cls, "8509/3",
                PermissibleValue(text="8509/3") )
        setattr(cls, "8966/0",
                PermissibleValue(text="8966/0") )
        setattr(cls, "8894/0",
                PermissibleValue(text="8894/0") )
        setattr(cls, "9983/3",
                PermissibleValue(text="9983/3") )
        setattr(cls, "8730/3",
                PermissibleValue(text="8730/3") )
        setattr(cls, "8380/1",
                PermissibleValue(text="8380/1") )
        setattr(cls, "8313/0",
                PermissibleValue(text="8313/0") )
        setattr(cls, "9801/3",
                PermissibleValue(text="9801/3") )
        setattr(cls, "8450/3",
                PermissibleValue(text="8450/3") )
        setattr(cls, "8959/0",
                PermissibleValue(text="8959/0") )
        setattr(cls, "8231/3",
                PermissibleValue(text="8231/3") )
        setattr(cls, "8712/0",
                PermissibleValue(text="8712/0") )
        setattr(cls, "8407/0",
                PermissibleValue(text="8407/0") )
        setattr(cls, "9102/3",
                PermissibleValue(text="9102/3") )
        setattr(cls, "8964/3",
                PermissibleValue(text="8964/3") )
        setattr(cls, "8040/0",
                PermissibleValue(text="8040/0") )
        setattr(cls, "9655/3",
                PermissibleValue(text="9655/3") )
        setattr(cls, "8858/3",
                PermissibleValue(text="8858/3") )
        setattr(cls, "9130/0",
                PermissibleValue(text="9130/0") )
        setattr(cls, "9383/1",
                PermissibleValue(text="9383/1") )
        setattr(cls, "8091/3",
                PermissibleValue(text="8091/3") )
        setattr(cls, "8576/3",
                PermissibleValue(text="8576/3") )
        setattr(cls, "9561/3",
                PermissibleValue(text="9561/3") )
        setattr(cls, "9837/3",
                PermissibleValue(text="9837/3") )
        setattr(cls, "9395/3",
                PermissibleValue(text="9395/3") )
        setattr(cls, "8720/3",
                PermissibleValue(text="8720/3") )
        setattr(cls, "9472/3",
                PermissibleValue(text="9472/3") )
        setattr(cls, "9000/0",
                PermissibleValue(text="9000/0") )
        setattr(cls, "8323/3",
                PermissibleValue(text="8323/3") )
        setattr(cls, "8243/3",
                PermissibleValue(text="8243/3") )
        setattr(cls, "8251/3",
                PermissibleValue(text="8251/3") )
        setattr(cls, "8501/2",
                PermissibleValue(text="8501/2") )
        setattr(cls, "8272/3",
                PermissibleValue(text="8272/3") )
        setattr(cls, "8300/3",
                PermissibleValue(text="8300/3") )
        setattr(cls, "8161/3",
                PermissibleValue(text="8161/3") )
        setattr(cls, "9967/3",
                PermissibleValue(text="9967/3") )
        setattr(cls, "8856/0",
                PermissibleValue(text="8856/0") )
        setattr(cls, "8891/3",
                PermissibleValue(text="8891/3") )
        setattr(cls, "9920/3",
                PermissibleValue(text="9920/3") )
        setattr(cls, "9053/3",
                PermissibleValue(text="9053/3") )
        setattr(cls, "8580/1",
                PermissibleValue(text="8580/1") )
        setattr(cls, "9813/3",
                PermissibleValue(text="9813/3") )
        setattr(cls, "8541/3",
                PermissibleValue(text="8541/3") )
        setattr(cls, "8325/0",
                PermissibleValue(text="8325/0") )
        setattr(cls, "8811/3",
                PermissibleValue(text="8811/3") )
        setattr(cls, "8582/1",
                PermissibleValue(text="8582/1") )
        setattr(cls, "8280/3",
                PermissibleValue(text="8280/3") )
        setattr(cls, "8521/1",
                PermissibleValue(text="8521/1") )
        setattr(cls, "8170/3",
                PermissibleValue(text="8170/3") )
        setattr(cls, "9964/3",
                PermissibleValue(text="9964/3") )
        setattr(cls, "8959/3",
                PermissibleValue(text="8959/3") )
        setattr(cls, "8941/3",
                PermissibleValue(text="8941/3") )
        setattr(cls, "8320/3",
                PermissibleValue(text="8320/3") )
        setattr(cls, "9712/3",
                PermissibleValue(text="9712/3") )
        setattr(cls, "9513/3",
                PermissibleValue(text="9513/3") )
        setattr(cls, "8551/3",
                PermissibleValue(text="8551/3") )
        setattr(cls, "8336/0",
                PermissibleValue(text="8336/0") )
        setattr(cls, "8683/0",
                PermissibleValue(text="8683/0") )
        setattr(cls, "9493/0",
                PermissibleValue(text="9493/0") )
        setattr(cls, "9016/0",
                PermissibleValue(text="9016/0") )
        setattr(cls, "9371/3",
                PermissibleValue(text="9371/3") )
        setattr(cls, "9562/0",
                PermissibleValue(text="9562/0") )
        setattr(cls, "9000/3",
                PermissibleValue(text="9000/3") )
        setattr(cls, "8339/3",
                PermissibleValue(text="8339/3") )
        setattr(cls, "8463/1",
                PermissibleValue(text="8463/1") )
        setattr(cls, "8250/2",
                PermissibleValue(text="8250/2") )
        setattr(cls, "9352/1",
                PermissibleValue(text="9352/1") )
        setattr(cls, "8898/1",
                PermissibleValue(text="8898/1") )
        setattr(cls, "8281/0",
                PermissibleValue(text="8281/0") )
        setattr(cls, "8246/3",
                PermissibleValue(text="8246/3") )
        setattr(cls, "8850/0",
                PermissibleValue(text="8850/0") )
        setattr(cls, "9440/3",
                PermissibleValue(text="9440/3") )
        setattr(cls, "9321/0",
                PermissibleValue(text="9321/0") )
        setattr(cls, "8905/0",
                PermissibleValue(text="8905/0") )
        setattr(cls, "8410/0",
                PermissibleValue(text="8410/0") )
        setattr(cls, "9540/0",
                PermissibleValue(text="9540/0") )
        setattr(cls, "8825/0",
                PermissibleValue(text="8825/0") )
        setattr(cls, "8214/3",
                PermissibleValue(text="8214/3") )
        setattr(cls, "8852/0",
                PermissibleValue(text="8852/0") )
        setattr(cls, "8330/3",
                PermissibleValue(text="8330/3") )
        setattr(cls, "9183/3",
                PermissibleValue(text="9183/3") )
        setattr(cls, "9758/3",
                PermissibleValue(text="9758/3") )
        setattr(cls, "8594/1",
                PermissibleValue(text="8594/1") )
        setattr(cls, "9539/1",
                PermissibleValue(text="9539/1") )
        setattr(cls, "9911/3",
                PermissibleValue(text="9911/3") )
        setattr(cls, "9732/3",
                PermissibleValue(text="9732/3") )
        setattr(cls, "9714/3",
                PermissibleValue(text="9714/3") )
        setattr(cls, "8440/0",
                PermissibleValue(text="8440/0") )
        setattr(cls, "8857/0",
                PermissibleValue(text="8857/0") )
        setattr(cls, "9650/3",
                PermissibleValue(text="9650/3") )
        setattr(cls, "8830/0",
                PermissibleValue(text="8830/0") )
        setattr(cls, "9431/1",
                PermissibleValue(text="9431/1") )
        setattr(cls, "8384/3",
                PermissibleValue(text="8384/3") )
        setattr(cls, "8210/2",
                PermissibleValue(text="8210/2") )
        setattr(cls, "8230/3",
                PermissibleValue(text="8230/3") )
        setattr(cls, "8521/3",
                PermissibleValue(text="8521/3") )
        setattr(cls, "8744/3",
                PermissibleValue(text="8744/3") )
        setattr(cls, "8202/0",
                PermissibleValue(text="8202/0") )
        setattr(cls, "8244/3",
                PermissibleValue(text="8244/3") )
        setattr(cls, "9755/3",
                PermissibleValue(text="9755/3") )
        setattr(cls, "8390/3",
                PermissibleValue(text="8390/3") )
        setattr(cls, "9270/3",
                PermissibleValue(text="9270/3") )
        setattr(cls, "8392/0",
                PermissibleValue(text="8392/0") )
        setattr(cls, "8510/3",
                PermissibleValue(text="8510/3") )
        setattr(cls, "9091/1",
                PermissibleValue(text="9091/1") )
        setattr(cls, "9290/0",
                PermissibleValue(text="9290/0") )
        setattr(cls, "9424/3",
                PermissibleValue(text="9424/3") )
        setattr(cls, "9131/0",
                PermissibleValue(text="9131/0") )
        setattr(cls, "9220/0",
                PermissibleValue(text="9220/0") )
        setattr(cls, "8053/0",
                PermissibleValue(text="8053/0") )
        setattr(cls, "8670/0",
                PermissibleValue(text="8670/0") )
        setattr(cls, "8630/1",
                PermissibleValue(text="8630/1") )
        setattr(cls, "8073/3",
                PermissibleValue(text="8073/3") )
        setattr(cls, "8391/0",
                PermissibleValue(text="8391/0") )
        setattr(cls, "8632/1",
                PermissibleValue(text="8632/1") )
        setattr(cls, "8750/0",
                PermissibleValue(text="8750/0") )
        setattr(cls, "8247/3",
                PermissibleValue(text="8247/3") )
        setattr(cls, "8461/3",
                PermissibleValue(text="8461/3") )
        setattr(cls, "8150/3",
                PermissibleValue(text="8150/3") )
        setattr(cls, "8983/3",
                PermissibleValue(text="8983/3") )
        setattr(cls, "8470/0",
                PermissibleValue(text="8470/0") )
        setattr(cls, "9865/3",
                PermissibleValue(text="9865/3") )
        setattr(cls, "8810/3",
                PermissibleValue(text="8810/3") )
        setattr(cls, "9860/3",
                PermissibleValue(text="9860/3") )
        setattr(cls, "9065/3",
                PermissibleValue(text="9065/3") )
        setattr(cls, "9050/0",
                PermissibleValue(text="9050/0") )
        setattr(cls, "8071/2",
                PermissibleValue(text="8071/2") )
        setattr(cls, "8070/6",
                PermissibleValue(text="8070/6") )
        setattr(cls, "8242/1",
                PermissibleValue(text="8242/1") )
        setattr(cls, "9473/3",
                PermissibleValue(text="9473/3") )
        setattr(cls, "9142/0",
                PermissibleValue(text="9142/0") )
        setattr(cls, "8589/3",
                PermissibleValue(text="8589/3") )
        setattr(cls, "8070/2",
                PermissibleValue(text="8070/2") )
        setattr(cls, "9474/3",
                PermissibleValue(text="9474/3") )
        setattr(cls, "8162/3",
                PermissibleValue(text="8162/3") )
        setattr(cls, "8070/33",
                PermissibleValue(text="8070/33") )
        setattr(cls, "8083/3",
                PermissibleValue(text="8083/3") )
        setattr(cls, "8311/3",
                PermissibleValue(text="8311/3") )
        setattr(cls, "9930/3",
                PermissibleValue(text="9930/3") )
        setattr(cls, "9137/3",
                PermissibleValue(text="9137/3") )
        setattr(cls, "9761/3",
                PermissibleValue(text="9761/3") )
        setattr(cls, "8420/0",
                PermissibleValue(text="8420/0") )
        setattr(cls, "8713/0",
                PermissibleValue(text="8713/0") )
        setattr(cls, "9505/1",
                PermissibleValue(text="9505/1") )
        setattr(cls, "9310/0",
                PermissibleValue(text="9310/0") )
        setattr(cls, "9261/3",
                PermissibleValue(text="9261/3") )
        setattr(cls, "8201/3",
                PermissibleValue(text="8201/3") )
        setattr(cls, "9709/3",
                PermissibleValue(text="9709/3") )
        setattr(cls, "8380/0",
                PermissibleValue(text="8380/0") )
        setattr(cls, "8620/1",
                PermissibleValue(text="8620/1") )
        setattr(cls, "8441/3",
                PermissibleValue(text="8441/3") )
        setattr(cls, "8462/1",
                PermissibleValue(text="8462/1") )
        setattr(cls, "9863/3",
                PermissibleValue(text="9863/3") )
        setattr(cls, "8102/0",
                PermissibleValue(text="8102/0") )
        setattr(cls, "9136/1",
                PermissibleValue(text="9136/1") )
        setattr(cls, "8723/0",
                PermissibleValue(text="8723/0") )
        setattr(cls, "9659/3",
                PermissibleValue(text="9659/3") )
        setattr(cls, "9184/3",
                PermissibleValue(text="9184/3") )
        setattr(cls, "9897/3",
                PermissibleValue(text="9897/3") )
        setattr(cls, "9442/3",
                PermissibleValue(text="9442/3") )
        setattr(cls, "8323/0",
                PermissibleValue(text="8323/0") )
        setattr(cls, "8149/0",
                PermissibleValue(text="8149/0") )
        setattr(cls, "9392/3",
                PermissibleValue(text="9392/3") )
        setattr(cls, "9242/3",
                PermissibleValue(text="9242/3") )
        setattr(cls, "9174/1",
                PermissibleValue(text="9174/1") )
        setattr(cls, "9273/0",
                PermissibleValue(text="9273/0") )
        setattr(cls, "9341/1",
                PermissibleValue(text="9341/1") )
        setattr(cls, "8522/3",
                PermissibleValue(text="8522/3") )
        setattr(cls, "8052/3",
                PermissibleValue(text="8052/3") )
        setattr(cls, "8140/2",
                PermissibleValue(text="8140/2") )
        setattr(cls, "8256/3",
                PermissibleValue(text="8256/3") )
        setattr(cls, "8812/3",
                PermissibleValue(text="8812/3") )
        setattr(cls, "8046/3",
                PermissibleValue(text="8046/3") )
        setattr(cls, "8762/1",
                PermissibleValue(text="8762/1") )
        setattr(cls, "8584/1",
                PermissibleValue(text="8584/1") )
        setattr(cls, "8322/0",
                PermissibleValue(text="8322/0") )
        setattr(cls, "8982/3",
                PermissibleValue(text="8982/3") )
        setattr(cls, "9082/3",
                PermissibleValue(text="9082/3") )
        setattr(cls, "8870/0",
                PermissibleValue(text="8870/0") )
        setattr(cls, "9809/3",
                PermissibleValue(text="9809/3") )
        setattr(cls, "8155/3",
                PermissibleValue(text="8155/3") )
        setattr(cls, "8520/3",
                PermissibleValue(text="8520/3") )
        setattr(cls, "9185/3",
                PermissibleValue(text="9185/3") )
        setattr(cls, "9341/3",
                PermissibleValue(text="9341/3") )
        setattr(cls, "8832/3",
                PermissibleValue(text="8832/3") )
        setattr(cls, "9200/1",
                PermissibleValue(text="9200/1") )
        setattr(cls, "8480/3",
                PermissibleValue(text="8480/3") )
        setattr(cls, "9735/3",
                PermissibleValue(text="9735/3") )
        setattr(cls, "8452/1",
                PermissibleValue(text="8452/1") )
        setattr(cls, "8084/3",
                PermissibleValue(text="8084/3") )
        setattr(cls, "8742/2",
                PermissibleValue(text="8742/2") )
        setattr(cls, "8692/1",
                PermissibleValue(text="8692/1") )
        setattr(cls, "9729/3",
                PermissibleValue(text="9729/3") )
        setattr(cls, "8574/3",
                PermissibleValue(text="8574/3") )
        setattr(cls, "9725/3",
                PermissibleValue(text="9725/3") )
        setattr(cls, "8728/1",
                PermissibleValue(text="8728/1") )
        setattr(cls, "9476/3",
                PermissibleValue(text="9476/3") )
        setattr(cls, "8630/3",
                PermissibleValue(text="8630/3") )
        setattr(cls, "8726/0",
                PermissibleValue(text="8726/0") )
        setattr(cls, "8810/1",
                PermissibleValue(text="8810/1") )
        setattr(cls, "9834/3",
                PermissibleValue(text="9834/3") )
        setattr(cls, "8571/3",
                PermissibleValue(text="8571/3") )
        setattr(cls, "8600/3",
                PermissibleValue(text="8600/3") )
        setattr(cls, "8480/0",
                PermissibleValue(text="8480/0") )
        setattr(cls, "8382/3",
                PermissibleValue(text="8382/3") )
        setattr(cls, "8691/1",
                PermissibleValue(text="8691/1") )
        setattr(cls, "9590/3",
                PermissibleValue(text="9590/3") )
        setattr(cls, "9541/0",
                PermissibleValue(text="9541/0") )
        setattr(cls, "9757/3",
                PermissibleValue(text="9757/3") )
        setattr(cls, "9963/3",
                PermissibleValue(text="9963/3") )
        setattr(cls, "8180/3",
                PermissibleValue(text="8180/3") )
        setattr(cls, "8031/3",
                PermissibleValue(text="8031/3") )
        setattr(cls, "8504/2",
                PermissibleValue(text="8504/2") )
        setattr(cls, "9861/3",
                PermissibleValue(text="9861/3") )
        setattr(cls, "8120/1",
                PermissibleValue(text="8120/1") )
        setattr(cls, "8897/1",
                PermissibleValue(text="8897/1") )
        setattr(cls, "8650/1",
                PermissibleValue(text="8650/1") )
        setattr(cls, "9501/3",
                PermissibleValue(text="9501/3") )
        setattr(cls, "9806/3",
                PermissibleValue(text="9806/3") )
        setattr(cls, "9230/3",
                PermissibleValue(text="9230/3") )
        setattr(cls, "8041/34",
                PermissibleValue(text="8041/34") )
        setattr(cls, "9133/1",
                PermissibleValue(text="9133/1") )
        setattr(cls, "8161/0",
                PermissibleValue(text="8161/0") )
        setattr(cls, "9501/0",
                PermissibleValue(text="9501/0") )
        setattr(cls, "8010/2",
                PermissibleValue(text="8010/2") )
        setattr(cls, "9580/0",
                PermissibleValue(text="9580/0") )
        setattr(cls, "9272/0",
                PermissibleValue(text="9272/0") )
        setattr(cls, "8760/0",
                PermissibleValue(text="8760/0") )
        setattr(cls, "8790/0",
                PermissibleValue(text="8790/0") )
        setattr(cls, "9187/3",
                PermissibleValue(text="9187/3") )
        setattr(cls, "8861/0",
                PermissibleValue(text="8861/0") )
        setattr(cls, "9290/3",
                PermissibleValue(text="9290/3") )
        setattr(cls, "8895/3",
                PermissibleValue(text="8895/3") )
        setattr(cls, "9310/3",
                PermissibleValue(text="9310/3") )
        setattr(cls, "8130/3",
                PermissibleValue(text="8130/3") )
        setattr(cls, "8480/1",
                PermissibleValue(text="8480/1") )
        setattr(cls, "8583/1",
                PermissibleValue(text="8583/1") )
        setattr(cls, "8263/2",
                PermissibleValue(text="8263/2") )
        setattr(cls, "8210/3",
                PermissibleValue(text="8210/3") )
        setattr(cls, "9510/3",
                PermissibleValue(text="9510/3") )
        setattr(cls, "9980/3",
                PermissibleValue(text="9980/3") )
        setattr(cls, "9597/3",
                PermissibleValue(text="9597/3") )
        setattr(cls, "9471/3",
                PermissibleValue(text="9471/3") )
        setattr(cls, "9742/3",
                PermissibleValue(text="9742/3") )
        setattr(cls, "9130/1",
                PermissibleValue(text="9130/1") )
        setattr(cls, "9413/0",
                PermissibleValue(text="9413/0") )
        setattr(cls, "8836/1",
                PermissibleValue(text="8836/1") )
        setattr(cls, "8825/3",
                PermissibleValue(text="8825/3") )
        setattr(cls, "8971/3",
                PermissibleValue(text="8971/3") )
        setattr(cls, "8912/3",
                PermissibleValue(text="8912/3") )
        setattr(cls, "8211/3",
                PermissibleValue(text="8211/3") )
        setattr(cls, "9100/0",
                PermissibleValue(text="9100/0") )
        setattr(cls, "8334/0",
                PermissibleValue(text="8334/0") )
        setattr(cls, "9125/0",
                PermissibleValue(text="9125/0") )
        setattr(cls, "8562/3",
                PermissibleValue(text="8562/3") )
        setattr(cls, "8143/3",
                PermissibleValue(text="8143/3") )
        setattr(cls, "8152/1",
                PermissibleValue(text="8152/1") )
        setattr(cls, "9661/3",
                PermissibleValue(text="9661/3") )
        setattr(cls, "9281/0",
                PermissibleValue(text="9281/0") )
        setattr(cls, "9815/3",
                PermissibleValue(text="9815/3") )
        setattr(cls, "8103/0",
                PermissibleValue(text="8103/0") )
        setattr(cls, "8693/3",
                PermissibleValue(text="8693/3") )
        setattr(cls, "9502/0",
                PermissibleValue(text="9502/0") )
        setattr(cls, "9521/3",
                PermissibleValue(text="9521/3") )
        setattr(cls, "8812/0",
                PermissibleValue(text="8812/0") )
        setattr(cls, "9769/1",
                PermissibleValue(text="9769/1") )
        setattr(cls, "9186/3",
                PermissibleValue(text="9186/3") )
        setattr(cls, "9719/3",
                PermissibleValue(text="9719/3") )
        setattr(cls, "9330/0",
                PermissibleValue(text="9330/0") )
        setattr(cls, "9274/0",
                PermissibleValue(text="9274/0") )
        setattr(cls, "9141/0",
                PermissibleValue(text="9141/0") )
        setattr(cls, "8959/1",
                PermissibleValue(text="8959/1") )
        setattr(cls, "9221/0",
                PermissibleValue(text="9221/0") )
        setattr(cls, "8723/3",
                PermissibleValue(text="8723/3") )
        setattr(cls, "8220/0",
                PermissibleValue(text="8220/0") )
        setattr(cls, "8318/3",
                PermissibleValue(text="8318/3") )
        setattr(cls, "8745/3",
                PermissibleValue(text="8745/3") )
        setattr(cls, "9382/3",
                PermissibleValue(text="9382/3") )
        setattr(cls, "8507/3",
                PermissibleValue(text="8507/3") )
        setattr(cls, "8892/0",
                PermissibleValue(text="8892/0") )
        setattr(cls, "8130/1",
                PermissibleValue(text="8130/1") )
        setattr(cls, "9090/0",
                PermissibleValue(text="9090/0") )
        setattr(cls, "8375/0",
                PermissibleValue(text="8375/0") )
        setattr(cls, "8590/1",
                PermissibleValue(text="8590/1") )
        setattr(cls, "8035/3",
                PermissibleValue(text="8035/3") )
        setattr(cls, "9070/3",
                PermissibleValue(text="9070/3") )
        setattr(cls, "8001/3",
                PermissibleValue(text="8001/3") )
        setattr(cls, "9560/0",
                PermissibleValue(text="9560/0") )
        setattr(cls, "9741/1",
                PermissibleValue(text="9741/1") )
        setattr(cls, "9241/0",
                PermissibleValue(text="9241/0") )
        setattr(cls, "8972/3",
                PermissibleValue(text="8972/3") )
        setattr(cls, "8700/0",
                PermissibleValue(text="8700/0") )
        setattr(cls, "8442/1",
                PermissibleValue(text="8442/1") )
        setattr(cls, "8932/0",
                PermissibleValue(text="8932/0") )
        setattr(cls, "9756/3",
                PermissibleValue(text="9756/3") )
        setattr(cls, "8260/0",
                PermissibleValue(text="8260/0") )
        setattr(cls, "9520/3",
                PermissibleValue(text="9520/3") )
        setattr(cls, "8390/0",
                PermissibleValue(text="8390/0") )
        setattr(cls, "8310/3",
                PermissibleValue(text="8310/3") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "9020/0",
                PermissibleValue(text="9020/0") )
        setattr(cls, "8815/1",
                PermissibleValue(text="8815/1") )
        setattr(cls, "8902/3",
                PermissibleValue(text="8902/3") )
        setattr(cls, "9931/3",
                PermissibleValue(text="9931/3") )
        setattr(cls, "8586/3",
                PermissibleValue(text="8586/3") )
        setattr(cls, "8000/6",
                PermissibleValue(text="8000/6") )
        setattr(cls, "8602/0",
                PermissibleValue(text="8602/0") )
        setattr(cls, "8714/3",
                PermissibleValue(text="8714/3") )
        setattr(cls, "8740/3",
                PermissibleValue(text="8740/3") )
        setattr(cls, "9522/3",
                PermissibleValue(text="9522/3") )
        setattr(cls, "9891/3",
                PermissibleValue(text="9891/3") )
        setattr(cls, "8471/0",
                PermissibleValue(text="8471/0") )
        setattr(cls, "8005/0",
                PermissibleValue(text="8005/0") )
        setattr(cls, "8530/3",
                PermissibleValue(text="8530/3") )
        setattr(cls, "9945/3",
                PermissibleValue(text="9945/3") )
        setattr(cls, "8519/2",
                PermissibleValue(text="8519/2") )
        setattr(cls, "9423/3",
                PermissibleValue(text="9423/3") )
        setattr(cls, "9673/3",
                PermissibleValue(text="9673/3") )
        setattr(cls, "9741/3",
                PermissibleValue(text="9741/3") )
        setattr(cls, "9180/3",
                PermissibleValue(text="9180/3") )
        setattr(cls, "8827/1",
                PermissibleValue(text="8827/1") )
        setattr(cls, "9663/3",
                PermissibleValue(text="9663/3") )
        setattr(cls, "9243/3",
                PermissibleValue(text="9243/3") )
        setattr(cls, "8263/0",
                PermissibleValue(text="8263/0") )
        setattr(cls, "8212/0",
                PermissibleValue(text="8212/0") )
        setattr(cls, "8121/0",
                PermissibleValue(text="8121/0") )
        setattr(cls, "8854/0",
                PermissibleValue(text="8854/0") )
        setattr(cls, "8930/3",
                PermissibleValue(text="8930/3") )
        setattr(cls, "8780/0",
                PermissibleValue(text="8780/0") )
        setattr(cls, "8022/3",
                PermissibleValue(text="8022/3") )
        setattr(cls, "8373/0",
                PermissibleValue(text="8373/0") )
        setattr(cls, "9015/3",
                PermissibleValue(text="9015/3") )
        setattr(cls, "8001/1",
                PermissibleValue(text="8001/1") )
        setattr(cls, "9362/3",
                PermissibleValue(text="9362/3") )
        setattr(cls, "8904/0",
                PermissibleValue(text="8904/0") )
        setattr(cls, "8584/3",
                PermissibleValue(text="8584/3") )
        setattr(cls, "8406/0",
                PermissibleValue(text="8406/0") )
        setattr(cls, "9506/1",
                PermissibleValue(text="9506/1") )
        setattr(cls, "8015/3",
                PermissibleValue(text="8015/3") )
        setattr(cls, "9085/3",
                PermissibleValue(text="9085/3") )
        setattr(cls, "9975/3",
                PermissibleValue(text="9975/3") )
        setattr(cls, "8004/3",
                PermissibleValue(text="8004/3") )
        setattr(cls, "8215/3",
                PermissibleValue(text="8215/3") )
        setattr(cls, "9832/3",
                PermissibleValue(text="9832/3") )
        setattr(cls, "8319/3",
                PermissibleValue(text="8319/3") )
        setattr(cls, "9514/1",
                PermissibleValue(text="9514/1") )
        setattr(cls, "8040/1",
                PermissibleValue(text="8040/1") )
        setattr(cls, "8780/3",
                PermissibleValue(text="8780/3") )
        setattr(cls, "8313/3",
                PermissibleValue(text="8313/3") )
        setattr(cls, "8460/3",
                PermissibleValue(text="8460/3") )
        setattr(cls, "9664/3",
                PermissibleValue(text="9664/3") )
        setattr(cls, "9869/3",
                PermissibleValue(text="9869/3") )
        setattr(cls, "8513/3",
                PermissibleValue(text="8513/3") )
        setattr(cls, "9678/3",
                PermissibleValue(text="9678/3") )
        setattr(cls, "8963/3",
                PermissibleValue(text="8963/3") )
        setattr(cls, "9716/3",
                PermissibleValue(text="9716/3") )
        setattr(cls, "8990/0",
                PermissibleValue(text="8990/0") )
        setattr(cls, "8508/3",
                PermissibleValue(text="8508/3") )
        setattr(cls, "8850/3",
                PermissibleValue(text="8850/3") )
        setattr(cls, "8771/0",
                PermissibleValue(text="8771/0") )
        setattr(cls, "9192/3",
                PermissibleValue(text="9192/3") )
        setattr(cls, "8981/3",
                PermissibleValue(text="8981/3") )
        setattr(cls, "8080/2",
                PermissibleValue(text="8080/2") )
        setattr(cls, "9836/3",
                PermissibleValue(text="9836/3") )
        setattr(cls, "9250/3",
                PermissibleValue(text="9250/3") )
        setattr(cls, "9667/3",
                PermissibleValue(text="9667/3") )
        setattr(cls, "8012/3",
                PermissibleValue(text="8012/3") )
        setattr(cls, "8522/1",
                PermissibleValue(text="8522/1") )
        setattr(cls, "8842/0",
                PermissibleValue(text="8842/0") )
        setattr(cls, "8522/2",
                PermissibleValue(text="8522/2") )
        setattr(cls, "8381/3",
                PermissibleValue(text="8381/3") )
        setattr(cls, "8814/3",
                PermissibleValue(text="8814/3") )
        setattr(cls, "9582/0",
                PermissibleValue(text="9582/0") )
        setattr(cls, "8441/0",
                PermissibleValue(text="8441/0") )
        setattr(cls, "8940/3",
                PermissibleValue(text="8940/3") )
        setattr(cls, "9391/3",
                PermissibleValue(text="9391/3") )
        setattr(cls, "8403/0",
                PermissibleValue(text="8403/0") )
        setattr(cls, "8461/0",
                PermissibleValue(text="8461/0") )
        setattr(cls, "8980/3",
                PermissibleValue(text="8980/3") )
        setattr(cls, "8010/9",
                PermissibleValue(text="8010/9") )
        setattr(cls, "9011/0",
                PermissibleValue(text="9011/0") )
        setattr(cls, "8634/3",
                PermissibleValue(text="8634/3") )
        setattr(cls, "8523/3",
                PermissibleValue(text="8523/3") )
        setattr(cls, "8290/3",
                PermissibleValue(text="8290/3") )
        setattr(cls, "8854/3",
                PermissibleValue(text="8854/3") )
        setattr(cls, "8153/1",
                PermissibleValue(text="8153/1") )
        setattr(cls, "8504/0",
                PermissibleValue(text="8504/0") )
        setattr(cls, "8337/3",
                PermissibleValue(text="8337/3") )
        setattr(cls, "9051/3",
                PermissibleValue(text="9051/3") )
        setattr(cls, "8060/0",
                PermissibleValue(text="8060/0") )
        setattr(cls, "8260/3",
                PermissibleValue(text="8260/3") )
        setattr(cls, "9063/3",
                PermissibleValue(text="9063/3") )
        setattr(cls, "8825/1",
                PermissibleValue(text="8825/1") )
        setattr(cls, "8090/1",
                PermissibleValue(text="8090/1") )
        setattr(cls, "8076/3",
                PermissibleValue(text="8076/3") )
        setattr(cls, "8721/3",
                PermissibleValue(text="8721/3") )
        setattr(cls, "8896/3",
                PermissibleValue(text="8896/3") )
        setattr(cls, "8252/3",
                PermissibleValue(text="8252/3") )
        setattr(cls, "9537/0",
                PermissibleValue(text="9537/0") )
        setattr(cls, "8160/0",
                PermissibleValue(text="8160/0") )
        setattr(cls, "9530/1",
                PermissibleValue(text="9530/1") )
        setattr(cls, "8121/1",
                PermissibleValue(text="8121/1") )
        setattr(cls, "8400/3",
                PermissibleValue(text="8400/3") )
        setattr(cls, "9083/3",
                PermissibleValue(text="9083/3") )
        setattr(cls, "9500/3",
                PermissibleValue(text="9500/3") )
        setattr(cls, "8402/0",
                PermissibleValue(text="8402/0") )
        setattr(cls, "8771/3",
                PermissibleValue(text="8771/3") )
        setattr(cls, "8991/3",
                PermissibleValue(text="8991/3") )
        setattr(cls, "9504/3",
                PermissibleValue(text="9504/3") )
        setattr(cls, "9080/3",
                PermissibleValue(text="9080/3") )
        setattr(cls, "9702/3",
                PermissibleValue(text="9702/3") )
        setattr(cls, "9596/3",
                PermissibleValue(text="9596/3") )
        setattr(cls, "9538/1",
                PermissibleValue(text="9538/1") )
        setattr(cls, "8631/0",
                PermissibleValue(text="8631/0") )
        setattr(cls, "9982/3",
                PermissibleValue(text="9982/3") )
        setattr(cls, "8173/3",
                PermissibleValue(text="8173/3") )
        setattr(cls, "8261/3",
                PermissibleValue(text="8261/3") )
        setattr(cls, "8453/3",
                PermissibleValue(text="8453/3") )
        setattr(cls, "8372/0",
                PermissibleValue(text="8372/0") )
        setattr(cls, "8333/0",
                PermissibleValue(text="8333/0") )
        setattr(cls, "8512/3",
                PermissibleValue(text="8512/3") )
        setattr(cls, "8120/3",
                PermissibleValue(text="8120/3") )
        setattr(cls, "8344/3",
                PermissibleValue(text="8344/3") )
        setattr(cls, "9751/3",
                PermissibleValue(text="9751/3") )
        setattr(cls, "8023/3",
                PermissibleValue(text="8023/3") )
        setattr(cls, "8280/0",
                PermissibleValue(text="8280/0") )
        setattr(cls, "9064/2",
                PermissibleValue(text="9064/2") )
        setattr(cls, "9393/3",
                PermissibleValue(text="9393/3") )
        setattr(cls, "9895/3",
                PermissibleValue(text="9895/3") )
        setattr(cls, "9010/0",
                PermissibleValue(text="9010/0") )
        setattr(cls, "8200/0",
                PermissibleValue(text="8200/0") )
        setattr(cls, "9370/3",
                PermissibleValue(text="9370/3") )
        setattr(cls, "8321/0",
                PermissibleValue(text="8321/0") )
        setattr(cls, "9807/3",
                PermissibleValue(text="9807/3") )
        setattr(cls, "9966/3",
                PermissibleValue(text="9966/3") )
        setattr(cls, "9961/3",
                PermissibleValue(text="9961/3") )
        setattr(cls, "9948/3",
                PermissibleValue(text="9948/3") )
        setattr(cls, "8671/0",
                PermissibleValue(text="8671/0") )
        setattr(cls, "9121/0",
                PermissibleValue(text="9121/0") )
        setattr(cls, "8935/0",
                PermissibleValue(text="8935/0") )
        setattr(cls, "8973/3",
                PermissibleValue(text="8973/3") )
        setattr(cls, "8257/3",
                PermissibleValue(text="8257/3") )
        setattr(cls, "9960/3",
                PermissibleValue(text="9960/3") )
        setattr(cls, "8265/3",
                PermissibleValue(text="8265/3") )
        setattr(cls, "9300/0",
                PermissibleValue(text="9300/0") )
        setattr(cls, "8251/0",
                PermissibleValue(text="8251/0") )
        setattr(cls, "9394/1",
                PermissibleValue(text="9394/1") )
        setattr(cls, "8890/3",
                PermissibleValue(text="8890/3") )
        setattr(cls, "8124/3",
                PermissibleValue(text="8124/3") )
        setattr(cls, "8990/1",
                PermissibleValue(text="8990/1") )
        setattr(cls, "9480/3",
                PermissibleValue(text="9480/3") )
        setattr(cls, "9816/3",
                PermissibleValue(text="9816/3") )
        setattr(cls, "8622/1",
                PermissibleValue(text="8622/1") )
        setattr(cls, "8097/3",
                PermissibleValue(text="8097/3") )
        setattr(cls, "8322/3",
                PermissibleValue(text="8322/3") )
        setattr(cls, "8343/3",
                PermissibleValue(text="8343/3") )
        setattr(cls, "8021/3",
                PermissibleValue(text="8021/3") )
        setattr(cls, "8245/1",
                PermissibleValue(text="8245/1") )
        setattr(cls, "9050/3",
                PermissibleValue(text="9050/3") )
        setattr(cls, "8803/3",
                PermissibleValue(text="8803/3") )
        setattr(cls, "8471/3",
                PermissibleValue(text="8471/3") )
        setattr(cls, "8835/1",
                PermissibleValue(text="8835/1") )
        setattr(cls, "8441/2",
                PermissibleValue(text="8441/2") )
        setattr(cls, "9160/0",
                PermissibleValue(text="9160/0") )
        setattr(cls, "9200/0",
                PermissibleValue(text="9200/0") )
        setattr(cls, "8560/0",
                PermissibleValue(text="8560/0") )
        setattr(cls, "9512/3",
                PermissibleValue(text="9512/3") )
        setattr(cls, "9302/0",
                PermissibleValue(text="9302/0") )
        setattr(cls, "8454/0",
                PermissibleValue(text="8454/0") )
        setattr(cls, "8370/1",
                PermissibleValue(text="8370/1") )
        setattr(cls, "8936/1",
                PermissibleValue(text="8936/1") )
        setattr(cls, "9390/3",
                PermissibleValue(text="9390/3") )
        setattr(cls, "8920/3",
                PermissibleValue(text="8920/3") )
        setattr(cls, "8821/1",
                PermissibleValue(text="8821/1") )
        setattr(cls, "8561/0",
                PermissibleValue(text="8561/0") )
        setattr(cls, "8156/3",
                PermissibleValue(text="8156/3") )
        setattr(cls, "8891/0",
                PermissibleValue(text="8891/0") )
        setattr(cls, "8264/0",
                PermissibleValue(text="8264/0") )
        setattr(cls, "8158/1",
                PermissibleValue(text="8158/1") )
        setattr(cls, "8573/3",
                PermissibleValue(text="8573/3") )
        setattr(cls, "8834/1",
                PermissibleValue(text="8834/1") )
        setattr(cls, "9103/0",
                PermissibleValue(text="9103/0") )
        setattr(cls, "8405/0",
                PermissibleValue(text="8405/0") )
        setattr(cls, "8151/0",
                PermissibleValue(text="8151/0") )
        setattr(cls, "8700/3",
                PermissibleValue(text="8700/3") )
        setattr(cls, "8147/3",
                PermissibleValue(text="8147/3") )
        setattr(cls, "9560/3",
                PermissibleValue(text="9560/3") )
        setattr(cls, "8642/1",
                PermissibleValue(text="8642/1") )
        setattr(cls, "9441/3",
                PermissibleValue(text="9441/3") )
        setattr(cls, "8453/2",
                PermissibleValue(text="8453/2") )
        setattr(cls, "8051/0",
                PermissibleValue(text="8051/0") )
        setattr(cls, "8570/3",
                PermissibleValue(text="8570/3") )
        setattr(cls, "8110/3",
                PermissibleValue(text="8110/3") )
        setattr(cls, "9081/3",
                PermissibleValue(text="9081/3") )
        setattr(cls, "8403/3",
                PermissibleValue(text="8403/3") )
        setattr(cls, "9175/0",
                PermissibleValue(text="9175/0") )
        setattr(cls, "8862/0",
                PermissibleValue(text="8862/0") )
        setattr(cls, "8641/0",
                PermissibleValue(text="8641/0") )
        setattr(cls, "9170/0",
                PermissibleValue(text="9170/0") )
        setattr(cls, "9411/3",
                PermissibleValue(text="9411/3") )
        setattr(cls, "9946/3",
                PermissibleValue(text="9946/3") )
        setattr(cls, "9654/3",
                PermissibleValue(text="9654/3") )
        setattr(cls, "8810/0",
                PermissibleValue(text="8810/0") )
        setattr(cls, "8893/0",
                PermissibleValue(text="8893/0") )
        setattr(cls, "9090/3",
                PermissibleValue(text="9090/3") )
        setattr(cls, "9505/3",
                PermissibleValue(text="9505/3") )
        setattr(cls, "8071/3",
                PermissibleValue(text="8071/3") )
        setattr(cls, "9873/3",
                PermissibleValue(text="9873/3") )
        setattr(cls, "9105/3",
                PermissibleValue(text="9105/3") )
        setattr(cls, "9051/0",
                PermissibleValue(text="9051/0") )
        setattr(cls, "8983/0",
                PermissibleValue(text="8983/0") )
        setattr(cls, "8725/0",
                PermissibleValue(text="8725/0") )
        setattr(cls, "9084/3",
                PermissibleValue(text="9084/3") )
        setattr(cls, "8935/3",
                PermissibleValue(text="8935/3") )
        setattr(cls, "9814/3",
                PermissibleValue(text="9814/3") )
        setattr(cls, "8075/3",
                PermissibleValue(text="8075/3") )
        setattr(cls, "9687/3",
                PermissibleValue(text="9687/3") )
        setattr(cls, "8444/1",
                PermissibleValue(text="8444/1") )
        setattr(cls, "8000/0",
                PermissibleValue(text="8000/0") )
        setattr(cls, "9818/3",
                PermissibleValue(text="9818/3") )
        setattr(cls, "8370/0",
                PermissibleValue(text="8370/0") )
        setattr(cls, "8147/0",
                PermissibleValue(text="8147/0") )
        setattr(cls, "8141/3",
                PermissibleValue(text="8141/3") )
        setattr(cls, "9044/3",
                PermissibleValue(text="9044/3") )
        setattr(cls, "8347/3",
                PermissibleValue(text="8347/3") )
        setattr(cls, "8581/1",
                PermissibleValue(text="8581/1") )
        setattr(cls, "9734/3",
                PermissibleValue(text="9734/3") )
        setattr(cls, "8110/0",
                PermissibleValue(text="8110/0") )
        setattr(cls, "8552/3",
                PermissibleValue(text="8552/3") )
        setattr(cls, "8502/3",
                PermissibleValue(text="8502/3") )
        setattr(cls, "9591/3",
                PermissibleValue(text="9591/3") )
        setattr(cls, "9124/3",
                PermissibleValue(text="9124/3") )
        setattr(cls, "8900/3",
                PermissibleValue(text="8900/3") )
        setattr(cls, "9571/0",
                PermissibleValue(text="9571/0") )
        setattr(cls, "8460/2",
                PermissibleValue(text="8460/2") )
        setattr(cls, "8505/0",
                PermissibleValue(text="8505/0") )
        setattr(cls, "8501/3",
                PermissibleValue(text="8501/3") )
        setattr(cls, "8903/0",
                PermissibleValue(text="8903/0") )
        setattr(cls, "8591/1",
                PermissibleValue(text="8591/1") )
        setattr(cls, "8580/0",
                PermissibleValue(text="8580/0") )
        setattr(cls, "9231/3",
                PermissibleValue(text="9231/3") )
        setattr(cls, "8503/3",
                PermissibleValue(text="8503/3") )
        setattr(cls, "9840/3",
                PermissibleValue(text="9840/3") )
        setattr(cls, "8150/1",
                PermissibleValue(text="8150/1") )
        setattr(cls, "8830/3",
                PermissibleValue(text="8830/3") )
        setattr(cls, "9221/3",
                PermissibleValue(text="9221/3") )
        setattr(cls, "8670/3",
                PermissibleValue(text="8670/3") )
        setattr(cls, "8936/0",
                PermissibleValue(text="8936/0") )
        setattr(cls, "9041/3",
                PermissibleValue(text="9041/3") )
        setattr(cls, "8163/0",
                PermissibleValue(text="8163/0") )
        setattr(cls, "8401/3",
                PermissibleValue(text="8401/3") )
        setattr(cls, "8965/0",
                PermissibleValue(text="8965/0") )
        setattr(cls, "9252/3",
                PermissibleValue(text="9252/3") )
        setattr(cls, "8826/0",
                PermissibleValue(text="8826/0") )
        setattr(cls, "8213/3",
                PermissibleValue(text="8213/3") )
        setattr(cls, "8248/1",
                PermissibleValue(text="8248/1") )
        setattr(cls, "9055/1",
                PermissibleValue(text="9055/1") )
        setattr(cls, "9718/3",
                PermissibleValue(text="9718/3") )
        setattr(cls, "9800/3",
                PermissibleValue(text="9800/3") )
        setattr(cls, "8727/0",
                PermissibleValue(text="8727/0") )
        setattr(cls, "8811/0",
                PermissibleValue(text="8811/0") )
        setattr(cls, "9014/0",
                PermissibleValue(text="9014/0") )
        setattr(cls, "9340/0",
                PermissibleValue(text="9340/0") )
        setattr(cls, "8680/3",
                PermissibleValue(text="8680/3") )
        setattr(cls, "8081/2",
                PermissibleValue(text="8081/2") )
        setattr(cls, "9180/0",
                PermissibleValue(text="9180/0") )
        setattr(cls, "9240/3",
                PermissibleValue(text="9240/3") )
        setattr(cls, "8014/3",
                PermissibleValue(text="8014/3") )
        setattr(cls, "8044/3",
                PermissibleValue(text="8044/3") )
        setattr(cls, "8330/0",
                PermissibleValue(text="8330/0") )
        setattr(cls, "8900/0",
                PermissibleValue(text="8900/0") )
        setattr(cls, "8120/0",
                PermissibleValue(text="8120/0") )
        setattr(cls, "8921/3",
                PermissibleValue(text="8921/3") )
        setattr(cls, "8051/3",
                PermissibleValue(text="8051/3") )
        setattr(cls, "9320/0",
                PermissibleValue(text="9320/0") )
        setattr(cls, "8121/3",
                PermissibleValue(text="8121/3") )
        setattr(cls, "8720/2",
                PermissibleValue(text="8720/2") )
        setattr(cls, "9680/3",
                PermissibleValue(text="9680/3") )
        setattr(cls, "9511/3",
                PermissibleValue(text="9511/3") )
        setattr(cls, "8314/3",
                PermissibleValue(text="8314/3") )
        setattr(cls, "8034/3",
                PermissibleValue(text="8034/3") )
        setattr(cls, "8805/3",
                PermissibleValue(text="8805/3") )
        setattr(cls, "8078/3",
                PermissibleValue(text="8078/3") )
        setattr(cls, "9120/3",
                PermissibleValue(text="9120/3") )
        setattr(cls, "8380/2",
                PermissibleValue(text="8380/2") )
        setattr(cls, "8090/3",
                PermissibleValue(text="8090/3") )
        setattr(cls, "8300/0",
                PermissibleValue(text="8300/0") )
        setattr(cls, "9684/3",
                PermissibleValue(text="9684/3") )
        setattr(cls, "8860/0",
                PermissibleValue(text="8860/0") )
        setattr(cls, "9193/3",
                PermissibleValue(text="9193/3") )
        setattr(cls, "8472/1",
                PermissibleValue(text="8472/1") )
        setattr(cls, "8154/3",
                PermissibleValue(text="8154/3") )
        setattr(cls, "8200/3",
                PermissibleValue(text="8200/3") )
        setattr(cls, "9020/1",
                PermissibleValue(text="9020/1") )
        setattr(cls, "9728/3",
                PermissibleValue(text="9728/3") )
        setattr(cls, "8346/3",
                PermissibleValue(text="8346/3") )
        setattr(cls, "8270/0",
                PermissibleValue(text="8270/0") )
        setattr(cls, "9123/0",
                PermissibleValue(text="9123/0") )
        setattr(cls, "8142/3",
                PermissibleValue(text="8142/3") )
        setattr(cls, "9738/3",
                PermissibleValue(text="9738/3") )
        setattr(cls, "9970/1",
                PermissibleValue(text="9970/1") )
        setattr(cls, "8640/3",
                PermissibleValue(text="8640/3") )
        setattr(cls, "8430/3",
                PermissibleValue(text="8430/3") )
        setattr(cls, "9045/3",
                PermissibleValue(text="9045/3") )
        setattr(cls, "9490/3",
                PermissibleValue(text="9490/3") )
        setattr(cls, "8931/3",
                PermissibleValue(text="8931/3") )
        setattr(cls, "9174/0",
                PermissibleValue(text="9174/0") )
        setattr(cls, "8343/2",
                PermissibleValue(text="8343/2") )
        setattr(cls, "8077/0",
                PermissibleValue(text="8077/0") )
        setattr(cls, "8220/3",
                PermissibleValue(text="8220/3") )
        setattr(cls, "8250/1",
                PermissibleValue(text="8250/1") )
        setattr(cls, "8572/3",
                PermissibleValue(text="8572/3") )
        setattr(cls, "9534/0",
                PermissibleValue(text="9534/0") )
        setattr(cls, "9020/3",
                PermissibleValue(text="9020/3") )
        setattr(cls, "8600/0",
                PermissibleValue(text="8600/0") )
        setattr(cls, "8240/1",
                PermissibleValue(text="8240/1") )
        setattr(cls, "8281/3",
                PermissibleValue(text="8281/3") )
        setattr(cls, "9507/0",
                PermissibleValue(text="9507/0") )
        setattr(cls, "9055/0",
                PermissibleValue(text="9055/0") )
        setattr(cls, "8313/1",
                PermissibleValue(text="8313/1") )
        setattr(cls, "8800/0",
                PermissibleValue(text="8800/0") )
        setattr(cls, "9054/0",
                PermissibleValue(text="9054/0") )
        setattr(cls, "9322/0",
                PermissibleValue(text="9322/0") )
        setattr(cls, "8500/3",
                PermissibleValue(text="8500/3") )
        setattr(cls, "9750/3",
                PermissibleValue(text="9750/3") )
        setattr(cls, "9312/0",
                PermissibleValue(text="9312/0") )
        setattr(cls, "8660/0",
                PermissibleValue(text="8660/0") )
        setattr(cls, "9867/3",
                PermissibleValue(text="9867/3") )
        setattr(cls, "9384/1",
                PermissibleValue(text="9384/1") )
        setattr(cls, "9442/1",
                PermissibleValue(text="9442/1") )
        setattr(cls, "8802/3",
                PermissibleValue(text="8802/3") )
        setattr(cls, "8681/1",
                PermissibleValue(text="8681/1") )
        setattr(cls, "8145/3",
                PermissibleValue(text="8145/3") )
        setattr(cls, "8324/0",
                PermissibleValue(text="8324/0") )
        setattr(cls, "9301/0",
                PermissibleValue(text="9301/0") )
        setattr(cls, "8407/3",
                PermissibleValue(text="8407/3") )
        setattr(cls, "8360/1",
                PermissibleValue(text="8360/1") )
        setattr(cls, "8960/3",
                PermissibleValue(text="8960/3") )
        setattr(cls, "8623/1",
                PermissibleValue(text="8623/1") )
        setattr(cls, "9965/3",
                PermissibleValue(text="9965/3") )
        setattr(cls, "8420/3",
                PermissibleValue(text="8420/3") )
        setattr(cls, "9898/3",
                PermissibleValue(text="9898/3") )
        setattr(cls, "9992/3",
                PermissibleValue(text="9992/3") )
        setattr(cls, "9100/3",
                PermissibleValue(text="9100/3") )
        setattr(cls, "8451/1",
                PermissibleValue(text="8451/1") )
        setattr(cls, "9717/3",
                PermissibleValue(text="9717/3") )
        setattr(cls, "9400/3",
                PermissibleValue(text="9400/3") )
        setattr(cls, "8172/3",
                PermissibleValue(text="8172/3") )
        setattr(cls, "8155/1",
                PermissibleValue(text="8155/1") )
        setattr(cls, "8824/0",
                PermissibleValue(text="8824/0") )
        setattr(cls, "8221/0",
                PermissibleValue(text="8221/0") )
        setattr(cls, "9874/3",
                PermissibleValue(text="9874/3") )
        setattr(cls, "8261/2",
                PermissibleValue(text="8261/2") )
        setattr(cls, "8005/3",
                PermissibleValue(text="8005/3") )
        setattr(cls, "8504/3",
                PermissibleValue(text="8504/3") )
        setattr(cls, "8010/6",
                PermissibleValue(text="8010/6") )
        setattr(cls, "8710/3",
                PermissibleValue(text="8710/3") )
        setattr(cls, "8400/0",
                PermissibleValue(text="8400/0") )
        setattr(cls, "8514/3",
                PermissibleValue(text="8514/3") )
        setattr(cls, "8240/3",
                PermissibleValue(text="8240/3") )
        setattr(cls, "9101/3",
                PermissibleValue(text="9101/3") )
        setattr(cls, "8140/6",
                PermissibleValue(text="8140/6") )
        setattr(cls, "8940/0",
                PermissibleValue(text="8940/0") )
        setattr(cls, "9342/3",
                PermissibleValue(text="9342/3") )
        setattr(cls, "8020/3",
                PermissibleValue(text="8020/3") )
        setattr(cls, "8773/3",
                PermissibleValue(text="8773/3") )
        setattr(cls, "8160/3",
                PermissibleValue(text="8160/3") )
        setattr(cls, "8095/3",
                PermissibleValue(text="8095/3") )
        setattr(cls, "8470/2",
                PermissibleValue(text="8470/2") )
        setattr(cls, "9280/0",
                PermissibleValue(text="9280/0") )
        setattr(cls, "9708/3",
                PermissibleValue(text="9708/3") )
        setattr(cls, "8855/3",
                PermissibleValue(text="8855/3") )
        setattr(cls, "8761/0",
                PermissibleValue(text="8761/0") )
        setattr(cls, "9991/3",
                PermissibleValue(text="9991/3") )
        setattr(cls, "9110/0",
                PermissibleValue(text="9110/0") )
        setattr(cls, "9752/1",
                PermissibleValue(text="9752/1") )
        setattr(cls, "9150/1",
                PermissibleValue(text="9150/1") )
        setattr(cls, "8630/0",
                PermissibleValue(text="8630/0") )
        setattr(cls, "8330/1",
                PermissibleValue(text="8330/1") )
        setattr(cls, "9181/3",
                PermissibleValue(text="9181/3") )
        setattr(cls, "8813/0",
                PermissibleValue(text="8813/0") )
        setattr(cls, "8443/0",
                PermissibleValue(text="8443/0") )
        setattr(cls, "8832/0",
                PermissibleValue(text="8832/0") )
        setattr(cls, "8650/3",
                PermissibleValue(text="8650/3") )
        setattr(cls, "9040/3",
                PermissibleValue(text="9040/3") )
        setattr(cls, "9762/3",
                PermissibleValue(text="9762/3") )
        setattr(cls, "9460/3",
                PermissibleValue(text="9460/3") )
        setattr(cls, "8852/3",
                PermissibleValue(text="8852/3") )
        setattr(cls, "8361/0",
                PermissibleValue(text="8361/0") )
        setattr(cls, "9251/1",
                PermissibleValue(text="9251/1") )
        setattr(cls, "8317/3",
                PermissibleValue(text="8317/3") )
        setattr(cls, "8682/1",
                PermissibleValue(text="8682/1") )
        setattr(cls, "8833/3",
                PermissibleValue(text="8833/3") )
        setattr(cls, "8741/2",
                PermissibleValue(text="8741/2") )
        setattr(cls, "8967/0",
                PermissibleValue(text="8967/0") )
        setattr(cls, "8163/2",
                PermissibleValue(text="8163/2") )
        setattr(cls, "9698/3",
                PermissibleValue(text="9698/3") )
        setattr(cls, "8631/3",
                PermissibleValue(text="8631/3") )
        setattr(cls, "9104/1",
                PermissibleValue(text="9104/1") )
        setattr(cls, "9060/3",
                PermissibleValue(text="9060/3") )
        setattr(cls, "9451/3",
                PermissibleValue(text="9451/3") )
        setattr(cls, "8824/1",
                PermissibleValue(text="8824/1") )
        setattr(cls, "9811/3",
                PermissibleValue(text="9811/3") )
        setattr(cls, "9122/0",
                PermissibleValue(text="9122/0") )
        setattr(cls, "8123/3",
                PermissibleValue(text="8123/3") )
        setattr(cls, "9262/0",
                PermissibleValue(text="9262/0") )
        setattr(cls, "8772/0",
                PermissibleValue(text="8772/0") )
        setattr(cls, "8743/3",
                PermissibleValue(text="8743/3") )
        setattr(cls, "9014/1",
                PermissibleValue(text="9014/1") )
        setattr(cls, "8050/2",
                PermissibleValue(text="8050/2") )
        setattr(cls, "9898/1",
                PermissibleValue(text="9898/1") )
        setattr(cls, "8815/0",
                PermissibleValue(text="8815/0") )
        setattr(cls, "9872/3",
                PermissibleValue(text="9872/3") )
        setattr(cls, "8290/0",
                PermissibleValue(text="8290/0") )
        setattr(cls, "9665/3",
                PermissibleValue(text="9665/3") )
        setattr(cls, "8770/3",
                PermissibleValue(text="8770/3") )
        setattr(cls, "8000/3",
                PermissibleValue(text="8000/3") )
        setattr(cls, "8813/3",
                PermissibleValue(text="8813/3") )
        setattr(cls, "9764/3",
                PermissibleValue(text="9764/3") )
        setattr(cls, "9000/1",
                PermissibleValue(text="9000/1") )
        setattr(cls, "9570/0",
                PermissibleValue(text="9570/0") )
        setattr(cls, "9532/0",
                PermissibleValue(text="9532/0") )
        setattr(cls, "9475/3",
                PermissibleValue(text="9475/3") )
        setattr(cls, "8690/1",
                PermissibleValue(text="8690/1") )
        setattr(cls, "9110/3",
                PermissibleValue(text="9110/3") )
        setattr(cls, "8174/3",
                PermissibleValue(text="8174/3") )
        setattr(cls, "8490/3",
                PermissibleValue(text="8490/3") )
        setattr(cls, "8910/3",
                PermissibleValue(text="8910/3") )
        setattr(cls, "9690/3",
                PermissibleValue(text="9690/3") )
        setattr(cls, "9540/3",
                PermissibleValue(text="9540/3") )
        setattr(cls, "8811/1",
                PermissibleValue(text="8811/1") )
        setattr(cls, "9817/3",
                PermissibleValue(text="9817/3") )
        setattr(cls, "9390/1",
                PermissibleValue(text="9390/1") )
        setattr(cls, "9421/1",
                PermissibleValue(text="9421/1") )
        setattr(cls, "8254/3",
                PermissibleValue(text="8254/3") )
        setattr(cls, "9870/3",
                PermissibleValue(text="9870/3") )
        setattr(cls, "9550/0",
                PermissibleValue(text="9550/0") )
        setattr(cls, "9271/0",
                PermissibleValue(text="9271/0") )
        setattr(cls, "9330/3",
                PermissibleValue(text="9330/3") )
        setattr(cls, "9651/3",
                PermissibleValue(text="9651/3") )
        setattr(cls, "8582/3",
                PermissibleValue(text="8582/3") )
        setattr(cls, "9701/3",
                PermissibleValue(text="9701/3") )
        setattr(cls, "9876/3",
                PermissibleValue(text="9876/3") )
        setattr(cls, "8587/0",
                PermissibleValue(text="8587/0") )
        setattr(cls, "9984/3",
                PermissibleValue(text="9984/3") )
        setattr(cls, "8310/0",
                PermissibleValue(text="8310/0") )
        setattr(cls, "8011/3",
                PermissibleValue(text="8011/3") )
        setattr(cls, "9252/0",
                PermissibleValue(text="9252/0") )
        setattr(cls, "8000/9",
                PermissibleValue(text="8000/9") )
        setattr(cls, "8560/3",
                PermissibleValue(text="8560/3") )
        setattr(cls, "8610/0",
                PermissibleValue(text="8610/0") )
        setattr(cls, "8450/0",
                PermissibleValue(text="8450/0") )
        setattr(cls, "8934/3",
                PermissibleValue(text="8934/3") )
        setattr(cls, "9250/1",
                PermissibleValue(text="9250/1") )
        setattr(cls, "9052/3",
                PermissibleValue(text="9052/3") )
        setattr(cls, "9768/1",
                PermissibleValue(text="9768/1") )
        setattr(cls, "8340/3",
                PermissibleValue(text="8340/3") )
        setattr(cls, "9805/3",
                PermissibleValue(text="9805/3") )
        setattr(cls, "8255/3",
                PermissibleValue(text="8255/3") )
        setattr(cls, "8140/1",
                PermissibleValue(text="8140/1") )
        setattr(cls, "9826/3",
                PermissibleValue(text="9826/3") )
        setattr(cls, "8540/3",
                PermissibleValue(text="8540/3") )
        setattr(cls, "9971/3",
                PermissibleValue(text="9971/3") )
        setattr(cls, "8592/1",
                PermissibleValue(text="8592/1") )
        setattr(cls, "8975/1",
                PermissibleValue(text="8975/1") )
        setattr(cls, "9390/0",
                PermissibleValue(text="9390/0") )
        setattr(cls, "9675/3",
                PermissibleValue(text="9675/3") )
        setattr(cls, "8190/0",
                PermissibleValue(text="8190/0") )
        setattr(cls, "8581/3",
                PermissibleValue(text="8581/3") )
        setattr(cls, "8601/0",
                PermissibleValue(text="8601/0") )
        setattr(cls, "8761/1",
                PermissibleValue(text="8761/1") )
        setattr(cls, "8335/3",
                PermissibleValue(text="8335/3") )
        setattr(cls, "8409/3",
                PermissibleValue(text="8409/3") )
        setattr(cls, "9015/0",
                PermissibleValue(text="9015/0") )
        setattr(cls, "8383/3",
                PermissibleValue(text="8383/3") )
        setattr(cls, "8032/3",
                PermissibleValue(text="8032/3") )
        setattr(cls, "8152/3",
                PermissibleValue(text="8152/3") )
        setattr(cls, "9173/0",
                PermissibleValue(text="9173/0") )
        setattr(cls, "8312/3",
                PermissibleValue(text="8312/3") )
        setattr(cls, "8500/2",
                PermissibleValue(text="8500/2") )
        setattr(cls, "8650/0",
                PermissibleValue(text="8650/0") )
        setattr(cls, "8550/1",
                PermissibleValue(text="8550/1") )
        setattr(cls, "8262/3",
                PermissibleValue(text="8262/3") )
        setattr(cls, "9971/1",
                PermissibleValue(text="9971/1") )
        setattr(cls, "8741/3",
                PermissibleValue(text="8741/3") )
        setattr(cls, "8153/3",
                PermissibleValue(text="8153/3") )
        setattr(cls, "8880/0",
                PermissibleValue(text="8880/0") )
        setattr(cls, "8230/2",
                PermissibleValue(text="8230/2") )
        setattr(cls, "9477/3",
                PermissibleValue(text="9477/3") )
        setattr(cls, "8711/3",
                PermissibleValue(text="8711/3") )
        setattr(cls, "8550/3",
                PermissibleValue(text="8550/3") )
        setattr(cls, "8728/0",
                PermissibleValue(text="8728/0") )
        setattr(cls, "8950/3",
                PermissibleValue(text="8950/3") )
        setattr(cls, "8381/1",
                PermissibleValue(text="8381/1") )
        setattr(cls, "8045/3",
                PermissibleValue(text="8045/3") )
        setattr(cls, "8974/1",
                PermissibleValue(text="8974/1") )
        setattr(cls, "9072/3",
                PermissibleValue(text="9072/3") )
        setattr(cls, "8002/3",
                PermissibleValue(text="8002/3") )
        setattr(cls, "8146/0",
                PermissibleValue(text="8146/0") )
        setattr(cls, "8270/3",
                PermissibleValue(text="8270/3") )
        setattr(cls, "8452/3",
                PermissibleValue(text="8452/3") )
        setattr(cls, "9827/3",
                PermissibleValue(text="9827/3") )
        setattr(cls, "9385/3",
                PermissibleValue(text="9385/3") )
        setattr(cls, "9140/3",
                PermissibleValue(text="9140/3") )
        setattr(cls, "8851/3",
                PermissibleValue(text="8851/3") )
        setattr(cls, "9351/1",
                PermissibleValue(text="9351/1") )
        setattr(cls, "8482/3",
                PermissibleValue(text="8482/3") )
        setattr(cls, "9013/0",
                PermissibleValue(text="9013/0") )
        setattr(cls, "8331/3",
                PermissibleValue(text="8331/3") )
        setattr(cls, "8010/0",
                PermissibleValue(text="8010/0") )
        setattr(cls, "9100/1",
                PermissibleValue(text="9100/1") )
        setattr(cls, "8851/0",
                PermissibleValue(text="8851/0") )
        setattr(cls, "8151/3",
                PermissibleValue(text="8151/3") )
        setattr(cls, "8583/3",
                PermissibleValue(text="8583/3") )
        setattr(cls, "8342/3",
                PermissibleValue(text="8342/3") )
        setattr(cls, "8272/0",
                PermissibleValue(text="8272/0") )
        setattr(cls, "9270/0",
                PermissibleValue(text="9270/0") )
        setattr(cls, "8585/3",
                PermissibleValue(text="8585/3") )
        setattr(cls, "8190/3",
                PermissibleValue(text="8190/3") )
        setattr(cls, "8144/3",
                PermissibleValue(text="8144/3") )
        setattr(cls, "8640/1",
                PermissibleValue(text="8640/1") )
        setattr(cls, "9502/3",
                PermissibleValue(text="9502/3") )
        setattr(cls, "9987/3",
                PermissibleValue(text="9987/3") )
        setattr(cls, "8840/0",
                PermissibleValue(text="8840/0") )
        setattr(cls, "8585/1",
                PermissibleValue(text="8585/1") )
        setattr(cls, "9571/3",
                PermissibleValue(text="9571/3") )
        setattr(cls, "8074/3",
                PermissibleValue(text="8074/3") )
        setattr(cls, "8350/3",
                PermissibleValue(text="8350/3") )
        setattr(cls, "9445/3",
                PermissibleValue(text="9445/3") )
        setattr(cls, "8490/6",
                PermissibleValue(text="8490/6") )
        setattr(cls, "8430/1",
                PermissibleValue(text="8430/1") )
        setattr(cls, "9737/3",
                PermissibleValue(text="9737/3") )
        setattr(cls, "9989/3",
                PermissibleValue(text="9989/3") )
        setattr(cls, "8261/0",
                PermissibleValue(text="8261/0") )
        setattr(cls, "9350/1",
                PermissibleValue(text="9350/1") )
        setattr(cls, "8042/3",
                PermissibleValue(text="8042/3") )
        setattr(cls, "8815/3",
                PermissibleValue(text="8815/3") )
        setattr(cls, "9866/3",
                PermissibleValue(text="9866/3") )
        setattr(cls, "8509/2",
                PermissibleValue(text="8509/2") )
        setattr(cls, "8543/3",
                PermissibleValue(text="8543/3") )
        setattr(cls, "9425/3",
                PermissibleValue(text="9425/3") )
        setattr(cls, "9581/3",
                PermissibleValue(text="9581/3") )
        setattr(cls, "9161/1",
                PermissibleValue(text="9161/1") )
        setattr(cls, "8804/3",
                PermissibleValue(text="8804/3") )
        setattr(cls, "8631/1",
                PermissibleValue(text="8631/1") )
        setattr(cls, "8175/3",
                PermissibleValue(text="8175/3") )
        setattr(cls, "8316/3",
                PermissibleValue(text="8316/3") )
        setattr(cls, "8315/3",
                PermissibleValue(text="8315/3") )
        setattr(cls, "8823/0",
                PermissibleValue(text="8823/0") )
        setattr(cls, "9695/3",
                PermissibleValue(text="9695/3") )
        setattr(cls, "9509/1",
                PermissibleValue(text="9509/1") )
        setattr(cls, "8460/0",
                PermissibleValue(text="8460/0") )
        setattr(cls, "9061/3",
                PermissibleValue(text="9061/3") )
        setattr(cls, "8473/1",
                PermissibleValue(text="8473/1") )
        setattr(cls, "8970/3",
                PermissibleValue(text="8970/3") )
        setattr(cls, "8542/3",
                PermissibleValue(text="8542/3") )
        setattr(cls, "9503/3",
                PermissibleValue(text="9503/3") )
        setattr(cls, "9043/3",
                PermissibleValue(text="9043/3") )
        setattr(cls, "8374/0",
                PermissibleValue(text="8374/0") )
        setattr(cls, "9251/3",
                PermissibleValue(text="9251/3") )
        setattr(cls, "9835/3",
                PermissibleValue(text="9835/3") )
        setattr(cls, "8052/2",
                PermissibleValue(text="8052/2") )
        setattr(cls, "8094/3",
                PermissibleValue(text="8094/3") )
        setattr(cls, "9361/1",
                PermissibleValue(text="9361/1") )
        setattr(cls, "8774/3",
                PermissibleValue(text="8774/3") )
        setattr(cls, "9492/0",
                PermissibleValue(text="9492/0") )
        setattr(cls, "9538/3",
                PermissibleValue(text="9538/3") )
        setattr(cls, "9691/3",
                PermissibleValue(text="9691/3") )
        setattr(cls, "9727/3",
                PermissibleValue(text="9727/3") )
        setattr(cls, "9380/3",
                PermissibleValue(text="9380/3") )
        setattr(cls, "9373/0",
                PermissibleValue(text="9373/0") )
        setattr(cls, "8100/0",
                PermissibleValue(text="8100/0") )
        setattr(cls, "8332/3",
                PermissibleValue(text="8332/3") )
        setattr(cls, "8761/3",
                PermissibleValue(text="8761/3") )
        setattr(cls, "8520/2",
                PermissibleValue(text="8520/2") )
        setattr(cls, "8263/3",
                PermissibleValue(text="8263/3") )
        setattr(cls, "9365/3",
                PermissibleValue(text="9365/3") )
        setattr(cls, "8503/2",
                PermissibleValue(text="8503/2") )
        setattr(cls, "9833/3",
                PermissibleValue(text="9833/3") )
        setattr(cls, "8030/3",
                PermissibleValue(text="8030/3") )
        setattr(cls, "9831/3",
                PermissibleValue(text="9831/3") )
        setattr(cls, "8082/3",
                PermissibleValue(text="8082/3") )
        setattr(cls, "8404/0",
                PermissibleValue(text="8404/0") )
        setattr(cls, "8253/3",
                PermissibleValue(text="8253/3") )
        setattr(cls, "8050/3",
                PermissibleValue(text="8050/3") )
        setattr(cls, "8857/3",
                PermissibleValue(text="8857/3") )
        setattr(cls, "8213/0",
                PermissibleValue(text="8213/0") )
        setattr(cls, "8371/0",
                PermissibleValue(text="8371/0") )
        setattr(cls, "9430/3",
                PermissibleValue(text="9430/3") )
        setattr(cls, "8140/3",
                PermissibleValue(text="8140/3") )
        setattr(cls, "9539/3",
                PermissibleValue(text="9539/3") )
        setattr(cls, "8409/0",
                PermissibleValue(text="8409/0") )
        setattr(cls, "8131/3",
                PermissibleValue(text="8131/3") )
        setattr(cls, "8722/0",
                PermissibleValue(text="8722/0") )
        setattr(cls, "9064/3",
                PermissibleValue(text="9064/3") )
        setattr(cls, "9194/3",
                PermissibleValue(text="9194/3") )
        setattr(cls, "8580/3",
                PermissibleValue(text="8580/3") )
        setattr(cls, "8881/0",
                PermissibleValue(text="8881/0") )
        setattr(cls, "8101/0",
                PermissibleValue(text="8101/0") )
        setattr(cls, "9052/0",
                PermissibleValue(text="9052/0") )
        setattr(cls, "8620/3",
                PermissibleValue(text="8620/3") )
        setattr(cls, "8011/0",
                PermissibleValue(text="8011/0") )
        setattr(cls, "8830/1",
                PermissibleValue(text="8830/1") )
        setattr(cls, "8730/0",
                PermissibleValue(text="8730/0") )
        setattr(cls, "9820/3",
                PermissibleValue(text="9820/3") )
        setattr(cls, "8822/1",
                PermissibleValue(text="8822/1") )
        setattr(cls, "9040/0",
                PermissibleValue(text="9040/0") )
        setattr(cls, "8000/1",
                PermissibleValue(text="8000/1") )
        setattr(cls, "8148/2",
                PermissibleValue(text="8148/2") )
        setattr(cls, "8480/6",
                PermissibleValue(text="8480/6") )
        setattr(cls, "9671/3",
                PermissibleValue(text="9671/3") )
        setattr(cls, "8400/1",
                PermissibleValue(text="8400/1") )
        setattr(cls, "9760/3",
                PermissibleValue(text="9760/3") )
        setattr(cls, "8801/3",
                PermissibleValue(text="8801/3") )
        setattr(cls, "9689/3",
                PermissibleValue(text="9689/3") )
        setattr(cls, "9073/1",
                PermissibleValue(text="9073/1") )
        setattr(cls, "8720/0",
                PermissibleValue(text="8720/0") )
        setattr(cls, "9220/3",
                PermissibleValue(text="9220/3") )
        setattr(cls, "8413/3",
                PermissibleValue(text="8413/3") )
        setattr(cls, "8933/3",
                PermissibleValue(text="8933/3") )
        setattr(cls, "8935/1",
                PermissibleValue(text="8935/1") )
        setattr(cls, "8410/3",
                PermissibleValue(text="8410/3") )
        setattr(cls, "8711/0",
                PermissibleValue(text="8711/0") )
        setattr(cls, "9372/3",
                PermissibleValue(text="9372/3") )
        setattr(cls, "8043/3",
                PermissibleValue(text="8043/3") )
        setattr(cls, "9940/3",
                PermissibleValue(text="9940/3") )
        setattr(cls, "9410/3",
                PermissibleValue(text="9410/3") )
        setattr(cls, "8221/3",
                PermissibleValue(text="8221/3") )
        setattr(cls, "8901/3",
                PermissibleValue(text="8901/3") )
        setattr(cls, "8102/3",
                PermissibleValue(text="8102/3") )
        setattr(cls, "8092/3",
                PermissibleValue(text="8092/3") )
        setattr(cls, "9172/0",
                PermissibleValue(text="9172/0") )
        setattr(cls, "8800/3",
                PermissibleValue(text="8800/3") )
        setattr(cls, "9530/0",
                PermissibleValue(text="9530/0") )
        setattr(cls, "9679/3",
                PermissibleValue(text="9679/3") )
        setattr(cls, "8524/3",
                PermissibleValue(text="8524/3") )
        setattr(cls, "9171/0",
                PermissibleValue(text="9171/0") )
        setattr(cls, "9161/0",
                PermissibleValue(text="9161/0") )
        setattr(cls, "9450/3",
                PermissibleValue(text="9450/3") )
        setattr(cls, "9080/0",
                PermissibleValue(text="9080/0") )
        setattr(cls, "8728/3",
                PermissibleValue(text="8728/3") )
        setattr(cls, "8401/0",
                PermissibleValue(text="8401/0") )
        setattr(cls, "9210/1",
                PermissibleValue(text="9210/1") )
        setattr(cls, "8204/0",
                PermissibleValue(text="8204/0") )
        setattr(cls, "9150/0",
                PermissibleValue(text="9150/0") )
        setattr(cls, "9182/3",
                PermissibleValue(text="9182/3") )
        setattr(cls, "8770/0",
                PermissibleValue(text="8770/0") )
        setattr(cls, "9753/1",
                PermissibleValue(text="9753/1") )
        setattr(cls, "8982/0",
                PermissibleValue(text="8982/0") )
        setattr(cls, "9110/1",
                PermissibleValue(text="9110/1") )
        setattr(cls, "8370/3",
                PermissibleValue(text="8370/3") )
        setattr(cls, "8470/3",
                PermissibleValue(text="8470/3") )
        setattr(cls, "9733/3",
                PermissibleValue(text="9733/3") )
        setattr(cls, "8740/0",
                PermissibleValue(text="8740/0") )
        setattr(cls, "8408/1",
                PermissibleValue(text="8408/1") )
        setattr(cls, "8680/0",
                PermissibleValue(text="8680/0") )
        setattr(cls, "9120/0",
                PermissibleValue(text="9120/0") )
        setattr(cls, "8680/1",
                PermissibleValue(text="8680/1") )
        setattr(cls, "8806/3",
                PermissibleValue(text="8806/3") )
        setattr(cls, "8033/3",
                PermissibleValue(text="8033/3") )
        setattr(cls, "8093/3",
                PermissibleValue(text="8093/3") )
        setattr(cls, "9071/3",
                PermissibleValue(text="9071/3") )
        setattr(cls, "9724/3",
                PermissibleValue(text="9724/3") )
        setattr(cls, "8050/0",
                PermissibleValue(text="8050/0") )
        setattr(cls, "9754/3",
                PermissibleValue(text="9754/3") )
        setattr(cls, "8742/3",
                PermissibleValue(text="8742/3") )
        setattr(cls, "9962/3",
                PermissibleValue(text="9962/3") )
        setattr(cls, "8171/3",
                PermissibleValue(text="8171/3") )
        setattr(cls, "9531/0",
                PermissibleValue(text="9531/0") )
        setattr(cls, "8894/3",
                PermissibleValue(text="8894/3") )
        setattr(cls, "8072/3",
                PermissibleValue(text="8072/3") )
        setattr(cls, "9270/1",
                PermissibleValue(text="9270/1") )
        setattr(cls, "8333/3",
                PermissibleValue(text="8333/3") )
        setattr(cls, "8936/3",
                PermissibleValue(text="8936/3") )
        setattr(cls, "8052/0",
                PermissibleValue(text="8052/0") )
        setattr(cls, "8507/2",
                PermissibleValue(text="8507/2") )
        setattr(cls, "8122/3",
                PermissibleValue(text="8122/3") )
        setattr(cls, "8170/0",
                PermissibleValue(text="8170/0") )
        setattr(cls, "9530/3",
                PermissibleValue(text="9530/3") )
        setattr(cls, "8085/3",
                PermissibleValue(text="8085/3") )
        setattr(cls, "8693/1",
                PermissibleValue(text="8693/1") )
        setattr(cls, "9210/0",
                PermissibleValue(text="9210/0") )
        setattr(cls, "9364/3",
                PermissibleValue(text="9364/3") )
        setattr(cls, "8951/3",
                PermissibleValue(text="8951/3") )
        setattr(cls, "9986/3",
                PermissibleValue(text="9986/3") )
        setattr(cls, "9765/1",
                PermissibleValue(text="9765/1") )
        setattr(cls, "8140/33",
                PermissibleValue(text="8140/33") )
        setattr(cls, "9132/0",
                PermissibleValue(text="9132/0") )
        setattr(cls, "9670/3",
                PermissibleValue(text="9670/3") )
        setattr(cls, "9230/0",
                PermissibleValue(text="9230/0") )
        setattr(cls, "9875/3",
                PermissibleValue(text="9875/3") )
        setattr(cls, "8408/3",
                PermissibleValue(text="8408/3") )
        setattr(cls, "8408/0",
                PermissibleValue(text="8408/0") )
        setattr(cls, "8001/0",
                PermissibleValue(text="8001/0") )
        setattr(cls, "8245/3",
                PermissibleValue(text="8245/3") )
        setattr(cls, "8800/9",
                PermissibleValue(text="8800/9") )
        setattr(cls, "9812/3",
                PermissibleValue(text="9812/3") )
        setattr(cls, "8746/3",
                PermissibleValue(text="8746/3") )
        setattr(cls, "9401/3",
                PermissibleValue(text="9401/3") )
        setattr(cls, "8440/3",
                PermissibleValue(text="8440/3") )
        setattr(cls, "8474/1",
                PermissibleValue(text="8474/1") )
        setattr(cls, "9740/1",
                PermissibleValue(text="9740/1") )
        setattr(cls, "8191/0",
                PermissibleValue(text="8191/0") )
        setattr(cls, "8077/2",
                PermissibleValue(text="8077/2") )
        setattr(cls, "8634/1",
                PermissibleValue(text="8634/1") )
        setattr(cls, "8890/1",
                PermissibleValue(text="8890/1") )
        setattr(cls, "9491/0",
                PermissibleValue(text="9491/0") )
        setattr(cls, "9490/0",
                PermissibleValue(text="9490/0") )
        setattr(cls, "9275/0",
                PermissibleValue(text="9275/0") )
        setattr(cls, "9084/0",
                PermissibleValue(text="9084/0") )
        setattr(cls, "9191/0",
                PermissibleValue(text="9191/0") )
        setattr(cls, "8381/0",
                PermissibleValue(text="8381/0") )
        setattr(cls, "8990/3",
                PermissibleValue(text="8990/3") )
        setattr(cls, "9896/3",
                PermissibleValue(text="9896/3") )
        setattr(cls, "8341/3",
                PermissibleValue(text="8341/3") )
        setattr(cls, "8960/1",
                PermissibleValue(text="8960/1") )
        setattr(cls, "9871/3",
                PermissibleValue(text="9871/3") )
        setattr(cls, "8249/3",
                PermissibleValue(text="8249/3") )
        setattr(cls, "9580/3",
                PermissibleValue(text="9580/3") )
        setattr(cls, "8474/3",
                PermissibleValue(text="8474/3") )
        setattr(cls, "9767/1",
                PermissibleValue(text="9767/1") )
        setattr(cls, "8722/3",
                PermissibleValue(text="8722/3") )
        setattr(cls, "8013/3",
                PermissibleValue(text="8013/3") )
        setattr(cls, "9699/3",
                PermissibleValue(text="9699/3") )
        setattr(cls, "9662/3",
                PermissibleValue(text="9662/3") )
        setattr(cls, "8481/3",
                PermissibleValue(text="8481/3") )
        setattr(cls, "9012/0",
                PermissibleValue(text="9012/0") )
        setattr(cls, "9133/3",
                PermissibleValue(text="9133/3") )
        setattr(cls, "9420/3",
                PermissibleValue(text="9420/3") )
        setattr(cls, "8086/3",
                PermissibleValue(text="8086/3") )
        setattr(cls, "8076/2",
                PermissibleValue(text="8076/2") )
        setattr(cls, "9130/3",
                PermissibleValue(text="9130/3") )
        setattr(cls, "8140/0",
                PermissibleValue(text="8140/0") )
        setattr(cls, "9396/3",
                PermissibleValue(text="9396/3") )
        setattr(cls, "8402/3",
                PermissibleValue(text="8402/3") )
        setattr(cls, "8588/3",
                PermissibleValue(text="8588/3") )
        setattr(cls, "8621/1",
                PermissibleValue(text="8621/1") )
        setattr(cls, "9444/1",
                PermissibleValue(text="9444/1") )
        setattr(cls, "9080/1",
                PermissibleValue(text="9080/1") )
        setattr(cls, "9042/3",
                PermissibleValue(text="9042/3") )
        setattr(cls, "9195/3",
                PermissibleValue(text="9195/3") )
        setattr(cls, "9731/3",
                PermissibleValue(text="9731/3") )
        setattr(cls, "8210/0",
                PermissibleValue(text="8210/0") )
        setattr(cls, "8156/1",
                PermissibleValue(text="8156/1") )
        setattr(cls, "9360/1",
                PermissibleValue(text="9360/1") )
        setattr(cls, "8311/1",
                PermissibleValue(text="8311/1") )
        setattr(cls, "8820/0",
                PermissibleValue(text="8820/0") )
        setattr(cls, "8041/3",
                PermissibleValue(text="8041/3") )
        setattr(cls, "9170/3",
                PermissibleValue(text="9170/3") )
        setattr(cls, "9950/3",
                PermissibleValue(text="9950/3") )
        setattr(cls, "8150/0",
                PermissibleValue(text="8150/0") )
        setattr(cls, "9652/3",
                PermissibleValue(text="9652/3") )
        setattr(cls, "8772/3",
                PermissibleValue(text="8772/3") )
        setattr(cls, "8148/0",
                PermissibleValue(text="8148/0") )
        setattr(cls, "8853/3",
                PermissibleValue(text="8853/3") )
        setattr(cls, "8525/3",
                PermissibleValue(text="8525/3") )
        setattr(cls, "9311/0",
                PermissibleValue(text="9311/0") )
        setattr(cls, "9363/0",
                PermissibleValue(text="9363/0") )
        setattr(cls, "9508/3",
                PermissibleValue(text="9508/3") )
        setattr(cls, "9533/0",
                PermissibleValue(text="9533/0") )
        setattr(cls, "9766/1",
                PermissibleValue(text="9766/1") )
        setattr(cls, "9302/3",
                PermissibleValue(text="9302/3") )
        setattr(cls, "9470/3",
                PermissibleValue(text="9470/3") )
        setattr(cls, "9150/3",
                PermissibleValue(text="9150/3") )
        setattr(cls, "9540/1",
                PermissibleValue(text="9540/1") )
        setattr(cls, "9014/3",
                PermissibleValue(text="9014/3") )
        setattr(cls, "8850/1",
                PermissibleValue(text="8850/1") )
        setattr(cls, "8096/0",
                PermissibleValue(text="8096/0") )
        setattr(cls, "9135/1",
                PermissibleValue(text="9135/1") )
        setattr(cls, "8201/2",
                PermissibleValue(text="8201/2") )
        setattr(cls, "8345/3",
                PermissibleValue(text="8345/3") )
        setattr(cls, "9381/3",
                PermissibleValue(text="9381/3") )
        setattr(cls, "8506/0",
                PermissibleValue(text="8506/0") )
        setattr(cls, "8842/3",
                PermissibleValue(text="8842/3") )
        setattr(cls, "9220/1",
                PermissibleValue(text="9220/1") )
        setattr(cls, "9030/0",
                PermissibleValue(text="9030/0") )
        setattr(cls, "9086/3",
                PermissibleValue(text="9086/3") )
        setattr(cls, "9985/3",
                PermissibleValue(text="9985/3") )
        setattr(cls, "9759/3",
                PermissibleValue(text="9759/3") )
        setattr(cls, "8453/0",
                PermissibleValue(text="8453/0") )
        setattr(cls, "8895/0",
                PermissibleValue(text="8895/0") )
        setattr(cls, "8130/2",
                PermissibleValue(text="8130/2") )
        setattr(cls, "8720/6",
                PermissibleValue(text="8720/6") )
        setattr(cls, "8040/3",
                PermissibleValue(text="8040/3") )
        setattr(cls, "8800/6",
                PermissibleValue(text="8800/6") )
        setattr(cls, "8950/6",
                PermissibleValue(text="8950/6") )
        setattr(cls, "8482/6",
                PermissibleValue(text="8482/6") )
        setattr(cls, "8240/6",
                PermissibleValue(text="8240/6") )
        setattr(cls, "8804/6",
                PermissibleValue(text="8804/6") )
        setattr(cls, "8249/6",
                PermissibleValue(text="8249/6") )
        setattr(cls, "9180/6",
                PermissibleValue(text="9180/6") )
        setattr(cls, "8020/6",
                PermissibleValue(text="8020/6") )
        setattr(cls, "8311/6",
                PermissibleValue(text="8311/6") )
        setattr(cls, "8441/6",
                PermissibleValue(text="8441/6") )
        setattr(cls, "8500/6",
                PermissibleValue(text="8500/6") )
        setattr(cls, "9440/6",
                PermissibleValue(text="9440/6") )
        setattr(cls, "8046/6",
                PermissibleValue(text="8046/6") )
        setattr(cls, "8041/6",
                PermissibleValue(text="8041/6") )
        setattr(cls, "8471/1",
                PermissibleValue(text="8471/1") )
        setattr(cls, "8801/6",
                PermissibleValue(text="8801/6") )
        setattr(cls, "8310/6",
                PermissibleValue(text="8310/6") )
        setattr(cls, "8920/6",
                PermissibleValue(text="8920/6") )
        setattr(cls, "8806/6",
                PermissibleValue(text="8806/6") )

class EnumCRDCHDiagnosisDiseaseStatus(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Diagnosis disease_status
    """
    Unknown = PermissibleValue(text="Unknown")

    _defn = EnumDefinition(
        name="EnumCRDCHDiagnosisDiseaseStatus",
        description="Autogenerated Enumeration for CRDC-H Diagnosis disease_status",
        code_set=None,
        code_set_version="2021-12-16T18:04:21.392448+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Initial Diagnosis",
                PermissibleValue(text="Initial Diagnosis") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "Progressive Disease",
                PermissibleValue(text="Progressive Disease") )
        setattr(cls, "Recurrent Disease",
                PermissibleValue(text="Recurrent Disease") )
        setattr(cls, "Residual Disease",
                PermissibleValue(text="Residual Disease") )

class EnumCRDCHDiagnosisMethodOfDiagnosis(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Diagnosis method_of_diagnosis
    """
    Laparoscopy = PermissibleValue(text="Laparoscopy",
                                             description="Laparoscopy")
    Autopsy = PermissibleValue(text="Autopsy",
                                     description="Autopsy")
    Thoracentesis = PermissibleValue(text="Thoracentesis",
                                                 description="Thoracentesis")
    Laparotomy = PermissibleValue(text="Laparotomy",
                                           description="Laparotomy")
    Cystoscopy = PermissibleValue(text="Cystoscopy",
                                           description="Cystoscopy")
    Biopsy = PermissibleValue(text="Biopsy",
                                   description="Biopsy")
    Other = PermissibleValue(text="Other",
                                 description="Other")
    Debulking = PermissibleValue(text="Debulking",
                                         description="Debulking")
    Enucleation = PermissibleValue(text="Enucleation",
                                             description="Enucleation")
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    Cytology = PermissibleValue(text="Cytology",
                                       description="Cytology")
    Imaging = PermissibleValue(text="Imaging",
                                     description="Imaging Technique")

    _defn = EnumDefinition(
        name="EnumCRDCHDiagnosisMethodOfDiagnosis",
        description="Autogenerated Enumeration for CRDC-H Diagnosis method_of_diagnosis",
        code_set=None,
        code_set_version="2021-12-16T18:04:21.594708+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Core Biopsy",
                PermissibleValue(text="Core Biopsy",
                                 description="Core Biopsy") )
        setattr(cls, "Pathologic Review",
                PermissibleValue(text="Pathologic Review",
                                 description="Pathologic Examination") )
        setattr(cls, "Ultrasound Guided Biopsy",
                PermissibleValue(text="Ultrasound Guided Biopsy",
                                 description="Ultrasound guided biopsy") )
        setattr(cls, "Incisional Biopsy",
                PermissibleValue(text="Incisional Biopsy",
                                 description="Incisional Biopsy") )
        setattr(cls, "Pap Smear",
                PermissibleValue(text="Pap Smear",
                                 description="Papanicolaou Smear Procedure") )
        setattr(cls, "Diagnostic Imaging",
                PermissibleValue(text="Diagnostic Imaging",
                                 description="Diagnostic Imaging") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported",
                                 description="Not Reported") )
        setattr(cls, "Surgical Resection",
                PermissibleValue(text="Surgical Resection",
                                 description="Excision") )
        setattr(cls, "Bone Marrow Aspirate",
                PermissibleValue(text="Bone Marrow Aspirate",
                                 description="Bone Marrow Aspiration") )
        setattr(cls, "Blood Draw",
                PermissibleValue(text="Blood Draw",
                                 description="Phlebotomy") )
        setattr(cls, "Fine Needle Aspiration",
                PermissibleValue(text="Fine Needle Aspiration",
                                 description="Fine-Needle Aspiration") )
        setattr(cls, "Physical Exam",
                PermissibleValue(text="Physical Exam",
                                 description="Physical Examination") )
        setattr(cls, "Dilation and Curettage Procedure",
                PermissibleValue(text="Dilation and Curettage Procedure",
                                 description="Dilation and Curettage") )
        setattr(cls, "Excisional Biopsy",
                PermissibleValue(text="Excisional Biopsy",
                                 description="Excisional Biopsy") )
        setattr(cls, "Not Allowed To Collect",
                PermissibleValue(text="Not Allowed To Collect") )

class EnumCRDCHDimensionalObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H DimensionalObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHDimensionalObservationCategory",
        description="Autogenerated Enumeration for CRDC-H DimensionalObservation category",
        code_set=None,
        code_set_version="2021-12-16T18:04:21.821225+00:00",
    )

class EnumCRDCHDimensionalObservationObservationType(EnumDefinitionImpl):
    """
    Types of measurements that describe the physical dimensions of an entity (e.g. a Specimen)
    """
    length = PermissibleValue(text="length",
                                   description="The length of a three-dimensional specimen, as measured in a plane perpendicular to the planes in which the width and height of the specimen are measured.")
    width = PermissibleValue(text="width",
                                 description="The width of a three-dimensional specimen, as measured in a plane perpendicular to the planes in which the length and height of the specimen are measured.")
    longest_dimension = PermissibleValue(text="longest_dimension",
                                                         description="The measured extent of the longest straight path across a specimen.")
    shortest_dimension = PermissibleValue(text="shortest_dimension",
                                                           description="The measured extent of the shortest straight path across a specimen.")
    intermediate_dimension = PermissibleValue(text="intermediate_dimension",
                                                                   description="The measured extent of the intermediate straight path across a specimen.")
    surface_area = PermissibleValue(text="surface_area",
                                               description="The total surface area of the specimen")

    _defn = EnumDefinition(
        name="EnumCRDCHDimensionalObservationObservationType",
        description="Types of measurements that describe the physical dimensions of an entity (e.g. a Specimen)",
    )

class EnumCRDCHDimensionalObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H DimensionalObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHDimensionalObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H DimensionalObservation method_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:22.114768+00:00",
    )

class EnumCRDCHDimensionalObservationSetCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H DimensionalObservationSet category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHDimensionalObservationSetCategory",
        description="Autogenerated Enumeration for CRDC-H DimensionalObservationSet category",
        code_set=None,
        code_set_version="2021-12-16T18:04:22.266296+00:00",
    )

class EnumCRDCHDimensionalObservationSetMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H DimensionalObservationSet method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHDimensionalObservationSetMethodType",
        description="Autogenerated Enumeration for CRDC-H DimensionalObservationSet method_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:22.411575+00:00",
    )

class EnumCRDCHDocumentDocumentType(EnumDefinitionImpl):
    """
    The high-level type of the report (e.g. 'pathology report')
    """
    protocol = PermissibleValue(text="protocol",
                                       description="A protocol by which the sample was obtained or generated (e.g. a protocol listed in protocols.io)")

    _defn = EnumDefinition(
        name="EnumCRDCHDocumentDocumentType",
        description="The high-level type of the report (e.g. 'pathology report')",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "pathology report",
                PermissibleValue(text="pathology report",
                                 description="A pathology report describing the specimen") )

class EnumCRDCHEnvironmentalExposureObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H EnvironmentalExposureObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHEnvironmentalExposureObservationCategory",
        description="Autogenerated Enumeration for CRDC-H EnvironmentalExposureObservation category",
        code_set=None,
        code_set_version="2021-12-16T18:04:22.707614+00:00",
    )

class EnumCRDCHEnvironmentalExposureObservationObservationType(EnumDefinitionImpl):
    """
    Types of observations about a Subject's environmental exposures.
    """
    asbestos_exposure = PermissibleValue(text="asbestos_exposure",
                                                         description="The yes/no/unknown indicator used to describe whether the patient was exposed to asbestos.")
    coal_dust_exposure = PermissibleValue(text="coal_dust_exposure",
                                                           description="The yes/no/unknown indicator used to describe whether a patient was exposed to fine powder derived by the crushing of coal.")
    radon_exposure = PermissibleValue(text="radon_exposure",
                                                   description="The yes/no/unknown indicator used to describe whether the patient was exposed to radon.")
    respirable_crystalline_silica_exposure = PermissibleValue(text="respirable_crystalline_silica_exposure",
                                                                                                   description="The yes/no/unknown indicator used to describe whether a patient was exposed to respirable crystalline silica, a widespread, naturally occurring, crystalline metal oxide that consists of different forms including quartz, cristobalite, tridymite, tripoli, ganister, chert and novaculite.")
    type_of_smoke_exposure = PermissibleValue(text="type_of_smoke_exposure",
                                                                   description="The text term used to describe the patient's specific type of smoke exposure.")

    _defn = EnumDefinition(
        name="EnumCRDCHEnvironmentalExposureObservationObservationType",
        description="Types of observations about a Subject's environmental exposures.",
    )

class EnumCRDCHEnvironmentalExposureObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H EnvironmentalExposureObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHEnvironmentalExposureObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H EnvironmentalExposureObservation method_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:23.006233+00:00",
    )

class EnumCRDCHEnvironmentalExposureObservationValueCodeableConcept(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H EnvironmentalExposureObservation value_codeable_concept
    """
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    No = PermissibleValue(text="No",
                           description="No")
    Yes = PermissibleValue(text="Yes",
                             description="Yes")

    _defn = EnumDefinition(
        name="EnumCRDCHEnvironmentalExposureObservationValueCodeableConcept",
        description="Autogenerated Enumeration for CRDC-H EnvironmentalExposureObservation value_codeable_concept",
        code_set=None,
        code_set_version="2021-12-16T18:04:23.144799+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Accidental fire smoke, grass",
                PermissibleValue(text="Accidental fire smoke, grass") )
        setattr(cls, "Tobacco smoke, NOS",
                PermissibleValue(text="Tobacco smoke, NOS") )
        setattr(cls, "Work-related smoke, military",
                PermissibleValue(text="Work-related smoke, military") )
        setattr(cls, "Accidental forest fire smoke",
                PermissibleValue(text="Accidental forest fire smoke") )
        setattr(cls, "Wood burning smoke, NOS",
                PermissibleValue(text="Wood burning smoke, NOS") )
        setattr(cls, "Environmental tobacco smoke",
                PermissibleValue(text="Environmental tobacco smoke") )
        setattr(cls, "Tobacco smoke, pipe",
                PermissibleValue(text="Tobacco smoke, pipe") )
        setattr(cls, "Indoor stove or fireplace smoke, coal burning",
                PermissibleValue(text="Indoor stove or fireplace smoke, coal burning") )
        setattr(cls, "Wood burning smoke, factory",
                PermissibleValue(text="Wood burning smoke, factory") )
        setattr(cls, "Indoor stove or fireplace smoke, wood burning",
                PermissibleValue(text="Indoor stove or fireplace smoke, wood burning") )
        setattr(cls, "Aircraft smoke",
                PermissibleValue(text="Aircraft smoke") )
        setattr(cls, "Tobacco smoke, cigarettes",
                PermissibleValue(text="Tobacco smoke, cigarettes") )
        setattr(cls, "Cooking-related smoke, NOS",
                PermissibleValue(text="Cooking-related smoke, NOS") )
        setattr(cls, "Coal smoke, NOS",
                PermissibleValue(text="Coal smoke, NOS") )
        setattr(cls, "Work-related smoke, generators",
                PermissibleValue(text="Work-related smoke, generators") )
        setattr(cls, "Machine smoke",
                PermissibleValue(text="Machine smoke") )
        setattr(cls, "No Smoke Exposure",
                PermissibleValue(text="No Smoke Exposure") )
        setattr(cls, "Work-related smoke, NOS",
                PermissibleValue(text="Work-related smoke, NOS") )
        setattr(cls, "Waste burning smoke",
                PermissibleValue(text="Waste burning smoke") )
        setattr(cls, "Work-related smoke, fire fighting",
                PermissibleValue(text="Work-related smoke, fire fighting") )
        setattr(cls, "Marijuana smoke",
                PermissibleValue(text="Marijuana smoke") )
        setattr(cls, "Hashish smoke",
                PermissibleValue(text="Hashish smoke") )
        setattr(cls, "Work-related smoke, plastics factory",
                PermissibleValue(text="Work-related smoke, plastics factory") )
        setattr(cls, "Gas burning smoke, propane",
                PermissibleValue(text="Gas burning smoke, propane") )
        setattr(cls, "Smokehouse smoke",
                PermissibleValue(text="Smokehouse smoke") )
        setattr(cls, "Factory smokestack smoke",
                PermissibleValue(text="Factory smokestack smoke") )
        setattr(cls, "Work-related smoke, foundry",
                PermissibleValue(text="Work-related smoke, foundry") )
        setattr(cls, "Work-related smoke, artificial smoke machines",
                PermissibleValue(text="Work-related smoke, artificial smoke machines") )
        setattr(cls, "Burning tree smoke",
                PermissibleValue(text="Burning tree smoke") )
        setattr(cls, "Work-related smoke, paint baking",
                PermissibleValue(text="Work-related smoke, paint baking") )
        setattr(cls, "Smoke exposure, NOS",
                PermissibleValue(text="Smoke exposure, NOS") )
        setattr(cls, "Field burning smoke",
                PermissibleValue(text="Field burning smoke") )
        setattr(cls, "Grilling smoke",
                PermissibleValue(text="Grilling smoke") )
        setattr(cls, "Indoor stove or fireplace smoke, NOS",
                PermissibleValue(text="Indoor stove or fireplace smoke, NOS") )
        setattr(cls, "Tobacco smoke, cigar",
                PermissibleValue(text="Tobacco smoke, cigar") )
        setattr(cls, "Oil burning smoke, Kerosene",
                PermissibleValue(text="Oil burning smoke, Kerosene") )
        setattr(cls, "Accidental building fire smoke",
                PermissibleValue(text="Accidental building fire smoke") )
        setattr(cls, "Accidental vehicle fire smoke",
                PermissibleValue(text="Accidental vehicle fire smoke") )
        setattr(cls, "Oil burning smoke, NOS",
                PermissibleValue(text="Oil burning smoke, NOS") )
        setattr(cls, "Electronic cigarette smoke, NOS",
                PermissibleValue(text="Electronic cigarette smoke, NOS") )
        setattr(cls, "Recreational fire smoke",
                PermissibleValue(text="Recreational fire smoke") )
        setattr(cls, "Accidental fire smoke, NOS",
                PermissibleValue(text="Accidental fire smoke, NOS") )
        setattr(cls, "Work-related smoke, plumbing",
                PermissibleValue(text="Work-related smoke, plumbing") )
        setattr(cls, "Fire smoke, NOS",
                PermissibleValue(text="Fire smoke, NOS") )
        setattr(cls, "Furnace or boiler smoke",
                PermissibleValue(text="Furnace or boiler smoke") )
        setattr(cls, "Grease fire smoke",
                PermissibleValue(text="Grease fire smoke") )
        setattr(cls, "Electrical fire smoke",
                PermissibleValue(text="Electrical fire smoke") )
        setattr(cls, "Volcanic smoke",
                PermissibleValue(text="Volcanic smoke") )
        setattr(cls, "Work-related smoke, soldering/welding",
                PermissibleValue(text="Work-related smoke, soldering/welding") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )

class EnumCRDCHExecutionConditionObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ExecutionConditionObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHExecutionConditionObservationCategory",
        description="Autogenerated Enumeration for CRDC-H ExecutionConditionObservation category",
        code_set=None,
        code_set_version="2021-12-16T18:04:23.401461+00:00",
    )

class EnumCRDCHExecutionConditionObservationObservationType(EnumDefinitionImpl):
    """
    Types of observations about the environmental conditions under which specific aspects of an activity were
    performed.
    """
    ischemic_temperature = PermissibleValue(text="ischemic_temperature",
                                                               description="A term describing the temperature of a specimen when it experienced ischemia.")

    _defn = EnumDefinition(
        name="EnumCRDCHExecutionConditionObservationObservationType",
        description="Types of observations about the environmental conditions under which specific aspects of an activity were performed.",
    )

class EnumCRDCHExecutionConditionObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ExecutionConditionObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHExecutionConditionObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H ExecutionConditionObservation method_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:23.676105+00:00",
    )

class EnumCRDCHExecutionConditionObservationValueCodeableConcept(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ExecutionConditionObservation value_codeable_concept
    """
    _defn = EnumDefinition(
        name="EnumCRDCHExecutionConditionObservationValueCodeableConcept",
        description="Autogenerated Enumeration for CRDC-H ExecutionConditionObservation value_codeable_concept",
        code_set=None,
        code_set_version="2021-12-16T18:04:23.810181+00:00",
    )

class EnumCRDCHExecutionTimeObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ExecutionTimeObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHExecutionTimeObservationCategory",
        description="Autogenerated Enumeration for CRDC-H ExecutionTimeObservation category",
        code_set=None,
        code_set_version="2021-12-16T18:04:23.949157+00:00",
    )

class EnumCRDCHExecutionTimeObservationObservationType(EnumDefinitionImpl):
    """
    An observation about the duration of specific aspects / parts of an activity.
    """
    time_between_excision_and_freezing = PermissibleValue(text="time_between_excision_and_freezing",
                                                                                           description="The elapsed time between the excision and freezing of the specimen from its subject/source.")
    time_between_clamping_and_freezing = PermissibleValue(text="time_between_clamping_and_freezing",
                                                                                           description="The elapsed time between the clamping of blood supply and freezing of the specimen from its subject/source.")
    ischemic_time = PermissibleValue(text="ischemic_time",
                                                 description="Duration of time, in seconds, between when the specimen stopped receiving oxygen and when it was preserved or processed.")

    _defn = EnumDefinition(
        name="EnumCRDCHExecutionTimeObservationObservationType",
        description="An observation about the duration of specific aspects / parts of an activity.",
    )

class EnumCRDCHExecutionTimeObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ExecutionTimeObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHExecutionTimeObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H ExecutionTimeObservation method_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:24.231603+00:00",
    )

class EnumCRDCHHistologicalCompositionObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H HistologicalCompositionObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHHistologicalCompositionObservationCategory",
        description="Autogenerated Enumeration for CRDC-H HistologicalCompositionObservation category",
        code_set=None,
        code_set_version="2021-12-16T18:04:24.376807+00:00",
    )

class EnumCRDCHHistologicalCompositionObservationObservationType(EnumDefinitionImpl):
    """
    Types of measurements that describe microscopic characteristics of a specimen - typically related to its cellular
    and tissue composition.
    """
    number_proliferating_cells = PermissibleValue(text="number_proliferating_cells",
                                                                           description="Numeric value that represents the count of proliferating cells determined during pathologic review of the sample slide(s).")
    percent_eosinophil_infiltration = PermissibleValue(text="percent_eosinophil_infiltration",
                                                                                     description="Numeric value to represent the percentage of infiltration by eosinophils in a tumor sample or specimen.")
    percent_granulocyte_infiltration = PermissibleValue(text="percent_granulocyte_infiltration",
                                                                                       description="Numeric value to represent the percentage of infiltration by granulocytes in a tumor sample or specimen.")
    percent_inflam_infiltration = PermissibleValue(text="percent_inflam_infiltration",
                                                                             description="Numeric value to represent local response to cellular injury, marked by capillary dilatation, edema and leukocyte infiltration; clinically, inflammation is manifest by redness, heat, pain, swelling and loss of function, with the need to heal damaged tissue.")
    percent_lymphocyte_infiltration = PermissibleValue(text="percent_lymphocyte_infiltration",
                                                                                     description="Numeric value to represent the percentage of infiltration by lymphocytes in a solid tissue normal sample or specimen.")
    percent_monocyte_infiltration = PermissibleValue(text="percent_monocyte_infiltration",
                                                                                 description="Numeric value to represent the percentage of monocyte infiltration in a sample or specimen.")
    percent_necrosis = PermissibleValue(text="percent_necrosis",
                                                       description="Numeric value to represent the percentage of cell death in a malignant tumor sample or specimen.")
    percent_neutrophil_infiltration = PermissibleValue(text="percent_neutrophil_infiltration",
                                                                                     description="Numeric value to represent the percentage of infiltration by neutrophils in a tumor sample or specimen.")
    percent_normal_cells = PermissibleValue(text="percent_normal_cells",
                                                               description="Numeric value to represent the percentage of normal cell content in a malignant tumor sample or specimen.")
    percent_stromal_cells = PermissibleValue(text="percent_stromal_cells",
                                                                 description="Numeric value to represent the percentage of reactive cells that are present in a malignant tumor sample or specimen but are not malignant such as fibroblasts, vascular structures, etc.")
    percent_tumor_cells = PermissibleValue(text="percent_tumor_cells",
                                                             description="Numeric value that represents the percentage of infiltration by tumor cells in a sample.")
    percent_tumor_nuclei = PermissibleValue(text="percent_tumor_nuclei",
                                                               description="Numeric value to represent the percentage of tumor nuclei in a malignant neoplasm sample or specimen.")
    tumor_infiltrating_lymphocytes = PermissibleValue(text="tumor_infiltrating_lymphocytes",
                                                                                   description="Measure of Tumor-Infiltrating Lymphocytes")
    non_tumor_tissue_area = PermissibleValue(text="non_tumor_tissue_area",
                                                                 description="The area within a sample that is represented by non-tumor tissue.")
    tumor_tissue_area = PermissibleValue(text="tumor_tissue_area",
                                                         description="The area within a sample that is comprised of tumor tissue.")
    analysis_area = PermissibleValue(text="analysis_area",
                                                 description="The total area of a sample that is used for analysis.")
    analysis_area_percentage_stroma = PermissibleValue(text="analysis_area_percentage_stroma",
                                                                                     description="The percentage of the analysis area that is represented by stromal tissue.")
    analysis_area_percentage_tumor = PermissibleValue(text="analysis_area_percentage_tumor",
                                                                                   description="The percentage of the analysis area that is represented by tumor tissue.")
    analysis_area_percentage_glass = PermissibleValue(text="analysis_area_percentage_glass",
                                                                                   description="The area of a sample on a slide that is represented by glass; the area of the sample that represents gaps in the sample.")
    analysis_area_percentage_pigmented_tumor = PermissibleValue(text="analysis_area_percentage_pigmented_tumor",
                                                                                                       description="The area of a sample on a slide that is represented by pigmented tumor tissue, which will be analyzed.")

    _defn = EnumDefinition(
        name="EnumCRDCHHistologicalCompositionObservationObservationType",
        description="Types of measurements that describe microscopic characteristics of a specimen - typically related to its cellular and tissue composition.",
    )

class EnumCRDCHHistologicalCompositionObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H HistologicalCompositionObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHHistologicalCompositionObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H HistologicalCompositionObservation method_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:24.668173+00:00",
    )

class EnumCRDCHHistologicalCompositionObservationSetCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H HistologicalCompositionObservationSet category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHHistologicalCompositionObservationSetCategory",
        description="Autogenerated Enumeration for CRDC-H HistologicalCompositionObservationSet category",
        code_set=None,
        code_set_version="2021-12-16T18:04:24.808640+00:00",
    )

class EnumCRDCHHistologicalCompositionObservationSetMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H HistologicalCompositionObservationSet method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHHistologicalCompositionObservationSetMethodType",
        description="Autogenerated Enumeration for CRDC-H HistologicalCompositionObservationSet method_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:24.958047+00:00",
    )

class EnumCRDCHIdentifierType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Identifier type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHIdentifierType",
        description="Autogenerated Enumeration for CRDC-H Identifier type",
        code_set=None,
        code_set_version="2021-12-16T18:04:25.105760+00:00",
    )

class EnumCRDCHObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Observation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHObservationCategory",
        description="Autogenerated Enumeration for CRDC-H Observation category",
        code_set=None,
        code_set_version="2021-12-16T18:04:25.253691+00:00",
    )

class EnumCRDCHObservationObservationType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Observation observation_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHObservationObservationType",
        description="Autogenerated Enumeration for CRDC-H Observation observation_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:25.408145+00:00",
    )

class EnumCRDCHObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Observation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H Observation method_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:25.552876+00:00",
    )

class EnumCRDCHObservationValueCodeableConcept(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Observation value_codeable_concept
    """
    _defn = EnumDefinition(
        name="EnumCRDCHObservationValueCodeableConcept",
        description="Autogenerated Enumeration for CRDC-H Observation value_codeable_concept",
        code_set=None,
        code_set_version="2021-12-16T18:04:25.700808+00:00",
    )

class EnumCRDCHObservationSetCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ObservationSet category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHObservationSetCategory",
        description="Autogenerated Enumeration for CRDC-H ObservationSet category",
        code_set=None,
        code_set_version="2021-12-16T18:04:26.217142+00:00",
    )

class EnumCRDCHObservationSetMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ObservationSet method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHObservationSetMethodType",
        description="Autogenerated Enumeration for CRDC-H ObservationSet method_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:26.363514+00:00",
    )

class EnumCRDCHQuantityValueCodeableConcept(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Quantity value_codeable_concept
    """
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")

    _defn = EnumDefinition(
        name="EnumCRDCHQuantityValueCodeableConcept",
        description="Autogenerated Enumeration for CRDC-H Quantity value_codeable_concept",
        code_set=None,
        code_set_version="2021-12-16T18:04:26.512767+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Adjacent (< or = 2cm)",
                PermissibleValue(text="Adjacent (< or = 2cm)",
                                 description="Adjacent") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported",
                                 description="Not Reported") )
        setattr(cls, "Distal (>2cm)",
                PermissibleValue(text="Distal (>2cm)",
                                 description="Distal") )

class EnumCRDCHQuantityUnit(EnumDefinitionImpl):
    """
    The unit for a value
    """
    milligrams = PermissibleValue(text="milligrams")
    days = PermissibleValue(text="days")
    minutes = PermissibleValue(text="minutes")

    _defn = EnumDefinition(
        name="EnumCRDCHQuantityUnit",
        description="The unit for a value",
    )

class EnumCRDCHResearchProjectResearchProjectType(EnumDefinitionImpl):
    """
    A high-level type of research activity
    """
    Program = PermissibleValue(text="Program",
                                     description="A broad framework of goals to be achieved.")
    Project = PermissibleValue(text="Project",
                                     description="Any specifically defined piece of work that is undertaken or attempted to meet a single requirement.")

    _defn = EnumDefinition(
        name="EnumCRDCHResearchProjectResearchProjectType",
        description="A high-level type of research activity",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Clinical Trial",
                PermissibleValue(text="Clinical Trial",
                                 description="A research study that prospectively assigns participants to one or more health-related interventions to evaluate the effects on health outcomes.") )

class EnumCRDCHResearchSubjectPrimaryDiagnosisCondition(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ResearchSubject primary_diagnosis_condition
    """
    Sarcoma = PermissibleValue(text="Sarcoma")
    Glioblastoma = PermissibleValue(text="Glioblastoma")
    Mesonephromas = PermissibleValue(text="Mesonephromas",
                                                 description="Mesonephric Neoplasm")
    Meningiomas = PermissibleValue(text="Meningiomas",
                                             description="Meningioma")
    Cholangiocarcinoma = PermissibleValue(text="Cholangiocarcinoma")
    Mesothelioma = PermissibleValue(text="Mesothelioma")
    Gliomas = PermissibleValue(text="Gliomas",
                                     description="Glioma")
    Neuroblastoma = PermissibleValue(text="Neuroblastoma")
    Other = PermissibleValue(text="Other")
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    Thymoma = PermissibleValue(text="Thymoma")
    Osteosarcoma = PermissibleValue(text="Osteosarcoma")

    _defn = EnumDefinition(
        name="EnumCRDCHResearchSubjectPrimaryDiagnosisCondition",
        description="Autogenerated Enumeration for CRDC-H ResearchSubject primary_diagnosis_condition",
        code_set=None,
        code_set_version="2021-12-16T18:04:26.993727+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Uveal Melanoma",
                PermissibleValue(text="Uveal Melanoma") )
        setattr(cls, "Acute Myeloid Leukemia",
                PermissibleValue(text="Acute Myeloid Leukemia") )
        setattr(cls, "Myelodysplastic Syndromes",
                PermissibleValue(text="Myelodysplastic Syndromes",
                                 description="Myelodysplastic Syndrome") )
        setattr(cls, "Early Onset Gastric Cancer",
                PermissibleValue(text="Early Onset Gastric Cancer") )
        setattr(cls, "Nevi and Melanomas",
                PermissibleValue(text="Nevi and Melanomas",
                                 description="Melanocytic Nevus and Melanoma") )
        setattr(cls, "Other Hematologic Disorders",
                PermissibleValue(text="Other Hematologic Disorders",
                                 description="Other Hematologic and Lymphocytic Disorder") )
        setattr(cls, "Synovial-like Neoplasms",
                PermissibleValue(text="Synovial-like Neoplasms",
                                 description="Synovial Neoplasm") )
        setattr(cls, "Testicular Germ Cell Tumors",
                PermissibleValue(text="Testicular Germ Cell Tumors") )
        setattr(cls, "Complex Epithelial Neoplasms",
                PermissibleValue(text="Complex Epithelial Neoplasms") )
        setattr(cls, "Clear Cell Renal Cell Carcinoma",
                PermissibleValue(text="Clear Cell Renal Cell Carcinoma") )
        setattr(cls, "Glioblastoma Multiforme",
                PermissibleValue(text="Glioblastoma Multiforme") )
        setattr(cls, "High-Risk Wilms Tumor",
                PermissibleValue(text="High-Risk Wilms Tumor") )
        setattr(cls, "Mast Cell Tumors",
                PermissibleValue(text="Mast Cell Tumors",
                                 description="Mast Cell Neoplasm") )
        setattr(cls, "Transitional Cell Papillomas and Carcinomas",
                PermissibleValue(text="Transitional Cell Papillomas and Carcinomas",
                                 description="Transitional Cell Papilloma and Transitional Cell Carcinoma") )
        setattr(cls, "Mature T- and NK-Cell Lymphomas",
                PermissibleValue(text="Mature T- and NK-Cell Lymphomas",
                                 description="Mature T-Cell and NK-Cell Non-Hodgkin Lymphoma") )
        setattr(cls, "Plasma Cell Tumors",
                PermissibleValue(text="Plasma Cell Tumors",
                                 description="Plasma Cell Neoplasm") )
        setattr(cls, "Miscellaneous Tumors",
                PermissibleValue(text="Miscellaneous Tumors",
                                 description="Miscellaneous Neoplasm") )
        setattr(cls, "Myxomatous Neoplasms",
                PermissibleValue(text="Myxomatous Neoplasms",
                                 description="Myxoma") )
        setattr(cls, "Soft Tissue Tumors and Sarcomas, NOS",
                PermissibleValue(text="Soft Tissue Tumors and Sarcomas, NOS",
                                 description="Soft Tissue Neoplasm and Soft Tissue Sarcoma") )
        setattr(cls, "Germ Cell Neoplasms",
                PermissibleValue(text="Germ Cell Neoplasms",
                                 description="Germ Cell Tumor") )
        setattr(cls, "Hepatocellular Carcinoma",
                PermissibleValue(text="Hepatocellular Carcinoma") )
        setattr(cls, "Breast Invasive Carcinoma",
                PermissibleValue(text="Breast Invasive Carcinoma") )
        setattr(cls, "Adenomas and Adenocarcinomas",
                PermissibleValue(text="Adenomas and Adenocarcinomas",
                                 description="Adenoma and Adenocarcinoma") )
        setattr(cls, "Uterine Carcinosarcoma",
                PermissibleValue(text="Uterine Carcinosarcoma") )
        setattr(cls, "Stomach Adenocarcinoma",
                PermissibleValue(text="Stomach Adenocarcinoma") )
        setattr(cls, "Neuroepitheliomatous Neoplasms",
                PermissibleValue(text="Neuroepitheliomatous Neoplasms",
                                 description="Neuroepithelial Neoplasm") )
        setattr(cls, "Cystic, Mucinous and Serous Neoplasms",
                PermissibleValue(text="Cystic, Mucinous and Serous Neoplasms",
                                 description="Cystic Neoplasm Mucinous Neoplasm and Serous Neoplasm") )
        setattr(cls, "Nerve Sheath Tumors",
                PermissibleValue(text="Nerve Sheath Tumors",
                                 description="Nerve Sheath Neoplasm") )
        setattr(cls, "Lymphoid Neoplasm Diffuse Large B-cell Lymphoma",
                PermissibleValue(text="Lymphoid Neoplasm Diffuse Large B-cell Lymphoma") )
        setattr(cls, "Skin Cutaneous Melanoma",
                PermissibleValue(text="Skin Cutaneous Melanoma") )
        setattr(cls, "Colon Adenocarcinoma",
                PermissibleValue(text="Colon Adenocarcinoma") )
        setattr(cls, "Thymic Epithelial Neoplasms",
                PermissibleValue(text="Thymic Epithelial Neoplasms",
                                 description="Combined Thymic Epithelial Neoplasm") )
        setattr(cls, "Esophageal Carcinoma",
                PermissibleValue(text="Esophageal Carcinoma") )
        setattr(cls, "Kidney Renal Clear Cell Carcinoma",
                PermissibleValue(text="Kidney Renal Clear Cell Carcinoma") )
        setattr(cls, "Not Applicable",
                PermissibleValue(text="Not Applicable") )
        setattr(cls, "Ductal and Lobular Neoplasms",
                PermissibleValue(text="Ductal and Lobular Neoplasms",
                                 description="Ductal Breast Carcinoma In Situ and Lobular Carcinoma In Situ") )
        setattr(cls, "Papillary Renal Cell Carcinoma",
                PermissibleValue(text="Papillary Renal Cell Carcinoma") )
        setattr(cls, "HIV+ Tumor Molecular Characterization Project - Cervical Cancer",
                PermissibleValue(text="HIV+ Tumor Molecular Characterization Project - Cervical Cancer") )
        setattr(cls, "HIV+ Tumor Molecular Characterization Project - Lung Cancer",
                PermissibleValue(text="HIV+ Tumor Molecular Characterization Project - Lung Cancer") )
        setattr(cls, "Clear Cell Sarcoma of the Kidney",
                PermissibleValue(text="Clear Cell Sarcoma of the Kidney") )
        setattr(cls, "Complex Mixed and Stromal Neoplasms",
                PermissibleValue(text="Complex Mixed and Stromal Neoplasms",
                                 description="Complex Mixed and Stromal Neoplasm") )
        setattr(cls, "Precursor Cell Lymphoblastic Lymphoma",
                PermissibleValue(text="Precursor Cell Lymphoblastic Lymphoma",
                                 description="Lymphoblastic Lymphoma") )
        setattr(cls, "Adnexal and Skin Appendage Neoplasms",
                PermissibleValue(text="Adnexal and Skin Appendage Neoplasms",
                                 description="Adnexal Carcinoma and Skin Appendage Neoplasm") )
        setattr(cls, "Mucoepidermoid Neoplasms",
                PermissibleValue(text="Mucoepidermoid Neoplasms",
                                 description="Mucoepidermoid Carcinoma") )
        setattr(cls, "Lung Adenocarcinoma",
                PermissibleValue(text="Lung Adenocarcinoma") )
        setattr(cls, "Leukemias, NOS",
                PermissibleValue(text="Leukemias, NOS",
                                 description="Not Otherwise Specified Leukemia") )
        setattr(cls, "Hodgkin Lymphoma",
                PermissibleValue(text="Hodgkin Lymphoma",
                                 description="Hodgkin Lymphoma") )
        setattr(cls, "Kidney Chromophobe",
                PermissibleValue(text="Kidney Chromophobe") )
        setattr(cls, "Chronic Myeloproliferative Disorders",
                PermissibleValue(text="Chronic Myeloproliferative Disorders",
                                 description="Chronic Myeloproliferative Neoplasm") )
        setattr(cls, "Multiple Myeloma",
                PermissibleValue(text="Multiple Myeloma") )
        setattr(cls, "Lymphatic Vessel Tumors",
                PermissibleValue(text="Lymphatic Vessel Tumors",
                                 description="Lymphatic Vessel Neoplasm") )
        setattr(cls, "Squamous Cell Neoplasms",
                PermissibleValue(text="Squamous Cell Neoplasms",
                                 description="Squamous Cell Neoplasm") )
        setattr(cls, "Rectum Adenocarcinoma",
                PermissibleValue(text="Rectum Adenocarcinoma") )
        setattr(cls, "Chromophobe Renal Cell Carcinoma",
                PermissibleValue(text="Chromophobe Renal Cell Carcinoma") )
        setattr(cls, "Uterine Corpus Endometrial Carcinoma",
                PermissibleValue(text="Uterine Corpus Endometrial Carcinoma") )
        setattr(cls, "Specialized Gonadal Neoplasms",
                PermissibleValue(text="Specialized Gonadal Neoplasms",
                                 description="Specialized Gonadal Neoplasm") )
        setattr(cls, "Myeloid Leukemias",
                PermissibleValue(text="Myeloid Leukemias",
                                 description="Myeloid Leukemia") )
        setattr(cls, "Pheochromocytoma and Paraganglioma",
                PermissibleValue(text="Pheochromocytoma and Paraganglioma") )
        setattr(cls, "Trophoblastic neoplasms",
                PermissibleValue(text="Trophoblastic neoplasms",
                                 description="Trophoblastic Tumor") )
        setattr(cls, "Burkitt Lymphoma",
                PermissibleValue(text="Burkitt Lymphoma") )
        setattr(cls, "Thyroid Carcinoma",
                PermissibleValue(text="Thyroid Carcinoma") )
        setattr(cls, "Chronic Lymphocytic Leukemia",
                PermissibleValue(text="Chronic Lymphocytic Leukemia") )
        setattr(cls, "Adrenocortical Carcinoma",
                PermissibleValue(text="Adrenocortical Carcinoma") )
        setattr(cls, "Acinar Cell Neoplasms",
                PermissibleValue(text="Acinar Cell Neoplasms",
                                 description="Acinar Cell Neoplasm") )
        setattr(cls, "Lymphoid Leukemias",
                PermissibleValue(text="Lymphoid Leukemias",
                                 description="Lymphoid Leukemia") )
        setattr(cls, "Paragangliomas and Glomus Tumors",
                PermissibleValue(text="Paragangliomas and Glomus Tumors",
                                 description="Paraganglioma And Glomus Tumor") )
        setattr(cls, "Pediatric/AYA Brain Tumors",
                PermissibleValue(text="Pediatric/AYA Brain Tumors") )
        setattr(cls, "Malignant Lymphomas, NOS or Diffuse",
                PermissibleValue(text="Malignant Lymphomas, NOS or Diffuse",
                                 description="Not Otherwise Specified or Diffuse Lymphoma") )
        setattr(cls, "Basal Cell Neoplasms",
                PermissibleValue(text="Basal Cell Neoplasms",
                                 description="Basal Cell Neoplasm") )
        setattr(cls, "Rhabdoid Tumor",
                PermissibleValue(text="Rhabdoid Tumor") )
        setattr(cls, "Myomatous Neoplasms",
                PermissibleValue(text="Myomatous Neoplasms",
                                 description="Myomatous Neoplasm") )
        setattr(cls, "Kidney Renal Papillary Cell Carcinoma",
                PermissibleValue(text="Kidney Renal Papillary Cell Carcinoma") )
        setattr(cls, "Acute Lymphoblastic Leukemia",
                PermissibleValue(text="Acute Lymphoblastic Leukemia") )
        setattr(cls, "Bladder Urothelial Carcinoma",
                PermissibleValue(text="Bladder Urothelial Carcinoma") )
        setattr(cls, "Fibroepithelial Neoplasms",
                PermissibleValue(text="Fibroepithelial Neoplasms",
                                 description="Fibroepithelial Neoplasm") )
        setattr(cls, "Granular Cell Tumors and Alveolar Soft Part Sarcomas",
                PermissibleValue(text="Granular Cell Tumors and Alveolar Soft Part Sarcomas",
                                 description="Granular Cell Tumor and Alveolar Soft Part Sarcoma") )
        setattr(cls, "Brain Lower Grade Glioma",
                PermissibleValue(text="Brain Lower Grade Glioma") )
        setattr(cls, "Oral Squamous Cell Carcinoma",
                PermissibleValue(text="Oral Squamous Cell Carcinoma") )
        setattr(cls, "Cervical Squamous Cell Carcinoma and Endocervical Adenocarcinoma",
                PermissibleValue(text="Cervical Squamous Cell Carcinoma and Endocervical Adenocarcinoma") )
        setattr(cls, "Osseous and Chondromatous Neoplasms",
                PermissibleValue(text="Osseous and Chondromatous Neoplasms",
                                 description="Osteogenic Neoplasm and Chondrogenic Neoplasm") )
        setattr(cls, "Neoplasms, NOS",
                PermissibleValue(text="Neoplasms, NOS",
                                 description="Not Otherwise Specified Neoplasm") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported",
                                 description="Not Reported") )
        setattr(cls, "Pancreatic Ductal Adenocarcinoma",
                PermissibleValue(text="Pancreatic Ductal Adenocarcinoma") )
        setattr(cls, "Pancreatic Adenocarcinoma",
                PermissibleValue(text="Pancreatic Adenocarcinoma") )
        setattr(cls, "Neoplasms of Histiocytes and Accessory Lymphoid Cells",
                PermissibleValue(text="Neoplasms of Histiocytes and Accessory Lymphoid Cells",
                                 description="Neoplasms of Histiocytes and Accessory Lymphoid Cells") )
        setattr(cls, "Odontogenic Tumors",
                PermissibleValue(text="Odontogenic Tumors",
                                 description="Odontogenic Neoplasm") )
        setattr(cls, "Ovarian Serous Cystadenocarcinoma",
                PermissibleValue(text="Ovarian Serous Cystadenocarcinoma") )
        setattr(cls, "Lung Squamous Cell Carcinoma",
                PermissibleValue(text="Lung Squamous Cell Carcinoma") )
        setattr(cls, "Prostate Adenocarcinoma",
                PermissibleValue(text="Prostate Adenocarcinoma") )
        setattr(cls, "Mature B-Cell Lymphomas",
                PermissibleValue(text="Mature B-Cell Lymphomas",
                                 description="Mature B-Cell Non-Hodgkin Lymphoma") )
        setattr(cls, "Mesothelial Neoplasms",
                PermissibleValue(text="Mesothelial Neoplasms",
                                 description="Mesothelial Neoplasm") )
        setattr(cls, "Fibromatous Neoplasms",
                PermissibleValue(text="Fibromatous Neoplasms",
                                 description="Fibromatosis") )
        setattr(cls, "Head and Neck Squamous Cell Carcinoma",
                PermissibleValue(text="Head and Neck Squamous Cell Carcinoma") )
        setattr(cls, "Lipomatous Neoplasms",
                PermissibleValue(text="Lipomatous Neoplasms",
                                 description="Lipomatous Neoplasm") )
        setattr(cls, "Other Leukemias",
                PermissibleValue(text="Other Leukemias",
                                 description="Other Leukemia") )
        setattr(cls, "Liver Hepatocellular Carcinoma",
                PermissibleValue(text="Liver Hepatocellular Carcinoma") )
        setattr(cls, "Miscellaneous Bone Tumors",
                PermissibleValue(text="Miscellaneous Bone Tumors",
                                 description="Miscellaneous Bone Neoplasm") )
        setattr(cls, "Blood Vessel Tumors",
                PermissibleValue(text="Blood Vessel Tumors",
                                 description="Blood Vessel Neoplasm") )
        setattr(cls, "Giant Cell Tumors",
                PermissibleValue(text="Giant Cell Tumors",
                                 description="Giant Cell Tumor") )
        setattr(cls, "Epithelial Neoplasms, NOS",
                PermissibleValue(text="Epithelial Neoplasms, NOS",
                                 description="Not Otherwise Specified Epithelial Neoplasm") )
        setattr(cls, "Immunoproliferative Diseases",
                PermissibleValue(text="Immunoproliferative Diseases",
                                 description="Immunoproliferative Disease") )

class EnumCRDCHResearchSubjectIndexTimepoint(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ResearchSubject index_timepoint
    """
    Diagnosis = PermissibleValue(text="Diagnosis",
                                         description="Diagnosis")
    Recurrence = PermissibleValue(text="Recurrence")

    _defn = EnumDefinition(
        name="EnumCRDCHResearchSubjectIndexTimepoint",
        description="Autogenerated Enumeration for CRDC-H ResearchSubject index_timepoint",
        code_set=None,
        code_set_version="2021-12-16T18:04:27.373345+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "First Treatment",
                PermissibleValue(text="First Treatment") )
        setattr(cls, "Initial Genomic Sequencing",
                PermissibleValue(text="Initial Genomic Sequencing") )
        setattr(cls, "Study Enrollment",
                PermissibleValue(text="Study Enrollment",
                                 description="Clinical Study Enrollment") )
        setattr(cls, "First Patient Visit",
                PermissibleValue(text="First Patient Visit",
                                 description="First Patient Visit") )
        setattr(cls, "Sample Procurement",
                PermissibleValue(text="Sample Procurement",
                                 description="Tissue Procurement") )

class EnumCRDCHSpecimenSpecimenType(EnumDefinitionImpl):
    """
    A high-level type of specimen, based on its derivation provenance (i.e. how far removed it is from the original
    sample extracted from a source).
    """
    portion = PermissibleValue(text="portion",
                                     description="A physical sub-part taken from an existing specimen.")
    aliquot = PermissibleValue(text="aliquot",
                                     description="A specimen that results from the division of some parent specimen into equal amounts for downstream analysis.")
    analyte = PermissibleValue(text="analyte",
                                     description="A specimen generated through the extraction of a specified class of substance/chemical (e.g. DNA, RNA, protein) from a parent specimen, which is stored in solution as an analyte.")
    slide = PermissibleValue(text="slide",
                                 description="A specimen that is mounted on a slide or coverslip for microscopic analysis.")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenSpecimenType",
        description="A high-level type of specimen, based on its derivation provenance (i.e. how far removed it is from the original sample extracted from a source).",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Fresh Specimen",
                PermissibleValue(text="Fresh Specimen",
                                 description="A specimen representing the material that was directly collected from a subject (i.e. not generated through portioning, aliquoting, or analyte extraction from an existing specimen).") )

class EnumCRDCHSpecimenAnalyteType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen analyte_type
    """
    D = PermissibleValue(text="D",
                         description="DNA")
    S = PermissibleValue(text="S")
    X = PermissibleValue(text="X",
                         description="Repli-G X (Qiagen) DNA")
    R = PermissibleValue(text="R",
                         description="Ribonucleic Acid")
    T = PermissibleValue(text="T",
                         description="Total Ribonucleic Acid")
    W = PermissibleValue(text="W",
                         description="Repli-G (Qiagen) DNA")
    H = PermissibleValue(text="H",
                         description="Hybrid Extraction RNA")
    G = PermissibleValue(text="G",
                         description="GenomePlex (Rubicon) Amplified DNA")
    E = PermissibleValue(text="E")
    Y = PermissibleValue(text="Y")
    RNA = PermissibleValue(text="RNA",
                             description="Ribonucleic Acid")
    DNA = PermissibleValue(text="DNA",
                             description="DNA")
    Protein = PermissibleValue(text="Protein",
                                     description="Protein")
    cfDNA = PermissibleValue(text="cfDNA")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenAnalyteType",
        description="Autogenerated Enumeration for CRDC-H Specimen analyte_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:27.663660+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "FFPE DNA",
                PermissibleValue(text="FFPE DNA",
                                 description="Formalin-Fixed Paraffin-Embedded DNA") )
        setattr(cls, "Repli-G (Qiagen) DNA",
                PermissibleValue(text="Repli-G (Qiagen) DNA",
                                 description="Repli-G (Qiagen) DNA") )
        setattr(cls, "GenomePlex (Rubicon) Amplified DNA",
                PermissibleValue(text="GenomePlex (Rubicon) Amplified DNA") )
        setattr(cls, "Total RNA",
                PermissibleValue(text="Total RNA",
                                 description="Total Ribonucleic Acid") )
        setattr(cls, "Repli-G X (Qiagen) DNA",
                PermissibleValue(text="Repli-G X (Qiagen) DNA",
                                 description="Repli-G X (Qiagen) DNA") )
        setattr(cls, "Repli-G Pooled (Qiagen) DNA",
                PermissibleValue(text="Repli-G Pooled (Qiagen) DNA",
                                 description="REPLI-g Pooled DNA") )
        setattr(cls, "EBV Immortalized Normal",
                PermissibleValue(text="EBV Immortalized Normal",
                                 description="Normal Epstein-Barr Virus Immortalization") )
        setattr(cls, "FFPE RNA",
                PermissibleValue(text="FFPE RNA",
                                 description="Formalin-Fixed Paraffin-Embedded RNA") )
        setattr(cls, "Nuclei RNA",
                PermissibleValue(text="Nuclei RNA") )

class EnumCRDCHSpecimenSourceMaterialType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen source_material_type
    """
    RNA = PermissibleValue(text="RNA")
    Granulocytes = PermissibleValue(text="Granulocytes",
                                               description="Granulocyte")
    Tumor = PermissibleValue(text="Tumor",
                                 description="Neoplasm")
    Saliva = PermissibleValue(text="Saliva",
                                   description="Saliva")
    Slides = PermissibleValue(text="Slides")
    Metastatic = PermissibleValue(text="Metastatic")
    Unknown = PermissibleValue(text="Unknown")
    DNA = PermissibleValue(text="DNA")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenSourceMaterialType",
        description="Autogenerated Enumeration for CRDC-H Specimen source_material_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:27.866079+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "20",
                PermissibleValue(text="20") )
        setattr(cls, "10",
                PermissibleValue(text="10") )
        setattr(cls, "13",
                PermissibleValue(text="13") )
        setattr(cls, "14",
                PermissibleValue(text="14") )
        setattr(cls, "02",
                PermissibleValue(text="02") )
        setattr(cls, "61",
                PermissibleValue(text="61") )
        setattr(cls, "11",
                PermissibleValue(text="11") )
        setattr(cls, "15",
                PermissibleValue(text="15") )
        setattr(cls, "41",
                PermissibleValue(text="41") )
        setattr(cls, "17",
                PermissibleValue(text="17") )
        setattr(cls, "86",
                PermissibleValue(text="86") )
        setattr(cls, "99",
                PermissibleValue(text="99") )
        setattr(cls, "06",
                PermissibleValue(text="06") )
        setattr(cls, "30",
                PermissibleValue(text="30") )
        setattr(cls, "42",
                PermissibleValue(text="42") )
        setattr(cls, "09",
                PermissibleValue(text="09") )
        setattr(cls, "16",
                PermissibleValue(text="16") )
        setattr(cls, "18",
                PermissibleValue(text="18") )
        setattr(cls, "31",
                PermissibleValue(text="31") )
        setattr(cls, "60",
                PermissibleValue(text="60") )
        setattr(cls, "40",
                PermissibleValue(text="40") )
        setattr(cls, "12",
                PermissibleValue(text="12") )
        setattr(cls, "50",
                PermissibleValue(text="50") )
        setattr(cls, "85",
                PermissibleValue(text="85") )
        setattr(cls, "08",
                PermissibleValue(text="08") )
        setattr(cls, "03",
                PermissibleValue(text="03") )
        setattr(cls, "05",
                PermissibleValue(text="05") )
        setattr(cls, "07",
                PermissibleValue(text="07") )
        setattr(cls, "04",
                PermissibleValue(text="04") )
        setattr(cls, "01",
                PermissibleValue(text="01") )
        setattr(cls, "32",
                PermissibleValue(text="32") )
        setattr(cls, "Expanded Next Generation Cancer Model",
                PermissibleValue(text="Expanded Next Generation Cancer Model") )
        setattr(cls, "Blood Derived Liquid Biopsy",
                PermissibleValue(text="Blood Derived Liquid Biopsy") )
        setattr(cls, "Xenograft Tissue",
                PermissibleValue(text="Xenograft Tissue") )
        setattr(cls, "Not Allowed To Collect",
                PermissibleValue(text="Not Allowed To Collect") )
        setattr(cls, "Lymphoid Normal",
                PermissibleValue(text="Lymphoid Normal") )
        setattr(cls, "Post neo-adjuvant therapy",
                PermissibleValue(text="Post neo-adjuvant therapy") )
        setattr(cls, "Blood Derived Normal",
                PermissibleValue(text="Blood Derived Normal") )
        setattr(cls, "Primary Blood Derived Cancer - Peripheral Blood",
                PermissibleValue(text="Primary Blood Derived Cancer - Peripheral Blood") )
        setattr(cls, "Primary Blood Derived Cancer - Bone Marrow",
                PermissibleValue(text="Primary Blood Derived Cancer - Bone Marrow") )
        setattr(cls, "Additional Metastatic",
                PermissibleValue(text="Additional Metastatic") )
        setattr(cls, "Pleural Effusion",
                PermissibleValue(text="Pleural Effusion") )
        setattr(cls, "Next Generation Cancer Model",
                PermissibleValue(text="Next Generation Cancer Model") )
        setattr(cls, "Additional - New Primary",
                PermissibleValue(text="Additional - New Primary") )
        setattr(cls, "Mixed Adherent Suspension",
                PermissibleValue(text="Mixed Adherent Suspension") )
        setattr(cls, "Human Tumor Original Cells",
                PermissibleValue(text="Human Tumor Original Cells") )
        setattr(cls, "Neoplasms of Uncertain and Unknown Behavior",
                PermissibleValue(text="Neoplasms of Uncertain and Unknown Behavior") )
        setattr(cls, "Bone Marrow Normal",
                PermissibleValue(text="Bone Marrow Normal") )
        setattr(cls, "Recurrent Blood Derived Cancer - Bone Marrow",
                PermissibleValue(text="Recurrent Blood Derived Cancer - Bone Marrow") )
        setattr(cls, "Mononuclear Cells from Bone Marrow Normal",
                PermissibleValue(text="Mononuclear Cells from Bone Marrow Normal") )
        setattr(cls, "Buccal Cell Normal",
                PermissibleValue(text="Buccal Cell Normal") )
        setattr(cls, "Solid Tissue Normal",
                PermissibleValue(text="Solid Tissue Normal") )
        setattr(cls, "Cell Lines",
                PermissibleValue(text="Cell Lines") )
        setattr(cls, "Repli-G X (Qiagen) DNA",
                PermissibleValue(text="Repli-G X (Qiagen) DNA") )
        setattr(cls, "Blood Derived Cancer - Peripheral Blood",
                PermissibleValue(text="Blood Derived Cancer - Peripheral Blood") )
        setattr(cls, "Benign Neoplasms",
                PermissibleValue(text="Benign Neoplasms") )
        setattr(cls, "Repli-G (Qiagen) DNA",
                PermissibleValue(text="Repli-G (Qiagen) DNA") )
        setattr(cls, "Recurrent Tumor",
                PermissibleValue(text="Recurrent Tumor") )
        setattr(cls, "Primary Xenograft Tissue",
                PermissibleValue(text="Primary Xenograft Tissue") )
        setattr(cls, "In Situ Neoplasms",
                PermissibleValue(text="In Situ Neoplasms") )
        setattr(cls, "Fibroblasts from Bone Marrow Normal",
                PermissibleValue(text="Fibroblasts from Bone Marrow Normal") )
        setattr(cls, "Tumor Adjacent Normal - Post Neo-adjuvant Therapy",
                PermissibleValue(text="Tumor Adjacent Normal - Post Neo-adjuvant Therapy") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "Blood Derived Cancer - Peripheral Blood, Post-treatment",
                PermissibleValue(text="Blood Derived Cancer - Peripheral Blood, Post-treatment") )
        setattr(cls, "Recurrent Blood Derived Cancer - Peripheral Blood",
                PermissibleValue(text="Recurrent Blood Derived Cancer - Peripheral Blood") )
        setattr(cls, "GenomePlex (Rubicon) Amplified DNA",
                PermissibleValue(text="GenomePlex (Rubicon) Amplified DNA") )
        setattr(cls, "Blood Derived Cancer - Bone Marrow",
                PermissibleValue(text="Blood Derived Cancer - Bone Marrow") )
        setattr(cls, "Primary Tumor",
                PermissibleValue(text="Primary Tumor",
                                 description="Primary Neoplasm") )
        setattr(cls, "Control Analyte",
                PermissibleValue(text="Control Analyte") )
        setattr(cls, "Total RNA",
                PermissibleValue(text="Total RNA") )
        setattr(cls, "FFPE Scrolls",
                PermissibleValue(text="FFPE Scrolls",
                                 description="Formalin Fixed Paraffin Embedded Tissue Scroll") )
        setattr(cls, "Blood Derived Cancer - Bone Marrow, Post-treatment",
                PermissibleValue(text="Blood Derived Cancer - Bone Marrow, Post-treatment") )
        setattr(cls, "FFPE Recurrent",
                PermissibleValue(text="FFPE Recurrent") )
        setattr(cls, "EBV Immortalized Normal",
                PermissibleValue(text="EBV Immortalized Normal") )
        setattr(cls, "Cell Line Derived Xenograft Tissue",
                PermissibleValue(text="Cell Line Derived Xenograft Tissue") )
        setattr(cls, "Normal Adjacent Tissue",
                PermissibleValue(text="Normal Adjacent Tissue") )

class EnumCRDCHSpecimenTumorStatusAtCollection(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen tumor_status_at_collection
    """
    primary = PermissibleValue(text="primary")
    Progression = PermissibleValue(text="Progression")
    recurrence = PermissibleValue(text="recurrence")
    Unknown = PermissibleValue(text="Unknown")
    metastasis = PermissibleValue(text="metastasis")
    Premalignant = PermissibleValue(text="Premalignant",
                                               description="Premalignant")
    other = PermissibleValue(text="other")
    Metastatic = PermissibleValue(text="Metastatic",
                                           description="Metastatic Tumor Tissue")
    NOS = PermissibleValue(text="NOS",
                             description="Not Otherwise Specified")
    Xenograft = PermissibleValue(text="Xenograft",
                                         description="Xenograft")
    Primary = PermissibleValue(text="Primary",
                                     description="Primary Untreated Malignant Tumor Tissue")
    Recurrence = PermissibleValue(text="Recurrence")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenTumorStatusAtCollection",
        description="Autogenerated Enumeration for CRDC-H Specimen tumor_status_at_collection",
        code_set=None,
        code_set_version="2021-12-16T18:04:28.204835+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Not Allowed To Collect",
                PermissibleValue(text="Not Allowed To Collect") )
        setattr(cls, "not reported",
                PermissibleValue(text="not reported") )
        setattr(cls, "Not Applicable",
                PermissibleValue(text="Not Applicable") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )

class EnumCRDCHSpecimenCellularCompositionType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen cellular_composition_type
    """
    Serum = PermissibleValue(text="Serum",
                                 description="Serum")
    Granulocytes = PermissibleValue(text="Granulocytes",
                                               description="Granulocyte")
    Cell = PermissibleValue(text="Cell",
                               description="Cell")
    Lymphocytes = PermissibleValue(text="Lymphocytes",
                                             description="Lymphocyte")
    Plasma = PermissibleValue(text="Plasma",
                                   description="Plasma")
    Sputum = PermissibleValue(text="Sputum",
                                   description="Sputum")
    Saliva = PermissibleValue(text="Saliva",
                                   description="Saliva")
    Unknown = PermissibleValue(text="Unknown")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenCellularCompositionType",
        description="Autogenerated Enumeration for CRDC-H Specimen cellular_composition_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:28.379034+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Mixed Adherent Suspension",
                PermissibleValue(text="Mixed Adherent Suspension") )
        setattr(cls, "3D Neurosphere",
                PermissibleValue(text="3D Neurosphere") )
        setattr(cls, "Fibroblasts from Bone Marrow Normal",
                PermissibleValue(text="Fibroblasts from Bone Marrow Normal",
                                 description="Normal Bone Marrow Fibroblast") )
        setattr(cls, "2D Classical Conditionally Reprogrammed Cells",
                PermissibleValue(text="2D Classical Conditionally Reprogrammed Cells") )
        setattr(cls, "2D Modified Conditionally Reprogrammed Cells",
                PermissibleValue(text="2D Modified Conditionally Reprogrammed Cells") )
        setattr(cls, "Derived Cell Line",
                PermissibleValue(text="Derived Cell Line",
                                 description="Derived Cell Line") )
        setattr(cls, "Bone Marrow Components NOS",
                PermissibleValue(text="Bone Marrow Components NOS",
                                 description="Bone Marrow Component Not Otherwise Specified") )
        setattr(cls, "Buccal Cells",
                PermissibleValue(text="Buccal Cells",
                                 description="Buccal Cell") )
        setattr(cls, "Mononuclear Cells from Bone Marrow Normal",
                PermissibleValue(text="Mononuclear Cells from Bone Marrow Normal",
                                 description="Normal Bone Marrow Monocyte") )
        setattr(cls, "Human Original Cells",
                PermissibleValue(text="Human Original Cells") )
        setattr(cls, "Solid Tissue",
                PermissibleValue(text="Solid Tissue",
                                 description="Solid Tissue") )
        setattr(cls, "Sorted Cells",
                PermissibleValue(text="Sorted Cells") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "3D Organoid",
                PermissibleValue(text="3D Organoid") )
        setattr(cls, "Peripheral Blood Components NOS",
                PermissibleValue(text="Peripheral Blood Components NOS",
                                 description="Peripheral Blood Component Not Otherwise Specified") )
        setattr(cls, "Whole Bone Marrow",
                PermissibleValue(text="Whole Bone Marrow",
                                 description="Whole Bone Marrow") )
        setattr(cls, "3D Air-Liquid Interface Organoid",
                PermissibleValue(text="3D Air-Liquid Interface Organoid") )
        setattr(cls, "Adherent Cell Line",
                PermissibleValue(text="Adherent Cell Line") )
        setattr(cls, "Pleural Effusion",
                PermissibleValue(text="Pleural Effusion",
                                 description="Pleural Fluid") )
        setattr(cls, "Liquid Suspension Cell Line",
                PermissibleValue(text="Liquid Suspension Cell Line") )
        setattr(cls, "Control Analyte",
                PermissibleValue(text="Control Analyte",
                                 description="Control Analyte") )
        setattr(cls, "Peripheral Whole Blood",
                PermissibleValue(text="Peripheral Whole Blood",
                                 description="Peripheral Whole Blood") )
        setattr(cls, "Bone Marrow Components",
                PermissibleValue(text="Bone Marrow Components",
                                 description="Bone Marrow Component") )
        setattr(cls, "Buffy Coat",
                PermissibleValue(text="Buffy Coat",
                                 description="Buffy Coat") )
        setattr(cls, "EBV Immortalized",
                PermissibleValue(text="EBV Immortalized",
                                 description="Epstein-Barr Virus Immortalized") )
        setattr(cls, "Not Allowed To Collect",
                PermissibleValue(text="Not Allowed To Collect") )

class EnumCRDCHSpecimenGeneralTissuePathology(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen general_tissue_pathology
    """
    Normal = PermissibleValue(text="Normal",
                                   description="Normal")
    Tumor = PermissibleValue(text="Tumor",
                                 description="Malignant Neoplasm")
    Abnormal = PermissibleValue(text="Abnormal",
                                       description="Abnormal")
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    Peritumoral = PermissibleValue(text="Peritumoral",
                                             description="Peritumoral")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenGeneralTissuePathology",
        description="Autogenerated Enumeration for CRDC-H Specimen general_tissue_pathology",
        code_set=None,
        code_set_version="2021-12-16T18:04:28.622991+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "Not Allowed To Collect",
                PermissibleValue(text="Not Allowed To Collect") )

class EnumCRDCHSpecimenSpecificTissuePathology(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen specific_tissue_pathology
    """
    Rhabdomyosarcoma = PermissibleValue(text="Rhabdomyosarcoma")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenSpecificTissuePathology",
        description="Autogenerated Enumeration for CRDC-H Specimen specific_tissue_pathology",
        code_set=None,
        code_set_version="2021-12-16T18:04:28.788333+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "60",
                PermissibleValue(text="60") )
        setattr(cls, "41",
                PermissibleValue(text="41") )
        setattr(cls, "15",
                PermissibleValue(text="15") )
        setattr(cls, "52",
                PermissibleValue(text="52") )
        setattr(cls, "51",
                PermissibleValue(text="51") )
        setattr(cls, "70",
                PermissibleValue(text="70") )
        setattr(cls, "50",
                PermissibleValue(text="50") )
        setattr(cls, "00",
                PermissibleValue(text="00") )
        setattr(cls, "20",
                PermissibleValue(text="20") )
        setattr(cls, "62",
                PermissibleValue(text="62") )
        setattr(cls, "30",
                PermissibleValue(text="30") )
        setattr(cls, "04",
                PermissibleValue(text="04") )
        setattr(cls, "63",
                PermissibleValue(text="63") )
        setattr(cls, "03",
                PermissibleValue(text="03") )
        setattr(cls, "65",
                PermissibleValue(text="65") )
        setattr(cls, "71",
                PermissibleValue(text="71") )
        setattr(cls, "64",
                PermissibleValue(text="64") )
        setattr(cls, "80",
                PermissibleValue(text="80") )
        setattr(cls, "02",
                PermissibleValue(text="02") )
        setattr(cls, "40",
                PermissibleValue(text="40") )
        setattr(cls, "01",
                PermissibleValue(text="01") )
        setattr(cls, "81",
                PermissibleValue(text="81") )
        setattr(cls, "61",
                PermissibleValue(text="61") )
        setattr(cls, "21",
                PermissibleValue(text="21") )
        setattr(cls, "10",
                PermissibleValue(text="10") )
        setattr(cls, "NHL, anaplastic large cell lymphoma",
                PermissibleValue(text="NHL, anaplastic large cell lymphoma") )
        setattr(cls, "Acute lymphoblastic leukemia (ALL)",
                PermissibleValue(text="Acute lymphoblastic leukemia (ALL)") )
        setattr(cls, "Clear cell sarcoma of the kidney (CCSK)",
                PermissibleValue(text="Clear cell sarcoma of the kidney (CCSK)") )
        setattr(cls, "Wilms tumor (WT)",
                PermissibleValue(text="Wilms tumor (WT)") )
        setattr(cls, "Cervical Cancer (all types)",
                PermissibleValue(text="Cervical Cancer (all types)") )
        setattr(cls, "Anal Cancer (all types)",
                PermissibleValue(text="Anal Cancer (all types)") )
        setattr(cls, "Ewing sarcoma",
                PermissibleValue(text="Ewing sarcoma") )
        setattr(cls, "CNS, rhabdoid tumor",
                PermissibleValue(text="CNS, rhabdoid tumor") )
        setattr(cls, "Non cancerous tissue",
                PermissibleValue(text="Non cancerous tissue") )
        setattr(cls, "CNS, other",
                PermissibleValue(text="CNS, other") )
        setattr(cls, "Acute Leukemia of Ambiguous Lineage (ALAL)",
                PermissibleValue(text="Acute Leukemia of Ambiguous Lineage (ALAL)") )
        setattr(cls, "Lung Cancer (all types)",
                PermissibleValue(text="Lung Cancer (all types)") )
        setattr(cls, "Induction Failure AML (AML-IF)",
                PermissibleValue(text="Induction Failure AML (AML-IF)") )
        setattr(cls, "CNS, medulloblastoma",
                PermissibleValue(text="CNS, medulloblastoma") )
        setattr(cls, "CNS, ependymoma",
                PermissibleValue(text="CNS, ependymoma") )
        setattr(cls, "CNS, glioblastoma (GBM)",
                PermissibleValue(text="CNS, glioblastoma (GBM)") )
        setattr(cls, "CNS, low grade glioma (LGG)",
                PermissibleValue(text="CNS, low grade glioma (LGG)") )
        setattr(cls, "Diffuse Large B-Cell Lymphoma (DLBCL)",
                PermissibleValue(text="Diffuse Large B-Cell Lymphoma (DLBCL)") )
        setattr(cls, "Rhabdoid tumor (kidney) (RT)",
                PermissibleValue(text="Rhabdoid tumor (kidney) (RT)") )
        setattr(cls, "Osteosarcoma (OS)",
                PermissibleValue(text="Osteosarcoma (OS)") )
        setattr(cls, "Soft tissue sarcoma, non-rhabdomyosarcoma",
                PermissibleValue(text="Soft tissue sarcoma, non-rhabdomyosarcoma") )
        setattr(cls, "NHL, Burkitt lymphoma (BL)",
                PermissibleValue(text="NHL, Burkitt lymphoma (BL)") )
        setattr(cls, "Neuroblastoma (NBL)",
                PermissibleValue(text="Neuroblastoma (NBL)") )
        setattr(cls, "Acute myeloid leukemia (AML)",
                PermissibleValue(text="Acute myeloid leukemia (AML)") )

class EnumCRDCHSpecimenPreinvasiveTissueMorphology(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen preinvasive_tissue_morphology
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenPreinvasiveTissueMorphology",
        description="Autogenerated Enumeration for CRDC-H Specimen preinvasive_tissue_morphology",
        code_set=None,
        code_set_version="2021-12-16T18:04:29.034984+00:00",
    )

class EnumCRDCHSpecimenMorphologyAssessorRole(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen morphology_assessor_role
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenMorphologyAssessorRole",
        description="Autogenerated Enumeration for CRDC-H Specimen morphology_assessor_role",
        code_set=None,
        code_set_version="2021-12-16T18:04:29.184186+00:00",
    )

class EnumCRDCHSpecimenMorphologyAssessmentMethod(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen morphology_assessment_method
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenMorphologyAssessmentMethod",
        description="Autogenerated Enumeration for CRDC-H Specimen morphology_assessment_method",
        code_set=None,
        code_set_version="2021-12-16T18:04:29.331265+00:00",
    )

class EnumCRDCHSpecimenDegreeOfDysplasia(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen degree_of_dysplasia
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenDegreeOfDysplasia",
        description="Autogenerated Enumeration for CRDC-H Specimen degree_of_dysplasia",
        code_set=None,
        code_set_version="2021-12-16T18:04:29.469027+00:00",
    )

class EnumCRDCHSpecimenSectionLocation(EnumDefinitionImpl):
    """
    The location in a parent specimen from which a section/portion was excised.
    """
    top = PermissibleValue(text="top",
                             description="The part of a specimen designated as its 'top' based on specified orientation criteria.")
    unknown = PermissibleValue(text="unknown",
                                     description="An unknown location on a specimen.")
    bottom = PermissibleValue(text="bottom",
                                   description="The part of a specimen designated as its 'bottom' based on specified orientation criteria.")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenSectionLocation",
        description="The location in a parent specimen from which a section/portion was excised.",
    )

class EnumCRDCHSpecimenContainerContainerType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H SpecimenContainer container_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenContainerContainerType",
        description="Autogenerated Enumeration for CRDC-H SpecimenContainer container_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:29.748768+00:00",
    )

class EnumCRDCHSpecimenCreationActivityActivityType(EnumDefinitionImpl):
    """
    The high-level type of activity through which the specimen was generated (i.e. via collection from the original
    source, or via derivation from an existing specimen)
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenCreationActivityActivityType",
        description="The high-level type of activity through which the specimen was generated (i.e. via collection from the original source, or via derivation from an existing specimen)",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "collection from source",
                PermissibleValue(text="collection from source",
                                 description="An activity that collects an initial sample directly from a subject / source.") )
        setattr(cls, "derivation from specimen",
                PermissibleValue(text="derivation from specimen",
                                 description="An activity that derives a new specimen from an existing one.") )

class EnumCRDCHSpecimenCreationActivityCollectionMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H SpecimenCreationActivity collection_method_type
    """
    Orchiectomy = PermissibleValue(text="Orchiectomy")
    Metastasectomy = PermissibleValue(text="Metastasectomy")
    Autopsy = PermissibleValue(text="Autopsy")
    Unknown = PermissibleValue(text="Unknown")
    Aspirate = PermissibleValue(text="Aspirate")
    Salpingectomy = PermissibleValue(text="Salpingectomy")
    Biopsy = PermissibleValue(text="Biopsy")
    Enucleation = PermissibleValue(text="Enucleation")
    Paracentesis = PermissibleValue(text="Paracentesis")
    Oophorectomy = PermissibleValue(text="Oophorectomy")
    Indeterminant = PermissibleValue(text="Indeterminant")
    Other = PermissibleValue(text="Other")
    Pancreatectomy = PermissibleValue(text="Pancreatectomy")
    Lobectomy = PermissibleValue(text="Lobectomy")
    Omentectomy = PermissibleValue(text="Omentectomy")
    Cystectomy = PermissibleValue(text="Cystectomy")
    Thoracentesis = PermissibleValue(text="Thoracentesis")
    Transplant = PermissibleValue(text="Transplant")
    Pneumonectomy = PermissibleValue(text="Pneumonectomy")
    Lumpectomy = PermissibleValue(text="Lumpectomy")
    Lymphadenectomy = PermissibleValue(text="Lymphadenectomy")
    No = PermissibleValue(text="No")
    Yes = PermissibleValue(text="Yes")
    Tonsillectomy = PermissibleValue(text="Tonsillectomy")
    Laryngopharyngectomy = PermissibleValue(text="Laryngopharyngectomy")
    Maxillectomy = PermissibleValue(text="Maxillectomy")
    Mandibulectomy = PermissibleValue(text="Mandibulectomy")
    Palatectomy = PermissibleValue(text="Palatectomy")
    Glossectomy = PermissibleValue(text="Glossectomy")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenCreationActivityCollectionMethodType",
        description="Autogenerated Enumeration for CRDC-H SpecimenCreationActivity collection_method_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:30.023438+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Right Hemicolectomy",
                PermissibleValue(text="Right Hemicolectomy") )
        setattr(cls, "Incisional Biopsy",
                PermissibleValue(text="Incisional Biopsy") )
        setattr(cls, "Blood Draw",
                PermissibleValue(text="Blood Draw") )
        setattr(cls, "Peritoneal Lavage",
                PermissibleValue(text="Peritoneal Lavage") )
        setattr(cls, "Open Radical Prostatectomy",
                PermissibleValue(text="Open Radical Prostatectomy") )
        setattr(cls, "Abdomino-perineal Resection of Rectum",
                PermissibleValue(text="Abdomino-perineal Resection of Rectum") )
        setattr(cls, "Endo Rectal Tumor Resection",
                PermissibleValue(text="Endo Rectal Tumor Resection") )
        setattr(cls, "Salpingo-oophorectomy",
                PermissibleValue(text="Salpingo-oophorectomy") )
        setattr(cls, "Not Allowed To Collect",
                PermissibleValue(text="Not Allowed To Collect") )
        setattr(cls, "Whipple Procedure",
                PermissibleValue(text="Whipple Procedure") )
        setattr(cls, "Modified Radical Mastectomy",
                PermissibleValue(text="Modified Radical Mastectomy") )
        setattr(cls, "Open Craniotomy",
                PermissibleValue(text="Open Craniotomy") )
        setattr(cls, "Wedge Resection",
                PermissibleValue(text="Wedge Resection") )
        setattr(cls, "Laparoscopic Radical Nephrectomy",
                PermissibleValue(text="Laparoscopic Radical Nephrectomy") )
        setattr(cls, "Open Partial Nephrectomy",
                PermissibleValue(text="Open Partial Nephrectomy") )
        setattr(cls, "Transurethral resection (TURBT)",
                PermissibleValue(text="Transurethral resection (TURBT)") )
        setattr(cls, "Sigmoid Colectomy",
                PermissibleValue(text="Sigmoid Colectomy") )
        setattr(cls, "Total Hepatectomy",
                PermissibleValue(text="Total Hepatectomy") )
        setattr(cls, "Subtotal Resection",
                PermissibleValue(text="Subtotal Resection") )
        setattr(cls, "Left Hemicolectomy",
                PermissibleValue(text="Left Hemicolectomy") )
        setattr(cls, "Needle Biopsy",
                PermissibleValue(text="Needle Biopsy") )
        setattr(cls, "Thoracoscopic Biopsy",
                PermissibleValue(text="Thoracoscopic Biopsy") )
        setattr(cls, "Total Mastectomy",
                PermissibleValue(text="Total Mastectomy") )
        setattr(cls, "Excisional Biopsy",
                PermissibleValue(text="Excisional Biopsy") )
        setattr(cls, "Bone Marrow Aspirate",
                PermissibleValue(text="Bone Marrow Aspirate") )
        setattr(cls, "Local Resection (Exoresection; wall resection)",
                PermissibleValue(text="Local Resection (Exoresection; wall resection)") )
        setattr(cls, "Fine Needle Aspiration",
                PermissibleValue(text="Fine Needle Aspiration") )
        setattr(cls, "Tumor Resection",
                PermissibleValue(text="Tumor Resection") )
        setattr(cls, "Gross Total Resection",
                PermissibleValue(text="Gross Total Resection") )
        setattr(cls, "Anterior Resection of Rectum",
                PermissibleValue(text="Anterior Resection of Rectum") )
        setattr(cls, "Laparoscopic Partial Nephrectomy",
                PermissibleValue(text="Laparoscopic Partial Nephrectomy") )
        setattr(cls, "Laparoscopic Radical Prostatectomy with Robotics",
                PermissibleValue(text="Laparoscopic Radical Prostatectomy with Robotics") )
        setattr(cls, "Pan-Procto Colectomy",
                PermissibleValue(text="Pan-Procto Colectomy") )
        setattr(cls, "Hysterectomy NOS",
                PermissibleValue(text="Hysterectomy NOS") )
        setattr(cls, "Core Biopsy",
                PermissibleValue(text="Core Biopsy") )
        setattr(cls, "Simple Mastectomy",
                PermissibleValue(text="Simple Mastectomy") )
        setattr(cls, "Endoscopic Biopsy",
                PermissibleValue(text="Endoscopic Biopsy") )
        setattr(cls, "Simple Hysterectomy",
                PermissibleValue(text="Simple Hysterectomy") )
        setattr(cls, "Laparoscopic Biopsy",
                PermissibleValue(text="Laparoscopic Biopsy") )
        setattr(cls, "Tumor Debulking",
                PermissibleValue(text="Tumor Debulking") )
        setattr(cls, "Ascites Drainage",
                PermissibleValue(text="Ascites Drainage") )
        setattr(cls, "Endoscopic Mucosal Resection (EMR)",
                PermissibleValue(text="Endoscopic Mucosal Resection (EMR)") )
        setattr(cls, "Laparoscopic Radical Prostatectomy without Robotics",
                PermissibleValue(text="Laparoscopic Radical Prostatectomy without Robotics") )
        setattr(cls, "Total Colectomy",
                PermissibleValue(text="Total Colectomy") )
        setattr(cls, "Liquid Biopsy",
                PermissibleValue(text="Liquid Biopsy") )
        setattr(cls, "Radical Hysterectomy",
                PermissibleValue(text="Radical Hysterectomy") )
        setattr(cls, "Surgical Resection",
                PermissibleValue(text="Surgical Resection") )
        setattr(cls, "Open Radical Nephrectomy",
                PermissibleValue(text="Open Radical Nephrectomy") )
        setattr(cls, "Transverse Colectomy",
                PermissibleValue(text="Transverse Colectomy") )
        setattr(cls, "Hand Assisted Laparoscopic Radical Nephrectomy",
                PermissibleValue(text="Hand Assisted Laparoscopic Radical Nephrectomy") )
        setattr(cls, "Punch Biopsy",
                PermissibleValue(text="Punch Biopsy") )
        setattr(cls, "Partial Hepatectomy",
                PermissibleValue(text="Partial Hepatectomy") )
        setattr(cls, "Supracervical Hysterectomy",
                PermissibleValue(text="Supracervical Hysterectomy") )
        setattr(cls, "Other Surgical Resection",
                PermissibleValue(text="Other Surgical Resection") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "Full Hysterectomy",
                PermissibleValue(text="Full Hysterectomy") )
        setattr(cls, "Supraglottic Laryngectomy",
                PermissibleValue(text="Supraglottic Laryngectomy") )
        setattr(cls, "Superficial Parotidectomy",
                PermissibleValue(text="Superficial Parotidectomy") )
        setattr(cls, "Transurethral Resection (TURP)",
                PermissibleValue(text="Transurethral Resection (TURP)") )
        setattr(cls, "Partial Nephrectomy",
                PermissibleValue(text="Partial Nephrectomy") )
        setattr(cls, "Buccal Mucosal Resection",
                PermissibleValue(text="Buccal Mucosal Resection") )
        setattr(cls, "Vertical Hemilaryngectomy",
                PermissibleValue(text="Vertical Hemilaryngectomy") )
        setattr(cls, "Total Nephrectomy",
                PermissibleValue(text="Total Nephrectomy") )
        setattr(cls, "Total Laryngectomy",
                PermissibleValue(text="Total Laryngectomy") )
        setattr(cls, "Transoral Laser Excision",
                PermissibleValue(text="Transoral Laser Excision") )
        setattr(cls, "Parotidectomy, NOS",
                PermissibleValue(text="Parotidectomy, NOS") )
        setattr(cls, "Radical Maxillectomy",
                PermissibleValue(text="Radical Maxillectomy") )
        setattr(cls, "Endolaryngeal Excision",
                PermissibleValue(text="Endolaryngeal Excision") )
        setattr(cls, "Partial Laryngectomy",
                PermissibleValue(text="Partial Laryngectomy") )
        setattr(cls, "Lymph Node Dissection",
                PermissibleValue(text="Lymph Node Dissection") )
        setattr(cls, "Radical Prostatectomy",
                PermissibleValue(text="Radical Prostatectomy") )
        setattr(cls, "Deep Parotidectomy",
                PermissibleValue(text="Deep Parotidectomy") )
        setattr(cls, "Subtotal Prostatectomy",
                PermissibleValue(text="Subtotal Prostatectomy") )
        setattr(cls, "Radical Nephrectomy",
                PermissibleValue(text="Radical Nephrectomy") )
        setattr(cls, "Supracricoid Laryngectomy",
                PermissibleValue(text="Supracricoid Laryngectomy") )
        setattr(cls, "Partial Maxillectomy",
                PermissibleValue(text="Partial Maxillectomy") )

class EnumCRDCHSpecimenCreationActivityDerivationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H SpecimenCreationActivity derivation_method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenCreationActivityDerivationMethodType",
        description="Autogenerated Enumeration for CRDC-H SpecimenCreationActivity derivation_method_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:30.373776+00:00",
    )

class EnumCRDCHSpecimenQualityObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H SpecimenQualityObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenQualityObservationCategory",
        description="Autogenerated Enumeration for CRDC-H SpecimenQualityObservation category",
        code_set=None,
        code_set_version="2021-12-16T18:04:30.515200+00:00",
    )

class EnumCRDCHSpecimenQualityObservationObservationType(EnumDefinitionImpl):
    """
    Types of measurements that reflect the quality of a specimen or its suitability for use.
    """
    ribosomal_rna_28s_16s_ratio = PermissibleValue(text="ribosomal_rna_28s_16s_ratio",
                                                                             description="Ratio of quantity of 28s RNA over that of 16s RNA.")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenQualityObservationObservationType",
        description="Types of measurements that reflect the quality of a specimen or its suitability for use.",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "a260_a280_ratio  ",
                PermissibleValue(text="a260_a280_ratio  ",
                                 description="Ratio of absorbance measured at a wavelength of 260 over that at a wavelength of 280.") )

class EnumCRDCHSpecimenQualityObservationMethodType(EnumDefinitionImpl):
    """
    A type of method used in determining the quantity of a specimen.
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenQualityObservationMethodType",
        description="A type of method used in determining the quantity of a specimen.",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "UV Spec",
                PermissibleValue(text="UV Spec",
                                 description="A technique used to measure light absorbance across the ultraviolet and visible ranges of the electromagnetic spectrum.") )
        setattr(cls, "Pico Green",
                PermissibleValue(text="Pico Green",
                                 description="A technique applying the Pico488 fluorescent sensor dye that is used for quantifying the amount of double-stranded DNA (dsDNA) present in a given sample.") )

class EnumCRDCHSpecimenQuantityObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H SpecimenQuantityObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenQuantityObservationCategory",
        description="Autogenerated Enumeration for CRDC-H SpecimenQuantityObservation category",
        code_set=None,
        code_set_version="2021-12-16T18:04:30.942437+00:00",
    )

class EnumCRDCHSpecimenQuantityObservationObservationType(EnumDefinitionImpl):
    """
    Measures related to the quantity of a specimen or analyte it currently contains - e.g. its weight, volume, or
    concentration.
    """
    weight = PermissibleValue(text="weight",
                                   description="The current weight of the specimen, at the time of recording (as opposed to an initial weight before its processing or portioning).")
    volume = PermissibleValue(text="volume",
                                   description="The current total volume of the specimen, at the time of recording.")
    concentration = PermissibleValue(text="concentration",
                                                 description="The concentration of an extracted analyte that is present in a specimen (specifically, in a specimen of type 'analyte', or an 'aliquot' derived from an analyte). For example, the concentration of DNA in a specimen created through extracting DNA from a blood sample.")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenQuantityObservationObservationType",
        description="Measures related to the quantity of a specimen or analyte it currently contains - e.g. its weight, volume, or concentration.",
    )

class EnumCRDCHSpecimenQuantityObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H SpecimenQuantityObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenQuantityObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H SpecimenQuantityObservation method_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:31.226101+00:00",
    )

class EnumCRDCHSpecimenProcessingActivityActivityType(EnumDefinitionImpl):
    """
    The high-level type of processing activity performed.
    """
    Fixation = PermissibleValue(text="Fixation",
                                       description="A processing activity that applies chemicals to preserve biological tissues from decay due to autolysis or putrefaction")
    Freezing = PermissibleValue(text="Freezing",
                                       description="A processing activity that aims to freeze a specimen.")
    Mounting = PermissibleValue(text="Mounting",
                                       description="A processing activity that aims to secure a specimen or slide in place in preparation for further examination (usually via microscopy)")
    Preservation = PermissibleValue(text="Preservation",
                                               description="A processing activity that aims to preserve a specimen.")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenProcessingActivityActivityType",
        description="The high-level type of processing activity performed.",
    )

class EnumCRDCHSpecimenProcessingActivityMethodType(EnumDefinitionImpl):
    """
    A type of method used to process a specimen (e.g. freezing, fixing, treating, preserving, labeling, etc.).
    """
    LN2 = PermissibleValue(text="LN2",
                             description="Freezing in liquid nitrogen.")
    isopentane = PermissibleValue(text="isopentane",
                                           description="Freezing in isopentane.")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenProcessingActivityMethodType",
        description="A type of method used to process a specimen (e.g. freezing, fixing, treating, preserving, labeling, etc.).",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Minues 80 Degrees Celsius Freezer",
                PermissibleValue(text="Minues 80 Degrees Celsius Freezer",
                                 description="Freezing at -80 degrees celcius") )
        setattr(cls, "-20",
                PermissibleValue(text="-20",
                                 description="Freezing at -20 degrees celcius") )

class EnumCRDCHSpecimenStorageActivityMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H SpecimenStorageActivity method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenStorageActivityMethodType",
        description="Autogenerated Enumeration for CRDC-H SpecimenStorageActivity method_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:31.675280+00:00",
    )

class EnumCRDCHSubjectSpecies(EnumDefinitionImpl):
    """
    The scientific binomial name for the species of the subject
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSubjectSpecies",
        description="The scientific binomial name for the species of the subject",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Homo sapiens",
                PermissibleValue(text="Homo sapiens") )
        setattr(cls, "Canis familiaris",
                PermissibleValue(text="Canis familiaris") )
        setattr(cls, "Mus musculus",
                PermissibleValue(text="Mus musculus") )

class EnumCRDCHSubjectBreed(EnumDefinitionImpl):
    """
    A label given to a group of animals homogeneous in appearance and other characteristics that distinguish it from
    other animals of the same species.
    """
    Akita = PermissibleValue(text="Akita")
    Beagle = PermissibleValue(text="Beagle")
    Boxer = PermissibleValue(text="Boxer")
    Bulldog = PermissibleValue(text="Bulldog")
    Bullmastiff = PermissibleValue(text="Bullmastiff")
    Chihuahua = PermissibleValue(text="Chihuahua")
    Dalmatian = PermissibleValue(text="Dalmatian")
    Greyhound = PermissibleValue(text="Greyhound")
    Mastiff = PermissibleValue(text="Mastiff")
    Poodle = PermissibleValue(text="Poodle")
    Rottweiler = PermissibleValue(text="Rottweiler")
    Samoyed = PermissibleValue(text="Samoyed")
    Vizsla = PermissibleValue(text="Vizsla")
    Weimaraner = PermissibleValue(text="Weimaraner")

    _defn = EnumDefinition(
        name="EnumCRDCHSubjectBreed",
        description="A label given to a group of animals homogeneous in appearance and other characteristics that distinguish it from other animals of the same species.",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "American Staffordshire Terrier",
                PermissibleValue(text="American Staffordshire Terrier") )
        setattr(cls, "Australian Shepherd",
                PermissibleValue(text="Australian Shepherd") )
        setattr(cls, "Basset Hound",
                PermissibleValue(text="Basset Hound") )
        setattr(cls, "Belgian Malinois",
                PermissibleValue(text="Belgian Malinois") )
        setattr(cls, "Bernese Mountain Dog",
                PermissibleValue(text="Bernese Mountain Dog") )
        setattr(cls, "Black and Tan Coonhound",
                PermissibleValue(text="Black and Tan Coonhound") )
        setattr(cls, "Border Collie",
                PermissibleValue(text="Border Collie") )
        setattr(cls, "Boston Terrier",
                PermissibleValue(text="Boston Terrier") )
        setattr(cls, "Bouvier des Flandres",
                PermissibleValue(text="Bouvier des Flandres") )
        setattr(cls, "Cavalier King Charles Spaniel",
                PermissibleValue(text="Cavalier King Charles Spaniel") )
        setattr(cls, "Chesapeake Bay Retriever",
                PermissibleValue(text="Chesapeake Bay Retriever") )
        setattr(cls, "Chinese Shar-Pei",
                PermissibleValue(text="Chinese Shar-Pei") )
        setattr(cls, "Cocker Spaniel",
                PermissibleValue(text="Cocker Spaniel") )
        setattr(cls, "Doberman Pinscher",
                PermissibleValue(text="Doberman Pinscher") )
        setattr(cls, "English Setter",
                PermissibleValue(text="English Setter") )
        setattr(cls, "Flat-Coated Retriever",
                PermissibleValue(text="Flat-Coated Retriever") )
        setattr(cls, "French Bulldog",
                PermissibleValue(text="French Bulldog") )
        setattr(cls, "German Shepherd Dog",
                PermissibleValue(text="German Shepherd Dog") )
        setattr(cls, "German Shorthaired Pointer",
                PermissibleValue(text="German Shorthaired Pointer") )
        setattr(cls, "Giant Schnauzer",
                PermissibleValue(text="Giant Schnauzer") )
        setattr(cls, "Golden Retriever",
                PermissibleValue(text="Golden Retriever") )
        setattr(cls, "Gordon Setter",
                PermissibleValue(text="Gordon Setter") )
        setattr(cls, "Irish Setter",
                PermissibleValue(text="Irish Setter") )
        setattr(cls, "Irish Wolfhound",
                PermissibleValue(text="Irish Wolfhound") )
        setattr(cls, "Labrador Retriever",
                PermissibleValue(text="Labrador Retriever") )
        setattr(cls, "Miniature Schnauzer",
                PermissibleValue(text="Miniature Schnauzer") )
        setattr(cls, "Mixed Breed",
                PermissibleValue(text="Mixed Breed") )
        setattr(cls, "Parson Russell Terrier",
                PermissibleValue(text="Parson Russell Terrier") )
        setattr(cls, "Saint Bernard",
                PermissibleValue(text="Saint Bernard") )
        setattr(cls, "Shih Tzu",
                PermissibleValue(text="Shih Tzu") )
        setattr(cls, "Staffordshire Bull Terrier",
                PermissibleValue(text="Staffordshire Bull Terrier") )
        setattr(cls, "West Highland White Terrier",
                PermissibleValue(text="West Highland White Terrier") )
        setattr(cls, "Yorkshire Terrier",
                PermissibleValue(text="Yorkshire Terrier") )

class EnumCRDCHSubjectSex(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Subject sex
    """
    unspecified = PermissibleValue(text="unspecified")
    unknown = PermissibleValue(text="unknown")
    female = PermissibleValue(text="female")
    male = PermissibleValue(text="male")

    _defn = EnumDefinition(
        name="EnumCRDCHSubjectSex",
        description="Autogenerated Enumeration for CRDC-H Subject sex",
        code_set=None,
        code_set_version="2021-12-16T18:04:32.112679+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "not reported",
                PermissibleValue(text="not reported") )

class EnumCRDCHSubjectEthnicity(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Subject ethnicity
    """
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    unknown = PermissibleValue(text="unknown")

    _defn = EnumDefinition(
        name="EnumCRDCHSubjectEthnicity",
        description="Autogenerated Enumeration for CRDC-H Subject ethnicity",
        code_set=None,
        code_set_version="2021-12-16T18:04:32.260053+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "hispanic or latino",
                PermissibleValue(text="hispanic or latino") )
        setattr(cls, "not reported",
                PermissibleValue(text="not reported") )
        setattr(cls, "not allowed to collect",
                PermissibleValue(text="not allowed to collect") )
        setattr(cls, "not hispanic or latino",
                PermissibleValue(text="not hispanic or latino") )

class EnumCRDCHSubjectRace(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Subject race
    """
    other = PermissibleValue(text="other")
    asian = PermissibleValue(text="asian")
    white = PermissibleValue(text="white")
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    unknown = PermissibleValue(text="unknown")

    _defn = EnumDefinition(
        name="EnumCRDCHSubjectRace",
        description="Autogenerated Enumeration for CRDC-H Subject race",
        code_set=None,
        code_set_version="2021-12-16T18:04:32.417638+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "american indian or alaska native",
                PermissibleValue(text="american indian or alaska native") )
        setattr(cls, "native hawaiian or other pacific islander",
                PermissibleValue(text="native hawaiian or other pacific islander") )
        setattr(cls, "not reported",
                PermissibleValue(text="not reported") )
        setattr(cls, "not allowed to collect",
                PermissibleValue(text="not allowed to collect") )
        setattr(cls, "black or african american",
                PermissibleValue(text="black or african american") )

class EnumCRDCHSubjectVitalStatus(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Subject vital_status
    """
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    Alive = PermissibleValue(text="Alive",
                                 description="ALIVE")
    Dead = PermissibleValue(text="Dead",
                               description="DEAD")

    _defn = EnumDefinition(
        name="EnumCRDCHSubjectVitalStatus",
        description="Autogenerated Enumeration for CRDC-H Subject vital_status",
        code_set=None,
        code_set_version="2021-12-16T18:04:32.571797+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported",
                                 description="Not Reported") )

class EnumCRDCHSubjectCauseOfDeath(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Subject cause_of_death
    """
    Infection = PermissibleValue(text="Infection",
                                         description="Infection")
    Toxicity = PermissibleValue(text="Toxicity",
                                       description="Toxicity")
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")

    _defn = EnumDefinition(
        name="EnumCRDCHSubjectCauseOfDeath",
        description="Autogenerated Enumeration for CRDC-H Subject cause_of_death",
        code_set=None,
        code_set_version="2021-12-16T18:04:32.719969+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Spinal Muscular Atrophy",
                PermissibleValue(text="Spinal Muscular Atrophy",
                                 description="Spinal Muscular Atrophy") )
        setattr(cls, "Not Cancer Related",
                PermissibleValue(text="Not Cancer Related") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported",
                                 description="Not Reported") )
        setattr(cls, "Cardiovascular Disorder, NOS",
                PermissibleValue(text="Cardiovascular Disorder, NOS",
                                 description="Cardiovascular Disorder, NOS") )
        setattr(cls, "Renal Disorder, NOS",
                PermissibleValue(text="Renal Disorder, NOS",
                                 description="Renal Disorder, NOS") )
        setattr(cls, "Surgical Complications",
                PermissibleValue(text="Surgical Complications",
                                 description="Surgical Procedure Complication") )
        setattr(cls, "Cancer Related",
                PermissibleValue(text="Cancer Related") )
        setattr(cls, "End-stage Renal Disease",
                PermissibleValue(text="End-stage Renal Disease",
                                 description="Chronic Kidney Disease, Stage 5") )

class EnumCRDCHSubstanceSubstanceType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Substance substance_type
    """
    Enoblituzumab = PermissibleValue(text="Enoblituzumab")
    Cyclosporine = PermissibleValue(text="Cyclosporine")
    Goserelin = PermissibleValue(text="Goserelin")
    Apomine = PermissibleValue(text="Apomine")
    Zinostatin = PermissibleValue(text="Zinostatin")
    Carbendazim = PermissibleValue(text="Carbendazim")
    Abagovomab = PermissibleValue(text="Abagovomab")
    Masoprocol = PermissibleValue(text="Masoprocol")
    Tepotinib = PermissibleValue(text="Tepotinib")
    Nortopixantrone = PermissibleValue(text="Nortopixantrone")
    Troglitazone = PermissibleValue(text="Troglitazone")
    Celecoxib = PermissibleValue(text="Celecoxib")
    Ofatumumab = PermissibleValue(text="Ofatumumab")
    Tubercidin = PermissibleValue(text="Tubercidin")
    Tafasitamab = PermissibleValue(text="Tafasitamab")
    Oleclumab = PermissibleValue(text="Oleclumab")
    Lenvatinib = PermissibleValue(text="Lenvatinib")
    Toremifene = PermissibleValue(text="Toremifene")
    Triazinate = PermissibleValue(text="Triazinate")
    Beauvericin = PermissibleValue(text="Beauvericin")
    Porfiromycin = PermissibleValue(text="Porfiromycin")
    Sapitinib = PermissibleValue(text="Sapitinib")
    Tiragolumab = PermissibleValue(text="Tiragolumab")
    Anaxirone = PermissibleValue(text="Anaxirone")
    Favezelimab = PermissibleValue(text="Favezelimab")
    Staurosporine = PermissibleValue(text="Staurosporine")
    Cantrixil = PermissibleValue(text="Cantrixil")
    Olinvacimab = PermissibleValue(text="Olinvacimab")
    Uroacitides = PermissibleValue(text="Uroacitides")
    Urelumab = PermissibleValue(text="Urelumab")
    Dacetuzumab = PermissibleValue(text="Dacetuzumab")
    Saracatinib = PermissibleValue(text="Saracatinib")
    Grapiprant = PermissibleValue(text="Grapiprant")
    Mitindomide = PermissibleValue(text="Mitindomide")
    Ganitumab = PermissibleValue(text="Ganitumab")
    Modotuximab = PermissibleValue(text="Modotuximab")
    Trofosfamide = PermissibleValue(text="Trofosfamide")
    Tipiracil = PermissibleValue(text="Tipiracil")
    Navarixin = PermissibleValue(text="Navarixin")
    Olutasidenib = PermissibleValue(text="Olutasidenib")
    Enasidenib = PermissibleValue(text="Enasidenib")
    Vedolizumab = PermissibleValue(text="Vedolizumab")
    Glesatinib = PermissibleValue(text="Glesatinib")
    Upamostat = PermissibleValue(text="Upamostat")
    Vinorelbine = PermissibleValue(text="Vinorelbine")
    Tritylcysteine = PermissibleValue(text="Tritylcysteine")
    Ivosidenib = PermissibleValue(text="Ivosidenib")
    Sonidegib = PermissibleValue(text="Sonidegib")
    Atamestane = PermissibleValue(text="Atamestane")
    Vesencumab = PermissibleValue(text="Vesencumab")
    Valrubicin = PermissibleValue(text="Valrubicin")
    Lenalidomide = PermissibleValue(text="Lenalidomide")
    Volociximab = PermissibleValue(text="Volociximab")
    Bevacizumab = PermissibleValue(text="Bevacizumab")
    Imgatuzumab = PermissibleValue(text="Imgatuzumab")
    Mitobronitol = PermissibleValue(text="Mitobronitol")
    Uproleselan = PermissibleValue(text="Uproleselan")
    Clomesone = PermissibleValue(text="Clomesone")
    Fimepinostat = PermissibleValue(text="Fimepinostat")
    Chlorambucil = PermissibleValue(text="Chlorambucil")
    Trifluridine = PermissibleValue(text="Trifluridine")
    Onatasertib = PermissibleValue(text="Onatasertib")
    Amuvatinib = PermissibleValue(text="Amuvatinib")
    Doxifluridine = PermissibleValue(text="Doxifluridine")
    Vorasidenib = PermissibleValue(text="Vorasidenib")
    Deuteporfin = PermissibleValue(text="Deuteporfin")
    Natalizumab = PermissibleValue(text="Natalizumab")
    Flanvotumab = PermissibleValue(text="Flanvotumab")
    Silibinin = PermissibleValue(text="Silibinin")
    Ilginatinib = PermissibleValue(text="Ilginatinib")
    Plinabulin = PermissibleValue(text="Plinabulin")
    Olaratumab = PermissibleValue(text="Olaratumab")
    Cintirorgon = PermissibleValue(text="Cintirorgon")
    Ceritinib = PermissibleValue(text="Ceritinib")
    Leuprolide = PermissibleValue(text="Leuprolide")
    Oxcarbazepine = PermissibleValue(text="Oxcarbazepine")
    Chiauranib = PermissibleValue(text="Chiauranib")
    Troriluzole = PermissibleValue(text="Troriluzole")
    Arcitumomab = PermissibleValue(text="Arcitumomab")
    Topixantrone = PermissibleValue(text="Topixantrone")
    Chemotherapy = PermissibleValue(text="Chemotherapy")
    Toripalimab = PermissibleValue(text="Toripalimab")
    Guadecitabine = PermissibleValue(text="Guadecitabine")
    Valemetostat = PermissibleValue(text="Valemetostat")
    Sizofiran = PermissibleValue(text="Sizofiran")
    Acetylcysteine = PermissibleValue(text="Acetylcysteine")
    Aceglatone = PermissibleValue(text="Aceglatone")
    Temsirolimus = PermissibleValue(text="Temsirolimus")
    Brequinar = PermissibleValue(text="Brequinar")
    Theliatinib = PermissibleValue(text="Theliatinib")
    Futibatinib = PermissibleValue(text="Futibatinib")
    Radgocitabine = PermissibleValue(text="Radgocitabine")
    Chlorozotocin = PermissibleValue(text="Chlorozotocin")
    Nedaplatin = PermissibleValue(text="Nedaplatin")
    Nogalamycin = PermissibleValue(text="Nogalamycin")
    Omipalisib = PermissibleValue(text="Omipalisib")
    Valspodar = PermissibleValue(text="Valspodar")
    Bisthianostat = PermissibleValue(text="Bisthianostat")
    Glasdegib = PermissibleValue(text="Glasdegib")
    Geldanamycin = PermissibleValue(text="Geldanamycin")
    Peptichemio = PermissibleValue(text="Peptichemio")
    Tovetumab = PermissibleValue(text="Tovetumab")
    Apitolisib = PermissibleValue(text="Apitolisib")
    Aranose = PermissibleValue(text="Aranose")
    Annamycin = PermissibleValue(text="Annamycin")
    Penicillamine = PermissibleValue(text="Penicillamine")
    Abituzumab = PermissibleValue(text="Abituzumab")
    Dexanabinol = PermissibleValue(text="Dexanabinol")
    Batabulin = PermissibleValue(text="Batabulin")
    Prolgolimab = PermissibleValue(text="Prolgolimab")
    Crizotinib = PermissibleValue(text="Crizotinib")
    Batimastat = PermissibleValue(text="Batimastat")
    Ivuxolimab = PermissibleValue(text="Ivuxolimab")
    Daclizumab = PermissibleValue(text="Daclizumab")
    Octreotide = PermissibleValue(text="Octreotide")
    Trilaciclib = PermissibleValue(text="Trilaciclib")
    Clomiphene = PermissibleValue(text="Clomiphene")
    Tamibarotene = PermissibleValue(text="Tamibarotene")
    Balstilimab = PermissibleValue(text="Balstilimab")
    Naxitamab = PermissibleValue(text="Naxitamab")
    Sulofenur = PermissibleValue(text="Sulofenur")
    Spartalizumab = PermissibleValue(text="Spartalizumab")
    Tasisulam = PermissibleValue(text="Tasisulam")
    Cinobufotalin = PermissibleValue(text="Cinobufotalin")
    Sonolisib = PermissibleValue(text="Sonolisib")
    Relacorilant = PermissibleValue(text="Relacorilant")
    Cenisertib = PermissibleValue(text="Cenisertib")
    Cevostamab = PermissibleValue(text="Cevostamab")
    Picoplatin = PermissibleValue(text="Picoplatin")
    Bortezomib = PermissibleValue(text="Bortezomib")
    Oregovomab = PermissibleValue(text="Oregovomab")
    Atiprimod = PermissibleValue(text="Atiprimod")
    Cetuximab = PermissibleValue(text="Cetuximab")
    Inalimarev = PermissibleValue(text="Inalimarev")
    Fruquintinib = PermissibleValue(text="Fruquintinib")
    Teglarinad = PermissibleValue(text="Teglarinad")
    Racotumomab = PermissibleValue(text="Racotumomab")
    Cixutumumab = PermissibleValue(text="Cixutumumab")
    Azimexon = PermissibleValue(text="Azimexon")
    Lomustine = PermissibleValue(text="Lomustine")
    Amsilarotene = PermissibleValue(text="Amsilarotene")
    Orelabrutinib = PermissibleValue(text="Orelabrutinib")
    Pterostilbene = PermissibleValue(text="Pterostilbene")
    Padoporfin = PermissibleValue(text="Padoporfin")
    HPPH = PermissibleValue(text="HPPH")
    Flutamide = PermissibleValue(text="Flutamide")
    Venetoclax = PermissibleValue(text="Venetoclax")
    Interferon = PermissibleValue(text="Interferon")
    Indoximod = PermissibleValue(text="Indoximod")
    Nocodazole = PermissibleValue(text="Nocodazole")
    Epcoritamab = PermissibleValue(text="Epcoritamab")
    SarCNU = PermissibleValue(text="SarCNU")
    Etoprine = PermissibleValue(text="Etoprine")
    Bemcentinib = PermissibleValue(text="Bemcentinib")
    Encelimab = PermissibleValue(text="Encelimab")
    Amatuximab = PermissibleValue(text="Amatuximab")
    Plevitrexed = PermissibleValue(text="Plevitrexed")
    Birinapant = PermissibleValue(text="Birinapant")
    Platinum = PermissibleValue(text="Platinum")
    Kanitinib = PermissibleValue(text="Kanitinib")
    Tyroserleutide = PermissibleValue(text="Tyroserleutide")
    Thiarabine = PermissibleValue(text="Thiarabine")
    Lucatumumab = PermissibleValue(text="Lucatumumab")
    Vitespen = PermissibleValue(text="Vitespen")
    Isatuximab = PermissibleValue(text="Isatuximab")
    Ranolazine = PermissibleValue(text="Ranolazine")
    Mitoxantrone = PermissibleValue(text="Mitoxantrone")
    Iproplatin = PermissibleValue(text="Iproplatin")
    Piperazinedione = PermissibleValue(text="Piperazinedione")
    Miptenalimab = PermissibleValue(text="Miptenalimab")
    Daunorubicin = PermissibleValue(text="Daunorubicin")
    Anastrozole = PermissibleValue(text="Anastrozole")
    Oxidopamine = PermissibleValue(text="Oxidopamine")
    Conatumumab = PermissibleValue(text="Conatumumab")
    Ipilimumab = PermissibleValue(text="Ipilimumab")
    Retinol = PermissibleValue(text="Retinol")
    Vonlerolizumab = PermissibleValue(text="Vonlerolizumab")
    Gefitinib = PermissibleValue(text="Gefitinib")
    Losoxantrone = PermissibleValue(text="Losoxantrone")
    Lacutamab = PermissibleValue(text="Lacutamab")
    Domatinostat = PermissibleValue(text="Domatinostat")
    Lurtotecan = PermissibleValue(text="Lurtotecan")
    Lontucirev = PermissibleValue(text="Lontucirev")
    Lapatinib = PermissibleValue(text="Lapatinib")
    Elsamitrucin = PermissibleValue(text="Elsamitrucin")
    Macimorelin = PermissibleValue(text="Macimorelin")
    Bicalutamide = PermissibleValue(text="Bicalutamide")
    Pentamethylmelamine = PermissibleValue(text="Pentamethylmelamine")
    Pirfenidone = PermissibleValue(text="Pirfenidone")
    Marizomib = PermissibleValue(text="Marizomib")
    Fresolimumab = PermissibleValue(text="Fresolimumab")
    Thioguanine = PermissibleValue(text="Thioguanine")
    Archexin = PermissibleValue(text="Archexin")
    Raltitrexed = PermissibleValue(text="Raltitrexed")
    Misonidazole = PermissibleValue(text="Misonidazole")
    Prednimustine = PermissibleValue(text="Prednimustine")
    Mitoguazone = PermissibleValue(text="Mitoguazone")
    Fluoxymesterone = PermissibleValue(text="Fluoxymesterone")
    Metformin = PermissibleValue(text="Metformin")
    Imalumab = PermissibleValue(text="Imalumab")
    Elmustine = PermissibleValue(text="Elmustine")
    Duvortuxizumab = PermissibleValue(text="Duvortuxizumab")
    Aspacytarabine = PermissibleValue(text="Aspacytarabine")
    Aprutumab = PermissibleValue(text="Aprutumab")
    Ezabenlimab = PermissibleValue(text="Ezabenlimab")
    Iroplact = PermissibleValue(text="Iroplact")
    Navicixizumab = PermissibleValue(text="Navicixizumab")
    Vinfosiltine = PermissibleValue(text="Vinfosiltine")
    Phenesterin = PermissibleValue(text="Phenesterin")
    Tinostamustine = PermissibleValue(text="Tinostamustine")
    Zebularine = PermissibleValue(text="Zebularine")
    Selonsertib = PermissibleValue(text="Selonsertib")
    Erdafitinib = PermissibleValue(text="Erdafitinib")
    Mezagitamab = PermissibleValue(text="Mezagitamab")
    Pexidartinib = PermissibleValue(text="Pexidartinib")
    Orantinib = PermissibleValue(text="Orantinib")
    Ripretinib = PermissibleValue(text="Ripretinib")
    Axatilimab = PermissibleValue(text="Axatilimab")
    Imexon = PermissibleValue(text="Imexon")
    Zalutumumab = PermissibleValue(text="Zalutumumab")
    Dinaciclib = PermissibleValue(text="Dinaciclib")
    Enloplatin = PermissibleValue(text="Enloplatin")
    Alefacept = PermissibleValue(text="Alefacept")
    Tasquinimod = PermissibleValue(text="Tasquinimod")
    Etoglucid = PermissibleValue(text="Etoglucid")
    Tegavivint = PermissibleValue(text="Tegavivint")
    Numidargistat = PermissibleValue(text="Numidargistat")
    Amrubicin = PermissibleValue(text="Amrubicin")
    Nifurtimox = PermissibleValue(text="Nifurtimox")
    Letrozole = PermissibleValue(text="Letrozole")
    Durvalumab = PermissibleValue(text="Durvalumab")
    Rogletimide = PermissibleValue(text="Rogletimide")
    Pexmetinib = PermissibleValue(text="Pexmetinib")
    Fenebrutinib = PermissibleValue(text="Fenebrutinib")
    Ixabepilone = PermissibleValue(text="Ixabepilone")
    Enpromate = PermissibleValue(text="Enpromate")
    Barasertib = PermissibleValue(text="Barasertib")
    Picropodophyllin = PermissibleValue(text="Picropodophyllin")
    Tilogotamab = PermissibleValue(text="Tilogotamab")
    Degarelix = PermissibleValue(text="Degarelix")
    Fosbretabulin = PermissibleValue(text="Fosbretabulin")
    Aminopterin = PermissibleValue(text="Aminopterin")
    Methylprednisolone = PermissibleValue(text="Methylprednisolone")
    Lucitanib = PermissibleValue(text="Lucitanib")
    Prednisolone = PermissibleValue(text="Prednisolone")
    Axitinib = PermissibleValue(text="Axitinib")
    Nimodipine = PermissibleValue(text="Nimodipine")
    Plozalizumab = PermissibleValue(text="Plozalizumab")
    Demcizumab = PermissibleValue(text="Demcizumab")
    Carboquone = PermissibleValue(text="Carboquone")
    Buparlisib = PermissibleValue(text="Buparlisib")
    Fedratinib = PermissibleValue(text="Fedratinib")
    Efizonerimod = PermissibleValue(text="Efizonerimod")
    Galarubicin = PermissibleValue(text="Galarubicin")
    Erlotinib = PermissibleValue(text="Erlotinib")
    Combretastatin = PermissibleValue(text="Combretastatin")
    Chaparrinone = PermissibleValue(text="Chaparrinone")
    Valecobulin = PermissibleValue(text="Valecobulin")
    Ketoconazole = PermissibleValue(text="Ketoconazole")
    Roneparstat = PermissibleValue(text="Roneparstat")
    Diazooxonorleucine = PermissibleValue(text="Diazooxonorleucine")
    Vapreotide = PermissibleValue(text="Vapreotide")
    Tivantinib = PermissibleValue(text="Tivantinib")
    Vemurafenib = PermissibleValue(text="Vemurafenib")
    Vanucizumab = PermissibleValue(text="Vanucizumab")
    Perifosine = PermissibleValue(text="Perifosine")
    Bruceantin = PermissibleValue(text="Bruceantin")
    Epirubicin = PermissibleValue(text="Epirubicin")
    Oleandrin = PermissibleValue(text="Oleandrin")
    Macitentan = PermissibleValue(text="Macitentan")
    Spirogermanium = PermissibleValue(text="Spirogermanium")
    Cancell = PermissibleValue(text="Cancell")
    Apaziquone = PermissibleValue(text="Apaziquone")
    Sonepcizumab = PermissibleValue(text="Sonepcizumab")
    Ombrabulin = PermissibleValue(text="Ombrabulin")
    Cesalin = PermissibleValue(text="Cesalin")
    Imatinib = PermissibleValue(text="Imatinib")
    Oltipraz = PermissibleValue(text="Oltipraz")
    Unknown = PermissibleValue(text="Unknown")
    Methylcantharidimide = PermissibleValue(text="Methylcantharidimide")
    Trabectedin = PermissibleValue(text="Trabectedin")
    Scopoletin = PermissibleValue(text="Scopoletin")
    Lestaurtinib = PermissibleValue(text="Lestaurtinib")
    Fosquidone = PermissibleValue(text="Fosquidone")
    Thalicarpine = PermissibleValue(text="Thalicarpine")
    Tocotrienol = PermissibleValue(text="Tocotrienol")
    Ridaforolimus = PermissibleValue(text="Ridaforolimus")
    Dasatinib = PermissibleValue(text="Dasatinib")
    Dezapelisib = PermissibleValue(text="Dezapelisib")
    Suramin = PermissibleValue(text="Suramin")
    Vibostolimab = PermissibleValue(text="Vibostolimab")
    Ketotrexate = PermissibleValue(text="Ketotrexate")
    Sabarubicin = PermissibleValue(text="Sabarubicin")
    Rodorubicin = PermissibleValue(text="Rodorubicin")
    Pegzilarginase = PermissibleValue(text="Pegzilarginase")
    Everolimus = PermissibleValue(text="Everolimus")
    Ranpirnase = PermissibleValue(text="Ranpirnase")
    Repotrectinib = PermissibleValue(text="Repotrectinib")
    Vulinacimab = PermissibleValue(text="Vulinacimab")
    Mosunetuzumab = PermissibleValue(text="Mosunetuzumab")
    Dalotuzumab = PermissibleValue(text="Dalotuzumab")
    Enclomiphene = PermissibleValue(text="Enclomiphene")
    Sargramostim = PermissibleValue(text="Sargramostim")
    Talabostat = PermissibleValue(text="Talabostat")
    Cediranib = PermissibleValue(text="Cediranib")
    Luminespib = PermissibleValue(text="Luminespib")
    Cosibelimab = PermissibleValue(text="Cosibelimab")
    Bazedoxifene = PermissibleValue(text="Bazedoxifene")
    Triapine = PermissibleValue(text="Triapine")
    Marimastat = PermissibleValue(text="Marimastat")
    Digitoxin = PermissibleValue(text="Digitoxin")
    Cladribine = PermissibleValue(text="Cladribine")
    Vibecotamab = PermissibleValue(text="Vibecotamab")
    Thalidomide = PermissibleValue(text="Thalidomide")
    Roquinimex = PermissibleValue(text="Roquinimex")
    Ormaplatin = PermissibleValue(text="Ormaplatin")
    Emitefur = PermissibleValue(text="Emitefur")
    Edrecolomab = PermissibleValue(text="Edrecolomab")
    Navoximod = PermissibleValue(text="Navoximod")
    Telaglenastat = PermissibleValue(text="Telaglenastat")
    Floxuridine = PermissibleValue(text="Floxuridine")
    Vinflunine = PermissibleValue(text="Vinflunine")
    Oxeclosporin = PermissibleValue(text="Oxeclosporin")
    Mitazalimab = PermissibleValue(text="Mitazalimab")
    Relugolix = PermissibleValue(text="Relugolix")
    AEE788 = PermissibleValue(text="AEE788")
    Linifanib = PermissibleValue(text="Linifanib")
    Litronesib = PermissibleValue(text="Litronesib")
    Nilotinib = PermissibleValue(text="Nilotinib")
    Trimetrexate = PermissibleValue(text="Trimetrexate")
    Iadademstat = PermissibleValue(text="Iadademstat")
    Bermekimab = PermissibleValue(text="Bermekimab")
    Zanolimumab = PermissibleValue(text="Zanolimumab")
    Proxalutamide = PermissibleValue(text="Proxalutamide")
    Testolactone = PermissibleValue(text="Testolactone")
    Elpamotide = PermissibleValue(text="Elpamotide")
    Mapatumumab = PermissibleValue(text="Mapatumumab")
    Tandutinib = PermissibleValue(text="Tandutinib")
    Ripertamab = PermissibleValue(text="Ripertamab")
    Lenzilumab = PermissibleValue(text="Lenzilumab")
    Puquitinib = PermissibleValue(text="Puquitinib")
    Ixazomib = PermissibleValue(text="Ixazomib")
    Cabiralizumab = PermissibleValue(text="Cabiralizumab")
    Ocrelizumab = PermissibleValue(text="Ocrelizumab")
    Seribantumab = PermissibleValue(text="Seribantumab")
    Clofarabine = PermissibleValue(text="Clofarabine")
    Noscapine = PermissibleValue(text="Noscapine")
    Menatetrenone = PermissibleValue(text="Menatetrenone")
    Vantictumab = PermissibleValue(text="Vantictumab")
    Entinostat = PermissibleValue(text="Entinostat")
    Taurultam = PermissibleValue(text="Taurultam")
    Seclidemstat = PermissibleValue(text="Seclidemstat")
    Osilodrostat = PermissibleValue(text="Osilodrostat")
    Pegaspargase = PermissibleValue(text="Pegaspargase")
    Tanomastat = PermissibleValue(text="Tanomastat")
    Ropocamptide = PermissibleValue(text="Ropocamptide")
    Diphencyprone = PermissibleValue(text="Diphencyprone")
    Teroxirone = PermissibleValue(text="Teroxirone")
    Rezivertinib = PermissibleValue(text="Rezivertinib")
    Mafosfamide = PermissibleValue(text="Mafosfamide")
    Stallimycin = PermissibleValue(text="Stallimycin")
    Tazarotene = PermissibleValue(text="Tazarotene")
    Cyproterone = PermissibleValue(text="Cyproterone")
    Sevacizumab = PermissibleValue(text="Sevacizumab")
    Rivoceranib = PermissibleValue(text="Rivoceranib")
    Tolnidamine = PermissibleValue(text="Tolnidamine")
    Lifileucel = PermissibleValue(text="Lifileucel")
    Poliglusam = PermissibleValue(text="Poliglusam")
    Anakinra = PermissibleValue(text="Anakinra")
    Cytarabine = PermissibleValue(text="Cytarabine")
    Alisertib = PermissibleValue(text="Alisertib")
    Essiac = PermissibleValue(text="Essiac")
    Piritrexim = PermissibleValue(text="Piritrexim")
    Pibrozelesin = PermissibleValue(text="Pibrozelesin")
    Varlilumab = PermissibleValue(text="Varlilumab")
    Emibetuzumab = PermissibleValue(text="Emibetuzumab")
    Bromacrylide = PermissibleValue(text="Bromacrylide")
    Trapoxin = PermissibleValue(text="Trapoxin")
    Dianhydrogalactitol = PermissibleValue(text="Dianhydrogalactitol")
    Bleomycin = PermissibleValue(text="Bleomycin")
    Sorafenib = PermissibleValue(text="Sorafenib")
    Chlorotoxin = PermissibleValue(text="Chlorotoxin")
    Lifirafenib = PermissibleValue(text="Lifirafenib")
    Elagolix = PermissibleValue(text="Elagolix")
    Darolutamide = PermissibleValue(text="Darolutamide")
    Binimetinib = PermissibleValue(text="Binimetinib")
    Tocilizumab = PermissibleValue(text="Tocilizumab")
    Refametinib = PermissibleValue(text="Refametinib")
    Carbetimer = PermissibleValue(text="Carbetimer")
    Cinobufagin = PermissibleValue(text="Cinobufagin")
    Sibrotuzumab = PermissibleValue(text="Sibrotuzumab")
    Cytochlor = PermissibleValue(text="Cytochlor")
    Alobresib = PermissibleValue(text="Alobresib")
    Glufosfamide = PermissibleValue(text="Glufosfamide")
    Semuloparin = PermissibleValue(text="Semuloparin")
    Milatuzumab = PermissibleValue(text="Milatuzumab")
    Methotrexate = PermissibleValue(text="Methotrexate")
    Tegafur = PermissibleValue(text="Tegafur")
    Olmutinib = PermissibleValue(text="Olmutinib")
    Pidilizumab = PermissibleValue(text="Pidilizumab")
    Alpelisib = PermissibleValue(text="Alpelisib")
    Efatutazone = PermissibleValue(text="Efatutazone")
    Entrectinib = PermissibleValue(text="Entrectinib")
    Anhydrovinblastine = PermissibleValue(text="Anhydrovinblastine")
    Daromun = PermissibleValue(text="Daromun")
    Nidanilimab = PermissibleValue(text="Nidanilimab")
    Remetinostat = PermissibleValue(text="Remetinostat")
    Clanfenur = PermissibleValue(text="Clanfenur")
    Eribulin = PermissibleValue(text="Eribulin")
    Simeprevir = PermissibleValue(text="Simeprevir")
    Pipobroman = PermissibleValue(text="Pipobroman")
    Vorolanib = PermissibleValue(text="Vorolanib")
    Infigratinib = PermissibleValue(text="Infigratinib")
    Tirapazamine = PermissibleValue(text="Tirapazamine")
    PCNU = PermissibleValue(text="PCNU")
    Roflumilast = PermissibleValue(text="Roflumilast")
    Niraparib = PermissibleValue(text="Niraparib")
    Diindolylmethane = PermissibleValue(text="Diindolylmethane")
    Ifabotuzumab = PermissibleValue(text="Ifabotuzumab")
    Amivantamab = PermissibleValue(text="Amivantamab")
    Capmatinib = PermissibleValue(text="Capmatinib")
    Elotuzumab = PermissibleValue(text="Elotuzumab")
    Quinine = PermissibleValue(text="Quinine")
    Spongistatin = PermissibleValue(text="Spongistatin")
    Relatlimab = PermissibleValue(text="Relatlimab")
    Tapotoclax = PermissibleValue(text="Tapotoclax")
    Rituximab = PermissibleValue(text="Rituximab")
    Chloroquine = PermissibleValue(text="Chloroquine")
    Denosumab = PermissibleValue(text="Denosumab")
    Morpholinodoxorubicin = PermissibleValue(text="Morpholinodoxorubicin")
    Camsirubicin = PermissibleValue(text="Camsirubicin")
    Ametantrone = PermissibleValue(text="Ametantrone")
    Bendamustine = PermissibleValue(text="Bendamustine")
    Filgrastim = PermissibleValue(text="Filgrastim")
    Trametinib = PermissibleValue(text="Trametinib")
    Tidutamab = PermissibleValue(text="Tidutamab")
    Bempegaldesleukin = PermissibleValue(text="Bempegaldesleukin")
    Ethaselen = PermissibleValue(text="Ethaselen")
    Itraconazole = PermissibleValue(text="Itraconazole")
    Doxercalciferol = PermissibleValue(text="Doxercalciferol")
    Peldesine = PermissibleValue(text="Peldesine")
    Cemiplimab = PermissibleValue(text="Cemiplimab")
    Xanthohumol = PermissibleValue(text="Xanthohumol")
    Afuresertib = PermissibleValue(text="Afuresertib")
    Thymopentin = PermissibleValue(text="Thymopentin")
    Pibenzimol = PermissibleValue(text="Pibenzimol")
    Pimitespib = PermissibleValue(text="Pimitespib")
    Tasadenoturev = PermissibleValue(text="Tasadenoturev")
    Telisotuzumab = PermissibleValue(text="Telisotuzumab")
    Niacinamide = PermissibleValue(text="Niacinamide")
    Dostarlimab = PermissibleValue(text="Dostarlimab")
    Dexamethasone = PermissibleValue(text="Dexamethasone")
    Imiquimod = PermissibleValue(text="Imiquimod")
    Fursultiamine = PermissibleValue(text="Fursultiamine")
    Lurbinectedin = PermissibleValue(text="Lurbinectedin")
    Istiratumab = PermissibleValue(text="Istiratumab")
    Hydroxychloroquine = PermissibleValue(text="Hydroxychloroquine")
    Nagrestipen = PermissibleValue(text="Nagrestipen")
    Ecromeximab = PermissibleValue(text="Ecromeximab")
    Dupilumab = PermissibleValue(text="Dupilumab")
    Narnatumab = PermissibleValue(text="Narnatumab")
    Genistein = PermissibleValue(text="Genistein")
    Belimumab = PermissibleValue(text="Belimumab")
    Larotaxel = PermissibleValue(text="Larotaxel")
    Carbogen = PermissibleValue(text="Carbogen")
    Ficlatuzumab = PermissibleValue(text="Ficlatuzumab")
    Mavelertinib = PermissibleValue(text="Mavelertinib")
    Fotemustine = PermissibleValue(text="Fotemustine")
    Cannabidiol = PermissibleValue(text="Cannabidiol")
    Edicotinib = PermissibleValue(text="Edicotinib")
    Cusatuzumab = PermissibleValue(text="Cusatuzumab")
    Etalocib = PermissibleValue(text="Etalocib")
    Margetuximab = PermissibleValue(text="Margetuximab")
    Obinutuzumab = PermissibleValue(text="Obinutuzumab")
    Vinepidine = PermissibleValue(text="Vinepidine")
    Benaxibine = PermissibleValue(text="Benaxibine")
    Daporinad = PermissibleValue(text="Daporinad")
    Licorice = PermissibleValue(text="Licorice")
    Mitozolomide = PermissibleValue(text="Mitozolomide")
    Merbarone = PermissibleValue(text="Merbarone")
    Mavorixafor = PermissibleValue(text="Mavorixafor")
    Seocalcitol = PermissibleValue(text="Seocalcitol")
    Icrucumab = PermissibleValue(text="Icrucumab")
    Ceralasertib = PermissibleValue(text="Ceralasertib")
    Lucanthone = PermissibleValue(text="Lucanthone")
    Fianlimab = PermissibleValue(text="Fianlimab")
    Intoplicine = PermissibleValue(text="Intoplicine")
    Bersanlimab = PermissibleValue(text="Bersanlimab")
    Galiximab = PermissibleValue(text="Galiximab")
    Merestinib = PermissibleValue(text="Merestinib")
    Tomaralimab = PermissibleValue(text="Tomaralimab")
    Verapamil = PermissibleValue(text="Verapamil")
    Belapectin = PermissibleValue(text="Belapectin")
    HuaChanSu = PermissibleValue(text="HuaChanSu")
    Conbercept = PermissibleValue(text="Conbercept")
    Gatipotuzumab = PermissibleValue(text="Gatipotuzumab")
    Cisplatin = PermissibleValue(text="Cisplatin")
    Satraplatin = PermissibleValue(text="Satraplatin")
    Miransertib = PermissibleValue(text="Miransertib")
    Metamelfalan = PermissibleValue(text="Metamelfalan")
    Apomab = PermissibleValue(text="Apomab")
    Ipafricept = PermissibleValue(text="Ipafricept")
    Tucatinib = PermissibleValue(text="Tucatinib")
    Lometrexol = PermissibleValue(text="Lometrexol")
    Mitoflaxone = PermissibleValue(text="Mitoflaxone")
    Febuxostat = PermissibleValue(text="Febuxostat")
    Edatrexate = PermissibleValue(text="Edatrexate")
    Ethylnitrosourea = PermissibleValue(text="Ethylnitrosourea")
    Laetrile = PermissibleValue(text="Laetrile")
    Pirotinib = PermissibleValue(text="Pirotinib")
    Linsitinib = PermissibleValue(text="Linsitinib")
    Ifosfamide = PermissibleValue(text="Ifosfamide")
    Futuximab = PermissibleValue(text="Futuximab")
    Panulisib = PermissibleValue(text="Panulisib")
    Milataxel = PermissibleValue(text="Milataxel")
    Midostaurin = PermissibleValue(text="Midostaurin")
    Bavituximab = PermissibleValue(text="Bavituximab")
    Citarinostat = PermissibleValue(text="Citarinostat")
    Emapalumab = PermissibleValue(text="Emapalumab")
    Taurolidine = PermissibleValue(text="Taurolidine")
    Dacplatinum = PermissibleValue(text="Dacplatinum")
    Voxtalisib = PermissibleValue(text="Voxtalisib")
    Vilaprisan = PermissibleValue(text="Vilaprisan")
    Dactinomycin = PermissibleValue(text="Dactinomycin")
    Exisulind = PermissibleValue(text="Exisulind")
    Pixatimod = PermissibleValue(text="Pixatimod")
    Tabalumab = PermissibleValue(text="Tabalumab")
    Incyclinide = PermissibleValue(text="Incyclinide")
    Tebentafusp = PermissibleValue(text="Tebentafusp")
    Ivaltinostat = PermissibleValue(text="Ivaltinostat")
    Zelavespib = PermissibleValue(text="Zelavespib")
    Farletuzumab = PermissibleValue(text="Farletuzumab")
    Pyrazinamide = PermissibleValue(text="Pyrazinamide")
    Intetumumab = PermissibleValue(text="Intetumumab")
    Aclarubicin = PermissibleValue(text="Aclarubicin")
    Topotecan = PermissibleValue(text="Topotecan")
    Empesertib = PermissibleValue(text="Empesertib")
    Ranimustine = PermissibleValue(text="Ranimustine")
    Brontictuzumab = PermissibleValue(text="Brontictuzumab")
    Tomivosertib = PermissibleValue(text="Tomivosertib")
    Bomedemstat = PermissibleValue(text="Bomedemstat")
    Utomilumab = PermissibleValue(text="Utomilumab")
    Tarenflurbil = PermissibleValue(text="Tarenflurbil")
    Neratinib = PermissibleValue(text="Neratinib")
    Pseudoisocytidine = PermissibleValue(text="Pseudoisocytidine")
    Ozarelix = PermissibleValue(text="Ozarelix")
    Patidegib = PermissibleValue(text="Patidegib")
    Patritumab = PermissibleValue(text="Patritumab")
    Sugemalimab = PermissibleValue(text="Sugemalimab")
    Pelitinib = PermissibleValue(text="Pelitinib")
    Lexatumumab = PermissibleValue(text="Lexatumumab")
    Blinatumomab = PermissibleValue(text="Blinatumomab")
    Ladirubicin = PermissibleValue(text="Ladirubicin")
    Bimiralisib = PermissibleValue(text="Bimiralisib")
    Sardomozide = PermissibleValue(text="Sardomozide")
    Carboxyamidotriazole = PermissibleValue(text="Carboxyamidotriazole")
    Thioinosine = PermissibleValue(text="Thioinosine")
    Timonacic = PermissibleValue(text="Timonacic")
    Alemtuzumab = PermissibleValue(text="Alemtuzumab")
    Detorubicin = PermissibleValue(text="Detorubicin")
    Alestramustine = PermissibleValue(text="Alestramustine")
    Leflunomide = PermissibleValue(text="Leflunomide")
    Busulfan = PermissibleValue(text="Busulfan")
    Azacitidine = PermissibleValue(text="Azacitidine")
    Enobosarm = PermissibleValue(text="Enobosarm")
    Fosaprepitant = PermissibleValue(text="Fosaprepitant")
    Edotecarin = PermissibleValue(text="Edotecarin")
    Talmapimod = PermissibleValue(text="Talmapimod")
    Taletrectinib = PermissibleValue(text="Taletrectinib")
    Entolimod = PermissibleValue(text="Entolimod")
    Mivavotinib = PermissibleValue(text="Mivavotinib")
    Ethyleneimine = PermissibleValue(text="Ethyleneimine")
    Artesunate = PermissibleValue(text="Artesunate")
    Ortataxel = PermissibleValue(text="Ortataxel")
    Indisulam = PermissibleValue(text="Indisulam")
    Mitomycin = PermissibleValue(text="Mitomycin")
    Miltefosine = PermissibleValue(text="Miltefosine")
    Namodenoson = PermissibleValue(text="Namodenoson")
    Olaparib = PermissibleValue(text="Olaparib")
    Taselisib = PermissibleValue(text="Taselisib")
    Polidocanol = PermissibleValue(text="Polidocanol")
    Danusertib = PermissibleValue(text="Danusertib")
    KRN5500 = PermissibleValue(text="KRN5500")
    Sasanlimab = PermissibleValue(text="Sasanlimab")
    Nirogacestat = PermissibleValue(text="Nirogacestat")
    Pralsetinib = PermissibleValue(text="Pralsetinib")
    Ibrutinib = PermissibleValue(text="Ibrutinib")
    Cyclodisone = PermissibleValue(text="Cyclodisone")
    Patupilone = PermissibleValue(text="Patupilone")
    Fibromun = PermissibleValue(text="Fibromun")
    Lisavanbulin = PermissibleValue(text="Lisavanbulin")
    Mifamurtide = PermissibleValue(text="Mifamurtide")
    Olivomycin = PermissibleValue(text="Olivomycin")
    Mercaptopurine = PermissibleValue(text="Mercaptopurine")
    Talotrexin = PermissibleValue(text="Talotrexin")
    Trabedersen = PermissibleValue(text="Trabedersen")
    Mitotane = PermissibleValue(text="Mitotane")
    Guselkumab = PermissibleValue(text="Guselkumab")
    Samotolisib = PermissibleValue(text="Samotolisib")
    Penclomedine = PermissibleValue(text="Penclomedine")
    Altretamine = PermissibleValue(text="Altretamine")
    Teniposide = PermissibleValue(text="Teniposide")
    Ionomycin = PermissibleValue(text="Ionomycin")
    Vopratelimab = PermissibleValue(text="Vopratelimab")
    Rofecoxib = PermissibleValue(text="Rofecoxib")
    Streptozocin = PermissibleValue(text="Streptozocin")
    Bisantrene = PermissibleValue(text="Bisantrene")
    Cycloleucine = PermissibleValue(text="Cycloleucine")
    Simurosertib = PermissibleValue(text="Simurosertib")
    Hypericin = PermissibleValue(text="Hypericin")
    Alectinib = PermissibleValue(text="Alectinib")
    Famitinib = PermissibleValue(text="Famitinib")
    Simtuzumab = PermissibleValue(text="Simtuzumab")
    Duvelisib = PermissibleValue(text="Duvelisib")
    Dihydrolenperone = PermissibleValue(text="Dihydrolenperone")
    Exemestane = PermissibleValue(text="Exemestane")
    Opucolimab = PermissibleValue(text="Opucolimab")
    Lintuzumab = PermissibleValue(text="Lintuzumab")
    Necitumumab = PermissibleValue(text="Necitumumab")
    Ganetespib = PermissibleValue(text="Ganetespib")
    Fulvestrant = PermissibleValue(text="Fulvestrant")
    Ambamustine = PermissibleValue(text="Ambamustine")
    Figitumumab = PermissibleValue(text="Figitumumab")
    Vistusertib = PermissibleValue(text="Vistusertib")
    Acalisib = PermissibleValue(text="Acalisib")
    Pralatrexate = PermissibleValue(text="Pralatrexate")
    Dinutuximab = PermissibleValue(text="Dinutuximab")
    Muparfostat = PermissibleValue(text="Muparfostat")
    Pevonedistat = PermissibleValue(text="Pevonedistat")
    Avdoralimab = PermissibleValue(text="Avdoralimab")
    Tositumomab = PermissibleValue(text="Tositumomab")
    Dacomitinib = PermissibleValue(text="Dacomitinib")
    Duborimycin = PermissibleValue(text="Duborimycin")
    Tilarginine = PermissibleValue(text="Tilarginine")
    Banoxantrone = PermissibleValue(text="Banoxantrone")
    Zanubrutinib = PermissibleValue(text="Zanubrutinib")
    Pembrolizumab = PermissibleValue(text="Pembrolizumab")
    Alkotinib = PermissibleValue(text="Alkotinib")
    Spiromustine = PermissibleValue(text="Spiromustine")
    Sergiolide = PermissibleValue(text="Sergiolide")
    Umbralisib = PermissibleValue(text="Umbralisib")
    Glucarpidase = PermissibleValue(text="Glucarpidase")
    Cabozantinib = PermissibleValue(text="Cabozantinib")
    Cevipabulin = PermissibleValue(text="Cevipabulin")
    Ponatinib = PermissibleValue(text="Ponatinib")
    Penberol = PermissibleValue(text="Penberol")
    Etanercept = PermissibleValue(text="Etanercept")
    Medorubicin = PermissibleValue(text="Medorubicin")
    Bizelesin = PermissibleValue(text="Bizelesin")
    Taladegib = PermissibleValue(text="Taladegib")
    Apolizumab = PermissibleValue(text="Apolizumab")
    Plamotamab = PermissibleValue(text="Plamotamab")
    Aviscumine = PermissibleValue(text="Aviscumine")
    Fostriecin = PermissibleValue(text="Fostriecin")
    Tavolimab = PermissibleValue(text="Tavolimab")
    Detirelix = PermissibleValue(text="Detirelix")
    Motixafortide = PermissibleValue(text="Motixafortide")
    Tasidotin = PermissibleValue(text="Tasidotin")
    Brigatinib = PermissibleValue(text="Brigatinib")
    Leurubicin = PermissibleValue(text="Leurubicin")
    Glaucarubolone = PermissibleValue(text="Glaucarubolone")
    Docetaxel = PermissibleValue(text="Docetaxel")
    Piroxantrone = PermissibleValue(text="Piroxantrone")
    Linrodostat = PermissibleValue(text="Linrodostat")
    Epipropidine = PermissibleValue(text="Epipropidine")
    Prednisone = PermissibleValue(text="Prednisone")
    Erbulozole = PermissibleValue(text="Erbulozole")
    Trodusquemine = PermissibleValue(text="Trodusquemine")
    Ublituximab = PermissibleValue(text="Ublituximab")
    Lorlatinib = PermissibleValue(text="Lorlatinib")
    Plitidepsin = PermissibleValue(text="Plitidepsin")
    Methylselenocysteine = PermissibleValue(text="Methylselenocysteine")
    Retifanlimab = PermissibleValue(text="Retifanlimab")
    Pertuzumab = PermissibleValue(text="Pertuzumab")
    Pemetrexed = PermissibleValue(text="Pemetrexed")
    Sotorasib = PermissibleValue(text="Sotorasib")
    Pomalidomide = PermissibleValue(text="Pomalidomide")
    Placebo = PermissibleValue(text="Placebo")
    Cenersen = PermissibleValue(text="Cenersen")
    Spanlecortemlocel = PermissibleValue(text="Spanlecortemlocel")
    Maytansine = PermissibleValue(text="Maytansine")
    Dynemicin = PermissibleValue(text="Dynemicin")
    Mofarotene = PermissibleValue(text="Mofarotene")
    Hydroxyurea = PermissibleValue(text="Hydroxyurea")
    Canfosfamide = PermissibleValue(text="Canfosfamide")
    Tesevatinib = PermissibleValue(text="Tesevatinib")
    Dicycloplatin = PermissibleValue(text="Dicycloplatin")
    Lodapolimab = PermissibleValue(text="Lodapolimab")
    Seviteronel = PermissibleValue(text="Seviteronel")
    Bisnafide = PermissibleValue(text="Bisnafide")
    Benzoylphenylurea = PermissibleValue(text="Benzoylphenylurea")
    Bemarituzumab = PermissibleValue(text="Bemarituzumab")
    Ilorasertib = PermissibleValue(text="Ilorasertib")
    Other = PermissibleValue(text="Other")
    Girentuximab = PermissibleValue(text="Girentuximab")
    Halofuginone = PermissibleValue(text="Halofuginone")
    Liarozole = PermissibleValue(text="Liarozole")
    Idelalisib = PermissibleValue(text="Idelalisib")
    Elacestrant = PermissibleValue(text="Elacestrant")
    Demecolcine = PermissibleValue(text="Demecolcine")
    Acridine = PermissibleValue(text="Acridine")
    Picibanil = PermissibleValue(text="Picibanil")
    Avelumab = PermissibleValue(text="Avelumab")
    Carmustine = PermissibleValue(text="Carmustine")
    Mipsagargin = PermissibleValue(text="Mipsagargin")
    Pentostatin = PermissibleValue(text="Pentostatin")
    Licartin = PermissibleValue(text="Licartin")
    Redaporfin = PermissibleValue(text="Redaporfin")
    Zalifrelimab = PermissibleValue(text="Zalifrelimab")
    Zandelisib = PermissibleValue(text="Zandelisib")
    Cimetidine = PermissibleValue(text="Cimetidine")
    Pirarubicin = PermissibleValue(text="Pirarubicin")
    Romidepsin = PermissibleValue(text="Romidepsin")
    Ancitabine = PermissibleValue(text="Ancitabine")
    Siplizumab = PermissibleValue(text="Siplizumab")
    Nazartinib = PermissibleValue(text="Nazartinib")
    Laniquidar = PermissibleValue(text="Laniquidar")
    Crenolanib = PermissibleValue(text="Crenolanib")
    Ruxotemitide = PermissibleValue(text="Ruxotemitide")
    Pelabresib = PermissibleValue(text="Pelabresib")
    Laromustine = PermissibleValue(text="Laromustine")
    Mivobulin = PermissibleValue(text="Mivobulin")
    Cordycepin = PermissibleValue(text="Cordycepin")
    Infliximab = PermissibleValue(text="Infliximab")
    Onvatilimab = PermissibleValue(text="Onvatilimab")
    Veltuzumab = PermissibleValue(text="Veltuzumab")
    Inproquone = PermissibleValue(text="Inproquone")
    Dexrazoxane = PermissibleValue(text="Dexrazoxane")
    Lovastatin = PermissibleValue(text="Lovastatin")
    Zibotentan = PermissibleValue(text="Zibotentan")
    Ulinastatin = PermissibleValue(text="Ulinastatin")
    Ciforadenant = PermissibleValue(text="Ciforadenant")
    Acitretin = PermissibleValue(text="Acitretin")
    Otlertuzumab = PermissibleValue(text="Otlertuzumab")
    Tazemetostat = PermissibleValue(text="Tazemetostat")
    Ianalumab = PermissibleValue(text="Ianalumab")
    Dalantercept = PermissibleValue(text="Dalantercept")
    Dovitinib = PermissibleValue(text="Dovitinib")
    Cobomarsen = PermissibleValue(text="Cobomarsen")
    Prexigebersen = PermissibleValue(text="Prexigebersen")
    Kanglaite = PermissibleValue(text="Kanglaite")
    Nintedanib = PermissibleValue(text="Nintedanib")
    Cryptophycin = PermissibleValue(text="Cryptophycin")
    Quarfloxin = PermissibleValue(text="Quarfloxin")
    Alofanib = PermissibleValue(text="Alofanib")
    Ramucirumab = PermissibleValue(text="Ramucirumab")
    Tesetaxel = PermissibleValue(text="Tesetaxel")
    Capivasertib = PermissibleValue(text="Capivasertib")
    Rosopatamab = PermissibleValue(text="Rosopatamab")
    Carmofur = PermissibleValue(text="Carmofur")
    Letolizumab = PermissibleValue(text="Letolizumab")
    Pegfilgrastim = PermissibleValue(text="Pegfilgrastim")
    Glumetinib = PermissibleValue(text="Glumetinib")
    Medroxyprogesterone = PermissibleValue(text="Medroxyprogesterone")
    Hexylresorcinol = PermissibleValue(text="Hexylresorcinol")
    Lilotomab = PermissibleValue(text="Lilotomab")
    Brostallicin = PermissibleValue(text="Brostallicin")
    Paxalisib = PermissibleValue(text="Paxalisib")
    Tipifarnib = PermissibleValue(text="Tipifarnib")
    Vecabrutinib = PermissibleValue(text="Vecabrutinib")
    Fenretinide = PermissibleValue(text="Fenretinide")
    Fotretamine = PermissibleValue(text="Fotretamine")
    Tigatuzumab = PermissibleValue(text="Tigatuzumab")
    Abarelix = PermissibleValue(text="Abarelix")
    Volasertib = PermissibleValue(text="Volasertib")
    Drozitumab = PermissibleValue(text="Drozitumab")
    Leucovorin = PermissibleValue(text="Leucovorin")
    Temozolomide = PermissibleValue(text="Temozolomide")
    Pictilisib = PermissibleValue(text="Pictilisib")
    Polyandrol = PermissibleValue(text="Polyandrol")
    Vorinostat = PermissibleValue(text="Vorinostat")
    Elliptinium = PermissibleValue(text="Elliptinium")
    Brilanestrant = PermissibleValue(text="Brilanestrant")
    Etoposide = PermissibleValue(text="Etoposide")
    Evofosfamide = PermissibleValue(text="Evofosfamide")
    Azathioprine = PermissibleValue(text="Azathioprine")
    Tirabrutinib = PermissibleValue(text="Tirabrutinib")
    Irosustat = PermissibleValue(text="Irosustat")
    Ropidoxuridine = PermissibleValue(text="Ropidoxuridine")
    Amustaline = PermissibleValue(text="Amustaline")
    Xiliertinib = PermissibleValue(text="Xiliertinib")
    Mitolactol = PermissibleValue(text="Mitolactol")
    Ispinesib = PermissibleValue(text="Ispinesib")
    Uzansertib = PermissibleValue(text="Uzansertib")
    Pemigatinib = PermissibleValue(text="Pemigatinib")
    Norgestrel = PermissibleValue(text="Norgestrel")
    Pyrotinib = PermissibleValue(text="Pyrotinib")
    Cobimetinib = PermissibleValue(text="Cobimetinib")
    Pipendoxifene = PermissibleValue(text="Pipendoxifene")
    Riviciclib = PermissibleValue(text="Riviciclib")
    Landogrozumab = PermissibleValue(text="Landogrozumab")
    Upifitamab = PermissibleValue(text="Upifitamab")
    Camptothecin = PermissibleValue(text="Camptothecin")
    Brivudine = PermissibleValue(text="Brivudine")
    Nanafrocin = PermissibleValue(text="Nanafrocin")
    Foretinib = PermissibleValue(text="Foretinib")
    Chlorodihydropyrimidine = PermissibleValue(text="Chlorodihydropyrimidine")
    Pamrevlumab = PermissibleValue(text="Pamrevlumab")
    Navitoclax = PermissibleValue(text="Navitoclax")
    Terameprocol = PermissibleValue(text="Terameprocol")
    Rebeccamycin = PermissibleValue(text="Rebeccamycin")
    Tiazofurin = PermissibleValue(text="Tiazofurin")
    Etoricoxib = PermissibleValue(text="Etoricoxib")
    Mannosulfan = PermissibleValue(text="Mannosulfan")
    Apricoxib = PermissibleValue(text="Apricoxib")
    Cemadotin = PermissibleValue(text="Cemadotin")
    Methoxyamine = PermissibleValue(text="Methoxyamine")
    Arfolitixorin = PermissibleValue(text="Arfolitixorin")
    Iboctadekin = PermissibleValue(text="Iboctadekin")
    Lentinan = PermissibleValue(text="Lentinan")
    Cactinomycin = PermissibleValue(text="Cactinomycin")
    Simmitinib = PermissibleValue(text="Simmitinib")
    Abiraterone = PermissibleValue(text="Abiraterone")
    Robatumumab = PermissibleValue(text="Robatumumab")
    Piposulfan = PermissibleValue(text="Piposulfan")
    Ulixertinib = PermissibleValue(text="Ulixertinib")
    Quisinostat = PermissibleValue(text="Quisinostat")
    Sulforaphane = PermissibleValue(text="Sulforaphane")
    Sapacitabine = PermissibleValue(text="Sapacitabine")
    Tributyrin = PermissibleValue(text="Tributyrin")
    Roducitabine = PermissibleValue(text="Roducitabine")
    Alvocidib = PermissibleValue(text="Alvocidib")
    Aprinocarsen = PermissibleValue(text="Aprinocarsen")
    Pacmilimab = PermissibleValue(text="Pacmilimab")
    Rogaratinib = PermissibleValue(text="Rogaratinib")
    Selicrelumab = PermissibleValue(text="Selicrelumab")
    Urabrelimab = PermissibleValue(text="Urabrelimab")
    Cobolimab = PermissibleValue(text="Cobolimab")
    Semaxanib = PermissibleValue(text="Semaxanib")
    Selitrectinib = PermissibleValue(text="Selitrectinib")
    Sabatolimab = PermissibleValue(text="Sabatolimab")
    Sintilimab = PermissibleValue(text="Sintilimab")
    Simotaxel = PermissibleValue(text="Simotaxel")
    Xevinapant = PermissibleValue(text="Xevinapant")
    Vintafolide = PermissibleValue(text="Vintafolide")
    Afimoxifene = PermissibleValue(text="Afimoxifene")
    Bactobolin = PermissibleValue(text="Bactobolin")
    Diazepinomicin = PermissibleValue(text="Diazepinomicin")
    Varlitinib = PermissibleValue(text="Varlitinib")
    Epacadostat = PermissibleValue(text="Epacadostat")
    Clioquinol = PermissibleValue(text="Clioquinol")
    Doxazosin = PermissibleValue(text="Doxazosin")
    Vinzolidine = PermissibleValue(text="Vinzolidine")
    Idasanutlin = PermissibleValue(text="Idasanutlin")
    Garlic = PermissibleValue(text="Garlic")
    Taltobulin = PermissibleValue(text="Taltobulin")
    Teclistamab = PermissibleValue(text="Teclistamab")
    Glofitamab = PermissibleValue(text="Glofitamab")
    Denibulin = PermissibleValue(text="Denibulin")
    Fisogatinib = PermissibleValue(text="Fisogatinib")
    Gutolactone = PermissibleValue(text="Gutolactone")
    Samuraciclib = PermissibleValue(text="Samuraciclib")
    Monalizumab = PermissibleValue(text="Monalizumab")
    Agerafenib = PermissibleValue(text="Agerafenib")
    Mirabegron = PermissibleValue(text="Mirabegron")
    Padeliporfin = PermissibleValue(text="Padeliporfin")
    Bexarotene = PermissibleValue(text="Bexarotene")
    Belzutifan = PermissibleValue(text="Belzutifan")
    Tariquidar = PermissibleValue(text="Tariquidar")
    Nanatinostat = PermissibleValue(text="Nanatinostat")
    Pacritinib = PermissibleValue(text="Pacritinib")
    Doxorubicin = PermissibleValue(text="Doxorubicin")
    Ruxolitinib = PermissibleValue(text="Ruxolitinib")
    Razoxane = PermissibleValue(text="Razoxane")
    Elinafide = PermissibleValue(text="Elinafide")
    Ontuxizumab = PermissibleValue(text="Ontuxizumab")
    Pazopanib = PermissibleValue(text="Pazopanib")
    Mobocertinib = PermissibleValue(text="Mobocertinib")
    Triethylenemelamine = PermissibleValue(text="Triethylenemelamine")
    Uprosertib = PermissibleValue(text="Uprosertib")
    Ritrosulfan = PermissibleValue(text="Ritrosulfan")
    Capecitabine = PermissibleValue(text="Capecitabine")
    Captopril = PermissibleValue(text="Captopril")
    Dactolisib = PermissibleValue(text="Dactolisib")
    Adavosertib = PermissibleValue(text="Adavosertib")
    Tallimustine = PermissibleValue(text="Tallimustine")
    Paricalcitol = PermissibleValue(text="Paricalcitol")
    Siltuximab = PermissibleValue(text="Siltuximab")
    Giredestrant = PermissibleValue(text="Giredestrant")
    Reparixin = PermissibleValue(text="Reparixin")
    Hycanthone = PermissibleValue(text="Hycanthone")
    Eltanexor = PermissibleValue(text="Eltanexor")
    Zanidatamab = PermissibleValue(text="Zanidatamab")
    Tanespimycin = PermissibleValue(text="Tanespimycin")
    Tosedostat = PermissibleValue(text="Tosedostat")
    Tremelimumab = PermissibleValue(text="Tremelimumab")
    Deferoxamine = PermissibleValue(text="Deferoxamine")
    Tarextumab = PermissibleValue(text="Tarextumab")
    Bardoxolone = PermissibleValue(text="Bardoxolone")
    Tepoditamab = PermissibleValue(text="Tepoditamab")
    Giloralimab = PermissibleValue(text="Giloralimab")
    Sobuzoxane = PermissibleValue(text="Sobuzoxane")
    Menogaril = PermissibleValue(text="Menogaril")
    Enzalutamide = PermissibleValue(text="Enzalutamide")
    Cerdulatinib = PermissibleValue(text="Cerdulatinib")
    Motolimod = PermissibleValue(text="Motolimod")
    Tesidolumab = PermissibleValue(text="Tesidolumab")
    Ubenimex = PermissibleValue(text="Ubenimex")
    Siremadlin = PermissibleValue(text="Siremadlin")
    Ricolinostat = PermissibleValue(text="Ricolinostat")
    Isotretinoin = PermissibleValue(text="Isotretinoin")
    Poziotinib = PermissibleValue(text="Poziotinib")
    Nelarabine = PermissibleValue(text="Nelarabine")
    Paclitaxel = PermissibleValue(text="Paclitaxel")
    Triptorelin = PermissibleValue(text="Triptorelin")
    Tauromustine = PermissibleValue(text="Tauromustine")
    Brentuximab = PermissibleValue(text="Brentuximab")
    Lerociclib = PermissibleValue(text="Lerociclib")
    Galunisertib = PermissibleValue(text="Galunisertib")
    Sivifene = PermissibleValue(text="Sivifene")
    Theramide = PermissibleValue(text="Theramide")
    Lobaplatin = PermissibleValue(text="Lobaplatin")
    Filanesib = PermissibleValue(text="Filanesib")
    Peretinoin = PermissibleValue(text="Peretinoin")
    Tertomotide = PermissibleValue(text="Tertomotide")
    Acivicin = PermissibleValue(text="Acivicin")
    Trioxifene = PermissibleValue(text="Trioxifene")
    Apatorsen = PermissibleValue(text="Apatorsen")
    Resiquimod = PermissibleValue(text="Resiquimod")
    T900607 = PermissibleValue(text="T900607")
    Retelliptine = PermissibleValue(text="Retelliptine")
    Tefinostat = PermissibleValue(text="Tefinostat")
    Epratuzumab = PermissibleValue(text="Epratuzumab")
    Pimurutamab = PermissibleValue(text="Pimurutamab")
    Ipomeanol = PermissibleValue(text="Ipomeanol")
    Amifostine = PermissibleValue(text="Amifostine")
    Oraxol = PermissibleValue(text="Oraxol")
    Alvespimycin = PermissibleValue(text="Alvespimycin")
    Codrituzumab = PermissibleValue(text="Codrituzumab")
    Aderbasib = PermissibleValue(text="Aderbasib")
    Sapanisertib = PermissibleValue(text="Sapanisertib")
    Peposertib = PermissibleValue(text="Peposertib")
    Azaribine = PermissibleValue(text="Azaribine")
    Tivozanib = PermissibleValue(text="Tivozanib")
    Gandotinib = PermissibleValue(text="Gandotinib")
    Auranofin = PermissibleValue(text="Auranofin")
    Afatinib = PermissibleValue(text="Afatinib")
    Girodazole = PermissibleValue(text="Girodazole")
    Ensituximab = PermissibleValue(text="Ensituximab")
    Pegvisomant = PermissibleValue(text="Pegvisomant")
    Emactuzumab = PermissibleValue(text="Emactuzumab")
    Lirilumab = PermissibleValue(text="Lirilumab")
    Ascrinvacumab = PermissibleValue(text="Ascrinvacumab")
    Pimasertib = PermissibleValue(text="Pimasertib")
    Quizartinib = PermissibleValue(text="Quizartinib")
    Sirolimus = PermissibleValue(text="Sirolimus")
    MK0731 = PermissibleValue(text="MK0731")
    Teloxantrone = PermissibleValue(text="Teloxantrone")
    Brivanib = PermissibleValue(text="Brivanib")
    Resminostat = PermissibleValue(text="Resminostat")
    Palifosfamide = PermissibleValue(text="Palifosfamide")
    Mifepristone = PermissibleValue(text="Mifepristone")
    Dexamethason = PermissibleValue(text="Dexamethason")
    Resveratrol = PermissibleValue(text="Resveratrol")
    Alanosine = PermissibleValue(text="Alanosine")
    Motesanib = PermissibleValue(text="Motesanib")
    Lonafarnib = PermissibleValue(text="Lonafarnib")
    Tenalisib = PermissibleValue(text="Tenalisib")
    Sagopilone = PermissibleValue(text="Sagopilone")
    Diaziquone = PermissibleValue(text="Diaziquone")
    Asunercept = PermissibleValue(text="Asunercept")
    Berzosertib = PermissibleValue(text="Berzosertib")
    Exicorilant = PermissibleValue(text="Exicorilant")
    Azaserine = PermissibleValue(text="Azaserine")
    Niclosamide = PermissibleValue(text="Niclosamide")
    Fludarabine = PermissibleValue(text="Fludarabine")
    Chaparrin = PermissibleValue(text="Chaparrin")
    Tirbanibulin = PermissibleValue(text="Tirbanibulin")
    Enadenotucirev = PermissibleValue(text="Enadenotucirev")
    Feladilimab = PermissibleValue(text="Feladilimab")
    Canerpaturev = PermissibleValue(text="Canerpaturev")
    Procarbazine = PermissibleValue(text="Procarbazine")
    Denenicokin = PermissibleValue(text="Denenicokin")
    Adecatumumab = PermissibleValue(text="Adecatumumab")
    Buserelin = PermissibleValue(text="Buserelin")
    Tacedinaline = PermissibleValue(text="Tacedinaline")
    Carboplatin = PermissibleValue(text="Carboplatin")
    Iberdomide = PermissibleValue(text="Iberdomide")
    Panitumumab = PermissibleValue(text="Panitumumab")
    Ranibizumab = PermissibleValue(text="Ranibizumab")
    Iloprost = PermissibleValue(text="Iloprost")
    Daniquidone = PermissibleValue(text="Daniquidone")
    Dabrafenib = PermissibleValue(text="Dabrafenib")
    Pracinostat = PermissibleValue(text="Pracinostat")
    Xentuzumab = PermissibleValue(text="Xentuzumab")
    Flumatinib = PermissibleValue(text="Flumatinib")
    EGb761 = PermissibleValue(text="EGb761")
    Abexinostat = PermissibleValue(text="Abexinostat")
    Almurtide = PermissibleValue(text="Almurtide")
    Naquotinib = PermissibleValue(text="Naquotinib")
    Foslinanib = PermissibleValue(text="Foslinanib")
    Intiquinatine = PermissibleValue(text="Intiquinatine")
    Acronine = PermissibleValue(text="Acronine")
    Metarrestin = PermissibleValue(text="Metarrestin")
    Bexmarilimab = PermissibleValue(text="Bexmarilimab")
    Revdofilimab = PermissibleValue(text="Revdofilimab")
    Duligotuzumab = PermissibleValue(text="Duligotuzumab")
    Estramustine = PermissibleValue(text="Estramustine")
    Telapristone = PermissibleValue(text="Telapristone")
    Elacytarabine = PermissibleValue(text="Elacytarabine")
    Nurulimab = PermissibleValue(text="Nurulimab")
    Atuveciclib = PermissibleValue(text="Atuveciclib")
    Indibulin = PermissibleValue(text="Indibulin")
    Audencel = PermissibleValue(text="Audencel")
    Ontorpacept = PermissibleValue(text="Ontorpacept")
    Pasireotide = PermissibleValue(text="Pasireotide")
    Rucaparib = PermissibleValue(text="Rucaparib")
    Mitotenamine = PermissibleValue(text="Mitotenamine")
    Clarithromycin = PermissibleValue(text="Clarithromycin")
    Idronoxil = PermissibleValue(text="Idronoxil")
    Alitretinoin = PermissibleValue(text="Alitretinoin")
    Burosumab = PermissibleValue(text="Burosumab")
    Semustine = PermissibleValue(text="Semustine")
    Mibefradil = PermissibleValue(text="Mibefradil")
    Rilotumumab = PermissibleValue(text="Rilotumumab")
    Bozitinib = PermissibleValue(text="Bozitinib")
    Inulin = PermissibleValue(text="Inulin")
    Baricitinib = PermissibleValue(text="Baricitinib")
    Indomethacin = PermissibleValue(text="Indomethacin")
    Aldoxorubicin = PermissibleValue(text="Aldoxorubicin")
    Gelonin = PermissibleValue(text="Gelonin")
    Ifetroban = PermissibleValue(text="Ifetroban")
    Herbimycin = PermissibleValue(text="Herbimycin")
    Ambazone = PermissibleValue(text="Ambazone")
    Pelitrexol = PermissibleValue(text="Pelitrexol")
    Talazoparib = PermissibleValue(text="Talazoparib")
    Matuzumab = PermissibleValue(text="Matuzumab")
    Mosedipimod = PermissibleValue(text="Mosedipimod")
    Lumretuzumab = PermissibleValue(text="Lumretuzumab")
    Eflornithine = PermissibleValue(text="Eflornithine")
    Nimotuzumab = PermissibleValue(text="Nimotuzumab")
    Spebrutinib = PermissibleValue(text="Spebrutinib")
    Idetrexed = PermissibleValue(text="Idetrexed")
    Vinblastine = PermissibleValue(text="Vinblastine")
    Budigalimab = PermissibleValue(text="Budigalimab")
    Zolbetuximab = PermissibleValue(text="Zolbetuximab")
    Veliparib = PermissibleValue(text="Veliparib")
    Tigapotide = PermissibleValue(text="Tigapotide")
    Carzelesin = PermissibleValue(text="Carzelesin")
    Altiratinib = PermissibleValue(text="Altiratinib")
    Orteronel = PermissibleValue(text="Orteronel")
    Cyclophosphamide = PermissibleValue(text="Cyclophosphamide")
    Andecaliximab = PermissibleValue(text="Andecaliximab")
    Tamoxifen = PermissibleValue(text="Tamoxifen")
    Pasotuxizumab = PermissibleValue(text="Pasotuxizumab")
    Delanzomib = PermissibleValue(text="Delanzomib")
    Retaspimycin = PermissibleValue(text="Retaspimycin")
    Roblitinib = PermissibleValue(text="Roblitinib")
    Breflate = PermissibleValue(text="Breflate")
    Safingol = PermissibleValue(text="Safingol")
    Camrelizumab = PermissibleValue(text="Camrelizumab")
    Onartuzumab = PermissibleValue(text="Onartuzumab")
    Rigosertib = PermissibleValue(text="Rigosertib")
    Belinostat = PermissibleValue(text="Belinostat")
    Balixafortide = PermissibleValue(text="Balixafortide")
    Ulocuplumab = PermissibleValue(text="Ulocuplumab")
    Serplulimab = PermissibleValue(text="Serplulimab")
    Prinomastat = PermissibleValue(text="Prinomastat")
    Calcitriol = PermissibleValue(text="Calcitriol")
    Taminadenant = PermissibleValue(text="Taminadenant")
    Formestane = PermissibleValue(text="Formestane")
    Enoticumab = PermissibleValue(text="Enoticumab")
    Carlumab = PermissibleValue(text="Carlumab")
    Namirotene = PermissibleValue(text="Namirotene")
    Murizatoclax = PermissibleValue(text="Murizatoclax")
    Gimatecan = PermissibleValue(text="Gimatecan")
    Dimethylmyleran = PermissibleValue(text="Dimethylmyleran")
    Tetrathiomolybdate = PermissibleValue(text="Tetrathiomolybdate")
    Dubermatinib = PermissibleValue(text="Dubermatinib")
    Ditiocarb = PermissibleValue(text="Ditiocarb")
    Folitixorin = PermissibleValue(text="Folitixorin")
    Mechlorethamine = PermissibleValue(text="Mechlorethamine")
    Magrolimab = PermissibleValue(text="Magrolimab")
    Rosmantuzumab = PermissibleValue(text="Rosmantuzumab")
    Zorubicin = PermissibleValue(text="Zorubicin")
    Sotrastaurin = PermissibleValue(text="Sotrastaurin")
    Larotrectinib = PermissibleValue(text="Larotrectinib")
    Azapicyl = PermissibleValue(text="Azapicyl")
    Vismodegib = PermissibleValue(text="Vismodegib")
    Etaracizumab = PermissibleValue(text="Etaracizumab")
    Asulacrine = PermissibleValue(text="Asulacrine")
    Tislelizumab = PermissibleValue(text="Tislelizumab")
    Decitabine = PermissibleValue(text="Decitabine")
    Depatuxizumab = PermissibleValue(text="Depatuxizumab")
    Samalizumab = PermissibleValue(text="Samalizumab")
    Sitravatinib = PermissibleValue(text="Sitravatinib")
    Inositol = PermissibleValue(text="Inositol")
    Rebimastat = PermissibleValue(text="Rebimastat")
    Clivatuzumab = PermissibleValue(text="Clivatuzumab")
    Troxacitabine = PermissibleValue(text="Troxacitabine")
    Manelimab = PermissibleValue(text="Manelimab")
    Idarubicin = PermissibleValue(text="Idarubicin")
    Pingyangmycin = PermissibleValue(text="Pingyangmycin")
    Telratolimod = PermissibleValue(text="Telratolimod")
    Onalespib = PermissibleValue(text="Onalespib")
    Talampanel = PermissibleValue(text="Talampanel")
    Dulanermin = PermissibleValue(text="Dulanermin")
    Itacitinib = PermissibleValue(text="Itacitinib")
    Falimarev = PermissibleValue(text="Falimarev")
    Pegilodecakin = PermissibleValue(text="Pegilodecakin")
    Talacotuzumab = PermissibleValue(text="Talacotuzumab")
    Carzinophilin = PermissibleValue(text="Carzinophilin")
    Binetrakin = PermissibleValue(text="Binetrakin")
    Birabresib = PermissibleValue(text="Birabresib")
    Irinotecan = PermissibleValue(text="Irinotecan")
    Perfosfamide = PermissibleValue(text="Perfosfamide")
    Mesna = PermissibleValue(text="Mesna")
    Gossypol = PermissibleValue(text="Gossypol")
    Becatecarin = PermissibleValue(text="Becatecarin")
    Nivolumab = PermissibleValue(text="Nivolumab")
    Temoporfin = PermissibleValue(text="Temoporfin")
    Elgemtumab = PermissibleValue(text="Elgemtumab")
    Tisagenlecleucel = PermissibleValue(text="Tisagenlecleucel")
    Hexaminolevulinate = PermissibleValue(text="Hexaminolevulinate")
    Asaley = PermissibleValue(text="Asaley")
    Echinomycin = PermissibleValue(text="Echinomycin")
    Golvatinib = PermissibleValue(text="Golvatinib")
    Tretazicar = PermissibleValue(text="Tretazicar")
    Givinostat = PermissibleValue(text="Givinostat")
    Bufalin = PermissibleValue(text="Bufalin")
    Budotitane = PermissibleValue(text="Budotitane")
    Mureletecan = PermissibleValue(text="Mureletecan")
    Fadraciclib = PermissibleValue(text="Fadraciclib")
    ASP4132 = PermissibleValue(text="ASP4132")
    Bosutinib = PermissibleValue(text="Bosutinib")
    Darleukin = PermissibleValue(text="Darleukin")
    Puromycin = PermissibleValue(text="Puromycin")
    Tezacitabine = PermissibleValue(text="Tezacitabine")
    Cabazitaxel = PermissibleValue(text="Cabazitaxel")
    Ilixadencel = PermissibleValue(text="Ilixadencel")
    Entospletinib = PermissibleValue(text="Entospletinib")
    Anthrapyrazole = PermissibleValue(text="Anthrapyrazole")
    Filgotinib = PermissibleValue(text="Filgotinib")
    Pegargiminase = PermissibleValue(text="Pegargiminase")
    Rubitecan = PermissibleValue(text="Rubitecan")
    Pentamustine = PermissibleValue(text="Pentamustine")
    Vandetanib = PermissibleValue(text="Vandetanib")
    Tanibirumab = PermissibleValue(text="Tanibirumab")
    Flotetuzumab = PermissibleValue(text="Flotetuzumab")
    Serdemetan = PermissibleValue(text="Serdemetan")
    Carfilzomib = PermissibleValue(text="Carfilzomib")
    Galamustine = PermissibleValue(text="Galamustine")
    Donafenib = PermissibleValue(text="Donafenib")
    Inebilizumab = PermissibleValue(text="Inebilizumab")
    Ensartinib = PermissibleValue(text="Ensartinib")
    Etigilimab = PermissibleValue(text="Etigilimab")
    Vofatamab = PermissibleValue(text="Vofatamab")
    Acodazole = PermissibleValue(text="Acodazole")
    Metoprine = PermissibleValue(text="Metoprine")
    Dusigitumab = PermissibleValue(text="Dusigitumab")
    Momelotinib = PermissibleValue(text="Momelotinib")
    Gemcitabine = PermissibleValue(text="Gemcitabine")
    Pioglitazone = PermissibleValue(text="Pioglitazone")
    Tetrahydrouridine = PermissibleValue(text="Tetrahydrouridine")
    Gedatolisib = PermissibleValue(text="Gedatolisib")
    Xeloda = PermissibleValue(text="Xeloda")
    Amcasertib = PermissibleValue(text="Amcasertib")
    Mivebresib = PermissibleValue(text="Mivebresib")
    Diethylnorspermine = PermissibleValue(text="Diethylnorspermine")
    Ragifilimab = PermissibleValue(text="Ragifilimab")
    Plocabulin = PermissibleValue(text="Plocabulin")
    Devimistat = PermissibleValue(text="Devimistat")
    Fluorouracil = PermissibleValue(text="Fluorouracil")
    Zorifertinib = PermissibleValue(text="Zorifertinib")
    Tucidinostat = PermissibleValue(text="Tucidinostat")
    Lapachone = PermissibleValue(text="Lapachone")
    Carubicin = PermissibleValue(text="Carubicin")
    Rosabulin = PermissibleValue(text="Rosabulin")
    Raloxifene = PermissibleValue(text="Raloxifene")
    Inecalcitol = PermissibleValue(text="Inecalcitol")
    Virulizin = PermissibleValue(text="Virulizin")
    Darinaparsin = PermissibleValue(text="Darinaparsin")
    Pelareorep = PermissibleValue(text="Pelareorep")
    Salirasib = PermissibleValue(text="Salirasib")
    Cositecan = PermissibleValue(text="Cositecan")
    Digoxin = PermissibleValue(text="Digoxin")
    Pegdinetanib = PermissibleValue(text="Pegdinetanib")
    Epitiostanol = PermissibleValue(text="Epitiostanol")
    Apalutamide = PermissibleValue(text="Apalutamide")
    Prexasertib = PermissibleValue(text="Prexasertib")
    Hydroxytyrosol = PermissibleValue(text="Hydroxytyrosol")
    Esorubicin = PermissibleValue(text="Esorubicin")
    Pancratistatin = PermissibleValue(text="Pancratistatin")
    Fazarabine = PermissibleValue(text="Fazarabine")
    Felzartamab = PermissibleValue(text="Felzartamab")
    Plicamycin = PermissibleValue(text="Plicamycin")
    Topsalysin = PermissibleValue(text="Topsalysin")
    Ipatasertib = PermissibleValue(text="Ipatasertib")
    Dienogest = PermissibleValue(text="Dienogest")
    Nimustine = PermissibleValue(text="Nimustine")
    Treosulfan = PermissibleValue(text="Treosulfan")
    Asciminib = PermissibleValue(text="Asciminib")
    Dacarbazine = PermissibleValue(text="Dacarbazine")
    Onvansertib = PermissibleValue(text="Onvansertib")
    Didox = PermissibleValue(text="Didox")
    Carotuximab = PermissibleValue(text="Carotuximab")
    Edelfosine = PermissibleValue(text="Edelfosine")
    Abemaciclib = PermissibleValue(text="Abemaciclib")
    Pamiparib = PermissibleValue(text="Pamiparib")
    Avadomide = PermissibleValue(text="Avadomide")
    Bazlitoran = PermissibleValue(text="Bazlitoran")
    Tolebrutinib = PermissibleValue(text="Tolebrutinib")
    APC8015F = PermissibleValue(text="APC8015F")
    Serabelisib = PermissibleValue(text="Serabelisib")
    Thioureidobutyronitrile = PermissibleValue(text="Thioureidobutyronitrile")
    Copanlisib = PermissibleValue(text="Copanlisib")
    Derazantinib = PermissibleValue(text="Derazantinib")
    Rhizoxin = PermissibleValue(text="Rhizoxin")
    Methazolamide = PermissibleValue(text="Methazolamide")
    Molibresib = PermissibleValue(text="Molibresib")
    Dezaguanine = PermissibleValue(text="Dezaguanine")
    Andrographolide = PermissibleValue(text="Andrographolide")
    Odronextamab = PermissibleValue(text="Odronextamab")
    Etanidazole = PermissibleValue(text="Etanidazole")
    Atezolizumab = PermissibleValue(text="Atezolizumab")
    Mogamulizumab = PermissibleValue(text="Mogamulizumab")
    Danvatirsen = PermissibleValue(text="Danvatirsen")
    Anthramycin = PermissibleValue(text="Anthramycin")
    Trastuzumab = PermissibleValue(text="Trastuzumab")
    Melphalan = PermissibleValue(text="Melphalan")
    Napabucasin = PermissibleValue(text="Napabucasin")
    Oprozomib = PermissibleValue(text="Oprozomib")
    Nesvacumab = PermissibleValue(text="Nesvacumab")
    Nemorubicin = PermissibleValue(text="Nemorubicin")
    Encorafenib = PermissibleValue(text="Encorafenib")
    Parsaclisib = PermissibleValue(text="Parsaclisib")
    Methoxsalen = PermissibleValue(text="Methoxsalen")
    Pepinemab = PermissibleValue(text="Pepinemab")
    Elisidepsin = PermissibleValue(text="Elisidepsin")
    Lexibulin = PermissibleValue(text="Lexibulin")
    Imetelstat = PermissibleValue(text="Imetelstat")
    Curcumin = PermissibleValue(text="Curcumin")
    Mocetinostat = PermissibleValue(text="Mocetinostat")
    Envafolimab = PermissibleValue(text="Envafolimab")
    Ertumaxomab = PermissibleValue(text="Ertumaxomab")
    Parsatuzumab = PermissibleValue(text="Parsatuzumab")
    Aldesleukin = PermissibleValue(text="Aldesleukin")
    Fluorodopan = PermissibleValue(text="Fluorodopan")
    Trebananib = PermissibleValue(text="Trebananib")
    Mirdametinib = PermissibleValue(text="Mirdametinib")
    Galocitabine = PermissibleValue(text="Galocitabine")
    Burixafor = PermissibleValue(text="Burixafor")
    Thiodiglycol = PermissibleValue(text="Thiodiglycol")
    Levothyroxine = PermissibleValue(text="Levothyroxine")
    Bafetinib = PermissibleValue(text="Bafetinib")
    Gentuximab = PermissibleValue(text="Gentuximab")
    Cirmtuzumab = PermissibleValue(text="Cirmtuzumab")
    Azotomycin = PermissibleValue(text="Azotomycin")
    Roniciclib = PermissibleValue(text="Roniciclib")
    Mitoclomine = PermissibleValue(text="Mitoclomine")
    Ieramilimab = PermissibleValue(text="Ieramilimab")
    Ribociclib = PermissibleValue(text="Ribociclib")
    Dilpacimab = PermissibleValue(text="Dilpacimab")
    Golotimod = PermissibleValue(text="Golotimod")
    Selpercatinib = PermissibleValue(text="Selpercatinib")
    Triaziquone = PermissibleValue(text="Triaziquone")
    Savolitinib = PermissibleValue(text="Savolitinib")
    Enzastaurin = PermissibleValue(text="Enzastaurin")
    Vosaroxin = PermissibleValue(text="Vosaroxin")
    Teprotumumab = PermissibleValue(text="Teprotumumab")
    Enavatuzumab = PermissibleValue(text="Enavatuzumab")
    Vadimezan = PermissibleValue(text="Vadimezan")
    Defactinib = PermissibleValue(text="Defactinib")
    Fluvastatin = PermissibleValue(text="Fluvastatin")
    Pyroxamide = PermissibleValue(text="Pyroxamide")
    Caracemide = PermissibleValue(text="Caracemide")
    Irofulven = PermissibleValue(text="Irofulven")
    Broxuridine = PermissibleValue(text="Broxuridine")
    Solitomab = PermissibleValue(text="Solitomab")
    Selinexor = PermissibleValue(text="Selinexor")
    Zalcitabine = PermissibleValue(text="Zalcitabine")
    Crolibulin = PermissibleValue(text="Crolibulin")
    Verubulin = PermissibleValue(text="Verubulin")
    Selumetinib = PermissibleValue(text="Selumetinib")
    Rosuvastatin = PermissibleValue(text="Rosuvastatin")
    Acalabrutinib = PermissibleValue(text="Acalabrutinib")
    Trigriluzole = PermissibleValue(text="Trigriluzole")
    Pilaralisib = PermissibleValue(text="Pilaralisib")
    Cedazuridine = PermissibleValue(text="Cedazuridine")
    Panobinostat = PermissibleValue(text="Panobinostat")
    Tabelecleucel = PermissibleValue(text="Tabelecleucel")
    Tocladesine = PermissibleValue(text="Tocladesine")
    Thiotepa = PermissibleValue(text="Thiotepa")
    Imaradenant = PermissibleValue(text="Imaradenant")
    Peplomycin = PermissibleValue(text="Peplomycin")
    Catumaxomab = PermissibleValue(text="Catumaxomab")
    Pixantrone = PermissibleValue(text="Pixantrone")
    Rabusertib = PermissibleValue(text="Rabusertib")
    Cetrelimab = PermissibleValue(text="Cetrelimab")
    Marcellomycin = PermissibleValue(text="Marcellomycin")
    Alsevalimab = PermissibleValue(text="Alsevalimab")
    Liposome = PermissibleValue(text="Liposome")
    Vindesine = PermissibleValue(text="Vindesine")
    Seliciclib = PermissibleValue(text="Seliciclib")
    Linperlisib = PermissibleValue(text="Linperlisib")
    Lefitolimod = PermissibleValue(text="Lefitolimod")
    Cilengitide = PermissibleValue(text="Cilengitide")
    Galeterone = PermissibleValue(text="Galeterone")
    Iniparib = PermissibleValue(text="Iniparib")
    Methyltestosterone = PermissibleValue(text="Methyltestosterone")
    Belvarafenib = PermissibleValue(text="Belvarafenib")
    Temarotene = PermissibleValue(text="Temarotene")
    Cibisatamab = PermissibleValue(text="Cibisatamab")
    Ocaratuzumab = PermissibleValue(text="Ocaratuzumab")
    Lazertinib = PermissibleValue(text="Lazertinib")
    Gilteritinib = PermissibleValue(text="Gilteritinib")
    Palbociclib = PermissibleValue(text="Palbociclib")
    Avapritinib = PermissibleValue(text="Avapritinib")
    Streptonigrin = PermissibleValue(text="Streptonigrin")
    Osimertinib = PermissibleValue(text="Osimertinib")
    Rociletinib = PermissibleValue(text="Rociletinib")
    Elesclomol = PermissibleValue(text="Elesclomol")
    Pumitepa = PermissibleValue(text="Pumitepa")
    Trimelamol = PermissibleValue(text="Trimelamol")
    Aminocamptothecin = PermissibleValue(text="Aminocamptothecin")
    Nedisertib = PermissibleValue(text="Nedisertib")
    Oxaliplatin = PermissibleValue(text="Oxaliplatin")
    Regorafenib = PermissibleValue(text="Regorafenib")
    Tretinoin = PermissibleValue(text="Tretinoin")
    Sulfatinib = PermissibleValue(text="Sulfatinib")
    Pyrazoloacridine = PermissibleValue(text="Pyrazoloacridine")
    Rindopepimut = PermissibleValue(text="Rindopepimut")
    Terfluranol = PermissibleValue(text="Terfluranol")
    Daratumumab = PermissibleValue(text="Daratumumab")
    Spiroplatin = PermissibleValue(text="Spiroplatin")
    Iratumumab = PermissibleValue(text="Iratumumab")
    Sulindac = PermissibleValue(text="Sulindac")
    Cedefingol = PermissibleValue(text="Cedefingol")
    Pentoxifylline = PermissibleValue(text="Pentoxifylline")
    Nilutamide = PermissibleValue(text="Nilutamide")
    Levetiracetam = PermissibleValue(text="Levetiracetam")
    Mevociclib = PermissibleValue(text="Mevociclib")
    Gimeracil = PermissibleValue(text="Gimeracil")
    Vactosertib = PermissibleValue(text="Vactosertib")
    Sotigalimab = PermissibleValue(text="Sotigalimab")
    Pinometostat = PermissibleValue(text="Pinometostat")
    Fluzoparib = PermissibleValue(text="Fluzoparib")
    Minretumomab = PermissibleValue(text="Minretumomab")
    Amsacrine = PermissibleValue(text="Amsacrine")
    Tenifatecan = PermissibleValue(text="Tenifatecan")
    Vatalanib = PermissibleValue(text="Vatalanib")
    Deslorelin = PermissibleValue(text="Deslorelin")
    Asparaginase = PermissibleValue(text="Asparaginase")
    Imifoplatin = PermissibleValue(text="Imifoplatin")
    Vosilasarm = PermissibleValue(text="Vosilasarm")
    Opaganib = PermissibleValue(text="Opaganib")
    Zotatifin = PermissibleValue(text="Zotatifin")
    Vincristine = PermissibleValue(text="Vincristine")
    Etarotene = PermissibleValue(text="Etarotene")
    Sunitinib = PermissibleValue(text="Sunitinib")

    _defn = EnumDefinition(
        name="EnumCRDCHSubstanceSubstanceType",
        description="Autogenerated Enumeration for CRDC-H Substance substance_type",
        code_set=None,
        code_set_version="2021-12-16T18:04:32.883250+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Autologous Anti-CD19 CAR-CD28 T-cells ET019002",
                PermissibleValue(text="Autologous Anti-CD19 CAR-CD28 T-cells ET019002") )
        setattr(cls, "PBN Derivative OKN-007",
                PermissibleValue(text="PBN Derivative OKN-007") )
        setattr(cls, "Pan-mutation-selective EGFR Inhibitor CLN-081",
                PermissibleValue(text="Pan-mutation-selective EGFR Inhibitor CLN-081") )
        setattr(cls, "MEK 1/2 Inhibitor FCN-159",
                PermissibleValue(text="MEK 1/2 Inhibitor FCN-159") )
        setattr(cls, "Idiotype-Pulsed Autologous Dendritic Cell Vaccine APC8020",
                PermissibleValue(text="Idiotype-Pulsed Autologous Dendritic Cell Vaccine APC8020") )
        setattr(cls, "Phellodendron amurense Bark Extract",
                PermissibleValue(text="Phellodendron amurense Bark Extract") )
        setattr(cls, "Lupartumab Amadotin",
                PermissibleValue(text="Lupartumab Amadotin") )
        setattr(cls, "Anti-CD39 Monoclonal Antibody TTX-030",
                PermissibleValue(text="Anti-CD39 Monoclonal Antibody TTX-030") )
        setattr(cls, "Sodium Dichloroacetate",
                PermissibleValue(text="Sodium Dichloroacetate") )
        setattr(cls, "Tezacitabine Anhydrous",
                PermissibleValue(text="Tezacitabine Anhydrous") )
        setattr(cls, "Conditionally Active Biologic Anti-AXL Antibody-drug Conjugate BA3011",
                PermissibleValue(text="Conditionally Active Biologic Anti-AXL Antibody-drug Conjugate BA3011") )
        setattr(cls, "Anti-Denatured Collagen Monoclonal Antibody TRC093",
                PermissibleValue(text="Anti-Denatured Collagen Monoclonal Antibody TRC093") )
        setattr(cls, "Endothelin Receptor Type A Antagonist YM598",
                PermissibleValue(text="Endothelin Receptor Type A Antagonist YM598") )
        setattr(cls, "Autologous Anti-EGFR CAR-transduced CXCR 5-modified T-lymphocytes",
                PermissibleValue(text="Autologous Anti-EGFR CAR-transduced CXCR 5-modified T-lymphocytes") )
        setattr(cls, "Autologous BCMA-targeted CAR T Cells LCAR-B4822M",
                PermissibleValue(text="Autologous BCMA-targeted CAR T Cells LCAR-B4822M") )
        setattr(cls, "Tubulin Polymerization Inhibitor CKD-516",
                PermissibleValue(text="Tubulin Polymerization Inhibitor CKD-516") )
        setattr(cls, "Anti-c-Met Monoclonal Antibody HLX55",
                PermissibleValue(text="Anti-c-Met Monoclonal Antibody HLX55") )
        setattr(cls, "Anti-LAMP1 Antibody-drug Conjugate SAR428926",
                PermissibleValue(text="Anti-LAMP1 Antibody-drug Conjugate SAR428926") )
        setattr(cls, "Immunomodulatory Agent CC-11006",
                PermissibleValue(text="Immunomodulatory Agent CC-11006") )
        setattr(cls, "Anti-IGF-1R Recombinant Monoclonal Antibody BIIB022",
                PermissibleValue(text="Anti-IGF-1R Recombinant Monoclonal Antibody BIIB022") )
        setattr(cls, "Ruthenium Ru-106",
                PermissibleValue(text="Ruthenium Ru-106") )
        setattr(cls, "DNA Plasmid-encoding Interleukin-12/HPV DNA Plasmids Therapeutic Vaccine MEDI0457",
                PermissibleValue(text="DNA Plasmid-encoding Interleukin-12/HPV DNA Plasmids Therapeutic Vaccine MEDI0457") )
        setattr(cls, "Copper Cu 67 Tyr3-octreotate",
                PermissibleValue(text="Copper Cu 67 Tyr3-octreotate") )
        setattr(cls, "MOv-gamma Chimeric Receptor Gene",
                PermissibleValue(text="MOv-gamma Chimeric Receptor Gene") )
        setattr(cls, "Recombinant Human 6Ckine",
                PermissibleValue(text="Recombinant Human 6Ckine") )
        setattr(cls, "PD-1 Directed Probody CX-188",
                PermissibleValue(text="PD-1 Directed Probody CX-188") )
        setattr(cls, "Immunoconjugate RO5479599",
                PermissibleValue(text="Immunoconjugate RO5479599") )
        setattr(cls, "siRNA-transfected Peripheral Blood Mononuclear Cells APN401",
                PermissibleValue(text="siRNA-transfected Peripheral Blood Mononuclear Cells APN401") )
        setattr(cls, "Anti-PD-1 Monoclonal Antibody AMG 404",
                PermissibleValue(text="Anti-PD-1 Monoclonal Antibody AMG 404") )
        setattr(cls, "Anti-CD73 Monoclonal Antibody CPI-006",
                PermissibleValue(text="Anti-CD73 Monoclonal Antibody CPI-006") )
        setattr(cls, "Anti-CD3/Anti-GUCY2C Bispecific Antibody PF-07062119",
                PermissibleValue(text="Anti-CD3/Anti-GUCY2C Bispecific Antibody PF-07062119") )
        setattr(cls, "Autologous Mesothelin-specific Human mRNA CAR-transfected PBMCs MCY-M11",
                PermissibleValue(text="Autologous Mesothelin-specific Human mRNA CAR-transfected PBMCs MCY-M11") )
        setattr(cls, "Colchicine-Site Binding Agent ABT-751",
                PermissibleValue(text="Colchicine-Site Binding Agent ABT-751") )
        setattr(cls, "Autologous Anti-BCMA CAR-transduced T-cells KITE-585",
                PermissibleValue(text="Autologous Anti-BCMA CAR-transduced T-cells KITE-585") )
        setattr(cls, "Nitric Oxide-Releasing Acetylsalicylic Acid Derivative",
                PermissibleValue(text="Nitric Oxide-Releasing Acetylsalicylic Acid Derivative") )
        setattr(cls, "IDO/TDO Inhibitor LY-01013",
                PermissibleValue(text="IDO/TDO Inhibitor LY-01013") )
        setattr(cls, "Fedratinib Hydrochloride",
                PermissibleValue(text="Fedratinib Hydrochloride") )
        setattr(cls, "Anti-ICOS Agonist Antibody GSK3359609",
                PermissibleValue(text="Anti-ICOS Agonist Antibody GSK3359609") )
        setattr(cls, "CDK4/6 Inhibitor HS-10342",
                PermissibleValue(text="CDK4/6 Inhibitor HS-10342") )
        setattr(cls, "Tamoxifen Citrate",
                PermissibleValue(text="Tamoxifen Citrate") )
        setattr(cls, "Anti-PD-L1 Monoclonal Antibody MDX-1105",
                PermissibleValue(text="Anti-PD-L1 Monoclonal Antibody MDX-1105") )
        setattr(cls, "Monomethyl Auristatin E",
                PermissibleValue(text="Monomethyl Auristatin E") )
        setattr(cls, "Cisplatin-E Therapeutic Implant",
                PermissibleValue(text="Cisplatin-E Therapeutic Implant") )
        setattr(cls, "2-Hydroxyestrone",
                PermissibleValue(text="2-Hydroxyestrone") )
        setattr(cls, "PARP/Tankyrase Inhibitor 2X-121",
                PermissibleValue(text="PARP/Tankyrase Inhibitor 2X-121") )
        setattr(cls, "KSP Inhibitor AZD4877",
                PermissibleValue(text="KSP Inhibitor AZD4877") )
        setattr(cls, "Sitimagene Ceradenovec",
                PermissibleValue(text="Sitimagene Ceradenovec") )
        setattr(cls, "Anti-CD70 Antibody-drug Conjugate SGN-CD70A",
                PermissibleValue(text="Anti-CD70 Antibody-drug Conjugate SGN-CD70A") )
        setattr(cls, "SR-BP1/HSI Inhibitor SR31747A",
                PermissibleValue(text="SR-BP1/HSI Inhibitor SR31747A") )
        setattr(cls, "Puquitinib Mesylate",
                PermissibleValue(text="Puquitinib Mesylate") )
        setattr(cls, "Epothilone KOS-1584",
                PermissibleValue(text="Epothilone KOS-1584") )
        setattr(cls, "Telomerase-specific Type 5 Adenovirus OBP-301",
                PermissibleValue(text="Telomerase-specific Type 5 Adenovirus OBP-301") )
        setattr(cls, "p53/HDM2 Interaction Inhibitor CGM097",
                PermissibleValue(text="p53/HDM2 Interaction Inhibitor CGM097") )
        setattr(cls, "PEG-interleukin-2",
                PermissibleValue(text="PEG-interleukin-2") )
        setattr(cls, "Yttrium Y-90 Tacatuzumab Tetraxetan",
                PermissibleValue(text="Yttrium Y-90 Tacatuzumab Tetraxetan") )
        setattr(cls, "Tavokinogene Telseplasmid",
                PermissibleValue(text="Tavokinogene Telseplasmid") )
        setattr(cls, "Pol I Inhibitor CX5461",
                PermissibleValue(text="Pol I Inhibitor CX5461") )
        setattr(cls, "Immunotoxin CMD-193",
                PermissibleValue(text="Immunotoxin CMD-193") )
        setattr(cls, "pan FGFR Inhibitor PRN1371",
                PermissibleValue(text="pan FGFR Inhibitor PRN1371") )
        setattr(cls, "Enterococcus gallinarum Strain MRx0518",
                PermissibleValue(text="Enterococcus gallinarum Strain MRx0518") )
        setattr(cls, "Allogeneic GM-CSF-secreting Lethally Irradiated Whole Melanoma Cell Vaccine",
                PermissibleValue(text="Allogeneic GM-CSF-secreting Lethally Irradiated Whole Melanoma Cell Vaccine") )
        setattr(cls, "Lorukafusp alfa",
                PermissibleValue(text="Lorukafusp alfa") )
        setattr(cls, "PSMA/CD3 Tri-specific T-cell Activating Construct HPN424",
                PermissibleValue(text="PSMA/CD3 Tri-specific T-cell Activating Construct HPN424") )
        setattr(cls, "GS/pan-Notch Inhibitor BMS-986115",
                PermissibleValue(text="GS/pan-Notch Inhibitor BMS-986115") )
        setattr(cls, "Cantuzumab Ravtansine",
                PermissibleValue(text="Cantuzumab Ravtansine") )
        setattr(cls, "Anti-mesothelin Antibody-drug Conjugate BMS-986148",
                PermissibleValue(text="Anti-mesothelin Antibody-drug Conjugate BMS-986148") )
        setattr(cls, "Sunitinib Malate",
                PermissibleValue(text="Sunitinib Malate") )
        setattr(cls, "PEG-Proline-Interferon Alfa-2b",
                PermissibleValue(text="PEG-Proline-Interferon Alfa-2b") )
        setattr(cls, "Anti-CD32B Monoclonal Antibody BI-1206",
                PermissibleValue(text="Anti-CD32B Monoclonal Antibody BI-1206") )
        setattr(cls, "Sodium Iodide I-131",
                PermissibleValue(text="Sodium Iodide I-131") )
        setattr(cls, "Pravastatin Sodium",
                PermissibleValue(text="Pravastatin Sodium") )
        setattr(cls, "CBP/beta-catenin Modulator E7386",
                PermissibleValue(text="CBP/beta-catenin Modulator E7386") )
        setattr(cls, "Monoclonal Antibody A1G4 Anti-Idiotype Vaccine",
                PermissibleValue(text="Monoclonal Antibody A1G4 Anti-Idiotype Vaccine") )
        setattr(cls, "Itacitinib Adipate",
                PermissibleValue(text="Itacitinib Adipate") )
        setattr(cls, "Vocimagene Amiretrorepvec",
                PermissibleValue(text="Vocimagene Amiretrorepvec") )
        setattr(cls, "Anti-CD47 Monoclonal Antibody Hu5F9-G4",
                PermissibleValue(text="Anti-CD47 Monoclonal Antibody Hu5F9-G4") )
        setattr(cls, "EP4 Antagonist ONO-4578",
                PermissibleValue(text="EP4 Antagonist ONO-4578") )
        setattr(cls, "Anti-HER2 Monoclonal Antibody CT-P6",
                PermissibleValue(text="Anti-HER2 Monoclonal Antibody CT-P6") )
        setattr(cls, "Anti-CLEC12A/CD3 Bispecific Antibody MCLA117",
                PermissibleValue(text="Anti-CLEC12A/CD3 Bispecific Antibody MCLA117") )
        setattr(cls, "IL-12sc, IL-15sushi, IFNa and GM-CSF mRNA-based Immunotherapeutic Agent SAR441000",
                PermissibleValue(text="IL-12sc, IL-15sushi, IFNa and GM-CSF mRNA-based Immunotherapeutic Agent SAR441000") )
        setattr(cls, "Octreotide Acetate",
                PermissibleValue(text="Octreotide Acetate") )
        setattr(cls, "Anti-RANKL Monoclonal Antibody GB-223",
                PermissibleValue(text="Anti-RANKL Monoclonal Antibody GB-223") )
        setattr(cls, "Akt Inhibitor SR13668",
                PermissibleValue(text="Akt Inhibitor SR13668") )
        setattr(cls, "IL-12-expressing HSV-1 NSC 733972",
                PermissibleValue(text="IL-12-expressing HSV-1 NSC 733972") )
        setattr(cls, "STING Agonist TAK-676",
                PermissibleValue(text="STING Agonist TAK-676") )
        setattr(cls, "CYP17 Inhibitor CFG920",
                PermissibleValue(text="CYP17 Inhibitor CFG920") )
        setattr(cls, "Monoclonal Antibody NEO-201",
                PermissibleValue(text="Monoclonal Antibody NEO-201") )
        setattr(cls, "pan-PI3K Inhibitor CLR457",
                PermissibleValue(text="pan-PI3K Inhibitor CLR457") )
        setattr(cls, "Anti-EGFR Monoclonal Antibody SYN004",
                PermissibleValue(text="Anti-EGFR Monoclonal Antibody SYN004") )
        setattr(cls, "Adenoviral Cancer Vaccine PF-06936308",
                PermissibleValue(text="Adenoviral Cancer Vaccine PF-06936308") )
        setattr(cls, "Beta-lapachone Prodrug ARQ 761",
                PermissibleValue(text="Beta-lapachone Prodrug ARQ 761") )
        setattr(cls, "Recombinant Human TRAIL-Trimer Fusion Protein SCB-313",
                PermissibleValue(text="Recombinant Human TRAIL-Trimer Fusion Protein SCB-313") )
        setattr(cls, "Gemcitabine Hydrochloride Emulsion",
                PermissibleValue(text="Gemcitabine Hydrochloride Emulsion") )
        setattr(cls, "SDF-1 Receptor Antagonist PTX-9908",
                PermissibleValue(text="SDF-1 Receptor Antagonist PTX-9908") )
        setattr(cls, "Gusperimus Trihydrochloride",
                PermissibleValue(text="Gusperimus Trihydrochloride") )
        setattr(cls, "Multi-AGC Kinase Inhibitor AT13148",
                PermissibleValue(text="Multi-AGC Kinase Inhibitor AT13148") )
        setattr(cls, "Prednisolone Acetate",
                PermissibleValue(text="Prednisolone Acetate") )
        setattr(cls, "CSF1R Inhibitor PLX73086",
                PermissibleValue(text="CSF1R Inhibitor PLX73086") )
        setattr(cls, "Anti-BTLA Monoclonal Antibody TAB004",
                PermissibleValue(text="Anti-BTLA Monoclonal Antibody TAB004") )
        setattr(cls, "Belantamab Mafodotin",
                PermissibleValue(text="Belantamab Mafodotin") )
        setattr(cls, "Paclitaxel Trevatide",
                PermissibleValue(text="Paclitaxel Trevatide") )
        setattr(cls, "LAIR-2 Fusion Protein NC410",
                PermissibleValue(text="LAIR-2 Fusion Protein NC410") )
        setattr(cls, "Radgocitabine Hydrochloride",
                PermissibleValue(text="Radgocitabine Hydrochloride") )
        setattr(cls, "Anti-TIM-3 Antibody BMS-986258",
                PermissibleValue(text="Anti-TIM-3 Antibody BMS-986258") )
        setattr(cls, "BH3 Mimetic ABT-737",
                PermissibleValue(text="BH3 Mimetic ABT-737") )
        setattr(cls, "G Protein-coupled Estrogen Receptor Agonist LNS8801",
                PermissibleValue(text="G Protein-coupled Estrogen Receptor Agonist LNS8801") )
        setattr(cls, "Anti-FGFR3 Antibody-drug Conjugate LY3076226",
                PermissibleValue(text="Anti-FGFR3 Antibody-drug Conjugate LY3076226") )
        setattr(cls, "Taxane Compound",
                PermissibleValue(text="Taxane Compound") )
        setattr(cls, "Anti-CD30 Monoclonal Antibody XmAb2513",
                PermissibleValue(text="Anti-CD30 Monoclonal Antibody XmAb2513") )
        setattr(cls, "IDH1(R132) Inhibitor IDH305",
                PermissibleValue(text="IDH1(R132) Inhibitor IDH305") )
        setattr(cls, "Allogeneic Renal Cell Carcinoma Vaccine MGN1601",
                PermissibleValue(text="Allogeneic Renal Cell Carcinoma Vaccine MGN1601") )
        setattr(cls, "HSP90alpha/beta Inhibitor TAS-116",
                PermissibleValue(text="HSP90alpha/beta Inhibitor TAS-116") )
        setattr(cls, "Squalamine Lactate",
                PermissibleValue(text="Squalamine Lactate") )
        setattr(cls, "cEt KRAS Antisense Oligonucleotide AZD4785",
                PermissibleValue(text="cEt KRAS Antisense Oligonucleotide AZD4785") )
        setattr(cls, "Anti-EphA2 Antibody-directed Liposomal Docetaxel Prodrug MM-310",
                PermissibleValue(text="Anti-EphA2 Antibody-directed Liposomal Docetaxel Prodrug MM-310") )
        setattr(cls, "Parvovirus H-1",
                PermissibleValue(text="Parvovirus H-1") )
        setattr(cls, "Glutathione Pegylated Liposomal Doxorubicin Hydrochloride Formulation 2B3-101",
                PermissibleValue(text="Glutathione Pegylated Liposomal Doxorubicin Hydrochloride Formulation 2B3-101") )
        setattr(cls, "Lapuleucel-T",
                PermissibleValue(text="Lapuleucel-T") )
        setattr(cls, "Anti-GD3 Antibody-drug Conjugate PF-06688992",
                PermissibleValue(text="Anti-GD3 Antibody-drug Conjugate PF-06688992") )
        setattr(cls, "Src Kinase Inhibitor M475271",
                PermissibleValue(text="Src Kinase Inhibitor M475271") )
        setattr(cls, "Iodine I 131 Monoclonal Antibody 81C6",
                PermissibleValue(text="Iodine I 131 Monoclonal Antibody 81C6") )
        setattr(cls, "Nitroglycerin Transdermal Patch",
                PermissibleValue(text="Nitroglycerin Transdermal Patch") )
        setattr(cls, "Diarylsulfonylurea Compound ILX-295501",
                PermissibleValue(text="Diarylsulfonylurea Compound ILX-295501") )
        setattr(cls, "Astatine At 211 Anti-CD45 Monoclonal Antibody BC8-B10",
                PermissibleValue(text="Astatine At 211 Anti-CD45 Monoclonal Antibody BC8-B10") )
        setattr(cls, "LMB-2 Immunotoxin",
                PermissibleValue(text="LMB-2 Immunotoxin") )
        setattr(cls, "Yttrium Y 90 Anti-CDH3 Monoclonal Antibody FF-21101",
                PermissibleValue(text="Yttrium Y 90 Anti-CDH3 Monoclonal Antibody FF-21101") )
        setattr(cls, "Nanoparticle Albumin-Bound Docetaxel",
                PermissibleValue(text="Nanoparticle Albumin-Bound Docetaxel") )
        setattr(cls, "Recombinant Interferon Alfa-2a",
                PermissibleValue(text="Recombinant Interferon Alfa-2a") )
        setattr(cls, "Anti-BCMA Antibody-drug Conjugate CC-99712",
                PermissibleValue(text="Anti-BCMA Antibody-drug Conjugate CC-99712") )
        setattr(cls, "Class 1/4 Histone Deacetylase Inhibitor OKI-179",
                PermissibleValue(text="Class 1/4 Histone Deacetylase Inhibitor OKI-179") )
        setattr(cls, "VEGFR/FGFR Inhibitor ODM-203",
                PermissibleValue(text="VEGFR/FGFR Inhibitor ODM-203") )
        setattr(cls, "Foslinanib Disodium",
                PermissibleValue(text="Foslinanib Disodium") )
        setattr(cls, "Porcupine Inhibitor ETC-1922159",
                PermissibleValue(text="Porcupine Inhibitor ETC-1922159") )
        setattr(cls, "PARP Inhibitor E7016",
                PermissibleValue(text="PARP Inhibitor E7016") )
        setattr(cls, "N-(5-tert-butyl-3-isoxazolyl)-N-(4-(4-pyridinyl)oxyphenyl) Urea",
                PermissibleValue(text="N-(5-tert-butyl-3-isoxazolyl)-N-(4-(4-pyridinyl)oxyphenyl) Urea") )
        setattr(cls, "Dengue Virus Adjuvant PV-001-DV",
                PermissibleValue(text="Dengue Virus Adjuvant PV-001-DV") )
        setattr(cls, "BET Inhibitor CPI-0610",
                PermissibleValue(text="BET Inhibitor CPI-0610") )
        setattr(cls, "Anti-Folate Receptor-alpha Antibody Drug Conjugate STRO-002",
                PermissibleValue(text="Anti-Folate Receptor-alpha Antibody Drug Conjugate STRO-002") )
        setattr(cls, "Autologous Rapamycin-resistant Th1/Tc1 Cells RAPA-201",
                PermissibleValue(text="Autologous Rapamycin-resistant Th1/Tc1 Cells RAPA-201") )
        setattr(cls, "Anti-CTGF Monoclonal Antibody FG-3019",
                PermissibleValue(text="Anti-CTGF Monoclonal Antibody FG-3019") )
        setattr(cls, "Anti-CTLA-4/OX40 Bispecific Antibody ATOR-1015",
                PermissibleValue(text="Anti-CTLA-4/OX40 Bispecific Antibody ATOR-1015") )
        setattr(cls, "Doxorubicin Prodrug/Prodrug-activating Biomaterial SQ3370",
                PermissibleValue(text="Doxorubicin Prodrug/Prodrug-activating Biomaterial SQ3370") )
        setattr(cls, "PARP Inhibitor CEP-9722",
                PermissibleValue(text="PARP Inhibitor CEP-9722") )
        setattr(cls, "SLCT Inhibitor GNS561",
                PermissibleValue(text="SLCT Inhibitor GNS561") )
        setattr(cls, "Decitabine and Cedazuridine",
                PermissibleValue(text="Decitabine and Cedazuridine") )
        setattr(cls, "Aurora Kinase/VEGFR2 Inhibitor CYC116",
                PermissibleValue(text="Aurora Kinase/VEGFR2 Inhibitor CYC116") )
        setattr(cls, "Anti-c-fms Monoclonal Antibody AMG 820",
                PermissibleValue(text="Anti-c-fms Monoclonal Antibody AMG 820") )
        setattr(cls, "Spherical Nucleic Acid Nanoparticle NU-0129",
                PermissibleValue(text="Spherical Nucleic Acid Nanoparticle NU-0129") )
        setattr(cls, "NLRP3 Agonist BMS-986299",
                PermissibleValue(text="NLRP3 Agonist BMS-986299") )
        setattr(cls, "Bendamustine Hydrochloride",
                PermissibleValue(text="Bendamustine Hydrochloride") )
        setattr(cls, "Anti-DLL4/VEGF Bispecific Monoclonal Antibody OMP-305B83",
                PermissibleValue(text="Anti-DLL4/VEGF Bispecific Monoclonal Antibody OMP-305B83") )
        setattr(cls, "BRAF Inhibitor ARQ 736",
                PermissibleValue(text="BRAF Inhibitor ARQ 736") )
        setattr(cls, "Anti-SIRPa Monoclonal Antibody CC-95251",
                PermissibleValue(text="Anti-SIRPa Monoclonal Antibody CC-95251") )
        setattr(cls, "Anti-HER2 Monoclonal Antibody/Anti-CD137Anticalin Bispecific Fusion Protein PRS-343",
                PermissibleValue(text="Anti-HER2 Monoclonal Antibody/Anti-CD137Anticalin Bispecific Fusion Protein PRS-343") )
        setattr(cls, "EGFR/VEGFR/RET Inhibitor HA121-28",
                PermissibleValue(text="EGFR/VEGFR/RET Inhibitor HA121-28") )
        setattr(cls, "Anti-HER2/Auristatin Payload Antibody-drug Conjugate XMT-1522",
                PermissibleValue(text="Anti-HER2/Auristatin Payload Antibody-drug Conjugate XMT-1522") )
        setattr(cls, "EGFR T790M Antagonist BPI-15086",
                PermissibleValue(text="EGFR T790M Antagonist BPI-15086") )
        setattr(cls, "Oncolytic Herpes Simplex Virus-1 ONCR-177",
                PermissibleValue(text="Oncolytic Herpes Simplex Virus-1 ONCR-177") )
        setattr(cls, "Personalized and Adjusted Neoantigen Peptide Vaccine PANDA-VAC",
                PermissibleValue(text="Personalized and Adjusted Neoantigen Peptide Vaccine PANDA-VAC") )
        setattr(cls, "Antibody-drug Conjugate SC-002",
                PermissibleValue(text="Antibody-drug Conjugate SC-002") )
        setattr(cls, "Therapeutic Cancer Vaccine ATP128",
                PermissibleValue(text="Therapeutic Cancer Vaccine ATP128") )
        setattr(cls, "Hsp90 Inhibitor BIIB028",
                PermissibleValue(text="Hsp90 Inhibitor BIIB028") )
        setattr(cls, "Mirvetuximab Soravtansine",
                PermissibleValue(text="Mirvetuximab Soravtansine") )
        setattr(cls, "Autologous Tumor Infiltrating Lymphocytes LN-145",
                PermissibleValue(text="Autologous Tumor Infiltrating Lymphocytes LN-145") )
        setattr(cls, "Anti-EGFR Monoclonal Antibody EMD 55900",
                PermissibleValue(text="Anti-EGFR Monoclonal Antibody EMD 55900") )
        setattr(cls, "Yttrium Y 90 Anti-CEA Monoclonal Antibody cT84.66",
                PermissibleValue(text="Yttrium Y 90 Anti-CEA Monoclonal Antibody cT84.66") )
        setattr(cls, "Anti-CTLA4 Monoclonal Antibody BMS-986218",
                PermissibleValue(text="Anti-CTLA4 Monoclonal Antibody BMS-986218") )
        setattr(cls, "PDK1 Inhibitor AR-12",
                PermissibleValue(text="PDK1 Inhibitor AR-12") )
        setattr(cls, "Anti-A33 Monoclonal Antibody KRN330",
                PermissibleValue(text="Anti-A33 Monoclonal Antibody KRN330") )
        setattr(cls, "PI3K-gamma Inhibitor IPI-549",
                PermissibleValue(text="PI3K-gamma Inhibitor IPI-549") )
        setattr(cls, "Ingenol Mebutate",
                PermissibleValue(text="Ingenol Mebutate") )
        setattr(cls, "Anti-CEA/Anti-HSG Bispecific Monoclonal Antibody TF2",
                PermissibleValue(text="Anti-CEA/Anti-HSG Bispecific Monoclonal Antibody TF2") )
        setattr(cls, "PRMT5 Inhibitor PRT811",
                PermissibleValue(text="PRMT5 Inhibitor PRT811") )
        setattr(cls, "Anti-PD-L1 Monoclonal Antibody MSB2311",
                PermissibleValue(text="Anti-PD-L1 Monoclonal Antibody MSB2311") )
        setattr(cls, "ALK Inhibitor",
                PermissibleValue(text="ALK Inhibitor") )
        setattr(cls, "Oncolytic Virus ASP9801",
                PermissibleValue(text="Oncolytic Virus ASP9801") )
        setattr(cls, "Anti-ICOS Monoclonal Antibody KY1044",
                PermissibleValue(text="Anti-ICOS Monoclonal Antibody KY1044") )
        setattr(cls, "Autologous Clonal Neoantigen T Cells ATL001",
                PermissibleValue(text="Autologous Clonal Neoantigen T Cells ATL001") )
        setattr(cls, "Monoclonal T-cell Receptor Anti-CD3 scFv Fusion Protein IMCgp100",
                PermissibleValue(text="Monoclonal T-cell Receptor Anti-CD3 scFv Fusion Protein IMCgp100") )
        setattr(cls, "7-Cyanoquinocarcinol",
                PermissibleValue(text="7-Cyanoquinocarcinol") )
        setattr(cls, "Anti-FAP/Interleukin-2 Fusion Protein RO6874281",
                PermissibleValue(text="Anti-FAP/Interleukin-2 Fusion Protein RO6874281") )
        setattr(cls, "PH20 Hyaluronidase-expressing Adenovirus VCN-01",
                PermissibleValue(text="PH20 Hyaluronidase-expressing Adenovirus VCN-01") )
        setattr(cls, "Iodine I 131 Monoclonal Antibody G-250",
                PermissibleValue(text="Iodine I 131 Monoclonal Antibody G-250") )
        setattr(cls, "Bispecific Antibody MDX-H210",
                PermissibleValue(text="Bispecific Antibody MDX-H210") )
        setattr(cls, "Anti-CD33 Monoclonal Antibody-DM4 Conjugate AVE9633",
                PermissibleValue(text="Anti-CD33 Monoclonal Antibody-DM4 Conjugate AVE9633") )
        setattr(cls, "Yttrium Y 90 Resin Microspheres",
                PermissibleValue(text="Yttrium Y 90 Resin Microspheres") )
        setattr(cls, "Anhydrous Enol-oxaloacetate",
                PermissibleValue(text="Anhydrous Enol-oxaloacetate") )
        setattr(cls, "V930 Vaccine",
                PermissibleValue(text="V930 Vaccine") )
        setattr(cls, "Amuvatinib Hydrochloride",
                PermissibleValue(text="Amuvatinib Hydrochloride") )
        setattr(cls, "MEK Inhibitor PD0325901",
                PermissibleValue(text="MEK Inhibitor PD0325901") )
        setattr(cls, "Anti-CD70 Antibody-Drug Conjugate MDX-1203",
                PermissibleValue(text="Anti-CD70 Antibody-Drug Conjugate MDX-1203") )
        setattr(cls, "Sialyl Tn Antigen",
                PermissibleValue(text="Sialyl Tn Antigen") )
        setattr(cls, "Cedazuridine/Azacitidine Combination Agent ASTX030",
                PermissibleValue(text="Cedazuridine/Azacitidine Combination Agent ASTX030") )
        setattr(cls, "Cyclophosphamide Anhydrous",
                PermissibleValue(text="Cyclophosphamide Anhydrous") )
        setattr(cls, "Anti-HER2 Bi-specific Monoclonal Antibody ZW25",
                PermissibleValue(text="Anti-HER2 Bi-specific Monoclonal Antibody ZW25") )
        setattr(cls, "CAIX Inhibitor SLC-0111",
                PermissibleValue(text="CAIX Inhibitor SLC-0111") )
        setattr(cls, "Monoclonal Antibody 81C6",
                PermissibleValue(text="Monoclonal Antibody 81C6") )
        setattr(cls, "Integrin Receptor Antagonist GLPG0187",
                PermissibleValue(text="Integrin Receptor Antagonist GLPG0187") )
        setattr(cls, "Anti-CD123 x Anti-CD3 Bispecific Antibody XmAb1404",
                PermissibleValue(text="Anti-CD123 x Anti-CD3 Bispecific Antibody XmAb1404") )
        setattr(cls, "FLT3/KIT Kinase Inhibitor AKN-028",
                PermissibleValue(text="FLT3/KIT Kinase Inhibitor AKN-028") )
        setattr(cls, "PIM Kinase Inhibitor TP-3654",
                PermissibleValue(text="PIM Kinase Inhibitor TP-3654") )
        setattr(cls, "FLT3 Inhibitor FF-10101 Succinate",
                PermissibleValue(text="FLT3 Inhibitor FF-10101 Succinate") )
        setattr(cls, "Anti-CTLA-4 Probody BMS-986288",
                PermissibleValue(text="Anti-CTLA-4 Probody BMS-986288") )
        setattr(cls, "Rebastinib Tosylate",
                PermissibleValue(text="Rebastinib Tosylate") )
        setattr(cls, "Rituximab Conjugate CON-4619",
                PermissibleValue(text="Rituximab Conjugate CON-4619") )
        setattr(cls, "Anti-CD73 Monoclonal Antibody TJ4309",
                PermissibleValue(text="Anti-CD73 Monoclonal Antibody TJ4309") )
        setattr(cls, "Polysialic Acid",
                PermissibleValue(text="Polysialic Acid") )
        setattr(cls, "Selective Estrogen Receptor Modulator CC-8490",
                PermissibleValue(text="Selective Estrogen Receptor Modulator CC-8490") )
        setattr(cls, "BMI1 Inhibitor PTC596",
                PermissibleValue(text="BMI1 Inhibitor PTC596") )
        setattr(cls, "S1P Receptor Agonist KRP203",
                PermissibleValue(text="S1P Receptor Agonist KRP203") )
        setattr(cls, "G-Quadruplex Stabilizer BMVC",
                PermissibleValue(text="G-Quadruplex Stabilizer BMVC") )
        setattr(cls, "Src/tubulin Inhibitor KX02",
                PermissibleValue(text="Src/tubulin Inhibitor KX02") )
        setattr(cls, "ER alpha Proteolysis-targeting Chimera Protein Degrader ARV-471",
                PermissibleValue(text="ER alpha Proteolysis-targeting Chimera Protein Degrader ARV-471") )
        setattr(cls, "2-Hydroxyoleic Acid",
                PermissibleValue(text="2-Hydroxyoleic Acid") )
        setattr(cls, "XBP1-US/XBP1-SP/CD138/CS1 Multipeptide Vaccine PVX-410",
                PermissibleValue(text="XBP1-US/XBP1-SP/CD138/CS1 Multipeptide Vaccine PVX-410") )
        setattr(cls, "iPSC-derived CD16/IL-15RF-expressing Anti-CD19 CAR-NK Cells FT596",
                PermissibleValue(text="iPSC-derived CD16/IL-15RF-expressing Anti-CD19 CAR-NK Cells FT596") )
        setattr(cls, "S-equol",
                PermissibleValue(text="S-equol") )
        setattr(cls, "Mcl-1 Inhibitor MIK665",
                PermissibleValue(text="Mcl-1 Inhibitor MIK665") )
        setattr(cls, "Betulinic Acid",
                PermissibleValue(text="Betulinic Acid") )
        setattr(cls, "Tubulin Inhibitor ALB-109564",
                PermissibleValue(text="Tubulin Inhibitor ALB-109564") )
        setattr(cls, "FGFR4 Inhibitor BLU 9931",
                PermissibleValue(text="FGFR4 Inhibitor BLU 9931") )
        setattr(cls, "Inactivated Oncolytic Virus Particle GEN0101",
                PermissibleValue(text="Inactivated Oncolytic Virus Particle GEN0101") )
        setattr(cls, "PIM Kinase Inhibitor SGI-1776",
                PermissibleValue(text="PIM Kinase Inhibitor SGI-1776") )
        setattr(cls, "Idronoxil Suppository NOX66",
                PermissibleValue(text="Idronoxil Suppository NOX66") )
        setattr(cls, "Anti-PD-1/CD47 Infusion Protein HX009",
                PermissibleValue(text="Anti-PD-1/CD47 Infusion Protein HX009") )
        setattr(cls, "Recombinant Interferon Beta",
                PermissibleValue(text="Recombinant Interferon Beta") )
        setattr(cls, "Anti-HER2 Bispecific Antibody-drug Conjugate ZW49",
                PermissibleValue(text="Anti-HER2 Bispecific Antibody-drug Conjugate ZW49") )
        setattr(cls, "Apoptosis Inducer GCS-100",
                PermissibleValue(text="Apoptosis Inducer GCS-100") )
        setattr(cls, "FGFR Inhibitor Debio 1347",
                PermissibleValue(text="FGFR Inhibitor Debio 1347") )
        setattr(cls, "BCG Solution",
                PermissibleValue(text="BCG Solution") )
        setattr(cls, "Neoantigen-based Glioblastoma Vaccine",
                PermissibleValue(text="Neoantigen-based Glioblastoma Vaccine") )
        setattr(cls, "Pirarubicin Hydrochloride",
                PermissibleValue(text="Pirarubicin Hydrochloride") )
        setattr(cls, "Chk1 Inhibitor GDC-0425",
                PermissibleValue(text="Chk1 Inhibitor GDC-0425") )
        setattr(cls, "Polyethylene Glycol Recombinant Endostatin",
                PermissibleValue(text="Polyethylene Glycol Recombinant Endostatin") )
        setattr(cls, "Anti-CD19 Monoclonal Antibody MDX-1342",
                PermissibleValue(text="Anti-CD19 Monoclonal Antibody MDX-1342") )
        setattr(cls, "Nanoscale Coordination Polymer Nanoparticles CPI-100",
                PermissibleValue(text="Nanoscale Coordination Polymer Nanoparticles CPI-100") )
        setattr(cls, "Triptorelin Pamoate",
                PermissibleValue(text="Triptorelin Pamoate") )
        setattr(cls, "Corticorelin Acetate",
                PermissibleValue(text="Corticorelin Acetate") )
        setattr(cls, "MEK 1/2 Inhibitor AS703988/MSC2015103B",
                PermissibleValue(text="MEK 1/2 Inhibitor AS703988/MSC2015103B") )
        setattr(cls, "Bcl-2 Inhibitor S65487",
                PermissibleValue(text="Bcl-2 Inhibitor S65487") )
        setattr(cls, "JAK2 Inhibitor BMS-911543",
                PermissibleValue(text="JAK2 Inhibitor BMS-911543") )
        setattr(cls, "Naptumomab Estafenatox",
                PermissibleValue(text="Naptumomab Estafenatox") )
        setattr(cls, "Radium Ra 224-labeled Calcium Carbonate Microparticles",
                PermissibleValue(text="Radium Ra 224-labeled Calcium Carbonate Microparticles") )
        setattr(cls, "DR5-targeting Tetrameric Nanobody Agonist TAS266",
                PermissibleValue(text="DR5-targeting Tetrameric Nanobody Agonist TAS266") )
        setattr(cls, "Ursolic Acid",
                PermissibleValue(text="Ursolic Acid") )
        setattr(cls, "Botanical Agent LEAC-102",
                PermissibleValue(text="Botanical Agent LEAC-102") )
        setattr(cls, "Liposome-encapsulated RB94 Plasmid DNA Gene Therapy Agent SGT-94",
                PermissibleValue(text="Liposome-encapsulated RB94 Plasmid DNA Gene Therapy Agent SGT-94") )
        setattr(cls, "PSA/PSMA DNA Plasmid INO-5150",
                PermissibleValue(text="PSA/PSMA DNA Plasmid INO-5150") )
        setattr(cls, "Nanocell-encapsulated miR-16-based microRNA Mimic",
                PermissibleValue(text="Nanocell-encapsulated miR-16-based microRNA Mimic") )
        setattr(cls, "hTERT Vaccine V934/V935",
                PermissibleValue(text="hTERT Vaccine V934/V935") )
        setattr(cls, "Survivin mRNA Antagonist EZN-3042",
                PermissibleValue(text="Survivin mRNA Antagonist EZN-3042") )
        setattr(cls, "Recombinant Interferon",
                PermissibleValue(text="Recombinant Interferon") )
        setattr(cls, "Hsp90 Inhibitor BIIB021",
                PermissibleValue(text="Hsp90 Inhibitor BIIB021") )
        setattr(cls, "Anti-c-Met Antibody-drug Conjugate TR1801",
                PermissibleValue(text="Anti-c-Met Antibody-drug Conjugate TR1801") )
        setattr(cls, "PI3K Alpha/Beta Inhibitor BAY1082439",
                PermissibleValue(text="PI3K Alpha/Beta Inhibitor BAY1082439") )
        setattr(cls, "Aurora B Serine/Threonine Kinase Inhibitor TAK-901",
                PermissibleValue(text="Aurora B Serine/Threonine Kinase Inhibitor TAK-901") )
        setattr(cls, "Autologous Anti-CD19 CAR TCR-zeta/4-1BB-transduced T-lymphocytes huCART19",
                PermissibleValue(text="Autologous Anti-CD19 CAR TCR-zeta/4-1BB-transduced T-lymphocytes huCART19") )
        setattr(cls, "dUTPase/DPD Inhibitor TAS-114",
                PermissibleValue(text="dUTPase/DPD Inhibitor TAS-114") )
        setattr(cls, "BET Inhibitor GSK2820151",
                PermissibleValue(text="BET Inhibitor GSK2820151") )
        setattr(cls, "Mitomycin B",
                PermissibleValue(text="Mitomycin B") )
        setattr(cls, "Autologous B-cell/Monocyte-presenting HER2/neu Antigen Vaccine BVAC-B",
                PermissibleValue(text="Autologous B-cell/Monocyte-presenting HER2/neu Antigen Vaccine BVAC-B") )
        setattr(cls, "OX40L-expressing Oncolytic Adenovirus DNX-2440",
                PermissibleValue(text="OX40L-expressing Oncolytic Adenovirus DNX-2440") )
        setattr(cls, "Yttrium Y 90 Monoclonal Antibody B3",
                PermissibleValue(text="Yttrium Y 90 Monoclonal Antibody B3") )
        setattr(cls, "Lutetium Lu-177 Rituximab",
                PermissibleValue(text="Lutetium Lu-177 Rituximab") )
        setattr(cls, "CDK9 Inhibitor AZD4573",
                PermissibleValue(text="CDK9 Inhibitor AZD4573") )
        setattr(cls, "ALK Inhibitor TAE684",
                PermissibleValue(text="ALK Inhibitor TAE684") )
        setattr(cls, "Immediate-release Onapristone",
                PermissibleValue(text="Immediate-release Onapristone") )
        setattr(cls, "Vincristine Sulfate",
                PermissibleValue(text="Vincristine Sulfate") )
        setattr(cls, "Anti-CD3/Anti-GPRC5D Bispecific Monoclonal Antibody JNJ-64407564",
                PermissibleValue(text="Anti-CD3/Anti-GPRC5D Bispecific Monoclonal Antibody JNJ-64407564") )
        setattr(cls, "Autologous Bispecific CD19/CD22-targeted CAR-T Cells GC022",
                PermissibleValue(text="Autologous Bispecific CD19/CD22-targeted CAR-T Cells GC022") )
        setattr(cls, "Liposomal Irinotecan",
                PermissibleValue(text="Liposomal Irinotecan") )
        setattr(cls, "Anti-TGF-beta RII Monoclonal Antibody IMC-TR1",
                PermissibleValue(text="Anti-TGF-beta RII Monoclonal Antibody IMC-TR1") )
        setattr(cls, "Pegylated Paclitaxel",
                PermissibleValue(text="Pegylated Paclitaxel") )
        setattr(cls, "Anti-CD137 Agonistic Monoclonal Antibody AGEN2373",
                PermissibleValue(text="Anti-CD137 Agonistic Monoclonal Antibody AGEN2373") )
        setattr(cls, "Polo-like Kinase 4 Inhibitor CFI-400945 Fumarate",
                PermissibleValue(text="Polo-like Kinase 4 Inhibitor CFI-400945 Fumarate") )
        setattr(cls, "Anti-PD-1 Monoclonal Antibody LZM009",
                PermissibleValue(text="Anti-PD-1 Monoclonal Antibody LZM009") )
        setattr(cls, "Nilotinib Hydrochloride Anhydrous",
                PermissibleValue(text="Nilotinib Hydrochloride Anhydrous") )
        setattr(cls, "Ropeginterferon Alfa-2B",
                PermissibleValue(text="Ropeginterferon Alfa-2B") )
        setattr(cls, "Radium Ra 223 Dichloride",
                PermissibleValue(text="Radium Ra 223 Dichloride") )
        setattr(cls, "Anti-CD20 Monoclonal Antibody B001",
                PermissibleValue(text="Anti-CD20 Monoclonal Antibody B001") )
        setattr(cls, "ALK Inhibitor ASP3026",
                PermissibleValue(text="ALK Inhibitor ASP3026") )
        setattr(cls, "Anti-IL-8 Monoclonal Antibody HuMax-IL8",
                PermissibleValue(text="Anti-IL-8 Monoclonal Antibody HuMax-IL8") )
        setattr(cls, "RAD51 Inhibitor CYT-0851",
                PermissibleValue(text="RAD51 Inhibitor CYT-0851") )
        setattr(cls, "Yttrium Y 90 Tabituximab Barzuxetan",
                PermissibleValue(text="Yttrium Y 90 Tabituximab Barzuxetan") )
        setattr(cls, "Hsp90 Antagonist KW-2478",
                PermissibleValue(text="Hsp90 Antagonist KW-2478") )
        setattr(cls, "Arabinoxylan Compound MGN3",
                PermissibleValue(text="Arabinoxylan Compound MGN3") )
        setattr(cls, "Dual-affinity B7-H3/CD3-targeted Protein MGD009",
                PermissibleValue(text="Dual-affinity B7-H3/CD3-targeted Protein MGD009") )
        setattr(cls, "Recombinant Super-compound Interferon",
                PermissibleValue(text="Recombinant Super-compound Interferon") )
        setattr(cls, "Vaccine-Sensitized Draining Lymph Node Cells",
                PermissibleValue(text="Vaccine-Sensitized Draining Lymph Node Cells") )
        setattr(cls, "Anti-HB-EGF Monoclonal Antibody KHK2866",
                PermissibleValue(text="Anti-HB-EGF Monoclonal Antibody KHK2866") )
        setattr(cls, "Tagraxofusp-erzs",
                PermissibleValue(text="Tagraxofusp-erzs") )
        setattr(cls, "Intermediate-affinity Interleukin-2 Receptor Agonist ALKS 4230",
                PermissibleValue(text="Intermediate-affinity Interleukin-2 Receptor Agonist ALKS 4230") )
        setattr(cls, "Anti-HER2 Immune Stimulator-antibody Conjugate NJH395",
                PermissibleValue(text="Anti-HER2 Immune Stimulator-antibody Conjugate NJH395") )
        setattr(cls, "Live-attenuated Double-deleted Listeria monocytogenes Bacteria JNJ-64041809",
                PermissibleValue(text="Live-attenuated Double-deleted Listeria monocytogenes Bacteria JNJ-64041809") )
        setattr(cls, "Anti-Neuropilin-1 Monoclonal Antibody MNRP1685A",
                PermissibleValue(text="Anti-Neuropilin-1 Monoclonal Antibody MNRP1685A") )
        setattr(cls, "Alpha-tocopheryloxyacetic Acid",
                PermissibleValue(text="Alpha-tocopheryloxyacetic Acid") )
        setattr(cls, "Atiprimod Dihydrochloride",
                PermissibleValue(text="Atiprimod Dihydrochloride") )
        setattr(cls, "Yttrium Y 90 Monoclonal Antibody Hu3S193",
                PermissibleValue(text="Yttrium Y 90 Monoclonal Antibody Hu3S193") )
        setattr(cls, "Lifastuzumab Vedotin",
                PermissibleValue(text="Lifastuzumab Vedotin") )
        setattr(cls, "Personalized Neoantigen DNA Vaccine GNOS-PV01",
                PermissibleValue(text="Personalized Neoantigen DNA Vaccine GNOS-PV01") )
        setattr(cls, "Palifosfamide Tromethamine",
                PermissibleValue(text="Palifosfamide Tromethamine") )
        setattr(cls, "Vaccinium myrtillus/Macleaya cordata/Echinacea angustifolia Extract Granules",
                PermissibleValue(text="Vaccinium myrtillus/Macleaya cordata/Echinacea angustifolia Extract Granules") )
        setattr(cls, "c-Met Inhibitor GST-HG161",
                PermissibleValue(text="c-Met Inhibitor GST-HG161") )
        setattr(cls, "Anti-CDH6 Antibody-drug Conjugate HKT288",
                PermissibleValue(text="Anti-CDH6 Antibody-drug Conjugate HKT288") )
        setattr(cls, "Yiqi-yangyin-jiedu Herbal Decoction",
                PermissibleValue(text="Yiqi-yangyin-jiedu Herbal Decoction") )
        setattr(cls, "AXL Inhibitor DS-1205c",
                PermissibleValue(text="AXL Inhibitor DS-1205c") )
        setattr(cls, "EP4 Antagonist INV-1120",
                PermissibleValue(text="EP4 Antagonist INV-1120") )
        setattr(cls, "Liposomal Daunorubicin Citrate",
                PermissibleValue(text="Liposomal Daunorubicin Citrate") )
        setattr(cls, "Wee1 Kinase Inhibitor Debio 0123",
                PermissibleValue(text="Wee1 Kinase Inhibitor Debio 0123") )
        setattr(cls, "Iodine I 124 Monoclonal Antibody A33",
                PermissibleValue(text="Iodine I 124 Monoclonal Antibody A33") )
        setattr(cls, "Camidanlumab Tesirine",
                PermissibleValue(text="Camidanlumab Tesirine") )
        setattr(cls, "Anti-CD19 Antibody-T-cell Receptor-expressing T-cells ET019003",
                PermissibleValue(text="Anti-CD19 Antibody-T-cell Receptor-expressing T-cells ET019003") )
        setattr(cls, "Tergenpumatucel-L",
                PermissibleValue(text="Tergenpumatucel-L") )
        setattr(cls, "HIF-2alpha Inhibitor PT2977",
                PermissibleValue(text="HIF-2alpha Inhibitor PT2977") )
        setattr(cls, "Anti-5T4 Antibody-Drug Conjugate PF-06263507",
                PermissibleValue(text="Anti-5T4 Antibody-Drug Conjugate PF-06263507") )
        setattr(cls, "Talotrexin Ammonium",
                PermissibleValue(text="Talotrexin Ammonium") )
        setattr(cls, "Trastuzumab Duocarmazine",
                PermissibleValue(text="Trastuzumab Duocarmazine") )
        setattr(cls, "DM4-Conjugated Anti-Cripto Monoclonal Antibody BIIB015",
                PermissibleValue(text="DM4-Conjugated Anti-Cripto Monoclonal Antibody BIIB015") )
        setattr(cls, "Anti-CTLA-4 Monoclonal Antibody BCD-145",
                PermissibleValue(text="Anti-CTLA-4 Monoclonal Antibody BCD-145") )
        setattr(cls, "Pexastimogene Devacirepvec",
                PermissibleValue(text="Pexastimogene Devacirepvec") )
        setattr(cls, "HPV16 L2/E6/E7 Fusion Protein Vaccine TA-CIN",
                PermissibleValue(text="HPV16 L2/E6/E7 Fusion Protein Vaccine TA-CIN") )
        setattr(cls, "Therapeutic Estradiol",
                PermissibleValue(text="Therapeutic Estradiol") )
        setattr(cls, "TRK Inhibitor AZD6918",
                PermissibleValue(text="TRK Inhibitor AZD6918") )
        setattr(cls, "Anti-CD40/Anti-4-1BB Bispecific Agonist Monoclonal Antibody GEN1042",
                PermissibleValue(text="Anti-CD40/Anti-4-1BB Bispecific Agonist Monoclonal Antibody GEN1042") )
        setattr(cls, "Rilimogene Galvacirepvec/Rilimogene Glafolivec",
                PermissibleValue(text="Rilimogene Galvacirepvec/Rilimogene Glafolivec") )
        setattr(cls, "TLR7/8/9 Antagonist IMO-8400",
                PermissibleValue(text="TLR7/8/9 Antagonist IMO-8400") )
        setattr(cls, "Ispinesib Mesylate",
                PermissibleValue(text="Ispinesib Mesylate") )
        setattr(cls, "Sam68 Modulator CWP232291",
                PermissibleValue(text="Sam68 Modulator CWP232291") )
        setattr(cls, "Dendrimer-conjugated Bcl-2/Bcl-XL Inhibitor AZD0466",
                PermissibleValue(text="Dendrimer-conjugated Bcl-2/Bcl-XL Inhibitor AZD0466") )
        setattr(cls, "iPSC-derived Natural Killer Cells FT500",
                PermissibleValue(text="iPSC-derived Natural Killer Cells FT500") )
        setattr(cls, "FLT3 Tyrosine Kinase Inhibitor TTT-3002",
                PermissibleValue(text="FLT3 Tyrosine Kinase Inhibitor TTT-3002") )
        setattr(cls, "Telomerase Inhibitor FJ5002",
                PermissibleValue(text="Telomerase Inhibitor FJ5002") )
        setattr(cls, "MDM2 Antagonist ASTX295",
                PermissibleValue(text="MDM2 Antagonist ASTX295") )
        setattr(cls, "c-Met Inhibitor MSC2156119J",
                PermissibleValue(text="c-Met Inhibitor MSC2156119J") )
        setattr(cls, "Androgen Receptor Antagonist TAS3681",
                PermissibleValue(text="Androgen Receptor Antagonist TAS3681") )
        setattr(cls, "Aurora A Kinase Inhibitor LY3295668",
                PermissibleValue(text="Aurora A Kinase Inhibitor LY3295668") )
        setattr(cls, "Gastrin/cholecystokinin Type B Receptor Inhibitor Z-360",
                PermissibleValue(text="Gastrin/cholecystokinin Type B Receptor Inhibitor Z-360") )
        setattr(cls, "Pan HER/VEGFR2 Receptor Tyrosine Kinase Inhibitor BMS-690514",
                PermissibleValue(text="Pan HER/VEGFR2 Receptor Tyrosine Kinase Inhibitor BMS-690514") )
        setattr(cls, "Anti-HER2-DM1 Antibody-drug Conjugate GQ1001",
                PermissibleValue(text="Anti-HER2-DM1 Antibody-drug Conjugate GQ1001") )
        setattr(cls, "PD-L1/PD-L2/VISTA Antagonist CA-170",
                PermissibleValue(text="PD-L1/PD-L2/VISTA Antagonist CA-170") )
        setattr(cls, "PI3K-delta Inhibitor PWT143",
                PermissibleValue(text="PI3K-delta Inhibitor PWT143") )
        setattr(cls, "LMP-2:419-427 Peptide Vaccine",
                PermissibleValue(text="LMP-2:419-427 Peptide Vaccine") )
        setattr(cls, "Anti-OX40 Agonist Monoclonal Antibody ABBV-368",
                PermissibleValue(text="Anti-OX40 Agonist Monoclonal Antibody ABBV-368") )
        setattr(cls, "Anti-DKK1 Monoclonal Antibody BHQ880",
                PermissibleValue(text="Anti-DKK1 Monoclonal Antibody BHQ880") )
        setattr(cls, "Palladium Pd-103",
                PermissibleValue(text="Palladium Pd-103") )
        setattr(cls, "Autologous Anti-CD19/CD20 Bispecific Nanobody-based CAR-T cells",
                PermissibleValue(text="Autologous Anti-CD19/CD20 Bispecific Nanobody-based CAR-T cells") )
        setattr(cls, "pan-PIM Kinase Inhibitor NVP-LGB-321",
                PermissibleValue(text="pan-PIM Kinase Inhibitor NVP-LGB-321") )
        setattr(cls, "Ibandronate Sodium",
                PermissibleValue(text="Ibandronate Sodium") )
        setattr(cls, "Wobe-Mugos E",
                PermissibleValue(text="Wobe-Mugos E") )
        setattr(cls, "Ixazomib Citrate",
                PermissibleValue(text="Ixazomib Citrate") )
        setattr(cls, "Anti-CD137 Agonistic Monoclonal Antibody ADG106",
                PermissibleValue(text="Anti-CD137 Agonistic Monoclonal Antibody ADG106") )
        setattr(cls, "HDAC/EGFR/HER2 Inhibitor CUDC-101",
                PermissibleValue(text="HDAC/EGFR/HER2 Inhibitor CUDC-101") )
        setattr(cls, "Autologous Anti-CD22 CAR-4-1BB-TCRz-transduced T-lymphocytes CART22-65s",
                PermissibleValue(text="Autologous Anti-CD22 CAR-4-1BB-TCRz-transduced T-lymphocytes CART22-65s") )
        setattr(cls, "Autologous NKG2D CAR-CD3zeta-DAP10-expressing T-Lymphocytes CYAD-01",
                PermissibleValue(text="Autologous NKG2D CAR-CD3zeta-DAP10-expressing T-Lymphocytes CYAD-01") )
        setattr(cls, "Iobenguane I-131",
                PermissibleValue(text="Iobenguane I-131") )
        setattr(cls, "Adenosine A2A Receptor Antagonist CS3005",
                PermissibleValue(text="Adenosine A2A Receptor Antagonist CS3005") )
        setattr(cls, "Interferon-gamma-expressing Adenovirus Vaccine ASN-002",
                PermissibleValue(text="Interferon-gamma-expressing Adenovirus Vaccine ASN-002") )
        setattr(cls, "Oncolytic HSV-1 C134",
                PermissibleValue(text="Oncolytic HSV-1 C134") )
        setattr(cls, "Macrocycle-bridged STING Agonist E7766",
                PermissibleValue(text="Macrocycle-bridged STING Agonist E7766") )
        setattr(cls, "Flumatinib Mesylate",
                PermissibleValue(text="Flumatinib Mesylate") )
        setattr(cls, "Monoclonal Antibody HeFi-1",
                PermissibleValue(text="Monoclonal Antibody HeFi-1") )
        setattr(cls, "Antibody-drug Conjugate ABBV-155",
                PermissibleValue(text="Antibody-drug Conjugate ABBV-155") )
        setattr(cls, "FASN Inhibitor TVB-2640",
                PermissibleValue(text="FASN Inhibitor TVB-2640") )
        setattr(cls, "Anti-CLEVER-1 Monoclonal Antibody FP-1305",
                PermissibleValue(text="Anti-CLEVER-1 Monoclonal Antibody FP-1305") )
        setattr(cls, "Lapatinib Ditosylate",
                PermissibleValue(text="Lapatinib Ditosylate") )
        setattr(cls, "Aerosolized Liposomal Rubitecan",
                PermissibleValue(text="Aerosolized Liposomal Rubitecan") )
        setattr(cls, "Autologous Heat-Shock Protein 70 Peptide Vaccine AG-858",
                PermissibleValue(text="Autologous Heat-Shock Protein 70 Peptide Vaccine AG-858") )
        setattr(cls, "Dihydroorotate Dehydrogenase Inhibitor AG-636",
                PermissibleValue(text="Dihydroorotate Dehydrogenase Inhibitor AG-636") )
        setattr(cls, "ATR Kinase Inhibitor M6620",
                PermissibleValue(text="ATR Kinase Inhibitor M6620") )
        setattr(cls, "Recombinant Interferon Alfa",
                PermissibleValue(text="Recombinant Interferon Alfa") )
        setattr(cls, "Paclitaxel Liposome",
                PermissibleValue(text="Paclitaxel Liposome") )
        setattr(cls, "PD-L1 Inhibitor GS-4224",
                PermissibleValue(text="PD-L1 Inhibitor GS-4224") )
        setattr(cls, "Cergutuzumab Amunaleukin",
                PermissibleValue(text="Cergutuzumab Amunaleukin") )
        setattr(cls, "Synthetic hTERT DNA Vaccine INO-1400",
                PermissibleValue(text="Synthetic hTERT DNA Vaccine INO-1400") )
        setattr(cls, "CAR T-Cells AMG 119",
                PermissibleValue(text="CAR T-Cells AMG 119") )
        setattr(cls, "LRP5/6 Antagonist BI 905677",
                PermissibleValue(text="LRP5/6 Antagonist BI 905677") )
        setattr(cls, "Telaglenastat Hydrochloride",
                PermissibleValue(text="Telaglenastat Hydrochloride") )
        setattr(cls, "Cevipabulin Succinate",
                PermissibleValue(text="Cevipabulin Succinate") )
        setattr(cls, "Anti-CD137 Agonistic Monoclonal Antibody CTX-471",
                PermissibleValue(text="Anti-CD137 Agonistic Monoclonal Antibody CTX-471") )
        setattr(cls, "Survivin-expressing CVD908ssb-TXSVN Vaccine",
                PermissibleValue(text="Survivin-expressing CVD908ssb-TXSVN Vaccine") )
        setattr(cls, "Yttrium Y 90-DOTA-di-HSG Peptide IMP-288",
                PermissibleValue(text="Yttrium Y 90-DOTA-di-HSG Peptide IMP-288") )
        setattr(cls, "Molibresib Besylate",
                PermissibleValue(text="Molibresib Besylate") )
        setattr(cls, "OPCs/Green Tea/Spirullina/Curcumin/Antrodia Camphorate/Fermented Soymilk Extract Capsule",
                PermissibleValue(text="OPCs/Green Tea/Spirullina/Curcumin/Antrodia Camphorate/Fermented Soymilk Extract Capsule") )
        setattr(cls, "Deoxycytidine Analogue TAS-109 Hydrochloride",
                PermissibleValue(text="Deoxycytidine Analogue TAS-109 Hydrochloride") )
        setattr(cls, "Nogapendekin Alfa",
                PermissibleValue(text="Nogapendekin Alfa") )
        setattr(cls, "Anti-LIV-1 Monoclonal Antibody-MMAE Conjugate SGN-LIV1A",
                PermissibleValue(text="Anti-LIV-1 Monoclonal Antibody-MMAE Conjugate SGN-LIV1A") )
        setattr(cls, "Anti-B7-H3/DXd Antibody-drug Conjugate DS-7300a",
                PermissibleValue(text="Anti-B7-H3/DXd Antibody-drug Conjugate DS-7300a") )
        setattr(cls, "PI3K-beta Inhibitor SAR260301",
                PermissibleValue(text="PI3K-beta Inhibitor SAR260301") )
        setattr(cls, "Anti-PD-1 Monoclonal Antibody HX008",
                PermissibleValue(text="Anti-PD-1 Monoclonal Antibody HX008") )
        setattr(cls, "Pemlimogene Merolisbac",
                PermissibleValue(text="Pemlimogene Merolisbac") )
        setattr(cls, "ERK Inhibitor GDC-0994",
                PermissibleValue(text="ERK Inhibitor GDC-0994") )
        setattr(cls, "Anti-alpha BCMA/Anti-alpha CD3 T-cell Engaging Bispecific Antibody TNB-383B",
                PermissibleValue(text="Anti-alpha BCMA/Anti-alpha CD3 T-cell Engaging Bispecific Antibody TNB-383B") )
        setattr(cls, "Anti-TIGIT Monoclonal Antibody SGN-TGT",
                PermissibleValue(text="Anti-TIGIT Monoclonal Antibody SGN-TGT") )
        setattr(cls, "BMS-275183",
                PermissibleValue(text="BMS-275183") )
        setattr(cls, "HER2-targeting Antibody Fc Fragment FS102",
                PermissibleValue(text="HER2-targeting Antibody Fc Fragment FS102") )
        setattr(cls, "Opioid Growth Factor",
                PermissibleValue(text="Opioid Growth Factor") )
        setattr(cls, "Lutetium Lu 177 DOTA-N3-CTT1403",
                PermissibleValue(text="Lutetium Lu 177 DOTA-N3-CTT1403") )
        setattr(cls, "p70S6K/Akt Inhibitor MSC2363318A",
                PermissibleValue(text="p70S6K/Akt Inhibitor MSC2363318A") )
        setattr(cls, "DI-Leu16-IL2 Immunocytokine",
                PermissibleValue(text="DI-Leu16-IL2 Immunocytokine") )
        setattr(cls, "Hsp90 Inhibitor XL888",
                PermissibleValue(text="Hsp90 Inhibitor XL888") )
        setattr(cls, "Allovectin-7",
                PermissibleValue(text="Allovectin-7") )
        setattr(cls, "Interferon Beta-1A",
                PermissibleValue(text="Interferon Beta-1A") )
        setattr(cls, "Pan-IDH Mutant Inhibitor AG-881",
                PermissibleValue(text="Pan-IDH Mutant Inhibitor AG-881") )
        setattr(cls, "Bleomycin Sulfate",
                PermissibleValue(text="Bleomycin Sulfate") )
        setattr(cls, "Bizalimogene Ralaplasmid",
                PermissibleValue(text="Bizalimogene Ralaplasmid") )
        setattr(cls, "Therapeutic Hydrocortisone",
                PermissibleValue(text="Therapeutic Hydrocortisone") )
        setattr(cls, "Antibody-drug Conjugate SC-004",
                PermissibleValue(text="Antibody-drug Conjugate SC-004") )
        setattr(cls, "Camptothecin Sodium",
                PermissibleValue(text="Camptothecin Sodium") )
        setattr(cls, "SIRPa-IgG4-Fc Fusion Protein TTI-622",
                PermissibleValue(text="SIRPa-IgG4-Fc Fusion Protein TTI-622") )
        setattr(cls, "Anti-TIGIT Monoclonal Antibody COM902",
                PermissibleValue(text="Anti-TIGIT Monoclonal Antibody COM902") )
        setattr(cls, "Anti-CD38-targeted IgG4-attenuated IFNa TAK-573",
                PermissibleValue(text="Anti-CD38-targeted IgG4-attenuated IFNa TAK-573") )
        setattr(cls, "BRAF/EGFR Inhibitor BGB-283",
                PermissibleValue(text="BRAF/EGFR Inhibitor BGB-283") )
        setattr(cls, "LSD1 Inhibitor RO7051790",
                PermissibleValue(text="LSD1 Inhibitor RO7051790") )
        setattr(cls, "ATR Kinase Inhibitor VX-803",
                PermissibleValue(text="ATR Kinase Inhibitor VX-803") )
        setattr(cls, "Pegylated Recombinant Human Arginase I BCT-100",
                PermissibleValue(text="Pegylated Recombinant Human Arginase I BCT-100") )
        setattr(cls, "Anti-CA19-9 Monoclonal Antibody 5B1",
                PermissibleValue(text="Anti-CA19-9 Monoclonal Antibody 5B1") )
        setattr(cls, "Anti-TIM-3 Monoclonal Antibody MBG453",
                PermissibleValue(text="Anti-TIM-3 Monoclonal Antibody MBG453") )
        setattr(cls, "Total Androgen Blockade",
                PermissibleValue(text="Total Androgen Blockade") )
        setattr(cls, "CD47 Antagonist ALX148",
                PermissibleValue(text="CD47 Antagonist ALX148") )
        setattr(cls, "c-Met Inhibitor AL2846",
                PermissibleValue(text="c-Met Inhibitor AL2846") )
        setattr(cls, "Arginase Inhibitor INCB001158",
                PermissibleValue(text="Arginase Inhibitor INCB001158") )
        setattr(cls, "Daunorubicin Hydrochloride",
                PermissibleValue(text="Daunorubicin Hydrochloride") )
        setattr(cls, "GSK-3 Inhibitor LY2090314",
                PermissibleValue(text="GSK-3 Inhibitor LY2090314") )
        setattr(cls, "IDO1/TDO2 Inhibitor DN1406131",
                PermissibleValue(text="IDO1/TDO2 Inhibitor DN1406131") )
        setattr(cls, "Rigosertib Sodium",
                PermissibleValue(text="Rigosertib Sodium") )
        setattr(cls, "P-p68 Inhibitor RX-5902",
                PermissibleValue(text="P-p68 Inhibitor RX-5902") )
        setattr(cls, "LSD1 Inhibitor CC-90011",
                PermissibleValue(text="LSD1 Inhibitor CC-90011") )
        setattr(cls, "Anti-Nucleolin Aptamer AS1411",
                PermissibleValue(text="Anti-Nucleolin Aptamer AS1411") )
        setattr(cls, "Allogeneic Large Multivalent Immunogen Melanoma Vaccine LP2307",
                PermissibleValue(text="Allogeneic Large Multivalent Immunogen Melanoma Vaccine LP2307") )
        setattr(cls, "CENP-E Inhibitor GSK-923295",
                PermissibleValue(text="CENP-E Inhibitor GSK-923295") )
        setattr(cls, "Indusatumab Vedotin",
                PermissibleValue(text="Indusatumab Vedotin") )
        setattr(cls, "Trastuzumab Conjugate BI-CON-02",
                PermissibleValue(text="Trastuzumab Conjugate BI-CON-02") )
        setattr(cls, "Phosphaplatin PT-112",
                PermissibleValue(text="Phosphaplatin PT-112") )
        setattr(cls, "Allogeneic Anti-BCMA CAR-transduced T-cells ALLO-715",
                PermissibleValue(text="Allogeneic Anti-BCMA CAR-transduced T-cells ALLO-715") )
        setattr(cls, "Picrasinoside H",
                PermissibleValue(text="Picrasinoside H") )
        setattr(cls, "At 211 Monoclonal Antibody 81C6",
                PermissibleValue(text="At 211 Monoclonal Antibody 81C6") )
        setattr(cls, "Light-activated AU-011",
                PermissibleValue(text="Light-activated AU-011") )
        setattr(cls, "ATM Kinase Inhibitor AZD1390",
                PermissibleValue(text="ATM Kinase Inhibitor AZD1390") )
        setattr(cls, "Crystalline Genistein Formulation AXP107-11",
                PermissibleValue(text="Crystalline Genistein Formulation AXP107-11") )
        setattr(cls, "Cyclodextrin-Based Polymer-Camptothecin CRLX101",
                PermissibleValue(text="Cyclodextrin-Based Polymer-Camptothecin CRLX101") )
        setattr(cls, "cFMS Tyrosine Kinase Inhibitor ARRY-382",
                PermissibleValue(text="cFMS Tyrosine Kinase Inhibitor ARRY-382") )
        setattr(cls, "Gold Sodium Thiomalate",
                PermissibleValue(text="Gold Sodium Thiomalate") )
        setattr(cls, "Anti-CSF1R Monoclonal Antibody SNDX-6352",
                PermissibleValue(text="Anti-CSF1R Monoclonal Antibody SNDX-6352") )
        setattr(cls, "p53-HDM2 Protein-protein Interaction Inhibitor APG-115",
                PermissibleValue(text="p53-HDM2 Protein-protein Interaction Inhibitor APG-115") )
        setattr(cls, "Cetuximab Sarotalocan",
                PermissibleValue(text="Cetuximab Sarotalocan") )
        setattr(cls, "SIRPa-4-1BBL Fusion Protein DSP107",
                PermissibleValue(text="SIRPa-4-1BBL Fusion Protein DSP107") )
        setattr(cls, "Artemether Sublingual Spray",
                PermissibleValue(text="Artemether Sublingual Spray") )
        setattr(cls, "DNMT1 Inhibitor NTX-301",
                PermissibleValue(text="DNMT1 Inhibitor NTX-301") )
        setattr(cls, "Adenoviral Tumor-specific Neoantigen Priming Vaccine GRT-C901",
                PermissibleValue(text="Adenoviral Tumor-specific Neoantigen Priming Vaccine GRT-C901") )
        setattr(cls, "I 131 Monoclonal Antibody CC49",
                PermissibleValue(text="I 131 Monoclonal Antibody CC49") )
        setattr(cls, "Shared Anti-Idiotype-AB-S024A",
                PermissibleValue(text="Shared Anti-Idiotype-AB-S024A") )
        setattr(cls, "Docetaxel-loaded Nanopharmaceutical CRLX301",
                PermissibleValue(text="Docetaxel-loaded Nanopharmaceutical CRLX301") )
        setattr(cls, "Gamma-Secretase Inhibitor RO4929097",
                PermissibleValue(text="Gamma-Secretase Inhibitor RO4929097") )
        setattr(cls, "CAIX Inhibitor DTP348",
                PermissibleValue(text="CAIX Inhibitor DTP348") )
        setattr(cls, "Antibody-drug Conjugate ABBV-176",
                PermissibleValue(text="Antibody-drug Conjugate ABBV-176") )
        setattr(cls, "Anti-CD22 ADC TRPH-222",
                PermissibleValue(text="Anti-CD22 ADC TRPH-222") )
        setattr(cls, "Glutaminase Inhibitor CB-839",
                PermissibleValue(text="Glutaminase Inhibitor CB-839") )
        setattr(cls, "FAP/4-1BB-targeting Fusion Protein RO7122290",
                PermissibleValue(text="FAP/4-1BB-targeting Fusion Protein RO7122290") )
        setattr(cls, "Anti-PKN3 siRNA Atu027",
                PermissibleValue(text="Anti-PKN3 siRNA Atu027") )
        setattr(cls, "Tris-acryl Gelatin Microspheres",
                PermissibleValue(text="Tris-acryl Gelatin Microspheres") )
        setattr(cls, "Allogeneic Melanoma Vaccine AGI-101H",
                PermissibleValue(text="Allogeneic Melanoma Vaccine AGI-101H") )
        setattr(cls, "RAF Kinase Inhibitor XL281",
                PermissibleValue(text="RAF Kinase Inhibitor XL281") )
        setattr(cls, "Lutetium Lu-177 Girentuximab",
                PermissibleValue(text="Lutetium Lu-177 Girentuximab") )
        setattr(cls, "Fascin Inhibitor NP-G2-044",
                PermissibleValue(text="Fascin Inhibitor NP-G2-044") )
        setattr(cls, "Pyridyl Cyanoguanidine CHS 828",
                PermissibleValue(text="Pyridyl Cyanoguanidine CHS 828") )
        setattr(cls, "Autologous Anti-BCMA CAR T-cells PHE885",
                PermissibleValue(text="Autologous Anti-BCMA CAR T-cells PHE885") )
        setattr(cls, "HDAC Inhibitor AR-42",
                PermissibleValue(text="HDAC Inhibitor AR-42") )
        setattr(cls, "Lyophilized Black Raspberry Saliva Substitute",
                PermissibleValue(text="Lyophilized Black Raspberry Saliva Substitute") )
        setattr(cls, "Anti-TROP2/DXd Antibody-drug Conjugate DS-1062a",
                PermissibleValue(text="Anti-TROP2/DXd Antibody-drug Conjugate DS-1062a") )
        setattr(cls, "Recombinant Interleukin-13",
                PermissibleValue(text="Recombinant Interleukin-13") )
        setattr(cls, "Rilimogene Glafolivec",
                PermissibleValue(text="Rilimogene Glafolivec") )
        setattr(cls, "Androgen Receptor Downregulator AZD3514",
                PermissibleValue(text="Androgen Receptor Downregulator AZD3514") )
        setattr(cls, "Ang2/VEGF-Binding Peptides-Antibody Fusion Protein CVX-241",
                PermissibleValue(text="Ang2/VEGF-Binding Peptides-Antibody Fusion Protein CVX-241") )
        setattr(cls, "Agonistic Anti-CD40 Monoclonal Antibody ADC-1013",
                PermissibleValue(text="Agonistic Anti-CD40 Monoclonal Antibody ADC-1013") )
        setattr(cls, "Anti-EGFR/CD16A Bispecific Antibody AFM24",
                PermissibleValue(text="Anti-EGFR/CD16A Bispecific Antibody AFM24") )
        setattr(cls, "Glutamine Antagonist DRP-104",
                PermissibleValue(text="Glutamine Antagonist DRP-104") )
        setattr(cls, "Chlorotoxin (EQ)-CD28-CD3zeta-CD19t-expressing CAR T-lymphocytes",
                PermissibleValue(text="Chlorotoxin (EQ)-CD28-CD3zeta-CD19t-expressing CAR T-lymphocytes") )
        setattr(cls, "Yttrium Y 90 Monoclonal Antibody BrE-3",
                PermissibleValue(text="Yttrium Y 90 Monoclonal Antibody BrE-3") )
        setattr(cls, "PARP 1/2 Inhibitor IMP4297",
                PermissibleValue(text="PARP 1/2 Inhibitor IMP4297") )
        setattr(cls, "Tyrosinase Peptide",
                PermissibleValue(text="Tyrosinase Peptide") )
        setattr(cls, "Trimethylcolchicinic Acid",
                PermissibleValue(text="Trimethylcolchicinic Acid") )
        setattr(cls, "Anti-CD33/CD3 Bispecific Antibody GEM 333",
                PermissibleValue(text="Anti-CD33/CD3 Bispecific Antibody GEM 333") )
        setattr(cls, "SHP2 Inhibitor JAB-3068",
                PermissibleValue(text="SHP2 Inhibitor JAB-3068") )
        setattr(cls, "PKA Regulatory Subunit RIalpha Mixed-Backbone Antisense Oligonucleotide GEM 231",
                PermissibleValue(text="PKA Regulatory Subunit RIalpha Mixed-Backbone Antisense Oligonucleotide GEM 231") )
        setattr(cls, "Methionine Aminopeptidase 2 Inhibitor M8891",
                PermissibleValue(text="Methionine Aminopeptidase 2 Inhibitor M8891") )
        setattr(cls, "Autologous CD19-targeted CAR T Cells JWCAR029",
                PermissibleValue(text="Autologous CD19-targeted CAR T Cells JWCAR029") )
        setattr(cls, "Limonene, (+)-",
                PermissibleValue(text="Limonene, (+)-") )
        setattr(cls, "FGFR/CSF-1R Inhibitor 3D185",
                PermissibleValue(text="FGFR/CSF-1R Inhibitor 3D185") )
        setattr(cls, "Neoantigen-HSP70 Peptide Cancer Vaccine AGEN2017",
                PermissibleValue(text="Neoantigen-HSP70 Peptide Cancer Vaccine AGEN2017") )
        setattr(cls, "Flt3/MerTK Inhibitor MRX-2843",
                PermissibleValue(text="Flt3/MerTK Inhibitor MRX-2843") )
        setattr(cls, "Antineoplastic Agent Combination SM-88",
                PermissibleValue(text="Antineoplastic Agent Combination SM-88") )
        setattr(cls, "Autologous CD19 CAR-expressing CD4+/CD8+ T-cells MB-CART19.1",
                PermissibleValue(text="Autologous CD19 CAR-expressing CD4+/CD8+ T-cells MB-CART19.1") )
        setattr(cls, "KRAS-MAPK Signaling Pathway Inhibitor JAB-3312",
                PermissibleValue(text="KRAS-MAPK Signaling Pathway Inhibitor JAB-3312") )
        setattr(cls, "Curcumin/Doxorubicin-encapsulating Nanoparticle IMX-110",
                PermissibleValue(text="Curcumin/Doxorubicin-encapsulating Nanoparticle IMX-110") )
        setattr(cls, "Combretastatin A-1",
                PermissibleValue(text="Combretastatin A-1") )
        setattr(cls, "Sorghum bicolor Supplement",
                PermissibleValue(text="Sorghum bicolor Supplement") )
        setattr(cls, "Monoclonal Antibody E2.3",
                PermissibleValue(text="Monoclonal Antibody E2.3") )
        setattr(cls, "Vesigenurtucel-L",
                PermissibleValue(text="Vesigenurtucel-L") )
        setattr(cls, "Antitumor B Key Active Component-alpha",
                PermissibleValue(text="Antitumor B Key Active Component-alpha") )
        setattr(cls, "Lutetium Lu 177 Dotatate",
                PermissibleValue(text="Lutetium Lu 177 Dotatate") )
        setattr(cls, "Pladienolide Derivative E7107",
                PermissibleValue(text="Pladienolide Derivative E7107") )
        setattr(cls, "Tyrosine Kinase Inhibitor XL228",
                PermissibleValue(text="Tyrosine Kinase Inhibitor XL228") )
        setattr(cls, "EP2/EP4 Antagonist TPST-1495",
                PermissibleValue(text="EP2/EP4 Antagonist TPST-1495") )
        setattr(cls, "Monoclonal Antibody m170",
                PermissibleValue(text="Monoclonal Antibody m170") )
        setattr(cls, "p300/CBP Bromodomain Inhibitor CCS1477",
                PermissibleValue(text="p300/CBP Bromodomain Inhibitor CCS1477") )
        setattr(cls, "Liposome-encapsulated TAAs mRNA Vaccine W_ova1",
                PermissibleValue(text="Liposome-encapsulated TAAs mRNA Vaccine W_ova1") )
        setattr(cls, "MMP Inhibitor S-3304",
                PermissibleValue(text="MMP Inhibitor S-3304") )
        setattr(cls, "Aurora A Kinase/Tyrosine Kinase Inhibitor ENMD-2076",
                PermissibleValue(text="Aurora A Kinase/Tyrosine Kinase Inhibitor ENMD-2076") )
        setattr(cls, "Rhenium Re-188 Ethiodized Oil",
                PermissibleValue(text="Rhenium Re-188 Ethiodized Oil") )
        setattr(cls, "Liposomal Docetaxel",
                PermissibleValue(text="Liposomal Docetaxel") )
        setattr(cls, "Bruceanol G",
                PermissibleValue(text="Bruceanol G") )
        setattr(cls, "Aryl Hydrocarbon Receptor Antagonist BAY2416964",
                PermissibleValue(text="Aryl Hydrocarbon Receptor Antagonist BAY2416964") )
        setattr(cls, "Polyamine Analogue SBP-101",
                PermissibleValue(text="Polyamine Analogue SBP-101") )
        setattr(cls, "Anti-Glypican 3/CD3 Bispecific Antibody ERY974",
                PermissibleValue(text="Anti-Glypican 3/CD3 Bispecific Antibody ERY974") )
        setattr(cls, "Transferrin-CRM107",
                PermissibleValue(text="Transferrin-CRM107") )
        setattr(cls, "Lutetium Lu 177 Monoclonal Antibody CC49",
                PermissibleValue(text="Lutetium Lu 177 Monoclonal Antibody CC49") )
        setattr(cls, "Docetaxel Emulsion ANX-514",
                PermissibleValue(text="Docetaxel Emulsion ANX-514") )
        setattr(cls, "huBC1-huIL12 Fusion Protein AS1409",
                PermissibleValue(text="huBC1-huIL12 Fusion Protein AS1409") )
        setattr(cls, "Lutetium Lu 177 DOTA-biotin",
                PermissibleValue(text="Lutetium Lu 177 DOTA-biotin") )
        setattr(cls, "Anti-CD19/CD3 Tetravalent Antibody AFM11",
                PermissibleValue(text="Anti-CD19/CD3 Tetravalent Antibody AFM11") )
        setattr(cls, "Globo H-DT Vaccine OBI-833",
                PermissibleValue(text="Globo H-DT Vaccine OBI-833") )
        setattr(cls, "Anti-CD38 Monoclonal Antibody TAK-079",
                PermissibleValue(text="Anti-CD38 Monoclonal Antibody TAK-079") )
        setattr(cls, "Anti-PD-1/CTLA-4 Bispecific Antibody MEDI5752",
                PermissibleValue(text="Anti-PD-1/CTLA-4 Bispecific Antibody MEDI5752") )
        setattr(cls, "Talimogene Laherparepvec",
                PermissibleValue(text="Talimogene Laherparepvec") )
        setattr(cls, "Abemaciclib Mesylate",
                PermissibleValue(text="Abemaciclib Mesylate") )
        setattr(cls, "Hsp90 Inhibitor MPC-3100",
                PermissibleValue(text="Hsp90 Inhibitor MPC-3100") )
        setattr(cls, "Lysine-specific Demethylase 1 Inhibitor INCB059872",
                PermissibleValue(text="Lysine-specific Demethylase 1 Inhibitor INCB059872") )
        setattr(cls, "Autologous Anti-CD19 CAR T-cells IM19",
                PermissibleValue(text="Autologous Anti-CD19 CAR T-cells IM19") )
        setattr(cls, "Anti-CTLA-4 Monoclonal Antibody HBM4003",
                PermissibleValue(text="Anti-CTLA-4 Monoclonal Antibody HBM4003") )
        setattr(cls, "Retrovector Encoding Mutant Anti-Cyclin G1",
                PermissibleValue(text="Retrovector Encoding Mutant Anti-Cyclin G1") )
        setattr(cls, "Aurora Kinase Inhibitor AMG 900",
                PermissibleValue(text="Aurora Kinase Inhibitor AMG 900") )
        setattr(cls, "MDM2 Inhibitor AMGMDS3",
                PermissibleValue(text="MDM2 Inhibitor AMGMDS3") )
        setattr(cls, "Sustained-release Mitomycin C Hydrogel Formulation UGN-102",
                PermissibleValue(text="Sustained-release Mitomycin C Hydrogel Formulation UGN-102") )
        setattr(cls, "c-Met Inhibitor AMG 337",
                PermissibleValue(text="c-Met Inhibitor AMG 337") )
        setattr(cls, "BMS-184476",
                PermissibleValue(text="BMS-184476") )
        setattr(cls, "Lyophilized Black Raspberry Lozenge",
                PermissibleValue(text="Lyophilized Black Raspberry Lozenge") )
        setattr(cls, "Anti-CD47/CD19 Bispecific Monoclonal Antibody TG-1801",
                PermissibleValue(text="Anti-CD47/CD19 Bispecific Monoclonal Antibody TG-1801") )
        setattr(cls, "Tyrosinase-KLH",
                PermissibleValue(text="Tyrosinase-KLH") )
        setattr(cls, "Saracatinib Difumarate",
                PermissibleValue(text="Saracatinib Difumarate") )
        setattr(cls, "Immunocytokine NHS-IL12",
                PermissibleValue(text="Immunocytokine NHS-IL12") )
        setattr(cls, "Coenzyme Q10",
                PermissibleValue(text="Coenzyme Q10") )
        setattr(cls, "O-Chloroacetylcarbamoylfumagillol",
                PermissibleValue(text="O-Chloroacetylcarbamoylfumagillol") )
        setattr(cls, "HPV6/11-targeted DNA Plasmid Vaccine INO-3107",
                PermissibleValue(text="HPV6/11-targeted DNA Plasmid Vaccine INO-3107") )
        setattr(cls, "DACH Polymer Platinate AP5346",
                PermissibleValue(text="DACH Polymer Platinate AP5346") )
        setattr(cls, "Antibody-drug Conjugate SC-005",
                PermissibleValue(text="Antibody-drug Conjugate SC-005") )
        setattr(cls, "Autologous Anti-NY-ESO-1/LAGE-1 TCR-transduced c259 T Lymphocytes GSK3377794",
                PermissibleValue(text="Autologous Anti-NY-ESO-1/LAGE-1 TCR-transduced c259 T Lymphocytes GSK3377794") )
        setattr(cls, "Anti-CD20 Monoclonal Antibody MIL62",
                PermissibleValue(text="Anti-CD20 Monoclonal Antibody MIL62") )
        setattr(cls, "c-Met Inhibitor MK2461",
                PermissibleValue(text="c-Met Inhibitor MK2461") )
        setattr(cls, "Methoxyamine Hydrochloride",
                PermissibleValue(text="Methoxyamine Hydrochloride") )
        setattr(cls, "Genetically Modified Interleukin-12 Transgene-encoding Bifidobacterium longum",
                PermissibleValue(text="Genetically Modified Interleukin-12 Transgene-encoding Bifidobacterium longum") )
        setattr(cls, "SIRPa-Fc-CD40L Fusion Protein SL-172154",
                PermissibleValue(text="SIRPa-Fc-CD40L Fusion Protein SL-172154") )
        setattr(cls, "Anti-PD-1/Anti-HER2 Bispecific Antibody IBI315",
                PermissibleValue(text="Anti-PD-1/Anti-HER2 Bispecific Antibody IBI315") )
        setattr(cls, "Hsp90 Inhibitor SNX-5422 Mesylate",
                PermissibleValue(text="Hsp90 Inhibitor SNX-5422 Mesylate") )
        setattr(cls, "Monoclonal Antibody CEP-37250/KHK2804",
                PermissibleValue(text="Monoclonal Antibody CEP-37250/KHK2804") )
        setattr(cls, "Histrelin Acetate",
                PermissibleValue(text="Histrelin Acetate") )
        setattr(cls, "Zorubicin Hydrochloride",
                PermissibleValue(text="Zorubicin Hydrochloride") )
        setattr(cls, "Multi-kinase Inhibitor XL092",
                PermissibleValue(text="Multi-kinase Inhibitor XL092") )
        setattr(cls, "Avitinib Maleate",
                PermissibleValue(text="Avitinib Maleate") )
        setattr(cls, "Anti-HER-2 Bispecific Antibody KN026",
                PermissibleValue(text="Anti-HER-2 Bispecific Antibody KN026") )
        setattr(cls, "Deoxycytidine Analogue TAS-109",
                PermissibleValue(text="Deoxycytidine Analogue TAS-109") )
        setattr(cls, "Autologous Universal CAR-expressing T-lymphocytes UniCAR02-T",
                PermissibleValue(text="Autologous Universal CAR-expressing T-lymphocytes UniCAR02-T") )
        setattr(cls, "Soy Isoflavones",
                PermissibleValue(text="Soy Isoflavones") )
        setattr(cls, "Anti-ILT4 Monoclonal Antibody MK-4830",
                PermissibleValue(text="Anti-ILT4 Monoclonal Antibody MK-4830") )
        setattr(cls, "Personalized Neoantigen Peptide Vaccine iNeo-Vac-P01",
                PermissibleValue(text="Personalized Neoantigen Peptide Vaccine iNeo-Vac-P01") )
        setattr(cls, "Autologous CD19-targeted CAR-T Cells GC007F",
                PermissibleValue(text="Autologous CD19-targeted CAR-T Cells GC007F") )
        setattr(cls, "AKT 1/2 Inhibitor BAY1125976",
                PermissibleValue(text="AKT 1/2 Inhibitor BAY1125976") )
        setattr(cls, "BCMA/CD3e Tri-specific T-cell Activating Construct HPN217",
                PermissibleValue(text="BCMA/CD3e Tri-specific T-cell Activating Construct HPN217") )
        setattr(cls, "Monoclonal Antibody huJ591",
                PermissibleValue(text="Monoclonal Antibody huJ591") )
        setattr(cls, "Topotecan Hydrochloride Liposomes",
                PermissibleValue(text="Topotecan Hydrochloride Liposomes") )
        setattr(cls, "HER-2-positive B-cell Peptide Antigen P467-DT-CRM197/Montanide Vaccine IMU-131",
                PermissibleValue(text="HER-2-positive B-cell Peptide Antigen P467-DT-CRM197/Montanide Vaccine IMU-131") )
        setattr(cls, "Ribonuclease QBI-139",
                PermissibleValue(text="Ribonuclease QBI-139") )
        setattr(cls, "Monoclonal Antibody 14G2A",
                PermissibleValue(text="Monoclonal Antibody 14G2A") )
        setattr(cls, "Receptor Tyrosine Kinase Inhibitor R1530",
                PermissibleValue(text="Receptor Tyrosine Kinase Inhibitor R1530") )
        setattr(cls, "HDM2 Inhibitor MK-8242",
                PermissibleValue(text="HDM2 Inhibitor MK-8242") )
        setattr(cls, "Cinacalcet Hydrochloride",
                PermissibleValue(text="Cinacalcet Hydrochloride") )
        setattr(cls, "PRMT1 Inhibitor GSK3368715",
                PermissibleValue(text="PRMT1 Inhibitor GSK3368715") )
        setattr(cls, "Nanoparticle Albumin-bound Thiocolchicine Dimer nab-5404",
                PermissibleValue(text="Nanoparticle Albumin-bound Thiocolchicine Dimer nab-5404") )
        setattr(cls, "Anti-AG7 Antibody Drug Conjugate AbGn-107",
                PermissibleValue(text="Anti-AG7 Antibody Drug Conjugate AbGn-107") )
        setattr(cls, "Yttrium-90 Polycarbonate Brachytherapy Plaque",
                PermissibleValue(text="Yttrium-90 Polycarbonate Brachytherapy Plaque") )
        setattr(cls, "Anti-c-MET Monoclonal Antibody LY2875358",
                PermissibleValue(text="Anti-c-MET Monoclonal Antibody LY2875358") )
        setattr(cls, "Anti-CD123/CD3 Bispecific Antibody APVO436",
                PermissibleValue(text="Anti-CD123/CD3 Bispecific Antibody APVO436") )
        setattr(cls, "Anti-HER2 Antibody-drug Conjugate DP303c",
                PermissibleValue(text="Anti-HER2 Antibody-drug Conjugate DP303c") )
        setattr(cls, "Aminoflavone Prodrug AFP464",
                PermissibleValue(text="Aminoflavone Prodrug AFP464") )
        setattr(cls, "Wnt Signaling Pathway Inhibitor SM08502",
                PermissibleValue(text="Wnt Signaling Pathway Inhibitor SM08502") )
        setattr(cls, "CD73 Inhibitor AB680",
                PermissibleValue(text="CD73 Inhibitor AB680") )
        setattr(cls, "Naratuximab Emtansine",
                PermissibleValue(text="Naratuximab Emtansine") )
        setattr(cls, "Allogeneic Anti-CD20-CAR T-cells PBCAR20A",
                PermissibleValue(text="Allogeneic Anti-CD20-CAR T-cells PBCAR20A") )
        setattr(cls, "Anti-EGFR Monoclonal Antibody GC1118",
                PermissibleValue(text="Anti-EGFR Monoclonal Antibody GC1118") )
        setattr(cls, "Anti-CD98 Monoclonal Antibody IGN523",
                PermissibleValue(text="Anti-CD98 Monoclonal Antibody IGN523") )
        setattr(cls, "Nadofaragene Firadenovec",
                PermissibleValue(text="Nadofaragene Firadenovec") )
        setattr(cls, "Anti-CD33 Monoclonal Antibody BI 836858",
                PermissibleValue(text="Anti-CD33 Monoclonal Antibody BI 836858") )
        setattr(cls, "Bruceanol H",
                PermissibleValue(text="Bruceanol H") )
        setattr(cls, "PGG Beta-Glucan",
                PermissibleValue(text="PGG Beta-Glucan") )
        setattr(cls, "Fumagillin-Derived Polymer Conjugate XMT-1107",
                PermissibleValue(text="Fumagillin-Derived Polymer Conjugate XMT-1107") )
        setattr(cls, "Doxorubicin-Eluting Beads",
                PermissibleValue(text="Doxorubicin-Eluting Beads") )
        setattr(cls, "Anti-HER2 ADC DS-8201a",
                PermissibleValue(text="Anti-HER2 ADC DS-8201a") )
        setattr(cls, "STING Agonist MK-1454",
                PermissibleValue(text="STING Agonist MK-1454") )
        setattr(cls, "Fimaporfin A",
                PermissibleValue(text="Fimaporfin A") )
        setattr(cls, "Aurora Kinase Inhibitor MLN8054",
                PermissibleValue(text="Aurora Kinase Inhibitor MLN8054") )
        setattr(cls, "Peplomycin Sulfate",
                PermissibleValue(text="Peplomycin Sulfate") )
        setattr(cls, "Shark Cartilage Extract AE-941",
                PermissibleValue(text="Shark Cartilage Extract AE-941") )
        setattr(cls, "Denileukin Diftitox",
                PermissibleValue(text="Denileukin Diftitox") )
        setattr(cls, "CDC7 Inhibitor TAK-931",
                PermissibleValue(text="CDC7 Inhibitor TAK-931") )
        setattr(cls, "Autologous Mesenchymal Stem Cells Apceth_101",
                PermissibleValue(text="Autologous Mesenchymal Stem Cells Apceth_101") )
        setattr(cls, "p97 Inhibitor CB-5339 Tosylate",
                PermissibleValue(text="p97 Inhibitor CB-5339 Tosylate") )
        setattr(cls, "Superagonist Interleukin-15:Interleukin-15 Receptor alphaSu/Fc Fusion Complex ALT-803",
                PermissibleValue(text="Superagonist Interleukin-15:Interleukin-15 Receptor alphaSu/Fc Fusion Complex ALT-803") )
        setattr(cls, "HDAC Inhibitor MPT0E028",
                PermissibleValue(text="HDAC Inhibitor MPT0E028") )
        setattr(cls, "Yangzheng Xiaoji Extract",
                PermissibleValue(text="Yangzheng Xiaoji Extract") )
        setattr(cls, "Synthetic hTERT DNA Vaccine INO-1401",
                PermissibleValue(text="Synthetic hTERT DNA Vaccine INO-1401") )
        setattr(cls, "Recombinant MIP1-alpha Variant ECI301",
                PermissibleValue(text="Recombinant MIP1-alpha Variant ECI301") )
        setattr(cls, "mRNA-based Personalized Cancer Vaccine mRNA-4157",
                PermissibleValue(text="mRNA-based Personalized Cancer Vaccine mRNA-4157") )
        setattr(cls, "Allogeneic GM-CSF-secreting Tumor Vaccine PANC 6.03 pcDNA-1/GM-Neo",
                PermissibleValue(text="Allogeneic GM-CSF-secreting Tumor Vaccine PANC 6.03 pcDNA-1/GM-Neo") )
        setattr(cls, "Mutant p53 Activator COTI-2",
                PermissibleValue(text="Mutant p53 Activator COTI-2") )
        setattr(cls, "Transferrin Receptor-Targeted Liposomal p53 cDNA",
                PermissibleValue(text="Transferrin Receptor-Targeted Liposomal p53 cDNA") )
        setattr(cls, "Trastuzumab/Hyaluronidase-oysk",
                PermissibleValue(text="Trastuzumab/Hyaluronidase-oysk") )
        setattr(cls, "PLK1 Inhibitor TAK-960",
                PermissibleValue(text="PLK1 Inhibitor TAK-960") )
        setattr(cls, "Anti-c-Met Antibody-drug Conjugate HTI-1066",
                PermissibleValue(text="Anti-c-Met Antibody-drug Conjugate HTI-1066") )
        setattr(cls, "DHA-Paclitaxel",
                PermissibleValue(text="DHA-Paclitaxel") )
        setattr(cls, "Anti-NY-ESO-1 Immunotherapeutic GSK-2241658A",
                PermissibleValue(text="Anti-NY-ESO-1 Immunotherapeutic GSK-2241658A") )
        setattr(cls, "MDM2 Antagonist RO6839921",
                PermissibleValue(text="MDM2 Antagonist RO6839921") )
        setattr(cls, "Vinorelbine Tartrate",
                PermissibleValue(text="Vinorelbine Tartrate") )
        setattr(cls, "Caffeic Acid Phenethyl Ester",
                PermissibleValue(text="Caffeic Acid Phenethyl Ester") )
        setattr(cls, "MAGE-A3-specific Immunotherapeutic GSK 2132231A",
                PermissibleValue(text="MAGE-A3-specific Immunotherapeutic GSK 2132231A") )
        setattr(cls, "Topotecan Sustained-release Episcleral Plaque",
                PermissibleValue(text="Topotecan Sustained-release Episcleral Plaque") )
        setattr(cls, "ChiNing Decoction",
                PermissibleValue(text="ChiNing Decoction") )
        setattr(cls, "TLR7 agonist BNT411",
                PermissibleValue(text="TLR7 agonist BNT411") )
        setattr(cls, "HCV DNA Vaccine INO-8000",
                PermissibleValue(text="HCV DNA Vaccine INO-8000") )
        setattr(cls, "Allogeneic Anti-CD19-CAR T-cells PBCAR0191",
                PermissibleValue(text="Allogeneic Anti-CD19-CAR T-cells PBCAR0191") )
        setattr(cls, "EGFR Inhibitor AZD3759",
                PermissibleValue(text="EGFR Inhibitor AZD3759") )
        setattr(cls, "PI3K-delta Inhibitor AMG 319",
                PermissibleValue(text="PI3K-delta Inhibitor AMG 319") )
        setattr(cls, "Androgen Receptor Antisense Oligonucleotide AZD5312",
                PermissibleValue(text="Androgen Receptor Antisense Oligonucleotide AZD5312") )
        setattr(cls, "pan-HER Kinase Inhibitor AC480",
                PermissibleValue(text="pan-HER Kinase Inhibitor AC480") )
        setattr(cls, "Mucoadhesive Paclitaxel Formulation",
                PermissibleValue(text="Mucoadhesive Paclitaxel Formulation") )
        setattr(cls, "Exatecan Mesylate Anhydrous",
                PermissibleValue(text="Exatecan Mesylate Anhydrous") )
        setattr(cls, "Ingenol Mebutate Gel",
                PermissibleValue(text="Ingenol Mebutate Gel") )
        setattr(cls, "Tin Ethyl Etiopurpurin",
                PermissibleValue(text="Tin Ethyl Etiopurpurin") )
        setattr(cls, "Anti-B7H3 Antibody-drug Conjugate MGC018",
                PermissibleValue(text="Anti-B7H3 Antibody-drug Conjugate MGC018") )
        setattr(cls, "Azintuxizumab Vedotin",
                PermissibleValue(text="Azintuxizumab Vedotin") )
        setattr(cls, "Oral Sodium Phenylbutyrate",
                PermissibleValue(text="Oral Sodium Phenylbutyrate") )
        setattr(cls, "MDM2 Antagonist RO5045337",
                PermissibleValue(text="MDM2 Antagonist RO5045337") )
        setattr(cls, "Recombinant Human Hsp110-gp100 Chaperone Complex Vaccine",
                PermissibleValue(text="Recombinant Human Hsp110-gp100 Chaperone Complex Vaccine") )
        setattr(cls, "Autologous CD123-4SCAR-expressing T-cells 4SCAR123",
                PermissibleValue(text="Autologous CD123-4SCAR-expressing T-cells 4SCAR123") )
        setattr(cls, "Yttrium Y 90 Anti-CD45 Monoclonal Antibody AHN-12",
                PermissibleValue(text="Yttrium Y 90 Anti-CD45 Monoclonal Antibody AHN-12") )
        setattr(cls, "Clomiphene Citrate",
                PermissibleValue(text="Clomiphene Citrate") )
        setattr(cls, "Lorvotuzumab Mertansine",
                PermissibleValue(text="Lorvotuzumab Mertansine") )
        setattr(cls, "Nab-paclitaxel",
                PermissibleValue(text="Nab-paclitaxel") )
        setattr(cls, "Multifunctional/Multitargeted Anticancer Agent OMN54",
                PermissibleValue(text="Multifunctional/Multitargeted Anticancer Agent OMN54") )
        setattr(cls, "Yttrium Y-90 Epratuzumab Tetraxetan",
                PermissibleValue(text="Yttrium Y-90 Epratuzumab Tetraxetan") )
        setattr(cls, "Maekmoondong-tang",
                PermissibleValue(text="Maekmoondong-tang") )
        setattr(cls, "Monoclonal Antibody L6",
                PermissibleValue(text="Monoclonal Antibody L6") )
        setattr(cls, "Cereblon E3 Ubiquitin Ligase Modulating Agent CC-99282",
                PermissibleValue(text="Cereblon E3 Ubiquitin Ligase Modulating Agent CC-99282") )
        setattr(cls, "Anti-PD-1/CTLA-4 Bispecific Antibody AK104",
                PermissibleValue(text="Anti-PD-1/CTLA-4 Bispecific Antibody AK104") )
        setattr(cls, "LSD1 Inhibitor SYHA1807",
                PermissibleValue(text="LSD1 Inhibitor SYHA1807") )
        setattr(cls, "Anti-gpA33/CD3 Monoclonal Antibody MGD007",
                PermissibleValue(text="Anti-gpA33/CD3 Monoclonal Antibody MGD007") )
        setattr(cls, "Anti-APRIL Monoclonal Antibody BION-1301",
                PermissibleValue(text="Anti-APRIL Monoclonal Antibody BION-1301") )
        setattr(cls, "HAAH Lambda phage Vaccine SNS-301",
                PermissibleValue(text="HAAH Lambda phage Vaccine SNS-301") )
        setattr(cls, "CCR2 Antagonist PF-04136309",
                PermissibleValue(text="CCR2 Antagonist PF-04136309") )
        setattr(cls, "Oral Milataxel",
                PermissibleValue(text="Oral Milataxel") )
        setattr(cls, "Anti-CD166 Probody-drug Conjugate CX-2009",
                PermissibleValue(text="Anti-CD166 Probody-drug Conjugate CX-2009") )
        setattr(cls, "IRAK4 Inhibitor CA-4948",
                PermissibleValue(text="IRAK4 Inhibitor CA-4948") )
        setattr(cls, "Recombinant Vesicular Stomatitis Virus-expressing Human Interferon Beta and Sodium-Iodide Symporter",
                PermissibleValue(text="Recombinant Vesicular Stomatitis Virus-expressing Human Interferon Beta and Sodium-Iodide Symporter") )
        setattr(cls, "EGFR/HER2 Inhibitor AV-412",
                PermissibleValue(text="EGFR/HER2 Inhibitor AV-412") )
        setattr(cls, "CDK7 Inhibitor SY-1365",
                PermissibleValue(text="CDK7 Inhibitor SY-1365") )
        setattr(cls, "Oblimersen Sodium",
                PermissibleValue(text="Oblimersen Sodium") )
        setattr(cls, "Topoisomerase I/II Inhibitor NEV-801",
                PermissibleValue(text="Topoisomerase I/II Inhibitor NEV-801") )
        setattr(cls, "Ad-RTS-hIL-12",
                PermissibleValue(text="Ad-RTS-hIL-12") )
        setattr(cls, "Dolastatin 15",
                PermissibleValue(text="Dolastatin 15") )
        setattr(cls, "Phenytoin Sodium",
                PermissibleValue(text="Phenytoin Sodium") )
        setattr(cls, "Autologous Anti-CD19 T-cell Receptor T cells ET190L1",
                PermissibleValue(text="Autologous Anti-CD19 T-cell Receptor T cells ET190L1") )
        setattr(cls, "Autologous Monocyte-derived Lysate-pulsed Dendritic Cell Vaccine PV-001-DC",
                PermissibleValue(text="Autologous Monocyte-derived Lysate-pulsed Dendritic Cell Vaccine PV-001-DC") )
        setattr(cls, "Allogeneic GM-CSF-secreting Lethally Irradiated Prostate Cancer Vaccine",
                PermissibleValue(text="Allogeneic GM-CSF-secreting Lethally Irradiated Prostate Cancer Vaccine") )
        setattr(cls, "BET Inhibitor CC-90010",
                PermissibleValue(text="BET Inhibitor CC-90010") )
        setattr(cls, "Mesothelin/CD3e Tri-specific T-cell Activating Construct HPN536",
                PermissibleValue(text="Mesothelin/CD3e Tri-specific T-cell Activating Construct HPN536") )
        setattr(cls, "Polyunsaturated Fatty Acid",
                PermissibleValue(text="Polyunsaturated Fatty Acid") )
        setattr(cls, "Anti-PRAME Immunotherapeutic GSK2302032A",
                PermissibleValue(text="Anti-PRAME Immunotherapeutic GSK2302032A") )
        setattr(cls, "WT1 Peptide Vaccine OCV-501",
                PermissibleValue(text="WT1 Peptide Vaccine OCV-501") )
        setattr(cls, "EphA2-targeting Bicycle Toxin Conjugate BT5528",
                PermissibleValue(text="EphA2-targeting Bicycle Toxin Conjugate BT5528") )
        setattr(cls, "Antisense Oligonucleotide GTI-2040",
                PermissibleValue(text="Antisense Oligonucleotide GTI-2040") )
        setattr(cls, "Renal Cell Carcinoma Peptides Vaccine IMA901",
                PermissibleValue(text="Renal Cell Carcinoma Peptides Vaccine IMA901") )
        setattr(cls, "Pixantrone Dimaleate",
                PermissibleValue(text="Pixantrone Dimaleate") )
        setattr(cls, "Coriolus Versicolor Extract",
                PermissibleValue(text="Coriolus Versicolor Extract") )
        setattr(cls, "p38 MAPK Inhibitor LY3007113",
                PermissibleValue(text="p38 MAPK Inhibitor LY3007113") )
        setattr(cls, "Anti-CD46 Antibody-drug Conjugate FOR46",
                PermissibleValue(text="Anti-CD46 Antibody-drug Conjugate FOR46") )
        setattr(cls, "CDK4/6 Inhibitor FCN-437",
                PermissibleValue(text="CDK4/6 Inhibitor FCN-437") )
        setattr(cls, "Therapeutic Breast/Ovarian/Prostate Peptide Cancer Vaccine DPX-0907",
                PermissibleValue(text="Therapeutic Breast/Ovarian/Prostate Peptide Cancer Vaccine DPX-0907") )
        setattr(cls, "Anti-GRP78 Monoclonal Antibody PAT-SM6",
                PermissibleValue(text="Anti-GRP78 Monoclonal Antibody PAT-SM6") )
        setattr(cls, "Autologous Anti-CD19CAR-HER2t/CD22CAR-EGFRt-expressing T-cells",
                PermissibleValue(text="Autologous Anti-CD19CAR-HER2t/CD22CAR-EGFRt-expressing T-cells") )
        setattr(cls, "Nucleolin Antagonist IPP-204106N",
                PermissibleValue(text="Nucleolin Antagonist IPP-204106N") )
        setattr(cls, "STING-expressing E. coli SYNB1891",
                PermissibleValue(text="STING-expressing E. coli SYNB1891") )
        setattr(cls, "Factor VII-targeting Immunoconjugate Protein ICON-1",
                PermissibleValue(text="Factor VII-targeting Immunoconjugate Protein ICON-1") )
        setattr(cls, "Nutraceutical TBL-12",
                PermissibleValue(text="Nutraceutical TBL-12") )
        setattr(cls, "Anti-PD-L1/4-1BB Bispecific Antibody INBRX-105",
                PermissibleValue(text="Anti-PD-L1/4-1BB Bispecific Antibody INBRX-105") )
        setattr(cls, "FGFR Inhibitor ASP5878",
                PermissibleValue(text="FGFR Inhibitor ASP5878") )
        setattr(cls, "Colorectal Tumor-Associated Peptides Vaccine IMA910",
                PermissibleValue(text="Colorectal Tumor-Associated Peptides Vaccine IMA910") )
        setattr(cls, "Magnesium Valproate",
                PermissibleValue(text="Magnesium Valproate") )
        setattr(cls, "PEP-3-KLH Conjugate Vaccine",
                PermissibleValue(text="PEP-3-KLH Conjugate Vaccine") )
        setattr(cls, "Tasisulam Sodium",
                PermissibleValue(text="Tasisulam Sodium") )
        setattr(cls, "Adenoviral MUC1 Vaccine ETBX-061",
                PermissibleValue(text="Adenoviral MUC1 Vaccine ETBX-061") )
        setattr(cls, "Denintuzumab Mafodotin",
                PermissibleValue(text="Denintuzumab Mafodotin") )
        setattr(cls, "Aurora Kinase Inhibitor BI 811283",
                PermissibleValue(text="Aurora Kinase Inhibitor BI 811283") )
        setattr(cls, "PI3Kalpha Inhibitor AZD8835",
                PermissibleValue(text="PI3Kalpha Inhibitor AZD8835") )
        setattr(cls, "LMB-1 Immunotoxin",
                PermissibleValue(text="LMB-1 Immunotoxin") )
        setattr(cls, "Strontium Chloride Sr-89",
                PermissibleValue(text="Strontium Chloride Sr-89") )
        setattr(cls, "Mercaptopurine Anhydrous",
                PermissibleValue(text="Mercaptopurine Anhydrous") )
        setattr(cls, "Anti-PSCA Monoclonal Antibody AGS-1C4D4",
                PermissibleValue(text="Anti-PSCA Monoclonal Antibody AGS-1C4D4") )
        setattr(cls, "Pyruvate Kinase M2 Isoform Activator TP-1454",
                PermissibleValue(text="Pyruvate Kinase M2 Isoform Activator TP-1454") )
        setattr(cls, "CYP11A1 Inhibitor ODM-209",
                PermissibleValue(text="CYP11A1 Inhibitor ODM-209") )
        setattr(cls, "HIF-1alpha Inhibitor PX-478",
                PermissibleValue(text="HIF-1alpha Inhibitor PX-478") )
        setattr(cls, "Anti-CD20 Monoclonal Antibody BAT4306F",
                PermissibleValue(text="Anti-CD20 Monoclonal Antibody BAT4306F") )
        setattr(cls, "Personalized Neoantigen DNA Vaccine GNOS-PVO2",
                PermissibleValue(text="Personalized Neoantigen DNA Vaccine GNOS-PVO2") )
        setattr(cls, "FLT3 Inhibitor HM43239",
                PermissibleValue(text="FLT3 Inhibitor HM43239") )
        setattr(cls, "PI3Kdelta Inhibitor GS-9901",
                PermissibleValue(text="PI3Kdelta Inhibitor GS-9901") )
        setattr(cls, "MAT2A Inhibitor AG-270",
                PermissibleValue(text="MAT2A Inhibitor AG-270") )
        setattr(cls, "CDK4/6 Inhibitor BPI-16350",
                PermissibleValue(text="CDK4/6 Inhibitor BPI-16350") )
        setattr(cls, "Oncolytic Newcastle Disease Virus Strain PV701",
                PermissibleValue(text="Oncolytic Newcastle Disease Virus Strain PV701") )
        setattr(cls, "FLT3/FGFR Dual Kinase Inhibitor MAX-40279",
                PermissibleValue(text="FLT3/FGFR Dual Kinase Inhibitor MAX-40279") )
        setattr(cls, "Wee1 Inhibitor ZN-c3",
                PermissibleValue(text="Wee1 Inhibitor ZN-c3") )
        setattr(cls, "Anti-CD205 Antibody-drug Conjugate OBT076",
                PermissibleValue(text="Anti-CD205 Antibody-drug Conjugate OBT076") )
        setattr(cls, "Recombinant Transforming Growth Factor-Beta",
                PermissibleValue(text="Recombinant Transforming Growth Factor-Beta") )
        setattr(cls, "Caricotamide/Tretazicar",
                PermissibleValue(text="Caricotamide/Tretazicar") )
        setattr(cls, "Multi-epitope Anti-folate Receptor Peptide Vaccine TPIV 200",
                PermissibleValue(text="Multi-epitope Anti-folate Receptor Peptide Vaccine TPIV 200") )
        setattr(cls, "Anti-CD19/Anti-CD22 Bispecific Immunotoxin DT2219ARL",
                PermissibleValue(text="Anti-CD19/Anti-CD22 Bispecific Immunotoxin DT2219ARL") )
        setattr(cls, "Anti-CD47 ADC SGN-CD47M",
                PermissibleValue(text="Anti-CD47 ADC SGN-CD47M") )
        setattr(cls, "Hyaluronidase-zzxf/Pertuzumab/Trastuzumab",
                PermissibleValue(text="Hyaluronidase-zzxf/Pertuzumab/Trastuzumab") )
        setattr(cls, "Anti-GITR Agonistic Monoclonal Antibody INCAGN01876",
                PermissibleValue(text="Anti-GITR Agonistic Monoclonal Antibody INCAGN01876") )
        setattr(cls, "FGFR/VEGFR/PDGFR/FLT3/SRC Inhibitor XL999",
                PermissibleValue(text="FGFR/VEGFR/PDGFR/FLT3/SRC Inhibitor XL999") )
        setattr(cls, "Anti-PD-1 Monoclonal Antibody HLX10",
                PermissibleValue(text="Anti-PD-1 Monoclonal Antibody HLX10") )
        setattr(cls, "Recombinant Interleukin-18",
                PermissibleValue(text="Recombinant Interleukin-18") )
        setattr(cls, "HDAC Class I/IIb Inhibitor HG146",
                PermissibleValue(text="HDAC Class I/IIb Inhibitor HG146") )
        setattr(cls, "Platinum Compound",
                PermissibleValue(text="Platinum Compound") )
        setattr(cls, "Ruthenium-based Small Molecule Therapeutic BOLD-100",
                PermissibleValue(text="Ruthenium-based Small Molecule Therapeutic BOLD-100") )
        setattr(cls, "Aurora Kinase Inhibitor PF-03814735",
                PermissibleValue(text="Aurora Kinase Inhibitor PF-03814735") )
        setattr(cls, "Anti-S15 Monoclonal Antibody NC318",
                PermissibleValue(text="Anti-S15 Monoclonal Antibody NC318") )
        setattr(cls, "Axl/Mer Inhibitor INCB081776",
                PermissibleValue(text="Axl/Mer Inhibitor INCB081776") )
        setattr(cls, "Hydrocortisone Sodium Succinate",
                PermissibleValue(text="Hydrocortisone Sodium Succinate") )
        setattr(cls, "Trimetrexate Glucuronate",
                PermissibleValue(text="Trimetrexate Glucuronate") )
        setattr(cls, "Anti-CD37 Bispecific Monoclonal Antibody GEN3009",
                PermissibleValue(text="Anti-CD37 Bispecific Monoclonal Antibody GEN3009") )
        setattr(cls, "Ashwagandha Root Powder Extract",
                PermissibleValue(text="Ashwagandha Root Powder Extract") )
        setattr(cls, "Thymidylate Synthase Inhibitor CX1106",
                PermissibleValue(text="Thymidylate Synthase Inhibitor CX1106") )
        setattr(cls, "Sodium Stibogluconate",
                PermissibleValue(text="Sodium Stibogluconate") )
        setattr(cls, "Pan-FLT3/Pan-BTK Multi-kinase Inhibitor CG-806",
                PermissibleValue(text="Pan-FLT3/Pan-BTK Multi-kinase Inhibitor CG-806") )
        setattr(cls, "Androgen Receptor Antagonist TRC253",
                PermissibleValue(text="Androgen Receptor Antagonist TRC253") )
        setattr(cls, "Liposome-encapsulated miR-34 Mimic MRX34",
                PermissibleValue(text="Liposome-encapsulated miR-34 Mimic MRX34") )
        setattr(cls, "Ubidecarenone Nanodispersion BPM31510n",
                PermissibleValue(text="Ubidecarenone Nanodispersion BPM31510n") )
        setattr(cls, "Autologous TCR-engineered T-cells IMA202",
                PermissibleValue(text="Autologous TCR-engineered T-cells IMA202") )
        setattr(cls, "Yttrium Y 90 Colloid",
                PermissibleValue(text="Yttrium Y 90 Colloid") )
        setattr(cls, "MVA-FCU1 TG4023",
                PermissibleValue(text="MVA-FCU1 TG4023") )
        setattr(cls, "BCR-ABL/KIT/AKT/ERK Inhibitor HQP1351",
                PermissibleValue(text="BCR-ABL/KIT/AKT/ERK Inhibitor HQP1351") )
        setattr(cls, "DM-CHOC-PEN",
                PermissibleValue(text="DM-CHOC-PEN") )
        setattr(cls, "MET Kinase Inhibitor OMO-1",
                PermissibleValue(text="MET Kinase Inhibitor OMO-1") )
        setattr(cls, "Interleukin Therapy",
                PermissibleValue(text="Interleukin Therapy") )
        setattr(cls, "Eribulin Mesylate",
                PermissibleValue(text="Eribulin Mesylate") )
        setattr(cls, "Micro Needle Array-Doxorubicin",
                PermissibleValue(text="Micro Needle Array-Doxorubicin") )
        setattr(cls, "Anlotinib Hydrochloride",
                PermissibleValue(text="Anlotinib Hydrochloride") )
        setattr(cls, "FLT3 Inhibitor SKI-G-801",
                PermissibleValue(text="FLT3 Inhibitor SKI-G-801") )
        setattr(cls, "IDO1/TDO2 Inhibitor M4112",
                PermissibleValue(text="IDO1/TDO2 Inhibitor M4112") )
        setattr(cls, "Anti-PD-1 Monoclonal Antibody AK105",
                PermissibleValue(text="Anti-PD-1 Monoclonal Antibody AK105") )
        setattr(cls, "Nimustine Hydrochloride",
                PermissibleValue(text="Nimustine Hydrochloride") )
        setattr(cls, "Procaspase Activating Compound-1 VO-100",
                PermissibleValue(text="Procaspase Activating Compound-1 VO-100") )
        setattr(cls, "EZH1/2 Inhibitor HH2853",
                PermissibleValue(text="EZH1/2 Inhibitor HH2853") )
        setattr(cls, "Pazopanib Hydrochloride",
                PermissibleValue(text="Pazopanib Hydrochloride") )
        setattr(cls, "Ganglioside GM2",
                PermissibleValue(text="Ganglioside GM2") )
        setattr(cls, "Glutaminase Inhibitor IPN60090",
                PermissibleValue(text="Glutaminase Inhibitor IPN60090") )
        setattr(cls, "Selumetinib Sulfate",
                PermissibleValue(text="Selumetinib Sulfate") )
        setattr(cls, "Autologous Pancreatic Adenocarcinoma Lysate and mRNA-loaded Dendritic Cell Vaccine",
                PermissibleValue(text="Autologous Pancreatic Adenocarcinoma Lysate and mRNA-loaded Dendritic Cell Vaccine") )
        setattr(cls, "Cetuximab-loaded Ethylcellulose Polymeric Nanoparticles Decorated with Octreotide (SY)",
                PermissibleValue(text="Cetuximab-loaded Ethylcellulose Polymeric Nanoparticles Decorated with Octreotide (SY)") )
        setattr(cls, "Anti-PD-L1 Monoclonal Antibody GR1405",
                PermissibleValue(text="Anti-PD-L1 Monoclonal Antibody GR1405") )
        setattr(cls, "Anti-MUC16/CD3 Bispecific Antibody REGN4018",
                PermissibleValue(text="Anti-MUC16/CD3 Bispecific Antibody REGN4018") )
        setattr(cls, "Anti-CD123/CD3 BiTE Antibody SAR440234",
                PermissibleValue(text="Anti-CD123/CD3 BiTE Antibody SAR440234") )
        setattr(cls, "CEA-MUC-1-TRICOM Vaccine CV301",
                PermissibleValue(text="CEA-MUC-1-TRICOM Vaccine CV301") )
        setattr(cls, "Arugula Seed Powder",
                PermissibleValue(text="Arugula Seed Powder") )
        setattr(cls, "Gemcitabine Prodrug LY2334737",
                PermissibleValue(text="Gemcitabine Prodrug LY2334737") )
        setattr(cls, "Boanmycin Hydrochloride",
                PermissibleValue(text="Boanmycin Hydrochloride") )
        setattr(cls, "Tubulin Binding Agent TTI-237",
                PermissibleValue(text="Tubulin Binding Agent TTI-237") )
        setattr(cls, "THL-P",
                PermissibleValue(text="THL-P") )
        setattr(cls, "Cidan Herbal Capsule",
                PermissibleValue(text="Cidan Herbal Capsule") )
        setattr(cls, "mTOR Kinase Inhibitor PP242",
                PermissibleValue(text="mTOR Kinase Inhibitor PP242") )
        setattr(cls, "D-methionine Formulation MRX-1024",
                PermissibleValue(text="D-methionine Formulation MRX-1024") )
        setattr(cls, "Anti-OFA Immunotherapeutic BB-MPI-03",
                PermissibleValue(text="Anti-OFA Immunotherapeutic BB-MPI-03") )
        setattr(cls, "SNS01-T Nanoparticles",
                PermissibleValue(text="SNS01-T Nanoparticles") )
        setattr(cls, "Dibrospidium Chloride",
                PermissibleValue(text="Dibrospidium Chloride") )
        setattr(cls, "3'-dA Phosphoramidate NUC-7738",
                PermissibleValue(text="3'-dA Phosphoramidate NUC-7738") )
        setattr(cls, "Paclitaxel PPE Microspheres",
                PermissibleValue(text="Paclitaxel PPE Microspheres") )
        setattr(cls, "Anti-Ep-CAM Monoclonal Antibody ING-1",
                PermissibleValue(text="Anti-Ep-CAM Monoclonal Antibody ING-1") )
        setattr(cls, "FGFR2 Inhibitor RLY-4008",
                PermissibleValue(text="FGFR2 Inhibitor RLY-4008") )
        setattr(cls, "Lanreotide Acetate",
                PermissibleValue(text="Lanreotide Acetate") )
        setattr(cls, "TGF-beta Receptor 1 Kinase Inhibitor SH3051",
                PermissibleValue(text="TGF-beta Receptor 1 Kinase Inhibitor SH3051") )
        setattr(cls, "Capecitabine Rapidly Disintegrating Tablet",
                PermissibleValue(text="Capecitabine Rapidly Disintegrating Tablet") )
        setattr(cls, "Apoptosis Inducer MPC-2130",
                PermissibleValue(text="Apoptosis Inducer MPC-2130") )
        setattr(cls, "ATM Inhibitor M 3541",
                PermissibleValue(text="ATM Inhibitor M 3541") )
        setattr(cls, "Sodium Phenylbutyrate",
                PermissibleValue(text="Sodium Phenylbutyrate") )
        setattr(cls, "PAK4/NAMPT Inhibitor KPT-9274",
                PermissibleValue(text="PAK4/NAMPT Inhibitor KPT-9274") )
        setattr(cls, "BET inhibitor BI 894999",
                PermissibleValue(text="BET inhibitor BI 894999") )
        setattr(cls, "Tubulin Polymerization Inhibitor VERU-111",
                PermissibleValue(text="Tubulin Polymerization Inhibitor VERU-111") )
        setattr(cls, "PI3K-delta Inhibitor INCB050465",
                PermissibleValue(text="PI3K-delta Inhibitor INCB050465") )
        setattr(cls, "Autologous Prostate Cancer Antigen-expressing Dendritic Cell Vaccine BPX-101",
                PermissibleValue(text="Autologous Prostate Cancer Antigen-expressing Dendritic Cell Vaccine BPX-101") )
        setattr(cls, "Pan-PIM Inhibitor INCB053914",
                PermissibleValue(text="Pan-PIM Inhibitor INCB053914") )
        setattr(cls, "Anti-B7-H3 Antibody DS-5573a",
                PermissibleValue(text="Anti-B7-H3 Antibody DS-5573a") )
        setattr(cls, "DNA Minor Groove Binding Agent SG2000",
                PermissibleValue(text="DNA Minor Groove Binding Agent SG2000") )
        setattr(cls, "DTRMWXHS-12/Everolimus/Pomalidomide Combination Agent DTRM-555",
                PermissibleValue(text="DTRMWXHS-12/Everolimus/Pomalidomide Combination Agent DTRM-555") )
        setattr(cls, "Zuclomiphene Citrate",
                PermissibleValue(text="Zuclomiphene Citrate") )
        setattr(cls, "Dexamethasone Phosphate",
                PermissibleValue(text="Dexamethasone Phosphate") )
        setattr(cls, "TP40 Immunotoxin",
                PermissibleValue(text="TP40 Immunotoxin") )
        setattr(cls, "Retaspimycin Hydrochloride",
                PermissibleValue(text="Retaspimycin Hydrochloride") )
        setattr(cls, "Pegylated Liposomal Doxorubicin Hydrochloride",
                PermissibleValue(text="Pegylated Liposomal Doxorubicin Hydrochloride") )
        setattr(cls, "Anti-PD-L1 Monoclonal Antibody CBT-502",
                PermissibleValue(text="Anti-PD-L1 Monoclonal Antibody CBT-502") )
        setattr(cls, "Autologous Anti-CD19/CD22 CAR T-cells AUTO3",
                PermissibleValue(text="Autologous Anti-CD19/CD22 CAR T-cells AUTO3") )
        setattr(cls, "IL-2/9/15 Gamma Chain Receptor Inhibitor BNZ-1",
                PermissibleValue(text="IL-2/9/15 Gamma Chain Receptor Inhibitor BNZ-1") )
        setattr(cls, "Anti-TWEAK Monoclonal Antibody RG7212",
                PermissibleValue(text="Anti-TWEAK Monoclonal Antibody RG7212") )
        setattr(cls, "Brivanib Alaninate",
                PermissibleValue(text="Brivanib Alaninate") )
        setattr(cls, "Axicabtagene Ciloleucel",
                PermissibleValue(text="Axicabtagene Ciloleucel") )
        setattr(cls, "Tegafur-Gimeracil-Oteracil Potassium-Leucovorin Calcium Oral Formulation",
                PermissibleValue(text="Tegafur-Gimeracil-Oteracil Potassium-Leucovorin Calcium Oral Formulation") )
        setattr(cls, "EGFR T790M Inhibitor HS-10296",
                PermissibleValue(text="EGFR T790M Inhibitor HS-10296") )
        setattr(cls, "Androgen Receptor Antagonist SHR3680",
                PermissibleValue(text="Androgen Receptor Antagonist SHR3680") )
        setattr(cls, "Anti-Claudin18.2 Monoclonal Antibody TST001",
                PermissibleValue(text="Anti-Claudin18.2 Monoclonal Antibody TST001") )
        setattr(cls, "pan-PI3K/mTOR Inhibitor SF1126",
                PermissibleValue(text="pan-PI3K/mTOR Inhibitor SF1126") )
        setattr(cls, "MDM2 Inhibitor BI 907828",
                PermissibleValue(text="MDM2 Inhibitor BI 907828") )
        setattr(cls, "Hu14.18-IL2 Fusion Protein EMD 273063",
                PermissibleValue(text="Hu14.18-IL2 Fusion Protein EMD 273063") )
        setattr(cls, "Noscapine Hydrochloride",
                PermissibleValue(text="Noscapine Hydrochloride") )
        setattr(cls, "Hsp90-targeted Photosensitizer HS-201",
                PermissibleValue(text="Hsp90-targeted Photosensitizer HS-201") )
        setattr(cls, "Monoclonal Antibody 3F8",
                PermissibleValue(text="Monoclonal Antibody 3F8") )
        setattr(cls, "SERD ZN-c5",
                PermissibleValue(text="SERD ZN-c5") )
        setattr(cls, "Tetraphenyl Chlorin Disulfonate",
                PermissibleValue(text="Tetraphenyl Chlorin Disulfonate") )
        setattr(cls, "pan-RAF Kinase Inhibitor CCT3833",
                PermissibleValue(text="pan-RAF Kinase Inhibitor CCT3833") )
        setattr(cls, "Emepepimut-S",
                PermissibleValue(text="Emepepimut-S") )
        setattr(cls, "DKK1-Neutralizing Monoclonal Antibody DKN-01",
                PermissibleValue(text="DKK1-Neutralizing Monoclonal Antibody DKN-01") )
        setattr(cls, "Maraba Oncolytic Virus Expressing Mutant HPV E6/E7",
                PermissibleValue(text="Maraba Oncolytic Virus Expressing Mutant HPV E6/E7") )
        setattr(cls, "VLP-encapsulated TLR9 Agonist CMP-001",
                PermissibleValue(text="VLP-encapsulated TLR9 Agonist CMP-001") )
        setattr(cls, "Jin Fu Kang",
                PermissibleValue(text="Jin Fu Kang") )
        setattr(cls, "Colorectal Cancer Peptide Vaccine PolyPEPI1018",
                PermissibleValue(text="Colorectal Cancer Peptide Vaccine PolyPEPI1018") )
        setattr(cls, "Lenalidomide Analog KPG-121",
                PermissibleValue(text="Lenalidomide Analog KPG-121") )
        setattr(cls, "Octreotide Pamoate",
                PermissibleValue(text="Octreotide Pamoate") )
        setattr(cls, "Sho-Saiko-To",
                PermissibleValue(text="Sho-Saiko-To") )
        setattr(cls, "Ruthenium-based Transferrin Targeting Agent NKP-1339",
                PermissibleValue(text="Ruthenium-based Transferrin Targeting Agent NKP-1339") )
        setattr(cls, "Gemcitabine Hydrochloride",
                PermissibleValue(text="Gemcitabine Hydrochloride") )
        setattr(cls, "Combretastatin A1 Diphosphate",
                PermissibleValue(text="Combretastatin A1 Diphosphate") )
        setattr(cls, "IMT-1012 Immunotherapeutic Vaccine",
                PermissibleValue(text="IMT-1012 Immunotherapeutic Vaccine") )
        setattr(cls, "Immune Checkpoint Inhibitor ASP8374",
                PermissibleValue(text="Immune Checkpoint Inhibitor ASP8374") )
        setattr(cls, "Adenovirus Serotype 26-expressing HPV18 Vaccine JNJ-63682931",
                PermissibleValue(text="Adenovirus Serotype 26-expressing HPV18 Vaccine JNJ-63682931") )
        setattr(cls, "Lutetium Lu 177-PSMA-617",
                PermissibleValue(text="Lutetium Lu 177-PSMA-617") )
        setattr(cls, "Compound Kushen Injection",
                PermissibleValue(text="Compound Kushen Injection") )
        setattr(cls, "Nelipepimut-S Plus GM-CSF Vaccine",
                PermissibleValue(text="Nelipepimut-S Plus GM-CSF Vaccine") )
        setattr(cls, "Polo-like Kinase 1 Inhibitor GSK461364",
                PermissibleValue(text="Polo-like Kinase 1 Inhibitor GSK461364") )
        setattr(cls, "IL-2 Recombinant Fusion Protein ALT-801",
                PermissibleValue(text="IL-2 Recombinant Fusion Protein ALT-801") )
        setattr(cls, "Chk1 Inhibitor CCT245737",
                PermissibleValue(text="Chk1 Inhibitor CCT245737") )
        setattr(cls, "FGF Receptor Antagonist HGS1036",
                PermissibleValue(text="FGF Receptor Antagonist HGS1036") )
        setattr(cls, "FLT3/ABL/Aurora Kinase Inhibitor KW-2449",
                PermissibleValue(text="FLT3/ABL/Aurora Kinase Inhibitor KW-2449") )
        setattr(cls, "Triamcinolone Acetonide",
                PermissibleValue(text="Triamcinolone Acetonide") )
        setattr(cls, "A2A Receptor Antagonist EOS100850",
                PermissibleValue(text="A2A Receptor Antagonist EOS100850") )
        setattr(cls, "Anti-HER2 Antibody-drug Conjugate BAT8001",
                PermissibleValue(text="Anti-HER2 Antibody-drug Conjugate BAT8001") )
        setattr(cls, "CD80-Fc Fusion Protein ALPN-202",
                PermissibleValue(text="CD80-Fc Fusion Protein ALPN-202") )
        setattr(cls, "Cortisone Acetate",
                PermissibleValue(text="Cortisone Acetate") )
        setattr(cls, "Medroxyprogesterone Acetate",
                PermissibleValue(text="Medroxyprogesterone Acetate") )
        setattr(cls, "Aurora Kinase Inhibitor SNS-314",
                PermissibleValue(text="Aurora Kinase Inhibitor SNS-314") )
        setattr(cls, "Camptothecin Analogue TLC388",
                PermissibleValue(text="Camptothecin Analogue TLC388") )
        setattr(cls, "Losatuxizumab Vedotin",
                PermissibleValue(text="Losatuxizumab Vedotin") )
        setattr(cls, "Ovine Submaxillary Mucin",
                PermissibleValue(text="Ovine Submaxillary Mucin") )
        setattr(cls, "Smac Mimetic GDC-0917",
                PermissibleValue(text="Smac Mimetic GDC-0917") )
        setattr(cls, "Bruceanol D",
                PermissibleValue(text="Bruceanol D") )
        setattr(cls, "Golnerminogene Pradenovec",
                PermissibleValue(text="Golnerminogene Pradenovec") )
        setattr(cls, "P-cadherin Antagonist PF-03732010",
                PermissibleValue(text="P-cadherin Antagonist PF-03732010") )
        setattr(cls, "JAK Inhibitor",
                PermissibleValue(text="JAK Inhibitor") )
        setattr(cls, "Recombinant Leukocyte Interleukin",
                PermissibleValue(text="Recombinant Leukocyte Interleukin") )
        setattr(cls, "Pegylated Deoxycytidine Analogue DFP-14927",
                PermissibleValue(text="Pegylated Deoxycytidine Analogue DFP-14927") )
        setattr(cls, "MAGE-A3 Multipeptide Vaccine GL-0817",
                PermissibleValue(text="MAGE-A3 Multipeptide Vaccine GL-0817") )
        setattr(cls, "Piritrexim Isethionate",
                PermissibleValue(text="Piritrexim Isethionate") )
        setattr(cls, "Topoisomerase I Inhibitor LMP400",
                PermissibleValue(text="Topoisomerase I Inhibitor LMP400") )
        setattr(cls, "L-Gossypol",
                PermissibleValue(text="L-Gossypol") )
        setattr(cls, "Anti-gremlin-1 Monoclonal Antibody UCB6114",
                PermissibleValue(text="Anti-gremlin-1 Monoclonal Antibody UCB6114") )
        setattr(cls, "Pegylated Recombinant Interleukin-2 THOR-707",
                PermissibleValue(text="Pegylated Recombinant Interleukin-2 THOR-707") )
        setattr(cls, "Cordycepin Triphosphate",
                PermissibleValue(text="Cordycepin Triphosphate") )
        setattr(cls, "Amblyomin-X",
                PermissibleValue(text="Amblyomin-X") )
        setattr(cls, "SERD SAR439859",
                PermissibleValue(text="SERD SAR439859") )
        setattr(cls, "Iodine I 131 Tositumomab",
                PermissibleValue(text="Iodine I 131 Tositumomab") )
        setattr(cls, "Engineered Red Blood Cells Co-expressing 4-1BBL and IL-15TP RTX-240",
                PermissibleValue(text="Engineered Red Blood Cells Co-expressing 4-1BBL and IL-15TP RTX-240") )
        setattr(cls, "Recombinant Interferon Alfa-2b",
                PermissibleValue(text="Recombinant Interferon Alfa-2b") )
        setattr(cls, "CXCR4 Peptide Antagonist LY2510924",
                PermissibleValue(text="CXCR4 Peptide Antagonist LY2510924") )
        setattr(cls, "Iodine I 131 Tenatumomab",
                PermissibleValue(text="Iodine I 131 Tenatumomab") )
        setattr(cls, "Viagenpumatucel-L",
                PermissibleValue(text="Viagenpumatucel-L") )
        setattr(cls, "Tozasertib Lactate",
                PermissibleValue(text="Tozasertib Lactate") )
        setattr(cls, "Antibody-drug Conjugate ABBV-838",
                PermissibleValue(text="Antibody-drug Conjugate ABBV-838") )
        setattr(cls, "Antibody-drug Conjugate SC-007",
                PermissibleValue(text="Antibody-drug Conjugate SC-007") )
        setattr(cls, "Anti-PVRIG Monoclonal Antibody COM701",
                PermissibleValue(text="Anti-PVRIG Monoclonal Antibody COM701") )
        setattr(cls, "Alvespimycin Hydrochloride",
                PermissibleValue(text="Alvespimycin Hydrochloride") )
        setattr(cls, "mTOR Kinase Inhibitor CC-223",
                PermissibleValue(text="mTOR Kinase Inhibitor CC-223") )
        setattr(cls, "Human Combinatorial Antibody Library-based Monoclonal Antibody VAY736",
                PermissibleValue(text="Human Combinatorial Antibody Library-based Monoclonal Antibody VAY736") )
        setattr(cls, "PARP-1/2 Inhibitor ABT-767",
                PermissibleValue(text="PARP-1/2 Inhibitor ABT-767") )
        setattr(cls, "USP14/UCHL5 Inhibitor VLX1570",
                PermissibleValue(text="USP14/UCHL5 Inhibitor VLX1570") )
        setattr(cls, "Monoclonal Antibody TRK-950",
                PermissibleValue(text="Monoclonal Antibody TRK-950") )
        setattr(cls, "IGF-1R Inhibitor",
                PermissibleValue(text="IGF-1R Inhibitor") )
        setattr(cls, "Autologous CD38-4SCAR-expressing T-cells 4SCAR38",
                PermissibleValue(text="Autologous CD38-4SCAR-expressing T-cells 4SCAR38") )
        setattr(cls, "Anti-HER2 Antibody-drug Conjugate A166",
                PermissibleValue(text="Anti-HER2 Antibody-drug Conjugate A166") )
        setattr(cls, "Rivoceranib Mesylate",
                PermissibleValue(text="Rivoceranib Mesylate") )
        setattr(cls, "Oncolytic HSV1716",
                PermissibleValue(text="Oncolytic HSV1716") )
        setattr(cls, "SIRPa-Fc Fusion Protein TTI-621",
                PermissibleValue(text="SIRPa-Fc Fusion Protein TTI-621") )
        setattr(cls, "Plk1 Inhibitor BI 2536",
                PermissibleValue(text="Plk1 Inhibitor BI 2536") )
        setattr(cls, "Dactolisib Tosylate",
                PermissibleValue(text="Dactolisib Tosylate") )
        setattr(cls, "Autologous Anti-CD19 CAR-4-1BB-CD3zeta-expressing T-cells CNCT19",
                PermissibleValue(text="Autologous Anti-CD19 CAR-4-1BB-CD3zeta-expressing T-cells CNCT19") )
        setattr(cls, "Galectin Inhibitor GR-MD-02",
                PermissibleValue(text="Galectin Inhibitor GR-MD-02") )
        setattr(cls, "Recombinant Humanized Anti-HER-2 Bispecific Monoclonal Antibody MBS301",
                PermissibleValue(text="Recombinant Humanized Anti-HER-2 Bispecific Monoclonal Antibody MBS301") )
        setattr(cls, "Cevipabulin Fumarate",
                PermissibleValue(text="Cevipabulin Fumarate") )
        setattr(cls, "Anti-MUC16/MMAE Antibody-Drug Conjugate DMUC4064A",
                PermissibleValue(text="Anti-MUC16/MMAE Antibody-Drug Conjugate DMUC4064A") )
        setattr(cls, "Algenpantucel-L",
                PermissibleValue(text="Algenpantucel-L") )
        setattr(cls, "HER2 Tri-specific Natural Killer Cell Engager DF1001",
                PermissibleValue(text="HER2 Tri-specific Natural Killer Cell Engager DF1001") )
        setattr(cls, "Oral Topotecan Hydrochloride",
                PermissibleValue(text="Oral Topotecan Hydrochloride") )
        setattr(cls, "Antiangiogenic Drug Combination TL-118",
                PermissibleValue(text="Antiangiogenic Drug Combination TL-118") )
        setattr(cls, "Hemiasterlin Analog E7974",
                PermissibleValue(text="Hemiasterlin Analog E7974") )
        setattr(cls, "Glioma Lysate Vaccine GBM6-AD",
                PermissibleValue(text="Glioma Lysate Vaccine GBM6-AD") )
        setattr(cls, "iNKT Cell Agonist ABX196",
                PermissibleValue(text="iNKT Cell Agonist ABX196") )
        setattr(cls, "Phosphorodiamidate Morpholino Oligomer AVI-4126",
                PermissibleValue(text="Phosphorodiamidate Morpholino Oligomer AVI-4126") )
        setattr(cls, "Checkpoint Kinase Inhibitor XL844",
                PermissibleValue(text="Checkpoint Kinase Inhibitor XL844") )
        setattr(cls, "WT1 Protein-derived Peptide Vaccine DSP-7888",
                PermissibleValue(text="WT1 Protein-derived Peptide Vaccine DSP-7888") )
        setattr(cls, "Sotrastaurin Acetate",
                PermissibleValue(text="Sotrastaurin Acetate") )
        setattr(cls, "Anti-CD38 Antibody-drug Conjugate STI-6129",
                PermissibleValue(text="Anti-CD38 Antibody-drug Conjugate STI-6129") )
        setattr(cls, "Anti-CD38/CD3 Bispecific Monoclonal Antibody GBR 1342",
                PermissibleValue(text="Anti-CD38/CD3 Bispecific Monoclonal Antibody GBR 1342") )
        setattr(cls, "Anti-PD-L1 Monoclonal Antibody BGB-A333",
                PermissibleValue(text="Anti-PD-L1 Monoclonal Antibody BGB-A333") )
        setattr(cls, "Monoclonal Antibody Lym-1",
                PermissibleValue(text="Monoclonal Antibody Lym-1") )
        setattr(cls, "TLR-Directed Cationic Lipid-DNA Complex JVRS-100",
                PermissibleValue(text="TLR-Directed Cationic Lipid-DNA Complex JVRS-100") )
        setattr(cls, "Peptide 946 Melanoma Vaccine",
                PermissibleValue(text="Peptide 946 Melanoma Vaccine") )
        setattr(cls, "Anti-FLT3 Monoclonal Antibody 4G8-SDIEM",
                PermissibleValue(text="Anti-FLT3 Monoclonal Antibody 4G8-SDIEM") )
        setattr(cls, "Oral Microencapsulated Diindolylmethane",
                PermissibleValue(text="Oral Microencapsulated Diindolylmethane") )
        setattr(cls, "Enclomiphene Citrate",
                PermissibleValue(text="Enclomiphene Citrate") )
        setattr(cls, "Thymidylate Synthase Inhibitor DFP-11207",
                PermissibleValue(text="Thymidylate Synthase Inhibitor DFP-11207") )
        setattr(cls, "IL-10 Immunomodulator MK-1966",
                PermissibleValue(text="IL-10 Immunomodulator MK-1966") )
        setattr(cls, "CDC7 Kinase Inhibitor LY3143921 Hydrate",
                PermissibleValue(text="CDC7 Kinase Inhibitor LY3143921 Hydrate") )
        setattr(cls, "CDK2 Inhibitor PF-07104091",
                PermissibleValue(text="CDK2 Inhibitor PF-07104091") )
        setattr(cls, "Bacillus Calmette-Guerin Substrain Connaught Live Antigen",
                PermissibleValue(text="Bacillus Calmette-Guerin Substrain Connaught Live Antigen") )
        setattr(cls, "Liposomal SN-38",
                PermissibleValue(text="Liposomal SN-38") )
        setattr(cls, "ALK Inhibitor PLB 1003",
                PermissibleValue(text="ALK Inhibitor PLB 1003") )
        setattr(cls, "Olvimulogene Nanivacirepvec",
                PermissibleValue(text="Olvimulogene Nanivacirepvec") )
        setattr(cls, "Monoclonal Antibody A27.15",
                PermissibleValue(text="Monoclonal Antibody A27.15") )
        setattr(cls, "DNA Vaccine VB10.16",
                PermissibleValue(text="DNA Vaccine VB10.16") )
        setattr(cls, "CD40 Agonistic Monoclonal Antibody APX005M",
                PermissibleValue(text="CD40 Agonistic Monoclonal Antibody APX005M") )
        setattr(cls, "TRPM8 Agonist D-3263",
                PermissibleValue(text="TRPM8 Agonist D-3263") )
        setattr(cls, "LMP2-specific T Cell Receptor-transduced Autologous T-lymphocytes",
                PermissibleValue(text="LMP2-specific T Cell Receptor-transduced Autologous T-lymphocytes") )
        setattr(cls, "Recombinant CD40-Ligand",
                PermissibleValue(text="Recombinant CD40-Ligand") )
        setattr(cls, "Anti-CEACAM1 Monoclonal Antibody CM-24",
                PermissibleValue(text="Anti-CEACAM1 Monoclonal Antibody CM-24") )
        setattr(cls, "Lipid Nanoparticle Encapsulating mRNAs Encoding Human OX40L/IL-23/IL-36gamma mRNA-2752",
                PermissibleValue(text="Lipid Nanoparticle Encapsulating mRNAs Encoding Human OX40L/IL-23/IL-36gamma mRNA-2752") )
        setattr(cls, "Qilisheng Immunoregulatory Oral Solution",
                PermissibleValue(text="Qilisheng Immunoregulatory Oral Solution") )
        setattr(cls, "Cytidine Analog RX-3117",
                PermissibleValue(text="Cytidine Analog RX-3117") )
        setattr(cls, "P-cadherin-targeting Agent PF-06671008",
                PermissibleValue(text="P-cadherin-targeting Agent PF-06671008") )
        setattr(cls, "mTORC1/2 Kinase Inhibitor BI 860585",
                PermissibleValue(text="mTORC1/2 Kinase Inhibitor BI 860585") )
        setattr(cls, "Recombinant Human EGF-rP64K/Montanide ISA 51 Vaccine",
                PermissibleValue(text="Recombinant Human EGF-rP64K/Montanide ISA 51 Vaccine") )
        setattr(cls, "Autologous CD19-targeted CAR T Cells CC-97540",
                PermissibleValue(text="Autologous CD19-targeted CAR T Cells CC-97540") )
        setattr(cls, "Adagloxad Simolenin",
                PermissibleValue(text="Adagloxad Simolenin") )
        setattr(cls, "Anti-CTLA-4/LAG-3 Bispecific Antibody XmAb22841",
                PermissibleValue(text="Anti-CTLA-4/LAG-3 Bispecific Antibody XmAb22841") )
        setattr(cls, "Anti-LAG-3 Monoclonal Antibody INCAGN02385",
                PermissibleValue(text="Anti-LAG-3 Monoclonal Antibody INCAGN02385") )
        setattr(cls, "Thorium Th 227 Anetumab Corixetan",
                PermissibleValue(text="Thorium Th 227 Anetumab Corixetan") )
        setattr(cls, "Pegylated Recombinant L-asparaginase Erwinia chrysanthemi",
                PermissibleValue(text="Pegylated Recombinant L-asparaginase Erwinia chrysanthemi") )
        setattr(cls, "pan-RAF Inhibitor LXH254",
                PermissibleValue(text="pan-RAF Inhibitor LXH254") )
        setattr(cls, "BET Bromodomain Inhibitor ZEN-3694",
                PermissibleValue(text="BET Bromodomain Inhibitor ZEN-3694") )
        setattr(cls, "PI3K-delta Inhibitor HMPL 689",
                PermissibleValue(text="PI3K-delta Inhibitor HMPL 689") )
        setattr(cls, "Smoothened Antagonist TAK-441",
                PermissibleValue(text="Smoothened Antagonist TAK-441") )
        setattr(cls, "p70S6K Inhibitor LY2584702",
                PermissibleValue(text="p70S6K Inhibitor LY2584702") )
        setattr(cls, "Triptolide Analog",
                PermissibleValue(text="Triptolide Analog") )
        setattr(cls, "Androstane Steroid HE3235",
                PermissibleValue(text="Androstane Steroid HE3235") )
        setattr(cls, "Porcupine Inhibitor WNT974",
                PermissibleValue(text="Porcupine Inhibitor WNT974") )
        setattr(cls, "mRNA-based TriMix Melanoma Vaccine ECI-006",
                PermissibleValue(text="mRNA-based TriMix Melanoma Vaccine ECI-006") )
        setattr(cls, "Amustaline Dihydrochloride",
                PermissibleValue(text="Amustaline Dihydrochloride") )
        setattr(cls, "Alpha-Thioguanine Deoxyriboside",
                PermissibleValue(text="Alpha-Thioguanine Deoxyriboside") )
        setattr(cls, "Anti-BCMA/PBD ADC MEDI2228",
                PermissibleValue(text="Anti-BCMA/PBD ADC MEDI2228") )
        setattr(cls, "Zinc Finger Nuclease ZFN-758",
                PermissibleValue(text="Zinc Finger Nuclease ZFN-758") )
        setattr(cls, "Motesanib Diphosphate",
                PermissibleValue(text="Motesanib Diphosphate") )
        setattr(cls, "Y 90 Monoclonal Antibody M195",
                PermissibleValue(text="Y 90 Monoclonal Antibody M195") )
        setattr(cls, "Liposome-Encapsulated Doxorubicin Citrate",
                PermissibleValue(text="Liposome-Encapsulated Doxorubicin Citrate") )
        setattr(cls, "Multi-neo-epitope Vaccine OSE 2101",
                PermissibleValue(text="Multi-neo-epitope Vaccine OSE 2101") )
        setattr(cls, "Baltaleucel-T",
                PermissibleValue(text="Baltaleucel-T") )
        setattr(cls, "Sipuleucel-T",
                PermissibleValue(text="Sipuleucel-T") )
        setattr(cls, "Liposomal HPV-16 E6/E7 Multipeptide Vaccine PDS0101",
                PermissibleValue(text="Liposomal HPV-16 E6/E7 Multipeptide Vaccine PDS0101") )
        setattr(cls, "Glembatumumab Vedotin",
                PermissibleValue(text="Glembatumumab Vedotin") )
        setattr(cls, "KRAS Mutant-targeting AMG 510",
                PermissibleValue(text="KRAS Mutant-targeting AMG 510") )
        setattr(cls, "Anti-5T4 Antibody-drug Conjugate ASN004",
                PermissibleValue(text="Anti-5T4 Antibody-drug Conjugate ASN004") )
        setattr(cls, "SSTR2-targeting Protein/DM1 Conjugate PEN-221",
                PermissibleValue(text="SSTR2-targeting Protein/DM1 Conjugate PEN-221") )
        setattr(cls, "Alflutinib Mesylate",
                PermissibleValue(text="Alflutinib Mesylate") )
        setattr(cls, "Taxane Analogue TPI 287",
                PermissibleValue(text="Taxane Analogue TPI 287") )
        setattr(cls, "Phenethyl Isothiocyanate-containing Watercress Juice",
                PermissibleValue(text="Phenethyl Isothiocyanate-containing Watercress Juice") )
        setattr(cls, "Anti-CD40/Anti-TAA Bispecific Monoclonal Antibody ABBV-428",
                PermissibleValue(text="Anti-CD40/Anti-TAA Bispecific Monoclonal Antibody ABBV-428") )
        setattr(cls, "Interleukin-15/Interleukin-15 Receptor Alpha Complex-Fc Fusion Protein XmAb24306",
                PermissibleValue(text="Interleukin-15/Interleukin-15 Receptor Alpha Complex-Fc Fusion Protein XmAb24306") )
        setattr(cls, "Oncolytic Newcastle Disease Virus MEDI5395",
                PermissibleValue(text="Oncolytic Newcastle Disease Virus MEDI5395") )
        setattr(cls, "Oxidative Phosphorylation Inhibitor IACS-010759",
                PermissibleValue(text="Oxidative Phosphorylation Inhibitor IACS-010759") )
        setattr(cls, "ALK-FAK Inhibitor CEP-37440",
                PermissibleValue(text="ALK-FAK Inhibitor CEP-37440") )
        setattr(cls, "Smac Mimetic LCL161",
                PermissibleValue(text="Smac Mimetic LCL161") )
        setattr(cls, "IL-12-expressing Mesenchymal Stem Cell Vaccine GX-051",
                PermissibleValue(text="IL-12-expressing Mesenchymal Stem Cell Vaccine GX-051") )
        setattr(cls, "Glecaprevir/Pibrentasvir",
                PermissibleValue(text="Glecaprevir/Pibrentasvir") )
        setattr(cls, "Triplatin Tetranitrate",
                PermissibleValue(text="Triplatin Tetranitrate") )
        setattr(cls, "Interleukin-12-Fc Fusion Protein DF6002",
                PermissibleValue(text="Interleukin-12-Fc Fusion Protein DF6002") )
        setattr(cls, "PI3K Inhibitor GSK1059615",
                PermissibleValue(text="PI3K Inhibitor GSK1059615") )
        setattr(cls, "Anti-CD123-Pyrrolobenzodiazepine Dimer Antibody Drug Conjugate SGN-CD123A",
                PermissibleValue(text="Anti-CD123-Pyrrolobenzodiazepine Dimer Antibody Drug Conjugate SGN-CD123A") )
        setattr(cls, "2-O, 3-O Desulfated Heparin",
                PermissibleValue(text="2-O, 3-O Desulfated Heparin") )
        setattr(cls, "PVA Microporous Hydrospheres/Doxorubicin Hydrochloride",
                PermissibleValue(text="PVA Microporous Hydrospheres/Doxorubicin Hydrochloride") )
        setattr(cls, "Anti-ANG2 Monoclonal Antibody MEDI-3617",
                PermissibleValue(text="Anti-ANG2 Monoclonal Antibody MEDI-3617") )
        setattr(cls, "Anti-latent TGF-beta 1 Monoclonal Antibody SRK-181",
                PermissibleValue(text="Anti-latent TGF-beta 1 Monoclonal Antibody SRK-181") )
        setattr(cls, "SHP2 Inhibitor RMC-4630",
                PermissibleValue(text="SHP2 Inhibitor RMC-4630") )
        setattr(cls, "Lometrexol Sodium",
                PermissibleValue(text="Lometrexol Sodium") )
        setattr(cls, "DNA-PK inhibitor AZD7648",
                PermissibleValue(text="DNA-PK inhibitor AZD7648") )
        setattr(cls, "Metformin Hydrochloride",
                Perm