language_data = {
    "Abkhazian": {
        "ISO_639_1_code": "ab",
        "ISO_639_2_code": "abk",
        "ISO_639_3_code": "abk",
    },
    "Afar": {
        "ISO_639_1_code": "aa",
        "ISO_639_2_code": "aar",
        "ISO_639_3_code": "aar",
    },
    "Afrikaans": {
        "ISO_639_1_code": "af",
        "ISO_639_2_code": "afr",
        "ISO_639_3_code": "afr",
    },
    "Akan": {
        "ISO_639_1_code": "ak",
        "ISO_639_2_code": "aka",
        "ISO_639_3_code": "aka",
    },
    "Albanian": {
        "ISO_639_1_code": "sq",
        "ISO_639_2_code": "sqi",
        "ISO_639_3_code": "sqi",
    },
    "Amharic": {
        "ISO_639_1_code": "am",
        "ISO_639_2_code": "amh",
        "ISO_639_3_code": "amh",
    },
    "Arabic": {
        "ISO_639_1_code": "ar",
        "ISO_639_2_code": "ara",
        "ISO_639_3_code": "ara",
    },
    "Aragonese": {
        "ISO_639_1_code": "an",
        "ISO_639_2_code": "arg",
        "ISO_639_3_code": "arg",
    },
    "Armenian": {
        "ISO_639_1_code": "hy",
        "ISO_639_2_code": "hye",
        "ISO_639_3_code": "hye",
    },
    "Assamese": {
        "ISO_639_1_code": "as",
        "ISO_639_2_code": "asm",
        "ISO_639_3_code": "asm",
    },
    "Avaric": {
        "ISO_639_1_code": "av",
        "ISO_639_2_code": "ava",
        "ISO_639_3_code": "ava",
    },
    "Avestan": {
        "ISO_639_1_code": "ae",
        "ISO_639_2_code": "ave",
        "ISO_639_3_code": "ave",
    },
    "Aymara": {
        "ISO_639_1_code": "ay",
        "ISO_639_2_code": "aym",
        "ISO_639_3_code": "aym",
    },
    "Azerbaijani": {
        "ISO_639_1_code": "az",
        "ISO_639_2_code": "aze",
        "ISO_639_3_code": "aze",
    },
    "Bambara": {
        "ISO_639_1_code": "bm",
        "ISO_639_2_code": "bam",
        "ISO_639_3_code": "bam",
    },
    "Bashkir": {
        "ISO_639_1_code": "ba",
        "ISO_639_2_code": "bak",
        "ISO_639_3_code": "bak",
    },
    "Basque": {
        "ISO_639_1_code": "eu",
        "ISO_639_2_code": "eus",
        "ISO_639_3_code": "eus",
    },
    "Belarusian": {
        "ISO_639_1_code": "be",
        "ISO_639_2_code": "bel",
        "ISO_639_3_code": "bel",
    },
    "Bengali": {
        "ISO_639_1_code": "bn",
        "ISO_639_2_code": "ben",
        "ISO_639_3_code": "ben",
    },
    "Bihari": {
        "ISO_639_1_code": "bh",
        "ISO_639_2_code": "bih",
        "ISO_639_3_code": "bih",
    },
    "Bislama": {
        "ISO_639_1_code": "bi",
        "ISO_639_2_code": "bis",
        "ISO_639_3_code": "bis",
    },
    "Bosnian": {
        "ISO_639_1_code": "bs",
        "ISO_639_2_code": "bos",
        "ISO_639_3_code": "bos",
    },
    "Breton": {
        "ISO_639_1_code": "br",
        "ISO_639_2_code": "bre",
        "ISO_639_3_code": "bre",
    },
    "Bulgarian": {
        "ISO_639_1_code": "bg",
        "ISO_639_2_code": "bul",
        "ISO_639_3_code": "bul",
    },
    "Burmese": {
        "ISO_639_1_code": "my",
        "ISO_639_2_code": "mya",
        "ISO_639_3_code": "mya",
    },
    "Catalan": {
        "ISO_639_1_code": "ca",
        "ISO_639_2_code": "cat",
        "ISO_639_3_code": "cat",
    },
    "Chamorro": {
        "ISO_639_1_code": "ch",
        "ISO_639_2_code": "cha",
        "ISO_639_3_code": "cha",
    },
    "Chechen": {
        "ISO_639_1_code": "ce",
        "ISO_639_2_code": "che",
        "ISO_639_3_code": "che",
    },
    "Chichewa": {
        "ISO_639_1_code": "ny",
        "ISO_639_2_code": "nya",
        "ISO_639_3_code": "nya",
    },
    "Chinese": {
        "ISO_639_1_code": "zh",
        "ISO_639_2_code": "zho",
        "ISO_639_3_code": "zho",
    },
    "Church Slavic": {
        "ISO_639_1_code": "cu",
        "ISO_639_2_code": "chu",
        "ISO_639_3_code": "chu",
    },
    "Chuvash": {
        "ISO_639_1_code": "cv",
        "ISO_639_2_code": "chv",
        "ISO_639_3_code": "chv",
    },
    "Cornish": {
        "ISO_639_1_code": "kw",
        "ISO_639_2_code": "cor",
        "ISO_639_3_code": "cor",
    },
    "Corsican": {
        "ISO_639_1_code": "co",
        "ISO_639_2_code": "cos",
        "ISO_639_3_code": "cos",
    },
    "Cree": {
        "ISO_639_1_code": "cr",
        "ISO_639_2_code": "cre",
        "ISO_639_3_code": "cre",
    },
    "Croatian": {
        "ISO_639_1_code": "hr",
        "ISO_639_2_code": "hrv",
        "ISO_639_3_code": "hrv",
    },
    "Czech": {
        "ISO_639_1_code": "cs",
        "ISO_639_2_code": "ces",
        "ISO_639_3_code": "ces",
    },
    "Danish": {
        "ISO_639_1_code": "da",
        "ISO_639_2_code": "dan",
        "ISO_639_3_code": "dan",
    },
    "Divehi": {
        "ISO_639_1_code": "dv",
        "ISO_639_2_code": "div",
        "ISO_639_3_code": "div",
    },
    "Dutch": {
        "ISO_639_1_code": "nl",
        "ISO_639_2_code": "nld",
        "ISO_639_3_code": "nld",
    },
    "Dzongkha": {
        "ISO_639_1_code": "dz",
        "ISO_639_2_code": "dzo",
        "ISO_639_3_code": "dzo",
    },
    "English": {
        "ISO_639_1_code": "en",
        "ISO_639_2_code": "eng",
        "ISO_639_3_code": "eng",
    },
    "Esperanto": {
        "ISO_639_1_code": "eo",
        "ISO_639_2_code": "epo",
        "ISO_639_3_code": "epo",
    },
    "Estonian": {
        "ISO_639_1_code": "et",
        "ISO_639_2_code": "est",
        "ISO_639_3_code": "est",
    },
    "Ewe": {
        "ISO_639_1_code": "ee",
        "ISO_639_2_code": "ewe",
        "ISO_639_3_code": "ewe",
    },
    "Faroese": {
        "ISO_639_1_code": "fo",
        "ISO_639_2_code": "fao",
        "ISO_639_3_code": "fao",
    },
    "Fijian": {
        "ISO_639_1_code": "fj",
        "ISO_639_2_code": "fij",
        "ISO_639_3_code": "fij",
    },
    "Finnish": {
        "ISO_639_1_code": "fi",
        "ISO_639_2_code": "fin",
        "ISO_639_3_code": "fin",
    },
    "French": {
        "ISO_639_1_code": "fr",
        "ISO_639_2_code": "fra",
        "ISO_639_3_code": "fra",
    },
    "Fulah": {
        "ISO_639_1_code": "ff",
        "ISO_639_2_code": "ful",
        "ISO_639_3_code": "ful",
    },
    "Galician": {
        "ISO_639_1_code": "gl",
        "ISO_639_2_code": "glg",
        "ISO_639_3_code": "glg",
    },
    "Georgian": {
        "ISO_639_1_code": "ka",
        "ISO_639_2_code": "kat",
        "ISO_639_3_code": "kat",
    },
    "German": {
        "ISO_639_1_code": "de",
        "ISO_639_2_code": "deu",
        "ISO_639_3_code": "deu",
    },
    "Greek": {
        "ISO_639_1_code": "el",
        "ISO_639_2_code": "ell",
        "ISO_639_3_code": "ell",
    },
    "Guarani": {
        "ISO_639_1_code": "gn",
        "ISO_639_2_code": "grn",
        "ISO_639_3_code": "grn",
    },
    "Gujarati": {
        "ISO_639_1_code": "gu",
        "ISO_639_2_code": "guj",
        "ISO_639_3_code": "guj",
    },
    "Haitian": {
        "ISO_639_1_code": "ht",
        "ISO_639_2_code": "hat",
        "ISO_639_3_code": "hat",
    },
    "Hausa": {
        "ISO_639_1_code": "ha",
        "ISO_639_2_code": "hau",
        "ISO_639_3_code": "hau",
    },
    "Hebrew": {
        "ISO_639_1_code": "he",
        "ISO_639_2_code": "heb",
        "ISO_639_3_code": "heb",
    },
    "Herero": {
        "ISO_639_1_code": "hz",
        "ISO_639_2_code": "her",
        "ISO_639_3_code": "her",
    },
    "Hindi": {
        "ISO_639_1_code": "hi",
        "ISO_639_2_code": "hin",
        "ISO_639_3_code": "hin",
    },
    "Hiri Motu": {
        "ISO_639_1_code": "ho",
        "ISO_639_2_code": "hmo",
        "ISO_639_3_code": "hmo",
    },
    "Hungarian": {
        "ISO_639_1_code": "hu",
        "ISO_639_2_code": "hun",
        "ISO_639_3_code": "hun",
    },
    "Icelandic": {
        "ISO_639_1_code": "is",
        "ISO_639_2_code": "isl",
        "ISO_639_3_code": "isl",
    },
    "Ido": {
        "ISO_639_1_code": "io",
        "ISO_639_2_code": "ido",
        "ISO_639_3_code": "ido",
    },
    "Igbo": {
        "ISO_639_1_code": "ig",
        "ISO_639_2_code": "ibo",
        "ISO_639_3_code": "ibo",
    },
    "Indonesian": {
        "ISO_639_1_code": "id",
        "ISO_639_2_code": "ind",
        "ISO_639_3_code": "ind",
    },
    "Interlingua": {
        "ISO_639_1_code": "ia",
        "ISO_639_2_code": "ina",
        "ISO_639_3_code": "ina",
    },
    "Interlingue": {
        "ISO_639_1_code": "ie",
        "ISO_639_2_code": "ile",
        "ISO_639_3_code": "ile",
    },
    "Inuktitut": {
        "ISO_639_1_code": "iu",
        "ISO_639_2_code": "iku",
        "ISO_639_3_code": "iku",
    },
    "Inupiaq": {
        "ISO_639_1_code": "ik",
        "ISO_639_2_code": "ipk",
        "ISO_639_3_code": "ipk",
    },
    "Irish": {
        "ISO_639_1_code": "ga",
        "ISO_639_2_code": "gle",
        "ISO_639_3_code": "gle",
    },
    "Italian": {
        "ISO_639_1_code": "it",
        "ISO_639_2_code": "ita",
        "ISO_639_3_code": "ita",
    },
    "Japanese": {
        "ISO_639_1_code": "ja",
        "ISO_639_2_code": "jpn",
        "ISO_639_3_code": "jpn",
    },
    "Javanese": {
        "ISO_639_1_code": "jv",
        "ISO_639_2_code": "jav",
        "ISO_639_3_code": "jav",
    },
    "Kalaallisut": {
        "ISO_639_1_code": "kl",
        "ISO_639_2_code": "kal",
        "ISO_639_3_code": "kal",
    },
    "Kannada": {
        "ISO_639_1_code": "kn",
        "ISO_639_2_code": "kan",
        "ISO_639_3_code": "kan",
    },
    "Kanuri": {
        "ISO_639_1_code": "kr",
        "ISO_639_2_code": "kau",
        "ISO_639_3_code": "kau",
    },
    "Kashmiri": {
        "ISO_639_1_code": "ks",
        "ISO_639_2_code": "kas",
        "ISO_639_3_code": "kas",
    },
    "Kazakh": {
        "ISO_639_1_code": "kk",
        "ISO_639_2_code": "kaz",
        "ISO_639_3_code": "kaz",
    },
    "Khmer": {
        "ISO_639_1_code": "km",
        "ISO_639_2_code": "khm",
        "ISO_639_3_code": "khm",
    },
    "Kikuyu": {
        "ISO_639_1_code": "ki",
        "ISO_639_2_code": "kik",
        "ISO_639_3_code": "kik",
    },
    "Kinyarwanda": {
        "ISO_639_1_code": "rw",
        "ISO_639_2_code": "kin",
        "ISO_639_3_code": "kin",
    },
    "Kirghiz": {
        "ISO_639_1_code": "ky",
        "ISO_639_2_code": "kir",
        "ISO_639_3_code": "kir",
    },
    "Komi": {
        "ISO_639_1_code": "kv",
        "ISO_639_2_code": "kom",
        "ISO_639_3_code": "kom",
    },
    "Kongo": {
        "ISO_639_1_code": "kg",
        "ISO_639_2_code": "kon",
        "ISO_639_3_code": "kon",
    },
    "Korean": {
        "ISO_639_1_code": "ko",
        "ISO_639_2_code": "kor",
        "ISO_639_3_code": "kor",
    },
    "Kuanyama": {
        "ISO_639_1_code": "kj",
        "ISO_639_2_code": "kua",
        "ISO_639_3_code": "kua",
    },
    "Kurdish": {
        "ISO_639_1_code": "ku",
        "ISO_639_2_code": "kur",
        "ISO_639_3_code": "kur",
    },
    "Lao": {
        "ISO_639_1_code": "lo",
        "ISO_639_2_code": "lao",
        "ISO_639_3_code": "lao",
    },
    "Latin": {
        "ISO_639_1_code": "la",
        "ISO_639_2_code": "lat",
        "ISO_639_3_code": "lat",
    },
    "Latvian": {
        "ISO_639_1_code": "lv",
        "ISO_639_2_code": "lav",
        "ISO_639_3_code": "lav",
    },
    "Limburgan": {
        "ISO_639_1_code": "li",
        "ISO_639_2_code": "lim",
        "ISO_639_3_code": "lim",
    },
    "Lingala": {
        "ISO_639_1_code": "ln",
        "ISO_639_2_code": "lin",
        "ISO_639_3_code": "lin",
    },
    "Lithuanian": {
        "ISO_639_1_code": "lt",
        "ISO_639_2_code": "lit",
        "ISO_639_3_code": "lit",
    },
    "Luba-Katanga": {
        "ISO_639_1_code": "lu",
        "ISO_639_2_code": "lub",
        "ISO_639_3_code": "lub",
    },
    "Luxembourgish": {
        "ISO_639_1_code": "lb",
        "ISO_639_2_code": "ltz",
        "ISO_639_3_code": "ltz",
    },
    "Macedonian": {
        "ISO_639_1_code": "mk",
        "ISO_639_2_code": "mkd",
        "ISO_639_3_code": "mkd",
    },
    "Malagasy": {
        "ISO_639_1_code": "mg",
        "ISO_639_2_code": "mlg",
        "ISO_639_3_code": "mlg",
    },
    "Malay": {
        "ISO_639_1_code": "ms",
        "ISO_639_2_code": "msa",
        "ISO_639_3_code": "msa",
    },
    "Malayalam": {
        "ISO_639_1_code": "ml",
        "ISO_639_2_code": "mal",
        "ISO_639_3_code": "mal",
    },
    "Maltese": {
        "ISO_639_1_code": "mt",
        "ISO_639_2_code": "mlt",
        "ISO_639_3_code": "mlt",
    },
    "Manx": {
        "ISO_639_1_code": "gv",
        "ISO_639_2_code": "glv",
        "ISO_639_3_code": "glv",
    },
    "Maori": {
        "ISO_639_1_code": "mi",
        "ISO_639_2_code": "mri",
        "ISO_639_3_code": "mri",
    },
    "Marathi": {
        "ISO_639_1_code": "mr",
        "ISO_639_2_code": "mar",
        "ISO_639_3_code": "mar",
    },
    "Marshallese": {
        "ISO_639_1_code": "mh",
        "ISO_639_2_code": "mah",
        "ISO_639_3_code": "mah",
    },
    "Mongolian": {
        "ISO_639_1_code": "mn",
        "ISO_639_2_code": "mon",
        "ISO_639_3_code": "mon",
    },
    "Nauru": {
        "ISO_639_1_code": "na",
        "ISO_639_2_code": "nau",
        "ISO_639_3_code": "nau",
    },
    "Navajo": {
        "ISO_639_1_code": "nv",
        "ISO_639_2_code": "nav",
        "ISO_639_3_code": "nav",
    },
    "Ndonga": {
        "ISO_639_1_code": "ng",
        "ISO_639_2_code": "ndo",
        "ISO_639_3_code": "ndo",
    },
    "Nepali": {
        "ISO_639_1_code": "ne",
        "ISO_639_2_code": "nep",
        "ISO_639_3_code": "nep",
    },
    "North Ndebele": {
        "ISO_639_1_code": "nd",
        "ISO_639_2_code": "nde",
        "ISO_639_3_code": "nde",
    },
    "Northern Sami": {
        "ISO_639_1_code": "se",
        "ISO_639_2_code": "sme",
        "ISO_639_3_code": "sme",
    },
    "Norwegian": {
        "ISO_639_1_code": "no",
        "ISO_639_2_code": "nor",
        "ISO_639_3_code": "nor",
    },
    "Norwegian Bokmål": {
        "ISO_639_1_code": "nb",
        "ISO_639_2_code": "nob",
        "ISO_639_3_code": "nob",
    },
    "Norwegian Nynorsk": {
        "ISO_639_1_code": "nn",
        "ISO_639_2_code": "nno",
        "ISO_639_3_code": "nno",
    },
    "Occitan": {
        "ISO_639_1_code": "oc",
        "ISO_639_2_code": "oci",
        "ISO_639_3_code": "oci",
    },
    "Ojibwa": {
        "ISO_639_1_code": "oj",
        "ISO_639_2_code": "oji",
        "ISO_639_3_code": "oji",
    },
    "Oriya": {
        "ISO_639_1_code": "or",
        "ISO_639_2_code": "ori",
        "ISO_639_3_code": "ori",
    },
    "Oromo": {
        "ISO_639_1_code": "om",
        "ISO_639_2_code": "orm",
        "ISO_639_3_code": "orm",
    },
    "Ossetian": {
        "ISO_639_1_code": "os",
        "ISO_639_2_code": "oss",
        "ISO_639_3_code": "oss",
    },
    "Pali": {
        "ISO_639_1_code": "pi",
        "ISO_639_2_code": "pli",
        "ISO_639_3_code": "pli",
    },
    "Pashto": {
        "ISO_639_1_code": "ps",
        "ISO_639_2_code": "pus",
        "ISO_639_3_code": "pus",
    },
    "Persian": {
        "ISO_639_1_code": "fa",
        "ISO_639_2_code": "fas",
        "ISO_639_3_code": "fas",
    },
    "Polish": {
        "ISO_639_1_code": "pl",
        "ISO_639_2_code": "pol",
        "ISO_639_3_code": "pol",
    },
    "Portuguese": {
        "ISO_639_1_code": "pt",
        "ISO_639_2_code": "por",
        "ISO_639_3_code": "por",
    },
    "Punjabi": {
        "ISO_639_1_code": "pa",
        "ISO_639_2_code": "pan",
        "ISO_639_3_code": "pan",
    },
    "Quechua": {
        "ISO_639_1_code": "qu",
        "ISO_639_2_code": "que",
        "ISO_639_3_code": "que",
    },
    "Romanian": {
        "ISO_639_1_code": "ro",
        "ISO_639_2_code": "ron",
        "ISO_639_3_code": "ron",
    },
    "Romansh": {
        "ISO_639_1_code": "rm",
        "ISO_639_2_code": "roh",
        "ISO_639_3_code": "roh",
    },
    "Rundi": {
        "ISO_639_1_code": "rn",
        "ISO_639_2_code": "run",
        "ISO_639_3_code": "run",
    },
    "Russian": {
        "ISO_639_1_code": "ru",
        "ISO_639_2_code": "rus",
        "ISO_639_3_code": "rus",
    },
    "Samoan": {
        "ISO_639_1_code": "sm",
        "ISO_639_2_code": "smo",
        "ISO_639_3_code": "smo",
    },
    "Sango": {
        "ISO_639_1_code": "sg",
        "ISO_639_2_code": "sag",
        "ISO_639_3_code": "sag",
    },
    "Sanskrit": {
        "ISO_639_1_code": "sa",
        "ISO_639_2_code": "san",
        "ISO_639_3_code": "san",
    },
    "Sardinian": {
        "ISO_639_1_code": "sc",
        "ISO_639_2_code": "srd",
        "ISO_639_3_code": "srd",
    },
    "Scottish Gaelic": {
        "ISO_639_1_code": "gd",
        "ISO_639_2_code": "gla",
        "ISO_639_3_code": "gla",
    },
    "Serbian": {
        "ISO_639_1_code": "sr",
        "ISO_639_2_code": "srp",
        "ISO_639_3_code": "srp",
    },
    "Shona": {
        "ISO_639_1_code": "sn",
        "ISO_639_2_code": "sna",
        "ISO_639_3_code": "sna",
    },
    "Sindhi": {
        "ISO_639_1_code": "sd",
        "ISO_639_2_code": "snd",
        "ISO_639_3_code": "snd",
    },
    "Sinhala": {
        "ISO_639_1_code": "si",
        "ISO_639_2_code": "sin",
        "ISO_639_3_code": "sin",
    },
    "Slovak": {
        "ISO_639_1_code": "sk",
        "ISO_639_2_code": "slk",
        "ISO_639_3_code": "slk",
    },
    "Slovenian": {
        "ISO_639_1_code": "sl",
        "ISO_639_2_code": "slv",
        "ISO_639_3_code": "slv",
    },
    "Somali": {
        "ISO_639_1_code": "so",
        "ISO_639_2_code": "som",
        "ISO_639_3_code": "som",
    },
    "Southern Ndebele": {
        "ISO_639_1_code": "nr",
        "ISO_639_2_code": "nbl",
        "ISO_639_3_code": "nbl",
    },
    "Southern Sotho": {
        "ISO_639_1_code": "st",
        "ISO_639_2_code": "sot",
        "ISO_639_3_code": "sot",
    },
    "Spanish": {
        "ISO_639_1_code": "es",
        "ISO_639_2_code": "spa",
        "ISO_639_3_code": "spa",
    },
    "Sundanese": {
        "ISO_639_1_code": "su",
        "ISO_639_2_code": "sun",
        "ISO_639_3_code": "sun",
    },
    "Swahili": {
        "ISO_639_1_code": "sw",
        "ISO_639_2_code": "swa",
        "ISO_639_3_code": "swa",
    },
    "Swati": {
        "ISO_639_1_code": "ss",
        "ISO_639_2_code": "ssw",
        "ISO_639_3_code": "ssw",
    },
    "Swedish": {
        "ISO_639_1_code": "sv",
        "ISO_639_2_code": "swe",
        "ISO_639_3_code": "swe",
    },
    "Tagalog": {
        "ISO_639_1_code": "tl",
        "ISO_639_2_code": "tgl",
        "ISO_639_3_code": "tgl",
    },
    "Tahitian": {
        "ISO_639_1_code": "ty",
        "ISO_639_2_code": "tah",
        "ISO_639_3_code": "tah",
    },
    "Tajik": {
        "ISO_639_1_code": "tg",
        "ISO_639_2_code": "tgk",
        "ISO_639_3_code": "tgk",
    },
    "Tamil": {
        "ISO_639_1_code": "ta",
        "ISO_639_2_code": "tam",
        "ISO_639_3_code": "tam",
    },
    "Tatar": {
        "ISO_639_1_code": "tt",
        "ISO_639_2_code": "tat",
        "ISO_639_3_code": "tat",
    },
    "Telugu": {
        "ISO_639_1_code": "te",
        "ISO_639_2_code": "tel",
        "ISO_639_3_code": "tel",
    },
    "Thai": {
        "ISO_639_1_code": "th",
        "ISO_639_2_code": "tha",
        "ISO_639_3_code": "tha",
    },
    "Tibetan": {
        "ISO_639_1_code": "bo",
        "ISO_639_2_code": "bod",
        "ISO_639_3_code": "bod",
    },
    "Tigrinya": {
        "ISO_639_1_code": "ti",
        "ISO_639_2_code": "tir",
        "ISO_639_3_code": "tir",
    },
    "Tonga": {
        "ISO_639_1_code": "to",
        "ISO_639_2_code": "ton",
        "ISO_639_3_code": "ton",
    },
    "Tsonga": {
        "ISO_639_1_code": "ts",
        "ISO_639_2_code": "tso",
        "ISO_639_3_code": "tso",
    },
    "Tswana": {
        "ISO_639_1_code": "tn",
        "ISO_639_2_code": "tsn",
        "ISO_639_3_code": "tsn",
    },
    "Turkish": {
        "ISO_639_1_code": "tr",
        "ISO_639_2_code": "tur",
        "ISO_639_3_code": "tur",
    },
    "Turkmen": {
        "ISO_639_1_code": "tk",
        "ISO_639_2_code": "tuk",
        "ISO_639_3_code": "tuk",
    },
    "Twi": {
        "ISO_639_1_code": "tw",
        "ISO_639_2_code": "twi",
        "ISO_639_3_code": "twi",
    },
    "Uyghur": {
        "ISO_639_1_code": "ug",
        "ISO_639_2_code": "uig",
        "ISO_639_3_code": "uig",
    },
    "Ukrainian": {
        "ISO_639_1_code": "uk",
        "ISO_639_2_code": "ukr",
        "ISO_639_3_code": "ukr",
    },
    "Urdu": {
        "ISO_639_1_code": "ur",
        "ISO_639_2_code": "urd",
        "ISO_639_3_code": "urd",
    },
    "Uzbek": {
        "ISO_639_1_code": "uz",
        "ISO_639_2_code": "uzb",
        "ISO_639_3_code": "uzb",
    },
    "Venda": {
        "ISO_639_1_code": "ve",
        "ISO_639_2_code": "ven",
        "ISO_639_3_code": "ven",
    },
    "Vietnamese": {
        "ISO_639_1_code": "vi",
        "ISO_639_2_code": "vie",
        "ISO_639_3_code": "vie",
    },
    "Volapük": {
        "ISO_639_1_code": "vo",
        "ISO_639_2_code": "vol",
        "ISO_639_3_code": "vol",
    },
    "Walloon": {
        "ISO_639_1_code": "wa",
        "ISO_639_2_code": "wln",
        "ISO_639_3_code": "wln",
    },
    "Welsh": {
        "ISO_639_1_code": "cy",
        "ISO_639_2_code": "cym",
        "ISO_639_3_code": "cym",
    },
    "Western Frisian": {
        "ISO_639_1_code": "fy",
        "ISO_639_2_code": "fry",
        "ISO_639_3_code": "fry",
    },
    "Wolof": {
        "ISO_639_1_code": "wo",
        "ISO_639_2_code": "wol",
        "ISO_639_3_code": "wol",
    },
    "Xhosa": {
        "ISO_639_1_code": "xh",
        "ISO_639_2_code": "xho",
        "ISO_639_3_code": "xho",
    },
    "Yiddish": {
        "ISO_639_1_code": "yi",
        "ISO_639_2_code": "yid",
        "ISO_639_3_code": "yid",
    },
    "Yoruba": {
        "ISO_639_1_code": "yo",
        "ISO_639_2_code": "yor",
        "ISO_639_3_code": "yor",
    },
    "Zhuang": {
        "ISO_639_1_code": "za",
        "ISO_639_2_code": "zha",
        "ISO_639_3_code": "zha",
    },
    "Zulu": {
        "ISO_639_1_code": "zu",
        "ISO_639_2_code": "zul",
        "ISO_639_3_code": "zul",
    }
}


# Reverse lookup dictionaries for iso codes
iso_639_1_to_name = {v['ISO_639_1_code']: k for k, v in language_data.items()}
iso_639_2_to_name = {v['ISO_639_2_code']: k for k, v in language_data.items()}
iso_639_3_to_name = {v['ISO_639_3_code']: k for k, v in language_data.items()}


def get_language_info(identifier):
    # Check if the identifier is a language name
    if identifier in language_data:
        language_name = identifier
    # Check if the identifier is an ISO 639-1 code
    elif identifier in iso_639_1_to_name:
        language_name = iso_639_1_to_name[identifier]
    # Check if the identifier is an ISO 639-2 code
    elif identifier in iso_639_2_to_name:
        language_name = iso_639_2_to_name[identifier]
    # Check if the identifier is an ISO 639-3 code
    elif identifier in iso_639_3_to_name:
        language_name = iso_639_3_to_name[identifier]
    else:
        return None  # Identifier not found

    # Retrieve the language info
    info = language_data[language_name]
    return {
        "language_name": language_name,
        "ISO_639_1_code": info["ISO_639_1_code"],
        "ISO_639_2_code": info["ISO_639_2_code"],
        "ISO_639_3_code": info["ISO_639_3_code"],
    }
