from collections.abc import Generator
from typing import NamedTuple

from _typeshed import Incomplete
from xmldiff import utils as utils
from xmldiff.diff_match_patch import diff_match_patch as diff_match_patch

DIFF_NS: str
DIFF_PREFIX: str
INSERT_NAME: Incomplete
DELETE_NAME: Incomplete
RENAME_NAME: Incomplete
WS_BOTH: int
WS_TEXT: int
WS_TAGS: int
WS_NONE: int
T_OPEN: int
T_CLOSE: int
T_SINGLE: int
PLACEHOLDER_START: int

class BaseFormatter:
    def __init__(self, normalize=..., pretty_print: bool = ...) -> None: ...
    def prepare(self, left_tree, right_tree) -> None: ...
    def format(self, diff, orig_tree) -> None: ...

class PlaceholderEntry(NamedTuple):
    element: Incomplete
    ttype: Incomplete
    close_ph: Incomplete

class PlaceholderMaker:
    text_tags: Incomplete
    formatting_tags: Incomplete
    placeholder2tag: Incomplete
    tag2placeholder: Incomplete
    placeholder: Incomplete
    diff_tags: Incomplete
    def __init__(self, text_tags=..., formatting_tags=...) -> None: ...
    def get_placeholder(self, element, ttype, close_ph): ...
    def is_placeholder(self, char): ...
    def is_formatting(self, element): ...
    def do_element(self, element) -> None: ...
    def do_tree(self, tree) -> None: ...
    def split_string(self, text): ...
    def undo_string(self, text): ...
    def undo_element(self, elem) -> None: ...
    def undo_tree(self, tree) -> None: ...
    def mark_diff(self, ph, action): ...
    def wrap_diff(self, text, action): ...

class XMLFormatter(BaseFormatter):
    normalize: Incomplete
    pretty_print: Incomplete
    text_tags: Incomplete
    formatting_tags: Incomplete
    placeholderer: Incomplete
    def __init__(
        self,
        normalize=...,
        pretty_print: bool = ...,
        text_tags=...,
        formatting_tags=...,
    ) -> None: ...
    def prepare(self, left_tree, right_tree) -> None: ...
    def finalize(self, result_tree) -> None: ...
    def format(self, diff, orig_tree, differ: Incomplete | None = ...): ...
    def render(self, result): ...
    def handle_action(self, action, result) -> None: ...

class DiffFormatter(BaseFormatter):
    normalize: Incomplete
    def __init__(self, normalize=..., pretty_print: bool = ...) -> None: ...
    def prepare(self, left, right) -> None: ...
    def finalize(self, left, right) -> None: ...
    def format(self, diff, orig_tree): ...
    def handle_action(self, action): ...

class XmlDiffFormatter(BaseFormatter):
    normalize: Incomplete
    def __init__(self, normalize=..., pretty_print: bool = ...) -> None: ...
    def prepare(self, left, right) -> None: ...
    def finalize(self, left, right) -> None: ...
    def format(self, diff, orig_tree): ...
    def handle_action(
        self, action, orig_tree
    ) -> Generator[Incomplete, None, None]: ...
