import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface DataLakeBucketProps {
    /**
     * @stability stable
     */
    readonly bucketName: string;
    /**
     * @stability stable
     */
    readonly dataCatalogAccountId: string;
    /**
     * @stability stable
     */
    readonly logBucket: s3.Bucket;
    /**
     * @stability stable
     */
    readonly crossAccount: boolean;
    /**
     * @stability stable
     */
    readonly s3Properties: s3.BucketProps | undefined;
}
/**
 * @stability stable
 */
export declare class DataLakeBucket extends Construct {
    /**
     * @stability stable
     */
    readonly bucket: s3.Bucket;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DataLakeBucketProps);
}
