import { IRole } from 'aws-cdk-lib/aws-iam';
import * as kms from 'aws-cdk-lib/aws-kms';
import * as lf from 'aws-cdk-lib/aws-lakeformation';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Bucket } from 'aws-cdk-lib/aws-s3';
import * as sns from 'aws-cdk-lib/aws-sns';
import { Construct } from 'constructs';
import { LakeType } from '..';
import { Stage } from '../data-lake';
import { DataProduct } from '../data-product';
import { Pipeline, S3NotificationProperties } from '../pipeline';
/**
 * @stability stable
 */
export declare enum DataTier {
    /**
     * @stability stable
     */
    RAW = "raw",
    /**
     * @stability stable
     */
    REFINED = "refined",
    /**
     * @stability stable
     */
    TRUSTED = "trusted"
}
/**
 * @stability stable
 */
export interface DataSetProperties {
    /**
     * @stability stable
     */
    readonly encryptionKey?: kms.Key;
    /**
     * @stability stable
     */
    readonly logBucket: s3.Bucket;
    /**
     * @stability stable
     */
    readonly stage: Stage;
    /**
     * @stability stable
     */
    readonly pipeline: Pipeline;
    /**
     * @stability stable
     */
    readonly dataProduct: DataProduct;
    /**
     * @stability stable
     */
    readonly s3BucketProps: s3.BucketProps | undefined;
    /**
     * @stability stable
     */
    readonly lakeType: LakeType;
    /**
     * @stability stable
     */
    readonly dataTiers: DataTier[];
    /**
     * @stability stable
     */
    readonly datalakeAdminRole: IRole;
    /**
     * @stability stable
     */
    readonly datalakeDbCreatorRole: IRole;
}
/**
 * @stability stable
 */
export interface DataSetResult {
    /**
     * @stability stable
     */
    readonly destinationBucketName?: string;
    /**
     * @stability stable
     */
    readonly destinationPrefix: string;
    /**
     * @stability stable
     */
    readonly sourceBucketName: string | undefined;
    /**
     * @stability stable
     */
    readonly sourceKeys: string[] | undefined;
}
/**
 * @stability stable
 */
export interface DataTierBucketProps {
    /**
     * @stability stable
     */
    readonly lakeType: LakeType;
    /**
     * @stability stable
     */
    readonly pipelineName: string;
    /**
     * @stability stable
     */
    readonly bucketName: string | undefined;
    /**
     * @stability stable
     */
    readonly dataCatalogAccountId: string;
    /**
     * @stability stable
     */
    readonly logBucket: Bucket;
    /**
     * @stability stable
     */
    readonly crossAccount: boolean;
    /**
     * @stability stable
     */
    readonly s3BucketProps: s3.BucketProps | undefined;
    /**
     * @stability stable
     */
    readonly s3NotificationProps: S3NotificationProperties | undefined;
    /**
     * @stability stable
     */
    readonly datalakeAdminRole: IRole;
    /**
     * @stability stable
     */
    readonly datalakeDbCreatorRole: IRole;
    /**
     * @stability stable
     */
    readonly tier: DataTier;
}
/**
 * @stability stable
 */
export declare class DataSet extends Construct {
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly lakeType: LakeType;
    /**
     * @stability stable
     */
    readonly dropLocation?: DataTier;
    /**
     * @stability stable
     */
    readonly rawBucketName?: string;
    /**
     * @stability stable
     */
    readonly trustedBucketName?: string;
    /**
     * @stability stable
     */
    readonly refinedBucketName?: string;
    /**
     * @stability stable
     */
    readonly encryptionKey?: kms.Key;
    /**
     * @stability stable
     */
    readonly downloadLocations?: DataSetResult;
    /**
     * @stability stable
     */
    s3NotificationTopic?: sns.Topic;
    /**
     * @stability stable
     */
    readonly pipeline: Pipeline;
    /**
     * @stability stable
     */
    readonly dataProduct: DataProduct;
    /**
     * @stability stable
     */
    locationRegistry: lf.CfnResource[];
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DataSetProperties);
    private createS3NotificationTopic;
    private createDataTierBucket;
    private registerDataLakeLocation;
    private createDataLocationAccessPermission;
    /**
     * @stability stable
     */
    getDataSetBucketName(dataTier: DataTier): string | undefined;
}
