import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import { Construct } from 'constructs';
import { KinesisStream } from './kinesis-stream';
import { S3DeliveryStream } from './s3-delivery-stream';
/**
 * @stability stable
 */
export interface IKinesisOpsProperties {
    /**
     * @stability stable
     */
    stream: KinesisStream;
    /**
     * @stability stable
     */
    deliveryStream: S3DeliveryStream;
    /**
     * @stability stable
     */
    inputStreamIteratorAgeCritical?: cloudwatch.CreateAlarmOptions;
    /**
     * @stability stable
     */
    inputStreamIteratorAgeWarning?: cloudwatch.CreateAlarmOptions;
    /**
     * @stability stable
     */
    inputStreamReadThroughputWarning?: cloudwatch.CreateAlarmOptions;
    /**
     * @stability stable
     */
    inputStreamWriteThroughputWarning?: cloudwatch.CreateAlarmOptions;
    /**
     * @stability stable
     */
    inputStreamGetRecordsWarning?: cloudwatch.CreateAlarmOptions;
    /**
     * @stability stable
     */
    inputStreamPutRecordsWarning?: cloudwatch.CreateAlarmOptions;
    /**
     * @stability stable
     */
    firehoseDeliveryToS3Critical?: cloudwatch.CreateAlarmOptions;
    /**
     * @stability stable
     */
    firehoseDeliveryToS3Warning?: cloudwatch.CreateAlarmOptions;
}
/**
 * @stability stable
 */
export declare class KinesisOps extends Construct {
    /**
     * @stability stable
     */
    dashboard: cloudwatch.Dashboard;
    /**
     * @stability stable
     */
    readonly stream: KinesisStream;
    /**
     * @stability stable
     */
    readonly deliveryStream: S3DeliveryStream;
    /**
     * @stability stable
     */
    readonly streamName: string;
    /**
     * @stability stable
     */
    readonly inputStreamIteratorAgeCriticalAlarm: cloudwatch.Alarm;
    /**
     * @stability stable
     */
    readonly inputStreamIteratorAgeWarningAlarm: cloudwatch.Alarm;
    /**
     * @stability stable
     */
    readonly inputStreamReadThroughputWarningAlarm: cloudwatch.Alarm;
    /**
     * @stability stable
     */
    readonly inputStreamWriteThroughputWarningAlarm: cloudwatch.Alarm;
    /**
     * @stability stable
     */
    readonly inputStreamGetRecordsWarningAlarm: cloudwatch.Alarm;
    /**
     * @stability stable
     */
    readonly inputStreamPutRecordsWarningAlarm: cloudwatch.Alarm;
    /**
     * @stability stable
     */
    readonly firehoseDeliveryToS3WarningAlarm: cloudwatch.Alarm;
    /**
     * @stability stable
     */
    readonly firehoseDeliveryToS3CriticalAlarm: cloudwatch.Alarm;
    /**
     * @stability stable
     */
    readonly alarmsSev2: cloudwatch.Alarm[];
    /**
     * @stability stable
     */
    readonly alarmsSev3: cloudwatch.Alarm[];
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: IKinesisOpsProperties);
    private alarmWidgets;
    private addWidgets;
    private setupDashboard;
}
