import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as kinesis from 'aws-cdk-lib/aws-kinesis';
import * as cdk from 'aws-cdk-lib/core';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export declare class KinesisStream extends cdk.Resource {
    /**
     * @stability stable
     */
    readonly stream: kinesis.Stream;
    /**
     * @stability stable
     */
    constructor(parent: Construct, name: string, props: kinesis.StreamProps);
    /**
     * @stability stable
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricGetRecordsBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricGetRecordsIteratorAgeMilliseconds(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricGetRecordsLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricGetRecordsRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricGetRecordsSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricIncomingBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricIncomingRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricPutRecordBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricPutRecordLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricPutRecordSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricPutRecordsBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricPutRecordsLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricPutRecordsRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricPutRecordsSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricReadProvisionedThroughputExceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricWriteProvisionedThroughputExceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricSubscribeToShardRateExceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricSubscribeToShardSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricSubscribeToShardEventBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricSubscribeToShardEventMillisBehindLatest(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricSubscribeToShardEventRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricSubscribeToShardEventSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
}
