"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisStream = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudwatch = require("aws-cdk-lib/aws-cloudwatch");
const kinesis = require("aws-cdk-lib/aws-kinesis");
const cdk = require("aws-cdk-lib/core");
/**
 * @stability stable
 */
class KinesisStream extends cdk.Resource {
    /**
     * @stability stable
     */
    constructor(parent, name, props) {
        super(parent, name);
        this.stream = new kinesis.Stream(this, 'kinesis-stream', props);
    }
    /**
     * @stability stable
     */
    metric(metricName, props) {
        return new cloudwatch.Metric({
            namespace: 'AWS/Kinesis',
            metricName,
            dimensionsMap: {
                StreamName: this.stream.streamName,
            },
            ...props,
        });
    }
    /**
     * @stability stable
     */
    metricGetRecordsBytes(props) {
        return this.metric('GetRecords.Bytes', props);
    }
    /**
     * @stability stable
     */
    metricGetRecordsIteratorAgeMilliseconds(props) {
        return this.metric('GetRecords.IteratorAgeMilliseconds', props);
    }
    /**
     * @stability stable
     */
    metricGetRecordsLatency(props) {
        return this.metric('GetRecords.Latency', props);
    }
    /**
     * @stability stable
     */
    metricGetRecordsRecords(props) {
        return this.metric('GetRecords.Records', props);
    }
    /**
     * @stability stable
     */
    metricGetRecordsSuccess(props) {
        return this.metric('GetRecords.Success', props);
    }
    /**
     * @stability stable
     */
    metricIncomingBytes(props) {
        return this.metric('IncomingBytes', props);
    }
    /**
     * @stability stable
     */
    metricIncomingRecords(props) {
        return this.metric('IncomingRecords', props);
    }
    /**
     * @stability stable
     */
    metricPutRecordBytes(props) {
        return this.metric('PutRecord.Bytes', props);
    }
    /**
     * @stability stable
     */
    metricPutRecordLatency(props) {
        return this.metric('PutRecord.Latency', props);
    }
    /**
     * @stability stable
     */
    metricPutRecordSuccess(props) {
        return this.metric('PutRecord.Success', props);
    }
    /**
     * @stability stable
     */
    metricPutRecordsBytes(props) {
        return this.metric('PutRecords.Bytes', props);
    }
    /**
     * @stability stable
     */
    metricPutRecordsLatency(props) {
        return this.metric('PutRecords.Latency', props);
    }
    /**
     * @stability stable
     */
    metricPutRecordsRecords(props) {
        return this.metric('PutRecords.Records', props);
    }
    /**
     * @stability stable
     */
    metricPutRecordsSuccess(props) {
        return this.metric('PutRecords.Success', props);
    }
    /**
     * @stability stable
     */
    metricReadProvisionedThroughputExceeded(props) {
        return this.metric('ReadProvisionedThroughputExceeded', props);
    }
    /**
     * @stability stable
     */
    metricWriteProvisionedThroughputExceeded(props) {
        return this.metric('WriteProvisionedThroughputExceeded', props);
    }
    /**
     * @stability stable
     */
    metricSubscribeToShardRateExceeded(props) {
        return this.metric('SubscribeToShard.RateExceeded', props);
    }
    /**
     * @stability stable
     */
    metricSubscribeToShardSuccess(props) {
        return this.metric('SubscribeToShard.Success', props);
    }
    /**
     * @stability stable
     */
    metricSubscribeToShardEventBytes(props) {
        return this.metric('SubscribeToShardEvent.Bytes', props);
    }
    /**
     * @stability stable
     */
    metricSubscribeToShardEventMillisBehindLatest(props) {
        return this.metric('SubscribeToShardEvent.MillisBehindLatest', props);
    }
    /**
     * @stability stable
     */
    metricSubscribeToShardEventRecords(props) {
        return this.metric('SubscribeToShardEvent.Records', props);
    }
    /**
     * @stability stable
     */
    metricSubscribeToShardEventSuccess(props) {
        return this.metric('SubscribeToShardEvent.Success', props);
    }
}
exports.KinesisStream = KinesisStream;
_a = JSII_RTTI_SYMBOL_1;
KinesisStream[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.KinesisStream", version: "0.0.44" };
//# sourceMappingURL=data:application/json;base64,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