import { Resource } from 'aws-cdk-lib';
import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as kinesis from 'aws-cdk-lib/aws-kinesis';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export declare enum DeliveryStreamType {
    /**
     * @stability stable
     */
    DIRECT_PUT = "DirectPut",
    /**
     * @stability stable
     */
    KINESIS_STREAM_AS_SOURCE = "KinesisStreamAsSource"
}
export declare enum ProcessorType {
    /**
     * @stability stable
     */
    LAMBDA = "Lambda"
}
/**
 * @stability stable
 */
export declare enum CompressionType {
    /**
     * @stability stable
     */
    UNCOMPRESSED = "UNCOMPRESSED",
    /**
     * @stability stable
     */
    GZIP = "GZIP",
    /**
     * @stability stable
     */
    ZIP = "ZIP",
    /**
     * @stability stable
     */
    SNAPPY = "Snappy"
}
/**
 * @stability stable
 */
export interface DeliveryStreamProperties {
    /**
     * @stability stable
     */
    readonly kinesisStream: kinesis.Stream;
    /**
     * @stability stable
     */
    readonly s3Bucket: s3.IBucket;
    /**
     * @stability stable
     */
    readonly s3Prefix?: string;
    /**
     * @stability stable
     */
    readonly compression?: CompressionType;
    /**
     * @stability stable
     */
    readonly transformFunction?: lambda.Function;
}
/**
 * @stability stable
 */
export declare class S3DeliveryStream extends Resource {
    /**
     * @stability stable
     */
    s3Bucket: s3.IBucket;
    /**
     * @stability stable
     */
    protected cloudWatchLogsRole?: iam.Role;
    /**
     * @stability stable
     */
    readonly deliveryStreamArn: string;
    /**
     * @stability stable
     */
    readonly deliveryStreamName: string;
    private readonly role;
    private readonly deliveryStreamResource;
    /**
     * @stability stable
     */
    constructor(parent: Construct, name: string, props: DeliveryStreamProperties);
    /**
     * @stability stable
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricBackupToS3Bytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricBackupToS3DataFreshness(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricBackupToS3Records(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricBackupToS3Success(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricDataReadFromKinesisStreamBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricDataReadFromKinesisStreamRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricDeliveryToS3Bytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricDeliveryToS3DataFreshness(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricDeliveryToS3Records(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricDeliveryToS3Success(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricIncomingBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricIncomingRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private makeKinesisSourceConfig;
    private makeS3Config;
    private makeProcessorConfig;
}
