"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3DeliveryStream = exports.CompressionType = exports.ProcessorType = exports.DeliveryStreamType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cloudwatch = require("aws-cdk-lib/aws-cloudwatch");
const iam = require("aws-cdk-lib/aws-iam");
const firehose = require("aws-cdk-lib/aws-kinesisfirehose");
/**
 * @stability stable
 */
var DeliveryStreamType;
(function (DeliveryStreamType) {
    DeliveryStreamType["DIRECT_PUT"] = "DirectPut";
    DeliveryStreamType["KINESIS_STREAM_AS_SOURCE"] = "KinesisStreamAsSource";
})(DeliveryStreamType = exports.DeliveryStreamType || (exports.DeliveryStreamType = {}));
var ProcessorType;
(function (ProcessorType) {
    ProcessorType["LAMBDA"] = "Lambda";
})(ProcessorType = exports.ProcessorType || (exports.ProcessorType = {}));
/**
 * @stability stable
 */
var CompressionType;
(function (CompressionType) {
    CompressionType["UNCOMPRESSED"] = "UNCOMPRESSED";
    CompressionType["GZIP"] = "GZIP";
    CompressionType["ZIP"] = "ZIP";
    CompressionType["SNAPPY"] = "Snappy";
})(CompressionType = exports.CompressionType || (exports.CompressionType = {}));
/**
 * @stability stable
 */
class S3DeliveryStream extends aws_cdk_lib_1.Resource {
    /**
     * @stability stable
     */
    constructor(parent, name, props) {
        super(parent, name);
        this.role = new iam.Role(this, 'kinesis-role', {
            assumedBy: new iam.ServicePrincipal('firehose.amazonaws.com'),
        });
        this.s3Bucket = props.s3Bucket;
        this.deliveryStreamResource = new firehose.CfnDeliveryStream(this, 'delivery-stream', {
            deliveryStreamType: DeliveryStreamType.KINESIS_STREAM_AS_SOURCE,
            kinesisStreamSourceConfiguration: this.makeKinesisSourceConfig(props),
            extendedS3DestinationConfiguration: this.makeS3Config(props),
        });
        this.deliveryStreamResource.node.addDependency(this.role);
        this.deliveryStreamArn = this.deliveryStreamResource.getAtt('Arn').toString();
        this.deliveryStreamName = this.deliveryStreamResource.ref;
    }
    /**
     * @stability stable
     */
    metric(metricName, props) {
        return new cloudwatch.Metric({
            namespace: 'AWS/Firehose',
            metricName,
            dimensionsMap: {
                DeliveryStreamName: this.deliveryStreamName,
            },
            ...props,
        });
    }
    /**
     * @stability stable
     */
    metricBackupToS3Bytes(props) {
        return this.metric('BackupToS3.Bytes', props);
    }
    /**
     * @stability stable
     */
    metricBackupToS3DataFreshness(props) {
        return this.metric('BackupToS3.DataFreshness', props);
    }
    /**
     * @stability stable
     */
    metricBackupToS3Records(props) {
        return this.metric('BackupToS3.Records', props);
    }
    /**
     * @stability stable
     */
    metricBackupToS3Success(props) {
        return this.metric('BackupToS3.Success', props);
    }
    /**
     * @stability stable
     */
    metricDataReadFromKinesisStreamBytes(props) {
        return this.metric('DataReadFromKinesisStream.Bytes', props);
    }
    /**
     * @stability stable
     */
    metricDataReadFromKinesisStreamRecords(props) {
        return this.metric('DataReadFromKinesisStream.Records', props);
    }
    /**
     * @stability stable
     */
    metricDeliveryToS3Bytes(props) {
        return this.metric('DeliveryToS3.Bytes', props);
    }
    /**
     * @stability stable
     */
    metricDeliveryToS3DataFreshness(props) {
        return this.metric('DeliveryToS3.DataFreshness', props);
    }
    /**
     * @stability stable
     */
    metricDeliveryToS3Records(props) {
        return this.metric('DeliveryToS3.Records', props);
    }
    /**
     * @stability stable
     */
    metricDeliveryToS3Success(props) {
        return this.metric('DeliveryToS3.Success', props);
    }
    /**
     * @stability stable
     */
    metricIncomingBytes(props) {
        return this.metric('IncomingBytes', props);
    }
    /**
     * @stability stable
     */
    metricIncomingRecords(props) {
        return this.metric('IncomingRecords', props);
    }
    makeKinesisSourceConfig(props) {
        if (props.kinesisStream) {
            props.kinesisStream.grantRead(this.role);
            props.kinesisStream.grant(this.role, 'kinesis:DescribeStream');
            return {
                kinesisStreamArn: props.kinesisStream.streamArn,
                roleArn: this.role.roleArn,
            };
        }
        else {
            throw new Error("must provide a Kinesis stream if type is 'KinesisStreamAsSource'");
        }
    }
    makeS3Config(props) {
        this.s3Bucket.grantReadWrite(this.role);
        if (props.kinesisStream) {
            props.kinesisStream.grantRead(this.role);
        }
        return {
            bucketArn: this.s3Bucket.bucketArn,
            bufferingHints: {
                intervalInSeconds: 60,
                sizeInMBs: 64,
            },
            compressionFormat: props.compression || CompressionType.UNCOMPRESSED,
            prefix: props.s3Prefix || '',
            roleArn: this.role.roleArn,
            processingConfiguration: this.makeProcessorConfig(props),
        };
    }
    makeProcessorConfig(props) {
        if (props.transformFunction) {
            this.role.addToPolicy(new iam.PolicyStatement({
                actions: ['lambda:InvokeFunction'],
                resources: [props.transformFunction.functionArn, `${props.transformFunction.functionArn}:*`],
            }));
            return {
                enabled: true,
                processors: [
                    {
                        type: ProcessorType.LAMBDA,
                        parameters: [
                            {
                                parameterName: 'LambdaArn',
                                parameterValue: props.transformFunction.functionArn,
                            },
                            {
                                parameterName: 'NumberOfRetries',
                                parameterValue: '3',
                            },
                        ],
                    },
                ],
            };
        }
        else {
            return undefined;
        }
    }
}
exports.S3DeliveryStream = S3DeliveryStream;
_a = JSII_RTTI_SYMBOL_1;
S3DeliveryStream[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.S3DeliveryStream", version: "0.0.44" };
//# sourceMappingURL=data:application/json;base64,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