import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as events from 'aws-cdk-lib/aws-events';
import * as glue from 'aws-cdk-lib/aws-glue';
import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface IGlueCrawlerProperties {
    /**
     * @stability stable
     */
    name: string;
    /**
     * @stability stable
     */
    databaseName: string;
    /**
     * @stability stable
     */
    roleName?: string;
    /**
     * @stability stable
     */
    trigger?: glue.CfnTrigger;
    /**
     * @stability stable
     */
    bucketName: string;
    /**
     * @stability stable
     */
    bucketPrefix?: string;
}
/**
 * @stability stable
 */
export declare class GlueCrawler extends Construct {
    /**
     * @stability stable
     */
    readonly crawler: glue.CfnCrawler;
    /**
     * @stability stable
     */
    readonly role: iam.IRole;
    /**
     * @stability stable
     */
    readonly metricSuccessRule: events.Rule;
    /**
     * @stability stable
     */
    readonly metricFailureRule: events.Rule;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: IGlueCrawlerProperties);
    /**
     * @stability stable
     */
    metricSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricFailure(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private ruleMetric;
    private crawlerRule;
    private createGlueCrawlerRole;
}
