import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import { Construct } from 'constructs';
import { GlueJob } from './glue-job';
/**
 * @stability stable
 */
export interface IGlueOpsProperties {
    /**
     * @stability stable
     */
    job: GlueJob;
    /**
     * @stability stable
     */
    jvmHeapSizeExceeding80percent?: cloudwatch.CreateAlarmOptions;
    /**
     * @stability stable
     */
    jvmHeapSizeExceeding90percent?: cloudwatch.CreateAlarmOptions;
    /**
     * @stability stable
     */
    metricExecutionFailure?: cloudwatch.CreateAlarmOptions;
    /**
     * @stability stable
     */
    metricAllExecutionAttemptsFailed?: cloudwatch.CreateAlarmOptions;
}
/**
 * @stability stable
 */
export declare class GlueJobOps extends Construct {
    /**
     * @stability stable
     */
    readonly job: GlueJob;
    /**
     * @stability stable
     */
    dashboard: cloudwatch.Dashboard;
    /**
     * @stability stable
     */
    readonly jvmHeapSizeExceeding80PercentAlarm: cloudwatch.Alarm;
    /**
     * @stability stable
     */
    readonly jvmHeapSizeExceeding90PercentAlarm: cloudwatch.Alarm;
    /**
     * @stability stable
     */
    readonly metricExecutionFailureAlarm: cloudwatch.Alarm;
    /**
     * @stability stable
     */
    readonly metricAllExecutionAttemptsFailedAlarm: cloudwatch.Alarm;
    /**
     * @stability stable
     */
    readonly alarmsSev2: cloudwatch.Alarm[];
    /**
     * @stability stable
     */
    readonly alarmsSev3: cloudwatch.Alarm[];
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: IGlueOpsProperties);
    private addWidgets;
    private setupDashboard;
    private alarmWidget;
}
