import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as events from 'aws-cdk-lib/aws-events';
import * as glue from 'aws-cdk-lib/aws-glue';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export declare enum GlueWorkerType {
    /**
     * @stability stable
     */
    STANDARD = "Standard",
    /**
     * @stability stable
     */
    G1_X = "G.1X",
    /**
     * @stability stable
     */
    G2_X = "G.2X"
}
/**
 * @stability stable
 */
export declare enum GlueVersion {
    /**
     * @stability stable
     */
    V_0 = "0.9",
    /**
     * @stability stable
     */
    V_1 = "1.0",
    /**
     * @stability stable
     */
    V_2 = "2.0",
    /**
     * @stability stable
     */
    V_3 = "3.0"
}
/**
 * @stability stable
 */
export declare enum GlueJobType {
    /**
     * @stability stable
     */
    GLUE_ETL = "glueetl",
    /**
     * @stability stable
     */
    GLUE_STREAMING = "gluestreaming"
}
/**
 * @stability stable
 */
export interface GlueJobProperties {
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly roleName?: string;
    /**
     * @stability stable
     */
    readonly description?: string;
    /**
     * @stability stable
     */
    readonly deploymentBucket: s3.IBucket;
    /**
     * @stability stable
     */
    readonly readAccessBuckets?: s3.IBucket[];
    /**
     * @stability stable
     */
    readonly writeAccessBuckets?: s3.IBucket[];
    /**
     * @stability stable
     */
    readonly glueVersion?: GlueVersion;
    /**
     * @stability stable
     */
    readonly workerType: GlueWorkerType;
    /**
     * @stability stable
     */
    readonly numberOfWorkers?: number;
    /**
     * @stability stable
     */
    readonly maxCapacity?: number;
    /**
     * @stability stable
     */
    readonly maxRetries?: number;
    /**
     * @stability stable
     */
    readonly maxConcurrentRuns?: number;
    /**
     * @stability stable
     */
    readonly jobScript: string;
    /**
     * @stability stable
     */
    readonly jobArgs?: {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    readonly timeout?: number;
    /**
     * @stability stable
     */
    readonly jobType: GlueJobType;
}
/**
 * @stability stable
 */
export declare class GlueJob extends Construct {
    private static readonly DAY_IN_MINUTES;
    /**
     * @stability stable
     */
    readonly job: glue.CfnJob;
    /**
     * @stability stable
     */
    readonly role: iam.IRole;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly metricSuccessRule: events.Rule;
    /**
     * @stability stable
     */
    readonly metricTimeoutRule: events.Rule;
    /**
     * @stability stable
     */
    readonly metricFailureRule: events.Rule;
    /**
     * @stability stable
     */
    readonly allExecutionAttemptsFailedEventSource = "custom.aws.glue.allExecutionAttemptsFailed";
    /**
     * @stability stable
     */
    readonly allExecutionAttemptsFailedEventDetailType = "All Execution Attempts Failed";
    /**
     * @stability stable
     */
    readonly executionFailureRule: events.Rule;
    /**
     * @stability stable
     */
    readonly lambdaFunction: lambda.SingletonFunction;
    private allExecutionAttemptsFailedRule;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: GlueJobProperties);
    private createGlueJobRole;
    private jobRule;
    /**
     * @stability stable
     */
    metricSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricFailure(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricAllExecutionAttemptsFailed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    metricTimeout(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private ruleMetric;
    /**
     * @stability stable
     */
    metric(metricName: string, dimensionType: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    jvmHeapUsageMetric(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    elapsedTimeMetric(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    diskSpaceUsedMbMetric(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @stability stable
     */
    runTimeInMiliseconds(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private createLambdaFunction;
}
