import { IResolvable } from 'aws-cdk-lib';
import * as glue from 'aws-cdk-lib/aws-glue';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface IGlueTableProperties {
    /**
     * @stability stable
     */
    tableName: string;
    /**
     * @stability stable
     */
    description: string;
    /**
     * @stability stable
     */
    partitionKeys: Array<glue.CfnTable.ColumnProperty | IResolvable> | IResolvable;
    /**
     * @stability stable
     */
    columns: Array<glue.CfnTable.ColumnProperty | IResolvable> | IResolvable;
    /**
     * @stability stable
     */
    parameters: {
        [param: string]: any;
    };
    /**
     * @stability stable
     */
    databaseName: string;
    /**
     * @stability stable
     */
    s3Location: string;
    /**
     * @stability stable
     */
    serializationLibrary: string;
    /**
     * @stability stable
     */
    serdeParameters: {
        [param: string]: any;
    };
    /**
     * @stability stable
     */
    inputFormat: string;
    /**
     * @stability stable
     */
    outputFormat: string;
    /**
     * @stability stable
     */
    catalogId: string;
}
/**
 * @stability stable
 */
export declare class GlueTable extends Construct {
    /**
     * @stability stable
     */
    readonly table: glue.CfnTable;
    /**
     * @stability stable
     */
    readonly tableName: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: IGlueTableProperties);
}
