"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataLakeAdministrator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lf = require("aws-cdk-lib/aws-lakeformation");
const constructs_1 = require("constructs");
/**
 * @stability stable
 */
class DataLakeAdministrator extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const accountId = aws_cdk_lib_1.Stack.of(this).account;
        this.role = new iam.Role(this, 'datalake-administrator-role', {
            roleName: props.name,
            assumedBy: new iam.CompositePrincipal(new iam.ServicePrincipal('lakeformation.amazonaws.com'), new iam.ServicePrincipal('lambda.amazonaws.com'), new iam.ServicePrincipal('sagemaker.amazonaws.com')),
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('AWSLakeFormationDataAdmin'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AWSGlueConsoleFullAccess'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('CloudWatchLogsReadOnlyAccess'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AWSLakeFormationCrossAccountManager'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonAthenaFullAccess'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSageMakerFullAccess'),
            ],
        });
        this.role.attachInlinePolicy(new iam.Policy(this, 'datalake-administrator-basic', {
            statements: [
                new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    actions: [
                        'iam:CreateServiceLinkedRole',
                    ],
                    resources: ['*'],
                    conditions: {
                        StringEquals: {
                            'iam:AWSServiceName': 'lakeformation.amazonaws.com',
                        },
                    },
                }),
                new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    actions: [
                        'iam:PutRolePolicy',
                    ],
                    resources: [`arn:aws:iam::${accountId}:role/aws-service-role/lakeformation.amazonaws.com/AWSServiceRoleForLakeFormationDataAccess`],
                }),
            ],
        }));
        this.role.attachInlinePolicy(new iam.Policy(this, 'datalake-administrator-lambda-writeCW-logs', {
            statements: [
                new iam.PolicyStatement({
                    resources: ['*'],
                    actions: [
                        'logs:CreateLogGroup',
                        'logs:CreateLogStream',
                        'logs:PutLogEvents',
                    ],
                    effect: iam.Effect.ALLOW,
                    sid: 'AllowLogging',
                }),
            ],
        }));
        this.role.attachInlinePolicy(new iam.Policy(this, 'datalake-administrator-TBAC', {
            statements: [
                new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    actions: [
                        'lakeformation:AddLFTagsToResource',
                        'lakeformation:RemoveLFTagsFromResource',
                        'lakeformation:GetResourceLFTags',
                        'lakeformation:ListLFTags',
                        'lakeformation:CreateLFTag',
                        'lakeformation:GetLFTag',
                        'lakeformation:UpdateLFTag',
                        'lakeformation:DeleteLFTag',
                        'lakeformation:SearchTablesByLFTags',
                        'lakeformation:SearchDatabasesByLFTags',
                    ],
                    resources: ['*'],
                }),
            ],
        }));
        this.role.attachInlinePolicy(new iam.Policy(this, 'datalake-administrator-cross-account', {
            statements: [
                new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    actions: [
                        'ram:AcceptResourceShareInvitation',
                        'ram:RejectResourceShareInvitation',
                        'ec2:DescribeAvailabilityZones',
                        'ram:EnableSharingWithAwsOrganization',
                    ],
                    resources: ['*'],
                }),
            ],
        }));
        const lfAdminRole = new lf.CfnDataLakeSettings(this, 'lf-datalake-role-admin-settings', {
            admins: [{
                    dataLakePrincipalIdentifier: this.role.roleArn,
                }],
        });
        lfAdminRole.node.addDependency(this.role);
        new aws_cdk_lib_1.CfnOutput(this, 'DataLakeAdminRole', { value: this.role.roleName });
    }
}
exports.DataLakeAdministrator = DataLakeAdministrator;
_a = JSII_RTTI_SYMBOL_1;
DataLakeAdministrator[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.DataLakeAdministrator", version: "0.0.44" };
//# sourceMappingURL=data:application/json;base64,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