import * as iam from 'aws-cdk-lib/aws-iam';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface DataLakeAnalystProps {
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly readAccessBuckets?: s3.IBucket[];
    /**
     * @stability stable
     */
    readonly writeAccessBuckets?: s3.IBucket[];
}
/**
 * @stability stable
 */
export declare class DataLakeAnalyst extends Construct {
    /**
     * @stability stable
     */
    readonly user: iam.User;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DataLakeAnalystProps);
}
