import * as events from 'aws-cdk-lib/aws-events';
import * as glue from 'aws-cdk-lib/aws-glue';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as s3 from 'aws-cdk-lib/aws-s3';
import * as cdk from 'aws-cdk-lib/core';
import { DataTier } from '.';
import { GlueJobType, GlueVersion, GlueWorkerType } from './etl/glue-job';
/**
 * @stability stable
 */
export interface JDBCProperties {
    /**
     * @stability stable
     */
    readonly jdbc: string;
    /**
     * @stability stable
     */
    readonly username: string;
    /**
     * @stability stable
     */
    readonly password: string;
}
/**
 * @stability stable
 */
export interface StreamProperties {
    /**
     * @stability stable
     */
    readonly streamName: string;
    /**
     * @stability stable
     */
    readonly lambdaDataGenerator?: LambdaDataGeneratorProperties;
}
/**
 * @stability stable
 */
export interface S3Properties {
    /**
     * @stability stable
     */
    readonly sourceBucketName: string;
    /**
     * @stability stable
     */
    readonly sourceKeys: string[];
}
/**
 * @stability stable
 */
export interface TableProps {
    /**
     * @stability stable
     */
    readonly tableName: string;
    /**
     * @stability stable
     */
    readonly description: string;
    /**
     * @stability stable
     */
    readonly partitionKeys: Array<glue.CfnTable.ColumnProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * @stability stable
     */
    readonly columns: Array<glue.CfnTable.ColumnProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * @stability stable
     */
    readonly parameters: {
        [param: string]: any;
    };
    /**
     * @stability stable
     */
    readonly serializationLibrary: string;
    /**
     * @stability stable
     */
    readonly serdeParameters: {
        [param: string]: any;
    };
    /**
     * @stability stable
     */
    readonly inputFormat: string;
    /**
     * @stability stable
     */
    readonly outputFormat: string;
    /**
     * @stability stable
     */
    readonly catalogId: string;
}
/**
 * @stability stable
 */
export interface JobProperties {
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly roleName?: string;
    /**
     * @stability stable
     */
    readonly description?: string;
    /**
     * @stability stable
     */
    readonly readAccessBuckets?: s3.IBucket[];
    /**
     * @stability stable
     */
    readonly writeAccessBuckets?: s3.IBucket[];
    /**
     * @stability stable
     */
    readonly glueVersion?: GlueVersion;
    /**
     * @stability stable
     */
    readonly workerType: GlueWorkerType;
    /**
     * @stability stable
     */
    readonly numberOfWorkers?: number;
    /**
     * @stability stable
     */
    readonly maxCapacity?: number;
    /**
     * @stability stable
     */
    readonly maxRetries?: number;
    /**
     * @stability stable
     */
    readonly maxConcurrentRuns?: number;
    /**
     * @stability stable
     */
    readonly jobScript: string;
    /**
     * @stability stable
     */
    readonly jobArgs?: {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    readonly timeout?: number;
    /**
     * @stability stable
     */
    readonly jobType: GlueJobType;
    /**
     * @stability stable
     */
    readonly destinationLocation?: DataTier;
}
/**
 * @stability stable
 */
export interface DataStreamProperties {
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly destinationBucketName: string;
    /**
     * @stability stable
     */
    readonly destinationPrefix: string;
    /**
     * @stability stable
     */
    readonly dataCatalogOwner: DataCatalogOwner;
    /**
     * @stability stable
     */
    readonly streamName: string;
    /**
     * @stability stable
     */
    readonly lambdaDataGenerator: LambdaDataGeneratorProperties;
}
/**
 * @stability stable
 */
export interface LambdaDataGeneratorProperties {
    /**
     * @stability stable
     */
    readonly code: lambda.Code;
    /**
     * @stability stable
     */
    readonly handler: string;
    /**
     * @stability stable
     */
    readonly timeout: cdk.Duration;
    /**
     * @stability stable
     */
    readonly runtime: lambda.Runtime;
    /**
     * @stability stable
     */
    readonly functionName: string;
    /**
     * @stability stable
     */
    readonly schedule: events.Schedule;
    /**
     * @stability stable
     */
    readonly ruleName: string;
}
/**
 * @stability stable
 */
export interface PipelineProperties {
    /**
     * @stability stable
     */
    readonly type: DataPipelineType;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly destinationPrefix: string;
    /**
     * @stability stable
     */
    readonly dataSetDropTier: DataTier;
    /**
     * @stability stable
     */
    readonly s3Properties?: S3Properties;
    /**
     * @stability stable
     */
    readonly streamProperties?: StreamProperties;
    /**
     * @stability stable
     */
    readonly jdbcProperties?: JDBCProperties;
    /**
     * @stability stable
     */
    readonly s3NotificationProps?: S3NotificationProperties;
    /**
     * @stability stable
     */
    readonly table?: TableProps;
    /**
     * @stability stable
     */
    readonly job?: JobProperties;
}
/**
 * @stability stable
 */
export interface DataCatalogOwner {
    /**
     * @stability stable
     */
    readonly accountId: string;
}
/**
 * @stability stable
 */
export interface S3NotificationProperties {
    /**
     * @stability stable
     */
    readonly event: s3.EventType;
    /**
     * @stability stable
     */
    readonly prefix: string;
    /**
     * @stability stable
     */
    readonly suffix: string;
}
/**
 * @stability stable
 */
export declare enum DataPipelineType {
    /**
     * @stability stable
     */
    STREAM = "stream",
    /**
     * @stability stable
     */
    JDBC = "jdbc",
    /**
     * @stability stable
     */
    S3 = "s3"
}
/**
 * @stability stable
 */
export declare class Pipeline {
    /**
     * @stability stable
     */
    readonly type: DataPipelineType;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly destinationPrefix: string;
    /**
     * @stability stable
     */
    readonly dataSetDropTier: DataTier;
    /**
     * @stability stable
     */
    readonly s3Properties?: S3Properties;
    /**
     * @stability stable
     */
    readonly streamProperties?: StreamProperties;
    /**
     * @stability stable
     */
    readonly jdbcProperties?: JDBCProperties;
    /**
     * @stability stable
     */
    readonly s3NotificationProps?: S3NotificationProperties;
    /**
     * @stability stable
     */
    readonly table?: TableProps;
    /**
     * @stability stable
     */
    readonly job?: JobProperties;
    /**
     * @stability stable
     */
    constructor(props: PipelineProperties);
}
