
__all__ = ['generate_func_common_stub']

import textwrap

from vecstub import vector_tuple


def generate_func_common_stub():
    names = [
        'abs', 'ceil', 'clamp', 'floatBitsToInt', 'floatBitsToUint', 'floor',
        'fma', 'fmax', 'fmin', 'fract', 'frexp', 'intBitsToFloat', 'isinf',
        'isnan', 'ldexp', 'max', 'min', 'mix', 'modf', 'round', 'roundEven',
        'sign', 'smoothstep', 'step', 'trunc', 'uintBitsToFloat'
    ]
    return names, textwrap.dedent(f"""
    @overload
    def abs(x: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def abs(x: {vector_tuple(i)}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def abs(x: _VT, /) -> _VT: ...

    @overload
    def ceil(x: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def ceil(x: {vector_tuple(i)}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def ceil(x: _VT, /) -> _VT: ...

    @overload
    def clamp(x: glm_typing.Number, min: glm_typing.Number, max: glm_typing.Number, /) -> glm_typing.Number: ...{''.join(f'''
    @overload
    def clamp(x: glm_typing.F32Vector{i}, min: glm_typing.Number, max: glm_typing.Number, /) -> vec{i}: ...
    @overload
    def clamp(x: glm_typing.F32Vector{i}, min: glm_typing.F32Vector{i}, max: glm_typing.F32Vector{i}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def clamp(x: _NF32VT, min: glm_typing.Number, max: glm_typing.Number, /) -> _NF32VT: ...
    @overload
    def clamp(x: _NF32VT, min: _NF32VT, max: _NF32VT, /) -> _NF32VT: ...

    @overload
    def floatBitsToInt(x: float, /) -> int: ...
    @overload
    def floatBitsToInt(x: glm_typing.F32Vector2, /) -> ivec2: ...
    @overload
    def floatBitsToInt(x: glm_typing.F32Vector3, /) -> ivec3: ...
    @overload
    def floatBitsToInt(x: glm_typing.F32Vector4, /) -> ivec4: ...
    @overload
    def floatBitsToInt(x: glm_typing.F32Vector1, /) -> ivec1: ...

    @overload
    def floatBitsToUint(x: float, /) -> int: ...
    @overload
    def floatBitsToUint(x: glm_typing.F32Vector2, /) -> uvec2: ...
    @overload
    def floatBitsToUint(x: glm_typing.F32Vector3, /) -> uvec3: ...
    @overload
    def floatBitsToUint(x: glm_typing.F32Vector4, /) -> uvec4: ...
    @overload
    def floatBitsToUint(x: glm_typing.F32Vector1, /) -> uvec1: ...

    @overload
    def floor(x: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def floor(x: {vector_tuple(i)}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def floor(x: _VT, /) -> _VT: ...

    def fma(a: glm_typing.Number, b: glm_typing.Number, c: glm_typing.Number, /) -> float: ...

    @overload
    def fmax(x: glm_typing.Number, y: glm_typing.Number, /) -> float: ...
    @overload
    def fmax(a: glm_typing.Number, b: glm_typing.Number, c: glm_typing.Number, /) -> float: ...
    @overload
    def fmax(a: glm_typing.Number, b: glm_typing.Number, c: glm_typing.Number, d: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def fmax(x: glm_typing.F32Vector{i}, y: glm_typing.Number, /) -> vec{i}: ...
    @overload
    def fmax(x: glm_typing.F32Vector{i}, y: glm_typing.F32Vector{i}, /) -> vec{i}: ...
    @overload
    def fmax(a: glm_typing.F32Vector{i}, b: glm_typing.F32Vector{i}, c: glm_typing.F32Vector{i}, /) -> vec{i}: ...
    @overload
    def fmax(a: glm_typing.F32Vector{i}, b: glm_typing.F32Vector{i}, c: glm_typing.F32Vector{i}, d: glm_typing.F32Vector{i}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def fmax(x: _NF32VT, y: glm_typing.Number, /) -> _NF32VT: ...
    @overload
    def fmax(x: _NF32VT, y: _NF32VT, /) -> _NF32VT: ...
    @overload
    def fmax(a: _NF32VT, b: _NF32VT, c: _NF32VT, /) -> _NF32VT: ...
    @overload
    def fmax(a: _NF32VT, b: _NF32VT, c: _NF32VT, d: _NF32VT, /) -> _NF32VT: ...

    @overload
    def fmin(x: glm_typing.Number, y: glm_typing.Number, /) -> float: ...
    @overload
    def fmin(a: glm_typing.Number, b: glm_typing.Number, c: glm_typing.Number, /) -> float: ...
    @overload
    def fmin(a: glm_typing.Number, b: glm_typing.Number, c: glm_typing.Number, d: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def fmin(x: glm_typing.F32Vector{i}, y: glm_typing.Number, /) -> vec{i}: ...
    @overload
    def fmin(x: glm_typing.F32Vector{i}, y: glm_typing.F32Vector{i}, /) -> vec{i}: ...
    @overload
    def fmin(a: glm_typing.F32Vector{i}, b: glm_typing.F32Vector{i}, c: glm_typing.F32Vector{i}, /) -> vec{i}: ...
    @overload
    def fmin(a: glm_typing.F32Vector{i}, b: glm_typing.F32Vector{i}, c: glm_typing.F32Vector{i}, d: glm_typing.F32Vector{i}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def fmin(x: _NF32VT, y: glm_typing.Number, /) -> _NF32VT: ...
    @overload
    def fmin(x: _NF32VT, y: _NF32VT, /) -> _NF32VT: ...
    @overload
    def fmin(a: _NF32VT, b: _NF32VT, c: _NF32VT, /) -> _NF32VT: ...
    @overload
    def fmin(a: _NF32VT, b: _NF32VT, c: _NF32VT, d: _NF32VT, /) -> _NF32VT: ...

    @overload
    def fract(x: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def fract(x: {vector_tuple(i)}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def fract(x: _VT, /) -> _VT: ...

    @overload
    def frexp(x: glm_typing.Number, /) -> Tuple[float, int]: ...
    @overload
    def frexp(x: dvec1, exp: ivec1, /) -> dvec1: ...
    @overload
    def frexp(x: dvec2, exp: ivec2, /) -> dvec2: ...
    @overload
    def frexp(x: dvec3, exp: ivec3, /) -> dvec3: ...
    @overload
    def frexp(x: dvec4, exp: ivec4, /) -> dvec4: ...
    @overload
    def frexp(x: glm_typing.F32Vector1, exp: ivec1, /) -> vec1: ...
    @overload
    def frexp(x: glm_typing.F32Vector2, exp: ivec2, /) -> vec2: ...
    @overload
    def frexp(x: glm_typing.F32Vector3, exp: ivec3, /) -> vec3: ...
    @overload
    def frexp(x: glm_typing.F32Vector4, exp: ivec4, /) -> vec4: ...

    @overload
    def intBitsToFloat(x: int, /) -> float: ...
    @overload
    def intBitsToFloat(x: glm_typing.I32Vector2, /) -> vec2: ...
    @overload
    def intBitsToFloat(x: glm_typing.I32Vector3, /) -> vec3: ...
    @overload
    def intBitsToFloat(x: glm_typing.I32Vector4, /) -> vec4: ...
    @overload
    def intBitsToFloat(x: glm_typing.I32Vector1, /) -> vec1: ...

    @overload
    def isinf(x: glm_typing.Number, /) -> bool: ...
    @overload
    def isinf(x: glm_typing.FDAnyVector1, /) -> bvec1: ...
    @overload
    def isinf(x: glm_typing.FDAnyVector2, /) -> bvec2: ...
    @overload
    def isinf(x: glm_typing.FDAnyVector3, /) -> bvec3: ...
    @overload
    def isinf(x: glm_typing.FDAnyQuaternionVector4, /) -> bvec4: ...

    @overload
    def isnan(x: glm_typing.Number, /) -> bool: ...
    @overload
    def isnan(x: glm_typing.FDAnyVector1, /) -> bvec1: ...
    @overload
    def isnan(x: glm_typing.FDAnyVector2, /) -> bvec2: ...
    @overload
    def isnan(x: glm_typing.FDAnyVector3, /) -> bvec3: ...
    @overload
    def isnan(x: glm_typing.FDAnyQuaternionVector4, /) -> bvec4: ...

    @overload
    def ldexp(x: glm_typing.Number, exp: glm_typing.Number, /) -> float: ...
    @overload
    def ldexp(x: dmvec2, exp: ivec2, /) -> dmvec2: ...
    @overload
    def ldexp(x: dmvec3, exp: ivec3, /) -> dmvec3: ...
    @overload
    def ldexp(x: dmvec4, exp: ivec4, /) -> dmvec4: ...
    @overload
    def ldexp(x: dvec1, exp: ivec1, /) -> dvec1: ...
    @overload
    def ldexp(x: dvec2, exp: ivec2, /) -> dvec2: ...
    @overload
    def ldexp(x: dvec3, exp: ivec3, /) -> dvec3: ...
    @overload
    def ldexp(x: dvec4, exp: ivec4, /) -> dvec4: ...
    @overload
    def ldexp(x: mvec2, exp: ivec2, /) -> mvec2: ...
    @overload
    def ldexp(x: mvec3, exp: ivec3, /) -> mvec3: ...
    @overload
    def ldexp(x: mvec4, exp: ivec4, /) -> mvec4: ...
    @overload
    def ldexp(x: Union[vec1, {vector_tuple(1)}], exp: ivec1, /) -> vec1: ...
    @overload
    def ldexp(x: Union[vec2, {vector_tuple(2)}], exp: ivec2, /) -> vec2: ...
    @overload
    def ldexp(x: Union[vec3, {vector_tuple(3)}], exp: ivec3, /) -> vec3: ...
    @overload
    def ldexp(x: Union[vec4, {vector_tuple(4)}], exp: ivec4, /) -> vec4: ...

    @overload
    def max(x: glm_typing.Number, y: glm_typing.Number, /) -> float: ...
    @overload
    def max(a: glm_typing.Number, b: glm_typing.Number, c: glm_typing.Number, /) -> float: ...
    @overload
    def max(a: glm_typing.Number, b: glm_typing.Number, c: glm_typing.Number, d: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def max(x: glm_typing.F32Vector{i}, y: glm_typing.Number, /) -> vec{i}: ...
    @overload
    def max(x: glm_typing.F32Vector{i}, y: glm_typing.F32Vector{i}, /) -> vec{i}: ...
    @overload
    def max(a: glm_typing.F32Vector{i}, b: glm_typing.F32Vector{i}, c: glm_typing.F32Vector{i}, /) -> vec{i}: ...
    @overload
    def max(a: glm_typing.F32Vector{i}, b: glm_typing.F32Vector{i}, c: glm_typing.F32Vector{i}, d: glm_typing.F32Vector{i}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def max(x: _NF32VT, y: glm_typing.Number, /) -> _NF32VT: ...
    @overload
    def max(x: _NF32VT, y: _NF32VT, /) -> _NF32VT: ...
    @overload
    def max(a: _NF32VT, b: _NF32VT, c: _NF32VT, /) -> _NF32VT: ...
    @overload
    def max(a: _NF32VT, b: _NF32VT, c: _NF32VT, d: _NF32VT, /) -> _NF32VT: ...
    @overload
    def max(_: Iterable[_T], /) -> _T: ...

    @overload
    def min(x: glm_typing.Number, y: glm_typing.Number, /) -> float: ...
    @overload
    def min(a: glm_typing.Number, b: glm_typing.Number, c: glm_typing.Number, /) -> float: ...
    @overload
    def min(a: glm_typing.Number, b: glm_typing.Number, c: glm_typing.Number, d: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def min(x: glm_typing.F32Vector{i}, y: glm_typing.Number, /) -> vec{i}: ...
    @overload
    def min(x: glm_typing.F32Vector{i}, y: glm_typing.F32Vector{i}, /) -> vec{i}: ...
    @overload
    def min(a: glm_typing.F32Vector{i}, b: glm_typing.F32Vector{i}, c: glm_typing.F32Vector{i}, /) -> vec{i}: ...
    @overload
    def min(a: glm_typing.F32Vector{i}, b: glm_typing.F32Vector{i}, c: glm_typing.F32Vector{i}, d: glm_typing.F32Vector{i}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def min(x: _NF32VT, y: glm_typing.Number, /) -> _NF32VT: ...
    @overload
    def min(x: _NF32VT, y: _NF32VT, /) -> _NF32VT: ...
    @overload
    def min(a: _NF32VT, b: _NF32VT, c: _NF32VT, /) -> _NF32VT: ...
    @overload
    def min(a: _NF32VT, b: _NF32VT, c: _NF32VT, d: _NF32VT, /) -> _NF32VT: ...
    @overload
    def min(_: Iterable[_T], /) -> _T: ...

    @overload
    def mix(x: glm_typing.Number, y: glm_typing.Number, a: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def mix(x: glm_typing.F32Vector{i}, y: glm_typing.F32Vector{i}, a: Union[glm_typing.FDAnyVector{i}, glm_typing.BAnyVector{i}, glm_typing.Number], /) -> vec{i}: ...
    @overload
    def mix(x: _NF32V{i}T, y: _NF32V{i}T, a: Union[glm_typing.FDAnyVector{i}, glm_typing.BAnyVector{i}, glm_typing.Number], /) -> _NF32V{i}T: ...''' for i in range(1, 5))}{''.join(f'''
    @overload
    def mix(x: glm_typing.F32Matrix{r}x{c}, y: glm_typing.F32Matrix{r}x{c}, a: Union[glm_typing.FAnyMatrix{r}x{c}, glm_typing.Number], /) -> mat{r}x{c}: ...
    @overload
    def mix(x: _NF32M{r}X{c}T, y: _NF32M{r}X{c}T, a: Union[glm_typing.FAnyMatrix{r}x{c}, glm_typing.Number], /) -> _NF32M{r}X{c}T: ...''' for r in range(2, 5) for c in range(2, 5))}
    @overload
    def mix(x: _QT, y: _QT, a: glm_typing.Number, /) -> _QT: ...

    @overload
    def modf(x: glm_typing.Number, /) -> Tuple[float, float]: ...{''.join(f'''
    @overload
    def modf(x: {vector_tuple(i)}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def modf(x: _FDVT, i: _FDVT, /) -> _FDVT: ...

    @overload
    def round(x: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def round(x: {vector_tuple(i)}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def round(x: _FDVT, i: _FDVT, /) -> _FDVT: ...

    @overload
    def roundEven(x: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def roundEven(x: {vector_tuple(i)}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def roundEven(x: _FDVT, i: _FDVT, /) -> _FDVT: ...

    @overload
    def sign(x: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def sign(x: {vector_tuple(i)}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def sign(x: _FDVT, i: _FDVT, /) -> _FDVT: ...

    @overload
    def smoothstep(edge0: glm_typing.Number, edge1: glm_typing.Number, x: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def smoothstep(edge0: glm_typing.Number, edge1: glm_typing.Number, x: glm_typing.F32Vector{i}, /) -> vec{i}: ...
    @overload
    def smoothstep(edge0: glm_typing.F32Vector{i}, edge1: glm_typing.F32Vector{i}, x: glm_typing.F32Vector{i}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def smoothstep(edge0: glm_typing.Number, edge1: glm_typing.Number, x: _NF32VT, /) -> _FDVT: ...
    @overload
    def smoothstep(edge0: _NF32VT, edge1: _NF32VT, x: _NF32VT, /) -> _NF32VT: ...

    @overload
    def step(edge: glm_typing.Number, x: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def step(edge: glm_typing.Number, x: glm_typing.F32Vector{i}, /) -> vec{i}: ...
    @overload
    def step(edge: glm_typing.F32Vector{i}, x: glm_typing.F32Vector{i}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def step(edge: glm_typing.Number, x: _NF32VT, /) -> _NF32VT: ...
    @overload
    def step(edge: _NF32VT, x: _NF32VT, /) -> _NF32VT: ...

    @overload
    def trunc(x: glm_typing.Number, /) -> float: ...{''.join(f'''
    @overload
    def trunc(x: {vector_tuple(i)}, /) -> vec{i}: ...''' for i in range(1, 5))}
    @overload
    def trunc(x: _FDVT, /) -> _FDVT: ...

    @overload
    def uintBitsToFloat(x: int, /) -> float: ...
    @overload
    def uintBitsToFloat(x: glm_typing.U32Vector2, /) -> vec2: ...
    @overload
    def uintBitsToFloat(x: glm_typing.U32Vector3, /) -> vec3: ...
    @overload
    def uintBitsToFloat(x: glm_typing.U32Vector4, /) -> vec4: ...
    @overload
    def uintBitsToFloat(x: glm_typing.U32Vector1, /) -> vec1: ...
    """)
