
__all__ = ['generate_matrix_clip_space_stub']

import textwrap


def generate_matrix_clip_space_stub():
    names = [
        'frustumLH_NO', 'frustumLH_ZO', 'frustumRH_NO', 'frustumRH_ZO',
        'frustum', 'frustumNO', 'frustumRH', 'frustumLH', 'frustumZO',
        'infinitePerspectiveLH', 'infinitePerspectiveRH',
        'infinitePerspective',
        'orthoLH_NO', 'orthoLH_ZO', 'orthoRH_NO', 'orthoRH_ZO', 'ortho',
        'orthoLH', 'orthoNO', 'orthoRH', 'orthoZO',
        'perspectiveLH_NO', 'perspectiveLH_ZO', 'perspectiveRH_NO',
        'perspectiveRH_ZO', 'perspective', 'perspectiveLH', 'perspectiveNO',
        'perspectiveRH', 'perspectiveZO',
        'perspectiveFovLH_NO', 'perspectiveFovLH_ZO', 'perspectiveFovRH_NO',
        'perspectiveFovRH_ZO', 'perspectiveFov', 'perspectiveFovLH',
        'perspectiveFovNO', 'perspectiveFovRH', 'perspectiveFovZO',
        'tweakedInfinitePerspective',
    ]
    return names, textwrap.dedent(f"""
    def frustumLH_NO(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def frustumLH_ZO(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def frustumRH_NO(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def frustumRH_ZO(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def frustum(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def frustumNO(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def frustumRH(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def frustumLH(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def frustumZO(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def infinitePerspectiveLH(fovy: glm_typing.Number, aspect: glm_typing.Number, near: glm_typing.Number, /) -> mat4x4: ...

    def infinitePerspectiveRH(fovy: glm_typing.Number, aspect: glm_typing.Number, near: glm_typing.Number, /) -> mat4x4: ...

    def infinitePerspective(fovy: glm_typing.Number, aspect: glm_typing.Number, near: glm_typing.Number, /) -> mat4x4: ...

    def orthoLH_NO(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, zNear: glm_typing.Number, zFar: glm_typing.Number, /) -> mat4x4: ...

    def orthoLH_ZO(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, zNear: glm_typing.Number, zFar: glm_typing.Number, /) -> mat4x4: ...

    def orthoRH_NO(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, zNear: glm_typing.Number, zFar: glm_typing.Number, /) -> mat4x4: ...

    def orthoRH_ZO(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, zNear: glm_typing.Number, zFar: glm_typing.Number, /) -> mat4x4: ...

    def ortho(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, zNear: glm_typing.Number, zFar: glm_typing.Number, /) -> mat4x4: ...

    def orthoLH(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, zNear: glm_typing.Number, zFar: glm_typing.Number, /) -> mat4x4: ...

    def orthoNO(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, zNear: glm_typing.Number, zFar: glm_typing.Number, /) -> mat4x4: ...

    def orthoRH(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, zNear: glm_typing.Number, zFar: glm_typing.Number, /) -> mat4x4: ...

    def orthoZO(left: glm_typing.Number, right: glm_typing.Number, bottom: glm_typing.Number, top: glm_typing.Number, zNear: glm_typing.Number, zFar: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveLH_NO(fovy: glm_typing.Number, aspect: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveLH_ZO(fovy: glm_typing.Number, aspect: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveRH_NO(fovy: glm_typing.Number, aspect: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveRH_ZO(fovy: glm_typing.Number, aspect: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspective(fovy: glm_typing.Number, aspect: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveLH(fovy: glm_typing.Number, aspect: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveNO(fovy: glm_typing.Number, aspect: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveRH(fovy: glm_typing.Number, aspect: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveZO(fovy: glm_typing.Number, aspect: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveFovLH_NO(fov: glm_typing.Number, width: glm_typing.Number, height: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveFovLH_ZO(fov: glm_typing.Number, width: glm_typing.Number, height: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveFovRH_NO(fov: glm_typing.Number, width: glm_typing.Number, height: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveFovRH_ZO(fov: glm_typing.Number, width: glm_typing.Number, height: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveFov(fov: glm_typing.Number, width: glm_typing.Number, height: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveFovLH(fov: glm_typing.Number, width: glm_typing.Number, height: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveFovNO(fov: glm_typing.Number, width: glm_typing.Number, height: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveFovRH(fov: glm_typing.Number, width: glm_typing.Number, height: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    def perspectiveFovZO(fov: glm_typing.Number, width: glm_typing.Number, height: glm_typing.Number, near: glm_typing.Number, far: glm_typing.Number, /) -> mat4x4: ...

    @overload
    def tweakedInfinitePerspective(fovy: glm_typing.Number, aspect: glm_typing.Number, near: glm_typing.Number, /) -> mat4x4: ...
    @overload
    def tweakedInfinitePerspective(fovy: glm_typing.Number, aspect: glm_typing.Number, near: glm_typing.Number, epsilon: float, /) -> mat4x4: ...
    """)
