
__all__ = ['generate_matrix_transform_stub']

import textwrap


def generate_matrix_transform_stub():
    names = [
        'identity',
        'lookAtLH', 'lookAtRH', 'lookAt',
    ]
    return names, textwrap.dedent(f"""
    def identity(matrix_type: Type[_MT], /) -> _MT: ...

    @overload
    def lookAtLH(eye: glm_typing.F32Vector3, center: glm_typing.F32Vector3, up: glm_typing.F32Vector3, /) -> mat4x4: ...
    @overload
    def lookAtLH(eye: dvec3, center: dvec3, up: dvec3, /) -> dmat4x4: ...

    @overload
    def lookAtRH(eye: glm_typing.F32Vector3, center: glm_typing.F32Vector3, up: glm_typing.F32Vector3, /) -> mat4x4: ...
    @overload
    def lookAtRH(eye: dvec3, center: dvec3, up: dvec3, /) -> dmat4x4: ...

    @overload
    def lookAt(eye: glm_typing.F32Vector3, center: glm_typing.F32Vector3, up: glm_typing.F32Vector3, /) -> mat4x4: ...
    @overload
    def lookAt(eye: dvec3, center: dvec3, up: dvec3, /) -> dmat4x4: ...

    @overload
    def rotate(angle: glm_typing.Number, axis: glm_typing.F32Vector3, /) -> mat4x4: ...
    @overload
    def rotate(angle: glm_typing.Number, axis: dvec3, /) -> dmat4x4: ...
    @overload
    def rotate(angle: glm_typing.Number, /) -> mat3x3: ...
    @overload
    def rotate(m: glm_typing.F32Matrix4x4, angle: glm_typing.Number, axis: glm_typing.F32Vector3, /) -> mat4x4: ...
    @overload
    def rotate(m: dmat4x4, angle: glm_typing.Number, axis: dvec3, /) -> dmat4x4: ...
    @overload
    def rotate(m: glm_typing.F32Matrix3x3, angle: glm_typing.Number, /) -> mat3x3: ...
    @overload
    def rotate(m: dmat3x3, angle: glm_typing.Number, /) -> dmat3x3: ...
    @overload
    def rotate(v: glm_typing.F32Vector2, angle: glm_typing.Number, /) -> vec2: ...
    @overload
    def rotate(v: dvec2, angle: glm_typing.Number, /) -> dvec2: ...
    @overload
    def rotate(v: glm_typing.F32Vector3, angle: glm_typing.Number, normal: glm_typing.F32Vector3, /) -> vec3: ...
    @overload
    def rotate(v: dvec3, angle: glm_typing.Number, normal: dvec3, /) -> dvec3: ...
    @overload
    def rotate(v: glm_typing.F32Vector4, angle: glm_typing.Number, normal: glm_typing.F32Vector3, /) -> vec3: ...
    @overload
    def rotate(v: dvec4, angle: glm_typing.Number, normal: dvec3, /) -> dvec4: ...
    @overload
    def rotate(v: quat, angle: glm_typing.Number, normal: glm_typing.F32Vector3, /) -> quat: ...
    @overload
    def rotate(v: dquat, angle: glm_typing.Number, normal: dvec3, /) -> dquat: ...

    @overload
    def rotate_slow(m: glm_typing.F32Matrix4x4, angle: glm_typing.Number, axis: glm_typing.F32Vector3, /) -> mat4x4: ...
    @overload
    def rotate_slow(m: dmat4x4, angle: glm_typing.Number, axis: dvec3, /) -> dmat4x4: ...

    @overload
    def scale(v: glm_typing.F32Vector3, /) -> mat4x4: ...
    @overload
    def scale(v: dvec3, /) -> dmat4x4: ...
    @overload
    def scale(v: glm_typing.F32Vector2, /) -> mat3x3: ...
    @overload
    def scale(v: dvec2, /) -> mat3x3: ...
    @overload
    def scale(m: glm_typing.F32Matrix4x4, v: glm_typing.F32Vector3, /) -> mat4x4: ...
    @overload
    def scale(m: dmat4x4, v: dvec3, /) -> dmat4x4: ...
    @overload
    def scale(m: glm_typing.F32Matrix3x3, v: glm_typing.F32Vector2, /) -> mat3x3: ...
    @overload
    def scale(m: dmat3x3, v: dvec2, /) -> dmat3x3: ...

    @overload
    def scale_slow(m: glm_typing.F32Matrix4x4, v: glm_typing.F32Vector3, /) -> mat4x4: ...
    @overload
    def scale_slow(m: dmat4x4, v: dvec3, /) -> dmat4x4: ...

    @overload
    def translate(v: glm_typing.F32Vector3, /) -> mat4x4: ...
    @overload
    def translate(v: dvec3, /) -> dmat4x4: ...
    @overload
    def translate(v: glm_typing.F32Vector2, /) -> mat3x3: ...
    @overload
    def translate(v: dvec2, /) -> dmat3x3: ...
    @overload
    def translate(m: glm_typing.F32Matrix4x4, v: glm_typing.F32Vector3, /) -> mat4x4: ...
    @overload
    def translate(m: dmat4x4, v: dvec3, /) -> dmat4x4: ...
    @overload
    def translate(m: glm_typing.F32Matrix3x3, v: glm_typing.F32Vector2, /) -> mat3x3: ...
    @overload
    def translate(m: dmat3x3, v: dvec2, /) -> dmat3x3: ...
    """)
