
__all__ = ['generate_type_ptr_stub']

import textwrap


def generate_type_ptr_stub():
    names = [
        'make_mat2', 'make_mat3', 'make_mat4',
        'make_mat2x2', 'make_mat2x3', 'make_mat2x4',
        'make_mat3x2', 'make_mat3x3', 'make_mat3x4',
        'make_mat4x2', 'make_mat4x3', 'make_mat4x4',
        'make_quat',
        'make_vec2', 'make_vec3', 'make_vec4',
        'sizeof', 'value_ptr',
    ]
    return names, textwrap.dedent(f"""
    def make_mat2(x: ctypes.pointer[Any], /) -> mat2x2: ...

    def make_mat3(x: ctypes.pointer[Any], /) -> mat3x3: ...

    def make_mat4(x: ctypes.pointer[Any], /) -> mat4x4: ...

    def make_mat2x2(x: ctypes.pointer[Any], /) -> mat2x2: ...

    def make_mat2x3(x: ctypes.pointer[Any], /) -> mat2x3: ...

    def make_mat2x4(x: ctypes.pointer[Any], /) -> mat2x4: ...

    def make_mat3x2(x: ctypes.pointer[Any], /) -> mat3x2: ...

    def make_mat3x3(x: ctypes.pointer[Any], /) -> mat3x3: ...

    def make_mat3x4(x: ctypes.pointer[Any], /) -> mat3x4: ...

    def make_mat4x2(x: ctypes.pointer[Any], /) -> mat4x2: ...

    def make_mat4x3(x: ctypes.pointer[Any], /) -> mat4x3: ...

    def make_mat4x4(x: ctypes.pointer[Any], /) -> mat4x4: ...

    def make_quat(x: ctypes.pointer[Any], /) -> quat: ...

    def make_vec2(x: ctypes.pointer[Any], /) -> vec2: ...

    def make_vec3(x: ctypes.pointer[Any], /) -> vec3: ...

    def make_vec4(x: ctypes.pointer[Any], /) -> vec4: ...

    @overload
    def sizeof(x: Type[Union[ctypes.c_bool, ctypes.c_short, ctypes.c_long, ctypes.c_longlong, ctypes.c_byte, ctypes.c_ushort, ctypes.c_ulong, ctypes.c_ulonglong, ctypes.c_ubyte, ctypes.c_double, ctypes.c_float, glm_typing.AnyAnyVecAny, glm_typing.AnyAnyMatAnyxAny, glm_typing.AnyAnyQuat]], /) -> int: ...
    @overload
    def sizeof(x: Union[ctypes.c_bool, ctypes.c_short, ctypes.c_long, ctypes.c_longlong, ctypes.c_byte, ctypes.c_ushort, ctypes.c_ulong, ctypes.c_ulonglong, ctypes.c_ubyte, ctypes.c_double, ctypes.c_float, array[Any], glm_typing.AnyAnyVecAny, glm_typing.AnyAnyMatAnyxAny, glm_typing.AnyAnyQuat], /) -> int: ...

    @overload
    def value_ptr(x: Union[glm_typing.F32VecAny, glm_typing.F32MatAnyxAny, glm_typing.F32Quat], /) -> ctypes.pointer[ctypes.c_float]: ...
    @overload
    def value_ptr(x: Union[glm_typing.D64VecAny, glm_typing.D64MatAnyxAny, glm_typing.D64Quat], /) -> ctypes.pointer[ctypes.c_double]: ...
    @overload
    def value_ptr(x: Union[glm_typing.I32VecAny, glm_typing.I32MatAnyxAny], /) -> ctypes.pointer[ctypes.c_int32]: ...
    @overload
    def value_ptr(x: Union[glm_typing.U32VecAny, glm_typing.U32MatAnyxAny], /) -> ctypes.pointer[ctypes.c_uint32]: ...
    @overload
    def value_ptr(x: glm_typing.I8VecAny, /) -> ctypes.pointer[ctypes.c_int8]: ...
    @overload
    def value_ptr(x: glm_typing.U8VecAny, /) -> ctypes.pointer[ctypes.c_uint8]: ...
    @overload
    def value_ptr(x: glm_typing.B8VecAny, /) -> ctypes.pointer[ctypes.c_bool]: ...
    @overload
    def value_ptr(x: glm_typing.I16VecAny, /) -> ctypes.pointer[ctypes.c_int16]: ...
    @overload
    def value_ptr(x: glm_typing.U16VecAny, /) -> ctypes.pointer[ctypes.c_uint16]: ...
    @overload
    def value_ptr(x: glm_typing.I64VecAny, /) -> ctypes.pointer[ctypes.c_int64]: ...
    @overload
    def value_ptr(x: glm_typing.U64VecAny, /) -> ctypes.pointer[ctypes.c_uint64]: ...
    """)
