# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['oats',
 'oats._data',
 'oats._utils',
 'oats.generator',
 'oats.models',
 'oats.models.distance',
 'oats.models.predictive',
 'oats.models.reconstruction',
 'oats.models.rule_based',
 'oats.preprocessor',
 'oats.scorer',
 'oats.threshold']

package_data = \
{'': ['*']}

install_requires = \
['darts==0.23.0',
 'jenkspy>=0.2.2,<0.3.0',
 'numpy>=1.22.4',
 'optuna>=2.10.0,<3.0.0',
 'pyod==1.0.4',
 'scipy==1.7.3',
 'statsforecast==1.0.0',
 'statsmodels>=0.13.2,<0.14.0',
 'stumpy>=1.11.1,<2.0.0',
 'tqdm>=4.64.1,<5.0.0']

extras_require = \
{':sys_platform != "darwin"': ['tensorflow>=2.9.3'],
 ':sys_platform == "darwin"': ['tensorflow-macos>=2.9.2,<2.10',
                               'tensorflow-metal==0.5.0']}

setup_kwargs = {
    'name': 'pyoats',
    'version': '0.1.2',
    'description': 'Quick and Easy Time Series Outlier Detection',
    'long_description': '<!-- Improved compatibility of back to top link: See: https://github.com/othneildrew/Best-README-Template/pull/73 -->\n<a name="readme-top"></a>\n<!--\n*** Thanks for checking out the Best-README-Template. If you have a suggestion\n*** that would make this better, please fork the repo and create a pull request\n*** or simply open an issue with the tag "enhancement".\n*** Don\'t forget to give the project a star!\n*** Thanks again! Now go create something AMAZING! :D\n-->\n\n\n\n<!-- PROJECT SHIELDS -->\n<!--\n*** I\'m using markdown "reference style" links for readability.\n*** Reference links are enclosed in brackets [ ] instead of parentheses ( ).\n*** See the bottom of this document for the declaration of the reference variables\n*** for contributors-url, forks-url, etc. This is an optional, concise syntax you may use.\n*** https://www.markdownguide.org/basic-syntax/#reference-style-links\n-->\n[![Contributors][contributors-shield]][contributors-url]\n[![Stargazers][stars-shield]][stars-url]\n[![Issues][issues-shield]][issues-url]\n[![Apache 2.0 License][license-shield]][license-url]\n[![Last Commit][last_commit-shield]][last_commit-url]\n\n\n\n<!-- PROJECT LOGO -->\n<br />\n<div align="center">\n  <a href="https://github.com/georgian-io/oats">\n    <img src="https://github.com/georgian-io/pyoats/raw/main/static/oats.png" alt="Logo" width="auto" height="80">\n  </a>\n\n<h3 align="center"> OATS</h3>\n\n  <p align="center">\n    Quick and Easy Outlier Detection for Time Series \n    <br />\n    <a href="https://georgian-io.github.io/pyoats-docs/"><strong>Explore the docs »</strong></a>\n    <br />\n    <br />\n    <a href="https://georgian-io.medium.com/time-series-anomaly-detection-a-field-study-d13b35ee4344">View Demo</a>\n    ·\n    <a href="https://github.com/georgian-io/pyoats/issues">Report Bug</a>\n    ·\n    <a href="https://github.com/georgian-io/pyoats/issues">Request Feature</a>\n  </p>\n</div>\n\n\n\n<!-- TABLE OF CONTENTS -->\n<details>\n  <summary>Table of Contents</summary>\n  <ol>\n    <li>\n      <a href="#about-the-project">About The Project</a>\n      <ul>\n        <li><a href="#built-with">Built With</a></li>\n      </ul>\n    </li>\n    <li>\n      <a href="#getting-started">Getting Started</a>\n      <ul>\n        <li><a href="#prerequisites">Prerequisites</a></li>\n        <li><a href="#installation">Installation</a></li>\n      </ul>\n    </li>\n    <li><a href="#usage">Usage</a></li>\n    <li><a href="#models">Models</a></li>\n    <li><a href="#roadmap">Roadmap</a></li>\n    <li><a href="#contributing">Contributing</a></li>\n    <li><a href="#license">License</a></li>\n    <li><a href="#contact">Contact</a></li>\n    <li><a href="#acknowledgments">Acknowledgments</a></li>\n  </ol>\n</details>\n\n\n\n<!-- ABOUT THE PROJECT -->\n## About The Project\nAdapting existing outlier detection & prediction methods into a **time series outlier detection** system is not a simple task. Good news: **OATS** has done the heavy lifting for you! \n\nWe present a straight-forward interface for popular, state-of-the-art detection methods to assist you in your experiments. In addition to the models, we also present different options when it comes to selecting a final threshold for predictions.\n\n**OATS** seamlessly supports both univariate and multivariate time series regardless of the model choice and guarantees the same output shape, enabling a modular approach to time series anoamly detection.\n\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n\n\n### Built With\n[![Python][Python.org]][Python-url] [![Poetry][Python-Poetry.org]][Poetry-url]\n\n[![Pytorch][Pytorch.org]][Torch-url]  [![PytorchLightning][PytorchLightning.ai]][Lightning-url] [![TensorFlow][TensorFlow.org]][TF-url] [![Numpy][Numpy.org]][Numpy-url]\n\n[![Darts][Darts]][Darts-url] [![PyOD][PyOD]][PyOD-url]\n\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n\n\n<!-- GETTING STARTED -->\n## Getting Started\n<br />\n<div align="center">\n    <img src="https://github.com/georgian-io/pyoats/raw/main/static/example-sine_wave.png" alt="Usage Example" width="600" height="auto">\n  </a>\n  </div>\n\n\n### Prerequisites\n[![Python][Python.org]][Python-url] >=3.8, <3.11\n\n\n#### For Docker Install:\n\n[![Docker][Docker.com]][Docker-url]\n\n#### For Local Install:\n\n[![Poetry][Python-Poetry.org]][Poetry-url]\n\n### Installation\n#### PyPI\n1. Install package via pip\n   ```sh\n   pip install pyoats\n   ```\n   **❗ Installing using an environment manager such as [`conda`](https://docs.conda.io/en/latest/miniconda.html), [`venv`](https://docs.python.org/3/library/venv.html), and [`poetry`](https://python-poetry.org/) is highly encouraged as this package contains deep learning frameworks.**\n  \n#### Docker\n1. Clone the repo\n    ```sh\n    git clone https://github.com/georgian-io/pyoats.git && cd pyoats \n    ```\n2. Build image\n    ```sh\n    docker build -t pyoats . \n    ```\n3. Run Container\n    ```sh \n    # CPU Only\n    docker run -it pyoats\n    \n    # with GPU\n    docker run -it --gpus all pyoats\n    ```\n    \n#### Local\n1. Clone the repo\n    ```sh\n    git clone https://github.com/georgian-io/pyoats.git && cd pyoats \n    ```\n2. Install via Poetry\n    ```sh \n    poetry install\n    ```\n\n\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n\n\n<!-- USAGE EXAMPLES -->\n## Usage\n\n### Quick Start\nFor a quick start, please refer to <a href="https://medium.com/@georgian-io/time-series-anomaly-detection-a-field-study-d13b35ee4344">our blog</a> or copy our <a href="https://tinyurl.com/pyoats-notebook">Colab notebook</a>!\n\n\n### Getting Anomaly Score\n```python \nfrom oats.models import NHiTSModel\n\nmodel = NHiTSModel(window=20, use_gpu=True)\nmodel.fit(train)\nscores = model.get_scores(test)\n```\n### Getting Threshold\n```python \nfrom oats.threshold import QuantileThreshold\n\nt = QuantileThreshold()\nthreshold = t.get_threshold(scores, 0.99)\nanom = scores > threshold\n```\n_For more examples, please refer to the [Documentation](https://georgian-io.github.io/pyoats-docs/)_\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n<!-- Models -->\n## Models\n\n\n_For more details about the individual models, please refer to the [Documentation](https://georgian-io.github.io/pyoats-docs/) or <a href="https://medium.com/georgian-impact-blog/time-series-anomaly-detection-the-detectives-toolbox-9ef131dddaf9">this blog</a> for deeper explanation._\n\nModel | Type | Multivariate Support* | Requires Fitting | DL Framework Dependency | Paper | Reference Model\n--- | :---: | :---: | :---: | :---: | :---: |  :---: \n`ARIMA` | Predictive | ⚠️ | ✅ |  | | [`statsmodels.ARIMA`](https://www.statsmodels.org/dev/generated/statsmodels.tsa.arima.model.ARIMA.html)\n`FluxEV` | Predictive | ⚠️ | ✅ |  | [📝](https://dl.acm.org/doi/10.1145/3437963.3441823) | \n`LightGBM` | Predictive | ⚠️ | ✅ |  |  | [`darts.LightGBM`](https://unit8co.github.io/darts/generated_api/darts.models.forecasting.gradient_boosted_model.html)\n`Moving Average` | Predictive | ⚠️ |  |  |  | \n`N-BEATS` | Predictive | ✅ | ✅ | [![Pytorch][Pytorch.org]][Torch-url] | [📝](https://openreview.net/forum?id=r1ecqn4YwB) | [`darts.NBEATS`](https://unit8co.github.io/darts/generated_api/darts.models.forecasting.nbeats.html)\n`N-HiTS` | Predictive | ✅ | ✅ | [![Pytorch][Pytorch.org]][Torch-url] | [📝](https://arxiv.org/abs/2201.12886) | [`darts.NHiTS`](https://unit8co.github.io/darts/generated_api/darts.models.forecasting.nhits.html)\n`RandomForest` | Predictive | ⚠️ | ✅ | | | [`darts.RandomForest`](https://unit8co.github.io/darts/generated_api/darts.models.forecasting.random_forest.html)\n`Regression` | Predictive | ⚠️ | ✅ | | | [`darts.Regression`](https://unit8co.github.io/darts/generated_api/darts.models.forecasting.regression_model.html)\n`RNN` | Predictive | ✅ | ✅ | [![Pytorch][Pytorch.org]][Torch-url] | | [`darts.RNN`](https://unit8co.github.io/darts/generated_api/darts.models.forecasting.rnn_model.html)\n`Temporal Convolution Network` | Predictive | ✅ | ✅ | [![Pytorch][Pytorch.org]][Torch-url] | [📝](https://arxiv.org/abs/1803.01271) | [`darts.TCN`](https://unit8co.github.io/darts/generated_api/darts.models.forecasting.tcn_model.html)\n`Temporal Fusion Transformers` | Predictive | ✅ | ✅ | [![Pytorch][Pytorch.org]][Torch-url] | [📝](https://arxiv.org/abs/1912.09363) | [`darts.TFT`](https://unit8co.github.io/darts/generated_api/darts.models.forecasting.tft_model.html)\n`Transformer` | Predictive | ✅ | ✅ | [![Pytorch][Pytorch.org]][Torch-url] | [📝](https://arxiv.org/abs/1706.03762) | [`darts.Transformer`](https://unit8co.github.io/darts/generated_api/darts.models.forecasting.transformer_model.html)\n`Isolation Forest` | Distance-Based | ✅ | ✅ | || [`pyod.IForest`](https://pyod.readthedocs.io/en/latest/pyod.models.html#module-pyod.models.iforest)\n`Matrix Profile` | Distance-Based | ✅ |  | | [📝](https://www.cs.ucr.edu/~eamonn/MatrixProfile.html) | [`stumpy`](https://github.com/TDAmeritrade/stumpy)\n`TranAD` | Reconstruction-Based | ✅ | ✅ | [![TensorFlow][TensorFlow.org]][Torch-url] | [📝](https://arxiv.org/abs/2201.07284) | [`tranad`](https://github.com/imperial-qore/TranAD)\n`Variational Autoencoder` | Reconstruction-Based | ✅ | ✅ | [![TensorFlow][TensorFlow.org]][Torch-url] |   [📝](https://arxiv.org/abs/1312.6114) | [`pyod.VAE`](https://pyod.readthedocs.io/en/latest/pyod.models.html#module-pyod.models.vae)\n`Quantile` | Rule-Based | ⚠️ |  |  || \n\n\n\n\n\n**\\*** For models with ⚠️, score calculation is done separately along each column. This implicitly assumes independence of covariates, which means that **the resultant anomaly scores do not take into account of inter-variable dependency structures.**\n\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n<!-- ROADMAP -->\n## Roadmap\n\n- [ ] Automatic hyper-parameter tuning\n- [ ] More examples \n- [ ] More preprocessors\n- [ ] More models from `pyod`\n\nSee the [open issues](https://github.com/georgian-io/pyoats/issues) for a full list of proposed features (and known issues).\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n\n\n<!-- CONTRIBUTING -->\n## Contributing\n\nContributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**.\n\nIf you have a suggestion that would make this better, please fork the repo and create a pull request. You can also simply open an issue with the tag "enhancement".\n\nDon\'t forget to give the project a star! Thanks again!\n\n1. Fork the Project\n2. Create your Feature Branch (`git checkout -b feature/amazing_feature`)\n3. Commit your Changes (`git commit -m \'Add some amazing_feature\'`)\n4. Push to the Branch (`git push origin feature/amazing_feature`)\n5. Open a Pull Request\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n\n\n<!-- LICENSE -->\n## License\n\nDistributed under the Apache 2.0 License. See `LICENSE` for more information.\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n\n\n<!-- CONTACT -->\n## Contact\n\n<div align="left">\n  <a href="https://www.georgian.io">\n    <img src="https://s34372.pcdn.co/wp-content/uploads/2022/03/Georgian_Blue.png" alt="Logo" width="auto" height="80">\n  </a>\n  </div>\n\n\n|<!-- -->|<!-- -->|<!-- -->|<!-- -->|\n|---|---|---|---|\n| __Benjamin Ye__ | [![Github][BenGithub]][BenLinkedIn-url] | [![LinkedIn][BenLinkedIn]][BenLinkedIn-url] |  [![eMail][eMail]][BenEmail-url] \n\n\nProject Link: [https://github.com/georgian-io/oats](https://github.com/georgian-io/oats)\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n\n\n<!-- ACKNOWLEDGMENTS -->\n## Acknowledgments\nI would like to thank my colleagues from Georgian for all the help and advice provided along the way.\n* [Angeline Yasodhara](mailto:angeline@georgian.io)\n* [Akshay Budhkar](mailto:akshay@georgian.io)\n* [Borna Almasi](mailto:borna@georgian.io)\n* [Parinaz Sobhani](mailto:parinaz@georgian.io)\n* [Rodrigo Ceballos Lentini](mailto:rodrigo@georgian.io)\n\nI\'d also like to extend my gratitude to all the contributors at [`Darts`][Darts-url] (for time series predictions) and [`PyOD`][PyOD-url] (for general outlier detection), whose projects have enabled a straight-forward extension into the domain of time series anomaly detection.\n\nFinally, it\'ll be remiss of me to not mention [DATA Lab @ Rice University](https://cs.rice.edu/~xh37/index.html), whose wonderful [`TODS`][TODS-url] package served as a major inspiration for this project. Please check them out especially if you\'re looking for AutoML support.\n\n[![Darts][Darts]][Darts-url] [![PyOD][PyOD]][PyOD-url] [![TODS][TODS]][TODS-url]\n\n \n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n\n\n<!-- MARKDOWN LINKS & IMAGES -->\n<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->\n[contributors-shield]: https://img.shields.io/github/contributors/georgian-io/oats.svg?style=for-the-badge\n[contributors-url]: https://github.com/georgian-io/pyoats/graphs/contributors\n[forks-shield]: https://img.shields.io/github/forks/georgian-io/contributors.svg?style=for-the-badge\n[forks-url]: https://github.com/georgian-io/pyoats/network/members\n[stars-shield]: https://img.shields.io/github/stars/georgian-io/oats.svg?style=for-the-badge\n[stars-url]: https://github.com/georgian-io/pyoats/stargazers\n[issues-shield]: https://img.shields.io/github/issues/georgian-io/oats.svg?style=for-the-badge\n[issues-url]: https://github.com/georgian-io/pyoats/issues\n[license-shield]: https://img.shields.io/github/license/georgian-io/oats.svg?style=for-the-badge\n[license-url]: https://github.com/georgian-io/pyoats/blob/master/LICENSE\n[last_commit-shield]: https://img.shields.io/github/last-commit/georgian-io/oats.svg?style=for-the-badge\n[last_commit-url]: https://github.com/georgian-io/pyoats/commits/\n\n\n\n<!-- Deps Links -->\n[Python-Poetry.org]: https://img.shields.io/badge/Poetry-60A5FA?style=for-the-badge&logo=poetry&logoColor=white\n[Poetry-url]: https://www.python-poetry.org/\n[Python.org]: https://img.shields.io/badge/Python-3776AB?style=for-the-badge&logo=python&logoColor=white\n[Python-url]: https://www.python.org/\n[PyTorch.org]: https://img.shields.io/badge/PyTorch-EE4C2C?style=for-the-badge&logo=pytorch&logoColor=white\n[Torch-url]: https://pytorch.org/\n[TensorFlow.org]: https://img.shields.io/badge/TensorFlow-FF6F00?style=for-the-badge&logo=tensorflow&logoColor=white\n[TF-url]: https://www.tensorflow.org/\n[Numpy.org]: https://img.shields.io/badge/Numpy-013243?style=for-the-badge&logo=numpy&logoColor=white\n[Numpy-url]: https://www.numpy.org/\n[Darts]: https://img.shields.io/badge/Repo-Darts-2100FF?style=for-the-badge&logo=github&logoColor=white\n[Darts-url]: https://github.com/unit8co/darts\n[PyOD]: https://img.shields.io/badge/Repo-PyOD-000000?style=for-the-badge&logo=github&logoColor=white\n[PyOD-url]: https://github.com/yzhao062/pyod\n[TODS]: https://img.shields.io/badge/Repo-TODS-29B48C?style=for-the-badge&logo=github&logoColor=white\n[TODS-url]: https://github.com/datamllab/tods\n[Docker.com]: https://img.shields.io/badge/Docker-2496ED?style=for-the-badge&logo=docker&logoColor=white\n[Docker-url]: https://docker.com\n[PyTorchLightning.ai]: https://img.shields.io/badge/lightning-792EE5?style=for-the-badge&logo=pytorchlightning&logoColor=white\n[Lightning-url]: https://www.pytorchlightning.ai/\n\n\n\n[BenLinkedIn]: https://img.shields.io/badge/LinkedIn-0A66C2?style=for-the-badge&logo=linkedin&logoColor=white\n[BenLinkedIn-url]: https://www.linkedin.com/in/benjaminye/\n\n[eMail]: https://img.shields.io/badge/EMail-EA4335?style=for-the-badge&logo=gmail&logoColor=white\n[BenEmail-url]: mailto:benjamin.ye@georgian.io\n\n[BenGithub]: https://img.shields.io/badge/Profile-14334A?style=for-the-badge&logo=github&logoColor=white\n[BenGithub-url]: https://www.linkedin.com/in/benjaminye/\n',
    'author': 'Benjamin Ye',
    'author_email': 'benjamin.ye@georgian.io',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<3.11',
}


setup(**setup_kwargs)
