# Forms Reference
## Table of contents


<a href="#user-content-1000">**1000.**</a>
1. <a href="#user-content-physical-exam">Physical Exam</a>
2. <a href="#user-content-patient-history">Patient History</a>
3. <a href="#user-content-other-arv-regimens">Other Arv Regimens</a>
4. <a href="#user-content-blood-result-insulin">Blood Result: Insulin</a>
5. <a href="#user-content-blood-result-hba1c">Blood Result: Hba1C</a>
6. <a href="#user-content-blood-result-rft">Blood Result: Rft</a>
7. <a href="#user-content-blood-result-lft">Blood Result: Lft</a>
8. <a href="#user-content-blood-result-fbc">Blood Result: Fbc</a>
9. <a href="#user-content-blood-result-lipids">Blood Result: Lipids</a>
10. <a href="#user-content-malaria-test">Malaria Test</a>
11. <a href="#user-content-urine-dipstick-test">Urine Dipstick Test</a>
12. <a href="#user-content-study-medication">Study Medication</a>

<a href="#user-content-1005">**1005.**</a>
1. <a href="#user-content-clinic-follow-up-vitals">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination">Clinic Follow Up: Examination</a>
3. <a href="#user-content-blood-result-glucose">Blood Result: Glucose</a>
4. <a href="#user-content-study-medication-1">Study Medication</a>
5. <a href="#user-content-medication-adherence">Medication Adherence</a>
6. <a href="#user-content-euroqol-eq-5d-3l-instrument">Euroqol Eq-5D-3L Instrument</a>
7. <a href="#user-content-sf-12-health-survey">Sf-12 Health Survey</a>
8. <a href="#user-content-health-economics-m3">Health Economics (M3)</a>

<a href="#user-content-1010">**1010.**</a>
1. <a href="#user-content-clinic-follow-up-vitals-1">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination-1">Clinic Follow Up: Examination</a>
3. <a href="#user-content-blood-result-glucose-1">Blood Result: Glucose</a>
4. <a href="#user-content-study-medication-2">Study Medication</a>
5. <a href="#user-content-medication-adherence-1">Medication Adherence</a>
6. <a href="#user-content-urine-pregnancy">Urine Pregnancy</a>
7. <a href="#user-content-health-economics-m3-1">Health Economics (M3)</a>
8. <a href="#user-content-michigan-neuropathy-screening-instrument-mnsi">Michigan Neuropathy Screening Instrument (Mnsi)</a>

<a href="#user-content-1030">**1030.**</a>
1. <a href="#user-content-clinic-follow-up-vitals-2">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination-2">Clinic Follow Up: Examination</a>
3. <a href="#user-content-blood-result-glucose-2">Blood Result: Glucose</a>
4. <a href="#user-content-blood-result-rft-1">Blood Result: Rft</a>
5. <a href="#user-content-blood-result-lft-1">Blood Result: Lft</a>
6. <a href="#user-content-study-medication-3">Study Medication</a>
7. <a href="#user-content-medication-adherence-2">Medication Adherence</a>
8. <a href="#user-content-urine-pregnancy-1">Urine Pregnancy</a>
9. <a href="#user-content-michigan-neuropathy-screening-instrument-mnsi-1">Michigan Neuropathy Screening Instrument (Mnsi)</a>

<a href="#user-content-1060">**1060.**</a>
1. <a href="#user-content-clinic-follow-up-vitals-3">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination-3">Clinic Follow Up: Examination</a>
3. <a href="#user-content-blood-result-glucose-3">Blood Result: Glucose</a>
4. <a href="#user-content-blood-result-rft-2">Blood Result: Rft</a>
5. <a href="#user-content-blood-result-lft-2">Blood Result: Lft</a>
6. <a href="#user-content-blood-result-fbc-1">Blood Result: Fbc</a>
7. <a href="#user-content-study-medication-4">Study Medication</a>
8. <a href="#user-content-medication-adherence-3">Medication Adherence</a>
9. <a href="#user-content-urine-pregnancy-2">Urine Pregnancy</a>
10. <a href="#user-content-michigan-neuropathy-screening-instrument-mnsi-2">Michigan Neuropathy Screening Instrument (Mnsi)</a>

<a href="#user-content-1090">**1090.**</a>
1. <a href="#user-content-clinic-follow-up-vitals-4">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination-4">Clinic Follow Up: Examination</a>
3. <a href="#user-content-blood-result-glucose-4">Blood Result: Glucose</a>
4. <a href="#user-content-study-medication-5">Study Medication</a>
5. <a href="#user-content-medication-adherence-4">Medication Adherence</a>
6. <a href="#user-content-urine-pregnancy-3">Urine Pregnancy</a>

<a href="#user-content-1120">**1120.**</a>
1. <a href="#user-content-clinic-follow-up-vitals-5">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination-5">Clinic Follow Up: Examination</a>
3. <a href="#user-content-glucose-ifg-ogtt">Glucose (Ifg, Ogtt)</a>
4. <a href="#user-content-blood-result-hba1c-1">Blood Result: Hba1C</a>
5. <a href="#user-content-blood-result-rft-3">Blood Result: Rft</a>
6. <a href="#user-content-blood-result-lft-3">Blood Result: Lft</a>
7. <a href="#user-content-blood-result-fbc-2">Blood Result: Fbc</a>
8. <a href="#user-content-blood-result-lipids-1">Blood Result: Lipids</a>
9. <a href="#user-content-study-medication-6">Study Medication</a>
10. <a href="#user-content-medication-adherence-5">Medication Adherence</a>
11. <a href="#user-content-urine-pregnancy-4">Urine Pregnancy</a>

<a href="#user-content-1150">**1150.**</a>
1. <a href="#user-content-clinic-follow-up-vitals-6">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination-6">Clinic Follow Up: Examination</a>
3. <a href="#user-content-blood-result-glucose-5">Blood Result: Glucose</a>
4. <a href="#user-content-study-medication-7">Study Medication</a>
5. <a href="#user-content-medication-adherence-6">Medication Adherence</a>
6. <a href="#user-content-urine-pregnancy-5">Urine Pregnancy</a>

<a href="#user-content-1180">**1180.**</a>
1. <a href="#user-content-clinic-follow-up-vitals-7">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination-7">Clinic Follow Up: Examination</a>
3. <a href="#user-content-blood-result-glucose-6">Blood Result: Glucose</a>
4. <a href="#user-content-blood-result-fbc-3">Blood Result: Fbc</a>
5. <a href="#user-content-study-medication-8">Study Medication</a>
6. <a href="#user-content-medication-adherence-7">Medication Adherence</a>
7. <a href="#user-content-urine-pregnancy-6">Urine Pregnancy</a>

<a href="#user-content-1210">**1210.**</a>
1. <a href="#user-content-clinic-follow-up-vitals-8">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination-8">Clinic Follow Up: Examination</a>
3. <a href="#user-content-blood-result-glucose-7">Blood Result: Glucose</a>
4. <a href="#user-content-study-medication-9">Study Medication</a>
5. <a href="#user-content-medication-adherence-8">Medication Adherence</a>
6. <a href="#user-content-urine-pregnancy-7">Urine Pregnancy</a>

<a href="#user-content-1240">**1240.**</a>
1. <a href="#user-content-clinic-follow-up-vitals-9">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination-9">Clinic Follow Up: Examination</a>
3. <a href="#user-content-glucose-ifg-ogtt-1">Glucose (Ifg, Ogtt)</a>
4. <a href="#user-content-blood-result-hba1c-2">Blood Result: Hba1C</a>
5. <a href="#user-content-blood-result-rft-4">Blood Result: Rft</a>
6. <a href="#user-content-blood-result-lft-4">Blood Result: Lft</a>
7. <a href="#user-content-blood-result-fbc-4">Blood Result: Fbc</a>
8. <a href="#user-content-blood-result-lipids-2">Blood Result: Lipids</a>
9. <a href="#user-content-study-medication-10">Study Medication</a>
10. <a href="#user-content-medication-adherence-9">Medication Adherence</a>
11. <a href="#user-content-urine-pregnancy-8">Urine Pregnancy</a>

<a href="#user-content-1270">**1270.**</a>
1. <a href="#user-content-clinic-follow-up-vitals-10">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination-10">Clinic Follow Up: Examination</a>
3. <a href="#user-content-blood-result-glucose-8">Blood Result: Glucose</a>
4. <a href="#user-content-study-medication-11">Study Medication</a>
5. <a href="#user-content-medication-adherence-10">Medication Adherence</a>
6. <a href="#user-content-urine-pregnancy-9">Urine Pregnancy</a>

<a href="#user-content-1300">**1300.**</a>
1. <a href="#user-content-clinic-follow-up-vitals-11">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination-11">Clinic Follow Up: Examination</a>
3. <a href="#user-content-blood-result-glucose-9">Blood Result: Glucose</a>
4. <a href="#user-content-blood-result-rft-5">Blood Result: Rft</a>
5. <a href="#user-content-blood-result-lft-5">Blood Result: Lft</a>
6. <a href="#user-content-blood-result-fbc-5">Blood Result: Fbc</a>
7. <a href="#user-content-study-medication-12">Study Medication</a>
8. <a href="#user-content-medication-adherence-11">Medication Adherence</a>
9. <a href="#user-content-urine-pregnancy-10">Urine Pregnancy</a>

<a href="#user-content-1330">**1330.**</a>
1. <a href="#user-content-clinic-follow-up-vitals-12">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination-12">Clinic Follow Up: Examination</a>
3. <a href="#user-content-blood-result-glucose-10">Blood Result: Glucose</a>
4. <a href="#user-content-study-medication-13">Study Medication</a>
5. <a href="#user-content-medication-adherence-12">Medication Adherence</a>
6. <a href="#user-content-urine-pregnancy-11">Urine Pregnancy</a>

<a href="#user-content-1360">**1360.**</a>
1. <a href="#user-content-clinic-follow-up-vitals-13">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination-13">Clinic Follow Up: Examination</a>
3. <a href="#user-content-glucose-ifg-ogtt-2">Glucose (Ifg, Ogtt)</a>
4. <a href="#user-content-blood-result-hba1c-3">Blood Result: Hba1C</a>
5. <a href="#user-content-blood-result-rft-6">Blood Result: Rft</a>
6. <a href="#user-content-blood-result-lft-6">Blood Result: Lft</a>
7. <a href="#user-content-blood-result-fbc-6">Blood Result: Fbc</a>
8. <a href="#user-content-blood-result-lipids-3">Blood Result: Lipids</a>
9. <a href="#user-content-study-medication-14">Study Medication</a>
10. <a href="#user-content-medication-adherence-13">Medication Adherence</a>
11. <a href="#user-content-urine-pregnancy-12">Urine Pregnancy</a>

<a href="#user-content-3000">**3000.**</a>
1. <a href="#user-content-clinic-follow-up-vitals-14">Clinic Follow Up: Vitals</a>
2. <a href="#user-content-clinic-follow-up-examination-14">Clinic Follow Up: Examination</a>
3. <a href="#user-content-glucose-ifg-ogtt-3">Glucose (Ifg, Ogtt)</a>
4. <a href="#user-content-blood-result-hba1c-4">Blood Result: Hba1C</a>
5. <a href="#user-content-blood-result-rft-7">Blood Result: Rft</a>
6. <a href="#user-content-blood-result-lft-7">Blood Result: Lft</a>
7. <a href="#user-content-blood-result-fbc-7">Blood Result: Fbc</a>
8. <a href="#user-content-blood-result-lipids-4">Blood Result: Lipids</a>
9. <a href="#user-content-study-medication-15">Study Medication</a>
10. <a href="#user-content-medication-adherence-14">Medication Adherence</a>
11. <a href="#user-content-urine-pregnancy-13">Urine Pregnancy</a>

<a href="#user-content-2000">**2000.**</a>
1. <a href="#user-content-delivery">Delivery</a>


### 1000



*Rendered on 2022-06-24 14:17*

#### Physical Exam
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_physicalexam
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_physicalexam
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: BP and Heart**

**3.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_physicalexam
- column: sys_blood_pressure_one
- type: IntegerField
---

**4.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_physicalexam
- column: dia_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_physicalexam
- column: sys_blood_pressure_two
- type: IntegerField
---

**6.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_physicalexam
- column: dia_blood_pressure_two
- type: IntegerField
---

**7.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_physicalexam
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_physicalexam
- column: heart_rate
- type: IntegerField
---

**9.0.** Is the heart beat <u>irregular</u>?
- db_table: meta_subject_physicalexam
- column: irregular_heartbeat
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If the heartbeat is <u>irregular</u>, please describe
- db_table: meta_subject_physicalexam
- column: irregular_heartbeat_description
- type: TextField
---

**11.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_physicalexam
- column: respiratory_rate
- type: IntegerField
---

**Section: Part 2: Other vitals**

**12.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_physicalexam
- column: temperature
- type: DecimalField
---

**Section: Part 3: Signs**

**13.0.** Jaundice?
- db_table: meta_subject_physicalexam
- column: jaundice
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**14.0.** Presence of peripheral oedema?
- db_table: meta_subject_physicalexam
- column: peripheral_oedema
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**15.0.** Abdominal tenderness on palpation?
- db_table: meta_subject_physicalexam
- column: abdominal_tenderness
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, abdominal tenderness, please describe
- db_table: meta_subject_physicalexam
- column: abdominal_tenderness_description
- type: TextField
---

**17.0.** Enlarged liver on palpation?
- db_table: meta_subject_physicalexam
- column: enlarged_liver
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---




*Rendered on 2022-06-24 14:17*

#### Patient History
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_patienthistory
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_patienthistory
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Do you have any of the following symptoms?
- db_table: meta_subject_patienthistory
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** If other, please specify ...
- db_table: meta_subject_patienthistory
- column: other_symptoms
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: HIV, ARVs and other prophylaxis**

**5.0.** When was the diagnosis of HIV made?
- db_table: meta_subject_patienthistory
- column: hiv_diagnosis_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Date of start of antiretroviral therapy (ART)
- db_table: meta_subject_patienthistory
- column: arv_initiation_date
- type: DateField
- format: YYYY-MM-DD
---

**7.0.** Last viral load

&nbsp;&nbsp;&nbsp;&nbsp; *copies/mL*
- db_table: meta_subject_patienthistory
- column: viral_load
- type: IntegerField
---

**8.0.** Date of last viral load
- db_table: meta_subject_patienthistory
- column: viral_load_date
- type: DateField
- format: YYYY-MM-DD
---

**9.0.** Last CD4

&nbsp;&nbsp;&nbsp;&nbsp; *cells/mm<sup>3</sup>*
- db_table: meta_subject_patienthistory
- column: cd4
- type: IntegerField
---

**10.0.** Date of last CD4
- db_table: meta_subject_patienthistory
- column: cd4_date
- type: DateField
- format: YYYY-MM-DD
---

**11.0.** Which antiretroviral therapy regimen is the patient currently on?
- db_table: meta_subject_patienthistory
- column: current_arv_regimen
- type: ForeignKey
---

**12.0.** If other, please specify ...
- db_table: meta_subject_patienthistory
- column: other_current_arv_regimen
- type: CharField
- length: 35
- responses: *free text*
---

**13.0.** When did the patient start this current antiretroviral therapy regimen?
- db_table: meta_subject_patienthistory
- column: current_arv_regimen_start_date
- type: DateField
- format: YYYY-MM-DD
---

**14.0.** Has the patient been on any previous regimen?
- db_table: meta_subject_patienthistory
- column: has_previous_arv_regimen
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**15.0.** Which antiretroviral therapy regimen was the patient previously on?
- db_table: meta_subject_patienthistory
- column: previous_arv_regimen
- type: ForeignKey
---

**16.0.** If other, please specify ...
- db_table: meta_subject_patienthistory
- column: other_previous_arv_regimen
- type: CharField
- length: 35
- responses: *free text*
---

**17.0.** When did the patient start this previous antiretroviral therapy regimen?
- db_table: meta_subject_patienthistory
- column: previous_arv_regimen_start_date
- type: DateField
- format: YYYY-MM-DD
---

**18.0.** Is the patient on any prophylaxis against opportunistic infections?
- db_table: meta_subject_patienthistory
- column: on_oi_prophylaxis
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** If YES, which prophylaxis is the patient on?
- db_table: meta_subject_patienthistory
- column: oi_prophylaxis
- type: ManyToManyField
- responses: *Select all that apply*
  - `tmp_smx`: *TMP/SMX*
  - `fluconazole`: *Fluconazole*
  - `isoniazid`: *Isoniazid*
  - `OTHER`: *Other, specify*
---

**20.0.** If other, please specify ...
- db_table: meta_subject_patienthistory
- column: other_oi_prophylaxis
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 3: Hypertension**

**21.0.** Has the patient been diagnosed with hypertension?
- db_table: meta_subject_patienthistory
- column: htn_diagnosis
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**22.0.** Is the patient on treatment for hypertension?
- db_table: meta_subject_patienthistory
- column: on_htn_treatment
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**23.0.** What medications is the patient currently taking for hypertension?
- db_table: meta_subject_patienthistory
- column: htn_treatment
- type: ManyToManyField
- responses: *Select all that apply*
  - `amlodipine`: *Amlodipine*
  - `atenolol`: *Atenolol*
  - `bendroflumethiazide`: *Bendroflumethiazide*
  - `bisoprolol`: *Bisoprolol*
  - `captopril`: *Captopril*
  - `diltiazem`: *Diltiazem*
  - `enalapril`: *Enalapril*
  - `eplerenone`: *Eplerenone*
  - `furosemide`: *Furosemide*
  - `hydralazine`: *Hydralazine*
  - `hydrochlothiazide`: *Hydrochlothiazide*
  - `indapamide`: *Indapamide*
  - `losartan`: *Losartan*
  - `metoprolol`: *Metoprolol*
  - `nifedipine`: *Nifedipine*
  - `perindopril`: *Perindopril*
  - `propanolol`: *Propanolol*
  - `spironolactone`: *Spironolactone*
  - `telmisartan`: *Telmisartan*
  - `torsemide`: *Torsemide*
  - `verapamil`: *Verapamil*
  - `OTHER`: *Other, specify*
---

**24.0.** If other medication(s), please specify ...
- db_table: meta_subject_patienthistory
- column: other_htn_treatment
- type: CharField
- length: 35
- responses: *free text*
---

**25.0.** Has the patient been diagnosed with dyslipidaemia?
- db_table: meta_subject_patienthistory
- column: dyslipidaemia_diagnosis
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**26.0.** Is the patient on treatment for dyslipidaemia?
- db_table: meta_subject_patienthistory
- column: on_dyslipidaemia_treatment
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**27.0.** What medication is the patient currently taking for dyslipidaemia?
- db_table: meta_subject_patienthistory
- column: dyslipidaemia_rx
- type: CharField
- length: 25
- responses:
  - `atorvastatin`: *Atorvastatin*
  - `rosuvastatin`: *Rosuvastatin*
  - `OTHER`: *Other, specify below ...*
  - `N/A`: *Not applicable*
---

**28.0.** Does the patient have any other conditions not mentioned above?
- db_table: meta_subject_patienthistory
- column: concomitant_conditions
- type: TextField
- length: 250
---

**29.0.** Is the patient taking any concomitant medications?
- db_table: meta_subject_patienthistory
- column: concomitant_medications
- type: TextField
- length: 250
---

**Section: Part 4: Other history**

**30.0.** Is the patient a <u>current</u> smoker?
- db_table: meta_subject_patienthistory
- column: current_smoker
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**31.0.** Is the patient a <u>previous</u> smoker?
- db_table: meta_subject_patienthistory
- column: former_smoker
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**32.0.** In the <u>past year</u>, have you had any of the following symptoms?
- db_table: meta_subject_patienthistory
- column: dm_symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `frequent_urination`: *Wanting to urinate more often than usual*
  - `excessive_thirst`: *Wanting to drink water more than usual*
  - `excessive_eating`: *Wanting to eat food more than usual*
  - `OTHER`: *Other, specify*
  - `none`: *No symptoms to report*
---

**33.0.** If other symptom in the <u>past year</u>, please specify ...
- db_table: meta_subject_patienthistory
- column: other_dm_symptoms
- type: CharField
- length: 35
- responses: *free text*
---

**34.0.** Has anyone in your immediate family ever been diagnosed with diabetes?

&nbsp;&nbsp;&nbsp;&nbsp; *Immediate family is parents, siblings, and children*
- db_table: meta_subject_patienthistory
- column: dm_in_family
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---




*Rendered on 2022-06-24 14:17*

#### Other Arv Regimens
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_otherarvregimens
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_otherarvregimens
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**2.1.** Are there additional ARV regimens to report NOT reported on the Patient History CRF?
- db_table: meta_subject_otherarvregimens
- column: has_other_regimens
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Insulin
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsins
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsins
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: insulin**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsins
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsins
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: INS**

**5.0.** Insulin
- db_table: meta_subject_bloodresultsins
- column: ins_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsins
- column: ins_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *IU/L*
  - `U/L`: *U/L*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsins
- column: ins_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsins
- column: ins_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**9.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsins
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsins
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**11.0.** summary
- db_table: meta_subject_bloodresultsins
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Hba1C
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultshba1c
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultshba1c
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: hba1c**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultshba1c
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultshba1c
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: HbA1c**

**5.0.** HbA1c value
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_units
- type: CharField
- length: 15
- responses: *free text*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**9.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultshba1c
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultshba1c
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**11.0.** summary
- db_table: meta_subject_bloodresultshba1c
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Rft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsrft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsrft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_rft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsrft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsrft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: UREA**

**5.0.** Urea (BUN)
- db_table: meta_subject_bloodresultsrft
- column: urea_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsrft
- column: urea_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: urea_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: urea_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: CREATININE**

**9.0.** Creatinine
- db_table: meta_subject_bloodresultsrft
- column: creatinine_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsrft
- column: creatinine_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `umol/L`: *μmol/L (micromoles/L)*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: creatinine_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: creatinine_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: URIC_ACID**

**13.0.** Uric Acid
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `mg/dL`: *mg/dL*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**17.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsrft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**18.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsrft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**19.0.** summary
- db_table: meta_subject_bloodresultsrft
- column: summary
- type: TextField
---

**Section: Calculated eGFR**

**20.0.** eGFR
- db_table: meta_subject_bloodresultsrft
- column: egfr_value
- type: DecimalField
---

**21.0.** units
- db_table: meta_subject_bloodresultsrft
- column: egfr_units
- type: CharField
- length: 15
- responses:
  - `mL/min/1.73m2`: *mL/min/1.73m2*
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Lft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultslft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultslft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_lft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultslft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultslft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: AST**

**5.0.** AST
- db_table: meta_subject_bloodresultslft
- column: ast_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultslft
- column: ast_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ast_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ast_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALT**

**9.0.** ALT
- db_table: meta_subject_bloodresultslft
- column: alt_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultslft
- column: alt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALP**

**13.0.** ALP
- db_table: meta_subject_bloodresultslft
- column: alp_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultslft
- column: alp_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alp_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alp_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: AMYLASE**

**17.0.** Serum Amylase
- db_table: meta_subject_bloodresultslft
- column: amylase_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultslft
- column: amylase_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: amylase_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: amylase_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: GGT**

**21.0.** GGT
- db_table: meta_subject_bloodresultslft
- column: ggt_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultslft
- column: ggt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ggt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ggt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALBUMIN**

**25.0.** Serum albumin
- db_table: meta_subject_bloodresultslft
- column: albumin_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultslft
- column: albumin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
  - `g/L`: *g/L*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: albumin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: albumin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**29.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultslft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**30.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultslft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**31.0.** summary
- db_table: meta_subject_bloodresultslft
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Fbc
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsfbc
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsfbc
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: fbc**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsfbc
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsfbc
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Haemoglobin**

**5.0.** Haemoglobin
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: HCT**

**9.0.** Hematocrit
- db_table: meta_subject_bloodresultsfbc
- column: hct_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: hct_units
- type: CharField
- length: 15
- responses:
  - `%`: *%*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: hct_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: hct_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: RBC**

**13.0.** Red blood cell count
- db_table: meta_subject_bloodresultsfbc
- column: rbc_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: rbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm^3*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: rbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: rbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: WBC**

**17.0.** WBC
- db_table: meta_subject_bloodresultsfbc
- column: wbc_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: wbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: wbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: wbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: PLATELETS**

**21.0.** Platelets
- db_table: meta_subject_bloodresultsfbc
- column: platelets_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: platelets_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: platelets_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: platelets_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCV**

**25.0.** MCV
- db_table: meta_subject_bloodresultsfbc
- column: mcv_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mcv_units
- type: CharField
- length: 15
- responses:
  - `fL/cell`: *fL/cell*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mcv_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mcv_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCH**

**29.0.** MCH
- db_table: meta_subject_bloodresultsfbc
- column: mch_value
- type: DecimalField
---

**30.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mch_units
- type: CharField
- length: 15
- responses:
  - `pg/cell`: *pg/cell*
---

**31.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mch_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**32.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mch_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCHC**

**33.0.** MCHC
- db_table: meta_subject_bloodresultsfbc
- column: mchc_value
- type: DecimalField
---

**34.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mchc_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**35.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mchc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**36.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mchc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**37.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsfbc
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**38.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsfbc
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**39.0.** summary
- db_table: meta_subject_bloodresultsfbc
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Lipids
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultslipid
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultslipid
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_lipids**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultslipid
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultslipid
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: LDL**

**5.0.** LDL
- db_table: meta_subject_bloodresultslipid
- column: ldl_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultslipid
- column: ldl_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: ldl_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: ldl_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: HDL**

**9.0.** HDL
- db_table: meta_subject_bloodresultslipid
- column: hdl_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultslipid
- column: hdl_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: hdl_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: hdl_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: TRIG**

**13.0.** Triglycerides
- db_table: meta_subject_bloodresultslipid
- column: trig_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultslipid
- column: trig_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: trig_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: trig_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: CHOL**

**17.0.** Total Cholesterol
- db_table: meta_subject_bloodresultslipid
- column: chol_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultslipid
- column: chol_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: chol_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: chol_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**21.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultslipid
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**22.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultslipid
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**23.0.** summary
- db_table: meta_subject_bloodresultslipid
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Malaria Test
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_malariatest
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_malariatest
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the malaria test performed?
- db_table: meta_subject_malariatest
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** Diagnostic test used
- db_table: meta_subject_malariatest
- column: diagnostic_type
- type: CharField
- length: 15
- responses:
  - `rapid_test`: *Rapid test*
  - `microscopy`: *Microscopy*
  - `N/A`: *Not applicable*
---

**5.0.** If NO, provide reason
- db_table: meta_subject_malariatest
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**6.0.** Result
- db_table: meta_subject_malariatest
- column: result
- type: CharField
- length: 25
- responses:
  - `present`: *Present*
  - `absent`: *Absent*
  - `N/A`: *Not Applicable*
---




*Rendered on 2022-06-24 14:17*

#### Urine Dipstick Test
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinedipsticktest
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinedipsticktest
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine dipstick test performed?
- db_table: meta_subject_urinedipsticktest
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinedipsticktest
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Ketones?
- db_table: meta_subject_urinedipsticktest
- column: ketones
- type: CharField
- length: 25
- responses:
  - `present`: *Present*
  - `absent`: *Absent*
  - `N/A`: *Not Applicable*
---

**6.0.** Protein?
- db_table: meta_subject_urinedipsticktest
- column: protein
- type: CharField
- length: 25
- responses:
  - `present`: *Present*
  - `absent`: *Absent*
  - `N/A`: *Not Applicable*
---

**7.0.** Glucose?
- db_table: meta_subject_urinedipsticktest
- column: glucose
- type: CharField
- length: 25
- responses:
  - `present`: *Present*
  - `absent`: *Absent*
  - `N/A`: *Not Applicable*
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---


#### Requisitions

* fbc

* chemistry_rft

* chemistry_lft

* insulin

### 1005



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Glucose
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsglu
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsglu
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: blood_glucose**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsglu
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsglu
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**5.0.** Was this fasting or non-fasting?
- db_table: meta_subject_bloodresultsglu
- column: fasting
- type: CharField
- length: 25
- responses:
  - `fasting`: *Fasting*
  - `non_fasting`: *Non-fasting*
---

**Section: Glucose**

**6.0.** Blood Glucose
- db_table: meta_subject_bloodresultsglu
- column: glucose_value
- type: DecimalField
---

**7.0.** units
- db_table: meta_subject_bloodresultsglu
- column: glucose_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**8.0.** abnormal
- db_table: meta_subject_bloodresultsglu
- column: glucose_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** reportable
- db_table: meta_subject_bloodresultsglu
- column: glucose_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**10.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsglu
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsglu
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**12.0.** summary
- db_table: meta_subject_bloodresultsglu
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Euroqol Eq-5D-3L Instrument
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_eq5d3l
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_eq5d3l
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Describe your health TODAY ...**

**3.0.** Mobility
- db_table: meta_subject_eq5d3l
- column: mobility
- type: CharField
- length: 45
- responses:
  - `no_problems_in_walking`: *I have no problems in walking about*
  - `some_problems_in_walking`: *I have some problems in walking about*
  - `confined_to_bed`: *I am confined to bed*
---

**4.0.** Self-care
- db_table: meta_subject_eq5d3l
- column: self_care
- type: CharField
- length: 45
- responses:
  - `no_problems_with_self_care`: *I have no problems with self-care*
  - `problems_washing_dressing_myself`: *I have some problems washing or dressing myself*
  - `unable_to_wash_dress_myself`: *I am unable to wash or dress myself*
---

**5.0.** Usual activities

&nbsp;&nbsp;&nbsp;&nbsp; *Example. work, study, housework, family or leisure activities*
- db_table: meta_subject_eq5d3l
- column: usual_activities
- type: CharField
- length: 45
- responses:
  - `no_problems_performing_usual_activities`: *I have no problems with performing my usual activities*
  - `some_problems_performing_usual_activities`: *I have some problems with performing my usual activities*
  - `unable_to_perform_usual_activities`: *I am unable to perform my usual activities*
---

**6.0.** Pain / Discomfort
- db_table: meta_subject_eq5d3l
- column: pain_discomfort
- type: CharField
- length: 45
- responses:
  - `no_pain_discomfort`: *I have no pain or discomfort*
  - `moderate_pain_discomfort`: *I have moderate pain or discomfort*
  - `extreme_pain_discomfort`: *I have extreme pain or discomfort*
---

**7.0.** Anxiety / Depression
- db_table: meta_subject_eq5d3l
- column: anxiety_depression
- type: CharField
- length: 45
- responses:
  - `not_anxious_depressed`: *I am not anxious or depressed*
  - `moderately_anxious_depressed`: *I am moderately anxious or depressed*
  - `extremely_anxious_depressed`: *I am extremely anxious or depressed*
---

**Section: How is your health TODAY?**

**8.0.** Visual score for how your health is TODAY
- db_table: meta_subject_eq5d3l
- column: health_today_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**9.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the number on the scale indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *This scale is numbered from 0 to 100. 100 means the <U>best</U> health you can imagine0 means the <U>worst</U> health you can imagine.*
- db_table: meta_subject_eq5d3l
- column: health_today_score_confirmed
- type: IntegerField
---

**Section: CRF Status**

**10.0.** CRF status

&nbsp;&nbsp;&nbsp;&nbsp; *If some data is still pending, flag this CRF as incomplete*
- db_table: meta_subject_eq5d3l
- column: crf_status
- type: CharField
- length: 25
- responses:
  - `INCOMPLETE`: *Incomplete (some data pending)*
  - `COMPLETE`: *Complete*
---

**11.0.** Any comments related to status of this CRF

&nbsp;&nbsp;&nbsp;&nbsp; *for example, why some data is still pending*
- db_table: meta_subject_eq5d3l
- column: crf_status_comments
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Sf-12 Health Survey
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_sf12
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_sf12
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: General health**

**3.0.** In general, would you say your health is:
- db_table: meta_subject_sf12
- column: general_health
- type: CharField
- length: 15
- responses:
  - `excellent`: *Excellent*
  - `very_good`: *Very good*
  - `good`: *Good*
  - `fair`: *Fair*
  - `poor`: *Poor*
---

**Section: Part 2: Activities limited by health**

**4.0.** <u>Moderate activities</u> such as moving a table, pushing a vacuum cleaner, bowling, or playing golf:
- db_table: meta_subject_sf12
- column: moderate_activities_now_limited
- type: CharField
- length: 20
- responses:
  - `limited_a_lot`: *YES, limited a lot*
  - `limited_a_little`: *YES, limited a little*
  - `not_limited_at_all`: *NO, not at all limited*
---

**5.0.** Climbing <u>several</u> flights of stairs:
- db_table: meta_subject_sf12
- column: climbing_stairs_now_limited
- type: CharField
- length: 20
- responses:
  - `limited_a_lot`: *YES, limited a lot*
  - `limited_a_little`: *YES, limited a little*
  - `not_limited_at_all`: *NO, not at all limited*
---

**Section: Part 3: Physical health problems (last 4 weeks)**

**6.0.** <u>Accomplished less</u> than you would like:
- db_table: meta_subject_sf12
- column: accomplished_less_physical_health
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** Were limited in the <u>kind</u> of work or other activities:
- db_table: meta_subject_sf12
- column: work_limited_physical_health
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 4: Emotional problems (last 4 weeks)**

**8.0.** <u>Accomplished less</u> than you would like:
- db_table: meta_subject_sf12
- column: accomplished_less_emotional
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Did work or activities <u>less carefully than usual</u>:
- db_table: meta_subject_sf12
- column: work_less_carefully_emotional
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 5: Pain (last 4 weeks)**

**10.0.** During the <u>past 4 weeks</u>, how much <u>did pain interfere</u> with your normal work (including work outside the home and housework)?
- db_table: meta_subject_sf12
- column: pain_interfere_work
- type: CharField
- length: 15
- responses:
  - `not_at_all`: *Not at all*
  - `a_little_bit`: *A little bit*
  - `moderately`: *Moderately*
  - `quite_a-bit`: *Quite a bit*
  - `extremely`: *Extremely*
---

**Section: Part 6: Feeling (last 4 weeks)**

**11.0.** Have you felt calm & peaceful?
- db_table: meta_subject_sf12
- column: felt_calm_peaceful
- type: CharField
- length: 25
- responses:
  - `all_of_the_time`: *All of the time*
  - `most_of_the_time`: *Most of the time*
  - `good_bit_of_the_time`: * A good bit of the time*
  - `some_of_the_time`: *Some of the time*
  - `little_of_the_time`: *A little of the time*
  - `none_of_the_time`: *None of the time*
---

**12.0.** Did you have a lot of energy?
- db_table: meta_subject_sf12
- column: felt_lot_energy
- type: CharField
- length: 25
- responses:
  - `all_of_the_time`: *All of the time*
  - `most_of_the_time`: *Most of the time*
  - `good_bit_of_the_time`: * A good bit of the time*
  - `some_of_the_time`: *Some of the time*
  - `little_of_the_time`: *A little of the time*
  - `none_of_the_time`: *None of the time*
---

**13.0.** Have you felt down-hearted and blue?
- db_table: meta_subject_sf12
- column: felt_down
- type: CharField
- length: 25
- responses:
  - `all_of_the_time`: *All of the time*
  - `most_of_the_time`: *Most of the time*
  - `good_bit_of_the_time`: * A good bit of the time*
  - `some_of_the_time`: *Some of the time*
  - `little_of_the_time`: *A little of the time*
  - `none_of_the_time`: *None of the time*
---

**Section: Part 7: Social activities (last 4 weeks)**

**14.0.** During the <u>past 4 weeks</u>, how much of the time has your physical health or emotional problems interfered with your social activities (like visiting friends, relatives, etc.)?
- db_table: meta_subject_sf12
- column: social_activities_interfered
- type: CharField
- length: 25
- responses:
  - `all_of_the_time`: *All of the time*
  - `most_of_the_time`: *Most of the time*
  - `some_of_the_time`: *Some of the time*
  - `little_of_the_time`: *A little of the time*
  - `none_of_the_time`: *None of the time*
---

**Section: CRF Status**

**15.0.** CRF status

&nbsp;&nbsp;&nbsp;&nbsp; *If some data is still pending, flag this CRF as incomplete*
- db_table: meta_subject_sf12
- column: crf_status
- type: CharField
- length: 25
- responses:
  - `INCOMPLETE`: *Incomplete (some data pending)*
  - `COMPLETE`: *Complete*
---

**16.0.** Any comments related to status of this CRF

&nbsp;&nbsp;&nbsp;&nbsp; *for example, why some data is still pending*
- db_table: meta_subject_sf12
- column: crf_status_comments
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Health Economics (M3)
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_healtheconomicssimple
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_healtheconomicssimple
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Marital status
- db_table: meta_subject_healtheconomicssimple
- column: marital_status
- type: CharField
- length: 25
- responses:
  - `never_married`: *Never married*
  - `married`: *Currently married*
  - `separated`: *Separated*
  - `divorced`: *Divorced*
  - `widowed`: *Widow / Spinster*
---

**4.0.** What is your occupation/profession?
- db_table: meta_subject_healtheconomicssimple
- column: occupation
- type: CharField
- length: 50
- responses: *free text*
---

**Section: Education**

**5.0.** How many years of education did you complete?
- db_table: meta_subject_healtheconomicssimple
- column: education_in_years
- type: IntegerField
---

**6.0.** What is your highest education certificate?
- db_table: meta_subject_healtheconomicssimple
- column: education_certificate
- type: CharField
- length: 50
- responses:
  - `primary`: *Primary Certificate*
  - `secondary`: *Secondary Certificate*
  - `tertiary`: *post-Secondary/Tertiary/College*
  - `OTHER`: *Other, please specify ...*
  - `N/A`: *Not applicable, never went to school*
---

**6.1.** If other, please specify ...
- db_table: meta_subject_healtheconomicssimple
- column: education_certificate_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.0.** If your highest education certificate above is `Tertiary`, what type of tertiary certificate?
- db_table: meta_subject_healtheconomicssimple
- column: education_certificate_tertiary
- type: CharField
- length: 50
- responses: *free text*
---

**8.0.** Did you go to primary/elementary school?
- db_table: meta_subject_healtheconomicssimple
- column: primary_school
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**9.0.** If YES, for how many years
- db_table: meta_subject_healtheconomicssimple
- column: primary_school_in_years
- type: IntegerField
---

**10.0.** Did you go to secondary school?
- db_table: meta_subject_healtheconomicssimple
- column: secondary_school
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, for how many years
- db_table: meta_subject_healtheconomicssimple
- column: secondary_school_in_years
- type: IntegerField
---

**12.0.** Did you go to higher education?
- db_table: meta_subject_healtheconomicssimple
- column: higher_education
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** If YES, for how many years
- db_table: meta_subject_healtheconomicssimple
- column: higher_education_in_years
- type: IntegerField
---


#### Requisitions

* blood_glucose

### 1010



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Glucose
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsglu
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsglu
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: blood_glucose**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsglu
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsglu
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**5.0.** Was this fasting or non-fasting?
- db_table: meta_subject_bloodresultsglu
- column: fasting
- type: CharField
- length: 25
- responses:
  - `fasting`: *Fasting*
  - `non_fasting`: *Non-fasting*
---

**Section: Glucose**

**6.0.** Blood Glucose
- db_table: meta_subject_bloodresultsglu
- column: glucose_value
- type: DecimalField
---

**7.0.** units
- db_table: meta_subject_bloodresultsglu
- column: glucose_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**8.0.** abnormal
- db_table: meta_subject_bloodresultsglu
- column: glucose_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** reportable
- db_table: meta_subject_bloodresultsglu
- column: glucose_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**10.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsglu
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsglu
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**12.0.** summary
- db_table: meta_subject_bloodresultsglu
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Urine Pregnancy
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinepregnancy
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinepregnancy
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine pregnancy test performed?
- db_table: meta_subject_urinepregnancy
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinepregnancy
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Urine βhCG date
- db_table: meta_subject_urinepregnancy
- column: assay_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Urine βhCG result
- db_table: meta_subject_urinepregnancy
- column: bhcg_value
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---




*Rendered on 2022-06-24 14:17*

#### Health Economics (M3)
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_healtheconomicssimple
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_healtheconomicssimple
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Marital status
- db_table: meta_subject_healtheconomicssimple
- column: marital_status
- type: CharField
- length: 25
- responses:
  - `never_married`: *Never married*
  - `married`: *Currently married*
  - `separated`: *Separated*
  - `divorced`: *Divorced*
  - `widowed`: *Widow / Spinster*
---

**4.0.** What is your occupation/profession?
- db_table: meta_subject_healtheconomicssimple
- column: occupation
- type: CharField
- length: 50
- responses: *free text*
---

**Section: Education**

**5.0.** How many years of education did you complete?
- db_table: meta_subject_healtheconomicssimple
- column: education_in_years
- type: IntegerField
---

**6.0.** What is your highest education certificate?
- db_table: meta_subject_healtheconomicssimple
- column: education_certificate
- type: CharField
- length: 50
- responses:
  - `primary`: *Primary Certificate*
  - `secondary`: *Secondary Certificate*
  - `tertiary`: *post-Secondary/Tertiary/College*
  - `OTHER`: *Other, please specify ...*
  - `N/A`: *Not applicable, never went to school*
---

**6.1.** If other, please specify ...
- db_table: meta_subject_healtheconomicssimple
- column: education_certificate_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.0.** If your highest education certificate above is `Tertiary`, what type of tertiary certificate?
- db_table: meta_subject_healtheconomicssimple
- column: education_certificate_tertiary
- type: CharField
- length: 50
- responses: *free text*
---

**8.0.** Did you go to primary/elementary school?
- db_table: meta_subject_healtheconomicssimple
- column: primary_school
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**9.0.** If YES, for how many years
- db_table: meta_subject_healtheconomicssimple
- column: primary_school_in_years
- type: IntegerField
---

**10.0.** Did you go to secondary school?
- db_table: meta_subject_healtheconomicssimple
- column: secondary_school
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, for how many years
- db_table: meta_subject_healtheconomicssimple
- column: secondary_school_in_years
- type: IntegerField
---

**12.0.** Did you go to higher education?
- db_table: meta_subject_healtheconomicssimple
- column: higher_education
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** If YES, for how many years
- db_table: meta_subject_healtheconomicssimple
- column: higher_education_in_years
- type: IntegerField
---




*Rendered on 2022-06-24 14:17*

#### Michigan Neuropathy Screening Instrument (Mnsi)
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_mnsi
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_mnsi
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Is the MNSI assessment being performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If completion of patient history or physical assessment not possible, respond with `no` and provide reason below.*
- db_table: meta_subject_mnsi
- column: mnsi_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, please provide a reason
- db_table: meta_subject_mnsi
- column: mnsi_not_performed_reason
- type: TextField
- length: 200
---

**Section: Part 1: Patient History**

**5.0.** Are your legs and/or feet numb?
- db_table: meta_subject_mnsi
- column: numb_legs_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** Do you ever have any burning pain in your legs and/or feet?
- db_table: meta_subject_mnsi
- column: burning_pain_legs_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**7.0.** Are your feet too sensitive to touch?
- db_table: meta_subject_mnsi
- column: feet_sensitive_touch
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.0.** Do you get muscle cramps in your legs and/or feet?
- db_table: meta_subject_mnsi
- column: muscle_cramps_legs_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**9.0.** Do you ever have any prickling feelings in your legs or feet?
- db_table: meta_subject_mnsi
- column: prickling_feelings_legs_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**10.0.** Does it hurt when the bed covers touch your skin?
- db_table: meta_subject_mnsi
- column: covers_touch_skin_painful
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** When you get into the tub or shower, are you able to tell the hot water from the cold water?
- db_table: meta_subject_mnsi
- column: differentiate_hot_cold_water
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**12.0.** Have you ever had an open sore on your foot?
- db_table: meta_subject_mnsi
- column: open_sore_foot_history
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Has your doctor ever told you that you have diabetic neuropathy?
- db_table: meta_subject_mnsi
- column: diabetic_neuropathy
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** Do you feel weak all over most of the time?
- db_table: meta_subject_mnsi
- column: feel_weak
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** Are your symptoms worse at night?
- db_table: meta_subject_mnsi
- column: symptoms_worse_night
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**16.0.** Do your legs hurt when you walk?
- db_table: meta_subject_mnsi
- column: legs_hurt_when_walk
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**17.0.** Are you able to sense your feet when you walk?
- db_table: meta_subject_mnsi
- column: sense_feet_when_walk
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**18.0.** Is the skin on your feet so dry that it cracks open?
- db_table: meta_subject_mnsi
- column: skin_cracks_open_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**19.0.** Have you ever had an amputation?
- db_table: meta_subject_mnsi
- column: amputation
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Part 2a: Physical Assessment - Right Foot**

**20.0.** Does RIGHT foot appear normal?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: normal_appearance_right_foot
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `not_examined`: *Not examined*
---

**21.0.** If NO, check all that apply to RIGHT foot?
- db_table: meta_subject_mnsi
- column: abnormal_obs_right_foot
- type: ManyToManyField
- responses: *Select all that apply*
  - `callous_formation`: *Callous formation*
  - `deformity_amputation`: *Deformity – amputation*
  - `deformity_flat_feet`: *Deformity – flat feet*
  - `deformity_halux_valgus`: *Deformity – halux valgus*
  - `deformity_hammer_toes`: *Deformity – hammer toes*
  - `deformity_joint_subluxation`: *Deformity – joint subluxation*
  - `deformity_medial_convexity`: *Deformity – medial convexity (Charcot foot)*
  - `deformity_overlapping_toes`: *Deformity – overlapping toes*
  - `deformity_prominent_metatarsal_heads`: *Deformity – prominent metatarsal heads*
  - `dry_skin`: *Dry skin*
  - `infection`: *Infection*
  - `fissure`: *Fissure*
  - `OTHER`: *Other abnormality, please specify*
---

**21.1.** If other abnormality observed on RIGHT foot, please specify ...
- db_table: meta_subject_mnsi
- column: abnormal_obs_right_foot_other
- type: CharField
- length: 35
- responses: *free text*
---

**22.0.** Ulceration, RIGHT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: ulceration_right_foot
- type: CharField
- length: 35
- responses:
  - `absent`: *Absent*
  - `present`: *Present*
  - `not_examined`: *Not examined*
---

**23.0.** Ankle reflexes, RIGHT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: ankle_reflexes_right_foot
- type: CharField
- length: 35
- responses:
  - `present`: *Present*
  - `present_with_reinforcement`: *Present/Reinforcement*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**24.0.** Vibration perception at great toe, RIGHT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: vibration_perception_right_toe
- type: CharField
- length: 35
- responses:
  - `present`: *Present*
  - `decreased`: *Decreased*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**25.0.** Monofilament, RIGHT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: monofilament_right_foot
- type: CharField
- length: 35
- responses:
  - `NORMAL`: *Normal*
  - `reduced`: *Reduced*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**Section: Part 2b: Physical Assessment - Left Foot**

**26.0.** Does LEFT foot appear normal?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: normal_appearance_left_foot
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `not_examined`: *Not examined*
---

**27.0.** If NO, check all that apply to LEFT foot?
- db_table: meta_subject_mnsi
- column: abnormal_obs_left_foot
- type: ManyToManyField
- responses: *Select all that apply*
  - `callous_formation`: *Callous formation*
  - `deformity_amputation`: *Deformity – amputation*
  - `deformity_flat_feet`: *Deformity – flat feet*
  - `deformity_halux_valgus`: *Deformity – halux valgus*
  - `deformity_hammer_toes`: *Deformity – hammer toes*
  - `deformity_joint_subluxation`: *Deformity – joint subluxation*
  - `deformity_medial_convexity`: *Deformity – medial convexity (Charcot foot)*
  - `deformity_overlapping_toes`: *Deformity – overlapping toes*
  - `deformity_prominent_metatarsal_heads`: *Deformity – prominent metatarsal heads*
  - `dry_skin`: *Dry skin*
  - `infection`: *Infection*
  - `fissure`: *Fissure*
  - `OTHER`: *Other abnormality, please specify*
---

**27.1.** If other abnormality observed on LEFT foot, please specify ...
- db_table: meta_subject_mnsi
- column: abnormal_obs_left_foot_other
- type: CharField
- length: 35
- responses: *free text*
---

**28.0.** Ulceration, LEFT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: ulceration_left_foot
- type: CharField
- length: 35
- responses:
  - `absent`: *Absent*
  - `present`: *Present*
  - `not_examined`: *Not examined*
---

**29.0.** Ankle reflexes, LEFT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: ankle_reflexes_left_foot
- type: CharField
- length: 35
- responses:
  - `present`: *Present*
  - `present_with_reinforcement`: *Present/Reinforcement*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**30.0.** Vibration perception at great toe, LEFT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: vibration_perception_left_toe
- type: CharField
- length: 35
- responses:
  - `present`: *Present*
  - `decreased`: *Decreased*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**31.0.** Monofilament, LEFT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: monofilament_left_foot
- type: CharField
- length: 35
- responses:
  - `NORMAL`: *Normal*
  - `reduced`: *Reduced*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**Section: CRF status**

**32.0.** CRF status

&nbsp;&nbsp;&nbsp;&nbsp; *If some data is still pending, flag this CRF as incomplete*
- db_table: meta_subject_mnsi
- column: crf_status
- type: CharField
- length: 25
- responses:
  - `INCOMPLETE`: *Incomplete (some data pending)*
  - `COMPLETE`: *Complete*
---

**33.0.** Any comments related to status of this CRF

&nbsp;&nbsp;&nbsp;&nbsp; *for example, why some data is still pending*
- db_table: meta_subject_mnsi
- column: crf_status_comments
- type: TextField
---

**Section: Calculated values**

**34.0.** calculated patient history score
- db_table: meta_subject_mnsi
- column: calculated_patient_history_score
- type: IntegerField
---

**35.0.** calculated physical assessment score
- db_table: meta_subject_mnsi
- column: calculated_physical_assessment_score
- type: DecimalField
---


#### Requisitions

* blood_glucose

### 1030



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Glucose
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsglu
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsglu
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: blood_glucose**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsglu
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsglu
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**5.0.** Was this fasting or non-fasting?
- db_table: meta_subject_bloodresultsglu
- column: fasting
- type: CharField
- length: 25
- responses:
  - `fasting`: *Fasting*
  - `non_fasting`: *Non-fasting*
---

**Section: Glucose**

**6.0.** Blood Glucose
- db_table: meta_subject_bloodresultsglu
- column: glucose_value
- type: DecimalField
---

**7.0.** units
- db_table: meta_subject_bloodresultsglu
- column: glucose_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**8.0.** abnormal
- db_table: meta_subject_bloodresultsglu
- column: glucose_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** reportable
- db_table: meta_subject_bloodresultsglu
- column: glucose_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**10.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsglu
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsglu
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**12.0.** summary
- db_table: meta_subject_bloodresultsglu
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Rft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsrft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsrft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_rft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsrft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsrft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: UREA**

**5.0.** Urea (BUN)
- db_table: meta_subject_bloodresultsrft
- column: urea_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsrft
- column: urea_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: urea_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: urea_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: CREATININE**

**9.0.** Creatinine
- db_table: meta_subject_bloodresultsrft
- column: creatinine_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsrft
- column: creatinine_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `umol/L`: *μmol/L (micromoles/L)*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: creatinine_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: creatinine_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: URIC_ACID**

**13.0.** Uric Acid
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `mg/dL`: *mg/dL*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**17.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsrft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**18.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsrft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**19.0.** summary
- db_table: meta_subject_bloodresultsrft
- column: summary
- type: TextField
---

**Section: Calculated eGFR**

**20.0.** eGFR
- db_table: meta_subject_bloodresultsrft
- column: egfr_value
- type: DecimalField
---

**21.0.** units
- db_table: meta_subject_bloodresultsrft
- column: egfr_units
- type: CharField
- length: 15
- responses:
  - `mL/min/1.73m2`: *mL/min/1.73m2*
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Lft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultslft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultslft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_lft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultslft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultslft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: AST**

**5.0.** AST
- db_table: meta_subject_bloodresultslft
- column: ast_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultslft
- column: ast_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ast_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ast_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALT**

**9.0.** ALT
- db_table: meta_subject_bloodresultslft
- column: alt_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultslft
- column: alt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALP**

**13.0.** ALP
- db_table: meta_subject_bloodresultslft
- column: alp_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultslft
- column: alp_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alp_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alp_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: AMYLASE**

**17.0.** Serum Amylase
- db_table: meta_subject_bloodresultslft
- column: amylase_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultslft
- column: amylase_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: amylase_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: amylase_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: GGT**

**21.0.** GGT
- db_table: meta_subject_bloodresultslft
- column: ggt_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultslft
- column: ggt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ggt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ggt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALBUMIN**

**25.0.** Serum albumin
- db_table: meta_subject_bloodresultslft
- column: albumin_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultslft
- column: albumin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
  - `g/L`: *g/L*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: albumin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: albumin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**29.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultslft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**30.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultslft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**31.0.** summary
- db_table: meta_subject_bloodresultslft
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Urine Pregnancy
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinepregnancy
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinepregnancy
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine pregnancy test performed?
- db_table: meta_subject_urinepregnancy
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinepregnancy
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Urine βhCG date
- db_table: meta_subject_urinepregnancy
- column: assay_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Urine βhCG result
- db_table: meta_subject_urinepregnancy
- column: bhcg_value
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---




*Rendered on 2022-06-24 14:17*

#### Michigan Neuropathy Screening Instrument (Mnsi)
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_mnsi
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_mnsi
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Is the MNSI assessment being performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If completion of patient history or physical assessment not possible, respond with `no` and provide reason below.*
- db_table: meta_subject_mnsi
- column: mnsi_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, please provide a reason
- db_table: meta_subject_mnsi
- column: mnsi_not_performed_reason
- type: TextField
- length: 200
---

**Section: Part 1: Patient History**

**5.0.** Are your legs and/or feet numb?
- db_table: meta_subject_mnsi
- column: numb_legs_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** Do you ever have any burning pain in your legs and/or feet?
- db_table: meta_subject_mnsi
- column: burning_pain_legs_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**7.0.** Are your feet too sensitive to touch?
- db_table: meta_subject_mnsi
- column: feet_sensitive_touch
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.0.** Do you get muscle cramps in your legs and/or feet?
- db_table: meta_subject_mnsi
- column: muscle_cramps_legs_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**9.0.** Do you ever have any prickling feelings in your legs or feet?
- db_table: meta_subject_mnsi
- column: prickling_feelings_legs_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**10.0.** Does it hurt when the bed covers touch your skin?
- db_table: meta_subject_mnsi
- column: covers_touch_skin_painful
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** When you get into the tub or shower, are you able to tell the hot water from the cold water?
- db_table: meta_subject_mnsi
- column: differentiate_hot_cold_water
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**12.0.** Have you ever had an open sore on your foot?
- db_table: meta_subject_mnsi
- column: open_sore_foot_history
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Has your doctor ever told you that you have diabetic neuropathy?
- db_table: meta_subject_mnsi
- column: diabetic_neuropathy
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** Do you feel weak all over most of the time?
- db_table: meta_subject_mnsi
- column: feel_weak
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** Are your symptoms worse at night?
- db_table: meta_subject_mnsi
- column: symptoms_worse_night
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**16.0.** Do your legs hurt when you walk?
- db_table: meta_subject_mnsi
- column: legs_hurt_when_walk
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**17.0.** Are you able to sense your feet when you walk?
- db_table: meta_subject_mnsi
- column: sense_feet_when_walk
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**18.0.** Is the skin on your feet so dry that it cracks open?
- db_table: meta_subject_mnsi
- column: skin_cracks_open_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**19.0.** Have you ever had an amputation?
- db_table: meta_subject_mnsi
- column: amputation
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Part 2a: Physical Assessment - Right Foot**

**20.0.** Does RIGHT foot appear normal?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: normal_appearance_right_foot
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `not_examined`: *Not examined*
---

**21.0.** If NO, check all that apply to RIGHT foot?
- db_table: meta_subject_mnsi
- column: abnormal_obs_right_foot
- type: ManyToManyField
- responses: *Select all that apply*
  - `callous_formation`: *Callous formation*
  - `deformity_amputation`: *Deformity – amputation*
  - `deformity_flat_feet`: *Deformity – flat feet*
  - `deformity_halux_valgus`: *Deformity – halux valgus*
  - `deformity_hammer_toes`: *Deformity – hammer toes*
  - `deformity_joint_subluxation`: *Deformity – joint subluxation*
  - `deformity_medial_convexity`: *Deformity – medial convexity (Charcot foot)*
  - `deformity_overlapping_toes`: *Deformity – overlapping toes*
  - `deformity_prominent_metatarsal_heads`: *Deformity – prominent metatarsal heads*
  - `dry_skin`: *Dry skin*
  - `infection`: *Infection*
  - `fissure`: *Fissure*
  - `OTHER`: *Other abnormality, please specify*
---

**21.1.** If other abnormality observed on RIGHT foot, please specify ...
- db_table: meta_subject_mnsi
- column: abnormal_obs_right_foot_other
- type: CharField
- length: 35
- responses: *free text*
---

**22.0.** Ulceration, RIGHT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: ulceration_right_foot
- type: CharField
- length: 35
- responses:
  - `absent`: *Absent*
  - `present`: *Present*
  - `not_examined`: *Not examined*
---

**23.0.** Ankle reflexes, RIGHT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: ankle_reflexes_right_foot
- type: CharField
- length: 35
- responses:
  - `present`: *Present*
  - `present_with_reinforcement`: *Present/Reinforcement*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**24.0.** Vibration perception at great toe, RIGHT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: vibration_perception_right_toe
- type: CharField
- length: 35
- responses:
  - `present`: *Present*
  - `decreased`: *Decreased*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**25.0.** Monofilament, RIGHT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: monofilament_right_foot
- type: CharField
- length: 35
- responses:
  - `NORMAL`: *Normal*
  - `reduced`: *Reduced*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**Section: Part 2b: Physical Assessment - Left Foot**

**26.0.** Does LEFT foot appear normal?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: normal_appearance_left_foot
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `not_examined`: *Not examined*
---

**27.0.** If NO, check all that apply to LEFT foot?
- db_table: meta_subject_mnsi
- column: abnormal_obs_left_foot
- type: ManyToManyField
- responses: *Select all that apply*
  - `callous_formation`: *Callous formation*
  - `deformity_amputation`: *Deformity – amputation*
  - `deformity_flat_feet`: *Deformity – flat feet*
  - `deformity_halux_valgus`: *Deformity – halux valgus*
  - `deformity_hammer_toes`: *Deformity – hammer toes*
  - `deformity_joint_subluxation`: *Deformity – joint subluxation*
  - `deformity_medial_convexity`: *Deformity – medial convexity (Charcot foot)*
  - `deformity_overlapping_toes`: *Deformity – overlapping toes*
  - `deformity_prominent_metatarsal_heads`: *Deformity – prominent metatarsal heads*
  - `dry_skin`: *Dry skin*
  - `infection`: *Infection*
  - `fissure`: *Fissure*
  - `OTHER`: *Other abnormality, please specify*
---

**27.1.** If other abnormality observed on LEFT foot, please specify ...
- db_table: meta_subject_mnsi
- column: abnormal_obs_left_foot_other
- type: CharField
- length: 35
- responses: *free text*
---

**28.0.** Ulceration, LEFT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: ulceration_left_foot
- type: CharField
- length: 35
- responses:
  - `absent`: *Absent*
  - `present`: *Present*
  - `not_examined`: *Not examined*
---

**29.0.** Ankle reflexes, LEFT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: ankle_reflexes_left_foot
- type: CharField
- length: 35
- responses:
  - `present`: *Present*
  - `present_with_reinforcement`: *Present/Reinforcement*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**30.0.** Vibration perception at great toe, LEFT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: vibration_perception_left_toe
- type: CharField
- length: 35
- responses:
  - `present`: *Present*
  - `decreased`: *Decreased*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**31.0.** Monofilament, LEFT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: monofilament_left_foot
- type: CharField
- length: 35
- responses:
  - `NORMAL`: *Normal*
  - `reduced`: *Reduced*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**Section: CRF status**

**32.0.** CRF status

&nbsp;&nbsp;&nbsp;&nbsp; *If some data is still pending, flag this CRF as incomplete*
- db_table: meta_subject_mnsi
- column: crf_status
- type: CharField
- length: 25
- responses:
  - `INCOMPLETE`: *Incomplete (some data pending)*
  - `COMPLETE`: *Complete*
---

**33.0.** Any comments related to status of this CRF

&nbsp;&nbsp;&nbsp;&nbsp; *for example, why some data is still pending*
- db_table: meta_subject_mnsi
- column: crf_status_comments
- type: TextField
---

**Section: Calculated values**

**34.0.** calculated patient history score
- db_table: meta_subject_mnsi
- column: calculated_patient_history_score
- type: IntegerField
---

**35.0.** calculated physical assessment score
- db_table: meta_subject_mnsi
- column: calculated_physical_assessment_score
- type: DecimalField
---


#### Requisitions

* blood_glucose

* chemistry_rft

* chemistry_lft

### 1060



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Glucose
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsglu
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsglu
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: blood_glucose**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsglu
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsglu
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**5.0.** Was this fasting or non-fasting?
- db_table: meta_subject_bloodresultsglu
- column: fasting
- type: CharField
- length: 25
- responses:
  - `fasting`: *Fasting*
  - `non_fasting`: *Non-fasting*
---

**Section: Glucose**

**6.0.** Blood Glucose
- db_table: meta_subject_bloodresultsglu
- column: glucose_value
- type: DecimalField
---

**7.0.** units
- db_table: meta_subject_bloodresultsglu
- column: glucose_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**8.0.** abnormal
- db_table: meta_subject_bloodresultsglu
- column: glucose_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** reportable
- db_table: meta_subject_bloodresultsglu
- column: glucose_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**10.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsglu
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsglu
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**12.0.** summary
- db_table: meta_subject_bloodresultsglu
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Rft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsrft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsrft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_rft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsrft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsrft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: UREA**

**5.0.** Urea (BUN)
- db_table: meta_subject_bloodresultsrft
- column: urea_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsrft
- column: urea_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: urea_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: urea_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: CREATININE**

**9.0.** Creatinine
- db_table: meta_subject_bloodresultsrft
- column: creatinine_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsrft
- column: creatinine_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `umol/L`: *μmol/L (micromoles/L)*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: creatinine_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: creatinine_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: URIC_ACID**

**13.0.** Uric Acid
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `mg/dL`: *mg/dL*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**17.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsrft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**18.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsrft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**19.0.** summary
- db_table: meta_subject_bloodresultsrft
- column: summary
- type: TextField
---

**Section: Calculated eGFR**

**20.0.** eGFR
- db_table: meta_subject_bloodresultsrft
- column: egfr_value
- type: DecimalField
---

**21.0.** units
- db_table: meta_subject_bloodresultsrft
- column: egfr_units
- type: CharField
- length: 15
- responses:
  - `mL/min/1.73m2`: *mL/min/1.73m2*
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Lft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultslft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultslft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_lft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultslft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultslft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: AST**

**5.0.** AST
- db_table: meta_subject_bloodresultslft
- column: ast_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultslft
- column: ast_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ast_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ast_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALT**

**9.0.** ALT
- db_table: meta_subject_bloodresultslft
- column: alt_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultslft
- column: alt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALP**

**13.0.** ALP
- db_table: meta_subject_bloodresultslft
- column: alp_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultslft
- column: alp_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alp_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alp_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: AMYLASE**

**17.0.** Serum Amylase
- db_table: meta_subject_bloodresultslft
- column: amylase_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultslft
- column: amylase_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: amylase_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: amylase_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: GGT**

**21.0.** GGT
- db_table: meta_subject_bloodresultslft
- column: ggt_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultslft
- column: ggt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ggt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ggt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALBUMIN**

**25.0.** Serum albumin
- db_table: meta_subject_bloodresultslft
- column: albumin_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultslft
- column: albumin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
  - `g/L`: *g/L*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: albumin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: albumin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**29.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultslft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**30.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultslft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**31.0.** summary
- db_table: meta_subject_bloodresultslft
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Fbc
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsfbc
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsfbc
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: fbc**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsfbc
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsfbc
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Haemoglobin**

**5.0.** Haemoglobin
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: HCT**

**9.0.** Hematocrit
- db_table: meta_subject_bloodresultsfbc
- column: hct_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: hct_units
- type: CharField
- length: 15
- responses:
  - `%`: *%*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: hct_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: hct_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: RBC**

**13.0.** Red blood cell count
- db_table: meta_subject_bloodresultsfbc
- column: rbc_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: rbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm^3*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: rbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: rbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: WBC**

**17.0.** WBC
- db_table: meta_subject_bloodresultsfbc
- column: wbc_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: wbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: wbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: wbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: PLATELETS**

**21.0.** Platelets
- db_table: meta_subject_bloodresultsfbc
- column: platelets_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: platelets_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: platelets_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: platelets_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCV**

**25.0.** MCV
- db_table: meta_subject_bloodresultsfbc
- column: mcv_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mcv_units
- type: CharField
- length: 15
- responses:
  - `fL/cell`: *fL/cell*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mcv_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mcv_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCH**

**29.0.** MCH
- db_table: meta_subject_bloodresultsfbc
- column: mch_value
- type: DecimalField
---

**30.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mch_units
- type: CharField
- length: 15
- responses:
  - `pg/cell`: *pg/cell*
---

**31.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mch_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**32.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mch_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCHC**

**33.0.** MCHC
- db_table: meta_subject_bloodresultsfbc
- column: mchc_value
- type: DecimalField
---

**34.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mchc_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**35.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mchc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**36.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mchc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**37.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsfbc
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**38.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsfbc
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**39.0.** summary
- db_table: meta_subject_bloodresultsfbc
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Urine Pregnancy
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinepregnancy
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinepregnancy
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine pregnancy test performed?
- db_table: meta_subject_urinepregnancy
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinepregnancy
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Urine βhCG date
- db_table: meta_subject_urinepregnancy
- column: assay_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Urine βhCG result
- db_table: meta_subject_urinepregnancy
- column: bhcg_value
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---




*Rendered on 2022-06-24 14:17*

#### Michigan Neuropathy Screening Instrument (Mnsi)
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_mnsi
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_mnsi
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Is the MNSI assessment being performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If completion of patient history or physical assessment not possible, respond with `no` and provide reason below.*
- db_table: meta_subject_mnsi
- column: mnsi_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, please provide a reason
- db_table: meta_subject_mnsi
- column: mnsi_not_performed_reason
- type: TextField
- length: 200
---

**Section: Part 1: Patient History**

**5.0.** Are your legs and/or feet numb?
- db_table: meta_subject_mnsi
- column: numb_legs_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** Do you ever have any burning pain in your legs and/or feet?
- db_table: meta_subject_mnsi
- column: burning_pain_legs_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**7.0.** Are your feet too sensitive to touch?
- db_table: meta_subject_mnsi
- column: feet_sensitive_touch
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.0.** Do you get muscle cramps in your legs and/or feet?
- db_table: meta_subject_mnsi
- column: muscle_cramps_legs_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**9.0.** Do you ever have any prickling feelings in your legs or feet?
- db_table: meta_subject_mnsi
- column: prickling_feelings_legs_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**10.0.** Does it hurt when the bed covers touch your skin?
- db_table: meta_subject_mnsi
- column: covers_touch_skin_painful
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** When you get into the tub or shower, are you able to tell the hot water from the cold water?
- db_table: meta_subject_mnsi
- column: differentiate_hot_cold_water
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**12.0.** Have you ever had an open sore on your foot?
- db_table: meta_subject_mnsi
- column: open_sore_foot_history
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Has your doctor ever told you that you have diabetic neuropathy?
- db_table: meta_subject_mnsi
- column: diabetic_neuropathy
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** Do you feel weak all over most of the time?
- db_table: meta_subject_mnsi
- column: feel_weak
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** Are your symptoms worse at night?
- db_table: meta_subject_mnsi
- column: symptoms_worse_night
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**16.0.** Do your legs hurt when you walk?
- db_table: meta_subject_mnsi
- column: legs_hurt_when_walk
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**17.0.** Are you able to sense your feet when you walk?
- db_table: meta_subject_mnsi
- column: sense_feet_when_walk
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**18.0.** Is the skin on your feet so dry that it cracks open?
- db_table: meta_subject_mnsi
- column: skin_cracks_open_feet
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**19.0.** Have you ever had an amputation?
- db_table: meta_subject_mnsi
- column: amputation
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Part 2a: Physical Assessment - Right Foot**

**20.0.** Does RIGHT foot appear normal?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: normal_appearance_right_foot
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `not_examined`: *Not examined*
---

**21.0.** If NO, check all that apply to RIGHT foot?
- db_table: meta_subject_mnsi
- column: abnormal_obs_right_foot
- type: ManyToManyField
- responses: *Select all that apply*
  - `callous_formation`: *Callous formation*
  - `deformity_amputation`: *Deformity – amputation*
  - `deformity_flat_feet`: *Deformity – flat feet*
  - `deformity_halux_valgus`: *Deformity – halux valgus*
  - `deformity_hammer_toes`: *Deformity – hammer toes*
  - `deformity_joint_subluxation`: *Deformity – joint subluxation*
  - `deformity_medial_convexity`: *Deformity – medial convexity (Charcot foot)*
  - `deformity_overlapping_toes`: *Deformity – overlapping toes*
  - `deformity_prominent_metatarsal_heads`: *Deformity – prominent metatarsal heads*
  - `dry_skin`: *Dry skin*
  - `infection`: *Infection*
  - `fissure`: *Fissure*
  - `OTHER`: *Other abnormality, please specify*
---

**21.1.** If other abnormality observed on RIGHT foot, please specify ...
- db_table: meta_subject_mnsi
- column: abnormal_obs_right_foot_other
- type: CharField
- length: 35
- responses: *free text*
---

**22.0.** Ulceration, RIGHT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: ulceration_right_foot
- type: CharField
- length: 35
- responses:
  - `absent`: *Absent*
  - `present`: *Present*
  - `not_examined`: *Not examined*
---

**23.0.** Ankle reflexes, RIGHT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: ankle_reflexes_right_foot
- type: CharField
- length: 35
- responses:
  - `present`: *Present*
  - `present_with_reinforcement`: *Present/Reinforcement*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**24.0.** Vibration perception at great toe, RIGHT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: vibration_perception_right_toe
- type: CharField
- length: 35
- responses:
  - `present`: *Present*
  - `decreased`: *Decreased*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**25.0.** Monofilament, RIGHT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: monofilament_right_foot
- type: CharField
- length: 35
- responses:
  - `NORMAL`: *Normal*
  - `reduced`: *Reduced*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**Section: Part 2b: Physical Assessment - Left Foot**

**26.0.** Does LEFT foot appear normal?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: normal_appearance_left_foot
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `not_examined`: *Not examined*
---

**27.0.** If NO, check all that apply to LEFT foot?
- db_table: meta_subject_mnsi
- column: abnormal_obs_left_foot
- type: ManyToManyField
- responses: *Select all that apply*
  - `callous_formation`: *Callous formation*
  - `deformity_amputation`: *Deformity – amputation*
  - `deformity_flat_feet`: *Deformity – flat feet*
  - `deformity_halux_valgus`: *Deformity – halux valgus*
  - `deformity_hammer_toes`: *Deformity – hammer toes*
  - `deformity_joint_subluxation`: *Deformity – joint subluxation*
  - `deformity_medial_convexity`: *Deformity – medial convexity (Charcot foot)*
  - `deformity_overlapping_toes`: *Deformity – overlapping toes*
  - `deformity_prominent_metatarsal_heads`: *Deformity – prominent metatarsal heads*
  - `dry_skin`: *Dry skin*
  - `infection`: *Infection*
  - `fissure`: *Fissure*
  - `OTHER`: *Other abnormality, please specify*
---

**27.1.** If other abnormality observed on LEFT foot, please specify ...
- db_table: meta_subject_mnsi
- column: abnormal_obs_left_foot_other
- type: CharField
- length: 35
- responses: *free text*
---

**28.0.** Ulceration, LEFT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: ulceration_left_foot
- type: CharField
- length: 35
- responses:
  - `absent`: *Absent*
  - `present`: *Present*
  - `not_examined`: *Not examined*
---

**29.0.** Ankle reflexes, LEFT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: ankle_reflexes_left_foot
- type: CharField
- length: 35
- responses:
  - `present`: *Present*
  - `present_with_reinforcement`: *Present/Reinforcement*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**30.0.** Vibration perception at great toe, LEFT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: vibration_perception_left_toe
- type: CharField
- length: 35
- responses:
  - `present`: *Present*
  - `decreased`: *Decreased*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**31.0.** Monofilament, LEFT foot?

&nbsp;&nbsp;&nbsp;&nbsp; *If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.*
- db_table: meta_subject_mnsi
- column: monofilament_left_foot
- type: CharField
- length: 35
- responses:
  - `NORMAL`: *Normal*
  - `reduced`: *Reduced*
  - `absent`: *Absent*
  - `not_examined`: *Not examined*
---

**Section: CRF status**

**32.0.** CRF status

&nbsp;&nbsp;&nbsp;&nbsp; *If some data is still pending, flag this CRF as incomplete*
- db_table: meta_subject_mnsi
- column: crf_status
- type: CharField
- length: 25
- responses:
  - `INCOMPLETE`: *Incomplete (some data pending)*
  - `COMPLETE`: *Complete*
---

**33.0.** Any comments related to status of this CRF

&nbsp;&nbsp;&nbsp;&nbsp; *for example, why some data is still pending*
- db_table: meta_subject_mnsi
- column: crf_status_comments
- type: TextField
---

**Section: Calculated values**

**34.0.** calculated patient history score
- db_table: meta_subject_mnsi
- column: calculated_patient_history_score
- type: IntegerField
---

**35.0.** calculated physical assessment score
- db_table: meta_subject_mnsi
- column: calculated_physical_assessment_score
- type: DecimalField
---


#### Requisitions

* blood_glucose

* chemistry_rft

* chemistry_lft

### 1090



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Glucose
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsglu
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsglu
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: blood_glucose**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsglu
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsglu
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**5.0.** Was this fasting or non-fasting?
- db_table: meta_subject_bloodresultsglu
- column: fasting
- type: CharField
- length: 25
- responses:
  - `fasting`: *Fasting*
  - `non_fasting`: *Non-fasting*
---

**Section: Glucose**

**6.0.** Blood Glucose
- db_table: meta_subject_bloodresultsglu
- column: glucose_value
- type: DecimalField
---

**7.0.** units
- db_table: meta_subject_bloodresultsglu
- column: glucose_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**8.0.** abnormal
- db_table: meta_subject_bloodresultsglu
- column: glucose_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** reportable
- db_table: meta_subject_bloodresultsglu
- column: glucose_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**10.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsglu
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsglu
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**12.0.** summary
- db_table: meta_subject_bloodresultsglu
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Urine Pregnancy
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinepregnancy
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinepregnancy
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine pregnancy test performed?
- db_table: meta_subject_urinepregnancy
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinepregnancy
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Urine βhCG date
- db_table: meta_subject_urinepregnancy
- column: assay_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Urine βhCG result
- db_table: meta_subject_urinepregnancy
- column: bhcg_value
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---


#### Requisitions

* blood_glucose

### 1120



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Glucose (Ifg, Ogtt)
A user model to capture IFG and OGTT
*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_glucose
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_glucose
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**3.0.** Has the participant fasted?

&nbsp;&nbsp;&nbsp;&nbsp; *As reported by patient*
- db_table: meta_subject_glucose
- column: fasting
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** How long have they fasted in hours and/or minutes?

&nbsp;&nbsp;&nbsp;&nbsp; *As reported by patient. Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc*
- db_table: meta_subject_glucose
- column: fasting_duration_str
- type: CharField
- length: 8
- responses: *free text*
---

**Section: FBG**

**5.0.** Was the IFG test performed?
- db_table: meta_subject_glucose
- column: fbg_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** If NO, provide reason
- db_table: meta_subject_glucose
- column: fbg_not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**7.0.** <u>Time</u> FBG level measured
- db_table: meta_subject_glucose
- column: fbg_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**8.0.** FBG level

&nbsp;&nbsp;&nbsp;&nbsp; *A `HIGH` reading may be entered as 9999.99*
- db_table: meta_subject_glucose
- column: fbg_value
- type: DecimalField
---

**9.0.** FBG units
- db_table: meta_subject_glucose
- column: fbg_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `N/A`: *Not applicable*
---

**Section: OGTT**

**10.0.** Was the OGTT test performed?
- db_table: meta_subject_glucose
- column: ogtt_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If NO, provide reason
- db_table: meta_subject_glucose
- column: ogtt_not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**12.0.** <u>Time</u> oral glucose solution was given

&nbsp;&nbsp;&nbsp;&nbsp; *(glucose solution given)*
- db_table: meta_subject_glucose
- column: ogtt_base_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**13.0.** <u>Time</u> blood glucose measured 2-hours after oral glucose solution given

&nbsp;&nbsp;&nbsp;&nbsp; *(2 hours after glucose solution given)*
- db_table: meta_subject_glucose
- column: ogtt_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**14.0.** Blood glucose <u>level</u> 2-hours after oral glucose solution given

&nbsp;&nbsp;&nbsp;&nbsp; *A `HIGH` reading may be entered as 9999.99*
- db_table: meta_subject_glucose
- column: ogtt_value
- type: DecimalField
---

**15.0.** Units (Blood glucose 2hrs after...)
- db_table: meta_subject_glucose
- column: ogtt_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `N/A`: *Not applicable*
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Hba1C
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultshba1c
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultshba1c
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: hba1c**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultshba1c
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultshba1c
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: HbA1c**

**5.0.** HbA1c value
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_units
- type: CharField
- length: 15
- responses: *free text*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**9.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultshba1c
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultshba1c
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**11.0.** summary
- db_table: meta_subject_bloodresultshba1c
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Rft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsrft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsrft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_rft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsrft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsrft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: UREA**

**5.0.** Urea (BUN)
- db_table: meta_subject_bloodresultsrft
- column: urea_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsrft
- column: urea_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: urea_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: urea_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: CREATININE**

**9.0.** Creatinine
- db_table: meta_subject_bloodresultsrft
- column: creatinine_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsrft
- column: creatinine_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `umol/L`: *μmol/L (micromoles/L)*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: creatinine_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: creatinine_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: URIC_ACID**

**13.0.** Uric Acid
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `mg/dL`: *mg/dL*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**17.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsrft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**18.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsrft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**19.0.** summary
- db_table: meta_subject_bloodresultsrft
- column: summary
- type: TextField
---

**Section: Calculated eGFR**

**20.0.** eGFR
- db_table: meta_subject_bloodresultsrft
- column: egfr_value
- type: DecimalField
---

**21.0.** units
- db_table: meta_subject_bloodresultsrft
- column: egfr_units
- type: CharField
- length: 15
- responses:
  - `mL/min/1.73m2`: *mL/min/1.73m2*
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Lft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultslft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultslft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_lft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultslft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultslft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: AST**

**5.0.** AST
- db_table: meta_subject_bloodresultslft
- column: ast_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultslft
- column: ast_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ast_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ast_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALT**

**9.0.** ALT
- db_table: meta_subject_bloodresultslft
- column: alt_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultslft
- column: alt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALP**

**13.0.** ALP
- db_table: meta_subject_bloodresultslft
- column: alp_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultslft
- column: alp_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alp_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alp_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: AMYLASE**

**17.0.** Serum Amylase
- db_table: meta_subject_bloodresultslft
- column: amylase_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultslft
- column: amylase_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: amylase_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: amylase_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: GGT**

**21.0.** GGT
- db_table: meta_subject_bloodresultslft
- column: ggt_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultslft
- column: ggt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ggt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ggt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALBUMIN**

**25.0.** Serum albumin
- db_table: meta_subject_bloodresultslft
- column: albumin_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultslft
- column: albumin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
  - `g/L`: *g/L*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: albumin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: albumin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**29.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultslft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**30.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultslft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**31.0.** summary
- db_table: meta_subject_bloodresultslft
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Fbc
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsfbc
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsfbc
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: fbc**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsfbc
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsfbc
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Haemoglobin**

**5.0.** Haemoglobin
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: HCT**

**9.0.** Hematocrit
- db_table: meta_subject_bloodresultsfbc
- column: hct_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: hct_units
- type: CharField
- length: 15
- responses:
  - `%`: *%*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: hct_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: hct_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: RBC**

**13.0.** Red blood cell count
- db_table: meta_subject_bloodresultsfbc
- column: rbc_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: rbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm^3*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: rbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: rbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: WBC**

**17.0.** WBC
- db_table: meta_subject_bloodresultsfbc
- column: wbc_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: wbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: wbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: wbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: PLATELETS**

**21.0.** Platelets
- db_table: meta_subject_bloodresultsfbc
- column: platelets_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: platelets_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: platelets_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: platelets_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCV**

**25.0.** MCV
- db_table: meta_subject_bloodresultsfbc
- column: mcv_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mcv_units
- type: CharField
- length: 15
- responses:
  - `fL/cell`: *fL/cell*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mcv_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mcv_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCH**

**29.0.** MCH
- db_table: meta_subject_bloodresultsfbc
- column: mch_value
- type: DecimalField
---

**30.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mch_units
- type: CharField
- length: 15
- responses:
  - `pg/cell`: *pg/cell*
---

**31.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mch_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**32.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mch_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCHC**

**33.0.** MCHC
- db_table: meta_subject_bloodresultsfbc
- column: mchc_value
- type: DecimalField
---

**34.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mchc_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**35.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mchc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**36.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mchc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**37.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsfbc
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**38.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsfbc
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**39.0.** summary
- db_table: meta_subject_bloodresultsfbc
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Lipids
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultslipid
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultslipid
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_lipids**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultslipid
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultslipid
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: LDL**

**5.0.** LDL
- db_table: meta_subject_bloodresultslipid
- column: ldl_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultslipid
- column: ldl_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: ldl_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: ldl_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: HDL**

**9.0.** HDL
- db_table: meta_subject_bloodresultslipid
- column: hdl_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultslipid
- column: hdl_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: hdl_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: hdl_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: TRIG**

**13.0.** Triglycerides
- db_table: meta_subject_bloodresultslipid
- column: trig_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultslipid
- column: trig_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: trig_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: trig_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: CHOL**

**17.0.** Total Cholesterol
- db_table: meta_subject_bloodresultslipid
- column: chol_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultslipid
- column: chol_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: chol_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: chol_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**21.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultslipid
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**22.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultslipid
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**23.0.** summary
- db_table: meta_subject_bloodresultslipid
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Urine Pregnancy
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinepregnancy
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinepregnancy
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine pregnancy test performed?
- db_table: meta_subject_urinepregnancy
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinepregnancy
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Urine βhCG date
- db_table: meta_subject_urinepregnancy
- column: assay_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Urine βhCG result
- db_table: meta_subject_urinepregnancy
- column: bhcg_value
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---


#### Requisitions

* blood_glucose

* chemistry_rft

* chemistry_lft

* chemistry_lipids

* fbc

### 1150



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Glucose
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsglu
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsglu
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: blood_glucose**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsglu
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsglu
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**5.0.** Was this fasting or non-fasting?
- db_table: meta_subject_bloodresultsglu
- column: fasting
- type: CharField
- length: 25
- responses:
  - `fasting`: *Fasting*
  - `non_fasting`: *Non-fasting*
---

**Section: Glucose**

**6.0.** Blood Glucose
- db_table: meta_subject_bloodresultsglu
- column: glucose_value
- type: DecimalField
---

**7.0.** units
- db_table: meta_subject_bloodresultsglu
- column: glucose_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**8.0.** abnormal
- db_table: meta_subject_bloodresultsglu
- column: glucose_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** reportable
- db_table: meta_subject_bloodresultsglu
- column: glucose_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**10.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsglu
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsglu
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**12.0.** summary
- db_table: meta_subject_bloodresultsglu
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Urine Pregnancy
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinepregnancy
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinepregnancy
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine pregnancy test performed?
- db_table: meta_subject_urinepregnancy
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinepregnancy
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Urine βhCG date
- db_table: meta_subject_urinepregnancy
- column: assay_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Urine βhCG result
- db_table: meta_subject_urinepregnancy
- column: bhcg_value
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---


#### Requisitions

* blood_glucose

### 1180



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Glucose
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsglu
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsglu
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: blood_glucose**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsglu
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsglu
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**5.0.** Was this fasting or non-fasting?
- db_table: meta_subject_bloodresultsglu
- column: fasting
- type: CharField
- length: 25
- responses:
  - `fasting`: *Fasting*
  - `non_fasting`: *Non-fasting*
---

**Section: Glucose**

**6.0.** Blood Glucose
- db_table: meta_subject_bloodresultsglu
- column: glucose_value
- type: DecimalField
---

**7.0.** units
- db_table: meta_subject_bloodresultsglu
- column: glucose_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**8.0.** abnormal
- db_table: meta_subject_bloodresultsglu
- column: glucose_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** reportable
- db_table: meta_subject_bloodresultsglu
- column: glucose_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**10.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsglu
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsglu
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**12.0.** summary
- db_table: meta_subject_bloodresultsglu
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Fbc
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsfbc
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsfbc
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: fbc**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsfbc
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsfbc
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Haemoglobin**

**5.0.** Haemoglobin
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: HCT**

**9.0.** Hematocrit
- db_table: meta_subject_bloodresultsfbc
- column: hct_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: hct_units
- type: CharField
- length: 15
- responses:
  - `%`: *%*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: hct_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: hct_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: RBC**

**13.0.** Red blood cell count
- db_table: meta_subject_bloodresultsfbc
- column: rbc_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: rbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm^3*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: rbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: rbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: WBC**

**17.0.** WBC
- db_table: meta_subject_bloodresultsfbc
- column: wbc_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: wbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: wbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: wbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: PLATELETS**

**21.0.** Platelets
- db_table: meta_subject_bloodresultsfbc
- column: platelets_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: platelets_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: platelets_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: platelets_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCV**

**25.0.** MCV
- db_table: meta_subject_bloodresultsfbc
- column: mcv_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mcv_units
- type: CharField
- length: 15
- responses:
  - `fL/cell`: *fL/cell*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mcv_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mcv_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCH**

**29.0.** MCH
- db_table: meta_subject_bloodresultsfbc
- column: mch_value
- type: DecimalField
---

**30.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mch_units
- type: CharField
- length: 15
- responses:
  - `pg/cell`: *pg/cell*
---

**31.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mch_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**32.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mch_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCHC**

**33.0.** MCHC
- db_table: meta_subject_bloodresultsfbc
- column: mchc_value
- type: DecimalField
---

**34.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mchc_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**35.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mchc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**36.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mchc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**37.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsfbc
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**38.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsfbc
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**39.0.** summary
- db_table: meta_subject_bloodresultsfbc
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Urine Pregnancy
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinepregnancy
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinepregnancy
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine pregnancy test performed?
- db_table: meta_subject_urinepregnancy
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinepregnancy
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Urine βhCG date
- db_table: meta_subject_urinepregnancy
- column: assay_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Urine βhCG result
- db_table: meta_subject_urinepregnancy
- column: bhcg_value
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---


#### Requisitions

* blood_glucose

* fbc

### 1210



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Glucose
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsglu
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsglu
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: blood_glucose**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsglu
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsglu
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**5.0.** Was this fasting or non-fasting?
- db_table: meta_subject_bloodresultsglu
- column: fasting
- type: CharField
- length: 25
- responses:
  - `fasting`: *Fasting*
  - `non_fasting`: *Non-fasting*
---

**Section: Glucose**

**6.0.** Blood Glucose
- db_table: meta_subject_bloodresultsglu
- column: glucose_value
- type: DecimalField
---

**7.0.** units
- db_table: meta_subject_bloodresultsglu
- column: glucose_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**8.0.** abnormal
- db_table: meta_subject_bloodresultsglu
- column: glucose_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** reportable
- db_table: meta_subject_bloodresultsglu
- column: glucose_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**10.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsglu
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsglu
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**12.0.** summary
- db_table: meta_subject_bloodresultsglu
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Urine Pregnancy
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinepregnancy
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinepregnancy
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine pregnancy test performed?
- db_table: meta_subject_urinepregnancy
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinepregnancy
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Urine βhCG date
- db_table: meta_subject_urinepregnancy
- column: assay_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Urine βhCG result
- db_table: meta_subject_urinepregnancy
- column: bhcg_value
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---


#### Requisitions

* blood_glucose

### 1240



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Glucose (Ifg, Ogtt)
A user model to capture IFG and OGTT
*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_glucose
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_glucose
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**3.0.** Has the participant fasted?

&nbsp;&nbsp;&nbsp;&nbsp; *As reported by patient*
- db_table: meta_subject_glucose
- column: fasting
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** How long have they fasted in hours and/or minutes?

&nbsp;&nbsp;&nbsp;&nbsp; *As reported by patient. Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc*
- db_table: meta_subject_glucose
- column: fasting_duration_str
- type: CharField
- length: 8
- responses: *free text*
---

**Section: FBG**

**5.0.** Was the IFG test performed?
- db_table: meta_subject_glucose
- column: fbg_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** If NO, provide reason
- db_table: meta_subject_glucose
- column: fbg_not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**7.0.** <u>Time</u> FBG level measured
- db_table: meta_subject_glucose
- column: fbg_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**8.0.** FBG level

&nbsp;&nbsp;&nbsp;&nbsp; *A `HIGH` reading may be entered as 9999.99*
- db_table: meta_subject_glucose
- column: fbg_value
- type: DecimalField
---

**9.0.** FBG units
- db_table: meta_subject_glucose
- column: fbg_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `N/A`: *Not applicable*
---

**Section: OGTT**

**10.0.** Was the OGTT test performed?
- db_table: meta_subject_glucose
- column: ogtt_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If NO, provide reason
- db_table: meta_subject_glucose
- column: ogtt_not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**12.0.** <u>Time</u> oral glucose solution was given

&nbsp;&nbsp;&nbsp;&nbsp; *(glucose solution given)*
- db_table: meta_subject_glucose
- column: ogtt_base_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**13.0.** <u>Time</u> blood glucose measured 2-hours after oral glucose solution given

&nbsp;&nbsp;&nbsp;&nbsp; *(2 hours after glucose solution given)*
- db_table: meta_subject_glucose
- column: ogtt_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**14.0.** Blood glucose <u>level</u> 2-hours after oral glucose solution given

&nbsp;&nbsp;&nbsp;&nbsp; *A `HIGH` reading may be entered as 9999.99*
- db_table: meta_subject_glucose
- column: ogtt_value
- type: DecimalField
---

**15.0.** Units (Blood glucose 2hrs after...)
- db_table: meta_subject_glucose
- column: ogtt_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `N/A`: *Not applicable*
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Hba1C
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultshba1c
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultshba1c
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: hba1c**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultshba1c
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultshba1c
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: HbA1c**

**5.0.** HbA1c value
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_units
- type: CharField
- length: 15
- responses: *free text*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**9.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultshba1c
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultshba1c
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**11.0.** summary
- db_table: meta_subject_bloodresultshba1c
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Rft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsrft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsrft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_rft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsrft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsrft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: UREA**

**5.0.** Urea (BUN)
- db_table: meta_subject_bloodresultsrft
- column: urea_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsrft
- column: urea_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: urea_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: urea_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: CREATININE**

**9.0.** Creatinine
- db_table: meta_subject_bloodresultsrft
- column: creatinine_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsrft
- column: creatinine_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `umol/L`: *μmol/L (micromoles/L)*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: creatinine_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: creatinine_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: URIC_ACID**

**13.0.** Uric Acid
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `mg/dL`: *mg/dL*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**17.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsrft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**18.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsrft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**19.0.** summary
- db_table: meta_subject_bloodresultsrft
- column: summary
- type: TextField
---

**Section: Calculated eGFR**

**20.0.** eGFR
- db_table: meta_subject_bloodresultsrft
- column: egfr_value
- type: DecimalField
---

**21.0.** units
- db_table: meta_subject_bloodresultsrft
- column: egfr_units
- type: CharField
- length: 15
- responses:
  - `mL/min/1.73m2`: *mL/min/1.73m2*
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Lft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultslft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultslft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_lft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultslft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultslft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: AST**

**5.0.** AST
- db_table: meta_subject_bloodresultslft
- column: ast_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultslft
- column: ast_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ast_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ast_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALT**

**9.0.** ALT
- db_table: meta_subject_bloodresultslft
- column: alt_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultslft
- column: alt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALP**

**13.0.** ALP
- db_table: meta_subject_bloodresultslft
- column: alp_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultslft
- column: alp_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alp_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alp_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: AMYLASE**

**17.0.** Serum Amylase
- db_table: meta_subject_bloodresultslft
- column: amylase_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultslft
- column: amylase_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: amylase_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: amylase_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: GGT**

**21.0.** GGT
- db_table: meta_subject_bloodresultslft
- column: ggt_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultslft
- column: ggt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ggt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ggt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALBUMIN**

**25.0.** Serum albumin
- db_table: meta_subject_bloodresultslft
- column: albumin_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultslft
- column: albumin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
  - `g/L`: *g/L*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: albumin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: albumin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**29.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultslft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**30.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultslft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**31.0.** summary
- db_table: meta_subject_bloodresultslft
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Fbc
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsfbc
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsfbc
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: fbc**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsfbc
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsfbc
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Haemoglobin**

**5.0.** Haemoglobin
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: HCT**

**9.0.** Hematocrit
- db_table: meta_subject_bloodresultsfbc
- column: hct_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: hct_units
- type: CharField
- length: 15
- responses:
  - `%`: *%*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: hct_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: hct_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: RBC**

**13.0.** Red blood cell count
- db_table: meta_subject_bloodresultsfbc
- column: rbc_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: rbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm^3*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: rbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: rbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: WBC**

**17.0.** WBC
- db_table: meta_subject_bloodresultsfbc
- column: wbc_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: wbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: wbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: wbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: PLATELETS**

**21.0.** Platelets
- db_table: meta_subject_bloodresultsfbc
- column: platelets_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: platelets_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: platelets_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: platelets_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCV**

**25.0.** MCV
- db_table: meta_subject_bloodresultsfbc
- column: mcv_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mcv_units
- type: CharField
- length: 15
- responses:
  - `fL/cell`: *fL/cell*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mcv_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mcv_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCH**

**29.0.** MCH
- db_table: meta_subject_bloodresultsfbc
- column: mch_value
- type: DecimalField
---

**30.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mch_units
- type: CharField
- length: 15
- responses:
  - `pg/cell`: *pg/cell*
---

**31.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mch_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**32.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mch_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCHC**

**33.0.** MCHC
- db_table: meta_subject_bloodresultsfbc
- column: mchc_value
- type: DecimalField
---

**34.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mchc_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**35.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mchc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**36.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mchc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**37.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsfbc
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**38.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsfbc
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**39.0.** summary
- db_table: meta_subject_bloodresultsfbc
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Lipids
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultslipid
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultslipid
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_lipids**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultslipid
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultslipid
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: LDL**

**5.0.** LDL
- db_table: meta_subject_bloodresultslipid
- column: ldl_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultslipid
- column: ldl_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: ldl_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: ldl_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: HDL**

**9.0.** HDL
- db_table: meta_subject_bloodresultslipid
- column: hdl_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultslipid
- column: hdl_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: hdl_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: hdl_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: TRIG**

**13.0.** Triglycerides
- db_table: meta_subject_bloodresultslipid
- column: trig_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultslipid
- column: trig_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: trig_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: trig_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: CHOL**

**17.0.** Total Cholesterol
- db_table: meta_subject_bloodresultslipid
- column: chol_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultslipid
- column: chol_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: chol_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: chol_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**21.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultslipid
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**22.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultslipid
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**23.0.** summary
- db_table: meta_subject_bloodresultslipid
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Urine Pregnancy
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinepregnancy
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinepregnancy
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine pregnancy test performed?
- db_table: meta_subject_urinepregnancy
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinepregnancy
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Urine βhCG date
- db_table: meta_subject_urinepregnancy
- column: assay_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Urine βhCG result
- db_table: meta_subject_urinepregnancy
- column: bhcg_value
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---


#### Requisitions

* blood_glucose

* chemistry_rft

* chemistry_lft

* chemistry_lipids

* fbc

### 1270



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Glucose
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsglu
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsglu
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: blood_glucose**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsglu
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsglu
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**5.0.** Was this fasting or non-fasting?
- db_table: meta_subject_bloodresultsglu
- column: fasting
- type: CharField
- length: 25
- responses:
  - `fasting`: *Fasting*
  - `non_fasting`: *Non-fasting*
---

**Section: Glucose**

**6.0.** Blood Glucose
- db_table: meta_subject_bloodresultsglu
- column: glucose_value
- type: DecimalField
---

**7.0.** units
- db_table: meta_subject_bloodresultsglu
- column: glucose_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**8.0.** abnormal
- db_table: meta_subject_bloodresultsglu
- column: glucose_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** reportable
- db_table: meta_subject_bloodresultsglu
- column: glucose_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**10.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsglu
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsglu
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**12.0.** summary
- db_table: meta_subject_bloodresultsglu
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Urine Pregnancy
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinepregnancy
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinepregnancy
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine pregnancy test performed?
- db_table: meta_subject_urinepregnancy
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinepregnancy
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Urine βhCG date
- db_table: meta_subject_urinepregnancy
- column: assay_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Urine βhCG result
- db_table: meta_subject_urinepregnancy
- column: bhcg_value
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---


#### Requisitions

* blood_glucose

### 1300



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Glucose
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsglu
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsglu
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: blood_glucose**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsglu
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsglu
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**5.0.** Was this fasting or non-fasting?
- db_table: meta_subject_bloodresultsglu
- column: fasting
- type: CharField
- length: 25
- responses:
  - `fasting`: *Fasting*
  - `non_fasting`: *Non-fasting*
---

**Section: Glucose**

**6.0.** Blood Glucose
- db_table: meta_subject_bloodresultsglu
- column: glucose_value
- type: DecimalField
---

**7.0.** units
- db_table: meta_subject_bloodresultsglu
- column: glucose_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**8.0.** abnormal
- db_table: meta_subject_bloodresultsglu
- column: glucose_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** reportable
- db_table: meta_subject_bloodresultsglu
- column: glucose_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**10.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsglu
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsglu
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**12.0.** summary
- db_table: meta_subject_bloodresultsglu
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Rft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsrft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsrft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_rft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsrft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsrft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: UREA**

**5.0.** Urea (BUN)
- db_table: meta_subject_bloodresultsrft
- column: urea_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsrft
- column: urea_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: urea_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: urea_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: CREATININE**

**9.0.** Creatinine
- db_table: meta_subject_bloodresultsrft
- column: creatinine_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsrft
- column: creatinine_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `umol/L`: *μmol/L (micromoles/L)*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: creatinine_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: creatinine_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: URIC_ACID**

**13.0.** Uric Acid
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `mg/dL`: *mg/dL*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**17.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsrft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**18.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsrft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**19.0.** summary
- db_table: meta_subject_bloodresultsrft
- column: summary
- type: TextField
---

**Section: Calculated eGFR**

**20.0.** eGFR
- db_table: meta_subject_bloodresultsrft
- column: egfr_value
- type: DecimalField
---

**21.0.** units
- db_table: meta_subject_bloodresultsrft
- column: egfr_units
- type: CharField
- length: 15
- responses:
  - `mL/min/1.73m2`: *mL/min/1.73m2*
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Lft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultslft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultslft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_lft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultslft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultslft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: AST**

**5.0.** AST
- db_table: meta_subject_bloodresultslft
- column: ast_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultslft
- column: ast_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ast_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ast_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALT**

**9.0.** ALT
- db_table: meta_subject_bloodresultslft
- column: alt_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultslft
- column: alt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALP**

**13.0.** ALP
- db_table: meta_subject_bloodresultslft
- column: alp_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultslft
- column: alp_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alp_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alp_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: AMYLASE**

**17.0.** Serum Amylase
- db_table: meta_subject_bloodresultslft
- column: amylase_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultslft
- column: amylase_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: amylase_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: amylase_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: GGT**

**21.0.** GGT
- db_table: meta_subject_bloodresultslft
- column: ggt_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultslft
- column: ggt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ggt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ggt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALBUMIN**

**25.0.** Serum albumin
- db_table: meta_subject_bloodresultslft
- column: albumin_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultslft
- column: albumin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
  - `g/L`: *g/L*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: albumin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: albumin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**29.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultslft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**30.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultslft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**31.0.** summary
- db_table: meta_subject_bloodresultslft
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Fbc
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsfbc
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsfbc
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: fbc**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsfbc
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsfbc
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Haemoglobin**

**5.0.** Haemoglobin
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: HCT**

**9.0.** Hematocrit
- db_table: meta_subject_bloodresultsfbc
- column: hct_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: hct_units
- type: CharField
- length: 15
- responses:
  - `%`: *%*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: hct_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: hct_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: RBC**

**13.0.** Red blood cell count
- db_table: meta_subject_bloodresultsfbc
- column: rbc_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: rbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm^3*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: rbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: rbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: WBC**

**17.0.** WBC
- db_table: meta_subject_bloodresultsfbc
- column: wbc_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: wbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: wbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: wbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: PLATELETS**

**21.0.** Platelets
- db_table: meta_subject_bloodresultsfbc
- column: platelets_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: platelets_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: platelets_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: platelets_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCV**

**25.0.** MCV
- db_table: meta_subject_bloodresultsfbc
- column: mcv_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mcv_units
- type: CharField
- length: 15
- responses:
  - `fL/cell`: *fL/cell*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mcv_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mcv_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCH**

**29.0.** MCH
- db_table: meta_subject_bloodresultsfbc
- column: mch_value
- type: DecimalField
---

**30.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mch_units
- type: CharField
- length: 15
- responses:
  - `pg/cell`: *pg/cell*
---

**31.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mch_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**32.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mch_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCHC**

**33.0.** MCHC
- db_table: meta_subject_bloodresultsfbc
- column: mchc_value
- type: DecimalField
---

**34.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mchc_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**35.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mchc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**36.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mchc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**37.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsfbc
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**38.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsfbc
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**39.0.** summary
- db_table: meta_subject_bloodresultsfbc
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Urine Pregnancy
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinepregnancy
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinepregnancy
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine pregnancy test performed?
- db_table: meta_subject_urinepregnancy
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinepregnancy
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Urine βhCG date
- db_table: meta_subject_urinepregnancy
- column: assay_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Urine βhCG result
- db_table: meta_subject_urinepregnancy
- column: bhcg_value
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---


#### Requisitions

* blood_glucose

* chemistry_rft

* chemistry_lft

* fbc

### 1330



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Glucose
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsglu
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsglu
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: blood_glucose**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsglu
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsglu
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**5.0.** Was this fasting or non-fasting?
- db_table: meta_subject_bloodresultsglu
- column: fasting
- type: CharField
- length: 25
- responses:
  - `fasting`: *Fasting*
  - `non_fasting`: *Non-fasting*
---

**Section: Glucose**

**6.0.** Blood Glucose
- db_table: meta_subject_bloodresultsglu
- column: glucose_value
- type: DecimalField
---

**7.0.** units
- db_table: meta_subject_bloodresultsglu
- column: glucose_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**8.0.** abnormal
- db_table: meta_subject_bloodresultsglu
- column: glucose_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** reportable
- db_table: meta_subject_bloodresultsglu
- column: glucose_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**10.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsglu
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsglu
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**12.0.** summary
- db_table: meta_subject_bloodresultsglu
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Urine Pregnancy
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinepregnancy
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinepregnancy
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine pregnancy test performed?
- db_table: meta_subject_urinepregnancy
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinepregnancy
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Urine βhCG date
- db_table: meta_subject_urinepregnancy
- column: assay_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Urine βhCG result
- db_table: meta_subject_urinepregnancy
- column: bhcg_value
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---


#### Requisitions

* blood_glucose

### 1360



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Glucose (Ifg, Ogtt)
A user model to capture IFG and OGTT
*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_glucose
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_glucose
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**3.0.** Has the participant fasted?

&nbsp;&nbsp;&nbsp;&nbsp; *As reported by patient*
- db_table: meta_subject_glucose
- column: fasting
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** How long have they fasted in hours and/or minutes?

&nbsp;&nbsp;&nbsp;&nbsp; *As reported by patient. Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc*
- db_table: meta_subject_glucose
- column: fasting_duration_str
- type: CharField
- length: 8
- responses: *free text*
---

**Section: FBG**

**5.0.** Was the IFG test performed?
- db_table: meta_subject_glucose
- column: fbg_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** If NO, provide reason
- db_table: meta_subject_glucose
- column: fbg_not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**7.0.** <u>Time</u> FBG level measured
- db_table: meta_subject_glucose
- column: fbg_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**8.0.** FBG level

&nbsp;&nbsp;&nbsp;&nbsp; *A `HIGH` reading may be entered as 9999.99*
- db_table: meta_subject_glucose
- column: fbg_value
- type: DecimalField
---

**9.0.** FBG units
- db_table: meta_subject_glucose
- column: fbg_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `N/A`: *Not applicable*
---

**Section: OGTT**

**10.0.** Was the OGTT test performed?
- db_table: meta_subject_glucose
- column: ogtt_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If NO, provide reason
- db_table: meta_subject_glucose
- column: ogtt_not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**12.0.** <u>Time</u> oral glucose solution was given

&nbsp;&nbsp;&nbsp;&nbsp; *(glucose solution given)*
- db_table: meta_subject_glucose
- column: ogtt_base_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**13.0.** <u>Time</u> blood glucose measured 2-hours after oral glucose solution given

&nbsp;&nbsp;&nbsp;&nbsp; *(2 hours after glucose solution given)*
- db_table: meta_subject_glucose
- column: ogtt_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**14.0.** Blood glucose <u>level</u> 2-hours after oral glucose solution given

&nbsp;&nbsp;&nbsp;&nbsp; *A `HIGH` reading may be entered as 9999.99*
- db_table: meta_subject_glucose
- column: ogtt_value
- type: DecimalField
---

**15.0.** Units (Blood glucose 2hrs after...)
- db_table: meta_subject_glucose
- column: ogtt_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `N/A`: *Not applicable*
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Hba1C
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultshba1c
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultshba1c
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: hba1c**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultshba1c
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultshba1c
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: HbA1c**

**5.0.** HbA1c value
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_units
- type: CharField
- length: 15
- responses: *free text*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**9.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultshba1c
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultshba1c
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**11.0.** summary
- db_table: meta_subject_bloodresultshba1c
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Rft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsrft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsrft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_rft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsrft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsrft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: UREA**

**5.0.** Urea (BUN)
- db_table: meta_subject_bloodresultsrft
- column: urea_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsrft
- column: urea_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: urea_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: urea_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: CREATININE**

**9.0.** Creatinine
- db_table: meta_subject_bloodresultsrft
- column: creatinine_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsrft
- column: creatinine_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `umol/L`: *μmol/L (micromoles/L)*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: creatinine_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: creatinine_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: URIC_ACID**

**13.0.** Uric Acid
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `mg/dL`: *mg/dL*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**17.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsrft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**18.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsrft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**19.0.** summary
- db_table: meta_subject_bloodresultsrft
- column: summary
- type: TextField
---

**Section: Calculated eGFR**

**20.0.** eGFR
- db_table: meta_subject_bloodresultsrft
- column: egfr_value
- type: DecimalField
---

**21.0.** units
- db_table: meta_subject_bloodresultsrft
- column: egfr_units
- type: CharField
- length: 15
- responses:
  - `mL/min/1.73m2`: *mL/min/1.73m2*
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Lft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultslft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultslft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_lft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultslft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultslft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: AST**

**5.0.** AST
- db_table: meta_subject_bloodresultslft
- column: ast_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultslft
- column: ast_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ast_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ast_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALT**

**9.0.** ALT
- db_table: meta_subject_bloodresultslft
- column: alt_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultslft
- column: alt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALP**

**13.0.** ALP
- db_table: meta_subject_bloodresultslft
- column: alp_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultslft
- column: alp_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alp_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alp_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: AMYLASE**

**17.0.** Serum Amylase
- db_table: meta_subject_bloodresultslft
- column: amylase_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultslft
- column: amylase_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: amylase_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: amylase_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: GGT**

**21.0.** GGT
- db_table: meta_subject_bloodresultslft
- column: ggt_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultslft
- column: ggt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ggt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ggt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALBUMIN**

**25.0.** Serum albumin
- db_table: meta_subject_bloodresultslft
- column: albumin_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultslft
- column: albumin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
  - `g/L`: *g/L*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: albumin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: albumin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**29.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultslft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**30.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultslft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**31.0.** summary
- db_table: meta_subject_bloodresultslft
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Fbc
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsfbc
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsfbc
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: fbc**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsfbc
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsfbc
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Haemoglobin**

**5.0.** Haemoglobin
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: HCT**

**9.0.** Hematocrit
- db_table: meta_subject_bloodresultsfbc
- column: hct_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: hct_units
- type: CharField
- length: 15
- responses:
  - `%`: *%*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: hct_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: hct_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: RBC**

**13.0.** Red blood cell count
- db_table: meta_subject_bloodresultsfbc
- column: rbc_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: rbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm^3*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: rbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: rbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: WBC**

**17.0.** WBC
- db_table: meta_subject_bloodresultsfbc
- column: wbc_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: wbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: wbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: wbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: PLATELETS**

**21.0.** Platelets
- db_table: meta_subject_bloodresultsfbc
- column: platelets_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: platelets_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: platelets_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: platelets_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCV**

**25.0.** MCV
- db_table: meta_subject_bloodresultsfbc
- column: mcv_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mcv_units
- type: CharField
- length: 15
- responses:
  - `fL/cell`: *fL/cell*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mcv_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mcv_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCH**

**29.0.** MCH
- db_table: meta_subject_bloodresultsfbc
- column: mch_value
- type: DecimalField
---

**30.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mch_units
- type: CharField
- length: 15
- responses:
  - `pg/cell`: *pg/cell*
---

**31.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mch_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**32.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mch_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCHC**

**33.0.** MCHC
- db_table: meta_subject_bloodresultsfbc
- column: mchc_value
- type: DecimalField
---

**34.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mchc_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**35.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mchc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**36.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mchc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**37.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsfbc
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**38.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsfbc
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**39.0.** summary
- db_table: meta_subject_bloodresultsfbc
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Lipids
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultslipid
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultslipid
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_lipids**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultslipid
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultslipid
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: LDL**

**5.0.** LDL
- db_table: meta_subject_bloodresultslipid
- column: ldl_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultslipid
- column: ldl_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: ldl_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: ldl_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: HDL**

**9.0.** HDL
- db_table: meta_subject_bloodresultslipid
- column: hdl_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultslipid
- column: hdl_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: hdl_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: hdl_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: TRIG**

**13.0.** Triglycerides
- db_table: meta_subject_bloodresultslipid
- column: trig_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultslipid
- column: trig_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: trig_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: trig_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: CHOL**

**17.0.** Total Cholesterol
- db_table: meta_subject_bloodresultslipid
- column: chol_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultslipid
- column: chol_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: chol_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: chol_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**21.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultslipid
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**22.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultslipid
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**23.0.** summary
- db_table: meta_subject_bloodresultslipid
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Urine Pregnancy
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinepregnancy
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinepregnancy
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine pregnancy test performed?
- db_table: meta_subject_urinepregnancy
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinepregnancy
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Urine βhCG date
- db_table: meta_subject_urinepregnancy
- column: assay_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Urine βhCG result
- db_table: meta_subject_urinepregnancy
- column: bhcg_value
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---


#### Requisitions

* blood_glucose

* chemistry_rft

* chemistry_lft

* chemistry_lipids

* fbc

### 3000



*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Vitals
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupvitals
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupvitals
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vitals**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: meta_subject_followupvitals
- column: weight
- type: DecimalField
---

**4.0.** Blood pressure: systolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_one
- type: IntegerField
---

**5.0.** Blood pressure: diastolic (first reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_one
- type: IntegerField
---

**6.0.** Blood pressure: systolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: meta_subject_followupvitals
- column: sys_blood_pressure_two
- type: IntegerField
---

**7.0.** Blood pressure: diastolic (second reading)

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: meta_subject_followupvitals
- column: dia_blood_pressure_two
- type: IntegerField
---

**8.0.** Does the patient have severe hypertension?

&nbsp;&nbsp;&nbsp;&nbsp; *Based on the above readings. Severe HTN is any BP reading > 180/110mmHg*
- db_table: meta_subject_followupvitals
- column: severe_htn
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: meta_subject_followupvitals
- column: heart_rate
- type: IntegerField
---

**10.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: meta_subject_followupvitals
- column: respiratory_rate
- type: IntegerField
---

**11.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celcius*
- db_table: meta_subject_followupvitals
- column: temperature
- type: DecimalField
---




*Rendered on 2022-06-24 14:17*

#### Clinic Follow Up: Examination
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: ['If participant is pregnant, complete the action linked CRF `Pregnancy notification`.']


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_followupexamination
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_followupexamination
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Part 1: Symptoms**

**3.0.** Since the participant's last appointment have they experienced any of the following symptoms

&nbsp;&nbsp;&nbsp;&nbsp; *either at this hospital or at a different clinic*
- db_table: meta_subject_followupexamination
- column: symptoms
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**4.0.** Please provide details on any of the symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_detail
- type: TextField
---

**5.0.** For these symptoms, were any grade 3 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**6.0.** Please provide details on any of the Grade 3 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g3_detail
- type: TextField
---

**7.0.** For these symptoms, were any grade 4 events

&nbsp;&nbsp;&nbsp;&nbsp; *Refer to DAIDS toxicity table. Please complete Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: symptoms_g4
- type: ManyToManyField
- responses: *Select all that apply*
  - `none`: *--No symptoms to report*
  - `abdominal_pain_general`: *Abdominal pain (General)*
  - `abdominal_pain_right_upper_quad`: *Abdominal pain (Right upper quadrant)*
  - `blurred_vision`: *Blurred vision*
  - `diarrhoea`: *Diarrhoea*
  - `dizziness`: *Dizziness*
  - `fatigue`: *Fatigue*
  - `flatulence`: *Flatulence (gas)*
  - `headaches`: *Headaches*
  - `increased_appetite`: *Increased appetite*
  - `joint_pain`: *Joint pain*
  - `loss_of_appetite`: *Loss of appetite*
  - `muscle_cramping`: *Muscle cramping*
  - `muscle_pain`: *Muscle pain*
  - `nausea`: *Nausea*
  - `pain_feet_or_lower_limbs`: *Pain in feet/lower limbs*
  - `pounding_heartbeat`: *Fast or pounding heartbeat*
  - `rash`: *Rash*
  - `shakiness`: *Shakiness*
  - `shallow_breathing`: *Fast or shallow breathing*
  - `skin_itching`: *Skin itching*
  - `sweating`: *Sweating*
  - `swelling_feet_or_lower_limbs`: *Swelling of feet/lower limbs*
  - `unusual_sleepiness`: *Unusual sleepiness*
  - `vomiting`: *Vomiting*
  - `weakness`: *Weakness*
  - `OTHER`: *Other, specify*
---

**8.0.** Please provide details on any of the Grade 4 symptoms above.
- db_table: meta_subject_followupexamination
- column: symptoms_g4_detail
- type: TextField
---

**Section: Part 2: Other Medical or Health problems**

**8.1.** Since your last visit has the participant experienced any other medical or health problems NOT listed above
- db_table: meta_subject_followupexamination
- column: any_other_problems
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.2.** If YES, please provide details of the event
- db_table: meta_subject_followupexamination
- column: any_other_problems_detail
- type: TextField
---

**8.299999999999999.** Does this event constitute an Adverse Event?
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.399999999999999.** If YES, what grade?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, grade 3 or 4, submit Serious Adverse Event form*
- db_table: meta_subject_followupexamination
- column: any_other_problems_sae_grade
- type: CharField
- length: 25
- responses:
  - `3`: *Grade 3*
  - `4`: *Grade 4*
  - `N/A`: *Not applicable*
---

**Section: Part 3: Hospitalizations or other external access to care**

**9.0.** Since the participant's last visit did they attend any other clinic or hospital for care for any reason

&nbsp;&nbsp;&nbsp;&nbsp; *Includes other routine appointments, e.g. BP check or family planning*
- db_table: meta_subject_followupexamination
- column: attended_clinic
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If YES, were they admitted to hospital?
- db_table: meta_subject_followupexamination
- column: admitted_hospital
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If YES, attend other clinic or hospital, please provide details of this event

&nbsp;&nbsp;&nbsp;&nbsp; *If the participant was given a referral letter or discharge summary record details here*
- db_table: meta_subject_followupexamination
- column: attended_clinic_detail
- type: TextField
---

**12.0.** Does the event constitute a <u>Serious Adverse Event</u>

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, submit a <u>Serious Adverse Event</u> Form*
- db_table: meta_subject_followupexamination
- column: attended_clinic_sae
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Was the participant prescribed any other medication at this clinic or hospital visit?
- db_table: meta_subject_followupexamination
- column: prescribed_medication
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**14.0.** If YES, prescribed any other medication, please provide details of this visit
- db_table: meta_subject_followupexamination
- column: prescribed_medication_detail
- type: TextField
---

**Section: Part 4: HIV Medications**

**15.0.** Since the participant's last visit has there been any change in their HIV medication?
- db_table: meta_subject_followupexamination
- column: art_change
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** If YES, please provide reason for change
- db_table: meta_subject_followupexamination
- column: art_change_reason
- type: TextField
---

**17.0.** Please indicate new regimen
- db_table: meta_subject_followupexamination
- column: art_new_regimen
- type: ForeignKey
---

**17.1.** If other, please specify ...
- db_table: meta_subject_followupexamination
- column: art_new_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Part 2: Examination**

**18.0.** Abdominal tenderness
- db_table: meta_subject_followupexamination
- column: abdominal_tenderness
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** Enlarged liver
- db_table: meta_subject_followupexamination
- column: enlarged_liver
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** Jaundice
- db_table: meta_subject_followupexamination
- column: jaundice
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Part 3: Summary**

**21.0.** Comment on the clinical course, any other symptoms present, assessment and management plan
- db_table: meta_subject_followupexamination
- column: comment
- type: TextField
---

**22.0.** Do you think the participant has lactic acidosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.*
- db_table: meta_subject_followupexamination
- column: lactic_acidosis
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** Do you think the participant has hepatomegaly with steatosis?

&nbsp;&nbsp;&nbsp;&nbsp; *Submit SAE form. This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome*
- db_table: meta_subject_followupexamination
- column: hepatomegaly
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** Is the participant being referred
- db_table: meta_subject_followupexamination
- column: referral
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, where are they being referred to

&nbsp;&nbsp;&nbsp;&nbsp; *Note: remind participant that admission or discharge information will be needed at the next follow up visit.*
- db_table: meta_subject_followupexamination
- column: referral_reason
- type: TextField
---

**Section: Action**

**26.0.** action identifier
- db_table: meta_subject_followupexamination
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**27.0.** action item
- db_table: meta_subject_followupexamination
- column: action_item
- type: ForeignKey
---

**28.0.** parent action item
- db_table: meta_subject_followupexamination
- column: parent_action_item
- type: ForeignKey
---

**29.0.** related action item
- db_table: meta_subject_followupexamination
- column: related_action_item
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Glucose (Ifg, Ogtt)
A user model to capture IFG and OGTT
*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_glucose
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_glucose
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fasting**

**3.0.** Has the participant fasted?

&nbsp;&nbsp;&nbsp;&nbsp; *As reported by patient*
- db_table: meta_subject_glucose
- column: fasting
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** How long have they fasted in hours and/or minutes?

&nbsp;&nbsp;&nbsp;&nbsp; *As reported by patient. Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc*
- db_table: meta_subject_glucose
- column: fasting_duration_str
- type: CharField
- length: 8
- responses: *free text*
---

**Section: FBG**

**5.0.** Was the IFG test performed?
- db_table: meta_subject_glucose
- column: fbg_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** If NO, provide reason
- db_table: meta_subject_glucose
- column: fbg_not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**7.0.** <u>Time</u> FBG level measured
- db_table: meta_subject_glucose
- column: fbg_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**8.0.** FBG level

&nbsp;&nbsp;&nbsp;&nbsp; *A `HIGH` reading may be entered as 9999.99*
- db_table: meta_subject_glucose
- column: fbg_value
- type: DecimalField
---

**9.0.** FBG units
- db_table: meta_subject_glucose
- column: fbg_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `N/A`: *Not applicable*
---

**Section: OGTT**

**10.0.** Was the OGTT test performed?
- db_table: meta_subject_glucose
- column: ogtt_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If NO, provide reason
- db_table: meta_subject_glucose
- column: ogtt_not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**12.0.** <u>Time</u> oral glucose solution was given

&nbsp;&nbsp;&nbsp;&nbsp; *(glucose solution given)*
- db_table: meta_subject_glucose
- column: ogtt_base_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**13.0.** <u>Time</u> blood glucose measured 2-hours after oral glucose solution given

&nbsp;&nbsp;&nbsp;&nbsp; *(2 hours after glucose solution given)*
- db_table: meta_subject_glucose
- column: ogtt_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**14.0.** Blood glucose <u>level</u> 2-hours after oral glucose solution given

&nbsp;&nbsp;&nbsp;&nbsp; *A `HIGH` reading may be entered as 9999.99*
- db_table: meta_subject_glucose
- column: ogtt_value
- type: DecimalField
---

**15.0.** Units (Blood glucose 2hrs after...)
- db_table: meta_subject_glucose
- column: ogtt_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `N/A`: *Not applicable*
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Hba1C
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultshba1c
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultshba1c
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: hba1c**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultshba1c
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultshba1c
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: HbA1c**

**5.0.** HbA1c value
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_units
- type: CharField
- length: 15
- responses: *free text*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultshba1c
- column: hba1c_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**9.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultshba1c
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultshba1c
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**11.0.** summary
- db_table: meta_subject_bloodresultshba1c
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Rft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsrft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsrft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_rft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsrft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsrft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: UREA**

**5.0.** Urea (BUN)
- db_table: meta_subject_bloodresultsrft
- column: urea_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsrft
- column: urea_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: urea_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: urea_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: CREATININE**

**9.0.** Creatinine
- db_table: meta_subject_bloodresultsrft
- column: creatinine_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsrft
- column: creatinine_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `umol/L`: *μmol/L (micromoles/L)*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: creatinine_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: creatinine_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: URIC_ACID**

**13.0.** Uric Acid
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `mg/dL`: *mg/dL*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsrft
- column: uric_acid_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**17.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsrft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**18.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsrft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**19.0.** summary
- db_table: meta_subject_bloodresultsrft
- column: summary
- type: TextField
---

**Section: Calculated eGFR**

**20.0.** eGFR
- db_table: meta_subject_bloodresultsrft
- column: egfr_value
- type: DecimalField
---

**21.0.** units
- db_table: meta_subject_bloodresultsrft
- column: egfr_units
- type: CharField
- length: 15
- responses:
  - `mL/min/1.73m2`: *mL/min/1.73m2*
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Lft
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultslft
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultslft
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_lft**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultslft
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultslft
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: AST**

**5.0.** AST
- db_table: meta_subject_bloodresultslft
- column: ast_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultslft
- column: ast_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ast_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ast_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALT**

**9.0.** ALT
- db_table: meta_subject_bloodresultslft
- column: alt_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultslft
- column: alt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALP**

**13.0.** ALP
- db_table: meta_subject_bloodresultslft
- column: alp_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultslft
- column: alp_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: alp_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: alp_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: AMYLASE**

**17.0.** Serum Amylase
- db_table: meta_subject_bloodresultslft
- column: amylase_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultslft
- column: amylase_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: amylase_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: amylase_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: GGT**

**21.0.** GGT
- db_table: meta_subject_bloodresultslft
- column: ggt_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultslft
- column: ggt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *U/L*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: ggt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: ggt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALBUMIN**

**25.0.** Serum albumin
- db_table: meta_subject_bloodresultslft
- column: albumin_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultslft
- column: albumin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
  - `g/L`: *g/L*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultslft
- column: albumin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultslft
- column: albumin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**29.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultslft
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**30.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultslft
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**31.0.** summary
- db_table: meta_subject_bloodresultslft
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Fbc
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultsfbc
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultsfbc
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: fbc**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultsfbc
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultsfbc
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Haemoglobin**

**5.0.** Haemoglobin
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: haemoglobin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: HCT**

**9.0.** Hematocrit
- db_table: meta_subject_bloodresultsfbc
- column: hct_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: hct_units
- type: CharField
- length: 15
- responses:
  - `%`: *%*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: hct_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: hct_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: RBC**

**13.0.** Red blood cell count
- db_table: meta_subject_bloodresultsfbc
- column: rbc_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: rbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm^3*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: rbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: rbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: WBC**

**17.0.** WBC
- db_table: meta_subject_bloodresultsfbc
- column: wbc_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: wbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: wbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: wbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: PLATELETS**

**21.0.** Platelets
- db_table: meta_subject_bloodresultsfbc
- column: platelets_value
- type: DecimalField
---

**22.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: platelets_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**23.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: platelets_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: platelets_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCV**

**25.0.** MCV
- db_table: meta_subject_bloodresultsfbc
- column: mcv_value
- type: DecimalField
---

**26.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mcv_units
- type: CharField
- length: 15
- responses:
  - `fL/cell`: *fL/cell*
---

**27.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mcv_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mcv_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCH**

**29.0.** MCH
- db_table: meta_subject_bloodresultsfbc
- column: mch_value
- type: DecimalField
---

**30.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mch_units
- type: CharField
- length: 15
- responses:
  - `pg/cell`: *pg/cell*
---

**31.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mch_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**32.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mch_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MCHC**

**33.0.** MCHC
- db_table: meta_subject_bloodresultsfbc
- column: mchc_value
- type: DecimalField
---

**34.0.** units
- db_table: meta_subject_bloodresultsfbc
- column: mchc_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**35.0.** abnormal
- db_table: meta_subject_bloodresultsfbc
- column: mchc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**36.0.** reportable
- db_table: meta_subject_bloodresultsfbc
- column: mchc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**37.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultsfbc
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**38.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultsfbc
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**39.0.** summary
- db_table: meta_subject_bloodresultsfbc
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Blood Result: Lipids
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_bloodresultslipid
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_bloodresultslipid
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: chemistry_lipids**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: meta_subject_bloodresultslipid
- column: requisition
- type: ForeignKey
---

**4.0.** Result Report Date and Time
- db_table: meta_subject_bloodresultslipid
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: LDL**

**5.0.** LDL
- db_table: meta_subject_bloodresultslipid
- column: ldl_value
- type: DecimalField
---

**6.0.** units
- db_table: meta_subject_bloodresultslipid
- column: ldl_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**7.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: ldl_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: ldl_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: HDL**

**9.0.** HDL
- db_table: meta_subject_bloodresultslipid
- column: hdl_value
- type: DecimalField
---

**10.0.** units
- db_table: meta_subject_bloodresultslipid
- column: hdl_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**11.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: hdl_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: hdl_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: TRIG**

**13.0.** Triglycerides
- db_table: meta_subject_bloodresultslipid
- column: trig_value
- type: DecimalField
---

**14.0.** units
- db_table: meta_subject_bloodresultslipid
- column: trig_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**15.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: trig_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: trig_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: CHOL**

**17.0.** Total Cholesterol
- db_table: meta_subject_bloodresultslipid
- column: chol_value
- type: DecimalField
---

**18.0.** units
- db_table: meta_subject_bloodresultslipid
- column: chol_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L*
---

**19.0.** abnormal
- db_table: meta_subject_bloodresultslipid
- column: chol_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: meta_subject_bloodresultslipid
- column: chol_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**21.0.** Are any of the above results abnormal?
- db_table: meta_subject_bloodresultslipid
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**22.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form.*
- db_table: meta_subject_bloodresultslipid
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**23.0.** summary
- db_table: meta_subject_bloodresultslipid
- column: summary
- type: TextField
---




*Rendered on 2022-06-24 14:17*

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: This refill**

**3.0.** refill date
- db_table: meta_subject_studymedication
- column: refill_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** dosage guideline
- db_table: meta_subject_studymedication
- column: dosage_guideline
- type: ForeignKey
---

**5.0.** formulation
- db_table: meta_subject_studymedication
- column: formulation
- type: ForeignKey
---

**6.0.** Refill to the next scheduled visit
- db_table: meta_subject_studymedication
- column: refill_to_next_visit
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** special instructions
- db_table: meta_subject_studymedication
- column: special_instructions
- type: TextField
---

**Section: Next refill**

**8.0.** Order refill for next scheduled visit?
- db_table: meta_subject_studymedication
- column: order_next
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** next dosage guideline
- db_table: meta_subject_studymedication
- column: next_dosage_guideline
- type: ForeignKey
---

**10.0.** next formulation
- db_table: meta_subject_studymedication
- column: next_formulation
- type: ForeignKey
---




*Rendered on 2022-06-24 14:17*

#### Medication Adherence
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_medicationadherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_medicationadherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Visual Score**

**3.0.** Visual score

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_slider
- type: CharField
- length: 3
- responses: *free text*
---

**4.0.** <B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.

&nbsp;&nbsp;&nbsp;&nbsp; *%*
- db_table: meta_subject_medicationadherence
- column: visual_score_confirmed
- type: IntegerField
---

**Section: Pill Count**

**5.0.** Was a pill count performed
- db_table: meta_subject_medicationadherence
- column: pill_count_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Number of pills left in the bottle
- db_table: meta_subject_medicationadherence
- column: pill_count
- type: IntegerField
---

**Section: Missed Medications**

**7.0.** When was the last time you missed your study pill?
- db_table: meta_subject_medicationadherence
- column: last_missed_pill
- type: CharField
- length: 25
- responses:
  - `today`: *today*
  - `yesterday`: *yesterday*
  - `earlier_this_week`: *earlier this week*
  - `last_week`: *last week*
  - `lt_month_ago`: *less than a month ago*
  - `gt_month_ago`: *more than a month ago*
  - `NEVER`: *have never missed taking my study pills*
---

**8.0.** Reasons for missing study pills
- db_table: meta_subject_medicationadherence
- column: missed_pill_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `forget_to_take`: *I sometimes forget to take my pills*
  - `dont_like_taking`: *I don't like taking my pills*
  - `make_me_ill`: *My pills sometimes make me feel sick*
  - `misplaced_pills`: *I sometimes misplace my pills*
  - `dont_believe_pills_help`: *I don't believe my pills are helping me*
  - `dont_believe_pills_needed`: *I don't believe I need to take my pills*
  - `not_feeling_well`: *I have not been feeling well*
  - `OTHER`: *Other, please specify ...*
---

**9.0.** If other, please specify ...
- db_table: meta_subject_medicationadherence
- column: other_missed_pill_reason
- type: CharField
- length: 150
- responses: *free text*
---




*Rendered on 2022-06-24 14:17*

#### Urine Pregnancy
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_urinepregnancy
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: meta_subject_urinepregnancy
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**3.0.** Was the urine pregnancy test performed?
- db_table: meta_subject_urinepregnancy
- column: performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, provide reason
- db_table: meta_subject_urinepregnancy
- column: not_performed_reason
- type: CharField
- length: 150
- responses: *free text*
---

**5.0.** Urine βhCG date
- db_table: meta_subject_urinepregnancy
- column: assay_date
- type: DateField
- format: YYYY-MM-DD
---

**6.0.** Urine βhCG result
- db_table: meta_subject_urinepregnancy
- column: bhcg_value
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---


#### Requisitions

### 2000



*Rendered on 2022-06-24 14:17*

#### Delivery
form 25
*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: meta_subject_delivery
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date and Time
- db_table: meta_subject_delivery
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Source of information**

**3.0.** Were you able to obtain a report on the delivery?

&nbsp;&nbsp;&nbsp;&nbsp; *If NO, please explain below*
- db_table: meta_subject_delivery
- column: info_available
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If the report was not available, please explain?
- db_table: meta_subject_delivery
- column: info_not_available_reason
- type: TextField
---

**5.0.** Who / what is the MAIN source of this information?
- db_table: meta_subject_delivery
- column: info_source
- type: CharField
- length: 25
- responses:
  - `patient`: *Study participant*
  - `OTHER`: *Other*
  - `N/A`: *Not applicable*
---

**5.1.** If not reported from study participant, please give the name and contact details of the informant.

&nbsp;&nbsp;&nbsp;&nbsp; * (Encryption: AES local)*
- db_table: meta_subject_delivery
- column: info_source_other
- type: CharField
- length: 71
- responses: *free text*
---

**6.0.** Informants relationship to the participant?
- db_table: meta_subject_delivery
- column: informant_relation
- type: CharField
- length: 25
- responses:
  - `husband_wife`: *Husband/wife*
  - `Parent`: *Parent*
  - `child`: *Child*
  - `unknown`: *Unknown*
  - `OTHER`: *Other*
  - `hospital_clinic`: *Hospital / Clinic records*
  - `N/A`: *Not applicable*
---

**6.1.** If other, please specify ...
- db_table: meta_subject_delivery
- column: informant_relation_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Delivery**

**7.0.** Date and time of delivery :

&nbsp;&nbsp;&nbsp;&nbsp; *If TIME unknown, estimate*
- db_table: meta_subject_delivery
- column: delivery_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**8.0.** Is the delivery TIME estimated?
- db_table: meta_subject_delivery
- column: delivery_time_estimated
- type: CharField
- length: 3
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**9.0.** Where did the delivery occur?
- db_table: meta_subject_delivery
- column: delivery_location
- type: CharField
- length: 25
- responses:
  - `home`: *At home*
  - `hospital_clinic`: *Hospital / Clinic*
  - `OTHER`: *Other location, specify*
  - `N/A`: *Not applicable*
---

**9.1.** If other, please specify ...
- db_table: meta_subject_delivery
- column: delivery_location_other
- type: CharField
- length: 35
- responses: *free text*
---

**10.0.** If delivery occurred at a `hospital` or `clinic`, please give name of the facility
- db_table: meta_subject_delivery
- column: delivery_location_name
- type: CharField
- length: 150
- responses: *free text*
---

**11.0.** Gestational age at delivery
- db_table: meta_subject_delivery
- column: delivery_ga
- type: IntegerField
---

**12.0.** Was the participant treated for gestational diabetes?
- db_table: meta_subject_delivery
- column: gm_treated
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** What was the maternal outcome of the pregnancy?
- db_table: meta_subject_delivery
- column: maternal_outcome
- type: CharField
- length: 50
- responses:
  - `no_complications`: *No complications*
  - `complications_full_recovery`: *Complications with full recovery*
  - `complications_ongoing_recovery`: *Complications with ongoing recovery*
  - `dead`: *Maternal mortality*
  - `N/A`: *Not applicable*
---

**Section: Outcomes**

**14.0.** Number of births / fetal / neonatal outcomes

&nbsp;&nbsp;&nbsp;&nbsp; *Each to be reported individually below*
- db_table: meta_subject_delivery
- column: fetal_outcome_count
- type: IntegerField
---

**Section: Action**

**15.0.** action identifier
- db_table: meta_subject_delivery
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**16.0.** action item
- db_table: meta_subject_delivery
- column: action_item
- type: ForeignKey
---

**17.0.** parent action item
- db_table: meta_subject_delivery
- column: parent_action_item
- type: ForeignKey
---

**18.0.** related action item
- db_table: meta_subject_delivery
- column: related_action_item
- type: ForeignKey
---


#### Requisitions



*Rendered on 2022-06-24 14:17*


