# Generated by Django 3.2.13 on 2022-09-07 12:05

from django.db import migrations
from edc_appointment.utils import get_next_appointment


def update_refill_end_datetimes(apps, schema_editor):
    appointment_model_cls = apps.get_model("edc_appointment.appointment")
    subject_visit_model_cls = apps.get_model("meta_subject.subjectvisit")
    model_cls = apps.get_model("meta_subject.studymedication")
    for obj in model_cls._default_manager.filter(refill_end_datetime__isnull=True).order_by(
        "refill_start_datetime"
    ):
        subject_visit = subject_visit_model_cls._default_manager.get(id=obj.subject_visit_id)
        appointment = appointment_model_cls._default_manager.get(
            id=subject_visit.appointment_id
        )
        try:
            obj.refill_end_datetime = get_next_appointment(
                appointment, include_interim=True
            ).appt_datetime
        except AttributeError:
            print(f"Unable to update. No next appt. Got {obj}.")
        else:
            obj.save_base(update_fields=["refill_end_datetime"])


class Migration(migrations.Migration):

    dependencies = [
        ("meta_subject", "0146_auto_20220907_0207"),
    ]

    operations = [migrations.RunPython(update_refill_end_datetimes)]
