"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgeDestination = void 0;
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
/**
 * Use an Event Bridge event bus as a Lambda destination.
 *
 * If no event bus is specified, the default event bus is used.
 *
 * @stability stable
 */
class EventBridgeDestination {
    /**
     * @default - use the default event bus
     * @stability stable
     */
    constructor(eventBus) {
        this.eventBus = eventBus;
    }
    /**
     * Returns a destination configuration.
     *
     * @stability stable
     */
    bind(_scope, fn, _options) {
        // deduplicated automatically
        events.EventBus.grantPutEvents(fn); // Cannot restrict to a specific resource
        return {
            destination: this.eventBus && this.eventBus.eventBusArn || core_1.Stack.of(fn).formatArn({
                service: 'events',
                resource: 'event-bus',
                resourceName: 'default',
            }),
        };
    }
}
exports.EventBridgeDestination = EventBridgeDestination;
//# sourceMappingURL=data:application/json;base64,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