# Copyright (c) 2020 The Regents of the University of Michigan
# All rights reserved.
# This software is licensed under the BSD 3-Clause License.
POS_HPMC = """boxMatrix 10 0 0 0 10 0 0 0 10
def A "poly3d 4 1.0 0.0 -0.707106 -1.0 0.0 -0.707106 0.0 1.0 0.707106 0.0 -1.0 0.707106"
A 1.82294440269 15.4535045624 14.8948659897 1 0 0 0
A -7.82164478302 10.8672037125 -2.95065999031 1 0 0 0
A -6.71628189087 -14.6842060089 -8.78729343414 1 0 0 0
eof
boxMatrix 10 0 0 0 10 0 0 0 10
def A "poly3d 4 1.0 0.0 -0.707106 -1.0 0.0 -0.707106 0.0 1.0 0.707106 0.0 -1.0 0.707106"
A 1.82294440269 15.4535045624 14.8948659897 1 0 0 0
A -7.82164478302 10.8672037125 -2.95065999031 1 0 0 0
A -6.764575947059 -14.8567379768 -8.685973902168 0.9805919875544 0.1852591352614 0.06382813748332 0.006661502213598
eof
boxMatrix 10 0 0 0 10 0 0 0 10
def A "poly3d 4 1.0 0.0 -0.707106 -1.0 0.0 -0.707106 0.0 1.0 0.707106 0.0 -1.0 0.707106"
A 1.82294440269 15.4535045624 14.8948659897 1 0 0 0
A -7.82164478302 10.8672037125 -2.95065999031 1 0 0 0
A -6.764575947059 -14.8567379768 -8.685973902168 0.9805919875544 0.1852591352614 0.06382813748332 0.006661502213598
eof"""  # noqa: E501

POS_HPMC_2D = """boxMatrix 10 0 0 0 10 0 0 0 1
def A "poly3d 4 0.5 0.5 0 -0.5 0.5 0 0.5 0.5 0 0.5 -0.5 0 008800"
A 1.82294440269 3.4535045624 0 1 0 0 0
A -2.82164478302 1.8672037125 0  1 0 0 0
A -3.71628189087 -2.6842060089 0 1 0 0 0
eof
boxMatrix 10 0 0 0 10 0 0 0 1
def A "poly3d 4 0.5 0.5 0 -0.5 0.5 0 0.5 0.5 0 0.5 -0.5 0 008800"
A 1.82294440269 3.4535045624 0 1 0 0 0
A -2.82164478302 1.8672037125 0  1 0 0 0
A -3.71628189087 -2.6842060089 0 1 0 0 0
eof
boxMatrix 10 0 0 0 10 0 0 0 1
def A "poly3d 4 0.5 0.5 0 -0.5 0.5 0 0.5 0.5 0 0.5 -0.5 0 008800"
A 1.82294440269 3.4535045624 0 1 0 0 0
A -2.82164478302 1.8672037125 0  1 0 0 0
A -3.71628189087 -2.6842060089 0 1 0 0 0
eof
"""  # noqa: E501

POS_INCSIM = """#[data] Steps X-Length Y-Length Z-Length
000000  10.000  10.000  10.000
000001  10.000  10.000  10.000
000002  10.000  10.000  10.000
#[done]
boxMatrix 10.0 0 0 0 10.0 0 0 0 10.0
def A "poly3d 4 1.0 0.0 -0.707106 -1.0 0.0 -0.707106 0.0 1.0 0.707106 0.0 -1.0 0.707106"
A 0 1.82294440269 15.4535045624 14.8948659897 1 0 0 0
A 0 -7.82164478302 10.8672037125 -2.95065999031 1 0 0 0
A 0 -6.71628189087 -14.6842060089 -8.78729343414 1 0 0 0
eof
#[data] Steps X-Length Y-Length Z-Length
000003  10.000  10.000  10.000
000004  10.000  10.000  10.000
000005  10.000  10.000  10.000
#[done]"""  # noqa: E501

POS_INCSIM_2D = """#[data] Steps X-Length Y-Length Z-Length
000000  10.000  10.000  1.000
000001  10.000  10.000  1.000
000002  10.000  10.000  1.000
#[done]
boxMatrix 10.0 0 0 0 10.0 0 0 0 1.0
def A "poly3d 4 0.5 0.5 0 -0.5 0.5 0 0.5 0.5 0 0.5 -0.5 0 008800"
A 1.82294440269 3.4535045624 0 1 0 0 0
A -2.82164478302 1.8672037125 0  1 0 0 0
A -3.71628189087 -2.6842060089 0 1 0 0 0
eof
#[data] Steps X-Length Y-Length Z-Length
000003  10.000  10.000  1.000
000004  10.000  10.000  1.000
000005  10.000  10.000  1.000
#[done]
"""  # noqa: E501

POS_MONOTYPE = """#[data] Steps           Time            Vol             Packing         Press           MSD             DeltaX          DeltaQ          DeltaV          AcceptX         AcceptQ         AcceptV         Ensemble        Shear           Overlaps        X-Length        Y-Length        Z-Length        XY-Angle        XZ-Angle        YZ-Angle        RNGstate        RNGstatew
5683290 0       13854.542584873 0.553368299     11      2.219808854     0.089573664     0.060274335     0.749136778     0.296100599     0.27948962      0.285714286     2       0       0       24.017662106    24.017662106    24.017662106    90      90      90      3728705625      1305200346
#[done]
boxMatrix 10.0 0 0 0 10.0 0 0 0 10.0
shape "poly3d 12 0.333333 1 0.333333 1 0.333333 0.333333 0.333333 0.333333 1 -1 -0.333333 0.333333 -0.333333 -1 0.333333 -0.333333 -0.333333 1 -0.333333 0.333333 -1 -0.333333 1 -0.333333 -1 0.333333 -0.333333 0.333333 -0.333333 -1 1 -0.333333 -0.333333 0.333333 -1 -0.333333"
ff0000 -11.320217528 -8.749537435 -8.011389974 -0.015480238 -0.664626252 0.724293168 -0.182843416
ff0000 -8.199472831 -9.791602851 10.203158041 0.250075053 -0.547617436 0.316252355 -0.733186238
eof"""  # noqa: E501

POS_MONOTYPE_2D = """#[data] Steps           Time            Vol             Packing         Press           MSD             DeltaX          DeltaQ          DeltaV          AcceptX         AcceptQ         AcceptV         Ensemble        Shear           Overlaps        X-Length        Y-Length        Z-Length        XY-Angle        XZ-Angle        YZ-Angle        RNGstate        RNGstatew
5683290 0       13854.542584873 0.553368299     11      2.219808854     0.089573664     0.060274335     0.749136778     0.296100599     0.27948962      0.285714286     2       0       0       24.017662106    24.017662106    0.0 90      0      0      3728705625      1305200346
#[done]
boxMatrix 25.0 0 0 0 25.0 0 0 0 1.0
shape "poly3d 12 0.333333 1 0 1 0.333333 0 0.333333 0.333333 0 -1 -0.333333 0 -0.333333 -1 0 -0.333333 -0.333333 0 -0.333333 0.333333 0 -0.333333 1 0 -1 0.333333 0 0.333333 -0.333333 0 1 -0.333333 0 0.333333 -1 0"
ff0000 -11.320217528 -8.749537435 0 1 0 0 0
ff0000 -8.199472831 -9.791602851 0 1 0 0 0
eof"""  # noqa: E501

POS_INJAVIS = """//date: Thursday, July 23, 2015 2:50:06 PM
#[data] Steps   Time    Vol     Packing Press   MSD     DeltaX  DeltaQ  DeltaV  AcceptX AcceptQ AcceptV Ensemble        Shear   Overlaps        X-Length        Y-Length        Z-Length        XY-Angle        XZ-Angle        YZ-Angle        RNGstate        RNGstatew
5683290 0       13854.5426      0.553368299     11      2.21980885      0.089573664     0.060274335     0.749136778     0.296100599     0.27948962      0.285714286     2       0       0       24.0176621      24.0176621      24.0176621      90      90      90      3.7287056E9     1.3052003E9
#[done]

rotation        11.884065       -19.36126781    -1.96424213
antiAliasing    true
showEdges       false
box     10.0    10.0      10.0
shape   "poly3d 12 0.333333     1       0.333333        1       0.333333        0.333333        0.333333        0.333333        1       -1      -0.333333       0.333333        -0.333333       -1      0.333333        -0.333333       -0.333333       1       -0.333333       0.333333        -1      -0.333333       1       -0.333333       -1      0.333333        -0.333333       0.333333        -0.333333       -1      1       -0.333333       -0.333333       0.333333        -1      -0.333333 ffff0000"
-11.32021753    -8.74953744     -8.01138997     -0.01548024     -0.66462625     0.724293168     -0.18284342
-8.19947283     -9.79160285     10.203158       0.250075053     -0.54761744     0.316252355     -0.73318624
eof"""  # noqa: E501

HOOMD_BLUE_XML = """<?xml version="1.0" encoding="UTF-8"?>
<hoomd_xml version="1.6">
<configuration time_step="0" dimensions="3" natoms="10" >
<box lx="4.713492870331" ly="4.713492870331" lz="4.713492870331" xy="0" xz="0" yz="0"/>
<position num="10">
-0.391116261482 2.34347701073 1.0384979248
2.03885579109 -2.35620737076 -1.75283277035
-0.931703925133 2.35222411156 -1.66501355171
-1.24394273758 -1.92150914669 -0.487465977669
-1.47881031036 -0.528331875801 -0.7279484272
0.800096750259 -0.486585855484 2.05291008949
0.182962417603 1.63233399391 -0.380876064301
-0.880133986473 0.873030900955 0.11570763588
-1.39306223392 -0.266534328461 1.78225398064
-1.27463591099 -2.22765517235 0.162209749222
</position>
<velocity>
-0.391116261482 2.34347701073 1.0384979248
2.03885579109 -2.35620737076 -1.75283277035
-0.931703925133 2.35222411156 -1.66501355171
-1.24394273758 -1.92150914669 -0.487465977669
-1.47881031036 -0.528331875801 -0.7279484272
0.800096750259 -0.486585855484 2.05291008949
0.182962417603 1.63233399391 -0.380876064301
-0.880133986473 0.873030900955 0.11570763588
-1.39306223392 -0.266534328461 1.78225398064
-1.27463591099 -2.22765517235 0.162209749222
</velocity>
<mass num="10">
1
1
1
1
1
1
1
1
1
1
</mass>
<diameter num="10">
1
1
1
1
1
1
1
1
1
1
</diameter>
<type num="10">
A
A
A
A
A
A
A
A
A
A
</type>
<body num="10">
-1
-1
-1
-1
-1
-1
-1
-1
-1
-1
</body>
<bond num="0">
</bond>
<angle num="0">
</angle>
<dihedral num="0">
</dihedral>
<improper num="0">
</improper>
<charge num="10">
0
0
0
0
0
0
0
0
0
0
</charge>
</configuration>
</hoomd_xml>
"""

HOOMD_BLUE_XML_2D = """<?xml version="1.0" encoding="UTF-8"?>
<hoomd_xml version="1.6">
<configuration time_step="0" dimensions="2" natoms="10" >
<box lx="4.713492870331" ly="4.713492870331" lz="1.0" xy="0" xz="0" yz="0"/>
<position num="10">
-0.391116261482 2.34347701073 0.0
2.03885579109 -2.35620737076 0.0
-0.931703925133 2.35222411156 0.0
-1.24394273758 -1.92150914669 0.0
-1.47881031036 -0.528331875801 0.0
0.800096750259 -0.486585855484 0.0
0.182962417603 1.63233399391 0.0
-0.880133986473 0.873030900955 0.0
-1.39306223392 -0.266534328461 0.0
-1.27463591099 -2.22765517235 0.0
</position>
<velocity>
-0.391116261482 2.34347701073 0.0
2.03885579109 -2.35620737076 0.0
-0.931703925133 2.35222411156 0.0
-1.24394273758 -1.92150914669 0.0
-1.47881031036 -0.528331875801 0.0
0.800096750259 -0.486585855484 0.0
0.182962417603 1.63233399391 0.0
-0.880133986473 0.873030900955 0.0
-1.39306223392 -0.266534328461 0.0
-1.27463591099 -2.22765517235 0.0
</velocity>
<mass num="10">
1
1
1
1
1
1
1
1
1
1
</mass>
<diameter num="10">
1
1
1
1
1
1
1
1
1
1
</diameter>
<type num="10">
A
A
A
A
A
A
A
A
A
A
</type>
<body num="10">
-1
-1
-1
-1
-1
-1
-1
-1
-1
-1
</body>
<bond num="0">
</bond>
<angle num="0">
</angle>
<dihedral num="0">
</dihedral>
<improper num="0">
</improper>
<charge num="10">
0
0
0
0
0
0
0
0
0
0
</charge>
</configuration>
</hoomd_xml>
"""

DCD_BASE64 = b'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'  # noqa: E501

GSD_BASE64 = b'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'  # noqa: E501

CIF = """
data_simulation_frame_0
_cell_length_a                 2
_cell_length_b                 2
_cell_length_c                 1.3333333333333333
_cell_angle_alpha              90
_cell_angle_beta               90
_cell_angle_gamma              120
_symmetry_space_group_name_H-M 'P 63/m m c'
_symmetry_Int_Tables_number 194
loop_
_symmetry_equiv_pos_site_id
_symmetry_equiv_pos_as_xyz
1 'x, x-y, -z+1/2'
2 '-x+y, y, -z+1/2'
3 '-y, -x, -z+1/2'
4 '-x+y, -x, -z+1/2'
5 '-y, x-y, -z+1/2'
6 'x, y, -z+1/2'
7 '-x, -x+y, z+1/2'
8 'x-y, -y, z+1/2'
9 'y, x, z+1/2'
10 'x-y, x, z+1/2'
11 'y, -x+y, z+1/2'
12 '-x, -y, z+1/2'
13 '-x, -x+y, -z'
14 'x-y, -y, -z'
15 'y, x, -z'
16 'x-y, x, -z'
17 'y, -x+y, -z'
18 '-x, -y, -z'
19 'x, x-y, z'
20 '-x+y, y, z'
21 '-y, -x, z'
22 '-x+y, -x, z'
23 '-y, x-y, z'
24 'x, y, z'
loop_
_atom_site_label
_atom_site_type_symbol
_atom_site_occupancy
_atom_site_fract_x
_atom_site_fract_y
_atom_site_fract_z
A1 A 1.00 0.333333333 0.6666666667 0.25
"""
