# --------------------------------------------------------------- Imports ---------------------------------------------------------------- #

# Pip
from jsoncodable import JSONCodable

# ---------------------------------------------------------------------------------------------------------------------------------------- #



# ------------------------------------------------------- class: PriceHistoryEntry ------------------------------------------------------- #

class PriceHistoryEntry(JSONCodable):

    # ------------------------------------------------------------- Init ------------------------------------------------------------- #

    def __init__(
        self,
        d: dict
    ):
        self.event = d['event']
        self.ts = int(d['time'] / 1000)
        self.price_change_rate = d['priceChangeRate']
        self.price = d['price']
        self.last_price = round(self.price / (1 + self.price_change_rate))
        self.price_change = self.price - self.last_price


# ---------------------------------------------------------------------------------------------------------------------------------------- #